<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\Module\XC\ProductTags\Model\DTO\Product;

/**
 * Product
 */
class Info extends \XLite\Model\DTO\Product\Info implements \XLite\Base\IDecorator
{
    /**
     * @param mixed|\XLite\Model\Product $object
     */
    protected function init($object)
    {
        parent::init($object);

        $tags = [];
        foreach ($object->getTags() as $tag) {
            $tags[] = $tag->getId();
        }

        $this->default->tags = $tags;
    }

    /**
     * @param \XLite\Model\Product $object
     * @param array|null           $rawData
     *
     * @return mixed
     */
    public function populateTo($object, $rawData = null)
    {
        parent::populateTo($object, $rawData);

        $repo = \XLite\Core\Database::getRepo('XLite\Module\XC\ProductTags\Model\Tag');
        $object->replaceTagsByTags($repo->getListByIdOrName($this->default->tags));
    }
}
