START TRANSACTION;
/*!40101 SET NAMES utf8, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET UNIQUE_CHECKS=0, FOREIGN_KEY_CHECKS=0 */;
/*!40111 SET SQL_NOTES=0 */;
CREATE TABLE `xlite_session_cells` (
  `cell_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`cell_id`),
  UNIQUE KEY `iname` (`id`,`name`),
  KEY `id` (`id`),
  CONSTRAINT `FK_C8BF5944BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_mailchimp_list_segments` (
  `id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `list_id` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `created_date` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `static` tinyint(1) NOT NULL,
  `useOrdersLastMonth` tinyint(1) NOT NULL,
  `ordersLastMonth` int(11) NOT NULL,
  `useOrderAmount` tinyint(1) NOT NULL,
  `orderAmount` decimal(14,4) NOT NULL,
  `useMemberships` tinyint(1) NOT NULL,
  `useProducts` tinyint(1) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_93CC76423DAE168B` (`list_id`),
  CONSTRAINT `FK_93CC76423DAE168B` FOREIGN KEY (`list_id`) REFERENCES `xlite_mailchimp_lists` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_shipping_methods` (
  `method_id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_class_id` int(10) unsigned DEFAULT NULL,
  `free` tinyint(1) NOT NULL,
  `processor` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `carrier` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `code` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `position` int(11) NOT NULL,
  `added` tinyint(1) NOT NULL,
  `moduleName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `fromMarketplace` tinyint(1) NOT NULL,
  `iconURL` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tableType` char(3) COLLATE utf8_unicode_ci DEFAULT NULL,
  `handlingFee` decimal(14,4) NOT NULL,
  `handlingFeeType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`method_id`),
  KEY `IDX_3BC5646FA94AAAE` (`tax_class_id`),
  KEY `processor` (`processor`),
  KEY `carrier` (`carrier`),
  KEY `enabled` (`enabled`),
  KEY `position` (`position`),
  CONSTRAINT `FK_3BC5646FA94AAAE` FOREIGN KEY (`tax_class_id`) REFERENCES `xlite_tax_classes` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_shipping_methods` VALUES (1,NULL,0,'fedex','','',0,0,0,'CDev_FedEx',0,NULL,NULL,0.0000,'a'),(2,NULL,0,'fedex','fedex','EUROPE_FIRST_INTERNATIONAL_PRIORITY',1,10,0,'',0,NULL,NULL,0.0000,'a'),(3,NULL,0,'fedex','fedex','FEDEX_1_DAY_FREIGHT',1,20,0,'',0,NULL,NULL,0.0000,'a'),(4,NULL,0,'fedex','fedex','FEDEX_2_DAY',1,30,0,'',0,NULL,NULL,0.0000,'a'),(5,NULL,0,'fedex','fedex','FEDEX_2_DAY_AM',1,40,0,'',0,NULL,NULL,0.0000,'a'),(6,NULL,0,'fedex','fedex','FEDEX_2_DAY_FREIGHT',1,50,0,'',0,NULL,NULL,0.0000,'a'),(7,NULL,0,'fedex','fedex','FEDEX_3_DAY_FREIGHT',1,60,0,'',0,NULL,NULL,0.0000,'a'),(8,NULL,0,'fedex','fedex','FEDEX_EXPRESS_SAVER',1,70,0,'',0,NULL,NULL,0.0000,'a'),(9,NULL,0,'fedex','fedex','FEDEX_FIRST_FREIGHT',1,80,0,'',0,NULL,NULL,0.0000,'a'),(10,NULL,0,'fedex','fedex','FEDEX_GROUND',1,90,0,'',0,NULL,NULL,0.0000,'a'),(11,NULL,0,'fedex','fedex','FIRST_OVERNIGHT',1,100,0,'',0,NULL,NULL,0.0000,'a'),(12,NULL,0,'fedex','fedex','GROUND_HOME_DELIVERY',1,110,0,'',0,NULL,NULL,0.0000,'a'),(13,NULL,0,'fedex','fedex','INTERNATIONAL_DISTRIBUTION_FREIGHT',1,120,0,'',0,NULL,NULL,0.0000,'a'),(14,NULL,0,'fedex','fedex','INTERNATIONAL_ECONOMY',1,130,0,'',0,NULL,NULL,0.0000,'a'),(15,NULL,0,'fedex','fedex','INTERNATIONAL_ECONOMY_DISTRIBUTION',1,140,0,'',0,NULL,NULL,0.0000,'a'),(16,NULL,0,'fedex','fedex','INTERNATIONAL_ECONOMY_FREIGHT',1,150,0,'',0,NULL,NULL,0.0000,'a'),(17,NULL,0,'fedex','fedex','INTERNATIONAL_FIRST',1,160,0,'',0,NULL,NULL,0.0000,'a'),(18,NULL,0,'fedex','fedex','INTERNATIONAL_PRIORITY',1,170,0,'',0,NULL,NULL,0.0000,'a'),(19,NULL,0,'fedex','fedex','INTERNATIONAL_PRIORITY_DISTRIBUTION',1,180,0,'',0,NULL,NULL,0.0000,'a'),(20,NULL,0,'fedex','fedex','INTERNATIONAL_PRIORITY_FREIGHT',1,190,0,'',0,NULL,NULL,0.0000,'a'),(21,NULL,0,'fedex','fedex','PRIORITY_OVERNIGHT',1,200,0,'',0,NULL,NULL,0.0000,'a'),(22,NULL,0,'fedex','fedex','SMART_POST',1,210,0,'',0,NULL,NULL,0.0000,'a'),(23,NULL,0,'fedex','fedex','STANDARD_OVERNIGHT',1,220,0,'',0,NULL,NULL,0.0000,'a'),(24,NULL,0,'ups','','',0,0,0,'XC_UPS',0,NULL,NULL,0.0000,'a'),(25,NULL,0,'ups','ups','NDA',1,10,0,'',0,NULL,NULL,0.0000,'a'),(26,NULL,0,'ups','ups','2DA',1,20,0,'',0,NULL,NULL,0.0000,'a'),(27,NULL,0,'ups','ups','GND',1,30,0,'',0,NULL,NULL,0.0000,'a'),(28,NULL,0,'ups','ups','WEXP',1,40,0,'',0,NULL,NULL,0.0000,'a'),(29,NULL,0,'ups','ups','WEXD',1,50,0,'',0,NULL,NULL,0.0000,'a'),(30,NULL,0,'ups','ups','STD',1,60,0,'',0,NULL,NULL,0.0000,'a'),(31,NULL,0,'ups','ups','3DS',1,70,0,'',0,NULL,NULL,0.0000,'a'),(32,NULL,0,'ups','ups','NDAS',1,80,0,'',0,NULL,NULL,0.0000,'a'),(33,NULL,0,'ups','ups','NDAE',1,90,0,'',0,NULL,NULL,0.0000,'a'),(34,NULL,0,'ups','ups','WEXPP',1,100,0,'',0,NULL,NULL,0.0000,'a'),(35,NULL,0,'ups','ups','2DAAM',1,110,0,'',0,NULL,NULL,0.0000,'a'),(36,NULL,0,'ups','ups','SAV',1,120,0,'',0,NULL,NULL,0.0000,'a'),(37,NULL,0,'ups','ups','TSTD',1,130,0,'',0,NULL,NULL,0.0000,'a'),(38,NULL,0,'ups','ups','TDC',1,140,0,'',0,NULL,NULL,0.0000,'a'),(39,NULL,0,'ups','ups','TI',1,150,0,'',0,NULL,NULL,0.0000,'a'),(40,NULL,0,'ups','ups','TEXP',1,160,0,'',0,NULL,NULL,0.0000,'a'),(41,NULL,0,'ups','ups','TEXPS',1,170,0,'',0,NULL,NULL,0.0000,'a'),(42,NULL,0,'ups','ups','WEXPF',1,180,0,'',0,NULL,NULL,0.0000,'a'),(43,NULL,0,'ups','ups','EXP',1,190,0,'',0,NULL,NULL,0.0000,'a'),(44,NULL,0,'ups','ups','EXPP',1,200,0,'',0,NULL,NULL,0.0000,'a'),(45,NULL,0,'ups','ups','EXDSM',1,210,0,'',0,NULL,NULL,0.0000,'a'),(46,NULL,0,'ups','ups','WEXDSM',1,220,0,'',0,NULL,NULL,0.0000,'a'),(47,NULL,0,'ups','ups','WEXPSM',1,230,0,'',0,NULL,NULL,0.0000,'a'),(48,NULL,0,'ups','ups','SAVSM',1,240,0,'',0,NULL,NULL,0.0000,'a'),(49,NULL,0,'ups','ups','EXPEAMSM',1,250,0,'',0,NULL,NULL,0.0000,'a'),(50,NULL,0,'ups','ups','NDAEAMSM',1,260,0,'',0,NULL,NULL,0.0000,'a'),(51,NULL,0,'ups','ups','WEXPPSM',1,270,0,'',0,NULL,NULL,0.0000,'a'),(52,NULL,0,'aupost','','',0,0,0,'CDev_AustraliaPost',0,NULL,NULL,0.0000,'a'),(53,NULL,0,'usps','','',0,0,0,'CDev_USPS',0,NULL,NULL,0.0000,'a'),(54,NULL,0,'usps','pb_usps','FCM',1,10,0,'',0,NULL,NULL,0.0000,'a'),(55,NULL,0,'usps','pb_usps','PM',1,20,0,'',0,NULL,NULL,0.0000,'a'),(56,NULL,0,'usps','pb_usps','EM',1,30,0,'',0,NULL,NULL,0.0000,'a'),(57,NULL,0,'usps','pb_usps','STDPOST',1,40,0,'',0,NULL,NULL,0.0000,'a'),(58,NULL,0,'usps','pb_usps','PRCLSEL',1,50,0,'',0,NULL,NULL,0.0000,'a'),(59,NULL,0,'usps','pb_usps','MEDIA',1,60,0,'',0,NULL,NULL,0.0000,'a'),(60,NULL,0,'usps','pb_usps','LIB',1,70,0,'',0,NULL,NULL,0.0000,'a'),(61,NULL,0,'usps','pb_usps','FCMI',1,80,0,'',0,NULL,NULL,0.0000,'a'),(62,NULL,0,'usps','pb_usps','FCPIS',1,90,0,'',0,NULL,NULL,0.0000,'a'),(63,NULL,0,'usps','pb_usps','EMI',1,100,0,'',0,NULL,NULL,0.0000,'a'),(64,NULL,0,'usps','pb_usps','PMI',1,110,0,'',0,NULL,NULL,0.0000,'a'),(65,NULL,0,'capost','','',0,0,0,'XC_CanadaPost',0,NULL,NULL,0.0000,'a'),(66,NULL,0,'capost','capost','DOM.RP',1,10,0,'',0,NULL,NULL,0.0000,'a'),(67,NULL,0,'capost','capost','DOM.EP',1,20,0,'',0,NULL,NULL,0.0000,'a'),(68,NULL,0,'capost','capost','DOM.XP',1,30,0,'',0,NULL,NULL,0.0000,'a'),(69,NULL,0,'capost','capost','DOM.XP.CERT',1,40,0,'',0,NULL,NULL,0.0000,'a'),(70,NULL,0,'capost','capost','DOM.PC',1,50,0,'',0,NULL,NULL,0.0000,'a'),(71,NULL,0,'capost','capost','DOM.LIB',1,60,0,'',0,NULL,NULL,0.0000,'a'),(72,NULL,0,'capost','capost','USA.EP',1,70,0,'',0,NULL,NULL,0.0000,'a'),(73,NULL,0,'capost','capost','USA.PW.ENV',1,80,0,'',0,NULL,NULL,0.0000,'a'),(74,NULL,0,'capost','capost','USA.PW.PAK',1,90,0,'',0,NULL,NULL,0.0000,'a'),(75,NULL,0,'capost','capost','USA.PW.PARCEL',1,100,0,'',0,NULL,NULL,0.0000,'a'),(76,NULL,0,'capost','capost','USA.SP.AIR',1,110,0,'',0,NULL,NULL,0.0000,'a'),(77,NULL,0,'capost','capost','USA.TP',1,120,0,'',0,NULL,NULL,0.0000,'a'),(78,NULL,0,'capost','capost','USA.TP.LVM',1,130,0,'',0,NULL,NULL,0.0000,'a'),(79,NULL,0,'capost','capost','USA.XP',1,140,0,'',0,NULL,NULL,0.0000,'a'),(80,NULL,0,'capost','capost','INT.XP',1,150,0,'',0,NULL,NULL,0.0000,'a'),(81,NULL,0,'capost','capost','INT.IP.AIR',1,160,0,'',0,NULL,NULL,0.0000,'a'),(82,NULL,0,'capost','capost','INT.IP.SURF',1,170,0,'',0,NULL,NULL,0.0000,'a'),(83,NULL,0,'capost','capost','INT.PW.ENV',1,180,0,'',0,NULL,NULL,0.0000,'a'),(84,NULL,0,'capost','capost','INT.PW.PAK',1,190,0,'',0,NULL,NULL,0.0000,'a'),(85,NULL,0,'capost','capost','INT.PW.PARCEL',1,200,0,'',0,NULL,NULL,0.0000,'a'),(86,NULL,0,'capost','capost','INT.SP.AIR',1,210,0,'',0,NULL,NULL,0.0000,'a'),(87,NULL,0,'capost','capost','INT.SP.SURF',1,220,0,'',0,NULL,NULL,0.0000,'a'),(88,NULL,0,'capost','capost','INT.TP',1,230,0,'',0,NULL,NULL,0.0000,'a'),(89,NULL,0,'offline','','courier',1,10,1,'',0,NULL,'S',0.0000,'a'),(90,NULL,0,'offline','','',1,20,1,'',0,NULL,'S',0.0000,'a'),(91,NULL,0,'offline','','',1,30,1,'',0,NULL,'S',0.0000,'a'),(92,NULL,0,'offline','','',1,40,1,'',0,NULL,'S',0.0000,'a'),(93,NULL,0,'offline','','',1,50,1,'',0,NULL,'S',0.0000,'a'),(94,NULL,1,'offline','','FREESHIP',1,30,1,'',0,NULL,'S',0.0000,'a'),(95,NULL,0,'offline','','FIXEDFEE',1,40,1,'',0,NULL,'S',0.0000,'a');
CREATE TABLE `xlite_categories` (
  `category_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned DEFAULT NULL,
  `ogMeta` longtext COLLATE utf8_unicode_ci,
  `useCustomOG` tinyint(1) NOT NULL,
  `demo` tinyint(1) NOT NULL,
  `useClasses` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `lpos` int(11) NOT NULL,
  `rpos` int(11) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `show_title` tinyint(1) NOT NULL,
  `depth` int(11) NOT NULL,
  `pos` int(11) NOT NULL,
  `root_category_look` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `metaDescType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `xcPendingExport` tinyint(1) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `IDX_9D0DF19B727ACA70` (`parent_id`),
  KEY `lpos` (`lpos`),
  KEY `rpos` (`rpos`),
  KEY `enabled` (`enabled`),
  CONSTRAINT `FK_9D0DF19B727ACA70` FOREIGN KEY (`parent_id`) REFERENCES `xlite_categories` (`category_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_categories` VALUES (1,NULL,'',0,0,'A',1,16,1,0,-1,0,'icons','A',0),(2,1,'',0,1,'A',2,3,1,1,0,30,NULL,'A',0),(3,1,'',0,1,'A',4,5,0,1,0,20,NULL,'A',0),(4,1,'',0,1,'A',6,7,1,1,0,10,NULL,'A',0),(5,1,'',0,1,'A',8,15,1,1,0,40,NULL,'A',0),(6,5,'',0,1,'A',9,10,1,1,1,10,NULL,'A',0),(7,5,'',0,1,'A',11,12,1,1,1,20,NULL,'A',0),(8,5,'',0,1,'A',13,14,1,1,1,30,NULL,'A',0);
CREATE TABLE `xlite_payment_transactions` (
  `transaction_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  `method_id` int(11) DEFAULT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `date` int(11) NOT NULL,
  `publicTxnId` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `method_name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `method_local_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `status` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `value` decimal(14,4) NOT NULL,
  `note` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `public_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `IDX_33CBDC008D9F6D38` (`order_id`),
  KEY `IDX_33CBDC0019883967` (`method_id`),
  KEY `IDX_33CBDC0038248176` (`currency_id`),
  KEY `status` (`status`),
  KEY `o` (`order_id`,`status`),
  KEY `pm` (`method_id`,`status`),
  KEY `publicTxnId` (`publicTxnId`),
  CONSTRAINT `FK_33CBDC0038248176` FOREIGN KEY (`currency_id`) REFERENCES `xlite_currencies` (`currency_id`),
  CONSTRAINT `FK_33CBDC0019883967` FOREIGN KEY (`method_id`) REFERENCES `xlite_payment_methods` (`method_id`) ON DELETE SET NULL,
  CONSTRAINT `FK_33CBDC008D9F6D38` FOREIGN KEY (`order_id`) REFERENCES `xlite_orders` (`order_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_payment_transactions` VALUES (1,1,4,840,1394005540,'000001-KGSP','MoneyOrdering','Money Order','S',110.6500,'','sale','000001-KGSP'),(2,2,4,840,1396005895,'000002-FX7B','MoneyOrdering','Money Order','S',88.6700,'','sale','000002-FX7B'),(3,3,4,840,1407005895,'000002-FX7B','MoneyOrdering','Money Order','S',158.9400,'','sale','000002-FX7B'),(4,4,NULL,840,1452604411,'000012-AS2T','SimplifyCommerceHP','Simplify Commerce Hosted Payments','F',38.0100,'Simplify_BadRequestException: \"Request data is invalid\" (status: 400, error code: validation, reference: c5a0b8b8-92ac-4908-9506-88b843ecd399)\nField error: card.number\"Card bin Country rejected by acquirer\" (country.bin.not.accepted)','sale','demostore-000012-AS2T'),(5,4,NULL,840,1452604437,'000013-3I22','SimplifyCommerceHP','Simplify Commerce Hosted Payments','F',38.0100,'Simplify_BadRequestException: \"Request data is invalid\" (status: 400, error code: validation, reference: 195c1b1a-44c8-46d4-8e48-ee4e65f271af)\nField error: card.number\"Card has expired.\" (card.expired)','sale','demostore-000013-3I22'),(6,5,4,840,1452604702,'000005-KXAQ','MoneyOrdering','Money Order','S',352.8100,'','sale','000005-KXAQ');
CREATE TABLE `xlite_page_images` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `page_id` int(10) unsigned DEFAULT NULL,
  `width` int(11) NOT NULL,
  `height` int(11) NOT NULL,
  `hash` char(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `needProcess` tinyint(1) NOT NULL,
  `path` varchar(512) COLLATE utf8_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_ABDA1565C4663E4` (`page_id`),
  CONSTRAINT `FK_ABDA1565C4663E4` FOREIGN KEY (`page_id`) REFERENCES `xlite_pages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_temporary_files` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `width` int(11) NOT NULL,
  `height` int(11) NOT NULL,
  `hash` char(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `needProcess` tinyint(1) NOT NULL,
  `path` varchar(512) COLLATE utf8_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_order_payment_status_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `customerName` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_702453C2BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_order_payment_statuses` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_order_payment_status_translations` VALUES (1,1,'Awaiting payment','Awaiting payment','en'),(2,2,'Authorized','Authorization hold','en'),(3,3,'Partially Paid','Partially Paid','en'),(4,4,'Paid','Paid','en'),(5,5,'Declined','Declined','en'),(6,6,'Cancelled','Cancelled','en'),(7,7,'Refunded','Refunded','en');
CREATE TABLE `xlite_orders` (
  `order_id` int(11) NOT NULL AUTO_INCREMENT,
  `not_finished_order_id` int(11) DEFAULT NULL,
  `profile_id` int(11) DEFAULT NULL,
  `orig_profile_id` int(11) DEFAULT NULL,
  `payment_status_id` int(10) unsigned DEFAULT NULL,
  `shipping_status_id` int(10) unsigned DEFAULT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `fraud_status_xpc` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `fraud_type_xpc` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `fraud_check_transaction_id` int(11) NOT NULL,
  `is_zero_auth` tinyint(1) NOT NULL,
  `mailchimpStoreId` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `demo` tinyint(1) NOT NULL,
  `shipping_id` int(11) NOT NULL,
  `shipping_method_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment_method_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tracking` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `date` int(11) NOT NULL,
  `lastRenewDate` int(11) NOT NULL,
  `notes` longtext COLLATE utf8_unicode_ci NOT NULL,
  `adminNotes` longtext COLLATE utf8_unicode_ci NOT NULL,
  `orderNumber` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `recent` tinyint(1) NOT NULL,
  `xcPendingExport` tinyint(1) NOT NULL,
  `total` decimal(14,4) NOT NULL,
  `subtotal` decimal(14,4) NOT NULL,
  `is_order` int(11) NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `IDX_9A9BE335791AE370` (`not_finished_order_id`),
  KEY `IDX_9A9BE335CCFA12B8` (`profile_id`),
  KEY `IDX_9A9BE335DBFEF46C` (`orig_profile_id`),
  KEY `IDX_9A9BE33538248176` (`currency_id`),
  KEY `date` (`date`),
  KEY `total` (`total`),
  KEY `subtotal` (`subtotal`),
  KEY `tracking` (`tracking`),
  KEY `payment_status` (`payment_status_id`),
  KEY `shipping_status` (`shipping_status_id`),
  KEY `shipping_id` (`shipping_id`),
  KEY `lastRenewDate` (`lastRenewDate`),
  KEY `orderNumber` (`orderNumber`),
  KEY `is_order` (`is_order`),
  KEY `xcPendingExport` (`xcPendingExport`),
  KEY `is_zero_auth` (`is_zero_auth`),
  CONSTRAINT `FK_9A9BE33538248176` FOREIGN KEY (`currency_id`) REFERENCES `xlite_currencies` (`currency_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_9A9BE33528DE2F95` FOREIGN KEY (`payment_status_id`) REFERENCES `xlite_order_payment_statuses` (`id`) ON DELETE SET NULL,
  CONSTRAINT `FK_9A9BE3352D02518A` FOREIGN KEY (`shipping_status_id`) REFERENCES `xlite_order_shipping_statuses` (`id`) ON DELETE SET NULL,
  CONSTRAINT `FK_9A9BE335791AE370` FOREIGN KEY (`not_finished_order_id`) REFERENCES `xlite_orders` (`order_id`) ON DELETE SET NULL,
  CONSTRAINT `FK_9A9BE335CCFA12B8` FOREIGN KEY (`profile_id`) REFERENCES `xlite_profiles` (`profile_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_9A9BE335DBFEF46C` FOREIGN KEY (`orig_profile_id`) REFERENCES `xlite_profiles` (`profile_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_orders` VALUES (1,NULL,2,1,4,4,840,'','',0,0,'',1,0,'','','',1394005540,1543299908,'','','1',0,0,18.4900,19.9900,1),(2,NULL,3,1,4,4,840,'','',0,0,'',1,0,'','','',1396005895,1543299908,'','','2',1,0,88.6700,84.9500,1),(3,NULL,4,1,4,4,840,'','',0,0,'',1,0,'','','',1407005895,1543299908,'','','3',1,0,158.9400,158.9400,1),(4,NULL,5,1,5,5,840,'','',0,0,'',1,0,'','Simplify Commerce Hosted Payments','',1452604403,1543299909,'','','4',1,0,38.0100,34.9900,1),(5,NULL,6,1,4,4,840,'','',0,0,'',1,0,'','','',1452604702,1543299909,'','','5',0,0,352.8100,351.3100,1);
CREATE TABLE `xlite_xpc_payment_transaction_data` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `address_id` int(11) DEFAULT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `card_number` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `card_type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `card_expire` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `use_for_recharges` char(1) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_46DDB2932FC0CB0F` (`transaction_id`),
  KEY `IDX_46DDB293F5B7AF75` (`address_id`),
  CONSTRAINT `FK_46DDB2932FC0CB0F` FOREIGN KEY (`transaction_id`) REFERENCES `xlite_payment_transactions` (`transaction_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_46DDB293F5B7AF75` FOREIGN KEY (`address_id`) REFERENCES `xlite_profile_addresses` (`address_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_data_source_parameters` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `data_source_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_6D9196CA1A935C57` (`data_source_id`),
  CONSTRAINT `FK_6D9196CA1A935C57` FOREIGN KEY (`data_source_id`) REFERENCES `xlite_data_sources` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_access_control_zone_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_access_control_zone_types` VALUES (1,'order');
CREATE TABLE `xlite_vendor_convo_message_reads` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `message_id` int(10) unsigned DEFAULT NULL,
  `profile_id` int(11) DEFAULT NULL,
  `date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`message_id`,`profile_id`),
  KEY `IDX_25816BBA537A1329` (`message_id`),
  KEY `IDX_25816BBACCFA12B8` (`profile_id`),
  CONSTRAINT `FK_25816BBACCFA12B8` FOREIGN KEY (`profile_id`) REFERENCES `xlite_profiles` (`profile_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_25816BBA537A1329` FOREIGN KEY (`message_id`) REFERENCES `xlite_vendor_convo_messages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_capost_delivery_service_options` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mandatory` tinyint(1) NOT NULL,
  `qualifierRequired` tinyint(1) NOT NULL,
  `qualifierMax` decimal(14,4) DEFAULT NULL,
  `serviceId` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_85C93F5589697FA8` (`serviceId`),
  CONSTRAINT `FK_85C93F5589697FA8` FOREIGN KEY (`serviceId`) REFERENCES `xlite_capost_delivery_services` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `position` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_tag_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_EDCE6447BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_tags` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_content_videos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(512) COLLATE utf8_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_order_capost_parcel_manifest_link_storage` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(512) COLLATE utf8_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  `linkId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_73059AC5AEC98E42` (`linkId`),
  CONSTRAINT `FK_73059AC5AEC98E42` FOREIGN KEY (`linkId`) REFERENCES `xlite_order_capost_parcel_manifest_links` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_tmp_vars` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_tmp_vars` VALUES (1,'cloud_search_reg_scheduled','1'),(2,'cache_build_timestamp','i:1543299932;'),(3,'get_addonsTTL','i:1543299933;'),(4,'get_coresData','a:0:{}'),(5,'get_coresTTL','i:1543299934;');
CREATE TABLE `xlite_tax_class_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_95C1403BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_tax_classes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_payment_method_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8_unicode_ci NOT NULL,
  `adminDescription` longtext COLLATE utf8_unicode_ci NOT NULL,
  `altAdminDescription` longtext COLLATE utf8_unicode_ci NOT NULL,
  `instruction` longtext COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_9FBF065BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_payment_methods` (`method_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_payment_method_translations` VALUES (1,1,'Purchase Order','','','','','','en'),(2,1,'Заказ-наряд','','Оформить заказ на поставку товара','','','','ru'),(3,2,'Phone Ordering','','Phone: (555) 555-5555','','','','en'),(4,2,'Заказ по телефону','','Тел. (555) 555-5555','','','','ru'),(5,3,'Fax Ordering','','Fax: (555) 555-5555','','','','en'),(6,3,'Заказ по факсу','','','','','','ru'),(7,4,'Money Order','','US Banks Only','','','','en'),(8,4,'Денежный перевод','','Оплата через отделение банка','','','','ru'),(9,5,'Check','','Check payment','','','','en'),(10,5,'Чек','','Оплата банковским чеком','','','','ru'),(11,6,'COD','','Cash On Delivery','','','','en'),(12,6,'Наложенный платеж','','Оплата товара при получении','','','','ru'),(13,7,'Cash on Delivery (FedEx)','','','','','','en'),(14,8,'PayPal Payflow Link','Credit/Debit card or PayPal','','','Accept Visa, MasterCard®, American Express, Discover and PayPal payments on your site by connecting a PayPal-hosted checkout page with your own internet merchant account. Customize the page to look like the rest of your site and make sure customer transactions are secure.','','en'),(15,9,'PayPal Partner Hosted with PCI Compliance','Credit/Debit card','','','PCI compliant payments on your site with Visa, MasterCard, American Express and Discover - without PayPal-hosted pages. Maintain full control over your customers\' checkout experience by providing a credit card form that will post your customers\' payment details from your site\'s native checkout page directly to the Gateway server.','','en'),(16,10,'PayPal Payments Advanced','Credit/Debit card or PayPal','','','Accept Visa, MasterCard®, American Express, Discover and PayPal payments securely. With this all-in-one option, customers stay on your site for the entire checkout process. It simplifies PCI compliance and opens the door to more than 100 million active PayPal customers. Requires credit approval (2-3 business days).','','en'),(17,11,'PayPal Payments Standard','PayPal','','','Add a PayPal payment button to your site to accept Visa, MasterCard®, American Express, Discover and PayPal payments securely. When your customers check out, they are redirected to PayPal to pay, then return to your site after they are finished.','','en'),(18,12,'PayPal Express Checkout','PayPal','','','Create a seamless checkout experience and increase your conversion rate by opening the door to over 100 million active PayPal customers who look for and use this fast, easy, and secure way to pay.','','en'),(19,13,'PayPal Credit','PayPal Credit','','','','','en'),(20,14,'PayPal Adaptive payments (legacy)','PayPal','','','This method provides automatic transfer of payments to vendor users (the type of users enabled by the Multi-vendor module). The method may not be activated unless the module <a href=\'admin.php?target=addons_list_marketplace&moduleName=XC\\MultiVendor\' target=\'_blank\'>Multi-vendor</a> is installed and enabled. To use this method, store administrator is required to have an Application ID for PayPal Adaptive Payments API.','','en'),(21,15,'PayPal for Marketplaces (beta)','PayPal','','','PayPal for Marketplaces is a comprehensive payments solution for marketplaces, crowdfunding platforms, and other environments where people buy and sell goods and services or raise money. The solution is ideal if you run a multi-party commerce platform and want a flexible, end-to-end solution for processing payments.','','en'),(22,15,'PayPal for Marketplaces (beta)','PayPal','','','PayPal for Marketplaces - это комплексное решение по приёму платежей для торговых площадок, платформ для сбора средств под проект (\"краудфандинг\") и других сфер, где осуществляется продажа и покупка товаров и услуг, либо сбор средств. Данное решение идеально подойдет для платформ, осуществляющих коммерческую деятельность от лица нескольких участников, и представляет собой комплексное и гибкое решение для обработки платежей на всех этапах этой деятельности.','','ru'),(23,16,'Cash on Delivery (UPS)','','','','','','en'),(24,17,'Authorize.Net SIM','','','','','','en'),(25,18,'Skrill Wallet','','','','','','en'),(26,19,'Skrill Neteller','','','','','','en'),(27,20,'Skrill PSC','','','','','','en'),(28,21,'Skrill Resurs','','','','','','en'),(29,22,'Skrill All Card Types','','','','','','en'),(30,23,'Skrill Visa','','','','','','en'),(31,24,'Skrill MasterCard','','','','','','en'),(32,25,'Skrill Visa Delta/Debit','','','','','','en'),(33,26,'Skrill Visa Electron','','','','','','en'),(34,27,'Skrill Maestro','','','','','','en'),(35,28,'Skrill American Express','','','','','','en'),(36,29,'Skrill Carte Bleue','','','','','','en'),(37,30,'Skrill Dankort','','','','','','en'),(38,31,'Skrill PostePay','','','','','','en'),(39,32,'Skrill CartaSi','','','','','','en'),(40,33,'Skrill Online Bank Transfer','','','','','','en'),(41,34,'Skrill Giropay','','','','','','en'),(42,35,'Skrill Direct Debit / ELV','','','','','','en'),(43,36,'Skrill All Polish Banks','','','','','','en'),(44,37,'Skrill Sofortueberweisung','','','','','','en'),(45,38,'Skrill Nordea Solo','','','','','','en'),(46,39,'Skrill iDEAL','','','','','','en'),(47,40,'Skrill EPS (Netpay)','','','','','','en'),(48,41,'Skrill POLi','','','','','','en'),(49,42,'Skrill ePay.bg','','','','','','en'),(50,43,'Skrill Trustly','','','','','','en'),(51,44,'Skrill Alipay','','','','','','en'),(52,45,'Skrill Direct bank transfer','','','','','','en'),(53,46,'Skrill Manual bank transfer','','','','','','en'),(54,47,'Skrill Cash/Invoice','','','','','','en'),(55,48,'Skrill Unionpay','','','','','','en'),(56,49,'QuantumGateway','','','','','','en'),(57,50,'2Checkout.com','','','','','','en'),(58,51,'Cash on Delivery (USPS)','','','','','','en'),(59,52,'Barclaycard ePDQ e-Commerce','','','','','','en'),(60,53,'iDEAL Professional (Rabobank)','','','','','','en'),(61,54,'Sage Pay form protocol','','','','','','en'),(62,55,'Stripe','','','','','','en'),(63,56,'Ingenico Payment Services (Ogone)','','','','','','en'),(64,57,'Moneris (eSELECTplus- Hosted Pay Page)','','','','','','en'),(65,58,'Amazon Pay','','','','','','en'),(66,59,'PayPal powered by Braintree','','','Supported countries: US, UK, France, Italy & Spain.','','','en'),(67,60,'Authorize.Net Accept.js','','','','','','en');
CREATE TABLE `xlite_access_control_entities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type_id` int(10) unsigned DEFAULT NULL,
  `cell_id` int(10) unsigned DEFAULT NULL,
  `uid` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_A98BAB59C54C8C93` (`type_id`),
  KEY `IDX_A98BAB59CB39D93A` (`cell_id`),
  CONSTRAINT `FK_A98BAB59CB39D93A` FOREIGN KEY (`cell_id`) REFERENCES `xlite_access_control_cells` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_A98BAB59C54C8C93` FOREIGN KEY (`type_id`) REFERENCES `xlite_access_control_entity_types` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_zone_elements` (
  `element_id` int(11) NOT NULL AUTO_INCREMENT,
  `zone_id` int(11) DEFAULT NULL,
  `element_value` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `element_type` char(1) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`element_id`),
  KEY `IDX_2AF5A18A9F2C3FAB` (`zone_id`),
  KEY `type_value` (`element_type`,`element_value`),
  KEY `id_type` (`zone_id`,`element_type`),
  CONSTRAINT `FK_2AF5A18A9F2C3FAB` FOREIGN KEY (`zone_id`) REFERENCES `xlite_zones` (`zone_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_zone_elements` VALUES (1,2,'US','C'),(2,2,'VI','C'),(3,2,'UM','C'),(4,3,'US','C'),(5,3,'VI','C'),(6,3,'UM','C'),(7,3,'CA','C'),(8,3,'US_NY','S'),(9,3,'US_ME','S'),(10,3,'US_VT','S'),(11,3,'US_NH','S'),(12,3,'US_MI','S'),(13,3,'US_MN','S'),(14,3,'US_WI','S'),(15,4,'AT','C'),(16,4,'BE','C'),(17,4,'BG','C'),(18,4,'HR','C'),(19,4,'CY','C'),(20,4,'CZ','C'),(21,4,'DK','C'),(22,4,'EE','C'),(23,4,'FL','C'),(24,4,'FR','C'),(25,4,'DE','C'),(26,4,'GR','C'),(27,4,'HU','C'),(28,4,'IE','C'),(29,4,'IT','C'),(30,4,'LV','C'),(31,4,'LT','C'),(32,4,'LU','C'),(33,4,'MT','C'),(34,4,'NL','C'),(35,4,'PL','C'),(36,4,'PT','C'),(37,4,'RO','C'),(38,4,'SK','C'),(39,4,'SI','C'),(40,4,'ES','C'),(41,4,'SE','C'),(42,4,'GB','C');
CREATE TABLE `xlite_sales_taxes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `enabled` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_config` (
  `config_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `category` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `orderby` int(11) NOT NULL,
  `value` longtext COLLATE utf8_unicode_ci NOT NULL,
  `widgetParameters` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:array)',
  PRIMARY KEY (`config_id`),
  UNIQUE KEY `nc` (`name`,`category`),
  KEY `orderby` (`orderby`),
  KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_config` VALUES (1,'admin_presentation','General','separator',40000,'','N;'),(2,'admin_security','Security','checkbox',1000,'N','N;'),(3,'anonymous','Shipping','separator',3000,'','N;'),(4,'anonymous_address','Shipping','text',4000,'','N;'),(5,'anonymous_country','Shipping','country',5000,'US','N;'),(6,'anonymous_state','Shipping','state',6000,'562','a:1:{s:9:\"selectOne\";b:1;}'),(7,'anonymous_custom_state','Shipping','text',7000,'','N;'),(8,'anonymous_city','Shipping','text',8000,'Los Angeles','N;'),(9,'anonymous_zipcode','Shipping','text',9000,'90001','N;'),(10,'anonymous_address_type','Shipping','\\XLite\\View\\FormField\\Select\\AddressType',10000,'R','N;'),(11,'aggregate_css','Performance','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',2000,'Y','N;'),(12,'aggregate_js','Performance','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',3000,'Y','N;'),(13,'use_view_cache','Performance','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',4000,'Y','N;'),(14,'use_dynamic_image_resizing','Performance','hidden',5000,'','N;'),(15,'use_lazy_load','Performance','hidden',5200,'','N;'),(16,'unsharp_mask_filter_on_resize','Performance','hidden',5100,'','N;'),(17,'layout_type','Layout','XLite\\View\\FormField\\Select\\LayoutType',1000,'left','N;'),(18,'layout_type_home','Layout','XLite\\View\\FormField\\Select\\LayoutType',1010,'one','N;'),(19,'cli_key','Security','',11000,'','N;'),(20,'company_address','Company','separator',38500,'','N;'),(21,'company_contacts','Company','separator',45500,'','N;'),(22,'company_fax','Company','XLite\\View\\FormField\\Input\\Text\\Phone',42000,'','N;'),(23,'company_identity','Company','separator',35000,'','N;'),(24,'company_name','Company','text',36000,'*Your company name*','N;'),(25,'company_website','Company','text',37000,'','N;'),(26,'terms_url','General','text',38000,'terms-and-conditions.html','N;'),(27,'customer_presentation','General','separator',20000,'','N;'),(28,'customer_security','Security','checkbox',100,'N','N;'),(29,'date_format','Units','XLite\\View\\FormField\\Select\\DateFormat',66000,'%b %e, %Y','N;'),(30,'week_start','Units','XLite\\View\\FormField\\Select\\DayOfWeek',67000,'sun','N;'),(31,'csv_delim','Units','XLite\\View\\FormField\\Select\\CSVDelimiter',70000,',','N;'),(32,'export_import_charset','Units','XLite\\View\\FormField\\Select\\IconvCharset',72500,'UTF-8','N;'),(33,'export_product_attrs','Units','XLite\\View\\FormField\\Select\\ExportAttrs',75000,'global','N;'),(34,'default_language','General','',33000,'en','N;'),(35,'default_admin_language','General','',33500,'en','N;'),(36,'default_offline_payment','Payments','text',0,'','N;'),(37,'default_purchase_limit','General','XLite\\View\\FormField\\Input\\Text\\Integer',29300,'9999','a:1:{s:3:\"min\";i:1;}'),(38,'default_select_payment','Payments','text',0,'','N;'),(39,'display_check_number','General','checkbox',21500,'Y','N;'),(40,'show_out_of_stock_products','General','XLite\\View\\FormField\\Select\\ShowOutOfStockProducts',20000,'directLink','N;'),(41,'default_prod_display_mode','General','XLite\\View\\FormField\\Select\\DefaultDisplayModeForProductsList',25000,'grid','N;'),(42,'license','License','text',0,'','N;'),(43,'location_address','Company','text',39000,'*Your company address*','N;'),(44,'location_country','Company','country',40000,'US','a:2:{s:9:\"selectOne\";b:0;s:3:\"all\";b:1;}'),(45,'location_state','Company','state',41000,'591','N;'),(46,'location_custom_state','Company','text',41500,'','N;'),(47,'location_city','Company','text',42000,'New York','N;'),(48,'location_zipcode','Company','text',43000,'10001','N;'),(49,'origin_use_company','Company','checkbox',38000,'1','N;'),(50,'origin_address','Company','text',39000,'','N;'),(51,'origin_country','Company','country',40000,'US','a:2:{s:9:\"selectOne\";b:0;s:3:\"all\";b:1;}'),(52,'origin_state','Company','state',41000,'','N;'),(53,'origin_custom_state','Company','text',41500,'','N;'),(54,'origin_city','Company','text',42000,'','N;'),(55,'origin_zipcode','Company','text',43000,'','N;'),(56,'company_phone','Company','text',44000,'(555) 555-5555','N;'),(57,'login_lifetime','General','XLite\\View\\FormField\\Input\\Text\\Integer',45000,'3','a:1:{s:3:\"min\";i:1;}'),(58,'maximal_order_amount','General','XLite\\View\\FormField\\Input\\Text\\FloatInput',29000,'99999','a:1:{s:3:\"min\";i:1;}'),(59,'minimal_order_amount','General','XLite\\View\\FormField\\Input\\Text\\FloatInput',28000,'0','a:1:{s:3:\"min\";i:0;}'),(60,'order_number_counter','General','XLite\\View\\FormField\\Input\\Text\\Integer',39000,'6','N;'),(61,'cart_ttl','General','XLite\\View\\FormField\\Input\\Text\\Integer',39500,'7','N;'),(62,'internal_cron_enabled','General','checkbox',39800,'Y','N;'),(63,'orders_department','Company','XLite\\View\\FormField\\Select\\MultipleEmails',48000,'a:1:{i:0;s:17:\"admin@example.com\";}','N;'),(64,'orders_per_page','General','XLite\\View\\FormField\\Input\\Text\\Integer',43000,'30','a:1:{s:3:\"min\";i:1;}'),(65,'products_per_page','General','XLite\\View\\FormField\\Input\\Text\\Integer',25000,'12','a:1:{s:3:\"min\";i:1;}'),(66,'products_per_page_max','General','XLite\\View\\FormField\\Input\\Text\\Integer',25000,'100','a:1:{s:3:\"min\";i:1;}'),(67,'products_per_page_admin','General','XLite\\View\\FormField\\Input\\Text\\Integer',41000,'10','a:1:{s:3:\"min\";i:1;}'),(68,'force_choose_product_options','General','XLite\\View\\FormField\\Select\\ForceProductOptions',29900,'','N;'),(69,'redirect_to_cart','General','checkbox',30000,'N','N;'),(70,'shop_closed','Internal','checkbox',11000,'N','N;'),(71,'shop_currency','General','',60500,'840','N;'),(72,'trailing_zeroes','General','',60500,'0','N;'),(73,'site_administrator','Company','XLite\\View\\FormField\\Select\\MultipleEmails',46000,'a:1:{i:0;s:17:\"admin@example.com\";}','N;'),(74,'smtp_password','Email','XLite\\View\\FormField\\Input\\PasswordWithValue',16000,'','N;'),(75,'smtp_security','Email','XLite\\View\\FormField\\Select\\SMTPSecurity',17000,'no','N;'),(76,'smtp_server_port','Email','XLite\\View\\FormField\\Input\\Text\\Integer',13000,'25','a:2:{s:3:\"min\";i:0;s:3:\"max\";i:65535;}'),(77,'smtp_server_url','Email','text',12000,'','N;'),(78,'smtp_username','Email','text',15000,'','N;'),(79,'start_year','Company','XLite\\View\\FormField\\Input\\Text\\PastYear',38000,'2016','N;'),(80,'subcategories_look','General','XLite\\View\\FormField\\Select\\SubcategoriesLook',22000,'icons','N;'),(81,'default_products_sort_order','General','XLite\\View\\FormField\\Select\\DefaultProductSortOrder',22500,'default','N;'),(82,'default_search_sort_order','General','XLite\\View\\FormField\\Select\\DefaultProductSortOrder',22501,'default','N;'),(83,'support_department','Company','XLite\\View\\FormField\\Select\\MultipleEmails',49000,'a:1:{i:0;s:17:\"admin@example.com\";}','N;'),(84,'time_format','Units','XLite\\View\\FormField\\Select\\TimeFormat',67000,'%H:%M','N;'),(85,'time_zone','Units','XLite\\View\\FormField\\Select\\TimeZone',68000,'','N;'),(86,'users_department','Company','XLite\\View\\FormField\\Select\\MultipleEmails',47000,'a:1:{i:0;s:17:\"admin@example.com\";}','N;'),(87,'users_per_page','General','XLite\\View\\FormField\\Input\\Text\\Integer',42000,'30','a:1:{s:3:\"min\";i:1;}'),(88,'mail_from_type','Email','XLite\\View\\FormField\\Select\\EmailFrom',10500,'contact','N;'),(89,'mail_from_manual','Email','\\XLite\\View\\FormField\\Input\\Text\\EmailFromManual',10600,'','a:1:{s:8:\"required\";b:1;}'),(90,'use_smtp','Email','\\XLite\\View\\FormField\\Input\\Checkbox\\UseSmtp',11000,'','N;'),(91,'use_smtp_auth','Email','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',14000,'','N;'),(92,'version','Version','',0,'5.3.5.8','N;'),(93,'weight_symbol','Units','text',62000,'lbs','N;'),(94,'weight_unit','Units','XLite\\View\\FormField\\Select\\WeightUnit',61000,'lbs','N;'),(95,'weight_trailing_zeroes','Units','checkbox',62100,'Y','N;'),(96,'weight_format','Units','XLite\\View\\FormField\\Select\\FloatFormat',62200,'|.','N;'),(97,'dim_symbol','Units','text',62500,'in','N;'),(98,'dim_unit','Units','XLite\\View\\FormField\\Select\\DimUnit',62300,'in','N;'),(99,'curl_cainfo','Environment','text',11000,'','N;'),(100,'curl_capath','Environment','text',12000,'','N;'),(101,'force_login_before_checkout','General','checkbox',30500,'Y','N;'),(102,'enable_add2cart_button_grid','General','checkbox',30100,'Y','N;'),(103,'requires_shipping_default','General','',0,'1','N;'),(104,'clean_url_flag','CleanURL','XLite\\View\\FormField\\Input\\Checkbox\\CleanUrl',1000,'0','N;'),(105,'general_options','CleanURL','separator',10000,'','N;'),(106,'default_site_title','CleanURL','XLite\\View\\FormField\\Label\\TranslationLabel',11000,'default-site-title','N;'),(107,'default_site_meta_description','CleanURL','XLite\\View\\FormField\\Label\\TranslationLabel',12000,'default-meta-description','N;'),(108,'default_site_meta_keywords','CleanURL','XLite\\View\\FormField\\Label\\TranslationLabel',13000,'default-meta-keywords','N;'),(109,'home_page_title_and_meta','CleanURL','XLite\\View\\FormField\\CleanUrls\\FrontPage',14000,'','N;'),(110,'page_title_format','CleanURL','XLite\\View\\FormField\\CleanUrls\\PageTitleFormat',15000,'','N;'),(111,'company_name','CleanURL','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',15100,'1','N;'),(112,'parent_category_path','CleanURL','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',15200,'1','N;'),(113,'object_name','CleanURL','XLite\\View\\FormField\\Input\\Checkbox\\OnOffReadOnly',15300,'1','N;'),(114,'object_name_in_page_title_order','CleanURL','XLite\\View\\FormField\\Input\\Checkbox\\FirstLast',16000,'0','N;'),(115,'clean_urls_about','CleanURL','separator',20000,'','N;'),(116,'about_widget','CleanURL','XLite\\View\\FormField\\CleanUrls\\AboutCleanUrls',21000,'','N;'),(117,'allow_membership_request','General','checkbox',39900,'N','N;'),(118,'upgrade_wave_sep','Environment','separator',20000,'','N;'),(119,'upgrade_wave','Environment','XLite\\View\\FormField\\Select\\UpgradeWave',21000,'','N;'),(120,'quick_data_rebuilding','CacheManagement','checkbox',10000,'N','N;'),(121,'fields_settings_section','Email','separator',1000,'','N;'),(122,'reply_to_customer','Email','\\XLite\\View\\FormField\\Label\\ReplyToCustomer',10700,'','N;'),(123,'reply_to_admin','Email','\\XLite\\View\\FormField\\Label\\ReplyToAdmin',10800,'','N;'),(124,'smtp_section','Email','\\XLite\\View\\FormField\\Separator\\Regular',10950,'','N;'),(125,'enabled','BannerRotation','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',10000,'1','N;'),(126,'interval','BannerRotation','XLite\\View\\FormField\\Input\\Text\\FloatInput',30000,'5','N;'),(127,'attach_pdf_invoices','NotificationAttachments','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',10000,'0','N;'),(128,'contact_us_comment','Company','XLite\\View\\FormField\\ContactUsComment',49500,'','N;'),(129,'deliverability_check','Company','XLite\\View\\FormField\\DeliverabilityCheck',49400,'','N;'),(130,'enable_form','CDev\\ContactUs','XLite\\View\\FormField\\Input\\Checkbox\\YesNo',100,'1','N;'),(131,'email','CDev\\ContactUs','XLite\\View\\FormField\\Input\\Text\\Email',200,'','N;'),(132,'showEmail','CDev\\ContactUs','XLite\\View\\FormField\\Input\\Checkbox\\YesNo',300,'1','N;'),(133,'contact_us_sep_1','CDev\\ContactUs','separator',1000,'','N;'),(134,'recaptcha_public_key','CDev\\ContactUs','text',1100,'','N;'),(135,'recaptcha_private_key','CDev\\ContactUs','text',1200,'','N;'),(136,'number_of_bestsellers','CDev\\Bestsellers','XLite\\View\\FormField\\Input\\Text\\Integer',115,'4','a:1:{s:3:\"min\";i:1;}'),(137,'ttl','CDev\\Egoods','XLite\\View\\FormField\\Input\\Text\\Integer',100,'3','a:1:{s:3:\"min\";i:0;}'),(138,'attempts_limit','CDev\\Egoods','XLite\\View\\FormField\\Input\\Text\\Integer',200,'3','a:1:{s:3:\"min\";i:0;}'),(139,'enable_history','CDev\\Egoods','XLite\\View\\FormField\\Input\\Checkbox\\YesNo',300,'1','N;'),(140,'esd_fullfilment','CDev\\Egoods','XLite\\View\\FormField\\Input\\Checkbox\\YesNo',400,'','N;'),(141,'approve_before_download','CDev\\Egoods','XLite\\View\\FormField\\Input\\Checkbox\\YesNo',500,'','N;'),(142,'sendfile_info','CDev\\Egoods','XLite\\Module\\CDev\\Egoods\\View\\FormField\\Label\\Sendfile',600,'','N;'),(143,'amazon_separator','CDev\\Egoods','separator',1000,'0','N;'),(144,'enable_signed_urls','CDev\\Egoods','XLite\\View\\FormField\\Input\\Checkbox\\YesNo',1100,'0','N;'),(145,'amazon_access','CDev\\Egoods','XLite\\View\\FormField\\Input\\Text',1200,'','N;'),(146,'amazon_secret','CDev\\Egoods','XLite\\View\\FormField\\Input\\Text',1300,'','N;'),(147,'bucket','CDev\\Egoods','XLite\\View\\FormField\\Input\\Text',1400,'','N;'),(148,'bucket_region','CDev\\Egoods','hidden',1500,'','N;'),(149,'featured_products_look','CDev\\FeaturedProducts','XLite\\Module\\CDev\\FeaturedProducts\\View\\FormField\\FeaturedProductsLook',10,'grid','N;'),(150,'key','CDev\\FedEx','XLite\\View\\FormField\\Input\\Text',10,'','N;'),(151,'password','CDev\\FedEx','XLite\\View\\FormField\\Input\\PasswordWithValue',20,'','N;'),(152,'account_number','CDev\\FedEx','XLite\\View\\FormField\\Input\\Text',30,'','N;'),(153,'meter_number','CDev\\FedEx','XLite\\View\\FormField\\Input\\Text',40,'','N;'),(154,'test_mode','CDev\\FedEx','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',50,'','N;'),(155,'debug_enabled','CDev\\FedEx','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',60,'','N;'),(156,'additionalSettingsSeparator','CDev\\FedEx','separator',100,'','N;'),(157,'carrierTypesSeparator','CDev\\FedEx','separator',200,'','N;'),(158,'fdxe','CDev\\FedEx','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',210,'','N;'),(159,'fdxg','CDev\\FedEx','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',220,'','N;'),(160,'fxsp','CDev\\FedEx','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',230,'','N;'),(161,'fxsp_hub_id','CDev\\FedEx','XLite\\Module\\CDev\\FedEx\\View\\FormField\\Select\\HubId',235,'','N;'),(162,'fxsp_indicia','CDev\\FedEx','XLite\\Module\\CDev\\FedEx\\View\\FormField\\Select\\Indicia',240,'','N;'),(163,'rate_request_type','CDev\\FedEx','XLite\\Module\\CDev\\FedEx\\View\\FormField\\Select\\RateRequestType',300,'NONE','N;'),(164,'packaging','CDev\\FedEx','XLite\\Module\\CDev\\FedEx\\View\\FormField\\Select\\Packaging',310,'','N;'),(165,'dropoff_type','CDev\\FedEx','XLite\\Module\\CDev\\FedEx\\View\\FormField\\Select\\DropOffType',320,'','N;'),(166,'ship_date','CDev\\FedEx','XLite\\Module\\CDev\\FedEx\\View\\FormField\\Select\\ShipDate',330,'0','N;'),(167,'currency_code','CDev\\FedEx','XLite\\Module\\CDev\\FedEx\\View\\FormField\\Select\\CurrencyCode',340,'0','N;'),(168,'currency_rate','CDev\\FedEx','XLite\\View\\FormField\\Input\\Text\\FloatInput',350,'1','N;'),(169,'dimensions','CDev\\FedEx','serialized',360,'a:3:{i:0;i:10;i:1;i:10;i:2;i:10;}','N;'),(170,'max_weight','CDev\\FedEx','XLite\\View\\FormField\\Input\\Text\\FloatInput',370,'70','N;'),(171,'specialServicesSeparator','CDev\\FedEx','separator',400,'','N;'),(172,'dg_accessibility','CDev\\FedEx','XLite\\Module\\CDev\\FedEx\\View\\FormField\\Select\\DangerousGoodsAccessibility',410,'','N;'),(173,'signature','CDev\\FedEx','XLite\\Module\\CDev\\FedEx\\View\\FormField\\Select\\Signature',420,'','N;'),(174,'cacheOnDeliverySeparator','CDev\\FedEx','separator',500,'','N;'),(175,'cod_type','CDev\\FedEx','XLite\\Module\\CDev\\FedEx\\View\\FormField\\Select\\CODType',510,'ANY','N;'),(176,'advancedOptionsSeparator','CDev\\FedEx','separator',600,'','N;'),(177,'opt_saturday_pickup','CDev\\FedEx','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',610,'','N;'),(178,'opt_residential_delivery','CDev\\FedEx','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',620,'','N;'),(179,'send_insured_value','CDev\\FedEx','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',630,'1','N;'),(180,'ga_account','CDev\\GoogleAnalytics','text',100,'','N;'),(181,'ga_tracking_type','CDev\\GoogleAnalytics','XLite\\Module\\CDev\\GoogleAnalytics\\View\\FormField\\Select\\TrackingType',200,'1','N;'),(182,'ga_code_version','CDev\\GoogleAnalytics','XLite\\Module\\CDev\\GoogleAnalytics\\View\\FormField\\Select\\CodeVersion',300,'U','N;'),(183,'ecommerce_enabled','CDev\\GoogleAnalytics','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',400,'1','N;'),(184,'purchase_only_on_paid','CDev\\GoogleAnalytics','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',450,'1','N;'),(185,'debug_mode','CDev\\GoogleAnalytics','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',500,'','N;'),(186,'gosocial_sep_1','CDev\\GoSocial','separator',5000,'','N;'),(187,'fb_app_id','CDev\\GoSocial','text',5100,'','N;'),(188,'fb_app_namespace','CDev\\GoSocial','text',5200,'','N;'),(189,'fb_admins','CDev\\GoSocial','text',5300,'','N;'),(190,'gosocial_sep_6','CDev\\GoSocial','separator',1000,'','N;'),(191,'fb_share_use','CDev\\GoSocial','checkbox',1050,'1','N;'),(192,'gosocial_sep_2','CDev\\GoSocial','separator',1300,'','N;'),(193,'like_settings_warning','CDev\\GoSocial','XLite\\Module\\CDev\\GoSocial\\View\\FormField\\Label\\LikeSettingsWarning',1325,'1','N;'),(194,'fb_like_use','CDev\\GoSocial','checkbox',1350,'','N;'),(195,'fb_like_layout','CDev\\GoSocial','XLite\\Module\\CDev\\GoSocial\\View\\FormField\\Select\\FBLayoutStyle',1400,'button_count','N;'),(196,'fb_like_show_faces','CDev\\GoSocial','checkbox',1420,'1','N;'),(197,'fb_like_verb','CDev\\GoSocial','XLite\\Module\\CDev\\GoSocial\\View\\FormField\\Select\\FBVerbDisplay',1440,'like','N;'),(198,'fb_like_colorscheme','CDev\\GoSocial','XLite\\Module\\CDev\\GoSocial\\View\\FormField\\Select\\FBLikeColorScheme',1460,'light','N;'),(199,'gosocial_sep_21','CDev\\GoSocial','separator',1500,'','N;'),(200,'fb_comments_use','CDev\\GoSocial','checkbox',1600,'1','N;'),(201,'fb_comments_num_posts','CDev\\GoSocial','XLite\\View\\FormField\\Input\\Text\\Integer',1700,'8','a:1:{s:3:\"min\";i:1;}'),(202,'fb_comments_colorscheme','CDev\\GoSocial','XLite\\Module\\CDev\\GoSocial\\View\\FormField\\Select\\FBCommentsColorScheme',1750,'light','N;'),(203,'gosocial_sep_3','CDev\\GoSocial','separator',2000,'','N;'),(204,'tweet_use','CDev\\GoSocial','checkbox',2050,'1','N;'),(205,'tweet_show_count','CDev\\GoSocial','checkbox',2100,'1','N;'),(206,'tweet_via','CDev\\GoSocial','text',2200,'','N;'),(207,'tweet_recommend','CDev\\GoSocial','text',2300,'','N;'),(208,'tweet_hashtag','CDev\\GoSocial','text',2300,'','N;'),(209,'gosocial_sep_4','CDev\\GoSocial','separator',3000,'','N;'),(210,'gplus_use','CDev\\GoSocial','checkbox',3050,'','N;'),(211,'gplus_page_id','CDev\\GoSocial','text',3100,'','N;'),(212,'gosocial_sep_5','CDev\\GoSocial','separator',4000,'','N;'),(213,'pinterest_use','CDev\\GoSocial','checkbox',4050,'1','N;'),(214,'show_admin_welcome','CDev\\Paypal','checkbox',100,'N','N;'),(215,'paypalLoginOptions','CDev\\Paypal','\\XLite\\Module\\CDev\\Paypal\\View\\FormField\\Instructions',200,'','N;'),(216,'loginRedirectURLProtocol','CDev\\Paypal','XLite\\Module\\CDev\\Paypal\\View\\FormField\\Select\\Protocol',300,'http','N;'),(217,'loginClientId','CDev\\Paypal','text',400,'','N;'),(218,'loginClientSecret','CDev\\Paypal','text',500,'','N;'),(219,'loginMode','CDev\\Paypal','XLite\\View\\FormField\\Select\\TestLiveMode',600,'test','N;'),(220,'loginScopes','CDev\\Paypal','XLite\\Module\\CDev\\Paypal\\View\\FormField\\Select\\Scopes',700,'a:6:{i:0;s:6:\"openid\";i:1;s:5:\"email\";i:2;s:7:\"profile\";i:3;s:7:\"address\";i:4;s:5:\"phone\";i:5;s:47:\"https://uri.paypal.com/services/expresscheckout\";}','N;'),(221,'esd_fullfilment','CDev\\PINCodes','XLite\\View\\FormField\\Input\\Checkbox\\YesNo',400,'','N;'),(222,'approve_before_download','CDev\\PINCodes','XLite\\View\\FormField\\Input\\Checkbox\\YesNo',500,'','N;'),(223,'sep_product_advisor_na','CDev\\ProductAdvisor','separator',10,'','N;'),(224,'na_enabled','CDev\\ProductAdvisor','checkbox',20,'Y','N;'),(225,'na_max_days','CDev\\ProductAdvisor','XLite\\View\\FormField\\Input\\Text\\Integer',30,'30','a:1:{s:3:\"min\";i:0;}'),(226,'na_max_count_in_full_list','CDev\\ProductAdvisor','XLite\\View\\FormField\\Input\\Text\\Integer',40,'30','a:1:{s:3:\"min\";i:0;}'),(227,'na_mark_with_label','CDev\\ProductAdvisor','XLite\\Module\\CDev\\ProductAdvisor\\View\\FormField\\Select\\MarkProducts',50,'C','N;'),(228,'na_max_count_in_block','CDev\\ProductAdvisor','XLite\\View\\FormField\\Input\\Text\\Integer',80,'3','a:1:{s:3:\"min\";i:0;}'),(229,'na_from_current_category','CDev\\ProductAdvisor','checkbox',90,'N','N;'),(230,'sep_product_advisor_cs','CDev\\ProductAdvisor','separator',1000,'','N;'),(231,'cs_enabled','CDev\\ProductAdvisor','checkbox',1010,'Y','N;'),(232,'cs_mark_with_label','CDev\\ProductAdvisor','XLite\\Module\\CDev\\ProductAdvisor\\View\\FormField\\Select\\MarkProducts',1020,'C','N;'),(233,'cs_display_date','CDev\\ProductAdvisor','checkbox',1030,'Y','N;'),(234,'cs_from_current_category','CDev\\ProductAdvisor','checkbox',1050,'N','N;'),(235,'cs_max_count_in_block','CDev\\ProductAdvisor','XLite\\View\\FormField\\Input\\Text\\Integer',1080,'3','a:1:{s:3:\"min\";i:0;}'),(236,'sep_product_advisor_rv','CDev\\ProductAdvisor','separator',2000,'','N;'),(237,'rv_enabled','CDev\\ProductAdvisor','checkbox',2010,'Y','N;'),(238,'rv_max_count_in_block','CDev\\ProductAdvisor','XLite\\View\\FormField\\Input\\Text\\Integer',2020,'10','a:1:{s:3:\"min\";i:0;}'),(239,'sep_product_advisor_cbb','CDev\\ProductAdvisor','separator',3000,'','N;'),(240,'cbb_enabled','CDev\\ProductAdvisor','checkbox',3010,'Y','N;'),(241,'cbb_max_count_in_block','CDev\\ProductAdvisor','XLite\\View\\FormField\\Input\\Text\\Integer',3020,'5','a:1:{s:3:\"min\";i:0;}'),(242,'sep_product_advisor_cvb','CDev\\ProductAdvisor','separator',4000,'','N;'),(243,'cvb_enabled','CDev\\ProductAdvisor','checkbox',4010,'Y','N;'),(244,'cvb_max_count_in_block','CDev\\ProductAdvisor','XLite\\View\\FormField\\Input\\Text\\Integer',4020,'5','a:1:{s:3:\"min\";i:0;}'),(245,'sale_enabled','CDev\\Sale','checkbox',20,'Y','N;'),(246,'sale_in_current_category','CDev\\Sale','checkbox',30,'Y','N;'),(247,'sale_max_count_in_block','CDev\\Sale','text',80,'6','N;'),(248,'logo','CDev\\SimpleCMS','XLite\\Module\\CDev\\SimpleCMS\\View\\FormField\\Input\\Logo',100,'','N;'),(249,'favicon','CDev\\SimpleCMS','XLite\\Module\\CDev\\SimpleCMS\\View\\FormField\\Input\\Favicon',200,'','N;'),(250,'appleIcon','CDev\\SimpleCMS','XLite\\Module\\CDev\\SimpleCMS\\View\\FormField\\Input\\AppleIcon',250,'','N;'),(251,'page_changefreq','CDev\\XMLSitemap','XLite\\Module\\CDev\\SimpleCMS\\View\\FormField\\Select\\ChangeFrequency',400,'daily','N;'),(252,'page_priority','CDev\\XMLSitemap','XLite\\View\\FormField\\Input\\Text\\FloatInput',800,'0.5','a:3:{s:3:\"min\";i:0;s:3:\"max\";i:1;s:1:\"e\";i:1;}'),(253,'show_default_menu','CDev\\SimpleCMS','checkbox',300,'Y','N;'),(254,'welcome_changefreq','CDev\\XMLSitemap','XLite\\Module\\CDev\\XMLSitemap\\View\\FormField\\Select\\ChangeFrequency',100,'daily','N;'),(255,'category_changefreq','CDev\\XMLSitemap','XLite\\Module\\CDev\\XMLSitemap\\View\\FormField\\Select\\ChangeFrequency',200,'daily','N;'),(256,'product_changefreq','CDev\\XMLSitemap','XLite\\Module\\CDev\\XMLSitemap\\View\\FormField\\Select\\ChangeFrequency',300,'daily','N;'),(257,'welcome_priority','CDev\\XMLSitemap','XLite\\View\\FormField\\Input\\Text\\FloatInput',500,'0.5','a:3:{s:3:\"min\";i:0;s:3:\"max\";i:1;s:1:\"e\";i:1;}'),(258,'category_priority','CDev\\XMLSitemap','XLite\\View\\FormField\\Input\\Text\\FloatInput',600,'0.5','a:3:{s:3:\"min\";i:0;s:3:\"max\";i:1;s:1:\"e\";i:1;}'),(259,'product_priority','CDev\\XMLSitemap','XLite\\View\\FormField\\Input\\Text\\FloatInput',700,'0.5','a:3:{s:3:\"min\";i:0;s:3:\"max\";i:1;s:1:\"e\";i:1;}'),(260,'enable_in_stock_only_filter','XC\\ProductFilter','checkbox',100,'1','N;'),(261,'enable_price_range_filter','XC\\ProductFilter','checkbox',200,'1','N;'),(262,'enable_attributes_filter','XC\\ProductFilter','checkbox',300,'1','N;'),(263,'attributes_filter_by_category','XC\\ProductFilter','checkbox',400,'1','N;'),(264,'attributes_filter_cache_mode','XC\\ProductFilter','XLite\\Module\\XC\\ProductFilter\\View\\FormField\\Select\\CacheResetMode',500,'1','N;'),(265,'attributes_sorting_type','XC\\ProductFilter','XLite\\Module\\XC\\ProductFilter\\View\\FormField\\Select\\AttributesSortingType',600,'A','N;'),(266,'url_part_type','XC\\ProductFilter','XLite\\Module\\XC\\ProductFilter\\View\\FormField\\Select\\UrlPartType',700,'G','N;'),(267,'whoCanLeaveFeedback','XC\\Reviews','\\XLite\\Module\\XC\\Reviews\\View\\FormField\\Select\\WhoCanLeaveFeedback',10,'R','N;'),(268,'disablePendingReviews','XC\\Reviews','checkbox',20,'1','N;'),(269,'reviewsCountPerTab','XC\\Reviews','\\XLite\\View\\FormField\\Input\\Text\\Integer',30,'5','a:1:{s:3:\"min\";i:1;}'),(270,'enableCustomersFollowup','XC\\Reviews','\\XLite\\View\\FormField\\Input\\Checkbox\\OnOff',50,'','N;'),(271,'followupTimeout','XC\\Reviews','\\XLite\\View\\FormField\\Input\\Text\\Integer',60,'15','a:1:{s:3:\"min\";i:0;}'),(272,'use_custom_css','XC\\ThemeTweaker','checkbox',10,'','N;'),(273,'use_custom_js','XC\\ThemeTweaker','checkbox',20,'','N;'),(274,'userID','XC\\UPS','XLite\\View\\FormField\\Input\\Text',10,'','N;'),(275,'password','XC\\UPS','XLite\\View\\FormField\\Input\\PasswordWithValue',20,'','N;'),(276,'accessKey','XC\\UPS','XLite\\View\\FormField\\Input\\Text',30,'','N;'),(277,'shipper_number','XC\\UPS','XLite\\View\\FormField\\Input\\Text',40,'','N;'),(278,'test_mode','XC\\UPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',50,'1','N;'),(279,'additionalSettingsSeparator','XC\\UPS','separator',100,'','N;'),(280,'packageSettingsSeparator','XC\\UPS','separator',200,'','N;'),(281,'packaging_type','XC\\UPS','XLite\\Module\\XC\\UPS\\View\\FormField\\Select\\PackagingType',210,'00','N;'),(282,'dimensions','XC\\UPS','serialized',220,'a:3:{i:0;i:10;i:1;i:10;i:2;i:10;}','N;'),(283,'max_weight','XC\\UPS','XLite\\View\\FormField\\Input\\Text\\FloatInput',230,'150','N;'),(284,'serviceOptionsSeparator','XC\\UPS','separator',300,'','N;'),(285,'pickup_type','XC\\UPS','XLite\\Module\\XC\\UPS\\View\\FormField\\Select\\PickupType',310,'01','N;'),(286,'saturday_pickup','XC\\UPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',320,'','N;'),(287,'additional_handling','XC\\UPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',330,'','N;'),(288,'saturday_delivery','XC\\UPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',340,'','N;'),(289,'negotiated_rates','XC\\UPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',350,'','N;'),(290,'delivery_conf','XC\\UPS','XLite\\Module\\XC\\UPS\\View\\FormField\\Select\\DeliveryConfirmation',360,'0','N;'),(291,'extra_cover','XC\\UPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',370,'','N;'),(292,'extra_cover_value','XC\\UPS','XLite\\View\\FormField\\Input\\Text\\Price',380,'0','N;'),(293,'cacheOnDeliverySeparator','XC\\UPS','separator',400,'','N;'),(294,'currencyConversionSeparator','XC\\UPS','separator',500,'','N;'),(295,'currency_code','XC\\UPS','XLite\\View\\FormField\\Input\\Text',510,'','N;'),(296,'currency_rate','XC\\UPS','XLite\\View\\FormField\\Input\\Text\\FloatInput',520,'1','N;'),(297,'additionalOptionsSeparator','XC\\UPS','separator',600,'','N;'),(298,'debug_enabled','XC\\UPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',610,'1','N;'),(299,'top_news_length','XC\\News','XLite\\View\\FormField\\Input\\Text\\Integer',100,'5','a:1:{s:3:\"min\";i:1;}'),(300,'items_per_page','XC\\News','XLite\\View\\FormField\\Input\\Text\\Integer',200,'50','a:1:{s:3:\"min\";i:1;}'),(301,'news_changefreq','CDev\\XMLSitemap','XLite\\Module\\CDev\\XMLSitemap\\View\\FormField\\Select\\ChangeFrequency',400,'daily','N;'),(302,'news_priority','CDev\\XMLSitemap','XLite\\View\\FormField\\Input\\Text\\FloatInput',800,'0.5','a:3:{s:3:\"min\";i:0;s:3:\"max\";i:1;s:1:\"e\";i:1;}'),(303,'freight_shipping_calc_mode','XC\\FreeShipping','XLite\\Module\\XC\\FreeShipping\\View\\FormField\\FreightMode',10,'F','N;'),(304,'default_provider','XC\\Geolocation','XLite\\Module\\XC\\Geolocation\\View\\FormField\\Select\\DefaultProvider',10,'0','N;'),(305,'display_location_popup','XC\\Geolocation','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',20,'1','N;'),(306,'extended_database','XC\\Geolocation','XLite\\View\\FormField\\FileUploader\\ChunkUpload',30,'','a:2:{s:13:\"successAction\";s:11:\"geolocation\";s:10:\"extensions\";s:5:\".mmdb\";}'),(307,'current_database','XC\\Geolocation','XLite\\Module\\XC\\Geolocation\\View\\FormField\\Label\\CurrentDatabase',40,'','N;'),(308,'checkout_type','General','XLite\\Module\\XC\\FastLaneCheckout\\View\\FormField\\Select\\CheckoutType',200,'fast-lane','N;'),(309,'use_custom_colors','XC\\FroalaEditor','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',10,'','N;'),(310,'custom_colors','XC\\FroalaEditor','XLite\\Module\\XC\\FroalaEditor\\View\\FormField\\ColorPalettePicker',20,'','N;'),(311,'mailChimpSeparator','XC\\MailChimp','separator',100,'','N;'),(312,'mailChimpAPIKey','XC\\MailChimp','text',200,'','N;'),(313,'analytics360enabled','XC\\MailChimp','\\XLite\\View\\FormField\\Input\\Checkbox\\OnOff',300,'1','N;'),(314,'abandonedCartEnabled','XC\\MailChimp','\\XLite\\View\\FormField\\Input\\Checkbox\\OnOff',350,'','N;'),(315,'defaultAutomationListId','XC\\MailChimp','\\XLite\\Module\\XC\\MailChimp\\View\\FormField\\Select\\Lists',375,'','N;'),(316,'doubleOptinDisabled','XC\\MailChimp','\\XLite\\View\\FormField\\Input\\Checkbox\\OnOff',400,'','N;'),(317,'subscriptionElementType','XC\\MailChimp','XLite\\Module\\XC\\MailChimp\\View\\FormField\\Select\\ElementType',500,'checkbox','N;'),(318,'updateInterval','XC\\MailChimp','XLite\\Module\\XC\\MailChimp\\View\\FormField\\Select\\UpdateInterval',600,'never','N;'),(319,'send_coupons','XC\\MailChimp','XLite\\Module\\XC\\MailChimp\\View\\FormField\\Select\\SendCoupons',700,'all','N;'),(320,'write_key','XC\\Concierge','hidden',100,'','N;'),(321,'company_id','XC\\Concierge','hidden',200,'','N;'),(322,'user_id','XC\\Concierge','hidden',300,'','N;'),(323,'additional_config_loaded','XC\\Concierge','hidden',400,'','N;'),(324,'fcm_show_product_num','QSL\\FlyoutCategoriesMenu','checkbox',10,'N','N;'),(325,'fcm_word_wrap','QSL\\FlyoutCategoriesMenu','checkbox',20,'Y','N;'),(326,'fcm_show_triangle','QSL\\FlyoutCategoriesMenu','checkbox',30,'Y','N;'),(327,'api_key','QSL\\CloudSearch','hidden',0,'','N;'),(328,'secret_key','QSL\\CloudSearch','hidden',0,'','N;'),(329,'dashboard','QSL\\CloudSearch','\\XLite\\Module\\QSL\\CloudSearch\\View\\FormField\\Dashboard',0,'','N;'),(330,'isCloudFiltersEnabled','QSL\\CloudSearch','hidden',20,'','N;'),(331,'quantity','XC\\CustomerAttachments','\\XLite\\View\\FormField\\Input\\Text\\Integer',0,'10','a:1:{s:3:\"min\";i:0;}'),(332,'extensions','XC\\CustomerAttachments','text',0,'','a:1:{s:7:\"comment\";s:68:\"Enter file extensions separated by comma; for example, \"jpg,txt,svg\"\";}'),(333,'file_size','XC\\CustomerAttachments','\\XLite\\Module\\XC\\CustomerAttachments\\View\\FormField\\Input\\Text\\FileSizeInteger',0,'0','a:1:{s:3:\"min\";i:0;}'),(334,'create_nfo_mode','XC\\NotFinishedOrders','XLite\\Module\\XC\\NotFinishedOrders\\View\\FormField\\Select\\CreateNFOMode',5,'onFailure','N;'),(335,'clear_cart_on_order_change','XC\\NotFinishedOrders','XLite\\View\\FormField\\Select\\YesNo',10,'Y','N;'),(336,'limit_nf_order_ttl','XC\\NotFinishedOrders','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',20,'1','N;'),(337,'nf_order_ttl','XC\\NotFinishedOrders','XLite\\View\\FormField\\Input\\Text\\Integer',30,'30','N;'),(338,'allow_vendor_communication','XC\\VendorMessages','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',200,'0','N;'),(339,'show_tags_sidebar','XC\\ProductTags','checkbox',100,'','N;'),(340,'enable_tags_filter','XC\\ProductFilter','checkbox',350,'1','N;'),(341,'wizard_state','XC\\Onboarding','hidden',0,'visible','N;'),(342,'test_mode','CDev\\AustraliaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',10,'1','N;'),(343,'api_key','CDev\\AustraliaPost','XLite\\View\\FormField\\Input\\Text',20,'','N;'),(344,'packageSettingsSeparator','CDev\\AustraliaPost','separator',100,'','N;'),(345,'package_type','CDev\\AustraliaPost','',0,'Parcel','N;'),(346,'package_box_type','CDev\\AustraliaPost','XLite\\Module\\CDev\\AustraliaPost\\View\\FormField\\PackageBoxType',110,'AUS_PARCEL_TYPE_BOXED_OTH','N;'),(347,'dimensions','CDev\\AustraliaPost','serialized',120,'a:3:{i:0;i:10;i:1;i:10;i:2;i:10;}','N;'),(348,'additionalSettingsSeparator','CDev\\AustraliaPost','separator',200,'','N;'),(349,'service_option','CDev\\AustraliaPost','XLite\\Module\\CDev\\AustraliaPost\\View\\FormField\\ServiceOption',210,'AUS_SERVICE_OPTION_STANDARD','N;'),(350,'extra_cover','CDev\\AustraliaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',220,'','N;'),(351,'extra_cover_value','CDev\\AustraliaPost','XLite\\View\\FormField\\Input\\Text\\Price',230,'0','N;'),(352,'currency_rate','CDev\\AustraliaPost','XLite\\View\\FormField\\Input\\Text\\FloatInput',240,'1','N;'),(353,'enable_new_methods','CDev\\AustraliaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',250,'1','N;'),(354,'debug_enabled','CDev\\AustraliaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',260,'1','N;'),(355,'max_weight','CDev\\AustraliaPost','',0,'20','N;'),(356,'email','CDev\\Moneybookers','text',100,'','N;'),(357,'logo_url','CDev\\Moneybookers','XLite\\View\\FormField\\Input\\Text\\URL',200,'','N;'),(358,'test','CDev\\Moneybookers','checkbox',300,'0','N;'),(359,'secret_word','CDev\\Moneybookers','text',400,'','N;'),(360,'prefix','CDev\\Moneybookers','text',500,'xcart','N;'),(361,'id','CDev\\Moneybookers','',0,'','N;'),(362,'ignore_memberships','CDev\\SalesTax','checkbox',150,'Y','N;'),(363,'addressType','CDev\\SalesTax','\\XLite\\Module\\CDev\\SalesTax\\View\\FormField\\AddressType',160,'billing','N;'),(364,'taxableBase','CDev\\SalesTax','\\XLite\\Module\\CDev\\SalesTax\\View\\FormField\\TaxableBase',170,'DST+SH','N;'),(365,'dataProvider','CDev\\USPS','XLite\\Module\\CDev\\USPS\\View\\FormField\\Select\\DataProvider',2,'pitneyBowes','N;'),(366,'pbEmailId','CDev\\USPS','XLite\\View\\FormField\\Input\\Text',10,'','N;'),(367,'pbShipperId','CDev\\USPS','',10,'','N;'),(368,'userid','CDev\\USPS','XLite\\View\\FormField\\Input\\Text',10,'','N;'),(369,'server_url','CDev\\USPS','XLite\\View\\FormField\\Input\\Text\\URL',20,'http://stg-production.shippingapis.com/ShippingApi.dll','N;'),(370,'additionalSettingsSeparator','CDev\\USPS','separator',100,'','N;'),(371,'commonOptionsSeparator','CDev\\USPS','separator',200,'','N;'),(372,'package_size','CDev\\USPS','XLite\\Module\\CDev\\USPS\\View\\FormField\\Select\\PackageSize',205,'REGULAR','N;'),(373,'dimensions','CDev\\USPS','serialized',210,'a:3:{i:0;i:10;i:1;i:7;i:2;i:9;}','N;'),(374,'girth','CDev\\USPS','XLite\\View\\FormField\\Input\\Text\\FloatInput',220,'0','N;'),(375,'max_weight','CDev\\USPS','XLite\\View\\FormField\\Input\\Text\\FloatInput',230,'70','N;'),(376,'machinable','CDev\\USPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',235,'1','N;'),(377,'currency_rate','CDev\\USPS','XLite\\View\\FormField\\Input\\Text\\FloatInput',240,'1','N;'),(378,'domesticUSPSSeparator','CDev\\USPS','separator',300,'','N;'),(379,'container','CDev\\USPS','XLite\\Module\\CDev\\USPS\\View\\FormField\\Select\\Container',310,'VARIABLE','N;'),(380,'first_class_mail_type','CDev\\USPS','XLite\\Module\\CDev\\USPS\\View\\FormField\\Select\\FirstClassMailType',330,'PARCEL','N;'),(381,'use_rate_type','CDev\\USPS','XLite\\Module\\CDev\\USPS\\View\\FormField\\Select\\UseRateType',350,'Rate','N;'),(382,'pb_domestic_parcel_type','CDev\\USPS','XLite\\Module\\CDev\\USPS\\View\\FormField\\Select\\PBDomesticParcelType',360,'PKG','N;'),(383,'domestic_all_services_type','CDev\\USPS','XLite\\Module\\CDev\\USPS\\View\\FormField\\Select\\AllServicesType',370,'online','N;'),(384,'internationalUSPSSeparator','CDev\\USPS','separator',400,'','N;'),(385,'mail_type','CDev\\USPS','XLite\\Module\\CDev\\USPS\\View\\FormField\\Select\\MailType',410,'Package','N;'),(386,'container_intl','CDev\\USPS','XLite\\Module\\CDev\\USPS\\View\\FormField\\Select\\ContainerIntl',420,'RECTANGULAR','N;'),(387,'commercial','CDev\\USPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',430,'','N;'),(388,'gxg','CDev\\USPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',440,'','N;'),(389,'gxg_pobox','CDev\\USPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',450,'','N;'),(390,'gxg_gift','CDev\\USPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',460,'','N;'),(391,'pb_international_parcel_type','CDev\\USPS','XLite\\Module\\CDev\\USPS\\View\\FormField\\Select\\PBInternationalParcelType',470,'PKG','N;'),(392,'cacheOnDeliverySeparator','CDev\\USPS','separator',500,'','N;'),(393,'use_cod_price','CDev\\USPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',510,'1','N;'),(394,'cod_price','CDev\\USPS','XLite\\View\\FormField\\Input\\Text\\Price',520,'6.95','N;'),(395,'additionalOptionsSeparator','CDev\\USPS','separator',600,'','N;'),(396,'debug_enabled','CDev\\USPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',610,'','N;'),(397,'pbSandbox','CDev\\USPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',605,'','N;'),(398,'autoenable_new_methods','CDev\\USPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',620,'1','N;'),(399,'xpc_shopping_cart_id','CDev\\XPaymentsConnector','XLite\\Module\\CDev\\XPaymentsConnector\\View\\FormField\\Input\\Text\\StoreID',1010,'','N;'),(400,'xpc_xpayments_url','CDev\\XPaymentsConnector','XLite\\Module\\CDev\\XPaymentsConnector\\View\\FormField\\Input\\Text\\URLipv6',1020,'','N;'),(401,'xpc_public_key','CDev\\XPaymentsConnector','textarea',1030,'','N;'),(402,'xpc_private_key','CDev\\XPaymentsConnector','textarea',1040,'','N;'),(403,'xpc_private_key_password','CDev\\XPaymentsConnector','text',1050,'','N;'),(404,'xpc_currency','CDev\\XPaymentsConnector','XLite\\View\\FormField\\Select\\Currency',1070,'840','N;'),(405,'xpc_api_version','CDev\\XPaymentsConnector','hidden',1080,'1.3','N;'),(406,'xpc_use_iframe','CDev\\XPaymentsConnector','checkbox',1090,'1','N;'),(407,'xpc_allowed_modules_load_date','CDev\\XPaymentsConnector','hidden',2000,'0','N;'),(408,'xpc_allowed_modules','CDev\\XPaymentsConnector','hidden',2010,'','N;'),(409,'xpc_zero_auth_method_id','CDev\\XPaymentsConnector','XLite\\Module\\CDev\\XPaymentsConnector\\View\\FormField\\Select\\ZeroAuthPaymentMethods',1100,'0','N;'),(410,'xpc_zero_auth_amount','CDev\\XPaymentsConnector','XLite\\Module\\CDev\\XPaymentsConnector\\View\\FormField\\Input\\Text\\ZeroAuthAmount',1110,'0','N;'),(411,'xpc_zero_auth_description','CDev\\XPaymentsConnector','XLite\\Module\\CDev\\XPaymentsConnector\\View\\FormField\\Input\\Text\\ZeroAuthDescription',1130,'','N;'),(412,'wizard_enabled','XC\\CanadaPost','',0,'1','N;'),(413,'wizard_hash','XC\\CanadaPost','',0,'','N;'),(414,'user','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Text',10,'','N;'),(415,'password','XC\\CanadaPost','XLite\\View\\FormField\\Input\\PasswordWithValue',20,'','N;'),(416,'developer_mode','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',30,'','N;'),(417,'debug_enabled','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',40,'','N;'),(418,'additionalSettingsSeparator','XC\\CanadaPost','separator',100,'','N;'),(419,'quote_type','XC\\CanadaPost','XLite\\Module\\XC\\CanadaPost\\View\\FormField\\Select\\QuoteType',110,'C','N;'),(420,'customer_number','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Text',120,'','N;'),(421,'currency_rate','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Text\\FloatInput',130,'1','N;'),(422,'contractShippingSeparator','XC\\CanadaPost','separator',200,'','N;'),(423,'contract_id','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Text',210,'','N;'),(424,'pick_up_type','XC\\CanadaPost','XLite\\Module\\XC\\CanadaPost\\View\\FormField\\Select\\PickUpType',220,'','N;'),(425,'deposit_site_num','XC\\CanadaPost','XLite\\Module\\XC\\CanadaPost\\View\\FormField\\Input\\Text\\DepositSiteNum',230,'','N;'),(426,'detailed_manifests','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',240,'1','N;'),(427,'manifest_name','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Text',250,'','N;'),(428,'deliverToPostOfficeSeparator','XC\\CanadaPost','separator',300,'','N;'),(429,'deliver_to_po_enabled','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',310,'','N;'),(430,'max_post_offices','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Text\\Integer',320,'5','N;'),(431,'parcelCharacteristicsSeparator','XC\\CanadaPost','separator',400,'','N;'),(432,'length','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Text\\FloatInput',410,'10','N;'),(433,'width','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Text\\FloatInput',420,'9','N;'),(434,'height','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Text\\FloatInput',430,'7','N;'),(435,'max_weight','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Text\\FloatInput',440,'30','N;'),(436,'document','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',450,'','N;'),(437,'unpackaged','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',460,'','N;'),(438,'mailing_tube','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',470,'','N;'),(439,'oversized','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',480,'','N;'),(440,'parcelSeparator','XC\\CanadaPost','separator',500,'','N;'),(441,'way_to_deliver','XC\\CanadaPost','XLite\\Module\\XC\\CanadaPost\\View\\FormField\\Select\\DeliveryWayType',510,'','N;'),(442,'signature','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',520,'','N;'),(443,'age_proof','XC\\CanadaPost','XLite\\Module\\XC\\CanadaPost\\View\\FormField\\Select\\AgeProofType',530,'','N;'),(444,'coverage','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Text\\FloatInput',540,'0','N;'),(445,'non_delivery','XC\\CanadaPost','XLite\\Module\\XC\\CanadaPost\\View\\FormField\\Select\\NonDeliveryType',550,'','N;'),(446,'time_zone','General','',0,'Europe/Moscow','N;');
CREATE TABLE `xlite_order_payment_statuses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` char(4) COLLATE utf8_unicode_ci DEFAULT NULL,
  `position` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_A2C34C8E77153098` (`code`),
  KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_order_payment_statuses` VALUES (1,'Q',10),(2,'A',20),(3,'PP',30),(4,'P',40),(5,'D',50),(6,'C',60),(7,'R',70);
CREATE TABLE `xlite_permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `enabled` tinyint(1) NOT NULL,
  `code` char(32) COLLATE utf8_unicode_ci NOT NULL,
  `section` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_permissions` VALUES (1,1,'root access','All'),(2,1,'manage catalog','Catalog'),(3,1,'manage users','Users'),(4,1,'manage admins','Users'),(5,1,'manage orders','Sales'),(6,1,'manage import','Import and Export'),(7,1,'manage export','Import and Export'),(8,1,'manage banners','Content'),(9,1,'unfiltered html','Content'),(10,1,'manage coupons','Coupons'),(11,1,'manage custom pages','Content'),(12,1,'manage menus','Content'),(13,1,'manage volume discounts','Volume discounts'),(14,1,'manage reviews','Catalog'),(15,1,'manage news','Content'),(16,1,'manage conversations','Conversations');
CREATE TABLE `xlite_product_membership_links` (
  `product_id` int(10) unsigned NOT NULL,
  `membership_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`membership_id`),
  KEY `IDX_E924C4344584665A` (`product_id`),
  KEY `IDX_E924C4341FB354CD` (`membership_id`),
  CONSTRAINT `FK_E924C4341FB354CD` FOREIGN KEY (`membership_id`) REFERENCES `xlite_memberships` (`membership_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_E924C4344584665A` FOREIGN KEY (`product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_attributes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_class_id` int(10) unsigned DEFAULT NULL,
  `attribute_group_id` int(10) unsigned DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `position` int(11) NOT NULL,
  `decimals` int(11) NOT NULL,
  `type` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `addToNew` char(1) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_9665298321B06187` (`product_class_id`),
  KEY `IDX_9665298362D643B7` (`attribute_group_id`),
  KEY `IDX_966529834584665A` (`product_id`),
  CONSTRAINT `FK_966529834584665A` FOREIGN KEY (`product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_9665298321B06187` FOREIGN KEY (`product_class_id`) REFERENCES `xlite_product_classes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_9665298362D643B7` FOREIGN KEY (`attribute_group_id`) REFERENCES `xlite_attribute_groups` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_attributes` VALUES (1,1,NULL,NULL,1,0,0,'S',''),(50,NULL,NULL,NULL,1,0,0,'S',''),(56,NULL,NULL,7,1,0,0,'S',''),(58,NULL,NULL,9,1,0,0,'S',''),(61,NULL,NULL,13,1,0,0,'S',''),(62,NULL,NULL,16,1,0,0,'C',''),(63,NULL,NULL,16,1,0,0,'C',''),(64,NULL,NULL,16,1,0,0,'C',''),(65,NULL,NULL,16,1,0,0,'C',''),(66,NULL,NULL,31,1,0,0,'C',''),(67,NULL,NULL,31,1,0,0,'C',''),(68,NULL,NULL,31,1,0,0,'C',''),(69,NULL,NULL,32,1,0,0,'S',''),(70,NULL,NULL,40,1,0,0,'S',''),(71,2,NULL,NULL,1,0,0,'S',''),(72,2,NULL,NULL,1,0,0,'S',''),(73,2,NULL,NULL,1,0,0,'S',''),(74,2,NULL,NULL,0,0,0,'S',''),(75,2,1,NULL,1,0,0,'S',''),(76,2,1,NULL,1,0,0,'S',''),(77,2,1,NULL,1,0,0,'S',''),(78,2,3,NULL,0,0,0,'S',''),(79,2,3,NULL,0,0,0,'S',''),(80,2,3,NULL,0,0,0,'S',''),(81,2,3,NULL,0,0,0,'S',''),(82,2,3,NULL,0,0,0,'S',''),(83,2,2,NULL,1,0,0,'S',''),(84,2,2,NULL,1,0,0,'S',''),(85,2,2,NULL,0,0,0,'S',''),(86,2,2,NULL,1,0,0,'C',''),(87,NULL,NULL,4,1,0,0,'S','');
CREATE TABLE `xlite_order_capost_parcel_shipments_manifests` (
  `manifest_id` int(11) NOT NULL,
  `shipment_id` int(11) NOT NULL,
  PRIMARY KEY (`manifest_id`,`shipment_id`),
  KEY `IDX_8D3D4D8FE697B2FB` (`manifest_id`),
  KEY `IDX_8D3D4D8F7BE036FC` (`shipment_id`),
  CONSTRAINT `FK_8D3D4D8F7BE036FC` FOREIGN KEY (`shipment_id`) REFERENCES `xlite_order_capost_parcel_shipment` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_8D3D4D8FE697B2FB` FOREIGN KEY (`manifest_id`) REFERENCES `xlite_order_capost_parcel_manifests` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_shipping_markups` (
  `markup_id` int(11) NOT NULL AUTO_INCREMENT,
  `method_id` int(11) DEFAULT NULL,
  `zone_id` int(11) DEFAULT NULL,
  `min_weight` decimal(14,2) NOT NULL,
  `max_weight` decimal(14,2) NOT NULL,
  `min_total` decimal(14,2) NOT NULL,
  `max_total` decimal(14,2) NOT NULL,
  `min_items` decimal(14,0) NOT NULL,
  `max_items` decimal(14,0) NOT NULL,
  `markup_flat` decimal(14,2) NOT NULL,
  `markup_percent` decimal(14,2) NOT NULL,
  `markup_per_item` decimal(14,2) NOT NULL,
  `markup_per_weight` decimal(14,2) NOT NULL,
  PRIMARY KEY (`markup_id`),
  KEY `IDX_2BE8DC419883967` (`method_id`),
  KEY `IDX_2BE8DC49F2C3FAB` (`zone_id`),
  KEY `rate` (`method_id`,`zone_id`,`min_weight`,`min_total`,`min_items`),
  KEY `max_weight` (`max_weight`),
  KEY `max_total` (`max_total`),
  KEY `max_items` (`max_items`),
  KEY `markup_flat` (`markup_flat`),
  KEY `markup_per_item` (`markup_per_item`),
  KEY `markup_percent` (`markup_percent`),
  KEY `markup_per_weight` (`markup_per_weight`),
  CONSTRAINT `FK_2BE8DC49F2C3FAB` FOREIGN KEY (`zone_id`) REFERENCES `xlite_zones` (`zone_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_2BE8DC419883967` FOREIGN KEY (`method_id`) REFERENCES `xlite_shipping_methods` (`method_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_shipping_markups` VALUES (1,89,2,0.00,999999999.00,0.00,999999999.00,0,999999999,2.45,1.50,0.00,0.00),(2,89,3,0.00,999999999.00,0.00,999999999.00,0,999999999,2.50,1.50,0.00,0.00),(3,89,1,0.00,999999999.00,0.00,999999999.00,0,999999999,5.50,1.75,0.00,0.00),(4,90,2,0.00,999999999.00,0.00,999999999.00,0,999999999,3.45,1.75,0.00,0.00),(5,90,3,0.00,999999999.00,0.00,999999999.00,0,999999999,3.50,1.75,0.00,0.00),(6,90,1,0.00,999999999.00,0.00,999999999.00,0,999999999,6.50,1.85,0.00,0.00),(7,91,2,0.00,999999999.00,0.00,999999999.00,0,999999999,100.00,10.00,0.00,0.00),(8,92,1,0.00,999999999.00,0.00,999999999.00,0,999999999,0.00,0.00,0.00,0.00),(9,93,1,0.00,999999999.00,50.00,999999999.00,0,999999999,0.00,0.00,0.00,0.00),(10,94,1,0.00,999999999.00,0.00,999999999.00,0,999999999,0.00,0.00,0.00,0.00),(11,95,1,0.00,999999999.00,0.00,999999999.00,0,999999999,0.00,0.00,0.00,0.00);
CREATE TABLE `xlite_product_attachment_storages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attachment_id` int(10) unsigned DEFAULT NULL,
  `path` varchar(512) COLLATE utf8_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_34701892464E68B` (`attachment_id`),
  CONSTRAINT `FK_34701892464E68B` FOREIGN KEY (`attachment_id`) REFERENCES `xlite_product_attachments` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_order_capost_office` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `officeId` char(10) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `location` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `distance` decimal(12,2) NOT NULL,
  `bilingualDesignation` tinyint(1) NOT NULL,
  `city` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `latitude` decimal(15,5) NOT NULL,
  `longitude` decimal(15,5) NOT NULL,
  `postalCode` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `province` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `officeAddress` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `workingHours` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  `orderId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_CE3DE61FFA237437` (`orderId`),
  CONSTRAINT `FK_CE3DE61FFA237437` FOREIGN KEY (`orderId`) REFERENCES `xlite_orders` (`order_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_payment_methods` (
  `method_id` int(11) NOT NULL AUTO_INCREMENT,
  `service_name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `class` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `moduleName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `orderby` int(11) NOT NULL,
  `adminOrderby` int(11) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `moduleEnabled` tinyint(1) NOT NULL,
  `added` tinyint(1) NOT NULL,
  `type` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `fromMarketplace` tinyint(1) NOT NULL,
  `iconURL` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `countries` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:array)',
  `exCountries` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:array)',
  PRIMARY KEY (`method_id`),
  KEY `orderby` (`orderby`),
  KEY `class` (`class`,`enabled`),
  KEY `enabled` (`enabled`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_payment_methods` VALUES (1,'PurchaseOrder','Model\\Payment\\Processor\\PurchaseOrder','',20,0,0,1,1,'O',0,NULL,'N;','N;'),(2,'PhoneOrdering','Model\\Payment\\Processor\\PhoneOrdering','',30,0,1,1,1,'O',0,NULL,'N;','N;'),(3,'FaxOrdering','Model\\Payment\\Processor\\Offline','',40,0,1,1,1,'O',0,NULL,'N;','N;'),(4,'MoneyOrdering','Model\\Payment\\Processor\\Offline','',50,0,1,1,1,'O',0,NULL,'N;','N;'),(5,'Echeck','Model\\Payment\\Processor\\Check','',60,0,0,1,1,'O',0,NULL,'N;','N;'),(6,'COD','Model\\Payment\\Processor\\Offline','',70,0,1,1,1,'O',0,NULL,'N;','N;'),(7,'COD_FEDEX','Module\\CDev\\FedEx\\Model\\Payment\\Processor\\COD','CDev_FedEx',0,0,0,1,1,'O',0,NULL,'a:2:{i:0;s:2:\"CA\";i:1;s:2:\"US\";}','N;'),(8,'PayflowLink','Module\\CDev\\Paypal\\Model\\Payment\\Processor\\PayflowLink','CDev_Paypal',-10600,0,0,1,0,'C',0,NULL,'a:4:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"AU\";i:3;s:2:\"NZ\";}','N;'),(9,'PayflowTransparentRedirect','Module\\CDev\\Paypal\\Model\\Payment\\Processor\\PayflowTransparentRedirect','CDev_Paypal',-10650,0,0,1,0,'C',0,NULL,'a:4:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"AU\";i:3;s:2:\"NZ\";}','N;'),(10,'PaypalAdvanced','Module\\CDev\\Paypal\\Model\\Payment\\Processor\\PaypalAdvanced','CDev_Paypal',-10700,0,0,1,0,'C',0,NULL,'a:2:{i:0;s:2:\"US\";i:1;s:2:\"CA\";}','N;'),(11,'PaypalWPS','Module\\CDev\\Paypal\\Model\\Payment\\Processor\\PaypalWPS','CDev_Paypal',-10800,0,0,1,0,'A',0,NULL,'a:24:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"MX\";i:3;s:2:\"BE\";i:4;s:2:\"DK\";i:5;s:2:\"FR\";i:6;s:2:\"DE\";i:7;s:2:\"IE\";i:8;s:2:\"IT\";i:9;s:2:\"LU\";i:10;s:2:\"NL\";i:11;s:2:\"NO\";i:12;s:2:\"PL\";i:13;s:2:\"RU\";i:14;s:2:\"JP\";i:15;s:2:\"ES\";i:16;s:2:\"NZ\";i:17;s:2:\"BR\";i:18;s:2:\"SE\";i:19;s:2:\"GB\";i:20;s:2:\"AU\";i:21;s:2:\"CN\";i:22;s:2:\"IL\";i:23;s:2:\"SG\";}','N;'),(12,'ExpressCheckout','Module\\CDev\\Paypal\\Model\\Payment\\Processor\\ExpressCheckout','CDev_Paypal',-102000,0,0,1,1,'C',0,NULL,'a:23:{i:0;s:2:\"US\";i:1;s:2:\"MX\";i:2;s:2:\"BE\";i:3;s:2:\"DK\";i:4;s:2:\"FR\";i:5;s:2:\"DE\";i:6;s:2:\"IE\";i:7;s:2:\"IT\";i:8;s:2:\"LU\";i:9;s:2:\"NL\";i:10;s:2:\"NO\";i:11;s:2:\"PL\";i:12;s:2:\"RU\";i:13;s:2:\"JP\";i:14;s:2:\"ES\";i:15;s:2:\"NZ\";i:16;s:2:\"BR\";i:17;s:2:\"SE\";i:18;s:2:\"GB\";i:19;s:2:\"AU\";i:20;s:2:\"CN\";i:21;s:2:\"IL\";i:22;s:2:\"SG\";}','N;'),(13,'PaypalCredit','Module\\CDev\\Paypal\\Model\\Payment\\Processor\\PaypalCredit','CDev_Paypal',-11000,0,0,1,1,'C',0,NULL,'a:2:{i:0;s:2:\"US\";i:1;s:2:\"CA\";}','N;'),(14,'PaypalAdaptive','Module\\CDev\\Paypal\\Model\\Payment\\Processor\\PaypalAdaptive','CDev_Paypal',-11100,0,0,1,0,'C',0,NULL,'N;','N;'),(15,'PaypalForMarketplaces','Module\\CDev\\Paypal\\Model\\Payment\\Processor\\PaypalForMarketplaces','CDev_Paypal',-11100,0,0,1,0,'C',0,NULL,'a:27:{i:0;s:2:\"AT\";i:1;s:2:\"AU\";i:2;s:2:\"BE\";i:3;s:2:\"CA\";i:4;s:2:\"CH\";i:5;s:2:\"CZ\";i:6;s:2:\"DE\";i:7;s:2:\"DK\";i:8;s:2:\"ES\";i:9;s:2:\"FI\";i:10;s:2:\"FR\";i:11;s:2:\"GB\";i:12;s:2:\"GB\";i:13;s:2:\"GR\";i:14;s:2:\"HU\";i:15;s:2:\"IE\";i:16;s:2:\"IL\";i:17;s:2:\"IN\";i:18;s:2:\"IT\";i:19;s:2:\"NL\";i:20;s:2:\"NO\";i:21;s:2:\"PL\";i:22;s:2:\"PT\";i:23;s:2:\"RU\";i:24;s:2:\"SE\";i:25;s:2:\"SK\";i:26;s:2:\"US\";}','N;'),(16,'COD_UPS','Module\\XC\\UPS\\Model\\Payment\\Processor\\COD','XC_UPS',0,0,0,1,1,'O',0,NULL,'a:2:{i:0;s:2:\"US\";i:1;s:2:\"PR\";}','N;'),(17,'AuthorizeNet SIM','Module\\CDev\\AuthorizeNet\\Model\\Payment\\Processor\\AuthorizeNetSIM','CDev_AuthorizeNet',-101000,0,0,1,0,'C',0,NULL,'a:4:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"GB\";i:3;s:2:\"AU\";}','N;'),(18,'Moneybookers.WLT','Module\\CDev\\Moneybookers\\Model\\Payment\\Processor\\Moneybookers','CDev_Moneybookers',1010,0,0,1,0,'N',0,NULL,'a:210:{i:0;s:2:\"AX\";i:1;s:2:\"AL\";i:2;s:2:\"DZ\";i:3;s:2:\"AD\";i:4;s:2:\"AO\";i:5;s:2:\"AI\";i:6;s:2:\"AQ\";i:7;s:2:\"AG\";i:8;s:2:\"AR\";i:9;s:2:\"AM\";i:10;s:2:\"AW\";i:11;s:2:\"AU\";i:12;s:2:\"AT\";i:13;s:2:\"AZ\";i:14;s:2:\"BS\";i:15;s:2:\"BH\";i:16;s:2:\"BD\";i:17;s:2:\"BB\";i:18;s:2:\"BY\";i:19;s:2:\"BE\";i:20;s:2:\"BZ\";i:21;s:2:\"BJ\";i:22;s:2:\"BM\";i:23;s:2:\"BT\";i:24;s:2:\"BO\";i:25;s:2:\"BQ\";i:26;s:2:\"BA\";i:27;s:2:\"BV\";i:28;s:2:\"BR\";i:29;s:2:\"IO\";i:30;s:2:\"BN\";i:31;s:2:\"BG\";i:32;s:2:\"BF\";i:33;s:2:\"BI\";i:34;s:2:\"CA\";i:35;s:2:\"CV\";i:36;s:2:\"KY\";i:37;s:2:\"TD\";i:38;s:2:\"CL\";i:39;s:2:\"CN\";i:40;s:2:\"CX\";i:41;s:2:\"CC\";i:42;s:2:\"CO\";i:43;s:2:\"KM\";i:44;s:2:\"CG\";i:45;s:2:\"CG\";i:46;s:2:\"CK\";i:47;s:2:\"CR\";i:48;s:2:\"HR\";i:49;s:2:\"CW\";i:50;s:2:\"CY\";i:51;s:2:\"CZ\";i:52;s:2:\"DK\";i:53;s:2:\"DJ\";i:54;s:2:\"DM\";i:55;s:2:\"DO\";i:56;s:2:\"EC\";i:57;s:2:\"EG\";i:58;s:2:\"SV\";i:59;s:2:\"GQ\";i:60;s:2:\"ER\";i:61;s:2:\"EE\";i:62;s:2:\"ET\";i:63;s:2:\"FK\";i:64;s:2:\"FJ\";i:65;s:2:\"FI\";i:66;s:2:\"FR\";i:67;s:2:\"PF\";i:68;s:2:\"TF\";i:69;s:2:\"GM\";i:70;s:2:\"GE\";i:71;s:2:\"DE\";i:72;s:2:\"GH\";i:73;s:2:\"GI\";i:74;s:2:\"GR\";i:75;s:2:\"GD\";i:76;s:2:\"GU\";i:77;s:2:\"GT\";i:78;s:2:\"GG\";i:79;s:2:\"GY\";i:80;s:2:\"HT\";i:81;s:2:\"HM\";i:82;s:2:\"HN\";i:83;s:2:\"HK\";i:84;s:2:\"HU\";i:85;s:2:\"IS\";i:86;s:2:\"IN\";i:87;s:2:\"ID\";i:88;s:2:\"IE\";i:89;s:2:\"IM\";i:90;s:2:\"IL\";i:91;s:2:\"IT\";i:92;s:2:\"JP\";i:93;s:2:\"JE\";i:94;s:2:\"JO\";i:95;s:2:\"KZ\";i:96;s:2:\"KE\";i:97;s:2:\"KI\";i:98;s:2:\"KR\";i:99;s:2:\"XK\";i:100;s:2:\"KW\";i:101;s:2:\"KG\";i:102;s:2:\"LA\";i:103;s:2:\"LV\";i:104;s:2:\"LB\";i:105;s:2:\"LS\";i:106;s:2:\"LR\";i:107;s:2:\"LY\";i:108;s:2:\"LI\";i:109;s:2:\"LT\";i:110;s:2:\"LU\";i:111;s:2:\"MO\";i:112;s:2:\"MK\";i:113;s:2:\"MG\";i:114;s:2:\"MW\";i:115;s:2:\"MY\";i:116;s:2:\"MT\";i:117;s:2:\"MH\";i:118;s:2:\"MQ\";i:119;s:2:\"MR\";i:120;s:2:\"MU\";i:121;s:2:\"YT\";i:122;s:2:\"MX\";i:123;s:2:\"FM\";i:124;s:2:\"MD\";i:125;s:2:\"MC\";i:126;s:2:\"MN\";i:127;s:2:\"ME\";i:128;s:2:\"MS\";i:129;s:2:\"MA\";i:130;s:2:\"NR\";i:131;s:2:\"NP\";i:132;s:2:\"NL\";i:133;s:2:\"AN\";i:134;s:2:\"NZ\";i:135;s:2:\"NI\";i:136;s:2:\"NE\";i:137;s:2:\"NG\";i:138;s:2:\"NU\";i:139;s:2:\"NF\";i:140;s:2:\"NO\";i:141;s:2:\"OM\";i:142;s:2:\"PK\";i:143;s:2:\"PW\";i:144;s:2:\"PS\";i:145;s:2:\"PA\";i:146;s:2:\"PG\";i:147;s:2:\"PY\";i:148;s:2:\"PE\";i:149;s:2:\"PH\";i:150;s:2:\"PN\";i:151;s:2:\"PL\";i:152;s:2:\"PT\";i:153;s:2:\"PR\";i:154;s:2:\"QA\";i:155;s:2:\"RO\";i:156;s:2:\"RU\";i:157;s:2:\"SH\";i:158;s:2:\"KN\";i:159;s:2:\"LC\";i:160;s:2:\"PM\";i:161;s:2:\"VC\";i:162;s:2:\"WS\";i:163;s:2:\"SM\";i:164;s:2:\"ST\";i:165;s:2:\"SA\";i:166;s:2:\"RS\";i:167;s:2:\"SC\";i:168;s:2:\"SL\";i:169;s:2:\"SG\";i:170;s:2:\"SX\";i:171;s:2:\"SK\";i:172;s:2:\"SI\";i:173;s:2:\"SB\";i:174;s:2:\"SO\";i:175;s:2:\"ZA\";i:176;s:2:\"GS\";i:177;s:2:\"ES\";i:178;s:2:\"LK\";i:179;s:2:\"SR\";i:180;s:2:\"SJ\";i:181;s:2:\"SE\";i:182;s:2:\"CH\";i:183;s:2:\"TW\";i:184;s:2:\"TZ\";i:185;s:2:\"TH\";i:186;s:2:\"TG\";i:187;s:2:\"TK\";i:188;s:2:\"TO\";i:189;s:2:\"TT\";i:190;s:2:\"TN\";i:191;s:2:\"TM\";i:192;s:2:\"TC\";i:193;s:2:\"TV\";i:194;s:2:\"UA\";i:195;s:2:\"AE\";i:196;s:2:\"GB\";i:197;s:2:\"UY\";i:198;s:2:\"UZ\";i:199;s:2:\"VU\";i:200;s:2:\"VA\";i:201;s:2:\"VE\";i:202;s:2:\"VN\";i:203;s:2:\"VG\";i:204;s:2:\"VI\";i:205;s:2:\"WF\";i:206;s:2:\"EH\";i:207;s:2:\"YE\";i:208;s:2:\"ZM\";i:209;s:2:\"ZW\";}','N;'),(19,'Moneybookers.NTL','Module\\CDev\\Moneybookers\\Model\\Payment\\Processor\\Moneybookers','CDev_Moneybookers',1010,0,0,1,0,'N',0,NULL,'N;','a:43:{i:0;s:2:\"AF\";i:1;s:2:\"AM\";i:2;s:2:\"BT\";i:3;s:2:\"BV\";i:4;s:2:\"MM\";i:5;s:2:\"CN\";i:6;s:2:\"CK\";i:7;s:2:\"CU\";i:8;s:2:\"ER\";i:9;s:2:\"GS\";i:10;s:2:\"GU\";i:11;s:2:\"GN\";i:12;s:2:\"IQ\";i:13;s:2:\"KZ\";i:14;s:2:\"KG\";i:15;s:2:\"LR\";i:16;s:2:\"LY\";i:17;s:2:\"MN\";i:18;s:2:\"MP\";i:19;s:2:\"MH\";i:20;s:2:\"PW\";i:21;s:2:\"PK\";i:22;s:2:\"PR\";i:23;s:2:\"SL\";i:24;s:2:\"SO\";i:25;s:2:\"ZW\";i:26;s:2:\"SD\";i:27;s:2:\"TJ\";i:28;s:2:\"TM\";i:29;s:2:\"UG\";i:30;s:2:\"US\";i:31;s:2:\"UZ\";i:32;s:2:\"YE\";i:33;s:2:\"CC\";i:34;s:2:\"CD\";i:35;s:2:\"HM\";i:36;s:2:\"IR\";i:37;s:2:\"CI\";i:38;s:2:\"KP\";i:39;s:2:\"FM\";i:40;s:2:\"TL\";i:41;s:2:\"SY\";i:42;s:2:\"VI\";}'),(20,'Moneybookers.PSC','Module\\CDev\\Moneybookers\\Model\\Payment\\Processor\\Moneybookers','CDev_Moneybookers',1010,0,0,1,0,'N',0,NULL,'a:35:{i:0;s:2:\"AS\";i:1;s:2:\"AT\";i:2;s:2:\"BE\";i:3;s:2:\"CA\";i:4;s:2:\"HR\";i:5;s:2:\"CY\";i:6;s:2:\"CZ\";i:7;s:2:\"DK\";i:8;s:2:\"FI\";i:9;s:2:\"FR\";i:10;s:2:\"DE\";i:11;s:2:\"GU\";i:12;s:2:\"HU\";i:13;s:2:\"IE\";i:14;s:2:\"IT\";i:15;s:2:\"LV\";i:16;s:2:\"LU\";i:17;s:2:\"MT\";i:18;s:2:\"MX\";i:19;s:2:\"NL\";i:20;s:2:\"MP\";i:21;s:2:\"NO\";i:22;s:2:\"PL\";i:23;s:2:\"PT\";i:24;s:2:\"PR\";i:25;s:2:\"RO\";i:26;s:2:\"SK\";i:27;s:2:\"SI\";i:28;s:2:\"ES\";i:29;s:2:\"SE\";i:30;s:2:\"CH\";i:31;s:2:\"TR\";i:32;s:2:\"GB\";i:33;s:2:\"US\";i:34;s:2:\"VI\";}','N;'),(21,'Moneybookers.RSB','Module\\CDev\\Moneybookers\\Model\\Payment\\Processor\\Moneybookers','CDev_Moneybookers',1010,0,0,1,0,'N',0,NULL,'a:4:{i:0;s:2:\"SE\";i:1;s:2:\"NO\";i:2;s:2:\"FI\";i:3;s:2:\"DK\";}','N;'),(22,'Moneybookers.ACC','Module\\CDev\\Moneybookers\\Model\\Payment\\Processor\\Moneybookers','CDev_Moneybookers',1020,0,0,1,0,'C',0,NULL,'a:231:{i:0;s:2:\"AX\";i:1;s:2:\"CX\";i:2;s:2:\"GN\";i:3;s:2:\"AL\";i:4;s:2:\"CC\";i:5;s:2:\"GW\";i:6;s:2:\"DZ\";i:7;s:2:\"CD\";i:8;s:2:\"GY\";i:9;s:2:\"AS\";i:10;s:2:\"CK\";i:11;s:2:\"HT\";i:12;s:2:\"AD\";i:13;s:2:\"CR\";i:14;s:2:\"HM\";i:15;s:2:\"AO\";i:16;s:2:\"CO\";i:17;s:2:\"VA\";i:18;s:2:\"AI\";i:19;s:2:\"KM\";i:20;s:2:\"HN\";i:21;s:2:\"AQ\";i:22;s:2:\"CD\";i:23;s:2:\"HK\";i:24;s:2:\"AG\";i:25;s:2:\"CI\";i:26;s:2:\"HU\";i:27;s:2:\"AR\";i:28;s:2:\"HR\";i:29;s:2:\"IS\";i:30;s:2:\"AM\";i:31;s:2:\"CY\";i:32;s:2:\"IN\";i:33;s:2:\"AW\";i:34;s:2:\"CZ\";i:35;s:2:\"ID\";i:36;s:2:\"AU\";i:37;s:2:\"DK\";i:38;s:2:\"IE\";i:39;s:2:\"AT\";i:40;s:2:\"DJ\";i:41;s:2:\"IM\";i:42;s:2:\"AZ\";i:43;s:2:\"DM\";i:44;s:2:\"IL\";i:45;s:2:\"BS\";i:46;s:2:\"DO\";i:47;s:2:\"IT\";i:48;s:2:\"BH\";i:49;s:2:\"EC\";i:50;s:2:\"JM\";i:51;s:2:\"BD\";i:52;s:2:\"EG\";i:53;s:2:\"JP\";i:54;s:2:\"BB\";i:55;s:2:\"SV\";i:56;s:2:\"JE\";i:57;s:2:\"BY\";i:58;s:2:\"GQ\";i:59;s:2:\"JO\";i:60;s:2:\"BE\";i:61;s:2:\"EE\";i:62;s:2:\"KZ\";i:63;s:2:\"BZ\";i:64;s:2:\"ET\";i:65;s:2:\"KE\";i:66;s:2:\"BJ\";i:67;s:2:\"FK\";i:68;s:2:\"KI\";i:69;s:2:\"BM\";i:70;s:2:\"FO\";i:71;s:2:\"KR\";i:72;s:2:\"BT\";i:73;s:2:\"FJ\";i:74;s:2:\"KW\";i:75;s:2:\"BO\";i:76;s:2:\"FI\";i:77;s:2:\"LA\";i:78;s:2:\"BA\";i:79;s:2:\"GG\";i:80;s:2:\"LV\";i:81;s:2:\"BW\";i:82;s:2:\"FR\";i:83;s:2:\"LB\";i:84;s:2:\"BV\";i:85;s:2:\"GF\";i:86;s:2:\"LS\";i:87;s:2:\"BR\";i:88;s:2:\"PF\";i:89;s:2:\"LR\";i:90;s:2:\"BN\";i:91;s:2:\"TF\";i:92;s:2:\"LI\";i:93;s:2:\"BG\";i:94;s:2:\"GA\";i:95;s:2:\"LT\";i:96;s:2:\"BF\";i:97;s:2:\"GM\";i:98;s:2:\"LU\";i:99;s:2:\"BI\";i:100;s:2:\"GE\";i:101;s:2:\"MO\";i:102;s:2:\"KH\";i:103;s:2:\"DE\";i:104;s:2:\"MK\";i:105;s:2:\"CM\";i:106;s:2:\"GH\";i:107;s:2:\"MG\";i:108;s:2:\"CA\";i:109;s:2:\"GI\";i:110;s:2:\"MW\";i:111;s:2:\"CV\";i:112;s:2:\"GR\";i:113;s:2:\"MY\";i:114;s:2:\"KY\";i:115;s:2:\"GL\";i:116;s:2:\"SE\";i:117;s:2:\"CF\";i:118;s:2:\"GD\";i:119;s:2:\"CH\";i:120;s:2:\"TD\";i:121;s:2:\"GP\";i:122;s:2:\"TW\";i:123;s:2:\"CL\";i:124;s:2:\"GU\";i:125;s:2:\"TJ\";i:126;s:2:\"CN\";i:127;s:2:\"GT\";i:128;s:2:\"TZ\";i:129;s:2:\"MV\";i:130;s:2:\"PE\";i:131;s:2:\"TH\";i:132;s:2:\"ML\";i:133;s:2:\"PH\";i:134;s:2:\"TL\";i:135;s:2:\"MT\";i:136;s:2:\"PN\";i:137;s:2:\"TG\";i:138;s:2:\"MH\";i:139;s:2:\"PL\";i:140;s:2:\"TK\";i:141;s:2:\"MQ\";i:142;s:2:\"PT\";i:143;s:2:\"TO\";i:144;s:2:\"MR\";i:145;s:2:\"PR\";i:146;s:2:\"TT\";i:147;s:2:\"MU\";i:148;s:2:\"QA\";i:149;s:2:\"TN\";i:150;s:2:\"YT\";i:151;s:2:\"RE\";i:152;s:2:\"TR\";i:153;s:2:\"MX\";i:154;s:2:\"RO\";i:155;s:2:\"TM\";i:156;s:2:\"FM\";i:157;s:2:\"RU\";i:158;s:2:\"TC\";i:159;s:2:\"MD\";i:160;s:2:\"RW\";i:161;s:2:\"TV\";i:162;s:2:\"MC\";i:163;s:2:\"SH\";i:164;s:2:\"UG\";i:165;s:2:\"MN\";i:166;s:2:\"KN\";i:167;s:2:\"UA\";i:168;s:2:\"ME\";i:169;s:2:\"LC\";i:170;s:2:\"AE\";i:171;s:2:\"MS\";i:172;s:2:\"PM\";i:173;s:2:\"GB\";i:174;s:2:\"MA\";i:175;s:2:\"VC\";i:176;s:2:\"US\";i:177;s:2:\"MZ\";i:178;s:2:\"WS\";i:179;s:2:\"UY\";i:180;s:2:\"MM\";i:181;s:2:\"SM\";i:182;s:2:\"UZ\";i:183;s:2:\"NA\";i:184;s:2:\"ST\";i:185;s:2:\"VU\";i:186;s:2:\"NP\";i:187;s:2:\"SA\";i:188;s:2:\"VE\";i:189;s:2:\"NL\";i:190;s:2:\"SN\";i:191;s:2:\"VN\";i:192;s:2:\"AN\";i:193;s:2:\"RS\";i:194;s:2:\"VG\";i:195;s:2:\"NC\";i:196;s:2:\"SC\";i:197;s:2:\"VI\";i:198;s:2:\"NZ\";i:199;s:2:\"SL\";i:200;s:2:\"WF\";i:201;s:2:\"NI\";i:202;s:2:\"SG\";i:203;s:2:\"EH\";i:204;s:2:\"NE\";i:205;s:2:\"SK\";i:206;s:2:\"YE\";i:207;s:2:\"NG\";i:208;s:2:\"SI\";i:209;s:2:\"ZM\";i:210;s:2:\"NU\";i:211;s:2:\"SB\";i:212;s:2:\"ZW\";i:213;s:2:\"NF\";i:214;s:2:\"SO\";i:215;s:2:\"MP\";i:216;s:2:\"ZA\";i:217;s:2:\"NO\";i:218;s:2:\"GS\";i:219;s:2:\"OM\";i:220;s:2:\"ES\";i:221;s:2:\"PK\";i:222;s:2:\"LK\";i:223;s:2:\"PW\";i:224;s:2:\"SR\";i:225;s:2:\"PS\";i:226;s:2:\"SJ\";i:227;s:2:\"PA\";i:228;s:2:\"SZ\";i:229;s:2:\"PG\";i:230;s:2:\"PY\";}','N;'),(23,'Moneybookers.VSA','Module\\CDev\\Moneybookers\\Model\\Payment\\Processor\\Moneybookers','CDev_Moneybookers',1030,0,0,1,0,'C',0,NULL,'a:210:{i:0;s:2:\"AX\";i:1;s:2:\"AL\";i:2;s:2:\"DZ\";i:3;s:2:\"AD\";i:4;s:2:\"AO\";i:5;s:2:\"AI\";i:6;s:2:\"AQ\";i:7;s:2:\"AG\";i:8;s:2:\"AR\";i:9;s:2:\"AM\";i:10;s:2:\"AW\";i:11;s:2:\"AU\";i:12;s:2:\"AT\";i:13;s:2:\"AZ\";i:14;s:2:\"BS\";i:15;s:2:\"BH\";i:16;s:2:\"BD\";i:17;s:2:\"BB\";i:18;s:2:\"BY\";i:19;s:2:\"BE\";i:20;s:2:\"BZ\";i:21;s:2:\"BJ\";i:22;s:2:\"BM\";i:23;s:2:\"BT\";i:24;s:2:\"BO\";i:25;s:2:\"BQ\";i:26;s:2:\"BA\";i:27;s:2:\"BV\";i:28;s:2:\"BR\";i:29;s:2:\"IO\";i:30;s:2:\"BN\";i:31;s:2:\"BG\";i:32;s:2:\"BF\";i:33;s:2:\"BI\";i:34;s:2:\"CA\";i:35;s:2:\"CV\";i:36;s:2:\"KY\";i:37;s:2:\"TD\";i:38;s:2:\"CL\";i:39;s:2:\"CN\";i:40;s:2:\"CX\";i:41;s:2:\"CC\";i:42;s:2:\"CO\";i:43;s:2:\"KM\";i:44;s:2:\"CG\";i:45;s:2:\"CG\";i:46;s:2:\"CK\";i:47;s:2:\"CR\";i:48;s:2:\"HR\";i:49;s:2:\"CW\";i:50;s:2:\"CY\";i:51;s:2:\"CZ\";i:52;s:2:\"DK\";i:53;s:2:\"DJ\";i:54;s:2:\"DM\";i:55;s:2:\"DO\";i:56;s:2:\"EC\";i:57;s:2:\"EG\";i:58;s:2:\"SV\";i:59;s:2:\"GQ\";i:60;s:2:\"ER\";i:61;s:2:\"EE\";i:62;s:2:\"ET\";i:63;s:2:\"FK\";i:64;s:2:\"FJ\";i:65;s:2:\"FI\";i:66;s:2:\"FR\";i:67;s:2:\"PF\";i:68;s:2:\"TF\";i:69;s:2:\"GM\";i:70;s:2:\"GE\";i:71;s:2:\"DE\";i:72;s:2:\"GH\";i:73;s:2:\"GI\";i:74;s:2:\"GR\";i:75;s:2:\"GD\";i:76;s:2:\"GU\";i:77;s:2:\"GT\";i:78;s:2:\"GG\";i:79;s:2:\"GY\";i:80;s:2:\"HT\";i:81;s:2:\"HM\";i:82;s:2:\"HN\";i:83;s:2:\"HK\";i:84;s:2:\"HU\";i:85;s:2:\"IS\";i:86;s:2:\"IN\";i:87;s:2:\"ID\";i:88;s:2:\"IE\";i:89;s:2:\"IM\";i:90;s:2:\"IL\";i:91;s:2:\"IT\";i:92;s:2:\"JP\";i:93;s:2:\"JE\";i:94;s:2:\"JO\";i:95;s:2:\"KZ\";i:96;s:2:\"KE\";i:97;s:2:\"KI\";i:98;s:2:\"KR\";i:99;s:2:\"XK\";i:100;s:2:\"KW\";i:101;s:2:\"KG\";i:102;s:2:\"LA\";i:103;s:2:\"LV\";i:104;s:2:\"LB\";i:105;s:2:\"LS\";i:106;s:2:\"LR\";i:107;s:2:\"LY\";i:108;s:2:\"LI\";i:109;s:2:\"LT\";i:110;s:2:\"LU\";i:111;s:2:\"MO\";i:112;s:2:\"MK\";i:113;s:2:\"MG\";i:114;s:2:\"MW\";i:115;s:2:\"MY\";i:116;s:2:\"MT\";i:117;s:2:\"MH\";i:118;s:2:\"MQ\";i:119;s:2:\"MR\";i:120;s:2:\"MU\";i:121;s:2:\"YT\";i:122;s:2:\"MX\";i:123;s:2:\"FM\";i:124;s:2:\"MD\";i:125;s:2:\"MC\";i:126;s:2:\"MN\";i:127;s:2:\"ME\";i:128;s:2:\"MS\";i:129;s:2:\"MA\";i:130;s:2:\"NR\";i:131;s:2:\"NP\";i:132;s:2:\"NL\";i:133;s:2:\"AN\";i:134;s:2:\"NZ\";i:135;s:2:\"NI\";i:136;s:2:\"NE\";i:137;s:2:\"NG\";i:138;s:2:\"NU\";i:139;s:2:\"NF\";i:140;s:2:\"NO\";i:141;s:2:\"OM\";i:142;s:2:\"PK\";i:143;s:2:\"PW\";i:144;s:2:\"PS\";i:145;s:2:\"PA\";i:146;s:2:\"PG\";i:147;s:2:\"PY\";i:148;s:2:\"PE\";i:149;s:2:\"PH\";i:150;s:2:\"PN\";i:151;s:2:\"PL\";i:152;s:2:\"PT\";i:153;s:2:\"PR\";i:154;s:2:\"QA\";i:155;s:2:\"RO\";i:156;s:2:\"RU\";i:157;s:2:\"SH\";i:158;s:2:\"KN\";i:159;s:2:\"LC\";i:160;s:2:\"PM\";i:161;s:2:\"VC\";i:162;s:2:\"WS\";i:163;s:2:\"SM\";i:164;s:2:\"ST\";i:165;s:2:\"SA\";i:166;s:2:\"RS\";i:167;s:2:\"SC\";i:168;s:2:\"SL\";i:169;s:2:\"SG\";i:170;s:2:\"SX\";i:171;s:2:\"SK\";i:172;s:2:\"SI\";i:173;s:2:\"SB\";i:174;s:2:\"SO\";i:175;s:2:\"ZA\";i:176;s:2:\"GS\";i:177;s:2:\"ES\";i:178;s:2:\"LK\";i:179;s:2:\"SR\";i:180;s:2:\"SJ\";i:181;s:2:\"SE\";i:182;s:2:\"CH\";i:183;s:2:\"TW\";i:184;s:2:\"TZ\";i:185;s:2:\"TH\";i:186;s:2:\"TG\";i:187;s:2:\"TK\";i:188;s:2:\"TO\";i:189;s:2:\"TT\";i:190;s:2:\"TN\";i:191;s:2:\"TM\";i:192;s:2:\"TC\";i:193;s:2:\"TV\";i:194;s:2:\"UA\";i:195;s:2:\"AE\";i:196;s:2:\"GB\";i:197;s:2:\"UY\";i:198;s:2:\"UZ\";i:199;s:2:\"VU\";i:200;s:2:\"VA\";i:201;s:2:\"VE\";i:202;s:2:\"VN\";i:203;s:2:\"VG\";i:204;s:2:\"VI\";i:205;s:2:\"WF\";i:206;s:2:\"EH\";i:207;s:2:\"YE\";i:208;s:2:\"ZM\";i:209;s:2:\"ZW\";}','N;'),(24,'Moneybookers.MSC','Module\\CDev\\Moneybookers\\Model\\Payment\\Processor\\Moneybookers','CDev_Moneybookers',1040,0,0,1,0,'C',0,NULL,'a:231:{i:0;s:2:\"AX\";i:1;s:2:\"CX\";i:2;s:2:\"GN\";i:3;s:2:\"AL\";i:4;s:2:\"CC\";i:5;s:2:\"GW\";i:6;s:2:\"DZ\";i:7;s:2:\"CD\";i:8;s:2:\"GY\";i:9;s:2:\"AS\";i:10;s:2:\"CK\";i:11;s:2:\"HT\";i:12;s:2:\"AD\";i:13;s:2:\"CR\";i:14;s:2:\"HM\";i:15;s:2:\"AO\";i:16;s:2:\"CO\";i:17;s:2:\"VA\";i:18;s:2:\"AI\";i:19;s:2:\"KM\";i:20;s:2:\"HN\";i:21;s:2:\"AQ\";i:22;s:2:\"CD\";i:23;s:2:\"HK\";i:24;s:2:\"AG\";i:25;s:2:\"CI\";i:26;s:2:\"HU\";i:27;s:2:\"AR\";i:28;s:2:\"HR\";i:29;s:2:\"IS\";i:30;s:2:\"AM\";i:31;s:2:\"CY\";i:32;s:2:\"IN\";i:33;s:2:\"AW\";i:34;s:2:\"CZ\";i:35;s:2:\"ID\";i:36;s:2:\"AU\";i:37;s:2:\"DK\";i:38;s:2:\"IE\";i:39;s:2:\"AT\";i:40;s:2:\"DJ\";i:41;s:2:\"IM\";i:42;s:2:\"AZ\";i:43;s:2:\"DM\";i:44;s:2:\"IL\";i:45;s:2:\"BS\";i:46;s:2:\"DO\";i:47;s:2:\"IT\";i:48;s:2:\"BH\";i:49;s:2:\"EC\";i:50;s:2:\"JM\";i:51;s:2:\"BD\";i:52;s:2:\"EG\";i:53;s:2:\"JP\";i:54;s:2:\"BB\";i:55;s:2:\"SV\";i:56;s:2:\"JE\";i:57;s:2:\"BY\";i:58;s:2:\"GQ\";i:59;s:2:\"JO\";i:60;s:2:\"BE\";i:61;s:2:\"EE\";i:62;s:2:\"KZ\";i:63;s:2:\"BZ\";i:64;s:2:\"ET\";i:65;s:2:\"KE\";i:66;s:2:\"BJ\";i:67;s:2:\"FK\";i:68;s:2:\"KI\";i:69;s:2:\"BM\";i:70;s:2:\"FO\";i:71;s:2:\"KR\";i:72;s:2:\"BT\";i:73;s:2:\"FJ\";i:74;s:2:\"KW\";i:75;s:2:\"BO\";i:76;s:2:\"FI\";i:77;s:2:\"LA\";i:78;s:2:\"BA\";i:79;s:2:\"GG\";i:80;s:2:\"LV\";i:81;s:2:\"BW\";i:82;s:2:\"FR\";i:83;s:2:\"LB\";i:84;s:2:\"BV\";i:85;s:2:\"GF\";i:86;s:2:\"LS\";i:87;s:2:\"BR\";i:88;s:2:\"PF\";i:89;s:2:\"LR\";i:90;s:2:\"BN\";i:91;s:2:\"TF\";i:92;s:2:\"LI\";i:93;s:2:\"BG\";i:94;s:2:\"GA\";i:95;s:2:\"LT\";i:96;s:2:\"BF\";i:97;s:2:\"GM\";i:98;s:2:\"LU\";i:99;s:2:\"BI\";i:100;s:2:\"GE\";i:101;s:2:\"MO\";i:102;s:2:\"KH\";i:103;s:2:\"DE\";i:104;s:2:\"MK\";i:105;s:2:\"CM\";i:106;s:2:\"GH\";i:107;s:2:\"MG\";i:108;s:2:\"CA\";i:109;s:2:\"GI\";i:110;s:2:\"MW\";i:111;s:2:\"CV\";i:112;s:2:\"GR\";i:113;s:2:\"MY\";i:114;s:2:\"KY\";i:115;s:2:\"GL\";i:116;s:2:\"SE\";i:117;s:2:\"CF\";i:118;s:2:\"GD\";i:119;s:2:\"CH\";i:120;s:2:\"TD\";i:121;s:2:\"GP\";i:122;s:2:\"TW\";i:123;s:2:\"CL\";i:124;s:2:\"GU\";i:125;s:2:\"TJ\";i:126;s:2:\"CN\";i:127;s:2:\"GT\";i:128;s:2:\"TZ\";i:129;s:2:\"MV\";i:130;s:2:\"PE\";i:131;s:2:\"TH\";i:132;s:2:\"ML\";i:133;s:2:\"PH\";i:134;s:2:\"TL\";i:135;s:2:\"MT\";i:136;s:2:\"PN\";i:137;s:2:\"TG\";i:138;s:2:\"MH\";i:139;s:2:\"PL\";i:140;s:2:\"TK\";i:141;s:2:\"MQ\";i:142;s:2:\"PT\";i:143;s:2:\"TO\";i:144;s:2:\"MR\";i:145;s:2:\"PR\";i:146;s:2:\"TT\";i:147;s:2:\"MU\";i:148;s:2:\"QA\";i:149;s:2:\"TN\";i:150;s:2:\"YT\";i:151;s:2:\"RE\";i:152;s:2:\"TR\";i:153;s:2:\"MX\";i:154;s:2:\"RO\";i:155;s:2:\"TM\";i:156;s:2:\"FM\";i:157;s:2:\"RU\";i:158;s:2:\"TC\";i:159;s:2:\"MD\";i:160;s:2:\"RW\";i:161;s:2:\"TV\";i:162;s:2:\"MC\";i:163;s:2:\"SH\";i:164;s:2:\"UG\";i:165;s:2:\"MN\";i:166;s:2:\"KN\";i:167;s:2:\"UA\";i:168;s:2:\"ME\";i:169;s:2:\"LC\";i:170;s:2:\"AE\";i:171;s:2:\"MS\";i:172;s:2:\"PM\";i:173;s:2:\"GB\";i:174;s:2:\"MA\";i:175;s:2:\"VC\";i:176;s:2:\"US\";i:177;s:2:\"MZ\";i:178;s:2:\"WS\";i:179;s:2:\"UY\";i:180;s:2:\"MM\";i:181;s:2:\"SM\";i:182;s:2:\"UZ\";i:183;s:2:\"NA\";i:184;s:2:\"ST\";i:185;s:2:\"VU\";i:186;s:2:\"NP\";i:187;s:2:\"SA\";i:188;s:2:\"VE\";i:189;s:2:\"NL\";i:190;s:2:\"SN\";i:191;s:2:\"VN\";i:192;s:2:\"AN\";i:193;s:2:\"RS\";i:194;s:2:\"VG\";i:195;s:2:\"NC\";i:196;s:2:\"SC\";i:197;s:2:\"VI\";i:198;s:2:\"NZ\";i:199;s:2:\"SL\";i:200;s:2:\"WF\";i:201;s:2:\"NI\";i:202;s:2:\"SG\";i:203;s:2:\"EH\";i:204;s:2:\"NE\";i:205;s:2:\"SK\";i:206;s:2:\"YE\";i:207;s:2:\"NG\";i:208;s:2:\"SI\";i:209;s:2:\"ZM\";i:210;s:2:\"NU\";i:211;s:2:\"SB\";i:212;s:2:\"ZW\";i:213;s:2:\"NF\";i:214;s:2:\"SO\";i:215;s:2:\"MP\";i:216;s:2:\"ZA\";i:217;s:2:\"NO\";i:218;s:2:\"GS\";i:219;s:2:\"OM\";i:220;s:2:\"ES\";i:221;s:2:\"PK\";i:222;s:2:\"LK\";i:223;s:2:\"PW\";i:224;s:2:\"SR\";i:225;s:2:\"PS\";i:226;s:2:\"SJ\";i:227;s:2:\"PA\";i:228;s:2:\"SZ\";i:229;s:2:\"PG\";i:230;s:2:\"PY\";}','N;'),(25,'Moneybookers.VSD','Module\\CDev\\Moneybookers\\Model\\Payment\\Processor\\Moneybookers','CDev_Moneybookers',1050,0,0,1,0,'C',0,NULL,'a:4:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"GB\";i:3;s:2:\"DE\";}','N;'),(26,'Moneybookers.VSE','Module\\CDev\\Moneybookers\\Model\\Payment\\Processor\\Moneybookers','CDev_Moneybookers',1060,0,0,1,0,'C',0,NULL,'a:210:{i:0;s:2:\"AX\";i:1;s:2:\"AL\";i:2;s:2:\"DZ\";i:3;s:2:\"AD\";i:4;s:2:\"AO\";i:5;s:2:\"AI\";i:6;s:2:\"AQ\";i:7;s:2:\"AG\";i:8;s:2:\"AR\";i:9;s:2:\"AM\";i:10;s:2:\"AW\";i:11;s:2:\"AU\";i:12;s:2:\"AT\";i:13;s:2:\"AZ\";i:14;s:2:\"BS\";i:15;s:2:\"BH\";i:16;s:2:\"BD\";i:17;s:2:\"BB\";i:18;s:2:\"BY\";i:19;s:2:\"BE\";i:20;s:2:\"BZ\";i:21;s:2:\"BJ\";i:22;s:2:\"BM\";i:23;s:2:\"BT\";i:24;s:2:\"BO\";i:25;s:2:\"BQ\";i:26;s:2:\"BA\";i:27;s:2:\"BV\";i:28;s:2:\"BR\";i:29;s:2:\"IO\";i:30;s:2:\"BN\";i:31;s:2:\"BG\";i:32;s:2:\"BF\";i:33;s:2:\"BI\";i:34;s:2:\"CA\";i:35;s:2:\"CV\";i:36;s:2:\"KY\";i:37;s:2:\"TD\";i:38;s:2:\"CL\";i:39;s:2:\"CN\";i:40;s:2:\"CX\";i:41;s:2:\"CC\";i:42;s:2:\"CO\";i:43;s:2:\"KM\";i:44;s:2:\"CG\";i:45;s:2:\"CG\";i:46;s:2:\"CK\";i:47;s:2:\"CR\";i:48;s:2:\"HR\";i:49;s:2:\"CW\";i:50;s:2:\"CY\";i:51;s:2:\"CZ\";i:52;s:2:\"DK\";i:53;s:2:\"DJ\";i:54;s:2:\"DM\";i:55;s:2:\"DO\";i:56;s:2:\"EC\";i:57;s:2:\"EG\";i:58;s:2:\"SV\";i:59;s:2:\"GQ\";i:60;s:2:\"ER\";i:61;s:2:\"EE\";i:62;s:2:\"ET\";i:63;s:2:\"FK\";i:64;s:2:\"FJ\";i:65;s:2:\"FI\";i:66;s:2:\"FR\";i:67;s:2:\"PF\";i:68;s:2:\"TF\";i:69;s:2:\"GM\";i:70;s:2:\"GE\";i:71;s:2:\"DE\";i:72;s:2:\"GH\";i:73;s:2:\"GI\";i:74;s:2:\"GR\";i:75;s:2:\"GD\";i:76;s:2:\"GU\";i:77;s:2:\"GT\";i:78;s:2:\"GG\";i:79;s:2:\"GY\";i:80;s:2:\"HT\";i:81;s:2:\"HM\";i:82;s:2:\"HN\";i:83;s:2:\"HK\";i:84;s:2:\"HU\";i:85;s:2:\"IS\";i:86;s:2:\"IN\";i:87;s:2:\"ID\";i:88;s:2:\"IE\";i:89;s:2:\"IM\";i:90;s:2:\"IL\";i:91;s:2:\"IT\";i:92;s:2:\"JP\";i:93;s:2:\"JE\";i:94;s:2:\"JO\";i:95;s:2:\"KZ\";i:96;s:2:\"KE\";i:97;s:2:\"KI\";i:98;s:2:\"KR\";i:99;s:2:\"XK\";i:100;s:2:\"KW\";i:101;s:2:\"KG\";i:102;s:2:\"LA\";i:103;s:2:\"LV\";i:104;s:2:\"LB\";i:105;s:2:\"LS\";i:106;s:2:\"LR\";i:107;s:2:\"LY\";i:108;s:2:\"LI\";i:109;s:2:\"LT\";i:110;s:2:\"LU\";i:111;s:2:\"MO\";i:112;s:2:\"MK\";i:113;s:2:\"MG\";i:114;s:2:\"MW\";i:115;s:2:\"MY\";i:116;s:2:\"MT\";i:117;s:2:\"MH\";i:118;s:2:\"MQ\";i:119;s:2:\"MR\";i:120;s:2:\"MU\";i:121;s:2:\"YT\";i:122;s:2:\"MX\";i:123;s:2:\"FM\";i:124;s:2:\"MD\";i:125;s:2:\"MC\";i:126;s:2:\"MN\";i:127;s:2:\"ME\";i:128;s:2:\"MS\";i:129;s:2:\"MA\";i:130;s:2:\"NR\";i:131;s:2:\"NP\";i:132;s:2:\"NL\";i:133;s:2:\"AN\";i:134;s:2:\"NZ\";i:135;s:2:\"NI\";i:136;s:2:\"NE\";i:137;s:2:\"NG\";i:138;s:2:\"NU\";i:139;s:2:\"NF\";i:140;s:2:\"NO\";i:141;s:2:\"OM\";i:142;s:2:\"PK\";i:143;s:2:\"PW\";i:144;s:2:\"PS\";i:145;s:2:\"PA\";i:146;s:2:\"PG\";i:147;s:2:\"PY\";i:148;s:2:\"PE\";i:149;s:2:\"PH\";i:150;s:2:\"PN\";i:151;s:2:\"PL\";i:152;s:2:\"PT\";i:153;s:2:\"PR\";i:154;s:2:\"QA\";i:155;s:2:\"RO\";i:156;s:2:\"RU\";i:157;s:2:\"SH\";i:158;s:2:\"KN\";i:159;s:2:\"LC\";i:160;s:2:\"PM\";i:161;s:2:\"VC\";i:162;s:2:\"WS\";i:163;s:2:\"SM\";i:164;s:2:\"ST\";i:165;s:2:\"SA\";i:166;s:2:\"RS\";i:167;s:2:\"SC\";i:168;s:2:\"SL\";i:169;s:2:\"SG\";i:170;s:2:\"SX\";i:171;s:2:\"SK\";i:172;s:2:\"SI\";i:173;s:2:\"SB\";i:174;s:2:\"SO\";i:175;s:2:\"ZA\";i:176;s:2:\"GS\";i:177;s:2:\"ES\";i:178;s:2:\"LK\";i:179;s:2:\"SR\";i:180;s:2:\"SJ\";i:181;s:2:\"SE\";i:182;s:2:\"CH\";i:183;s:2:\"TW\";i:184;s:2:\"TZ\";i:185;s:2:\"TH\";i:186;s:2:\"TG\";i:187;s:2:\"TK\";i:188;s:2:\"TO\";i:189;s:2:\"TT\";i:190;s:2:\"TN\";i:191;s:2:\"TM\";i:192;s:2:\"TC\";i:193;s:2:\"TV\";i:194;s:2:\"UA\";i:195;s:2:\"AE\";i:196;s:2:\"GB\";i:197;s:2:\"UY\";i:198;s:2:\"UZ\";i:199;s:2:\"VU\";i:200;s:2:\"VA\";i:201;s:2:\"VE\";i:202;s:2:\"VN\";i:203;s:2:\"VG\";i:204;s:2:\"VI\";i:205;s:2:\"WF\";i:206;s:2:\"EH\";i:207;s:2:\"YE\";i:208;s:2:\"ZM\";i:209;s:2:\"ZW\";}','N;'),(27,'Moneybookers.MAE','Module\\CDev\\Moneybookers\\Model\\Payment\\Processor\\Moneybookers','CDev_Moneybookers',1070,0,0,1,0,'C',0,NULL,'a:4:{i:0;s:2:\"GB\";i:1;s:2:\"ES\";i:2;s:2:\"IE\";i:3;s:2:\"AT\";}','N;'),(28,'Moneybookers.AMX','Module\\CDev\\Moneybookers\\Model\\Payment\\Processor\\Moneybookers','CDev_Moneybookers',1090,0,0,1,0,'C',0,NULL,'a:210:{i:0;s:2:\"AX\";i:1;s:2:\"AL\";i:2;s:2:\"DZ\";i:3;s:2:\"AD\";i:4;s:2:\"AO\";i:5;s:2:\"AI\";i:6;s:2:\"AQ\";i:7;s:2:\"AG\";i:8;s:2:\"AR\";i:9;s:2:\"AM\";i:10;s:2:\"AW\";i:11;s:2:\"AU\";i:12;s:2:\"AT\";i:13;s:2:\"AZ\";i:14;s:2:\"BS\";i:15;s:2:\"BH\";i:16;s:2:\"BD\";i:17;s:2:\"BB\";i:18;s:2:\"BY\";i:19;s:2:\"BE\";i:20;s:2:\"BZ\";i:21;s:2:\"BJ\";i:22;s:2:\"BM\";i:23;s:2:\"BT\";i:24;s:2:\"BO\";i:25;s:2:\"BQ\";i:26;s:2:\"BA\";i:27;s:2:\"BV\";i:28;s:2:\"BR\";i:29;s:2:\"IO\";i:30;s:2:\"BN\";i:31;s:2:\"BG\";i:32;s:2:\"BF\";i:33;s:2:\"BI\";i:34;s:2:\"CA\";i:35;s:2:\"CV\";i:36;s:2:\"KY\";i:37;s:2:\"TD\";i:38;s:2:\"CL\";i:39;s:2:\"CN\";i:40;s:2:\"CX\";i:41;s:2:\"CC\";i:42;s:2:\"CO\";i:43;s:2:\"KM\";i:44;s:2:\"CG\";i:45;s:2:\"CG\";i:46;s:2:\"CK\";i:47;s:2:\"CR\";i:48;s:2:\"HR\";i:49;s:2:\"CW\";i:50;s:2:\"CY\";i:51;s:2:\"CZ\";i:52;s:2:\"DK\";i:53;s:2:\"DJ\";i:54;s:2:\"DM\";i:55;s:2:\"DO\";i:56;s:2:\"EC\";i:57;s:2:\"EG\";i:58;s:2:\"SV\";i:59;s:2:\"GQ\";i:60;s:2:\"ER\";i:61;s:2:\"EE\";i:62;s:2:\"ET\";i:63;s:2:\"FK\";i:64;s:2:\"FJ\";i:65;s:2:\"FI\";i:66;s:2:\"FR\";i:67;s:2:\"PF\";i:68;s:2:\"TF\";i:69;s:2:\"GM\";i:70;s:2:\"GE\";i:71;s:2:\"DE\";i:72;s:2:\"GH\";i:73;s:2:\"GI\";i:74;s:2:\"GR\";i:75;s:2:\"GD\";i:76;s:2:\"GU\";i:77;s:2:\"GT\";i:78;s:2:\"GG\";i:79;s:2:\"GY\";i:80;s:2:\"HT\";i:81;s:2:\"HM\";i:82;s:2:\"HN\";i:83;s:2:\"HK\";i:84;s:2:\"HU\";i:85;s:2:\"IS\";i:86;s:2:\"IN\";i:87;s:2:\"ID\";i:88;s:2:\"IE\";i:89;s:2:\"IM\";i:90;s:2:\"IL\";i:91;s:2:\"IT\";i:92;s:2:\"JP\";i:93;s:2:\"JE\";i:94;s:2:\"JO\";i:95;s:2:\"KZ\";i:96;s:2:\"KE\";i:97;s:2:\"KI\";i:98;s:2:\"KR\";i:99;s:2:\"XK\";i:100;s:2:\"KW\";i:101;s:2:\"KG\";i:102;s:2:\"LA\";i:103;s:2:\"LV\";i:104;s:2:\"LB\";i:105;s:2:\"LS\";i:106;s:2:\"LR\";i:107;s:2:\"LY\";i:108;s:2:\"LI\";i:109;s:2:\"LT\";i:110;s:2:\"LU\";i:111;s:2:\"MO\";i:112;s:2:\"MK\";i:113;s:2:\"MG\";i:114;s:2:\"MW\";i:115;s:2:\"MY\";i:116;s:2:\"MT\";i:117;s:2:\"MH\";i:118;s:2:\"MQ\";i:119;s:2:\"MR\";i:120;s:2:\"MU\";i:121;s:2:\"YT\";i:122;s:2:\"MX\";i:123;s:2:\"FM\";i:124;s:2:\"MD\";i:125;s:2:\"MC\";i:126;s:2:\"MN\";i:127;s:2:\"ME\";i:128;s:2:\"MS\";i:129;s:2:\"MA\";i:130;s:2:\"NR\";i:131;s:2:\"NP\";i:132;s:2:\"NL\";i:133;s:2:\"AN\";i:134;s:2:\"NZ\";i:135;s:2:\"NI\";i:136;s:2:\"NE\";i:137;s:2:\"NG\";i:138;s:2:\"NU\";i:139;s:2:\"NF\";i:140;s:2:\"NO\";i:141;s:2:\"OM\";i:142;s:2:\"PK\";i:143;s:2:\"PW\";i:144;s:2:\"PS\";i:145;s:2:\"PA\";i:146;s:2:\"PG\";i:147;s:2:\"PY\";i:148;s:2:\"PE\";i:149;s:2:\"PH\";i:150;s:2:\"PN\";i:151;s:2:\"PL\";i:152;s:2:\"PT\";i:153;s:2:\"PR\";i:154;s:2:\"QA\";i:155;s:2:\"RO\";i:156;s:2:\"RU\";i:157;s:2:\"SH\";i:158;s:2:\"KN\";i:159;s:2:\"LC\";i:160;s:2:\"PM\";i:161;s:2:\"VC\";i:162;s:2:\"WS\";i:163;s:2:\"SM\";i:164;s:2:\"ST\";i:165;s:2:\"SA\";i:166;s:2:\"RS\";i:167;s:2:\"SC\";i:168;s:2:\"SL\";i:169;s:2:\"SG\";i:170;s:2:\"SX\";i:171;s:2:\"SK\";i:172;s:2:\"SI\";i:173;s:2:\"SB\";i:174;s:2:\"SO\";i:175;s:2:\"ZA\";i:176;s:2:\"GS\";i:177;s:2:\"ES\";i:178;s:2:\"LK\";i:179;s:2:\"SR\";i:180;s:2:\"SJ\";i:181;s:2:\"SE\";i:182;s:2:\"CH\";i:183;s:2:\"TW\";i:184;s:2:\"TZ\";i:185;s:2:\"TH\";i:186;s:2:\"TG\";i:187;s:2:\"TK\";i:188;s:2:\"TO\";i:189;s:2:\"TT\";i:190;s:2:\"TN\";i:191;s:2:\"TM\";i:192;s:2:\"TC\";i:193;s:2:\"TV\";i:194;s:2:\"UA\";i:195;s:2:\"AE\";i:196;s:2:\"GB\";i:197;s:2:\"UY\";i:198;s:2:\"UZ\";i:199;s:2:\"VU\";i:200;s:2:\"VA\";i:201;s:2:\"VE\";i:202;s:2:\"VN\";i:203;s:2:\"VG\";i:204;s:2:\"VI\";i:205;s:2:\"WF\";i:206;s:2:\"EH\";i:207;s:2:\"YE\";i:208;s:2:\"ZM\";i:209;s:2:\"ZW\";}','a:1:{i:0;s:2:\"US\";}'),(29,'Moneybookers.GCB','Module\\CDev\\Moneybookers\\Model\\Payment\\Processor\\Moneybookers','CDev_Moneybookers',1130,0,0,1,0,'C',0,NULL,'a:1:{i:0;s:2:\"FR\";}','N;'),(30,'Moneybookers.DNK','Module\\CDev\\Moneybookers\\Model\\Payment\\Processor\\Moneybookers','CDev_Moneybookers',1140,0,0,1,0,'C',0,NULL,'a:1:{i:0;s:2:\"DK\";}','N;'),(31,'Moneybookers.PSP','Module\\CDev\\Moneybookers\\Model\\Payment\\Processor\\Moneybookers','CDev_Moneybookers',1150,0,0,1,0,'C',0,NULL,'a:1:{i:0;s:2:\"IT\";}','N;'),(32,'Moneybookers.CSI','Module\\CDev\\Moneybookers\\Model\\Payment\\Processor\\Moneybookers','CDev_Moneybookers',1160,0,0,1,0,'C',0,NULL,'a:1:{i:0;s:2:\"IT\";}','N;'),(33,'Moneybookers.OBT','Module\\CDev\\Moneybookers\\Model\\Payment\\Processor\\Moneybookers','CDev_Moneybookers',1170,0,0,1,0,'N',0,NULL,'a:8:{i:0;s:2:\"DE\";i:1;s:2:\"GB\";i:2;s:2:\"FR\";i:3;s:2:\"IT\";i:4;s:2:\"ES\";i:5;s:2:\"HU\";i:6;s:2:\"PL\";i:7;s:2:\"AT\";}','N;'),(34,'Moneybookers.GIR','Module\\CDev\\Moneybookers\\Model\\Payment\\Processor\\Moneybookers','CDev_Moneybookers',1180,0,0,1,0,'N',0,NULL,'a:1:{i:0;s:2:\"DE\";}','N;'),(35,'Moneybookers.DID','Module\\CDev\\Moneybookers\\Model\\Payment\\Processor\\Moneybookers','CDev_Moneybookers',1190,0,0,1,0,'N',0,NULL,'a:1:{i:0;s:2:\"DE\";}','N;'),(36,'Moneybookers.PWY','Module\\CDev\\Moneybookers\\Model\\Payment\\Processor\\Moneybookers','CDev_Moneybookers',1270,0,0,1,0,'N',0,NULL,'a:1:{i:0;s:2:\"PL\";}','N;'),(37,'Moneybookers.SFT','Module\\CDev\\Moneybookers\\Model\\Payment\\Processor\\Moneybookers','CDev_Moneybookers',1200,0,0,1,0,'N',0,NULL,'a:11:{i:0;s:2:\"DE\";i:1;s:2:\"AT\";i:2;s:2:\"BE\";i:3;s:2:\"NL\";i:4;s:2:\"IT\";i:5;s:2:\"FR\";i:6;s:2:\"PL\";i:7;s:2:\"HU\";i:8;s:2:\"SK\";i:9;s:2:\"CZ\";i:10;s:2:\"GB\";}','N;'),(38,'Moneybookers.EBT','Module\\CDev\\Moneybookers\\Model\\Payment\\Processor\\Moneybookers','CDev_Moneybookers',1220,0,0,1,0,'N',0,NULL,'a:1:{i:0;s:2:\"SE\";}','N;'),(39,'Moneybookers.IDL','Module\\CDev\\Moneybookers\\Model\\Payment\\Processor\\Moneybookers','CDev_Moneybookers',1240,0,0,1,0,'N',0,NULL,'a:28:{i:0;s:2:\"BE\";i:1;s:2:\"BG\";i:2;s:2:\"CZ\";i:3;s:2:\"DK\";i:4;s:2:\"DE\";i:5;s:2:\"EE\";i:6;s:2:\"IE\";i:7;s:2:\"EL\";i:8;s:2:\"ES\";i:9;s:2:\"FR\";i:10;s:2:\"HR\";i:11;s:2:\"IT\";i:12;s:2:\"CY\";i:13;s:2:\"LV\";i:14;s:2:\"LT\";i:15;s:2:\"LU\";i:16;s:2:\"HU\";i:17;s:2:\"MT\";i:18;s:2:\"NL\";i:19;s:2:\"AT\";i:20;s:2:\"PL\";i:21;s:2:\"PT\";i:22;s:2:\"RO\";i:23;s:2:\"SI\";i:24;s:2:\"SK\";i:25;s:2:\"FI\";i:26;s:2:\"SE\";i:27;s:2:\"UK\";}','N;'),(40,'Moneybookers.NPY','Module\\CDev\\Moneybookers\\Model\\Payment\\Processor\\Moneybookers','CDev_Moneybookers',1250,0,0,1,0,'N',0,NULL,'a:1:{i:0;s:2:\"AT\";}','N;'),(41,'Moneybookers.PLI','Module\\CDev\\Moneybookers\\Model\\Payment\\Processor\\Moneybookers','CDev_Moneybookers',1260,0,0,1,0,'N',0,NULL,'a:1:{i:0;s:2:\"AU\";}','N;'),(42,'Moneybookers.EPY','Module\\CDev\\Moneybookers\\Model\\Payment\\Processor\\Moneybookers','CDev_Moneybookers',1450,0,0,1,0,'N',0,NULL,'a:1:{i:0;s:2:\"BG\";}','N;'),(43,'Moneybookers.GLU','Module\\CDev\\Moneybookers\\Model\\Payment\\Processor\\Moneybookers','CDev_Moneybookers',1460,0,0,1,0,'N',0,NULL,'a:13:{i:0;s:2:\"SE\";i:1;s:2:\"FI\";i:2;s:2:\"EE\";i:3;s:2:\"DK\";i:4;s:2:\"ES\";i:5;s:2:\"IT\";i:6;s:2:\"DE\";i:7;s:2:\"PT\";i:8;s:2:\"AT\";i:9;s:2:\"LV\";i:10;s:2:\"LT\";i:11;s:2:\"NL\";i:12;s:2:\"PL\";}','N;'),(44,'Moneybookers.ALI','Module\\CDev\\Moneybookers\\Model\\Payment\\Processor\\Moneybookers','CDev_Moneybookers',1460,0,0,1,0,'N',0,NULL,'a:1:{i:0;s:2:\"CN\";}','N;'),(45,'Moneybookers.ADB','Module\\CDev\\Moneybookers\\Model\\Payment\\Processor\\Moneybookers','CDev_Moneybookers',1460,0,0,1,0,'N',0,NULL,'a:2:{i:0;s:2:\"AR\";i:1;s:2:\"BR\";}','N;'),(46,'Moneybookers.AOB','Module\\CDev\\Moneybookers\\Model\\Payment\\Processor\\Moneybookers','CDev_Moneybookers',1460,0,0,1,0,'N',0,NULL,'a:4:{i:0;s:2:\"BR\";i:1;s:2:\"CL\";i:2;s:2:\"CN\";i:3;s:2:\"CO\";}','N;'),(47,'Moneybookers.ACI','Module\\CDev\\Moneybookers\\Model\\Payment\\Processor\\Moneybookers','CDev_Moneybookers',1460,0,0,1,0,'N',0,NULL,'a:7:{i:0;s:2:\"AR\";i:1;s:2:\"BR\";i:2;s:2:\"CL\";i:3;s:2:\"CN\";i:4;s:2:\"CO\";i:5;s:2:\"MX\";i:6;s:2:\"UY\";}','N;'),(48,'Moneybookers.AUP','Module\\CDev\\Moneybookers\\Model\\Payment\\Processor\\Moneybookers','CDev_Moneybookers',1460,0,0,1,0,'N',0,NULL,'a:1:{i:0;s:2:\"CN\";}','N;'),(49,'QuantumGateway','Module\\CDev\\Quantum\\Model\\Payment\\Processor\\Quantum','CDev_Quantum',-10000,0,0,1,0,'C',0,NULL,'a:1:{i:0;s:2:\"US\";}','N;'),(50,'2Checkout.com','Module\\CDev\\TwoCheckout\\Model\\Payment\\Processor\\TwoCheckout','CDev_TwoCheckout',-10500,0,0,1,0,'C',0,NULL,'N;','N;'),(51,'COD_USPS','Module\\CDev\\USPS\\Model\\Payment\\Processor\\COD','CDev_USPS',0,0,0,1,1,'O',0,NULL,'a:1:{i:0;s:2:\"US\";}','N;'),(52,'ePDQ e-Commerce','Module\\XC\\EPDQ\\Model\\Payment\\Processor\\EPDQ','XC_EPDQ',-10200,0,0,1,0,'C',0,NULL,'a:1:{i:0;s:2:\"GB\";}','N;'),(53,'iDEAL Professional','Module\\XC\\IdealPayments\\Model\\Payment\\Processor\\IdealProfessional','XC_IdealPayments',-10100,0,0,1,0,'C',0,NULL,'a:28:{i:0;s:2:\"BE\";i:1;s:2:\"BG\";i:2;s:2:\"CZ\";i:3;s:2:\"DK\";i:4;s:2:\"DE\";i:5;s:2:\"EE\";i:6;s:2:\"IE\";i:7;s:2:\"EL\";i:8;s:2:\"ES\";i:9;s:2:\"FR\";i:10;s:2:\"HR\";i:11;s:2:\"IT\";i:12;s:2:\"CY\";i:13;s:2:\"LV\";i:14;s:2:\"LT\";i:15;s:2:\"LU\";i:16;s:2:\"HU\";i:17;s:2:\"MT\";i:18;s:2:\"NL\";i:19;s:2:\"AT\";i:20;s:2:\"PL\";i:21;s:2:\"PT\";i:22;s:2:\"RO\";i:23;s:2:\"SI\";i:24;s:2:\"SK\";i:25;s:2:\"FI\";i:26;s:2:\"SE\";i:27;s:2:\"UK\";}','N;'),(54,'SagePay form protocol','Module\\XC\\SagePay\\Model\\Payment\\Processor\\SagePayForm','XC_SagePay',-101500,0,0,1,0,'C',0,NULL,'a:2:{i:0;s:2:\"GB\";i:1;s:2:\"IE\";}','N;'),(55,'Stripe','Module\\XC\\Stripe\\Model\\Payment\\Stripe','XC_Stripe',-10300,0,0,1,0,'C',0,NULL,'a:22:{i:0;s:2:\"AU\";i:1;s:2:\"CA\";i:2;s:2:\"DK\";i:3;s:2:\"FI\";i:4;s:2:\"FR\";i:5;s:2:\"IE\";i:6;s:2:\"JP\";i:7;s:2:\"NO\";i:8;s:2:\"SG\";i:9;s:2:\"ES\";i:10;s:2:\"SE\";i:11;s:2:\"GB\";i:12;s:2:\"US\";i:13;s:2:\"AT\";i:14;s:2:\"BE\";i:15;s:2:\"DE\";i:16;s:2:\"HK\";i:17;s:2:\"IT\";i:18;s:2:\"LU\";i:19;s:2:\"NL\";i:20;s:2:\"PT\";i:21;s:2:\"CH\";}','N;'),(56,'Ingenico Payment Services (Ogone)','Module\\XC\\OgoneEcommerce\\Model\\Payment\\Processor\\OgoneEcommerce','XC_OgoneEcommerce',0,0,0,1,0,'C',0,NULL,'a:63:{i:0;s:2:\"FR\";i:1;s:2:\"DE\";i:2;s:2:\"IT\";i:3;s:2:\"PT\";i:4;s:2:\"ES\";i:5;s:2:\"GB\";i:6;s:2:\"HU\";i:7;s:2:\"PL\";i:8;s:2:\"RU\";i:9;s:2:\"TR\";i:10;s:2:\"AI\";i:11;s:2:\"AG\";i:12;s:2:\"AR\";i:13;s:2:\"AW\";i:14;s:2:\"BS\";i:15;s:2:\"BB\";i:16;s:2:\"BZ\";i:17;s:2:\"BM\";i:18;s:2:\"BO\";i:19;s:2:\"BR\";i:20;s:2:\"VG\";i:21;s:2:\"KY\";i:22;s:2:\"CL\";i:23;s:2:\"CO\";i:24;s:2:\"CR\";i:25;s:2:\"CU\";i:26;s:2:\"DM\";i:27;s:2:\"DO\";i:28;s:2:\"EC\";i:29;s:2:\"SV\";i:30;s:2:\"FK\";i:31;s:2:\"GF\";i:32;s:2:\"GD\";i:33;s:2:\"GP\";i:34;s:2:\"GT\";i:35;s:2:\"GY\";i:36;s:2:\"HT\";i:37;s:2:\"HN\";i:38;s:2:\"JM\";i:39;s:2:\"MQ\";i:40;s:2:\"MX\";i:41;s:2:\"MS\";i:42;s:2:\"AN\";i:43;s:2:\"NI\";i:44;s:2:\"PA\";i:45;s:2:\"PY\";i:46;s:2:\"PE\";i:47;s:2:\"PR\";i:48;s:2:\"LC\";i:49;s:2:\"KN\";i:50;s:2:\"VC\";i:51;s:2:\"SR\";i:52;s:2:\"TT\";i:53;s:2:\"TC\";i:54;s:2:\"VI\";i:55;s:2:\"UY\";i:56;s:2:\"VE\";i:57;s:2:\"CA\";i:58;s:2:\"GL\";i:59;s:2:\"PM\";i:60;s:2:\"US\";i:61;s:2:\"BL\";i:62;s:2:\"MF\";}','N;'),(57,'Moneris (eSELECTplus- Hosted Pay Page)','Module\\XC\\ESelectHPP\\Model\\Payment\\Processor\\ESelectHPP','XC_ESelectHPP',0,0,0,1,0,'C',0,NULL,'a:1:{i:0;s:2:\"CA\";}','N;'),(58,'PayWithAmazon','Module\\Amazon\\PayWithAmazon\\Model\\Payment\\Processor\\PayWithAmazon','Amazon_PayWithAmazon',-101600,-101600,0,1,0,'C',0,NULL,'a:4:{i:0;s:2:\"US\";i:1;s:2:\"GB\";i:2;s:2:\"DE\";i:3;s:2:\"JP\";}','N;'),(59,'PayPal powered by Braintree','Module\\QSL\\BraintreeVZ\\Model\\Payment\\Processor\\BraintreeVZ','QSL_BraintreeVZ',-101950,-101950,0,1,0,'A',0,NULL,'a:5:{i:0;s:2:\"US\";i:1;s:2:\"UK\";i:2;s:2:\"FR\";i:3;s:2:\"IT\";i:4;s:2:\"ES\";}','N;'),(60,'AuthorizenetAcceptjs','Module\\QSL\\AuthorizenetAcceptjs\\Model\\Payment\\Processor\\AuthorizenetAcceptjs','QSL_AuthorizenetAcceptjs',-101800,-101800,0,1,1,'C',0,NULL,'a:1:{i:0;s:2:\"US\";}','N;');
CREATE TABLE `xlite_role_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `IDX_27007A52BF396750` (`id`),
  CONSTRAINT `FK_27007A52BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_role_translations` VALUES (1,1,'Administrator','en'),(2,1,'Administrator','ru'),(3,2,'Coupons management','en'),(4,2,'Управление купонами','ru'),(5,3,'Content management','en'),(6,3,'Управлением контентом','ru'),(7,4,'Volume discounts management','en'),(8,4,'Управление скидками','ru');
CREATE TABLE `xlite_iframe_contents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `method` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `data` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_module_keys` (
  `keyId` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `author` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `keyValue` char(64) COLLATE utf8_unicode_ci NOT NULL,
  `keyType` int(11) NOT NULL,
  `xcnPlan` bigint(20) NOT NULL,
  `keyData` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  `active` tinyint(1) NOT NULL,
  PRIMARY KEY (`keyId`),
  UNIQUE KEY `an` (`author`,`name`,`xcnPlan`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_attribute_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `unit` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_8BBAD04BBF396750` FOREIGN KEY (`id`) REFERENCES `xlite_attributes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_attribute_translations` VALUES (1,1,'Size','','en'),(50,50,'Manufacturer','','en'),(51,1,'Размер','','ru'),(100,50,'Производитель','','ru'),(106,56,'Color','','en'),(108,58,'Color','','en'),(111,61,'Character','','en'),(112,62,'Captain America','','en'),(113,63,'Iron Man','','en'),(114,64,'Hulk','','en'),(115,65,'Thor','','en'),(116,66,'Black','','en'),(117,67,'Pink','','en'),(118,68,'Blue','','en'),(119,69,'Color','','en'),(120,70,'Color','','en'),(126,56,'Цвет','','ru'),(128,58,'Цвет','','ru'),(131,61,'Персонаж','','ru'),(132,62,'Капитан Америка','','ru'),(133,63,'Железный человек','','ru'),(134,64,'Халк','','ru'),(135,65,'Тор','','ru'),(136,66,'Черный','','ru'),(137,67,'Розовый','','ru'),(138,68,'Синий','','ru'),(139,69,'Цвет','','ru'),(140,70,'Цвет','','ru'),(141,71,'Capacity, GB','','en'),(142,72,'Chip','','en'),(143,73,'Color','','en'),(144,74,'Sim card','','en'),(145,75,'Display type','','en'),(146,76,'Dimension, inches','','en'),(147,77,'Resolution','','en'),(148,78,'Battery type','','en'),(149,79,'Talk time','','en'),(150,80,'Standby time','','en'),(151,81,'Video playback','','en'),(152,82,'Audio playback','','en'),(153,83,'GSM model','','en'),(154,84,'Wi-Fi','','en'),(155,85,'Bluetooth','','en'),(156,86,'GPS','','en'),(157,87,'Color','','en'),(158,87,'Цвет','','ru'),(159,73,'Цвет','','ru'),(160,71,'Объем памяти, GB','','ru'),(161,72,'Chip','','ru'),(162,74,'Sim card','','ru'),(163,75,'Display type','','ru'),(164,76,'Dimension, inches','','ru'),(165,77,'Resolution','','ru'),(166,78,'Battery type','','ru'),(167,79,'Talk time','','ru'),(168,80,'Standby time','','ru'),(169,81,'Video playback','','ru'),(170,82,'Audio playback','','ru'),(171,83,'GSM model','','ru'),(172,84,'Wi-Fi','','ru'),(173,85,'Bluetooth','','ru'),(174,86,'GPS','','ru');
CREATE TABLE `xlite_membership_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_571DB741BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_memberships` (`membership_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_membership_translations` VALUES (1,1,'Wholesaler','en'),(2,1,'Оптовый покупатель','ru');
CREATE TABLE `xlite_currencies` (
  `currency_id` int(10) unsigned NOT NULL,
  `code` char(3) COLLATE utf8_unicode_ci NOT NULL,
  `symbol` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `prefix` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `suffix` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `e` smallint(6) NOT NULL,
  `decimalDelimiter` varchar(8) COLLATE utf8_unicode_ci NOT NULL,
  `thousandDelimiter` varchar(8) COLLATE utf8_unicode_ci NOT NULL,
  `roundUp` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`currency_id`),
  UNIQUE KEY `UNIQ_903AF16077153098` (`code`),
  KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_currencies` VALUES (8,'ALL','L','L','',2,'.','','N'),(12,'DZD','د.ج','د.ج','',2,'.','','N'),(32,'ARS','$','$','',2,'.','','N'),(36,'AUD','$','$','',2,'.','','N'),(44,'BSD','$','$','',2,'.','','N'),(48,'BHD','.د.ب','.د.ب','',3,'.','','N'),(50,'BDT','৳','৳','',2,'.','','N'),(51,'AMD','դր.','դր.','',2,'.','','N'),(52,'BBD','$','$','',2,'.','','N'),(60,'BMD','$','$','',2,'.','','N'),(64,'BTN','Nu','Nu','',2,'.','','N'),(68,'BOB','$','$','',2,'.','','N'),(72,'BWP','P','P','',2,'.','','N'),(84,'BZD','$','$','',2,'.','','N'),(90,'SBD','$','$','',2,'.','','N'),(96,'BND','$','$','',2,'.','','N'),(104,'MMK','K','K','',2,'.','','N'),(108,'BIF','₣','₣','',0,'.','','N'),(116,'KHR','$','$','',2,'.','','N'),(124,'CAD','$','$','',2,'.','','N'),(132,'CVE','$','$','',2,'.','','N'),(136,'KYD','$','$','',2,'.','','N'),(144,'LKR','Re','Re','',2,'.','','N'),(152,'CLP','$','$','',0,'.','','N'),(156,'CNY','¥','¥','',2,'.','','N'),(170,'COP','$','$','',2,'.','','N'),(174,'KMF','₣','₣','',0,'.','','N'),(188,'CRC','₡','₡','',2,'.','','N'),(191,'HRK','Kn','Kn','',2,'.','','N'),(192,'CUP','$','$','',2,'.','','N'),(203,'CZK','Kč','Kč','',2,'.','','N'),(208,'DKK','kr','kr','',2,'.','','N'),(214,'DOP','$','$','',2,'.','','N'),(222,'SVC','₡','₡','',2,'.','','N'),(230,'ETB','Br','Br','',2,'.','','N'),(232,'ERN','Nfk','Nfk','',2,'.','','N'),(238,'FKP','£','£','',2,'.','','N'),(242,'FJD','$','$','',2,'.','','N'),(262,'DJF','₣','₣','',0,'.','','N'),(270,'GMD','D','D','',2,'.','','N'),(292,'GIP','£','£','',2,'.','','N'),(320,'GTQ','Q','Q','',2,'.','','N'),(324,'GNF','₣','₣','',0,'.','','N'),(328,'GYD','$','$','',2,'.','','N'),(332,'HTG','G','G','',2,'.','','N'),(340,'HNL','L','L','',2,'.','','N'),(344,'HKD','$','$','',2,'.','','N'),(348,'HUF','ƒ','ƒ','',2,'.','','N'),(352,'ISK','kr','kr','',0,'.','','N'),(356,'INR','₹','₹','',2,'.','','N'),(360,'IDR','Rp','Rp','',0,'.','','N'),(364,'IRR','﷼','﷼','',2,'.','','N'),(368,'IQD','ع.د','ع.د','',3,'.','','N'),(376,'ILS','₪','₪','',2,'.','','N'),(388,'JMD','$','$','',2,'.','','N'),(392,'JPY','¥','¥','',0,'.','','N'),(398,'KZT','₸','₸','',2,'.','','N'),(400,'JOD','د.ا','د.ا','',3,'.','','N'),(404,'KES','KSh','KSh','',2,'.','','N'),(408,'KPW','₩','₩','',2,'.','','N'),(410,'KRW','₩','₩','',0,'.','','N'),(414,'KWD','د.ك','د.ك','',3,'.','','N'),(417,'KGS','C','C','',2,'.','','N'),(418,'LAK','₭','₭','',2,'.','','N'),(422,'LBP','.ل.ل','.ل.ل','',2,'.','','N'),(426,'LSL','L','L','',2,'.','','N'),(428,'LVL','Ls','Ls','',2,'.','','N'),(430,'LRD','$','$','',2,'.','','N'),(434,'LYD','ل.د','ل.د','',3,'.','','N'),(440,'LTL','Lt','Lt','',2,'.','','N'),(446,'MOP','$','$','',2,'.','','N'),(454,'MWK','K','K','',2,'.','','N'),(458,'MYR','RM','RM','',2,'.','','N'),(462,'MVR','Rf','Rf','',2,'.','','N'),(478,'MRO','UM','UM','',0,'.','','N'),(480,'MUR','Re','Re','',2,'.','','N'),(484,'MXN','$','$','',2,'.','','N'),(496,'MNT','₮','₮','',2,'.','','N'),(498,'MDL','L','L','',2,'.','','N'),(504,'MAD','د. م.','د. م.','',2,'.','','N'),(512,'OMR','ر.ع.','ر.ع.','',3,'.','','N'),(516,'NAD','N$','N$','',2,'.','','N'),(524,'NPR','Re','Re','',2,'.','','N'),(532,'ANG','ƒ','ƒ','',2,'.','','N'),(533,'AWG','ƒ','ƒ','',2,'.','','N'),(548,'VUV','Vt','Vt','',0,'.','','N'),(554,'NZD','$','$','',2,'.','','N'),(558,'NIO','$','$','',2,'.','','N'),(566,'NGN','₦','₦','',2,'.','','N'),(578,'NOK','kr','kr','',2,'.','','N'),(586,'PKR','Re','Re','',2,'.','','N'),(590,'PAB','B/.','B/.','',2,'.','','N'),(598,'PGK','K','K','',2,'.','','N'),(600,'PYG','₲','₲','',0,'.','','N'),(604,'PEN','S/.','S/.','',2,'.','','N'),(608,'PHP','₱','₱','',2,'.','','N'),(634,'QAR','ر.ق','ر.ق','',2,'.','','N'),(643,'RUB','₽','','₽',2,'.','','N'),(646,'RWF','₣','₣','',0,'.','','N'),(654,'SHP','£','£','',2,'.','','N'),(678,'STD','Db','Db','',2,'.','','N'),(682,'SAR','ر.س','ر.س','',2,'.','','N'),(690,'SCR','Re','Re','',2,'.','','N'),(694,'SLL','Le','Le','',2,'.','','N'),(702,'SGD','$','$','',2,'.','','N'),(704,'VND','₫','₫','',0,'.','','N'),(706,'SOS','S','S','',2,'.','','N'),(710,'ZAR','R','R','',2,'.','','N'),(728,'SSP','SSP','SSP','',2,'.','','N'),(748,'SZL','L','L','',2,'.','','N'),(752,'SEK','kr','kr','',2,'.','','N'),(756,'CHF','₣','₣','',2,'.','','N'),(760,'SYP','S£','S£','',2,'.','','N'),(764,'THB','฿','฿','',2,'.','','N'),(776,'TOP','$','$','',2,'.','','N'),(780,'TTD','$','$','',2,'.','','N'),(784,'AED','د.إ','د.إ','',2,'.','','N'),(788,'TND','د.ت','د.ت','',3,'.','','N'),(800,'UGX','USh','USh','',2,'.','','N'),(807,'MKD','ден.','ден.','',2,'.','','N'),(818,'EGP','LE','LE','',2,'.','','N'),(826,'GBP','£','£','',2,'.','','N'),(834,'TZS','TSh','TSh','',2,'.','','N'),(840,'USD','$','$','',2,'.','','N'),(858,'UYU','$','$','',2,'.','','N'),(860,'UZS','сўм','сўм','',2,'.','','N'),(882,'WST','$','$','',2,'.','','N'),(886,'YER','﷼','﷼','',2,'.','','N'),(894,'ZMK','K','K','',2,'.','','N'),(901,'TWD','NT$','NT$','',2,'.','','N'),(932,'ZWL','Z$','Z$','',2,'.','','N'),(934,'TMT','m','m','',2,'.','','N'),(936,'GHS','₵','₵','',2,'.','','N'),(937,'VEF','Bs','Bs','',2,'.','','N'),(938,'SDG','£','£','',2,'.','','N'),(941,'RSD','дин.','дин.','',2,'.','','N'),(943,'MZN','MT','MT','',2,'.','','N'),(944,'AZN','m','m','',2,'.','','N'),(946,'RON','L','L','',2,'.','','N'),(949,'TRY','₤','₤','',2,'.','','N'),(950,'XAF','₣','₣','',0,'.','','N'),(951,'XCD','$','$','',2,'.','','N'),(952,'XOF','₣','₣','',0,'.','','N'),(953,'XPF','₣','₣','',0,'.','','N'),(968,'SRD','$','$','',2,'.','','N'),(969,'MGA','Ar.','Ar.','',0,'.','','N'),(971,'AFN','؋','؋','',2,'.','','N'),(972,'TJS','с.','с.','',2,'.','','N'),(973,'AOA','Kz','Kz','',2,'.','','N'),(974,'BYR','Br','','Br',0,'.','','N'),(975,'BGN','лв','лв','',2,'.','','N'),(976,'CDF','₣','₣','',2,'.','','N'),(977,'BAM','KM','KM','',2,'.','','N'),(978,'EUR','€','€','',2,'.','','N'),(980,'UAH','₴','₴','',2,'.','','N'),(981,'GEL','ლ.','ლ.','',2,'.','','N'),(985,'PLN','zł','zł','',2,'.','','N'),(986,'BRL','$','$','',2,'.','','N');
CREATE TABLE `xlite_order_capost_parcel_manifest_links` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rel` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `href` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `idx` int(11) DEFAULT NULL,
  `mediaType` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `manifestId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_7FE471EA99AD4367` (`manifestId`),
  CONSTRAINT `FK_7FE471EA99AD4367` FOREIGN KEY (`manifestId`) REFERENCES `xlite_order_capost_parcel_manifests` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_view_lists` (
  `list_id` int(11) NOT NULL AUTO_INCREMENT,
  `list_override` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `weight_override` int(11) NOT NULL,
  `override_mode` int(11) NOT NULL,
  `class` varchar(255) CHARACTER SET latin1 NOT NULL,
  `list` varchar(255) CHARACTER SET latin1 NOT NULL,
  `zone` varchar(16) CHARACTER SET latin1 NOT NULL,
  `child` varchar(512) CHARACTER SET latin1 NOT NULL,
  `weight` int(11) NOT NULL,
  `tpl` varchar(512) CHARACTER SET latin1 NOT NULL,
  `version` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`list_id`),
  KEY `tl` (`tpl`,`list`),
  KEY `lzv` (`list`,`zone`,`version`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_view_lists` VALUES (1,'',0,0,'','cart.item.info','customer','XLite\\View\\SelectedAttributeValues',20,'',NULL),(2,'',0,0,'','admin.center','admin','XLite\\View\\Attributes',16777215,'',NULL),(3,'',0,0,'','admin.main.page.header.left','admin','XLite\\View\\CoreVersionPlacer',200,'',NULL),(4,'',0,0,'','layout.main','customer','XLite\\View\\OperateAsUserNotification',0,'',NULL),(5,'',0,0,'','admin.center','admin','XLite\\View\\SafeMode',16777215,'',NULL),(6,'',0,0,'','admin.center','admin','XLite\\View\\Login',16777215,'',NULL),(7,'',0,0,'','sidebar.first','customer','XLite\\View\\TopCategories',100,'',NULL),(8,'',0,0,'','center','customer','XLite\\View\\PageNotFound',16777215,'',NULL),(9,'',0,0,'','admin.center','admin','XLite\\View\\PageNotFound',16777215,'',NULL),(10,'',0,0,'','taxes.help.section','admin','XLite\\View\\TaxBanner',10,'',NULL),(11,'',0,0,'','admin.center','admin','XLite\\View\\Attribute',16777215,'',NULL),(12,'',0,0,'','center','customer','XLite\\View\\Category',16777215,'',NULL),(13,'',0,0,'','checkout.main','customer','XLite\\View\\AllInOneSolutions',1,'',NULL),(14,'',0,0,'','admin.center','admin','XLite\\View\\ItemsList\\Model\\Membership',16777215,'',NULL),(15,'',0,0,'','order.actions','admin','XLite\\View\\ItemsList\\Model\\OrderTrackingNumber',9999,'',NULL),(16,'',0,0,'','admin.center','admin','XLite\\View\\ItemsList\\Model\\AttributeOption',16777215,'',NULL),(17,'',0,0,'','admin.center','admin','XLite\\View\\ItemsList\\Model\\Product\\Admin\\Cloned',16777215,'',NULL),(18,'',0,0,'','admin.center','admin','XLite\\View\\ItemsList\\Model\\Product\\Admin\\Search',16777215,'',NULL),(19,'',0,0,'','admin.center','admin','XLite\\View\\ItemsList\\Model\\AttributeGroup',16777215,'',NULL),(20,'',0,0,'','admin.center','admin','XLite\\View\\ItemsList\\Model\\Payment\\Transaction',16777215,'',NULL),(21,'',0,0,'','pager.admin.model.table.right','admin','XLite\\View\\ItemsList\\Model\\Order\\Admin\\SearchTotal',100,'',NULL),(22,'',0,0,'','admin.center','admin','XLite\\View\\ItemsList\\Model\\Order\\Admin\\Recent',16777215,'',NULL),(23,'',0,0,'','dashboard-center','admin','XLite\\View\\ItemsList\\Model\\Order\\Admin\\RecentBlock',100,'',NULL),(24,'',0,0,'','admin.center','admin','XLite\\View\\ItemsList\\Model\\Profile',16777215,'',NULL),(25,'',0,0,'','admin.center','admin','XLite\\View\\ItemsList\\Model\\ProductClass',16777215,'',NULL),(26,'',0,0,'','center.bottom','customer','XLite\\View\\ItemsList\\Product\\Customer\\Category\\Main',200,'',NULL),(27,'',0,0,'','itemsList.product.cart','customer','XLite\\View\\ItemsList\\Product\\Customer\\CartTray',16777215,'',NULL),(28,'',0,0,'','admin.center','admin','XLite\\View\\ConsistencyCheck\\Page',16777215,'',NULL),(29,'',0,0,'','center','customer','XLite\\View\\Welcome',16777215,'',NULL),(30,'',0,0,'','admin.center','admin','XLite\\View\\Upgrade\\InstallUpdates',16777215,'',NULL),(31,'',0,0,'','admin.center','admin','XLite\\View\\Upgrade\\Step\\Completed\\Backup',200,'',NULL),(32,'',0,0,'','admin.center','admin','XLite\\View\\Upgrade\\Step\\Completed\\StatusMessages',0,'',NULL),(33,'',0,0,'','admin.center','admin','XLite\\View\\Upgrade\\Step\\Completed\\Log',400,'',NULL),(34,'',0,0,'','admin.center','admin','XLite\\View\\Upgrade\\Step\\Completed\\EntriesList',300,'',NULL),(35,'',0,0,'','admin.center','admin','XLite\\View\\Upgrade\\Step\\Prepare\\StatusMessages',0,'',NULL),(36,'',0,0,'','admin.center','admin','XLite\\View\\Upgrade\\Step\\Prepare\\Buttons',300,'',NULL),(37,'',0,0,'','admin.center','admin','XLite\\View\\Upgrade\\Step\\Prepare\\EntriesList',100,'',NULL),(38,'',0,0,'','admin.center','admin','XLite\\View\\Upgrade\\Step\\Prepare\\PremiumLicenseModules',1,'',NULL),(39,'',0,0,'','admin.center','admin','XLite\\View\\Upgrade\\Step\\Prepare\\UpgradeDisallowed',1,'',NULL),(40,'',0,0,'','admin.center','admin','XLite\\View\\Upgrade\\Step\\ReadyToInstall\\StatusMessages',0,'',NULL),(41,'',0,0,'','admin.center','admin','XLite\\View\\Upgrade\\Step\\ReadyToInstall\\Buttons',100,'',NULL),(42,'',0,0,'','admin.center','admin','XLite\\View\\Upgrade\\UpgradeWaveWarning',0,'',NULL),(43,'',0,0,'','admin.center','admin','XLite\\View\\Upgrade\\EmptyCells',100,'',NULL),(44,'',0,0,'','admin.center','admin','XLite\\View\\Upgrade\\Tabber',1000,'',NULL),(45,'',0,0,'','center','customer','XLite\\View\\Order',16777215,'',NULL),(46,'',0,0,'','center','customer','XLite\\View\\Cart',16777215,'',NULL),(47,'',0,0,'','order','admin','XLite\\View\\OrderHistory',150,'',NULL),(48,'',0,0,'','admin.center','admin','XLite\\View\\ActivateFreeLicense',16777215,'',NULL),(49,'',0,0,'','admin.center','admin','XLite\\View\\Shipping\\EditMethod',16777215,'',NULL),(50,'',0,0,'','admin.center','admin','XLite\\View\\Shipping\\AddMethod',16777215,'',NULL),(51,'',0,0,'','center','customer','XLite\\View\\Checkout',16777215,'',NULL),(52,'',0,0,'','invoice.item.name','customer','XLite\\View\\InvoiceAttributeValues',50,'',NULL),(53,'',0,0,'','invoice.item.name','admin','XLite\\View\\InvoiceAttributeValues',20,'',NULL),(54,'',0,0,'','invoice.item.name','mail','XLite\\View\\InvoiceAttributeValues',50,'',NULL),(55,'',0,0,'','invoice.item.name','pdf','XLite\\View\\InvoiceAttributeValues',20,'',NULL),(56,'',0,0,'','order.items.item.name','admin','XLite\\View\\InvoiceAttributeValues',20,'',NULL),(57,'',0,0,'','cli.center','console','XLite\\View\\Console\\Main',16777215,'',NULL),(58,'',0,0,'','cli.center','console','XLite\\View\\Console\\Error',16777215,'',NULL),(59,'',0,0,'','cli.center','console','XLite\\View\\Console\\Db',16777215,'',NULL),(60,'',0,0,'','admin.center','admin','XLite\\View\\SalesCalculation\\Progress',16777215,'',NULL),(62,'',0,0,'','minicart.vertical.item','customer','XLite\\View\\MinicartAttributeValues',30,'',NULL),(63,'',0,0,'','admin.center','admin','XLite\\View\\RecoverPasswordAdmin',16777215,'',NULL),(64,'',0,0,'','admin.center','admin','XLite\\View\\LanguagesModify\\LanguageImport',16777215,'',NULL),(65,'',0,0,'','admin.main.page.header.right','admin','XLite\\View\\StorefrontStatus',100,'',NULL),(66,'',0,0,'','admin.center','admin','XLite\\View\\MembershipsQuickData\\Main',16777215,'',NULL),(67,'',0,0,'','dashboard-sidebar','admin','XLite\\View\\BenchmarkSummary',300,'',NULL),(68,'',0,0,'','layout.main','customer','XLite\\View\\CategoryBanner',350,'',NULL),(69,'',0,0,'','layout.main.breadcrumb','customer','XLite\\View\\Location',100,'',NULL),(70,'',0,0,'','import.completed.content','admin','XLite\\View\\Import\\Warnings',1000,'',NULL),(71,'',0,0,'','admin.center','admin','XLite\\View\\Page\\PaymentTransaction',16777215,'',NULL),(72,'',0,0,'','admin.center','admin','XLite\\View\\Page\\Admin\\Export',16777215,'',NULL),(73,'',0,0,'','environment.before','admin','XLite\\View\\Page\\Admin\\OldPhpVersionWarning',16777215,'',NULL),(74,'',0,0,'','admin.center','admin','XLite\\View\\Page\\Admin\\Import',16777215,'',NULL),(75,'',0,0,'','admin.center','admin','XLite\\View\\Page\\Layout',16777215,'',NULL),(76,'',0,0,'','admin.center','admin','XLite\\View\\Page\\Logs',16777215,'',NULL),(77,'',0,0,'','admin.center','admin','XLite\\View\\Page\\Images',16777215,'',NULL),(78,'',0,0,'','admin.center','admin','XLite\\View\\Page\\Performance',16777215,'',NULL),(79,'',0,0,'','center','customer','XLite\\View\\CheckoutFailed',16777215,'',NULL),(80,'',0,0,'','center','customer','XLite\\View\\ShippingEstimator\\ShippingEstimate',16777215,'',NULL),(82,'',0,0,'','center.bottom','customer','XLite\\View\\Search',100,'',NULL),(83,'',0,0,'','admin.center','admin','XLite\\View\\Tabs\\FrontPage',16777215,'',NULL),(84,'',0,0,'','admin.center','admin','XLite\\View\\Tabs\\Category',16777215,'',NULL),(85,'',0,0,'','admin.center','admin','XLite\\View\\Tabs\\Countries',16777215,'',NULL),(86,'',0,0,'','admin.center','admin','XLite\\View\\Tabs\\AdminProfile',16777215,'',NULL),(87,'',0,0,'','add_payment','admin','XLite\\View\\Tabs\\OnlinePaymentType',10,'',NULL),(88,'',0,0,'','add_shipping','admin','XLite\\View\\Tabs\\ShippingType',10,'',NULL),(89,'',0,0,'','admin.center','admin','XLite\\View\\Tabs\\Taxes',20,'',NULL),(90,'',0,0,'','admin.center','admin','XLite\\View\\Tabs\\ShippingSettings',16777215,'',NULL),(91,'',0,0,'','admin.center','admin','XLite\\View\\Tabs\\CartCheckout',16777215,'',NULL),(92,'',0,0,'','admin.center','admin','XLite\\View\\Tabs\\Shipping',16777215,'',NULL),(93,'',0,0,'','admin.center','admin','XLite\\View\\Tabs\\BackupRestore',16777215,'',NULL),(94,'',0,0,'','center','customer','XLite\\View\\Tabs\\Account',16777215,'',NULL),(95,'',0,0,'','admin.center','admin','XLite\\View\\Tabs\\Statistics',16777215,'',NULL),(96,'',0,0,'','admin.center','admin','XLite\\View\\Tabs\\Translations',16777215,'',NULL),(97,'',0,0,'','admin.center','admin','XLite\\View\\Tabs\\Notifications',16777215,'',NULL),(98,'',0,0,'','admin.center','admin','XLite\\View\\Tabs\\Localization',16777215,'',NULL),(99,'',0,0,'','admin.center','admin','XLite\\View\\Tabs\\PaymentSettings',16777215,'',NULL),(100,'',0,0,'','admin.center','admin','XLite\\View\\Dashboard',16777215,'',NULL),(101,'',0,0,'','admin.center','admin','XLite\\View\\RecentLogin',16777215,'',NULL),(102,'',0,0,'','admin.center','admin','XLite\\View\\Model\\Profile\\ForceChangePassword',16777215,'',NULL),(103,'',0,0,'','center','customer','XLite\\View\\RecoverPassword',16777215,'',NULL),(104,'',0,0,'','center','customer','XLite\\View\\BackFromPayment',16777215,'',NULL),(105,'',0,0,'','dashboard-center','admin','XLite\\View\\WelcomeBlock\\RootAdmin',50,'',NULL),(106,'',0,0,'','dashboard-center','admin','XLite\\View\\WelcomeBlock\\Admin',50,'',NULL),(107,'',0,0,'','admin.center','admin','XLite\\View\\CacheManagement',16777215,'',NULL),(108,'',0,0,'','center','customer','XLite\\View\\AccessDenied',16777215,'',NULL),(109,'',0,0,'','center','customer','XLite\\View\\SelectAddress',16777215,'',NULL),(110,'',0,0,'','crud.settings.header','admin','XLite\\View\\Promo\\SMTP',100,'',NULL),(111,'',0,0,'','carriers.before','admin','XLite\\View\\Promo\\FreeShippingHowTo',16777215,'',NULL),(112,'',0,0,'','body','customer','XLite\\View\\JSContainer',999999,'',NULL),(113,'',0,0,'','body','admin','XLite\\View\\JSContainer',10,'',NULL),(114,'',0,0,'','admin.center','admin','XLite\\View\\IntegrityCheck\\Page',16777215,'',NULL),(115,'',0,0,'','admin.center','admin','XLite\\View\\AttributeOption',16777215,'',NULL),(116,'',0,0,'','product.details.page.image.photo','customer','XLite\\View\\Product\\Details\\Customer\\Image',10,'',NULL),(117,'',0,0,'','product.details.quicklook.image','customer','XLite\\View\\Product\\Details\\Customer\\Image',10,'',NULL),(118,'',0,0,'','center','customer','XLite\\View\\Product\\Details\\Customer\\Page\\Main',16777215,'',NULL),(119,'',0,0,'','center','customer','XLite\\View\\Product\\Details\\Customer\\Page\\QuickLook',16777215,'',NULL),(122,'',0,0,'','admin.center','admin','XLite\\View\\AttributeGroup',16777215,'',NULL),(123,'',0,0,'','layout.slidebar','customer','XLite\\View\\Slidebar',10,'',NULL),(124,'',0,0,'','layout.main','customer','XLite\\View\\TopMessage',100,'',NULL),(125,'',0,0,'','admin.center','admin','XLite\\View\\RemoveData',16777215,'',NULL),(128,'',0,0,'','header.language.menu','customer','XLite\\View\\LanguageSelector\\Customer',100,'',NULL),(129,'',0,0,'','admin.center','admin','XLite\\View\\FileSelectorDialog',16777215,'',NULL),(130,'',0,0,'','dashboard-sidebar','admin','XLite\\View\\RSS\\RSSLazyLoad',400,'',NULL),(131,'',0,0,'','body','customer','XLite\\View\\Content',100,'',NULL),(132,'',0,0,'','body','admin','XLite\\View\\Content',100,'',NULL),(133,'',0,0,'','center','customer','XLite\\View\\CheckoutSuccess',16777215,'',NULL),(134,'',0,0,'','admin.main.page.content.left','admin','XLite\\View\\Menu\\Admin\\LeftMenu',100,'',NULL),(135,'',0,0,'','admin.main.page.header','admin','XLite\\View\\Menu\\Admin\\Marketplace\\TopMenuNode',300,'',NULL),(136,'',0,0,'','admin.main.page.header','admin','XLite\\View\\Menu\\Admin\\QuickMenu\\TopMenuNode',400,'',NULL),(137,'',0,0,'','admin.main.page.header.right','admin','XLite\\View\\Menu\\Admin\\LanguageSelector\\TopMenuNode',200,'',NULL),(138,'',0,0,'','admin.main.page.header','admin','XLite\\View\\Menu\\Admin\\Info\\TopMenuNode',200,'',NULL),(139,'',0,0,'','admin.main.page.header.right','admin','XLite\\View\\Menu\\Admin\\Account\\TopMenuNode',300,'',NULL),(140,'',0,0,'','slidebar.menu','customer','XLite\\View\\Menu\\Customer\\Top',50,'',NULL),(141,'',0,0,'','header.menu','customer','XLite\\View\\Menu\\Customer\\Top',50,'',NULL),(142,'',0,0,'','layout.main.footer','customer','XLite\\View\\Menu\\Customer\\Footer',100,'',NULL),(143,'',0,0,'','center','customer','XLite\\View\\ChangeAttributeValues',16777215,'',NULL),(144,'',0,0,'','layout.header.categories','customer','XLite\\View\\TopCategoriesSlidebar',10,'',NULL),(145,'',0,0,'','layout.header.mobile','customer','XLite\\View\\MobileHeader',100,'',NULL),(146,'',0,0,'','center.bottom','customer','XLite\\View\\Subcategories',100,'',NULL),(147,'',0,0,'','admin.center','admin','XLite\\View\\Accounting',16777215,'',NULL),(148,'',0,0,'','admin.main.page.header.right','admin','XLite\\View\\Job\\HeaderJobsState',90,'',NULL),(149,'',0,0,'','admin.center','admin','XLite\\View\\ProductSelections',16777215,'',NULL),(150,'',0,0,'','admin.center','admin','XLite\\View\\Payment\\Method',16777215,'',NULL),(151,'',0,0,'','center','customer','XLite\\View\\Payment\\Iframe',16777215,'',NULL),(152,'',0,0,'','admin.center','admin','XLite\\View\\Payment\\AddMethod',16777215,'',NULL),(153,'',0,0,'','admin.main.page.header.left','admin','XLite\\View\\CoreVersion',200,'',NULL),(154,'',0,0,'','main','admin','XLite\\View\\AdminPanel',100,'',NULL),(155,'',0,0,'','center','customer','XLite\\View\\Authorization',16777215,'',NULL),(157,'',0,0,'','admin.main.page.header_wrapper','admin','XLite\\View\\UpgradeTopBox',1000,'',NULL),(158,'',0,0,'','dashboard-sidebar','admin','XLite\\View\\Order\\Statistics\\MiniInformer',100,'',NULL),(159,'',0,0,'','admin.center','admin','XLite\\View\\Order\\Search\\Search',16777215,'',NULL),(160,'',0,0,'','order.actions','admin','XLite\\View\\Order\\Actions',200,'',NULL),(161,'',0,0,'','order.details.payment_actions','admin','XLite\\View\\Order\\Details\\Admin\\PaymentActionsUnit',16777215,'',NULL),(162,'',0,0,'','page.tabs.after','admin','XLite\\View\\Order\\Details\\Admin\\NextPrevious',200,'',NULL),(163,'',0,0,'','order.children','customer','XLite\\View\\Invoice',30,'',NULL),(164,'',0,0,'','center','customer','XLite\\View\\CheckoutCanceled',16777215,'',NULL),(165,'',0,0,'','orders.panel','customer','XLite\\View\\Sort\\Order',20,'',NULL),(166,'',0,0,'','center','customer','XLite\\View\\InvoicePage',16777215,'',NULL),(167,'',0,0,'','admin.main.page.header','admin','XLite\\View\\HeaderSearch',500,'',NULL),(168,'',0,0,'','checkout.review.surcharge.info','customer','XLite\\View\\SurchargeInfo\\CODSurchargeInfo',10,'',NULL),(169,'',0,0,'','taxes.top.section','admin','XLite\\View\\TaxBannerAlert',10,'',NULL),(170,'',0,0,'','admin.main.page.header','admin','XLite\\View\\QueryMarketplace',0,'',NULL),(171,'',0,0,'','order.children','admin','XLite\\View\\PackingSlip',30,'',NULL),(172,'',0,0,'','admin.main.page.header_wrapper','admin','XLite\\View\\ActivateTopBox',500,'',NULL),(173,'',0,0,'','center','customer','XLite\\View\\Terms',16777215,'',NULL),(174,'',0,0,'','admin.center','admin','XLite\\View\\BrowseServer',16777215,'',NULL),(175,'',0,0,'','admin.center','admin','XLite\\View\\ProductClass',16777215,'',NULL),(176,'',0,0,'','admin.center','admin','XLite\\View\\CommonResources',16777215,'',NULL),(177,'',0,0,'','layout.main','customer','XLite\\View\\CommonResources',16777215,'',NULL),(178,'',0,0,'','page.tabs.after','admin','XLite\\View\\Button\\PrintInvoice',200,'',NULL),(179,'',0,0,'','marketplace.addons-filters','admin','XLite\\View\\Button\\Addon\\ActivateLicenseKey',300,'',NULL),(180,'',0,0,'','marketplace.addons-filters','admin','XLite\\View\\Button\\Addon\\EnterLicenseKey',300,'',NULL),(181,'',0,0,'','modules.pager.buttons','admin','XLite\\View\\Button\\AllAddons',100,'',NULL),(182,'',0,0,'','page.tabs.after','admin','XLite\\View\\Button\\PrintPackingSlip',100,'',NULL),(183,'',0,0,'','layout.main.breadcrumb','admin','XLite\\View\\AdminLocation',100,'',NULL),(184,'',0,0,'','admin.center','admin','XLite\\View\\ModulesManager\\UploadAddons',16777215,'',NULL),(185,'',0,0,'','admin.center','admin','XLite\\View\\ModulesManager\\Purchased',16777215,'',NULL),(186,'',0,0,'','admin.center','admin','XLite\\View\\ModulesManager\\Install',16777215,'',NULL),(187,'',0,0,'','admin.center','admin','XLite\\View\\ModulesManager\\ModuleWarnings',16777215,'',NULL),(188,'',0,0,'','admin.center','admin','XLite\\View\\ModulesManager\\KeysNotice',0,'',NULL),(189,'',0,0,'','admin.center','admin','XLite\\View\\ModulesManager\\ModuleLicense',16777215,'',NULL),(190,'',0,0,'','admin.center','admin','XLite\\View\\ModulesManager\\Manage',16777215,'',NULL),(191,'',0,0,'','admin.center','admin','XLite\\View\\ModulesManager\\LicenseKey',16777215,'',NULL),(192,'',0,0,'','admin.center','admin','XLite\\View\\ModulesManager\\TrialNotice',0,'',NULL),(193,'',0,0,'','admin.center','admin','XLite\\View\\ModulesManager\\AddonKey',16777215,'',NULL),(194,'',0,0,'','itemsList.module.manage.columns.module-main-section.actions','admin','XLite\\View\\ModulesManager\\Action\\Main',10,'',NULL),(195,'',0,0,'','itemsList.module.manage.columns.module-main-section.actions','admin','XLite\\View\\ModulesManager\\Action\\Uninstall',100,'',NULL),(196,'',0,0,'','itemsList.module.manage.columns.module-main-section.actions','admin','XLite\\View\\ModulesManager\\Action\\ManageLayout',17,'',NULL),(197,'',0,0,'','itemsList.module.manage.columns.module-main-section.actions','admin','XLite\\View\\ModulesManager\\Action\\Settings',15,'',NULL),(198,'',0,0,'','itemsList.module.manage.columns.module-main-section.actions','admin','XLite\\View\\ModulesManager\\Action\\Pack',30,'',NULL),(199,'',0,0,'','admin.center','admin','XLite\\View\\ModulesManager\\InstallationType',16777215,'',NULL),(200,'',0,0,'','admin.center','admin','XLite\\View\\HttpsSettings',16777215,'',NULL),(202,'',0,0,'','checkout.main','customer','XLite\\View\\Checkout\\Steps',200,'',NULL),(203,'',0,0,'','checkout.review.selected.placeOrder','customer','XLite\\View\\Checkout\\Payment',100,'',NULL),(204,'',0,0,'','checkout.shipping.selected.sub.payment','customer','XLite\\View\\Checkout\\PaymentMethodsList',300,'',NULL),(205,'',0,0,'','checkout.review.selected','customer','XLite\\View\\Checkout\\CartItems',10,'',NULL),(206,'',0,0,'','center','customer','XLite\\View\\BackToTop',16777215,'',NULL),(207,'',0,0,'','admin.center','admin','XLite\\View\\Tabber',1000,'',NULL),(208,'',0,0,'','layout.header.right','customer','XLite\\View\\Minicart',100,'',NULL),(209,'',0,0,'','admin.center','admin','XLite\\View\\Promotions',16777215,'',NULL),(210,'',0,0,'','center','customer','XLite\\View\\AccessControl',16777215,'',NULL),(211,'',0,0,'','sidebar.footer','customer','XLite\\View\\PoweredBy',16777215,'',NULL),(212,'',0,0,'','center','customer','XLite\\Module\\Amazon\\PayWithAmazon\\View\\AmazonCheckout',16777215,'',NULL),(213,'',0,0,'','center.top','customer','XLite\\Module\\Amazon\\PayWithAmazon\\View\\CheckoutButton',100,'',NULL),(214,'',0,0,'','center.bottom','customer','XLite\\Module\\CDev\\Bestsellers\\View\\Bestsellers',400,'',NULL),(215,'',0,0,'','center','customer','XLite\\Module\\CDev\\Bestsellers\\View\\BestsellersPage',16777215,'',NULL),(216,'',0,0,'','center','customer','XLite\\Module\\CDev\\ContactUs\\View\\ContactUs',16777215,'',NULL),(217,'',0,0,'','admin.center','admin','XLite\\Module\\CDev\\Coupons\\View\\Coupon',16777215,'',NULL),(218,'',0,0,'','coupons.itemsList.footer','admin','XLite\\Module\\CDev\\Coupons\\View\\Panel\\Coupons',16777215,'',NULL),(219,'',0,0,'','cart.panel.box','customer','XLite\\Module\\CDev\\Coupons\\View\\CartCoupons',200,'',NULL),(221,'',0,0,'','checkout_fastlane.sections.details','customer','XLite\\Module\\CDev\\Coupons\\View\\CartCoupons',200,'',NULL),(222,'',0,0,'','invoice.item.name','customer','XLite\\Module\\CDev\\Egoods\\View\\Order\\ItemBox',16777215,'',NULL),(223,'',0,0,'','invoice.item.name','mail','XLite\\Module\\CDev\\Egoods\\View\\Order\\ItemBox',16777215,'',NULL),(224,'',0,0,'','page.tabs.after','admin','XLite\\Module\\CDev\\Egoods\\View\\Button\\BlockAll',0,'',NULL),(225,'',0,0,'','page.tabs.after','admin','XLite\\Module\\CDev\\Egoods\\View\\Button\\RenewAll',0,'',NULL),(226,'',0,0,'','admin.center','admin','XLite\\Module\\CDev\\FeaturedProducts\\View\\FProducts',16777215,'',NULL),(227,'',0,0,'','admin.center','admin','XLite\\Module\\CDev\\FeaturedProducts\\View\\ProductSelections',16777215,'',NULL),(228,'',0,0,'','center.bottom','customer','XLite\\Module\\CDev\\FeaturedProducts\\View\\Customer\\FeaturedProducts',300,'',NULL),(229,'',0,0,'','product.details.page.tab.description.file-attachments','customer','XLite\\Module\\CDev\\FileAttachments\\View\\Product\\Customer',10,'',NULL),(230,'',0,0,'','body','customer','XLite\\Module\\CDev\\GoSocial\\View\\ExternalSDK\\Facebook',999998,'',NULL),(231,'',0,0,'','product.modify.list','admin','XLite\\Module\\CDev\\GoSocial\\View\\ProductModify',1015,'',NULL),(232,'',0,0,'','product.details.page.tab.comments','customer','XLite\\Module\\CDev\\GoSocial\\View\\FacebookComments',16777215,'',NULL),(233,'',0,0,'','buttons.share','customer','XLite\\Module\\CDev\\GoSocial\\View\\Button\\Tweet',200,'',NULL),(234,'',0,0,'','buttons.share','customer','XLite\\Module\\CDev\\GoSocial\\View\\Button\\Facebook',100,'',NULL),(235,'',0,0,'','buttons.share','customer','XLite\\Module\\CDev\\GoSocial\\View\\Button\\Pinterest',400,'',NULL),(236,'',0,0,'','buttons.share','customer','XLite\\Module\\CDev\\GoSocial\\View\\Button\\GooglePlus',300,'',NULL),(237,'',0,0,'','buttons.share','customer','XLite\\Module\\CDev\\GoSocial\\View\\Button\\FacebookLike',50,'',NULL),(238,'',0,0,'','layout.footer','customer','XLite\\Module\\CDev\\GoogleAnalytics\\View\\GAActions',16777215,'',NULL),(239,'',0,0,'','body','admin','XLite\\Module\\CDev\\GoogleAnalytics\\View\\GAActions',16777215,'',NULL),(240,'',0,0,'','head','customer','XLite\\Module\\CDev\\GoogleAnalytics\\View\\Header\\Traditional',16777215,'',NULL),(241,'',0,0,'','head','customer','XLite\\Module\\CDev\\GoogleAnalytics\\View\\Header\\Universal',16777215,'',NULL),(242,'',0,0,'','head','admin','XLite\\Module\\CDev\\GoogleAnalytics\\View\\Header\\Universal',16777215,'',NULL),(243,'',0,0,'','tabs.content','admin','XLite\\Module\\CDev\\GoogleAnalytics\\View\\TabberLink',16777215,'',NULL),(244,'',0,0,'','admin.center','admin','XLite\\Module\\CDev\\Moneybookers\\View\\MoneybookersSettings',16777215,'',NULL),(245,'',0,0,'','product.pinCodes','admin','XLite\\Module\\CDev\\PINCodes\\View\\ItemsList\\Model\\PinCode\\Admin\\Manage',500,'',NULL),(246,'',0,0,'','admin.center','admin','XLite\\Module\\CDev\\PINCodes\\View\\AddPinCodesDialog',16777215,'',NULL),(247,'',0,0,'','invoice.item.name','customer','XLite\\Module\\CDev\\PINCodes\\View\\InvoicePinCodes',200,'',NULL),(248,'',0,0,'','invoice.item.name','admin','XLite\\Module\\CDev\\PINCodes\\View\\InvoicePinCodes',30,'',NULL),(249,'',0,0,'','crud.paypalbutton.formHeader','admin','XLite\\Module\\CDev\\Paypal\\View\\ItemsList\\Model\\PaypalButton',100,'',NULL),(250,'',0,0,'','admin.center','admin','XLite\\Module\\CDev\\Paypal\\View\\Tabs\\Settings',16777215,'',NULL),(251,'',0,0,'','dashboard-center','admin','XLite\\Module\\CDev\\Paypal\\View\\WelcomeBlock\\Paypal',20,'',NULL),(252,'',0,0,'','cart.panel.totals','customer','XLite\\Module\\CDev\\Paypal\\View\\Button\\Cart\\ExpressCheckout',100,'',NULL),(253,'',0,0,'','cart.panel.totals','customer','XLite\\Module\\CDev\\Paypal\\View\\Button\\Cart\\ButtonsSeparator',90,'',NULL),(254,'',0,0,'','minicart.horizontal.buttons','customer','XLite\\Module\\CDev\\Paypal\\View\\Button\\Minicart\\ExpressCheckout',100,'',NULL),(255,'',0,0,'','minicart.horizontal.buttons','customer','XLite\\Module\\CDev\\Paypal\\View\\Button\\Minicart\\ButtonsSeparator',90,'',NULL),(256,'',0,0,'','checkout.review.selected.placeOrder','customer','XLite\\Module\\CDev\\Paypal\\View\\Button\\Checkout\\ExpressCheckout',450,'',NULL),(257,'',0,0,'','checkout_fastlane.sections.place-order.before','customer','XLite\\Module\\CDev\\Paypal\\View\\Button\\Checkout\\ExpressCheckout',100,'',NULL),(258,'',0,0,'','checkout.review.selected.placeOrder','customer','XLite\\Module\\CDev\\Paypal\\View\\Button\\Checkout\\PaypalCredit',450,'',NULL),(259,'',0,0,'','checkout_fastlane.sections.place-order.before','customer','XLite\\Module\\CDev\\Paypal\\View\\Button\\Checkout\\PaypalCredit',100,'',NULL),(260,'',0,0,'','checkout.review.selected.placeOrder','customer','XLite\\Module\\CDev\\Paypal\\View\\Button\\Checkout\\PaypalForMarketplaces',450,'',NULL),(261,'',0,0,'','checkout_fastlane.sections.place-order.before','customer','XLite\\Module\\CDev\\Paypal\\View\\Button\\Checkout\\PaypalForMarketplaces',100,'',NULL),(262,'',0,0,'','center.bottom','customer','XLite\\Module\\CDev\\ProductAdvisor\\View\\ViewedBought',800,'',NULL),(263,'',0,0,'','sidebar.second','customer','XLite\\Module\\CDev\\ProductAdvisor\\View\\NewArrivals',600,'',NULL),(264,'',0,0,'','center','customer','XLite\\Module\\CDev\\ProductAdvisor\\View\\ComingSoonPage',16777215,'',NULL),(265,'',0,0,'','sidebar.second','customer','XLite\\Module\\CDev\\ProductAdvisor\\View\\ComingSoon',700,'',NULL),(266,'',0,0,'','center.bottom','customer','XLite\\Module\\CDev\\ProductAdvisor\\View\\BoughtBought',700,'',NULL),(267,'',0,0,'','center.bottom','customer','XLite\\Module\\CDev\\ProductAdvisor\\View\\RecentlyViewed',500,'',NULL),(268,'',0,0,'','center','customer','XLite\\Module\\CDev\\ProductAdvisor\\View\\NewArrivalsPage',16777215,'',NULL),(269,'',0,0,'','center','customer','XLite\\Module\\CDev\\Sale\\View\\SalePage',16777215,'',NULL),(270,'',0,0,'','admin.center','admin','XLite\\Module\\CDev\\Sale\\View\\SaleSelectedDialog',16777215,'',NULL),(271,'',0,0,'','sidebar.first','customer','XLite\\Module\\CDev\\Sale\\View\\SaleBlock',1000,'',NULL),(272,'',0,0,'','center','customer','XLite\\Module\\CDev\\SimpleCMS\\View\\CustomerPage',16777215,'',NULL),(273,'',0,0,'','admin.center','admin','XLite\\Module\\CDev\\SimpleCMS\\View\\ItemsList\\Model\\Page',16777215,'',NULL),(274,'',0,0,'','admin.center','admin','XLite\\Module\\CDev\\SimpleCMS\\View\\Page\\LogoFavicon',16777215,'',NULL),(275,'',0,0,'','admin.main.page.content.center','admin','XLite\\Module\\CDev\\SimpleCMS\\View\\MenuFormattedPath',7,'',NULL),(276,'',0,0,'','admin.center','admin','XLite\\Module\\CDev\\SimpleCMS\\View\\Page',16777215,'',NULL),(277,'',0,0,'','admin.center','admin','XLite\\Module\\CDev\\UserPermissions\\View\\Roles',16777215,'',NULL),(278,'',0,0,'','admin.center','admin','XLite\\Module\\CDev\\UserPermissions\\View\\Role',16777215,'',NULL),(279,'',0,0,'','checkout.review.selected','customer','XLite\\Module\\CDev\\VolumeDiscounts\\View\\CheckoutPromo',14,'',NULL),(280,'',0,0,'','checkout.review.inactive','customer','XLite\\Module\\CDev\\VolumeDiscounts\\View\\CheckoutPromo',14,'',NULL),(281,'',0,0,'','cart.panel.totals','customer','XLite\\Module\\CDev\\VolumeDiscounts\\View\\CartPromo',300,'',NULL),(282,'',0,0,'','admin.center','admin','XLite\\Module\\CDev\\XMLSitemap\\View\\Admin\\SitemapTabs',16777215,'',NULL),(283,'',0,0,'','admin.center','admin','XLite\\Module\\CDev\\XPaymentsConnector\\View\\PopupAddInfo',16777215,'',NULL),(284,'',0,0,'','admin.center','admin','XLite\\Module\\CDev\\XPaymentsConnector\\View\\PopupSavedCards',16777215,'',NULL),(285,'',0,0,'','center','customer','XLite\\Module\\CDev\\XPaymentsConnector\\View\\AddNewCard',16777215,'',NULL),(286,'',0,0,'','center','admin','XLite\\Module\\CDev\\XPaymentsConnector\\View\\SavedCards',16777215,'',NULL),(287,'',0,0,'','center','customer','XLite\\Module\\CDev\\XPaymentsConnector\\View\\XpcPopup',16777215,'',NULL),(288,'',0,0,'','admin.center','admin','XLite\\Module\\CDev\\XPaymentsConnector\\View\\AdminAddNewCard',16777215,'',NULL),(289,'',0,0,'','admin.center','admin','XLite\\Module\\QSL\\BraintreeVZ\\View\\BraintreeCreditCardsAdmin',16777215,'',NULL),(290,'',0,0,'','admin.center','admin','XLite\\Module\\QSL\\BraintreeVZ\\View\\Tabs\\Config',16777215,'',NULL),(291,'',0,0,'','cart.panel.totals','customer','XLite\\Module\\QSL\\BraintreeVZ\\View\\Button\\PayPal',100,'',NULL),(292,'',0,0,'','minicart.horizontal.buttons','customer','XLite\\Module\\QSL\\BraintreeVZ\\View\\Button\\PayPal',100,'',NULL),(293,'',0,0,'','add2cart_popup.item.buttons','customer','XLite\\Module\\QSL\\BraintreeVZ\\View\\Button\\PayPal',300,'',NULL),(294,'',0,0,'','sidebar.single','customer','XLite\\Module\\QSL\\CloudSearch\\View\\CloudFilters\\FiltersBoxPlaceholder',102,'',NULL),(295,'',0,0,'','sidebar.first','customer','XLite\\Module\\QSL\\CloudSearch\\View\\CloudFilters\\FiltersBoxPlaceholder',102,'',NULL),(296,'',0,0,'','layout.slidebar','customer','XLite\\Module\\QSL\\CloudSearch\\View\\CloudFilters\\Slidebar',20,'',NULL),(297,'',0,0,'','admin.center','admin','XLite\\Module\\XC\\BulkEditing\\View\\FormModel\\Product',16777215,'',NULL),(298,'',0,0,'','center','customer','XLite\\Module\\XC\\CanadaPost\\View\\TrackingDetails',16777215,'',NULL),(299,'',0,0,'','admin.center','admin','XLite\\Module\\XC\\CanadaPost\\View\\TrackingDetails',16777215,'',NULL),(300,'',0,0,'','admin.center','admin','XLite\\Module\\XC\\CanadaPost\\View\\ProductsReturns',16777215,'',NULL),(301,'',0,0,'','admin.center','admin','XLite\\Module\\XC\\CanadaPost\\View\\ProductsReturn',16777215,'',NULL),(302,'',0,0,'','invoice.bottom','customer','XLite\\Module\\XC\\CanadaPost\\View\\Invoice\\DeliveryToPost',15,'',NULL),(303,'',0,0,'','invoice.bottom','customer','XLite\\Module\\XC\\CanadaPost\\View\\Invoice\\Tracking',25,'',NULL),(304,'',0,0,'','order.children','admin','XLite\\Module\\XC\\CanadaPost\\View\\PackingSlip',30,'',NULL),(305,'',0,0,'','center','customer','XLite\\Module\\XC\\CanadaPost\\View\\ReturnProducts',16777215,'',NULL),(306,'',0,0,'','checkout.shipping.selected.sub.payment','customer','XLite\\Module\\XC\\CanadaPost\\View\\Checkout\\PostOfficesList',210,'',NULL),(307,'',0,0,'','head','admin','XLite\\Module\\XC\\Concierge\\View\\Initialization',16777215,'',NULL),(308,'',0,0,'','layout.header.right','customer','XLite\\Module\\XC\\CrispWhiteSkin\\View\\HeaderSettings',30,'',NULL),(309,'',0,0,'','itemsList.product.grid.customer.header','customer','XLite\\Module\\XC\\CrispWhiteSkin\\View\\FiltersMobile',40,'',NULL),(310,'',0,0,'','itemsList.product.list.customer.header','customer','XLite\\Module\\XC\\CrispWhiteSkin\\View\\FiltersMobile',40,'',NULL),(311,'',0,0,'','itemsList.product.table.customer.header','customer','XLite\\Module\\XC\\CrispWhiteSkin\\View\\FiltersMobile',40,'',NULL),(312,'',0,0,'','product.details.page.image','customer','XLite\\Module\\XC\\CrispWhiteSkin\\View\\Product\\Details\\Customer\\GalleryMobile',11,'',NULL),(313,'',0,0,'','slidebar.settings','customer','XLite\\Module\\XC\\CrispWhiteSkin\\View\\LanguageSelector\\WrapperSlidebar',200,'',NULL),(314,'',0,0,'','layout.header.bar.locale.menu','customer','XLite\\Module\\XC\\CrispWhiteSkin\\View\\LanguageSelector\\WrapperSingle',30,'',NULL),(315,'',0,0,'','layout.header.right.settings','customer','XLite\\Module\\XC\\CrispWhiteSkin\\View\\LanguageSelector\\Wrapper',200,'',NULL),(316,'',0,0,'','layout.header.bar','customer','XLite\\Module\\XC\\CrispWhiteSkin\\View\\LanguageSelector\\LocaleIndicator',80,'',NULL),(317,'',0,0,'','layout.header.bar.links.logged','customer','XLite\\Module\\XC\\CrispWhiteSkin\\View\\Menu\\Customer\\OrdersList',300,'',NULL),(318,'',0,0,'','contact_us.parts.last','customer','XLite\\Module\\XC\\CrispWhiteSkin\\View\\ContactsContactUsFooter',10,'',NULL),(319,'',0,0,'','admin.center','admin','XLite\\Module\\XC\\CustomProductTabs\\View\\GlobalTabs',16777215,'',NULL),(320,'',0,0,'','admin.center','admin','XLite\\Module\\XC\\CustomProductTabs\\View\\ProductTabs',16777215,'',NULL),(321,'',0,0,'','admin.center','admin','XLite\\Module\\XC\\CustomProductTabs\\View\\ProductTab',16777215,'',NULL),(322,'',0,0,'','admin.center','admin','XLite\\Module\\XC\\CustomProductTabs\\View\\GlobalTab',16777215,'',NULL),(323,'',0,0,'','center','customer','XLite\\Module\\XC\\CustomerAttachments\\View\\AttachmentPopup',16777215,'',NULL),(324,'',0,0,'','invoice.item.name','admin','XLite\\Module\\XC\\CustomerAttachments\\View\\AttachmentsList',100,'',NULL),(325,'',0,0,'','product.details.page.info','customer','XLite\\Module\\XC\\CustomerAttachments\\View\\Product\\CustomerAttachmentsInput',45,'',NULL),(326,'',0,0,'','product.details.quicklook.info','customer','XLite\\Module\\XC\\CustomerAttachments\\View\\Product\\CustomerAttachmentsInput',65,'',NULL),(327,'',0,0,'','cart.item.info','customer','XLite\\Module\\XC\\CustomerAttachments\\View\\AddPopup',80,'',NULL),(328,'',0,0,'','center','customer','XLite\\Module\\XC\\FastLaneCheckout\\View\\CheckoutFastlane',16777215,'',NULL),(329,'',0,0,'','checkout_fastlane','customer','XLite\\Module\\XC\\FastLaneCheckout\\View\\Blocks\\AddressMetadata',99999,'',NULL),(330,'',0,0,'','checkout_fastlane','customer','XLite\\Module\\XC\\FastLaneCheckout\\View\\Blocks\\AddressForm\\BillingMetadata',99999,'',NULL),(331,'',0,0,'','checkout_fastlane','customer','XLite\\Module\\XC\\FastLaneCheckout\\View\\Blocks\\AddressForm\\ShippingMetadata',99999,'',NULL),(332,'',0,0,'','import.failed.content','admin','XLite\\Module\\XC\\FreeShipping\\View\\Promo\\FreeShippingUpdateImport',0,'',NULL),(333,'',0,0,'','crud.modulesettings.header','admin','XLite\\Module\\XC\\FreeShipping\\View\\Promo\\FreeShippingUpdate',100,'',NULL),(334,'',0,0,'','admin.center','admin','XLite\\Module\\XC\\FroalaEditor\\View\\Settings',16777215,'',NULL),(335,'',0,0,'','crud.modulesettings.header','admin','XLite\\Module\\XC\\Geolocation\\View\\Settings\\GeolocationHeader',100,'',NULL),(337,'',0,0,'','admin.center','admin','XLite\\Module\\XC\\MailChimp\\View\\ItemsList\\Model\\MailChimpGroupNames',16777215,'',NULL),(338,'',0,0,'','admin.center','admin','XLite\\Module\\XC\\MailChimp\\View\\ItemsList\\Model\\MailChimpGroup',16777215,'',NULL),(339,'',0,0,'','admin.center','admin','XLite\\Module\\XC\\MailChimp\\View\\Tabs\\Settings',16777215,'',NULL),(340,'',0,0,'','admin.center','admin','XLite\\Module\\XC\\MailChimp\\View\\MailChimpSegments',200,'',NULL),(341,'',0,0,'','admin.center','admin','XLite\\Module\\XC\\MailChimp\\View\\MailChimpLists',200,'',NULL),(342,'',0,0,'','crud.modulesettings.header','admin','XLite\\Module\\XC\\MailChimp\\View\\Settings\\MailChimpHeader',100,'',NULL),(343,'',0,0,'','admin.center','admin','XLite\\Module\\XC\\MailChimp\\View\\MailChimpSegment',200,'',NULL),(344,'',0,0,'','center','customer','XLite\\Module\\XC\\News\\View\\Page\\Customer\\NewsMessages',16777215,'',NULL),(345,'',0,0,'','center','customer','XLite\\Module\\XC\\News\\View\\Page\\Customer\\NewsMessage',16777215,'',NULL),(346,'',0,0,'','admin.center','admin','XLite\\Module\\XC\\News\\View\\NewsMessages',16777215,'',NULL),(347,'',0,0,'','sidebar.first','customer','XLite\\Module\\XC\\News\\View\\TopNewsSideBar',16777215,'',NULL),(348,'',0,0,'','admin.center','admin','XLite\\Module\\XC\\News\\View\\NewsMessage',16777215,'',NULL),(349,'',0,0,'','admin.center','admin','XLite\\Module\\XC\\NewsletterSubscriptions\\View\\ItemsList\\Subscribers',16777215,'',NULL),(351,'',0,0,'','admin.center','admin','XLite\\Module\\XC\\NewsletterSubscriptions\\View\\MailChimpPlaceholder',0,'',NULL),(353,'',0,0,'','head','customer','XLite\\Module\\XC\\NextPreviousProduct\\View\\Initialization',1305,'',NULL),(354,'',0,0,'','dashboard-sidebar','admin','XLite\\Module\\XC\\Onboarding\\View\\Dashboard\\WizardStatus',50,'',NULL),(355,'',0,0,'','admin.center','admin','XLite\\Module\\XC\\Onboarding\\View\\Wizard',16777215,'',NULL),(356,'',0,0,'','admin.center','admin','XLite\\Module\\XC\\Onboarding\\View\\MiniWizardStatus',100,'',NULL),(357,'',0,0,'','center','customer','XLite\\Module\\XC\\ProductComparison\\View\\ComparisonTable',16777215,'',NULL),(358,'',0,0,'','product.details.page.info.buttons.cart-buttons','customer','XLite\\Module\\XC\\ProductComparison\\View\\AddToCompare\\Product',120,'',NULL),(359,'',0,0,'','product.details.page.info.buttons-added.cart-buttons','customer','XLite\\Module\\XC\\ProductComparison\\View\\AddToCompare\\Product',120,'',NULL),(362,'',0,0,'','comparison_table.data','customer','XLite\\Module\\XC\\ProductComparison\\View\\ComparisonTable\\Attributes',300,'',NULL),(363,'',0,0,'','center.bottom','customer','XLite\\Module\\XC\\ProductFilter\\View\\ItemsList\\Product\\Customer\\Category\\CategoryFilter',200,'',NULL),(364,'',0,0,'','sidebar.filter','customer','XLite\\Module\\XC\\ProductFilter\\View\\Filter\\Attributes',300,'',NULL),(365,'',0,0,'','sidebar.filter','customer','XLite\\Module\\XC\\ProductFilter\\View\\Filter\\InStockOnly',200,'',NULL),(366,'',0,0,'','sidebar.filter','customer','XLite\\Module\\XC\\ProductFilter\\View\\Filter\\PriceRange',100,'',NULL),(367,'',0,0,'','sidebar.first','customer','XLite\\Module\\XC\\ProductFilter\\View\\Filter',300,'',NULL),(368,'',0,0,'','sidebar.filter','customer','XLite\\Module\\XC\\ProductTags\\View\\Filter\\Tags',400,'',NULL),(369,'',0,0,'','product.details.page.info','customer','XLite\\Module\\XC\\ProductTags\\View\\TagsList',15,'',NULL),(370,'',0,0,'','sidebar.first','customer','XLite\\Module\\XC\\ProductTags\\View\\TagsBox',200,'',NULL),(371,'',0,0,'','admin.center','admin','XLite\\Module\\XC\\ProductTags\\View\\Tags',16777215,'',NULL),(372,'',0,0,'','admin.center','admin','XLite\\Module\\XC\\Reviews\\View\\ItemsList\\Model\\Review',16777215,'',NULL),(373,'',0,0,'','admin.center','admin','XLite\\Module\\XC\\Reviews\\View\\Review',16777215,'',NULL),(374,'',0,0,'','product.details.page.tab.reviews','customer','XLite\\Module\\XC\\Reviews\\View\\Product\\ReviewsTab',16777215,'',NULL),(375,'',0,0,'','center','customer','XLite\\Module\\XC\\Reviews\\View\\Customer\\ProductReviews',16777215,'',NULL),(376,'',0,0,'','product.reviews.tab','customer','XLite\\Module\\XC\\Reviews\\View\\Customer\\ReviewsTab',300,'',NULL),(377,'',0,0,'','center','customer','XLite\\Module\\XC\\Sitemap\\View\\Page\\Customer\\Map',16777215,'',NULL),(378,'',0,0,'','layout.main','customer','XLite\\Module\\XC\\ThemeTweaker\\View\\ThemeTweakerPanel',0,'',NULL),(379,'',0,0,'','admin.center','admin','XLite\\Module\\XC\\ThemeTweaker\\View\\ThemeTweakerTemplates',16777215,'',NULL),(380,'',0,0,'','themetweaker-panel--content','customer','XLite\\Module\\XC\\ThemeTweaker\\View\\ThemeTweaker\\CssEditor',100,'',NULL),(381,'',0,0,'','themetweaker-panel--content','customer','XLite\\Module\\XC\\ThemeTweaker\\View\\ThemeTweaker\\WebmasterMode',100,'',NULL),(382,'',0,0,'','themetweaker-panel--content','customer','XLite\\Module\\XC\\ThemeTweaker\\View\\ThemeTweaker\\InlineEditor',100,'',NULL),(383,'',0,0,'','themetweaker-panel--content','customer','XLite\\Module\\XC\\ThemeTweaker\\View\\ThemeTweaker\\LayoutEditor',100,'',NULL),(384,'',0,0,'','themetweaker-panel--content','customer','XLite\\Module\\XC\\ThemeTweaker\\View\\ThemeTweaker\\LabelsEditor',100,'',NULL),(385,'',0,0,'','themetweaker-panel-extensions','customer','XLite\\Module\\XC\\ThemeTweaker\\View\\ThemeTweaker\\Modal',999,'',NULL),(386,'',0,0,'','admin.center','admin','XLite\\Module\\XC\\ThemeTweaker\\View\\Tabs\\CustomCssJS',16777215,'',NULL),(387,'',0,0,'','admin.center','admin','XLite\\Module\\XC\\ThemeTweaker\\View\\NotificationEditor',16777215,'',NULL),(388,'',0,0,'','layout_settings.settings','admin','XLite\\Module\\XC\\ThemeTweaker\\View\\PanelHelp',100,'',NULL),(389,'',0,0,'','admin.center','admin','XLite\\Module\\XC\\ThemeTweaker\\View\\ThemeTweakerTemplate',16777215,'',NULL),(390,'',0,0,'','admin.center','admin','XLite\\Module\\XC\\ThemeTweaker\\View\\FlexyToTwig',16777215,'',NULL),(391,'',0,0,'','admin.center','admin','XLite\\Module\\XC\\UpdateInventory\\View\\UpdateInventory',16777215,'',NULL),(392,'',0,0,'','center.bottom','customer','XLite\\Module\\XC\\Upselling\\View\\ItemsList\\UpsellingProducts',700,'',NULL),(393,'',0,0,'','admin.center','admin','XLite\\Module\\XC\\Upselling\\View\\ProductSelections',16777215,'',NULL),(394,'',0,0,'','layout.header.bar.links.logged','customer','XLite\\Module\\XC\\VendorMessages\\View\\CustomerTopLink',100,'',NULL),(395,'',0,0,'','admin.center','admin','XLite\\Module\\XC\\VendorMessages\\View\\Page\\Admin\\Messages',16777215,'',NULL),(396,'',0,0,'','admin.center','admin','XLite\\Module\\XC\\VendorMessages\\View\\Page\\Conversation',16777215,'',NULL),(397,'',0,0,'','center','customer','XLite\\Module\\XC\\VendorMessages\\View\\Page\\Conversation',16777215,'',NULL),(398,'',0,0,'','center','customer','XLite\\Module\\XC\\VendorMessages\\View\\Page\\Customer\\OrderMessages',16777215,'',NULL),(399,'',0,0,'','product.vendor_info.popover_content','customer','XLite\\Module\\XC\\VendorMessages\\View\\ContactNow',40,'',NULL),(400,'',0,0,'','vendorpage.vendor_info','customer','XLite\\Module\\XC\\VendorMessages\\View\\ContactNow',2000,'',NULL),(401,'',0,0,'','invoice.base.totals.after','pdf','',20,'order/invoice/parts/totals.includedModifiers.twig',NULL),(402,'',0,0,'','invoice.item','pdf','',40,'order/invoice/parts/items/item.total.twig',NULL),(403,'',0,0,'','invoice.item','pdf','',20,'order/invoice/parts/items/item.price.twig',NULL),(404,'',0,0,'','invoice.base','customer','',10,'order/invoice/parts/head.twig',NULL),(405,'',0,0,'','invoice.base.totals.after','customer','',20,'order/invoice/parts/totals.includedModifiers.twig',NULL),(406,'',0,0,'','invoice.item','customer','',40,'order/invoice/parts/items/item.total.twig',NULL),(407,'',0,0,'','invoice.item','customer','',20,'order/invoice/parts/items/item.price.twig',NULL),(408,'',0,0,'','order.status','customer','',20,'order/parts/status.shipping.twig',NULL),(409,'',0,0,'','order.links','customer','',100,'order/parts/link.print.twig',NULL),(410,'',0,0,'','order.children','customer','',20,'order/parts/links.twig',NULL),(411,'',0,0,'','order.status','customer','',10,'order/parts/status.payment.twig',NULL),(412,'',0,0,'','order.children','customer','',10,'order/parts/status.twig',NULL),(413,'',0,0,'','recover.password.fields','customer','',200,'recover_password/parts/form.user.twig',NULL),(414,'',0,0,'','recover.password','customer','',100,'recover_password/parts/note.twig',NULL),(415,'',0,0,'','recover.password','customer','',200,'recover_password/parts/form.twig',NULL),(416,'',0,0,'','recover.password.fields','customer','',300,'recover_password/parts/form.button.twig',NULL),(417,'',0,0,'','recover.password.fields','customer','',100,'recover_password/parts/form.email.twig',NULL),(418,'',0,0,'','customer.signin.links','customer','',200,'authorization/parts/link.forgot.twig',NULL),(419,'',0,0,'','customer.signin.fields','customer','',500,'authorization/parts/field.links.twig',NULL),(420,'',0,0,'','customer.signin.fields','customer','',400,'authorization/parts/field.button.twig',NULL),(421,'',0,0,'','customer.signin.popup.fields','customer','',400,'authorization/parts/field.button.twig',NULL),(422,'',0,0,'','customer.signin.fields','customer','',200,'authorization/parts/field.password.twig',NULL),(423,'',0,0,'','customer.signin.popup.fields','customer','',200,'authorization/parts/field.password.twig',NULL),(424,'',0,0,'','customer.signin.links','customer','',100,'authorization/parts/link.create.twig',NULL),(425,'',0,0,'','customer.signin.links','customer','',200,'authorization/parts/link.bullet.twig',NULL),(426,'',0,0,'','customer.signin.fields','customer','',100,'authorization/parts/field.name.twig',NULL),(427,'',0,0,'','customer.signin.popup.fields','customer','',100,'authorization/parts/field.name.twig',NULL),(428,'',0,0,'','customer.signin.fields','customer','',300,'authorization/parts/field.message.twig',NULL),(429,'',0,0,'','customer.signin.popup.fields','customer','',300,'authorization/parts/field.message.twig',NULL),(430,'',0,0,'','footer','customer','',100,'footer/parts/css_aggregation.twig',NULL),(431,'',0,0,'','pager.itemsTotal','customer','',20,'pager/parts/items_total.twig',NULL),(432,'',0,0,'','productBlock.info','customer','',100,'product_box/parts/photo.twig',NULL),(433,'',0,0,'','productBlock.info','customer','',400,'product_box/parts/add2cart.twig',NULL),(434,'',0,0,'','orders.children.actions','customer','',100,'items_list/order/parts/actions.reorder.twig',NULL),(435,'',0,0,'','orders.children.view_all_items_link','customer','',10,'items_list/order/parts/view_all_items_link.twig',NULL),(436,'',0,0,'','orders.children.spec','customer','',300,'items_list/order/parts/spec.date.twig',NULL),(437,'',0,0,'','orders.children.spec','customer','',500,'items_list/order/parts/spec.total.twig',NULL),(438,'',0,0,'','orders.children.spec','customer','',100,'items_list/order/parts/spec.switcher.twig',NULL),(439,'',0,0,'','orders.children.spec','customer','',200,'items_list/order/parts/spec.number.twig',NULL),(440,'',0,0,'','orders.children.spec','customer','',600,'items_list/order/parts/spec.count.twig',NULL),(441,'',0,0,'','orders.children.spec','customer','',400,'items_list/order/parts/spec.break.twig',NULL),(442,'',0,0,'','orders.children.shipping','customer','',100,'items_list/order/parts/shipping.name.twig',NULL),(443,'',0,0,'','itemsList.product.list.customer.body','customer','',40,'items_list/product/center/list/parts/body/body.twig',NULL),(444,'',0,0,'','itemsList.product.list.customer.body','customer','',20,'items_list/product/center/list/parts/body/thumbnail.twig',NULL),(445,'',0,0,'','itemsList.product.table.customer.captions','customer','',40,'items_list/product/parts/table.captions.price.twig',NULL),(449,'',0,0,'','itemsList.product.big_thumbnails.customer.info','customer','',0,'items_list/product/parts/common.drag-n-drop-handle.twig',NULL),(450,'',0,0,'','itemsList.product.table.customer.columns','customer','',50,'items_list/product/parts/common.button-add2cart.twig',NULL),(455,'',0,0,'','itemsList.product.list.customer.photo','customer','',10,'items_list/product/parts/common.product-thumbnail-aligned-top.twig',NULL),(456,'',0,0,'','itemsList.product.small_thumbnails.customer.info','customer','',20,'items_list/product/parts/small-thumbnails.details.twig',NULL),(457,'',0,0,'','itemsList.product.grid.customer.info.photo','customer','',999,'items_list/product/parts/common.quicklook-button.twig',NULL),(458,'',0,0,'','itemsList.product.list.customer.quicklook','customer','',999,'items_list/product/parts/common.quicklook-button.twig',NULL),(459,'',0,0,'','productBlock.info','customer','',999,'items_list/product/parts/common.quicklook-button.twig',NULL),(460,'',0,0,'','itemsList.product.list.customer.info','customer','',30,'items_list/product/parts/common.product-description.twig',NULL),(461,'',0,0,'','itemsList.product.table.customer.captions','customer','',10,'items_list/product/parts/table.captions.sku.twig',NULL),(462,'',0,0,'','itemsList.product.table.customer.captions','customer','',25,'items_list/product/parts/table.captions.labels.twig',NULL),(463,'',0,0,'','itemsList.product.list.customer.info','customer','',1000,'items_list/product/parts/list.button-add2cart.twig',NULL),(464,'',0,0,'','itemsList.product.table.customer.captions','customer','',20,'items_list/product/parts/table.captions.name.twig',NULL),(466,'',0,0,'','itemsList.product.table.customer.captions','customer','',30,'items_list/product/parts/table.captions.qty.twig',NULL),(467,'',0,0,'','itemsList.product.grid.customer.info','customer','',20,'items_list/product/parts/common.product-name.twig',NULL),(469,'',0,0,'','itemsList.product.small_thumbnails.customer.details','customer','',20,'items_list/product/parts/common.product-name.twig',NULL),(470,'',0,0,'','itemsList.product.big_thumbnails.customer.info','customer','',200,'items_list/product/parts/common.product-name.twig',NULL),(471,'',0,0,'','itemsList.product.text_links.customer.info','customer','',100,'items_list/product/parts/common.product-name.twig',NULL),(472,'',0,0,'','productBlock.info','customer','',200,'items_list/product/parts/common.product-name.twig',NULL),(473,'',0,0,'','itemsList.product.table.customer.columns','customer','',10,'items_list/product/parts/common.product-sku.twig',NULL),(474,'',0,0,'','itemsList.product.grid.customer.info','customer','',10,'items_list/product/parts/grid.photo.twig',NULL),(475,'',0,0,'','itemsList.product.small_thumbnails.customer.info','customer','',10,'items_list/product/parts/grid.photo.twig',NULL),(476,'',0,0,'','itemsList.product.big_thumbnails.customer.info','customer','',100,'items_list/product/parts/grid.photo.twig',NULL),(477,'',0,0,'','itemsList.product.table.customer.columns','customer','',20,'items_list/product/parts/common.product-link.twig',NULL),(478,'',0,0,'','itemsList.product.grid.customer.info','customer','',30,'items_list/product/parts/common.product-price.twig',NULL),(479,'',0,0,'','itemsList.product.small_thumbnails.customer.details','customer','',25,'items_list/product/parts/common.product-price.twig',NULL),(480,'',0,0,'','itemsList.product.list.customer.info','customer','',40,'items_list/product/parts/common.product-price.twig',NULL),(481,'',0,0,'','itemsList.product.table.customer.columns','customer','',40,'items_list/product/parts/common.product-price.twig',NULL),(482,'',0,0,'','productBlock.info','customer','',300,'items_list/product/parts/common.product-price.twig',NULL),(483,'',0,0,'','itemsList.product.grid.customer.info','customer','',998,'items_list/product/parts/common.labels.twig',NULL),(485,'',0,0,'','itemsList.product.list.customer.photo','customer','',998,'items_list/product/parts/common.labels.twig',NULL),(486,'',0,0,'','itemsList.product.table.customer.columns','customer','',25,'items_list/product/parts/common.labels.twig',NULL),(487,'',0,0,'','itemsList.product.big_thumbnails.customer.info','customer','',998,'items_list/product/parts/common.labels.twig',NULL),(488,'',0,0,'','productBlock.info.photo','customer','',998,'items_list/product/parts/common.labels.twig',NULL),(489,'',0,0,'','product.details.page.image','customer','',17,'items_list/product/parts/common.labels.twig',NULL),(490,'',0,0,'','itemsList.product.grid.customer.info.photo','customer','',10,'items_list/product/parts/common.product-thumbnail.twig',NULL),(491,'',0,0,'','itemsList.product.small_thumbnails.customer.info.photo','customer','',10,'items_list/product/parts/common.product-thumbnail.twig',NULL),(492,'',0,0,'','itemsList.product.big_thumbnails.customer.info.photo','customer','',10,'items_list/product/parts/common.product-thumbnail.twig',NULL),(493,'',0,0,'','productBlock.info.photo','customer','',100,'items_list/product/parts/common.product-thumbnail.twig',NULL),(495,'',0,0,'','itemsList.product.table.customer.captions','customer','',50,'items_list/product/parts/table.captions.add2cart-button.twig',NULL),(496,'',0,0,'','itemsList.product.table.customer.buttons','customer','',50,'items_list/product/parts/common.button-buy-selected.twig',NULL),(505,'',0,0,'','jscontainer.js','customer','',100,'jscontainer/parts/js.twig',NULL),(506,'',0,0,'','jscontainer.js','customer','',50,'jscontainer/parts/register_resources.twig',NULL),(507,'',0,0,'','jscontainer.js','customer','',200,'jscontainer/parts/js_aggregation.twig',NULL),(509,'',0,0,'','product.details.quicklook.info','customer','',18,'product/details/parts/common.stock.twig',NULL),(510,'',0,0,'','product.details.page','customer','',20,'product/details/parts/page.image.twig',NULL),(511,'',0,0,'','product.details.page.info.buttons-added.cart-buttons','customer','',30,'product/details/parts/common.add-button.twig',NULL),(512,'',0,0,'','product.details.quicklook.info.buttons-added.cart-buttons','customer','',30,'product/details/parts/common.add-button.twig',NULL),(513,'',0,0,'','product.details.page.info.buttons.cart-buttons','customer','',20,'product/details/parts/common.add-button.twig',NULL),(514,'',0,0,'','product.details.quicklook.info.buttons.cart-buttons','customer','',20,'product/details/parts/common.add-button.twig',NULL),(516,'',0,0,'','product.details.page','customer','',40,'product/details/parts/page.tabs.twig',NULL),(517,'',0,0,'','product.details.common.product-attributes.attributes','customer','',10,'product/details/parts/common.product-attributes-list.twig',NULL),(518,'',0,0,'','product.details.page.info','customer','',10,'product/details/parts/common.product-title.twig',NULL),(521,'',0,0,'','product.details.page','customer','',1000,'product/details/parts/common.javascript-add2cart.twig',NULL),(522,'',0,0,'','product.details.page.tab.description','customer','',100,'product/details/parts/common.product-description.twig',NULL),(523,'',0,0,'','product.details.page.info','customer','',100,'product/details/parts/common.info.buttons.twig',NULL),(524,'',0,0,'','product.details.quicklook.info','customer','',100,'product/details/parts/common.info.buttons.twig',NULL),(526,'',0,0,'','product.details.quicklook','customer','',30,'product/details/parts/quicklook.info.twig',NULL),(527,'',0,0,'','product.details.page.info','customer','',40,'product/details/parts/common.price.twig',NULL),(528,'',0,0,'','product.details.quicklook.info','customer','',40,'product/details/parts/common.price.twig',NULL),(529,'',0,0,'','product.details.page','customer','',30,'product/details/parts/page.info.twig',NULL),(532,'',0,0,'','product.details.page.info.buttons','customer','',10,'product/details/parts/common.info.buttons.cart-buttons.twig',NULL),(533,'',0,0,'','product.details.page.info.buttons-added','customer','',10,'product/details/parts/common.info.buttons.cart-buttons.twig',NULL),(534,'',0,0,'','product.details.quicklook.info.buttons','customer','',20,'product/details/parts/common.info.buttons.cart-buttons.twig',NULL),(535,'',0,0,'','product.details.quicklook.info.buttons-added','customer','',20,'product/details/parts/common.info.buttons.cart-buttons.twig',NULL),(536,'',0,0,'','product.details.page.info','customer','',42,'product/details/parts/common.notify-on-price-drop.twig',NULL),(537,'',0,0,'','product.details.quicklook','customer','',20,'product/details/parts/quicklook.image.twig',NULL),(538,'',0,0,'','product.details.quicklook.rotator','customer','',20,'product/details/parts/quicklook.rotator.twig',NULL),(539,'',0,0,'','product.details.page.info.buttons.cart-buttons','customer','',10,'product/details/parts/common.qty.twig',NULL),(540,'',0,0,'','product.details.page.info.buttons-added.cart-buttons','customer','',10,'product/details/parts/common.qty.twig',NULL),(541,'',0,0,'','product.details.quicklook.info.buttons.cart-buttons','customer','',10,'product/details/parts/common.qty.twig',NULL),(542,'',0,0,'','product.details.quicklook.info.buttons-added.cart-buttons','customer','',10,'product/details/parts/common.qty.twig',NULL),(547,'',0,0,'','product.details.page.tab.description','customer','',50,'product/details/parts/common.product-common-attributes.twig',NULL),(548,'',0,0,'','product.details.page.tab.description','customer','',100,'product/details/parts/common.product-main-attributes.twig',NULL),(549,'',0,0,'','product.details.page.tab.attributes','customer','',10,'product/details/parts/page.tabs.attributes.twig',NULL),(550,'',0,0,'','product.details.common.product-attributes.elements','customer','',100,'product/details/common_attributes/common.product-attributes.weight.twig',NULL),(551,'',0,0,'','product.details.common.product-attributes.elements','customer','',200,'product/details/common_attributes/common.product-attributes.sku.twig',NULL),(554,'',0,0,'','product.simple-search-form.simple-box.elements','customer','',10,'product/search/simple-search-parts/input.twig',NULL),(555,'',0,0,'','product.simple-search-form.simple-box.elements','customer','',20,'product/search/simple-search-parts/submit.twig',NULL),(556,'',0,0,'','product.simple-search-form.simple-box','customer','',10,'product/search/simple-search-parts/simple-box.twig',NULL),(557,'',0,0,'','products.search.conditions.phrase','customer','',100,'product/search/parts/phrase.all.twig',NULL),(558,'',0,0,'','products.search.conditions.advanced','customer','',100,'product/search/parts/advanced.options.twig',NULL),(559,'',0,0,'','products.search.conditions.phrase','customer','',200,'product/search/parts/phrase.any.twig',NULL),(560,'',0,0,'','products.search.conditions.substring','customer','',100,'product/search/parts/substring.input.twig',NULL),(561,'',0,0,'','products.search.conditions.advanced.options','customer','',300,'product/search/parts/advanced.options.sku.twig',NULL),(562,'',0,0,'','products.search.conditions.substring','customer','',200,'product/search/parts/substring.button.twig',NULL),(563,'',0,0,'','products.search.conditions-responsive.substring','customer','',200,'product/search/parts/substring.button.twig',NULL),(564,'',0,0,'','products.search.conditions.advanced.options','customer','',100,'product/search/parts/advanced.options.title.twig',NULL),(565,'',0,0,'','products.search.conditions.advanced.options','customer','',200,'product/search/parts/advanced.options.descr.twig',NULL),(566,'',0,0,'','products.search.conditions.advanced','customer','',200,'product/search/parts/advanced.category.twig',NULL),(567,'',0,0,'','products.search.conditions.phrase','customer','',300,'product/search/parts/phrase.phrase.twig',NULL),(568,'',0,0,'','product.quantity-box','customer','',20,'product/quantity_box/parts/quantity_box.twig',NULL),(570,'',0,0,'','minicart.horizontal.buttons','customer','',5,'mini_cart/horizontal/parts/cart.twig',NULL),(571,'',0,0,'','minicart.horizontal.buttons','customer','',20,'mini_cart/horizontal/parts/disabled_reason.twig',NULL),(572,'',0,0,'','minicart.horizontal.buttons','customer','',10,'mini_cart/horizontal/parts/checkout.twig',NULL),(573,'',0,0,'','minicart.horizontal.children','customer','',10,'mini_cart/horizontal/parts/items.twig',NULL),(574,'',0,0,'','minicart.horizontal.item','customer','',10,'mini_cart/horizontal/parts/item.name.twig',NULL),(575,'',0,0,'','minicart.horizontal.item','customer','',20,'mini_cart/horizontal/parts/item.price.twig',NULL),(576,'',0,0,'','minicart.horizontal.children','customer','',5,'mini_cart/horizontal/parts/link.twig',NULL),(577,'',0,0,'','signin-anonymous-title','customer','',200,'signin/signin_anonymous_box.twig',NULL),(578,'',0,0,'','signin-anonymous-title','customer','',20,'signin/signin_title.twig',NULL),(579,'',0,0,'','checkout.signin.form','customer','',10,'signin/parts_login_form/email.twig',NULL),(580,'',0,0,'','checkout.signin.form','customer','',20,'signin/parts_login_form/password.twig',NULL),(581,'',0,0,'','checkout.signin.form','customer','',30,'signin/parts_login_form/button.twig',NULL),(582,'',0,0,'','signin.main','customer','',10,'signin/signin.twig',NULL),(583,'',0,0,'','customer.checkout.signin','customer','',10,'signin/signin_login_form.twig',NULL),(584,'',0,0,'','head','customer','',3,'header/parts/alternate_lang.twig',NULL),(585,'',0,0,'','head','customer','',1000,'header/parts/link_favicon.twig',NULL),(586,'',0,0,'','head','customer','',500,'header/parts/meta_generator.twig',NULL),(587,'',0,0,'','head','customer','',100,'header/parts/title.twig',NULL),(588,'',0,0,'','head.css','customer','',100,'header/parts/parts.css/css.twig',NULL),(589,'',0,0,'','head.css','customer','',200,'header/parts/parts.css/css_aggregation.twig',NULL),(590,'',0,0,'','head','customer','',1300,'header/parts/script_config.twig',NULL),(591,'',0,0,'','head','customer','',550,'header/parts/meta_title.twig',NULL),(592,'',0,0,'','head','customer','',1100,'header/parts/link_css.twig',NULL),(593,'',0,0,'','head','customer','',2,'header/parts/canonical.twig',NULL),(594,'',0,0,'','head','customer','',200,'header/parts/meta_content_type.twig',NULL),(595,'',0,0,'','head','customer','',1,'header/parts/base.twig',NULL),(596,'',0,0,'','head','customer','',650,'header/parts/meta_viewport.twig',NULL),(597,'',0,0,'','head','customer','',700,'header/parts/meta_mobile_capable.twig',NULL),(598,'',0,0,'','head','customer','',800,'header/parts/meta_compat_ie.twig',NULL),(599,'',0,0,'','head','customer','',700,'header/parts/meta_upgrade_insecure.twig',NULL),(600,'',0,0,'','head','customer','',1500,'header/parts/preloaded_labels.twig',NULL),(601,'',0,0,'','head','customer','',700,'header/parts/meta_keywords.twig',NULL),(602,'',0,0,'','head','customer','',1310,'header/parts/layout_options.twig',NULL),(603,'',0,0,'','head','customer','',600,'header/parts/meta_description.twig',NULL),(604,'',0,0,'','head','customer','',16777215,'header/meta.twig',NULL),(605,'',0,0,'','operate_as_user','customer','',10,'operate_as_user/parts/desc.twig',NULL),(606,'',0,0,'','operate_as_user','customer','',30,'operate_as_user/parts/login.twig',NULL),(607,'',0,0,'','operate_as_user','customer','',20,'operate_as_user/parts/name.twig',NULL),(608,'',0,0,'','operate_as_user','customer','',40,'operate_as_user/parts/finish-button.twig',NULL),(609,'',0,0,'','cart.panel.totals','customer','',25,'shopping_cart/parts/total.separator.twig',NULL),(611,'',0,0,'','cart.item.info','customer','',10,'shopping_cart/parts/item.info.name.twig',NULL),(612,'',0,0,'','cart.item','customer','',30,'shopping_cart/parts/item.info.twig',NULL),(613,'',0,0,'','cart.item.info','customer','',100,'shopping_cart/parts/item.info.out.twig',NULL),(614,'',0,0,'','cart.totals','customer','',30,'shopping_cart/parts/cartItems.includedModifiers.twig',NULL),(615,'',0,0,'','cart.children','customer','',30,'shopping_cart/parts/totals.twig',NULL),(616,'',0,0,'','cart.children','customer','',10,'shopping_cart/parts/items.twig',NULL),(617,'',0,0,'','checkout.cart','customer','',10,'shopping_cart/parts/items.twig',NULL),(618,'',0,0,'','cart.buttons','customer','',20,'shopping_cart/parts/button.clear.twig',NULL),(619,'',0,0,'','cart.panel','customer','',10,'shopping_cart/parts/panel.totals.twig',NULL),(620,'',0,0,'','cart.panel.totals','customer','',20,'shopping_cart/parts/total.modifiers.twig',NULL),(621,'',0,0,'','cart.totals','customer','',10,'shopping_cart/parts/total.subtotal.twig',NULL),(622,'',0,0,'','cart.panel.totals','customer','',10,'shopping_cart/parts/total.subtotal.twig',NULL),(623,'',0,0,'','cart.panel.totals','customer','',40,'shopping_cart/parts/total.button.twig',NULL),(624,'',0,0,'','cart.item','customer','',40,'shopping_cart/parts/item.price.twig',NULL),(625,'',0,0,'','cart.panel','customer','',20,'shopping_cart/parts/panel.box.twig',NULL),(626,'',0,0,'','cart.children','customer','',20,'shopping_cart/parts/buttons.twig',NULL),(627,'',0,0,'','cart.item','customer','',20,'shopping_cart/parts/item.image.twig',NULL),(628,'',0,0,'','cart.item','customer','',60,'shopping_cart/parts/item.subtotal.twig',NULL),(629,'',0,0,'','cart.group','customer','',10,'shopping_cart/parts/group.title.twig',NULL),(631,'',0,0,'','cart.panel.totals','customer','',50,'shopping_cart/parts/total.disabled.reason.twig',NULL),(632,'',0,0,'','cart.panel.totals','customer','',30,'shopping_cart/parts/total.total.twig',NULL),(633,'',0,0,'','cart.panel.totals','customer','',35,'shopping_cart/parts/total.includedModifiers.twig',NULL),(634,'',0,0,'','cart.item','customer','',50,'shopping_cart/parts/item.qty.twig',NULL),(635,'',0,0,'','cart.bottom.right','customer','',20,'shopping_cart/checkout_buttons.twig',NULL),(636,'',0,0,'','shippingEstimator.main','customer','',10,'shopping_cart/shipping_estimator/parts/main.address.twig',NULL),(637,'',0,0,'','shippingEstimator.address','customer','',10,'shopping_cart/shipping_estimator/parts/address.country.twig',NULL),(638,'',0,0,'','shippingEstimator.address','customer','',40,'shopping_cart/shipping_estimator/parts/address.type.twig',NULL),(639,'',0,0,'','shippingEstimator.address','customer','',20,'shopping_cart/shipping_estimator/parts/address.state.twig',NULL),(640,'',0,0,'','shippingEstimator.address','customer','',25,'shopping_cart/shipping_estimator/parts/address.city.twig',NULL),(641,'',0,0,'','shippingEstimator.main','customer','',20,'shopping_cart/shipping_estimator/parts/main.methods.twig',NULL),(642,'',0,0,'','shippingEstimator.address','customer','',30,'shopping_cart/shipping_estimator/parts/address.zipcode.twig',NULL),(643,'',0,0,'','checkout.review.selected.items','customer','',10,'checkout/steps/review/parts/items.subtotal.twig',NULL),(644,'',0,0,'','checkout.review.inactive.items','customer','',10,'checkout/steps/review/parts/items.subtotal.twig',NULL),(645,'',0,0,'','checkout.review.selected.placeOrder','customer','',400,'checkout/steps/review/parts/place_order.button.twig',NULL),(646,'',0,0,'','checkout.review.selected.placeOrder','customer','',200,'checkout/steps/review/parts/place_order.note.twig',NULL),(647,'',0,0,'','checkout.review.selected','customer','',20,'checkout/steps/review/parts/place_order.twig',NULL),(648,'',0,0,'','checkout.review.selected.items','customer','',30,'checkout/steps/review/parts/items.modifiers.twig',NULL),(649,'',0,0,'','checkout.review.selected.placeOrder','customer','',500,'checkout/steps/review/parts/place_order.agree_note.twig',NULL),(650,'',0,0,'','checkout.review.selected.items','customer','',20,'checkout/steps/review/parts/items.list.twig',NULL),(651,'',0,0,'','checkout.review.inactive.items','customer','',20,'checkout/steps/review/parts/items.list.twig',NULL),(652,'',0,0,'','checkout.review.selected.items','customer','',35,'checkout/steps/review/parts/items.separator.twig',NULL),(653,'',0,0,'','checkout.review.inactive.items','customer','',35,'checkout/steps/review/parts/items.separator.twig',NULL),(654,'',0,0,'','checkout.review.selected.items','customer','',50,'checkout/steps/review/parts/items.paid.twig',NULL),(655,'',0,0,'','checkout.review.inactive.items','customer','',50,'checkout/steps/review/parts/items.paid.twig',NULL),(656,'',0,0,'','checkout.review.selected.items','customer','',45,'checkout/steps/review/parts/items.includedModifiers.twig',NULL),(657,'',0,0,'','checkout.review.selected.items','customer','',40,'checkout/steps/review/parts/items.total.twig',NULL),(658,'',0,0,'','checkout.review.inactive.items','customer','',40,'checkout/steps/review/parts/items.total.twig',NULL),(660,'',0,0,'','checkout.shipping.selected','customer','',200,'checkout/steps/shipping/parts/subsection.payment.twig',NULL),(661,'',0,0,'','checkout.payment.address.email','customer','',100,'checkout/steps/shipping/parts/address.billing.create.twig',NULL),(662,'',0,0,'','checkout.shipping.selected.sub.shipping','customer','',100,'checkout/steps/shipping/parts/address.first.twig',NULL),(663,'',0,0,'','checkout.shipping.address.email','customer','',100,'checkout/steps/shipping/parts/address.shipping.create.twig',NULL),(664,'',0,0,'','checkout.shipping.selected.sub.payment','customer','',200,'checkout/steps/shipping/parts/shippingMethods.twig',NULL),(665,'',0,0,'','checkout.shipping.selected.sub.payment','customer','',100,'checkout/steps/shipping/parts/address.second.twig',NULL),(666,'',0,0,'','checkout.shipping.selected','customer','',100,'checkout/steps/shipping/parts/subsection.shipping.twig',NULL),(667,'',0,0,'','checkout.cart','customer','',20,'checkout/parts/cart.totals.twig',NULL),(668,'',0,0,'','checkout.success','customer','',200,'checkout/success/parts/invoice.twig',NULL),(669,'',0,0,'','checkout.success','customer','',100,'checkout/success/parts/panel.twig',NULL),(670,'',0,0,'','checkout.success.panel','customer','',300,'checkout/success/parts/panel_line.twig',NULL),(671,'',0,0,'','checkout.success.panel','customer','',200,'checkout/success/parts/buttons.twig',NULL),(672,'',0,0,'','checkout.success.panel.buttons','customer','',200,'checkout/success/parts/button.print.twig',NULL),(673,'',0,0,'','checkout.success.panel','customer','',100,'checkout/success_message.twig',NULL),(675,'',0,0,'','layout.header.bar.links.newby','customer','',101,'modules/Amazon/PayWithAmazon/login/signin/layout.header.bar.links.newby.twig',NULL),(676,'',0,0,'','customer.signin','customer','',100,'modules/Amazon/PayWithAmazon/login/signin/signin.twig',NULL),(677,'',0,0,'','add2cart_popup.item.buttons','customer','',1000,'modules/Amazon/PayWithAmazon/checkout_button/add2cart_popup.twig',NULL),(678,'',0,0,'','cart.panel.totals','customer','',1000,'modules/Amazon/PayWithAmazon/checkout_button/cart.twig',NULL),(679,'',0,0,'','minicart.horizontal.buttons','customer','',1000,'modules/Amazon/PayWithAmazon/checkout_button/mini_cart.twig',NULL),(680,'',0,0,'','head','customer','',1310,'modules/Amazon/PayWithAmazon/header/parts/amazon_config.twig',NULL),(681,'',0,0,'','comparison_table.header_fixed','customer','',100,'modules/XC/ProductComparison/comparison_table/parts/product_name.twig',NULL),(682,'',0,0,'','comparison_table.data','customer','',200,'modules/XC/ProductComparison/comparison_table/parts/weight.twig',NULL),(683,'',0,0,'','comparison_table.header','customer','',100,'modules/XC/ProductComparison/comparison_table/parts/images.twig',NULL),(684,'',0,0,'','comparison_table.data','customer','',100,'modules/XC/ProductComparison/comparison_table/parts/prices.twig',NULL),(685,'',0,0,'','comparison_table.header_fixed','customer','',200,'modules/XC/ProductComparison/comparison_table/parts/buttons.twig',NULL),(686,'',0,0,'','product.details.page.info','customer','',105,'modules/XC/CustomProductTabs/product/brief_info.twig',NULL),(687,'',0,0,'','invoice.item.name','customer','',100,'modules/XC/CustomerAttachments/order/invoice/parts/items/item.attachments.twig',NULL),(688,'',0,0,'','customer.attachments.popup','customer','',100,'modules/XC/CustomerAttachments/parts/add_files.twig',NULL),(689,'',0,0,'','customer.attachments.popup.item','customer','',90,'modules/XC/CustomerAttachments/parts/file_name.twig',NULL),(690,'',0,0,'','customer.attachments.popup.item','customer','',40,'modules/XC/CustomerAttachments/parts/delete_btn.twig',NULL),(691,'',0,0,'','customer.attachments.popup','customer','',50,'modules/XC/CustomerAttachments/parts/files_table.twig',NULL),(692,'',0,0,'','next_previous.product.body','customer','',100,'modules/XC/NextPreviousProduct/product/parts/body.link.twig',NULL),(693,'',0,0,'','next_previous.product.body','customer','',200,'modules/XC/NextPreviousProduct/product/parts/body.cookie_data.twig',NULL),(694,'',0,0,'','next_previous.product.body','customer','',300,'modules/XC/NextPreviousProduct/product/parts/body.dropdown.twig',NULL),(695,'',0,0,'','next_previous.product.body.dropdown','customer','',100,'modules/XC/NextPreviousProduct/product/parts/dropdown_parts/image.twig',NULL),(696,'',0,0,'','next_previous.product.body.dropdown','customer','',200,'modules/XC/NextPreviousProduct/product/parts/dropdown_parts/name.twig',NULL),(697,'',0,0,'','next_previous.product.body.dropdown','customer','',300,'modules/XC/NextPreviousProduct/product/parts/dropdown_parts/price.twig',NULL),(698,'',0,0,'','itemsList.product.grid.customer.info','customer','',20,'modules/XC/NextPreviousProduct/items-list/cookie-data.twig',NULL),(699,'',0,0,'','itemsList.product.grid.customer.recently.info','customer','',20,'modules/XC/NextPreviousProduct/items-list/cookie-data.twig',NULL),(700,'',0,0,'','itemsList.product.list.customer.info','customer','',20,'modules/XC/NextPreviousProduct/items-list/cookie-data.twig',NULL),(701,'',0,0,'','itemsList.product.table.customer.column.after','customer','',20,'modules/XC/NextPreviousProduct/items-list/cookie-data.twig',NULL),(702,'',0,0,'','itemsList.product.small_thumbnails.customer.details','customer','',20,'modules/XC/NextPreviousProduct/items-list/cookie-data.twig',NULL),(703,'',0,0,'','itemsList.product.big_thumbnails.customer.info','customer','',200,'modules/XC/NextPreviousProduct/items-list/cookie-data.twig',NULL),(704,'',0,0,'','itemsList.product.text_links.customer.info','customer','',100,'modules/XC/NextPreviousProduct/items-list/cookie-data.twig',NULL),(705,'',0,0,'','productBlock.info','customer','',200,'modules/XC/NextPreviousProduct/items-list/cookie-data.twig',NULL),(706,'',0,0,'','location-select.main','customer','',10,'modules/XC/Geolocation/location_popup/parts/main.address.twig',NULL),(707,'',0,0,'','location-select.address','customer','',10,'modules/XC/Geolocation/location_popup/parts/address.country.twig',NULL),(708,'',0,0,'','location-select.address','customer','',40,'modules/XC/Geolocation/location_popup/parts/address.type.twig',NULL),(709,'',0,0,'','location-select.address','customer','',20,'modules/XC/Geolocation/location_popup/parts/address.state.twig',NULL),(710,'',0,0,'','location-select.address','customer','',30,'modules/XC/Geolocation/location_popup/parts/address.zipcode.twig',NULL),(711,'',0,0,'','itemsList.newsMessages.customer.center.row','customer','',250,'modules/XC/News/news_messages/list/parts/cell.brief.twig',NULL),(712,'',0,0,'','itemsList.newsMessages.customer.center.row','customer','',200,'modules/XC/News/news_messages/list/parts/cell.name.twig',NULL),(713,'',0,0,'','itemsList.newsMessages.customer.center.row','customer','',100,'modules/XC/News/news_messages/list/parts/cell.date.twig',NULL),(714,'',0,0,'','newsMessage.details','customer','',300,'modules/XC/News/page/news_message/parts/body.twig',NULL),(715,'',0,0,'','newsMessage.details','customer','',200,'modules/XC/News/page/news_message/parts/date.twig',NULL),(716,'',0,0,'','newsMessage.details','customer','',400,'modules/XC/News/page/news_message/parts/link.twig',NULL),(717,'',0,0,'','itemsList.newsMessages.customer.top.row','customer','',250,'modules/XC/News/top_news_messages/list/parts/cell.brief.twig',NULL),(718,'',0,0,'','itemsList.newsMessages.customer.top.row','customer','',200,'modules/XC/News/top_news_messages/list/parts/cell.name.twig',NULL),(719,'',0,0,'','itemsList.newsMessages.customer.top.row','customer','',100,'modules/XC/News/top_news_messages/list/parts/cell.date.twig',NULL),(720,'',0,0,'','themetweaker-panel--tabs','customer','',50,'modules/XC/ThemeTweaker/themetweaker_panel/panel/tabs.inline_editor.twig',NULL),(721,'',0,0,'','themetweaker-panel--tabs','customer','',10,'modules/XC/ThemeTweaker/themetweaker_panel/panel/tabs.webmaster.twig',NULL),(722,'',0,0,'','themetweaker-panel--tabs','customer','',20,'modules/XC/ThemeTweaker/themetweaker_panel/panel/tabs.custom_css.twig',NULL),(723,'',0,0,'','themetweaker-panel--tabs','customer','',0,'modules/XC/ThemeTweaker/themetweaker_panel/panel/tabs.hide.twig',NULL),(724,'',0,0,'','themetweaker-panel--header','customer','',100,'modules/XC/ThemeTweaker/themetweaker_panel/panel/tabs.twig',NULL),(725,'',0,0,'','themetweaker-panel--tabs','customer','',30,'modules/XC/ThemeTweaker/themetweaker_panel/panel/tabs.layout_editor.twig',NULL),(726,'',0,0,'','themetweaker-panel--header','customer','',200,'modules/XC/ThemeTweaker/themetweaker_panel/panel/actions.twig',NULL),(727,'',0,0,'','themetweaker-panel--body','customer','',100,'modules/XC/ThemeTweaker/themetweaker_panel/panel/content.twig',NULL),(728,'',0,0,'','themetweaker-panel--actions','customer','',100,'modules/XC/ThemeTweaker/themetweaker_panel/panel/actions.switcher.twig',NULL),(729,'',0,0,'','themetweaker-panel--tabs','customer','',40,'modules/XC/ThemeTweaker/themetweaker_panel/panel/tabs.labels_editor.twig',NULL),(730,'',0,0,'','themetweaker-panel--actions','customer','',999,'modules/XC/ThemeTweaker/themetweaker_panel/panel/actions.save.twig',NULL),(731,'',0,0,'','themetweaker-panel-extensions','customer','',100,'modules/XC/ThemeTweaker/themetweaker_panel/panel_extensions/shortcut.twig',NULL),(732,'',0,0,'','themetweaker-panel-extensions','customer','',200,'modules/XC/ThemeTweaker/themetweaker_panel/panel_extensions/confirm_exit_modal.twig',NULL),(733,'',0,0,'','layout_editor','customer','',100,'modules/XC/ThemeTweaker/themetweaker/layout_editor/panel_parts/help_message.twig',NULL),(734,'',0,0,'','layout_editor','customer','',20,'modules/XC/ThemeTweaker/themetweaker/layout_editor/panel_parts/hidden_blocks.twig',NULL),(735,'',0,0,'','layout_editor','customer','',10,'modules/XC/ThemeTweaker/themetweaker/layout_editor/panel_parts/hidden_count.twig',NULL),(736,'',0,0,'','list-item.actions','customer','',10,'modules/XC/ThemeTweaker/themetweaker/layout_editor/list_item_parts/action_hide.twig',NULL),(737,'',0,0,'','list-item.actions','customer','',10,'modules/XC/ThemeTweaker/themetweaker/layout_editor/list_item_parts/action_unhide.twig',NULL),(738,'',0,0,'','inline_editor','customer','',200,'modules/XC/ThemeTweaker/themetweaker/inline_editable/tinymce_warning_modal.twig',NULL),(739,'',0,0,'','head.css','customer','',9999,'modules/XC/ThemeTweaker/themetweaker/custom_css/css.twig',NULL),(740,'',0,0,'','order.links','customer','',10,'modules/XC/VendorMessages/order/parts/link.messages.twig',NULL),(741,'',0,0,'','orders.children.spec','customer','',350,'modules/XC/VendorMessages/order/list/parts/spec.messages.twig',NULL),(742,'',0,0,'','NewsletterSubscriptions.footer.success-block','customer','',100,'modules/XC/NewsletterSubscriptions/form/parts/success.twig',NULL),(743,'',0,0,'','NewsletterSubscriptions.footer.form-block','customer','',100,'modules/XC/NewsletterSubscriptions/form/parts/form.twig',NULL),(744,'',0,0,'','NewsletterSubscriptions.footer.error-block','customer','',100,'modules/XC/NewsletterSubscriptions/form/parts/error.twig',NULL),(745,'',0,0,'','products.search.conditions.advanced.options','customer','',400,'modules/XC/ProductTags/product/search/parts/advanced.options.tag.twig',NULL),(746,'',0,0,'','checkout_fastlane.blocks.payment_methods.available','customer','',10,'modules/XC/FastLaneCheckout/blocks/payment_methods/available/payment_tpl.twig',NULL),(747,'',0,0,'','checkout_fastlane.blocks.address.billing.prepend','customer','',10,'modules/XC/FastLaneCheckout/blocks/address_form/address_book.twig',NULL),(748,'',0,0,'','checkout_fastlane.blocks.address.shipping.prepend','customer','',10,'modules/XC/FastLaneCheckout/blocks/address_form/address_book.twig',NULL),(749,'',0,0,'','checkout_fastlane.blocks.address.billing.email','customer','',100,'modules/XC/FastLaneCheckout/blocks/address_form/billing/address.create.twig',NULL),(750,'',0,0,'','checkout_fastlane.blocks.address.billing.before','customer','',10,'modules/XC/FastLaneCheckout/blocks/address_form/billing/same.twig',NULL),(751,'',0,0,'','checkout_fastlane.blocks.address.shipping.email','customer','',100,'modules/XC/FastLaneCheckout/blocks/address_form/shipping/address.create.twig',NULL),(752,'',0,0,'','checkout_fastlane.blocks.popup_address_form.shipping','customer','',999,'modules/XC/FastLaneCheckout/blocks/popup_address_form/apply_to_billing.twig',NULL),(753,'',0,0,'','checkout_fastlane.blocks.popup_address_form.billing','customer','',999,'modules/XC/FastLaneCheckout/blocks/popup_address_form/apply_to_shipping.twig',NULL),(754,'',0,0,'','select-address.after','customer','',100,'modules/XC/FastLaneCheckout/select_address/add_button.twig',NULL),(755,'',0,0,'','checkout_fastlane.sections.address','customer','',10,'modules/XC/FastLaneCheckout/sections/address/shipping.twig',NULL),(756,'',0,0,'','checkout_fastlane.sections.address','customer','',20,'modules/XC/FastLaneCheckout/sections/address/billing.twig',NULL),(757,'',0,0,'','checkout_fastlane.sections.details.left','customer','',15,'modules/XC/FastLaneCheckout/sections/details/shipping_details.twig',NULL),(758,'',0,0,'','checkout_fastlane.sections.details.right','customer','',19,'modules/XC/FastLaneCheckout/sections/details/order_total.twig',NULL),(759,'',0,0,'','checkout_fastlane.sections.details.left','customer','',10,'modules/XC/FastLaneCheckout/sections/details/order_details.twig',NULL),(760,'',0,0,'','checkout_fastlane.sections.payment.right','customer','',10,'modules/XC/FastLaneCheckout/sections/payment/methods.twig',NULL),(761,'',0,0,'','checkout_fastlane.sections.payment.left','customer','',30,'modules/XC/FastLaneCheckout/sections/payment/note.twig',NULL),(762,'',0,0,'','checkout_fastlane.sections.payment.left','customer','',0,'modules/XC/FastLaneCheckout/sections/payment/heading.left.twig',NULL),(763,'',0,0,'','checkout_fastlane.sections.payment.left','customer','',20,'modules/XC/FastLaneCheckout/sections/payment/billing.twig',NULL),(764,'',0,0,'','checkout_fastlane.sections.payment','customer','',10,'modules/XC/FastLaneCheckout/sections/payment/columns.twig',NULL),(765,'',0,0,'','checkout_fastlane.sections.payment.right','customer','',0,'modules/XC/FastLaneCheckout/sections/payment/heading.right.twig',NULL),(766,'',0,0,'','checkout_fastlane.sections.after','customer','',10,'modules/XC/FastLaneCheckout/sections/details_box.twig',NULL),(767,'',0,0,'','checkout_fastlane.sections.shipping.right','customer','',10,'modules/XC/FastLaneCheckout/sections/shipping/methods.twig',NULL),(768,'',0,0,'','checkout_fastlane.sections.shipping.left','customer','',10,'modules/XC/FastLaneCheckout/sections/shipping/email.twig',NULL),(769,'',0,0,'','checkout_fastlane.sections.shipping.left','customer','',30,'modules/XC/FastLaneCheckout/sections/shipping/note.twig',NULL),(770,'',0,0,'','checkout_fastlane.sections.shipping.left','customer','',0,'modules/XC/FastLaneCheckout/sections/shipping/heading.left.twig',NULL),(771,'',0,0,'','checkout_fastlane.sections.shipping.left','customer','',20,'modules/XC/FastLaneCheckout/sections/shipping/address.twig',NULL),(772,'',0,0,'','checkout_fastlane.sections.shipping','customer','',10,'modules/XC/FastLaneCheckout/sections/shipping/columns.twig',NULL),(773,'',0,0,'','checkout_fastlane.sections.shipping.right','customer','',0,'modules/XC/FastLaneCheckout/sections/shipping/heading.right.twig',NULL),(774,'',0,0,'','checkout_fastlane.sections.details.right','customer','',20,'modules/XC/FastLaneCheckout/sections/section_change_button.twig',NULL),(775,'',0,0,'','checkout_fastlane.header.left','customer','',10,'modules/XC/FastLaneCheckout/checkout_fastlane/header/title.twig',NULL),(777,'',0,0,'','checkout_fastlane.header.right','customer','',10,'modules/XC/FastLaneCheckout/checkout_fastlane/header/navigation.twig',NULL),(778,'',0,0,'','checkout_fastlane','customer','',10,'modules/XC/FastLaneCheckout/checkout_fastlane/header.twig',NULL),(779,'',0,0,'','checkout_fastlane','customer','',20,'modules/XC/FastLaneCheckout/checkout_fastlane/sections.twig',NULL),(781,'',0,0,'','product.details.quicklook.info','customer','',19,'modules/XC/FreeShipping/free_ship.label.twig',NULL),(782,'',0,0,'','checkout.review.selected.placeOrder','customer','',350,'modules/XC/MailChimp/model/profile/subscriptions_list.twig',NULL),(783,'',0,0,'','checkout_fastlane.sections.place-order.before','customer','',100,'modules/XC/MailChimp/model/profile/subscriptions_list.twig',NULL),(784,'',0,0,'','checkout.review.selected.items','customer','',2000,'modules/XC/MailChimp/model/profile/subscriptions_list.twig',NULL),(785,'',0,0,'','reviews.general','customer','',20,'modules/XC/Reviews/button/add_review.twig',NULL),(786,'',0,0,'','reviews.product.rating.average','customer','',100,'modules/XC/Reviews/product/details/rating.twig',NULL),(788,'',0,0,'','review.add.fields','customer','',400,'modules/XC/Reviews/review/parts/field.review.twig',NULL),(789,'',0,0,'','review.add.fields','customer','',200,'modules/XC/Reviews/review/parts/field.reviewer_name.twig',NULL),(790,'',0,0,'','review.add.fields','customer','',100,'modules/XC/Reviews/review/parts/field.rating.twig',NULL),(791,'',0,0,'','review.add.buttons','customer','',500,'modules/XC/Reviews/review/parts/buttons.twig',NULL),(792,'',0,0,'','review.add.fields','customer','',300,'modules/XC/Reviews/review/parts/field.email.twig',NULL),(793,'',0,0,'','reviews.page.rating','customer','',200,'modules/XC/Reviews/average_rating/text.twig',NULL),(794,'',0,0,'','reviews.tooltip.rating','customer','',200,'modules/XC/Reviews/average_rating/text.twig',NULL),(795,'',0,0,'','reviews.product.rating','customer','',100,'modules/XC/Reviews/average_rating/form.twig',NULL),(797,'',0,0,'','reviews.tab.rating','customer','',200,'modules/XC/Reviews/average_rating/form.twig',NULL),(798,'',0,0,'','reviews.product.rating.form.content','customer','',100,'modules/XC/Reviews/average_rating/rating.twig',NULL),(799,'',0,0,'','reviews.page.rating','customer','',300,'modules/XC/Reviews/average_rating/details.twig',NULL),(800,'',0,0,'','reviews.rating.details','customer','',200,'modules/XC/Reviews/average_rating/details.twig',NULL),(801,'',0,0,'','reviews.page.rating','customer','',200,'modules/XC/Reviews/average_rating/separator.twig',NULL),(804,'',0,0,'','product.reviews.tab','customer','',500,'modules/XC/Reviews/reviews_tab/parts/tab.all_reviews_link.twig',NULL),(805,'',0,0,'','product.reviews.tab','customer','',200,'modules/XC/Reviews/reviews_tab/parts/tab.reviews_list_header.twig',NULL),(806,'',0,0,'','reviews.review.response','customer','',300,'modules/XC/Reviews/reviews_page/parts/response.text.twig',NULL),(807,'',0,0,'','reviews.review.title','customer','',200,'modules/XC/Reviews/reviews_page/parts/title.right.twig',NULL),(808,'',0,0,'','reviews.review','customer','',100,'modules/XC/Reviews/reviews_page/parts/review.title.twig',NULL),(809,'',0,0,'','reviews.review','customer','',200,'modules/XC/Reviews/reviews_page/parts/review.rating.twig',NULL),(810,'',0,0,'','reviews.review.title','customer','',100,'modules/XC/Reviews/reviews_page/parts/title.left.twig',NULL),(811,'',0,0,'','product.reviews.page','customer','',200,'modules/XC/Reviews/reviews_page/parts/page.reviews_list_header.twig',NULL),(812,'',0,0,'','reviews.review.response','customer','',100,'modules/XC/Reviews/reviews_page/parts/response.title.twig',NULL),(813,'',0,0,'','reviews.review','customer','',300,'modules/XC/Reviews/reviews_page/parts/review.text.twig',NULL),(814,'',0,0,'','product.reviews.page','customer','',300,'modules/XC/Reviews/reviews_page/parts/page.reviews_list.twig',NULL),(815,'',0,0,'','product.reviews.page','customer','',100,'modules/XC/Reviews/reviews_page/parts/page.product.twig',NULL),(816,'',0,0,'','reviews.review','customer','',500,'modules/XC/Reviews/reviews_page/parts/review.response.twig',NULL),(817,'',0,0,'','reviews','customer','',16777215,'modules/XC/Reviews/reviews_page/reviews.twig',NULL),(818,'',0,0,'','invoice.bottom.d2po','customer','',10,'modules/XC/CanadaPost/order/invoice/parts/bottom.d2po.details.twig',NULL),(819,'',0,0,'','order.links','customer','',30,'modules/XC/CanadaPost/order/parts/link.return.twig',NULL),(820,'',0,0,'','capost_create_return.form','customer','',200,'modules/XC/CanadaPost/products_return/create/parts/main.form.message.twig',NULL),(821,'',0,0,'','capost_create_return.form','customer','',300,'modules/XC/CanadaPost/products_return/create/parts/main.form.button.twig',NULL),(822,'',0,0,'','capost_create_return.form.captions','customer','',5,'modules/XC/CanadaPost/products_return/create/parts/table.captions.field.twig',NULL),(823,'',0,0,'','capost_create_return.form.captions','customer','',15,'modules/XC/CanadaPost/products_return/create/parts/table.captions.image.twig',NULL),(824,'',0,0,'','capost_create_return.form.captions','customer','',30,'modules/XC/CanadaPost/products_return/create/parts/table.captions.ret_amount.twig',NULL),(825,'',0,0,'','capost_create_return.form','customer','',100,'modules/XC/CanadaPost/products_return/create/parts/main.form.products.twig',NULL),(826,'',0,0,'','capost_create_return.form.columns','customer','',20,'modules/XC/CanadaPost/products_return/create/parts/table.common.name.twig',NULL),(827,'',0,0,'','capost_create_return.form.columns','customer','',10,'modules/XC/CanadaPost/products_return/create/parts/table.common.field.twig',NULL),(828,'',0,0,'','capost_create_return.form.columns','customer','',30,'modules/XC/CanadaPost/products_return/create/parts/table.common.ret_amount.twig',NULL),(829,'',0,0,'','capost_create_return.form.captions','customer','',10,'modules/XC/CanadaPost/products_return/create/parts/table.captions.sku.twig',NULL),(830,'',0,0,'','capost_create_return.form.captions','customer','',20,'modules/XC/CanadaPost/products_return/create/parts/table.captions.name.twig',NULL),(831,'',0,0,'','capost_create_return.form.columns','customer','',25,'modules/XC/CanadaPost/products_return/create/parts/table.common.amount.twig',NULL),(832,'',0,0,'','capost_create_return.form.columns','customer','',10,'modules/XC/CanadaPost/products_return/create/parts/table.common.sku.twig',NULL),(833,'',0,0,'','capost_create_return','customer','',100,'modules/XC/CanadaPost/products_return/create/parts/main.info.twig',NULL),(834,'',0,0,'','capost_create_return.form.columns','customer','',15,'modules/XC/CanadaPost/products_return/create/parts/table.common.image.twig',NULL),(835,'',0,0,'','capost_create_return.form.captions','customer','',25,'modules/XC/CanadaPost/products_return/create/parts/table.captions.amount.twig',NULL),(836,'',0,0,'','capost_create_return','customer','',200,'modules/XC/CanadaPost/products_return/create/parts/main.form.twig',NULL),(838,'',0,0,'','customer.signin','customer','',100,'modules/CDev/Paypal/login/signin/signin.paypal.twig',NULL),(839,'',0,0,'','layout.header.bar.links.newby','customer','',101,'modules/CDev/Paypal/login/signin/layout.header.bar.links.newby.twig',NULL),(840,'',0,0,'','cart.panel','customer','',15,'modules/CDev/Paypal/banner/cartPage/nearCheckoutButton.twig',NULL),(841,'',0,0,'','product.details.page.info','customer','',105,'modules/CDev/Paypal/banner/ProductDetailsPages/nearAddToCartButton.twig',NULL),(842,'',0,0,'','center','customer','',10,'modules/CDev/Paypal/banner/homePage/aboveProducts.twig',NULL),(843,'',0,0,'','center.bottom','customer','',99999,'modules/CDev/Paypal/banner/homePage/belowProducts.twig',NULL),(844,'',0,0,'','center.top','customer','',100,'modules/CDev/Paypal/banner/categoryPages/aboveProducts.twig',NULL),(845,'',0,0,'','center.bottom','customer','',99999,'modules/CDev/Paypal/banner/categoryPages/belowProducts.twig',NULL),(846,'',0,0,'','product.details.page.info.buttons-added.cart-buttons','customer','',40,'modules/CDev/Paypal/product/details/parts/express_checkout.twig',NULL),(847,'',0,0,'','product.details.quicklook.info.buttons-added.cart-buttons','customer','',40,'modules/CDev/Paypal/product/details/parts/express_checkout.twig',NULL),(848,'',0,0,'','product.details.page.info.buttons.cart-buttons','customer','',30,'modules/CDev/Paypal/product/details/parts/express_checkout.twig',NULL),(849,'',0,0,'','product.details.quicklook.info.buttons.cart-buttons','customer','',30,'modules/CDev/Paypal/product/details/parts/express_checkout.twig',NULL),(850,'',0,0,'','add2cart_popup.item.buttons','customer','',300,'modules/CDev/Paypal/add2cart_popup/express_checkout.twig',NULL),(851,'',0,0,'','itemsList.product.list.customer.info','customer','',1100,'modules/CDev/Paypal/item_list/product/parts/express_checkout.twig',NULL),(852,'',0,0,'','itemsList.product.grid.customer.info','customer','',20,'modules/CDev/GoogleAnalytics/impression-block.twig',NULL),(853,'',0,0,'','itemsList.product.list.customer.info','customer','',20,'modules/CDev/GoogleAnalytics/impression-block.twig',NULL),(854,'',0,0,'','itemsList.product.small_thumbnails.customer.details','customer','',20,'modules/CDev/GoogleAnalytics/impression-block.twig',NULL),(855,'',0,0,'','itemsList.product.big_thumbnails.customer.info','customer','',200,'modules/CDev/GoogleAnalytics/impression-block.twig',NULL),(856,'',0,0,'','itemsList.product.text_links.customer.info','customer','',100,'modules/CDev/GoogleAnalytics/impression-block.twig',NULL),(857,'',0,0,'','itemsList.product.table.customer.add2cart','customer','',10,'modules/CDev/GoogleAnalytics/impression-block.twig',NULL),(858,'',0,0,'','productBlock.info','customer','',200,'modules/CDev/GoogleAnalytics/impression-block.twig',NULL),(859,'',0,0,'','invoice.bottom.address.billing','customer','',30,'modules/CDev/XPaymentsConnector/invoice/invoice.twig',NULL),(860,'',0,0,'','customer.account.saved_cards.before','customer','',100,'modules/CDev/XPaymentsConnector/account/saved_cards.header.twig',NULL),(861,'',0,0,'','customer.account.add_new_card.before','customer','',100,'modules/CDev/XPaymentsConnector/account/saved_cards.header.twig',NULL),(862,'',0,0,'','customer.account.add_new_card.before','customer','',200,'modules/CDev/XPaymentsConnector/account/add_new_card.header.twig',NULL),(863,'',0,0,'','customer.account.add_new_card.address','customer','',100,'modules/CDev/XPaymentsConnector/account/add_new_card.address.twig',NULL),(864,'',0,0,'','customer.account.saved_cards.table','customer','',100,'modules/CDev/XPaymentsConnector/account/saved_cards.table.twig',NULL),(865,'',0,0,'','customer.account.add_new_card.form','customer','',100,'modules/CDev/XPaymentsConnector/account/add_new_card.form.twig',NULL),(866,'',0,0,'','checkout.review.selected','customer','',20,'modules/CDev/XPaymentsConnector/checkout/script.twig',NULL),(867,'',0,0,'','checkout_fastlane.sections.payment.left','customer','',500,'modules/CDev/XPaymentsConnector/checkout/script.twig',NULL),(868,'',0,0,'','static_page.info','customer','',100,'modules/CDev/SimpleCMS/page/parts/content.twig',NULL),(869,'',0,0,'','product.plain_price.tail.market_price.text','customer','',200,'modules/CDev/MarketPrice/details/you_save.twig',NULL),(870,'',0,0,'','product.plain_price.tail.market_price.label','customer','',100,'modules/CDev/MarketPrice/details/label.twig',NULL),(871,'',0,0,'','product.plain_price.tail.market_price.text','customer','',100,'modules/CDev/MarketPrice/details/market_price.twig',NULL),(872,'',0,0,'','product.plain_price.tail','customer','',45,'modules/CDev/MarketPrice/details.twig',NULL),(875,'',0,0,'','itemsList.product.text_links.customer.recently.info','customer','',100,'modules/CDev/ProductAdvisor/parts/info_textlinks.twig',NULL),(876,'',0,0,'','itemsList.product.grid.customer.recently.info','customer','',100,'modules/CDev/ProductAdvisor/parts/info.twig',NULL),(879,'',0,0,'','product.plain_price.tail.sale_price.text','customer','',100,'modules/CDev/Sale/details/sale_price.twig',NULL),(880,'',0,0,'','product.plain_price.tail.sale_price.text','customer','',200,'modules/CDev/Sale/details/you_save.twig',NULL),(881,'',0,0,'','product.plain_price.tail.sale_price.label','customer','',100,'modules/CDev/Sale/details/label.twig',NULL),(882,'',0,0,'','product.plain_price.tail','customer','',40,'modules/CDev/Sale/label.twig',NULL),(883,'',0,0,'','static_page.info','customer','',100000,'modules/CDev/GoSocial/page/parts/share.twig',NULL),(885,'',0,0,'','cart.panel.totals.modifier','customer','',16777215,'modules/CDev/Coupons/coupons_minilist.twig',NULL),(886,'',0,0,'','checkout.review.selected.items.modifier','customer','',16777215,'modules/CDev/Coupons/coupons_minilist.twig',NULL),(887,'',0,0,'','invoice.base.totals.modifier.name','customer','',16777215,'modules/CDev/Coupons/coupons_minilist.twig',NULL),(888,'',0,0,'','cart.item.info','customer','',1000,'modules/CDev/Coupons/item.freeship.twig',NULL),(889,'',0,0,'','product.details.page.tab.description','customer','',50,'modules/CDev/FileAttachments/file_attachments.twig',NULL),(890,'',0,0,'','itemsList.product.grid.customer.header','customer','',100,'modules/QSL/CloudSearch/cloud_filters/items_list/product/parts/common.filters.twig',NULL),(891,'',0,0,'','itemsList.product.list.customer.header','customer','',100,'modules/QSL/CloudSearch/cloud_filters/items_list/product/parts/common.filters.twig',NULL),(892,'',0,0,'','itemsList.product.table.customer.header','customer','',100,'modules/QSL/CloudSearch/cloud_filters/items_list/product/parts/common.filters.twig',NULL),(893,'',0,0,'','invoice.bottom.address.billing','customer','',30,'modules/QSL/BraintreeVZ/invoice/credit_card.twig',NULL),(894,'',0,0,'','order_status.wrapper','customer','',10,'common/order_status_wrapper.twig',NULL),(895,'',0,0,'','surcharge.common','customer','',100,'common/surcharge_parts/surcharge.twig',NULL),(896,'',0,0,'','product.plain_price','customer','',10,'common/price_parts/price.twig',NULL),(897,'',0,0,'','product.plain_price_only','customer','',10,'common/price_parts/price.twig',NULL),(898,'',0,0,'','order_status.nowrapper','customer','',10,'common/order_status_nowrapper.twig',NULL),(899,'',0,0,'','layout.main.footer','customer','',1000,'layout/footer/main.footer.section.twig',NULL),(900,'',0,0,'','layout.footer','customer','',500,'layout/footer/main.footer.twig',NULL),(901,'',0,0,'','layout.header.bar','customer','',100,'layout/header/header.bar.links.twig',NULL),(902,'',0,0,'','layout.header.bar.links.logged','customer','',200,'layout/header/header.bar.links.logged.account.twig',NULL),(903,'',0,0,'','layout.header','customer','',190,'layout/header/header.bar.checkout.logos.twig',NULL),(904,'',0,0,'','layout.header.bar.links.logged','customer','',500,'layout/header/header.bar.links.logged.logout.twig',NULL),(905,'',0,0,'','layout.header','customer','',200,'layout/header/header.bar.twig',NULL),(908,'',0,0,'','layout.header.bar.links.newby','customer','',200,'layout/header/header.bar.links.newby.register.twig',NULL),(909,'',0,0,'','layout.main','customer','',200,'layout/header/main.header.twig',NULL),(911,'',0,0,'','layout.header.bar.links.newby','customer','',100,'layout/header/header.bar.links.newby.login.twig',NULL),(912,'',0,0,'','layout.header','customer','',100,'layout/header/header.logo.twig',NULL),(913,'',0,0,'','layout.responsive.search','customer','',200,'layout/header/header.bar.mobilesearch.twig',NULL),(918,'',0,0,'','layout.header.bar','customer','',100,'layout/header/header.bar.links.logged.twig',NULL),(920,'',0,0,'','layout.main.center','customer','',100,'layout/content/main.center.left.twig',NULL),(921,'',0,0,'','layout.main.center','customer','',300,'layout/content/main.center.right.twig',NULL),(922,'',0,0,'','layout.main','customer','',400,'layout/content/main.center.twig',NULL),(923,'',0,0,'','layout.main.center','customer','',200,'layout/content/main.center.center.twig',NULL),(924,'',0,0,'','itemsList.product.grid.customer.info','customer','',998,'items_list/product/parts/common.marks.twig',NULL),(925,'',0,0,'','itemsList.product.list.customer.photo','customer','',998,'items_list/product/parts/common.marks.twig',NULL),(926,'',0,0,'','itemsList.product.table.customer.columns','customer','',45,'items_list/product/parts/common.marks.twig',NULL),(927,'',0,0,'','itemsList.product.table.customer.columns','customer','',9999999,'items_list/product/parts/table.product-representation.twig',NULL),(928,'',0,0,'','customer.account.details.after','customer','',100,'account/parts/link.login.twig',NULL),(929,'',0,0,'','product.details.quicklook.info','customer','',10,'product/details/parts/common.product-title-link.twig',NULL),(930,'',0,0,'','minicart.horizontal.item','customer','',18,'mini_cart/horizontal/parts/item.amount.twig',NULL),(931,'',0,0,'','minicart.horizontal.item','customer','',5,'mini_cart/horizontal/parts/item.image.twig',NULL),(932,'',0,0,'','signin-anonymous-title.continue','customer','',100,'signin/parts/continue.email.twig',NULL),(933,'',0,0,'','signin-anonymous-title.continue','customer','',110,'signin/parts/continue.button.twig',NULL),(934,'',0,0,'','cart.panel.totals.modifier','customer','',16777215,'shopping_cart/parts/item.shipping.estimator.twig',NULL),(935,'',0,0,'','cart.panel','customer','',10,'shopping_cart/parts/button.continue.twig',NULL),(936,'',0,0,'','cart.children','customer','',10,'shopping_cart/parts/button.continue.twig',NULL),(937,'',0,0,'','customer.account.details.before','customer','',10,'modules/Amazon/PayWithAmazon/account/login.twig',NULL),(938,'',0,0,'','layout.main.footer','customer','',50,'layout/footer/main.footer.contacts.twig',NULL),(939,'',0,0,'','layout.header.right.mobile','customer','',100,'layout/header/header.right.mobile.minicart.twig',NULL),(940,'',0,0,'','layout.header.right','customer','',10,'layout/header/header.right.search.twig',NULL),(941,'',0,0,'','layout.header.right.mobile','customer','',10,'layout/header/header.right.search.twig',NULL),(942,'',0,0,'','layout.header.bar.links.logged','customer','',-100,'layout/header/header.bar.links.logged.email.twig',NULL),(943,'',0,0,'','slidebar.additional-menu.links','customer','',10,'layout/header/header_settings/profile.twig',NULL),(944,'',0,0,'','slidebar.additional-menu','customer','',1000,'layout/header/header_settings/logout.twig',NULL),(945,'',0,0,'','layout.header.right.settings','customer','',1000,'layout/header/header_settings/logout.twig',NULL),(946,'',0,0,'','slidebar.additional-menu','customer','',400,'layout/header/header_settings/login.twig',NULL),(947,'',0,0,'','layout.header.right.settings','customer','',400,'layout/header/header_settings/login.twig',NULL),(948,'',0,0,'','slidebar.additional-menu','customer','',-100,'layout/header/header_settings/email.twig',NULL),(949,'',0,0,'','layout.header.right.settings','customer','',-100,'layout/header/header_settings/email.twig',NULL),(950,'',0,0,'','slidebar.additional-menu','customer','',390,'layout/header/header_settings/settings.twig',NULL),(951,'',0,0,'','slidebar.additional-menu','customer','',100,'layout/header/header_settings/links.twig',NULL),(952,'',0,0,'','layout.header.right.settings','customer','',100,'layout/header/header_settings/links.twig',NULL),(953,'',0,0,'','layout.header.mobile.menu','customer','',1000,'layout/header/mobile_header_parts/right_menu.twig',NULL),(954,'',0,0,'','header.menu','customer','',1000,'layout/header/mobile_header_parts/additional_menu.twig',NULL),(955,'',0,0,'','layout.header.mobile.menu','customer','',10,'layout/header/mobile_header_parts/logo.twig',NULL),(956,'',0,0,'','layout.header.bar.locale','customer','',20,'layout/header/locale/language.twig',NULL),(957,'',0,0,'','layout.header.bar.locale','customer','',10,'layout/header/locale/country.twig',NULL),(958,'',0,0,'','layout.header.bar.locale','customer','',30,'layout/header/locale/currency.twig',NULL),(959,'',0,0,'','contact_us.parts','customer','',10,'contact_us/parts/contact_us.address.twig',NULL),(960,'',0,0,'','invoice.base','mail','',60,'modules/CDev/XPaymentsConnector/fraud_check.twig',NULL),(961,'',0,0,'','invoice.base','mail','',60,'modules/CDev/XPaymentsConnector/kount.twig',NULL),(962,'',0,0,'','invoice.head','mail','',10,'order/invoice/parts/title.twig',NULL),(963,'',0,0,'','invoice.bottom.lines','mail','',20,'order/invoice/parts/bottom.statuses.twig',NULL),(964,'',0,0,'','invoice.item.name','mail','',100,'modules/XC/CustomerAttachments/order/invoice/parts/items/item.attachments.twig',NULL),(965,'',0,0,'','invoice.bottom.address.billing','mail','',30,'modules/CDev/XPaymentsConnector/invoice.twig',NULL),(966,'',0,0,'','invoice.item.name','mail','',10,'modules/CDev/PINCodes/invoice_item_pin_codes.twig',NULL),(967,'',0,0,'','invoice.base.totals.modifier.name','mail','',16777215,'modules/CDev/Coupons/coupons_minilist.twig',NULL),(968,'',0,0,'','tracking.info','mail','',10,'order_tracking_information/parts/tracking_info.twig',NULL),(969,'',0,0,'','welcome-block.non-root.title','admin','',10,'welcome_block/admin/title.twig',NULL),(970,'',0,0,'','welcome-block.non-root.content','admin','',10,'welcome_block/admin/block.items.twig',NULL),(971,'',0,0,'','welcome-block.non-root','admin','',100,'welcome_block/admin/block.twig',NULL),(972,'',0,0,'','welcome-block.non-root.content','admin','',20,'welcome_block/admin/block.footer.twig',NULL),(973,'',0,0,'','welcome-block.root.title','admin','',10,'welcome_block/root_admin/title.twig',NULL),(974,'',0,0,'','welcome-block.root.content','admin','',10,'welcome_block/root_admin/block.items.twig',NULL),(975,'',0,0,'','welcome-block.root','admin','',100,'welcome_block/root_admin/block.twig',NULL),(976,'',0,0,'','welcome-block.root.content','admin','',20,'welcome_block/root_admin/block.footer.twig',NULL),(977,'',0,0,'','order.operations','admin','',50,'order/page/parts/staff_note.twig',NULL),(978,'',0,0,'','order','admin','',400,'order/page/parts/operations.twig',NULL),(979,'',0,0,'','order.actions.statuses','admin','',200,'order/page/parts/action.payment_status.twig',NULL),(980,'',0,0,'','order.payment','admin','',200,'order/page/parts/payment.address.twig',NULL),(981,'',0,0,'','order.title.row','admin','',100,'order/page/parts/title.twig',NULL),(982,'',0,0,'','order.operations','admin','',100,'order/page/parts/line1.twig',NULL),(983,'',0,0,'','order.actions.statuses','admin','',100,'order/page/parts/action.shipping_status.twig',NULL),(984,'',0,0,'','order.actions.paymentActionsRow','admin','',100,'order/page/parts/action.transactions.twig',NULL),(985,'',0,0,'','order.payment','admin','',100,'order/page/parts/payment.method.twig',NULL),(986,'',0,0,'','order.actions.statuses','admin','',1000,'order/page/parts/action.row.twig',NULL),(987,'',0,0,'','order','admin','',100,'order/page/parts/title.row.twig',NULL),(988,'',0,0,'','order.actions','admin','',1000,'order/page/parts/action.statuses.twig',NULL),(989,'',0,0,'','order.title.box','admin','',200,'order/page/parts/title.box.history.twig',NULL),(990,'',0,0,'','order.items.bottom','admin','',100,'order/page/parts/totals.twig',NULL),(991,'',0,0,'','order.base.totals','admin','',300,'order/page/parts/totals.total.twig',NULL),(992,'',0,0,'','order.items.bottom','admin','',200,'order/page/parts/customerNotes.twig',NULL),(993,'',0,0,'','order.base.totals','admin','',200,'order/page/parts/totals.modifiers.twig',NULL),(994,'',0,0,'','order.actions.paymentActionsRow','admin','',200,'order/page/parts/action.payment_actions.twig',NULL),(995,'',0,0,'','order.shipping','admin','',200,'order/page/parts/shipping.address.twig',NULL),(996,'',0,0,'','order','admin','',1000,'order/page/parts/antifraud_ad.twig',NULL),(997,'',0,0,'','order.base.totals','admin','',100,'order/page/parts/totals.subtotal.twig',NULL),(998,'',0,0,'','order.items.wrapper','admin','',10,'order/page/parts/items/items.twig',NULL),(999,'',0,0,'','order.item','admin','',10,'order/page/parts/items/item.name.twig',NULL),(1000,'',0,0,'','order.items.head','admin','',30,'order/page/parts/items/items.head.qty.twig',NULL),(1001,'',0,0,'','order.item','admin','',40,'order/page/parts/items/item.total.twig',NULL),(1002,'',0,0,'','order.item','admin','',20,'order/page/parts/items/item.price.twig',NULL),(1003,'',0,0,'','order.items.head','admin','',20,'order/page/parts/items/items.head.price.twig',NULL),(1004,'',0,0,'','order.item.name','admin','',10,'order/page/parts/items/item.sku.twig',NULL),(1005,'',0,0,'','order.items.head','admin','',40,'order/page/parts/items/items.head.total.twig',NULL),(1006,'',0,0,'','order.items.head','admin','',10,'order/page/parts/items/items.head.name.twig',NULL),(1007,'',0,0,'','order.item','admin','',30,'order/page/parts/items/item.qty.twig',NULL),(1008,'',0,0,'','order.operations','admin','',300,'order/page/parts/line3.twig',NULL),(1009,'',0,0,'','order.items.wrapper','admin','',100,'order/page/parts/items_bottom_box.twig',NULL),(1010,'',0,0,'','order.operations','admin','',30,'order/page/parts/placed.twig',NULL),(1011,'',0,0,'','order.note','admin','',100,'order/page/parts/note.note.twig',NULL),(1012,'',0,0,'','order.title.row','admin','',200,'order/page/parts/title.box.twig',NULL),(1013,'',0,0,'','order.shipping','admin','',100,'order/page/parts/shipping.method.twig',NULL),(1014,'',0,0,'','packing_slip.base','admin','',25,'order/packing_slip/parts/body/body.note.twig',NULL),(1015,'',0,0,'','packing_slip.items','admin','',10,'order/packing_slip/parts/body/totals.twig',NULL),(1016,'',0,0,'','packing_slip.base','admin','',30,'order/packing_slip/parts/body/items.twig',NULL),(1017,'',0,0,'','packing_slip.items.head','admin','',10,'order/packing_slip/parts/body/items/items.head.sku.twig',NULL),(1018,'',0,0,'','packing_slip.items.head','admin','',40,'order/packing_slip/parts/body/items/items.head.qty_ship.twig',NULL),(1019,'',0,0,'','packing_slip.item','admin','',20,'order/packing_slip/parts/body/items/item.name.twig',NULL),(1020,'',0,0,'','packing_slip.items.head','admin','',30,'order/packing_slip/parts/body/items/items.head.qty.twig',NULL),(1021,'',0,0,'','packing_slip.item','admin','',10,'order/packing_slip/parts/body/items/item.name.sku.twig',NULL),(1022,'',0,0,'','packing_slip.item','admin','',40,'order/packing_slip/parts/body/items/item.qty_ship.twig',NULL),(1023,'',0,0,'','packing_slip.items.head','admin','',20,'order/packing_slip/parts/body/items/items.head.name.twig',NULL),(1024,'',0,0,'','packing_slip.item','admin','',30,'order/packing_slip/parts/body/items/item.qty.twig',NULL),(1025,'',0,0,'','packing_slip.footer','admin','',20,'order/packing_slip/parts/footer/footer.additional.twig',NULL),(1026,'',0,0,'','packing_slip.base','admin','',60,'order/packing_slip/parts/footer/footer.twig',NULL),(1027,'',0,0,'','packing_slip.addresses','admin','',10,'order/packing_slip/parts/addresses/addresses.purchaser.twig',NULL),(1028,'',0,0,'','packing_slip.addresses.shipping','admin','',10,'order/packing_slip/parts/addresses/purchaser.address.shipping.twig',NULL),(1029,'',0,0,'','packing_slip.base','admin','',20,'order/packing_slip/parts/addresses/addresses.twig',NULL),(1030,'',0,0,'','packing_slip.addresses','admin','',20,'order/packing_slip/parts/addresses/addresses.merchant.twig',NULL),(1031,'',0,0,'','packing_slip.addresses.billing','admin','',10,'order/packing_slip/parts/addresses/purchaser.address.billing.twig',NULL),(1032,'',0,0,'','packing_slip.base','admin','',10,'order/packing_slip/parts/head/head.twig',NULL),(1033,'',0,0,'','packing_slip.head','admin','',20,'order/packing_slip/parts/head/head.logo.twig',NULL),(1034,'',0,0,'','packing_slip.head','admin','',10,'order/packing_slip/parts/head/head.title.twig',NULL),(1035,'',0,0,'','order.history.base.events.details.info','admin','',10,'order/history/parts/event_details.twig',NULL),(1036,'',0,0,'','order.history.base.events.details.info','admin','',30,'order/history/parts/event_details_data.twig',NULL),(1037,'',0,0,'','order.history.base','admin','',10,'order/history/parts/block.twig',NULL),(1038,'',0,0,'','order.history.base.events','admin','',10,'order/history/parts/event_block_header.twig',NULL),(1039,'',0,0,'','order.history.base.events.details.info','admin','',20,'order/history/parts/event_details_comment.twig',NULL),(1040,'',0,0,'','order.history.base.events.details','admin','',20,'order/history/parts/event_details_action.twig',NULL),(1041,'',0,0,'','order.history.base.events.details','admin','',10,'order/history/parts/event_date.twig',NULL),(1042,'',0,0,'','order.history.base.events.details','admin','',30,'order/history/parts/event_description.twig',NULL),(1043,'',0,0,'','order.history.base.events.details','admin','',150,'order/history/parts/event_details_author.twig',NULL),(1044,'',0,0,'','order.history.base.events','admin','',20,'order/history/parts/event.twig',NULL),(1045,'',0,0,'','searchPanel.order.admin.main.actions','admin','',16777215,'search_panel/order/clear_search.twig',NULL),(1046,'',0,0,'','admin.main.page.content.center','admin','',10,'center.twig',NULL),(1047,'',0,0,'','address.order.main','admin','',300,'address/order/parts/shipping.twig',NULL),(1048,'',0,0,'','address.order.main','admin','',400,'address/order/parts/buttons.twig',NULL),(1049,'',0,0,'','address.order.main','admin','',100,'address/order/parts/info.twig',NULL),(1050,'',0,0,'','address.order.main','admin','',200,'address/order/parts/billing.twig',NULL),(1051,'',0,0,'','address.text.main','admin','',100,'address/text/parts/field.twig',NULL),(1052,'',0,0,'','admin.main.page.footer.left','admin','',100,'footer/right/marketplace_terms.twig',NULL),(1053,'',0,0,'','admin.main.page.footer.right','admin','',300,'footer/right/social_link.twig',NULL),(1054,'',0,0,'','admin.main.page.footer.right','admin','',100,'footer/right/site.twig',NULL),(1055,'',0,0,'','pager.itemsTotal','admin','',20,'pager/parts/items_total.twig',NULL),(1056,'',0,0,'','pager.admin.model.table.left','admin','',300,'pager/model/table/parts/more.twig',NULL),(1057,'',0,0,'','pager.admin.model.table.left','admin','',100,'pager/model/table/parts/page.twig',NULL),(1058,'',0,0,'','pager.admin.model.table.left','admin','',400,'pager/model/table/parts/items_per_page.twig',NULL),(1059,'',0,0,'','itemsList.productclass.header.before','admin','',10,'product_classes/header_note.twig',NULL),(1060,'',0,0,'','itemsList.state.header','admin','',10,'states/header.twig',NULL),(1061,'',0,0,'','payment.methods.list.line','admin','',100,'items_list/payment/methods/parts/line.header.twig',NULL),(1062,'',0,0,'','payment.methods.list.header','admin','',100,'items_list/payment/methods/parts/header.icon.twig',NULL),(1063,'',0,0,'','payment.methods.list.header','admin','',500,'items_list/payment/methods/parts/header.alt_icon.twig',NULL),(1064,'',0,0,'','payment.methods.list.header','admin','',200,'items_list/payment/methods/parts/header.title.twig',NULL),(1065,'',0,0,'','payment.methods.list.row','admin','',300,'items_list/payment/methods/parts/action.right.twig',NULL),(1066,'',0,0,'','payment.methods.list.header','admin','',400,'items_list/payment/methods/parts/header.description.twig',NULL),(1067,'',0,0,'','payment.methods.list.line','admin','',200,'items_list/payment/methods/parts/line.row.twig',NULL),(1068,'',0,0,'','payment.methods.list.header','admin','',300,'items_list/payment/methods/parts/header.switcher.twig',NULL),(1069,'',0,0,'','itemsList.product.table.admin.search.columns','admin','',70,'items_list/product/table/parts/columns/inventory.twig',NULL),(1070,'',0,0,'','itemsList.product.table.admin.search.columns','admin','',20,'items_list/product/table/parts/columns/sku.twig',NULL),(1071,'',0,0,'','itemsList.product.table.admin.search.columns','admin','',30,'items_list/product/table/parts/columns/name.twig',NULL),(1072,'',0,0,'','itemsList.product.table.admin.search.columns','admin','',60,'items_list/product/table/parts/columns/price.twig',NULL),(1073,'',0,0,'','itemsList.product.table.admin.search.columns','admin','',50,'items_list/product/table/parts/columns/position.twig',NULL),(1074,'',0,0,'','itemsList.product.table.admin.search.columns','admin','',10,'items_list/product/table/parts/columns/checkbox.twig',NULL),(1075,'',0,0,'','itemsList.product.table.admin.search.header','admin','',70,'items_list/product/table/parts/header/inventory.twig',NULL),(1076,'',0,0,'','itemsList.product.table.admin.search.header','admin','',20,'items_list/product/table/parts/header/sku.twig',NULL),(1077,'',0,0,'','itemsList.product.table.admin.search.header','admin','',30,'items_list/product/table/parts/header/name.twig',NULL),(1078,'',0,0,'','itemsList.product.table.admin.search.header','admin','',60,'items_list/product/table/parts/header/price.twig',NULL),(1079,'',0,0,'','itemsList.product.table.admin.search.header','admin','',50,'items_list/product/table/parts/header/position.twig',NULL),(1080,'',0,0,'','itemsList.product.table.admin.search.header','admin','',10,'items_list/product/table/parts/header/checkbox.twig',NULL),(1081,'',0,0,'','itemsList.product.modify.brief.admin.columns','admin','',70,'items_list/product/modify/brief/parts/columns/inventory.twig',NULL),(1082,'',0,0,'','itemsList.product.modify.brief.admin.columns','admin','',20,'items_list/product/modify/brief/parts/columns/sku.twig',NULL),(1083,'',0,0,'','itemsList.product.modify.brief.admin.columns','admin','',30,'items_list/product/modify/brief/parts/columns/name.twig',NULL),(1084,'',0,0,'','itemsList.product.modify.brief.admin.columns','admin','',60,'items_list/product/modify/brief/parts/columns/price.twig',NULL),(1085,'',0,0,'','itemsList.product.modify.brief.admin.header','admin','',70,'items_list/product/modify/brief/parts/header/inventory.twig',NULL),(1086,'',0,0,'','itemsList.product.modify.brief.admin.header','admin','',20,'items_list/product/modify/brief/parts/header/sku.twig',NULL),(1087,'',0,0,'','itemsList.product.modify.brief.admin.header','admin','',30,'items_list/product/modify/brief/parts/header/name.twig',NULL),(1088,'',0,0,'','itemsList.product.modify.brief.admin.header','admin','',60,'items_list/product/modify/brief/parts/header/price.twig',NULL),(1089,'',0,0,'','itemsList.product.modify.common.admin.columns','admin','',70,'items_list/product/modify/common/parts/columns/inventory.twig',NULL),(1090,'',0,0,'','itemsList.product.modify.common.admin.columns','admin','',20,'items_list/product/modify/common/parts/columns/sku.twig',NULL),(1091,'',0,0,'','itemsList.product.modify.common.admin.columns','admin','',30,'items_list/product/modify/common/parts/columns/name.twig',NULL),(1092,'',0,0,'','itemsList.product.modify.common.admin.columns','admin','',60,'items_list/product/modify/common/parts/columns/price.twig',NULL),(1093,'',0,0,'','itemsList.product.modify.common.admin.columns','admin','',10,'items_list/product/modify/common/parts/columns/checkbox.twig',NULL),(1094,'',0,0,'','itemsList.product.modify.common.admin.header','admin','',70,'items_list/product/modify/common/parts/header/inventory.twig',NULL),(1095,'',0,0,'','itemsList.product.modify.common.admin.header','admin','',20,'items_list/product/modify/common/parts/header/sku.twig',NULL),(1096,'',0,0,'','itemsList.product.modify.common.admin.header','admin','',30,'items_list/product/modify/common/parts/header/name.twig',NULL),(1097,'',0,0,'','itemsList.product.modify.common.admin.header','admin','',60,'items_list/product/modify/common/parts/header/price.twig',NULL),(1098,'',0,0,'','itemsList.product.modify.common.admin.header','admin','',10,'items_list/product/modify/common/parts/header/checkbox.twig',NULL),(1099,'',0,0,'','itemsList.module.manage.columns.module-main-section','admin','',200,'items_list/module/manage/parts/columns/xcn_notice.twig',NULL),(1100,'',0,0,'','itemsList.module.manage.columns.icon','admin','',200,'items_list/module/manage/parts/columns/icon/image.twig',NULL),(1101,'',0,0,'','itemsList.module.install.columns.icon','admin','',200,'items_list/module/manage/parts/columns/icon/image.twig',NULL),(1102,'',0,0,'','itemsList.module.sales-channels.columns.icon','admin','',200,'items_list/module/manage/parts/columns/icon/image.twig',NULL),(1103,'',0,0,'','itemsList.module.purchased.columns.icon','admin','',200,'items_list/module/manage/parts/columns/icon/image.twig',NULL),(1104,'',0,0,'','itemsList.module.manage.columns.module-description-section.messages','admin','',30,'items_list/module/manage/parts/columns/module-description-section/cannot_enable.twig',NULL),(1105,'',0,0,'','itemsList.module.install.columns.module-description-section','admin','',400,'items_list/module/manage/parts/columns/module-description-section/cannot_enable.twig',NULL),(1106,'',0,0,'','itemsList.module.sales-channels.columns.module-description-section','admin','',400,'items_list/module/manage/parts/columns/module-description-section/cannot_enable.twig',NULL),(1107,'',0,0,'','itemsList.module.purchased.columns.module-description-section','admin','',400,'items_list/module/manage/parts/columns/module-description-section/cannot_enable.twig',NULL),(1108,'',0,0,'','itemsList.module.manage.columns.module-description-section.messages','admin','',40,'items_list/module/manage/parts/columns/module-description-section/upgrade_notes.twig',NULL),(1109,'',0,0,'','itemsList.module.manage.columns.module-description-section','admin','',30,'items_list/module/manage/parts/columns/module-description-section/messages.twig',NULL),(1110,'',0,0,'','itemsList.module.manage.columns.module-description-section.messages.cannot_enable.core_upgrade_needed','admin','',200,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/core_upgrade_needed/note_2.twig',NULL),(1111,'',0,0,'','itemsList.module.install.columns.module-description-section.cannot_enable.core_upgrade_needed','admin','',200,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/core_upgrade_needed/note_2.twig',NULL),(1112,'',0,0,'','itemsList.module.sales-channels.columns.module-description-section.cannot_enable.core_upgrade_needed','admin','',200,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/core_upgrade_needed/note_2.twig',NULL),(1113,'',0,0,'','itemsList.module.purchased.columns.module-description-section.cannot_enable.core_upgrade_needed','admin','',200,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/core_upgrade_needed/note_2.twig',NULL),(1114,'',0,0,'','itemsList.module.manage.columns.module-description-section.messages.cannot_enable.core_upgrade_needed','admin','',100,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/core_upgrade_needed/note_1_enable.twig',NULL),(1115,'',0,0,'','itemsList.module.install.columns.module-description-section.cannot_enable.core_upgrade_needed','admin','',100,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/core_upgrade_needed/note_1_install.twig',NULL),(1116,'',0,0,'','itemsList.module.manage.columns.module-description-section.messages.cannot_enable','admin','',100,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/dependencies.twig',NULL),(1117,'',0,0,'','itemsList.module.install.columns.module-description-section.cannot_enable','admin','',100,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/dependencies.twig',NULL),(1118,'',0,0,'','itemsList.module.sales-channels.columns.module-description-section.cannot_enable','admin','',100,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/dependencies.twig',NULL),(1119,'',0,0,'','itemsList.module.purchased.columns.module-description-section.cannot_enable','admin','',100,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/dependencies.twig',NULL),(1120,'',0,0,'','itemsList.module.manage.columns.module-description-section.messages.cannot_enable','admin','',200,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/core_upgrade_needed.twig',NULL),(1121,'',0,0,'','itemsList.module.install.columns.module-description-section.cannot_enable','admin','',200,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/core_upgrade_needed.twig',NULL),(1122,'',0,0,'','itemsList.module.sales-channels.columns.module-description-section.cannot_enable','admin','',200,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/core_upgrade_needed.twig',NULL),(1123,'',0,0,'','itemsList.module.purchased.columns.module-description-section.cannot_enable','admin','',200,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/core_upgrade_needed.twig',NULL),(1124,'',0,0,'','itemsList.module.manage.columns.module-description-section.messages.cannot_enable.dependencies','admin','',200,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/dependencies/list.twig',NULL),(1125,'',0,0,'','itemsList.module.install.columns.module-description-section.cannot_enable.dependencies','admin','',200,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/dependencies/list.twig',NULL),(1126,'',0,0,'','itemsList.module.sales-channels.columns.module-description-section.cannot_enable.dependencies','admin','',200,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/dependencies/list.twig',NULL),(1127,'',0,0,'','itemsList.module.purchased.columns.module-description-section.cannot_enable.dependencies','admin','',200,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/dependencies/list.twig',NULL),(1128,'',0,0,'','itemsList.module.manage.columns.module-description-section.messages.cannot_enable.dependencies','admin','',300,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/dependencies/note_mutual.twig',NULL),(1129,'',0,0,'','itemsList.module.install.columns.module-description-section.cannot_enable.dependencies','admin','',300,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/dependencies/note_mutual.twig',NULL),(1130,'',0,0,'','itemsList.module.sales-channels.columns.module-description-section.cannot_enable.dependencies','admin','',300,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/dependencies/note_mutual.twig',NULL),(1131,'',0,0,'','itemsList.module.purchased.columns.module-description-section.cannot_enable.dependencies','admin','',300,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/dependencies/note_mutual.twig',NULL),(1132,'',0,0,'','itemsList.module.manage.columns.module-description-section.messages.cannot_enable.dependencies.details','admin','',100,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/dependencies/details/link.twig',NULL),(1133,'',0,0,'','itemsList.module.install.columns.module-description-section.cannot_enable.dependencies.details','admin','',100,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/dependencies/details/link.twig',NULL),(1134,'',0,0,'','itemsList.module.sales-channels.columns.module-description-section.cannot_enable.dependencies.details','admin','',100,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/dependencies/details/link.twig',NULL),(1135,'',0,0,'','itemsList.module.purchased.columns.module-description-section.cannot_enable.dependencies.details','admin','',100,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/dependencies/details/link.twig',NULL),(1136,'',0,0,'','itemsList.module.manage.columns.module-description-section.messages.cannot_enable.dependencies','admin','',100,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/dependencies/note.twig',NULL),(1137,'',0,0,'','itemsList.module.install.columns.module-description-section.cannot_enable.dependencies','admin','',100,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/dependencies/note.twig',NULL),(1138,'',0,0,'','itemsList.module.sales-channels.columns.module-description-section.cannot_enable.dependencies','admin','',100,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/dependencies/note.twig',NULL),(1139,'',0,0,'','itemsList.module.purchased.columns.module-description-section.cannot_enable.dependencies','admin','',100,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/dependencies/note.twig',NULL),(1140,'',0,0,'','itemsList.module.manage.columns.module-description-section.messages.cannot_enable.dependencies','admin','',400,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/dependencies/list_mutual.twig',NULL),(1141,'',0,0,'','itemsList.module.install.columns.module-description-section.cannot_enable.dependencies','admin','',400,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/dependencies/list_mutual.twig',NULL),(1142,'',0,0,'','itemsList.module.sales-channels.columns.module-description-section.cannot_enable.dependencies','admin','',400,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/dependencies/list_mutual.twig',NULL),(1143,'',0,0,'','itemsList.module.purchased.columns.module-description-section.cannot_enable.dependencies','admin','',400,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/dependencies/list_mutual.twig',NULL),(1144,'',0,0,'','itemsList.module.manage.columns.module-description-section.messages.cannot_enable','admin','',300,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/module_upgrade_needed.twig',NULL),(1145,'',0,0,'','itemsList.module.install.columns.module-description-section.cannot_enable','admin','',300,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/module_upgrade_needed.twig',NULL),(1146,'',0,0,'','itemsList.module.sales-channels.columns.module-description-section.cannot_enable','admin','',300,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/module_upgrade_needed.twig',NULL),(1147,'',0,0,'','itemsList.module.purchased.columns.module-description-section.cannot_enable','admin','',300,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/module_upgrade_needed.twig',NULL),(1148,'',0,0,'','itemsList.module.manage.columns.module-description-section.messages.cannot_enable.module_upgrade_needed','admin','',100,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/module_upgrade_needed/note.twig',NULL),(1149,'',0,0,'','itemsList.module.install.columns.module-description-section.cannot_enable.module_upgrade_needed','admin','',100,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/module_upgrade_needed/note.twig',NULL),(1150,'',0,0,'','itemsList.module.sales-channels.columns.module-description-section.cannot_enable.module_upgrade_needed','admin','',100,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/module_upgrade_needed/note.twig',NULL),(1151,'',0,0,'','itemsList.module.purchased.columns.module-description-section.cannot_enable.module_upgrade_needed','admin','',100,'items_list/module/manage/parts/columns/module-description-section/cannot_enable/module_upgrade_needed/note.twig',NULL),(1152,'',0,0,'','itemsList.module.manage.columns.module-description-section.messages','admin','',40,'items_list/module/manage/parts/columns/module-description-section/update_notes.twig',NULL),(1153,'',0,0,'','itemsList.module.install.columns.module-description-section','admin','',15,'items_list/module/manage/parts/columns/module-description-section/translation_notice.twig',NULL),(1154,'',0,0,'','itemsList.module.manage.columns.module-description-section.messages','admin','',30,'items_list/module/manage/parts/columns/module-description-section/cannot_disable.twig',NULL),(1155,'',0,0,'','itemsList.module.manage.columns.module-description-section','admin','',10,'items_list/module/manage/parts/columns/module-description-section/description.twig',NULL),(1156,'',0,0,'','itemsList.module.install.columns.module-description-section','admin','',10,'items_list/module/manage/parts/columns/module-description-section/description.twig',NULL),(1157,'',0,0,'','itemsList.module.sales-channels.columns.module-description-section','admin','',10,'items_list/module/manage/parts/columns/module-description-section/description.twig',NULL),(1158,'',0,0,'','itemsList.module.purchased.columns.module-description-section','admin','',10,'items_list/module/manage/parts/columns/module-description-section/description.twig',NULL),(1159,'',0,0,'','itemsList.module.manage.columns.module-main-section','admin','',1000,'items_list/module/manage/parts/columns/module-main-section/js_code.twig',NULL),(1160,'',0,0,'','itemsList.module.manage.columns.module-main-section','admin','',40,'items_list/module/manage/parts/columns/module-main-section/request_for_upgrade.twig',NULL),(1161,'',0,0,'','itemsList.module.install.columns.module-main-section','admin','',40,'items_list/module/manage/parts/columns/module-main-section/request_for_upgrade.twig',NULL),(1162,'',0,0,'','itemsList.module.sales-channels.columns.module-main-section','admin','',40,'items_list/module/manage/parts/columns/module-main-section/request_for_upgrade.twig',NULL),(1163,'',0,0,'','itemsList.module.purchased.columns.module-main-section','admin','',40,'items_list/module/manage/parts/columns/module-main-section/request_for_upgrade.twig',NULL),(1164,'',0,0,'','itemsList.module.manage.columns.module-main-section','admin','',25,'items_list/module/manage/parts/columns/module-main-section/version.twig',NULL),(1165,'',0,0,'','itemsList.module.manage.columns.module-main-section','admin','',20,'items_list/module/manage/parts/columns/module-main-section/author.twig',NULL),(1166,'',0,0,'','itemsList.module.install.columns.module-main-section','admin','',20,'items_list/module/manage/parts/columns/module-main-section/author.twig',NULL),(1167,'',0,0,'','itemsList.module.sales-channels.columns.module-main-section','admin','',20,'items_list/module/manage/parts/columns/module-main-section/author.twig',NULL),(1168,'',0,0,'','itemsList.module.purchased.columns.module-main-section','admin','',20,'items_list/module/manage/parts/columns/module-main-section/author.twig',NULL),(1169,'',0,0,'','itemsList.module.manage.columns.module-main-section','admin','',21,'items_list/module/manage/parts/columns/module-main-section/author_email.twig',NULL),(1170,'',0,0,'','itemsList.module.install.columns.module-main-section','admin','',21,'items_list/module/manage/parts/columns/module-main-section/author_email.twig',NULL),(1171,'',0,0,'','itemsList.module.sales-channels.columns.module-main-section','admin','',21,'items_list/module/manage/parts/columns/module-main-section/author_email.twig',NULL),(1172,'',0,0,'','itemsList.module.purchased.columns.module-main-section','admin','',21,'items_list/module/manage/parts/columns/module-main-section/author_email.twig',NULL),(1173,'',0,0,'','itemsList.module.manage.columns.module-main-section','admin','',30,'items_list/module/manage/parts/columns/module-main-section/actions.twig',NULL),(1174,'',0,0,'','itemsList.module.manage.columns.module-main-section','admin','',10,'items_list/module/manage/parts/columns/module-main-section/name.twig',NULL),(1175,'',0,0,'','itemsList.module.install.columns.module-main-section','admin','',10,'items_list/module/manage/parts/columns/module-main-section/name.twig',NULL),(1176,'',0,0,'','itemsList.module.sales-channels.columns.module-main-section','admin','',10,'items_list/module/manage/parts/columns/module-main-section/name.twig',NULL),(1177,'',0,0,'','itemsList.module.purchased.columns.module-main-section','admin','',10,'items_list/module/manage/parts/columns/module-main-section/name.twig',NULL),(1178,'',0,0,'','itemsList.module.manage.columns','admin','',50,'items_list/module/manage/parts/columns/main.twig',NULL),(1179,'',0,0,'','itemsList.module.install.columns','admin','',50,'items_list/module/manage/parts/columns/main.twig',NULL),(1180,'',0,0,'','itemsList.module.sales-channels.columns','admin','',50,'items_list/module/manage/parts/columns/main.twig',NULL),(1181,'',0,0,'','itemsList.module.purchased.columns','admin','',50,'items_list/module/manage/parts/columns/main.twig',NULL),(1182,'',0,0,'','itemsList.module.manage.columns','admin','',30,'items_list/module/manage/parts/columns/icon.twig',NULL),(1183,'',0,0,'','itemsList.module.install.columns','admin','',30,'items_list/module/manage/parts/columns/icon.twig',NULL),(1184,'',0,0,'','itemsList.module.sales-channels.columns','admin','',30,'items_list/module/manage/parts/columns/icon.twig',NULL),(1185,'',0,0,'','itemsList.module.purchased.columns','admin','',30,'items_list/module/manage/parts/columns/icon.twig',NULL),(1186,'',0,0,'','itemsList.module.manage.columns','admin','',70,'items_list/module/manage/parts/columns/description.twig',NULL),(1187,'',0,0,'','itemsList.module.install.columns','admin','',70,'items_list/module/manage/parts/columns/description.twig',NULL),(1188,'',0,0,'','itemsList.module.sales-channels.columns','admin','',70,'items_list/module/manage/parts/columns/description.twig',NULL),(1189,'',0,0,'','itemsList.module.purchased.columns','admin','',70,'items_list/module/manage/parts/columns/description.twig',NULL),(1190,'',0,0,'','itemsList.module.manage.sections','admin','',400,'items_list/module/manage/parts/sections/list.twig',NULL),(1191,'',0,0,'','modules-manage.top-controls','admin','',100,'items_list/module/manage/parts/sections/header.twig',NULL),(1192,'',0,0,'','itemsList.module.manage.sections','admin','',100,'items_list/module/manage/parts/sections/javascript.twig',NULL),(1193,'',0,0,'','marketplace.top-controls','admin','',500,'items_list/module/install/items_list/list.twig',NULL),(1194,'',0,0,'','marketplace.top-controls','admin','',200,'items_list/module/install/items_list/banner.twig',NULL),(1195,'',0,0,'','itemsList.module.install.columns.module-description-section','admin','',40,'items_list/module/install/parts/columns/upgrade_notes.twig',NULL),(1196,'',0,0,'','itemsList.module.sales-channels.columns.module-description-section','admin','',40,'items_list/module/install/parts/columns/upgrade_notes.twig',NULL),(1197,'',0,0,'','itemsList.module.purchased.columns.module-description-section','admin','',40,'items_list/module/install/parts/columns/upgrade_notes.twig',NULL),(1198,'',0,0,'','itemsList.module.install.columns.module-main-section.actions','admin','',100,'items_list/module/install/parts/columns/info/purchase.twig',NULL),(1199,'',0,0,'','itemsList.module.sales-channels.columns.module-main-section.actions','admin','',100,'items_list/module/install/parts/columns/info/purchase.twig',NULL),(1200,'',0,0,'','itemsList.module.purchased.columns.module-main-section.actions','admin','',100,'items_list/module/install/parts/columns/info/purchase.twig',NULL),(1201,'',0,0,'','itemsList.module.install.columns.module-main-section','admin','',200,'items_list/module/install/parts/columns/info/xcn_notice.twig',NULL),(1202,'',0,0,'','itemsList.module.sales-channels.columns.module-main-section','admin','',200,'items_list/module/install/parts/columns/info/xcn_notice.twig',NULL),(1203,'',0,0,'','itemsList.module.purchased.columns.module-main-section','admin','',200,'items_list/module/install/parts/columns/info/xcn_notice.twig',NULL),(1204,'',0,0,'','itemsList.module.install.columns.module-main-section.actions','admin','',100,'items_list/module/install/parts/columns/info/install.twig',NULL),(1205,'',0,0,'','itemsList.module.sales-channels.columns.module-main-section','admin','',200,'items_list/module/install/parts/columns/info/install.twig',NULL),(1206,'',0,0,'','itemsList.module.purchased.columns.module-main-section.actions','admin','',100,'items_list/module/install/parts/columns/info/install.twig',NULL),(1207,'',0,0,'','itemsList.module.install.columns.module-main-section','admin','',200,'items_list/module/install/parts/columns/info/not_avail_notice.twig',NULL),(1208,'',0,0,'','itemsList.module.sales-channels.columns.module-main-section','admin','',200,'items_list/module/install/parts/columns/info/not_avail_notice.twig',NULL),(1209,'',0,0,'','itemsList.module.purchased.columns.module-main-section','admin','',200,'items_list/module/install/parts/columns/info/not_avail_notice.twig',NULL),(1210,'',0,0,'','itemsList.module.install.columns.module-main-section','admin','',100,'items_list/module/install/parts/columns/info/already_installed.twig',NULL),(1211,'',0,0,'','itemsList.module.sales-channels.columns.module-main-section','admin','',100,'items_list/module/install/parts/columns/info/already_installed.twig',NULL),(1212,'',0,0,'','itemsList.module.purchased.columns.module-main-section','admin','',100,'items_list/module/install/parts/columns/info/already_installed.twig',NULL),(1213,'',0,0,'','itemsList.module.install.columns.module-main-section','admin','',30,'items_list/module/install/parts/columns/info/actions.twig',NULL),(1214,'',0,0,'','itemsList.module.sales-channels.columns.module-main-section','admin','',30,'items_list/module/install/parts/columns/info/actions.twig',NULL),(1215,'',0,0,'','itemsList.module.purchased.columns.module-main-section','admin','',30,'items_list/module/install/parts/columns/info/actions.twig',NULL),(1216,'',0,0,'','itemsList.module.install.columns.icon','admin','',210,'items_list/module/install/parts/columns/info/price.twig',NULL),(1217,'',0,0,'','itemsList.module.sales-channels.columns.icon','admin','',210,'items_list/module/install/parts/columns/info/price.twig',NULL),(1218,'',0,0,'','itemsList.module.install.columns.module-description-section','admin','',40,'items_list/module/install/parts/columns/info/tags.twig',NULL),(1219,'',0,0,'','itemsList.module.sales-channels.columns.module-description-section','admin','',40,'items_list/module/install/parts/columns/info/tags.twig',NULL),(1220,'',0,0,'','itemsList.module.purchased.columns.module-description-section','admin','',40,'items_list/module/install/parts/columns/info/tags.twig',NULL),(1221,'',0,0,'','itemsList.module.install.columns.module-description-section.info-element','admin','',10,'items_list/module/install/parts/columns/info/vote.twig',NULL),(1222,'',0,0,'','itemsList.module.install.columns.module-description-section','admin','',400,'items_list/module/install/parts/columns/info/purchase_state.twig',NULL),(1223,'',0,0,'','itemsList.module.purchased.columns.module-description-section','admin','',400,'items_list/module/install/parts/columns/info/purchase_state.twig',NULL),(1224,'',0,0,'','itemsList.module.install.columns.module-main-section','admin','',25,'items_list/module/install/parts/columns/info/popularity.twig',NULL),(1225,'',0,0,'','itemsList.module.sales-channels.columns.module-main-section','admin','',25,'items_list/module/install/parts/columns/info/popularity.twig',NULL),(1226,'',0,0,'','itemsList.module.purchased.columns.module-main-section','admin','',25,'items_list/module/install/parts/columns/info/popularity.twig',NULL),(1227,'',0,0,'','itemsList.module.install.columns.module-main-section','admin','',15,'items_list/module/install/parts/columns/info.twig',NULL),(1228,'',0,0,'','itemsList.module.sales-channels.columns.module-main-section','admin','',15,'items_list/module/install/parts/columns/info.twig',NULL),(1229,'',0,0,'','itemsList.module.purchased.columns.module-main-section','admin','',15,'items_list/module/install/parts/columns/info.twig',NULL),(1230,'',0,0,'','marketplace.top-controls','admin','',400,'items_list/module/install/parts/header.twig',NULL),(1231,'',0,0,'','marketplace.addons-filters','admin','',200,'items_list/module/install/parts/sections/addons_search_box.twig',NULL),(1232,'',0,0,'','marketplace.top-controls','admin','',100,'items_list/module/install/parts/sections/filter.twig',NULL),(1233,'',0,0,'','marketplace.top-controls','admin','',300,'items_list/module/install/parts/sections/sorting.twig',NULL),(1234,'',0,0,'','marketplace.addons-filters','admin','',250,'items_list/module/install/parts/sections/my_purchases.twig',NULL),(1235,'',0,0,'','itemsList.module.install.footer','admin','',10,'items_list/module/install/parts/footer.twig',NULL),(1236,'',0,0,'','marketplace.top-controls','admin','',700,'items_list/module/install/footer.twig',NULL),(1237,'',0,0,'','sales-channels.top-controls','admin','',400,'items_list/module/sales_channels/items_list/list.twig',NULL),(1238,'',0,0,'','sales-channels.top-controls','admin','',500,'items_list/module/sales_channels/items_list/footer.twig',NULL),(1239,'',0,0,'','sales-channels.top-controls','admin','',300,'items_list/module/sales_channels/items_list/clear.twig',NULL),(1240,'',0,0,'','itemsList.module.purchased.columns.icon','admin','',210,'items_list/module/purchased/parts/columns/info/price.twig',NULL),(1241,'',0,0,'','itemsList.orders.search.cell.status','admin','',16777215,'items_list/model/table/order/cell.actions.twig',NULL),(1242,'',0,0,'','itemsList.orders.search.cell.status','admin','',16777215,'items_list/model/table/order/cell.payment_actions.twig',NULL),(1243,'',0,0,'','itemsList.category.cell.subcategories','admin','',100,'items_list/model/table/category/parts/info.subcategories.twig',NULL),(1244,'',0,0,'','itemsList.category.cell.info','admin','',100,'items_list/model/table/category/parts/info.products.twig',NULL),(1245,'',0,0,'','itemsList.orderitem.cell.price','admin','',100,'items_list/model/table/order_item/restore.twig',NULL),(1246,'',0,0,'','itemsList.orderitem.dumpCell.price','admin','',100,'items_list/model/table/order_item/restore.twig',NULL),(1247,'',0,0,'','itemsList.country.cell.states','admin','',100,'items_list/model/table/countries/parts/cell.states.twig',NULL),(1248,'',0,0,'','itemsList.shipping-methods.cell.rates','admin','',100,'items_list/model/table/shipping/methods/cell.rates.twig',NULL),(1249,'',0,0,'','itemsList.profile.search.footer','admin','',20,'profile/add_user.twig',NULL),(1250,'',0,0,'','itemsList.profile.search.footer','admin','',10,'profile/delete_user.twig',NULL),(1251,'',0,0,'','dashboard-center','admin','',200,'dashboard/parts/center/panel.twig',NULL),(1252,'',0,0,'','dashboard','admin','',100,'dashboard/parts/body_markup.twig',NULL),(1253,'',0,0,'','crud.settings.field','admin','',100,'email_settings/queues_note.twig',NULL),(1254,'',0,0,'','crud.modulesettings.formHeader','admin','',50,'promotions/simple_blocks/modules_settings.twig',NULL),(1255,'',0,0,'','form_model.product.inventory.before','admin','',5,'promotions/simple_blocks/wholesale.twig',NULL),(1256,'',0,0,'','crud.currency.currency.formHeader','admin','',50,'promotions/simple_blocks/multicurrency.twig',NULL),(1257,'',0,0,'','crud.notificationattachments.formHeader','admin','',50,'promotions/simple_blocks/pdf_invoice.twig',NULL),(1258,'',0,0,'','crud.bannerrotation.formHeader','admin','',50,'promotions/simple_blocks/banner_system.twig',NULL),(1259,'',0,0,'','crud.settings.footer','admin','',100,'settings/email.twig',NULL),(1260,'',0,0,'','crud.settings.field','admin','',100,'settings/contacts/anchor.twig',NULL),(1261,'',0,0,'','crud.settings.footer','admin','',200,'settings/clean_view_cache.twig',NULL),(1262,'',0,0,'','crud.settings.footer','admin','',100,'settings/clean_aggregation.twig',NULL),(1263,'',0,0,'','admin.center','admin','',16777215,'settings/module.twig',NULL),(1264,'',0,0,'','file-uploader.menu','admin','',20,'file_uploader/parts/menu.view.twig',NULL),(1265,'',0,0,'','file-uploader.menu','admin','',100,'file_uploader/parts/menu.delete.twig',NULL),(1266,'',0,0,'','file-uploader.menu','admin','',30,'file_uploader/parts/menu.upload.twig',NULL),(1267,'',0,0,'','file-uploader.menu','admin','',50,'file_uploader/parts/menu.alt.twig',NULL),(1268,'',0,0,'','file-uploader.menu','admin','',10,'file_uploader/parts/menu.message.twig',NULL),(1269,'',0,0,'','install-addon.buttons','admin','',16777215,'modules_manager/license/select_type_button.twig',NULL),(1270,'',0,0,'','install-addon.buttons','admin','',16777215,'modules_manager/license/install_button.twig',NULL),(1271,'',0,0,'','installation_types.buttons','admin','',16777215,'modules_manager/installation_type/buttons.twig',NULL),(1272,'',0,0,'','admin.main.page.header','admin','',16777215,'top_links/version_notes/parts/key_notice.twig',NULL),(1273,'',0,0,'','admin.main.page.header','admin','',20,'top_links/version_notes/parts/base.twig',NULL),(1274,'',0,0,'','itemsList.removedata.header','admin','',100,'page/remove_data/parts/remove.twig',NULL),(1275,'',0,0,'','layout_settings','admin','',10,'layout_settings/parts/layout_settings.settings.twig',NULL),(1276,'',0,0,'','layout_settings','admin','',20,'layout_settings/parts/layout_settings.change_template.twig',NULL),(1277,'',0,0,'','layout_settings.settings','admin','',40,'layout_settings/settings/parts/settings.settings_form.twig',NULL),(1278,'',0,0,'','layout_settings.settings','admin','',30,'layout_settings/settings/parts/settings.layout_type.twig',NULL),(1279,'',0,0,'','layout_settings.settings','admin','',20,'layout_settings/settings/parts/settings.current_template.twig',NULL),(1280,'',0,0,'','itemsList.methods.header','admin','',10,'payment/appearance/note.twig',NULL),(1281,'',0,0,'','payment.method.add.offline','admin','',16777215,'payment/add_method/parts/add_offline_method.twig',NULL),(1282,'',0,0,'','itemsList.onlinemethods.header','admin','',10,'payment/add_method/parts/payment_gateways.note.twig',NULL),(1283,'',0,0,'','jscontainer.js','admin','',100,'jscontainer/parts/js.twig',NULL),(1284,'',0,0,'','jscontainer.js','admin','',50,'jscontainer/parts/register_resources.twig',NULL),(1285,'',0,0,'','jscontainer.js','admin','',200,'jscontainer/parts/js_aggregation.twig',NULL),(1286,'',0,0,'','product.search.conditions.by-keywords','admin','',30,'product/search/parts/by_conditions_parts/by_description.twig',NULL),(1287,'',0,0,'','product.search.conditions.by-keywords','admin','',10,'product/search/parts/by_conditions_parts/by_title.twig',NULL),(1288,'',0,0,'','product.search.conditions.by-keywords','admin','',20,'product/search/parts/by_conditions_parts/by_sku.twig',NULL),(1290,'',0,0,'','product.inventory.parts','admin','',40,'product/inventory/low_limit_amount.twig',NULL),(1291,'',0,0,'','product.inventory.parts','admin','',30,'product/inventory/low_limit_selector.twig',NULL),(1292,'',0,0,'','product.inventory.parts','admin','',100,'product/inventory/buttons.twig',NULL),(1294,'',0,0,'','product.attributes.actions','admin','',10,'product/attributes/parts/action.remove.twig',NULL),(1295,'',0,0,'','itemsList.attributegroup.footer','admin','',10,'attribute_groups/note.twig',NULL),(1296,'',0,0,'','import.begin.options','admin','',100,'import/parts/option.update_only.twig',NULL),(1297,'',0,0,'','import.failed.buttons','admin','',100,'import/parts/failed.buttons.reupload.twig',NULL),(1298,'',0,0,'','import.begin.options','admin','',200,'import/parts/option.delete_temporary_files.twig',NULL),(1299,'',0,0,'','import.failed.content.errors','admin','',100,'import/parts/common.errors.twig',NULL),(1300,'',0,0,'','import.completed.content.errors','admin','',100,'import/parts/common.errors.twig',NULL),(1301,'',0,0,'','import.begin.content','admin','',100,'import/parts/begin.files.twig',NULL),(1302,'',0,0,'','import.begin.options','admin','',50,'import/parts/option.ignore_images_verification.twig',NULL),(1303,'',0,0,'','import.begin.buttons','admin','',100,'import/parts/begin.buttons.import.twig',NULL),(1304,'',0,0,'','import.begin.content','admin','',200,'import/parts/begin.options.twig',NULL),(1305,'',0,0,'','import.completed.content','admin','',100,'import/parts/completed.messages.twig',NULL),(1306,'',0,0,'','import.begin.options','admin','',400,'import/parts/option.delimiter.twig',NULL),(1307,'',0,0,'','import.completed.buttons','admin','',100,'import/parts/completed.buttons.new_import.twig',NULL),(1308,'',0,0,'','import.begin.options','admin','',300,'import/parts/option.charset.twig',NULL),(1309,'',0,0,'','import.begin.content.files','admin','',100,'import/parts/begin.files.orders_note.twig',NULL),(1310,'',0,0,'','import.failed.content','admin','',100,'import/parts/failed.errors.twig',NULL),(1311,'',0,0,'','import.failed.buttons','admin','',200,'import/parts/failed.buttons.proceed.twig',NULL),(1312,'',0,0,'','admin.main.page.header.left','admin','',100,'main_center/page_container_parts/header_parts/logo.twig',NULL),(1313,'',0,0,'','admin.main.page.header','admin','',100,'main_center/page_container_parts/header_parts/menu_control.twig',NULL),(1314,'',0,0,'','head','admin','',80,'header/parts/favicon.twig',NULL),(1315,'',0,0,'','head','admin','',40,'header/parts/ie.twig',NULL),(1316,'',0,0,'','head','admin','',10,'header/parts/title.twig',NULL),(1317,'',0,0,'','head.css','admin','',100,'header/parts/parts.css/css.twig',NULL),(1318,'',0,0,'','head.css','admin','',200,'header/parts/parts.css/css_aggregation.twig',NULL),(1319,'',0,0,'','head','admin','',100,'header/parts/js_static.twig',NULL),(1320,'',0,0,'','head','admin','',70,'header/parts/nofollow.twig',NULL),(1321,'',0,0,'','head','admin','',700,'header/parts/meta_mobile-capable.twig',NULL),(1322,'',0,0,'','head','admin','',90,'header/parts/css.twig',NULL),(1323,'',0,0,'','head','admin','',1500,'header/parts/preloaded_labels.twig',NULL),(1324,'',0,0,'','head','admin','',20,'header/parts/content-type.twig',NULL),(1325,'',0,0,'','head','admin','',40,'header/parts/noindex.twig',NULL),(1326,'',0,0,'','zones.zone.details','admin','',200,'zones/details/parts/field.state.twig',NULL),(1327,'',0,0,'','zones.zone.details','admin','',100,'zones/details/parts/field.country.twig',NULL),(1328,'',0,0,'','zones.zone','admin','',300,'zones/details/parts/actions.twig',NULL),(1329,'',0,0,'','zones.zone.details','admin','',500,'zones/details/parts/field.address.twig',NULL),(1330,'',0,0,'','zones.zone.details','admin','',400,'zones/details/parts/field.zipcode.twig',NULL),(1331,'',0,0,'','zones.zone','admin','',200,'zones/details/parts/details.twig',NULL),(1332,'',0,0,'','zones.zone.details','admin','',300,'zones/details/parts/field.city.twig',NULL),(1333,'',0,0,'','zones.zone','admin','',100,'zones/details/parts/field.name.twig',NULL),(1334,'',0,0,'','top_sellers.selectors','admin','',10,'top_sellers/parts/availability_selector.twig',NULL),(1335,'',0,0,'','top_sellers.selectors','admin','',20,'top_sellers/parts/period_selector.twig',NULL),(1336,'',0,0,'','crud.bannerrotation.formFooter','admin','',200,'banner_rotation/parts/images.twig',NULL),(1337,'',0,0,'','browseServer','admin','',100,'browse_server/parts/items.twig',NULL),(1338,'',0,0,'','browseServer.item','admin','',100,'browse_server/parts/item.name.twig',NULL),(1339,'',0,0,'','browseServer','admin','',200,'browse_server/parts/buttons.twig',NULL),(1340,'',0,0,'','payment.methods.list.header','admin','',9999,'modules/Amazon/PayWithAmazon/method_style.twig',NULL),(1341,'',0,0,'','onboarding-wizard.header','admin','',50,'modules/XC/Onboarding/wizard/close_button.twig',NULL),(1342,'',0,0,'','onboarding-wizard.header','admin','',100,'modules/XC/Onboarding/wizard/header.twig',NULL),(1343,'',0,0,'','payment.methods.list.header','admin','',400,'modules/XC/SagePay/sagepay_description.twig',NULL),(1344,'',0,0,'','payment_status.after.SagePay_form_protocol','admin','',100,'modules/XC/SagePay/payment_status.twig',NULL),(1345,'',0,0,'','images_settings','admin','',100,'modules/XC/ThemeTweaker/images_settings/parts/custom_images.twig',NULL),(1346,'',0,0,'','form_model.xc.bulkediting.product.after','admin','',100,'modules/XC/BulkEditing/bulk_edit/selected.twig',NULL),(1347,'',0,0,'','itemsList.xc.bulkediting.category.header','admin','',100,'modules/XC/BulkEditing/items_list/selected/count.twig',NULL),(1348,'',0,0,'','itemsList.xc.bulkediting.inventory.header','admin','',100,'modules/XC/BulkEditing/items_list/selected/count.twig',NULL),(1349,'',0,0,'','itemsList.xc.bulkediting.priceandmembership.header','admin','',100,'modules/XC/BulkEditing/items_list/selected/count.twig',NULL),(1350,'',0,0,'','itemsList.xc.bulkediting.shippinginfo.header','admin','',100,'modules/XC/BulkEditing/items_list/selected/count.twig',NULL),(1351,'',0,0,'','product.search.conditions.by-keywords','admin','',40,'modules/XC/ProductTags/product/search/parts/by_conditions_parts/by_tag.twig',NULL),(1352,'',0,0,'','itemsList.xc.reviews.review.header','admin','',16777215,'modules/XC/Reviews/reviews/buttons/addReview.twig',NULL),(1353,'',0,0,'','itemsList.xc.reviews.productreview.header','admin','',16777215,'modules/XC/Reviews/reviews/buttons/addReview.twig',NULL),(1354,'',0,0,'','crud.modulesettings.formHeader','admin','',50,'modules/XC/Reviews/review/promo_settings.twig',NULL),(1355,'',0,0,'','crud.review.footer','admin','',100,'modules/XC/Reviews/review/promo.twig',NULL),(1356,'',0,0,'','order.shipping','admin','',250,'modules/XC/CanadaPost/order/page/parts/shipping.d2po.twig',NULL),(1357,'',0,0,'','searchPanel.xc.canadapost.productsreturn.admin.main.actions','admin','',16777215,'modules/XC/CanadaPost/search_panel/return/clear_search.twig',NULL),(1358,'',0,0,'','capost_return.form','admin','',300,'modules/XC/CanadaPost/products_return/parts/form.files.twig',NULL),(1359,'',0,0,'','capost_return.form.actions.left','admin','',100,'modules/XC/CanadaPost/products_return/parts/form.action.left.status.twig',NULL),(1360,'',0,0,'','capost_return.form.actions.right','admin','',100,'modules/XC/CanadaPost/products_return/parts/form.action.right.note.twig',NULL),(1361,'',0,0,'','capost_return','admin','',200,'modules/XC/CanadaPost/products_return/parts/form.twig',NULL),(1362,'',0,0,'','capost_return.form','admin','',100,'modules/XC/CanadaPost/products_return/parts/form.actions.twig',NULL),(1363,'',0,0,'','capost_return.form','admin','',200,'modules/XC/CanadaPost/products_return/parts/form.products.twig',NULL),(1364,'',0,0,'','capost_return','admin','',100,'modules/XC/CanadaPost/products_return/parts/created.twig',NULL),(1365,'',0,0,'','capost_return.form','admin','',400,'modules/XC/CanadaPost/products_return/parts/form.notes.twig',NULL),(1366,'',0,0,'','welcome-block.paypal','admin','',100,'modules/CDev/Paypal/welcome_block/paypal/block.twig',NULL),(1367,'',0,0,'','welcome-block.paypal.content','admin','',20,'modules/CDev/Paypal/welcome_block/paypal/block.footer.twig',NULL),(1368,'',0,0,'','welcome-block.paypal.content','admin','',10,'modules/CDev/Paypal/welcome_block/paypal/block.content.twig',NULL),(1369,'',0,0,'','order.payment','admin','',110,'modules/CDev/Paypal/order/payment.id.twig',NULL),(1370,'',0,0,'','order.actions.paymentActionsRow','admin','',100,'modules/CDev/Paypal/order/refund_in_progress.twig',NULL),(1371,'',0,0,'','payment.methods.list.row.after.ExpressCheckout','admin','',100,'modules/CDev/Paypal/items_list/payment/methods/parts/action.right.after.expressCheckout.twig',NULL),(1372,'',0,0,'','payment.methods.list.row.after.PayflowLink','admin','',100,'modules/CDev/Paypal/items_list/payment/methods/parts/action.right.after.twig',NULL),(1373,'',0,0,'','payment.methods.list.row.after.PaypalAdvanced','admin','',100,'modules/CDev/Paypal/items_list/payment/methods/parts/action.right.after.twig',NULL),(1374,'',0,0,'','payment.methods.list.row.after.PaypalWPS','admin','',100,'modules/CDev/Paypal/items_list/payment/methods/parts/action.right.after.twig',NULL),(1375,'',0,0,'','payment_status.after.ExpressCheckout','admin','',100,'modules/CDev/Paypal/settings/ExpressCheckout/payment_status.twig',NULL),(1376,'',0,0,'','itemsList.shipping-methods.header','admin','',20,'modules/CDev/USPS/refresh.twig',NULL),(1377,'',0,0,'','browseServer.item','admin','',200,'modules/CDev/Egoods/encrypt_mark.twig',NULL),(1378,'',0,0,'','order.actions.paymentActionsRow','admin','',19000,'modules/CDev/XPaymentsConnector/order/order/payment_actions/recharge.twig',NULL),(1379,'',0,0,'','order','admin','',1100,'modules/CDev/XPaymentsConnector/order/fraud_status/check.twig',NULL),(1380,'',0,0,'','order','admin','',1000,'modules/CDev/XPaymentsConnector/order/fraud_status/kount.twig',NULL),(1381,'',0,0,'','order.operations','admin','',290,'modules/CDev/XPaymentsConnector/order/transactions/body.twig',NULL),(1382,'',0,0,'','admin.account.saved_cards.before','admin','',100,'modules/CDev/XPaymentsConnector/account/saved_cards.header.twig',NULL),(1383,'',0,0,'','admin.account.add_new_card.address','admin','',100,'modules/CDev/XPaymentsConnector/account/add_new_card.address.twig',NULL),(1384,'',0,0,'','admin.account.saved_cards.table','admin','',100,'modules/CDev/XPaymentsConnector/account/saved_cards.table.twig',NULL),(1385,'',0,0,'','admin.account.add_new_card.form','admin','',100,'modules/CDev/XPaymentsConnector/account/add_new_card.form.twig',NULL),(1386,'',0,0,'','payment.methods.body','admin','',150,'modules/CDev/Moneybookers/register.twig',NULL),(1387,'',0,0,'','itemsList.cdev.simplecms.menu.header','admin','',10,'modules/CDev/SimpleCMS/menus/default_option.twig',NULL),(1388,'',0,0,'','product.modify.list','admin','',550,'modules/CDev/MarketPrice/price.twig',NULL),(1389,'',0,0,'','product.modify.list','admin','',832,'modules/CDev/ProductAdvisor/product/parts/coming_soon.twig',NULL),(1390,'',0,0,'','product.modify.list','admin','',832,'modules/CDev/ProductAdvisor/product/parts/new_arrival.twig',NULL),(1391,'',0,0,'','product.inventory.parts','admin','',10,'modules/CDev/PINCodes/inv_track_selector.twig',NULL),(1392,'',0,0,'','product.pinCodes','admin','',300,'modules/CDev/PINCodes/product/pins_status.twig',NULL),(1393,'',0,0,'','product.pinCodes','admin','',10,'modules/CDev/PINCodes/product/script_init.twig',NULL),(1394,'',0,0,'','product.pinCodes','admin','',100,'modules/CDev/PINCodes/product/enabled_checkbox.twig',NULL),(1395,'',0,0,'','product.pinCodes','admin','',400,'modules/CDev/PINCodes/product/actions.twig',NULL),(1396,'',0,0,'','product.pinCodes','admin','',200,'modules/CDev/PINCodes/product/auto_generate.twig',NULL),(1397,'',0,0,'','product.inventory.parts','admin','',20,'modules/CDev/PINCodes/inv_track_amount.twig',NULL),(1398,'',0,0,'','itemsList.products.search.cell.name','admin','',10,'modules/CDev/Sale/product/sale_label.twig',NULL),(1399,'',0,0,'','itemsList.product_selector.cell.name','admin','',10,'modules/CDev/Sale/product/sale_label.twig',NULL),(1400,'',0,0,'','sale_discount_types','admin','',20,'modules/CDev/Sale/sale_discount_types/parts/percent.twig',NULL),(1401,'',0,0,'','sale_discount_types','admin','',40,'modules/CDev/Sale/sale_discount_types/parts/hidden_percent.twig',NULL),(1402,'',0,0,'','sale_discount_types','admin','',10,'modules/CDev/Sale/sale_discount_types/parts/price.twig',NULL),(1403,'',0,0,'','sale_discount_types','admin','',30,'modules/CDev/Sale/sale_discount_types/parts/hidden_price.twig',NULL),(1404,'',0,0,'','itemsList.product.admin.featured.columns','admin','',40,'modules/CDev/FeaturedProducts/items_list/product/featured/parts/columns/category.twig',NULL),(1405,'',0,0,'','itemsList.product.admin.featured.columns','admin','',20,'modules/CDev/FeaturedProducts/items_list/product/featured/parts/columns/sku.twig',NULL),(1406,'',0,0,'','itemsList.product.admin.featured.columns','admin','',30,'modules/CDev/FeaturedProducts/items_list/product/featured/parts/columns/name.twig',NULL),(1407,'',0,0,'','itemsList.product.admin.featured.columns','admin','',10,'modules/CDev/FeaturedProducts/items_list/product/featured/parts/columns/checkbox.twig',NULL),(1408,'',0,0,'','itemsList.product.admin.featured.header','admin','',40,'modules/CDev/FeaturedProducts/items_list/product/featured/parts/header/category.twig',NULL),(1409,'',0,0,'','itemsList.product.admin.featured.header','admin','',20,'modules/CDev/FeaturedProducts/items_list/product/featured/parts/header/sku.twig',NULL),(1410,'',0,0,'','itemsList.product.admin.featured.header','admin','',30,'modules/CDev/FeaturedProducts/items_list/product/featured/parts/header/name.twig',NULL),(1411,'',0,0,'','itemsList.product.admin.featured.header','admin','',10,'modules/CDev/FeaturedProducts/items_list/product/featured/parts/header/checkbox.twig',NULL),(1412,'',0,0,'','itemsList.category.cell.featured_products','admin','',100,'modules/CDev/FeaturedProducts/items_list/category/parts/info.featured_products.twig',NULL),(1413,'',0,0,'','coupons.itemsList.header','admin','',100,'modules/CDev/Coupons/coupons/list/add.twig',NULL),(1414,'',0,0,'','itemsList.coupons.cell.code','admin','',16777215,'modules/CDev/Coupons/coupons/list/code.twig',NULL),(1415,'',0,0,'','invoice.base.totals.modifier.name','admin','',16777215,'modules/CDev/Coupons/coupons_minilist.twig',NULL),(1416,'',0,0,'','order.payment','admin','',120,'modules/QSL/BraintreeVZ/order/credit_card.twig',NULL),(1417,'',0,0,'','payment_status.after.PayPal_powered_by_Braintree','admin','',20,'modules/QSL/BraintreeVZ/config/status.twig',NULL),(1418,'',0,0,'','tabs.after.items','admin','',100,'profiles/parts/actions.twig',NULL),(1419,'',0,0,'','profiles.search.dateTypes','admin','',100,'profiles/parts/search_form/date_type.registered.twig',NULL),(1420,'',0,0,'','profiles.search.dateTypes','admin','',200,'profiles/parts/search_form/date_type.logged.twig',NULL),(1421,'',0,0,'','languages.add-language','admin','',300,'languages/languages/parts/import_language.twig',NULL),(1422,'',0,0,'','file_select_dialog.file_selections','admin','',400,'file_selector/parts/local_server_input.twig',NULL),(1423,'',0,0,'','file_select_dialog.file_selections','admin','',100,'file_selector/parts/local_computer_label.twig',NULL),(1424,'',0,0,'','file_select_dialog.file_selections','admin','',600,'file_selector/parts/url_input.twig',NULL),(1425,'',0,0,'','file_select_dialog.file_selections_url','admin','',600,'file_selector/parts/url_input.twig',NULL),(1426,'',0,0,'','file_select_dialog.file_selections','admin','',300,'file_selector/parts/local_server_label.twig',NULL),(1427,'',0,0,'','file_select_dialog.actions','admin','',100,'file_selector/parts/file_select_actions.twig',NULL),(1428,'',0,0,'','file_select_dialog.file_selections','admin','',700,'file_selector/parts/url_copy_to_local.twig',NULL),(1429,'',0,0,'','file_select_dialog.file_selections_url','admin','',700,'file_selector/parts/url_copy_to_local.twig',NULL),(1430,'',0,0,'','file_select_dialog.file_selections','admin','',500,'file_selector/parts/url_label.twig',NULL),(1431,'',0,0,'','file_select_dialog.file_selections_url','admin','',500,'file_selector/parts/url_label.twig',NULL),(1432,'',0,0,'','file_select_dialog.file_selections','admin','',200,'file_selector/parts/local_computer_input.twig',NULL),(1433,'',0,0,'','images_settings','admin','',40,'images_settings/parts/layout_settings.cloud_zoom.twig',NULL),(1434,'',0,0,'','images_settings','admin','',55,'images_settings/parts/lazy_load.twig',NULL),(1435,'',0,0,'','images_settings','admin','',35,'images_settings/parts/unsharp_mask.twig',NULL),(1436,'',0,0,'','images_settings','admin','',30,'images_settings/parts/resize_quality.twig',NULL),(1437,'',0,0,'','images_settings','admin','',50,'images_settings/parts/layout_settings.cloud_zoom_mode.twig',NULL),(1438,'',0,0,'','images_settings','admin','',60,'images_settings/parts/default_settings.twig',NULL),(1439,'',0,0,'','images_settings','admin','',20,'images_settings/parts/resize_images.twig',NULL),(1440,'',0,0,'','product.plain_price','admin','',10,'common/price_parts/price.twig',NULL),(1441,'',0,0,'','product.plain_price_only','admin','',10,'common/price_parts/price.twig',NULL),(1442,'',0,0,'','edit_shipping','admin','',16777215,'shipping/add_method/parts/offline_create.twig',NULL),(1443,'',0,0,'','crud.shipping.offline.formFooter','admin','',16777215,'shipping/add_method/parts/rates.twig',NULL),(1444,'',0,0,'','itemsList.shipping-methods.header','admin','',10,'shipping/methods.status.twig',NULL),(1445,'',0,0,'','itemsList.notification.header','admin','',100,'notifications/list.twig',NULL),(1446,'',0,0,'','itemsList.notification.cell.name','admin','',100,'notifications/cell.name.twig',NULL),(1447,'',0,0,'','crud.notificationattachments.formHeader','admin','',100,'notifications/parts/warning.twig',NULL),(1448,'',0,0,'','itemsList.notification.cell.enabledForAdmin','admin','',100,'notifications/cell.enabledForAdmin.twig',NULL),(1449,'',0,0,'','upgrade.step.ready_to_install.buttons.sections.right','admin','',200,'upgrade/step/ready_to_install/buttons/parts/try_again.twig',NULL),(1450,'',0,0,'','upgrade.step.ready_to_install.entries_list.sections.permissions.buttons','admin','',200,'upgrade/step/ready_to_install/buttons/parts/try_again.twig',NULL),(1451,'',0,0,'','upgrade.step.ready_to_install.buttons.sections.left','admin','',200,'upgrade/step/ready_to_install/buttons/parts/install.twig',NULL),(1452,'',0,0,'','upgrade.step.ready_to_install.buttons.sections','admin','',100,'upgrade/step/ready_to_install/buttons/parts/left.twig',NULL),(1453,'',0,0,'','upgrade.step.ready_to_install.buttons.sections','admin','',200,'upgrade/step/ready_to_install/buttons/parts/right.twig',NULL),(1454,'',0,0,'','upgrade.step.ready_to_install.buttons.sections.left','admin','',100,'upgrade/step/ready_to_install/buttons/parts/agree.twig',NULL),(1455,'',0,0,'','upgrade.step.ready_to_install.buttons.sections.left','admin','',150,'upgrade/step/ready_to_install/buttons/parts/remove_agree.twig',NULL),(1456,'',0,0,'','upgrade.step.ready_to_install.entries_list.sections.permissions.buttons','admin','',100,'upgrade/step/ready_to_install/entries_list/parts/permissions/buttons/copy.twig',NULL),(1457,'',0,0,'','upgrade.step.ready_to_install.entries_list.sections.table.columns','admin','',300,'upgrade/step/ready_to_install/entries_list/parts/table/columns/changelog_link.twig',NULL),(1458,'',0,0,'','upgrade.step.ready_to_install.entries_list.sections.table.columns','admin','',300,'upgrade/step/ready_to_install/entries_list/parts/table/columns/version.twig',NULL),(1459,'',0,0,'','upgrade.step.completed.entries_list.sections.table.columns','admin','',300,'upgrade/step/ready_to_install/entries_list/parts/table/columns/version.twig',NULL),(1460,'',0,0,'','upgrade.step.ready_to_install.entries_list.sections.table.columns','admin','',100,'upgrade/step/ready_to_install/entries_list/parts/table/columns/component.twig',NULL),(1461,'',0,0,'','upgrade.step.completed.entries_list.sections.table.columns','admin','',100,'upgrade/step/ready_to_install/entries_list/parts/table/columns/component.twig',NULL),(1462,'',0,0,'','upgrade.step.ready_to_install.entries_list.sections.table.columns','admin','',200,'upgrade/step/ready_to_install/entries_list/parts/table/columns/status.twig',NULL),(1463,'',0,0,'','upgrade.step.completed.entries_list.sections.table.columns','admin','',200,'upgrade/step/ready_to_install/entries_list/parts/table/columns/status.twig',NULL),(1464,'',0,0,'','upgrade.step.ready_to_install.entries_list.sections.table.columns.changelog','admin','',350,'upgrade/step/ready_to_install/entries_list/parts/table/columns/changelog.twig',NULL),(1465,'',0,0,'','upgrade.step.ready_to_install.entries_list.sections.table.columns.error','admin','',400,'upgrade/step/ready_to_install/entries_list/parts/table/columns/error.twig',NULL),(1466,'',0,0,'','upgrade.step.ready_to_install.entries_list.sections.table.header','admin','',300,'upgrade/step/ready_to_install/entries_list/parts/table/header/version.twig',NULL),(1467,'',0,0,'','upgrade.step.completed.entries_list.sections.table.header','admin','',300,'upgrade/step/ready_to_install/entries_list/parts/table/header/version.twig',NULL),(1468,'',0,0,'','upgrade.step.ready_to_install.entries_list.sections.table.header','admin','',100,'upgrade/step/ready_to_install/entries_list/parts/table/header/component.twig',NULL),(1469,'',0,0,'','upgrade.step.completed.entries_list.sections.table.header','admin','',100,'upgrade/step/ready_to_install/entries_list/parts/table/header/component.twig',NULL),(1470,'',0,0,'','upgrade.step.ready_to_install.entries_list.sections.table.header','admin','',200,'upgrade/step/ready_to_install/entries_list/parts/table/header/status.twig',NULL),(1471,'',0,0,'','upgrade.step.completed.entries_list.sections.table.header','admin','',200,'upgrade/step/ready_to_install/entries_list/parts/table/header/status.twig',NULL),(1472,'',0,0,'','upgrade.step.ready_to_install.entries_list.sections.table.header','admin','',300,'upgrade/step/ready_to_install/entries_list/parts/table/header/changelog.twig',NULL),(1473,'',0,0,'','upgrade.step.ready_to_install.entries_list.sections','admin','',100,'upgrade/step/ready_to_install/entries_list/parts/table.twig',NULL),(1474,'',0,0,'','upgrade.step.completed.entries_list.sections','admin','',200,'upgrade/step/ready_to_install/entries_list/parts/table.twig',NULL),(1475,'',0,0,'','upgrade.step.completed.backup.actions','admin','',300,'upgrade/step/completed/backup/part/actions/restore_backup.twig',NULL),(1476,'',0,0,'','upgrade.step.completed.backup.actions','admin','',100,'upgrade/step/completed/backup/part/actions/soft_reset.twig',NULL),(1477,'',0,0,'','upgrade.step.ready_to_install.create_backup.actions','admin','',100,'upgrade/step/completed/backup/part/actions/soft_reset.twig',NULL),(1478,'',0,0,'','upgrade.step.ready_to_install.create_backup.actions','admin','',50,'upgrade/step/completed/backup/part/actions/restore_snapshot.twig',NULL),(1479,'',0,0,'','upgrade.step.completed.backup.actions','admin','',200,'upgrade/step/completed/backup/part/actions/hard_reset.twig',NULL),(1480,'',0,0,'','upgrade.step.ready_to_install.create_backup.actions','admin','',200,'upgrade/step/completed/backup/part/actions/hard_reset.twig',NULL),(1481,'',0,0,'','upgrade.step.completed.backup.sections','admin','',100,'upgrade/step/completed/backup/part/description.twig',NULL),(1482,'',0,0,'','upgrade.step.prepare.incompatible_entries_upgrade.sections.table.info','admin','',100,'upgrade/step/prepare/incompatible_entries_upgrade/parts/table/info/name.twig',NULL),(1483,'',0,0,'','upgrade.step.prepare.incompatible_entries_upgrade.sections.table.info.module','admin','',100,'upgrade/step/prepare/incompatible_entries_upgrade/parts/table/info/module/version.twig',NULL),(1484,'',0,0,'','upgrade.step.prepare.incompatible_entries_upgrade.sections.table.info.module','admin','',200,'upgrade/step/prepare/incompatible_entries_upgrade/parts/table/info/module/author.twig',NULL),(1485,'',0,0,'','upgrade.step.prepare.incompatible_entries_upgrade.sections.table.info','admin','',200,'upgrade/step/prepare/incompatible_entries_upgrade/parts/table/info/module.twig',NULL),(1486,'',0,0,'','upgrade.step.prepare.incompatible_entries_upgrade.sections.table','admin','',200,'upgrade/step/prepare/incompatible_entries_upgrade/parts/table/info.twig',NULL),(1487,'',0,0,'','upgrade.step.prepare.incompatible_entries_upgrade.sections.table','admin','',100,'upgrade/step/prepare/incompatible_entries_upgrade/parts/table/icon.twig',NULL),(1488,'',0,0,'','upgrade.step.prepare.incompatible_entries_upgrade.sections','admin','',200,'upgrade/step/prepare/incompatible_entries_upgrade/parts/table.twig',NULL),(1489,'',0,0,'','upgrade.step.prepare.incompatible_entries_upgrade.sections','admin','',100,'upgrade/step/prepare/incompatible_entries_upgrade/parts/description.twig',NULL),(1490,'',0,0,'','upgrade.step.prepare.incompatible_entries_update.sections','admin','',300,'upgrade/step/prepare/incompatible_entries_update/parts/agree.twig',NULL),(1491,'',0,0,'','upgrade.step.prepare.incompatible_entries_update.sections.table.columns','admin','',100,'upgrade/step/prepare/incompatible_entries_update/parts/table/columns/name.twig',NULL),(1492,'',0,0,'','upgrade.step.prepare.incompatible_entries_update.sections.table.columns','admin','',200,'upgrade/step/prepare/incompatible_entries_update/parts/table/columns/icon.twig',NULL),(1493,'',0,0,'','upgrade.step.prepare.incompatible_entries_update.sections.table.columns','admin','',300,'upgrade/step/prepare/incompatible_entries_update/parts/table/columns/checkbox.twig',NULL),(1494,'',0,0,'','upgrade.step.prepare.incompatible_entries_update.sections','admin','',200,'upgrade/step/prepare/incompatible_entries_update/parts/table.twig',NULL),(1495,'',0,0,'','upgrade.step.prepare.incompatible_entries_update.sections','admin','',100,'upgrade/step/prepare/incompatible_entries_update/parts/description.twig',NULL),(1496,'',0,0,'','upgrade.step.prepare.entries_list_upgrade.sections.table.info','admin','',100,'upgrade/step/prepare/entries_list_upgrade/parts/table/info/name.twig',NULL),(1497,'',0,0,'','upgrade.step.prepare.entries_list_upgrade.sections.table.info.module','admin','',100,'upgrade/step/prepare/entries_list_upgrade/parts/table/info/module/version.twig',NULL),(1498,'',0,0,'','upgrade.step.prepare.entries_list_upgrade.sections.table.info.module','admin','',200,'upgrade/step/prepare/entries_list_upgrade/parts/table/info/module/author.twig',NULL),(1499,'',0,0,'','upgrade.step.prepare.entries_list_upgrade.sections.table.info.module','admin','',300,'upgrade/step/prepare/entries_list_upgrade/parts/table/info/module/status.twig',NULL),(1500,'',0,0,'','upgrade.step.prepare.entries_list_upgrade.sections.table.info','admin','',200,'upgrade/step/prepare/entries_list_upgrade/parts/table/info/module.twig',NULL),(1501,'',0,0,'','upgrade.step.prepare.entries_list_upgrade.sections.table','admin','',200,'upgrade/step/prepare/entries_list_upgrade/parts/table/info.twig',NULL),(1502,'',0,0,'','upgrade.step.prepare.entries_list_upgrade.sections.table','admin','',100,'upgrade/step/prepare/entries_list_upgrade/parts/table/icon.twig',NULL),(1503,'',0,0,'','upgrade.step.prepare.entries_list_upgrade.sections','admin','',100,'upgrade/step/prepare/entries_list_upgrade/parts/table.twig',NULL),(1504,'',0,0,'','upgrade.step.prepare.buttons.sections','admin','',50,'upgrade/step/prepare/buttons/parts/expired_keys.twig',NULL),(1505,'',0,0,'','upgrade.step.prepare.buttons.sections','admin','',200,'upgrade/step/prepare/buttons/parts/continue.twig',NULL),(1506,'',0,0,'','upgrade.step.prepare.buttons.sections','admin','',200,'upgrade/step/prepare/buttons/parts/trial_notice.twig',NULL),(1507,'',0,0,'','upgrade.step.prepare.entries_list_update.sections.table.columns','admin','',600,'upgrade/step/prepare/entries_list_update/parts/table/columns/size.twig',NULL),(1508,'',0,0,'','upgrade.step.prepare.entries_list_update.sections.table.columns','admin','',500,'upgrade/step/prepare/entries_list_update/parts/table/columns/version_new.twig',NULL),(1509,'',0,0,'','upgrade.step.prepare.entries_list_update.sections.table.columns','admin','',400,'upgrade/step/prepare/entries_list_update/parts/table/columns/version_separator.twig',NULL),(1510,'',0,0,'','upgrade.step.prepare.entries_list_update.sections.table.columns','admin','',300,'upgrade/step/prepare/entries_list_update/parts/table/columns/version_old.twig',NULL),(1511,'',0,0,'','upgrade.step.prepare.entries_list_update.sections.table.columns','admin','',100,'upgrade/step/prepare/entries_list_update/parts/table/columns/name.twig',NULL),(1512,'',0,0,'','upgrade.step.prepare.entries_list_update.sections.table.columns','admin','',200,'upgrade/step/prepare/entries_list_update/parts/table/columns/status.twig',NULL),(1513,'',0,0,'','upgrade.step.prepare.entries_list_update.sections.table.header','admin','',300,'upgrade/step/prepare/entries_list_update/parts/table/header/size.twig',NULL),(1514,'',0,0,'','upgrade.step.prepare.entries_list_update.sections.table.header','admin','',200,'upgrade/step/prepare/entries_list_update/parts/table/header/version.twig',NULL),(1515,'',0,0,'','upgrade.step.prepare.entries_list_update.sections.table.header','admin','',100,'upgrade/step/prepare/entries_list_update/parts/table/header/component.twig',NULL),(1516,'',0,0,'','upgrade.step.prepare.entries_list_update.sections','admin','',100,'upgrade/step/prepare/entries_list_update/parts/table.twig',NULL),(1517,'',0,0,'','upgrade.install_updates.sections','admin','',100,'upgrade/install_updates/parts/top.twig',NULL),(1518,'',0,0,'','upgrade.install_updates.sections','admin','',200,'upgrade/install_updates/parts/form.twig',NULL),(1519,'',0,0,'','upgrade.install_updates.sections.form.info','admin','',300,'upgrade/install_updates/parts/form/info/version.twig',NULL),(1520,'',0,0,'','upgrade.install_updates.sections.form.info','admin','',100,'upgrade/install_updates/parts/form/info/name.twig',NULL),(1521,'',0,0,'','upgrade.install_updates.sections.form.info.module','admin','',100,'upgrade/install_updates/parts/form/info/module/author.twig',NULL),(1522,'',0,0,'','upgrade.install_updates.sections.form.info.module','admin','',200,'upgrade/install_updates/parts/form/info/module/status.twig',NULL),(1523,'',0,0,'','upgrade.install_updates.sections.form.info','admin','',200,'upgrade/install_updates/parts/form/info/module.twig',NULL),(1524,'',0,0,'','upgrade.install_updates.sections.form','admin','',200,'upgrade/install_updates/parts/form/info.twig',NULL),(1525,'',0,0,'','upgrade.install_updates.sections.form','admin','',100,'upgrade/install_updates/parts/form/icon.twig',NULL),(1526,'',0,0,'','upgrade.install_updates.sections','admin','',300,'upgrade/install_updates/parts/advanced_link.twig',NULL),(1527,'',0,0,'','export.completed.content','admin','',200,'export/parts/completed.downloadLarge.twig',NULL),(1528,'',0,0,'','export.begin.options','admin','',200,'export/parts/option.attrs.twig',NULL),(1529,'',0,0,'','export.popup.completed.content','admin','',100,'export/parts/popup.completed.message.twig',NULL),(1530,'',0,0,'','export.begin.buttons','admin','',100,'export/parts/begin.buttons.export.twig',NULL),(1531,'',0,0,'','export.begin.content','admin','',100,'export/parts/begin.sections.twig',NULL),(1532,'',0,0,'','export.begin.content','admin','',200,'export/parts/begin.options.twig',NULL),(1533,'',0,0,'','export.completed.content','admin','',100,'export/parts/completed.download.twig',NULL),(1534,'',0,0,'','export.popup.completed.content','admin','',100,'export/parts/completed.download.twig',NULL),(1535,'',0,0,'','export.failed.buttons','admin','',100,'export/parts/failed.buttons.export.twig',NULL),(1536,'',0,0,'','export.begin.options','admin','',400,'export/parts/option.delimiter.twig',NULL),(1537,'',0,0,'','export.begin.options','admin','',300,'export/parts/option.charset.twig',NULL),(1538,'',0,0,'','export.failed.content','admin','',100,'export/parts/failed.errors.twig',NULL),(1539,'',0,0,'','export.completed.buttons','admin','',100,'export/parts/completed.buttons.export.twig',NULL),(1540,'',0,0,'','export.begin.options','admin','',100,'export/parts/option.files.twig',NULL),(1541,'',0,0,'','invoice.bottom.method.shipping','common','',20,'order/invoice/parts/bottom.methods.shipping.twig',NULL),(1542,'',0,0,'','invoice.subhead.companyAddress','common','',100,'order/invoice/parts/head.companyAddress.name.twig',NULL),(1543,'',0,0,'','invoice.bottom.address.billing','common','',10,'order/invoice/parts/bottom.address.billing.twig',NULL),(1544,'',0,0,'','invoice.subhead.companyAddress','common','',200,'order/invoice/parts/head.companyAddress.address.twig',NULL),(1545,'',0,0,'','invoice.head','common','',10,'order/invoice/parts/title.twig',NULL),(1546,'',0,0,'','invoice.base','common','',10,'order/invoice/parts/head.twig',NULL),(1547,'',0,0,'','invoice.base','common','',55,'order/invoice/parts/instruction.twig',NULL),(1548,'',0,0,'','invoice.bottom.lines','common','',10,'order/invoice/parts/bottom.methods.twig',NULL),(1549,'',0,0,'','invoice.base.totals.after','common','',20,'order/invoice/parts/totals.includedModifiers.twig',NULL),(1550,'',0,0,'','invoice.base','common','',60,'order/invoice/parts/totals.twig',NULL),(1551,'',0,0,'','invoice.subhead.companyAddress','common','',300,'order/invoice/parts/head.companyAddress.phone.twig',NULL),(1552,'',0,0,'','invoice.subhead','common','',20,'order/invoice/parts/head.address.twig',NULL),(1553,'',0,0,'','invoice.subhead','common','',10,'order/invoice/parts/bottom.twig',NULL),(1554,'',0,0,'','invoice.base.totals.after','common','',10,'order/invoice/parts/totals.total.twig',NULL),(1555,'',0,0,'','invoice.head','common','',20,'order/invoice/parts/head.logo.twig',NULL),(1556,'',0,0,'','invoice.base','common','',40,'order/invoice/parts/note.twig',NULL),(1557,'',0,0,'','invoice.base','common','',20,'order/invoice/parts/subhead.twig',NULL),(1558,'',0,0,'','invoice.base.totals','common','',200,'order/invoice/parts/totals.modifiers.twig',NULL),(1559,'',0,0,'','invoice.bottom.method.payment','common','',20,'order/invoice/parts/bottom.methods.payment.twig',NULL),(1560,'',0,0,'','invoice.base.totals','common','',100,'order/invoice/parts/totals.subtotal.twig',NULL),(1561,'',0,0,'','invoice.subhead.companyAddress','common','',500,'order/invoice/parts/head.companyAddress.website.twig',NULL),(1562,'',0,0,'','invoice.base','common','',50,'order/invoice/parts/items/items.twig',NULL),(1563,'',0,0,'','invoice.item','common','',10,'order/invoice/parts/items/item.name.twig',NULL),(1564,'',0,0,'','invoice.items.head','common','',30,'order/invoice/parts/items/items.head.qty.twig',NULL),(1565,'',0,0,'','invoice.item','common','',40,'order/invoice/parts/items/item.total.twig',NULL),(1566,'',0,0,'','invoice.item','common','',20,'order/invoice/parts/items/item.price.twig',NULL),(1567,'',0,0,'','invoice.items.head','common','',10,'order/invoice/parts/items/items.head.item.twig',NULL),(1568,'',0,0,'','invoice.items.head','common','',20,'order/invoice/parts/items/items.head.price.twig',NULL),(1569,'',0,0,'','invoice.item.name','common','',10,'order/invoice/parts/items/item.sku.twig',NULL),(1570,'',0,0,'','invoice.items.head','common','',40,'order/invoice/parts/items/items.head.total.twig',NULL),(1571,'',0,0,'','invoice.item','common','',30,'order/invoice/parts/items/item.qty.twig',NULL),(1572,'',0,0,'','invoice.bottom.address.shipping','common','',20,'order/invoice/parts/bottom.address.shipping.twig',NULL),(1573,'',0,0,'','invoice.subhead.companyAddress','common','',400,'order/invoice/parts/head.companyAddress.fax.twig',NULL),(1574,'',0,0,'','product.plain_price','common','',10,'common/price_parts/price.twig',NULL),(1575,'',0,0,'','product.plain_price_only','common','',10,'common/price_parts/price.twig',NULL),(1576,'',0,0,'','minicart.horizontal.item.name','customer','XLite\\View\\MinicartAttributeValues',10,'',NULL),(1577,'',0,0,'','product.details.page.image','customer','XLite\\View\\Product\\Details\\Customer\\PhotoBox',5,'',NULL),(1578,'',0,0,'','product.details.page','customer','XLite\\View\\Product\\Details\\Customer\\Gallery',15,'',NULL),(1579,'',0,0,'','product.details.quicklook','customer','XLite\\View\\Product\\Details\\Customer\\Gallery',15,'',NULL),(1580,'',0,0,'','layout.main','customer','XLite\\View\\BannerRotation\\BannerRotation',350,'',NULL),(1581,'',0,0,'','checkout.review.selected','customer','XLite\\Module\\CDev\\Coupons\\View\\CartCoupons',200,'',NULL),(1582,'',0,0,'','product.details.page','customer','XLite\\Module\\XC\\NextPreviousProduct\\View\\Product\\Details\\Customer\\NextPreviousProduct',17,'',NULL),(1583,'',0,0,'','layout.main.footer.before','customer','XLite\\Module\\XC\\NewsletterSubscriptions\\View\\SubscribeBlock',10,'',NULL),(1584,'',0,0,'','product.details.quicklook.info.buttons.cart-buttons','customer','XLite\\Module\\XC\\ProductComparison\\View\\AddToCompare\\Product',120,'',NULL),(1585,'',0,0,'','product.details.quicklook.info.buttons-added.cart-buttons','customer','XLite\\Module\\XC\\ProductComparison\\View\\AddToCompare\\Product',129,'',NULL),(1586,'',0,0,'','layout.header.right','customer','XLite\\Module\\XC\\ProductComparison\\View\\AddToCompare\\ProductCompareIndicator',50,'',NULL),(1587,'',0,0,'','layout.header.right.mobile','customer','XLite\\Module\\XC\\ProductComparison\\View\\AddToCompare\\ProductCompareIndicator',50,'',NULL),(1588,'',0,0,'','slidebar.additional-menu.links','customer','XLite\\Module\\XC\\ProductComparison\\View\\AddToCompare\\ProductCompareLink',20,'',NULL),(1589,'',0,0,'','itemsList.product.grid.customer.marks','customer','XLite\\Module\\XC\\ProductComparison\\View\\AddToCompare\\Products',200,'',NULL),(1590,'',0,0,'','itemsList.product.list.customer.marks','customer','XLite\\Module\\XC\\ProductComparison\\View\\AddToCompare\\Products',200,'',NULL),(1591,'',0,0,'','itemsList.product.table.customer.marks','customer','XLite\\Module\\XC\\ProductComparison\\View\\AddToCompare\\Products',200,'',NULL),(1592,'',0,0,'','customer.signin.popup.fields','customer','',500,'authorization/parts/field.links.twig',NULL),(1593,'',0,0,'','center.top','customer','',1000,'layout/content/main.location.twig',NULL),(1594,'',0,0,'','product.details.page.info','customer','',5,'layout/content/product.location.twig',NULL),(1595,'',0,0,'','layout.header','customer','',300,'layout/header/top_menu.twig',NULL),(1596,'',0,0,'','layout.header','customer','',350,'layout/header/header.right.twig',NULL),(1597,'',0,0,'','layout.header.bar','customer','',50,'layout/header/header.bar.search.twig',NULL),(1598,'',0,0,'','layout.header.right.mobile','customer','',1100,'layout/header/header.bar.checkout.logos.twig',NULL),(1599,'',0,0,'','layout.header.mobile.menu','customer','',2000,'layout/header/mobile_header_parts/slidebar_menu.twig',NULL),(1600,'',0,0,'','itemsList.product.small_thumbnails.customer.info.photo','customer','',30,'items_list/product/parts/common.labels.twig',NULL),(1601,'',0,0,'','product.details.quicklook.image','customer','',17,'items_list/product/parts/common.labels.twig',NULL),(1602,'',0,0,'','cart.item','customer','',100,'shopping_cart/parts/item.remove.twig',NULL),(1603,'',0,0,'','cart.item.info','customer','',15,'shopping_cart/parts/item.info.weight.twig',NULL),(1604,'',0,0,'','itemsList.product.grid.customer.info','customer','',24,'product/details/stock/label.twig',NULL),(1605,'',0,0,'','itemsList.product.list.customer.info','customer','',32,'product/details/stock/label.twig',NULL),(1606,'',0,0,'','itemsList.product.grid.customer.header','customer','',10,'items_list/product/parts/common.sort-options.twig',NULL),(1607,'',0,0,'','itemsList.product.list.customer.header','customer','',10,'items_list/product/parts/common.sort-options.twig',NULL),(1608,'',0,0,'','itemsList.product.table.customer.header','customer','',10,'items_list/product/parts/common.sort-options.twig',NULL),(1609,'',0,0,'','itemsList.product.grid.customer.header','customer','',20,'items_list/product/parts/common.display-modes.twig',NULL),(1610,'',0,0,'','itemsList.product.list.customer.header','customer','',20,'items_list/product/parts/common.display-modes.twig',NULL),(1611,'',0,0,'','itemsList.product.table.customer.header','customer','',20,'items_list/product/parts/common.display-modes.twig',NULL),(1612,'',0,0,'','itemsList.product.list.customer.info','customer','',20,'items_list/product/center/list/parts/common.product-name.twig',NULL),(1613,'',0,0,'','itemsList.product.grid.customer.marks','customer','',100,'items_list/product/parts/common.added-mark.twig',NULL),(1614,'',0,0,'','itemsList.product.list.customer.marks','customer','',100,'items_list/product/parts/common.added-mark.twig',NULL),(1615,'',0,0,'','itemsList.product.table.customer.marks','customer','',100,'items_list/product/parts/common.added-mark.twig',NULL),(1616,'',0,0,'','product.details.page.image.photo','customer','',100,'product/details/parts/common.loupe.twig',NULL),(1617,'',0,0,'','product.details.page.info','customer','',19,'product/details/parts/common.briefDescription.twig',NULL),(1618,'',0,0,'','product.details.page.info','customer','',16,'product/details/parts/common.stock.twig',NULL),(1619,'',0,0,'','product.details.page.info','customer','',35,'product/details/parts/common.product-editable-attributes.twig',NULL),(1620,'',0,0,'','product.details.quicklook.info','customer','',30,'product/details/parts/common.product-editable-attributes.twig',NULL),(1621,'',0,0,'','product.details.quicklook.image','customer','',30,'product/details/parts/common.more-info-link.twig',NULL),(1622,'',0,0,'','itemsList.product.grid.customer.info.photo','customer','',998,'items_list/product/parts/grid.button-add2cart-wrapper.twig',NULL),(1623,'',0,0,'','product.details.page.image','customer','',10,'product/details/parts/common.product-added.twig',NULL),(1624,'',0,0,'','product.details.quicklook.image','customer','',5,'product/details/parts/common.product-added.twig',NULL),(1625,'',0,0,'','checkout.payment.address.before','customer','',10,'checkout/steps/shipping/parts/address.billing.same.twig',NULL),(1626,'',0,0,'','product.details.page.image','customer','',20,'modules/CDev/GoSocial/product/details/parts/common.share.twig',NULL),(1627,'',0,0,'','product.details.page.info','customer','',17,'modules/XC/FreeShipping/free_ship.label.twig',NULL),(1628,'',0,0,'','product.details.page.info','customer','',16,'modules/CDev/ProductAdvisor/product/details/parts/common.coming_soon.twig',NULL),(1629,'',0,0,'','product.details.quicklook.info','customer','',16,'modules/CDev/ProductAdvisor/product/details/parts/common.coming_soon.twig',NULL),(1630,'',0,0,'','itemsList.product.grid.customer.info','customer','',27,'modules/CDev/ProductAdvisor/expected.twig',NULL),(1631,'',0,0,'','itemsList.product.list.customer.info','customer','',33,'modules/CDev/ProductAdvisor/expected.twig',NULL),(1632,'',0,0,'','itemsList.product.grid.customer.info','customer','',16,'modules/XC/Reviews/product.items_list.rating.twig',NULL),(1633,'',0,0,'','itemsList.product.list.customer.info','customer','',35,'modules/XC/Reviews/product.items_list.rating.twig',NULL),(1634,'',0,0,'','product.details.quicklook.image','customer','',20,'modules/XC/Reviews/product_details.rating.twig',NULL),(1635,'',0,0,'','product.details.page.info','customer','',18,'modules/XC/Reviews/product_details.rating.twig',NULL),(1636,'',0,0,'','reviews.page.rating','customer','',100,'modules/XC/Reviews/reviews_page/parts/average_rating.form.twig',NULL),(1637,'',0,0,'','signin-anonymous-title','customer','',300,'modules/Amazon/PayWithAmazon/login/signin/signin.checkout.twig',NULL),(1638,'',0,0,'','signin-anonymous-title','customer','',300,'modules/CDev/Paypal/login/signin/signin.checkout.paypal.twig',NULL),(1639,'',0,0,'','checkout_fastlane.header.top','customer','XLite\\View\\AllInOneSolutions',100,'',NULL),(1640,'',0,0,'','checkout_fastlane.header.top','customer','',100,'layout/header/header.bar.checkout.logos.twig',NULL);
CREATE TABLE `xlite_xpc_payment_data_cells` (
  `data_id` int(11) NOT NULL AUTO_INCREMENT,
  `transaction_id` int(11) DEFAULT NULL,
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`data_id`),
  KEY `IDX_CD89A76F2FC0CB0F` (`transaction_id`),
  KEY `tn` (`transaction_id`,`name`),
  CONSTRAINT `FK_CD89A76F2FC0CB0F` FOREIGN KEY (`transaction_id`) REFERENCES `xlite_payment_transactions` (`transaction_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_access_control_cells` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hash` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `returnData` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `resendMethod` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_order_capost_parcel_shipment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shipmentId` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `shipmentStatus` varchar(14) COLLATE utf8_unicode_ci DEFAULT NULL,
  `trackingPin` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `returnTrackingPin` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `poNumber` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `parcelId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_7954C1A5A9ACC87` (`parcelId`),
  CONSTRAINT `FK_7954C1A5A9ACC87` FOREIGN KEY (`parcelId`) REFERENCES `xlite_order_capost_parcels` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_newsletter_subscriptions_subscribers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `profile_id` int(11) DEFAULT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `IDX_D0911E5FCCFA12B8` (`profile_id`),
  CONSTRAINT `FK_D0911E5FCCFA12B8` FOREIGN KEY (`profile_id`) REFERENCES `xlite_profiles` (`profile_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_language_labels` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`label_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_language_labels` VALUES (4358,' page and make sure that:'),(3398,'\"Cash on delivery\" status'),(4357,'\"Site management\"'),(2070,'\"X product\" options'),(1194,'\"{{number}}\" tracking number is added'),(1195,'\"{{number}}\" tracking number is removed'),(1849,'\"{{product}} product\" attributes'),(2020,'# selected'),(1,'%'),(2092,'\'RESULT\' argument not found'),(2087,'\'status\' request argument can not found'),(3632,'(disabled role)'),(4245,'(like categories, weight, description, color)'),(2085,'(optional)'),(4261,'(without writing a single line of code) - 2 min'),(450,'+12130000000'),(3971,'+15550000000'),(1793,'- OR -'),(254,'-- No categories --'),(2611,'...Downloading {{entry}}...{{status}}'),(2609,'...Hooks {{hooksCount}}'),(2608,'...Hooks {{hooksCount}}, Items {{itemsCount}}...'),(2607,'...Invoke {{type}} hook for {{entry}}...'),(2610,'...Unpacking {{entry}}...{{status}}'),(4075,'1 day'),(4070,'1 hour'),(4066,'1 minute'),(4078,'1 week'),(4439,'1.1 (X-Payments 1.0.5 and earlier)'),(4440,'1.2 (X-Payments 2.0 and X-Payments 1.0.6)'),(4487,'1.3 (X-Payments 2.1)'),(4067,'10 minutes'),(446,'1000 Example street'),(3972,'1000 Main Street'),(4074,'12 hours'),(4286,'120+ supported payment gateways, such as PayPal, Authorize.net and etc.'),(403,'14days'),(4068,'15 minutes'),(4575,'18 years'),(4576,'19 years'),(4076,'2 days'),(4071,'2 hours'),(4353,'2Checkout.com account number'),(4069,'30 minutes'),(404,'30days'),(4072,'4 hours'),(4077,'5 days'),(4073,'6 hours'),(402,'7days'),(449,'90001'),(2612,'<span>X</span> items'),(3968,'A - Z'),(1491,'A DB error occurred while uninstalling the module X'),(4181,'A dispute has been opened successfully'),(2243,'A new category will be created'),(454,'A new customer? Enter your e-mail'),(2240,'A new membership will be created'),(2241,'A new product class will be created'),(2239,'A new product will be created'),(3769,'A new review has been submitted for the product \"{{name}}\".'),(2242,'A new tax class will be created'),(3408,'A single domain'),(455,'ABA routing number'),(4311,'API Login ID'),(3449,'API access password'),(3448,'API access username'),(3453,'API certificate'),(3452,'API certificate filename'),(3443,'API credentials for payments and post-checkout operations'),(3451,'API signature'),(391,'APRIL'),(395,'AUGUST'),(2485,'About X remaining'),(2786,'About clean urls'),(456,'Absolute'),(457,'Accept'),(2735,'Accept[TT]'),(458,'Accepted orders'),(4698,'Access Key ID'),(3235,'Access denied'),(460,'Access denied!'),(461,'Access information'),(462,'Access is locked out'),(463,'Access level'),(2756,'Access level cannot be changed (from {{prevValue}} to {{value}}) for existing profile ({{login}})'),(3236,'Access link has been successfully sent'),(464,'Account'),(465,'Account details'),(263,'Account settings'),(466,'Account status'),(467,'Account summary'),(2617,'Accounting'),(2399,'Action'),(1487,'Action X::Y, M'),(41,'Activate'),(39,'Activate existing key'),(38,'Activate free license'),(3073,'Activate free license & remove premium features.'),(45,'Activate free license description'),(1673,'Activate key'),(468,'Activate license key'),(2519,'Activate purchased skin'),(2296,'Activate your X-Cart'),(2294,'Activate your X-Cart installation'),(2295,'Activate your X-Cart installation first'),(32,'Activate your license key'),(469,'Activate your paid module license'),(470,'Active'),(471,'Active from'),(472,'Active till'),(473,'Add'),(3572,'Add PIN codes'),(474,'Add Product'),(4252,'Add a few [more products] to your catalog or proceed to the next step - whatever makes you happy.'),(3237,'Add addons'),(3238,'Add address'),(475,'Add alternative payment method'),(1919,'Add attribute'),(2706,'Add banner'),(476,'Add category'),(477,'Add child'),(2702,'Add comment here'),(2873,'Add countries'),(3346,'Add coupon'),(478,'Add discount'),(479,'Add featured products'),(2075,'Add featured products for \"X\"'),(3395,'Add featured products for the front page'),(480,'Add file'),(4222,'Add first product'),(481,'Add image'),(146,'Add language'),(482,'Add markup'),(483,'Add new'),(484,'Add new address'),(485,'Add new country'),(3339,'Add new coupon'),(4441,'Add new credit card'),(486,'Add new exception'),(145,'Add new label'),(149,'Add new language'),(487,'Add new membership level'),(488,'Add new option'),(489,'Add new option group'),(490,'Add new state'),(491,'Add offline payment method'),(4242,'Add other options'),(4206,'Add other products to compare'),(492,'Add payment method'),(3578,'Add pin codes'),(2841,'Add product'),(1975,'Add products'),(1653,'Add rates'),(3903,'Add related products'),(3782,'Add response'),(3700,'Add review'),(3111,'Add sales channel'),(493,'Add shipping method'),(1658,'Add state'),(1657,'Add states'),(4128,'Add status'),(494,'Add subcategory'),(2406,'Add to bag'),(51,'Add to cart'),(4209,'Add to compare'),(1197,'Add tracking number'),(495,'Add user'),(496,'Add your _products_'),(3720,'Add your own review'),(497,'Add zone'),(2425,'Add-on does not exist.'),(498,'Add-ons'),(499,'Add/update options'),(500,'Added'),(3345,'Added coupons'),(2949,'Added files'),(2207,'Added items'),(502,'Added to cart'),(3970,'Added to comparison table'),(3518,'Additional PayPal Business Account'),(3499,'Additional criteria to match for PayPal account verification'),(3432,'Additional settings'),(915,'Addons Marketplace'),(503,'Address'),(504,'Address book'),(505,'Address details'),(506,'Address field'),(507,'Address fields'),(4336,'Address for sales tax calculation'),(1852,'Address has been deleted'),(1847,'Address is not selected'),(4654,'Address line verification: X'),(3239,'Address masks'),(1848,'Address not found'),(508,'Address pattern'),(3240,'Address type'),(1846,'Address type has wrong value'),(4655,'Address zipcode verification: X'),(2573,'Address zone'),(4008,'Addresses'),(1784,'Addresses list is empty'),(4391,'Adds the sender’s signature and the date on CN22 and CP72 shipping labels. Enter the signature as a string. The Sender’s signature date is automatically populated.'),(509,'Admin'),(1333,'Admin has requested a change of password for your account. Please change the password before you proceed.'),(510,'Administration Zone'),(511,'Administrator'),(1545,'Administrator Zone'),(2440,'Administrator account cannot be deleted via customer interface.'),(2335,'Administrator header'),(4573,'Administrator notes'),(2336,'Administrator signature'),(2339,'Administrator subject'),(2340,'Administrator text'),(2417,'Advanced Order Management'),(4279,'Advanced shipping options'),(4284,'Advanced shipping settings'),(3406,'Advanced statistics with Google Analytics'),(2084,'After activation Skrill will give you access to a new section in your Skrill account called \"Merchant tools\". Please choose a secret word (do not use your password for this) and enter it into the merchant tools section and below.'),(1308,'After clicking this button, your hard/soft reset links will be regenerated. You need it in case old links were compromised.'),(1432,'After the problem has been fixed, try to connect again.'),(2762,'After the problem has been fixed, try to connect again.\', {\'clear_cache\': url(\'addons_list_marketplace'),(1517,'After the upgrade is completed please check your website. If you find that the site is inoperative, please try to do the following'),(1838,'Aggregation cache has been cleaned'),(3887,'Air service center'),(251,'All'),(684,'All Addresses (default zone)'),(369,'All Order Statuses'),(419,'All User Types'),(512,'All add-ons'),(2959,'All addons'),(2162,'All attributes'),(3681,'All classes from this category'),(4185,'All communication threads'),(1860,'All countries'),(513,'All customers'),(2763,'All items'),(2204,'All items cannot be removed from the order.'),(2139,'All levels'),(417,'All membership levels'),(514,'All memberships'),(3581,'All newest products'),(3917,'All news'),(2143,'All orders'),(2128,'All payment statuses'),(2686,'All payment transaction statuses'),(516,'All products on sale'),(1783,'All rights reserved.'),(517,'All shipping methods'),(2129,'All shipping statuses'),(518,'All shipping zones'),(770,'All states'),(2409,'All statuses'),(6,'All tags'),(515,'All the necessary adaptation will be done by the developer.'),(519,'All the products are in sufficient quantities'),(520,'All time'),(3582,'All upcoming products'),(2416,'All user types'),(3751,'All users'),(1789,'All words'),(4143,'Allow buyers to attach files to this product'),(4065,'Allow this product to be used as a MailChimp segment condition'),(4138,'Allowed file extensions: X'),(3684,'Alphabetical'),(523,'Alphabetically'),(1689,'Already added'),(1728,'Already exists'),(524,'Already have an account?'),(2678,'Also the system has detected problems with the following modules'),(2789,'Also, to manage your redirects you can define 301 redirects in .htaccess file.'),(3064,'Also, you can review X-Cart recommended hosting providers'),(112,'Alt'),(525,'Alternative payment methods'),(526,'Alternative text'),(299,'Alternatively, upload file sqldump.sql.php to the var/backup/ sub-directory click on the \"Restore from server\" button'),(2764,'Although you can switch the store to use the secure protocol for the website pages, most Internet browsers will likely display a warning message scaring your website visitors away.'),(2636,'Amazon'),(4725,'Amazon Order Ref ID'),(4695,'Amazon Seller ID'),(4724,'Amazon callback URL help'),(4723,'Amazon could not process the transaction due to an internal processing error.'),(4722,'Amazon has rejected the authorisation.'),(4707,'AmazonRefresh'),(4708,'AmazonRefundRefresh'),(527,'Amount'),(528,'Amount: high to low'),(529,'Amount: low to high'),(1871,'An attempt to update settings of unknown payment method'),(2362,'An error occurred while sending the request'),(2478,'An error occurred, please try again. If the problem persists, contact the administrator.'),(2479,'An error occurred, please try again. If the problem persists, contact the administrator. (txnNote)'),(1743,'An upgrade is a dangerous process that may result in a crashed website.'),(530,'An upgrade is a dangerous process that may result in a crashed website. It is strongly recommended to create a full back up of your shop (the code and the database) and download it to a local computer before proceeding to the next step.'),(1940,'Anonymous'),(2140,'Anonymous (access level)'),(222,'Anonymous Customer'),(223,'Anonymous Customer, _Registered User with the same email_'),(2030,'Anonymous Customers'),(3766,'Anonymous reviewer'),(3616,'Anonymous users only'),(3241,'Another bulk change in progress, please try again later'),(531,'Another state'),(134,'Any availability status'),(424,'Any category'),(137,'Any class'),(532,'Any membership level'),(533,'Any product class'),(2555,'Any profile'),(3695,'Any rating'),(3990,'Any special needs?'),(425,'Any status'),(2187,'Any stock status'),(3615,'Any visitors'),(1790,'Any word'),(534,'Any zone'),(3973,'Anyland'),(3974,'Anytown'),(2629,'App type'),(535,'Appearance'),(3312,'Applied discount coupon'),(3095,'Apply attribute value changes for all the products'),(536,'Apply destination'),(537,'Apply price'),(3660,'Apply sort and view settings for all products'),(2942,'Apply sorting globally'),(3242,'Apply to billing address'),(3093,'Apply unsharp mask filter on resize'),(1762,'Apply value changes globally'),(1761,'Apply value changes locally'),(3711,'Approve'),(3702,'Approve review'),(4691,'Approved URL'),(538,'Are you sure you want to continue?'),(539,'Are you sure you want to delete the selected user?'),(2653,'Are you sure you want to delete this filter?'),(1686,'Are you sure you want to delete this profile?'),(540,'Are you sure you want to disable this add-on?'),(2842,'Are you sure you want to enable https anyway?'),(541,'Are you sure you want to enable this add-on?'),(4591,'Are you sure you want to transmit this shipment?'),(2404,'Are you sure you want to uninstall selected add-ons?'),(542,'Are you sure you want to uninstall this add-on?'),(4589,'Are you sure you want to void this shipment?'),(543,'Are you sure you wish to delete the selected zones?'),(544,'Are you sure?'),(545,'Arrival date'),(547,'Ask.com'),(2460,'Assign entered Clean URL to this page anyway'),(548,'Assigned classes'),(546,'Asynchronous'),(4155,'Attach file'),(4141,'Attach files'),(4540,'Attached files'),(4139,'Attached files:'),(4150,'Attachment X is deleted'),(3403,'Attachment has been deleted successfully'),(549,'Attachment is not deleted'),(3359,'Attachment removed'),(550,'Attachments'),(551,'Attachments have been updated successfully'),(3061,'Attention!'),(3161,'Attention! You are creating an account with full access. Roles warning'),(1589,'Attribute'),(28,'Attribute data will be lost. warning text'),(1588,'Attribute group'),(1585,'Attribute name'),(1580,'Attribute option'),(3132,'Attribute value ID'),(1586,'Attribute values'),(3133,'Attribute values (select)'),(140,'Attributes'),(773,'Attributes block'),(339,'Attributes for X product class'),(1850,'Attributes have been successfully changed'),(1900,'Attributes have been updated successfully'),(1915,'Attributes imported'),(552,'Australia Post settings'),(2109,'Auth'),(3433,'Auth and Capture'),(3434,'Auth only'),(553,'Authentication'),(554,'Authentication code'),(4615,'Authentication options'),(555,'Author'),(2064,'Authorization and Capture'),(2065,'Authorization only'),(4490,'Authorization period, days'),(4709,'Authorization status: {{status}}'),(556,'Authorization then capture'),(4488,'Authorize amount for card setup'),(4458,'Authorize/charge the difference'),(4738,'AuthorizeNet accept.js instruction text'),(2723,'Authorize[TT]'),(371,'Authorized'),(1839,'Authorized amount'),(557,'Auto'),(4057,'Auto-Updated'),(2765,'Autogenerate'),(1687,'Autogenerate Clean URL'),(2082,'Autogenerated'),(2645,'Automate Shipping Refunds'),(2622,'Automate shipping'),(2624,'Automate your shipping process with the services of our partners: print shipping labels, grab shipping orders info from eBay, ETSY, Amazon and other marketplaces; integrate with several shipping carriers in one spot and more.'),(3575,'Automatically'),(558,'Availability'),(3381,'Available after purchase'),(3366,'Available for download'),(559,'Available for sale'),(2552,'Avalara, a leader in US sales tax automation, provides a solution that can make your life easier by providing accurate and up-to-date tax rates for products you sell.'),(3727,'Average rating'),(2905,'Awaiting processing'),(560,'B'),(267,'BEGIN - END of TOTAL'),(1827,'Back'),(1794,'Back to Login form'),(2683,'Back to Trial mode'),(3853,'Back to Webmaster mode'),(772,'Back to Zones list'),(4446,'Back to credit cards'),(561,'Back to file select'),(562,'Back to layout settings'),(563,'Back to methods'),(1795,'Back to modules'),(3858,'Back to notification settings'),(2343,'Back to notifications list'),(564,'Back to order list'),(3737,'Back to product details'),(4023,'Back to products'),(4081,'Back to segments list'),(2599,'Back to shipping methods'),(3800,'Back to templates list'),(325,'Backend payment transaction X issued'),(2766,'Background export is in progress'),(565,'Backup'),(566,'Backup database'),(2042,'Backup your store with Backup Master'),(567,'Bank Account Number'),(926,'Bank name'),(3464,'Banner on Cart page'),(3462,'Banner on Category pages'),(3461,'Banner on Home page'),(3463,'Banner on Product details pages'),(2705,'Banner rotation'),(3729,'Based on'),(3750,'Be the first and leave a feedback.'),(1622,'Before editing attributes specific for the chosen type you should save the changes'),(2545,'Before enabling HTTPS protocol read this article:'),(2292,'Before installing a paid addon for this installation, you need to activate your X-Cart license.'),(4309,'Before you can start configure Australia Post module you should update available options from Australia Post. Please click button below.'),(568,'Benchmark completed in '),(569,'Benchmark result under 3000ms is considered good'),(570,'Bestsellers'),(2662,'Bill to'),(2877,'Billing'),(571,'Billing address'),(2095,'Billing address is not defined'),(572,'Billing address is not defined yet'),(1830,'Billing address is the same as Shipping'),(2881,'Billing to'),(573,'Bing'),(4281,'Bingo! You\'ve added carrier as a shipping carrier'),(3391,'Block'),(3827,'Block is disabled'),(3826,'Block is enabled'),(2073,'Blocked'),(3365,'Blocked by administrator'),(2870,'Body'),(4557,'Box maximum weight'),(574,'Brief description'),(575,'Brief descrption'),(3655,'Brief info'),(3661,'Brief info help'),(576,'Browse server'),(4021,'Bulk Edit processing in progress...'),(4013,'Bulk edit'),(4015,'Bulk edit all'),(4018,'Bulk edit has been processed successfully.'),(4019,'Bulk edit processing has been interrupted.'),(4020,'Bulk edit processing may take a while to complete. Please do not close this page until the process is fully completed.'),(4024,'Bulk edit selected'),(3243,'Business premium features'),(2217,'Buy'),(2494,'Buy Business Edition'),(577,'Buy more'),(2449,'Buy prolongation'),(1804,'C.O.D. fee included'),(578,'CLOSE'),(2010,'CM'),(4378,'COD value'),(579,'CSS & JavaScript'),(2394,'CSV delimiter'),(2168,'CSV file has the wrong filename format.'),(3057,'CSV format tables'),(1990,'CSV or ZIP files, total max size: {{size}}'),(4653,'CVC verification: X'),(3244,'CVV / CVC'),(1815,'CVV2'),(2480,'Cache management'),(580,'Cache rebuild is already started, please wait'),(2483,'Calculate quick data'),(2484,'Calculate quick data help text'),(581,'Calculate rates'),(2486,'Calculating quick data...'),(448,'California'),(1817,'Call us: '),(4726,'Callback URL'),(3367,'Can be downloaded only after buying the product'),(2560,'Can be provided only for offline shipping methods.'),(2562,'Can be provided only for online shipping methods.'),(3444,'Can be set up later'),(3556,'Can not be disabled for products with manually defined PIN codes'),(582,'Can\'t be disabled. The module is required by:'),(583,'Can\'t connect to the Addons Marketplace server'),(2037,'Can\'t connect to the marketplace server'),(3989,'Can\'t subscribe you right now. Try later'),(4530,'Canada Post module allows to use online shipping rates calculation via Canada Post'),(4568,'Canada Post settings'),(4598,'CanadaPost settings'),(161,'Cancel'),(4417,'Cancel import and keep current payment methods'),(3601,'Cancel sale'),(3604,'Cancel sale for all'),(373,'Canceled'),(2693,'Canceled[S]'),(2975,'Canceling'),(4147,'Cannot attach the file. The maximum attached file size may not exceed X MB'),(4146,'Cannot attach the file. The number of attached files may not exceed X'),(4100,'Cannot authenticate'),(1906,'Cannot autogenerate clean URL for the product name \"{{name}}\". Please specify it manually.'),(2947,'Cannot check the files for this module'),(2201,'Cannot create temporary order for modification'),(2348,'Cannot gather modules from the marketplace. Please try later.'),(3851,'Cannot get flexy content'),(3558,'Cannot remove a sold PIN code'),(304,'Cannot set X permissions for subdirectories:'),(2110,'Capture'),(4703,'Capture mode'),(2727,'Capture multiple[TT]'),(2726,'Capture partially[TT]'),(584,'Capture status'),(2725,'Capture[TT]'),(1840,'Captured amount'),(4581,'Card (hold) for pick up'),(2308,'Card number'),(4482,'Card saved'),(2305,'Card type'),(4483,'Card was not saved due to payment processor error'),(1810,'Cardholder name'),(4463,'Cards saved by the customer for the future orders in this shop. No real credit cards were saved, only special token on the side of the payment processor, that can be used in this store only.'),(4406,'Cards which can be used for your future orders in this shop. No real credit cards were saved, only special token on the side of the payment processor, that can be used in this store only.'),(1188,'Carrier'),(2596,'Carrier service'),(2597,'Carrier service name'),(2595,'Carrier services'),(2564,'Carrier-calculated rates'),(1825,'Cart'),(585,'Cart & checkout'),(2184,'Cart contains products with wrong quantity'),(2183,'Cart contains products with wrong quantity. Please correct this to proceed'),(232,'Cart is empty'),(2078,'Cash on delivery'),(586,'Catalog'),(587,'Categories'),(4219,'Categories and tags'),(1916,'Categories imported'),(2984,'Categories processed'),(2987,'Categories processed: X out of Y'),(2986,'Categories processed: X out of Y with errors'),(2988,'Categories processed: {{count}}'),(588,'Category'),(3881,'Category description'),(102,'Category icon'),(3054,'Category id or path is required'),(589,'Category info'),(590,'Category name'),(591,'Category name contains invalid symbols'),(2761,'Category name should not be empty'),(592,'Category page title'),(593,'Category path contains invalid symbols'),(3056,'Category with id X not found, new category will be created'),(594,'Change'),(595,'Change address'),(1816,'Change attributes'),(3159,'Change fulfillment status for selected'),(596,'Change method'),(597,'Change options'),(1434,'Change password'),(598,'Change payment info'),(3158,'Change payment status for selected'),(600,'Change shipping'),(599,'Change shipping info'),(3245,'Change template'),(2205,'Changed items'),(2206,'Changed options'),(3818,'Changes may be incompatible with TinyMCE. Are you sure to proceed?'),(1759,'Changes of attributes globally'),(1760,'Changes of attributes locally'),(2219,'Character set'),(4491,'Charged amount'),(1741,'Check again'),(601,'Check all'),(3849,'Check directory permissions'),(2535,'Check for available free disk space has failed'),(2843,'Check for updates'),(602,'Check number'),(4005,'Check shipping info'),(3188,'Check the article how to check your emails'),(4481,'Check the settings.'),(3190,'Check your email deliverability'),(603,'Checking'),(604,'Checking integrity, please wait...'),(236,'Checkout'),(3992,'Checkout type'),(605,'Choose'),(606,'Choose _payment methods_'),(2521,'Choose a new template'),(4006,'Choose another address'),(2307,'Choose card type'),(3683,'Choose classes...'),(607,'Choose file'),(608,'Choose from a variety of bundled payment solutions to accept credit cards and other methods of payment on your website'),(609,'Choose method'),(2883,'Choose shipping'),(610,'Choose shipping method'),(1797,'Choose the product options first'),(2493,'Choose the right plan'),(3947,'Choose your location'),(1633,'Choosing \"URLs\" will link the exported data to your public files (product and category images, downloadable files shown on product pages, and so on) through direct URLs'),(2306,'Chose credit card type'),(611,'City'),(1446,'City masks'),(2163,'Classes & Attributes'),(1867,'Classes & attributes'),(3680,'Classes for product filter'),(612,'Clean URL'),(2768,'Clean URLs'),(665,'Clean URLs are disabled'),(663,'Clean URLs are disabled. More info'),(2767,'Clean URLs are disabled. More info\', {\'more_info_url\': url(\'settings\', \''),(664,'Clean URLs are enabled'),(667,'Clean URLs functionality may not be enabled. More info'),(617,'Clean aggregation cache'),(72,'Clean aggregation cache help text'),(618,'Clean widgets cache'),(73,'Clean widgets cache help text'),(619,'CleanURL'),(616,'Clean_urls_error_message'),(1541,'Cleanup'),(1538,'Cleanup queries'),(2901,'Clear all caches'),(2902,'Clear all caches text'),(1801,'Clear all fields'),(620,'Clear bag'),(3246,'Clear cache help text'),(56,'Clear cart'),(4207,'Clear list'),(132,'Clear search'),(4666,'Click Connect with Stripe to be redirected to Stripe.com'),(621,'Click here to access/add subcategories'),(4337,'Click here to specify tax rates that will apply only to shipping charges'),(4244,'Click here to upload product image'),(4256,'Click here to upload your logo. Recommended 400x150px (PNG, JPG or SVG)'),(622,'Click here to view states of country'),(1613,'Click if you do not want to add this value to new products or class’s assigns automatically'),(1614,'Click if you want to add this value to new products or class’s assigns automatically'),(4063,'Click rate'),(4411,'Click the button below to re-import payment methods from X-Payments.'),(2218,'Click the link to increase product amount'),(3519,'Click this to access the PayPal sign-in page and sign in using your PayPal account different from the account specified above.'),(1652,'Click to add rates'),(1656,'Click to add states'),(1720,'Click to close'),(3405,'Click to edit'),(1659,'Click to edit all this label translations'),(1651,'Click to edit rates'),(1655,'Click to edit states'),(3088,'Click to expand menu'),(4002,'Click to finish your order'),(1719,'Click to open'),(4004,'Click to proceed to the next step'),(4014,'Click to specify'),(623,'Click to unblock'),(201,'Clicking the Place order button you accept: Terms and Conditions'),(4700,'Client ID'),(1572,'Clone'),(2967,'Clone selected'),(1571,'Clone this product'),(141,'Cloned products'),(380,'Close'),(4180,'Close dispute'),(624,'Close storefront'),(4229,'Close wizard'),(1948,'Closed'),(2630,'Cloud Service'),(2631,'Cloud Zoom'),(2632,'Cloud Zoom mode'),(2633,'Cloud Zoom mode Inside'),(2634,'Cloud Zoom mode Outside'),(4124,'CloudSearch sets default sort order to relevance'),(625,'Code'),(3521,'Color'),(2909,'Column X is required'),(3583,'Coming soon'),(2390,'Coming soon (title)'),(3594,'Coming soon...'),(1712,'Comma'),(626,'Comment'),(627,'Comments'),(2006,'Commercial'),(4580,'Commercial - will return the contracted price between Canada Post and the contract holder'),(4616,'Common options'),(1204,'Common tax settings'),(2132,'Communication log'),(3508,'Communication problem'),(4187,'Communication threads with open disputes'),(4186,'Communication threads with unread messages'),(1934,'Compact view'),(628,'Company'),(629,'Company name'),(2094,'Compare'),(1818,'Compare products'),(1547,'Compare your result with other servers'),(4205,'Comparison table - X items'),(1731,'Complete'),(1831,'Complete billing address'),(630,'Completed'),(631,'Component'),(4479,'Conection with X-Payments is OK.'),(3002,'Config file'),(632,'Configuration'),(4431,'Configuration has been successfully deployed'),(1647,'Configure'),(3879,'Configure Tag Manager'),(633,'Configure _shipping methods_'),(4614,'Configure manually'),(3407,'Configure the Google Analytics module to view the advanced statistics'),(3390,'Configure your X-Cart installation to support large file downloads.'),(4473,'Configure your gateway'),(4262,'Configure your geographic settings to connect with local customers'),(634,'Configure your store'),(4503,'Configuring of the payment methods presented possible in the X-Payments backoffice only. In case of any problems you need to review the X-Payments Connector module settings and if it\'s ok, review payment configurations settings on the X-Payments side.'),(158,'Confirm deletion'),(635,'Confirm password'),(2500,'Confirmation'),(1729,'Confirmation does not match'),(180,'Congratulations! Your order has been placed successfully'),(4474,'Connect'),(3512,'Connect to PayPal'),(4476,'Connect to X-Payments. Do 3 easy steps.'),(4093,'Connect with your MailChimp account'),(3978,'Connect your store to MailChimp'),(3510,'Connected to PayPal; Merchant ID: {{merchantId}}'),(4478,'Connected!'),(2790,'Connecting to the marketplace...'),(4466,'Connection'),(4480,'Connection failed!'),(4495,'Connection with X-Payments is OK.'),(3128,'Consistency check'),(3137,'Consistency has not yet been checked. Initiate an consistency check by clicking the button \"Refresh consistency status\".'),(4335,'Contact Skrill at newbusiness@paysafe.com'),(3162,'Contact Us page settings'),(4617,'Contact name for the manifest address'),(4295,'Contact our expert'),(4170,'Contact seller'),(3605,'Contact us'),(3074,'Contact us if you have any questions.'),(31,'Contact us trial notice'),(3389,'Contact your hosting provider to make sure X-Sendfile is installed on the server.'),(636,'Contacts'),(637,'Content'),(4033,'Content has script tags (Froala)'),(3624,'Content page title'),(638,'Continue'),(1832,'Continue as guest'),(57,'Continue shopping'),(70,'Continue...'),(4618,'Contract ID'),(4619,'Contract shipping options'),(4395,'Convenience - Verify addresses and buy & print compliant USPS labels directly from the X-Cart application'),(4197,'Conversation'),(4199,'Conversation: X'),(4198,'Conversations'),(2710,'Convert failed transactions into real orders'),(3844,'Convert templates'),(113,'Copy'),(4659,'Copy Webhook URL and go to Account settings'),(639,'Copy file to local server'),(4422,'Copy the value of the Configuration field from X-Payments Online Store Details page, paste the string here and click Deploy. All the connection settings will be specified automatically.'),(114,'Copy to clipboard'),(111,'Copy to file system'),(1699,'Core version'),(640,'Core version: '),(3634,'Could not add the discount because another discount already exists for the specified subtotal range and membership level'),(3553,'Could not assign X PIN codes to order #Y.'),(2475,'Could not assign upgrade access level to your license keys'),(4304,'Could not save logo image'),(3635,'Could not update the discount because another discount already exists for the specified subtotal range and membership level'),(2847,'Couldn\'t download the banner {{value}} from URL'),(2712,'Couldn\'t download the image {{value}} from URL'),(2049,'Couldn\'t move X images. See log for details.'),(2048,'Couldn\'t move image X'),(1536,'Count'),(4579,'Counter - will return the regular price paid by retail consumers'),(641,'Countries'),(2316,'Countries information has been successfully updated'),(642,'Countries, states and zones'),(643,'Country'),(644,'Country is not selected'),(4702,'Country of Merchant account'),(3341,'Coupon'),(3349,'Coupon cannot be combined with other coupons'),(645,'Coupon code'),(3319,'Coupon discount'),(3337,'Coupon discount can be limited to customers with these membership levels'),(3336,'Coupon discount can be limited to these product classes'),(646,'Coupons'),(4620,'Coverage'),(647,'Create'),(649,'Create SQL file'),(650,'Create a backup'),(651,'Create account'),(652,'Create an account for later use'),(653,'Create category'),(2433,'Create label'),(654,'Create new account'),(1987,'Create new items and update existing items'),(3922,'Create news message'),(648,'Create profile'),(4534,'Create return'),(4392,'Create shipment'),(4280,'Create shipping rate'),(1319,'Create zone'),(655,'Created'),(4541,'Created on'),(4426,'Credit card'),(1811,'Credit card number'),(2315,'Credit card security code (if present)'),(3538,'Credit or debit card (Visa, MasterCard, American Express, Discover, and so on)'),(3247,'Critical'),(1985,'Critical error'),(1520,'Critical errors have been detected in the files you are trying to import. Check the manual to correct the errors and try again.'),(1707,'Curl options'),(1706,'Curl version'),(656,'Currency'),(4621,'Currency rate'),(2998,'Current password'),(2200,'Current price for the selected configuration and quantity: X'),(2514,'Current template'),(2083,'Custom'),(658,'Custom CSS'),(3106,'Custom CSS & JS'),(100,'Custom HTML title'),(659,'Custom JavaScript'),(657,'Custom addons'),(1995,'Custom attributes'),(660,'Custom images'),(1923,'Custom offline shipping'),(2565,'Custom table rates'),(661,'Custom translation'),(221,'Customer'),(2138,'Customer access level'),(3888,'Customer counter'),(3230,'Customer email (if exist)'),(2333,'Customer header'),(2202,'Customer information'),(3713,'Customer name'),(220,'Customer note'),(4622,'Customer number'),(3738,'Customer reviews'),(2334,'Customer signature'),(2337,'Customer subject'),(2338,'Customer text'),(662,'Customer zip/postal code'),(1549,'Customer zone is closed for maintenance.'),(4151,'Customer`s attachments were changed'),(1912,'Customers'),(1913,'Customers imported'),(3584,'Customers who bought this product also bought'),(3585,'Customers who viewed this product bought'),(3520,'Customize the PayPal button'),(4260,'Customize your store with Layout Editor option'),(399,'DECEMBER'),(2637,'DHL'),(2011,'DM'),(3889,'Daily Pickup'),(3293,'Dashboard'),(1521,'Data has not been found'),(669,'Data have been deleted successfully'),(670,'Data have been saved successfully'),(3248,'Data removal has been completed successfully.'),(3249,'Data removal has been stopped.'),(3250,'Database'),(671,'Database backup created successfully'),(1888,'Database restored successfully!'),(672,'Date'),(3251,'Date and time in the shop'),(3164,'Date and time in the store'),(3163,'Date and time on the server'),(1800,'Date range'),(411,'Date range should less than %d days'),(410,'Date range should longer than %d days'),(3332,'Date when customers can start using the coupon'),(3333,'Date when the coupon expires'),(4451,'Date, time'),(3586,'Date: newest first'),(3587,'Date: oldest first'),(673,'Day'),(379,'Days'),(674,'Dear'),(317,'Dear X'),(675,'Dear customer'),(676,'Decline'),(2736,'Decline[TT]'),(677,'Declined'),(4692,'Declined URL'),(4492,'Declined amount'),(678,'Default'),(679,'Default customer address'),(1921,'Default for admins'),(680,'Default for customer zone and can not disabled or deleted'),(681,'Default for customer zone and cannot be disabled or deleted'),(1920,'Default for customers'),(2687,'Default image settings'),(682,'Default images settings'),(1582,'Default option'),(2781,'Default site meta description'),(2782,'Default site meta keywords'),(2780,'Default site title'),(138,'Default tax class'),(1623,'Default value'),(437,'Default zone tooltip text'),(1104,'Default-sort-option'),(685,'Define classes'),(3533,'Delayed'),(160,'Delete'),(4249,'Delete Demo products'),(169,'Delete Language'),(686,'Delete SQL file'),(2439,'Delete account'),(687,'Delete all'),(1621,'Delete all files'),(4140,'Delete attachment'),(2652,'Delete filter option'),(69,'Delete item'),(688,'Delete profile'),(689,'Delete selected'),(690,'Delete selected profile'),(1524,'Delete temporary files after the import is completed'),(691,'Delete the image'),(692,'Delete this address?'),(4535,'Deliver to Post Office'),(4623,'Deliver to Post Office options'),(60,'Delivery'),(3890,'Delivery confirmation - adult signature required'),(3891,'Delivery confirmation - no signature'),(3892,'Delivery confirmation - signature required'),(4371,'Delivery cost'),(4398,'Delivery date'),(4007,'Delivery method'),(693,'Delivery methods'),(2557,'Delivery time'),(4538,'Delivery to Post Office'),(281,'Depending on the size of your data file, importing may take some time.'),(2113,'Deploy'),(52,'Description'),(4489,'Description of the card setup payment'),(4255,'Design your online store to fit your brand'),(2057,'Destination address'),(694,'Destination zone'),(695,'Details'),(3252,'Developer'),(4299,'Developer docs'),(4624,'Developer mode'),(2972,'Developer wave'),(2380,'Developers docs'),(4493,'Difference'),(4208,'Differences only'),(3294,'Dimensions'),(4558,'Dimensions (cm)'),(696,'Directories and files permissions'),(360,'Directory X does not have permissions to write. Please set necessary permissions to directory X.'),(4613,'Directory X is not writable'),(1918,'Directory does not have permissions to write'),(1711,'Directory is empty'),(165,'Disable'),(3253,'Disable HTTPS'),(2966,'Disable all'),(697,'Disable all modules in the system'),(3907,'Disable mutual links'),(2964,'Disable selected'),(698,'Disable suspicious modules'),(699,'Disabled'),(3010,'Disabled functions'),(1616,'Disabled in catalog'),(168,'Disabled language can not be set as default for customer zone'),(1905,'Disabled language cannot be default.'),(700,'Disabled language cannot be set as default for customer zone'),(2121,'Disabled modules hooks message body'),(2120,'Disabled modules hooks message head'),(2960,'Disabled only'),(793,'Disables all addons except ones that are provided by X-Cart Team & Qualiteam (soft reset)'),(792,'Disables all addons except ones that are provided by X-Cart Team (hard reset)'),(1208,'Disables all modules except ones that were downloaded from marketplace (soft reset)'),(3822,'Discard changes'),(4664,'Disconnect'),(701,'Discount'),(702,'Discount amount'),(703,'Discount type'),(4338,'Discounted subtotal'),(4339,'Discounted subtotal + Shipping cost'),(3103,'Discounts'),(704,'Display \'inc/ex VAT\' labels next to prices'),(3882,'Display all templates'),(1206,'Display common settings'),(3454,'Display the \"Buy Now with PayPal\" button'),(705,'Display type'),(1929,'Displays the number of labels translated to the language'),(4191,'Dispute'),(4178,'Dispute closed by X'),(4188,'Dispute is open X by Y'),(4177,'Dispute opened by X'),(4196,'Disputes'),(706,'Do not close this page!'),(1748,'Do not replace selected files and ignore their newer versions'),(4583,'Do not safe drop'),(2146,'Do not see your payment method? Find it on our Marketplace'),(2791,'Do not see your payment method? Find it on our Marketplace\', {\'url\': url(\'addons_list_marketplace\', \'\', {\'tag\': \'Payment processing'),(2186,'Do not select anything if you want to make the product visible to all customers.'),(707,'Do not show at startup anymore'),(3682,'Do not show the filter'),(4485,'Do not use card setup'),(1523,'Do not verify images to increase speed of the process'),(4331,'Do you have questions?'),(4269,'Do you need to ship your products?'),(2614,'Do you really want to close storefront?'),(3908,'Do you really want to delete all relations from this product?'),(708,'Do you really want to delete selected items?'),(3050,'DocBlocks support'),(4559,'Document'),(4542,'Documents'),(2671,'Does not match license type (requires {{list}} edition)'),(3475,'Don\'t have account yet?'),(4648,'Don\'t have account yet? Sign up for SagePay now!'),(4674,'Don\'t have an account?'),(4324,'Don\'t have an account? Sign up for free'),(3596,'Don\'t label'),(4251,'Done! We ve just deleted all your demo products'),(709,'Dont have account yet?'),(4320,'Dont have an account? Sign Up Now'),(2041,'Don’t forget to create a backup!'),(1721,'Double quote'),(3254,'Download'),(1991,'Download CSV files'),(710,'Download SQL file'),(1634,'Download all files in a single archive'),(2721,'Download error file'),(3371,'Download link did not found'),(3369,'Download link is blocked'),(3372,'Download link is not active'),(3373,'Download link is renew'),(3370,'Download links is blocked'),(3374,'Download links is renew'),(711,'Downloaded components'),(712,'Downloading updates'),(713,'Downloading updates, please wait...'),(3362,'Downloads left'),(714,'Drag and drop me to the bag'),(3866,'Drag-n-drop blocks'),(1522,'Drop existing items before import'),(715,'Drop items here to shop'),(716,'Drupal frontend'),(338,'Duplicated clean URL: X'),(286,'During the import was recorded X errors. You can get them by downloading the log files.'),(4089,'E-Commerce features setup'),(1819,'E-Mail'),(3441,'E-Mail address to receive PayPal payment'),(3376,'E-goods'),(717,'E-mail'),(718,'E-mail is not defined yet'),(2889,'E-mail will also be updated in all the related orders.'),(3492,'EACHRECEIVER'),(3539,'ELV/SEPA'),(2638,'ETSY'),(4396,'Easy payment options - Ship Now Pay Later with a Pitney Bowes Line of Credit or use a credit card.'),(1654,'Edit'),(3657,'Edit Globally'),(3996,'Edit address'),(3910,'Edit all'),(1690,'Edit attribute'),(1612,'Edit attribute values'),(1555,'Edit attributes'),(4010,'Edit billing address'),(719,'Edit charges for:'),(2517,'Edit custom options'),(3997,'Edit email'),(170,'Edit label'),(171,'Edit labels'),(427,'Edit labels (X)'),(721,'Edit page'),(720,'Edit payment method data'),(1649,'Edit product'),(722,'Edit profile'),(443,'Edit rates (X)'),(3701,'Edit review'),(4011,'Edit shipping address'),(432,'Edit states (X)'),(365,'Edit subcategories (X)'),(3859,'Edit template based on'),(3855,'Edit via Webmaster mode'),(3719,'Edit your review'),(3797,'Edited templates'),(327,'Editing attribute groups on this page won\'t affect other product classes which use these groups'),(3379,'Egoods free'),(3378,'Egoods paid'),(723,'Email'),(724,'Email &amp; password'),(3300,'Email Address'),(239,'Email address'),(4326,'Email address of your Skrill account'),(2032,'Email again'),(725,'Email body'),(3229,'Email from the contact information section according to the type of email message'),(2329,'Email notifications'),(3982,'Email or login'),(726,'Email settings'),(3179,'Email transfer settings'),(2038,'Empty \"class\" parameter is passed to the {{method}}'),(166,'Enable'),(4625,'Enable \"Deliver to Post Office\" feature'),(727,'Enable HTTPS'),(2965,'Enable all'),(613,'Enable clean URL'),(666,'Enable clean URLs'),(3255,'Enable module'),(3906,'Enable mutual links'),(2963,'Enable selected'),(4690,'Enable the Use Enhanced Cancel option.'),(2458,'Enable the option \"Assign entered Clean URL to this page anyway\" to dissociate the entered Clean URL from the page it is currently used for and assign it to the page of the object being edited.'),(2878,'Enable this if you would like us to use your shipping address as your billing address'),(728,'Enabled'),(2331,'Enabled for administrator'),(2332,'Enabled for customer'),(1615,'Enabled in catalog'),(2961,'Enabled only'),(3862,'Enter Order number'),(4586,'Enter Return # or Order #'),(733,'Enter X more characters to start search'),(204,'Enter a correct email'),(2457,'Enter a different Clean URL value for this page'),(2851,'Enter a keyword to search.'),(3785,'Enter a name to be published with the review'),(209,'Enter a negative number'),(206,'Enter a number'),(208,'Enter a positive number'),(205,'Enter an integer'),(3340,'Enter code'),(729,'Enter coupon code'),(370,'Enter date range'),(3423,'Enter description of the purchase that will be displayed on PayPal payment page.'),(3983,'Enter email address'),(4133,'Enter file extensions separated by comma; for example, \"jpg,txt,svg\"'),(2651,'Enter filter name'),(416,'Enter keyword'),(730,'Enter keywords'),(731,'Enter license key'),(1968,'Enter pattern here'),(4243,'Enter product name'),(2792,'Enter product name or SKU'),(1971,'Enter search pattern'),(732,'Enter shipping address'),(3422,'Enter the email address associated with your PayPal account.'),(1803,'Enter the shipping address to see delivery methods available to you'),(4096,'Enter your MailChimp API key manually'),(1833,'Enter your e-mail'),(40,'Enter your license key here'),(3072,'Enter your premium license key'),(3834,'Entity was successfully saved'),(734,'Environment'),(735,'Environment info'),(736,'Error'),(614,'Error code explanation:'),(4436,'Error had occured during the requesting of payment methods from X-Payments. See log files for details.'),(2848,'Error of banner loading. Make sure the \"images\" directory has write permissions.'),(2263,'Error of image loading. Make sure the \"images\" directory has write permissions.'),(2713,'Error of image verification ({{value}}). Make sure you have specified the correct image file or URL.'),(1884,'Error of uploading file.'),(3835,'Error on saving image'),(3256,'Error sending link'),(2719,'Errors'),(2952,'Errors files'),(4399,'Estimate delivery date'),(737,'Estimate shipping cost'),(738,'Estimate your server performance'),(739,'Estimated for'),(46,'Evaluation notice'),(2788,'Every object stores history with 8 clean urls which were previously used for this object.'),(740,'Everything you need'),(4264,'Ex.'),(1788,'Exact phrase'),(741,'Example'),(447,'Example city'),(742,'Examples'),(4292,'Excellent! Now you can get paid'),(743,'Exception'),(3938,'Exclude from shipping cost calculation'),(2554,'Existing Avalara user?'),(1805,'Existing Customer?'),(3828,'Exit editor'),(3815,'Exit product preview'),(2448,'Exp. date'),(744,'Expand the functionality of your store by installing and using add-on modules'),(1935,'Expanded view'),(3593,'Expected on'),(1813,'Expiration date'),(374,'Expired'),(3363,'Expired by TTL'),(3361,'Expired by limit'),(3364,'Expires in'),(745,'Export'),(2793,'Export all'),(1641,'Export cannot be started because it is disabled or there is another running export process'),(1635,'Export completed'),(1639,'Export failed'),(1642,'Export in CSV'),(1640,'Export not started'),(4161,'Export of Not Finished orders is not supported. To export the orders which are now in this state, change their fulfillment status from Not Finished to any other.'),(2618,'Export orders'),(2160,'Export product data with'),(746,'Export products'),(1630,'Export public files as'),(2794,'Export selected'),(1629,'Export settings'),(359,'Exported in X'),(1636,'Exporting data...'),(3541,'Express Checkout process stopped.'),(747,'Extensions'),(389,'FEBRUARY'),(385,'FR'),(3927,'FREE'),(3929,'FREE SHIPPING'),(2523,'FREE quote'),(2627,'FREE trial'),(748,'Facebook'),(749,'Failed'),(750,'Failed to add detailed image'),(751,'Failed to add the attachment'),(752,'Failed to add the attachment. The file download is forbidden'),(2265,'Failed to load the banner {{value}} because it does not exist'),(2264,'Failed to load the file {{value}} because it does not exist'),(3402,'Failed to re-upload attachment'),(1896,'Failed to update category image'),(3610,'Failed to update page image'),(1917,'Failed write to file'),(361,'Failed write to file X. There may not be enough disc-space. Please check if there is enough disc-space.'),(753,'Failed/Declined'),(2692,'Failed[S]'),(1742,'Failure'),(1809,'Failure reason:'),(3861,'Failure sending test email to X'),(3852,'Failure to convert flexy-template. Check for syntax errors'),(4626,'Failure to finish registration process.'),(4627,'Failure to get token ID.'),(1600,'Failure: File has the wrong format.'),(3991,'Fast Lane checkout'),(3607,'Favicon'),(1676,'Fax'),(3396,'Featured'),(754,'Featured products'),(2639,'FedEx'),(3397,'FedEx module allows to use online shipping rates calculation via FedEx.'),(3542,'Fees payer'),(755,'Field is required!'),(4152,'File Attaching is mandatory for this product'),(4148,'File attachments are not allowed for this product'),(2742,'File can not be uploaded'),(3404,'File description'),(3386,'File is available by public URL'),(2431,'File is not an image'),(2432,'File is not uploaded'),(1876,'File not found'),(3026,'File permissions'),(306,'File size exceeds the maximum size'),(756,'File title'),(3257,'File uploading'),(3165,'File uploading error 1'),(3166,'File uploading error 2'),(3167,'File uploading error 3'),(3168,'File uploading error 4'),(3169,'File uploading error 6'),(3170,'File uploading error 7'),(3171,'File uploading error 8'),(3016,'File uploads'),(4149,'File uploads forbidden by web server'),(2795,'File was successfully uploaded'),(4529,'File with certificate should be located in the directory {{certsDir}}'),(2605,'Files cannot be updated'),(4667,'Fill out the form with your Company info to setup your account and start processing payments immedately'),(4050,'Filter by order amount'),(4048,'Filter by order frequency'),(4052,'Filter by profile membership'),(4053,'Filter by specific products'),(2655,'Filter has been removed'),(2654,'Filter has been successfully saved'),(2492,'Filter transactions by status'),(4120,'Filters'),(1969,'Find countries'),(2147,'Find in Marketplace'),(1292,'Find language in marketplace'),(1970,'Find states'),(2490,'Find transactions by ID'),(757,'Find us on'),(758,'Find us on Facebook'),(3258,'Finish'),(2551,'Finished operating as user'),(759,'First name'),(4080,'First name or last name are empty. Please add a new address to your address book or modify existing and fill in those fields in order to subscribe to this list.'),(3784,'First name, Last name or E-mail'),(2892,'First, restore your website from the created backup - this is the fastest way to get your store back online.'),(3993,'Firstname'),(760,'Flat markup'),(2591,'Flat shipping charge per item ordered.'),(2593,'Flat shipping charge per weight unit ordered (for example, per pound or per kilogram - depending on the weight units used by your store).'),(2590,'Flat shipping charge. This value will be added to the shipping rate regardless of the weight, price and number of items ordered.'),(3847,'Flexy templates have been removed'),(3839,'Flexy to twig converter'),(3840,'Flexy-template'),(3854,'Flexy-to-twig converter warning'),(761,'Footer menu'),(2035,'For any emergency you can use the hard, soft and restore-state links'),(1697,'For details refer to'),(29,'For details refer to X-Cart license'),(762,'For the period'),(2117,'Force customer to choose product options before the product can be added to cart'),(1786,'Forgot password'),(763,'Forgot password?'),(1553,'Forgot your password?'),(764,'Format'),(2314,'Four-digit number on the front side of your card'),(65,'Free'),(3195,'Free & paid'),(765,'Free add-ons'),(2176,'Free license is activated successfully'),(2181,'Free license key for this email is already registered'),(3928,'Free shipping'),(3931,'Free shipping tooltip text'),(3943,'Free shipping update import text'),(3942,'Free shipping update text'),(3937,'Freight'),(4034,'Froala Editor settings'),(766,'From'),(108,'From computer'),(774,'From email'),(1836,'Front page'),(2775,'Front page title'),(3301,'Full Name'),(775,'Full description'),(776,'Full name'),(3536,'Funding methods (checkout page)'),(2024,'G'),(3036,'GDlib extension'),(777,'General'),(778,'General Settings'),(779,'General info'),(2779,'General options'),(780,'General settings'),(4340,'General tax rates'),(3643,'Generate XML-Sitemap'),(3674,'Generate cache on the fly'),(2374,'Generate resized images'),(2375,'Generate resized images help text'),(3642,'Generate sitemap'),(4268,'Geo settings & company info are all set. Congrats!'),(3951,'Geolocation header promo'),(1607,'Get CSV'),(3633,'Get X off for order amount over Y'),(2741,'Get a more customizeable PDF invoice solution for your store'),(2738,'Get a more powerful banner system for your store'),(2734,'Get information[TT]'),(3688,'Get params'),(2566,'Get shipping rates from major shipping carrier companies.'),(4397,'Get started Now! Click here to create your PITNEY BOWES Postage Account'),(4400,'Girth'),(781,'Give buyers a way to pay by adding an alternative payment method.'),(782,'Give buyers another way to pay by adding an alternative payment method'),(1893,'Global'),(2161,'Global & Classes attributes'),(1892,'Global attributes'),(3368,'Global eGood settings'),(3658,'Global product tabs'),(3663,'Global tab label'),(3662,'Global tab not found'),(4293,'Go on, make your first sale.'),(783,'Go to Marketplace'),(784,'Go to checkout'),(48,'Go to checkout as a New customer'),(3964,'Go to comparison table'),(3870,'Go to different page to edit the content'),(4460,'Go to payment details page'),(3770,'Go to see the review [in the Admin area]'),(4257,'Good job! You company logo is added'),(63,'Grand total'),(2863,'Greeting'),(194,'Greetings, X'),(785,'Grid'),(786,'Group options'),(2278,'Group {{value}} does not exists and will be created'),(4088,'Groups'),(4684,'HPP Key'),(788,'HTML title (\'title\' tag)'),(3042,'HTTPS bouncers'),(789,'HTTPS check'),(1908,'HTTPS option has been disabled'),(1907,'HTTPS option has been successfully enabled'),(790,'HTTPS settings'),(2561,'Handling fee'),(1773,'Hard reset (disables all modules and runs application)'),(2895,'Hard reset. Disable all addons except those provided by X-Cart Team'),(3687,'Hash'),(2464,'Hash file for installed entry \"{{entry}}\" doesn\'t exist or is not readable'),(4321,'Hash protection type'),(794,'Have a discount coupon?'),(3311,'Have more coupons?'),(2625,'Haven\'t found what you\'re looking for? View more shipping modules'),(2865,'Header'),(2861,'Header, greeting & signature'),(2061,'Height'),(795,'Height (px)'),(250,'Hello, user'),(125,'Help'),(796,'Help zone'),(797,'Here are shown only the methods enabled on the configuration page'),(787,'Here is a new link for access to your information: X'),(4258,'Here is the way it looks like on desktop & mobile devices. Do you like it?'),(798,'Here you can define how your payment methods will look in customer area'),(1558,'Here you can define how your payment methods will look in customer area.'),(4275,'Here you can manually define your shipping rates and etc.'),(2585,'Here you can provide general information about the shipping method and configure a table defining how shipping rates for this method should be calculated.'),(4087,'Here you can view and manage the MailChimp news lists and groups of the user.'),(4172,'Hidden X messages'),(3678,'Hidden from products filter'),(799,'Hide'),(4673,'Hide \"How to use\" instruction'),(2718,'Hide all warnings/errors'),(2796,'Hide and make them available only via a direct link'),(1205,'Hide common settings'),(3883,'Hide converted templates'),(4173,'Hide message history'),(4383,'Hide the carrier shipping charge on the label'),(4382,'Hide total carrier charge'),(800,'Hide trailing zeros in fractional part'),(4195,'Hide vendor’s products in the order'),(3966,'High - Low'),(3867,'Highlight labels'),(801,'History'),(3383,'History of downloads'),(802,'Home'),(2783,'Home page title and meta'),(3259,'Hot addons'),(2533,'How do I move X-Cart?'),(3734,'How do you rate this item?'),(803,'How to'),(804,'How to back up your store database'),(2586,'How to define shipping rates'),(805,'How to define shipping zones'),(3058,'How to set up free shipping help'),(2461,'Human readable and SEO friendly web address for the page.'),(200,'I accept Terms and Conditions'),(806,'I agree that these addons may require an adaptation.'),(3459,'I agree with PayPal terms & conditions'),(2303,'I confirm that I have created backups of my store\'s files and database before upgrading the store'),(3071,'I have a license key'),(4272,'I sell digital goods or services and do not need to set up shipping'),(2122,'I understand that the following disabled modules will be removed.'),(4430,'I want to use this credit card for my future orders in this shop.'),(4248,'I\'ll do it later'),(4101,'ID'),(2012,'IN'),(3439,'IPN HTTP error'),(3438,'IPN verification failed'),(807,'Icons'),(808,'Identity'),(3191,'If a category has subcategories, the value in brackets shows the overall number of products in both that category and all its subcategories.'),(3232,'If the product is not available for sale, the system returns 404 response.'),(809,'If there are some critical errors occurred you can do the following'),(810,'If you choose the second option, you can download the file from the server later on and delete it from the server by clicking on the \'Delete SQL file\' button.'),(1566,'If you choose to create SQL file, you will be able to download the file from the server later and after that delete it from the server by clicking on the \"Delete SQL file\" button.'),(811,'If you do not have an account, you can easily'),(4696,'If you do not have seller account, you can register here: USA UK Germany'),(812,'If you don\'t have a moneybookers account yet, please sign up for a free moneybookers account at: http://www.skrill.com'),(813,'If you have a license key for a commercial module, you can enter it here to register the purchase of the appropriate module.'),(814,'If you have a plugin in the .tar format, you can install it by uploading it here'),(1579,'If you have multiple products sharing the same set of attributes, it makes sence to make them to be of the same product type and create the attributes on the product type level.'),(2520,'If you purchased a template but do not see it here, activate the license key that was provided to you.'),(2896,'If you still need help, please, feel free to contact X-Cart Help Desk at helpdesk@x-cart.com.'),(315,'If you store product images in the database, they are included in the SQL dump file'),(3350,'If you want the coupon discount to be applied only to products from specific categories, specify these categories here.'),(4571,'If you want to enable merchant registration wizard once again, please click on the following link'),(1564,'If you want to upload the backup of another X-Cart installation, ensure that you have completed the steps described here'),(2040,'If your store is crashed after upgrade, you can recover it'),(2797,'Ignore membership'),(815,'Image'),(212,'Image X'),(816,'Image border will not be displayed in customer\'s frontend'),(817,'Image has been identified as a duplicate and has not been imported'),(3092,'Image quality after resize'),(2154,'Image resized: X out of Y'),(2158,'Image resized: X out of Y with errors'),(3114,'Image resizing requires libraries'),(139,'Images'),(2372,'Images resized'),(2388,'Images resized: {{count}}'),(3534,'Immediate'),(4727,'Immediate Charge'),(818,'Import'),(819,'Import / Export'),(3198,'Import and Export'),(1533,'Import by CSV'),(3579,'Import from CSV file'),(820,'Import from file'),(2159,'Import has been cancelled.'),(2435,'Import language'),(1972,'Import language from CSV file'),(282,'Import mechanism does not know the field of X and it can not be imported'),(1986,'Import mode'),(1989,'Import mode comment'),(821,'Import of orders is not supported.'),(4410,'Import payment methods'),(2798,'Import results'),(1525,'Import settings'),(822,'Import/Export'),(2396,'Import/Export guide'),(823,'Important'),(3941,'Important info on the Free shipping addon update'),(4447,'Important!'),(2366,'Imported'),(2367,'Importing data...'),(279,'Importing will overwrite the existing product information. This operation cannot be undone.'),(2291,'In advanced mode you can choose specific modules for upgrade.'),(3597,'In catalog only'),(824,'In category'),(1559,'In order to accept credit cards payments you should install the necessary payment module from our Marketplace.'),(2688,'In progress[S]'),(825,'In stock'),(3673,'In stock only'),(4544,'In store currency (0 - do not use coverage)'),(4662,'In the form that opens, paste the \"Webhook URL\" value into the field \"URL to be called\" and click \"Add endpoint\".'),(4661,'In the section \"Endpoints receiving events from your account\", click \"+ Add endpoint\".'),(2463,'In this section you can review the recent payment transactions that have taken place at your store'),(826,'Inactive'),(2670,'Inactive license key ({{key}})'),(827,'Incl. X'),(4351,'Include response in hash'),(272,'Including X'),(1593,'Including subcategories'),(1730,'Incomplete'),(828,'Incompleted'),(2750,'Incorrect amount'),(303,'Incorrect owner of X directory'),(305,'Incorrect owner of X file'),(2499,'Incorrect password. Please try again.'),(2749,'Incorrect permissions'),(4341,'Individual settings for every rate'),(2799,'Info'),(3945,'Information'),(2182,'Information about free license key has been sent'),(2689,'Initialized[S]'),(2800,'Initializing...'),(3869,'Inline editor'),(3817,'Inline editor is unavailable due to TinyMCE'),(829,'InnoDB engine support enabled'),(2133,'Input data'),(830,'Install'),(3880,'Install Google Tag Manager'),(4095,'Install Mailchimp addon'),(3154,'Install TaxJar integration'),(831,'Install add-on'),(1974,'Install addons'),(2844,'Install anyway'),(832,'Install updates'),(2437,'Installation date'),(833,'Installation directory'),(3260,'Installation requirements'),(3000,'Installation script'),(2540,'Installation warnings'),(834,'Installed'),(3194,'Installed Addons'),(835,'Installed Modules'),(836,'Installed modules'),(1667,'Installed version'),(3160,'Installing addons'),(837,'Installing updates, please wait...'),(4379,'Insurance value'),(2623,'Integration with'),(2943,'Integrity check'),(2954,'Integrity check has been completed successfully.'),(2955,'Integrity check has been stopped.'),(2953,'Integrity has not yet been checked. Initiate an integrity check by clicking the button \"Refresh integrity status\".'),(4302,'International: phone'),(838,'Invalid login or password'),(4016,'Inventory'),(1909,'Inventory has been successfully updated'),(839,'Inventory status'),(840,'Inventory tracking'),(3573,'Inventory tracking for product X will not be imported'),(841,'Inventory tracking for this product is'),(2801,'Inventory tracking is'),(2185,'Inventory tracking options'),(842,'Invoice'),(1845,'Invoice #{{orderId}}, {{time}}'),(228,'Invoice X'),(2066,'Invoice number prefix'),(3392,'Ip'),(4376,'Irregular parcel girth'),(1814,'Issue no'),(843,'It is impossible to delete or create user accounts because your store currently works as an integration with Drupal and shares users with Drupal. Deleting/creating user accounts is possible via Drupal administrator interface.'),(844,'It is impossible to edit some user profile fields because your store currently works as an integration with Drupal and shares users with Drupal. Modifying these fields is possible via Drupal administrator interface.'),(1513,'It\'s impossible to detect valid SSL certificate availability on your server because curl extension is not installed.'),(4317,'It\'s recommended to limit the length of invoice prefix to 9 characters'),(1936,'Item'),(845,'Item description'),(846,'Item has been deleted from cart'),(1855,'Item has not been deleted from cart'),(2852,'Item list'),(847,'Item name'),(2234,'Item not found ({{keys}})'),(234,'Items'),(848,'Items per page'),(2576,'Items range'),(388,'JANUARY'),(394,'JULY'),(393,'JUNE'),(3975,'Joe'),(849,'Join forces with your bank'),(501,'Joined'),(2937,'Just enter email address'),(850,'K'),(2023,'KG'),(4455,'KOUNT Antifraud screening result'),(1488,'Key is validated, but the module X was not found'),(126,'Knowledge Base'),(4298,'Knowledge base'),(2021,'LB'),(1930,'Label'),(4380,'Label format'),(156,'Label name'),(4381,'Label size'),(1922,'Labels'),(3821,'Labels editor'),(851,'Language'),(852,'Language labels'),(163,'Language name in X'),(120,'Language options'),(1596,'Language:'),(124,'Languages'),(1754,'Last 24 hours'),(1755,'Last 7 days'),(184,'Last added items'),(3055,'Last element of category path should be same as name'),(853,'Last logged in'),(854,'Last login'),(1756,'Last month'),(855,'Last name'),(2313,'Last three numbers on the back side of your card'),(2886,'Last time re-deployed at'),(2467,'Last week'),(2469,'Last year'),(3994,'Lastname'),(4291,'Launch (Paypal Onboarding)'),(3457,'Launch PayPal'),(2222,'Layout'),(3868,'Layout block'),(3819,'Layout editor'),(3831,'Layout editor allows you to change the position of the blocks in drag-n-drop fashion'),(3823,'Layout editor is'),(3830,'Layout editor is disabled'),(3829,'Layout editor is enabled'),(2524,'Layout has been changed. Review the updated storefront.'),(2516,'Layout type'),(2322,'Learn More'),(3877,'Learn more about Google Tag Manager'),(104,'Learn more about the top banner and how it shows in the page layout'),(4582,'Leave at door'),(2513,'Leave blank to use category name as Page Title.'),(3925,'Leave blank to use news title as Page Title.'),(3625,'Leave blank to use page name as Page Title.'),(2501,'Leave blank to use product name as Page Title.'),(2059,'Length'),(1583,'Length x Width x Height'),(1791,'Less search options'),(3151,'Let TaxJar automate your sales tax calculations, reporting, and filings in minutes.'),(3893,'Letter center'),(4233,'Let’s setup your store'),(30,'License activation is not available'),(1494,'License is not received'),(2447,'License key'),(2443,'License key has been successfully verified and activated for \"{{name}}\" module by \"{{author}}\" author.'),(856,'License key has been successfully verified for \"{{name}}\" module by \"{{author}}\" author'),(2673,'License key is missing'),(3075,'License key registration'),(2669,'License warning'),(3261,'License warnings'),(2436,'License: trial version'),(857,'Lifetime'),(3327,'Limit number of uses'),(858,'Limit the number of uses'),(2151,'Lines checked: X out of Y'),(2152,'Lines imported: X out of Y'),(2156,'Lines imported: X out of Y with errors'),(2155,'Lines verified: X out of Y with errors'),(859,'Link'),(860,'List'),(861,'List of states'),(4060,'List rating'),(2001,'Live'),(2090,'Live mode'),(1887,'Loading the database from file .'),(862,'Loading...'),(863,'Localization'),(3952,'Location is invalid'),(3949,'Location was successfully set'),(2098,'Locked'),(4628,'Log all communications between shopping cart and Canada Post server'),(2427,'Log files not found'),(864,'Log in'),(2740,'Log in as this admin'),(262,'Log off'),(865,'Log out'),(866,'Logged as'),(3617,'Logged in users only'),(261,'Logged in!'),(867,'Login'),(1806,'Login Here'),(2430,'Login dates'),(868,'Login here'),(869,'Login history'),(2802,'Login is locked out'),(2938,'Login to your account'),(1939,'Login/E-mail'),(3606,'Logo'),(3619,'Logo & Favicon'),(2994,'Logout this user'),(870,'Look & Feel'),(1701,'Loopback test'),(3967,'Low - High'),(343,'Low inventory products'),(871,'Low limit notification for this product is'),(872,'Low limit quantity'),(873,'Low stock'),(2468,'Low stock info'),(4029,'Low stock notification to admin'),(4028,'Low stock warning on product page'),(874,'M'),(390,'MARCH'),(3503,'MATCH_CRITERIA_DISABLED'),(3500,'MATCH_CRITERIA_HELP'),(3501,'MATCH_CRITERIA_NAME'),(3502,'MATCH_CRITERIA_NONE'),(392,'MAY'),(4314,'MD5 Hash protection'),(4349,'MD5 hash value'),(2009,'MM'),(381,'MO'),(2309,'MONTH'),(4035,'MailChimp'),(4036,'MailChimp Integration with E-commerce support'),(4041,'MailChimp Lists'),(4039,'MailChimp is an email marketing service with powerful tools to manage your email campaigns and subscribers while gathering advanced analytics information on your campaign performance.'),(4084,'MailChimp list group names'),(4083,'MailChimp list groups'),(4042,'MailChimp list segments'),(4102,'MailChimp lists'),(4079,'MailChimp lists update'),(4043,'MailChimp segment settings'),(4103,'MailChimp settings'),(4561,'Mailing tube'),(144,'Main categories'),(875,'Maintenance'),(876,'Maintenance and operation'),(2855,'Major improvements and new features'),(2854,'Major upgrade'),(2509,'Make a discount available to all customers or only to specific membership levels;'),(877,'Make back-up of your store database'),(3911,'Make mutual relations'),(3175,'Make sure the URL is correct and the file referenced by the URL is a PNG/JPG/JPEG'),(1885,'Making backup of the current database state ... '),(885,'Manage admins'),(1882,'Manage attribute groups'),(878,'Manage catalog'),(879,'Manage categories'),(366,'Manage category (X)'),(880,'Manage customer and administrator accounts'),(3656,'Manage global tabs'),(1692,'Manage groups'),(881,'Manage layout'),(882,'Manage orders'),(883,'Manage orders placed at your store'),(1578,'Manage product classes'),(4104,'Manage segments'),(884,'Manage users'),(4285,'Manage your payment options'),(886,'Manage your product inventory'),(2803,'Manage zones'),(887,'Mandatory fields are marked with an asterisk'),(4553,'Manifest ID'),(4552,'Manifests'),(3685,'Manual'),(3576,'Manually'),(888,'Manually defined shipping methods'),(4202,'Mark all'),(4203,'Mark selected'),(889,'Mark, the search engines you want to inform of the structure of your site using the site map'),(890,'Market price'),(2804,'Marketing'),(891,'Marketplace'),(892,'Marketplace [check_addon_key]: the \"{{url}}\" URL requested'),(893,'Marketplace [check_for_updates]: the \"{{url}}\" URL requested'),(894,'Marketplace [check_for_updates]: valid response received'),(895,'Marketplace [get_hosting_score]: response has an invalid format'),(896,'Marketplace [get_hosting_score]: the \"{{url}}\" URL requested'),(2297,'Marketplace-Vendor'),(897,'Markup per item'),(898,'Markup per weight unit'),(1787,'Max'),(4137,'Max allowed file size is X'),(4629,'Maximum Post Offices that will be displayed'),(2858,'Maximum items in box'),(1584,'Maximum number of items per box'),(3328,'Maximum number of uses'),(3323,'Maximum order subtotal must be greater than minimum order subtotal'),(3335,'Maximum order subtotal the coupon can be applied to'),(300,'Maximum size of the file to upload is N'),(1883,'Measuring productivity in manual mode failed.'),(4061,'Members count'),(899,'Membership'),(900,'Membership access'),(901,'Membership levels'),(902,'Membership name'),(903,'Memberships'),(3013,'Memory limit'),(2096,'Menu'),(3609,'Menu links help text'),(904,'Menus'),(3428,'Merchant login'),(4569,'Merchant registration wizard'),(227,'Merge with Registered'),(905,'Message'),(3298,'Message has been sent'),(4166,'Message not found'),(4165,'Messages'),(106,'Meta desc'),(906,'Meta description'),(907,'Meta keywords'),(105,'Meta tags'),(2420,'Method name'),(908,'Methods'),(3322,'Minimum order subtotal must be less than maximum order subtotal'),(3334,'Minimum order subtotal the coupon can be applied to'),(2805,'Minimum value is X'),(2856,'Minor improvements'),(2853,'Minor update'),(2950,'Modified files'),(1581,'Modifiers'),(909,'Modify'),(910,'Modify \"{{name}}\" option group'),(911,'Modify category'),(912,'Modify option groups exceptions'),(913,'Modify root category (the front shop page)'),(2395,'Module Marketplace. Terms of use'),(152,'Module available editions 3'),(153,'Module available editions 4'),(914,'Module has been successfully installed'),(3262,'Module name'),(1878,'Module packing is available in the DEVELOPER mode only. Check etc/config.php file'),(2405,'Module page'),(4277,'Module settings (shipping_rates)'),(1508,'Module with ID X is not found'),(1672,'Module\'s page'),(2806,'Modules'),(1499,'Modules have been successfully installed'),(1910,'Modules license agreements'),(3263,'Monday'),(4184,'Monitoring of communication related to oder #X has been disabled'),(4183,'Monitoring of communication related to oder #X has been enabled'),(407,'Month'),(1826,'More'),(1976,'More actions for selected'),(916,'More add-ons'),(2613,'More attributes'),(917,'More details'),(2047,'More info is available in X-Cart\'s Knowledge Base article \'What to do if you cannot access your store...\''),(615,'More information about clean urls in X-Cart is available in '),(668,'More information on Clean URL problems on your system'),(4663,'More information on the setup of webhooks is available here: https://stripe.com/docs/webhooks#configuring-your-webhook-settings'),(4265,'More localisation settings'),(1792,'More search options'),(2647,'More shipping solutions'),(918,'Most Popular'),(919,'Most Rated'),(920,'Move'),(4595,'Move item'),(4026,'Move to'),(2017,'Mr.'),(2019,'Mrs.'),(2018,'Ms.'),(3410,'Multiple top-level domains'),(3899,'Mutual link'),(3909,'Mutual link head help'),(4305,'My Shipping'),(921,'My account'),(3105,'My addons'),(3946,'My location'),(3109,'My profile'),(3118,'My purchases'),(4276,'My shipping'),(3034,'MySQL cache'),(922,'MySQL server'),(3030,'MySQL version'),(148,'N it.'),(118,'N items found'),(147,'N items total'),(398,'NOVEMBER'),(923,'Name'),(1927,'Name asc'),(1928,'Name desc'),(4307,'Name length must be less then {{length}}'),(927,'Name of account holder'),(924,'Name of address field'),(925,'Name of purchaser'),(1577,'Name, e.g. Apparel'),(1055,'Name-sort-option'),(164,'Native language name'),(3467,'Near \"Add to cart\" button'),(3468,'Near \"Checkout\" button'),(3147,'Need a customizable contact us form with location map? [Get it now!]'),(42,'Need a license key?'),(3089,'Need a way to set multicurrency prices? [Install the addon]'),(3090,'Need a way to set up product variants? [Install the addon]'),(3091,'Need a way to set wholesale prices? [Install the addon]'),(2522,'Need custom design? We can modify this template or create a completely unique design for you'),(4294,'Need help setting up your store?'),(1694,'Need license key?'),(1560,'Need more payment methods?'),(928,'Never'),(1626,'New Export'),(3650,'New Tab'),(2407,'New access codes were generated.'),(930,'New access key will also be sent to the Site administrator\'s email address'),(929,'New access link'),(2386,'New account'),(1552,'New address'),(931,'New address field'),(3588,'New arrivals'),(1691,'New attribute'),(2268,'New attribute group will be created'),(142,'New category'),(2701,'New customer note'),(932,'New discount coupon'),(1625,'New group'),(933,'New image'),(3812,'New images'),(1519,'New import'),(934,'New item'),(133,'New membership'),(4201,'New message'),(4174,'New message for order'),(4193,'New messages'),(2125,'New module version available for core versions X'),(2471,'New modules'),(3914,'New news message'),(935,'New page'),(4596,'New parcel'),(936,'New product class'),(937,'New product has been added successfully'),(3761,'New product reviews'),(938,'New rate'),(939,'New role'),(1771,'New safe mode access key has been generated'),(4342,'New sale tax rate'),(2199,'New staff note'),(3649,'New tab'),(4215,'New tag'),(1318,'New tax class'),(2553,'New to Avalara?'),(47,'New to our store?'),(1752,'New user registered'),(1624,'New value'),(190,'New zone has been created successfully'),(3589,'New!'),(940,'Newest'),(941,'Newest first'),(3915,'News'),(4046,'News list subscriptions'),(3913,'News message'),(3912,'News messages'),(3923,'News page title'),(3924,'News title'),(3988,'Newsletters'),(942,'Next'),(3919,'Next news'),(3087,'Next order'),(943,'Next page'),(55,'Next product'),(4012,'Next step'),(99,'Next wizard'),(944,'No'),(1427,'No Curl extension for PHP error'),(1428,'No OpenSSL extension for PHP error'),(3565,'No PIN codes found.'),(1426,'No Phar extension for PHP error'),(2936,'No account yet?'),(2621,'No accounting system has been selected yet. Choose your accounting system below and configure it.'),(4464,'No active X-Payments payment methods, or saving credit cards is not activated.'),(1591,'No attributes'),(1693,'No attributes are defined for the product class yet.'),(1592,'No attributes assigned'),(2970,'No category assigned'),(1868,'No category defined'),(2173,'No class'),(3894,'No confirmation'),(945,'No countries found'),(2007,'No delimiter'),(3787,'No email'),(4539,'No events found'),(946,'No featured products defined for this category'),(3172,'No file was uploaded'),(3846,'No flexy-templates found.'),(1590,'No group'),(4105,'No groups defined'),(947,'No image'),(948,'No images uploaded'),(2411,'No items found'),(949,'No items found.'),(4612,'No items have been selected for return.'),(418,'No membership'),(950,'No merchant account required'),(522,'No merchant account required. Simple onboarding for you and easy checkout for your customers.'),(2412,'No model selected'),(1663,'No modules found'),(119,'No modules found for search_string'),(951,'No order have been placed yet'),(350,'No order on last day'),(353,'No order on last lifetime'),(352,'No order on last month'),(351,'No order on last week'),(354,'No orders'),(3857,'No orders available. Please create at least one order.'),(952,'No orders have been placed yet'),(123,'No other languages defined'),(1858,'No payment method selected'),(1859,'No payment methods found based on the selected criteria'),(953,'No payment modules installed'),(3568,'No pin codes are bought yet'),(1576,'No product class assigned'),(1665,'No products found'),(4210,'No products have been selected for comparison.'),(4123,'No products matching the current filtering criteria were found. Try clearing filters.'),(3670,'No products matching your criteria found. Please try again with different parameters.'),(954,'No products sold yet'),(1666,'No profiles found'),(2349,'No promotion modules installed'),(2534,'No region'),(2850,'No results found.'),(3748,'No reviews.'),(3141,'No roundup'),(4106,'No segments'),(955,'No states found'),(4058,'No subscription'),(1554,'No such user'),(956,'No tax rate defined'),(1192,'No tracking numbers are defined'),(1664,'No users found'),(3554,'No valid code found.'),(4384,'Non delivery option'),(957,'Non-administrator'),(3264,'Non-critical'),(4630,'Non-delivery instructions'),(252,'None'),(4162,'Not Finished orders were skipped during the export process. If you wish to export the orders which are now in this state, change their fulfillment status from Not Finished to any other.'),(2971,'Not assigned'),(3265,'Not available'),(1703,'Not detected'),(2036,'Not enough disk space. Required: {{req}} (+{{reserve}} reserve). Available: {{avail}}'),(958,'Not finished'),(4157,'Not finished order'),(959,'Not numeric'),(3749,'Not rated yet'),(2619,'Not seeing your accounting software here? Let us know'),(1608,'Not selected'),(4027,'Not set'),(4574,'Not specified'),(960,'Note'),(4465,'Note: No payment methods here because the module is not configured. Please finalize settings at '),(2058,'Note: a new window will be opened'),(961,'Notes'),(2342,'Notification'),(2379,'Notification header, greeting, text and signature can be set using variables. A list of supported variables and their respective values is provided in the table below'),(2868,'Notification state'),(2715,'Notify administrator if the stock quantity of this product goes below a certain limit'),(962,'Notify administrator inactivity help'),(2214,'Notify customer'),(1738,'Now disabled'),(4283,'Now you can define how shipping rates should be calculated based on  delivery time, weight and other parameters.'),(1598,'Number of ignored rows:'),(397,'OCTOBER'),(3884,'OK'),(1683,'OR'),(2022,'OZ'),(2778,'Object name (category, product, etc)'),(2770,'Object name order first'),(2771,'Object name order last'),(3493,'Obtaining your live PayPal credentials'),(963,'Off'),(964,'Official website'),(4287,'Offline method'),(965,'Offline methods'),(4678,'Ogone PSPID'),(4682,'Ogone settings note'),(4681,'Ogone signup'),(4444,'Ok'),(3062,'Ok, Got it'),(2700,'Old customer note'),(966,'Old price'),(2198,'Old staff note'),(967,'On'),(968,'On all catalog pages'),(3895,'On call air'),(3598,'On catalog and product pages'),(2908,'On category and product details page'),(2907,'On category listing'),(4565,'On delivery'),(4564,'On exception'),(3739,'On moderation'),(969,'On product details only'),(3602,'On sale'),(4563,'On shipment'),(2862,'On this page you can edit the header, greeting and signature used by all the email notifications sent by your store (separately for admin and customer users).'),(4306,'Onboarding Wizard'),(1307,'Once links are regenerated, they will be sent to store administrator email.'),(4419,'Once the connection is verified, you should proceed to the'),(3998,'One Page checkout'),(2226,'One column'),(3409,'One domain with multiple subdomains'),(3896,'One time pickup'),(970,'Online catalog structure setup'),(4288,'Online method'),(459,'Online methods'),(2144,'Online orders'),(2716,'Only X left in stock'),(3744,'Only customers who purchased this product can leave feedback on this product'),(136,'Only disabled'),(135,'Only enabled'),(1877,'Only enabled modules can be packed'),(2906,'Only orders awaiting processing'),(971,'Only small letter, digits and undescore sign are allowed'),(3295,'Oops, no products have been added to this category yet.'),(1946,'Open'),(972,'Open Graph meta tags'),(4477,'Open X-Payments dashboard to configure'),(4190,'Open a dispute'),(4179,'Open dispute'),(3621,'Open graph image'),(973,'Open graph tags'),(3871,'Open home or category pages for more opportunities to adjust the website structure'),(4062,'Open rate'),(974,'Open storefront'),(4660,'Open the page \"Webhooks\" in the \"Developers\" section of dashboard.stripe.com: https://dashboard.stripe.com/account/webhooks'),(3875,'Open the storefront while logged in as administrator to change the look & feel of the store.'),(4470,'Open your X-Payments dashboard'),(2547,'Operate as user'),(975,'Operating system'),(4697,'Operation mode'),(976,'Option group'),(4310,'Option values has been successfully updated.'),(2807,'Options'),(977,'Options have been successfully changed'),(2401,'Options:'),(3126,'Or add a video review powered by ShopperApproved'),(4423,'Or fill in the settings manually'),(3479,'Or register with'),(3478,'Or sign in the classic way'),(3482,'Or use your social account'),(978,'Order'),(979,'Order #'),(288,'Order #X, Y'),(1967,'Order #{{id}}'),(1977,'Order #{{id}} details'),(980,'Order ID'),(2664,'Order QTY'),(981,'Order Total'),(322,'Order Total X'),(289,'Order X'),(2989,'Order X has been confirmed as delivered to the customer'),(1534,'Order by'),(1834,'Order can not be placed because not all required fields are completed. Please check the form and try again.'),(4003,'Order cannot be placed because some steps are not completed'),(2808,'Order cannot be placed because there is no shipping methods available.'),(2215,'Order changes cannot be saved due to negative total value'),(3149,'Order customer notes changed'),(2661,'Order date'),(982,'Order date from'),(983,'Order date through'),(3561,'Order deleted'),(984,'Order details'),(2438,'Order failed'),(3387,'Order fulfilment status changed from {{oldStatus}} to {{newStatus}} by file download'),(3150,'Order has been edited'),(1933,'Order history'),(985,'Order id'),(3440,'Order id prefix'),(3360,'Order is not processed'),(341,'Order is placed'),(2209,'Order item attributes are out-of-date and cannot be edited'),(2927,'Order item modifier not found'),(986,'Order items'),(2918,'Order modifier not found'),(1857,'Order not found'),(987,'Order note'),(3999,'Order note. Any special needs?'),(1799,'Order number'),(2809,'Order number or email'),(988,'Order page'),(1785,'Order payment'),(2130,'Order payment status changed from {{oldStatus}} to {{newStatus}}'),(4354,'Order prefix'),(989,'Order review'),(2131,'Order shipping status changed from {{oldStatus}} to {{newStatus}}'),(3148,'Order staff notes changed'),(990,'Order statistics'),(991,'Order status'),(2115,'Order status changed from {{oldStatus}} to {{newStatus}}'),(4496,'Order status mapping rules'),(4127,'Order statuses'),(1189,'Order tracking information'),(2931,'Order transaction status not found'),(2933,'Order transaction type not found'),(2210,'Order will be delivered to the billing address.'),(2760,'OrderBy position number must be specified as a non-negative integer.'),(368,'OrderID or email, ID1-ID2 for range'),(4705,'OrderId prefix'),(3377,'Ordered files'),(4592,'Ordered qty'),(992,'Orders'),(2904,'Orders awaiting processing'),(993,'Orders count'),(2667,'Orders has been deleted successfully'),(4129,'Orders have this status tooltip'),(4049,'Orders last month'),(2389,'Orders list'),(994,'Orders placed'),(4168,'Orders with any messages'),(4167,'Orders with unread messages'),(2644,'Origin address'),(249,'Other'),(185,'Other items'),(131,'Our Blog'),(3304,'Our location'),(1824,'Out of Stock'),(995,'Out of stock'),(4562,'Oversized'),(3019,'PDO extension'),(1705,'PHP \'gd\' extension is not installed.'),(3005,'PHP version'),(3555,'PIN'),(3570,'PIN code'),(3571,'PIN codes'),(3569,'PIN codes data have been successfully updated'),(3557,'PIN codes enabled'),(3574,'PIN codes generation method'),(4551,'PO Number'),(1088,'PO number'),(2145,'POS orders'),(3494,'PRIMARYRECEIVER'),(4683,'PS Store ID'),(996,'Pack it'),(1678,'Package'),(2081,'Package dimensions (inches)'),(4631,'Package height (cm)'),(4632,'Package length (cm)'),(4633,'Package maximum weight (kg)'),(2076,'Package properties'),(2053,'Package subtotal'),(2054,'Package subtotal (X)'),(2051,'Package weight'),(2052,'Package weight (X)'),(4634,'Package width (cm)'),(2080,'Packaging'),(2660,'Packing date'),(2658,'Packing slip'),(997,'Page'),(998,'Page URL'),(999,'Page name'),(1000,'Page not found'),(2784,'Page title format'),(1001,'Pages'),(1002,'Paid'),(4545,'Parcel'),(4554,'Parcel characteristics'),(4375,'Parcel dimensions'),(4585,'Parcel is cannot be transmitted - wrong quote type'),(4584,'Parcel is cannot be voided or transmitted - wrong quote type'),(4543,'Parcel options'),(4373,'Parcel type'),(4374,'Parcel weight'),(4601,'Parcels have been successfully updated'),(1003,'Parent category'),(2958,'Parent category name'),(2777,'Parent category path'),(377,'Partially refunded'),(3426,'Partner name'),(3266,'Passed'),(240,'Password'),(1004,'Password and its confirmation do not match'),(401,'Past'),(3808,'Path for using in custom CSS'),(1005,'Pattern search'),(4706,'Pay with Amazon'),(4428,'Pay with previously used credit card'),(3484,'PayPal'),(3446,'PayPal API'),(3469,'PayPal API (Merchant API) will work for most merchants; however, some merchants may have access only to Payflow API.'),(3514,'PayPal API Client ID'),(3515,'PayPal API Secret'),(3517,'PayPal BN Code'),(3495,'PayPal Credit'),(3458,'PayPal Credit is'),(3543,'PayPal Express Checkout'),(3513,'PayPal For Marketplaces account email'),(3421,'PayPal ID / Email'),(3509,'PayPal Merchant ID'),(3516,'PayPal Partner ID'),(3460,'PayPal account email'),(521,'PayPal all-in-one solutions'),(3430,'PayPal recommends entering a User Login here instead of your Merchant Login'),(4728,'PayWithAmazon available actions'),(3488,'PayerID value was not returned by PayPal. Please try again. If the problem persists, contact the administrator.'),(3447,'Payflow API'),(2884,'Payment'),(4712,'Payment capture error: {{error}}'),(1012,'Payment data ({{method}})'),(1006,'Payment gateways'),(4718,'Payment has been authorized successfully.'),(3472,'Payment has been captured successfully'),(4711,'Payment has been captured successfully.'),(4719,'Payment has been declined.'),(3470,'Payment has been refunded successfully'),(4715,'Payment has been refunded successfully.'),(3471,'Payment has been voided successfully'),(3544,'Payment has bes refunded successfully'),(3547,'Payment have been voided successfully'),(4713,'Payment have been voided successfully.'),(1007,'Payment info'),(4494,'Payment information'),(1008,'Payment instructions'),(2392,'Payment is not required'),(1009,'Payment method'),(1011,'Payment method data'),(4486,'Payment method for card setup'),(2538,'Payment method has been added'),(1881,'Payment method has been added successfully'),(335,'Payment method has been disabled successfully'),(334,'Payment method has been enabled successfully'),(336,'Payment method has been removed successfully'),(337,'Payment method has not been configured properly'),(2352,'Payment method is disabled'),(2351,'Payment method is enabled'),(2428,'Payment method settings'),(2539,'Payment method was not added'),(1010,'Payment methods'),(331,'Payment methods appearance description'),(4484,'Payment methods have been imported successfully'),(3267,'Payment order status'),(4652,'Payment processed with errors. Please, try again or ask administrator'),(4729,'Payment refresh error: {{error}}'),(4717,'Payment refund error: {{error}}'),(4524,'Payment return page requested without expected parameters'),(1013,'Payment settings'),(2126,'Payment status'),(2917,'Payment status not found, \"Awaiting payment\" will be used for order'),(4131,'Payment status not found, new status will be created'),(4125,'Payment statuses'),(1014,'Payment transaction ID'),(324,'Payment transaction X issued'),(4720,'Payment transaction is in progress...'),(1015,'Payment transactions'),(4714,'Payment void error: {{error}}'),(323,'Payment was not finished'),(1016,'Payments'),(3531,'Payments with this payment method are not allowed because HTTPS is not configured'),(3486,'Paypal capture warning message'),(3545,'Paypal login (email)'),(1017,'Pending'),(256,'Pending membership'),(1018,'Pending memberships'),(2691,'Pending[S]'),(1019,'Per item markup'),(1020,'Per weight unit markup'),(1021,'Percent'),(3636,'Percent discount value cannot exceed 100%'),(1022,'Percent markup'),(1023,'Percent off'),(1024,'Perform order search'),(1025,'Performance'),(2897,'Performing task...'),(3321,'Period end date must be later than period start date'),(3320,'Period start date must be sooner than period end date'),(1026,'Permissions'),(1027,'Permissions checking failed'),(1028,'Personal info'),(1334,'Personal info: The new password must not coincide with the current password for your account.'),(3039,'Phar extension'),(1029,'Phone'),(1030,'Pick address from address book'),(3796,'Pick template from page element'),(3865,'Pick templates from page'),(3418,'Pin'),(3417,'Pin It'),(4401,'PitneyBowes'),(1031,'Place order'),(202,'Place order X'),(2193,'Placed by NAME'),(2192,'Placed by _NAME_'),(1682,'Placed on'),(2191,'Placed on DATE'),(320,'Placed on X by Y'),(321,'Placed on X by Y link'),(1931,'Plain field'),(1661,'Please'),(1032,'Please accept the Terms and Conditions to continue'),(3965,'Please add another product to comparison'),(2962,'Please be warned that proper operation of the site after an upgrade is not guaranteed if you choose to upgrade only some of the components listed below.'),(1033,'Please choose the appropriate action'),(1599,'Please confirm if you want proceed with the import otherwise cancel the operation.'),(1299,'Please contact the module developers to make sure that these modules are compatible with the upcoming upgrade'),(2134,'Please create a new password'),(1034,'Please enable JavaScript in your web browser.'),(3297,'Please enter the correct captcha'),(1726,'Please enter the correct file location or set correct file permissions.'),(4650,'Please enter your encryption password (This is different from your merchant password). More info on encryption passwords is available <here>'),(1035,'Please identify yourself'),(1544,'Please make sure that \"min weight\", \"min total\", \"min items\", \"shipping zone\", \"shipping method\" fields do not overlap with other shipping rates.'),(1605,'Please make sure your file format is as described.'),(4567,'Please note that rates are calculated for shipping from Canadian locations only.'),(1036,'Please note that some of these modules are definitely incompatible with the upcoming upgrade and will be disabled in order to prevent the system crash'),(2385,'Please note that the following modules will also be enabled'),(4393,'Please note: the USPS Web tools APIs print labels without postage.'),(3079,'Please register your license key now or purchase a premium license to skyrocket your business.'),(2446,'Please renew your access to upgrades to get new superior features from the latest releases.'),(3772,'Please review purchased product {{product}}'),(3774,'Please review purchased products'),(1037,'Please run the benchmark test in order to estimate your server performance'),(1038,'Please save the soft reset and hard reset links so that you can use them later in case the website crash happens'),(3192,'Please select'),(415,'Please select a date range'),(414,'Please select a date range between %d and %d days'),(413,'Please select a date range less than %d days'),(412,'Please select a date range longer than %d days'),(1039,'Please select one'),(420,'Please select one ...'),(421,'Please select option'),(1851,'Please select other attribute'),(2317,'Please select the countries first'),(3268,'Please select the entities first'),(2666,'Please select the orders first'),(1837,'Please select the products first'),(3758,'Please select the reviews first'),(2180,'Please select the states first'),(4217,'Please select the tags first'),(3717,'Please sign in to add review'),(172,'Please specify a pattern to find the required labels'),(1490,'Please specify non-empty key'),(151,'Please specify text labels for each language'),(2810,'Please wait'),(247,'Please, clarify your search request or search in Marketplace'),(246,'Please, clarify your search request. Suggest your idea or contact us to get free quote for custom service'),(1424,'Please, contact administrator'),(1733,'Please, enter a valid IP address'),(1732,'Please, enter a valid e-mail address'),(1716,'Please, enter unique membership name'),(1643,'Please, make sure that the following modules are installed and enabled:'),(3562,'Please, type in the new PIN codes one per line.'),(3419,'Plus'),(1671,'Popularity'),(1040,'Pos'),(1041,'Pos.'),(1042,'Pos.:'),(1043,'Position'),(2169,'Possible import file names are:'),(2171,'Possible reasons of data not found in import file'),(2056,'Postal Code'),(2062,'Postal/ZIP Code'),(1046,'Pre upgrade disabled modules hooks message body'),(1049,'Pre upgrade disabled modules hooks message footer'),(1045,'Pre upgrade disabled modules hooks message head'),(2604,'Pre-upgrade hooks cannot be run'),(1048,'Pre-upgrade off'),(1047,'Pre-upgrade on'),(1044,'Prefix'),(2172,'Premium license modules warning'),(1050,'Prev'),(1573,'Preview product page'),(3856,'Preview template'),(405,'Previous'),(3918,'Previous news'),(3086,'Previous order'),(1051,'Previous page'),(54,'Previous product'),(244,'Price'),(4017,'Price and membership'),(1925,'Price asc'),(1926,'Price desc'),(1052,'Price modifier'),(3672,'Price range'),(1054,'Price-sort-option'),(1053,'Price: Not a numeric'),(2811,'Prices & Inventory'),(4355,'Pricing currency'),(1056,'Primary menu'),(2002,'Print'),(2626,'Print Shipping labels'),(4386,'Print custom message 1'),(4388,'Print custom message 2'),(1057,'Print invoice'),(2659,'Print packing slip'),(2003,'Print selected'),(2119,'Priority'),(2071,'Private'),(3269,'Private and custom modules:'),(3270,'Private link'),(3271,'Proceed'),(1528,'Proceed import'),(2879,'Proceed to payment'),(203,'Proceed to payment X'),(4228,'Proceed to the next step'),(1058,'Processed'),(1059,'Processed/Completed'),(2985,'Processing categories...'),(2371,'Processing products...'),(3697,'Product'),(1779,'Product ID'),(1060,'Product Name'),(1061,'Product SKU'),(1062,'Product Title'),(1063,'Product added to bag'),(2164,'Product attributes values'),(2166,'Product attributes values (Plain text) has been imported'),(2167,'Product attributes values (Textarea) has been imported'),(2165,'Product attributes values (Yes/No) has been imported'),(2410,'Product attributes values has been imported'),(1064,'Product class'),(1901,'Product class have been updated successfully'),(1902,'Product class name is empty'),(2277,'Product class {{value}} does not exists and will be created'),(1065,'Product classes'),(1066,'Product has been added to cart'),(1854,'Product has not been added to cart'),(1067,'Product images'),(1068,'Product info'),(1069,'Product info has been updated successfully'),(1070,'Product is out of stock'),(4025,'Product list'),(245,'Product name'),(3577,'Product not found'),(1071,'Product on sale'),(1072,'Product options'),(3960,'Product or product variant with SKU \"{{value}}\" not found'),(1073,'Product page title'),(1074,'Product prices are defined including this tax calculated for'),(3358,'Product removed'),(3698,'Product reviews'),(3653,'Product tabs'),(4216,'Product tags'),(2271,'Product with SKU \"{{value}}\" does not exists'),(3957,'Product with SKU \"{{value}}\" not found'),(2196,'Product with selected properties cannot be purchased'),(3710,'Product, SKU or customer info'),(1903,'Product-Specific'),(1904,'Product-Specific attributes'),(2270,'ProductSKU is empty'),(1075,'Products'),(3959,'Products and product variants updated'),(1537,'Products found'),(1914,'Products imported'),(1076,'Products in bag'),(2974,'Products in this class: {{X}}'),(2434,'Products information has been successfully deleted'),(1077,'Products information has been successfully updated'),(2370,'Products processed'),(2153,'Products processed: X out of Y'),(2157,'Products processed: X out of Y with errors'),(2387,'Products processed: {{count}}'),(4531,'Products return X'),(3699,'Products reviews'),(2708,'Products search'),(3955,'Products updated'),(1078,'Products with low inventory'),(2990,'Products with no assigned categories'),(1079,'Profile'),(2995,'Profile actions'),(3060,'Profile details'),(1080,'Profile has been created successfully'),(1081,'Profile has been deleted successfully'),(1964,'Profile has been modified successfully'),(1082,'Profile has been updated successfully'),(2137,'Profile is not defined'),(2413,'Profile is not selected'),(1083,'Profile settings'),(1084,'Promotions'),(4635,'Proof of age'),(1085,'Properties'),(3976,'Public'),(2418,'Public ID'),(2419,'Public id'),(3272,'Public installed modules:'),(4737,'Public key'),(4675,'Publishable key'),(4676,'Publishable key (test mode)'),(3716,'Published'),(1086,'Purchase'),(1087,'Purchase SSL certificate'),(3070,'Purchase a premium license key'),(2089,'Purchase description'),(2668,'Purchase license'),(37,'Purchase premium license'),(1669,'Purchased'),(3117,'Purchased addons'),(3603,'Put all for sale'),(3600,'Put up for sale'),(1089,'Put up selected for sale'),(1090,'Qty'),(1091,'Qty.'),(230,'Quantity'),(3548,'Quantity in stock'),(3566,'Quantity in stock is determined by the amount of the remaining PIN codes'),(3563,'Quantity in stock is determined by the amount of the remaining PIN codes.'),(1092,'Quantity: high to low'),(1093,'Quantity: low to high'),(408,'Quarter'),(1535,'Query'),(1094,'Queued'),(1095,'Quick and easy setup'),(3110,'Quick menu'),(2876,'Quick view'),(2548,'Quit'),(4636,'Quote type'),(2402,'RSS feed'),(1096,'Rate'),(3742,'Rate asc'),(3743,'Rate desc'),(3741,'Rate sort'),(1097,'Rates'),(1098,'Rates / Conditions'),(3708,'Rating'),(3724,'Rating of votes'),(3762,'Ratings and Reviews of X'),(3754,'Ratings only'),(1099,'Raw online rate (on-line rate)'),(1100,'Re-build cache'),(2684,'Re-check'),(2481,'Re-deploy the store'),(2482,'Re-deploy the store help text'),(1101,'Re-generate access key'),(1587,'Re-generate links'),(4409,'Re-import payment methods'),(1102,'Re-order'),(3382,'Re-upload file'),(2451,'Re-validate license keys'),(4163,'Read'),(3740,'Read all reviews about the product'),(4250,'Ready to delete demo products?'),(4192,'Reason'),(3273,'Rebuild view lists help text'),(2899,'Recalculate ViewLists'),(2900,'Recalculate ViewLists text'),(2212,'Recalculate this value automatically'),(2812,'Recalculate totals'),(2813,'Recent orders only'),(3193,'Recently installed addons'),(2429,'Recently installed modules'),(3590,'Recently viewed'),(3773,'Recently, you have made a purchase from our company:'),(1924,'Recommended'),(3511,'Reconnect to PayPal'),(4094,'Reconnect with your MailChimp account'),(241,'Recover password'),(3342,'Redeem'),(1103,'Redirect customers to HTTPS'),(3068,'Refer to X-Cart license agreement for further details.'),(4497,'Refer to on-line manual'),(1105,'Referer'),(3138,'Refresh consistency status'),(2948,'Refresh integrity status'),(4363,'Refresh list of available methods'),(4730,'Refresh status'),(4668,'Refresh token'),(2112,'Refund'),(4716,'Refund is in progress...'),(2733,'Refund multiple[TT]'),(2732,'Refund partially[TT]'),(375,'Refund requested'),(4731,'Refund status'),(3504,'Refund status:'),(4710,'Refund status: {{status}}'),(2731,'Refund[TT]'),(376,'Refunded'),(1841,'Refunded amount'),(2628,'Refunds'),(1106,'Register'),(3084,'Register license key'),(1765,'Register user'),(3480,'Register with'),(3477,'Register with PayPal or go to checkout as a New customer'),(4701,'Register your website as an application on the Login with Amazon App Console.'),(1107,'Registered'),(2141,'Registered (access level)'),(224,'Registered Customer'),(225,'Registered Customer, _Anonymous Customer with the same email_'),(2029,'Registered Customers'),(3752,'Registered users only'),(3745,'Registered users who purchased product'),(3496,'Registering your application with PayPal'),(4637,'Registration process has been canceled.'),(4638,'Registration process has been completed successfully.'),(3767,'Reject'),(3898,'Related products'),(3900,'Related products page'),(4318,'Relay Response URL note'),(3560,'Remaining PINs'),(3069,'Remind me on next sign-in'),(44,'Removal of this message is allowed only through activation of a free or premium license.'),(1108,'Remove'),(3675,'Remove cache when attribute, tag or product data is changed'),(2216,'Remove data'),(3274,'Remove expired sessions'),(3275,'Remove expired shopping carts'),(3845,'Remove flexy-templates'),(3276,'Remove module'),(3677,'Remove product filter cache'),(3676,'Remove product filter cache tooltip'),(2681,'Remove unlicensed modules'),(3344,'Removed coupons'),(2951,'Removed files'),(2208,'Removed items'),(3277,'Removing expired datacache'),(1620,'Removing this attribute will affect all the products. Leave this blank to hide this option for the product.'),(1698,'Removing this message without buying a Full license is prohibited and will result in legal proceedings.'),(1207,'Rename label'),(4639,'Render detailed manifest'),(3393,'Renew'),(2450,'Renew your access to new features'),(1746,'Replace all modified files with the unmodified newer versions'),(4416,'Replace payment methods'),(4022,'Replace with'),(128,'Report a bug'),(2360,'Request for upgrade'),(4413,'Request payment methods'),(2086,'Request type must be POST'),(4657,'Requested amount: X; real amount: Y'),(4658,'Requested currency: X; real currency: Y'),(4656,'Requested transaction type: X; real transaction type: Y'),(1973,'Requested zone does not exists'),(1433,'Require to change password on next log in'),(1109,'Required'),(1717,'Required field'),(284,'Required field X is not defined or empty'),(4322,'Required for SHA512 hash protection.'),(1110,'Required php extensions is not loaded: X'),(2968,'Required state_id checkbox help text'),(1111,'Requires registered merchant account'),(2709,'Requires shipping'),(2672,'Requires {{list}} edition'),(1112,'Rerun benchmark'),(1113,'Resend secret link to renew the access'),(4121,'Reset all filters'),(3669,'Reset filter'),(2005,'Residential'),(2373,'Resizing images...'),(2459,'Resolve the conflict'),(3781,'Response date is in wrong format'),(4511,'Response from ePDQ is not trusted (SHA checking is failed)'),(1114,'Response from marketplace is not received'),(1115,'Response from marketplace: '),(1489,'Response from marketplace: X'),(1116,'Restore'),(1117,'Restore database'),(1118,'Restore from server'),(1119,'Restore last backup'),(1120,'Restore links'),(3793,'Restore this version'),(791,'Restores to current state of active addons (use in case of emergency)'),(1890,'Restoring database from the backup .'),(2456,'Result'),(1734,'Result pages'),(4452,'Result payment status'),(4610,'Return'),(4597,'Return #'),(4587,'Return products'),(4593,'Return qty'),(4533,'Return quantity'),(1121,'Return to Drupal'),(1891,'Return to admin interface'),(3995,'Return to cart'),(3953,'Return to default database'),(4550,'Return tracking pin'),(1529,'Reupload files'),(1122,'Revenue'),(3950,'Revert to default database'),(3756,'Review'),(2707,'Review & Submit order'),(3703,'Review has been created'),(3704,'Review has been deleted'),(3705,'Review has not been created since product is not found'),(3706,'Review has not been updated since product is not found'),(3792,'Review it.'),(3178,'Review modules'),(1123,'Review statistics on various aspects of your store\'s operation'),(3707,'Reviewer'),(3788,'Reviewer name'),(3731,'Reviews'),(3760,'Reviews about product'),(3753,'Reviews and ratings'),(3696,'Reviews for product'),(3709,'Reviews imported'),(3755,'Reviews only'),(3732,'Reviews: X'),(1124,'Role'),(1125,'Roles'),(2755,'Roles cannot be changed for your profile via import'),(1126,'Root Level'),(1127,'Root access'),(1684,'Root categories'),(1128,'Root category'),(2149,'Root category listings format'),(253,'Root level'),(3140,'RoundUp'),(1983,'Row {{number}}'),(1984,'Row(s) {{numbers}}'),(4457,'Rules triggered'),(1129,'Run Benchmark again'),(1130,'Run benchmark'),(386,'SA'),(3497,'SECONDARYONLY'),(3498,'SENDER'),(3764,'SEO'),(1164,'SEO settings'),(396,'SEPTEMBER'),(4679,'SHA-IN passphrase'),(4680,'SHA-OUT passphrase'),(2594,'SHIPPING = flat + ITEMS*per_item + SUBTOTAL*(% of subtotal)/100 + WEIGHT*per_weight;'),(53,'SKU'),(2414,'SKU is not selected'),(2814,'SKU length must be less then {{length}}'),(3278,'SKU must be unique'),(3783,'SKU or Product name'),(2816,'SKU or SKU1, SKU2'),(1131,'SKU: a-z'),(1132,'SKU: z-a'),(1133,'SMTP server'),(1875,'SQL file was deleted successfully'),(1429,'SSL Error'),(1134,'STORE SETUP'),(387,'SU'),(1135,'SYSTEM SETTINGS'),(1136,'Safe mode'),(1137,'Safe mode access key'),(1869,'Safe mode access key has been re-generated'),(2033,'Safe mode links were emailed'),(4645,'Sage Pay password'),(4647,'Sage Pay pricing currency'),(4644,'Sage Pay processing mode'),(4643,'Sage Pay vendor name'),(4646,'Sage pay invoice number prefix'),(4649,'SagePay Form admin description'),(1138,'Sale'),(1139,'Sale price'),(2465,'Sale statistics'),(1140,'Sale statistics from the opening of the store'),(2724,'Sale[TT]'),(1141,'Sales'),(4301,'Sales & Customer Service:'),(4303,'Sales & Customer Service: [phone]'),(3307,'Sales asc'),(2698,'Sales calculation'),(3104,'Sales channels'),(3308,'Sales desc'),(3306,'Sales sort'),(1142,'Sales tax'),(1527,'Samples of the file structures'),(150,'Save'),(3618,'Save & Close'),(4227,'Save and go to the next step'),(1143,'Save as new'),(4438,'Save cards'),(1144,'Save changes'),(4445,'Save credit card'),(4498,'Save credit card setup'),(2650,'Save filter'),(3948,'Save location'),(2213,'Save the existing value without re-calculating'),(1145,'Save zone details'),(4442,'Saved credit cards'),(3112,'Saving'),(1146,'Savings'),(4394,'Savings - Up to 49% off retail USPS postage rates'),(2869,'Scheme'),(4456,'Score'),(3746,'Score: X. Votes: Y'),(98,'Search'),(3843,'Search flexy-templates'),(1147,'Search for modules'),(1148,'Search for orders'),(4600,'Search for returns'),(2491,'Search for transactions by date'),(1149,'Search for users'),(1150,'Search for users that are'),(426,'Search in'),(1151,'Search in subcategories'),(2148,'Search items...(customer header search form)'),(422,'Search keywords'),(423,'Search payment method'),(1152,'Search product'),(1153,'Search profiles'),(1154,'Search result'),(1155,'Search results'),(2142,'Search total'),(2849,'Searching...'),(2893,'Second, try to disable all non-X-Cart modules by using the links below:'),(4699,'Secret Access Key'),(4328,'Secret Word'),(2114,'Secret key'),(4677,'Secret key (test mode)'),(2099,'Secret word'),(237,'Secure Checkout'),(1156,'Secure connection cannot be established.'),(2304,'Secure credit card payment'),(1157,'Security'),(2312,'Security code'),(2470,'Security issue'),(1158,'Security settings'),(183,'See all items in the cart'),(1829,'See comparison chart'),(4469,'See how'),(2174,'See log file for details'),(4300,'See the tutorials and documentation about X-Cart store customization.'),(4054,'Segment condition'),(314,'Select a country or a state from a list, specify the zone'),(1750,'Select all'),(4047,'Select box'),(1159,'Select country'),(115,'Select file'),(4527,'Select issuer'),(122,'Select language'),(2817,'Select language to edit'),(248,'Select one'),(1160,'Select options'),(1866,'Select products from the list'),(1161,'Select status'),(3765,'Select the review that should be included into the rich snippet shown for the page of this product when the page appears in search results by Google and other major search engines'),(3279,'Select type'),(4064,'Selected by default'),(769,'Selected countries'),(768,'Selected countries:'),(3757,'Selected reviews have been deleted'),(3759,'Selected reviews have been updated'),(771,'Selected states'),(4218,'Selected tags have been deleted'),(378,'Selected:'),(1713,'Semicolon'),(1162,'Send'),(3303,'Send a message'),(2999,'Send reset link'),(1163,'Send test email'),(1191,'Send tracking info'),(2818,'Separate box'),(1165,'Service name'),(1166,'Service name of address field'),(1167,'Set'),(2510,'Set a single discount or add multiple volume discounts.'),(2508,'Set absolute or %-based discount rates;'),(4274,'Set flat shipping rates for your store'),(4689,'Set the Response Method setting to Sent to your server as a POST.'),(1168,'Set the sale price'),(167,'Set this language as default for customer zone'),(4290,'Set up offline & online payments'),(4226,'Set up payment gateways'),(4271,'Set up shipping'),(4225,'Set up shipping methods'),(4266,'Set your company info'),(3201,'Setting up Canadian taxes'),(3199,'Setting up VAT / GST'),(3200,'Setting up sales tax'),(3202,'Setting up tax classes'),(1169,'Settings'),(1170,'Setup _address zones_ and _taxes_'),(4739,'Setup instruction'),(2194,'Setup store price: X'),(3522,'Shape'),(3420,'Share'),(2665,'Ship QTY'),(4402,'Ship date'),(1569,'Ship in a separate box'),(2663,'Ship to'),(4547,'Shipment ID'),(4370,'Shipment Id'),(4603,'Shipment cannot be created'),(4608,'Shipment cannot be transmitted'),(4605,'Shipment cannot be voided'),(4369,'Shipment has been created successfully'),(4602,'Shipment has been created with errors'),(4606,'Shipment has been tranmitted with errors'),(4607,'Shipment has been transmitted successfully'),(4368,'Shipment has been voided successfully'),(4604,'Shipment has been voided with errors'),(4546,'Shipment info'),(2077,'Shipment options'),(4548,'Shipment status'),(4609,'Shipments'),(4640,'Shipments pick up type'),(372,'Shipped'),(3608,'Shipping'),(1171,'Shipping & Taxes'),(1320,'Shipping / Payment info'),(1172,'Shipping address'),(1844,'Shipping address is invalid'),(1173,'Shipping address is not completly defined yet'),(1174,'Shipping address is not defined'),(1175,'Shipping address is not defined yet'),(2592,'Shipping charge based on a percentage of the order subtotal.'),(1551,'Shipping charges'),(64,'Shipping cost'),(3932,'Shipping freight'),(3935,'Shipping freight + regular shipping rate'),(3934,'Shipping freight only'),(3936,'Shipping freight tooltip text'),(1677,'Shipping has been calculated based on the following split of the products into packages:'),(1176,'Shipping info'),(4372,'Shipping label'),(4390,'Shipping label sender signature'),(1177,'Shipping markup has been created successfully'),(1178,'Shipping markups have been updated'),(1179,'Shipping method'),(2819,'Shipping method / cost'),(1180,'Shipping method has been added'),(3280,'Shipping method is disabled'),(3281,'Shipping method is enabled'),(2556,'Shipping method is not configured.'),(2567,'Shipping method name'),(1181,'Shipping methods'),(1182,'Shipping methods are not available'),(187,'Shipping methods have been updated'),(3282,'Shipping order status'),(1543,'Shipping rate cannot be added'),(1542,'Shipping rate has been added successfully'),(1183,'Shipping rates'),(2588,'Shipping rates are calculated by the following formula:'),(1184,'Shipping settings'),(2646,'Shipping solutions'),(2127,'Shipping status'),(2916,'Shipping status not found, \"New\" will be used for order'),(4132,'Shipping status not found, new status will be created'),(4126,'Shipping statuses'),(2880,'Shipping to'),(1185,'Shipping zones'),(3789,'Shopper approved promo'),(1199,'Shopping bag'),(3667,'Shopping options'),(400,'Shortcuts'),(2031,'Show'),(4672,'Show \"How to use\" instruction'),(101,'Show Category title'),(3465,'Show above products'),(3838,'Show all'),(117,'Show all labels'),(3671,'Show all products in this category'),(4429,'Show all saved credit cards'),(2717,'Show all warnings/errors'),(3466,'Show below products'),(3629,'Show default menu along with the custom one'),(3305,'Show email as text'),(219,'Show filter options'),(2820,'Show in all the sections'),(2714,'Show low stock warning on product page'),(2785,'Show object name in page title'),(2821,'Show only in categories and search listings'),(3523,'Show payment card icons'),(3668,'Show products'),(2992,'Show products with no assigned category'),(1200,'Show social buttons'),(3059,'Show states for selected countries only'),(4194,'Show vendor’s products in the order'),(2822,'Show:'),(2323,'Sign Up'),(3476,'Sign Up Now'),(1201,'Sign in'),(2875,'Sign in / sign up'),(1202,'Sign out'),(4086,'Sign up for <Company name> news, sales and deals'),(4740,'Sign up for Authorize.net'),(3153,'Sign up for TaxJar'),(4085,'Sign up for news and updates from your favorite store. Be the first to know about exclusive sales, offers and deals.'),(3979,'Sign up for {{companyName}} news'),(2866,'Signature'),(4313,'Signature  key'),(4323,'Signature key'),(36,'Simplify tax compilance process and reduce the sales tax audit risk with AvaTax Sales Tax Automation'),(1722,'Single quote'),(3639,'Site map has not been registred in X'),(3640,'Site map successfully registred on X'),(4641,'Site number of the deposit location'),(3944,'Sitemap'),(3645,'Sitemap generation has been completed successfully.'),(3646,'Sitemap generation has been stopped.'),(3644,'Sitemap generation...'),(1203,'Size'),(4273,'Skip Shipping Step'),(4230,'Skip this step'),(3283,'Skipped'),(4327,'Skrill Customer ID'),(4334,'Skrill Quick Checkout description'),(4332,'Skrill settings'),(2823,'Soft and Hard reset links for your store'),(3284,'Soft and hard reset links for your store'),(1774,'Soft reset (disables all modules except ones that were downloaded from marketplace)'),(2894,'Soft reset. Turn off all addons except those provided by X-Cart Team & Qualiteam'),(3549,'Sold'),(3559,'Sold PINs'),(3825,'Some'),(1744,'Some files are modified'),(4156,'Some files haven`t been attached'),(3848,'Some flexy-templates cannot be removed. Please correct file permissions or remove them manually'),(2445,'Some of these updates are not available for you at the moment.'),(4289,'Some people simply prefer to place their orders by phone — let them do that.'),(287,'Some products could have been imported incorrectly'),(4522,'Something wrong in the iDEAL payment module settings. Please try later or use other payment option.'),(3352,'Sorry, the coupon has expired'),(3353,'Sorry, the coupon use limit has been reached'),(3354,'Sorry, the coupon you entered cannot be applied to the items in your cart'),(3351,'Sorry, the coupon you entered is invalid. Make sure the coupon code is spelled correctly'),(3355,'Sorry, the coupon you entered is not valid for your membership level. Contact the administrator'),(3348,'Sorry, this coupon cannot be combined with the coupon already applied. Revome the previously applied coupon and try again.'),(2657,'Sorry, your order cannot be placed as there are no shipping methods available.'),(1807,'Sorry, your order payment is canceled.'),(1808,'Sorry, your order payment is failed.'),(3285,'Sort'),(255,'Sort by'),(2824,'Sort by:'),(2825,'Sort settings'),(2350,'Sorting & Descriptions'),(2055,'Source address'),(2008,'Space'),(4377,'Special services'),(452,'Specification'),(3183,'Specify email address'),(4424,'Specify the URL of your X-Payments installation. Copy and paste Store ID, Public key, Private key and Private key password from X-Payments Online Store Details page.'),(1209,'Specify your _store information_'),(2826,'Specify your _store information_\', {\'URL\': url(\'settings\', \''),(1210,'Speed up your store'),(2211,'Staff note'),(2640,'Stamps.com'),(2515,'Standard'),(2903,'Start'),(1628,'Start Export'),(4468,'Start FREE Trial'),(1518,'Start Import'),(3442,'Start accepting Express Checkout payments immediately by simply plugging in the email address where you would like to receive payments.'),(1812,'Start date'),(1211,'Start selling!'),(3714,'Start typing customer email or name'),(3712,'Start typing product name or SKU'),(1212,'State'),(1506,'State cannot be created with unknown country code X'),(1213,'States'),(1214,'States have been deleted successfully'),(1215,'States have been updated successfully'),(2179,'States information has been successfully deleted'),(4056,'Static'),(1216,'Statistics'),(1217,'Status'),(3197,'Status comment (reason)'),(2415,'Status is not defined'),(4665,'Status: Connected'),(357,'Steps to complete your store for real sales'),(1938,'Stock'),(3286,'Store ID'),(1218,'Store Maintenance'),(1219,'Store currency'),(1220,'Store info'),(1221,'Store is closed'),(1222,'Store is open'),(1757,'Store lifetime'),(1223,'Store setup'),(1224,'Storefront'),(1945,'Storefront is closed'),(1947,'Storefront is open'),(4000,'Street address'),(143,'Subcat'),(1225,'Subcategories'),(367,'Subcategories for'),(1226,'Subject'),(3623,'Submenu'),(58,'Submit'),(2874,'Subscribe'),(4082,'Subscribe by default'),(4045,'Subscribe to our news list and be in touch with our latest offers.'),(3985,'Subscriber with email {{email}} already subscribed'),(3981,'Subscribers'),(3984,'Subscribers imported'),(4044,'Subscription'),(1227,'Substring'),(66,'Subtotal'),(4343,'Subtotal + Shipping cost'),(2574,'Subtotal range'),(1228,'Subtotal range (begin)'),(1229,'Subtotal range (end)'),(1675,'Success'),(2690,'Success[S]'),(4107,'Successfully authenticated'),(1230,'Successfully imported X new products'),(1231,'Successfully imported X new products and upgraded Y old products'),(1232,'Successfully upgraded Y old products'),(1233,'Suffix'),(127,'Suggest an idea'),(3897,'Suggested retail rates'),(3287,'Sunday'),(1516,'Support'),(3129,'Surcharges'),(2957,'Switch to Category search'),(2956,'Switch to Category tree'),(2888,'Switcher NO'),(2887,'Switcher YES'),(1234,'Synchronous'),(3108,'System logs'),(1235,'System settings'),(4130,'System status tooltip'),(3107,'System tools'),(1861,'System will download and install this module from marketplace. Continue?'),(384,'TH'),(382,'TU'),(1714,'Tab'),(3666,'Tab displaying comments about the product. Added by the addons VK/GoSocial/Disqus'),(3786,'Tab displaying product reviews. Added by the addon Product Reviews'),(3665,'Tab displaying the product\'s attributes and other details. Added by the X-Cart core'),(3664,'Tab displaying the product\'s detailed description. Added by the X-Cart core'),(1236,'Table'),(2568,'Table based on'),(3648,'Tabs'),(3654,'Tabs imported'),(4214,'Tag'),(3878,'Tag Manager Dashboard'),(5,'Tags'),(2236,'Tags are not allowed in the column \"{{column}}\" and will be stripped'),(67,'Tax'),(4032,'Tax Class'),(1574,'Tax class'),(1898,'Tax classes'),(1237,'Tax disabled'),(1238,'Tax enabled'),(1239,'Tax has been disabled successfully'),(1240,'Tax has been enabled successfully'),(1242,'Tax rate has been deleted successfully'),(1243,'Tax rate has not been deleted successfully'),(4345,'Tax rates for shipping charges have not yet been created.'),(1241,'Tax rates have been updated successfully'),(4346,'Tax rates have not yet been created.'),(4347,'Tax rates on shipping cost'),(1244,'Tax title'),(3156,'TaxJar Category'),(3155,'TaxJar Dashboard'),(3152,'TaxJar enabled'),(4344,'Taxable base'),(1245,'Taxes'),(1246,'Teaser'),(3799,'Template'),(3820,'Template editor'),(3842,'Template is converted'),(3620,'Terms and conditions'),(1504,'Terms and conditions text'),(2004,'Test'),(4566,'Test Canada Post rates calculation'),(3288,'Test e-mail have been successfully sent'),(1247,'Test email configuration'),(1766,'Test email notification'),(1767,'Test email notification:'),(2079,'Test mode'),(2189,'Test mode: Live'),(2188,'Test mode: Test'),(2598,'Test rates'),(1248,'Test shipping rates'),(4433,'Test transaction completed successfully'),(4443,'Test transaction completed successfully for API version X'),(4434,'Test transaction failed. Please check the X-Payment Connector settings and try again. If all options is ok review your X-Payments settings and make sure you have properly defined shopping cart properties.'),(2088,'Test/Live mode'),(2737,'Test[TT]'),(1249,'Tester'),(1250,'Text'),(87,'Text labels have been deleted'),(83,'Text labels have been updated successfully'),(88,'Text labels have not been deleted: no text labels have been found or specified'),(85,'Text labels have not been updated successfully: the default application language has been set as the translation language'),(86,'Text labels have not been updated successfully: the translation language has not been found'),(84,'Text labels have not been updated successfully: the translation language has not been specified'),(3599,'Text links'),(3780,'Text of response'),(3715,'Text of review'),(1932,'Textarea'),(266,'Thank you for registering a customer account, your profile has been created successfully'),(3980,'Thank you for subscribing to the newsletter! We hope you enjoy shopping at {{companyName}}'),(216,'Thank you for using company services'),(1251,'Thank you for your order'),(318,'Thank you for your order FOOTER'),(3721,'Thank your for sharing your opinion with us!'),(4360,'The \"Approved URL\" value must be exact as this'),(4693,'The \"Pay With Amazon\" feature is not configured and cannot be used.'),(4694,'The \"Pay with Amazon\" feature requires https to be properly set up for your store.'),(4359,'The \"Pricing currency\" value must be exactly the same as on it.'),(2846,'The \"{{file}}\" file is not allowed and was not uploaded. Allowed extensions are: {{extensions}}'),(3622,'The \"{{file}}\" file is not allowed image and was not uploaded. Allowed images are: {{extensions}}'),(1835,'The \"{{file}}\" file was not uploaded'),(1873,'The \"{{file}}\" is not CSV or archive'),(2233,'The \"{{value}}\" category does not exist'),(2267,'The \"{{value}}\" group is not created'),(2231,'The \"{{value}}\" image does not exist'),(2228,'The \"{{value}}\" membership does not exist'),(2229,'The \"{{value}}\" product class does not exist'),(2230,'The \"{{value}}\" tax class does not exist'),(3626,'The AppleIcon image could not be uploaded (Unallowed image type. Must be a .png image with the resolution of 192x192 px)'),(4687,'The Approved URL value must be exact as this:'),(3289,'The Clean URL entered has unallowed chars.'),(2454,'The Clean URL entered is a redirect to object.'),(2769,'The Clean URL entered is already in use by target alias.'),(2453,'The Clean URL entered is already in use.'),(4688,'The Declined URL value must be exact as this:'),(2118,'The English language cannot be removed as it is primary language for all texts.'),(1266,'The HTTPS protocol is enabled for your website'),(1252,'The SSL certificate installed for your custom website domain is not valid.'),(1253,'The SSL certificate installed on your server is not valid. Although you can switch the store to use the secure protocol for the website pages, most Internet browsers will likely display a warning message scaring your website visitors away.'),(4686,'The Store ID and HPP Key value must be exactly the same as on it.'),(290,'The X field is empty'),(1254,'The X language has been added and enabled successfully'),(76,'The X language has been added successfully'),(78,'The X language has been deleted successfully'),(81,'The X language has been disabled successfully'),(82,'The X language has been enabled successfully'),(177,'The X module has been installed incorrectly. Please see the logs for more information'),(175,'The X module has been installed successfully'),(176,'The X module has been installed with errors: the DB has not been modified correctly'),(178,'The X module has been installed, but the module has a wrong module control class'),(1956,'The address field has been added'),(1955,'The address field has been updated'),(1255,'The attachment has been added successfully'),(3401,'The attachment has been successfully re-upload'),(1950,'The attribute group has been added'),(1949,'The attribute group has been updated'),(1958,'The attribute has been added'),(1957,'The attribute has been updated'),(1952,'The attribute option has been added'),(1951,'The attribute option has been updated'),(215,'The benchmark evaluates server environment'),(2330,'The body template may include other templates to generate the email notification. To customize it, please, copy appropriate templates to \"skins/theme_tweaker/mail/\"'),(2195,'The button is inactive either because no changes have been detected on the current page or because the order totals need to be recalculated before the order can be updated.'),(2696,'The calculation completed'),(2695,'The calculation failed'),(2488,'The calculation of quick data has been completed successfully.'),(2489,'The calculation of quick data has been stopped.'),(1954,'The category has been added'),(1953,'The category has been updated'),(1256,'The changes will be applied to all selected products'),(2455,'The clean URL will be generated automatically.'),(2422,'The common notification fields has been updated'),(4213,'The comparison table has been cleared.'),(217,'The confirmation URL link was mailed to email'),(2135,'The confirmation URL link will be emailed to you shortly'),(2945,'The core may be checked only if a valid license key is present.'),(2759,'The count of categories specified for a product and the count of orderBy position numbers describing the position of the product within these categories must be the same.'),(1879,'The countries list for zone is empty. Please specify it.'),(2890,'The countries to which the selected states belong will be added to the zone automatically.'),(3325,'The coupon has been added'),(3318,'The coupon has been applied to your order'),(3326,'The coupon has been updated'),(1889,'The database has not been restored because of the errors'),(3791,'The database stores different version of the custom changes.'),(80,'The default interface language cannot be disabled'),(1257,'The detailed image has been added successfully'),(1258,'The detailed image has been deleted'),(1899,'The detailed image has not been deleted'),(1259,'The detailed images have been updated successfully'),(1568,'The directory \'var/backup/\' does not exist or is not writable.'),(3811,'The directory {{dir}} does not exist or is not writable.'),(3324,'The discount should be less than 100%'),(4182,'The dispute has been closed'),(2656,'The download should start automatically. Click the link if does not start.'),(95,'The edited language has not been found'),(218,'The email with your account information was mailed to email'),(1260,'The exceptions have been updated successfully'),(1775,'The export is complete.'),(4169,'The field Body may not be blank'),(2616,'The file extension is forbidden'),(2748,'The file extension is forbidden ({{file}}'),(307,'The file was not loaded because of a failure on the server'),(1897,'The file was not loaded because of a failure on the server.'),(3810,'The file {{file}} does not exist or is not writable.'),(4144,'The files have been attached successfully'),(1262,'The following add-on(s) must be disabled'),(1261,'The following add-on(s) must be enabled'),(1263,'The following categories were selected to be removed'),(1264,'The following dependent add-ons will be disabled  automatically'),(1510,'The following expected input data have wrong format or empty: X'),(1627,'The following files are too large to be included in the archive'),(2355,'The following modules currently do not have a version compatible with the X-Cart version to which you are upgrading'),(154,'The following modules will be disabled'),(2384,'The following selected modules cannot be disabled due to architecture limitations'),(2381,'The following selected modules cannot be disabled or uninstalled as they have dependent modules'),(2382,'The following selected modules cannot be enabled as they depend on disabled modules which cannot be enabled'),(1865,'The form could not be identified as a form generated by X-Cart'),(1963,'The front page has been updated'),(2376,'The generation of resized images has been completed successfully.'),(2377,'The generation of resized images has been stopped.'),(3385,'The history of downloads feature for this product is disabled. You can enable it here'),(1265,'The image has been updated'),(2378,'The image resizing process may take a while to complete. Please do not close this page until the process is fully completed.'),(1267,'The import is in progress'),(2993,'The import process has been canceled'),(1268,'The importing starts immediately upon selecting the data file. No additional confirmation prompts will appear.'),(2444,'The key does not allow getting new features and upgrades.'),(1601,'The language CSV file should be a text file which contains 3 columns per row (columns are separated by comma:'),(96,'The language data has been saved'),(79,'The language has not been found'),(1595,'The language labels have been successfully imported:'),(75,'The language you want to add has already been added'),(74,'The language you want to add has not been found'),(77,'The language you want to delete has not been found'),(1269,'The language you want to delete is the default application language and cannot be deleted'),(1270,'The language you want to delete is the default interface language and cannot be deleted'),(3309,'The length of X field must be greater than Y'),(3310,'The length of X field must be less than Y'),(2238,'The length of value for the column \"{{column}}\" exceeds length of field and will be cut'),(71,'The link was copied to your clipboard'),(97,'The maximum file size that can be uploaded: X'),(1271,'The maximum number of uses'),(3356,'The maximum number of uses per user'),(1715,'The membership name cannot contain such symbols as \\, \' and \". Also, it cannot exceed 32 characters.'),(3613,'The menu has been added'),(3612,'The menu has been updated'),(1842,'The method is not configured and cannot be used'),(1492,'The module X has been uninstalled successfully'),(1272,'The module has been partially uninstalled'),(174,'The module has been uninstalled successfully'),(1740,'The module is incompatible with the new core version going to be installed'),(1273,'The module is not released for your X-Cart version'),(2946,'The module may be checked only if a valid license key is present.'),(2383,'The module may not be disabled due to the limitations of the module architecture.'),(173,'The module to uninstall has not been found'),(2124,'The module version is incompatible with your core version and cannot be enabled. Minimum core version required for this module is X.'),(2123,'The module version is incompatible with your core version and cannot be installed. Minimum core version required for this module is X.'),(179,'The modules have been updated'),(2257,'The name is empty'),(3098,'The name will be changed globally'),(4247,'The newly created product is already in your [storefront]. Have a look! Ready to delete demo products?'),(3921,'The news message has been added'),(3920,'The news message has been updated'),(2423,'The notification has been updated'),(2235,'The number of values in the row does not match the number of column headers for this CSV file'),(1843,'The only remaining active administrator profile cannot be deleted.'),(1942,'The order subtotal exceeds the maximum allowed value ({{max_order_amount}})'),(1992,'The order subtotal exceeds the maximum allowed value ({{max_order_amount}}), please remove some items from the cart.'),(1943,'The order subtotal less than the minimum allowed value ({{min_order_amount}})'),(1993,'The order subtotal less than the minimum allowed value ({{min_order_amount}}), please add some items to the cart.'),(1274,'The page has been added'),(3614,'The page has been updated'),(1763,'The password is the one you specified during checkout.'),(1764,'The password is the one you specified.'),(362,'The process of export is complete. You can follow this_link to check the results and download the files containing data.'),(1638,'The process of export may take much time. Please do not close this page until the export is complete'),(1637,'The process of export may take much time. You may close the page, the operation will be in progress as background. If the operation takes long enough, we will send you a notification when it is complete.'),(1531,'The process of import may take much time. Please do not close this page until the import is complete'),(1530,'The process of import may take much time. You may close the page, the operation will be in progress as background. If the operation takes long enough, we will send you a notification when it is complete.'),(2487,'The process of quick data calculation may take a while to complete. Please do not close this page until the process is fully completed.'),(2697,'The process of sales calculation may take a while to complete. Please do not close this page until the process is fully completed.'),(3647,'The process of sitemap generation may take a while to complete. Please do not close this page until the process is fully completed.'),(3905,'The product SKU#\"X\" is already set as Related for the product'),(2074,'The product SKU#\"X\" is already set as featured for the category'),(3902,'The product SKU#\"X\" is already set as related for the product'),(1960,'The product class has been added'),(1959,'The product class has been updated'),(3689,'The product filter cache has been removed successfully.'),(2615,'The product for which you attempted to upload an attachment has not been found'),(2424,'The product has been added'),(4212,'The product has been added to the comparison table'),(4211,'The product has been removed from comparison table'),(2175,'The product has been updated'),(1275,'The product option group has been added successfully'),(1276,'The product option group has been updated successfully'),(1277,'The product option groups have been updated successfully'),(1278,'The product option groups have not been successfully updated'),(1962,'The product selection has been added'),(1961,'The product selection has been updated'),(3652,'The product tab has been added'),(3651,'The product tab has been updated'),(2227,'The product with \"{{value}}\" SKU does not exist'),(2997,'The product you are trying to add to cart is unavailable'),(3384,'The product\'s history of downloads is empty'),(4611,'The products return has been registered.'),(1503,'The profile has been registered. The password has been sent to the user\'s email address'),(1502,'The profiles have been merged'),(1594,'The provided file contains the following language labels:'),(4454,'The related payment not found. Apparently it was deleted.'),(1279,'The requested page could not be found.'),(1280,'The restoration procedure is irreversible and erases all data tables from your store database. It is highly recommended that you back your present database data up before restoring one of the previous states from a back-up.'),(3631,'The role has been added'),(3630,'The role has been updated'),(1281,'The same as shipping'),(3400,'The same file can not be assigned to one product'),(1982,'The script found {{number}} errors during import'),(3956,'The script found {{number}} errors during update inventory'),(1981,'The script found {{number}} errors during verification'),(2827,'The secure protocol for your website is disabled.'),(2828,'The secure protocol for your website is enabled.'),(2532,'The secure protocol is enabled for your website. But X-Cart hasn\'t found the valid SSL certificate on your server.'),(2991,'The selected categories have been deleted. There are products with no assigned category.'),(1864,'The selected payment method is obsolete or invalid. Select another payment method'),(1282,'The selected shipping markups have been deleted successfully'),(186,'The selected shipping method has been deleted successfully'),(188,'The selected zones have been deleted successfully'),(2190,'The service name X is reserved and cannot be used for an address field.'),(2867,'The settings in this section determine the content of email notifications sent to admin.'),(2864,'The settings in this section determine the content of email notifications sent to customer.'),(1872,'The settings of payment method successfully updated'),(2197,'The specified amount of product exceeds maximum amount of product in stock'),(1283,'The state has been added successfully'),(283,'The string is different from that of the title number of columns - X instead of Y'),(2398,'The system detects that some updates are available for enabled modules. It is strongly recommended to have all enabled modules updated to latest version for better compatibility before the install new ones from Marketplace.'),(2511,'The system has been restored to the selected snapshot of X'),(2674,'The system has detected one or more problems with some of the modules at your store:'),(1745,'The system has detected that some custom modifications were made by editing core and module files, not by writing new modules. In order to proceed with the upgrade you should decide what to do with the modifications'),(2682,'The system has detected that the license key that was activated for your store is invalid.'),(2512,'The system has failed to restore because there was no snapshot of X'),(1966,'The tax class has been added'),(1965,'The tax class has been updated'),(3805,'The template has been added'),(3804,'The template has been updated'),(3860,'The test email notification has been sent to X'),(93,'The text label has been added successfully'),(89,'The text label has been deleted'),(94,'The text label has been modified successfully'),(91,'The text label has not been added, because its name has not been specified'),(1284,'The text label has not been added, because its translation to the default application language has not been specified'),(1285,'The text label has not been added, because its translation to the default interface language has not been specified'),(92,'The text label has not been added, because such a text label already exists'),(90,'The text label has not been deleted: it has been either not found or not specified'),(1286,'The text label has not been modified, because its translation to the default application language has not been specified'),(1287,'The text label has not been modified, because its translation to the default interface language has not been specified'),(3099,'The totals have been recalculated. Press \"Save changes\" to adjust the order'),(4450,'The transaction will be marked as'),(1288,'The upgrade is completed. Please, do not close this page until you check your web site and check that everything works properly'),(4231,'The uploaded image is too large.'),(226,'The user will be registered; a password will be sent to the user via email'),(2237,'The value in the column \"{{column}}\" will be adjusted according to HTML specification to prevent potential XSS attack'),(2722,'The value must be greater than the current maximum order number in the order list'),(1718,'The value must be in range'),(293,'The value of the X field has an incorrect format'),(291,'The value of the X field must be greater than Y'),(292,'The value of the X field must be less than Y'),(294,'The value of the X field should not be longer than Y'),(1548,'The values are average'),(3795,'Theme tweaker'),(3131,'There are %model% with missing %another_model%'),(3130,'There are %model% without valid %another_model% relation'),(2476,'There are no activated license keys'),(1289,'There are no categories'),(3768,'There are no comments yet. Be the first to leave a comment'),(1575,'There are no images loaded for this product'),(3139,'There are no inconsistencies found'),(1507,'There are no labels translated to X'),(1290,'There are no markups selected'),(4435,'There are no payment configurations for this store.'),(2751,'There are no permissions to import user access level'),(2753,'There are no permissions to import user roles'),(1291,'There are no rates available for specified source/destination and/or package measurements/weight.'),(1802,'There are no shipping methods available'),(1650,'There are no shipping methods defined for this carrier'),(3832,'There are some custom CSS styles in your store. These styles may affect the look of the installed template. Review the custom styles and disable them if necessary.'),(3833,'There are some custom templates in your store that may contain skin dependent code.'),(2530,'There are unsaved changes on the page. If you choose to continue, these changes will be lost. Do you want to proceed?'),(1187,'There is a maximum purchase limit of MaxQuantity'),(1186,'There is a minimum purchase limit of MinQuantity'),(198,'There is already an account with your email address. You can sign in or continue as guest'),(2885,'There is already state with code {{code}} in {{country}}'),(3316,'There is no such a coupon, please check the spelling: X'),(1293,'There is no user with specified email address'),(3136,'There is one valid root category, however there are multiple root category candidates'),(1294,'There were no orders placed'),(4721,'There were problems with the payment method.'),(431,'There\'s no payment method available'),(4536,'There\'s no post offices available'),(3416,'These Open Graph meta tags were generated automatically based on general product information.'),(1998,'These attributes can be applied to all the products in the store.'),(1996,'These attributes can be applied to the \"{{name}}\" product class.'),(1997,'These attributes can only be applied to this particular product.'),(1295,'These components require your attention'),(1296,'These components will be updated'),(1297,'These instructions will appear below the order invoice on the page which customers see after they confirm their order.'),(1298,'These links were already provided to you after this store was installed and will be emailed to you again after you start the upgrade process'),(2034,'These links were already provided to you after this store was installed and will be emailed to you again after you start the upgrade process.'),(2787,'These options separated by X, you can change it by modify X label'),(4407,'These payment methods were imported from your X-Payments. You can add them to your store at the '),(3850,'This action will remove all flexy-templates. Are you sure to proceed?'),(1820,'This address was used as a'),(1300,'This address was used as a billing address during the recent purchase'),(1301,'This address was used as a shipping address during the recent purchase'),(3338,'This comment will be visible to shop administrators only'),(1302,'This component is automatically calculated by shipping add-on module and cannot be edited'),(3347,'This coupon cannot be combined with other coupons'),(1303,'This e-mail address is already in use by another user.'),(1304,'This email address is used for an existing account. Enter another email address or sign in'),(2462,'This feature is available only for paid (non-free) X-Cart license plans'),(4031,'This feature is not yet available. You will be redirected to the feature request page where you can vote to have this feature implemented in one of the upcoming versions.'),(3933,'This field can be used to set a fixed shipping fee for the product. Make sure the field value is a positive number (greater than zero).'),(210,'This field is required'),(3296,'This field is required.'),(1305,'This is a default zone which covers all addresses. It\'s impossible to edit this zone\'s countries, states etc'),(243,'This is a demo store with powerful X-Cart engine inside'),(4389,'This is a user specified message that gets printed on the bottom of the label. A string of up to 50 characters can be printed on the label.'),(4387,'This is a user specified message that gets printed on the face of the label. A string of up to 50 characters can be printed on the label.'),(3429,'This is the login name you created when signing up for PayPal Payments Advanced.'),(3436,'This is the login name you created when signing up for Payflow.'),(3437,'This is the password you created when signing up for PayPal Payflow or the password you created for API calls.'),(3431,'This is the password you created when signing up for PayPal Payments Advanced or the password you created for API calls.'),(428,'This language is added by module and cannot be removed.'),(3067,'This message can be removed only through activation of a free or premium license.'),(1645,'This method does not support the current store currency and is not available for customers'),(2699,'This method is displayed because you are logged in as admin and operating as another user'),(1646,'This method is in test mode'),(342,'This module is available for X-Cart hosted stores only.'),(2050,'This module uses PHP\'s cURL functions which are disabled on your web server'),(1306,'This month'),(1798,'This operation is irreversible. Are you sure you want to proceed?'),(4732,'This operation will cancel order. Payment authorization will be voided. Please confirm to proceed.'),(4733,'This operation will capture funds from customer. Please confirm to proceed.'),(4734,'This operation will refund funds to customer. Please confirm to proceed.'),(4330,'This options is relevant only if you share your Skrill account with other online shops.'),(2829,'This order was not checked by the AntiFraud service!'),(2341,'This page allows you to adjust the types of email notifications your store sends to users'),(1550,'This page allows you to configure Shipping methods, zones and charges.'),(1557,'This page allows you to edit global attributes, which are available for all products in your store, and attributes specific for classes of your products.'),(2502,'This page is intended for the creation and management of discount coupons.'),(2507,'This page is intended for the management of volume discounts based on the order subtotal.'),(1648,'This payment method cannot be enabled until you configure it'),(3290,'This payment method is'),(2318,'This payment method is Active.'),(2319,'This payment method is Inactive.'),(2830,'This payment method is not configured.'),(2898,'This process may take much time. Please do not close this page until the task is complete'),(191,'This product has been added to your bag'),(61,'This product is out of stock or it has been disabled for sale'),(3592,'This product will be shown in coming soon section'),(3591,'This product will be shown in new arrivals'),(1313,'This quarter'),(1309,'This section displays 10 top-selling products for today, this week and this month'),(1310,'This section displays order placement statistics'),(1546,'This section displays order processing statistics'),(3455,'This setting determines whether or not the \"Buy Now with PayPal\" button should be displayed on product list pages (in list view) and product details pages.'),(2600,'This shipping method is'),(2601,'This shipping method is not configured.'),(3435,'This should be the same partner name that is used when logging into your PayPal Payflow account.'),(1311,'This site requires JavaScript to function properly.'),(2497,'This tool allows you to get rid of any content that might have been created in your store for testing purposes and which you no longer need.'),(199,'This user name is used for an existing account. Enter another user name or sign in'),(4352,'This value must be set in exactly the same way as it is set on the payment gateway end.'),(1312,'This week'),(363,'This will increase the shipping cost by XX'),(1314,'This year'),(2225,'Three columns'),(1315,'Through'),(1316,'Thumbnail'),(2831,'Time left'),(1430,'Timeout error'),(1317,'Title'),(33,'To activate your X-Cart license, enter your secret key into the field below and click Activate.'),(34,'To activate your X-Cart or commercial module license, enter your license key into the field below and click Activate.'),(4412,'To be able to use the payment methods defined in X-Payments you should import information about them from X-Payments. Click the button below and X-Payments will return a list of payment methods available for this shopping cart.'),(295,'To boost your sales try to use Discounts coupons, Sale, Product Advisor, Volume discounts addons. Also you may be interested in all Marketing extensions from our Marketplace'),(1770,'To change the password, log into your company account and use the \'Modify profile\' link'),(1609,'To change the roles of your profile, contact the store administrator'),(1321,'To contact us please fill the form below'),(1422,'To continue, please, sign in'),(1322,'To email'),(356,'To enable secure protocol for your website pages you need a valid SSL certificate purchased for the website domain and installed on your server.'),(3491,'To enable this payment method, you need <Multi-vendor> module installed.'),(3490,'To enable this payment method, you need Multi-vendor module installed.'),(297,'To fix this problem, do the following: 3 points'),(280,'To get the format of the import data you can export your products to a file'),(1556,'To have attributes specific for product classes, define product classes first.'),(355,'To make the online store use the secure protocol you need an SSL certificate purchased for the website domain and installed on your server.'),(2525,'To make your changes visible in the customer area, cache rebuild is required. It will take several seconds. You don’t need to close the storefront, the operation is executed in the background.'),(3977,'To move your existing subscribers to MailChimp lists, <export your subscribers data> from X-Cart and use the import feature under your MailChimp account.'),(1323,'To place the order please accept Terms and Conditions'),(1324,'To place the order please complete the previous steps first'),(4333,'To process your customers\' payments with Skrill, you need a Skrill account. If you do not have one yet, you can sign up for free at http://www.skrill.com'),(1325,'To recover your password, please type in the valid e-mail address you use as a login'),(4532,'To request a return please fill the form below'),(3157,'To send email asynchronously and improve website performance we recommend to set up queues in on your server. [Learn how to do it].'),(4356,'To set up the integration you should follow '),(4685,'To set up the integration, go to the _Site management_'),(35,'To setup Tax Rates, find and install the appropriate addons from Marketplace'),(2832,'To setup Tax Rates, find and install the appropriate addons from Marketplace\', {\'url\': url(\'addons_list_marketplace\', \'\', {\'tag\': \'Taxes'),(4570,'To start registration process for Canada Post merchant account click on the \"Register\" button.'),(3330,'To use the coupon, your order subtotal must be at least X'),(3329,'To use the coupon, your order subtotal must be between X and Y'),(3331,'To use the coupon, your order subtotal must not exceed Y'),(1326,'Today'),(3637,'Too large value for absolute discount'),(2685,'Tools'),(3916,'Top News'),(213,'Top X products'),(103,'Top banner'),(1327,'Top sellers'),(1328,'Top selling products'),(231,'Total'),(4051,'Total amount of orders'),(4555,'Total items weight'),(4594,'Total weight'),(1776,'Totals'),(1190,'Track package'),(4599,'Tracking details'),(1198,'Tracking information has been sent'),(4367,'Tracking information was updated successfully'),(2421,'Tracking number'),(1196,'Tracking number is changed from \"{{old_number}}\" to \"{{new_number}}\"'),(1193,'Tracking numbers'),(4549,'Tracking pin'),(4537,'Tracking pins'),(3411,'Traditional'),(2426,'Transaction'),(2833,'Transaction ID'),(2093,'Transaction amount mismatch'),(3176,'Transaction is in progress'),(4312,'Transaction key'),(4453,'Transaction result'),(2063,'Transaction type'),(2648,'Transactions details'),(1329,'Translation driver'),(129,'Translations'),(4590,'Transmit shipment'),(3083,'Trial has expired!'),(326,'Trial period X days'),(2000,'Trial period expires today'),(1999,'Trial period is expired'),(4122,'Try clearing filters or different search terms.'),(1796,'Try search-as-you-type feature...'),(1862,'Try to change the search criteria or find the needed solution in marketplace'),(2834,'Try to change the search criteria or find the needed solution in marketplace\', {\'URL\': url(\'addons_list_marketplace\', \'\', {\'tag\': \'Payment processing'),(1863,'Try to search worldwide or find the needed solution in marketplace'),(2835,'Try to search worldwide or find the needed solution in marketplace\', {\'URL\': url(\'addons_list_marketplace\', \'\', {\'tag\': \'Payment processing'),(1470,'Try to unpack them manually'),(296,'Trying to access the shop at X'),(2606,'Trying to run pre-upgrade hooks while not all archives were unpacked'),(4499,'Trying to use unaccepted template change.'),(3414,'Tweet'),(3841,'Twig-template path'),(1330,'Twitter'),(2224,'Two columns with left sidebar'),(2223,'Two columns with right sidebar'),(1331,'Type'),(1332,'Type of Account'),(4704,'Type of authorization request'),(4038,'Type: checkbox'),(4037,'Type: select box'),(4361,'U.S.P.S. module allows you to use online shipping rates calculation via USPS Web Tools Ecommerce API.'),(2641,'UPS'),(3885,'UPS module allows to use online shipping rates calculation via UPS service.'),(3809,'URL'),(4671,'URL is copied'),(1631,'URLs'),(2642,'USPS'),(4366,'USPS Shipments'),(1874,'Unable to delete file'),(1493,'Unable to delete module X files: some dirs have no writable permissions: Y'),(2745,'Unable to download the contents of {{url}}'),(2747,'Unable to get at the contents of {{url}}'),(4403,'Unable to get merchant info'),(301,'Unable to install module X because some modules, which it depends on, have not been installed or activated yet'),(3546,'Unable to retrieve Publisher ID for specified PayPal account. Banners are now disabled.'),(3836,'Unable to save edited content. Errors: '),(2744,'Unable to write data to file {{file}}'),(2680,'Unallowed modules will be disabled automatically on the next visit any page in the administrator interface.'),(2072,'Unavailable'),(3394,'Unblock and renew'),(1335,'Uncheck all'),(116,'Undelete'),(1336,'Understanding Online Payments'),(1337,'Unexpected error: version value is not passed'),(4512,'Unexpected result was received from ePDQ (transaction status is not set)'),(4523,'Unexpected result was received from iDEAL (transaction status is not set)'),(1421,'Unfortunately, you don\'t have permissions to access this page.'),(3474,'Unfortunately, your API credentials could not be obtained from your PayPal account automatically.'),(1338,'Uninstall'),(1339,'Units & Formats'),(1340,'Units of measurement'),(3412,'Universal Analytics'),(1341,'Unknown'),(2944,'Unknown core version'),(3291,'Unknown error'),(3580,'Unknown error occurred'),(1511,'Unknown language: X'),(4528,'Unknown payment transaction'),(2177,'Unknown payment. If you see this message after returning from the payment page, please contact the store administrator for information about the status of your payment.'),(3837,'Unknown temporary file'),(2097,'Unlimited'),(4560,'Unpackaged'),(1342,'Unpacking archives, please wait...'),(4164,'Unread'),(1751,'Unselect all'),(1343,'Unset'),(4145,'Unsupported file extension'),(62,'Update'),(4040,'Update MailChimp Lists'),(4404,'Update date'),(4427,'Update default card'),(1344,'Update exceptions'),(1988,'Update existing items, but skip new items'),(1345,'Update module'),(2845,'Update modules'),(1346,'Update product'),(1347,'Update profile'),(3954,'Update quantity'),(3961,'Update quantity import guide'),(4108,'Update store data'),(4405,'Update tracking info'),(1348,'Updated components'),(1349,'Updates are available'),(1350,'Updates for the X-Cart core and/or installed modules are available'),(1351,'Updates for your version ({{version}})'),(2836,'Updating data from the marketplace...'),(1352,'Upgrade'),(2477,'Upgrade access level cannot be changed for default free license'),(2473,'Upgrade access level has been successfully assigned to your license keys'),(2474,'Upgrade access level tooltip message'),(1353,'Upgrade available'),(1354,'Upgrade core'),(1737,'Upgrade for X-Cart core is available'),(1355,'Upgrade module'),(2859,'Upgrade not allowed'),(2354,'Upgrade note'),(3063,'Upgrade phar warning'),(1356,'Upgrade to version {{version}}'),(1357,'Upload'),(4259,'Upload a new logo'),(1358,'Upload add-on'),(1359,'Upload and restore'),(4223,'Upload company logo'),(1360,'Upload file'),(3023,'Upload file size limit'),(1526,'Upload files'),(1561,'Upload from server'),(1562,'Upload from your computer'),(4090,'Upload store data to MailChimp'),(110,'Upload via URL'),(4254,'Upload your company logo'),(4109,'Uploading data has been completed successfully.'),(4110,'Uploading data has been stopped.'),(3450,'Use PayPal authentication method'),(4421,'Use X-Payments configuration bundle'),(3388,'Use X-Sendfile to facilitate the download of large file attachments (100 Mb and larger) by customers:'),(1361,'Use a merchant account from your financial institution or choose a bundled payment solution to accept credit cards and other methods of payment on your website.'),(1362,'Use a merchant account from your financial institution to accept online payments'),(3790,'Use custom css'),(1363,'Use custom js'),(1367,'Use default logo'),(1369,'Use dynamic image help'),(1368,'Use dynamic image resizing'),(4735,'Use existing Amazon account'),(3485,'Use existing PayPal account'),(3483,'Use existing account from'),(1366,'Use images lazy load help'),(1365,'Use images lazy load placeholder'),(1364,'Use images lazy load preloaded'),(4350,'Use of Restriction key must be disabled in your Quantum Gateway merchant center account at all times.'),(3507,'Use of the unsupported Payment Data Transfer (PDT) method has been detected'),(4461,'Use one of the following cards to'),(2045,'Use our new nifty module to automatically backup your store and be able to restore it if anything crops up.'),(3876,'Use the Google Tag Manager addon for more flexibility when adding JS code to your web pages.'),(1370,'Use the category name'),(1772,'Use the following key to access safe mode'),(2293,'Use the form below to provide your license information.'),(1371,'Use the navigation bar above this dialog to navigate through the catalog categories'),(4348,'Use the same tax rates for all user membership levels'),(4385,'Use this field for instructions in case the package is not delivered.'),(1372,'Use this section to back the database of your online store up. Please note that the database backup procedure can take up to several minutes.'),(1565,'Use this section to back up the database of your online store. Please note that the database backup procedure can take up to several minutes.'),(1373,'Use this section to define shipping zones.'),(1374,'Use this section to define your store\'s shipping methods.'),(1375,'Use this section to manage the list of existing countries. This list is used in the shipping settings and calculations, and in the registration form at the Customer Front-end.'),(1376,'Use this section to manage the lists of counties, provinces, regions and states of different countries. The lists are used in shipping settings and calculations, and in the registration form at the Customer Front-end.'),(1377,'Use this section to restore the database of your online store. Please note that the database restoration procedure can take up to several minutes'),(1378,'Use this section to review the list of existing membership levels and add new ones'),(4425,'Used credit cards'),(2091,'User'),(264,'User X is logged in'),(1735,'User activity'),(1778,'User filled in Contact Us form'),(4297,'User manuals, release notes, modules, videos and more.'),(1379,'User membership'),(1380,'User type'),(1381,'Username or e-mail'),(1382,'Users'),(3113,'Users list'),(1383,'Uses count'),(1384,'Uses left'),(2677,'Using the modules with this type of license violation is illegal'),(2310,'VALID THRU'),(1385,'VAT'),(1386,'Validate key'),(1387,'Value'),(2232,'Variant attribute \"{{column}}\" cannot be empty'),(3540,'Venmo'),(1532,'Verification results'),(2368,'Verified'),(4224,'Verify geo settings'),(2369,'Verifying data before importing...'),(1388,'Version'),(1389,'Version change'),(109,'Via URL'),(1944,'View all addons'),(1758,'View all low inventory products'),(1390,'View all open orders'),(2150,'View all ordered items'),(238,'View cart'),(107,'View image'),(1670,'View in list'),(3292,'View in my addons'),(1391,'View logs'),(2472,'View more addons in Marketplace'),(2704,'View order history'),(4459,'View payment information'),(1392,'View profile'),(2391,'View storefront'),(1393,'View system logs'),(1394,'View update log'),(3611,'Visible for'),(3679,'Visible in products filter'),(1395,'Visit module details page'),(1396,'Visit storefront'),(2518,'Visit the template store'),(2111,'Void'),(2730,'Void multiple[TT]'),(2729,'Void partially[TT]'),(4588,'Void shipment'),(2694,'Void[S]'),(2728,'Void[TT]'),(1397,'Volume discounts'),(3747,'Votes: X'),(1685,'WARNING! There are no more available administrators\' profiles. You will not be able to manage your store after you delete this profile.'),(383,'WE'),(3413,'Want help with SEO? Ask X-Cart Guru'),(2620,'Want to change or add another accounting system? Choose the accounting system you require below and configure it.'),(3127,'Want to customize review surveys and display video testimonials? Try Shopper Approved and collect up to 70x more ratings and reviews'),(1398,'Warning'),(1704,'Warning!'),(1724,'Warning! CSV file was not specified.'),(1702,'Warning! InnoDB engine is not supported. It is required for software operation'),(1660,'Warning! Installing this module will overwrite all language labels translated to the appropriate language.'),(4526,'Warning! Please re-check public and private key values!'),(1727,'Warning! The file you have specified in the \'File (CSV) for upload\' field has not been uploaded to the server.'),(1725,'Warning! The file you have specified in the \'File (CSV) local\' field does not exist or cannot be read.'),(3085,'Warning! The image cannot be resized to reduce capacity for better site performance.'),(2498,'Warning! The selected types of content data will be deleted permanently.'),(1399,'Warning! There is not enough product items in stock to process the order'),(4525,'Warning! This payment method requires OpenSSL extension. Please install and enable this extension in your PHP configuration.'),(1563,'Warning: The restoration procedure is irreversible and erases all the data tables from the store database. It is highly recommended that you back up your current database before restoring one of the previous states from a back-up.'),(1400,'Warning: this operation can not be reverted!'),(2720,'Warnings'),(332,'Watch this short video and learn the basics of how online payment processing works'),(1401,'Watch video'),(4642,'Way to deliver'),(1509,'We are already aware of this problem and working on it. If you would like to get in touch, feel free to contact us via our Help center at _URL_'),(3302,'We are always glad to help you.'),(2044,'We are doing our best to make your upgrade process not only easy to do, but safe.'),(3535,'We are experiencing a problem with the \"PayPal For Marketplaces\" payment method.'),(3134,'We couldn\'t find one correct root category'),(3135,'We couldn\'t find one correct root category, however there are possible candidates'),(1515,'We have found a valid SSL certificate installed on the server. Now you can switch the store to use the secure protocol for the store back-end and checkout, sign-in and profile pages.'),(3415,'We recommend to use share button instead of like'),(3733,'We use this email in case we need additional information on your review. We do not use it for any kind of mailing lists or spam subscriptions'),(4448,'We will authorize'),(2046,'We will email you with emergency links to disable custom modules and stay only with original add-ons.'),(4267,'We will use this info to create invoices, send emails and calculate shipping rates for your customers.'),(4263,'We\'ve tried to guess your country, currency and weight. Verify, please.'),(4059,'Web ID'),(1402,'Web server'),(4134,'Web server max upload file size limit is X'),(4670,'Webhook URL is your store\'s URL through which Stripe informs your store about any changes in the order'),(3532,'Webhook listener error: could not subscribe to event(s).'),(3801,'Webmaster Mode allows you to change the storefront design in click-and-edit mode'),(3798,'Webmaster mode'),(3803,'Webmaster mode is disabled'),(3802,'Webmaster mode is enabled'),(1753,'Website'),(406,'Week'),(49,'Weight'),(50,'Weight X'),(1403,'Weight modifier'),(2575,'Weight range'),(1611,'Welcome'),(229,'Welcome to X-Cart'),(1404,'What is benchmark?'),(1617,'What to export'),(2563,'What type of shipping rates would you like to use?'),(328,'What\'s new'),(4308,'When AustraliaPost returns shipping methods which does not exists in the available methods list, these methods will be created in the list automatically'),(3537,'When multiple funding sources are available to the buyer, PayPal automatically determines which additional buttons are appropriate to display. However, you can choose to opt-in or out-of displaying specific funding sources.'),(1405,'When the export is completed, you will be prompted to download the product data file'),(1894,'Widgets cache has been cleaned'),(1895,'Widgets cache has not been cleaned completely'),(2060,'Width'),(1406,'Width (px)'),(3096,'Will be added globally'),(3097,'Will be added to the product class'),(2969,'Will be available if core update is selected'),(2403,'Will be deleted:'),(1739,'Will be installed'),(2400,'Will be updated if core update is selected'),(2635,'Win app'),(4189,'Write your message'),(3735,'Write your review'),(2274,'Wrong \"default\" format ({{value}}). Value should be one of \"Yes\" or \"No\"'),(2273,'Wrong \"owner\" format ({{value}}). Value should be one of \"Yes\" or \"No\"'),(2275,'Wrong \"priceModifier\" format ({{value}}). Correct examples: +1, +1%, -1, -1%'),(2272,'Wrong \"type\" value ({{value}}). This should be \"C\", \"S\" or \"T\"'),(2276,'Wrong \"weightModifier\" format ({{value}}). Correct examples: +1, +1%, -1, -1%'),(2752,'Wrong access level format'),(2281,'Wrong added format'),(2912,'Wrong address same format'),(2911,'Wrong anonymous format'),(2250,'Wrong arrival date format'),(2288,'Wrong billing address format'),(2260,'Wrong box height format'),(2259,'Wrong box length format'),(2258,'Wrong box width format'),(4364,'Wrong container type selected: {{value}}. For large package size only the following types are allowed: RECTANGULAR, NONRECTANGULAR, VARIABLE'),(2289,'Wrong country code format'),(2915,'Wrong currency format'),(2251,'Wrong date format'),(2245,'Wrong enabled format'),(3939,'Wrong exclude from shipping cost format'),(2282,'Wrong first login date format'),(2262,'Wrong format of Clean URL value (allowed alpha-numeric, \"_\" and \"-\" chars)'),(2452,'Wrong format: Field contains unallowed characters'),(3940,'Wrong free shipping format'),(3930,'Wrong freight fixed fee format'),(2253,'Wrong inventory tracking format'),(2928,'Wrong item order modifier format'),(2261,'Wrong items per box format'),(2286,'Wrong language format'),(2283,'Wrong last login date format'),(2280,'Wrong login format'),(2256,'Wrong low limit level format'),(2255,'Wrong low stock notification format'),(2246,'Wrong meta desc type format'),(1407,'Wrong method_id specifed'),(2920,'Wrong order item format'),(2922,'Wrong order item name format'),(2923,'Wrong order item price format'),(2926,'Wrong order item quantity format'),(2921,'Wrong order item sku format'),(2924,'Wrong order item subtotal format'),(2925,'Wrong order item total format'),(2919,'Wrong order modifier format'),(2910,'Wrong order number format'),(2935,'Wrong order transaction currency format'),(2929,'Wrong order transaction format'),(2934,'Wrong order transaction id format'),(2930,'Wrong order transaction method format'),(2932,'Wrong order transaction value format'),(2266,'Wrong position format'),(2244,'Wrong price format'),(3958,'Wrong product quantity value format (\"{{value}}\")'),(2285,'Wrong referer format'),(2754,'Wrong role format'),(2248,'Wrong shippable format'),(2287,'Wrong shipping address format'),(2279,'Wrong show title format'),(2290,'Wrong state id format'),(2284,'Wrong status format'),(2254,'Wrong stock level format'),(2913,'Wrong subtotal format'),(3487,'Wrong token of Express Checkout. Please try again. If the problem persists, contact the administrator.'),(2914,'Wrong total format'),(2269,'Wrong type format'),(2252,'Wrong update date format'),(2249,'Wrong use separate box format'),(3686,'Wrong useClasses format'),(1408,'Wrong value is specified for arrival date field. The field was not updated.'),(2247,'Wrong weight format'),(271,'X GB'),(162,'X Language (Code: Y)'),(270,'X MB'),(3567,'X PIN Codes were not assigned.'),(3550,'X PIN code duplicates ignored.'),(3551,'X PIN codes created successfully.'),(3552,'X PIN codes longer than Y characters ignored.'),(3120,'X addon'),(1505,'X addon(s) selected'),(3121,'X addons'),(3122,'X addons (5)'),(340,'X attributes in group'),(268,'X bytes'),(3315,'X code is already used for other coupon, please specify a different code'),(3314,'X coupon(s) has been created'),(3313,'X coupon(s) has been removed'),(3080,'X day left'),(275,'X days'),(3081,'X days left'),(3082,'X days left (5)'),(313,'X entities has been created'),(312,'X entities has been removed'),(2178,'X expired shopping cart(s) have been successfully removed'),(211,'X field is required'),(1500,'X file type'),(4142,'X file(s) attached'),(276,'X hours'),(285,'X image unable to load'),(233,'X item'),(308,'X item available'),(181,'X item in bag'),(195,'X items'),(4651,'X items ($)'),(309,'X items available'),(182,'X items in bag'),(2857,'X items selected'),(269,'X kB'),(121,'X labels'),(430,'X language labels have been removed'),(429,'X languages have been removed'),(333,'X methods available'),(277,'X minutes'),(214,'X module settings'),(2356,'X module will be disabled'),(2358,'X module will be upgraded'),(2496,'X modules selected'),(2357,'X modules will be disabled'),(2359,'X modules will be upgraded'),(274,'X months'),(4175,'X new message for order'),(4200,'X new messages'),(3343,'X off'),(259,'X order'),(260,'X orders'),(344,'X orders on last day'),(346,'X orders on last month'),(345,'X orders on last week'),(311,'X product(s) has been created'),(310,'X product(s) has been removed'),(364,'X products'),(265,'X products found'),(4204,'X products selected'),(257,'X results found'),(347,'X revenue on last day'),(349,'X revenue on last month'),(348,'X revenue on last week'),(278,'X seconds'),(441,'X shipping methods have been created'),(442,'X shipping methods have been removed'),(3694,'X star_1'),(3693,'X stars_2'),(3692,'X stars_3'),(3691,'X stars_4'),(3690,'X stars_5'),(433,'X states have been removed'),(434,'X states have been successfully created'),(4171,'X unread messages'),(273,'X years'),(435,'X zones have been removed'),(436,'X zones have been successfully created'),(4232,'X% Wizard completion'),(358,'X, including images and file attachments'),(1409,'X-Cart'),(3076,'X-Cart Business trial will expire in X day'),(3077,'X-Cart Business trial will expire in X days'),(3078,'X-Cart Business trial will expire in X days (5)'),(130,'X-Cart News'),(2891,'X-Cart Team have done their best to make your upgrade process as enjoyable as possible.'),(4418,'X-Cart automatically checks the connection to X-Payments after the settings are saved.<br/> If the module is configured properly, a \"Test transaction completed successfully\" message is displayed at the top of the page.'),(2544,'X-Cart could not find a valid SSL certificate on your server X.'),(2543,'X-Cart could not find a valid SSL certificate on your server.'),(2542,'X-Cart could not find a valid SSL certificate on your server. Although you can switch the store to use the secure protocol for the website pages, most Internet browsers will likely display a warning message scaring your website visitors away.'),(2170,'X-Cart could not find data in your file.'),(2531,'X-Cart found some issues with installed SSL certificate'),(2441,'X-Cart license key has been successfully verified'),(2442,'X-Cart license key has been successfully verified and activated. But this key has expired and do not allow upgrade store.'),(1410,'X-Cart online store builder'),(4296,'X-Cart professionals will easily materialize just about any idea you’ve got.'),(1411,'X-Cart shopping cart software'),(2860,'X-Cart v5.3 requires PHP version 5.4 or better. Please update the PHP version installed on your server before you proceed.'),(4472,'X-Payments'),(4500,'X-Payments Dashboard'),(4415,'X-Payments configuration ID'),(4501,'X-Payments considers this transaction as potentially fraudlent.'),(4414,'X-Payments returned the following payment methods for your shopping cart:'),(4437,'X-Payments transaction'),(3047,'XML extensions support'),(1412,'XML parser'),(1413,'XML sitemap'),(3641,'XML sitemap URL: X'),(2311,'YEAR'),(1414,'Yahoo!'),(1415,'Yandex'),(409,'Year'),(2116,'Year when store started its operation'),(1416,'Yes'),(1417,'Yes, I agree with License agreement'),(2397,'Yes, I agree with License agreements'),(2043,'Yes, I have made the full backup of my store files and database'),(4270,'Yes, I sell tangible goods that needed to be shipped'),(1937,'Yes/No'),(2466,'Yesterday'),(4176,'You Have No Messages'),(159,'You are going to delete the X language'),(2550,'You are logged in as: user'),(1418,'You are not allowed to access this resource!'),(3813,'You are now in layout editing mode'),(3814,'You are now in preview mode'),(2546,'You are operating as:'),(2549,'You are operating as: user'),(1781,'You are sure to clear your cart?'),(2679,'You can also contact our CR department for help with this issue'),(4136,'You can attach X file(s)'),(4135,'You can attach X more file(s)'),(1696,'You can build your web-site during FREE evaluation, but you cannot use this installation for real sales without buying a license.'),(2221,'You can change the CSV delimiter for all subsequent imports and exports using this link'),(2220,'You can change the charset for all subsequent imports and exports using this link'),(316,'You can choose if to download your database data'),(2941,'You can continue as guest or create an account'),(3424,'You can define an order id prefix, which would precede each order number in your shop, to make it unique'),(4329,'You can define an order id prefix, which would precede each order number in your shop, to make it unique (each transaction id must be unique for a Skrill account)'),(2589,'You can define the following values:'),(2649,'You can find the failed transaction here'),(2541,'You can get more information using this service: '),(155,'You can install these updates after purchasing and activating your X-Cart license key'),(1769,'You can now use the following credentials to access your account'),(2837,'You can purchase AntiFraud Service subscription'),(2587,'You can set up different shipping rates depending on the weight, price or quantity of items in the order.'),(298,'You can upload the database data directly from your local computer'),(4253,'You can view the newly created product in your [storefront] or add a few [more products] to your catalog.'),(3901,'You cannot choose this product'),(1567,'You cannot save database data to a file on the web server (\'var/backup/sqldump.sql.php\').'),(2758,'You cannot update administrator profile ({{value}}). Row is skipped'),(2757,'You cannot update administrator profile ({{value}}). Row will be skipped'),(3196,'You don’t have any notifications right now.'),(4246,'You have added 1 product'),(3718,'You have already reviewed this product'),(3317,'You have already used the coupon'),(1856,'You have an unpaid order #{{ORDER}}'),(3987,'You have configured MailChimp as your primary email newsletter tool. New subscribers will be added directly to your MailChimp lists (this X-Cart list will be skipped). You can manage your subscriber lists under your MailChimp account'),(1644,'You have no payment methods enabled in your shop'),(1425,'You have selected to delete your profile. Please, confirm you want to proceed'),(4325,'You have sent a request for activation on the X.'),(1610,'You have the following roles:'),(4154,'You have to attach file'),(4153,'You have to attach file to product'),(3816,'You have unsaved changes. Are you really sure to exit the preview?'),(3874,'You have unsaved changes. Are you really sure to exit?'),(3963,'You just added'),(3066,'You must register your X-Cart installation before using it for real sales. Activate your existing license key or purchase a premium license to skyrocket your business.'),(43,'You must register your installation before you can use it for real sales'),(2039,'You need hard and soft reset links in case some 3rd party module crashes your web-store'),(2838,'You need these links in case you want to recover your store'),(4502,'You should accept the changes at the'),(2537,'You should check available free disk space yourself before continuing installation'),(2536,'You should check available free disk space yourself before continuing upgrade'),(2353,'You should confirm that you have created backup before upgrading the store.'),(1853,'You tried to buy more items of \"{{product}}\" product {{description}} than are in stock. We have {{amount}} item(s) only. Please adjust the product quantity.'),(3564,'You will be able to add pin codes after saving changes.'),(1570,'You will be able to provide additional product info (images, attributes, etc.) after you submit this form.'),(4282,'You\'ve successfully set up shipping areas and rates for your store'),(2136,'Your \"Password reset key\" has expired. Please enter the email address associated with your user account to get a new \"Password reset key\".'),(3473,'Your API credentials have been successfully obtained from your PayPal account and saved for use by your X-Cart store.'),(1828,'Your Account'),(3299,'Your Message'),(3173,'Your PHP version is outdated'),(3174,'Your PHP version is outdated and no longer supported'),(3445,'Your PayPal Publisher ID is X'),(4669,'Your Stripe account is no longer accessible. Please connect with Stripe once again.'),(3065,'Your X-Cart Business trial has expired!'),(1695,'Your X-Cart installation is licensed for evaluation purposes only.'),(1419,'Your access link has been expired'),(3100,'Your access to X-Cart Business features expires in X day'),(3101,'Your access to X-Cart Business features expires in X days'),(3102,'Your access to X-Cart Business features expires in X days (5)'),(329,'Your account email is X'),(1435,'Your account information will be e-mailed to you shortly'),(1436,'Your account information will be e-mailed to you shortly.'),(330,'Your account password is X'),(3425,'Your account settings'),(3489,'Your address data was not received from PayPal. Please try again. If the problem persists, contact the administrator.'),(242,'Your cart'),(4432,'Your configuration string is not correct'),(1420,'Your custom addons were prepared for certain core version'),(3794,'Your custom file is successfully saved'),(1437,'Your e-mail'),(3725,'Your email'),(444,'Your first name'),(445,'Your last name'),(1438,'Your name'),(1768,'Your new password'),(1978,'Your order details will be sent to your e-mail address'),(4009,'Your order details will be sent to your email address'),(3427,'Your partner name is PayPal'),(3115,'Your payment has been processed; now the addon can be installed.'),(3116,'Your payment is being processed. The addon license key will be sent to your email address as soon as the processing has been completed. You will be able to use this key to install the addon at any time. '),(3380,'Your payment module to accept payments for digital items. [Get it now]!'),(3722,'Your product rating is saved. Thank you!'),(1439,'Your products will be exported as a CSV file.'),(1777,'Your profile modified'),(2361,'Your request has been sent successfully'),(3736,'Your review'),(3723,'Your review has been updated. Thank your for sharing your opinion with us!'),(192,'Your shopping bag - X item'),(193,'Your shopping bag - X items'),(1440,'Your shopping bag is empty'),(1441,'Your state'),(1442,'Your store'),(1514,'Your store is configured to use the secure protocol for the store back-end and checkout, sign-in and profile pages.'),(1443,'Your store is currently unable to calculate taxes'),(2365,'Your version (X) can be upgraded to'),(3969,'Z - A'),(207,'Zero cannot be used'),(1444,'Zip code'),(1445,'Zip/postal code masks'),(4001,'Zipcode'),(1447,'Zone'),(440,'Zone address masks help'),(439,'Zone city masks help'),(189,'Zone details have been updated successfully'),(1448,'Zone name'),(1501,'Zone not found (X)'),(438,'Zone zipcode masks help'),(1449,'Zones'),(2393,'Zoom image'),(3505,'[BT] In progress'),(2776,'[Edit]'),(3231,'[field] year must be between 1970 and 2038'),(4091,'_MailChimp ecommerce info text_'),(196,'_X_ item'),(197,'_X_ items'),(3506,'__pdt-paypal-warning__'),(2067,'a side box'),(3595,'a2cp-source-code-PAB'),(3904,'a2cp-source-code-REL'),(1823,'address during the recent purchase'),(2103,'always'),(1450,'and'),(1782,'attributes'),(3094,'attributes_popover_text'),(4316,'authorize_key_help'),(4315,'authorize_md5_key_help'),(1821,'billing'),(3189,'body of the test email'),(4736,'braintree_merchant_account_id_help'),(1451,'by'),(4159,'by payment callback (Failed + Cancel)'),(4160,'by pressing Place order button'),(1431,'cURL error'),(1708,'cannot create directory'),(302,'cannot set X permissions'),(2347,'checkbox.firstlast.off'),(2346,'checkbox.firstlast.on'),(2345,'checkbox.onoff.off'),(2344,'checkbox.onoff.on'),(2014,'cm'),(3003,'config_file.error_message_1'),(3004,'config_file.label_message'),(4116,'cs_categories'),(4119,'cs_did_you_mean'),(4118,'cs_manufacturers'),(4117,'cs_pages'),(4115,'cs_products'),(4112,'cs_see_details'),(4113,'cs_see_more_results_for'),(4111,'cs_showing_results_for'),(4114,'cs_suggestions'),(3726,'customers'),(2105,'daily'),(1606,'default'),(683,'default-meta-description'),(2774,'default-meta-keywords'),(2773,'default-site-title'),(1512,'deleted'),(2558,'deliveryTime.help'),(4578,'deposit your items at a Post Office'),(1452,'details'),(1680,'dimensions'),(1453,'disabled'),(3824,'disabled blocks'),(2015,'dm'),(3051,'doc_blocks_support.error_message_1'),(3052,'doc_blocks_support.error_message_2'),(3053,'doc_blocks_support.label_message'),(1886,'done'),(1454,'downloads'),(4097,'e-Commerce Analytics disable warning'),(2643,'eBay'),(4508,'ePDQ Currency'),(4510,'ePDQ Enable logging of ePDQ transactions'),(4509,'ePDQ Invoice number prefix'),(4505,'ePDQ PSPID'),(4506,'ePDQ SHA-IN pass phrase'),(4507,'ePDQ SHA-OUT pass phrase'),(4504,'ePDQ settings note'),(2101,'each'),(1618,'editable'),(3180,'email from Contact information section'),(451,'email@example.com'),(2327,'emailNotificationAdminHeader'),(2328,'emailNotificationAdminSignature'),(2324,'emailNotificationCustomerHeader'),(2326,'emailNotificationCustomerSignature'),(2325,'emailNotificationGreeting'),(1723,'empty'),(4572,'enable merchant wizard'),(1455,'enabled'),(2069,'expired'),(3399,'fedex.CODStatusOptionComment'),(1710,'file does not exist'),(3027,'file_permissions.error_message_1'),(3028,'file_permissions.error_message_2'),(3029,'file_permissions.kb_message'),(2577,'flat rate'),(4462,'for this order'),(767,'from'),(1456,'from URL'),(1457,'from local computer'),(1458,'from local server'),(2028,'g'),(1459,'hard reset'),(4055,'here'),(2364,'hide list'),(2104,'hourly'),(3203,'https://kb.x-cart.com/'),(3222,'https://kb.x-cart.com/general_setup/inaccessible_admin_area_after_enabling_https.html'),(3207,'https://kb.x-cart.com/general_setup/moving_x-cart_to_another_location.html'),(3205,'https://kb.x-cart.com/general_setup/moving_x-cart_to_another_location.html#transfering-database'),(3204,'https://kb.x-cart.com/general_setup/what_to_do_if_your_store_says_we_are_deploying_new_changes_and_you_cannot_access_it.html'),(3208,'https://kb.x-cart.com/import-export/'),(3211,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_categories.html'),(3209,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_classes_&_attributes.html'),(3212,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_customers.html'),(3214,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_orders.html'),(3210,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_product_attribute_values.html'),(3213,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_products.html'),(3220,'https://kb.x-cart.com/integrating_your_store_with_other_web-sites/sell_your_products_with_buy_button.html'),(3962,'https://kb.x-cart.com/modules/update_inventory.html'),(3216,'https://kb.x-cart.com/payments/paypal/setting_up_paypal_express_checkout.html'),(3217,'https://kb.x-cart.com/payments/paypal/setting_up_paypal_payflow_link.html'),(3218,'https://kb.x-cart.com/payments/paypal/setting_up_paypal_payments_advanced.html'),(3219,'https://kb.x-cart.com/payments/paypal/setting_up_paypal_payments_standard.html'),(3206,'https://kb.x-cart.com/seo_and_promotion/setting_up_seo-friendly_urls.html'),(3215,'https://kb.x-cart.com/setting_up_x-cart_5_environment/configuring_attachments_sending.html'),(3221,'https://kb.x-cart.com/shipping/custom_table_rates.html'),(3224,'https://kb.x-cart.com/shipping/free_shipping.html'),(3227,'https://kb.x-cart.com/taxes/setting_up_canadian_taxes.html'),(3226,'https://kb.x-cart.com/taxes/setting_up_sales_tax.html'),(3228,'https://kb.x-cart.com/taxes/setting_up_tax_classes.html'),(3225,'https://kb.x-cart.com/taxes/setting_up_vat_gst.html'),(3223,'https://kb.x-cart.com/users/user_roles.html'),(3043,'https_bouncer.error_message_1'),(3044,'https_bouncer.error_message_2'),(3046,'https_bouncer.kb_message'),(3045,'https_bouncer.label_message'),(4519,'iDEAL Currency'),(4521,'iDEAL Enable logging of iDEAL transactions'),(4520,'iDEAL Invoice number prefix'),(4513,'iDEAL Merchant ID'),(4517,'iDEAL Private Key'),(4518,'iDEAL Private Key Password'),(4515,'iDEAL Public Certificate File'),(4516,'iDEAL Public Key'),(4514,'iDEAL SubID'),(1674,'if you have any questions'),(2529,'imgsize-category-Default'),(2526,'imgsize-product-Default'),(2527,'imgsize-product-LGThumbnailGrid'),(2528,'imgsize-product-LGThumbnailList'),(4471,'in'),(1460,'in description'),(1461,'in title'),(2675,'inactive license key(s);'),(2016,'inches'),(3001,'install_script.error_message_1'),(2676,'installed module(s) not allowed by the type of X-Cart license activated at your store.'),(1495,'invalid module ID passed: X'),(1462,'is available'),(1681,'item(s)'),(1780,'item(s) in stock'),(235,'items'),(1463,'items available'),(2982,'itemslist.admin.category.blank'),(3357,'itemslist.admin.coupon.blank'),(2983,'itemslist.admin.membership.blank'),(3628,'itemslist.admin.menu.blank'),(3926,'itemslist.admin.news_message.blank'),(2978,'itemslist.admin.order.blank'),(2977,'itemslist.admin.order.search.blank'),(3627,'itemslist.admin.page.blank'),(2981,'itemslist.admin.product.blank'),(2980,'itemslist.admin.product.search.blank'),(3771,'itemslist.admin.review.blank'),(2996,'itemslist.admin.subcategory.blank'),(3986,'itemslist.admin.subscribers.blank'),(4220,'itemslist.admin.tag.blank'),(3864,'itemslist.admin.template.blank'),(2979,'itemslist.admin.transaction.blank'),(3638,'itemslist.admin.volume_discounts.blank'),(2027,'kg'),(1603,'label name,'),(1604,'label translation.'),(4030,'label.coming_soon'),(1597,'labels count:'),(1602,'language code,'),(2025,'lbs'),(3659,'learn more'),(1464,'less'),(3375,'less one hour'),(1632,'local files'),(3184,'mail tester line 1'),(3185,'mail tester line 2'),(3186,'mail tester line 3'),(3187,'mail tester line 4'),(4092,'mailchimp_settings_promo_text'),(2976,'mbstring.extension.alert'),(2013,'mm'),(1497,'module version X is not equal to the core one (Y)'),(4,'module-sort-Alphabetically'),(2,'module-sort-Most popular'),(3,'module-sort-Newest'),(1465,'modules'),(2107,'monthly'),(2703,'more'),(1466,'ms'),(1619,'multi value'),(3035,'mysql_cache.error_message_1'),(3031,'mysql_version.error_message_1'),(3032,'mysql_version.error_message_2'),(3033,'mysql_version.error_message_3'),(68,'n/a'),(2739,'na_admin'),(2711,'na_customer'),(1467,'never'),(3119,'new core'),(3123,'new core and X addon'),(3124,'new core and X addons'),(3125,'new core and X addons (5)'),(2203,'no comments'),(1468,'none'),(1469,'not all archives were unpacked'),(453,'not all upgrade packs were downloaded'),(1471,'not available for sale'),(4158,'not finished'),(1472,'not installed'),(1473,'not ready to download packs. Please, try again'),(2872,'notification.section.administrator'),(2871,'notification.section.customer'),(1736,'now disabled'),(1474,'of'),(4449,'on your credit card in order to attach this credit card to your account. The amount will be released back to your card after a while.'),(4239,'onboarding.add_product.heading'),(4241,'onboarding.add_product.import'),(4240,'onboarding.add_product.text'),(4238,'onboarding.intro.disable_button'),(4234,'onboarding.intro.heading'),(4237,'onboarding.intro.later_button'),(4236,'onboarding.intro.next_button'),(4235,'onboarding.intro.text'),(1475,'options'),(1476,'or'),(4278,'or choose a shipping carrier to provide your customers with real-time quotes'),(3481,'or go to checkout as a New customer'),(2940,'or proceed with'),(2839,'or use the form below'),(3728,'out of'),(1668,'outdated'),(2026,'oz'),(4408,'page.'),(2320,'paymentStatus.Active'),(2321,'paymentStatus.Inactive'),(3456,'paypal_welcome_text'),(2578,'per item'),(258,'per page'),(2579,'per weight unit'),(319,'percent X off'),(3011,'php_disabled_functions.error_message_1'),(3012,'php_disabled_functions.label_message'),(3017,'php_file_uploads.error_message_1'),(3018,'php_file_uploads.label_message'),(3037,'php_gdlib.error_message_1'),(3038,'php_gdlib.error_message_2'),(3014,'php_memory_limit.error_message_1'),(3015,'php_memory_limit.label_message'),(3020,'php_pdo_mysql.error_message_1'),(3022,'php_pdo_mysql.kb_message'),(3021,'php_pdo_mysql.label_message'),(3040,'php_phar.error_message_1'),(3041,'php_phar.label_message'),(3024,'php_upload_max_file_size.error_message_1'),(3025,'php_upload_max_file_size.label_message'),(3006,'php_version.error_message_1'),(3007,'php_version.error_message_2'),(3008,'php_version.error_message_3'),(3009,'php_version.label_message'),(1423,'please sign in'),(3530,'pp-button-location:Add2Cart popup'),(3526,'pp-button-location:Cart'),(3528,'pp-button-location:Checkout'),(3529,'pp-button-location:Checkout (credit)'),(3527,'pp-button-location:Minicart'),(3525,'pp-button-location:Product list'),(3524,'pp-button-location:Product page'),(2298,'price-All'),(2300,'price-Free'),(2299,'price-Paid'),(1688,'products'),(1477,'proxy'),(4319,'relay_response_help'),(1941,'requested for'),(1540,'requested once or twice'),(1539,'requested only once'),(157,'required'),(3763,'reviewMetaDescription'),(1478,'sale'),(2882,'same as shipping'),(2102,'save'),(4420,'section.'),(4098,'send all discount coupons'),(4099,'send only discount coupons with matched rules'),(3181,'sender identified by server'),(4577,'shipments are picked up by Canada Post'),(1822,'shipping'),(2584,'shippingFormula.Free'),(2581,'shippingFormula.Items'),(2580,'shippingFormula.Shipping'),(2582,'shippingFormula.Subtotal'),(2583,'shippingFormula.Weight'),(2602,'shippingStatus.Active'),(2603,'shippingStatus.Inactive'),(2572,'shippingTableType.All'),(2571,'shippingTableType.Items'),(2569,'shippingTableType.Subtotal'),(2570,'shippingTableType.Weight'),(1479,'should be performed manually'),(2408,'show list'),(1480,'soft reset'),(3182,'specific email address (set up below)'),(3775,'star_tooltip_1'),(3776,'star_tooltip_2'),(3777,'star_tooltip_3'),(3778,'star_tooltip_4'),(3779,'star_tooltip_5'),(1709,'subdirectories problems'),(59,'submit_restore_pass'),(4467,'tab and get back here to configure methods.'),(2559,'tableType.help'),(9,'tag-Accounting'),(10,'tag-Administration'),(8,'tag-All'),(7,'tag-All tags'),(2301,'tag-Catalog Management'),(25,'tag-Checkout'),(11,'tag-Delivery'),(12,'tag-Development'),(27,'tag-Fraud prevention'),(13,'tag-Fulfillment'),(14,'tag-Marketing'),(23,'tag-Migration'),(21,'tag-Orders'),(15,'tag-Payment processing'),(24,'tag-Price modifiers'),(26,'tag-Products'),(20,'tag-Sales Channels'),(2302,'tag-Search and Navigation'),(22,'tag-Security'),(16,'tag-Statistics'),(17,'tag-Translation'),(18,'tag-User experience'),(19,'tag-Website design'),(2505,'the categories and product classes to which the coupon may be applied;'),(1747,'the custom modifications will be lost'),(2503,'the dates the coupon should be valid for;'),(2068,'the main column'),(2504,'the order subtotal range for which the coupon can be used;'),(2840,'the same as billing'),(3873,'themetweaker.shortcut.save'),(3872,'themetweaker.shortcut.switcher'),(2772,'title-delimiter'),(3177,'to be uninstalled'),(2939,'to enjoy checkout'),(1481,'trying to install a non-marketplace module: X'),(1482,'trying to unpack non-downloaded archives'),(1496,'unable to add module entry to the installation list: X'),(1483,'unable to install: not all archives were unpacked. Please, try again'),(1484,'unable to test files: not all archives were unpacked'),(1498,'unable to upload module'),(2495,'unavailable'),(2100,'units'),(1485,'unknown'),(1880,'unknown error'),(3143,'up to 1 decimal'),(3145,'up to 10'),(3146,'up to 100'),(3142,'up to 2 decimals'),(3144,'up to integer'),(1662,'upgrade core'),(2973,'upgrade_warning_text'),(3886,'ups.CODStatusOptionComment'),(4362,'usps.CODStatusOptionComment'),(1700,'verified version'),(2363,'view list'),(3730,'votes'),(4556,'warning: parcel is overweight'),(3807,'webmasterMode.Disabled'),(3806,'webmasterMode.Enabled'),(2106,'weekly'),(1679,'weight'),(2506,'whether the coupon may be used by everyone or only by users with specific memberships.'),(4475,'with'),(3863,'xlite-translation-popover.help'),(3048,'xml_support.error_message_1'),(3049,'xml_support.label_message'),(2108,'yearly'),(1486,'you save'),(1749,'your web site may crash'),(4221,'{{count}} Tag duplicates ignored'),(1979,'{{count}} created'),(3233,'{{count}} day'),(3234,'{{count}} days'),(1980,'{{count}} updated'),(2815,'{{field}} length must be less then {{length}}'),(2746,'{{file}} does not exist on the filesystem'),(2743,'{{file}} file could not be copied to a new location {{newPath}}'),(1911,'{{module}} license agreement'),(1994,'{{name}} attributes'),(1870,'{{paymentMethod}} settings'),(4365,'{{value}} is an invalid container type for a REGULAR package. Valid Container is: VARIABLE');
CREATE TABLE `xlite_clean_urls` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `page_id` int(10) unsigned DEFAULT NULL,
  `news_message_id` int(10) unsigned DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `cleanURL` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_F2542545C4663E4` (`page_id`),
  KEY `IDX_F2542545BF05C450` (`news_message_id`),
  KEY `IDX_F25425454584665A` (`product_id`),
  KEY `IDX_F254254512469DE2` (`category_id`),
  KEY `cleanURL` (`cleanURL`),
  CONSTRAINT `FK_F254254512469DE2` FOREIGN KEY (`category_id`) REFERENCES `xlite_categories` (`category_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_F25425454584665A` FOREIGN KEY (`product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_F2542545BF05C450` FOREIGN KEY (`news_message_id`) REFERENCES `xlite_news` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_F2542545C4663E4` FOREIGN KEY (`page_id`) REFERENCES `xlite_pages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_clean_urls` VALUES (1,1,NULL,NULL,NULL,'terms-and-conditions.html'),(2,2,NULL,NULL,NULL,'shipping.html'),(3,NULL,NULL,1,NULL,'mordorable-fitted-ladies-tee.html'),(4,NULL,NULL,2,NULL,'octopus-cardigan.html'),(5,NULL,NULL,3,NULL,'spiderman-selfie-ladies-tee.html'),(6,NULL,NULL,4,NULL,'star-wars-tissue-weight-fitted-ladies-tee.html'),(7,NULL,NULL,5,NULL,'wonder-woman-hockey-stripe-ladies-tee.html'),(8,NULL,NULL,6,NULL,'star-trek-command-cycle-jersey.html'),(9,NULL,NULL,7,NULL,'star-trek-uniform-polos.html'),(10,NULL,NULL,8,NULL,'bow-ties-are-cool.html'),(11,NULL,NULL,9,NULL,'star-trek-tng-uniform-tee.html'),(12,NULL,NULL,10,NULL,'ewok-ladies-hooded-tank-top.html'),(13,NULL,NULL,11,NULL,'dota-2-series-3-micro-plush-blind-box.html'),(14,NULL,NULL,12,NULL,'minions-pop-vinyl-figures.html'),(15,NULL,NULL,13,NULL,'vinyl-idolz-ghostbusters.html'),(16,NULL,NULL,14,NULL,'dota-2-sniper-plush.html'),(17,NULL,NULL,15,NULL,'soft-kitty-singing-plush.html'),(18,NULL,NULL,16,NULL,'avengers-age-of-ultron-fabrikations-plush.html'),(19,NULL,NULL,17,NULL,'ollie-the-app-controlled-robot.html'),(20,NULL,NULL,18,NULL,'powerup-r-3-0-smartphone-controlled-paper-airplane.html'),(21,NULL,NULL,19,NULL,'chocolate-covered-edible-bugs-gift-pack.html'),(22,NULL,NULL,20,NULL,'canned-unicorn-meat.html'),(23,NULL,NULL,21,NULL,'the-thinkgeek-annoy-a-tron.html'),(24,NULL,NULL,22,NULL,'legendary-hero-8-bit-heart-bouquet.html'),(25,NULL,NULL,23,NULL,'executive-building-brick-set-chrome-.html'),(26,NULL,NULL,24,NULL,'blizzard-diablo-goblin-bank-with-sound.html'),(27,NULL,NULL,25,NULL,'ghostbusters-stay-puft-marshmallow-face-mug.html'),(28,NULL,NULL,26,NULL,'build-on-brick-mug.html'),(29,NULL,NULL,27,NULL,'superhero-mom-mug.html'),(30,NULL,NULL,28,NULL,'olloclip-iphone-macro-3-in-1-lens-system.html'),(31,NULL,NULL,29,NULL,'gunnar-vayper-gaming-glasses.html'),(32,NULL,NULL,30,NULL,'astro-a50-halo-edition.html'),(33,NULL,NULL,31,NULL,'cup-of-mojo-bluetooth-speaker.html'),(34,NULL,NULL,32,NULL,'jbl-pebbles-pc-speakers.html'),(35,NULL,NULL,33,NULL,'bright-idea-usb-powered-light-bulb.html'),(36,NULL,NULL,34,NULL,'mj-technology-android-tablet-with-built-in-hdtv-tuner.html'),(37,NULL,NULL,35,NULL,'bactrack-vio-bluetooth-app-enabled-breathalyzer.html'),(38,NULL,NULL,36,NULL,'coffee-cup-power-inverter-v2-0.html'),(39,NULL,NULL,37,NULL,'apple-iphone-6-16gb.html'),(40,NULL,NULL,38,NULL,'canon-ef-24-105mm-f-4l-is-usm.html'),(41,NULL,NULL,39,NULL,'apple-watch-sport-42mm-with-sport-band.html'),(42,NULL,NULL,40,NULL,'astro-a30-system.html'),(43,NULL,NULL,41,NULL,'apple-iphone-6-plus-options-amp-attributes-.html'),(44,NULL,NULL,42,NULL,'apple-iphone-5s.html'),(45,NULL,NULL,NULL,1,'catalog'),(46,NULL,NULL,NULL,2,'igoods'),(47,NULL,NULL,NULL,3,'electronics'),(48,NULL,NULL,NULL,4,'apparel'),(49,NULL,NULL,NULL,5,'toys'),(50,NULL,NULL,NULL,6,'geek-toys'),(51,NULL,NULL,NULL,7,'office-pranks-and-cube-warfare'),(52,NULL,NULL,NULL,8,'home-and-office');
CREATE TABLE `xlite_category_images` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned DEFAULT NULL,
  `alt` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `width` int(11) NOT NULL,
  `height` int(11) NOT NULL,
  `hash` char(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `needProcess` tinyint(1) NOT NULL,
  `path` varchar(512) COLLATE utf8_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_3EDA5C4B12469DE2` (`category_id`),
  CONSTRAINT `FK_3EDA5C4B12469DE2` FOREIGN KEY (`category_id`) REFERENCES `xlite_categories` (`category_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_category_images` VALUES (1,2,'',434,555,NULL,1,'igoods.png','','image/png','r',265767,1394109447),(2,3,'',434,555,NULL,1,'igoods.png','','image/png','r',265767,1394109447),(3,4,'',600,640,NULL,1,'1814_star_trek_command_cycle_jersey.jpeg','','image/jpeg','r',56283,1278412215),(4,5,'',600,590,NULL,1,'ijrm_back_to_the_future_vinyl_idols.png','','image/png','r',276157,1543299905),(5,6,'',600,590,NULL,1,'ijrm_back_to_the_future_vinyl_idols.png','','image/png','r',276157,1543299905),(6,7,'',600,481,NULL,1,'ivvg_beer_briefcase_1.jpeg','','image/jpeg','r',54394,1543299905),(7,8,'',600,600,NULL,1,'17f0_3d_bmo_mug_1.jpeg','','image/jpeg','r',38929,1543299906);
CREATE TABLE `xlite_payment_method_settings` (
  `setting_id` int(11) NOT NULL AUTO_INCREMENT,
  `method_id` int(11) DEFAULT NULL,
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`setting_id`),
  KEY `IDX_33B9DA0019883967` (`method_id`),
  KEY `mn` (`method_id`,`name`),
  CONSTRAINT `FK_33B9DA0019883967` FOREIGN KEY (`method_id`) REFERENCES `xlite_payment_methods` (`method_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_payment_method_settings` VALUES (1,8,'vendor',''),(2,8,'user',''),(3,8,'pwd',''),(4,8,'partner','PayPal'),(5,8,'prefix','mystore_'),(6,8,'transaction_type','S'),(7,8,'mode','test'),(8,8,'buyNowEnabled','1'),(9,9,'vendor',''),(10,9,'user',''),(11,9,'pwd',''),(12,9,'partner','PayPal'),(13,9,'prefix','mystore_'),(14,9,'transaction_type','S'),(15,9,'mode','test'),(16,10,'vendor',''),(17,10,'user',''),(18,10,'pwd',''),(19,10,'partner','PayPal'),(20,10,'prefix','mystore_'),(21,10,'transaction_type','S'),(22,10,'mode','test'),(23,10,'buyNowEnabled','1'),(24,11,'account',''),(25,11,'description',''),(26,11,'prefix','mystore_'),(27,11,'mode','test'),(28,12,'api_type','email'),(29,12,'email',''),(30,12,'api_solution','paypal'),(31,12,'vendor',''),(32,12,'user',''),(33,12,'pwd',''),(34,12,'partner','PayPal'),(35,12,'api_username',''),(36,12,'api_password',''),(37,12,'auth_method','signature'),(38,12,'signature',''),(39,12,'certificate',''),(40,12,'prefix','mystore_'),(41,12,'transaction_type','S'),(42,12,'mode','test'),(43,12,'merchantId',''),(44,12,'buyNowEnabled','1'),(45,13,'enabled','1'),(46,13,'agreement','N'),(47,13,'email',''),(48,13,'publisherId',''),(49,13,'bannerOnHomePage','D'),(50,13,'bannerOnCategoryPages','D'),(51,13,'bannerOnProductDetailsPages','A'),(52,13,'bannerOnCartPage','C'),(53,14,'app_id',''),(54,14,'api_username',''),(55,14,'api_password',''),(56,14,'signature',''),(57,14,'paypal_login',''),(58,14,'partner','PayPal'),(59,14,'feesPayer','PRIMARYRECEIVER'),(60,14,'matchCriteria','name'),(61,14,'prefix','mystore_'),(62,14,'transaction_type','S'),(63,14,'mode','test'),(64,14,'buyNowEnabled','1'),(65,15,'email',''),(66,15,'client_id',''),(67,15,'secret',''),(68,15,'partner_id',''),(69,15,'bn_code',''),(70,15,'additional_partner_referral_id',''),(71,15,'additional_merchant_id',''),(72,15,'payment_descriptor',''),(73,15,'prefix','mystore_'),(74,15,'transaction_type','S'),(75,15,'mode','test'),(76,15,'disburse_funds','INSTANT'),(77,17,'login',''),(78,17,'key',''),(79,17,'signature',''),(80,17,'type','sale'),(81,17,'test','1'),(82,17,'prefix','xcart'),(83,17,'hash_key',''),(84,17,'hash_type','sha512'),(85,49,'login',''),(86,49,'prefix','xcart'),(87,49,'hash',''),(88,49,'include_response','N'),(89,50,'account',''),(90,50,'secret',''),(91,50,'language','en'),(92,50,'mode','test'),(93,50,'prefix','xcart'),(94,50,'currency','USD'),(95,52,'pspid',''),(96,52,'sha_in',''),(97,52,'sha_out',''),(98,52,'currency','GBP'),(99,52,'test','1'),(100,52,'prefix','xcart_'),(101,52,'debug_enabled','0'),(102,53,'merchant_id',''),(103,53,'subid','0'),(104,53,'pub_cert','rabobank.cer'),(105,53,'pub_key',''),(106,53,'private_key',''),(107,53,'private_key_pass',''),(108,53,'currency','EUR'),(109,53,'test','Y'),(110,53,'prefix','xcart_'),(111,53,'debug_enabled','0'),(112,54,'vendorName',''),(113,54,'password',''),(114,54,'type','sale'),(115,54,'test','1'),(116,54,'prefix','xcart'),(117,55,'publishKey',''),(118,55,'accessToken',''),(119,55,'publishKeyTest',''),(120,55,'accessTokenTest',''),(121,55,'mode','live'),(122,55,'type','sale'),(123,55,'prefix','xcart'),(124,55,'userId',''),(125,55,'refreshToken',''),(126,56,'pspid',''),(127,56,'shaIn',''),(128,56,'shaOut',''),(129,56,'prefix','xcart'),(130,56,'mode','test'),(131,57,'store_id',''),(132,57,'hpp_key',''),(133,57,'mode','test'),(134,57,'prefix','xcart'),(135,57,'currency','USD'),(136,58,'merchant_id',''),(137,58,'mode',''),(138,58,'access_key',''),(139,58,'secret_key',''),(140,58,'client_id',''),(141,58,'region','USD'),(142,58,'capture_mode','C'),(143,58,'sync_mode','S'),(144,58,'order_id_prefix',''),(145,59,'prefix',''),(146,59,'merchantId',''),(147,59,'accessToken',''),(148,59,'refreshToken',''),(149,59,'merchantAccountId',''),(150,59,'kountMerchantId',''),(151,59,'isAutoSettle',''),(152,59,'testMode','1'),(153,59,'isPayPal','0'),(154,59,'paypalButtonColor','gold'),(155,59,'paypalButtonShape','pill'),(156,59,'is3dSecure','0'),(157,59,'isAcceptNo3dSecure','0'),(158,59,'is3dSecureForVault','0'),(159,59,'isUseVault','1'),(160,59,'isShowSaveCardBox','1'),(161,60,'api_login_id',''),(162,60,'transaction_key',''),(163,60,'public_key',''),(164,60,'type','sale'),(165,60,'mode','test'),(166,60,'prefix','xcart');
CREATE TABLE `xlite_entity_type_versions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `entityType` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `version` char(36) COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_4A1BBA741F08814A` (`entityType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_entity_type_versions` VALUES (6,'XLite\\Model\\Currency','1d356e04-7dc6-4f74-8b1f-8a48057b597f'),(7,'XLite\\Model\\CurrencyTranslation','ce4fdf84-b048-4298-9cca-a6e43ea931b1'),(8,'XLite\\Model\\Membership','b8bc6ad4-9143-4539-9c14-746dbee62f32'),(9,'XLite\\Model\\MembershipTranslation','0d1c1fd1-d77d-4596-b568-cb8d25fd2085'),(10,'XLite\\Model\\Language','2532036b-5cd5-417a-aba8-9879deb16f42'),(11,'XLite\\Model\\LanguageTranslation','8d8bf695-9ce4-47aa-8f88-5cfb735cdff5'),(15,'XLite\\Model\\Country','806c717b-102b-4780-974c-e7d4c217d02f'),(16,'XLite\\Model\\CountryTranslation','fe42a700-b75c-455d-abb1-f050c3ea0731'),(17,'XLite\\Model\\State','c530e3f7-f29d-4eb4-a48f-9f29298f93b8'),(18,'XLite\\Model\\Region','a89d589c-3276-4e74-96f8-03d3bcd50057'),(27,'XLite\\Model\\AddressField','b1a2b767-1d33-4971-a626-ca2145d4afd8'),(28,'XLite\\Model\\AddressFieldTranslation','a5fd083e-cf73-4c48-a6fe-b199eed5181f'),(30,'XLite\\Model\\Order\\Status\\Payment','efa4d80e-09bf-40f7-8723-4ae88859ca4d'),(31,'XLite\\Model\\Order\\Status\\PaymentTranslation','9ef19c57-ebbb-4136-a1e7-a42368642aa1'),(38,'XLite\\Model\\SearchFilter','3eccf4e8-7735-4375-8cb4-dcac08409169'),(39,'XLite\\Model\\SearchFilterTranslation','955b3322-1a90-4728-9389-bab04975ddbf'),(40,'XLite\\Model\\AccessControlEntityType','b3da0202-f6f3-4946-a0b9-c533592df76b'),(41,'XLite\\Model\\AccessControlZoneType','c97f29c5-102a-48c6-9f93-11064b019bac'),(126,'XLite\\Model\\MoneyModificator','e452cc86-e300-4452-b394-db449fdca1f5'),(137,'XLite\\Module\\CDev\\SimpleCMS\\Model\\Page','b2cae00f-9567-452e-8e30-2e8fc5d6731d'),(139,'XLite\\Module\\CDev\\SimpleCMS\\Model\\PageTranslation','b2a72efd-359b-47ad-a141-f78b0f95acce'),(152,'XLite\\Model\\Role','8dc45f8e-22e7-4265-9085-b78db2fff968'),(153,'XLite\\Model\\RoleTranslation','854332b5-a3d4-460c-ac9a-03641160f916'),(219,'XLite\\Model\\ImageSettings','9bd14a11-d554-4ace-8d40-a7c4a9bb364b'),(235,'XLite\\Model\\Task','b5e3eb09-8cdb-4e9a-be09-85e0110dab90'),(258,'XLite\\Model\\Order\\Status\\Shipping','d458cc00-8e91-4ea5-a131-20189ed21289'),(259,'XLite\\Model\\Order\\Status\\ShippingTranslation','ce76d8fe-a095-49fc-8e91-9224b39ec6c3'),(260,'XLite\\Model\\Order\\Status\\Property','452fccd9-c937-494d-b364-a73304881efc'),(263,'XLite\\Model\\Role\\Permission','ae8fcc49-6043-4114-8a98-4dda3406f8ef'),(271,'XLite\\Model\\Role\\PermissionTranslation','9d67859e-0afc-466c-8f3d-ac02aa341474'),(305,'XLite\\Model\\Order\\Modifier','81833939-677c-4bd9-a403-04539cdcd4f1'),(347,'XLite\\Model\\Notification','9b98d552-aad2-423a-bfc6-989ba3897df7'),(348,'XLite\\Model\\NotificationTranslation','8941bcc4-b29e-4e4b-86ac-7fb5f88103e7'),(381,'XLite\\Model\\Payment\\Method','907da786-2365-4376-b087-39cb831ae26a'),(382,'XLite\\Model\\Payment\\MethodTranslation','1b4a415a-fc66-4b93-a768-6e39f8feab7a'),(383,'XLite\\Model\\Payment\\MethodSetting','05835b73-54e4-4daf-abc1-10cd820291a3'),(384,'XLite\\Model\\LanguageLabel','abf42b91-b79f-4ff2-959d-ddd94c5a0ce3'),(385,'XLite\\Model\\LanguageLabelTranslation','3d84c467-7b8f-4fa1-9d00-611c3782a479'),(595,'XLite\\Model\\ProductTranslation','63ca4361-b932-4ada-9ae7-861e58e5ad6d'),(646,'XLite\\Model\\Image\\Category\\Banner','9e391e2e-fa0b-4c69-9146-a76229370709'),(674,'XLite\\Model\\CleanURL','19b2f349-3e18-428f-a978-91532a5ab829'),(675,'XLite\\Model\\Image\\Category\\Image','23277281-69ff-43de-baea-7e8a292ba7ac'),(676,'XLite\\Model\\CategoryTranslation','742f3438-84e3-4300-8a4d-924c05c5f48b'),(679,'XLite\\Model\\CategoryProducts','ff44c67c-7c31-4b25-af21-82ccfa269136'),(680,'XLite\\Model\\Category\\QuickFlags','683208c1-4665-47a2-9b45-93f37bffbcda'),(681,'XLite\\Model\\Config','906d2100-2dd0-4127-a1af-ec3565beb62c'),(682,'XLite\\Model\\ConfigTranslation','218b4445-ed4f-4bc3-9134-449468decc7c'),(683,'XLite\\Model\\BannerRotationSlide','e6cee0de-26a0-4f60-963c-9736e656bd2c'),(684,'XLite\\Model\\Image\\BannerRotationImage','5857de11-08af-4c2b-ab15-c9f195baa20e'),(693,'XLite\\Module\\XC\\CustomProductTabs\\Model\\Product\\CustomGlobalTab','92929ab8-14b6-4bb2-b016-0fe75acdb620'),(695,'XLite\\Model\\Product\\GlobalTabProvider','2f0ad744-294b-4701-bc2e-8e8244501708'),(696,'XLite\\Module\\XC\\CustomProductTabs\\Model\\Product\\CustomGlobalTabTranslation','0256471c-37b1-41f1-8be3-978e4e437d4d'),(697,'XLite\\Model\\Product\\GlobalTab','8a4a51ed-5b20-4956-928a-f235cf571b88'),(705,'XLite\\Module\\CDev\\FeaturedProducts\\Model\\FeaturedProduct','c5782ca0-20cc-4987-ad18-acf816e1cdcd'),(721,'XLite\\Module\\CDev\\SimpleCMS\\Model\\Menu','c07819ca-5898-49cf-9951-40e861479c5e'),(722,'XLite\\Module\\CDev\\SimpleCMS\\Model\\MenuTranslation','a3f20eee-e0df-48af-ba2a-55f2d2cbe6bd'),(723,'XLite\\Module\\CDev\\SimpleCMS\\Model\\Menu\\QuickFlags','5a69b283-83aa-4d7d-a938-94150e8cd651'),(772,'XLite\\Model\\Category','4e3aaed5-e9e8-49d4-8b0f-6ea91fd49410'),(807,'XLite\\Model\\Payment\\TransactionData','b8bbd3e7-0ce7-460f-a9cb-4612ec6efb4e'),(812,'XLite\\Model\\Profile','05246f06-7cef-4387-9046-a529c75e287f'),(813,'XLite\\Model\\Address','65ef429b-3de6-4390-bdf7-6a0e2d95bed2'),(814,'XLite\\Model\\AddressFieldValue','454c1cf7-7614-411a-98e6-5f949ce9ca10'),(815,'XLite\\Model\\Payment\\Transaction','310fb43d-6a87-4cbb-8527-fc6fc505be59'),(817,'XLite\\Model\\Order','5fac59d9-cc3b-49b5-9254-06070e02e9c3'),(818,'XLite\\Model\\OrderItem','6da8f386-fdcd-4d19-b6c4-91d248047dbf'),(819,'XLite\\Model\\Order\\Surcharge','29054735-6cc6-43e2-977e-9d26a79c0f17'),(820,'XLite\\Model\\OrderHistoryEvents','d36bf0e6-a851-43fe-ab7f-35efbf6d38a2'),(842,'XLite\\Model\\Product','d5ee44d3-34b4-4841-9471-86d593b6c119'),(843,'XLite\\Model\\QuickData','ce5ff211-3192-4147-88b7-7f44c1399846'),(845,'XLite\\Model\\ZoneElement','bbf3c447-f9df-4edd-adc2-ea83a14a6c36'),(915,'XLite\\Model\\Shipping\\Method','abe45408-50f0-4db1-9bda-9627642deaa6'),(916,'XLite\\Model\\Shipping\\MethodTranslation','40ca7c23-ac2b-471c-8875-5845632d11a1'),(917,'XLite\\Model\\Shipping\\Markup','b80cd2cb-28d5-4b8c-ba20-ade0def9bb52'),(918,'XLite\\Model\\Zone','99dcf4e5-521e-4bcb-95cf-c4e41b1496f0'),(919,'XLite\\Model\\ViewList','a2e7e388-b9cc-45c9-8ecc-59a4c5ac18ea'),(920,'XLite\\Model\\Module','ca9d977c-3295-49e2-8b0d-868fc8493e38'),(921,'XLite\\Model\\Image\\Product\\Image','fefa4fa5-7ebf-4f48-aa6a-7a8ea57d938f');
CREATE TABLE `xlite_tax_classes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `position` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_usps_shipment` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  `transactionId` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `requestData` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  `responseData` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  `printDate` int(11) NOT NULL,
  `price` decimal(14,4) NOT NULL,
  `shipmentId` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `trackingNumber` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `trackingData` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  `labelURL` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `labelContent` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  PRIMARY KEY (`id`),
  KEY `IDX_9426ED218D9F6D38` (`order_id`),
  CONSTRAINT `FK_9426ED218D9F6D38` FOREIGN KEY (`order_id`) REFERENCES `xlite_orders` (`order_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_zones` (
  `zone_id` int(11) NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL,
  PRIMARY KEY (`zone_id`),
  KEY `zone_name` (`zone_name`),
  KEY `zone_default` (`is_default`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_zones` VALUES (1,'All Addresses (default zone)',1),(2,'United States',0),(3,'North of United States & Canada',0),(4,'Europe',0);
CREATE TABLE `xlite_attribute_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_class_id` int(10) unsigned DEFAULT NULL,
  `position` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_59E382E821B06187` (`product_class_id`),
  CONSTRAINT `FK_59E382E821B06187` FOREIGN KEY (`product_class_id`) REFERENCES `xlite_product_classes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_attribute_groups` VALUES (1,2,10),(2,2,20),(3,2,30);
CREATE TABLE `xlite_profile_addresses` (
  `address_id` int(11) NOT NULL AUTO_INCREMENT,
  `profile_id` int(11) DEFAULT NULL,
  `state_id` int(11) DEFAULT NULL,
  `country_code` char(2) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_billing` tinyint(1) NOT NULL,
  `is_shipping` tinyint(1) NOT NULL,
  `isWork` tinyint(1) NOT NULL,
  `address_type` char(1) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`address_id`),
  KEY `IDX_A6B45064CCFA12B8` (`profile_id`),
  KEY `IDX_A6B450645D83CC1` (`state_id`),
  KEY `IDX_A6B45064F026BB7C` (`country_code`),
  KEY `is_billing` (`is_billing`),
  KEY `is_shipping` (`is_shipping`),
  CONSTRAINT `FK_A6B45064F026BB7C` FOREIGN KEY (`country_code`) REFERENCES `xlite_countries` (`code`) ON DELETE SET NULL,
  CONSTRAINT `FK_A6B450645D83CC1` FOREIGN KEY (`state_id`) REFERENCES `xlite_states` (`state_id`) ON DELETE SET NULL,
  CONSTRAINT `FK_A6B45064CCFA12B8` FOREIGN KEY (`profile_id`) REFERENCES `xlite_profiles` (`profile_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_profile_addresses` VALUES (1,1,NULL,'US',1,1,0,'R'),(2,2,NULL,'US',1,1,0,'R'),(3,3,NULL,'US',1,1,0,'R'),(4,4,NULL,'US',1,1,0,'R'),(5,5,NULL,'US',1,1,0,'R'),(6,6,NULL,'US',1,1,0,'R');
CREATE TABLE `xlite_mailchimp_segment_subscriptions` (
  `segment_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `profile_id` int(11) NOT NULL,
  PRIMARY KEY (`segment_id`,`profile_id`),
  KEY `IDX_CE45B298DB296AAD` (`segment_id`),
  KEY `IDX_CE45B298CCFA12B8` (`profile_id`),
  CONSTRAINT `FK_CE45B298CCFA12B8` FOREIGN KEY (`profile_id`) REFERENCES `xlite_profiles` (`profile_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_CE45B298DB296AAD` FOREIGN KEY (`segment_id`) REFERENCES `xlite_mailchimp_list_segments` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_product_stats` (
  `stat_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `viewed_product_id` int(10) unsigned DEFAULT NULL,
  `bought_product_id` int(10) unsigned DEFAULT NULL,
  `count` int(10) unsigned NOT NULL,
  PRIMARY KEY (`stat_id`),
  KEY `IDX_B01836BC658EF086` (`viewed_product_id`),
  KEY `IDX_B01836BC3BA20971` (`bought_product_id`),
  CONSTRAINT `FK_B01836BC3BA20971` FOREIGN KEY (`bought_product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_B01836BC658EF086` FOREIGN KEY (`viewed_product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_customer_attachments_storage` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `item_id` int(11) DEFAULT NULL,
  `path` varchar(512) COLLATE utf8_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_ACB714E4126F525E` (`item_id`),
  CONSTRAINT `FK_ACB714E4126F525E` FOREIGN KEY (`item_id`) REFERENCES `xlite_order_items` (`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_product_tabs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned DEFAULT NULL,
  `global_tab_id` int(10) unsigned DEFAULT NULL,
  `position` int(11) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `link` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `product_global_tab` (`product_id`,`global_tab_id`),
  KEY `IDX_F5B7716D4584665A` (`product_id`),
  KEY `IDX_F5B7716D629D8673` (`global_tab_id`),
  CONSTRAINT `FK_F5B7716D629D8673` FOREIGN KEY (`global_tab_id`) REFERENCES `xlite_global_product_tabs` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_F5B7716D4584665A` FOREIGN KEY (`product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_product_tabs` VALUES (1,1,5,-10,1,NULL),(2,2,5,-10,1,NULL),(3,3,5,-10,1,NULL),(4,4,5,-10,1,NULL),(5,5,5,-10,1,NULL),(6,6,5,-10,1,NULL),(7,7,5,-10,1,NULL),(8,8,5,-10,1,NULL),(9,9,5,-10,1,NULL),(10,10,5,-10,1,NULL),(11,11,5,-10,1,NULL),(12,12,5,-10,1,NULL),(13,13,5,-10,1,NULL),(14,14,5,-10,1,NULL),(15,15,5,-10,1,NULL),(16,16,5,-10,1,NULL),(17,17,5,-10,1,NULL),(18,18,5,-10,1,NULL),(19,19,5,-10,1,NULL),(20,20,5,-10,1,NULL),(21,21,5,-10,1,NULL),(22,22,5,-10,1,NULL),(23,23,5,-10,1,NULL),(24,24,5,-10,1,NULL),(25,25,5,-10,1,NULL),(26,26,5,-10,1,NULL),(27,27,5,-10,1,NULL),(28,28,5,-10,1,NULL),(29,29,5,-10,1,NULL),(30,30,5,-10,1,NULL),(31,31,5,-10,1,NULL),(32,32,5,-10,1,NULL),(33,33,5,-10,1,NULL),(34,34,5,-10,1,NULL),(35,35,5,-10,1,NULL),(36,36,5,-10,1,NULL),(37,37,5,-10,1,NULL),(38,38,5,-10,1,NULL),(39,39,5,-10,1,NULL),(40,40,5,-10,1,NULL),(41,41,5,-10,1,NULL),(42,42,5,-10,1,NULL),(64,1,6,-10,1,NULL),(65,2,6,-10,1,NULL),(66,3,6,-10,1,NULL),(67,4,6,-10,1,NULL),(68,5,6,-10,1,NULL),(69,6,6,-10,1,NULL),(70,7,6,-10,1,NULL),(71,8,6,-10,1,NULL),(72,9,6,-10,1,NULL),(73,10,6,-10,1,NULL),(74,11,6,-10,1,NULL),(75,12,6,-10,1,NULL),(76,13,6,-10,1,NULL),(77,14,6,-10,1,NULL),(78,15,6,-10,1,NULL),(79,16,6,-10,1,NULL),(80,17,6,-10,1,NULL),(81,18,6,-10,1,NULL),(82,19,6,-10,1,NULL),(83,20,6,-10,1,NULL),(84,21,6,-10,1,NULL),(85,22,6,-10,1,NULL),(86,23,6,-10,1,NULL),(87,24,6,-10,1,NULL),(88,25,6,-10,1,NULL),(89,26,6,-10,1,NULL),(90,27,6,-10,1,NULL),(91,28,6,-10,1,NULL),(92,29,6,-10,1,NULL),(93,30,6,-10,1,NULL),(94,31,6,-10,1,NULL),(95,32,6,-10,1,NULL),(96,33,6,-10,1,NULL),(97,34,6,-10,1,NULL),(98,35,6,-10,1,NULL),(99,36,6,-10,1,NULL),(100,37,6,-10,1,NULL),(101,38,6,-10,1,NULL),(102,39,6,-10,1,NULL),(103,40,6,-10,1,NULL),(104,41,6,-10,1,NULL),(105,42,6,-10,1,NULL),(127,1,7,-10,1,NULL),(128,2,7,-10,1,NULL),(129,3,7,-10,1,NULL),(130,4,7,-10,1,NULL),(131,5,7,-10,1,NULL),(132,6,7,-10,1,NULL),(133,7,7,-10,1,NULL),(134,8,7,-10,1,NULL),(135,9,7,-10,1,NULL),(136,10,7,-10,1,NULL),(137,11,7,-10,1,NULL),(138,12,7,-10,1,NULL),(139,13,7,-10,1,NULL),(140,14,7,-10,1,NULL),(141,15,7,-10,1,NULL),(142,16,7,-10,1,NULL),(143,17,7,-10,1,NULL),(144,18,7,-10,1,NULL),(145,19,7,-10,1,NULL),(146,20,7,-10,1,NULL),(147,21,7,-10,1,NULL),(148,22,7,-10,1,NULL),(149,23,7,-10,1,NULL),(150,24,7,-10,1,NULL),(151,25,7,-10,1,NULL),(152,26,7,-10,1,NULL),(153,27,7,-10,1,NULL),(154,28,7,-10,1,NULL),(155,29,7,-10,1,NULL),(156,30,7,-10,1,NULL),(157,31,7,-10,1,NULL),(158,32,7,-10,1,NULL),(159,33,7,-10,1,NULL),(160,34,7,-10,1,NULL),(161,35,7,-10,1,NULL),(162,36,7,-10,1,NULL),(163,37,7,-10,1,NULL),(164,38,7,-10,1,NULL),(165,39,7,-10,1,NULL),(166,40,7,-10,1,NULL),(167,41,7,-10,1,NULL),(168,42,7,-10,1,NULL),(190,37,NULL,0,1,'Privacy'),(191,42,NULL,0,1,'Privacy'),(192,1,1,-80,1,NULL),(193,2,1,-80,1,NULL),(194,3,1,-80,1,NULL),(195,4,1,-80,1,NULL),(196,5,1,-80,1,NULL),(197,6,1,-80,1,NULL),(198,7,1,-80,1,NULL),(199,8,1,-80,1,NULL),(200,9,1,-80,1,NULL),(201,10,1,-80,1,NULL),(202,11,1,-80,1,NULL),(203,12,1,-80,1,NULL),(204,13,1,-80,1,NULL),(205,14,1,-80,1,NULL),(206,15,1,-80,1,NULL),(207,16,1,-80,1,NULL),(208,17,1,-80,1,NULL),(209,18,1,-80,1,NULL),(210,19,1,-80,1,NULL),(211,20,1,-80,1,NULL),(212,21,1,-80,1,NULL),(213,22,1,-80,1,NULL),(214,23,1,-80,1,NULL),(215,24,1,-80,1,NULL),(216,25,1,-80,1,NULL),(217,26,1,-80,1,NULL),(218,27,1,-80,1,NULL),(219,28,1,-80,1,NULL),(220,29,1,-80,1,NULL),(221,30,1,-80,1,NULL),(222,31,1,-80,1,NULL),(223,32,1,-80,1,NULL),(224,33,1,-80,1,NULL),(225,34,1,-80,1,NULL),(226,35,1,-80,1,NULL),(227,36,1,-80,1,NULL),(228,37,1,-80,1,NULL),(229,38,1,-80,1,NULL),(230,39,1,-80,1,NULL),(231,40,1,-80,1,NULL),(232,41,1,-80,1,NULL),(233,42,1,-80,1,NULL),(255,1,2,-70,1,NULL),(256,2,2,-70,1,NULL),(257,3,2,-70,1,NULL),(258,4,2,-70,1,NULL),(259,5,2,-70,1,NULL),(260,6,2,-70,1,NULL),(261,7,2,-70,1,NULL),(262,8,2,-70,1,NULL),(263,9,2,-70,1,NULL),(264,10,2,-70,1,NULL),(265,11,2,-70,1,NULL),(266,12,2,-70,1,NULL),(267,13,2,-70,1,NULL),(268,14,2,-70,1,NULL),(269,15,2,-70,1,NULL),(270,16,2,-70,1,NULL),(271,17,2,-70,1,NULL),(272,18,2,-70,1,NULL),(273,19,2,-70,1,NULL),(274,20,2,-70,1,NULL),(275,21,2,-70,1,NULL),(276,22,2,-70,1,NULL),(277,23,2,-70,1,NULL),(278,24,2,-70,1,NULL),(279,25,2,-70,1,NULL),(280,26,2,-70,1,NULL),(281,27,2,-70,1,NULL),(282,28,2,-70,1,NULL),(283,29,2,-70,1,NULL),(284,30,2,-70,1,NULL),(285,31,2,-70,1,NULL),(286,32,2,-70,1,NULL),(287,33,2,-70,1,NULL),(288,34,2,-70,1,NULL),(289,35,2,-70,1,NULL),(290,36,2,-70,1,NULL),(291,37,2,-70,1,NULL),(292,38,2,-70,1,NULL),(293,39,2,-70,1,NULL),(294,40,2,-70,1,NULL),(295,41,2,-70,1,NULL),(296,42,2,-70,1,NULL),(318,1,3,-60,1,NULL),(319,2,3,-60,1,NULL),(320,3,3,-60,1,NULL),(321,4,3,-60,1,NULL),(322,5,3,-60,1,NULL),(323,6,3,-60,1,NULL),(324,7,3,-60,1,NULL),(325,8,3,-60,1,NULL),(326,9,3,-60,1,NULL),(327,10,3,-60,1,NULL),(328,11,3,-60,1,NULL),(329,12,3,-60,1,NULL),(330,13,3,-60,1,NULL),(331,14,3,-60,1,NULL),(332,15,3,-60,1,NULL),(333,16,3,-60,1,NULL),(334,17,3,-60,1,NULL),(335,18,3,-60,1,NULL),(336,19,3,-60,1,NULL),(337,20,3,-60,1,NULL),(338,21,3,-60,1,NULL),(339,22,3,-60,1,NULL),(340,23,3,-60,1,NULL),(341,24,3,-60,1,NULL),(342,25,3,-60,1,NULL),(343,26,3,-60,1,NULL),(344,27,3,-60,1,NULL),(345,28,3,-60,1,NULL),(346,29,3,-60,1,NULL),(347,30,3,-60,1,NULL),(348,31,3,-60,1,NULL),(349,32,3,-60,1,NULL),(350,33,3,-60,1,NULL),(351,34,3,-60,1,NULL),(352,35,3,-60,1,NULL),(353,36,3,-60,1,NULL),(354,37,3,-60,1,NULL),(355,38,3,-60,1,NULL),(356,39,3,-60,1,NULL),(357,40,3,-60,1,NULL),(358,41,3,-60,1,NULL),(359,42,3,-60,1,NULL),(381,1,4,-30,1,NULL),(382,2,4,-30,1,NULL),(383,3,4,-30,1,NULL),(384,4,4,-30,1,NULL),(385,5,4,-30,1,NULL),(386,6,4,-30,1,NULL),(387,7,4,-30,1,NULL),(388,8,4,-30,1,NULL),(389,9,4,-30,1,NULL),(390,10,4,-30,1,NULL),(391,11,4,-30,1,NULL),(392,12,4,-30,1,NULL),(393,13,4,-30,1,NULL),(394,14,4,-30,1,NULL),(395,15,4,-30,1,NULL),(396,16,4,-30,1,NULL),(397,17,4,-30,1,NULL),(398,18,4,-30,1,NULL),(399,19,4,-30,1,NULL),(400,20,4,-30,1,NULL),(401,21,4,-30,1,NULL),(402,22,4,-30,1,NULL),(403,23,4,-30,1,NULL),(404,24,4,-30,1,NULL),(405,25,4,-30,1,NULL),(406,26,4,-30,1,NULL),(407,27,4,-30,1,NULL),(408,28,4,-30,1,NULL),(409,29,4,-30,1,NULL),(410,30,4,-30,1,NULL),(411,31,4,-30,1,NULL),(412,32,4,-30,1,NULL),(413,33,4,-30,1,NULL),(414,34,4,-30,1,NULL),(415,35,4,-30,1,NULL),(416,36,4,-30,1,NULL),(417,37,4,-30,1,NULL),(418,38,4,-30,1,NULL),(419,39,4,-30,1,NULL),(420,40,4,-30,1,NULL),(421,41,4,-30,1,NULL),(422,42,4,-30,1,NULL);
CREATE TABLE `xlite_mailchimp_lists` (
  `id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `date_created` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `date_updated` int(11) NOT NULL,
  `list_rating` decimal(3,2) NOT NULL,
  `subscribe_url_short` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `subscribe_url_long` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `member_count` int(11) NOT NULL,
  `open_rate` decimal(5,2) NOT NULL,
  `click_rate` decimal(5,2) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `subscribeByDefault` tinyint(1) NOT NULL,
  `isRemoved` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_product_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8_unicode_ci NOT NULL,
  `briefDescription` longtext COLLATE utf8_unicode_ci NOT NULL,
  `metaTags` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `metaDesc` longtext COLLATE utf8_unicode_ci NOT NULL,
  `metaTitle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  KEY `name` (`name`),
  CONSTRAINT `FK_F48089BABF396750` FOREIGN KEY (`id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_product_translations` VALUES (1,1,'Mordorable! Fitted Ladies\' Tee','<h4 class=\"prodheader\">TALK ABOUT PRECIOUSSSSS!</h4>\n<p>One does not simply walk into Mordor. It\'s best if one <em>skips</em>. Holding hands and singing showtunes, preferably. This shirt features a montage of all the cuteness that\'s to be had when you visit Mordor. There\'s little Gollum waving hello or goodbye or something to The One Ring. Isn\'t it preciousssss? A big ol\' snuggledy battle troll waits patiently to give out \"Free Hugs,\" and an Uruk-hai says \"o hai!\" over his shoulder. In the distance, there\'s Mount Doom with its explosion of lava (read: candy) and happy, puffy clouds of vog. Through the sky flies a friendly Nazgul on his Fell Beast (rawr!). The whole scene is watched over by the big, blinky eye of Sauron perched between the pinnacles of Barad-dûr. Face it. It\'s Mordorable.</p>\n<p>All the cuteness of Mordor is captured on this teal babydoll shirt. Fitted in juniors sizes. Despite the above description, ThinkGeek warns of the potential risks of traveling to Mordor and urges caution when traveling there. And you should definitely be up on your immunizations.</p>','<p>Who doesn\'t want to go to Mordor? With its mountain vistas and minimalist landscapes, your vacation photos are sure to turn out great. (Did we mention black is slimming?) Ancient castles to visit. New species to observe. It\'s the adventure of a lifetime</p>','','Who doesn\'t want to go to Mordor? With its mountain vistas and minimalist landscapes, your vacation photos are sure to turn out great. (Did we mention black is slimming?) Ancient castles to visit. New species to observe. It\'s the adventure of a lifetime','','en'),(2,2,'Octopus Cardigan','<h4 class=\"prodheader\">FOR HUMANS</h4>\n<p>What would you do with eight arms? At first, we thought, \"FOUR LAPTOPS!\" Then we realized that we still only had one pair of eyes. Now we\'re thinking two laptops, an iPod, some knitting, and one arm left for scratching any itches that arise. (Ever notice how you always get itchy whenever your hands are full or nail polish is drying? Pesky!)</p>\n<p>This Octopus Cardigan is for two-armed lifeforms, specifically humanoid. It is 100% cotton black colored cardigan with green Octopus design. See the chart below to select your size.</p>\n<table><tbody><tr><td> </td>\n<td>S</td>\n<td>M</td>\n<td>L</td>\n<td>XL</td>\n</tr><tr><td>Chest</td>\n<td>34 in.</td>\n<td>36 in.</td>\n<td>38 in.</td>\n<td>41 in.</td>\n</tr><tr><td>Length</td>\n<td>16 in.</td>\n<td>16 1/4 in.</td>\n<td>16 1/2 in.</td>\n<td>16 3/4 in.</td>\n</tr></tbody></table>','<p>No, no, not a cardigan FOR an octopus. This one only has two arms, so it\'s for a human. Of course, if you knew a cold octopus, this could warm two of its limbs.</p>','','No, no, not a cardigan FOR an octopus. This one only has two arms, so it\'s for a human. Of course, if you knew a cold octopus, this could warm two of its limbs.','','en'),(3,3,'Spiderman Selfie Ladies\' Tee','<h4 class=\"prodheader\">SELFIE SENSES TINGLING</h4>\n<p>Being a photojournalist for the <em>Daily Bugle</em>, you\'d think Peter Parker would understand how selfies work. Although maybe he\'s taking this shot in a mirror and he\'s going to scan the finished product and post it to Facebook. Or maybe the word \"FLASH!\" in the burst is actually a tip that The Flash is just off the side of this image taking a picture with his phone of Spidey with his camera. Although that would be comic book universes colliding.... Maybe we think about things too much.</p>\n<p>Spiderman taking a photo with the hashtag #amazing beneath on the front of this black, 100% cotton ladies\' shirt. Machine wash cold. Tumble dry low or lay flat to dry. Imported.</p>\n<p><em>Please note that the model is wearing a size medium.</em></p>\n<p>Sizing Table</p>\n<table><tbody><tr><td> </td>\n<td>S</td>\n<td>M</td>\n<td>L</td>\n<td>XL</td>\n<td>2X</td>\n<td>3X</td>\n<td> </td>\n</tr><tr><td>Chest</td>\n<td>32 in.</td>\n<td>34 in.</td>\n<td>36 in.</td>\n<td>38 in.</td>\n<td>40 in.</td>\n<td>42 in.</td>\n<td>  </td>\n</tr><tr><td>Body Length</td>\n<td>25 3/4 in.</td>\n<td>26 1/2 in.</td>\n<td>27 1/4 in.</td>\n<td>28 in.</td>\n<td>28 3/4 in.</td>\n<td>30 in.</td>\n</tr></tbody></table>','<p>We\'ll just warn you that if you check this hashtag your mileage may vary. What people think is \"amazing\" differs vastly.</p>','','We\'ll just warn you that if you check this hashtag your mileage may vary. What people think is \"amazing\" differs vastly.','','en'),(4,4,'Star Wars Tissue-Weight Fitted Ladies\' Tee','<h4 class=\"prodheader\">ARE YOU A FAN?</h4>\n<p>As female Star Wars fans, our cosplay options were previously fairly limited. Leia, Slave Leia, maybe a Twi\'lek if you had the patience to paint yourself blue. But thanks to some brave pioneers, crossplay is alive and well in the Star Wars fandom, so we can freely be totally awesome versions of Han Solo, Boba Fett, or even Chewbacca. We\'ve tailored our costumes to meet the needs of our bodies <em>and</em> our fandom. The same should go for our t-shirts, right?</p>\n<p>Star Wars printed in white on a tissue-weight, heather plum, 65% cotton / 35% polyester babydoll (fitted) shirt.</p>\n<p>Note: Please reference the table below to choose your size.</p>\n<table><tbody><tr><td> </td>\n<td>S</td>\n<td>M</td>\n<td>L</td>\n<td>XL</td>\n<td>2X</td>\n</tr><tr><td>Chest</td>\n<td>32 1/2 in.</td>\n<td>34 1/2 in.</td>\n<td>36 1/2 in.</td>\n<td>39 1/2 in.</td>\n<td>41 1/2 in.</td>\n</tr><tr><td>Body Length</td>\n<td>25 in.</td>\n<td>26 in.</td>\n<td>27 in.</td>\n<td>28 in.</td>\n<td>29 in.</td>\n</tr></tbody></table>','<h4 class=\"prodheader\">ARE YOU A FAN?</h4>\n<p>Here is something made especially for all those women who are Star Wars fans! It is cool, it is feminine, and it shows that you are a true fan!</p>','','ARE YOU A FAN?\nHere is something made especially for all those women who are Star Wars fans! It is cool, it is feminine, and it shows that you are a true fan!','','en'),(5,5,'Wonder Woman Hockey Stripe Ladies\' Tee','<div id=\"proddescription\">\n<h4 class=\"prodheader\">*CUE THE THEME MUSIC*</h4>\n<p>Ever notice that nearly every heroine has the superpower of Awesome Hair? Seriously, not a strand out of place, even when they\'re flying, kicking the crap out of someone, or running through a sewer. Perfect. Hair. *sigh* We\'re so jealous.</p>\n<p>Well, heroines and Thor.</p>\n<p>Wonder Woman\'s logo on the front of this blue, 50% cotton / 50% polyester ladies\' shirt. Sleeves have white and blue stripes. Machine wash cold. Tumble dry low or lay flat to dry. Imported.</p>\n<p><em>Please note that the model is wearing a size medium.</em></p>\n<table><tbody><tr><td> </td>\n<td>S</td>\n<td>M</td>\n<td>L</td>\n<td>XL</td>\n<td>2X</td>\n</tr><tr><td>Chest</td>\n<td>30 in.</td>\n<td>32 in</td>\n<td>34 in.</td>\n<td>36 in.</td>\n<td>38 in.</td>\n</tr><tr><td>Waist</td>\n<td>28 in.</td>\n<td>30 in.</td>\n<td>32 in.</td>\n<td>34 in.</td>\n<td>36 in.</td>\n</tr><tr><td>Body Length</td>\n<td>24 in.</td>\n<td>25 in.</td>\n<td>26 in.</td>\n<td>27 in.</td>\n<td>28 in.</td>\n</tr><tr><td>Sleeve Length</td>\n<td>9 3/4 in.</td>\n<td>10 in.</td>\n<td>10 1/4 in.</td>\n<td>10 1/2 in.</td>\n<td>10 3/4 in.</td>\n</tr></tbody></table></div>\n<div id=\"bullets\"> </div>\n<div id=\"olapic_specific_widget\" class=\"olapic olapic-widget-rendered olapic-chrome olapic_items_0 olapic_slide_horizontal\"> </div>','<h4 class=\"prodheader\">*CUE THE THEME MUSIC*</h4>\n<p>If you spin around really fast in this shirt, you won\'t turn into Wonder Woman. But you might get vertigo and fall over. So it\'s probably best if you don\'t do that.</p>','','*CUE THE THEME MUSIC*\nIf you spin around really fast in this shirt, you won\'t turn into Wonder Woman. But you might get vertigo and fall over. So it\'s probably best if you don\'t do that.','','en'),(6,6,'Star Trek Command Cycle Jersey','<h4 class=\"prodheader\">BOLDLY GO! ON YOUR LEFT...</h4>\n<p>Star Trek fans are doctors, lawyers, politicians, coders, engineers, artists, and athletes. They are everywhere, and they are legion. Recognizing each other by their clothes, jewelry, bags, and bumper stickers, they greet each other with a lift of an eyebrow, and a traditional Vulcan salute, answering \"Peace and Long Life\" with the venerated \"Live Long and Prosper.\"</p>\n<p>Once shunted into the back-alleys of fandom, Star Trek fans are now coming out of the woodwork, wearing their pride openly and declaring to the world, \"I\'m a Trekkie. You\'ll have to deal with it.\"</p>\n<p>And you don\'t have to pilot a starship to be a Star Trek fan! You can trade in your warp nacelles for two wheels, and hit the dusty streets and trails of planet Earth. Our new bicycle jersey is made of space-age AIRpass-Pro fiber, which wicks away moisture.</p>\n<p>Product Specifications</p>\n<ul><li>Space-age bicycle jersey is science fact</li>\n<li>Officially-licensed Star Trek merchandise</li>\n<li>Command gold pattern on sleeves and sides made up of alternating Starfleet badges</li>\n<li>Great for the Trek-fan biker in your life</li>\n<li>AIRpass-Pro moisture wicking technology</li>\n<li>UV protection</li>\n<li>Wicks away moisture, keeping you cool and dry</li>\n<li>Hidden, full-length YKK zipper</li>\n<li>3 pockets with reinforced stitching</li>\n<li>Silicon Gripper bottom in rear</li>\n<li>Form-fitting for maximum comfort</li>\n<li>Materials: 100% polyester</li>\n<li>Hand wash, lay flat to dry.</li>\n<li>Made in China</li>\n<li>Please reference the table below to determine your size. Note: Front length does not include collar.</li>\n</ul><p> </p>\n<table><tbody><tr><td>\n<p> </p>\n</td>\n<td>\n<p>S</p>\n</td>\n<td>\n<p>M</p>\n</td>\n<td>\n<p>L</p>\n</td>\n<td>\n<p>XL</p>\n</td>\n<td>\n<p>2XL</p>\n</td>\n<td>\n<p>3XL</p>\n</td>\n</tr><tr><td>\n<p>Chest</p>\n</td>\n<td>\n<p>37 - 39\"</p>\n</td>\n<td>\n<p>39 - 41\"</p>\n</td>\n<td>\n<p>41 - 43\"</p>\n</td>\n<td>\n<p>43 - 45\"</p>\n</td>\n<td>\n<p>45 - 47\"</p>\n</td>\n<td>\n<p>47 - 49\"</p>\n</td>\n</tr><tr><td>\n<p>Waist</p>\n</td>\n<td>\n<p>31 - 33\"</p>\n</td>\n<td>\n<p>33 - 36\"</p>\n</td>\n<td>\n<p>37 - 39\"</p>\n</td>\n<td>\n<p>40 - 43\"</p>\n</td>\n<td>\n<p>44 - 46\"</p>\n</td>\n<td>\n<p>47 - 49\"</p>\n</td>\n</tr><tr><td>\n<p>Front Length</p>\n</td>\n<td>\n<p>19\"</p>\n</td>\n<td>\n<p>22\"</p>\n</td>\n<td>\n<p>24\"</p>\n</td>\n<td>\n<p>26\"</p>\n</td>\n<td>\n<p>28\"</p>\n</td>\n<td>\n<p>30\"</p>\n</td>\n</tr></tbody></table>','<h4 class=\"prodheader\">BOLDLY GO! ON YOUR LEFT...</h4>\n<ul><li>Space-age bicycle jersey is science fact</li>\n<li>Officially-licensed Star Trek merchandise</li>\n<li>Command gold pattern on sleeves and sides made up of alternating Starfleet badges</li>\n</ul>','','BOLDLY GO! ON YOUR LEFT...\nSpace-age bicycle jersey is science fact\nOfficially-licensed Star Trek merchandise\nCommand gold pattern on sleeves and sides made up of alternating Starfleet badges\n','','en'),(7,7,'Star Trek Uniform Polos','<h4 class=\"prodheader\">FROM THE FINAL FRONTIER TO THE OFFICE</h4>\n<blockquote><em>Kirk to Scotty: Meet me at the water cooler. We should talk about the game.</em></blockquote>\n<p>Not everyone in Starfleet worked on the bridge of a spaceship. Some of them were computer programmers, IT workers, and engineers, and they worked in a great office with a ping-pong table and casual Friday.</p>\n<p>Join in the fun with a Star Trek uniform polo shirt! Each different color is embroidered with the appropriate symbol from the Original Series: choose between blue (science), red (operations/engineering), and gold (command).</p>\n<p>Product Specifications</p>\n<ul><li>Polo with embroidered Star Trek insignia</li>\n<li>Corporate casual for Starfleet and your office</li>\n<li>Officially licensed STAR TREK product</li>\n<li>Choose between blue, gold and red</li>\n<li>Materials: 50% cotton, 50% polyester</li>\n<li>Custom embroidery approx. 3 inches tall on left chest</li>\n</ul>','<h4 class=\"prodheader\">FROM THE FINAL FRONTIER TO THE OFFICE</h4>\n<p>These Star Trek uniform polo shirts are perfect for the corporate-casual trekkie in all of us. They\'re made from 50% cotton and 50% polyester and feature embroidered science, engineering or command insignia. All you need to do is choose a color!</p>','','FROM THE FINAL FRONTIER TO THE OFFICE\nThese Star Trek uniform polo shirts are perfect for the corporate-casual trekkie in all of us. They\'re made from 50% cotton and 50% polyester and feature embroidered science, engineering or command insignia. All you need to do is choose a color!','','en'),(8,8,'Bow Ties Are Cool [Unlimited QTY]','<div id=\"proddescription\">\n<h4 class=\"prodheader\">NO TYING REQUIRED.</h4>\n<p>There\'s a long history regarding bow ties, neckties, and doctors. Did you know that pediatricians wear bow ties to avoid being strangled by grabby babies? In fact, neckties are such a danger to doctors and patients that British hospitals banned the wearing of neckties in 2007. \"Colonized by pathogens\" was the exact phrase. Yuck.</p>\n<p>Our Doctor, on the other hand, acquired his signature bow tie in an English hospital, where perhaps it once graced the neck of a cardiologist. (It\'s a pity they never met; that would have been a fun EKG.) We\'re not sure if The Doctor chose it for its fashionable qualities or its utilitarian nature, but he\'s succeeded on both counts.</p>\n<p>\"Bow Ties Are Cool\" printed on a navy blue, 100% cotton t-shirt in the classic \"Keep Calm\" font, topped with a bow tie you don\'t ever have to tie.</p>\n</div>','<h4 class=\"prodheader\">NO TYING REQUIRED.</h4>\n<p>Turns out, The Doctor is quite the influential figure in fashion. In the month after the episode <em>The Eleventh Hour</em> aired, bow tie sales at one UK menswear shop grew by 94%. Who knew?</p>','','NO TYING REQUIRED.\nTurns out, The Doctor is quite the influential figure in fashion. In the month after the episode The Eleventh Hour aired, bow tie sales at one UK menswear shop grew by 94%. Who knew?','','en'),(9,9,'Star Trek TNG Uniform Tee','<h4 class=\"prodheader\">CAPTAIN ON THE BRIDGE</h4>\n<p>We all have questions about Deanna Troi\'s uniform choices. Why doesn\'t she have to wear Starfleet standard issue? Why did she choose that weird asymmetrical blue dress? And why, exactly, is Enterprise the only ship in the fleet with a psychic counselor at the captain\'s left hand?</p>\n<p>All of these problems could be solved pretty quickly with this Star Trek uniform tee, inspired by the TNG uniforms. If Counselor Troi had seen the comfort and quality of these casual Starfleet duds, she would have ditched her pastel dresses in a minute.</p>\n<p>Each TNG Uniform Tee is made from 100% cotton high-quality cut-and-sew construction. Sparkly comm badges and pips are screenprinted. Imported.</p>','<h4 class=\"prodheader\">CAPTAIN ON THE BRIDGE</h4>\n<p>Dress like your favorite Enterprise-D crew member! The Star Trek: The Next Generation uniform t-shirts are constructed just for this purpose, the high quality Picard would demand from his crew. Pips and sparkly comm badges are screen-printed on.</p>','','CAPTAIN ON THE BRIDGE\nDress like your favorite Enterprise-D crew member! The Star Trek: The Next Generation uniform t-shirts are constructed just for this purpose, the high quality Picard would demand from his crew. Pips and sparkly comm badges are screen-printed on.','','en'),(10,10,'Ewok Ladies Hooded Tank Top','<h4 class=\"prodheader\">EWOK THE WALK</h4>\n<p>Are you curious? Do you love the forest? Do you express your enjoyment of something through singing and dancing? If you answered yes to all these questions, you, too, might be an Ewok. We didn\'t recognize you without your ears.</p>\n<p>Get this hooded tank top to show everybody your inner Ewok. We\'re going to bypass the ceremony of the Festival of Hoods and just say you\'ve earned this orange hood, complete with little, fuzzy Ewok ears. There are various shades of Ewok brown printed on the front and back of this 100% cotton ladies\' tank top. Back is racerback-style. Machine wash cold. Tumble dry low or lay flat to dry. Imported.</p>\n<p><em>Please note that the model is wearing a size medium. This tank does run small, we recommend going up one size.</em></p>\n<p>Please reference the table below to choose your size. These are the measurements of the body type that will fit each size, not the actual garment.</p>\n<p>Sizing Table</p>\n<table><tbody><tr><td> </td>\n<td>S</td>\n<td>M</td>\n<td>L</td>\n<td>XL</td>\n<td>XXL</td>\n<td>XXXL</td>\n</tr><tr><td>Chest</td>\n<td>34 in.</td>\n<td>36 in.</td>\n<td>37 in.</td>\n<td>38 in.</td>\n<td>39 in.</td>\n<td>41 in.</td>\n</tr><tr><td>Waist</td>\n<td>27 in.</td>\n<td>29 in.</td>\n<td>31 in.</td>\n<td>32 in.</td>\n<td>33 in.</td>\n<td>35 in.</td>\n</tr><tr><td>Hips</td>\n<td>36 in.</td>\n<td>38 in.</td>\n<td>40 in.</td>\n<td>41 in.</td>\n<td>42 in.</td>\n<td>44 in.</td>\n</tr><tr><td>Body Length</td>\n<td>26 1/2 in.</td>\n<td>27 in.</td>\n<td>27 1/2 in.</td>\n<td>28 in.</td>\n<td>28 1/2 in.</td>\n<td>29 in.</td>\n</tr></tbody></table>','<h4 class=\"prodheader\">EWOK THE WALK</h4>\n<ul><li>Makes you look like an Ewok</li>\n<li>Standard tank top in front, racerback-styling in back</li>\n<li>Don\'t make us poke you with the spear</li>\n</ul>','','EWOK THE WALK\nMakes you look like an Ewok\nStandard tank top in front, racerback-styling in back\nDon\'t make us poke you with the spear\n','','en'),(11,11,'DOTA 2 - Series 3 Micro Plush Blind Box','<h4 class=\"prodheader\">FUZZY WUZZY RETURNS</h4>\n<p>Maybe tiny plush isn\'t the first product that comes to mind when you\'re thinking of merchandising your multiplayer online battle arena game. \"Aren\'t you just the cutest little Strygwyr EVAR? Yes you are. Who\'s Daddy\'s little bloodseeker?\" But we all know Valve doesn\'t play by the same rules as other video game companies, so who are we to be surprised?<br /><br />These Series 3 DOTA 2 Microplushes feature 11 different designs to collect: Brewmaster, Dark Seer, Invoker, Jakiro, Juggernaut, Lina, Necrophos, Razor, Staglift, Storm Spirit, and Sven. The 10 commons come with come with an unlock code for \"Imbued Lockless Luckvase 2015.\" Staglift is rare and comes with an additional in-game card.<br /><br />Please note: Digital items are currently limited to one copy per Steam account. If you have previously registered a key for this item to your account, you will be unable to receive a second copy.</p>\n<p>Product Specifications </p>\n<ul><li>DOTA 2 - Series 3 Micro Plush Blind Box</li>\n<li>Officially-licensed <em>Defense of the Ancients 2</em> merchandise</li>\n<li>Blind boxed for maximum surprise (see FAQ below for more info) </li>\n<li>11 different plushes to collect (Brewmaster, Dark Seer, Invoker, Jakiro, Juggernaut, Lina, Necrophos, Razor, Staglift, Storm Spirit, and Sven)</li>\n<li>1 rare in mix: Staglift </li>\n<li>10 commons come with unlock code for \"Imbued Lockless Luckvase 2015\" in DOTA 2</li>\n<li>Staglift comes with an additional in-game card</li>\n<li>Elastic loop on top makes them easy to hang</li>\n<li>Dimensions: 4 1/2\" - 5\" tall</li>\n</ul><p><span style=\"color:#384245;font-family:Lato, Helvetica, Arial, sans-serif;font-size:14.3999996185303px;line-height:22.3999996185303px;\"> </span></p>','<h4 class=\"prodheader\">FUZZY WUZZY RETURNS</h4>\n<ul><li>11 different DOTA 2 Microplushes to collect</li>\n<li>Brewmaster, Dark Seer, Invoker, Jakiro, Juggernaut, Lina, Necrophos, Razor, Staglift, Storm Spirit, Sven</li>\n<li>Each comes with an unlock code for Imbued Lockless Luckvase 2015</li>\n</ul>','','FUZZY WUZZY RETURNS\n11 different DOTA 2 Microplushes to collect\nBrewmaster, Dark Seer, Invoker, Jakiro, Juggernaut, Lina, Necrophos, Razor, Staglift, Storm Spirit, Sven\nEach comes with an unlock code for Imbued Lockless Luckvase 2015\n','','en'),(12,12,'Minions Pop Vinyl Figures','<h4 class=\"prodheader\">CAUSE THEY WEREN\'T CUTE ENOUGH?</h4>\n<p>We hear these little guys are on the lookout for a new evil overlord to follow. Is it you? If so, they\'re guaranteed to make your collectibles shelf at least 27% more mysterious.*</p>\n<p>More Minions have been added to Funko\'s already extensive POP! lineup, this time from the <em>Minions</em> movie. Choose Au Naturel; Eye, Matie; or King Bob.</p>\n<p>*Your collectibles\' mysteriousness not guaranteed to increase in value. Call now. Operators are standing by.</p>\n<p>Product Specifications  </p>\n<p> </p>\n<ul><li>Super-cute Funko POP! versions of Minions</li>\n<li>Officially-licensed Minions movie merchandise</li>\n<li>Choose Au Naturel; Eye, Matie; or King Bob </li>\n<li>Materials: Vinyl</li>\n<li>Dimensions: 3 3/4\" tall (King Bob\'s a little taller overall because of his crown)</li>\n<li>Ages 3+</li>\n<li>WARNING - SMALL PARTS - Not intended for children under 3 years of age</li>\n</ul>','<h4 class=\"prodheader\">CAUSE THEY WEREN\'T CUTE ENOUGH?</h4>\n<ul><li>Super-cute Funko POP! versions of Minions</li>\n<li>Choose Au Naturel; Eye, Matie; or King Bob</li>\n<li>BANANA!!!!</li>\n</ul>','','CAUSE THEY WEREN\'T CUTE ENOUGH?\nSuper-cute Funko POP! versions of Minions\nChoose Au Naturel; Eye, Matie; or King Bob\nBANANA!!!!\n','','en'),(13,13,'Vinyl Idolz: Ghostbusters','<h4 class=\"prodheader\">WHO YOU GONNA SMALL?</h4>\n<p>Are you troubled by strange noises in the middle of the night? Do you experience feelings of dread in your basement or attic? Have you or any member of your family ever seen a spook, specter, or ghost? If the answer is yes, then don\'t wait another minute. Pick up your mouse and order these Vinyl Idolz: Ghostbusters. They\'re ready to believe you!<br /><br />Vinyl Sugar has made tiny versions of your favorite protectors from the paranormal. Choose Dr. Peter Venkman, Dr. Egon Spengler, or Dr. Raymond Stantz. Get these Vinyl Idolz: Ghostbusters some s\'mores, and recreate the movie you love to love. Just don\'t cross the streams. Because that would be bad. <br /><br />Product Specifications  </p>\n<ul><li>Vinyl Idolz: Ghostbusters</li>\n<li>Officially-licensed <em>Ghostbusters</em> merchandise</li>\n<li>Choose Dr. Peter Venkman, Dr. Egon Spengler, or Dr. Raymond Stantz</li>\n<li>Part of the Vinyl Idolz line from Vinyl Sugar (basically Funko) &amp; A Large Evil Corporation</li>\n<li>Materials: Vinyl</li>\n<li>Dimensions: 8\" tall</li>\n</ul>','<h4 class=\"prodheader\">WHO YOU GONNA SMALL?</h4>\n<ul><li>Ghostbusters vinyl figures from the Vinyl Idolz line</li>\n<li>Choose Dr. Peter Venkman, Dr. Egon Spengler, or Dr. Raymond Stantz</li>\n<li>We\'re holding out for the cartoon-y Ecto-1</li>\n</ul>','','WHO YOU GONNA SMALL?\nGhostbusters vinyl figures from the Vinyl Idolz line\nChoose Dr. Peter Venkman, Dr. Egon Spengler, or Dr. Raymond Stantz\nWe\'re holding out for the cartoon-y Ecto-1\n','','en'),(14,14,'DOTA 2 Sniper Plush','<h4 class=\"prodheader\">THIS PLUSH IS ALSO VERY SQUISHY</h4>\n<p>If there\'s one thing we can all agree on, it\'s that Kardel Sharpeye is pretty annoying unless you\'re the one playing him. If we hear \"You got peep\'d!\" one more time, or that inane \"Hee hee hee!\"</p>\n<p>Come here, Dota 2 Sniper Plush. We feel the need to throttle you, and with this convenient little plush, we can totally do it....</p>\n<p>Product Specifications  </p>\n<p> </p>\n<ul><li><em>DOTA 2 </em>Sniper Plush</li>\n<li>Officially-licensed <em>DOTA 2</em> merchandise</li>\n<li> Comes with unlock code for \"Imbued Lockless Luckvessel\" in <em>DOTA 2</em></li>\n<li>Goggles are NOT removable (we might have ripped the eyeballs off our plush checking for you)</li>\n<li>Materials: 100% polyester</li>\n<li>Care Instructions: Spot clean with a damp cloth and mild detergent </li>\n<li>Imported</li>\n<li>Dimensions: </li>\n<li>Ages 13+</li>\n<li>WARNING - SMALL PARTS - Not intended for children under 3 years of age</li>\n</ul>','<h4 class=\"prodheader\">THIS PLUSH IS ALSO VERY SQUISHY</h4>\n<ul><li>Be sure to max out Shrapnel</li>\n<li>Or don\'t</li>\n<li>Comes with an unlock code for Imbued Lockless Luckvessel</li>\n</ul>','','THIS PLUSH IS ALSO VERY SQUISHY\nBe sure to max out Shrapnel\nOr don\'t\nComes with an unlock code for Imbued Lockless Luckvessel\n','','en'),(15,15,'Soft Kitty Singing Plush [Sale] [Reviews]','<h4 class=\"prodheader\">HEAR KITTY, KITTY, KITTY</h4>\n<p>We love \"Soft Kitty,\" but there\'s a problem inherent with the song. In order to sing it properly, you have to be in the presence of a sick person (or, well, Shel-bot). A sick person with a highly-contagious illness. On the sickie\'s behalf, we\'ll also point out that sometimes when you\'re sick, you just don\'t want to see other humans. You feel horrible. You look horrible. You just want to burrow in your blanket cave and be left alone. That\'s when the Soft Kitty Singing Plush comes in handy. It\'s the perfect proxy. Just squeeze its front left paw to get it to sing \"Soft Kitty.\" Best of all, it never gets frustrated when you tell it it has to start over. In fact, every time you press its paw, it starts from the beginning. Good kitty.</p>\n<blockquote>Soft kitty, warm kitty<br />Little ball of fur<br />Happy kitty, sleepy kitty<br />Purr purr purr</blockquote>\n<p> </p>\n<p>Soft Kitty Singing Plush</p>\n<ul><li>10-inches long.</li>\n<li>Collar has a little Bohr-model atom tag with the <em>Big Bang Theory</em> logo.</li>\n<li>Requires 3x 1.5V button-cell batteries (included).</li>\n<li>Pull the clear plastic tab from the battery compartment to activate.</li>\n<li>Sings \"Soft Kitty.\"</li>\n<li>Polyester fiber. All new material.</li>\n<li>Do not machine wash. Surface clean with a damp cloth.</li>\n<li>For ages 3+.</li>\n</ul>','<h4 class=\"prodheader\">HEAR KITTY, KITTY, KITTY</h4>\n<ul><li>Officially-licensed <em>Big Bang Theory</em> product.</li>\n<li>Sings \"Soft Kitty\" when paw is pressed.</li>\n<li>Guaranteed to make you feel better.</li>\n</ul>','','HEAR KITTY, KITTY, KITTY\nOfficially-licensed Big Bang Theory product.\nSings \"Soft Kitty\" when paw is pressed.\nGuaranteed to make you feel better.\n','','en'),(16,16,'Avengers: Fabrikations Plush [Related Products]','<h4 class=\"prodheader\">HUG THE AVENGERS!</h4>\n<p>We\'ve all seen it before. Sometimes when superheroes become established they go soft. They coast on their reputation, remembering past good deeds instead of undertaking new ones. But nobody would accuse the Avengers of such shenanigans - until now.</p>\n<p>They\'ve all gone soft, or, well, at least some of the guys have. Choose Captain America, Hulk, Iron Man, or Thor. Each of these Avengers: Age of Ultron Fabrikations soft-sculpt figures from Funko has only one point of articulation. Their heads turn, as if to say, \"No, we have NOT gone soft. We have gone plushy. It\'s different.\" Take it from our tiny genius, billionaire, playboy, plushanthropist.</p>\n<div id=\"proddescription\">\n<p>Product Specifications  </p>\n<ul><li>Avengers Fabrikations soft-sculpt figures from Funko</li>\n<li>Officially-licensed <em>Avengers: Age of Ultron</em> merchandise</li>\n<li>Choose Captain America, Hulk, Iron Man, or Thor </li>\n<li>Features rotating head</li>\n<li>Flat-bottomed and weighted feet for easy display</li>\n<li>Embroidered details and vinyl accessories</li>\n<li>Care Instructions: Spot clean with a damp cloth and mild detergent </li>\n<li>Imported</li>\n<li>Dimensions: ~6\" tall</li>\n<li>Age 14+</li>\n<li>WARNING - SMALL PARTS - Not intended for children under 3 years of age</li>\n</ul></div>','<h4 class=\"prodheader\">HUG THE AVENGERS!</h4>\n<p>Choose one of these Avengers: Age of Ultron Fabrikations soft-sculpt figures from Funko: Captain America, Hulk, Iron Man, or Thor.</p>','','HUG THE AVENGERS!\nChoose one of these Avengers: Age of Ultron Fabrikations soft-sculpt figures from Funko: Captain America, Hulk, Iron Man, or Thor.','','en'),(17,17,'Ollie - The App Controlled Robot','<h4 class=\"prodheader\">TUBULAR!</h4>\n<p>One of the pieces of feedback the creators of <a href=\"http://www.thinkgeek.com/ed94\">Sphero</a> got about their popular R/C robot was that it could do really cool things, but the users wished it could go faster. So they created Ollie.</p>\n<p>Ollie\'s a cylinder. He can\'t do all the things that his spherical counterpart can do, but he can do one thing particularly well: go fast. How fast? 14 miles an hour. And his wheels spin independently, which basically makes him a tiny skateboarding genius. He can spin, drift, flip, turn, and tumble when you tell him to via an app on your smartphone. He pairs with a touch and works up to 98 ft. away (which is good for a little guy who can escape at a speed of 14 mph). While they were testing him, the creators managed to get one to jump off a ramp over 6 ft. high. Basically over a person. Boo. Yah.</p>\n<p>He\'ll run for an hour (and recharges via micro USB cable, included, which takes 3 hours). That means that on a single charge, we could theoretically drive our Ollie all the way from ThinkGeek World Domination HQ to the Pentagon. Which we\'re sure wouldn\'t raise any eyebrows or cause security alerts. Do not try this at home with your own Ollie. If you do, do not blame us.</p>\n<p>Product Specifications</p>\n<ul><li>Smartphone-controlled robot shaped like a cylinder</li>\n<li>Compatible with iOS 7.0+ and Android 4.4.2+</li>\n<li>Super-fast - top speed of 14 mph</li>\n<li>Wheels spin independently of each other</li>\n<li>Spin, drift, flip, turn, and tumble with app-powered tricks</li>\n<li>Connects to your smartphone via Bluetooth™ LE (pairs via touch)</li>\n<li>Wireless Range: 98 ft.</li>\n<li>Check to see if your device is compatible <a href=\"http://www.gosphero.com/c/#ollie-identifier\">here</a></li>\n<li>4 separate apps for different functions (driving, programming, etc.)</li>\n<li>Automatic firmware updates</li>\n<li>SDK available in <a href=\"https://developer.gosphero.com/\">14 coding languages</a></li>\n<li>Set it to open or closed spaces, hard or soft surfaces</li>\n<li>Future accessories include alternate wheels, tires, hubcaps, and smartramps</li>\n<li>Has LED \"running lights\" that react</li>\n<li>Materials: High-grade polycarbonate body</li>\n<li>Batteries: Rechargeable - charges via micro USB cable (included)</li>\n<li>Runs for 1 hr. on charge; charging takes 3 hrs.</li>\n<li>Dimensions: 9.9\" x 4.8\" x 4.3\"</li>\n<li>Weight: 1.4 lbs.</li>\n<li>Includes Ollie, 2 Nubby Tires (all-terrain), 2 Hubcaps, micro USB charging cable, and a quick start guide</li>\n<li>Note: Unlike <a href=\"http://www.thinkgeek.com/ed94\">Sphero</a>, Ollie is NOT waterproof</li>\n</ul>','<h4 class=\"prodheader\">TUBULAR!</h4>\n<ul><li>Colorful cylinder with a tiny robot inside</li>\n<li>Spin, drift, flip, turn, and tumble with app-powered tricks</li>\n<li>Compatible with iOS and Android devices</li>\n</ul>','','TUBULAR!\nColorful cylinder with a tiny robot inside\nSpin, drift, flip, turn, and tumble with app-powered tricks\nCompatible with iOS and Android devices\n','','en'),(18,18,'PowerUp® 3.0 Smartphone Controlled Paper Airplane','<h4 class=\"prodheader\">TURN ANY PAPER AIRPLANE INTO AN R/C AIRPLANE!</h4>\n<p>Paper airplanes are awesome for relieving office boredom, attacking a coworker or sibling, or sending messages around the Ministry of Magic. But sometimes paper airplanes need just a little more oomph - a little more power. Well, the time has come to easily add that extra power and control the plane with your smartphone with the PowerUp® 3.0 Smartphone Controlled Paper Airplane.</p>\n<p>First, make your airplane. Oooo, nice one. Then, you just slip your PowerUp® 3.0 Smartphone Controlled Paper Airplane propeller-stalk thing onto your paper airplane. It clips to the front, with the prop sticking out the back. Twenty minutes of USB charging, and you\'ll have ten minutes of flight time! Load up the app in your iPhone or Android device, and you\'ll be able to control the paper airplane right from your phone! Control the thrust with a virtual throttle and tilt your phone for steering. Get yerself a PowerUp® 3.0 Smartphone Controlled Paper Airplane, and you will be the ruler of the air!</p>\n<p>Product Specifications  </p>\n<p> </p>\n<ul><li>For Ages 14 and Up</li>\n<li>Turn any paper airplane into a smartphone controlled R/C airplane!</li>\n<li>Connects via Bluetooth</li>\n<li>Features:\n<ul><li>180 feet range</li>\n<li>Crash-proof bumper</li>\n<li>10 minutes of flight on one 20 minute charge</li>\n<li>Crash-proof carbon fiber frame</li>\n<li>Automatic thrust to assist when turning</li>\n<li>Precision control for easy flying</li>\n</ul></li>\n<li>App features:\n<ul><li>Magnetic compass</li>\n<li>Charging status indicator</li>\n<li>Thrust level indicator</li>\n<li>Ascend/Descend lever</li>\n<li>Artificial horizon</li>\n<li>Battery level indicator</li>\n<li>Range indicator</li>\n</ul></li>\n<li>Includes: PowerUp® 3.0 Smart Module, Micro USB cable, Spare propeller, Spare rudder, Display case and mount, 4 PowerUp® paper templates, Waterproof paper template, PowerUp® 3.0 user guide</li>\n<li>Free app available for iOS and Android devices</li>\n<li>Dimensions: approx. 8.25\" long</li>\n</ul>','<h4 class=\"prodheader\">TURN ANY PAPER AIRPLANE INTO AN R/C AIRPLANE!</h4>\n<ul><li>Add to your paper plane to make it propeller driven and smartphone controlled</li>\n<li>Connects via Bluetooth to your smartphone (because wires would be silly)</li>\n<li>20 minute charge gives you 10 minutes of flight!</li>\n</ul>','','TURN ANY PAPER AIRPLANE INTO AN R/C AIRPLANE!\nAdd to your paper plane to make it propeller driven and smartphone controlled\nConnects via Bluetooth to your smartphone (because wires would be silly)\n20 minute charge gives you 10 minutes of flight!\n','','en'),(19,19,'Chocolate-Covered Edible Bugs Gift Pack','<h4 class=\"prodheader\">BUGS PLUS CHOCOLATE EQUALS YUMMY!</h4>\n<p>Get ready to have your mind blown: we\'ve taken the five second rule and plugged it into Einstein\'s General Theory of Relativistic Theories on Stuff and Things. The result is this: as a food falls to the ground, the five second rule countdown starts. BUT (and this is the most important part), if the food started off on the ground, then the five second rule becomes infinite. What does that mean? You can eat bugs any time you want, since technically they never fell to the ground to begin with!! Cover \'em with chocolate, and you\'ve got our <em>Chocolate-Covered Edible Bugs Gift Pack</em>.</p>\n<p>Each <em>Chocolate-Covered Edible Bugs Gift Pack</em> is a trio of dark chocolate-covered insects, full of protein and crunch and yumminess. Scorpions, superworms, and silkworms all await your eager palate. We like to say they are enrobed in chocolate, because that makes them a sexier food. The <em>Chocolate-Covered Edible Bugs Gift Pack</em> makes a perfect present for the person who thinks they have everything, an instant appetizer sampler for adventurous entertaining, and/or a protein-packed snack any time you need it. Entomophagist-a-licious!</p>\n<p>Chocolate-Covered Edible Bugs Gift Pack</p>\n<ul><li>A trio of dark chocolate-covered ex-creepy crawlies await your mouth and tasting/eating parts.</li>\n<li>You\'ll get three cans - one of each (dark chocolate covered): Armor Tail Scorpions (<em>Mesobuthus martensii</em>), Superworms (<em>Zophobas morio</em>), and Silkworms (<em>Bombyx mori</em>).</li>\n<li>Ingredients: bug, sugar, vegetable fat, cocoa powder, emulsifier, and vanillin.</li>\n<li>Insect Roll Call:\n<ul><li>Scorpions - 2 per tin.</li>\n<li>Superworms - 12 per tin.</li>\n<li>Silkworms - 12 per tin.</li>\n</ul></li>\n<li>Tin Dimensions: 2.5\" diameter x 1.5\" tall.</li>\n</ul>','<h4 class=\"prodheader\">BUGS PLUS CHOCOLATE EQUALS YUMMY!</h4>\n<ul><li>Three different bugs (each in its own tin) covered in delectable chocolate.</li>\n<li>Scorpions, superworms, and silkworms.</li>\n<li>And chocolate. Yum!</li>\n</ul>','','BUGS PLUS CHOCOLATE EQUALS YUMMY!\nThree different bugs (each in its own tin) covered in delectable chocolate.\nScorpions, superworms, and silkworms.\nAnd chocolate. Yum!\n','','en'),(20,20,'Canned Unicorn Meat','<h4 class=\"prodheader\">NO FOOLIN\' - UNICORN MEAT IS REAL!</h4>\n<p><em>Excellent source of sparkles!</em></p>\n<p>Unicorns, as we all know, frolic all over the world, pooping rainbows and marshmallows wherever they go. What you don\'t know is that when unicorns reach the end of their lifespan, they are drawn to County Meath, Ireland. The Sisters at Radiant Farms have dedicated their lives to nursing these elegant creatures through their final days. Taking a cue from the Kobe beef industry, they massage each unicorn\'s coat with Guinness daily and fatten them on a diet comprised entirely of candy corn. As the unicorn ages, its meat becomes fatty and marbled and the living bone in the horn loses density in a process much like osteoporosis. The horn\'s outer layer of keratin begins to develop a flavor very similar to candied almonds. Blending the crushed unicorn horn into the meat adds delightful, crispy flavor notes in each bite. We are confident you will find a world of bewilderment in every mouthful of scrumptious unicorn meat.</p>\n<p>Unfortunately, due to restrictions on the importation of mythical processed meatstuff, we are unable to bring you Canned Unicorn Meat in the way the Sisters of Radiant Farms intended. When you open your can, you will find one tiny unicorn which has been appropriately sliced into its main cuts of meat. Simply use your Growth Ray to re-embiggen the unicorn before skinning it and processing its flesh. Or if you\'re lazy, just bring it to your local Mad Scientist-Butcher. He\'ll know what to do.</p>\n<p><strong>Radiant Farms Canned Unicorn Meat Specifications</strong></p>\n<ul class=\"floatfix\"><li>14 ounces of delicious unicorn meat, canned for your convenience</li>\n<li>Imported from a small independent cannery in County Meath, Ireland</li>\n<li>Crunchy horn bits in every bite - an excellent source of Calcium</li>\n<li>Tastes like rotisserie chicken but with a hint of marshmallow sweetness</li>\n<li>Easily spreadable for sandwiches, hors d\'oeuvres, and more</li>\n<li>Sparkly meat lends the unmistakable air of class and sophistication to your parties</li>\n<li>Unlike other meats, unicorn fat is polyunsaturated and lowers your LDL cholesterol</li>\n<li>Not yet approved by the USDA or FDA, but the nuns have eaten it for centuries and they\'re healthy as horses</li>\n<li>Okay, for real: you can\'t eat this. It\'s a dismembered stuffed unicorn in a can.</li>\n<li>The bottom of the tin is easily removable to gain access to the mini dead unicorn inside. No can opener needed!</li>\n</ul>','<h4 class=\"prodheader\">NO FOOLIN\' - UNICORN MEAT IS REAL!</h4>\n<ul><li>14 ounces of delicious unicorn meat, canned for your convenience</li>\n<li>Imported from a small independent cannery in County Meath, Ireland</li>\n<li>Okay, for real: you can\'t eat this. It\'s a dismembered stuffed unicorn in a can.</li>\n</ul>','','NO FOOLIN\' - UNICORN MEAT IS REAL!\n14 ounces of delicious unicorn meat, canned for your convenience\nImported from a small independent cannery in County Meath, Ireland\nOkay, for real: you can\'t eat this. It\'s a dismembered stuffed unicorn in a can.\n','','en'),(21,21,'The ThinkGeek Annoy-a-tron','<h4 class=\"prodheader\">DRIVE YOUR \"FRIENDS\" CRAZY - AGAIN</h4>\n<p>Now that they\'ve mostly recovered from the twisted mind maze that was the original Annoy-a-tron, send them on a new journey of \"self discovery\" with the latest version featuring 6 sound choices, it\'s at least twice as fun (and annoying) as the original. For effective deployment, we humbly suggest the following sounds and locations, but you can conduct your own field research for more insight.</p>\n<p>The cricket chirping sound is interesting because someone will instinctively look near the ground when trying to locate a cricket. So, placing the Annoy-a-tron several feet or more above the ground will help to obscure its location. The 15kHz sound is also interesting because this frequency range of sound cannot be heard by everyone. In older adults or those with deteriorated hearing (a condition known as presbycusis) this high frequency sound will not be audible, while others will clearly hear the sound and find it quite annoying. They also might think they are going crazy because people nearby will report that they don\'t hear anything.</p>\n<p>Assuming you have done your part in selecting a suitable hiding location for the Annoy-a-tron, it will do its part to drive your co-workers slowly mad with its short and seemingly random beeps. And when someone does locate the Annoy-a-tron, they\'re not going to know what it is - which is almost as much fun as watching them search for it. Muahaha...</p>\n<p>** - The 15kHz \'Teen Buzz Tone\' is a frequency that young people can hear but older folks cannot. Sometimes younger folks cannot hear it and sometimes older folks can hear it, but, in general, it\'s called the \'Teen Buzz\' tone. When you can hear it, trust us, it\'s annoying. Dogs agree.</p>\n<p>The ThinkGeek Annoy-a-tron Features: <br /><br /></p>\n<ul><li>Amazingly small</li>\n<li>Six sounds choices:\n<ul><li>Beep</li>\n<li>12kHz electronic noise sound</li>\n<li>15kHz \'Teen Buzz Tone\' electronic noise sound</li>\n<li>Cricket</li>\n<li>Doorbell</li>\n<li>Random/Alternating sound mode</li>\n</ul></li>\n<li>Battery included (lasts 1 month+ of continuous use)</li>\n<li>Embedded Rare-earth Magnet for easy hiding</li>\n<li>Single push button to change sounds</li>\n<li>Please note: after removing battery tab you may need to push down slightly on the magnet to re-seat the battery correctly (you may even hear a small click)</li>\n<li>Battery: CR2032</li>\n</ul>','<h4 class=\"prodheader\">DRIVE YOUR \"FRIENDS\" CRAZY - AGAIN</h4>\n<ul><li>Tiny device produces six annoying noises</li>\n<li>Turn it on, hide it, and watch the fun begin</li>\n<li><em>As seen on NCIS!</em></li>\n</ul>','','DRIVE YOUR \"FRIENDS\" CRAZY - AGAIN\nTiny device produces six annoying noises\nTurn it on, hide it, and watch the fun begin\nAs seen on NCIS!\n','','en'),(22,22,'Legendary Hero 8-Bit Heart Bouquet','<h4 class=\"prodheader\">BE MY PLAYER 2</h4>\n<p>Life was simpler in 8-bit. Sidescrolling was the name of the game and came with none of the potential motion-sickness that today\'s immersion games can cause. There were clear-cut good guys and bad guys. There was a princess to rescue. There was one hero, and it was you.</p>\n<p>And back in those days, Valentines were handmade from construction paper. Everybody got one. And when you wrote \"love,\" it meant \"love\" as in \"I\'d love another cookie.\" Life was simpler.</p>\n<div id=\"proddescription\">\n<p>Do you have somebody in your life who deserves your heart... or three? Celebrate the simplicity of old-school gaming with our 8-bit Legendary Hero. This foam cutout comes with a cardboard fold-out stand or can be hung from the wall. Great as decoration on a table, it says, \"Be my Player 2\" better than any stupid flowers ever could.</p>\n<p><strong>Product Specifications</strong></p>\n<ul><li>8-bit Legendary Hero</li>\n<li>A ThinkGeek creation and exclusive!</li>\n<li>3D construction with 3 layers of depth</li>\n<li>Includes fold-out stand for displaying on a desk or table</li>\n<li>Holes in back for wall mounting</li>\n<li>Materials: Durable EVA foam</li>\n<li>Dimensions: 11\" tall x 5 1/2\" wide x 3\" deep assembled</li>\n</ul></div>','<h4 class=\"prodheader\">BE MY PLAYER 2</h4>\n<ul><li>3D foam cutout brings back old-school memories</li>\n<li>Includes fold-out stand for displaying on a desk or table</li>\n<li>A ThinkGeek creation and exclusive!</li>\n</ul>','','BE MY PLAYER 2\n3D foam cutout brings back old-school memories\nIncludes fold-out stand for displaying on a desk or table\nA ThinkGeek creation and exclusive!\n','','en'),(23,23,'Executive Building Brick Set (Chrome)','<h4 class=\"prodheader\">BUILDING BRICKS ALL GROWN UP</h4>\n<div class=\"right\"> </div>\n<p>We here at ThinkGeek World Domination HQ have long been of the philosophy that building bricks are for all ages, but some people seem to think they\'re just for kids. These are the same sorts of people who give us the hairy eyeball when we venture into the brick store at the mall or when we put a pack of Fun Dip in our cart with every intention of eating it ourselves. Possibly before we get to the register. Slightly damp UPCs are still scannable, right?</p>\n<p>Why should you stop having fun because some people have no imagination? You shouldn\'t! This Executive Building Brick Set is the perfect answer to those spoilsports. With 8 2x4 stud building bricks, this set can be incorporated with your other bricks to build all sorts of shiny custom creations. With their clean and crisp lines, these metal bricks look perfect gracing your modern office or coffee table. Leave them out and see who can\'t resist.</p>\n<p><strong>Product Specifications </strong> </p>\n<p> </p>\n<ul><li>Executive Building Brick Set</li>\n<li>Includes 8 2x4 stud building bricks</li>\n<li>Chrome-plated solid metal construction</li>\n<li>Combine with your other bricks</li>\n<li>Compatible with other popular building sets</li>\n<li>Materials: Chrome-plated base metal</li>\n<li>Weight: 6 1/2 oz. </li>\n<li>Ages 14+</li>\n</ul>','<h4 class=\"prodheader\">BUILDING BRICKS ALL GROWN UP</h4>\n<ul><li>Set includes 8 2x4 stud building bricks</li>\n<li>Chrome-plated solid metal construction</li>\n<li>Compatible with other popular building sets</li>\n</ul>','','BUILDING BRICKS ALL GROWN UP\nSet includes 8 2x4 stud building bricks\nChrome-plated solid metal construction\nCompatible with other popular building sets\n','','en'),(24,24,'Blizzard Diablo Goblin Bank with Sound','<h4 class=\"prodheader\">OMGOBLIN!</h4>\n<p>Diablo III\'s Treasure Goblins. Enigmatically, they\'re creatures which cannot deal damage to your character but are the most likely to be the reason for your character\'s untimely demise. There\'s something about them (could it be all the LOOT?!) that makes all reason go out the door. Even in hardcore, we occasionally accidentally chase them right into the midst of elite mob packs. That rarely ends well.</p>\n<p>You don\'t have to worry about that happening with this Diablo Treasure Goblin Bank with Sound, and we promise this one won\'t teleport out on you with 3% health left. He\'s going to stay right where you put him. Just don\'t put him down next to a portal, okay? Fill his bag with loot and listen to him cackle happily as he takes your money. And you don\'t have to beat the candy out of him to get your money back - there\'s a coin removal door on the bottom of the bank. If only in-game Treasure Goblins were this simple....</p>\n<p><strong>Product Specifications</strong>   </p>\n<ul><li>Diablo Treasure Goblin Bank with Sound</li>\n<li>Officially-licensed <em>Diablo III</em> merchandise</li>\n<li>A ThinkGeek creation &amp; exclusive</li>\n<li>Cackles happily as he takes your money</li>\n<li>When you drop a coin in, one of six sounds plays</li>\n<li>Coin removal door on the bottom (so you don\'t have to beat the candy out of him - unless you just want to)</li>\n<li>Note: Does not drop legendary items (unless you fill it with legendary items)</li>\n<li>Batteries: 3 AAA 1.5V LR03 (not included)</li>\n<li>Dimensions: 9\" deep x 4 1/2\" wide x 8\" tall </li>\n<li>Weight: 12 oz. (without batteries)</li>\n<li><strong>Ages 6+</strong></li>\n</ul>','<h4 class=\"prodheader\">OMGOBLIN!</h4>\n<ul><li>Diablo Treasure Goblin Bank with Sound</li>\n<li>Cackles happily as he takes your money</li>\n<li>A ThinkGeek creation &amp; exclusive</li>\n</ul>','','OMGOBLIN!\nDiablo Treasure Goblin Bank with Sound\nCackles happily as he takes your money\nA ThinkGeek creation &amp; exclusive\n','','en'),(25,25,'Ghostbusters Stay Puft Marshmallow Face Mug','<h4 class=\"prodheader\">I AIN\'T AFRAID OF NO COFFEE</h4>\n<div class=\"right\"> </div>\n<blockquote>I tried to think of the most harmless thing. Something I loved from my childhood. Something that could never ever possibly destroy us. Mr. Stay Puft!<br />- Ray</blockquote>\n<p>This mug lets you decide how your day\'s going to go. On one side, it features the sweet Stay Puft Marshmallow Man\'s smiling face, the one Ray remembers from his childhood. On the other, it features evil Stay Puft Marshmallow Man, destroyer of worlds, the one who\'s come to terrorize New York City. Which side will you drink from today?</p>\n<p><strong>Product Specifications</strong>   </p>\n<ul><li>A two-sided mug featuring the Stay Puft Marshmallow Man\'s countenance</li>\n<li>Happy mascot on one side; paranormal monster on the other</li>\n<li>Officially-licensed Ghostbusters merchandise</li>\n<li>Capacity: 20 oz.</li>\n<li>Materials: Ceramic</li>\n<li>Dimensions: 3 3/4\" tall x 4\" wide</li>\n<li>Not microwave safe</li>\n<li>Not dishwasher safe</li>\n<li><strong>Ages 12+</strong></li>\n</ul>','<h4 class=\"prodheader\">I AIN\'T AFRAID OF NO COFFEE</h4>\n<ul><li>If you are not afraid of any ghosts, this is the mug for you</li>\n<li>Holds 20 ounces of your favorite beverage</li>\n<li>(Presumably cocoa with marshmallows)</li>\n</ul>','','I AIN\'T AFRAID OF NO COFFEE\nIf you are not afraid of any ghosts, this is the mug for you\nHolds 20 ounces of your favorite beverage\n(Presumably cocoa with marshmallows)\n','','en'),(26,26,'Build-On Brick Mug','<h4 class=\"prodheader\">BUILD UP YOUR COFFEE!</h4>\n<p><span style=\"color:#ff0000;\"><em>Important Note: The Brick Mug does not come with any bricks. You need to provide your own. However we\'re confident you\'ve got a variety of compatible building sets at your house already. Oh... also you don\'t get coffee, you need to brew that or something. In short, you get the mug. Okay, we\'re done here.</em></span></p>\n<p>Morning meetings suck. We\'re lucky at ThinkGeek because generally a \"morning\" meeting starts at 11, so you\'ve got some time to get a cup of coffee in before you have to brain too hard. If you\'re in a climate where 9 am meetings are the norm, you\'re going to need more than caffeine to stay awake.</p>\n<p>Enter the Build-On Brick Mug. It\'s a coffee mug and construction set all in one! Bring along a handful of your favorite building blocks - it\'s compatible with LEGO™, PixelBlocks, Mega Bloks, KRE-O, or K\'NEX Bricks™ - and tinker with a creation while your upper management drones on about things they think are important. What will your mug become? That\'s up to you! Be sure to send us your Action Shots!</p>\n<p><strong>Product Specifications</strong></p>\n<ul><li>Drink your coffee and build something, too!</li>\n<li>Choose from black, grey, or red</li>\n<li>Mug with exterior building surface compatible with most bricks</li>\n<li>Compatibility:\n<ul><li>LEGO™</li>\n<li>PixelBlocks</li>\n<li>Mega Bloks</li>\n<li>KRE-O</li>\n<li>K\'NEX Bricks™</li>\n</ul></li>\n<li><strong>Note</strong>: This mug is not officially licensed by LEGO™, PixelBlocks, Mega Bloks, KRE-O, or K\'NEX Bricks™. It just happens to be compatible with them all.</li>\n<li>Not Microwave safe (but fine for hot coffee)</li>\n<li><strong>Materials</strong>: BPA-free plastic</li>\n<li><strong>Capacity</strong>: 12 ounces</li>\n<li><strong>Washing</strong>: Hand wash</li>\n</ul>','<h4 class=\"prodheader\">BUILD UP YOUR COFFEE!</h4>\n<ul><li>Have your coffee and build it too!</li>\n<li>Compatible with most construction bricks</li>\n<li>May cause distraction at morning meetings</li>\n</ul>','','BUILD UP YOUR COFFEE!\nHave your coffee and build it too!\nCompatible with most construction bricks\nMay cause distraction at morning meetings\n','','en'),(27,27,'Superhero Mom Mug','<h4 class=\"prodheader\">YEAH, YOU\'RE SUPER!</h4>\n<p>You may not always have the cape on, but you really are super. Your kids think so. We think so. We also think you should let the world know. You could always wear a shirt or a sandwich board proclaiming your super-ness, but we think the best way is with a super mug. A Superhero Mom Mug, to be precise.</p>\n<p>Each Superhero Mom Mug features all the molded on details you\'d expect from a super mug: cape, belt (to keep the superpants up), arms akimbo, and emblem on the chest (featuring a big M for Mom). And the arms akimbo aren\'t just a posture choice - they actually form two handles! The Superhero Mom Mug will hold 15 oz. of your favorite beverage and is dishwasher and microwave safe. The only thing the Superhero Mom Mug can\'t do is fly. We\'ll leave that up to you!</p>\n<p>Also great for anyone whose name starts with the letter M.</p>\n<p><strong>Product Specifications</strong>  </p>\n<ul><li>Superhero Mom Mug</li>\n<li>This mug is ready for justice</li>\n<li>The arms (gallantly akimbo) are the handles of this super mug</li>\n<li>A ThinkGeek creation and exclusive!</li>\n<li>Dishwasher safe</li>\n<li>Microwave safe</li>\n<li>Capacity: 15 oz.</li>\n<li>Materials: Ceramic</li>\n<li>Dimensions: approx. 3.75\" x 6.75\" x 4\"</li>\n</ul>','<h4 class=\"prodheader\">YEAH, YOU\'RE SUPER!</h4>\n<ul><li>The perfect mug for SuperMoms everywhere</li>\n<li>Holds 15 oz of any super beverage</li>\n<li>A ThinkGeek creation and exclusive!</li>\n</ul>','','YEAH, YOU\'RE SUPER!\nThe perfect mug for SuperMoms everywhere\nHolds 15 oz of any super beverage\nA ThinkGeek creation and exclusive!\n','','en'),(28,28,'Olloclip iPhone Macro 3-in-1 Lens System','<h4 class=\"prodheader\">MACROCOSMIC</h4>\n<p>Compatible with the iPhone 5/5S or the 5th gen iPod Touch (using the included adapter), the Olloclip Macro 3-in-1 is a quick-connect lens system that includes 7x, 14x, and 21x lenses in a tiny and convenient package.</p>\n<p>Using Olloclip is easy! Slide it on over your iPhone\'s rear camera lens, and you\'re ready to take amazing photos and videos. With that 21x lens, what you have is a very basic microscope, one which runs on your iPhone and snags amazing pictures of your \"slides.\" The 14x and 21x also come with hoods designed to diffuse light and set you up for success by providing the optimum distance from the object being photographed. Olloclip\'s storage bag even doubles as a microfiber cleaning cloth for the ultimate in convenience.</p>\n<p>Product Specifications</p>\n<ul><li>Quick-connect lens system for iPhone 5/5S</li>\n<li>Comes with 7x, 14x, and 21x macro lens options</li>\n<li>Slides on to the corner of your iPhone and automatically aligns itself</li>\n<li>The camera will autofocus as normal with the Olloclip on, don\'t worry!</li>\n<li>Works for still photos, videos, even super-detailed Facetime</li>\n<li>Lenses made with precision-ground glass, multi-element optics</li>\n<li>Barrels made from aircraft-grade anodized aluminum</li>\n<li>Soft plastic material on clip protects your iPhone from scratches</li>\n<li>Included in the Olloclip package:\n<ul><li>3 macro lenses (7x, 14x, and 21x)</li>\n<li>2 InstaFocus hoods for steadier shots at the perfect distance and diffused light</li>\n<li>Microfiber lens cleaning cloth storage bag</li>\n<li>5th gen iPod Touch adapter</li>\n</ul></li>\n<li>Note: The Olloclip is specifically designed for the shape and size of the iPhone 5 and 5S. It will not fit any other device besides the iPod touch model mentioned above.</li>\n</ul>','<h4 class=\"prodheader\">MACROCOSMIC</h4>\n<ul><li>Quick-connect lens system for iPhone 5/5S</li>\n<li>Includes 7x, 14x, and 21x macro lenses</li>\n<li>Works for still photos, videos, even super-detailed Facetime</li>\n</ul>','','MACROCOSMIC\nQuick-connect lens system for iPhone 5/5S\nIncludes 7x, 14x, and 21x macro lenses\nWorks for still photos, videos, even super-detailed Facetime\n','','en'),(29,29,'Gunnar Vayper Gaming Glasses','<div id=\"productimage\">\n<div class=\"prod_gallery\">\n<div id=\"image\"><strong>REDUCE EYESTRAIN WITH SCIENCE!</strong></div>\n</div>\n</div>\n<div class=\"contentblob\">\n<div> </div>\n<div id=\"proddescription\">The human eye is a magnificent device. Refined over millions of years of evolution, it\'s a highly specialized and effective organ that helps us hunt prey, spot berries, and notice and dodge swinging clubs. As humanity continued to evolve, however, we relied more on the tools we manufactured rather than the ones with which we were born.<br /><br />Now we have more so-called \"knowledge-workers\" than ever, spending all day tied to desks, and staring at computer screens. We\'ve traded sore backs and calluses for headaches and dry and tired eyes. You rub your eyes, and drip drops into them, but that doesn\'t really help, does it?<br /><br />You see, high-efficiency fluorescent lighting and computer monitors in our offices are highly shifted towards the blue-end of the spectrum. The problem is, blue light focuses differently on the retina than the rest of the spectrum. Ever look at a blue LED and noticed a halo around the light? Staring at it gives you a headache, doesn\'t it? Guess why! Your eyes are straining to try and bring that fuzzy spot into focus, and they just can\'t!<br /><br />What you need is a way to filter out some of those blues that give your eyes so much trouble. With amber lenses, Gunnar Computer Glasses shift that light to the warmer end of the spectrum, giving your tired eyes a chance to recover. Not only do they filter blue light, they also reduce glare, helping with eye strain even more.<br /><br />Be more productive, working longer and harder than the other guys, and maybe you\'ll get that promotion before Doofus McDumbPants across the hall does. We hate that guy.<br /><br /><strong>Product Specifications  </strong><br /><ul><li>Glasses specifically designed to reduce computer-related eyestrain</li>\n<li>Onyx-colored, injection-polymer frame</li>\n<li>Adjustable silicone nose pads provide a customizable fit</li>\n<li>Fastener-free hinge design and high tensile steel construction</li>\n<li>Gently-curved, ultra-slim temples distribute headphone pressure to ensure headset compatibility</li>\n<li>One piece front construction eliminates all welds, screws and other potential points of failure</li>\n<li>Flexible temples conform and ergonomically fit a wide range of head and face shapes</li>\n<li>Wide format lenses create a panoramic viewing field for high resolution viewing</li>\n<li>58mm lens width x 15mm nose x 130mm temple</li>\n<li>Note: These will not fit over your current glasses. However, you can custom order them <a href=\"http://www.gunnars.com/rx/\">with your prescription lenses.</a></li>\n</ul></div>\n</div>','<h4 class=\"prodheader\">REDUCE EYESTRAIN WITH SCIENCE!</h4>\n<ul><li>Glasses reduce computer-related eyestrain</li>\n<li>Great for code monkeys and gamers</li>\n<li>Onyx-colored, injection-polymer frame</li>\n</ul>','','REDUCE EYESTRAIN WITH SCIENCE!\nGlasses reduce computer-related eyestrain\nGreat for code monkeys and gamers\nOnyx-colored, injection-polymer frame\n','','en'),(30,30,'Astro A50 Halo Edition','<h4 class=\"prodheader\">HEADPHONES FOR THE MASTER CHIEF IN YOU!</h4>\n<p>When it\'s game time, you slip on your headphones and disappear into whatever world you\'re gaming in. It\'s important that these headphones are quality for many reasons. First, you want to make sure you hear everything: from explosions to enemies to spells to conversation with other online players. And second, you want to make sure other players hear you! Time to power up your gaming experience to a whole new level with the Astro A50 Halo Edition.</p>\n<p>With the Astro A50 Halo Edition, you can experience the world of the Master Chief with Dolby 7.1 Surround Sound, without being tied down by cords. The uni-directional microphone delivers absolute vocal clarity for distortion-free communication with your teammates. Using top of the line wireless technology, the Astro A50 Halo Edition employs three different EQ modes, allowing you to customize your audio experience for movies, hardcore gaming, or competitive shooters. And thanks to the Astro A50 Halo Edition\'s adjustable size and plush cushions, you can game comfortably all through the night. Because sometimes, the war never ends.</p>\n<p><strong>Product Specifications</strong>  </p>\n<ul><li>These wireless headphones are at the pinnacle of gaming headphone technology</li>\n<li>Master Chief color and detailing</li>\n<li>Wireless 5.8 GHz</li>\n<li>Dolby 7.1</li>\n<li>EQ presets</li>\n<li>Flip-up to mute mic</li>\n<li>Compatibility: Xbox One (also works with PS4, PS3, 360*, PC)\n<ul><li>* For 360, voice chat requires XBL Controller Cable (Sold Separately)</li>\n</ul></li>\n<li>Astro A50 Specs:\n<ul><li>Transducer Principle: Open Air</li>\n<li>Frequency Response: 20 - 21,000 Hz</li>\n<li>Distortion: THD &lt; 1%</li>\n<li>Microphone: 6.0mm unidirectional with noise gate</li>\n<li>Nominal Impedance: 48 Ohms</li>\n<li>Headband Pressure: 2.6N</li>\n<li>Ear Coupling: Over-Ear</li>\n<li>Weight w/o Cable: 363 g</li>\n<li>Connection: 2.5mm Xbox Live Chat Port, Micro-USB Port</li>\n</ul></li>\n<li>MixAmp Tx Specs:\n<ul><li>Wireless: 5.8GHz w/ KleerNet</li>\n<li>Audio Fidelity: 48kHz 16-bit</li>\n<li>Mic Fidelity: 48kHz 16-bit</li>\n<li>Channels: Stereo w/ Dolby</li>\n<li>Input: Micro-USB Power &amp; Voice, Optical In, AUX In (3.5mm)</li>\n<li>Output: Optical Passthrough, USB Charging Port</li>\n<li>Power: USB</li>\n<li>Surround Technology: Dolby PLIIx, Dolby Headphone</li>\n</ul></li>\n<li>Includes:\n<ul><li>A50 Wireless Headset</li>\n<li>MixAmp Tx </li>\n<li>AG1</li>\n<li>Display Stand</li>\n<li>Headset Cables: 0.5m Micro-USB Cable</li>\n<li>MixAmp Cables: 1.0m Micro-USB Cable, 1.0m TOSlink Optical Cable</li>\n</ul></li>\n</ul>','<h4 class=\"prodheader\">HEADPHONES FOR THE MASTER CHIEF IN YOU!</h4>\n<ul><li>The zenith of Astro headphones: the A50!</li>\n<li>Dolby Digital 7.1 sound and wireless 5.8GHz technology</li>\n<li>Master Chief color and detailing</li>\n</ul>','','HEADPHONES FOR THE MASTER CHIEF IN YOU!\nThe zenith of Astro headphones: the A50!\nDolby Digital 7.1 sound and wireless 5.8GHz technology\nMaster Chief color and detailing\n','','en'),(31,31,'Cup of Mojo Bluetooth Speaker','<h4 class=\"prodheader\">A TINY SHOT OF BIG SOUND</h4>\n<p>Mojo is some powerful stuff. They say either you have it or you don\'t, but if you\'ve had it in the past and are just running low now, you can get it back. You know what our favorite way to get our mojo is? Wirelessly, because then we can share it with everyone in the room. See, this kind of mojo connects to our smartphone and plays our music for all to hear. No, we\'re not crazy - we\'re using the Cup of Mojo Bluetooth Speaker!</p>\n<p>Available in many stunning colors that are fun and bold, the Cup of Mojo Bluetooth Speaker is the perfect accompaniment to any smartphone, tablet, computer, or anything else with Bluetooth. Enjoy the loud, clear, acoustics whether you\'re at home, by the BBQ, in the park, or in your local coffee shop (possibly annoying many other patrons). Clip the Cup of Mojo Bluetooth Speaker anywhere with the integrated handle carabiner clip, and you\'ll always have your tunes when you need them most (especially, during afternoon tea).</p>\n<p><strong>Product Specifications</strong>   </p>\n<ul><li>A little cup is really a portable bluetooth speaker!</li>\n<li>Clip your Cup of Mojo Speaker anywhere with the carabiner handle clip</li>\n<li>Stream music from any Bluetooth 3.0 device (smartphones, tablets, computers, etc.)</li>\n<li>Boosted bass for even bass-ier bass</li>\n<li>Rubber bottom to protect surfaces (and prevent slippage)</li>\n<li>One button operation (for ease power on/off and Bluetooth pairing)</li>\n<li>Range: Up to 32.8 feet (depending on line of sight)</li>\n<li>Batteries: Rechargeable lithium-ion battery via micro-USB cable (included)</li>\n<li>Battery Life: Up to 4 hours</li>\n<li>Includes: Cup of Mojo Bluetooth Speaker, USB Charge-Cable, and Quick Start Guide </li>\n<li>It looks like a mug, but it is not microwave or dishwasher safe</li>\n<li>Dimensions: approx. 2.3\" x 3.25\" x 2.4\"</li>\n<li>Weight: approx. 3.7 oz</li>\n</ul>','<h4 class=\"prodheader\">A TINY SHOT OF BIG SOUND</h4>\n<ul><li>A little Bluetooth speaker that looks like a cup of mojo</li>\n<li>Boosted bass for a fuller sound</li>\n<li>Carabiner handle clip will make sure you have a speaker whenever you need it</li>\n</ul>','','A TINY SHOT OF BIG SOUND\nA little Bluetooth speaker that looks like a cup of mojo\nBoosted bass for a fuller sound\nCarabiner handle clip will make sure you have a speaker whenever you need it\n','','en'),(32,32,'JBL Pebbles PC Speakers','<h4 class=\"prodheader\">THESE SPEAKERS GO BAMM-BAMM!</h4>\n<p>Some things in life are very complicated. And many times, those complicated things don\'t work out as well as they should (based on their complexity). Well, to all those complicated things that aren\'t good, we say, \"SHAME!\" And to further shame them, we use a pair of JBL Pebbles PC Speakers. Why? Because they are super easy, yet pump out sound like a complicated speaker system.</p>\n<p>Simply connect your JBL Pebbles PC Speakers via USB plug-and-play and transform your laptop entertainment into a unique 2.0 stereo sound experience. The USB provides audio information AND power, so there\'s no extra AC adapter to worry about. Plus, the cords wrap around the base, to minimize the cable clutter. One of the JBL Pebbles PC Speakers has an integrated volume knob (the whole center of the speaker is a big dial), so you can quickly and easily adjust the loud-i-tude of your tunes. Upgrade your computer\'s sound system with the JBL Pebbles PC Speakers. Your music will thank you.</p>\n<p><strong>Product Specifications</strong>  </p>\n<ul><li>Stylish pair of USB plug-and-play speakers for your computer</li>\n<li>USB powered - USB audio transfer</li>\n<li>Integrated cords wrap around base for less wire clutter; stores in base for easy portability</li>\n<li>Integrated volume/power control</li>\n<li>Auxiliary input for connecting other devices</li>\n<li>Choice of Color: Black or White</li>\n<li>Includes:\n<ul><li>1 pair JBL Pebbles USB digital speakers, with built-in USB</li>\n<li>Audio cable</li>\n<li>Quick-start guide</li>\n</ul></li>\n<li>Dimensions: 6\" diameter x 2.75\" wide (each)</li>\n<li>Weight: 1.18 lbs (each)</li>\n</ul>','<h4 class=\"prodheader\">THESE SPEAKERS GO BAMM-BAMM!</h4>\n<ul><li>Stylish USB speakers are plug-and-play</li>\n<li>USB powered, so AC adapter needed</li>\n<li>Integrated volume control in the center of one speaker</li>\n</ul>','','THESE SPEAKERS GO BAMM-BAMM!\nStylish USB speakers are plug-and-play\nUSB powered, so AC adapter needed\nIntegrated volume control in the center of one speaker\n','','en'),(33,33,'Bright Idea - USB-Powered Light Bulb','<h4 class=\"prodheader\">SHED SOME LIGHT ON THE SUBJECT</h4>\n<p>There are a lot of USB-powered devices that aren\'t terribly useful. See: USB Humping Dog, <a href=\"http://www.thinkgeek.com/c208\">USB Pet Rock</a>, <a href=\"http://www.thinkgeek.com/ede3\">USB Squirming Tentacle</a>. They\'re all, shall we say, ornamental. Like rhinestones on a phone case, they\'re purely decorative additions to your space, which is just what you need sometimes.</p>\n<p>However, this USB-Powered Light Bulb won\'t ever fall into that category. See, when it\'s plugged into a USB port it gives off a frosted, soft blue light, and when it\'s not it glows in the dark.</p>\n<p>It\'s perfect for working late at night. Sure, your laptop is backlit, but sometimes it\'s not just the screen you need to see. And the shiny, adjustable cable is definitely artsy and clever. Plug it into an <a href=\"http://www.thinkgeek.com/eb7b\">iGeek</a> or a similar charger and have your own portable, crazy-looking lamp. It\'d be great around a pool or at an outdoor venue where you need light for a little while but may not have a convenient outlet.</p>\n<p><strong>Product Specifications</strong></p>\n<ul><li>Light bulb powered by USB (gives off a frosted, soft blue light from an LED)</li>\n<li>Glows in the dark when not powered</li>\n<li>Compatible with all standard USB ports</li>\n<li>Adjustable gooseneck arm is 9 1/2\" of shiny metal</li>\n<li>Good for considerate roommates (inconsiderate roommates need not apply)</li>\n<li>Materials: Plastic? Resin? Not glass, at the very least.</li>\n<li>Dimensions: 2 1/2\" wide x 2 1/2\" deep, 9 1/2\" cable</li>\n<li>It\'s basically the size of a standard incandescent bulb, although the base is a bit smaller.</li>\n<li>Weight: just over 2 oz.</li>\n</ul>','<h4 class=\"prodheader\">SHED SOME LIGHT ON THE SUBJECT</h4>\n<ul><li>Light bulb powered by USB</li>\n<li>Great for situations where you need just a bit more light</li>\n<li>Glows in the dark when not plugged in</li>\n</ul>','','SHED SOME LIGHT ON THE SUBJECT\nLight bulb powered by USB\nGreat for situations where you need just a bit more light\nGlows in the dark when not plugged in\n','','en'),(34,34,'MJ Technology Android Tablet with Built-in HDTV Tuner','<h4 class=\"prodheader\">MORE PORTS THAN AN IPAD</h4>\n<p>Okay, so almost ANY ports is more than an iPad, so that isn\'t really an accomplishment, but we still figured it was worth pointing out, because we always end up frustrated when we end up troubleshooting someone\'s iPad (despite having bought them AppleCare and having previously escorted them to the Genius Bar) and realize we have to transfer something large we have on this laptop next to us to the iPad via the Internet. <br /><br />None of that with this new Android tablet with built-in HDTV tuner from MJ Technology. You might recognize MJ Technology\'s name because of the talk about their Ubuntu tablets coming out. This 7\" one instead runs Android 4.1 (Jelly Bean) on its 1.5GHz dual cortex A9 processor. To get a good grasp of this tablet, imagine everything you expect out of an Android tablet. Now add in the ability to pick up an over-the-air HDTV television signal. Voila. With just a 7\" screen diagonal, it\'s not clunky but neither is it the torture of trying to navigate a spreadsheet on your phone. Goldilocks, we think it\'s just right.<br /><br /><strong>Product Specifications  </strong></p>\n<ul><li>Android Tablet with Built-in HDTV Tuner</li>\n<li>Choose black, white, or gray</li>\n<li>Runs Android 4.1 (Jelly Bean)</li>\n<li>7\" diagonal LCD screen with 1024 x 600 resolution (720P)</li>\n<li>1.5GHz dual cortex A9 processor</li>\n<li>8GB storage built-in</li>\n<li>Ports for the included 3G antenna, a micro-SD (supports up to 64GB), microphone, headphone jack, and micro-USB </li>\n<li>Built-in cameras (front-facing 0.3 + 2 megapixel rear-facing)</li>\n<li>802.1 b/g/n wi-fi connection</li>\n<li>5 points multi-touch capacitive touch screen</li>\n<li>Built-in speakers with Dolby Digital Audio</li>\n<li>Retractable external ATSC antenna for over-the-air digital television</li>\n<li>Batteries: Built-in rechargeable Li-Poly battery</li>\n<li>One charge provides 4-6 hours of HDTV-tuned TV or 8 hours of tablet/general use</li>\n<li>Includes tablet, microUSB to standard USB adapter, 3G antenna, and a wall charger</li>\n<li>Dimensions: 8 1/2\" long x 5 1/4\" wide x 1\" thick</li>\n<li>Weight: 11 oz.</li>\n</ul>','<h4 class=\"prodheader\">MORE PORTS THAN AN IPAD</h4>\n<ul><li>7\" diagonal LCD screen with 1024 x 600 resolution (720P)</li>\n<li>1.5GHz dual cortex A9 processor</li>\n<li>Retractable external ATSC antenna for over-the-air digital television</li>\n</ul>','','MORE PORTS THAN AN IPAD\n7\" diagonal LCD screen with 1024 x 600 resolution (720P)\n1.5GHz dual cortex A9 processor\nRetractable external ATSC antenna for over-the-air digital television\n','','en'),(35,35,'BACtrack Vio - Bluetooth App Enabled Breathalyzer','<h4 class=\"prodheader\">THREE SPREADSHEETS TO THE WIND</h4>\n<p>All adults who drink have their own sobriety self-tests. Some of us start slurring our words. Others get more clumsy than usual (which takes skill). Some of us who are introverts can tell we\'re drunk when we\'re talking to strangers without being acutely aware of it. But, of course, none of these is an accurate test for whether or not it\'s safe to hit the road.</p>\n<p>The BACtrack Vio is a wireless, app-enabled breathalyzer. It uses Bluetooth 4.0 LE to sync with your device. You breathe into the device; your phone tells you your blood alcohol content level, from 0.000 - 0.400%. But wait. There\'s more. Because this breathalyzer has your smartphone powering it, it can do a few more things. For instance, it can track your drinking over time. It can tell you at what time you\'ll be sober (15 more minutes of ill-advised karaoke or are you down for a movie?). It allows you to easily share via SMS or social your details and location with someone who\'s not with you so you can get home safely. And it\'ll let you guess your BAC, so you\'ll know how good your self-test really is.</p>\n<p>One final note. For anybody who\'s argued with a drunk friend in a parking lot before, this app is great for using science to prove to them that you need to take the wheel for everyone\'s sake. And it comes with three replaceable mouthpieces so you can test multiple friends once they see how cool your little gadget is.</p>\n<p><strong>Product Specifications</strong></p>\n<ul><li>Detects blood alcohol content from 0.000 - 0.400% BAC</li>\n<li>Compatible with iPhone 5/5S, 5C, 4S; iPad Air, 4, 3, Mini 1 and 2; Samsung Galaxy S5, S4, S3 (some other devices running Android 4.3 equipped with Bluetooth 4.0)</li>\n<li>Wirelessly syncs with your iPhone or Android smartphone via Bluetooth 4.0 LE</li>\n<li>Free BACtrack app estimates when your BAC will return to 0.00%, lets you guess your BAC, tracks your drinking over time, and even lets you easily share details including location and time via SMS or social (if you\'re calling friends for a ride, make it easy on them)</li>\n<li>More accurate results than standard semiconductor sensors</li>\n<li>Warm-up Time: 10 seconds</li>\n<li>Blowing Time: 5 seconds</li>\n<li>In under 30 seconds, you can know whether you should ride with a friend or call a cab</li>\n<li>Batteries: 1 AAA battery (included)</li>\n<li>Dimensions: 0.95\" x 2.85\" x 0.65\"</li>\n<li>Weight: 2 oz. (including battery)</li>\n<li>Includes BACtrack, battery, 3 replaceable mouthpieces, and manual</li>\n</ul>','<h4 class=\"prodheader\">THREE SPREADSHEETS TO THE WIND</h4>\n<ul><li>Detects blood alcohol content from 0.000 - 0.400%</li>\n<li>Fits easily into a pocket or purse</li>\n<li>Compatible with iPhone 5/5S, Samsung Galaxy S5, S4, and more</li>\n</ul>','','THREE SPREADSHEETS TO THE WIND\nDetects blood alcohol content from 0.000 - 0.400%\nFits easily into a pocket or purse\nCompatible with iPhone 5/5S, Samsung Galaxy S5, S4, and more\n','','en'),(36,36,'Coffee Cup Power Inverter V2.0','<div id=\"proddescription\">\n<h4 class=\"prodheader\">LIKE A CAFFEINE BOOST FOR YOUR ELECTRONICS!</h4>\n<p>When you start to feel a little low on energy you can turn to that terrific alkaloid, caffeine. Available from many sources like Bawls and, of course, that tried and true hot beverage, coffee. Reaching for your coffee cup to get an energy boost when you\'re tired is pretty much second nature. Well, now your gadgets can turn to a coffee cup of their own when they need an energy recharge.</p>\n<p>The Coffee Cup Power Inverter V2.0 is a conveniently shaped power source that coverts your car\'s DC power into two 120-volt AC outlets. Perfect for powering or charging smartphones, tablets, DVD players, televisions, game consoles, and tons of other portable electronics. This new version of the coffee cup also has an upgraded USB charging port providing 2.1 amps of power. The unique coffee cup shape fits nicely in today\'s auto/boat/truck cup holders, preventing it from moving around inside your vehicle.</p>\n<p> </p>\n</div>\n<div id=\"bullets\">\n<ul><li>200 Watt inverter with 2 AC plugs and USB power port</li>\n<li>New and improved version of one of our favorites</li>\n<li>2.1 amp USB port for extra charging power (previously 500mAh)</li>\n<li>Provides 120 Volt AC power from any cigarette lighter socket</li>\n<li>200W continuous/400W peak</li>\n<li>Fits into standard cup holders</li>\n<li>18\" cord</li>\n<li>Overload protection and low battery shut-off</li>\n<li>Power 3 devices at once</li>\n<li>One year warranty</li>\n<li>Dimensions: 6\" tall x 3.5\" dia</li>\n</ul></div>','<h4 class=\"prodheader\">LIKE A CAFFEINE BOOST FOR YOUR ELECTRONICS!</h4>\n<ul><li>200 watt inverter with 2 AC plugs with new 2.1 amp USB port</li>\n<li>Fits into standard cup holders in your car</li>\n<li>Keep all of your gear up and running</li>\n</ul>','','LIKE A CAFFEINE BOOST FOR YOUR ELECTRONICS!\n200 watt inverter with 2 AC plugs with new 2.1 amp USB port\nFits into standard cup holders in your car\nKeep all of your gear up and running\n','','en'),(37,37,'Apple iPhone 6S [Options & Attributes] [Custom tabs]','<div class=\"features\">\n<div class=\"feature media-block\">\n<div class=\"content\"><br /><p>iPhone 6S isn’t simply bigger — it’s better in every way. Larger, yet dramatically thinner. More powerful, but remarkably power efficient. With a smooth metal surface that seamlessly meets the new Retina HD display. It’s one continuous form where hardware and software function in perfect unison, creating a new generation of iPhone that’s better by any measure.</p>\n<h4>iPhone at its largest. And thinnest.</h4>\n<p>Developing an iPhone with a larger, more advanced display meant pushing the edge of design. From the seamless transition of glass and metal to the streamlined profile, every detail was carefully considered to enhance your experience. So while its display is larger, iPhone 6 feels just right.</p>\n</div>\n</div>\n<div class=\"feature media-block\">\n<div class=\"media\"> </div>\n<div class=\"content\">\n<h4>Not just a bigger display. A better display.</h4>\n<p>It’s one thing to make a bigger display. It’s something else entirely to make a bigger MultiTouch display with brilliant colors and higher contrast at even wider viewing angles. But that’s exactly what we did with the new Retina HD display.</p>\n</div>\n</div>\n<div class=\"feature media-block\">\n<div class=\"media\"> </div>\n<div class=\"content\">\n<h4>Hugely powerful. Enormously efficient.</h4>\n<p>Built on 64-bit desktop-class architecture, the new A8 chip delivers more power, even while driving a larger display. The M8 motion coprocessor efficiently gathers data from advanced sensors and a new barometer. And with increased battery life, iPhone 6 lets you do more, for longer than ever.</p>\n</div>\n</div>\n</div>\n<div class=\"feature media-block\">\n<div class=\"media\"> </div>\n<div class=\"content\">\n<h4>The camera that changed photos now does the same for video.</h4>\n<p>More people take more photos with iPhone than with any other camera. And now the iSight camera has a new sensor with Focus Pixels and new video features, like 1080p HD at 60 fps, slo-mo at 240 fps, and time-lapse video mode. So you’ll have more reasons to capture more moments on video, too.</p>\n</div>\n</div>\n<div class=\"gs grid-9of20\">\n<div class=\"in-the-box\">\n<div> </div>\n<div class=\"content\">\n<h4>What’s in the box</h4>\n<ul class=\"ul\"><li>iPhone 6S</li>\n<li>Apple EarPods with Remote and Mic</li>\n<li>Lightning to USB Cable</li>\n<li>5W USB Power Adapter</li>\n</ul></div>\n</div>\n</div>\n<div style=\"padding:24px 24px 24px 21px;display:block;\">This site is a demo site only. This product is not available for sale at our site. <br />But you can buy it at <a style=\"color:#1e7ec8;text-decoration:underline;\" title=\"Apple Store\" href=\"http://store.apple.com/us/buy-iphone/iphone6\">Apple Store</a>, this is where we took description from.</div>','','','\niPhone 6S isn’t simply bigger — it’s better in every way. Larger, yet dramatically thinner. More powerful, but remarkably power efficient. With a smooth metal surface that seamlessly meets the new Retina HD display. It’s one continuous form where hardware and software function in perfect unison, creating a new generation of iPhone that’s better by any measure.\niPhone at its largest. And thinnest.\nDeveloping an iPhone with a larger, more advanced display meant pushing the edge of design. From the seamless transition of glass and metal to the streamlined profile, every detail was carefully considered to enhance your experience. So while its display is larger, iPhone 6 feels just right.\n\n\n\n \n\nNot just a bigger display. A better display.\nIt’s one thing to make a bigger display. It’s something else entirely to make a bigger MultiTouch display with brilliant colors and higher contrast at even wider viewing angles. But that’s exactly what we did with the new Retina HD display.\n\n\n\n \n\nHugely powerful. Enormously efficient.\nBuilt on 64-bit desktop-class architecture, the new A8 chip delivers more power, even while driving a larger display. The M8 motion coprocessor efficiently gathers data from advanced sensors and a new barometer. And with increased battery life, iPhone 6 lets you do more, for longer than ever.\n\n\n\n\n \n\nThe camera that changed photos now does the same for video.\nMore people take more photos with iPhone than with any other camera. And now the iSight camera has a new sensor with Focus Pixels and new video features, like 1080p HD at 60 fps, slo-mo at 240 fps, and time-lapse video mode. So you’ll have more reasons to capture more moments on video, too.\n\n\n\n\n \n\nWhat’s in the box\niPhone 6S\nApple EarPods with Remote and Mic\nLightning to USB Cable\n5W USB Power Adapter\n\n\n\nThis site is a demo site only. This product is not available for sale at our site. But you can buy it at Apple Store, this is where we took description from.','','en'),(38,38,'Canon EF 24-105mm f/4L IS USM','<p>This easy-to-use standard zoom lens can cover a large zoom area ranging from 24mm wide-angle to 105mm portrait-length telephoto, and its Image Stabilizer Technology steadies camera shake up to three stops. Constructed with one Super-UD glass element and three aspherical lenses, this lens minimizes chromatic aberration and distortion. The result is excellent picture quality, even at wide apertures. Canon\'s ring-type USM gives silent but quick AF, along with full-time manual focus. Moreover, with dust- and moisture-resistant construction, this is a durable yet sophisticated lens that meets the demands of advanced amateur photographers and professional photographers alike.</p>\n<ul class=\"propsInfo\"><li>Lens mount: Canon EF Mount</li>\n<li>24 mm - 105 mm, Aperture 1:4.0</li>\n<li>image stabilizer</li>\n<li>min. focal range 0.45 m</li>\n<li>Filter-Ø 77 mm, weatherproof</li>\n</ul>','','','This easy-to-use standard zoom lens can cover a large zoom area ranging from 24mm wide-angle to 105mm portrait-length telephoto, and its Image Stabilizer Technology steadies camera shake up to three stops. Constructed with one Super-UD glass element and three aspherical lenses, this lens minimizes chromatic aberration and distortion. The result is excellent picture quality, even at wide apertures. Canon\'s ring-type USM gives silent but quick AF, along with full-time manual focus. Moreover, with dust- and moisture-resistant construction, this is a durable yet sophisticated lens that meets the demands of advanced amateur photographers and professional photographers alike.\nLens mount: Canon EF Mount\n24 mm - 105 mm, Aperture 1:4.0\nimage stabilizer\nmin. focal range 0.45 m\nFilter-Ø 77 mm, weatherproof\n','','en'),(39,39,'Apple Watch Sport 42mm with Sport Band','<p>Every Apple Watch Sport comes with one year of hardware repair coverage through its <a href=\"http://www.apple.com/legal/warranty\" target=\"_blank\">limited warranty</a> and up to <a href=\"http://www.apple.com/support/complimentary\" target=\"_blank\">90 days of complimentary support</a>.</p>\n<h2 class=\"fwl\">What’s in the box</h2>\n<ul><li>Apple Watch</li>\n<li>Magnetic charging cable (2 m)</li>\n<li>USB power adapter (5W)</li>\n<li>Sport Band (includes band that can be configured for either S/M or M/L length)</li>\n<li>Quick start guide</li>\n</ul><p> </p>\n<h2 class=\"fwl\">Apple Watch Sport features</h2>\n<ul><li>Silver or space gray anodized aluminum case</li>\n<li>Ion-X glass</li>\n<li>Retina display with Force Touch</li>\n<li>Composite back</li>\n<li class=\"compact-right-10\">Sport Band with stainless steel pin</li>\n<li>Digital Crown</li>\n<li>Heart rate sensor, accelerometer, and gyroscope</li>\n</ul><ul><li>Ambient light sensor</li>\n<li>Speaker and microphone</li>\n<li>Wi-Fi (802.11b/g/n 2.4GHz)</li>\n<li>Bluetooth 4.0</li>\n<li>Up to 18 hours of battery life*</li>\n<li>Water resistant**</li>\n</ul><p> </p>\n<p class=\"disclaimer\">*Battery life varies by use and configuration; actual results will vary. See <a href=\"http://www.apple.com/batteries\" target=\"_blank\">www.apple.com/batteries</a> and <a href=\"http://www.apple.com/watch/battery.html\" target=\"_blank\">www.apple.com/watch/battery.html</a> for more information.</p>\n<p class=\"disclaimer\">**Apple Watch is splash and water resistant but not waterproof. You can, for example, wear and use Apple Watch during exercise, in the rain, and while washing your hands, but submerging Apple Watch is not recommended. Apple Watch has a water resistance rating of IPX7 under IEC standard 60529. The leather bands are not water resistant.</p>\n<p class=\"disclaimer\"><br />Features are subject to change and may not be available in all regions or all languages. Requires iPhone 5 or later.</p>\n<p> </p>','','','Every Apple Watch Sport comes with one year of hardware repair coverage through its limited warranty and up to 90 days of complimentary support.\nWhat’s in the box\nApple Watch\nMagnetic charging cable (2 m)\nUSB power adapter (5W)\nSport Band (includes band that can be configured for either S/M or M/L length)\nQuick start guide\n \nApple Watch Sport features\nSilver or space gray anodized aluminum case\nIon-X glass\nRetina display with Force Touch\nComposite back\nSport Band with stainless steel pin\nDigital Crown\nHeart rate sensor, accelerometer, and gyroscope\nAmbient light sensor\nSpeaker and microphone\nWi-Fi (802.11b/g/n 2.4GHz)\nBluetooth 4.0\nUp to 18 hours of battery life*\nWater resistant**\n \n*Battery life varies by use and configuration; actual results will vary. See www.apple.com/batteries and www.apple.com/watch/battery.html for more information.\n**Apple Watch is splash and water resistant but not waterproof. You can, for example, wear and use Apple Watch during exercise, in the rain, and while washing your hands, but submerging Apple Watch is not recommended. Apple Watch has a water resistance rating of IPX7 under IEC standard 60529. The leather bands are not water resistant.\nFeatures are subject to change and may not be available in all regions or all languages. Requires iPhone 5 or later.\n ','','en'),(40,40,'Astro A30 System','<h4 class=\"prodheader\">HEAR WHAT YOU\'VE BEEN MISSING</h4>\n<p>When it\'s game time, you slip on your headphones and disappear into whatever world you\'re gaming in. It\'s important that these headphones are quality for many reasons. First, you want to make sure you hear everything: from explosions to enemies to spells to conversation with other online players. And second, you want to make sure other players hear you! Time to power up your gaming experience to a whole new level with the Astro A30 System.</p>\n<p>The Astro A30 System brings the power Dolby 7.1 Surround Sound to the next generation of gaming by combining the power of the A30 headset with the MixAmp Pro. The preferred choice among cross-platform gamers, the A30 is highly portable, lightweight and comes fully equipped with three different audio cables for easy connection not just to your Xbox One, but with a variety of mobile devices and consoles. Easy size adjustment and breathable fabric cushions make this over-ear design so comfortable, you might even forget you’re wearing them. The MixAmp Pro brings the ultimate power of Dolby 7.1 Surround Sound to your favorite games and allows you to capture both voice and game audio through the Stream output. The Astro A30 System - more power for your ear holes!</p>\n<p>Product Specifications  </p>\n<ul><li>Don\'t just hear your games, aurally experience them with this awesome headphones set</li>\n<li>Color Choice: Black or White</li>\n<li>Compatibility: Xbox One/PS4/PS3/PC</li>\n<li>Astro A30 Specs:\n<ul><li>Transducer Principle: Dynamic, Closed</li>\n<li>Frequency Response: 20 - 21,000 Hz</li>\n<li>Distortion: Less than 0.1%</li>\n<li>Microphone: 6.0mm unidirectional with noise gate</li>\n<li>Nominal Impedance: 32 Ohms</li>\n<li>Headband Pressure: 2.0N</li>\n<li>Ear Coupling: On-Ear</li>\n<li>Weight w/o Cable: 188 grams</li>\n<li>Connection: 3.5mm 4-pole Jack</li>\n</ul></li>\n<li>MixAmp Pro Specs:\n<ul><li>Inputs Rear: 3.5mm Mini TOSlink, 3.5mm mp3 connector, USB mini-B (audio/power), 3.5mm Stream Output</li>\n<li>Frequency Response: 20-20,000 Hz</li>\n<li>Power Output: 70mW 32ohm per channel</li>\n<li>Inputs Front: Headset Connector, 2.5mm Xbox Live voice communication connector, Two daisy chain 3.5mm ports</li>\n</ul></li>\n<li>Includes: \n<ul><li>A30 Headset</li>\n<li>A30 Mic</li>\n<li>ASTRO Speaker Tags</li>\n<li>MixAmp Pro</li>\n<li>Headset Cables: 2.0M A30 Inline Mute Cable, 65mm PC Splitter Cable</li>\n<li>MixAmp Cables: 3.0M TOSlink Optical Cable, 3.0M Mini-USB Cable, 1.5M Xbox Live Chat Cable, 1.5M 3.5mm Audio Cable</li>\n</ul></li>\n</ul>','<h4 class=\"prodheader\">HEAR WHAT YOU\'VE BEEN MISSING</h4>\n<ul><li>Awesome, cross-platform, gaming headphones</li>\n<li>MixAmp Pro included for even more control</li>\n<li>Works with Xbox One, PS4, PS3, and PC</li>\n</ul>','','HEAR WHAT YOU\'VE BEEN MISSING\nAwesome, cross-platform, gaming headphones\nMixAmp Pro included for even more control\nWorks with Xbox One, PS4, PS3, and PC\n','','en'),(41,41,'Apple iPhone 6S Plus [Options & Attributes]','<ul class=\"propsInfo\"><li>Smartphone, Apple iOS 9</li>\n<li>Display: 11.9 cm (4.7\"), 8.0 MP camera</li>\n<li>CPU: 2x 1.40 GHz, 64.0 GB storage</li>\n<li>GPS</li>\n<li>LTE, WLAN, Bluetooth 4.0, NFC</li>\n</ul>','','','Smartphone, Apple iOS 9\nDisplay: 11.9 cm (4.7\"), 8.0 MP camera\nCPU: 2x 1.40 GHz, 64.0 GB storage\nGPS\nLTE, WLAN, Bluetooth 4.0, NFC\n','','en'),(42,42,'Apple iPhone SE [Options & Attributes] [Tabs]','<div class=\"features\">\n<div class=\"feature media-block\">\n<div class=\"content\">\n<div class=\"features\">\n<div class=\"feature media-block\">\n<div class=\"content\">\n<h4>All-new design.</h4>\n<p>At 7.6 mm and 113 grams,<span style=\"font-size:xx-small;\"> </span>iPhone SE has a remarkably thin and light design. It’s made from anodized aluminum. And the beveled edges are diamond cut for incredible precision.</p>\n</div>\n</div>\n<div class=\"feature media-block\">\n<div class=\"media\"> </div>\n<div class=\"content\">\n<h4>Brilliant 4-inch Retina display.</h4>\n<p>4-inch (diagonal) LED-backlit widescreen Multi-Touch display with IPS technology</p>\n</div>\n</div>\n<div class=\"feature media-block\">\n<div class=\"content\">\n<h4>Powerful A9 chip.</h4>\n<p>A9 chip with 64-bit architecture. Embedded M9 motion coprocessor</p>\n</div>\n</div>\n<div class=\"feature media-block\">\n<div class=\"media\"> </div>\n<div class=\"content\">\n<h4>Ultrafast wireless.</h4>\n<p>With support for the latest wireless technologies, iPhone SE connects to more networks all over the world. And Wi-Fi is faster, too.</p>\n</div>\n</div>\n</div>\n<div class=\"gs grid-9of20\">\n<div class=\"in-the-box\">\n<div> </div>\n<div class=\"content\">\n<h4>What’s in the box</h4>\n<ul class=\"ul\"><li>iPhone SE with iOS 9.3</li>\n<li>Apple EarPods with Remote and Mic</li>\n<li>Lightning to USB Cable</li>\n<li>USB Power Adapter</li>\n</ul></div>\n</div>\n<div class=\"system-requirements\">\n<h4>Warranty</h4>\n<p>Every iPhone includes 90 days of free telephone technical support and a one-year limited warranty.</p>\n</div>\n</div>\n</div>\n</div>\n</div>\n<div class=\"gs grid-9of20\">\n<div class=\"system-requirements\">\n<p> </p>\n</div>\n</div>\n<div style=\"padding:24px 24px 24px 21px;display:block;\">This site is a demo site only. This product is not available for sale at our site. <br />But you can buy it at <a style=\"color:#1e7ec8;text-decoration:underline;\" title=\"Apple Store\" href=\"http://store.apple.com/us/buy/home/shop_iphone/family/iphone5\">Apple Store</a> , this is where we took description from.</div>','','','\n\n\n\n\nAll-new design.\nAt 7.6 mm and 113 grams, iPhone SE has a remarkably thin and light design. It’s made from anodized aluminum. And the beveled edges are diamond cut for incredible precision.\n\n\n\n \n\nBrilliant 4-inch Retina display.\n4-inch (diagonal) LED-backlit widescreen Multi-Touch display with IPS technology\n\n\n\n\nPowerful A9 chip.\nA9 chip with 64-bit architecture. Embedded M9 motion coprocessor\n\n\n\n \n\nUltrafast wireless.\nWith support for the latest wireless technologies, iPhone SE connects to more networks all over the world. And Wi-Fi is faster, too.\n\n\n\n\n\n \n\nWhat’s in the box\niPhone SE with iOS 9.3\nApple EarPods with Remote and Mic\nLightning to USB Cable\nUSB Power Adapter\n\n\n\nWarranty\nEvery iPhone includes 90 days of free telephone technical support and a one-year limited warranty.\n\n\n\n\n\n\n\n \n\n\nThis site is a demo site only. This product is not available for sale at our site. But you can buy it at Apple Store , this is where we took description from.','','en');
CREATE TABLE `xlite_vendor_convo_messages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `conversation_id` int(10) unsigned DEFAULT NULL,
  `profile_id` int(11) DEFAULT NULL,
  `date` int(10) unsigned NOT NULL,
  `body` longtext COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_329529AC0396` (`conversation_id`),
  KEY `IDX_32952CCFA12B8` (`profile_id`),
  CONSTRAINT `FK_32952CCFA12B8` FOREIGN KEY (`profile_id`) REFERENCES `xlite_profiles` (`profile_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_329529AC0396` FOREIGN KEY (`conversation_id`) REFERENCES `xlite_conversations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_category_quick_flags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned DEFAULT NULL,
  `subcategories_count_all` int(11) NOT NULL,
  `subcategories_count_enabled` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_5BA9C50312469DE2` (`category_id`),
  CONSTRAINT `FK_5BA9C50312469DE2` FOREIGN KEY (`category_id`) REFERENCES `xlite_categories` (`category_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_category_quick_flags` VALUES (1,1,4,3),(2,2,0,0),(3,3,0,0),(4,4,0,0),(5,5,3,3),(6,6,0,0),(7,7,0,0),(8,8,0,0);
CREATE TABLE `xlite_global_product_tab_provider` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tab_id` int(10) unsigned DEFAULT NULL,
  `code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_5120A7CB8D0C9323` (`tab_id`),
  CONSTRAINT `FK_5120A7CB8D0C9323` FOREIGN KEY (`tab_id`) REFERENCES `xlite_global_product_tabs` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_global_product_tab_provider` VALUES (1,1,'Core'),(2,2,'Core'),(3,3,'CDev\\GoSocial'),(4,4,'XC\\Reviews'),(5,5,'Core'),(6,6,'Core'),(7,7,'Core');
CREATE TABLE `xlite_profiles` (
  `profile_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  `membership_id` int(10) unsigned DEFAULT NULL,
  `pending_membership_id` int(10) unsigned DEFAULT NULL,
  `socialLoginProvider` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `socialLoginId` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `gaClientId` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `default_card_id` int(10) unsigned NOT NULL,
  `pending_zero_auth` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `pending_zero_auth_txn_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `pending_zero_auth_status` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `pending_zero_auth_interface` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `braintree_customer_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `saveCardBoxChecked` tinyint(1) NOT NULL,
  `conciergeUserId` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `login` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `password` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `password_hint` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `password_hint_answer` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `passwordResetKey` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `passwordResetKeyDate` int(11) NOT NULL,
  `access_level` int(11) NOT NULL,
  `cms_profile_id` int(11) NOT NULL,
  `cms_name` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `added` int(11) NOT NULL,
  `first_login` int(11) NOT NULL,
  `last_login` int(11) NOT NULL,
  `status` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `statusComment` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `referer` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `language` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `last_shipping_id` int(11) DEFAULT NULL,
  `last_payment_id` int(11) DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL,
  `forceChangePassword` tinyint(1) NOT NULL,
  `dateOfLoginAttempt` int(10) unsigned NOT NULL,
  `countOfLoginAttempts` int(11) NOT NULL,
  `searchFakeField` longtext COLLATE utf8_unicode_ci,
  `xcPendingExport` tinyint(1) NOT NULL,
  `lastCheckoutEmail` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`profile_id`),
  UNIQUE KEY `UNIQ_13F3DB338D9F6D38` (`order_id`),
  KEY `IDX_13F3DB331FB354CD` (`membership_id`),
  KEY `IDX_13F3DB33CD228392` (`pending_membership_id`),
  KEY `cms_profile` (`cms_name`,`cms_profile_id`),
  KEY `login` (`login`),
  KEY `order_id` (`order_id`),
  KEY `password` (`password`),
  KEY `access_level` (`access_level`),
  KEY `first_login` (`first_login`),
  KEY `last_login` (`last_login`),
  KEY `status` (`status`),
  CONSTRAINT `FK_13F3DB33CD228392` FOREIGN KEY (`pending_membership_id`) REFERENCES `xlite_memberships` (`membership_id`) ON DELETE SET NULL,
  CONSTRAINT `FK_13F3DB331FB354CD` FOREIGN KEY (`membership_id`) REFERENCES `xlite_memberships` (`membership_id`) ON DELETE SET NULL,
  CONSTRAINT `FK_13F3DB338D9F6D38` FOREIGN KEY (`order_id`) REFERENCES `xlite_orders` (`order_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_profiles` VALUES (1,NULL,NULL,NULL,NULL,NULL,'',0,'','','','','',0,NULL,'bit-bucket@example.com','084e0343a0486ff05530df6c705c8bb4','','','',0,0,0,'',1543299908,0,0,'E','','','en',NULL,NULL,1,0,0,0,'Guest Guest Guest;bit-bucket@example.com',0,''),(2,1,NULL,NULL,NULL,NULL,'',0,'','','','','',0,NULL,'bit-bucket@example.com','084e0343a0486ff05530df6c705c8bb4','','','',0,0,0,'',1543299908,0,0,'E','','','en',NULL,NULL,1,0,0,0,'Guest Guest Guest;bit-bucket@example.com',0,''),(3,2,NULL,NULL,NULL,NULL,'',0,'','','','','',0,NULL,'bit-bucket@example.com','084e0343a0486ff05530df6c705c8bb4','','','',0,0,0,'',1543299908,0,0,'E','','','en',NULL,NULL,1,0,0,0,'Guest Guest Guest;bit-bucket@example.com',0,''),(4,3,NULL,NULL,NULL,NULL,'',0,'','','','','',0,NULL,'bit-bucket@example.com','084e0343a0486ff05530df6c705c8bb4','','','',0,0,0,'',1543299908,0,0,'E','','','en',NULL,NULL,1,0,0,0,'Guest Guest Guest;bit-bucket@example.com',0,''),(5,4,NULL,NULL,NULL,NULL,'',0,'','','','','',0,NULL,'bit-bucket@example.com','084e0343a0486ff05530df6c705c8bb4','','','',0,0,0,'',1543299908,0,0,'E','','','en',NULL,NULL,1,0,0,0,'Guest Guest Guest;bit-bucket@example.com',0,''),(6,5,NULL,NULL,NULL,NULL,'',0,'','','','','',0,NULL,'bit-bucket@example.com','084e0343a0486ff05530df6c705c8bb4','','','',0,0,0,'',1543299909,0,0,'E','','','en',NULL,NULL,1,0,0,0,'Guest Guest Guest;bit-bucket@example.com',0,'');
CREATE TABLE `xlite_sales_tax_rates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tax_id` int(10) unsigned DEFAULT NULL,
  `zone_id` int(11) DEFAULT NULL,
  `tax_class_id` int(10) unsigned DEFAULT NULL,
  `membership_id` int(10) unsigned DEFAULT NULL,
  `value` decimal(14,4) NOT NULL,
  `type` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `position` int(11) NOT NULL,
  `noTaxClass` tinyint(1) NOT NULL,
  `taxableBase` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_1ACD2E0EB2A824D8` (`tax_id`),
  KEY `IDX_1ACD2E0E9F2C3FAB` (`zone_id`),
  KEY `IDX_1ACD2E0EA94AAAE` (`tax_class_id`),
  KEY `IDX_1ACD2E0E1FB354CD` (`membership_id`),
  CONSTRAINT `FK_1ACD2E0E1FB354CD` FOREIGN KEY (`membership_id`) REFERENCES `xlite_memberships` (`membership_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_1ACD2E0E9F2C3FAB` FOREIGN KEY (`zone_id`) REFERENCES `xlite_zones` (`zone_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_1ACD2E0EA94AAAE` FOREIGN KEY (`tax_class_id`) REFERENCES `xlite_tax_classes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_1ACD2E0EB2A824D8` FOREIGN KEY (`tax_id`) REFERENCES `xlite_sales_taxes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_order_review_keys` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  `keyValue` char(32) COLLATE utf8_unicode_ci NOT NULL,
  `addedDate` int(11) NOT NULL,
  `sentDate` int(11) NOT NULL,
  `firstClickDate` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_3869BA7B8D9F6D38` (`order_id`),
  KEY `keyValue` (`keyValue`),
  KEY `addedDate` (`addedDate`),
  KEY `sentDate` (`sentDate`),
  CONSTRAINT `FK_3869BA7B8D9F6D38` FOREIGN KEY (`order_id`) REFERENCES `xlite_orders` (`order_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_product_tags` (
  `product_id` int(10) unsigned NOT NULL,
  `tag_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`tag_id`),
  KEY `IDX_88C085284584665A` (`product_id`),
  KEY `IDX_88C08528BAD26311` (`tag_id`),
  CONSTRAINT `FK_88C08528BAD26311` FOREIGN KEY (`tag_id`) REFERENCES `xlite_tags` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_88C085284584665A` FOREIGN KEY (`product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_money_modificators` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `class` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `modificator` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `validator` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `position` int(11) NOT NULL,
  `behavior` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `purpose` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_money_modificators` VALUES (1,'XLite\\Logic\\AttributeSurcharge','modifyMoney','isApply',10,'','net'),(2,'XLite\\Module\\CDev\\Sale\\Logic\\SalePrice','modifyMoney','isApply',5,'','net'),(3,'XLite\\Module\\CDev\\Sale\\Logic\\PercentOff','modifyMoney','isApply',500,'','net');
CREATE TABLE `xlite_attribute_option_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_31550B83BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_attribute_options` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_attribute_option_translations` VALUES (1,1,'S','en'),(2,2,'M','en'),(3,3,'L','en'),(4,4,'XL','en'),(5,5,'XXL','en'),(8,8,'XXXL','en'),(109,109,'IndependentApparel','en'),(110,110,'YourStyle','en'),(111,111,'MyBestDress','en'),(112,112,'Toyty','en'),(113,113,'FunnyChildren','en'),(114,114,'MindSet','en'),(115,115,'GoodyBrand','en'),(116,116,'iBoutique','en'),(1001,1,'S','ru'),(1002,2,'M','ru'),(1003,3,'L','ru'),(1004,4,'XL','ru'),(1005,5,'XXL','ru'),(1008,8,'XXXL','ru'),(1109,109,'IndependentApparel','ru'),(1110,110,'YourStyle','ru'),(1111,111,'MyBestDress','ru'),(1112,112,'Toyty','ru'),(1113,113,'FunnyChildren','ru'),(1114,114,'MindSet','ru'),(1115,115,'GoodyBrand','ru'),(1116,116,'iBoutique','ru'),(1134,134,'Blue','en'),(1135,135,'Gold','en'),(1136,136,'Red','en'),(1143,143,'Blue','en'),(1144,144,'Gold','en'),(1145,145,'Red','en'),(1158,158,'Dr. Peter Venkman','en'),(1159,159,'Dr. Egon Spengler','en'),(1160,160,'Dr. Raymond Stantz','en'),(1161,161,'White','en'),(1162,162,'Black','en'),(1163,163,'Black','en'),(1164,164,'White','en'),(2001,1,'S','ru'),(2002,2,'M','ru'),(2003,3,'L','ru'),(2004,4,'XL','ru'),(2005,5,'XXL','ru'),(2008,8,'XXXL','ru'),(2109,109,'IndependentApparel','ru'),(2110,110,'YourStyle','ru'),(2111,111,'MyBestDress','ru'),(2112,112,'Toyty','ru'),(2113,113,'FunnyChildren','ru'),(2114,114,'MindSet','ru'),(2115,115,'GoodyBrand','ru'),(2116,116,'iBoutique','ru'),(3001,1,'S','ru'),(3002,2,'M','ru'),(3003,3,'L','ru'),(3004,4,'XL','ru'),(3005,5,'XXL','ru'),(3008,8,'XXXL','ru'),(3109,109,'IndependentApparel','ru'),(3110,110,'YourStyle','ru'),(3111,111,'MyBestDress','ru'),(3112,112,'Toyty','ru'),(3113,113,'FunnyChildren','ru'),(3114,114,'MindSet','ru'),(3115,115,'GoodyBrand','ru'),(3116,116,'iBoutique','ru'),(3134,134,'Синий','ru'),(3135,135,'Золотой','ru'),(3136,136,'Красный','ru'),(3143,143,'Синий','ru'),(3144,144,'Золотой','ru'),(3145,145,'Красный','ru'),(3158,158,'Питер Венкман','ru'),(3159,159,'Иган Спенглер','ru'),(3160,160,'Рэймонд Стэнтс','ru'),(3161,161,'Белый','ru'),(3162,162,'Черный','ru'),(3163,163,'Черный','ru'),(3164,164,'Белый','ru'),(3165,165,'16','en'),(3166,166,'64','en'),(3167,167,'128','en'),(3168,168,'Silver','en'),(3169,169,'Space Gray','en'),(3170,170,'Gold','en'),(3171,171,'A8 chip with 64‑bit architecture','en'),(3172,172,'Nano-SIM','en'),(3173,173,'Retina HD display','en'),(3174,174,'4.7','en'),(3175,175,'1334x750','en'),(3176,176,'Built-in rechargeable lithium-ion battery','en'),(3177,177,'Up to 14 hours on 3G','en'),(3178,178,'Up to 10 days (250 hours)','en'),(3179,179,'Up to 11 hours','en'),(3180,180,'Up to 50 hours','en'),(3181,181,'GSM/EDGE/LTE','en'),(3182,182,'802.11a/b/g/n/ac','en'),(3183,183,'Bluetooth 4.2','en'),(3184,184,'5.5','en'),(3185,185,'1920x1080','en'),(3186,186,'32','en'),(3187,187,'A7 chip with 64-bit architecture','en'),(3188,188,'White','en'),(3189,189,'Black','en'),(3190,190,'4','en'),(3191,191,'1136x640','en'),(3192,192,'Up to 10 hours on 3G','en'),(3193,193,'Up to 250 hours','en'),(3194,194,'Up to 10 hours','en'),(3195,195,'Up to 40 hours','en'),(3196,196,'GSM/EDGE','en'),(3197,197,'802.11a/b/g/n','en'),(3198,198,'Up to 24 hours on 3G','en'),(3199,199,'Up to 16 days (384 hours)','en'),(3200,200,'A9 chip with 64‑bit architecture','en'),(3201,201,'Purple','en'),(3202,202,'Green','en'),(3203,203,'Orange','en'),(3204,204,'Blue','en'),(3205,201,'Фиолетовый','ru'),(3206,202,'Зеленый','ru'),(3207,203,'Оранжевый','ru'),(3208,204,'Синий','ru'),(3209,205,'Rose Gold','en'),(3210,168,'Серебристый','ru'),(3211,169,'Серый космос','ru'),(3212,170,'Золотой','ru'),(3213,188,'Белый','ru'),(3214,189,'Черный','ru'),(3215,205,'Розовое золото','ru'),(3216,165,'16','ru'),(3217,166,'64','ru'),(3218,167,'128','ru'),(3219,186,'32','ru'),(3221,207,'Nano-SIM','ru'),(3223,209,'4','ru'),(3224,210,'1136x640','ru'),(3225,211,'Built-in rechargeable lithium-ion battery','ru'),(3226,212,'Up to 14 hours on 3G','ru'),(3227,213,'Up to 10 days (250 hours)','ru'),(3228,214,'Up to 10 hours','ru'),(3229,215,'Up to 40 hours','ru'),(3231,217,'802.11a/b/g/n/ac','ru');
CREATE TABLE `xlite_order_history_event_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_id` int(11) DEFAULT NULL,
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_BAE0BB2471F7E88B` (`event_id`),
  KEY `en` (`event_id`,`name`),
  CONSTRAINT `FK_BAE0BB2471F7E88B` FOREIGN KEY (`event_id`) REFERENCES `xlite_order_history_events` (`event_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_category_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8_unicode_ci NOT NULL,
  `metaTags` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `metaDesc` longtext COLLATE utf8_unicode_ci NOT NULL,
  `metaTitle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_9ED79EA5BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_categories` (`category_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_category_translations` VALUES (1,1,'Catalog','<h1>Welcome to X-Cart Demo Store!</h1><p>It illustrates operation and features of X-Cart - all-in-one eCommerce solution for swift and easy launch of a professional online store. Orders placed here cannot be fulfilled as all the sample products listed in this store are for demonstration and testing purposes only.</p>','','','','en'),(2,2,'iGoods - Product Filter','','','','','en'),(3,3,'Electronics','','','','','en'),(4,4,'Apparel','','','','','en'),(5,5,'Toys','','','','','en'),(6,6,'Geek toys','','','','','en'),(7,7,'Office Pranks','','','','','en'),(8,8,'Home & office','','','','','en');
CREATE TABLE `xlite_page_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `teaser` longtext COLLATE utf8_unicode_ci NOT NULL,
  `body` longtext COLLATE utf8_unicode_ci NOT NULL,
  `metaKeywords` longtext COLLATE utf8_unicode_ci NOT NULL,
  `metaTitle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_D4ABAC0BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_pages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_page_translations` VALUES (1,1,'Terms and conditions','Terms and conditions','<p>Terms and conditions text</p><p>To replace this text with the actual Terms and conditions, go to the \"Content -> Pages\" section, open the \"Terms &amp; Conditions\" page and edit the \"Content\" field.</p>','','','en'),(2,1,'Условия использования','Условия использования','<p>Чтобы разместить на этой странице Ваш собственный текст \"Условия использования\", перейдите в раздел \"Содержание -> Страницы\", откройте для редактирования страницу \"Условия использования\" и добавьте требуемый текст в поле \"Содержание\".</p>','','','ru'),(3,1,'条款约定','条款约定','<p>内容描述</p><p>要替代该条款内的内容，请到&ldquo;内容-网页&ldquo;中进行设置，打开页面编辑并在这里编辑内容栏目。</p>','','','zh'),(4,2,'Shipping','Shipping teaser','<p>This page is intended for your store\'s shipping policy.</p><p>Here you can provide general information about the available shipping options and rates, shipping turn-around times, size and weight limits for shipping, shipping restrictions, order tracking, and so on.</p><p></p><p>To replace this text with the actual delivery information, go to the \"Content -> Pages\" section, open the \"Shipping\" page and edit the \"Content\" field.</p>','','','en'),(5,2,'Доставка','Доставка','<p>Чтобы разместить на этой странице Ваш собственный текст \"Доставка\", перейдите в раздел \"Содержание -> Страницы\", откройте для редактирования страницу \"Доставка\" и добавьте требуемый текст в поле \"Содержание\".</p>','','','ru'),(6,2,'关于运输','关于运输','<p>关于运输的内容</p><p>要设置该页面的运输项目内容，请到&rdquo;内容-页面&rdquo;中打开关于运输页面进行修改。</p>','','','zh');
CREATE TABLE `xlite_menu_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_CC54E72BBF396750` FOREIGN KEY (`id`) REFERENCES `xlite_menus` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_menu_translations` VALUES (1,1,'Home','en'),(2,1,'Главная','ru'),(3,1,'主页','zh'),(4,3,'My Account','en'),(5,3,'Мой профиль','ru'),(6,3,'我的账户','zh'),(7,4,'My orders','en'),(8,4,'Мои заказы','ru'),(9,4,'订单（复数）','zh'),(10,5,'My address book','en'),(11,5,'Мои адреса','ru'),(12,5,'地址簿','zh'),(13,6,'Shipping','en'),(14,6,'Доставка','ru'),(15,7,'New!','en'),(16,7,'Новинки','ru'),(17,8,'Coming soon','en'),(18,8,'Скоро в продаже','ru'),(19,9,'Hot deals','en'),(20,9,'Акции','ru'),(21,10,'Sale','en'),(22,10,'Распродажа','ru'),(23,11,'Bestsellers','en'),(24,11,'Бестселлеры','ru'),(25,12,'Special offers','en'),(26,12,'Специальные предложения','ru'),(27,13,'Contact us','en'),(28,13,'Напишите нам','ru'),(29,14,'Categories','en'),(30,14,'Товары','ru'),(31,15,'Apparel','en'),(32,15,'Одежда','ru'),(33,16,'iGoods','en'),(34,16,'Электроника','ru'),(35,17,'Toys','en'),(36,17,'Игрушки','ru'),(37,18,'Offers','en'),(38,18,'Акции','ru'),(39,19,'Sale','en'),(40,19,'Распродажа','ru'),(41,20,'Coming soon','en'),(42,20,'Скоро в продаже','ru'),(43,21,'New!','en'),(44,21,'Новинки','ru'),(45,22,'Info links','en'),(46,22,'Информация','ru'),(47,23,'Shipping','en'),(48,23,'Правила доставки','ru'),(49,24,'Sitemap','en'),(50,24,'Карта сайта','ru'),(51,25,'Terms & Conditions','en'),(52,25,'Условия использования','ru'),(53,26,'Services','en'),(54,26,'Сервисы','ru'),(55,27,'Shipping info','en'),(56,27,'Доставка','ru'),(57,28,'Contact us','en'),(58,28,'Напишите нам','ru'),(59,29,'My X-Cart','en'),(60,29,'Мой X-Cart','ru'),(61,30,'Address book','en'),(62,30,'Мои адреса','ru'),(63,31,'Order list','en'),(64,31,'Мои заказы','ru'),(65,32,'Account details','en'),(66,32,'Личный кабинет','ru');
CREATE TABLE `xlite_custom_global_tabs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `global_tab_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_5C09BCAD629D8673` (`global_tab_id`),
  CONSTRAINT `FK_5C09BCAD629D8673` FOREIGN KEY (`global_tab_id`) REFERENCES `xlite_global_product_tabs` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_custom_global_tabs` VALUES (1,5),(2,6),(3,7);
CREATE TABLE `xlite_notifications` (
  `templatesDirectory` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `availableForAdmin` tinyint(1) NOT NULL,
  `availableForCustomer` tinyint(1) NOT NULL,
  `enabledForAdmin` tinyint(1) NOT NULL,
  `enabledForCustomer` tinyint(1) NOT NULL,
  `adminHeaderEnabled` tinyint(1) NOT NULL,
  `adminGreetingEnabled` tinyint(1) NOT NULL,
  `adminSignatureEnabled` tinyint(1) NOT NULL,
  `customerHeaderEnabled` tinyint(1) NOT NULL,
  `customerGreetingEnabled` tinyint(1) NOT NULL,
  `customerSignatureEnabled` tinyint(1) NOT NULL,
  `position` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`templatesDirectory`),
  UNIQUE KEY `UNIQ_26039A9958BB5391` (`templatesDirectory`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_notifications` VALUES ('failed_admin_login',1,0,1,0,1,0,1,1,1,1,100),('failed_transaction',1,0,1,0,1,0,1,1,1,1,200),('low_limit_warning',1,0,1,0,1,0,1,1,1,1,300),('modules/CDev/ContactUs/message',0,0,1,0,1,0,1,1,1,1,500),('modules/CDev/Egoods/egoods_links',0,1,0,1,1,0,1,1,1,1,600),('modules/CDev/PINCodes/acquire_pin_codes_failed',1,0,1,0,1,0,1,1,1,1,700),('modules/XC/CanadaPost/return_approved',0,1,0,1,1,0,1,1,1,1,800),('modules/XC/CanadaPost/return_rejected',0,1,0,1,1,0,1,1,1,1,900),('modules/XC/Reviews/new_review',1,0,1,0,1,0,1,0,0,0,1000),('modules/XC/Reviews/review_key',0,0,0,1,0,0,0,1,1,1,0),('modules/XC/VendorMessages/new_message_notification',1,1,1,1,1,0,1,1,1,1,1200),('modules/XC/VendorMessages/notification',1,1,1,1,1,0,1,1,1,1,1100),('order_advanced_changed',0,1,0,1,0,0,1,0,1,1,1300),('order_canceled',1,1,1,1,0,0,1,0,1,1,1500),('order_changed',1,1,1,1,0,0,1,0,1,1,1400),('order_created',1,1,1,1,0,0,1,0,1,1,1600),('order_failed',1,1,1,1,0,0,1,0,1,1,1700),('order_processed',1,1,1,1,0,0,1,0,1,1,1800),('order_shipped',0,1,0,1,0,0,1,0,1,1,1900),('order_tracking_information',0,0,0,1,0,0,1,0,1,1,2000),('order_waiting_for_approve',0,1,0,1,0,0,1,0,1,1,2100),('profile_created',1,1,0,1,1,0,1,1,1,1,2200),('profile_deleted',1,0,0,0,1,0,1,1,1,1,2300),('profile_modified',1,1,0,1,1,0,1,1,1,1,2400),('recover_password_request',0,0,1,1,1,0,1,1,1,1,2500),('register_anonymous',0,1,0,1,1,0,1,1,1,1,2600);
CREATE TABLE `xlite_memberships` (
  `membership_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `position` int(11) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  PRIMARY KEY (`membership_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_memberships` VALUES (1,10,1);
CREATE TABLE `xlite_language_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(11) DEFAULT NULL,
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `IDX_610C29E2BF396750` (`id`),
  KEY `ci` (`code`,`id`),
  CONSTRAINT `FK_610C29E2BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_languages` (`lng_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_language_translations` VALUES (1,1,'Afar','en'),(2,2,'Abkhazian','en'),(3,3,'Afrikaans','en'),(4,4,'Akan','en'),(5,5,'Albanian','en'),(6,6,'Amharic','en'),(7,7,'Arabic','en'),(8,8,'Aragonese','en'),(9,9,'Armenian','en'),(10,10,'Assamese','en'),(11,11,'Avaric','en'),(12,12,'Avestan','en'),(13,13,'Aymara','en'),(14,14,'Azerbaijani','en'),(15,15,'Bashkir','en'),(16,16,'Bambara','en'),(17,17,'Basque','en'),(18,18,'Belarusian','en'),(19,19,'Bengali','en'),(20,20,'Bihari','en'),(21,21,'Bislama','en'),(22,22,'Bosnian','en'),(23,23,'Brazilian Portuguese','en'),(24,24,'British','en'),(25,25,'Bulgarian','en'),(26,26,'Burmese','en'),(27,27,'Catalan','en'),(28,28,'Chamorro','en'),(29,29,'Chechen','en'),(30,30,'Chinese','en'),(31,31,'Church Slavic','en'),(32,32,'Chuvash','en'),(33,33,'Cornish','en'),(34,34,'Corsican','en'),(35,35,'Cree','en'),(36,36,'Czech','en'),(37,37,'Danish','en'),(38,38,'Divehi','en'),(39,39,'Dutch','en'),(40,40,'Dzongkha','en'),(41,41,'English','en'),(42,42,'Esperanto','en'),(43,43,'Estonian','en'),(44,44,'Ewe','en'),(45,45,'Faroese','en'),(46,46,'Fijian','en'),(47,47,'Finnish','en'),(48,48,'French','en'),(49,49,'Western Frisian','en'),(50,50,'Fulah','en'),(51,51,'Georgian','en'),(52,52,'German','en'),(53,53,'Gaelic','en'),(54,54,'Irish','en'),(55,55,'Galician','en'),(56,56,'Manx','en'),(57,57,'Greek','en'),(58,58,'Guarani','en'),(59,59,'Gujarati','en'),(60,60,'Haitian','en'),(61,61,'Hausa','en'),(62,62,'Hebrew','en'),(63,63,'Herero','en'),(64,64,'Hindi','en'),(65,65,'Hiri Motu','en'),(66,66,'Croatian','en'),(67,67,'Hungarian','en'),(68,68,'Igbo','en'),(69,69,'Icelandic','en'),(70,70,'Ido','en'),(71,71,'Sichuan Yi','en'),(72,72,'Inuktitut','en'),(73,73,'Interlingue','en'),(74,74,'Interlingua','en'),(75,75,'Indonesian','en'),(76,76,'Inupiaq','en'),(77,77,'Italian','en'),(78,78,'Javanese','en'),(79,79,'Japanese','en'),(80,80,'Kalaallisut','en'),(81,81,'Kannada','en'),(82,82,'Kashmiri','en'),(83,83,'Kanuri','en'),(84,84,'Kazakh','en'),(85,85,'Khmer or Cambodian','en'),(86,86,'Kikuyu','en'),(87,87,'Kinyarwanda','en'),(88,88,'Kirghiz','en'),(89,89,'Komi','en'),(90,90,'Kongo','en'),(91,91,'Korean','en'),(92,92,'Kuanyama','en'),(93,93,'Kurdish','en'),(94,94,'Lao','en'),(95,95,'Latin','en'),(96,96,'Latvian','en'),(97,97,'Limburgan','en'),(98,98,'Lingala','en'),(99,99,'Lithuanian','en'),(100,100,'Luxembourgish','en'),(101,101,'Luba-Katanga','en'),(102,102,'Ganda','en'),(103,103,'Macedonian','en'),(104,104,'Marshallese','en'),(105,105,'Malayalam','en'),(106,106,'Maori','en'),(107,107,'Marathi','en'),(108,108,'Malay','en'),(109,109,'Malagasy','en'),(110,110,'Maltese','en'),(111,111,'Mongolian','en'),(112,112,'Nauru','en'),(113,113,'Navajo','en'),(114,114,'Ndebel','en'),(115,115,'Ndebel','en'),(116,116,'Ndonga','en'),(117,117,'Nepali','en'),(118,118,'Norwegian','en'),(119,119,'Chichewa','en'),(120,120,'Occitan','en'),(121,121,'Ojibwa','en'),(122,122,'Oriya','en'),(123,123,'Oromo','en'),(124,124,'Ossetian','en'),(125,125,'Panjabi','en'),(126,126,'Persian','en'),(127,127,'Pali','en'),(128,128,'Polish','en'),(129,129,'Portuguese','en'),(130,130,'Pushto','en'),(131,131,'Quechua','en'),(132,132,'Romansh','en'),(133,133,'Romanian','en'),(134,134,'Rundi','en'),(135,135,'Russian','en'),(136,136,'Sango','en'),(137,137,'Sanskrit','en'),(138,138,'Sinhala','en'),(139,139,'Slovak','en'),(140,140,'Slovenian','en'),(141,141,'Northern Sami','en'),(142,142,'Samoan','en'),(143,143,'Shona','en'),(144,144,'Sindhi','en'),(145,145,'Somali','en'),(146,146,'Soth','en'),(147,147,'Spanish','en'),(148,148,'Sardinian','en'),(149,149,'Serbian','en'),(150,150,'Swati','en'),(151,151,'Sundanese','en'),(152,152,'Swahili','en'),(153,153,'Swedish','en'),(154,154,'Tahitian','en'),(155,155,'Tamil','en'),(156,156,'Tatar','en'),(157,157,'Telugu','en'),(158,158,'Tajik','en'),(159,159,'Tagalog','en'),(160,160,'Thai','en'),(161,161,'Tibetan','en'),(162,162,'Tigrinya','en'),(163,163,'Tonga','en'),(164,164,'Tswana','en'),(165,165,'Tsonga','en'),(166,166,'Turkmen','en'),(167,167,'Turkish','en'),(168,168,'Twi','en'),(169,169,'Uighur','en'),(170,170,'Ukrainian','en'),(171,171,'Urdu','en'),(172,172,'Uzbek','en'),(173,173,'Venda','en'),(174,174,'Vietnamese','en'),(175,175,'Welsh','en'),(176,176,'Walloon','en'),(177,177,'Wolof','en'),(178,178,'Xhosa','en'),(179,179,'Yiddish','en'),(180,180,'Yoruba','en'),(181,181,'Zhuang','en'),(182,182,'Zulu','en');
CREATE TABLE `xlite_attribute_properties` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned DEFAULT NULL,
  `attribute_id` int(10) unsigned DEFAULT NULL,
  `position` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_3C3647F44584665A` (`product_id`),
  KEY `IDX_3C3647F4B6E62EFA` (`attribute_id`),
  CONSTRAINT `FK_3C3647F4B6E62EFA` FOREIGN KEY (`attribute_id`) REFERENCES `xlite_attributes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_3C3647F44584665A` FOREIGN KEY (`product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_product_class_coupons` (
  `coupon_id` int(10) unsigned NOT NULL,
  `class_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`coupon_id`,`class_id`),
  KEY `IDX_684B0DA666C5951B` (`coupon_id`),
  KEY `IDX_684B0DA6EA000B10` (`class_id`),
  CONSTRAINT `FK_684B0DA6EA000B10` FOREIGN KEY (`class_id`) REFERENCES `xlite_product_classes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_684B0DA666C5951B` FOREIGN KEY (`coupon_id`) REFERENCES `xlite_coupons` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_menu_quick_flags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_id` int(10) unsigned DEFAULT NULL,
  `submenus_count_all` int(11) NOT NULL,
  `submenus_count_enabled` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_B0327DB0CCD7E912` (`menu_id`),
  CONSTRAINT `FK_B0327DB0CCD7E912` FOREIGN KEY (`menu_id`) REFERENCES `xlite_menus` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_menu_quick_flags` VALUES (1,3,2,2),(3,1,0,0),(4,2,12,12),(5,4,0,0),(6,5,0,0),(8,6,0,0),(9,7,0,0),(10,8,0,0),(11,9,3,2),(12,10,0,0),(13,11,0,0),(14,12,0,0),(15,14,3,3),(16,13,0,0),(17,15,0,0),(18,16,0,0),(19,17,0,0),(20,18,3,3),(21,19,0,0),(22,20,0,0),(23,21,0,0),(24,22,3,3),(25,23,0,0),(26,24,0,0),(27,25,0,0),(28,26,2,2),(29,27,0,0),(30,28,0,0),(31,29,3,3),(32,30,0,0),(33,31,0,0),(34,32,0,0);
CREATE TABLE `xlite_roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `enabled` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_roles` VALUES (1,1),(2,1),(3,1),(4,1);
CREATE TABLE `xlite_payment_transaction_data` (
  `data_id` int(11) NOT NULL AUTO_INCREMENT,
  `transaction_id` int(11) DEFAULT NULL,
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `access_level` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`data_id`),
  KEY `IDX_BA8F92A12FC0CB0F` (`transaction_id`),
  KEY `tn` (`transaction_id`,`name`),
  CONSTRAINT `FK_BA8F92A12FC0CB0F` FOREIGN KEY (`transaction_id`) REFERENCES `xlite_payment_transactions` (`transaction_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_payment_transaction_data` VALUES (1,4,'test_mode','Test mode','A','1'),(2,4,'error_field_name_card.number','Error: field name','A','card.number'),(3,4,'error_field_code_card.number','Error: field code','A','country.bin.not.accepted'),(4,4,'error_field_message_card.number','Error: field message','A','Card bin Country rejected by acquirer'),(5,4,'cart_items','Cart items','A','a:1:{i:0;a:5:{s:4:\"name\";s:27:\"Ewok Ladies Hooded Tank Top\";s:3:\"sku\";s:6:\"100ewl\";s:5:\"price\";d:34.990000000000002;s:6:\"amount\";i:1;s:5:\"attrs\";a:0:{}}}'),(6,5,'test_mode','Test mode','A','1'),(7,5,'error_field_name_card.number','Error: field name','A','card.number'),(8,5,'error_field_code_card.number','Error: field code','A','card.expired'),(9,5,'error_field_message_card.number','Error: field message','A','Card has expired.'),(10,5,'cart_items','Cart items','A','a:1:{i:0;a:5:{s:4:\"name\";s:27:\"Ewok Ladies Hooded Tank Top\";s:3:\"sku\";s:6:\"100ewl\";s:5:\"price\";d:34.990000000000002;s:6:\"amount\";i:1;s:5:\"attrs\";a:0:{}}}');
CREATE TABLE `xlite_profile_roles` (
  `role_id` int(10) unsigned NOT NULL,
  `profile_id` int(11) NOT NULL,
  PRIMARY KEY (`role_id`,`profile_id`),
  KEY `IDX_7E99B5FD60322AC` (`role_id`),
  KEY `IDX_7E99B5FCCFA12B8` (`profile_id`),
  CONSTRAINT `FK_7E99B5FCCFA12B8` FOREIGN KEY (`profile_id`) REFERENCES `xlite_profiles` (`profile_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_7E99B5FD60322AC` FOREIGN KEY (`role_id`) REFERENCES `xlite_roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_measure_dumps` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `data` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `text` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_coupon_categories` (
  `coupon_id` int(10) unsigned NOT NULL,
  `category_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`coupon_id`,`category_id`),
  KEY `IDX_2EB1BB6066C5951B` (`coupon_id`),
  KEY `IDX_2EB1BB6012469DE2` (`category_id`),
  CONSTRAINT `FK_2EB1BB6012469DE2` FOREIGN KEY (`category_id`) REFERENCES `xlite_categories` (`category_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_2EB1BB6066C5951B` FOREIGN KEY (`coupon_id`) REFERENCES `xlite_coupons` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_capost_return_link_storage` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(512) COLLATE utf8_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  `linkId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_784CAF87AEC98E42` (`linkId`),
  CONSTRAINT `FK_784CAF87AEC98E42` FOREIGN KEY (`linkId`) REFERENCES `xlite_capost_return_links` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_order_items` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `object_id` int(10) unsigned DEFAULT NULL,
  `order_id` int(11) DEFAULT NULL,
  `categoryAdded` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `xpcFakeItem` tinyint(1) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `sku` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `price` decimal(14,4) NOT NULL COMMENT '(DC2Type:money)',
  `itemNetPrice` decimal(14,4) NOT NULL,
  `discountedSubtotal` decimal(14,4) NOT NULL,
  `amount` int(11) NOT NULL,
  `total` decimal(14,4) NOT NULL,
  `subtotal` decimal(14,4) NOT NULL,
  `object_type` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `IDX_4693C0A18D9F6D38` (`order_id`),
  KEY `ooo` (`order_id`,`object_type`,`object_id`),
  KEY `object_id` (`object_id`),
  KEY `price` (`price`),
  KEY `amount` (`amount`),
  CONSTRAINT `FK_4693C0A18D9F6D38` FOREIGN KEY (`order_id`) REFERENCES `xlite_orders` (`order_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_4693C0A1232D562B` FOREIGN KEY (`object_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_order_items` VALUES (1,13,1,'',0,'Vinyl Idolz: Ghostbusters','1204',19.9900,19.9900,16.9900,1,19.9900,19.9900,'product'),(2,3,2,'',0,'Spiderman Selfie Ladies\' Tee','12030',19.9900,19.9900,39.9800,2,39.9800,39.9800,'product'),(3,8,2,'',0,'Bow Ties Are Cool [Unlimited QTY]','12007',19.9900,14.9900,44.9700,3,44.9700,44.9700,'product'),(4,12,3,'',0,'Minions Pop Vinyl Figures','12022',9.9900,9.9900,59.9400,6,59.9400,59.9400,'product'),(5,17,3,'',0,'Ollie - The App Controlled Robot','12026',99.0000,99.0000,99.9900,1,99.0000,99.0000,'product'),(6,10,4,'',0,'Ewok Ladies Hooded Tank Top','100ewl',34.9900,34.9900,34.9900,1,34.9900,34.9900,'product'),(7,15,5,'',0,'Soft Kitty Singing Plush [Sale] [Reviews]','12029',29.9900,25.4900,305.8800,12,305.8800,305.8800,'product'),(8,27,5,'',0,'Superhero Mom Mug','12035',12.9900,6.4900,45.4300,7,45.4300,45.4300,'product');
CREATE TABLE `xlite_attribute_values_select_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_CDF9A7AFBF396750` FOREIGN KEY (`id`) REFERENCES `xlite_attribute_values_select` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_notification_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8_unicode_ci NOT NULL,
  `customerSubject` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `customerText` longtext COLLATE utf8_unicode_ci NOT NULL,
  `adminSubject` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `adminText` longtext COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_3F6179FEBF396750` FOREIGN KEY (`id`) REFERENCES `xlite_notifications` (`templatesDirectory`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_notification_translations` VALUES (1,'failed_admin_login','Failed admin login','The notification is sent to the email address of the admin user for whose account failed login attempts have been detected several times in a row. A copy of the message is also sent to the store’s super admin user.','','','WARNING! Administrator login failure','Failed administrator login detected.','en'),(2,'failed_transaction','Failed transaction','This notification is sent to the administrator if payment transaction was failed','','','Failed transaction','','en'),(3,'low_limit_warning','Low limit warning','This message is used to notify the administrator when the stock level of a product reaches the low stock limit as specified in the product details.','','','Low stock warning','The inventory level of a product in your store has reached the low limit.','en'),(4,'order_advanced_changed','Order changed with advanced order management','This message is sent to notify the customer of any changes made to their order by an administrator using the advanced order management feature.','Your order has been changed','Your order has been changed by customer service. Here are the details of your order:','','','en'),(5,'order_changed','Order changed','This notification is sent to both the administrator and customer when the status of an order is updated - in the event that no other type of notification is sent.','Your order has been changed','Your order has been changed. Here are the details of your order:','Order has been changed','Order has been changed.','en'),(6,'order_canceled','Order canceled','This notification is sent to both the administrator and customer when an order gets the status Canceled.','Your order has been canceled','Your order has been canceled.','Order has been canceled','Order has been canceled.','en'),(7,'order_created','Order created','This notification is sent to both the administrator and customer when a new order is created.','Order has been created','Thank you for shopping with us! We received your order.<br />You will receive an order confirmation once your order is processed.','Order has been created','Order has been created.','en'),(8,'order_failed','Order declined','This notification is sent to both the administrator and customer when an order gets the status Declined.','Your order has been declined','The status of your order has been changed to \"Declined\". This could be for one of the following reasons:<br />1) The order was declined by the store administrator.<br />2) The payment could not be processed at the time of order placement.<br />For more information, please contact the store administrator.','Order has been declined','Order has been declined.','en'),(9,'order_processed','Order processed','This notification is sent to both the administrator and customer when an order gets the status Paid.','Order confirmation','Your order has been processed. Thank you for your business.<br />We will notify you by email of any further order status updates.','Order has been processed','Order has been processed.','en'),(10,'order_shipped','Order shipped','This notification is sent to the customer when an order gets the status Shipped.','Your order has been shipped','Your order has been shipped. Thank you for your business.<br />Please come back soon!','','','en'),(11,'order_tracking_information','Order tracking information','This notification is sent to the customer when an administrator clicks the \"Send tracking information to customer\" button.','Your order tracking information','Here are the tracking details for your order','','','en'),(12,'order_waiting_for_approve','Order awaiting for approval','This notification is sent to the customer when an order gets the status Waiting for approve.','Order awaiting for approval','Thank you for your purchase. Our team will provide you with the download links in a couple of hours. Sorry for the inconveniences.','','','en'),(13,'profile_created','User profile created','This notification is sent to both the administrator and customer when a new customer profile is created.','Welcome!','Thank you for registering with us.','New user registration','A new user profile has been registered:','en'),(14,'profile_deleted','User profile deleted','This notification is sent to the administrator when a customer profile is deleted.','','','User profile has been deleted','The following user profile has been deleted:','en'),(15,'profile_modified','User profile modified','This notification is sent to both the administrator and customer when a user profile is updated.','Your profile has been modified','Your profile has been modified. To view your profile information, log in at our site.','User profile has been modified','The user profile has been modified.','en'),(16,'recover_password_request','Password reset request','This notification is sent to the user when a password reset is requested for their account.','Confirm password reset request','<p>You have received this message because you requested to reset your forgotten password.<br />If you did not submit such a request, it might mean that somebody was trying to gain access to your account.</p><p>To confirm that this request was submitted by you, click on the link below<br/>(If the link does not work, please copy and paste the entire URL into your browser\'s address bar and press Enter).</p>','Confirm password reset request','<p>You have received this message because you requested to reset your forgotten password.<br />If you did not submit such a request, it might mean that somebody was trying to gain access to your account.</p><p>To confirm that this request was submitted by you, click on the link below<br/>(If the link does not work, please copy and paste the entire URL into your browser\'s address bar and press Enter).</p>','en'),(17,'register_anonymous','User account created for guest buyer based on order info','This notification is sent to the customer when a customer profile is created for them by the store administrator based on a previously created order.','User account created','<p>Thank you for shopping with us! We noticed that one or more orders you made at our store were placed using guest checkout. We appreciate your business and look forward to continue serving you in the future. For your convenience, we created an account for you at our store. The account stores all the information about your previous orders with us.</p><p>To log in to your account, please use the following credentials:<br />(The password can be changed in your account profile)</p>','','','en'),(18,'modules/CDev/ContactUs/message','Contact us form submitted (Contact us module)','This notification is sent to the administrator when someone submits a request via the \"Contact us\" form.','','','%contact_us_subject% - %company_name%. Contact us form','','en'),(19,'modules/CDev/ContactUs/message','Заполнена форма для связи с администрацией магазина (модуль Contact us)','Данное сообщение используется для оповещения администратора в случае поступления в адрес магазина обращения через форму для связи с администрацией.','','','%contact_us_subject% - %company_name%. Форма для связи с администрацией магазина','','ru'),(20,'modules/CDev/Egoods/egoods_links','E-goods download links (E-goods module)','This notification is sent to the customer when their order containing egoods gets the status Paid.','Your download links','Your order has been processed. The files for the products you purchased can be downloaded at:','','','en'),(21,'modules/CDev/Egoods/egoods_links','Ссылки для скачивания файлов (модуль E-goods)','Данное сообщение отправляется покупателю, когда размещенный им заказ, содержащий электронные товары, получает статус \"Оплачен\".','Ваши ссылки для скачивания файлов','Благодарим Вас за своевременную оплату заказа. Файлы приобретенных Вами товаров могут быть загружены по следующим ссылкам:','','','ru'),(22,'modules/CDev/PINCodes/acquire_pin_codes_failed','PIN code generation failure (PIN codes module)','This notification is sent to the administrator in the event of an error in the process of generating PIN codes for one or more items - as a result of which the PIN codes have not been generated.','','','PIN code generation failure for one or more ordered items','Could not generate PIN codes for the following products:','en'),(23,'modules/CDev/PINCodes/acquire_pin_codes_failed','Ошибка создания пин-кода (модуль PIN codes)','Данное сообщение отправляется администратору в случае, когда при создании PIN-кодов для одного или нескольких товаров произошла ошибка, в результате которой PIN-код(ы) не были созданы.','','','Ошибка создания PIN-кода для одного или нескольких заказанных товаров','Не удалось создать PIN-коды для следующих товаров:','ru'),(24,'modules/XC/Reviews/new_review','New product review submitted - (Product Reviews module)','This message is used to notify the administrator when a customer submits a new product review.','','','A new review has been submitted','','en'),(25,'modules/XC/Reviews/new_review','Получен новый отзыв о товаре - (модуль Product Reviews)','Данное сообщение используется для уведомления администратора о том, что клиент оставил отзыв о каком-либо товаре.','','','Получен новый отзыв о товаре','','ru'),(26,'modules/XC/Reviews/review_key','Request to review purchased products - (Product Reviews module)','This message is used to invite customers to leave feedback on the products they have purchased.','Please review your purchase','','','','en'),(27,'modules/XC/Reviews/review_key','Приглашение оставить отзыв на купленные товары - (модуль Product Reviews)','Данное сообщение используется для отправки покупателю приглашения оставить отзыв о купленных им товарах.','Пожалуйста, оставьте отзыв о купленных товарах','','','','ru'),(28,'modules/XC/VendorMessages/notification','Order message (Order messages module)','This message will be sent to customer when a new message appears in the communication thread regarding an order','New message for order %order_number%','%company_link%\n<p>\nYou\'ve got a message regarding your order %order_messages_link%:\n</p>\n<p>\n%message%\n</p>','','','en'),(29,'modules/XC/VendorMessages/new_message_notification','New message (Order messages module)','This message will be sent to customer when a new message appears in the conversation','New message in conversation','%company_link%\n<p>\nYou\'ve got a new message in %conversation_link%:\n</p>\n<p>\n%message%\n</p>\n','','','en'),(30,'modules/XC/VendorMessages/notification','Новое сообщение по заказу (модуль Order messages)','Это уведомление будет отправлено покупателю, когда в контексте сделанного им заказа появится новое сообщение','Новое сообщение по заказу №%order_number%','%company_link%\n<p>\nВы получили новое сообщение по заказу %order_messages_link%:\n</p>\n<p>\n%message%\n</p>','','','ru'),(31,'modules/XC/VendorMessages/new_message_notification','Новое сообщение (модуль Order messages)','Это уведомление будет отправлено покупателю, когда в разговоре появится новое сообщение','Новое сообщение в разговоре','%company_link%\n<p>\nВы получили новое сообщение в %conversation_link%:\n</p>\n<p>\n%message%\n</p>','','','ru'),(32,'modules/XC/CanadaPost/return_approved','Return request approved (Canada Post module)','This notification is sent to the customer if their request to return a product via Canada Post is approved by the administrator.','Your return request has been approved','Your return request has been approved','','','en'),(33,'modules/XC/CanadaPost/return_approved','Запрос на возврат товара одобрен (модуль Canada Post)','Данное сообщение отправляется покупателю в случае, если его запрос на возврат товара с пересылкой службой Canada Post получает одобрение администратора.','Ваш запрос на возврат товара одобрен','Ваш запрос на возврат товара одобрен','','','ru'),(34,'modules/XC/CanadaPost/return_rejected','Return request rejected (Canada Post module)','This notification is sent to the customer if their request to return a product via Canada Post is rejected by the administrator.','Your return request has been rejected','Your return request has been rejected','','','en'),(35,'modules/XC/CanadaPost/return_rejected','Запрос на возврат товара отклонен (модуль Canada Post)','Данное сообщение отправляется покупателю в случае, если его запрос на возврат товара с пересылкой службой Canada Post отклоняется администратором.','Ваш запрос на возврат товара отклонен','Ваш запрос на возврат товара отклонен','','','ru');
CREATE TABLE `xlite_sales_tax_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_F11466F5BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_sales_taxes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_content_images` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `width` int(11) NOT NULL,
  `height` int(11) NOT NULL,
  `hash` char(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `needProcess` tinyint(1) NOT NULL,
  `path` varchar(512) COLLATE utf8_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_order_item_attribute_values` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `item_id` int(11) DEFAULT NULL,
  `attribute_value_checkbox_id` int(10) unsigned DEFAULT NULL,
  `attribute_value_select_id` int(10) unsigned DEFAULT NULL,
  `attribute_value_text_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `value` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `attributeId` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_46E30CEA126F525E` (`item_id`),
  KEY `IDX_46E30CEA571B5A02` (`attribute_value_checkbox_id`),
  KEY `IDX_46E30CEAA16D6CC9` (`attribute_value_select_id`),
  KEY `IDX_46E30CEA27A31B4D` (`attribute_value_text_id`),
  CONSTRAINT `FK_46E30CEA27A31B4D` FOREIGN KEY (`attribute_value_text_id`) REFERENCES `xlite_attribute_values_text` (`id`) ON DELETE SET NULL,
  CONSTRAINT `FK_46E30CEA126F525E` FOREIGN KEY (`item_id`) REFERENCES `xlite_order_items` (`item_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_46E30CEA571B5A02` FOREIGN KEY (`attribute_value_checkbox_id`) REFERENCES `xlite_attribute_values_checkbox` (`id`) ON DELETE SET NULL,
  CONSTRAINT `FK_46E30CEAA16D6CC9` FOREIGN KEY (`attribute_value_select_id`) REFERENCES `xlite_attribute_values_select` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_order_capost_parcel_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `amount` int(11) NOT NULL,
  `parcelId` int(11) DEFAULT NULL,
  `orderItemId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_18699C805A9ACC87` (`parcelId`),
  KEY `IDX_18699C80BBF22A26` (`orderItemId`),
  CONSTRAINT `FK_18699C80BBF22A26` FOREIGN KEY (`orderItemId`) REFERENCES `xlite_order_items` (`item_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_18699C805A9ACC87` FOREIGN KEY (`parcelId`) REFERENCES `xlite_order_capost_parcels` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_order_shipping_status_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `customerName` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_53DEE45BBF396750` FOREIGN KEY (`id`) REFERENCES `xlite_order_shipping_statuses` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_order_shipping_status_translations` VALUES (1,1,'New','New','en'),(2,2,'Processing','Processing','en'),(3,3,'Shipped','Shipped','en'),(4,4,'Delivered','Delivered','en'),(5,5,'Will Not Deliver','Will Not Deliver','en'),(6,6,'Returned','Returned','en'),(7,7,'Waiting for approve','Waiting for approve','en'),(8,8,'Not Finished','Not finished','en'),(9,8,'Не завершен','Не завершен','ru');
CREATE TABLE `xlite_membership_coupons` (
  `coupon_id` int(10) unsigned NOT NULL,
  `membership_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`coupon_id`,`membership_id`),
  KEY `IDX_560DE2166C5951B` (`coupon_id`),
  KEY `IDX_560DE211FB354CD` (`membership_id`),
  CONSTRAINT `FK_560DE211FB354CD` FOREIGN KEY (`membership_id`) REFERENCES `xlite_memberships` (`membership_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_560DE2166C5951B` FOREIGN KEY (`coupon_id`) REFERENCES `xlite_coupons` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_images_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `model` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `moduleName` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `width` int(11) NOT NULL,
  `height` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code_model_module` (`code`,`model`,`moduleName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_images_settings` VALUES (1,'Default','XLite\\Model\\Image\\Product\\Image','default',300,300),(2,'LGThumbnailList','XLite\\Model\\Image\\Product\\Image','default',160,160),(3,'LGThumbnailGrid','XLite\\Model\\Image\\Product\\Image','default',160,160),(4,'Default','XLite\\Model\\Image\\Category\\Image','default',160,160),(5,'Default','XLite\\Model\\Image\\Category\\Image','XC\\CrispWhiteSkin',100,120),(6,'LGThumbnailGrid','XLite\\Model\\Image\\Product\\Image','XC\\CrispWhiteSkin',262,280),(7,'LGThumbnailList','XLite\\Model\\Image\\Product\\Image','XC\\CrispWhiteSkin',262,280),(8,'Default','XLite\\Model\\Image\\Product\\Image','XC\\CrispWhiteSkin',366,440);
CREATE TABLE `xlite_product_classes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `position` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_product_classes` VALUES (1,0),(2,0);
CREATE TABLE `xlite_permission_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `IDX_98B75E86BF396750` (`id`),
  CONSTRAINT `FK_98B75E86BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_permission_translations` VALUES (1,1,'Root access','','en'),(2,2,'Manage catalog','','en'),(3,3,'Manage users','','en'),(4,4,'Manage administrators','','en'),(5,5,'Manage orders','','en'),(6,6,'Manage import','','en'),(7,7,'Manage export','','en'),(8,8,'Manage banners','','en'),(9,9,'Allow unfiltered HTML','','en'),(10,10,'Manage coupons','','en'),(11,10,'Управление купонами','','ru'),(12,11,'Manage custom pages','','en'),(13,12,'Manage menus','','en'),(14,13,'Manage volume discounts','','en'),(15,13,'Управление скидками','','ru'),(16,14,'Manage reviews','','en'),(17,14,'Управление отзывами','','ru'),(18,15,'Manage news','','en'),(19,15,'Управление новостями','','ru'),(20,16,'Manage conversations','','en'),(21,16,'Управление разговорами','','ru');
CREATE TABLE `xlite_conversations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_845131BB8D9F6D38` (`order_id`),
  CONSTRAINT `FK_845131BB8D9F6D38` FOREIGN KEY (`order_id`) REFERENCES `xlite_orders` (`order_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_attribute_values_checkbox` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned DEFAULT NULL,
  `attribute_id` int(10) unsigned DEFAULT NULL,
  `value` tinyint(1) NOT NULL,
  `priceModifier` decimal(14,4) NOT NULL,
  `priceModifierType` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `weightModifier` decimal(14,4) NOT NULL,
  `weightModifierType` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `defaultValue` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`),
  KEY `attribute_id` (`attribute_id`),
  KEY `value` (`value`),
  CONSTRAINT `FK_3CA3503BB6E62EFA` FOREIGN KEY (`attribute_id`) REFERENCES `xlite_attributes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_3CA3503B4584665A` FOREIGN KEY (`product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_attribute_values_checkbox` VALUES (1,16,62,0,0.0000,'a',0.0000,'a',0),(2,16,63,1,19.9900,'a',0.0000,'a',0),(3,16,64,0,0.0000,'a',0.0000,'a',0),(4,16,65,0,0.0000,'a',0.0000,'a',0),(5,16,62,1,19.9900,'a',0.0000,'a',0),(7,16,64,1,19.9900,'a',0.0000,'a',0),(8,16,65,1,19.9900,'a',0.0000,'a',0),(9,31,66,1,0.0000,'a',0.0000,'a',0),(10,31,66,0,0.0000,'a',0.0000,'a',0),(11,31,67,1,0.0000,'a',0.0000,'a',0),(12,31,67,0,0.0000,'a',0.0000,'a',0),(13,31,68,1,0.0000,'a',0.0000,'a',0),(14,31,68,0,0.0000,'a',0.0000,'a',0),(15,42,86,1,0.0000,'p',0.0000,'p',0),(18,37,86,1,0.0000,'p',0.0000,'p',0),(19,41,86,1,0.0000,'p',0.0000,'p',0),(20,16,63,0,0.0000,'a',0.0000,'a',0);
CREATE TABLE `xlite_mailchimp_store` (
  `id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `list_id` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `main` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_95CF70793DAE168B` (`list_id`),
  CONSTRAINT `FK_95CF70793DAE168B` FOREIGN KEY (`list_id`) REFERENCES `xlite_mailchimp_lists` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_mailchimp_list_group` (
  `id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `list_id` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `title` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_2F783133DAE168B` (`list_id`),
  CONSTRAINT `FK_2F783133DAE168B` FOREIGN KEY (`list_id`) REFERENCES `xlite_mailchimp_lists` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_data_sources` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_shipping_method_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `deliveryTime` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `IDX_674AA5A0BF396750` (`id`),
  CONSTRAINT `FK_674AA5A0BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_shipping_methods` (`method_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_shipping_method_translations` VALUES (1,1,'FedEx','','en'),(2,2,'FedEx Europe First International Priority','','en'),(3,3,'FedEx 1Day<sup>&reg;</sup> Freight','','en'),(4,4,'FedEx 2Day<sup>&reg;</sup>','','en'),(5,5,'FedEx 2Day AM<sup>&reg;</sup>','','en'),(6,6,'FedEx 2Day<sup>&reg;</sup> Freight','','en'),(7,7,'FedEx 3Day<sup>&reg;</sup> Freight','','en'),(8,8,'FedEx Express Saver<sup>&reg;</sup>','','en'),(9,9,'FedEx First Freight<sup>&reg;</sup>','','en'),(10,10,'FedEx Ground<sup>&reg;</sup>','','en'),(11,11,'FedEx First Overnight<sup>&reg;</sup>','','en'),(12,12,'FedEx Home Delivery<sup>&reg;</sup>','','en'),(13,13,'FedEx International Distribution<sup>&reg;</sup> Freight','','en'),(14,14,'FedEx International Economy<sup>&reg;</sup>','','en'),(15,15,'FedEx International Economy Distribution<sup>&reg;</sup>','','en'),(16,16,'FedEx International Economy<sup>&reg;</sup> Freight','','en'),(17,17,'FedEx International First<sup>&reg;</sup>','','en'),(18,18,'FedEx International Priority<sup>&reg;</sup>','','en'),(19,19,'FedEx International Priority<sup>&reg;</sup> Distribution','','en'),(20,20,'FedEx International Priority Freight<sup>&reg;</sup>','','en'),(21,21,'FedEx Priority Overnight<sup>&reg;</sup>','','en'),(22,22,'FedEx SmartPost<sup>&reg;</sup>/FedEx SmartPost<sup>&reg;</sup> International','','en'),(23,23,'FedEx Standard Overnight<sup>&reg;</sup>','','en'),(24,24,'UPS','','en'),(25,25,'UPS Next Day Air&reg;','','en'),(26,26,'UPS 2nd Day Air&reg;','','en'),(27,27,'UPS Ground','','en'),(28,28,'UPS Worldwide Express','','en'),(29,29,'UPS Worldwide Expedited','','en'),(30,30,'UPS Standard','','en'),(31,31,'UPS 3 Day Select&reg;','','en'),(32,32,'UPS Next Day Air Saver&reg;','','en'),(33,33,'UPS Next Day Air&reg; Early A.M.','','en'),(34,34,'UPS Worldwide Express Plus','','en'),(35,35,'UPS 2nd Day Air A.M.&reg;','','en'),(36,36,'UPS Saver','','en'),(37,37,'UPS Today StandardSM','','en'),(38,38,'UPS Today Dedicated CourrierSM','','en'),(39,39,'UPS Today Intercity','','en'),(40,40,'UPS Today Express','','en'),(41,41,'UPS Today Express Saver','','en'),(42,42,'UPS WorldWide Express Freight','','en'),(43,43,'UPS Express','','en'),(44,44,'UPS Express Plus','','en'),(45,45,'UPS ExpeditedSM','','en'),(46,46,'UPS Worldwide ExpeditedSM','','en'),(47,47,'UPS Worldwide ExpressSM','','en'),(48,48,'UPS SaverSM','','en'),(49,49,'UPS Express Early A.M. SM','','en'),(50,50,'UPS Next Day Air&reg; Early A.M. SM','','en'),(51,51,'UPS Worldwide Express PlusSM','','en'),(52,52,'AustraliaPost','','en'),(53,53,'U.S.P.S','','en'),(54,54,'U.S.P.S. First Class Mail','','en'),(55,55,'U.S.P.S. Priority Mail','','en'),(56,56,'U.S.P.S. Priority Mail Express','','en'),(57,57,'U.S.P.S. Standard Post','','en'),(58,58,'U.S.P.S. Parcel Select','','en'),(59,59,'U.S.P.S. Media Mail','','en'),(60,60,'U.S.P.S. Library Mail','','en'),(61,61,'U.S.P.S. First Class International','','en'),(62,62,'U.S.P.S. First Class Package International Service','','en'),(63,63,'U.S.P.S. Priority Mail Express International','','en'),(64,64,'U.S.P.S. Priority Mail International','','en'),(65,65,'CanadaPost','','en'),(66,66,'Regular Parcel','','en'),(67,67,'Expedited Parcel','','en'),(68,68,'Xpresspost','','en'),(69,69,'Xpresspost Certified','','en'),(70,70,'Priority','','en'),(71,71,'Library Books','','en'),(72,72,'Expedited Parcel USA','','en'),(73,73,'Priority Worldwide Envelope USA','','en'),(74,74,'Priority Worldwide pak USA','','en'),(75,75,'Priority Worldwide Parcel USA','','en'),(76,76,'Small Packet USA Air','','en'),(77,77,'Tracked Packet – USA','','en'),(78,78,'Tracked Packet – USA (LVM)','','en'),(79,79,'Xpresspost USA','','en'),(80,80,'Xpresspost International','','en'),(81,81,'International Parcel Air','','en'),(82,82,'International Parcel Surface','','en'),(83,83,'Priority Worldwide Envelope International','','en'),(84,84,'Priority Worldwide pak International','','en'),(85,85,'Priority Worldwide parcel International','','en'),(86,86,'Small Packet International Air','','en'),(87,87,'Small Packet International Surface','','en'),(88,88,'Tracked Packet – International','','en'),(89,89,'Courier','2 - 4 days','en'),(90,89,'Доставка курьером','2 - 4 дня','ru'),(91,90,'Local shipping','up to one week','en'),(92,90,'Местная доставка','до одной недели','ru'),(93,91,'One day shipping','1 day','en'),(94,91,'Экспресс доставка','1 день','ru'),(95,92,'Local pickup','','en'),(96,92,'Самовывоз','','ru'),(97,93,'Free shipping on orders over $50','','en'),(98,93,'Бесплатная доставка при заказе от $50','','ru'),(99,94,'Free shipping','5 - 7 days','en'),(100,94,'Бесплатная доставка','5 - 7 дней','ru'),(101,95,'Fixed rate shipping','5 - 7 days','en'),(102,95,'Фиксированная стоимость доставки','5 - 7 дней','ru');
CREATE TABLE `xlite_product_attachment_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `title` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_C05C8533BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_product_attachments` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_access_control_zones` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cell_id` int(10) unsigned DEFAULT NULL,
  `type_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cz` (`cell_id`,`type_id`),
  KEY `IDX_19AE0547CB39D93A` (`cell_id`),
  KEY `IDX_19AE0547C54C8C93` (`type_id`),
  CONSTRAINT `FK_19AE0547C54C8C93` FOREIGN KEY (`type_id`) REFERENCES `xlite_access_control_zone_types` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_19AE0547CB39D93A` FOREIGN KEY (`cell_id`) REFERENCES `xlite_access_control_cells` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_country_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` char(2) COLLATE utf8_unicode_ci DEFAULT NULL,
  `country` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `country` (`country`),
  KEY `id` (`id`),
  CONSTRAINT `FK_758727C3BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_countries` (`code`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_country_translations` VALUES (1,'AF','Afghanistan','en'),(2,'AX','Åland Islands','en'),(3,'AL','Albania','en'),(4,'DZ','Algeria','en'),(5,'AS','American Samoa','en'),(6,'AD','Andorra','en'),(7,'AO','Angola','en'),(8,'AI','Anguilla','en'),(9,'AQ','Antarctica','en'),(10,'AG','Antigua and Barbuda','en'),(11,'AR','Argentina','en'),(12,'AM','Armenia','en'),(13,'AW','Aruba','en'),(14,'AU','Australia','en'),(15,'AT','Austria','en'),(16,'AZ','Azerbaijan','en'),(17,'BS','Bahamas','en'),(18,'BH','Bahrain','en'),(19,'BD','Bangladesh','en'),(20,'BB','Barbados','en'),(21,'BY','Belarus','en'),(22,'BE','Belgium','en'),(23,'BZ','Belize','en'),(24,'BJ','Benin','en'),(25,'BM','Bermuda','en'),(26,'BT','Bhutan','en'),(27,'BO','Bolivia, Plurinational State of','en'),(28,'BQ','Bonaire, Sint Eustatius and Saba','en'),(29,'BA','Bosnia and Herzegowina','en'),(30,'BW','Botswana','en'),(31,'BV','Bouvet Island','en'),(32,'BR','Brazil','en'),(33,'IO','British Indian Ocean Territory','en'),(34,'BN','Brunei Darussalam','en'),(35,'BG','Bulgaria','en'),(36,'BF','Burkina Faso','en'),(37,'BI','Burundi','en'),(38,'KH','Cambodia','en'),(39,'CM','Cameroon','en'),(40,'CA','Canada','en'),(41,'CV','Cape Verde','en'),(42,'KY','Cayman Islands','en'),(43,'CF','Central African Republic','en'),(44,'TD','Chad','en'),(45,'CL','Chile','en'),(46,'CN','China','en'),(47,'CX','Christmas Island','en'),(48,'CC','Cocos (Keeling) Islands','en'),(49,'CO','Colombia','en'),(50,'KM','Comoros','en'),(51,'CG','Congo','en'),(52,'CD','Congo, the Democratic Republic of the','en'),(53,'CK','Cook Islands','en'),(54,'CR','Costa Rica','en'),(55,'CI','Côte d\'Ivoire','en'),(56,'HR','Croatia','en'),(57,'CU','Cuba','en'),(58,'CW','Curaçao','en'),(59,'CY','Cyprus','en'),(60,'CZ','Czech Republic','en'),(61,'DK','Denmark','en'),(62,'DJ','Djibouti','en'),(63,'DM','Dominica','en'),(64,'DO','Dominican Republic','en'),(65,'EC','Ecuador','en'),(66,'EG','Egypt','en'),(67,'SV','El Salvador','en'),(68,'GQ','Equatorial Guinea','en'),(69,'ER','Eritrea','en'),(70,'EE','Estonia','en'),(71,'ET','Ethiopia','en'),(72,'FK','Falkland Islands (Malvinas)','en'),(73,'FO','Faroe Islands','en'),(74,'FJ','Fiji','en'),(75,'FI','Finland','en'),(76,'FR','France','en'),(77,'GF','French Guiana','en'),(78,'PF','French Polynesia','en'),(79,'TF','French Southern Territories','en'),(80,'GA','Gabon','en'),(81,'GM','Gambia','en'),(82,'GE','Georgia','en'),(83,'DE','Germany','en'),(84,'GH','Ghana','en'),(85,'GI','Gibraltar','en'),(86,'GR','Greece','en'),(87,'GL','Greenland','en'),(88,'GD','Grenada','en'),(89,'GP','Guadeloupe','en'),(90,'GU','Guam','en'),(91,'GT','Guatemala','en'),(92,'GG','Guernsey','en'),(93,'GN','Guinea','en'),(94,'GW','Guinea-Bissau','en'),(95,'GY','Guyana','en'),(96,'HT','Haiti','en'),(97,'HM','Heard and McDonald Islands','en'),(98,'VA','Holy See (Vatican City State)','en'),(99,'HN','Honduras','en'),(100,'HK','Hong Kong','en'),(101,'HU','Hungary','en'),(102,'IS','Iceland','en'),(103,'IN','India','en'),(104,'ID','Indonesia','en'),(105,'IR','Iran, Islamic Republic of','en'),(106,'IQ','Iraq','en'),(107,'IE','Ireland','en'),(108,'IM','Isle of Man','en'),(109,'IL','Israel','en'),(110,'IT','Italy','en'),(111,'JM','Jamaica','en'),(112,'JP','Japan','en'),(113,'JE','Jersey','en'),(114,'JO','Jordan','en'),(115,'KZ','Kazakhstan','en'),(116,'KE','Kenya','en'),(117,'KI','Kiribati','en'),(118,'KP','Korea, Democratic People\'s Republic of','en'),(119,'KR','Korea, Republic of','en'),(120,'KW','Kuwait','en'),(121,'KG','Kyrgyzstan','en'),(122,'LA','Lao People\'s Democratic Republic','en'),(123,'LV','Latvia','en'),(124,'LB','Lebanon','en'),(125,'LS','Lesotho','en'),(126,'LR','Liberia','en'),(127,'LY','Libya','en'),(128,'LI','Liechtenstein','en'),(129,'LT','Lithuania','en'),(130,'LU','Luxembourg','en'),(131,'MO','Macao','en'),(132,'MK','Macedonia','en'),(133,'MG','Madagascar','en'),(134,'MW','Malawi','en'),(135,'MY','Malaysia','en'),(136,'MV','Maldives','en'),(137,'ML','Mali','en'),(138,'MT','Malta','en'),(139,'MH','Marshall Islands','en'),(140,'MQ','Martinique','en'),(141,'MR','Mauritania','en'),(142,'MU','Mauritius','en'),(143,'YT','Mayotte','en'),(144,'MX','Mexico','en'),(145,'FM','Micronesia, Federated States of','en'),(146,'MD','Moldova, Republic of','en'),(147,'MC','Monaco','en'),(148,'MN','Mongolia','en'),(149,'ME','Montenegro','en'),(150,'MS','Montserrat','en'),(151,'MA','Morocco','en'),(152,'MZ','Mozambique','en'),(153,'MM','Myanmar','en'),(154,'NA','Namibia','en'),(155,'NR','Nauru','en'),(156,'NP','Nepal','en'),(157,'NL','Netherlands','en'),(158,'NC','New Caledonia','en'),(159,'NZ','New Zealand','en'),(160,'NI','Nicaragua','en'),(161,'NE','Niger','en'),(162,'NG','Nigeria','en'),(163,'NU','Niue','en'),(164,'NF','Norfolk Island','en'),(165,'MP','Northern Mariana Islands','en'),(166,'NO','Norway','en'),(167,'OM','Oman','en'),(168,'PK','Pakistan','en'),(169,'PW','Palau','en'),(170,'PS','Palestinian Territory, Occupied','en'),(171,'PA','Panama','en'),(172,'PG','Papua New Guinea','en'),(173,'PY','Paraguay','en'),(174,'PE','Peru','en'),(175,'PH','Philippines','en'),(176,'PN','Pitcairn','en'),(177,'PL','Poland','en'),(178,'PT','Portugal','en'),(179,'PR','Puerto Rico','en'),(180,'QA','Qatar','en'),(181,'RE','Réunion','en'),(182,'RO','Romania','en'),(183,'RU','Russian Federation','en'),(184,'RW','Rwanda','en'),(185,'BL','Saint Barthélemy','en'),(186,'SH','Saint Helena, Ascension and Tristan da Cunha','en'),(187,'KN','Saint Kitts and Nevis','en'),(188,'LC','Saint Lucia','en'),(189,'MF','Saint Martin','en'),(190,'PM','Saint Pierre and Miquelon','en'),(191,'VC','Saint Vincent and the Grenadines','en'),(192,'WS','Samoa','en'),(193,'SM','San Marino','en'),(194,'ST','Sao Tome and Principe','en'),(195,'SA','Saudi Arabia','en'),(196,'SN','Senegal','en'),(197,'RS','Serbia','en'),(198,'SC','Seychelles','en'),(199,'SL','Sierra Leone','en'),(200,'SG','Singapore','en'),(201,'SX','Sint Maarten','en'),(202,'SK','Slovakia','en'),(203,'SI','Slovenia','en'),(204,'SB','Solomon Islands','en'),(205,'SO','Somalia','en'),(206,'ZA','South Africa','en'),(207,'GS','South Georgia and the South Sandwich Islands','en'),(208,'SS','South Sudan','en'),(209,'ES','Spain','en'),(210,'LK','Sri Lanka','en'),(211,'SD','Sudan','en'),(212,'SR','Suriname','en'),(213,'SJ','Svalbard and Jan Mayen','en'),(214,'SZ','Swaziland','en'),(215,'SE','Sweden','en'),(216,'CH','Switzerland','en'),(217,'SY','Syrian Arab Republic','en'),(218,'TW','Taiwan, Province of China','en'),(219,'TJ','Tajikistan','en'),(220,'TZ','Tanzania, United Republic of','en'),(221,'TH','Thailand','en'),(222,'TL','Timor-Leste','en'),(223,'TG','Togo','en'),(224,'TK','Tokelau','en'),(225,'TO','Tonga','en'),(226,'TT','Trinidad and Tobago','en'),(227,'TN','Tunisia','en'),(228,'TR','Turkey','en'),(229,'TM','Turkmenistan','en'),(230,'TC','Turks and Caicos Islands','en'),(231,'TV','Tuvalu','en'),(232,'UG','Uganda','en'),(233,'UA','Ukraine','en'),(234,'AE','United Arab Emirates','en'),(235,'GB','United Kingdom','en'),(236,'US','United States','en'),(237,'UM','United States Minor Outlying Islands','en'),(238,'UY','Uruguay','en'),(239,'UZ','Uzbekistan','en'),(240,'VU','Vanuatu','en'),(241,'VE','Venezuela, Bolivarian Republic of','en'),(242,'VN','Viet Nam','en'),(243,'VG','Virgin Islands, British','en'),(244,'VI','Virgin Islands, U.S.','en'),(245,'WF','Wallis And Futuna Islands','en'),(246,'EH','Western Sahara','en'),(247,'YE','Yemen','en'),(248,'ZM','Zambia','en'),(249,'ZW','Zimbabwe','en');
CREATE TABLE `xlite_category_class_links` (
  `category_id` int(10) unsigned NOT NULL,
  `class_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`category_id`,`class_id`),
  KEY `IDX_3F5DB31312469DE2` (`category_id`),
  KEY `IDX_3F5DB313EA000B10` (`class_id`),
  CONSTRAINT `FK_3F5DB313EA000B10` FOREIGN KEY (`class_id`) REFERENCES `xlite_product_classes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_3F5DB31312469DE2` FOREIGN KEY (`category_id`) REFERENCES `xlite_categories` (`category_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_role_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `role_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `IDX_94D50124FED90CCA` (`permission_id`),
  KEY `IDX_94D50124D60322AC` (`role_id`),
  CONSTRAINT `FK_94D50124D60322AC` FOREIGN KEY (`role_id`) REFERENCES `xlite_roles` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_94D50124FED90CCA` FOREIGN KEY (`permission_id`) REFERENCES `xlite_permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_role_permissions` VALUES (1,1),(10,2),(11,3),(12,3),(13,4);
COMMIT;