/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

(function () {

  Vue.directive('xliteProductCategory', {
    params: ['searchingLbl', 'noResultsLbl', 'enterTermLbl'],
    twoWay: true,
    bind: function () {
      var self = this;
      var $el = $(this.el);
      var model = this.expression;
      var term = '';

      $el
        .select2(
          {
            debug: true,
            language: {
              noResults: function () {
                return term.length ? self.params.noResultsLbl : self.params.enterTermLbl;
              },
              searching: function () {
                return self.params.searchingLbl;
              }
            },
            escapeMarkup: function (markup) { return markup; },
            templateResult: function (repo) {
              var term = $('.select2-search__field', $el.parent()).val();

              return repo.loading
                ? htmlspecialchars(repo.text)
                : htmlspecialchars(repo.text).replace(new RegExp('('+term+')([^/]*)$', 'i'), '<em>$1</em>$2');
            },
            templateSelection: function (selection) {
              return '<span class="select2-selection-text">' + htmlspecialchars(selection.text) + '</span>';
            },
            matcher: function (params, match) {
              if (params.term == null || $.trim(params.term) === '') {
                return match;
              }

              var re = new RegExp('('+params.term+')([^/]*)$', 'i');
              if (re.test(match.text)) {
                return match;
              }

              return null;
            }
          }
        )
        .on('select2:select', _.bind(function (e) {
          var $el = $(this.el);
          this.vm.$set(model, $el.val() || []);
        }, this))
        .on('select2:unselect', _.bind(function (e) {
          var $el = $(this.el);
          this.vm.$set(model, $el.val() || []);
        }, this));

      this.vm.$watch(this.expression, function (newValue, oldValue) {
        self.vm.$set('form.default.category_tree', newValue);
      });

      this.vm.$watch('form.default.category_tree', function (newValue, oldValue) {
        self.vm.$set(self.expression, newValue);
      });

      jQuery(this.el).select2Sortable(function() {
        var ul = $el.next('.select2-container')
          .first('ul.select2-selection__rendered');

        var reservedChoices = jQuery(ul).find('.select2-selection__choice').get().reverse();

        jQuery(reservedChoices).each(function() {
          var id = $(this).data('data').id;
          var option = $this.find('option[value="' + id + '"]')[0];
          $this.prepend(option);
        });

        self.vm.$set('form.default.category_tree', $el.val());
      });

      setTimeout(function () {
        $el.closest('.input-widget').find('span.help-block a').click(function () {
          self.vm.$set('form.default.category_widget_type', 'tree');
          jQuery.cookie('product_modify_categroy_widget', 'tree');
        });

        $('#form_default_category_tree').attr('name', '').closest('.input-widget').find('span.help-block a').click(function () {
          self.vm.$set('form.default.category_widget_type', 'search');
          jQuery.cookie('product_modify_categroy_widget', 'search');
        });
      }, 1000);
    },
    update: function (newValue, oldValue) {
      if (newValue.filter(function (value) { return value.length }).length === 0) {
        return;
      }

      var $el = $(this.el);

      $el.val(newValue);
      $el.trigger('change');
    }
  });

})();
