<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\Model\Repo;

/**
 * Tax classes repository
 *
 * @Api\Operation\Create(modelClass="XLite\Model\TaxClass", summary="Add new tax class")
 * @Api\Operation\Read(modelClass="XLite\Model\TaxClass", summary="Retrieve tax class by id")
 * @Api\Operation\ReadAll(modelClass="XLite\Model\TaxClass", summary="Retrieve tax classes by conditions")
 * @Api\Operation\Update(modelClass="XLite\Model\TaxClass", summary="Update tax class by id")
 * @Api\Operation\Delete(modelClass="XLite\Model\TaxClass", summary="Delete tax class by id")
 */
class TaxClass extends \XLite\Model\Repo\Base\I18n
{
    /**
     * Allowable search params
     */
    const CND_PRODUCT = 'product';

    /**
     * Default 'order by' field name
     *
     * @var string
     */
    protected $defaultOrderBy = 'position';

    /**
     * Prepare certain search condition
     *
     * @param \Doctrine\ORM\QueryBuilder $queryBuilder Query builder to prepare
     * @param mixed                      $value        Condition OPTIONAL
     *
     * @return void
     */
    protected function prepareCndProduct(\Doctrine\ORM\QueryBuilder $queryBuilder, $value = null)
    {
        if ($value && !is_object($value)) {
            $ids = array();
            foreach ($value as $id) {
                if ($id) {
                    $ids[] = is_object($id) ? $id->getId() : $id;
                }
            }

            if ($ids) {
                $queryBuilder->linkInner('p.products')
                    ->andWhere($queryBuilder->expr()->in('products.product_id', $ids));
            }
        }
    }

    // }}}

    // {{{ Find one by name

    /**
     * Find entity by name (any language)
     *
     * @param string  $name      Name
     * @param boolean $countOnly Count only OPTIONAL
     *
     * @return \XLite\Model\TaxClass|integer
     */
    public function findOneByName($name, $countOnly = false)
    {
        return $countOnly
            ? count($this->defineOneByNameQuery($name)->getResult())
            : $this->defineOneByNameQuery($name)->getSingleResult();
    }

    /**
     * Define query builder for findOneByName() method
     *
     * @param string $name Name
     *
     * @return \Doctrine\ORM\QueryBuilder
     */
    protected function defineOneByNameQuery($name)
    {
        $qb = $this->createQueryBuilder()
            ->andWhere('translations.name = :name')
            ->setParameter('name', $name);

        return $qb;
    }

    // }}}
}
