<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\View\Upgrade\Step\Completed;

/**
 * UpgradeNotes
 */
class UpgradeNotes extends \XLite\View\Upgrade\Step\Completed\ACompleted
{
    /**
     * Upgrade notes
     *
     * @var array
     */
    protected $upgradeNotes = null;

    /**
     * Register CSS files
     *
     * @return array
     */
    public function getCSSFiles()
    {
        $list = parent::getCSSFiles();
        $list[] = $this->getDir() . '/css/style.css';

        return $list;
    }

    /**
     * Get directory where template is located (body.twig)
     *
     * @return string
     */
    protected function getDir()
    {
        return parent::getDir() . '/upgrade_notes';
    }

    /**
     * Return internal list name
     *
     * @return string
     */
    protected function getListName()
    {
        return parent::getListName() . '.upgrade_notes';
    }

    /**
     * Check widget visibility
     *
     * @return boolean
     */
    protected function isVisible()
    {
        return parent::isVisible() && (bool) $this->getUpgradeNotes();
    }

    /**
     * Return list of files
     *
     * @return array
     */
    protected function getUpgradeNotes()
    {
        if (!isset($this->upgradeNotes)) {
            /** @var \XLite\Upgrade\Entry\AEntry $entry */
            foreach ($this->getUpgradeEntries() as $entry) {
                $notes = $entry->getUpgradeNotes('post_upgrade');

                if ($notes) {
                    $this->upgradeNotes[$entry->getName()] = $notes;
                }
            };
        }

        return $this->upgradeNotes;
    }
}
