<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\Module\CDev\ProductAdvisor\View\ItemsList\Product\Customer;

/**
 * Products items list extension
 */
abstract class ACustomer extends \XLite\Module\QSL\CloudSearch\View\ItemsList\Product\Customer\ACustomerNextPrevious implements \XLite\Base\IDecorator
{
    /**
     * Allowed sort criteria
     */
    const SORT_BY_MODE_DATE  = 'p.arrivalDate';

    /**
     * Define and set widget attributes; initialize widget
     *
     * @param array $params Widget params OPTIONAL
     *
     * @return void
     */
    public function __construct(array $params = array())
    {
        parent::__construct($params);

        $this->sortByModes = array(
            static::SORT_BY_MODE_DATE => 'Newest first',
        ) + $this->sortByModes;
    }

    /**
     * Get products 'sort by' fields
     *
     * @return array
     */
    protected function getSortByFields()
    {
        return array(
            'newest' => static::SORT_BY_MODE_DATE,
        ) + parent::getSortByFields();
    }

    /**
     * Register CSS files
     *
     * @return array
     */
    public function getCSSFiles()
    {
        $list = parent::getCSSFiles();
        $list[] = 'modules/CDev/ProductAdvisor/style.css';

        return $list;
    }

    /**
     * Get products single order 'sort by' fields
     * Return in format [sort_by_field => sort_order]
     *
     * @return array
     */
    protected function getSingleOrderSortByFields()
    {
        return parent::getSingleOrderSortByFields() + [
            static::SORT_BY_MODE_DATE => static::SORT_ORDER_DESC
        ];
    }
}
