<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\Module\XC\CanadaPost\View;

/**
 * Invoice widget
 */
abstract class Invoice extends \XLite\Module\XPay\XPaymentsCloud\View\Invoice implements \XLite\Base\IDecorator
{
    /**
     * Register files from common repository
     *
     * @return array
     */
    public function getCommonFiles()
    {
        $list = parent::getCommonFiles();
        $list[static::RESOURCE_JS][] = 'js/core.popup.js';

        return $list;
    }

    /**
     * Get a list of JS files required to display the widget properly
     *
     * @return array
     */
    public function getJSFiles()
    {
        $list = parent::getJSFiles();
        $list[] = 'modules/XC/CanadaPost/js/tracking_controller.js';

        return $list;
    }

    /**
     * Register CSS files
     *
     * @return array
     */
    public function getCSSFiles()
    {
        $list = parent::getCSSFiles();
        $list[] = 'modules/XC/CanadaPost/order/invoice/parts/bottom.d2po.css';

        return $list;
    }

    /**
     * Get selected Canada Post post office 
     *
     * @return \XLite\Module\XC\CanadaPost\Model\Order\PostOffice|null
     */
    protected function getCapostOffice()
    {
        return $this->getOrder()->getCapostOffice();

    }
}
