START TRANSACTION;
/*!40101 SET NAMES utf8, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET UNIQUE_CHECKS=0, FOREIGN_KEY_CHECKS=0 */;
/*!40111 SET SQL_NOTES=0 */;
CREATE TABLE `xlite_order_capost_parcel_manifests` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `poNumber` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rel` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `href` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `idx` int(11) DEFAULT NULL,
  `mediaType` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_order_item_private_attachments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `item_id` int(11) DEFAULT NULL,
  `attachment_id` int(10) unsigned DEFAULT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `downloadKey` char(128) COLLATE utf8_unicode_ci NOT NULL,
  `expire` int(10) unsigned NOT NULL,
  `attempt` int(10) unsigned NOT NULL,
  `attemptLimit` int(10) unsigned NOT NULL,
  `blocked` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_BC5B98F1126F525E` (`item_id`),
  KEY `IDX_BC5B98F1464E68B` (`attachment_id`),
  CONSTRAINT `FK_BC5B98F1126F525E` FOREIGN KEY (`item_id`) REFERENCES `xlite_order_items` (`item_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_BC5B98F1464E68B` FOREIGN KEY (`attachment_id`) REFERENCES `xlite_product_attachments` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_country_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` char(2) COLLATE utf8_unicode_ci DEFAULT NULL,
  `country` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `country` (`country`),
  KEY `id` (`id`),
  CONSTRAINT `FK_758727C3BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_countries` (`code`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_country_translations` VALUES (1,'AF','Afghanistan','en'),(2,'AX','Åland Islands','en'),(3,'AL','Albania','en'),(4,'DZ','Algeria','en'),(5,'AS','American Samoa','en'),(6,'AD','Andorra','en'),(7,'AO','Angola','en'),(8,'AI','Anguilla','en'),(9,'AQ','Antarctica','en'),(10,'AG','Antigua and Barbuda','en'),(11,'AR','Argentina','en'),(12,'AM','Armenia','en'),(13,'AW','Aruba','en'),(14,'AU','Australia','en'),(15,'AT','Austria','en'),(16,'AZ','Azerbaijan','en'),(17,'BS','Bahamas','en'),(18,'BH','Bahrain','en'),(19,'BD','Bangladesh','en'),(20,'BB','Barbados','en'),(21,'BY','Belarus','en'),(22,'BE','Belgium','en'),(23,'BZ','Belize','en'),(24,'BJ','Benin','en'),(25,'BM','Bermuda','en'),(26,'BT','Bhutan','en'),(27,'BO','Bolivia, Plurinational State of','en'),(28,'BQ','Bonaire, Sint Eustatius and Saba','en'),(29,'BA','Bosnia and Herzegowina','en'),(30,'BW','Botswana','en'),(31,'BV','Bouvet Island','en'),(32,'BR','Brazil','en'),(33,'IO','British Indian Ocean Territory','en'),(34,'BN','Brunei Darussalam','en'),(35,'BG','Bulgaria','en'),(36,'BF','Burkina Faso','en'),(37,'BI','Burundi','en'),(38,'KH','Cambodia','en'),(39,'CM','Cameroon','en'),(40,'CA','Canada','en'),(41,'CV','Cape Verde','en'),(42,'KY','Cayman Islands','en'),(43,'CF','Central African Republic','en'),(44,'TD','Chad','en'),(45,'CL','Chile','en'),(46,'CN','China','en'),(47,'CX','Christmas Island','en'),(48,'CC','Cocos (Keeling) Islands','en'),(49,'CO','Colombia','en'),(50,'KM','Comoros','en'),(51,'CG','Congo','en'),(52,'CD','Congo, the Democratic Republic of the','en'),(53,'CK','Cook Islands','en'),(54,'CR','Costa Rica','en'),(55,'CI','Côte d\'Ivoire','en'),(56,'HR','Croatia','en'),(57,'CU','Cuba','en'),(58,'CW','Curaçao','en'),(59,'CY','Cyprus','en'),(60,'CZ','Czech Republic','en'),(61,'DK','Denmark','en'),(62,'DJ','Djibouti','en'),(63,'DM','Dominica','en'),(64,'DO','Dominican Republic','en'),(65,'EC','Ecuador','en'),(66,'EG','Egypt','en'),(67,'SV','El Salvador','en'),(68,'GQ','Equatorial Guinea','en'),(69,'ER','Eritrea','en'),(70,'EE','Estonia','en'),(71,'ET','Ethiopia','en'),(72,'FK','Falkland Islands (Malvinas)','en'),(73,'FO','Faroe Islands','en'),(74,'FJ','Fiji','en'),(75,'FI','Finland','en'),(76,'FR','France','en'),(77,'GF','French Guiana','en'),(78,'PF','French Polynesia','en'),(79,'TF','French Southern Territories','en'),(80,'GA','Gabon','en'),(81,'GM','Gambia','en'),(82,'GE','Georgia','en'),(83,'DE','Germany','en'),(84,'GH','Ghana','en'),(85,'GI','Gibraltar','en'),(86,'GR','Greece','en'),(87,'GL','Greenland','en'),(88,'GD','Grenada','en'),(89,'GP','Guadeloupe','en'),(90,'GU','Guam','en'),(91,'GT','Guatemala','en'),(92,'GG','Guernsey','en'),(93,'GN','Guinea','en'),(94,'GW','Guinea-Bissau','en'),(95,'GY','Guyana','en'),(96,'HT','Haiti','en'),(97,'HM','Heard and McDonald Islands','en'),(98,'VA','Holy See (Vatican City State)','en'),(99,'HN','Honduras','en'),(100,'HK','Hong Kong','en'),(101,'HU','Hungary','en'),(102,'IS','Iceland','en'),(103,'IN','India','en'),(104,'ID','Indonesia','en'),(105,'IR','Iran, Islamic Republic of','en'),(106,'IQ','Iraq','en'),(107,'IE','Ireland','en'),(108,'IM','Isle of Man','en'),(109,'IL','Israel','en'),(110,'IT','Italy','en'),(111,'JM','Jamaica','en'),(112,'JP','Japan','en'),(113,'JE','Jersey','en'),(114,'JO','Jordan','en'),(115,'KZ','Kazakhstan','en'),(116,'KE','Kenya','en'),(117,'KI','Kiribati','en'),(118,'KP','Korea, Democratic People\'s Republic of','en'),(119,'KR','Korea, Republic of','en'),(120,'KW','Kuwait','en'),(121,'KG','Kyrgyzstan','en'),(122,'LA','Lao People\'s Democratic Republic','en'),(123,'LV','Latvia','en'),(124,'LB','Lebanon','en'),(125,'LS','Lesotho','en'),(126,'LR','Liberia','en'),(127,'LY','Libya','en'),(128,'LI','Liechtenstein','en'),(129,'LT','Lithuania','en'),(130,'LU','Luxembourg','en'),(131,'MO','Macao','en'),(132,'MK','North Macedonia','en'),(133,'MG','Madagascar','en'),(134,'MW','Malawi','en'),(135,'MY','Malaysia','en'),(136,'MV','Maldives','en'),(137,'ML','Mali','en'),(138,'MT','Malta','en'),(139,'MH','Marshall Islands','en'),(140,'MQ','Martinique','en'),(141,'MR','Mauritania','en'),(142,'MU','Mauritius','en'),(143,'YT','Mayotte','en'),(144,'MX','Mexico','en'),(145,'FM','Micronesia, Federated States of','en'),(146,'MD','Moldova, Republic of','en'),(147,'MC','Monaco','en'),(148,'MN','Mongolia','en'),(149,'ME','Montenegro','en'),(150,'MS','Montserrat','en'),(151,'MA','Morocco','en'),(152,'MZ','Mozambique','en'),(153,'MM','Myanmar','en'),(154,'NA','Namibia','en'),(155,'NR','Nauru','en'),(156,'NP','Nepal','en'),(157,'NL','Netherlands','en'),(158,'NC','New Caledonia','en'),(159,'NZ','New Zealand','en'),(160,'NI','Nicaragua','en'),(161,'NE','Niger','en'),(162,'NG','Nigeria','en'),(163,'NU','Niue','en'),(164,'NF','Norfolk Island','en'),(165,'MP','Northern Mariana Islands','en'),(166,'NO','Norway','en'),(167,'OM','Oman','en'),(168,'PK','Pakistan','en'),(169,'PW','Palau','en'),(170,'PS','Palestinian Territory, Occupied','en'),(171,'PA','Panama','en'),(172,'PG','Papua New Guinea','en'),(173,'PY','Paraguay','en'),(174,'PE','Peru','en'),(175,'PH','Philippines','en'),(176,'PN','Pitcairn','en'),(177,'PL','Poland','en'),(178,'PT','Portugal','en'),(179,'PR','Puerto Rico','en'),(180,'QA','Qatar','en'),(181,'RE','Réunion','en'),(182,'RO','Romania','en'),(183,'RU','Russian Federation','en'),(184,'RW','Rwanda','en'),(185,'BL','Saint Barthélemy','en'),(186,'SH','Saint Helena, Ascension and Tristan da Cunha','en'),(187,'KN','Saint Kitts and Nevis','en'),(188,'LC','Saint Lucia','en'),(189,'MF','Saint Martin','en'),(190,'PM','Saint Pierre and Miquelon','en'),(191,'VC','Saint Vincent and the Grenadines','en'),(192,'WS','Samoa','en'),(193,'SM','San Marino','en'),(194,'ST','Sao Tome and Principe','en'),(195,'SA','Saudi Arabia','en'),(196,'SN','Senegal','en'),(197,'RS','Serbia','en'),(198,'SC','Seychelles','en'),(199,'SL','Sierra Leone','en'),(200,'SG','Singapore','en'),(201,'SX','Sint Maarten','en'),(202,'SK','Slovakia','en'),(203,'SI','Slovenia','en'),(204,'SB','Solomon Islands','en'),(205,'SO','Somalia','en'),(206,'ZA','South Africa','en'),(207,'GS','South Georgia and the South Sandwich Islands','en'),(208,'SS','South Sudan','en'),(209,'ES','Spain','en'),(210,'LK','Sri Lanka','en'),(211,'SD','Sudan','en'),(212,'SR','Suriname','en'),(213,'SJ','Svalbard and Jan Mayen','en'),(214,'SZ','Swaziland','en'),(215,'SE','Sweden','en'),(216,'CH','Switzerland','en'),(217,'SY','Syrian Arab Republic','en'),(218,'TW','Taiwan, Province of China','en'),(219,'TJ','Tajikistan','en'),(220,'TZ','Tanzania, United Republic of','en'),(221,'TH','Thailand','en'),(222,'TL','Timor-Leste','en'),(223,'TG','Togo','en'),(224,'TK','Tokelau','en'),(225,'TO','Tonga','en'),(226,'TT','Trinidad and Tobago','en'),(227,'TN','Tunisia','en'),(228,'TR','Turkey','en'),(229,'TM','Turkmenistan','en'),(230,'TC','Turks and Caicos Islands','en'),(231,'TV','Tuvalu','en'),(232,'UG','Uganda','en'),(233,'UA','Ukraine','en'),(234,'AE','United Arab Emirates','en'),(235,'GB','United Kingdom','en'),(236,'US','United States','en'),(237,'UM','United States Minor Outlying Islands','en'),(238,'UY','Uruguay','en'),(239,'UZ','Uzbekistan','en'),(240,'VU','Vanuatu','en'),(241,'VE','Venezuela, Bolivarian Republic of','en'),(242,'VN','Viet Nam','en'),(243,'VG','Virgin Islands, British','en'),(244,'VI','Virgin Islands, U.S.','en'),(245,'WF','Wallis And Futuna Islands','en'),(246,'EH','Western Sahara','en'),(247,'YE','Yemen','en'),(248,'ZM','Zambia','en'),(249,'ZW','Zimbabwe','en');
CREATE TABLE `xlite_category_quick_flags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned DEFAULT NULL,
  `subcategories_count_all` int(11) NOT NULL,
  `subcategories_count_enabled` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_5BA9C50312469DE2` (`category_id`),
  CONSTRAINT `FK_5BA9C50312469DE2` FOREIGN KEY (`category_id`) REFERENCES `xlite_categories` (`category_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_category_quick_flags` VALUES (1,1,3,3),(2,2,3,3),(3,3,0,0),(4,4,0,0),(5,5,0,0),(6,6,2,2),(7,7,0,0),(8,8,0,0),(9,9,3,3),(10,10,0,0),(11,11,0,0),(12,12,0,0);
CREATE TABLE `xlite_measure_dumps` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `data` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `text` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_order_shipping_statuses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` char(4) COLLATE utf8_unicode_ci DEFAULT NULL,
  `position` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_F46FC21177153098` (`code`),
  KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_order_shipping_statuses` VALUES (1,'N',10),(2,'P',20),(3,'S',30),(4,'D',40),(5,'WND',50),(6,'R',60),(7,'WFA',70),(8,'NBA',80),(9,'NF',100);
CREATE TABLE `xlite_attribute_values_hidden_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_B6B29289BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_attribute_values_hidden` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_language_label_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(11) DEFAULT NULL,
  `label` longtext COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_D36B6764BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_language_labels` (`label_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_language_label_translations` VALUES (1,1,'%','en'),(2,2,'Most popular','en'),(3,3,'Newest','en'),(4,4,'Alphabetically','en'),(5,5,'Tags','en'),(6,6,'Before editing attributes specific for the chosen type you should save the changes. <br /><br />Changing the type of a product attribute after having defined values for this attribute for some products will result in losing the defined attribute values.','en'),(7,7,'For details refer to <a href=\"{{licenseAgreementURL}}\" target=\"_blank\">X-Cart license agreement</a>.','en'),(8,8,'We are sorry, the Marketplace server is currently unavailable. Your license could not be registered. Please try again later.','en'),(9,9,'<a href=\"{{contactURL}}\" target=\"_blank\">Contact us</a> if you have any questions','en'),(10,10,'Activate your license key','en'),(11,11,'To activate your X-Cart license, enter your secret key into the field below and click Activate.','en'),(12,12,'To activate your X-Cart or commercial module license, enter your license key into the field below and click Activate.','en'),(13,13,'To set up Tax Rates, find and install appropriate add-on modules from the <a href=\"{{url}}\">Marketplace</a>','en'),(14,14,'Simplify tax compilance process and reduce the sales tax audit risk with <a href=\"{{url}}\">AvaTax Sales Tax Automation</a>','en'),(15,15,'Purchase premium license','en'),(16,16,'Activate free license','en'),(17,17,'activate existing key','en'),(18,18,'Enter your license key here','en'),(19,19,'Activate','en'),(20,20,'Need a license key?','en'),(21,21,'You must register your installation before you can use it for real sales. Registration can be accomplished by activating a free license with limited features or by purchasing a premium license.','en'),(22,22,'Removal of this message is allowed only through activation of a free or premium license.','en'),(23,23,'Free Edition has a limited set of features, so all the modules of the Business package will be removed in your store. However, you will be able to <a href=\'{{purchaseURL}}\'>upgrade</a> your Free version to Premium at any time and install addons from the Premium package.<br /><br /><strong>Here\'s a list of modules that are not available under free license. After the activation of a free license key all these modules will be removed from your installation.</strong>','en'),(24,24,'Evaluation notice','en'),(25,25,'Don\'t have an account yet?','en'),(26,26,'Go to checkout as a New customer','en'),(27,27,'Weight','en'),(28,28,'Weight ({{symbol}})','en'),(29,29,'Add to cart','en'),(30,30,'Description','en'),(31,31,'SKU','en'),(32,32,'Previous','en'),(33,33,'Next product','en'),(34,34,'Clear cart','en'),(35,35,'Continue shopping','en'),(36,36,'Submit','en'),(37,37,'Submit','en'),(38,38,'Delivery','en'),(39,39,'(!) This product is out of stock or not available','en'),(40,40,'Update','en'),(41,41,'Grand total','en'),(42,42,'Shipping cost','en'),(43,43,'Free','en'),(44,44,'Subtotal','en'),(45,45,'Tax','en'),(46,46,'n/a','en'),(47,47,'Delete item','en'),(48,48,'Continue...','en'),(49,49,'The text was copied to your clipboard','en'),(50,50,'When X-Cart aggregates CSS and JS files, the result is cached. If you change your JS/CSS files directly in the file system after they have been included into the cache, you will not see the functionality or style changes you have made. To make your changes visible, clear the aggregation cache.','en'),(51,51,'When X-Cart uses widgets cache, the static content of product lists is stored into a temporary cache. After editing the content (modifying the product descriptions, titles or photos), you should clear the widgets cache to make these changes visible in the front end right away. If you do not clear it, the changes will be updated anyway, but it may require more time','en'),(52,52,'The language you want to add has not been found','en'),(53,53,'This language already exists','en'),(54,54,'The {{language}} language has been added successfully','en'),(55,55,'The language you want to delete has not been found','en'),(56,56,'The {{language}} language has been deleted successfully','en'),(57,57,'Language not found','en'),(58,58,'The default interface language cannot be disabled','en'),(59,59,'The {{language}} language has been disabled','en'),(60,60,'The {{language}} language has been enabled','en'),(61,61,'The text labels have been updated','en'),(62,62,'Couldn\'t update the text labels: the translation language is not specified','en'),(63,63,'Couldn\'t update the text labels: the default language is set as the translation language','en'),(64,64,'Couldn\'t update the text labels: the translation language has not been found','en'),(65,65,'The text labels have been deleted','en'),(66,66,'Couldn\'t delete the text labels: text labels not found or not specified','en'),(67,67,'The text label has been deleted','en'),(68,68,'Couldn\'t delete the text label: text label not found or not specified','en'),(69,69,'Couldn\'t add the text label: name not specified.','en'),(70,70,'Couldn\'t add the text label: text label already exists.','en'),(71,71,'The text label has been added successfully','en'),(72,72,'The text label has been updated successfully','en'),(73,73,'The language you are trying to edit has not been found','en'),(74,74,'The language data has been saved','en'),(75,75,'The maximum upload file size is {{upload_max_filesize}}','en'),(76,76,'Search','en'),(77,77,'Next','en'),(78,78,'Custom HTML title','en'),(79,79,'Show category title','en'),(80,80,'Category icon','en'),(81,81,'Top banner','en'),(82,82,'<a href=\"https://devs.x-cart.com/en/how-to_articles/how_to_change_the_height_of_the_top_category_banner.html\">Learn more about the top banner and how it shows in the page layout</a>','en'),(83,83,'Meta tags','en'),(84,84,'Meta desc','en'),(85,85,'View image','en'),(86,86,'From computer','en'),(87,87,'Via URL','en'),(88,88,'Upload via URL','en'),(89,89,'Copy to file system','en'),(90,90,'Alt','en'),(91,91,'Copy','en'),(92,92,'Copy to clipboard','en'),(93,93,'Select file','en'),(94,94,'Undelete','en'),(95,95,'Show all labels','en'),(96,96,'{{n}} items found','en'),(97,97,'No modules found for \"<em>{{search_string}}</em>\"','en'),(98,98,'Language options','en'),(99,99,'{{language}} labels','en'),(100,100,'Select language','en'),(101,101,'No other languages defined','en'),(102,102,'Languages','en'),(103,103,'Help','en'),(104,104,'Knowledge Base','en'),(105,105,'Report a bug','en'),(106,106,'Translations','en'),(107,107,'X-Cart News','en'),(108,108,'Our Blog','en'),(109,109,'Clear fields','en'),(110,110,'New membership','en'),(111,111,'Any availability status','en'),(112,112,'Only enabled','en'),(113,113,'Only disabled','en'),(114,114,'Any class','en'),(115,115,'Default tax class','en'),(116,116,'Images','en'),(117,117,'Attributes','en'),(118,118,'Cloned products','en'),(119,119,'New category','en'),(120,120,'Subcat','en'),(121,121,'Main categories','en'),(122,122,'Add new label','en'),(123,123,'Add language','en'),(124,124,'{{n}} items total','en'),(125,125,'{{count}} item(s)','en'),(126,126,'Add new language','en'),(127,127,'Save','en'),(128,128,'Provide a translation of the text label into each of the languages used at your store. If the text label does not have a translation for a specific language, the translation of the label into the default language will be used instead. If the default language translation is also not available, the Label Name will be used.','en'),(129,129,'Purchase {{list}} license to install this add-on or','en'),(130,130,'Purchase {{list}} license to enable this add-on or','en'),(131,131,'The following modules will be disabled','en'),(132,132,'You can install these updates after <a href=\"{{URL}}\" target=\"_blank\">purchasing</a> and activating your X-Cart license key.','en'),(133,133,'Label name','en'),(134,134,'required','en'),(135,135,'Confirm deletion','en'),(136,136,'You are about to delete the {{language}} language. This operation is irreversible. Are you sure you want to continue?','en'),(137,137,'Delete','en'),(138,138,'Cancel','en'),(139,139,'{{language}} Language (Code: {{code}})','en'),(140,140,'Language name in {{language}}','en'),(141,141,'Native language name','en'),(142,142,'Disable','en'),(143,143,'Enable','en'),(144,144,'Set this language as default for the Customer area','en'),(145,145,'A disabled language cannot be set as default for the Customer area','en'),(146,146,'Delete Language','en'),(147,147,'Edit label','en'),(148,148,'Edit labels','en'),(149,149,'Please specify a pattern to find the required labels','en'),(150,150,'Module not found. Cannot uninstall.','en'),(151,151,'The module has been uninstalled successfully','en'),(152,152,'The {{module}} module has been uninstalled successfully','en'),(153,153,'The {{module}} module was installed with errors: the database was not updated correctly','en'),(154,154,'The {{module}} module was installed incorrectly. Please see logs for more information.','en'),(155,155,'The {{module}} module has been installed; however, the module has a wrong module control class','en'),(156,156,'The modules have been updated','en'),(157,157,'Congratulations! Your order has been placed.<br />You will receive your order confirmation shortly.','en'),(158,158,'{{count}} item in cart','en'),(159,159,'{{count}} items in cart','en'),(160,160,'Items in <a href=\"cart.php?target=cart\">your cart</a>: {{count}}','en'),(161,161,'See all {{count}} items','en'),(162,162,'Last added items','en'),(163,163,'Other items','en'),(164,164,'The selected shipping method has been deleted successfully','en'),(165,165,'The shipping methods have been updated','en'),(166,166,'The selected zones have been deleted successfully','en'),(167,167,'Zone details have been updated successfully','en'),(168,168,'The new zone has been created successfully','en'),(169,169,'This product is in <a href=\"{{href}}\">your cart</a>','en'),(170,170,'Your shopping cart - {{count}} item','en'),(171,171,'Your shopping cart - {{count}} items','en'),(172,172,'Greetings, {{name}}','en'),(173,173,'{{count}} items','en'),(174,174,'<div class=\"minicart-items-number\">{{count}}</div> <div class=\"minicart-items-text\">item</div>','en'),(175,175,'<div class=\"minicart-items-number\">{{count}}</div> <div class=\"minicart-items-text\">items</div>','en'),(176,176,'The email you provided is already in use. You can continue as guest or <a href=\"{{URL}}\" class=\"sign-in log-in\">Sign in</a>','en'),(177,177,'This user name is already taken. Please choose a different user name or <a href=\"{{URL}}\" class=\"log-in\">sign in</a>','en'),(178,178,'I accept the <a href=\"{{URL}}\" target=\"_blank\">Terms &amp; Conditions</a>','en'),(179,179,'By clicking the button above you confirm that you accept the <a href=\"{{URL}}\">Terms &amp; Conditions</a>','en'),(180,180,'Place order: {{total}}','en'),(181,181,'Proceed to payment: {{total}}','en'),(182,182,'Enter a correct email','en'),(183,183,'Enter an integer','en'),(184,184,'Enter a number','en'),(185,185,'Zero cannot be used','en'),(186,186,'Enter a positive number','en'),(187,187,'Enter a negative number','en'),(188,188,'This field is required','en'),(189,189,'\'{{field}}\' field is required','en'),(190,190,'Image #{{index}}','en'),(191,191,'Top {{count}} products','en'),(192,192,'\"{{name}}\" module settings','en'),(193,193,'The benchmark evaluates server environment, namely:<br />1. File subsystem - read and write speed.<br />2. Database server - computing speed, DB data read and write speed.<br />3. Computing power - speed of computing and exchanging data in the memory.<br /><span>The total test time is the sum of the times taken by each of these tests.</span>','en'),(194,194,'Thank you for using {{company}} services','en'),(195,195,'The confirmation URL link was sent to {{email}}','en'),(196,196,'An email with your account information was sent to {{email}}. Please make sure you can log in using the received data.','en'),(197,197,'Show filter options','en'),(198,198,'Customer note','en'),(199,199,'Customer','en'),(200,200,'Anonymous Customer','en'),(201,201,'Anonymous Customer, <a href=\"{{URL}}\">Registered User with the same email</a>','en'),(202,202,'Registered Customer','en'),(203,203,'Registered Customer, <a href=\"{{URL}}\">Anonymous Customer with the same email</a>','en'),(204,204,'The user will be registered; a password will be sent to the user via email','en'),(205,205,'Merge with Registered','en'),(206,206,'Invoice #{{id}}','en'),(207,207,'Welcome to X-Cart','en'),(208,208,'Quantity','en'),(209,209,'Total','en'),(210,210,'Cart is empty','en'),(211,211,'{{count}} item','en'),(212,212,'Items','en'),(213,213,'items','en'),(214,214,'Checkout','en'),(215,215,'Secure Checkout','en'),(216,216,'View cart','en'),(217,217,'Email address','en'),(218,218,'Password','en'),(219,219,'Recover password','en'),(220,220,'Your cart','en'),(221,221,'This is a demo store powered by X-Cart, using PHP5 templates technology and MySQL database.','en'),(222,222,'Price','en'),(223,223,'Product name','en'),(224,224,'Please clarify your search request or search in the <a href=\"{{marketplace}}\">Marketplace</a>','en'),(225,225,'Select one...','en'),(226,226,'Other','en'),(227,227,'Hello, {{name}}','en'),(228,228,'All','en'),(229,229,'None','en'),(230,230,'[Root level]','en'),(231,231,'-- No categories --','en'),(232,232,'Sort by','en'),(233,233,'Pending membership','en'),(234,234,'{{count}} result(s) found','en'),(235,235,'per page','en'),(236,236,'<span>{{count}}</span> order','en'),(237,237,'<span>{{count}}</span> orders','en'),(238,238,'Logged in!','en'),(239,239,'Log off','en'),(240,240,'Account settings','en'),(241,241,'User <strong>{{login}}</strong> is logged in.','en'),(242,242,'{{count}} products found','en'),(243,243,'Thank you for registering a customer account.<br />As a registered customer you can enjoy a simplified checkout process and review your order history.<br /><br />A registration confirmation message with your account details has been sent to your email <b>{profile.login}</b>.<br />Please use your registration email and password every time you place orders at our store.<br /><br />You are now logged in and welcome to continue shopping.','en'),(244,244,'<span class=\"begin-record-number\">{{begin}}</span>&ndash;<span class=\"end-record-number\">{{end}}</span> of <span class=\"records-count\">{{total}}</span>','en'),(245,245,'{{value}} bytes','en'),(246,246,'{{value}} kB','en'),(247,247,'{{value}} MB','en'),(248,248,'{{value}} GB','en'),(249,249,'Including {{name}}','en'),(250,250,'{{years}} year(s)','en'),(251,251,'{{months}} month(s)','en'),(252,252,'{{days}} day(s)','en'),(253,253,'{{hours}} hour(s)','en'),(254,254,'{{minutes}} minute(s)','en'),(255,255,'{{seconds}} second(s)','en'),(256,256,'Import will overwrite the existing product information. This operation cannot be undone.','en'),(257,257,'To find out the data format for import, you can create a sample data file <a href=\"{{url}}\">by exporting your existing products</a>. Then you can prepare your import file using the same format.','en'),(258,258,'Note that data import time will depend on the size of the file being imported.','en'),(259,259,'Cannot import the field \'{{name}}\': unknown field','en'),(260,260,'String is inconsistent with the title: the number of columns is {{wrong}} instead of {{right}}','en'),(261,261,'The required field \'{{name}}\' is not defined or empty. The product has not been created','en'),(262,262,'{{url}} image unable to load','en'),(263,263,'During import {{count}} errors were generated. For details, <a href=\"{{url}}\">download</a> the log files.','en'),(264,264,'Some products might have been imported incorrectly. Please check your catalog. Find the IDs of such products in the import log file above.','en'),(265,265,'Order #{{id}}, {{date}}','en'),(266,266,'Order #{{id}}','en'),(267,267,'The {{name}} field is empty','en'),(268,268,'The value of the {{name}} field must be greater than {{min}}','en'),(269,269,'The value of the {{name}} field must be less than {{max}}','en'),(270,270,'Incorrect value format in {{name}} field.','en'),(271,271,'The value of the {{name}} field must not be longer than {{max}}','en'),(272,272,'To boost your sales, try the \"<a href=\"{{discountCoupons}}\">Coupons</a>\", \"<a href=\"{{sale}}\">Sale</a>\", \"<a href=\"{{productAdvisor}}\">Product Advisor</a>\" and \"<a href=\"{{volumeDiscounts}}\">Volume Discounts</a>\" addons. You may also be interested in other <a href=\"{{marketingTag}}\">Marketing</a> extensions from our Marketplace','en'),(273,273,'Trying to access the shop at <a href=\"{{url}}\">{{url}}</a> ...','en'),(274,274,'To fix this problem take the following steps: <ul><li>make sure the HTTPS protocol is enabled by your hosting service provider;</li><li>check your HTTPS settings (the \'https_host\' parameter in the \'etc/config.php\' file must be valid);</li><li>reload this page.</li></ul>','en'),(275,275,'To upload the database data directly from your local computer, click \"Browse\", choose an SQL dump file and click \"Upload and restore\". This method is more convenient; however, it has a file size limitation of {{N}}.','en'),(276,276,'You may upload a file named sqldump.sql.php to the var/backup/ directory of your X-Cart installation on the web server and click \"Restore from server\".','en'),(277,277,'Maximum upload file size is {{N}}.','en'),(278,278,'Unable to install the module \"{{X}}\":  required modules have not been installed or activated.','en'),(279,279,'cannot set {{X}} permissions','en'),(280,280,'Incorrect owner of {{X}} directory','en'),(281,281,'Cannot set {{X}} permissions for subdirectories:','en'),(282,282,'Incorrect owner of {{X}} file','en'),(283,283,'File size exceeds the maximum size of ({{size}})','en'),(284,284,'File was not loaded due to a server side failure.','en'),(285,285,'{{count}} item available','en'),(286,286,'{{count}} items available','en'),(287,287,'{{count}} product(s) removed','en'),(288,288,'{{count}} product(s) created','en'),(289,289,'{{count}} entities  removed','en'),(290,290,'{{count}} entities created','en'),(291,291,'Select a country or a state from the list, specify the zone where the country or state should be listed and click \"Apply\". To select more than one country/state, hold down the CTRL key while selecting the items. A zone must contain either countries or states. You cannot include both states and countries into the same zone.','en'),(292,292,'If you store product images in the database, they are included in the SQL dump file. If the product images are located on the file system, they are not included in the SQL dump file. To back up such images you need to download them directly from the server.','en'),(293,293,'You can choose one of the following options:<ol class=\"styled\"><li>Download the database data (SQL dump) directly to your local computer - please click the \'Download SQL file\' button.</li><li>Save the database data as a file on the web server (\'var/backup/sqldump.sql.php\') - please click the \'Create SQL file\' button.</li></ol>','en'),(294,294,'Dear {{name}}!','en'),(295,295,'Thank you for your business. Please come back soon!','en'),(296,296,'{{percent}} off','en'),(297,297,'Placed on <span class=\"date\">{{date}}</span> by <span class=\"name\">{{name}}</span>','en'),(298,298,'Placed on <span class=\"date\">{{date}}</span> by <a href=\"{{url}}\" class=\"name\">{{name}}</a>','en'),(299,299,'Order Total: <span>{{total}}</span>','en'),(300,300,'Oops! Our payment system has not informed us whether your last order was paid for, or not. Is there a payment form that you have not completed yet? If so, please complete and submit it. Or you can quickly <a href=\"{{url}}\">re-order the products</a> from your last incomplete order.','en'),(301,301,'Payment transaction [method: {{trx_method}}, type: {{trx_type}}, amount: {{trx_value}}, status: {{trx_status}}]','en'),(302,302,'Back end payment transaction [method: {{trx_method}}, type: {{trx_type}}, amount: {{trx_value}}, status: {{trx_status}}]','en'),(303,303,'Trial period &mdash; {{X}} day(s) left','en'),(304,304,'Editing attribute groups on this page will not affect other product classes that use these groups. Removing a group does not delete attributes from the group, but makes them show up among other attributes having no associated groups.','en'),(305,305,'What\'s new','en'),(306,306,'Your account email is {{email}}','en'),(307,307,'Your account password is {{password}}','en'),(308,308,'Watch this short video and learn the basics of how online payment processing works. You will also find out what to look for when choosing the best payment processing solution for your business.','en'),(309,309,'{{count}} methods available','en'),(310,310,'The payment method has been enabled','en'),(311,311,'The payment method has been disabled','en'),(312,312,'The payment method has been removed','en'),(313,313,'The payment method has not been configured properly','en'),(314,314,'Duplicated clean URL: {{value}}','en'),(315,315,'Attributes for \"{{class}}\" product class','en'),(316,316,'{{count}} attributes in group','en'),(317,317,'Order {{order_number}} has been placed','en'),(318,318,'This module is available for X-Cart hosted stores only. <a href=\"{{url}}\">Click here for more information.</a>','en'),(319,319,'Low inventory products ({{count}})','en'),(320,320,'{{value}} orders yesterday','en'),(321,321,'{{value}} orders last week','en'),(322,322,'{{value}} orders last month','en'),(323,323,'{{value}} yesterday','en'),(324,324,'{{value}} last week','en'),(325,325,'{{value}} last month','en'),(326,326,'No orders yesterday','en'),(327,327,'No orders last week','en'),(328,328,'No orders last month','en'),(329,329,'No orders yet','en'),(330,330,'No orders','en'),(331,331,'To use the secure protocol you need an SSL certificate purchased for the \"<span>{{domain}}</span>\" domain and installed on your server.','en'),(332,332,'To enable the secure protocol for your website pages you need a valid SSL certificate purchased for the \"<span>{{domain}}</span>\" website domain and installed on your server.','en'),(333,333,'Pre-launch checklist:','en'),(334,334,'{{size}}','en'),(335,335,'Exported on {{date}}','en'),(336,336,'No write permissions to directory {{path}}. Please set the necessary permissions to directory {{path}}.','en'),(337,337,'Failed write to file {{path}}. There may not be enough disk space. Please check if there is enough disk space.','en'),(338,338,'Export is complete. <a href=\"{{url}}\">Check results and download</a>.','en'),(339,339,'This will increase the shipping cost by {{XX}}','en'),(340,340,'{{count}} products','en'),(341,341,'Subcategories: {{count}}','en'),(342,342,'Manage category: {{category_name}}','en'),(343,343,'Subcategories for','en'),(344,344,'OrderID or email, ID1-ID2 for range','en'),(345,345,'All Order Statuses','en'),(346,346,'Enter date range','en'),(347,347,'Authorized','en'),(348,348,'Shipped','en'),(349,349,'Cancelled','en'),(350,350,'Expired','en'),(351,351,'Refund requested','en'),(352,352,'Refunded','en'),(353,353,'Partially refunded','en'),(354,354,'Selected:','en'),(355,355,'Days','en'),(356,356,'Close','en'),(357,357,'MO','en'),(358,358,'TU','en'),(359,359,'WE','en'),(360,360,'TH','en'),(361,361,'FR','en'),(362,362,'SA','en'),(363,363,'SU','en'),(364,364,'JANUARY','en'),(365,365,'FEBRUARY','en'),(366,366,'MARCH','en'),(367,367,'APRIL','en'),(368,368,'MAY','en'),(369,369,'JUNE','en'),(370,370,'JULY','en'),(371,371,'AUGUST','en'),(372,372,'SEPTEMBER','en'),(373,373,'OCTOBER','en'),(374,374,'NOVEMBER','en'),(375,375,'DECEMBER','en'),(376,376,'Shortcuts','en'),(377,377,'Past','en'),(378,378,'7days','en'),(379,379,'14days','en'),(380,380,'30days','en'),(381,381,'Previous','en'),(382,382,'Week','en'),(383,383,'Month','en'),(384,384,'Quarter','en'),(385,385,'Year','en'),(386,386,'Date range should be longer than %d days','en'),(387,387,'Date range should be less than %d days','en'),(388,388,'Please select a date range longer than %d days','en'),(389,389,'Please select a date range shorter than %d days','en'),(390,390,'Please select a date range between %d and %d days','en'),(391,391,'Please select a date range','en'),(392,392,'Enter keyword','en'),(393,393,'All membership levels','en'),(394,394,'No membership','en'),(395,395,'All User Types','en'),(396,396,'Please select one ...','en'),(397,397,'Please select an option','en'),(398,398,'Search keywords','en'),(399,399,'Search payment method','en'),(400,400,'Any category','en'),(401,401,'Any status','en'),(402,402,'Search in','en'),(403,403,'{{count}} label(s)','en'),(404,404,'This language was added by the module {{module}} and cannot be removed.','en'),(405,405,'{{count}} language(s) removed','en'),(406,406,'{{count}} language label(s) removed','en'),(407,407,'No payment methods available. Please contact the <a href=\"mailto:{{email}}\">store administrator</a>.','en'),(408,408,'Edit states ({{count}})','en'),(409,409,'{{count}} state(s) removed','en'),(410,410,'{{count}} state(s) created','en'),(411,411,'{{count}} zone(s) removed','en'),(412,412,'{{count}} zone(s) created','en'),(413,413,'This is the default zone which matches all possible addresses.<br />The default zone can be edited but cannot be removed.','en'),(414,414,'Examples:<br /><br />2204%<br />38?45<br />23%<br /><br /><b>?</b> - any character<br /><b>%</b> - any character sequence, even empty','en'),(415,415,'Examples:<br /><br />New York<br />New%<br />%Y?rk<br /><br /><b>?</b> - any character<br /><b>%</b> - any character sequence, even empty','en'),(416,416,'Examples:<br /><br />%Water St%<br />%Coney Is?and%<br /><br /><b>?</b> - any character<br /><b>%</b> - any character sequence, even empty','en'),(417,417,'{{count}} shipping method(s) created','en'),(418,418,'{{count}} shipping method(s) removed','en'),(419,419,'Edit rates ({{count}})','en'),(420,420,'Your first name','en'),(421,421,'Your last name','en'),(422,422,'1000 Example street','en'),(423,423,'Example city','en'),(424,424,'California','en'),(425,425,'','en'),(426,426,'+12130000000','en'),(427,427,'','en'),(428,428,'Specification','en'),(429,429,'Not all the upgrade packs have been downloaded. This may have been caused by one of the following:<ul class=\'marked-list\'><li>slow Internet connection;</li><li>an internal problem on the Marketplace server;</li><li>a problem with your X-Cart license (expired license key, license key not matching the module license, etc.)</li></ul>','en'),(430,430,'A new customer? Enter your email','en'),(431,431,'ABA routing number','en'),(432,432,'Absolute','en'),(433,433,'Accept','en'),(434,434,'Orders','en'),(435,435,'Online methods','en'),(436,436,'Access denied!','en'),(437,437,'Access information','en'),(438,438,'Access is locked out','en'),(439,439,'Access level','en'),(440,440,'Account','en'),(441,441,'Account details','en'),(442,442,'Account status','en'),(443,443,'Account summary','en'),(444,444,'Activate license key','en'),(445,445,'Activate your paid module license','en'),(446,446,'Active','en'),(447,447,'Active from','en'),(448,448,'Active till','en'),(449,449,'Add','en'),(450,450,'Add Product','en'),(451,451,'Add alternative payment method','en'),(452,452,'Add category','en'),(453,453,'Add child','en'),(454,454,'Add discount','en'),(455,455,'Add featured products','en'),(456,456,'Add file','en'),(457,457,'Add image','en'),(458,458,'Add rate','en'),(459,459,'Add new','en'),(460,460,'Add new address','en'),(461,461,'Add new country','en'),(462,462,'Add new exception','en'),(463,463,'Add new membership level','en'),(464,464,'Add new option','en'),(465,465,'Add new option group','en'),(466,466,'Add new state','en'),(467,467,'Add offline payment method','en'),(468,468,'Add payment method','en'),(469,469,'Add shipping method','en'),(470,470,'Add subcategory','en'),(471,471,'Add user','en'),(472,472,'Add your <a href=\"{{URL}}\">products</a>','en'),(473,473,'Add zone','en'),(474,474,'Add-ons','en'),(475,475,'Add/update options','en'),(476,476,'Added','en'),(477,477,'Joined','en'),(478,478,'Added to cart','en'),(479,479,'Address','en'),(480,480,'Address book','en'),(481,481,'Address details','en'),(482,482,'Address field','en'),(483,483,'Address fields','en'),(484,484,'Address pattern','en'),(485,485,'Admin','en'),(486,486,'Administrator area','en'),(487,487,'Administrator','en'),(488,488,'All add-ons','en'),(489,489,'All customers','en'),(490,490,'All memberships','en'),(491,491,'All the necessary adaptation will be done by the developer (covered by extended warranty).','en'),(492,492,'All products on sale','en'),(493,493,'All shipping methods','en'),(494,494,'All address zones','en'),(495,495,'All the products are in sufficient quantities','en'),(496,496,'All time','en'),(497,497,'PayPal all-in-one solutions','en'),(498,498,'No merchant account required. Simple onboarding for you and easy checkout for your customers.','en'),(499,499,'Alphabetically','en'),(500,500,'Already have an account?','en'),(501,501,'Alternative payment methods','en'),(502,502,'Alternative text','en'),(503,503,'Amount','en'),(504,504,'Amount: high to low','en'),(505,505,'Amount: low to high','en'),(506,506,'An upgrade is a dangerous process that may result in a crashed website. It is strongly recommended to create a full backup of your store (the code and the database) and download it to a local computer before proceeding to the next step.','en'),(507,507,'Another state','en'),(508,508,'Any membership level','en'),(509,509,'Any product class','en'),(510,510,'Any zone','en'),(511,511,'Appearance','en'),(512,512,'Apply destination','en'),(513,513,'Apply price','en'),(514,514,'Are you sure you want to continue?','en'),(515,515,'Are you sure you want to delete the selected user?','en'),(516,516,'Are you sure you want to disable this add-on?','en'),(517,517,'Are you sure you want to enable this add-on?','en'),(518,518,'Are you sure you want to uninstall this add-on?','en'),(519,519,'Are you sure you want to delete the selected payment method?','en'),(520,520,'Are you sure you wish to delete the selected zones?','en'),(521,521,'Are you sure?','en'),(522,522,'Arrival date','en'),(523,523,'Asynchronous','en'),(524,524,'Ask.com','en'),(525,525,'Assigned classes','en'),(526,526,'Attachment has not been deleted','en'),(527,527,'Attachments','en'),(528,528,'Attachments have been updated successfully','en'),(529,529,'Australia Post settings','en'),(530,530,'Authentication','en'),(531,531,'Authentication code','en'),(532,532,'Author','en'),(533,533,'Authorization then capture','en'),(534,534,'Auto','en'),(535,535,'Availability','en'),(536,536,'Available for sale','en'),(537,537,'B','en'),(538,538,'Back to file select','en'),(539,539,'Back to layout settings','en'),(540,540,'Back to methods','en'),(541,541,'Back to orders list','en'),(542,542,'Backup','en'),(543,543,'Backup database','en'),(544,544,'Bank Account Number','en'),(545,545,'Benchmark completed in ','en'),(546,546,'Benchmark result under 3000ms is considered good','en'),(547,547,'Bestsellers','en'),(548,548,'Billing address','en'),(549,549,'Billing address is not defined yet','en'),(550,550,'Bing','en'),(551,551,'Brief description','en'),(552,552,'Brief description','en'),(553,553,'Browse server','en'),(554,554,'Buy more','en'),(555,555,'CLOSE','en'),(556,556,'CSS & JavaScript','en'),(557,557,'Cache rebuild is already started, please wait','en'),(558,558,'Calculate rates','en'),(559,559,'Cannot be disabled. The module is required by:','en'),(560,560,'Cannot connect to the Addons Marketplace server','en'),(561,561,'Capture status','en'),(562,562,'Cart & checkout','en'),(563,563,'Catalog','en'),(564,564,'Categories','en'),(565,565,'Category','en'),(566,566,'Category info','en'),(567,567,'Category name','en'),(568,568,'Category name contains invalid UTF-8 characters or 4-byte UTF-8 characters which are not supported. Please correct and try again.','en'),(569,569,'Category page title','en'),(570,570,'Category path contains invalid UTF-8 characters or 4-byte UTF-8 characters which are not supported. Please correct and try again.','en'),(571,571,'Change','en'),(572,572,'Change address','en'),(573,573,'Change method','en'),(574,574,'Change options','en'),(575,575,'Change payment info','en'),(576,576,'Change shipping info','en'),(577,577,'Change shipping info','en'),(578,578,'Check all','en'),(579,579,'Check number','en'),(580,580,'Checking','en'),(581,581,'Checking integrity, please wait...','en'),(582,582,'Choose','en'),(583,583,'Choose <a href=\"{{URL}}\">payment methods</a>','en'),(584,584,'Choose file','en'),(585,585,'Choose from a variety of bundled payment solutions to accept credit cards and other methods of payment on your website','en'),(586,586,'Choose method','en'),(587,587,'Choose shipping method','en'),(588,588,'City','en'),(589,589,'Clean URL','en'),(590,590,'Enable clean URL','en'),(591,591,'Error code explanation:','en'),(592,592,'Internal server error','en'),(593,593,'More information about clean urls in X-Cart is available in <a href=\"{{url}}\" target=\"blank\">{{url}}</a>','en'),(594,594,'We made a test request to <a href=\"{{url}}\">{{url}}</a> URL and got the following result (It means that your SEO-friendly URLs may not work properly after enabling).','en'),(595,595,'Clear aggregation cache','en'),(596,596,'Clear widgets cache','en'),(597,597,'CleanURL','en'),(598,598,'Empty your cart','en'),(599,599,'Click here to access/add subcategories','en'),(600,600,'Click here to view states of country','en'),(601,601,'Click to unblock','en'),(602,602,'Close storefront','en'),(603,603,'Code','en'),(604,604,'Comment','en'),(605,605,'Comments','en'),(606,606,'Company','en'),(607,607,'Company name','en'),(608,608,'Completed','en'),(609,609,'Component','en'),(610,610,'Configuration','en'),(611,611,'Configure <a href=\"{{URL}}\">shipping methods</a>','en'),(612,612,'Configure your store','en'),(613,613,'Confirm password','en'),(614,614,'Contacts','en'),(615,615,'Content','en'),(616,616,'Continue','en'),(617,617,'Copy file to local server','en'),(618,618,'Core version: ','en'),(619,619,'Countries','en'),(620,620,'Countries, states and zones','en'),(621,621,'Country','en'),(622,622,'Country is not selected','en'),(623,623,'Coupon code','en'),(624,624,'Coupons','en'),(625,625,'Create','en'),(626,626,'Create profile','en'),(627,627,'Create SQL file','en'),(628,628,'Create a backup','en'),(629,629,'Create account','en'),(630,630,'Create an account for later use','en'),(631,631,'Create category','en'),(632,632,'Create new account','en'),(633,633,'Created','en'),(634,634,'Currency','en'),(635,635,'Custom add-ons','en'),(636,636,'Custom CSS','en'),(637,637,'Custom JavaScript','en'),(638,638,'Custom images','en'),(639,639,'Custom translation','en'),(640,640,'Customer zip/postal code','en'),(641,641,'Clean URLs are disabled. <a target=\'_blank\' href=\'{{more_info_url}}\'>More info</a>','en'),(642,642,'Clean URLs are enabled','en'),(643,643,'Clean URLs are disabled','en'),(644,644,'Enable clean URLs','en'),(645,645,'Clean URLs functionality may not be enabled. <a target=\'_blank\' href=\'{{article_url}}\'>More info<i class=\'icon fa fa-external-link\'></i></a>','en'),(646,646,'More information on Clean URL problems on your system','en'),(647,647,'The data has been deleted successfully','en'),(648,648,'The data has been saved successfully','en'),(649,649,'Database backup has been created successfully','en'),(650,650,'Date','en'),(651,651,'Day','en'),(652,652,'Dear','en'),(653,653,'Dear customer!','en'),(654,654,'Decline','en'),(655,655,'Declined','en'),(656,656,'Default','en'),(657,657,'Default customer address','en'),(658,658,'Default for Customer area and cannot be disabled or deleted','en'),(659,659,'Default for Customer area and cannot be disabled or deleted','en'),(660,660,'Default images settings','en'),(661,661,'The powerful shopping cart software for web stores and e-commerce enabled stores is based on PHP5 with SQL database with highly configurable implementation based on templates','en'),(662,662,'All Addresses (default zone)','en'),(663,663,'Define classes','en'),(664,664,'Delete SQL file','en'),(665,665,'Delete all','en'),(666,666,'Delete profile','en'),(667,667,'Delete selected','en'),(668,668,'Delete selected profile','en'),(669,669,'Delete the image','en'),(670,670,'Delete this address?','en'),(671,671,'Delivery methods','en'),(672,672,'Destination zone','en'),(673,673,'Details','en'),(674,674,'Directory and file permissions','en'),(675,675,'Disable all modules in the system','en'),(676,676,'Disable suspicious modules','en'),(677,677,'Disabled','en'),(678,678,'A disabled language cannot be set as default for Customer area','en'),(679,679,'Discount','en'),(680,680,'Discount amount','en'),(681,681,'Discount type','en'),(682,682,'Display \'inc/ex VAT\' labels next to prices','en'),(683,683,'Display type','en'),(684,684,'Do not close this page!','en'),(685,685,'Do not show at startup anymore','en'),(686,686,'Do you really want to delete the selected items?','en'),(687,687,'Dont have account yet?','en'),(688,688,'Download SQL file','en'),(689,689,'Downloaded components','en'),(690,690,'Downloading updates','en'),(691,691,'Downloading updates, please wait...','en'),(692,692,'Drag and drop me to the cart','en'),(693,693,'Drop items here to shop','en'),(694,694,'Drupal front end','en'),(695,695,'Email','en'),(696,696,'Email is not defined yet','en'),(697,697,'Edit charges for:','en'),(698,698,'Edit payment method data','en'),(699,699,'Edit page','en'),(700,700,'Edit profile','en'),(701,701,'Email','en'),(702,702,'Email &amp; password','en'),(703,703,'Email body','en'),(704,704,'Email settings','en'),(705,705,'Enable HTTPS','en'),(706,706,'Enabled','en'),(707,707,'Enter coupon code','en'),(708,708,'Enter keywords','en'),(709,709,'Enter license key','en'),(710,710,'Enter shipping address','en'),(711,711,'Enter {{X}} more characters to start search','en'),(712,712,'Environment','en'),(713,713,'Environment info','en'),(714,714,'Error','en'),(715,715,'Estimate shipping cost','en'),(716,716,'Estimate your server performance','en'),(717,717,'Estimated for','en'),(718,718,'Everything you need','en'),(719,719,'Example','en'),(720,720,'Examples','en'),(721,721,'Exception','en'),(722,722,'Extend the functionality of your store by installing and using add-on modules','en'),(723,723,'Export','en'),(724,724,'Export products','en'),(725,725,'Extensions','en'),(726,726,'Facebook','en'),(727,727,'Failed','en'),(728,728,'Failed to add the detailed image','en'),(729,729,'Failed to add the attachment','en'),(730,730,'Failed to add the attachment. The file download is forbidden','en'),(731,731,'Failed/Declined','en'),(732,732,'Featured products','en'),(733,733,'Field is required!','en'),(734,734,'File title','en'),(735,735,'Find us on','en'),(736,736,'Find us on Facebook','en'),(737,737,'First name','en'),(738,738,'Flat rate','en'),(739,739,'Footer menu','en'),(740,740,'For the period','en'),(741,741,'Forgot password?','en'),(742,742,'Format','en'),(743,743,'Free add-ons','en'),(744,744,'From','en'),(745,745,'from','en'),(746,746,'Selected countries:','en'),(747,747,'Selected countries','en'),(748,748,'All states','en'),(749,749,'Selected states','en'),(750,750,'Back to Zones list','en'),(751,751,'Attributes block','en'),(752,752,'From email','en'),(753,753,'Full description','en'),(754,754,'Full name','en'),(755,755,'General','en'),(756,756,'General Settings','en'),(757,757,'General info','en'),(758,758,'General settings','en'),(759,759,'Give buyers a way to pay by adding an alternative payment method.','en'),(760,760,'Give buyers another way to pay by adding an alternative payment method','en'),(761,761,'Go to Marketplace','en'),(762,762,'Go to checkout','en'),(763,763,'Grid','en'),(764,764,'Group options','en'),(765,765,'Here\'s a new link for access to your information: <a href=\"{{link}}\">{{link}}</a>','en'),(766,766,'HTML title (\'title\' tag)','en'),(767,767,'HTTPS check','en'),(768,768,'HTTPS settings','en'),(769,769,'Restores to current state of active addons (use in case of emergency)','en'),(770,770,'Disables all addons except ones that are provided by X-Cart Team (hard reset)','en'),(771,771,'Disables all addons except ones that are provided by X-Cart Team & Qualiteam (soft reset)','en'),(772,772,'Disables all addons (core reset)','en'),(773,773,'Have a discount coupon?','en'),(774,774,'Height (px)','en'),(775,775,'Help zone','en'),(776,776,'The list below shows only the methods enabled on the configuration page','en'),(777,777,'Here you can define how your payment methods will look in the Customer area','en'),(778,778,'Hide','en'),(779,779,'Hide trailing zeros in fractional part','en'),(780,780,'History','en'),(781,781,'Home','en'),(782,782,'How to','en'),(783,783,'How to back up your store database','en'),(784,784,'How to define address zones','en'),(785,785,'I understand that these add-ons may require an adaptation.','en'),(786,786,'Icons','en'),(787,787,'Identity','en'),(788,788,'If any critical errors have occurred, you can do the following','en'),(789,789,'If you choose the second option, you can download the file from the server later on and delete it from the server by clicking on the \'Delete SQL file\' button.','en'),(790,790,'If you do not have an account, you can easily','en'),(791,791,'If you don\'t have a moneybookers account yet, please sign up for a free moneybookers account at: http://www.skrill.com','en'),(792,792,'If you have a license key for a commercial module, you can enter it here to register the purchase of the module.','en'),(793,793,'If you have a plugin in the .tar format, you can install it by uploading it here','en'),(794,794,'Image','en'),(795,795,'Image border will not be displayed in the storefront','en'),(796,796,'Image has been identified as a duplicate and has not been imported: {{value}}','en'),(797,797,'Import','en'),(798,798,'Import / Export','en'),(799,799,'Import from file','en'),(800,800,'Import/Export','en'),(801,801,'Important','en'),(802,802,'In category','en'),(803,803,'In stock','en'),(804,804,'Inactive','en'),(805,805,'Incl. X','en'),(806,806,'Incomplete','en'),(807,807,'InnoDB engine support enabled','en'),(808,808,'Install','en'),(809,809,'Install add-on','en'),(810,810,'Install updates','en'),(811,811,'Installation directory','en'),(812,812,'Installed','en'),(813,813,'Installed Modules','en'),(814,814,'Installed modules','en'),(815,815,'Installing updates, please wait...','en'),(816,816,'Invalid login or password','en'),(817,817,'Invalid login or password. <br/><span class=\"common-text\">You can use the \'Forgot password?\' link to reset your password.</span>','en'),(818,818,'Inventory status','en'),(819,819,'Inventory tracking','en'),(820,820,'Inventory tracking','en'),(821,821,'Invoice','en'),(822,822,'It is not possible to delete or create user accounts because your store currently works as an integration with Drupal and shares users with Drupal. Deleting/creating user accounts is possible via Drupal administrator interface.','en'),(823,823,'It is not possible to edit some user profile fields because your store currently works as an integration with Drupal and shares users with Drupal. Modifying these fields is possible via Drupal administrator interface.','en'),(824,824,'Item description','en'),(825,825,'Item(s) deleted from your cart','en'),(826,826,'Item name','en'),(827,827,'Items per page','en'),(828,828,'Join forces with your bank','en'),(829,829,'K','en'),(830,830,'Language','en'),(831,831,'Language labels','en'),(832,832,'Last logged in','en'),(833,833,'Last login','en'),(834,834,'Last name','en'),(835,835,'License key has been successfully verified for the \"{{name}}\" module by \"{{author}}\" ','en'),(836,836,'Lifetime','en'),(837,837,'Limit the number of uses','en'),(838,838,'Link','en'),(839,839,'List','en'),(840,840,'List of states','en'),(841,841,'Loading...','en'),(842,842,'Localization','en'),(843,843,'Log in','en'),(844,844,'Log out','en'),(845,845,'Logged as','en'),(846,846,'Login','en'),(847,847,'Log in here','en'),(848,848,'Login history','en'),(849,849,'Look & Feel','en'),(850,850,'Low stock notification for this product is','en'),(851,851,'Low stock threshold','en'),(852,852,'Low stock','en'),(853,853,'M','en'),(854,854,'Maintenance','en'),(855,855,'Maintenance and operation','en'),(856,856,'Back up your store\'s database','en'),(857,857,'Manage catalog','en'),(858,858,'Manage categories','en'),(859,859,'Manage customer and administrator accounts','en'),(860,860,'Manage layout','en'),(861,861,'Manage orders','en'),(862,862,'Manage orders placed at your store','en'),(863,863,'Manage users','en'),(864,864,'Manage administrators','en'),(865,865,'Manage your product inventory','en'),(866,866,'Required fields are marked with an asterisk','en'),(867,867,'Manually defined shipping methods','en'),(868,868,'Mark the search engines you want to inform of the structure of your site using the site map','en'),(869,869,'Market price','en'),(870,870,'App Store','en'),(871,871,'Marketplace [check_addon_key]: the \"{{url}}\" URL requested','en'),(872,872,'Marketplace [check_for_updates]: the \"{{url}}\" URL requested','en'),(873,873,'Marketplace [check_for_updates]: valid response received','en'),(874,874,'Marketplace [get_hosting_score]: response has an invalid format','en'),(875,875,'Marketplace [get_hosting_score]: the \"{{url}}\" URL requested','en'),(876,876,'Rate per item','en'),(877,877,'Rate per weight unit','en'),(878,878,'Membership','en'),(879,879,'Membership access','en'),(880,880,'Membership levels','en'),(881,881,'Membership name','en'),(882,882,'Memberships','en'),(883,883,'Menus','en'),(884,884,'Message','en'),(885,885,'Meta description','en'),(886,886,'Meta keywords','en'),(887,887,'Methods','en'),(888,888,'Modify','en'),(889,889,'Modify \"{{name}}\" option group','en'),(890,890,'Modify category','en'),(891,891,'Modify option group exceptions','en'),(892,892,'Modify root category (the store\'s front page)','en'),(893,893,'The module has been successfully installed','en'),(894,894,'Addons Marketplace','en'),(895,895,'More add-ons','en'),(896,896,'More details','en'),(897,897,'Most Popular','en'),(898,898,'Most Rated','en'),(899,899,'Move','en'),(900,900,'My account','en'),(901,901,'MySQL server','en'),(902,902,'Name','en'),(903,903,'Name of address field','en'),(904,904,'Name of purchaser','en'),(905,905,'Bank name','en'),(906,906,'Name of account holder','en'),(907,907,'Never','en'),(908,908,'New access link','en'),(909,909,'New access key will also be sent to the Site administrator\'s email address','en'),(910,910,'New address field','en'),(911,911,'New discount coupon','en'),(912,912,'New image','en'),(913,913,'New item','en'),(914,914,'New page','en'),(915,915,'New product class','en'),(916,916,'The new product has been added successfully','en'),(917,917,'New rate','en'),(918,918,'New role','en'),(919,919,'Newest','en'),(920,920,'Newest first','en'),(921,921,'Next','en'),(922,922,'Next page','en'),(923,923,'No','en'),(924,924,'No countries found','en'),(925,925,'No products are featured in this category','en'),(926,926,'No image','en'),(927,927,'No images uploaded','en'),(928,928,'No items found.','en'),(929,929,'No merchant account required','en'),(930,930,'No orders have been placed yet','en'),(931,931,'No orders have been placed yet','en'),(932,932,'No payment modules installed','en'),(933,933,'No products sold yet','en'),(934,934,'No states found','en'),(935,935,'No tax rates defined','en'),(936,936,'Non-administrator','en'),(937,937,'Not finished','en'),(938,938,'Not a numeric value','en'),(939,939,'Note','en'),(940,940,'Notes','en'),(941,941,'This setting is inactive because \"Low stock warning\" notifications are disabled. You can enable them <a href=\"{{link}}\">here</a>.','en'),(942,942,'Off','en'),(943,943,'Official website','en'),(944,944,'Offline methods','en'),(945,945,'Old price','en'),(946,946,'On','en'),(947,947,'On all catalog pages','en'),(948,948,'On product details pages only','en'),(949,949,'Online catalog structure setup','en'),(950,950,'Only lowercase letters, digits and undescore character are allowed','en'),(951,951,'Open Graph meta tags','en'),(952,952,'Open graph tags','en'),(953,953,'Open storefront','en'),(954,954,'Operating system','en'),(955,955,'Option group','en'),(956,956,'The options have been successfully updated','en'),(957,957,'Order','en'),(958,958,'Order #','en'),(959,959,'Order ID','en'),(960,960,'Order Total','en'),(961,961,'Order date from','en'),(962,962,'Order date through','en'),(963,963,'Order details','en'),(964,964,'Order id','en'),(965,965,'Order items','en'),(966,966,'Order note','en'),(967,967,'Order page','en'),(968,968,'Order review','en'),(969,969,'Order statistics','en'),(970,970,'Order status','en'),(971,971,'Orders','en'),(972,972,'Orders count','en'),(973,973,'Orders placed','en'),(974,974,'Out of stock','en'),(975,975,'Pack it','en'),(976,976,'Page','en'),(977,977,'Page URL','en'),(978,978,'Page name','en'),(979,979,'Page not found','en'),(980,980,'Pages','en'),(981,981,'Paid','en'),(982,982,'Parent category','en'),(983,983,'Password and its confirmation do not match','en'),(984,984,'Pattern search','en'),(985,985,'All payment methods','en'),(986,986,'Payment info','en'),(987,987,'Payment instructions','en'),(988,988,'Payment method','en'),(989,989,'Payment methods','en'),(990,990,'Payment method data','en'),(991,991,'Payment data ({{method}})','en'),(992,992,'Payment settings','en'),(993,993,'Payment transaction ID','en'),(994,994,'Payment transactions','en'),(995,995,'Payment methods','en'),(996,996,'Pending','en'),(997,997,'Pending memberships','en'),(998,998,'Per item rate','en'),(999,999,'Per weight unit rate','en'),(1000,1000,'Percent','en'),(1001,1001,'Percent rate','en'),(1002,1002,'Percent off','en'),(1003,1003,'Perform order search','en'),(1004,1004,'Performance','en'),(1005,1005,'Permissions','en'),(1006,1006,'Not enough permissions to run the process. Make sure the following permissions are set (UNIX-like systems only).<br />Such permissions are required for a seamless automated installation or upgrade of X-Cart on your server. They do not take into account the specific configuration of your server or any security requirements. Once the process is completed, make sure you change the permissions to a more restrictive setting. <a target=\'_blank\' href=\'https://kb.x-cart.com/en/setting_up_x-cart_5_environment/secure_configuration.html#why-x-cart-asks-for-666777-permissions\'>Read more</a>','en'),(1007,1007,'Personal info','en'),(1008,1008,'Phone','en'),(1009,1009,'Pick address from address book','en'),(1010,1010,'Place order','en'),(1011,1011,'Please accept the Terms and Conditions to continue','en'),(1012,1012,'Please choose the appropriate action','en'),(1013,1013,'Please enable JavaScript in your web browser.','en'),(1014,1014,'Please identify yourself','en'),(1015,1015,'Please note that some of these modules are incompatible with the upcoming upgrade and will be disabled in order to prevent a system crash','en'),(1016,1016,'Run benchmark to estimate your server performance','en'),(1017,1017,'Please save the soft reset and hard reset links so you can use them later in case your website crashes','en'),(1018,1018,'Please select one','en'),(1019,1019,'Pos','en'),(1020,1020,'Pos.','en'),(1021,1021,'Pos.:','en'),(1022,1022,'Position','en'),(1023,1023,'Prefix','en'),(1024,1024,'Pre-upgrade action required','en'),(1025,1025,'Some of the modules used by your store contain code that must be executed before the upgrade process begins. For the code to be executed successfully, the modules must be enabled. However, some of the modules containing such code are now disabled. This will prevent the pre-upgrade code from execution and is highly likely to cause problems, like a fatal error.<br /><br />Listed below are the modules that contain pre-upgrade code and are disabled. Here you can specify the modules for which you want the pre-upgrade code to be executed:','en'),(1026,1026,'Execute','en'),(1027,1027,'Do not execute','en'),(1028,1028,'Please note that we may not be held responsible for any upgrade problems caused by failure to execute the required pre-upgrade code.','en'),(1029,1029,'Prev','en'),(1030,1030,'Previous page','en'),(1031,1031,'Price modifier','en'),(1032,1032,'Price: Not a numeric value','en'),(1033,1033,'Price','en'),(1034,1034,'Name','en'),(1035,1035,'Primary menu','en'),(1036,1036,'Print invoice','en'),(1037,1037,'Processed','en'),(1038,1038,'Processed/Completed','en'),(1039,1039,'Product Name','en'),(1040,1040,'Product SKU','en'),(1041,1041,'Product Title','en'),(1042,1042,'Product has been added to your cart','en'),(1043,1043,'Product class','en'),(1044,1044,'Product classes','en'),(1045,1045,'Product has been added to your cart','en'),(1046,1046,'Product images','en'),(1047,1047,'Product info','en'),(1048,1048,'Product info has been updated successfully','en'),(1049,1049,'Product is out of stock','en'),(1050,1050,'Product on sale','en'),(1051,1051,'Product options','en'),(1052,1052,'Product page title','en'),(1053,1053,'Product prices are defined including this tax calculated for','en'),(1054,1054,'Products','en'),(1055,1055,'Products in cart','en'),(1056,1056,'Product information has been successfully updated','en'),(1057,1057,'Products with low inventory','en'),(1058,1058,'Profile','en'),(1059,1059,'The profile has been created successfully','en'),(1060,1060,'The profile has been deleted successfully','en'),(1061,1061,'The profile has been updated successfully','en'),(1062,1062,'Profile settings','en'),(1063,1063,'Promotions','en'),(1064,1064,'Properties','en'),(1065,1065,'Purchase','en'),(1066,1066,'Purchase SSL certificate','en'),(1067,1067,'PO number','en'),(1068,1068,'Put up selected for sale','en'),(1069,1069,'Qty','en'),(1070,1070,'Qty.','en'),(1071,1071,'Quantity: high to low','en'),(1072,1072,'Quantity: low to high','en'),(1073,1073,'Queued','en'),(1074,1074,'Quick and easy setup','en'),(1075,1075,'Rate','en'),(1076,1076,'Rates','en'),(1077,1077,'Rates / Conditions','en'),(1078,1078,'Raw online rate (on-line rate)','en'),(1079,1079,'Re-build cache','en'),(1080,1080,'Re-generate access key','en'),(1081,1081,'Re-order','en'),(1082,1082,'Redirect customers to HTTPS','en'),(1083,1083,'Recommended','en'),(1084,1084,'Referer','en'),(1085,1085,'Register','en'),(1086,1086,'Registered','en'),(1087,1087,'Remove','en'),(1088,1088,'Required','en'),(1089,1089,'Required PHP extensions are missing: {{extensions}}','en'),(1090,1090,'Some of them require a registered merchant account','en'),(1091,1091,'Re-run benchmark','en'),(1092,1092,'Resend the secret link to renew access','en'),(1093,1093,'Response from Marketplace not received','en'),(1094,1094,'Response from Marketplace: ','en'),(1095,1095,'Restore','en'),(1096,1096,'Restore database','en'),(1097,1097,'Restore from server','en'),(1098,1098,'Restore last backup','en'),(1099,1099,'Restore links','en'),(1100,1100,'Return to Drupal','en'),(1101,1101,'Revenue','en'),(1102,1102,'Review statistics on the various aspects of your store\'s operation','en'),(1103,1103,'Role','en'),(1104,1104,'Roles','en'),(1105,1105,'Root Level','en'),(1106,1106,'Root access','en'),(1107,1107,'Root category','en'),(1108,1108,'Run Benchmark again','en'),(1109,1109,'Run benchmark','en'),(1110,1110,'SKU: a-z','en'),(1111,1111,'SKU: z-a','en'),(1112,1112,'SMTP server','en'),(1113,1113,'STORE SETUP','en'),(1114,1114,'SYSTEM SETTINGS','en'),(1115,1115,'Safe mode','en'),(1116,1116,'Safe mode access key','en'),(1117,1117,'Sale','en'),(1118,1118,'Sale price','en'),(1119,1119,'Sale statistics since the opening of the store','en'),(1120,1120,'Sales','en'),(1121,1121,'Sales tax','en'),(1122,1122,'Save as new','en'),(1123,1123,'Save changes','en'),(1124,1124,'Save zone details','en'),(1125,1125,'Savings','en'),(1126,1126,'Search for modules','en'),(1127,1127,'Search for orders','en'),(1128,1128,'Search for users','en'),(1129,1129,'Search for users that are','en'),(1130,1130,'Search in subcategories','en'),(1131,1131,'Search product','en'),(1132,1132,'Search profiles','en'),(1133,1133,'Search result','en'),(1134,1134,'Search results','en'),(1135,1135,'Secure connection cannot be established.','en'),(1136,1136,'Security','en'),(1137,1137,'Security settings','en'),(1138,1138,'Select country','en'),(1139,1139,'Select options','en'),(1140,1140,'Select status','en'),(1141,1141,'Send','en'),(1142,1142,'Send test email','en'),(1143,1143,'Send to {{email}}','en'),(1144,1144,'SEO settings','en'),(1145,1145,'Service name','en'),(1146,1146,'Service name of address field','en'),(1147,1147,'Set','en'),(1148,1148,'Set the sale price','en'),(1149,1149,'Settings','en'),(1150,1150,'Set up <a href=\"{{URL1}}\">address zones</a> and <a href=\"{{URL2}}\">taxes</a>','en'),(1151,1151,'Shipping & Taxes','en'),(1152,1152,'Shipping address','en'),(1153,1153,'Shipping address is not completly defined yet','en'),(1154,1154,'Shipping address is not defined','en'),(1155,1155,'Shipping address is not defined yet','en'),(1156,1156,'Shipping info','en'),(1157,1157,'The shipping rate has been created successfully','en'),(1158,1158,'The shipping rates have been updated','en'),(1159,1159,'Shipping method','en'),(1160,1160,'The shipping method has been added','en'),(1161,1161,'Shipping methods','en'),(1162,1162,'Shipping methods are not available','en'),(1163,1163,'Shipping rates','en'),(1164,1164,'Shipping settings','en'),(1165,1165,'Address zones','en'),(1166,1166,'There\'s a minimum purchase limit of {{minQuantity}}. The number of units of the product \'{{productName}}\' in cart has been adjusted to reach this limit.','en'),(1167,1167,'There\'s a maximum purchase limit of {{maxQuantity}}. The number of units of the product \'{{productName}}\' in cart has been adjusted to reach this limit.','en'),(1168,1168,'Carrier','en'),(1169,1169,'Order tracking information','en'),(1170,1170,'Track package','en'),(1171,1171,'Send tracking info','en'),(1172,1172,'No tracking numbers are defined','en'),(1173,1173,'Tracking numbers','en'),(1174,1174,'\"{{number}}\" tracking number has been added','en'),(1175,1175,'\"{{number}}\" tracking number has been removed','en'),(1176,1176,'Tracking number has been changed from \"{{old_number}}\" to \"{{new_number}}\"','en'),(1177,1177,'Add tracking number','en'),(1178,1178,'Tracking information has been sent','en'),(1179,1179,'Shopping cart','en'),(1180,1180,'Show social buttons','en'),(1181,1181,'Sign in','en'),(1182,1182,'Sign out','en'),(1183,1183,'Size','en'),(1184,1184,'Common tax settings','en'),(1185,1185,'Hide settings','en'),(1186,1186,'Display settings','en'),(1187,1187,'Rename label','en'),(1188,1188,'<strong>Disables all modules except for the ones that were downloaded from the Marketplace</strong>(soft reset)','en'),(1189,1189,'Specify your <a href=\"{{URL}}\">store information</a>','en'),(1190,1190,'Speed up your store','en'),(1191,1191,'Start selling!','en'),(1192,1192,'State','en'),(1193,1193,'States','en'),(1194,1194,'The states have been deleted successfully','en'),(1195,1195,'The states have been updated successfully','en'),(1196,1196,'Statistics','en'),(1197,1197,'Status','en'),(1198,1198,'Store Maintenance','en'),(1199,1199,'Store currency','en'),(1200,1200,'Contact information','en'),(1201,1201,'Store is closed','en'),(1202,1202,'Store is open','en'),(1203,1203,'Store setup','en'),(1204,1204,'Storefront','en'),(1205,1205,'Subcategories','en'),(1206,1206,'Subject','en'),(1207,1207,'Substring','en'),(1208,1208,'Subtotal range (begin)','en'),(1209,1209,'Subtotal range (end)','en'),(1210,1210,'Successfully imported X new products','en'),(1211,1211,'Successfully imported X new products and updated Y existing products','en'),(1212,1212,'Successfully updated Y products','en'),(1213,1213,'Suffix','en'),(1214,1214,'Synchronous','en'),(1215,1215,'System settings','en'),(1216,1216,'Table','en'),(1217,1217,'Tax disabled','en'),(1218,1218,'Tax enabled','en'),(1219,1219,'The tax has been disabled successfully','en'),(1220,1220,'The tax has been enabled successfully','en'),(1221,1221,'The tax rates have been updated successfully','en'),(1222,1222,'Tax rate has been deleted successfully','en'),(1223,1223,'Tax rate has not been deleted','en'),(1224,1224,'Tax title','en'),(1225,1225,'Taxes','en'),(1226,1226,'Teaser','en'),(1227,1227,'Test email configuration','en'),(1228,1228,'Test shipping rates','en'),(1229,1229,'Tester','en'),(1230,1230,'Text','en'),(1231,1231,'Thank you for your order','en'),(1232,1232,'The SSL certificate installed for your custom website domain is not valid.','en'),(1233,1233,'The SSL certificate installed on your server is not valid. Although you can switch the store to use the secure protocol for the website pages, most Internet browsers will likely display a warning message scaring your website visitors away.','en'),(1234,1234,'The X language has been added and enabled successfully','en'),(1235,1235,'The attachment has been added successfully','en'),(1236,1236,'The changes will be applied to all selected products','en'),(1237,1237,'The detailed image has been added successfully','en'),(1238,1238,'The detailed image has been deleted','en'),(1239,1239,'The detailed images have been updated successfully','en'),(1240,1240,'The exceptions have been updated successfully','en'),(1241,1241,'To enable this add-on, the following add-on(s) must be enabled','en'),(1242,1242,'To enable this add-on, the following add-on(s) must be disabled','en'),(1243,1243,'The following categories were selected to be removed','en'),(1244,1244,'The following dependent add-ons will be disabled automatically','en'),(1245,1245,'The image has been updated','en'),(1246,1246,'The HTTPS protocol is enabled for your website','en'),(1247,1247,'The import is in progress','en'),(1248,1248,'The import will start immediately upon selecting the data file. No additional confirmation prompts will appear.','en'),(1249,1249,'The language you want to delete is the default application language and cannot be deleted','en'),(1250,1250,'The language you want to delete is the default interface language and cannot be deleted','en'),(1251,1251,'The maximum number of uses','en'),(1252,1252,'The module has been partially uninstalled','en'),(1253,1253,'The module is not compatible with your X-Cart version','en'),(1254,1254,'The page has been added','en'),(1255,1255,'The product option group has been added successfully','en'),(1256,1256,'The product option group has been updated successfully','en'),(1257,1257,'The product option groups have been updated successfully','en'),(1258,1258,'Failed to update the product option groups','en'),(1259,1259,'The requested page could not be found.','en'),(1260,1260,'Sorry, this page is no longer available.','en'),(1261,1261,'Sorry, this product is no longer available.','en'),(1262,1262,'Sorry, this category is no longer available.','en'),(1263,1263,'If you continue having trouble finding what you are looking for please contact our customer service department.','en'),(1264,1264,'Go to home page','en'),(1265,1265,'The restoration procedure is irreversible and erases all existing data tables from your store\'s database. It is highly recommended that you back up the data currently stored in the database before restoring a past version of your database from backup.','en'),(1266,1266,'The same as shipping','en'),(1267,1267,'The selected shipping rates have been deleted successfully','en'),(1268,1268,'The state has been added successfully','en'),(1269,1269,'The text label has not been added because its translation into the default application language has not been specified','en'),(1270,1270,'The text label has not been added because its translation into the default interface language has not been specified','en'),(1271,1271,'The text label has not been modified because its translation into the default application language has not been specified','en'),(1272,1272,'The text label has not been modified because its translation into the default interface language has not been specified','en'),(1273,1273,'The upgrade is completed. Please do not close this page until you check your web site and make sure that everything works properly','en'),(1274,1274,'There are no categories','en'),(1275,1275,'There are no rates selected','en'),(1276,1276,'There are no rates available for the specified source/destination and/or package measurements/weight.','en'),(1277,1277,'Find language in the marketplace','en'),(1278,1278,'There is no user with the specified email address','en'),(1279,1279,'There were no orders placed','en'),(1280,1280,'These components require your attention','en'),(1281,1281,'These components will be updated','en'),(1282,1282,'These instructions will appear below the order invoice on the page that customers see after they confirm their order.','en'),(1283,1283,'These links were already provided to you after this store was installed and will be emailed to you again after you start the upgrade process','en'),(1284,1284,'Please contact the module developers to make sure that these modules are compatible with the upcoming upgrade. We do not guarantee that the store will operate correctly if the modules remain enabled. Consider disabling the modules before you proceed to the next step.','en'),(1285,1285,'This address was used as a billing address during a recent purchase','en'),(1286,1286,'This address was used as a shipping address during a recent purchase','en'),(1287,1287,'This component is automatically calculated by a shipping add-on module and cannot be edited','en'),(1288,1288,'This email address is already in use by another user.','en'),(1289,1289,'This email address is used for an existing account. Enter another email address or sign in','en'),(1290,1290,'This is the default zone which covers all addresses. It is not possible to edit this zone\'s countries, states, etc.','en'),(1291,1291,'This month','en'),(1292,1292,'Once the links are regenerated, they will be sent to the store administrator email.','en'),(1293,1293,'After clicking this button, your hard/soft reset links will be regenerated. You may need this if your old links were compromised.','en'),(1294,1294,'This section displays order placement statistics','en'),(1295,1295,'This site requires JavaScript to function properly.','en'),(1296,1296,'This week','en'),(1297,1297,'This quarter','en'),(1298,1298,'This year','en'),(1299,1299,'Through','en'),(1300,1300,'Thumbnail','en'),(1301,1301,'Title','en'),(1302,1302,'New tax class','en'),(1303,1303,'Create zone','en'),(1304,1304,'Shipping / Payment info','en'),(1305,1305,'To contact us please use the form below','en'),(1306,1306,'To email','en'),(1307,1307,'To place the order please accept the Terms and Conditions','en'),(1308,1308,'To place the order please complete the previous steps first','en'),(1309,1309,'To reset your password, please enter the email address associated with your user account','en'),(1310,1310,'Today','en'),(1311,1311,'Best sellers','en'),(1312,1312,'Best sellers','en'),(1313,1313,'Translation driver','en'),(1314,1314,'Twitter','en'),(1315,1315,'Type','en'),(1316,1316,'Type of Account','en'),(1317,1317,'Admin has requested a change of password for your account. Please change the password before you proceed.','en'),(1318,1318,'The new password must not coincide with the current password for your account.','en'),(1319,1319,'Uncheck all','en'),(1320,1320,'Understanding Online Payments','en'),(1321,1321,'Error: Version value was not passed','en'),(1322,1322,'Uninstall','en'),(1323,1323,'Units & Formats','en'),(1324,1324,'Units of measurement','en'),(1325,1325,'Unknown','en'),(1326,1326,'Unpacking archives, please wait...','en'),(1327,1327,'Unset','en'),(1328,1328,'Update exceptions','en'),(1329,1329,'Update module','en'),(1330,1330,'Update product','en'),(1331,1331,'Update profile','en'),(1332,1332,'Updated components','en'),(1333,1333,'Updates are available','en'),(1334,1334,'Updates for the X-Cart core and/or installed modules are available','en'),(1335,1335,'Updates for your version ({{version}})','en'),(1336,1336,'Upgrade','en'),(1337,1337,'Upgrade is available','en'),(1338,1338,'Upgrade core','en'),(1339,1339,'Upgrade module','en'),(1340,1340,'Upgrade to version {{version}}','en'),(1341,1341,'Upload','en'),(1342,1342,'Upload add-on','en'),(1343,1343,'Upload and restore','en'),(1344,1344,'Upload file','en'),(1345,1345,'Use a merchant account from your financial institution or choose a bundled payment solution to accept credit cards and other methods of payment on your website.','en'),(1346,1346,'Use a merchant account from your financial institution to accept online payments','en'),(1347,1347,'Use custom js','en'),(1348,1348,'Use lazy loading','en'),(1349,1349,'Use default logo','en'),(1350,1350,'Use dynamic image resizing','en'),(1351,1351,'This setting determines what happens if X-Cart cannot find a previously generated resized version of an image it needs to display. If this setting is enabled, an appropriately sized version of the image is generated on the fly. If this setting is disabled, the original (non-resized) image is used.','en'),(1352,1352,'Use the category name','en'),(1353,1353,'Use the navigation bar above this dialog to navigate through the catalog categories','en'),(1354,1354,'Use this section to back up the database of your online store. Please note that the database backup procedure can take up to several minutes.','en'),(1355,1355,'Use this section to define address zones.','en'),(1356,1356,'Use this section to configure your store\'s shipping methods.','en'),(1357,1357,'Use this section to manage the list of existing countries. This list is used in the shipping settings and calculations, as well as in the registration form in the Customer area.','en'),(1358,1358,'Use this section to manage the lists of counties, provinces, regions and states of different countries. The lists are used in shipping settings and calculations, as well as in the registration form in the Customer area.','en'),(1359,1359,'Use this section to restore the database of your online store. Please note that the database restoration procedure can take up to several minutes','en'),(1360,1360,'Use this section to review the list of existing membership levels and add new ones','en'),(1361,1361,'User membership','en'),(1362,1362,'User type','en'),(1363,1363,'Username or email','en'),(1364,1364,'Users','en'),(1365,1365,'Uses count','en'),(1366,1366,'Uses left','en'),(1367,1367,'VAT','en'),(1368,1368,'Validate key','en'),(1369,1369,'Value','en'),(1370,1370,'Version','en'),(1371,1371,'Version change','en'),(1372,1372,'View all open orders','en'),(1373,1373,'View logs','en'),(1374,1374,'View profile','en'),(1375,1375,'View system logs','en'),(1376,1376,'View update log','en'),(1377,1377,'Visit module details page','en'),(1378,1378,'Visit storefront','en'),(1379,1379,'Volume discounts','en'),(1380,1380,'Warning','en'),(1381,1381,'Warning! Not enough items in stock for the order to be processed','en'),(1382,1382,'Warning: this operation cannot be reverted!','en'),(1383,1383,'Watch video','en'),(1384,1384,'Web server','en'),(1385,1385,'Weight modifier','en'),(1386,1386,'What is benchmark?','en'),(1387,1387,'After the export process has been completed, you will be prompted to download the product data file','en'),(1388,1388,'Width (px)','en'),(1389,1389,'Wrong method_id specifed','en'),(1390,1390,'Wrong value is specified for arrival date field. The field was not updated.','en'),(1391,1391,'X-Cart','en'),(1392,1392,'X-Cart online store builder','en'),(1393,1393,'X-Cart shopping cart software','en'),(1394,1394,'XML parser','en'),(1395,1395,'XML sitemap','en'),(1396,1396,'Yahoo!','en'),(1397,1397,'Yandex','en'),(1398,1398,'Yes','en'),(1399,1399,'Yes, I accept the License agreement','en'),(1400,1400,'You are not allowed to access this resource!','en'),(1401,1401,'Your access link has expired.','en'),(1402,1402,'It seems that your custom add-ons were developed for a specific version of X-Cart core. As a result, some adaptation of these add-ons may be required for the upcoming upgrade. Please contact your module developer to assist you with the adaptation.','en'),(1403,1403,'Unfortunately, you don\'t have permissions to access this page.','en'),(1404,1404,'To continue, please {{singin}}','en'),(1405,1405,'sign in','en'),(1406,1406,'Please <a href=\"{{contact_link}}\">contact the administrator</a>','en'),(1407,1407,'You have selected to delete your profile. Please confirm that you want to proceed','en'),(1408,1408,'PHP <a href=\'//php.net/phar\' target=\'_blank\'>.phar</b> extension is not enabled on your server. Here is a <a href=\'https://kb.x-cart.com/en/setting_up_x-cart_5_environment/setting_up_.phar.html\' target=\'_blank\'>manual</a> for setting up the extension.','en'),(1409,1409,'PHP cURL extension is not enabled on your server. Here is a <a href=\'https://kb.x-cart.com/en/setting_up_x-cart_5_environment/setting_up_curl.html\' target=\'_blank\'>manual</a> for setting up the extension.','en'),(1410,1410,'PHP openSSL extension is not enabled on your server. Here is a <a href=\'https://kb.x-cart.com/en/setting_up_x-cart_5_environment/setting_up_openssl.html\' target=\'_blank\'>manual</a> for setting up the extension.','en'),(1411,1411,'Your server does not have an SSL certificate. Ask your hosting team to install an SSL certificate or create a self-signed one according to this <a href=\'https://kb.x-cart.com/en/setting_up_x-cart_5_environment/creating_self-signed_ssl_certificate.html\' target=\'_blank\'>guide</a>.','en'),(1412,1412,'Previous attempt to connect to the Marketplace server failed.','en'),(1413,1413,'cURL returned an error while establishing a connection: {{error code}} {{error message}}','en'),(1414,1414,'After the problem has been fixed, try to <a href=\'{{clear_cache}}\'>connect</a> again.','en'),(1415,1415,'Require to change password on next log in','en'),(1416,1416,'Change password','en'),(1417,1417,'Your account information will be emailed to you shortly','en'),(1418,1418,'Your account information will be emailed to you shortly.','en'),(1419,1419,'Your email','en'),(1420,1420,'Your name','en'),(1421,1421,'Your products will be exported as a CSV file.','en'),(1422,1422,'Your cart is empty','en'),(1423,1423,'Your state','en'),(1424,1424,'Your storefront','en'),(1425,1425,'Your store is currently unable to calculate taxes','en'),(1426,1426,'Zip code','en'),(1427,1427,'Zip/postal code masks','en'),(1428,1428,'City masks','en'),(1429,1429,'Zone','en'),(1430,1430,'Zone name','en'),(1431,1431,'Zones','en'),(1432,1432,'and','en'),(1433,1433,'by','en'),(1434,1434,'details','en'),(1435,1435,'disabled','en'),(1436,1436,'downloads','en'),(1437,1437,'enabled','en'),(1438,1438,'from URL','en'),(1439,1439,'from local computer','en'),(1440,1440,'from local server','en'),(1441,1441,'hard reset','en'),(1442,1442,'in description','en'),(1443,1443,'in title','en'),(1444,1444,'is available','en'),(1445,1445,'items available','en'),(1446,1446,'less','en'),(1447,1447,'modules','en'),(1448,1448,'ms','en'),(1449,1449,'never','en'),(1450,1450,'none','en'),(1451,1451,'The following archives could not be unpacked: {{list}}','en'),(1452,1452,'Try to unpack them manually, then click on <a href=\'{{link}}\'>this link</a>.','en'),(1453,1453,'not available for sale','en'),(1454,1454,'not installed','en'),(1455,1455,'not ready to download packs. Please, try again','en'),(1456,1456,'of','en'),(1457,1457,'options','en'),(1458,1458,'or','en'),(1459,1459,'proxy','en'),(1460,1460,'sale','en'),(1461,1461,'should be performed manually','en'),(1462,1462,'soft reset','en'),(1463,1463,'trying to install a non-marketplace module: \"{{name}}\"','en'),(1464,1464,'trying to unpack non-downloaded archives','en'),(1465,1465,'Unable to install: The following archives could not be unpacked: {{list}}','en'),(1466,1466,'Unable to test files: The following archives could not be unpacked: {{list}}','en'),(1467,1467,'unknown','en'),(1468,1468,'you save','en'),(1469,1469,'Action \"{{class}}::{{action}}\", {{message}}','en'),(1470,1470,'The key has been validated, but the module {{module}} has not been found','en'),(1471,1471,'Response from Marketplace: {{response}}','en'),(1472,1472,'Please specify a non-empty key','en'),(1473,1473,'A DB error occurred while uninstalling the module \"{{name}}\"','en'),(1474,1474,'The module \"{{name}}\" has been uninstalled successfully','en'),(1475,1475,'Unable to delete the module \"{{name}}\" files: some dirs do not have write permissions: {{dirs}}','en'),(1476,1476,'License not received','en'),(1477,1477,'invalid module ID passed: \"{{moduleId}}\"','en'),(1478,1478,'unable to add module entry to the installation list: \"{{path}}\"','en'),(1479,1479,'module version \"{{module_version}}\" does not match the core version (\"{{core_version}}\")','en'),(1480,1480,'unable to upload the module','en'),(1481,1481,'The modules have been successfully installed','en'),(1482,1482,'{{ext}} file type','en'),(1483,1483,'Zone not found ({{zoneId}})','en'),(1484,1484,'The profiles have been merged','en'),(1485,1485,'The profile has been registered. The password has been sent to the user\'s email address','en'),(1486,1486,'<a href=\"terms-and-conditions.html\">Terms and conditions details</a><br /><br />Edit the \"Terms and conditions text\" label via the Admin area','en'),(1487,1487,'<span class=\"modules-amount\">{{count}}</span> addon(s) selected','en'),(1488,1488,'State cannot be created with an unknown country code ({{code}})','en'),(1489,1489,'There are no labels translated to {{language}}','en'),(1490,1490,'Module with ID \"{{id}}\" not found','en'),(1491,1491,'We are already aware of this problem and are working on it. If you would like to get in touch, feel free to contact us via our Help center at <a href=\"{{url}}\" target=\"_blank\">{{url}}</a>.','en'),(1492,1492,'The following expected input data has a wrong format or is empty: {{fields}}','en'),(1493,1493,'Unknown language: {{code}}','en'),(1494,1494,'deleted','en'),(1495,1495,'It is impossible to detect valid SSL certificate availability on your server because curl extension is not installed.','en'),(1496,1496,'Your store is configured to use the secure protocol for both the store’s back end and customer area.','en'),(1497,1497,'We have found a valid SSL certificate installed on the server. Now you can switch the store to use the secure protocol for the store\'s back end, checkout, sign-in and profile pages.','en'),(1498,1498,'Support','en'),(1499,1499,'After the upgrade is completed, please check your website. If you find that the site is not operating properly, please try the following','en'),(1500,1500,'Start Import','en'),(1501,1501,'New import','en'),(1502,1502,'Critical errors have been detected in the files you are trying to import. Check the manual to correct the errors and try again.','en'),(1503,1503,'Data has not been found','en'),(1504,1504,'Clear the item\'s data before importing this item','en'),(1505,1505,'Do not verify images to run the process faster','en'),(1506,1506,'Delete temporary files after the import is completed','en'),(1507,1507,'Import settings','en'),(1508,1508,'Upload files','en'),(1509,1509,'Samples of the file structures','en'),(1510,1510,'Continue import','en'),(1511,1511,'Re-upload files','en'),(1512,1512,'The import process may take a while to complete. You may close the page; the process will continue in the background. If the process takes long enough, we will send you a notification when it is completed.','en'),(1513,1513,'The import process may take a while to complete. Please do not close this page until the process is fully completed. If you have closed the page, please re-open it to complete the import process as it is in progress only when the page is open.','en'),(1514,1514,'Verification results','en'),(1515,1515,'Import by CSV','en'),(1516,1516,'Order by','en'),(1517,1517,'Query','en'),(1518,1518,'Count','en'),(1519,1519,'Products found','en'),(1520,1520,'Cleanup queries','en'),(1521,1521,'requested only once','en'),(1522,1522,'requested once or twice','en'),(1523,1523,'Cleanup','en'),(1524,1524,'The shipping rate has been added successfully','en'),(1525,1525,'The shipping rate cannot be added','en'),(1526,1526,'Please make sure that <b>\"min weight\", \"min total\", \"min items\", \"shipping zone\" and \"shipping method\"</b> fields do not overlap with those of any other shipping rates.','en'),(1527,1527,'Administrator area','en'),(1528,1528,'This section displays order processing statistics','en'),(1529,1529,'Compare your result with other servers','en'),(1530,1530,'The values are average','en'),(1531,1531,'Customer area is closed for maintenance.','en'),(1532,1532,'This page allows you to configure shipping methods, address zones and shipping charges.','en'),(1533,1533,'Shipping charges','en'),(1534,1534,'New address','en'),(1535,1535,'Forgot your password?','en'),(1536,1536,'No such user','en'),(1537,1537,'Edit attributes','en'),(1538,1538,'To set up attributes specific for product classes, define the product classes first.','en'),(1539,1539,'Here you can define attributes for all of your products and sets of attributes for different classes of your products.','en'),(1540,1540,'Here you can define how your payment methods will look in the Customer area.','en'),(1541,1541,'More payment methods can be added by installing appropriate payment modules. Check out the Marketplace to find and install the payment modules you require.','en'),(1542,1542,'Need more payment methods?','en'),(1543,1543,'Upload from server','en'),(1544,1544,'Upload from your computer','en'),(1545,1545,'Warning: The restoration procedure is irreversible and erases all existing data tables from the store\'s database. It is highly recommended that you back up the data currently stored in your database before restoring a past version of your database from backup.','en'),(1546,1546,'Also, if you want to upload the backup of <b>another</b> X-Cart installation, ensure that you have completed the steps described <a href=\'{{url}}\'>here</a>','en'),(1547,1547,'Use this section to back up the database of your online store. Please note that the database backup procedure can take up to several minutes.','en'),(1548,1548,'If you choose to create an SQL file, you will be able to download the file from the server later and, after that, delete it from the server using the \"Delete SQL file\" button.','en'),(1549,1549,'You cannot save database data to a file on the web server (\'var/backup/sqldump.sql.php\').','en'),(1550,1550,'The directory \'var/backup/\' does not exist or is not writable.','en'),(1551,1551,'Ship in a separate box','en'),(1552,1552,'You will be able to provide additional product info (images, attributes, etc.) after you submit this form.','en'),(1553,1553,'Clone this product','en'),(1554,1554,'Clone','en'),(1555,1555,'Preview product page','en'),(1556,1556,'Tax class','en'),(1557,1557,'There are no images loaded for this product','en'),(1558,1558,'No product class assigned','en'),(1559,1559,'Name, e.g. Apparel','en'),(1560,1560,'Manage product classes','en'),(1561,1561,'If you have multiple products sharing the same set of attributes, it makes sence to set up a common product type for these products and create the attributes on the product type level.','en'),(1562,1562,'Attribute option','en'),(1563,1563,'Modifiers','en'),(1564,1564,'Default option','en'),(1565,1565,'Length x Width x Height','en'),(1566,1566,'Maximum number of items per box','en'),(1567,1567,'Attribute name','en'),(1568,1568,'Attribute values','en'),(1569,1569,'Re-generate links','en'),(1570,1570,'Attribute group','en'),(1571,1571,'Attribute groups','en'),(1572,1572,'Attribute','en'),(1573,1573,'No group','en'),(1574,1574,'No attributes','en'),(1575,1575,'No attributes assigned','en'),(1576,1576,'Including subcategories','en'),(1577,1577,'The provided file contains the following language labels:','en'),(1578,1578,'The language labels have been successfully imported:','en'),(1579,1579,'Language:','en'),(1580,1580,'labels count:','en'),(1581,1581,'Number of ignored rows:','en'),(1582,1582,'Please confirm that you want to proceed with the import or cancel the operation.','en'),(1583,1583,'Failure: Wrong file format.','en'),(1584,1584,'The language CSV file should be a text file containing three columns per row (the columns must be separated by a comma:','en'),(1585,1585,'language code,','en'),(1586,1586,'label name,','en'),(1587,1587,'label translation.','en'),(1588,1588,'Please make sure your file format is as described.','en'),(1589,1589,'default','en'),(1590,1590,'Get CSV','en'),(1591,1591,'Not selected','en'),(1592,1592,'To change your roles, contact the store administrator','en'),(1593,1593,'You have the following roles:','en'),(1594,1594,'Welcome','en'),(1595,1595,'Edit attribute values','en'),(1596,1596,'Click if you do not want to add this value to new products or class assigns automatically','en'),(1597,1597,'Click if you want to add this value to new products or class assigns automatically','en'),(1598,1598,'Enabled in catalog','en'),(1599,1599,'Disabled in catalog','en'),(1600,1600,'What to export','en'),(1601,1601,'editable','en'),(1602,1602,'multi value','en'),(1603,1603,'Removing this attribute will affect all the products. Leave this blank to hide this option for the product.','en'),(1604,1604,'Delete all files','en'),(1605,1605,'Before editing attributes specific for the chosen type you should save the changes','en'),(1606,1606,'Default value','en'),(1607,1607,'Default attribute value','en'),(1608,1608,'Buyers can select an option','en'),(1609,1609,'No pre-defined value','en'),(1610,1610,'Whether customers should be able to select an option they require when ordering the product, or the information is provided purely as part of product specification. <br/>Default setting for new products. Does not change the configuration of products created previously.','en'),(1611,1611,'This value will be added to new products or class assigns automatically','en'),(1612,1612,'New value','en'),(1613,1613,'New group','en'),(1614,1614,'New Export','en'),(1615,1615,'The following files are too large to be included in the archive','en'),(1616,1616,'Start Export','en'),(1617,1617,'Export settings','en'),(1618,1618,'Export public files as','en'),(1619,1619,'URLs','en'),(1620,1620,'local files','en'),(1621,1621,'Choosing \"URLs\" will link the exported data to your public files (product and category images, downloadable files shown on product pages, and so on) through direct URLs. Public files won\'t be included into the archive with exported files; however, private files (for example, digitally distributed products) will go into the archive anyway.<br /><br />Choosing \"local files\" will provide file paths to your files, relative to your X-Cart installation.','en'),(1622,1622,'Download all files','en'),(1623,1623,'Exported files','en'),(1624,1624,'Export completed','en'),(1625,1625,'Exporting data...','en'),(1626,1626,'The export process may take a while to complete. You may close the page, the process will continue in the background. If the process takes long enough, we will send you a notification when it is completed.','en'),(1627,1627,'The export process may take a while to complete. Please do not close this page until the process is fully completed. If you have closed the page, please re-open it to complete the export process as it is in progress only when the page is open.','en'),(1628,1628,'Export failed','en'),(1629,1629,'Export was not started','en'),(1630,1630,'Export cannot be started because it is disabled or there is another running export process. Try again later.','en'),(1631,1631,'Export in CSV','en'),(1632,1632,'Please make sure the following modules are installed and enabled:','en'),(1633,1633,'You have no payment methods enabled at your store','en'),(1634,1634,'This method does not support the current store currency and is not available to customers','en'),(1635,1635,'This method is in test mode','en'),(1636,1636,'Configure','en'),(1637,1637,'This payment method cannot be enabled until you configure it','en'),(1638,1638,'Edit product','en'),(1639,1639,'There are no shipping methods defined for this carrier','en'),(1640,1640,'Click to edit rates','en'),(1641,1641,'Click to add rates','en'),(1642,1642,'Add rates','en'),(1643,1643,'Edit','en'),(1644,1644,'Click to edit states','en'),(1645,1645,'Click to add states','en'),(1646,1646,'Add states','en'),(1647,1647,'Add state','en'),(1648,1648,'Click to edit all the translations for this label','en'),(1649,1649,'Warning! Installing this module will overwrite any existing label translations for this language.','en'),(1650,1650,'Please','en'),(1651,1651,'upgrade core','en'),(1652,1652,'No modules found','en'),(1653,1653,'No users found','en'),(1654,1654,'No products found','en'),(1655,1655,'No profiles found','en'),(1656,1656,'Installed version','en'),(1657,1657,'outdated','en'),(1658,1658,'Purchased','en'),(1659,1659,'View in list','en'),(1660,1660,'Popularity','en'),(1661,1661,'Module\'s page','en'),(1662,1662,'Activate key','en'),(1663,1663,'if you have any questions','en'),(1664,1664,'Success','en'),(1665,1665,'Fax','en'),(1666,1666,'The shipping cost has been calculated based on the following combination of products into packages:','en'),(1667,1667,'Package','en'),(1668,1668,'weight','en'),(1669,1669,'dimensions','en'),(1670,1670,'item(s)','en'),(1671,1671,'Placed on','en'),(1672,1672,'OR','en'),(1673,1673,'Root categories','en'),(1674,1674,'WARNING! There are no more available administrator profiles. You will not be able to manage your store after you delete this profile.','en'),(1675,1675,'Are you sure you want to delete this profile?','en'),(1676,1676,'Autogenerate Clean URL','en'),(1677,1677,'products','en'),(1678,1678,'Already added','en'),(1679,1679,'Edit attribute','en'),(1680,1680,'New attribute','en'),(1681,1681,'Manage groups','en'),(1682,1682,'No attributes are defined for the product class yet.','en'),(1683,1683,'Need a license key?','en'),(1684,1684,'Your X-Cart installation is licensed for evaluation purposes only.','en'),(1685,1685,'You can build your website during FREE evaluation, but you cannot use this installation for real sales without buying a license.','en'),(1686,1686,'For details refer to','en'),(1687,1687,'Removing this message without buying a Full license is prohibited and will result in legal proceedings.','en'),(1688,1688,'Core version','en'),(1689,1689,'verified version','en'),(1690,1690,'Loopback test','en'),(1691,1691,'Warning! InnoDB engine is not supported. It is required for software operation','en'),(1692,1692,'Not detected','en'),(1693,1693,'Warning!','en'),(1694,1694,'PHP \'gd\' extension is not installed.','en'),(1695,1695,'Curl version','en'),(1696,1696,'Curl options','en'),(1697,1697,'cannot create directory','en'),(1698,1698,'subdirectories problems','en'),(1699,1699,'file does not exist','en'),(1700,1700,'Directory is empty','en'),(1701,1701,'Comma','en'),(1702,1702,'Semicolon','en'),(1703,1703,'Tab','en'),(1704,1704,'A membership name cannot contain such symbols as \\, \' and \". Also, it cannot exceed 32 characters.','en'),(1705,1705,'Please enter a unique membership name','en'),(1706,1706,'Required field','en'),(1707,1707,'The value must be in the range of','en'),(1708,1708,'Click to open','en'),(1709,1709,'Click to close','en'),(1710,1710,'Double quote','en'),(1711,1711,'Single quote','en'),(1712,1712,'empty','en'),(1713,1713,'Warning! CSV file was not specified.','en'),(1714,1714,'Warning! The file you have specified in the \'File (CSV) local\' field does not exist or cannot be read.','en'),(1715,1715,'Please enter the correct file location or set correct file permissions.','en'),(1716,1716,'Warning! The file you have specified in the \'File (CSV) for upload\' field has not been uploaded to the server.','en'),(1717,1717,'Already exists','en'),(1718,1718,'Confirmation does not match','en'),(1719,1719,'Incomplete','en'),(1720,1720,'Complete','en'),(1721,1721,'Please, enter a valid email address','en'),(1722,1722,'Please, enter a valid IP address','en'),(1723,1723,'Result pages','en'),(1724,1724,'User activity','en'),(1725,1725,'now disabled','en'),(1726,1726,'Upgrade for X-Cart core is available','en'),(1727,1727,'Now disabled','en'),(1728,1728,'Will be installed','en'),(1729,1729,'The module is incompatible with the new core version that is going to be installed','en'),(1730,1730,'Check again','en'),(1731,1731,'Failure','en'),(1732,1732,'An upgrade is a dangerous process that may result in a crashed website. It is strongly recommended to create a full back up of your store (the code and the database) and download it to a local computer before you proceed to the next step.','en'),(1733,1733,'Some files are modified','en'),(1734,1734,'The system has detected that some custom modifications were made by editing core and module files, not by writing new modules. In order to proceed with the upgrade you should decide what to do with the modifications','en'),(1735,1735,'Replace all modified files with the unmodified newer versions','en'),(1736,1736,'the custom modifications will be lost','en'),(1737,1737,'Do not replace selected files and ignore their newer versions','en'),(1738,1738,'your web site may crash','en'),(1739,1739,'Select all','en'),(1740,1740,'Unselect all','en'),(1741,1741,'New user registered','en'),(1742,1742,'Website','en'),(1743,1743,'Last 24 hours','en'),(1744,1744,'Last 7 days','en'),(1745,1745,'Last month','en'),(1746,1746,'Store lifetime','en'),(1747,1747,'View all','en'),(1748,1748,'Changes of attribute values will affect only this product. Changes of attribute names and of the attribute list will affect all the products of the corresponding class.','en'),(1749,1749,'Changes of attribute values will affect only this product. Changes of attribute names and of the attribute list will affect all the products','en'),(1750,1750,'Apply value changes locally','en'),(1751,1751,'Apply value changes globally','en'),(1752,1752,'The password is the one you specified during checkout.','en'),(1753,1753,'The password is the one you specified.','en'),(1754,1754,'Register user','en'),(1755,1755,'Test email notification','en'),(1756,1756,'Test email notification:','en'),(1757,1757,'Your new password','en'),(1758,1758,'You can now use the following credentials to access your account','en'),(1759,1759,'To change the password, log into your company account and use the \'My account\' link','en'),(1760,1760,'New safe mode access key has been generated','en'),(1761,1761,'Use the following key to access safe mode','en'),(1762,1762,'Hard reset (disables all the installed modules and runs the X-Cart application)','en'),(1763,1763,'Soft reset (disables all the modules except for the ones that were downloaded from X-Cart\'s Marketplace and runs the X-Cart application)','en'),(1764,1764,'The export is complete.','en'),(1765,1765,'Totals','en'),(1766,1766,'Your profile was modified','en'),(1767,1767,'A user has submitted the Contact Us form','en'),(1768,1768,'Product ID','en'),(1769,1769,'item(s) in stock','en'),(1770,1770,'Are you sure you want to clear your cart?','en'),(1771,1771,'attributes','en'),(1772,1772,'All rights reserved.','en'),(1773,1773,'Addresses list is empty','en'),(1774,1774,'Order payment','en'),(1775,1775,'Forgot password','en'),(1776,1776,'Max','en'),(1777,1777,'Exact phrase','en'),(1778,1778,'All words','en'),(1779,1779,'Any word','en'),(1780,1780,'Fewer search options','en'),(1781,1781,'More search options','en'),(1782,1782,'- OR -','en'),(1783,1783,'Back to Login form','en'),(1784,1784,'Back to modules','en'),(1785,1785,'Try the search-as-you-type feature...','en'),(1786,1786,'Choose the product options first','en'),(1787,1787,'This operation is irreversible. Are you sure you want to proceed?','en'),(1788,1788,'Order number','en'),(1789,1789,'Date range','en'),(1790,1790,'Clear all fields','en'),(1791,1791,'There are no shipping methods available','en'),(1792,1792,'Enter the shipping address to see delivery methods available to you','en'),(1793,1793,'C.O.D. fee included','en'),(1794,1794,'Existing Customer?','en'),(1795,1795,'Login Here','en'),(1796,1796,'Sorry, your order payment was cancelled.','en'),(1797,1797,'Sorry, your order payment failed.','en'),(1798,1798,'Failure reason:','en'),(1799,1799,'Cardholder name','en'),(1800,1800,'Credit card number','en'),(1801,1801,'Start date','en'),(1802,1802,'Expiration date','en'),(1803,1803,'Issue no','en'),(1804,1804,'CVV2','en'),(1805,1805,'Change attributes','en'),(1806,1806,'Call us: ','en'),(1807,1807,'Compare products','en'),(1808,1808,'Email','en'),(1809,1809,'This address was used as a','en'),(1810,1810,'billing','en'),(1811,1811,'shipping','en'),(1812,1812,'address during the recent purchase','en'),(1813,1813,'Out of Stock','en'),(1814,1814,'Cart','en'),(1815,1815,'More','en'),(1816,1816,'Back','en'),(1817,1817,'Your Account','en'),(1818,1818,'See comparison chart','en'),(1819,1819,'Billing address is the same as Shipping','en'),(1820,1820,'Complete billing address','en'),(1821,1821,'Continue as guest','en'),(1822,1822,'Enter your email','en'),(1823,1823,'Order cannot be placed because not all of the required fields are completed. Please check the form and try again.','en'),(1824,1824,'The \"{{file}}\" file was not uploaded','en'),(1825,1825,'Front page','en'),(1826,1826,'Please select the products first','en'),(1827,1827,'Aggregation cache has been cleared','en'),(1828,1828,'Authorized amount','en'),(1829,1829,'Captured amount','en'),(1830,1830,'Refunded amount','en'),(1831,1831,'The method is not configured and cannot be used','en'),(1832,1832,'The only remaining active administrator profile cannot be deleted.','en'),(1833,1833,'Shipping address is invalid','en'),(1834,1834,'Invoice #{{orderId}}, {{time}}','en'),(1835,1835,'Address type has a wrong value','en'),(1836,1836,'Address not selected','en'),(1837,1837,'Address not found','en'),(1838,1838,'\"{{product}} product\" attributes','en'),(1839,1839,'The attributes have been successfully updated','en'),(1840,1840,'Please select a different attribute','en'),(1841,1841,'The address has been deleted','en'),(1842,1842,'You tried to buy more items of \"{{product}}\" product {{description}} than are in stock. We have {{amount}} item(s) only. Please adjust the product quantity.','en'),(1843,1843,'The product has not been added to cart','en'),(1844,1844,'The item has not been removed from cart','en'),(1845,1845,'You have an unpaid order #{{ORDER}}','en'),(1846,1846,'Order not found','en'),(1847,1847,'No payment method selected','en'),(1848,1848,'No payment methods found for criteria: \'{{substring}}\' / {{country}}.','en'),(1849,1849,'All countries','en'),(1850,1850,'System will download and install this module from marketplace. Continue?','en'),(1851,1851,'Try to change the search criteria or find the needed solution in <a href=\"{{URL}}\" class=\"no-payments-marketplace-link\">marketplace</a>','en'),(1852,1852,'Please let us know if you want to <a target=\"_blank\" href=\"{{URL}}\">suggest an idea</a> or <a target=\"_blank\" href=\"{{URL}}\">contact us</a> for a free quote for custom development service.','en'),(1853,1853,'The selected payment method is obsolete or invalid. Select another payment method','en'),(1854,1854,'The form has expired and has been blocked. It seems that the page with the form may have been opened in more than one tab or remained unused for too long. Do not worry, such application behavior is used for security reasons to keep your business safe.','en'),(1855,1855,'Select products from the list','en'),(1856,1856,'Classes & attributes','en'),(1857,1857,'No category defined','en'),(1858,1858,'Safe mode access key has been re-generated','en'),(1859,1859,'{{paymentMethod}} settings','en'),(1860,1860,'An attempt to update settings of unknown payment method','en'),(1861,1861,'The payment method settings have been successfully updated','en'),(1862,1862,'The \"{{file}}\" is not CSV or archive','en'),(1863,1863,'Unable to delete file','en'),(1864,1864,'SQL file was deleted successfully','en'),(1865,1865,'File not found','en'),(1866,1866,'Only enabled modules can be packed','en'),(1867,1867,'Module packing is available in the DEVELOPER mode only. Check etc/config.php file','en'),(1868,1868,'The countries list for the zone is empty. Please specify the countries that belong in this zone.','en'),(1869,1869,'unknown error','en'),(1870,1870,'The payment method has been added successfully','en'),(1871,1871,'Manage attribute groups','en'),(1872,1872,'Measuring performance in manual mode failed.','en'),(1873,1873,'File uploading error.','en'),(1874,1874,'Making a backup of the current database state ... ','en'),(1875,1875,'done','en'),(1876,1876,'Loading the database from file .','en'),(1877,1877,'Database restored successfully!','en'),(1878,1878,'The database has not been restored because of errors','en'),(1879,1879,'Restoring database from backup .','en'),(1880,1880,'Return to Admin interface','en'),(1881,1881,'Global attributes','en'),(1882,1882,'Global','en'),(1883,1883,'Widgets cache has been cleared','en'),(1884,1884,'Widgets cache has not been cleaned completely','en'),(1885,1885,'Failed to update category image','en'),(1886,1886,'The file was not loaded due to a server-side failure.','en'),(1887,1887,'Tax classes','en'),(1888,1888,'The detailed image has not been deleted','en'),(1889,1889,'Attributes have been updated successfully','en'),(1890,1890,'Product class have been updated successfully','en'),(1891,1891,'Product class name is empty','en'),(1892,1892,'Product-Specific','en'),(1893,1893,'Product-Specific attributes','en'),(1894,1894,'A disabled language cannot be default.','en'),(1895,1895,'Cannot autogenerate a clean URL for the product name \"{{name}}\". Please specify it manually.','en'),(1896,1896,'HTTPS option has been successfully enabled','en'),(1897,1897,'HTTPS option has been disabled','en'),(1898,1898,'Inventory has been successfully updated','en'),(1899,1899,'Modules license agreements','en'),(1900,1900,'{{module}} license agreement','en'),(1901,1901,'Customers','en'),(1902,1902,'Customers imported','en'),(1903,1903,'Products imported','en'),(1904,1904,'Attributes imported','en'),(1905,1905,'Categories imported','en'),(1906,1906,'Failed write to file','en'),(1907,1907,'No write permissions to directory','en'),(1908,1908,'Add attribute','en'),(1909,1909,'Default for customers','en'),(1910,1910,'Default for admins','en'),(1911,1911,'Labels','en'),(1912,1912,'Custom','en'),(1913,1913,'Recommended','en'),(1914,1914,'By Price - cheapest first','en'),(1915,1915,'By Price - cheapest last','en'),(1916,1916,'By Name - A-Z','en'),(1917,1917,'By Name - Z-A','en'),(1918,1918,'Displays the number of labels translated into the language','en'),(1919,1919,'Label','en'),(1920,1920,'Plain field','en'),(1921,1921,'Hidden attributes','en'),(1922,1922,'Hidden field','en'),(1923,1923,'-- empty --','en'),(1924,1924,'Textarea','en'),(1925,1925,'Order history','en'),(1926,1926,'Compact view','en'),(1927,1927,'Expanded view','en'),(1928,1928,'Item','en'),(1929,1929,'Yes/No','en'),(1930,1930,'In stock','en'),(1931,1931,'Login/Email','en'),(1932,1932,'Anonymous','en'),(1933,1933,'requested for','en'),(1934,1934,'<p>The order subtotal exceeds the maximum allowed value ({{max_order_amount}})</p>','en'),(1935,1935,'<p>The order subtotal is less than the minimum allowed value ({{min_order_amount}})</p>','en'),(1936,1936,'View all addons','en'),(1937,1937,'Storefront is closed','en'),(1938,1938,'Open','en'),(1939,1939,'Storefront is open','en'),(1940,1940,'Closed','en'),(1941,1941,'The attribute group has been updated','en'),(1942,1942,'The attribute group has been added','en'),(1943,1943,'The attribute option has been updated','en'),(1944,1944,'The attribute option has been added','en'),(1945,1945,'The category has been updated','en'),(1946,1946,'The category has been added','en'),(1947,1947,'The address field has been updated','en'),(1948,1948,'The address field has been added','en'),(1949,1949,'The attribute has been updated','en'),(1950,1950,'The attribute has been added','en'),(1951,1951,'The product class has been updated','en'),(1952,1952,'The product class has been added','en'),(1953,1953,'The product selection has been updated','en'),(1954,1954,'The product selection has been added','en'),(1955,1955,'Front page updated','en'),(1956,1956,'The profile has been modified successfully','en'),(1957,1957,'The tax class has been updated','en'),(1958,1958,'The tax class has been added','en'),(1959,1959,'Order #{{id}}','en'),(1960,1960,'Enter pattern here','en'),(1961,1961,'Find countries','en'),(1962,1962,'Find states','en'),(1963,1963,'Enter search pattern','en'),(1964,1964,'Import language from CSV file','en'),(1965,1965,'Requested zone does not exist','en'),(1966,1966,'Install addons','en'),(1967,1967,'Add products','en'),(1968,1968,'More actions for selected','en'),(1969,1969,'Order #{{id}} details','en'),(1970,1970,'Your order details will be sent to your email address','en'),(1971,1971,'{{count}} created','en'),(1972,1972,'{{count}} updated','en'),(1973,1973,'The script found {{number}} problem(s) during verification','en'),(1974,1974,'The script found {{number}} problem(s) during import','en'),(1975,1975,'Row {{number}}','en'),(1976,1976,'Row(s) {{numbers}}','en'),(1977,1977,'Critical error','en'),(1978,1978,'Import mode','en'),(1979,1979,'Create new items and update existing items','en'),(1980,1980,'Update existing items, but skip new items','en'),(1981,1981,'During import in the <strong>\'Create new items and update existing items\'</strong> mode, if your import file contains items that do not already exist in the store\'s database, these items will be created as a result of import. New items can be created based on the following master IDs:<ul>{{keys}}</ul>If you only want to update the existing items without creating any new ones, switch to the mode <strong>\'Update existing items, but skip new items\'</strong>.<br /><br />Note that any missing items that are dependent on existing items will be created in both the modes. For example, if an existing product being updated through import does not have a category specified, the category will be created.','en'),(1982,1982,'CSV or ZIP files, total max size: {{size}}','en'),(1983,1983,'Download CSV files','en'),(1984,1984,'<p>The order subtotal exceeds the maximum allowed value ({{max_order_amount}}). Please remove some items from the cart.</p>','en'),(1985,1985,'<p>The order subtotal is less than the minimum allowed value ({{min_order_amount}}). Please add some items to the cart.</p>','en'),(1986,1986,'{{name}} attributes','en'),(1987,1987,'Custom attributes','en'),(1988,1988,'These attributes can be applied to the \"{{name}}\" product class.','en'),(1989,1989,'These attributes can only be applied to this particular product.','en'),(1990,1990,'These attributes can be applied to all the products in the store.','en'),(1991,1991,'Your trial period has expired','en'),(1992,1992,'Your trial period expires today','en'),(1993,1993,'Live','en'),(1994,1994,'Print','en'),(1995,1995,'Print selected','en'),(1996,1996,'Test','en'),(1997,1997,'Residential','en'),(1998,1998,'Commercial','en'),(1999,1999,'No delimiter','en'),(2000,2000,'Space','en'),(2001,2001,'MM','en'),(2002,2002,'CM','en'),(2003,2003,'DM','en'),(2004,2004,'IN','en'),(2005,2005,'mm','en'),(2006,2006,'cm','en'),(2007,2007,'dm','en'),(2008,2008,'inches','en'),(2009,2009,'Mr.','en'),(2010,2010,'Ms.','en'),(2011,2011,'Mrs.','en'),(2012,2012,'# selected','en'),(2013,2013,'LB','en'),(2014,2014,'OZ','en'),(2015,2015,'KG','en'),(2016,2016,'G','en'),(2017,2017,'lbs','en'),(2018,2018,'oz','en'),(2019,2019,'kg','en'),(2020,2020,'g','en'),(2021,2021,'Registered Customers','en'),(2022,2022,'Anonymous Customers','en'),(2023,2023,'Show','en'),(2024,2024,'Email again','en'),(2025,2025,'Safe mode links were emailed','en'),(2026,2026,'These links were already provided to you after this store was installed and will be emailed to you again after you start the upgrade process.','en'),(2027,2027,'For any emergency you can use the hard, soft and restore-state links. Pay attention, that these links just disable certain modules in your store, but not make any backups.','en'),(2028,2028,'Not enough disk space. Required: {{req}} (+{{reserve}} reserve). Available: {{avail}}','en'),(2029,2029,'Cannot connect to the Marketplace server','en'),(2030,2030,'Empty \"class\" parameter is passed to the {{method}}','en'),(2031,2031,'You need hard and soft reset links in case some 3rd party addon <a href=\"{{article}}\" target=\"_blank\">crashes your web store</a>','en'),(2032,2032,'We strongly recommend <b>to make a full backup</b> of your live store before starting the upgrade process. If your store crashes as a result of a failed upgrade, you will be able to <a href=\"{{article}}\" target=\"_blank\">restore it</a> from backup.','en'),(2033,2033,'Don’t forget to create a backup!','en'),(2034,2034,'Backup your store with Backup Master','en'),(2035,2035,'Yes, I\'ve made the full backup of my store files and database','en'),(2036,2036,'We are doing our best to make your upgrade process not only easy to do, but safe.','en'),(2037,2037,'Use our new nifty module to automatically backup your store and be able to restore it if anything crops up.','en'),(2038,2038,'We will email you with <b>emergency links</b> to disable custom modules and stay only with original add-ons.<br/> Pay attention, these links do not create backups.','en'),(2039,2039,'More info is available in X-Cart\'s Knowledge Base article <a href=\"{{article}}\" target=\"_blank\">What to do if you cannot access your store...</a>','en'),(2040,2040,'Couldn\'t move image {{path}}','en'),(2041,2041,'Couldn\'t move {{count}} images. See log for details.','en'),(2042,2042,'This module uses PHP\'s cURL functions which are disabled on your web server','en'),(2043,2043,'Package weight','en'),(2044,2044,'Package weight ({{units}})','en'),(2045,2045,'Package subtotal','en'),(2046,2046,'Package subtotal ({{units}})','en'),(2047,2047,'Source address','en'),(2048,2048,'Postal Code','en'),(2049,2049,'Destination address','en'),(2050,2050,'Note: a new window will be opened','en'),(2051,2051,'Length','en'),(2052,2052,'Width','en'),(2053,2053,'Height','en'),(2054,2054,'Postal/ZIP Code','en'),(2055,2055,'Transaction type','en'),(2056,2056,'Authorization and Capture','en'),(2057,2057,'Authorization only','en'),(2058,2058,'Invoice number prefix','en'),(2059,2059,'a side box','en'),(2060,2060,'the main column','en'),(2061,2061,'expired','en'),(2062,2062,'\"{{product}}\" options','en'),(2063,2063,'Private','en'),(2064,2064,'Unavailable','en'),(2065,2065,'Blocked','en'),(2066,2066,'The product SKU#\"{{SKU}}\" is already set as featured for the category','en'),(2067,2067,'Add featured products for \"{{category}}\"','en'),(2068,2068,'Package properties','en'),(2069,2069,'Shipment options','en'),(2070,2070,'Cash on delivery','en'),(2071,2071,'Test mode','en'),(2072,2072,'Packaging','en'),(2073,2073,'Package dimensions (inches)','en'),(2074,2074,'Autogenerated','en'),(2075,2075,'Custom','en'),(2076,2076,'After activation Skrill will give you access to a new section in your Skrill account called \"Merchant tools\". Please choose a secret word (do not use your password for this) and enter it into the Merchant tools section and the form below.','en'),(2077,2077,'(optional)','en'),(2078,2078,'Request type must be POST','en'),(2079,2079,'\'status\' request argument not found','en'),(2080,2080,'Test/Live mode','en'),(2081,2081,'Purchase description','en'),(2082,2082,'Live mode','en'),(2083,2083,'User','en'),(2084,2084,'\'RESULT\' argument not found','en'),(2085,2085,'Transaction amount mismatch','en'),(2086,2086,'Compare','en'),(2087,2087,'Billing address is not defined','en'),(2088,2088,'Menu','en'),(2089,2089,'Unlimited','en'),(2090,2090,'Locked','en'),(2091,2091,'Secret word','en'),(2092,2092,'units','en'),(2093,2093,'each','en'),(2094,2094,'save','en'),(2095,2095,'always','en'),(2096,2096,'hourly','en'),(2097,2097,'daily','en'),(2098,2098,'weekly','en'),(2099,2099,'monthly','en'),(2100,2100,'yearly','en'),(2101,2101,'Auth','en'),(2102,2102,'Capture','en'),(2103,2103,'Void','en'),(2104,2104,'Refund','en'),(2105,2105,'Deploy','en'),(2106,2106,'Secret key','en'),(2107,2107,'Order status changed from {{oldStatus}} to {{newStatus}}','en'),(2108,2108,'Year in which the store opened','en'),(2109,2109,'Force customer to choose product options before adding a product to cart','en'),(2110,2110,'The English language cannot be removed as it is primary language for all texts.','en'),(2111,2111,'Priority','en'),(2112,2112,'Either enable or uninstall the modules below.','en'),(2113,2113,'For the modules named below, an upgrade is available. These modules are now disabled. For the upgrade to be applied successfully to these modules, the modules need to be enabled. You can enable the modules <a href=\'{{link}}\'>here</a>. If you choose not to enable the modules, they will be uninstalled and removed from your store during the upgrade.','en'),(2114,2114,'I understand that <a href=\'#modules_to_uninstall\'>the following disabled modules</a> will be removed.','en'),(2115,2115,'The module version is incompatible with your core version and cannot be installed. The minimum core version required for this module is {{version}}.','en'),(2116,2116,'The module version is incompatible with your core version and cannot be enabled. The minimum core version required for this module is {{version}}.','en'),(2117,2117,'New module version available for core versions {{versions}}.','en'),(2118,2118,'Payment status','en'),(2119,2119,'Fulfilment status','en'),(2120,2120,'All payment statuses','en'),(2121,2121,'All fulfilment statuses','en'),(2122,2122,'Order payment status changed from {{oldStatus}} to {{newStatus}}','en'),(2123,2123,'Order fulfilment status changed from {{oldStatus}} to {{newStatus}}','en'),(2124,2124,'Communication log','en'),(2125,2125,'Input data','en'),(2126,2126,'Please create a new password','en'),(2127,2127,'The confirmation URL link will be emailed to you shortly','en'),(2128,2128,'Your \"Password reset key\" has expired. Please enter the email address associated with your user account to get a new \"Password reset key\".','en'),(2129,2129,'Profile is not defined','en'),(2130,2130,'Customer access level','en'),(2131,2131,'All levels','en'),(2132,2132,'Anonymous','en'),(2133,2133,'Registered','en'),(2134,2134,'Search total','en'),(2135,2135,'All orders','en'),(2136,2136,'Online orders','en'),(2137,2137,'POS orders','en'),(2138,2138,'Do not see your payment method? Find it in our <a href=\"{{url}}\">Marketplace</a>','en'),(2139,2139,'Find in Marketplace','en'),(2140,2140,'Search items...','en'),(2141,2141,'Root category listings format','en'),(2142,2142,'View all ordered items','en'),(2143,2143,'Lines checked: {{X}} out of {{Y}}','en'),(2144,2144,'Lines imported: {{X}} out of {{Y}}','en'),(2145,2145,'Products processed: {{X}} out of {{Y}}','en'),(2146,2146,'Image resized: {{X}} out of {{Y}}','en'),(2147,2147,'Lines verified: {{X}} out of {{Y}} (errors: {{errors}}, warnings: {{warns}})','en'),(2148,2148,'Lines imported: {{X}} out of {{Y}} (errors: {{errors}}, warnings: {{warns}})','en'),(2149,2149,'Products processed: {{X}} out of {{Y}} (errors: {{errors}}, warnings: {{warns}})','en'),(2150,2150,'Image resized: {{X}} out of {{Y}} (errors: {{errors}}, warnings: {{warns}})','en'),(2151,2151,'Import has been cancelled.','en'),(2152,2152,'Export product data with','en'),(2153,2153,'Global & Classes attributes','en'),(2154,2154,'All attributes','en'),(2155,2155,'Classes & Attributes','en'),(2156,2156,'Product attribute values','en'),(2157,2157,'Product attribute values (Yes/No) have been imported','en'),(2158,2158,'Product attribute values (Plain text) have been imported','en'),(2159,2159,'Product attribute values (Textarea) have been imported','en'),(2160,2160,'Product attribute values (Hidden field) have been imported','en'),(2161,2161,'CSV file has a wrong filename format.','en'),(2162,2162,'Possible file names are: {{files}}','en'),(2163,2163,'X-Cart could not find data in your file.','en'),(2164,2164,'Possible reasons are:<br /><ul><li>file is empty</li><li>you specified CSV delimiter other than defined in settings ({{separator}}). In this case, define the correct delimiter in the <strong>CSV column delimiter</strong> on the <a href=\"{{configURL}}\">Localization settings page</a>.</li><li>encoding of your file is not {{encoding}}. In this case, you need to open your CSV file in the spreadsheet editor (MS Excel, Openoffice Calc, etc) and save it using UTF-8 charset.</li><li>your CSV file has an incorrect format. <a href=\"{{kbURL}}\" target=\"blank\">Check our Knowledge base</a> for proper import formats.</li></ul>','en'),(2165,2165,'Your store has some modules available only to Premium license owners. To continue with the upgrade, you must either <a href=\'{{purchaseURL}}\' target=\'_blank\'>purchase</a> a Premium license, or <a href=\'{{installedModulesURL}}\'>remove</a> the following modules from your store:','en'),(2166,2166,'No class','en'),(2167,2167,'See log file for details','en'),(2168,2168,'The product has been updated','en'),(2169,2169,'Free license has been activated successfully','en'),(2170,2170,'Unknown payment. If you see this message after returning from the payment page, please contact the store administrator for information about the status of your payment.','en'),(2171,2171,'{{count}} expired shopping cart(s) have been successfully removed','en'),(2172,2172,'States information has been successfully deleted','en'),(2173,2173,'Please select the states first','en'),(2174,2174,'<p>Cart contains products with a wrong quantity. Please correct this to proceed</p>','en'),(2175,2175,'<p>Cart contains products with a wrong quantity</p>','en'),(2176,2176,'Inventory tracking options','en'),(2177,2177,'Do not select anything if you want to make the product visible to all customers. Otherwise it will be visible to the users assigned to selected membership only.','en'),(2178,2178,'Any stock status','en'),(2179,2179,'Test','en'),(2180,2180,'Live','en'),(2181,2181,'The service name \'{{value}}\' is reserved and cannot be used for an address field.','en'),(2182,2182,'Placed on <span class=\"date\">{{date}}</span>','en'),(2183,2183,'by <a class=\"name\" href=\"{{url}}\">{{name}}</a>','en'),(2184,2184,'by <span class=\"name\">{{name}}</span>','en'),(2185,2185,'Setup store price: {{price}}','en'),(2186,2186,'The button is inactive either because no changes have been detected on the current page or because the order totals need to be recalculated before the order can be updated.','en'),(2187,2187,'Product with selected properties cannot be purchased','en'),(2188,2188,'The specified amount of the product ({{value}}) exceeds the amount of the product in stock ({{max}})','en'),(2189,2189,'Old staff note','en'),(2190,2190,'New staff note','en'),(2191,2191,'Current price for the selected configuration and quantity: {{price}}','en'),(2192,2192,'Cannot create temporary order for modification','en'),(2193,2193,'Customer information','en'),(2194,2194,'no comments','en'),(2195,2195,'All items cannot be removed from the order.','en'),(2196,2196,'Changed items','en'),(2197,2197,'Changed options','en'),(2198,2198,'Added items','en'),(2199,2199,'Removed items','en'),(2200,2200,'Order item attributes are out-of-date and cannot be edited','en'),(2201,2201,'Order will be delivered to the billing address.','en'),(2202,2202,'Staff note','en'),(2203,2203,'The value will be recalculated automatically. Press it if you want to \'freeze\' the current value.','en'),(2204,2204,'The current value is \'frozen\' and won\'t be recalculated. Press it if you want it to be updated when the totals are recalculated.','en'),(2205,2205,'Don’t notify customer','en'),(2206,2206,'Order changes cannot be saved due to negative total value','en'),(2207,2207,'Remove data','en'),(2208,2208,'Buy','en'),(2209,2209,'Click the link to increase product amount','en'),(2210,2210,'Charset','en'),(2211,2211,'You can change the charset for all subsequent imports and exports using <a href=\"{{url}}\">this link</a>.','en'),(2212,2212,'You can change the CSV delimiter for all subsequent imports and exports using <a href=\"{{url}}\">this link</a>.','en'),(2213,2213,'Layout','en'),(2214,2214,'Two columns with right sidebar','en'),(2215,2215,'Two columns with left sidebar','en'),(2216,2216,'Three columns','en'),(2217,2217,'One column','en'),(2218,2218,'The product with SKU \"{{value}}\" does not exist. The \"{{name}}\" attribute will be imported as global','en'),(2219,2219,'The \"{{value}}\" membership does not exist','en'),(2220,2220,'The \"{{value}}\" product class does not exist','en'),(2221,2221,'The \"{{value}}\" tax class does not exist','en'),(2222,2222,'The \"{{value}}\" image does not exist','en'),(2223,2223,'Variant attribute \"{{column}}\" cannot be empty','en'),(2224,2224,'The \"{{value}}\" category does not exist','en'),(2225,2225,'Item not found ({{keys}})','en'),(2226,2226,'The number of values in the row does not match the number of column headers for this CSV file','en'),(2227,2227,'Tags are not allowed in the column \"{{column}}\" and will be stripped','en'),(2228,2228,'The value in the column \"{{column}}\" will be adjusted according to HTML specification to prevent potential XSS attack','en'),(2229,2229,'The value in the column \"{{column}}\" will be cut because its length exceeds the allowed character length for the respective field','en'),(2230,2230,'New product will be created','en'),(2231,2231,'New membership will be created','en'),(2232,2232,'New product class will be created','en'),(2233,2233,'New tax class will be created','en'),(2234,2234,'New category will be created','en'),(2235,2235,'Wrong price format. Positive floating-point number expected','en'),(2236,2236,'Wrong enabled format. This should be \"Yes\" or \"No\"','en'),(2237,2237,'Wrong metaDescType format. This should be \"A\" or \"C\"','en'),(2238,2238,'Wrong format of weight value. Positive floating-point number expected','en'),(2239,2239,'Wrong format of low stock notification value. This should be \"Yes\" or \"No\"','en'),(2240,2240,'Wrong format of use separate box value. This should be \"Yes\" or \"No\"','en'),(2241,2241,'Wrong arrival date format. Correct example: Thu, 21 Dec 2000 16:01:07','en'),(2242,2242,'Wrong date format. Correct example: Thu, 21 Dec 2000 16:01:07','en'),(2243,2243,'Wrong update date format. Correct example: Thu, 21 Dec 2000 16:01:07','en'),(2244,2244,'Wrong format of inventory tracking value. This should be \"Yes\" or \"No\"','en'),(2245,2245,'Wrong format of stock level value. Positive integer expected','en'),(2246,2246,'Wrong format of low stock notification value. This should be \"Yes\" or \"No\"','en'),(2247,2247,'Wrong format of low limit level value. Positive integer expected','en'),(2248,2248,'The name is empty','en'),(2249,2249,'Wrong format of box width value. Positive integer expected','en'),(2250,2250,'Wrong format of box length value. Positive integer expected','en'),(2251,2251,'Wrong format of box height value. Positive integer expected','en'),(2252,2252,'Wrong format of items per box value. Positive integer expected','en'),(2253,2253,'Wrong format of Clean URL value (only alphanumeric, dash (\"-\") and underscore (\"_\") chars are allowed)','en'),(2254,2254,'Error of image loading. Make sure the \"images\" directory has write permissions.','en'),(2255,2255,'Couldn\'t load the image \"{{value}}\", the file does not exist.','en'),(2256,2256,'Couldn\'t load the banner \"{{value}}\", the file does not exist.','en'),(2257,2257,'Wrong position format','en'),(2258,2258,'The group \"{{value}}\" does not exist. A new group will be created','en'),(2259,2259,'New attribute group will be created','en'),(2260,2260,'Wrong format of \"type\" value ({{value}}). This should be \"C\" - checkbox, \"S\" - selector, or \"T\" - textarea','en'),(2261,2261,'Product SKU is empty','en'),(2262,2262,'There is no product with SKU \"{{value}}\" to assign the attribute option value to','en'),(2263,2263,'Wrong format of \"type\" value ({{value}}). This should be \"C\" - checkbox, \"S\" - selector, \"H\" - hidden field or \"T\" - textarea','en'),(2264,2264,'Wrong format of \"owner\" value ({{value}}). This should be \"Yes\" for product-specific attributes or \"No\" for global attributes','en'),(2265,2265,'Wrong format of \"default\" value ({{value}}). This should be \"Yes\" for product-specific attributes or \"No\" for global attributes','en'),(2266,2266,'Wrong \"priceModifier\" format ({{value}}). Correct examples: +1, +1%, -1, -1%','en'),(2267,2267,'Wrong \"weightModifier\" format ({{value}}). Correct examples: +1, +1%, -1, -1%','en'),(2268,2268,'Product class {{value}} does not exists and will be created','en'),(2269,2269,'Group {{value}} does not exists and will be created','en'),(2270,2270,'Wrong format of show title value. This should be \"Yes\" or \"No\"','en'),(2271,2271,'Wrong login format. Email as login is expected','en'),(2272,2272,'Wrong date format. Correct example: Thu, 21 Dec 2000 16:01:07','en'),(2273,2273,'Wrong date format. Correct example: Thu, 21 Dec 2000 16:01:07','en'),(2274,2274,'Wrong last login date format. Example: Thu, 21 Dec 2000 16:01:07','en'),(2275,2275,'Wrong status format. This should be \"E\" - enabled, or \"D\" - disabled','en'),(2276,2276,'Wrong referer format. URL expected. Correct example: http://x-cart.com','en'),(2277,2277,'Wrong format of language value. Correct examples: EN, DE, RU: http://en.wikipedia.org/wiki/ISO_639-1','en'),(2278,2278,'Wrong format. This should be \"Yes\" or \"No\". Use \"Yes\" if it is the shipping address.','en'),(2279,2279,'Wrong format. This should be \"Yes\" or \"No\". Use \"Yes\" if it is the billing address.','en'),(2280,2280,'Wrong format of country code value. Correct examples: CA, US, RU: http://en.wikipedia.org/wiki/ISO_3166-1_alpha-2','en'),(2281,2281,'Wrong format of state id value.','en'),(2282,2282,'In advanced mode you can choose specific modules for upgrade.','en'),(2283,2283,'Before installing a paid addon for this installation, you need to <a href=\"#\" class=\"open-license-key-form\">activate your X-Cart license.</a>','en'),(2284,2284,'Use the form below to provide your license information.','en'),(2285,2285,'Activate your X-Cart installation','en'),(2286,2286,'Activate your X-Cart installation first','en'),(2287,2287,'Activate key','en'),(2288,2288,'Vendor','en'),(2289,2289,'All','en'),(2290,2290,'Paid','en'),(2291,2291,'Free','en'),(2292,2292,'I confirm that I have <strong>created backups</strong> of my store\'s files and database before upgrading the store','en'),(2293,2293,'Secure credit card payment','en'),(2294,2294,'Card type','en'),(2295,2295,'Chose credit card type','en'),(2296,2296,'Choose card type','en'),(2297,2297,'Card number','en'),(2298,2298,'MONTH','en'),(2299,2299,'VALID THRU','en'),(2300,2300,'YEAR','en'),(2301,2301,'Security code','en'),(2302,2302,'Last three numbers on the back side of your card','en'),(2303,2303,'Four-digit number on the front side of your card','en'),(2304,2304,'Credit card security code (if present)','en'),(2305,2305,'Countries information has been successfully updated','en'),(2306,2306,'Please select the countries first','en'),(2307,2307,'This payment method is <strong>Active</strong>.','en'),(2308,2308,'This payment method is <strong>Inactive</strong>.','en'),(2309,2309,'Active','en'),(2310,2310,'Inactive','en'),(2311,2311,'Learn More','en'),(2312,2312,'Learn more.','en'),(2313,2313,'Sign Up','en'),(2314,2314,'<div id=\"logo\" style=\"max-width: 250px;\">%logo%</div>','en'),(2315,2315,'<h3>Hey %recipient_name%</h3>','en'),(2316,2316,'Your friends at %company_link%.','en'),(2317,2317,'<div id=\"logo\" style=\"max-width: 250px;\">%logo%</div>','en'),(2318,2318,'<h3>Hey</h3>','en'),(2319,2319,'Your virtual assistant at %company_link%.','en'),(2320,2320,'Market your products to relevant audience on Google Shopping. Start advertising in minutes with the new Google Shopping app. <a href=\"{{url}}\">Learn more</a>.','en'),(2321,2321,'Tip from X-Cart','en'),(2322,2322,'Email notifications','en'),(2323,2323,'This content (if it exists) will be shown below the notification text; alternatively, it may be inserted in another location within the notification via the variable <b>%dynamic_message%</b>.','en'),(2324,2324,'Content of this notification based on the body.twig template','en'),(2325,2325,'Enabled for administrator','en'),(2326,2326,'Enabled for customer','en'),(2327,2327,'Customer header','en'),(2328,2328,'Customer signature','en'),(2329,2329,'Administrator header','en'),(2330,2330,'Administrator signature','en'),(2331,2331,'Customer subject','en'),(2332,2332,'Customer text','en'),(2333,2333,'Administrator subject','en'),(2334,2334,'Administrator text','en'),(2335,2335,'This page allows you to adjust the types of email notifications your store sends to users. Use the On/Off widget to enable/disable specific notifications. Click on the name of a notification to edit the notification text.','en'),(2336,2336,'Notification','en'),(2337,2337,'Back to notifications list','en'),(2338,2338,'On','en'),(2339,2339,'Off','en'),(2340,2340,'First','en'),(2341,2341,'Last','en'),(2342,2342,'The Free license key cannot be activated as it is impossible to get information about the available addons from the Marketplace at the moment. Please try again later.','en'),(2343,2343,'No promotion modules installed','en'),(2344,2344,'Names, descriptions & sorting','en'),(2345,2345,'Payment method is enabled','en'),(2346,2346,'Payment method is disabled','en'),(2347,2347,'You should confirm that you have created a backup before upgrading the store.','en'),(2348,2348,'Upgrade note','en'),(2349,2349,'The following modules currently do not have a version compatible with the X-Cart version to which you are upgrading. If you want to keep using these modules after the upgrade, use the \"Request for upgrade\" button to send a request to the module developers so they provide an updated version for their module and make it available via the X-Cart\'s Marketplace. Once the updated module versions are available, you should be able to complete upgrading your store without losing any of the features you currently use.','en'),(2350,2350,'{{count}} module will be disabled','en'),(2351,2351,'{{count}} modules will be disabled','en'),(2352,2352,'{{count}} module will be upgraded','en'),(2353,2353,'{{count}} modules will be upgraded','en'),(2354,2354,'Request for upgrade','en'),(2355,2355,'Your request has been sent successfully','en'),(2356,2356,'An error occurred while sending the request','en'),(2357,2357,'view list','en'),(2358,2358,'hide list','en'),(2359,2359,'Your version ({{version}}) can be upgraded to','en'),(2360,2360,'Imported','en'),(2361,2361,'Importing data...','en'),(2362,2362,'Verified','en'),(2363,2363,'Verifying data before importing...','en'),(2364,2364,'Products processed','en'),(2365,2365,'Processing products...','en'),(2366,2366,'Images resized','en'),(2367,2367,'Resizing images...','en'),(2368,2368,'Generate resized images','en'),(2369,2369,'Clicking the \"Generate resized images\" button launches the image resizing routine to generate copies of existing images in all the sizes needed to display the images in your store\'s customer area. Having a separate image file in each of the sizes provides a way to speed up your site\'s performance by reducing page load times for pages containing graphics.','en'),(2370,2370,'The generation of resized images has been completed successfully.','en'),(2371,2371,'The generation of resized images has been stopped.','en'),(2372,2372,'The image resizing process may take a while to complete. Please do not close this page until the process is fully completed. If the page has been closed, please re-open it to complete the process (The image resizing routine is executed only while the page stays open).','en'),(2373,2373,'Variables for this notification','en'),(2374,2374,'Developers docs','en'),(2375,2375,'The following selected modules cannot be disabled or uninstalled as they have dependent modules: {{list}}','en'),(2376,2376,'The following selected modules cannot be enabled as they depend on disabled modules which cannot be enabled: {{list}}','en'),(2377,2377,'The module may not be disabled due to the limitations of the module architecture.','en'),(2378,2378,'The following selected modules cannot be disabled due to architecture limitations: {{list}}','en'),(2379,2379,'Please note that the following modules will also be enabled:','en'),(2380,2380,'New account','en'),(2381,2381,'Products processed: {{count}}','en'),(2382,2382,'Images resized: {{count}}','en'),(2383,2383,'Orders list','en'),(2384,2384,'Coming soon','en'),(2385,2385,'View storefront','en'),(2386,2386,'Payment is not required','en'),(2387,2387,'Zoom image','en'),(2388,2388,'CSV delimiter','en'),(2389,2389,'Module Marketplace. Terms of use','en'),(2390,2390,'Import/Export guide','en'),(2391,2391,'Yes, I agree with License agreements','en'),(2392,2392,'The system has detected that some updates are available for enabled modules. It is strongly recommended to have all the enabled modules updated to the latest version for better compatibility before installing new ones from the Marketplace.','en'),(2393,2393,'Action','en'),(2394,2394,'Will be updated if core update is selected','en'),(2395,2395,'Options:','en'),(2396,2396,'RSS feed','en'),(2397,2397,'Will be deleted:','en'),(2398,2398,'Are you sure you want to uninstall the selected add-ons?','en'),(2399,2399,'Module page','en'),(2400,2400,'Add to bag','en'),(2401,2401,'New access codes were generated.','en'),(2402,2402,'show list','en'),(2403,2403,'All statuses','en'),(2404,2404,'Product attribute values have been imported','en'),(2405,2405,'No items found','en'),(2406,2406,'No model selected','en'),(2407,2407,'Profile is not selected','en'),(2408,2408,'SKU is not selected','en'),(2409,2409,'Status is not defined','en'),(2410,2410,'All user types','en'),(2411,2411,'Advanced Order Management','en'),(2412,2412,'Public ID','en'),(2413,2413,'Public id','en'),(2414,2414,'Method name','en'),(2415,2415,'Tracking number','en'),(2416,2416,'The common notification fields have been updated','en'),(2417,2417,'The notification has been updated','en'),(2418,2418,'The product has been added','en'),(2419,2419,'Add-on does not exist.','en'),(2420,2420,'Transaction','en'),(2421,2421,'Log files not found','en'),(2422,2422,'Payment method settings','en'),(2423,2423,'Recently installed modules','en'),(2424,2424,'Login dates','en'),(2425,2425,'File is not an image','en'),(2426,2426,'File is not uploaded','en'),(2427,2427,'Create label','en'),(2428,2428,'Product information has been deleted successfully','en'),(2429,2429,'Import language','en'),(2430,2430,'License: trial version','en'),(2431,2431,'Installation date','en'),(2432,2432,'Order failed','en'),(2433,2433,'Delete account','en'),(2434,2434,'Administrator account cannot be deleted via customer interface.','en'),(2435,2435,'X-Cart license key has been successfully verified and activated.','en'),(2436,2436,'X-Cart license key has been activated. However, this key is expired and does not allow getting upgrade packs from the Marketplace.','en'),(2437,2437,'The license key for the module \"{{name}}\" by \"{{author}}\" has been successfully verified and activated.','en'),(2438,2438,'The key does not allow getting new features and upgrades. <a href=\"{{renewalUrl}}\" target=\"_blank\">Renew your key now</a>','en'),(2439,2439,'Some of these updates are not available for you at the moment. Please renew your access to upgrades to get new superior features from the latest releases.','en'),(2440,2440,'Please renew your access to upgrades to get new superior features from the latest releases.','en'),(2441,2441,'License key','en'),(2442,2442,'Exp. date','en'),(2443,2443,'Prolongate license','en'),(2444,2444,'Renew your access to new features','en'),(2445,2445,'Re-validate license keys','en'),(2446,2446,'Wrong format: Field contains unallowed characters','en'),(2447,2447,'The Clean URL entered is already <a href=\"{{entityURL}}\" target=\"_blank\">in use</a>. Check the \"Resolve the conflict\" tooltip.','en'),(2448,2448,'The Clean URL entered is a redirect to <a href=\"{{entityURL}}\" target=\"_blank\">another object</a>.','en'),(2449,2449,'The clean URL will be generated automatically.','en'),(2450,2450,'Result','en'),(2451,2451,'Change the Clean URL value for this page (Enter a different Clean URL value manually or use the Autogenerate Clean URL feature)','en'),(2452,2452,'Enable the option \"Assign entered Clean URL to this page anyway\" to dissociate the entered Clean URL from the page it is currently used for and assign it to the page of the object being edited.','en'),(2453,2453,'Resolve the conflict','en'),(2454,2454,'Assign entered Clean URL to this page anyway','en'),(2455,2455,'Human readable and SEO friendly web address for the page.','en'),(2456,2456,'This feature is available only for paid (non-free) <a href=\"{{pricingUrl}}\" target=\"_blank\">X-Cart license plans</a>.','en'),(2457,2457,'In this section you can review the recent payment transactions that have taken place at your store, both successful and failed. You can easily identify orders with payment problems and increase your sales by following up on abandoned carts.','en'),(2458,2458,'Hash file for installed entry \"{{entry}}\" doesn\'t exist or is not readable','en'),(2459,2459,'Sale statistics','en'),(2460,2460,'Yesterday','en'),(2461,2461,'Last week','en'),(2462,2462,'Low stock info','en'),(2463,2463,'Last year','en'),(2464,2464,'Security issue','en'),(2465,2465,'New addons','en'),(2466,2466,'View more addons in Marketplace','en'),(2467,2467,'Upgrade access level has been successfully assigned to your license keys','en'),(2468,2468,'<ul><li><b>Developer</b> level assumes the earliest access to upgrade, but the build can be unstable.</li><li><b>Merchant</b> level assumes the latest access to upgrade, but the build will be the most stable.</li></ul>','en'),(2469,2469,'Could not assign upgrade access level to your license keys','en'),(2470,2470,'There are no activated license keys','en'),(2471,2471,'Upgrade access level cannot be changed for default free license','en'),(2472,2472,'An error occurred, please try again. If the problem persists, contact the administrator.','en'),(2473,2473,'An error occurred, please try again. If the problem persists, contact the administrator.<ul><li>{{txnNote}}</li></ul>','en'),(2474,2474,'Cache management','en'),(2475,2475,'Re-deploy the store','en'),(2476,2476,'Re-deployment may take a while to complete. Please do not close this page until the process is fully completed. If the page has been closed, please re-open it to complete the process (The store re-deployment is executed only while the page stays open).','en'),(2477,2477,'Calculate quick data','en'),(2478,2478,'Calculated quick data enhances your store\'s performance by allowing quick product sorting. The process of quick data calculation may take a while to complete. Please do not close this page until the process is fully completed. If the page has been closed, please re-open it to complete the process (The calculation is performed only while the page stays open).','en'),(2479,2479,'About {{time}} remaining','en'),(2480,2480,'Calculating quick data...','en'),(2481,2481,'The process of quick data calculation may take a while to complete. Please do not close this page until the process is fully completed. If the page has been closed, please re-open it to complete the process (The calculation is performed only while the page stays open).','en'),(2482,2482,'The calculation of quick data has been completed successfully.','en'),(2483,2483,'The calculation of quick data has been stopped.','en'),(2484,2484,'Find transactions <b>by ID</b>','en'),(2485,2485,'Search for transactions <b>by date</b>','en'),(2486,2486,'Filter transactions <b>by status</b>','en'),(2487,2487,'Choose the right plan','en'),(2488,2488,'Buy Business Edition','en'),(2489,2489,'unavailable','en'),(2490,2490,'{{count}} modules have been selected','en'),(2491,2491,'This tool allows you to get rid of any content that might have been created in your store for testing purposes and which you no longer need. To use the tool, mark for deletion the types of content data you want to be removed, then click the <strong>Save Changes</strong> button. Removal of content data will not affect the store\'s existing configuration settings.','en'),(2492,2492,'<strong>Warning!</strong> The selected types of content data will be deleted permanently. We strongly recommend you back up your store before you proceed.<br />Please enter the administrator password to confirm you understand the consequences of your choice.','en'),(2493,2493,'Incorrect password. Please try again.','en'),(2494,2494,'Confirmation','en'),(2495,2495,'Leave blank to use product name as Page Title.','en'),(2496,2496,'This page is intended for the creation and management of discount coupons. Different types of coupons are supported, including <strong>$ off, % off and free shipping</strong>. For each coupon the following information can be specified:','en'),(2497,2497,'the <strong>dates</strong> the coupon should be valid for;','en'),(2498,2498,'the <strong>order subtotal range</strong> for which the coupon can be used;','en'),(2499,2499,'the <strong>categories and product classes</strong> to which the coupon may be applied;','en'),(2500,2500,'whether the coupon may be used by everyone or only by users with <strong>specific memberships</strong>.','en'),(2501,2501,'This page is intended for the management of volume discounts based on the order subtotal.','en'),(2502,2502,'Set <strong>absolute or %-based</strong> discount rates;','en'),(2503,2503,'Make a discount available to <strong>all customers</strong> or only to specific <strong>membership levels</strong>;','en'),(2504,2504,'Set a single discount or add <strong>multiple volume discounts</strong>.','en'),(2505,2505,'The system has been restored to the selected snapshot of {{date}}','en'),(2506,2506,'The system has failed to restore because there was no snapshot of {{date}}','en'),(2507,2507,'Leave blank to use category name as Page Title.','en'),(2508,2508,'Current template','en'),(2509,2509,'Standard','en'),(2510,2510,'Layout type','en'),(2511,2511,'Edit custom options','en'),(2512,2512,'Visit the template store','en'),(2513,2513,'Activate purchased skin','en'),(2514,2514,'If you purchased a template but do not see it here, activate the license key that was provided to you.','en'),(2515,2515,'Choose a new template','en'),(2516,2516,'<strong>Need custom design?</strong> We can modify this template or create a completely unique design for you','en'),(2517,2517,'FREE quote','en'),(2518,2518,'Layout has been changed. <a href=\"{{storefront}}\" target=\"_blank\">Review the updated storefront</a>.','en'),(2519,2519,'To make your changes visible in the customer area, cache rebuild is required. It will take several seconds. You don’t need to close the storefront, the operation is executed in the background.','en'),(2520,2520,'Product details image','en'),(2521,2521,'Products list image (<span class=\"preview\" data-img=\"preview_grid.png\">grid view</span>)','en'),(2522,2522,'Products list image (<span class=\"preview\" data-img=\"preview_list.png\">list view</span>)','en'),(2523,2523,'Category image','en'),(2524,2524,'There are unsaved changes on the page. If you choose to continue, these changes will be lost. Do you want to proceed?','en'),(2525,2525,'X-Cart found some issues with installed SSL certificate. You can get more information using this service: <a href=\'{{url}}\'>{{url}}</a>','en'),(2526,2526,'The secure protocol is enabled for your website. But X-Cart hasn\'t found the valid SSL certificate on your server.','en'),(2527,2527,'How do I move X-Cart?','en'),(2528,2528,'No region','en'),(2529,2529,'Check for available free disk space has failed','en'),(2530,2530,'You should check available free disk space yourself before continuing upgrade','en'),(2531,2531,'You should check available free disk space yourself before continuing installation','en'),(2532,2532,'Payment method has been added','en'),(2533,2533,'Payment method was not added','en'),(2534,2534,'Installation warnings','en'),(2535,2535,'You can get more information using this service: <a href=\"{{url}}\">{{url}}</a>','en'),(2536,2536,'X-Cart could not find a valid SSL certificate on your server. Although you can switch the store to use the secure protocol for the website pages, most Internet browsers will likely display a warning message scaring your website visitors away.','en'),(2537,2537,'X-Cart could not find a valid SSL certificate on your server.','en'),(2538,2538,'X-Cart could not find a valid SSL certificate on your server (<span>{{domain}}</span>).','en'),(2539,2539,'Before enabling HTTPS protocol read this article: <a href=\"{{articleUrl}}\">Inaccessible Admin area after enabling HTTPS</a>','en'),(2540,2540,'You are operating as:','en'),(2541,2541,'Operate as this customer','en'),(2542,2542,'Quit','en'),(2543,2543,'You are operating as: {{user}}','en'),(2544,2544,'You are logged in as: {{user}}','en'),(2545,2545,'Finished operating as customer','en'),(2546,2546,'Avalara provides our mutual customers with everything you need to calculate, file and remit sales tax for your business effortlessly by providing an integrated, end-to-end solution for every step of the tax compliance process.','en'),(2547,2547,'New to Avalara? <a href=\"http://www.avalara.com/integrations/x-cart/\" target=\"_blank\">Sign up here!</a>','en'),(2548,2548,'<a href=\"https://www.avalara.com/us/en/products/integrations/x-cart.html?partnersource=0010b00001sr5BH&CampaignID=7010b0000013aD9&lsmr=Direct%20Partner%20Referral&lso=Direct%20Partner%20Referral\" target=\"_blank\">60 Day Free Trial</a>','en'),(2549,2549,'Existing Avalara Customer? <a href=\"{{moduleSettings}}\">Turn AvaTax on now!</a>','en'),(2550,2550,'Any profile','en'),(2551,2551,'Shipping method is not configured.','en'),(2552,2552,'Delivery time','en'),(2553,2553,'Shipping method information that your customers will be able to see when choosing a shipping method for their order during checkout. Can be provided only for offline shipping methods.','en'),(2554,2554,'Choose a parameter (or parameters) based on which custom rates will be defined. When calculating shipping costs, the system takes into account only the custom rates defined based on the parameter(s) selected in this field.','en'),(2555,2555,'Can be provided only for offline shipping methods.','en'),(2556,2556,'Handling fee','en'),(2557,2557,'Can be provided only for online shipping methods.','en'),(2558,2558,'What type of shipping rates would you like to use?','en'),(2559,2559,'Carrier-calculated rates','en'),(2560,2560,'Custom table rates','en'),(2561,2561,'Get shipping rates from major shipping carrier companies. No need to enter shipping rates manualy: the rates are obtained from the shipping carrier in real time so you get the most accurate shipping cost estimation.','en'),(2562,2562,'Method name','en'),(2563,2563,'Table based on','en'),(2564,2564,'Subtotal','en'),(2565,2565,'Discounted subtotal','en'),(2566,2566,'Weight','en'),(2567,2567,'Items','en'),(2568,2568,'Subtotal, weight, items','en'),(2569,2569,'Address zone','en'),(2570,2570,'Subtotal range','en'),(2571,2571,'Discounted subtotal range','en'),(2572,2572,'Weight range','en'),(2573,2573,'Items range','en'),(2574,2574,'flat rate','en'),(2575,2575,'per item','en'),(2576,2576,'per weight unit','en'),(2577,2577,'Shipping','en'),(2578,2578,'Items','en'),(2579,2579,'Subtotal','en'),(2580,2580,'Discounted subtotal','en'),(2581,2581,'Weight','en'),(2582,2582,'Free','en'),(2583,2583,'Here you can provide general information about the shipping method and configure a table defining how shipping rates for this method should be calculated.','en'),(2584,2584,'Learn how to define shipping rates','en'),(2585,2585,'You can set up different shipping rates depending on the weight, price or quantity of items in the order. For this purpose in the field \"Table based on\" you need to specify the quality of an order that should determine the choice of a shipping rate (order subtotal, order weight, quantity of items in the order, or \"Subtotal, weight, items\" - if multiple factors need to be taken into account at the same time). Then in the table below you need to specify the subtotal, weight and/or quantity range that make an order eligible for this rate, and specify the values that need to be taken into account when calculating the shipping rate. If rates for more than one ranges need to be specified, it is necessary to add more rows to the rates table. The ranges for the different rates in the table may not overlap.','en'),(2586,2586,'Shipping rates are calculated by the following formula:','en'),(2587,2587,'You can define the following values:','en'),(2588,2588,'Flat shipping charge. This value will be added to the shipping rate regardless of the weight, price and number of items ordered.','en'),(2589,2589,'Flat shipping charge per item ordered.','en'),(2590,2590,'Shipping charge based on a percentage of the order subtotal.','en'),(2591,2591,'Flat shipping charge per weight unit ordered (for example, per pound or per kilogram - depending on the weight units used by your store).','en'),(2592,2592,'SHIPPING = flat + ITEMS*per_item + SUBTOTAL*(% of subtotal)/100 + WEIGHT*per_{{X}};','en'),(2593,2593,'Carrier services','en'),(2594,2594,'Carrier service','en'),(2595,2595,'Carrier service name','en'),(2596,2596,'Test rates','en'),(2597,2597,'Back to shipping methods','en'),(2598,2598,'This shipping method is','en'),(2599,2599,'This shipping method is <strong>not configured</strong>.','en'),(2600,2600,'on','en'),(2601,2601,'off','en'),(2602,2602,'Pre-upgrade hooks cannot be run','en'),(2603,2603,'Files cannot be updated','en'),(2604,2604,'Trying to run pre-upgrade hooks while not all archives were unpacked','en'),(2605,2605,'...Invoke {{type}} hook for {{entry}}...','en'),(2606,2606,'...Hooks {{hooksCount}}, Items {{itemsCount}}...','en'),(2607,2607,'...Hooks {{hooksCount}}','en'),(2608,2608,'...Unpacking {{entry}}...{{status}}','en'),(2609,2609,'...Downloading {{entry}}...{{status}}','en'),(2610,2610,'<span class=\"value\">{{X}}</span> items','en'),(2611,2611,'More attributes','en'),(2612,2612,'Do you really want to close storefront?','en'),(2613,2613,'The product for which you attempted to upload an attachment has not been found','en'),(2614,2614,'The file extension is forbidden','en'),(2615,2615,'Accounting','en'),(2616,2616,'Export orders','en'),(2617,2617,'Not seeing your accounting software here? <a href=\"{{href}}\" target=\"_blank\">Let us know</a>','en'),(2618,2618,'Want to change or add another accounting system? Choose the accounting system you require below and configure it.','en'),(2619,2619,'No accounting system has been selected yet. Choose your accounting system below and configure it.','en'),(2620,2620,'Automate shipping','en'),(2621,2621,'Integration with','en'),(2622,2622,'Automate your shipping process with the services of our partners: print shipping labels, grab shipping orders info from eBay, ETSY, Amazon and other marketplaces; integrate with several shipping carriers in one spot and more.','en'),(2623,2623,'Haven\'t found what you\'re looking for? View more <a href=\'{{href}}\'>shipping modules</a>','en'),(2624,2624,'Print Shipping labels','en'),(2625,2625,'FREE trial','en'),(2626,2626,'Refunds','en'),(2627,2627,'App type','en'),(2628,2628,'Cloud Service','en'),(2629,2629,'Cloud Zoom','en'),(2630,2630,'Cloud Zoom mode','en'),(2631,2631,'Inside','en'),(2632,2632,'Outside','en'),(2633,2633,'Win app','en'),(2634,2634,'Amazon','en'),(2635,2635,'DHL','en'),(2636,2636,'ETSY','en'),(2637,2637,'FedEx','en'),(2638,2638,'Stamps.com','en'),(2639,2639,'UPS','en'),(2640,2640,'U.S.P.S.','en'),(2641,2641,'eBay','en'),(2642,2642,'Ship-From address','en'),(2643,2643,'Automate Shipping Refunds','en'),(2644,2644,'Shipping solutions','en'),(2645,2645,'More shipping solutions','en'),(2646,2646,'Transaction details','en'),(2647,2647,'You can find the failed transaction <a href=\"{{url}}\">here</a>','en'),(2648,2648,'Save filter','en'),(2649,2649,'Enter filter name','en'),(2650,2650,'Delete filter','en'),(2651,2651,'Are you sure you want to delete this filter?','en'),(2652,2652,'Filter has been successfully saved','en'),(2653,2653,'Filter has been removed','en'),(2654,2654,'The download should start automatically. Click the link if does not start.','en'),(2655,2655,'Sorry, your order cannot be placed as there are no shipping methods available.','en'),(2656,2656,'Packing slip','en'),(2657,2657,'Print packing slip','en'),(2658,2658,'Packing date','en'),(2659,2659,'Order date','en'),(2660,2660,'Bill to','en'),(2661,2661,'Ship to','en'),(2662,2662,'Order QTY','en'),(2663,2663,'Ship QTY','en'),(2664,2664,'Please select the orders first','en'),(2665,2665,'Orders has been successfully deleted','en'),(2666,2666,'Purchase license','en'),(2667,2667,'License warning','en'),(2668,2668,'Inactive license key ({{key}})','en'),(2669,2669,'Does not match license type (requires {{list}} edition)','en'),(2670,2670,'Requires {{list}} edition license','en'),(2671,2671,'License key is missing','en'),(2672,2672,'The system has detected one or more problems with some of the modules at your store:','en'),(2673,2673,'inactive license key(s);','en'),(2674,2674,'installed module(s) not allowed by the type of X-Cart license activated at your store.','en'),(2675,2675,'Using the modules with this type of license violation is illegal.<br />To resolve the problem, please remove the affected modules from your store, or activate a valid license allowing the use of these modules.','en'),(2676,2676,'Also the system has detected problems with the following modules:','en'),(2677,2677,'You can also <a href=\"{{url}}\" target=\"_blank\">contact our CR department</a> for help with this issue','en'),(2678,2678,'WARNING! Any attempt to access further pages in the administrator interface will result in the <strong>automatic disabling</strong> of all the unallowed modules. To prevent this from happening, please activate a valid license key by clicking the button below.','en'),(2679,2679,'Remove unlicensed modules','en'),(2680,2680,'The system has detected that the license key that was activated for your store is invalid.<br />Using the store with an invalid license key is illegal.<br />To resolve the problem, please activate a valid license key for your store, or revert to Trial mode.','en'),(2681,2681,'Back to Trial mode','en'),(2682,2682,'Re-check','en'),(2683,2683,'Tools','en'),(2684,2684,'All payment transaction statuses','en'),(2685,2685,'Default image settings','en'),(2686,2686,'In progress','en'),(2687,2687,'Initialized','en'),(2688,2688,'Success','en'),(2689,2689,'Pending','en'),(2690,2690,'Failed','en'),(2691,2691,'Canceled','en'),(2692,2692,'Void','en'),(2693,2693,'The calculation failed','en'),(2694,2694,'The calculation completed','en'),(2695,2695,'The process of sales calculation may take a while to complete. Please do not close this page until the process is fully completed.','en'),(2696,2696,'Sales calculation','en'),(2697,2697,'This method is displayed because you are logged in as admin and operating as another user','en'),(2698,2698,'Old customer note','en'),(2699,2699,'New customer note','en'),(2700,2700,'Add comment here','en'),(2701,2701,'more','en'),(2702,2702,'View order history','en'),(2703,2703,'Banner rotation','en'),(2704,2704,'Add banner','en'),(2705,2705,'Review & Submit order','en'),(2706,2706,'Products search','en'),(2707,2707,'Requires shipping','en'),(2708,2708,'Learn how to convert failed transactions into real orders','en'),(2709,2709,'Customer','en'),(2710,2710,'Couldn\'t download the image \"{{value}}\"','en'),(2711,2711,'Error of image verification ({{value}}). Make sure you have specified the correct image file or URL.','en'),(2712,2712,'Show low stock warning on product page','en'),(2713,2713,'Notify administrator if the stock quantity of this product goes below a certain limit','en'),(2714,2714,'Only {{X}} left in stock','en'),(2715,2715,'Show all warnings/errors','en'),(2716,2716,'Hide all warnings/errors','en'),(2717,2717,'Errors','en'),(2718,2718,'Warnings','en'),(2719,2719,'Download error file','en'),(2720,2720,'The value must be greater than the current maximum order number in the order list','en'),(2721,2721,'Authorize','en'),(2722,2722,'Sale','en'),(2723,2723,'Capture','en'),(2724,2724,'Capture partially','en'),(2725,2725,'Capture multiple','en'),(2726,2726,'Void','en'),(2727,2727,'Void partially','en'),(2728,2728,'Void multiple','en'),(2729,2729,'Refund','en'),(2730,2730,'Refund partially','en'),(2731,2731,'Refund multiple','en'),(2732,2732,'Get information','en'),(2733,2733,'Accept','en'),(2734,2734,'Decline','en'),(2735,2735,'Test','en'),(2736,2736,'Need a more powerful banner system for your store? <a href=\"{{url}}\">Get it now!</a>','en'),(2737,2737,'Administrator','en'),(2738,2738,'Log in as this admin','en'),(2739,2739,'Need a more customizeable PDF invoice solution for your store? <a href=\"{{url}}\">Get it now!</a>','en'),(2740,2740,'File can not be uploaded','en'),(2741,2741,'{{file}} file could not be copied to a new location {{newPath}}','en'),(2742,2742,'Unable to write data to file {{file}}','en'),(2743,2743,'Unable to download the content of {{url}}','en'),(2744,2744,'File {{file}} does not exist','en'),(2745,2745,'Unable to get the content from {{url}}','en'),(2746,2746,'The file extension is forbidden ({{file}}','en'),(2747,2747,'Incorrect permissions','en'),(2748,2748,'Incorrect amount','en'),(2749,2749,'Not enough permissions to import user access level','en'),(2750,2750,'Wrong access level format ({{value}})','en'),(2751,2751,'Not enough permissions to import user roles','en'),(2752,2752,'Wrong role name ({{value}})','en'),(2753,2753,'Roles cannot be changed for your profile via import. Row will be skipped','en'),(2754,2754,'Access level cannot be changed (from {{prevValue}} to {{value}}) for existing profile ({{login}})','en'),(2755,2755,'You cannot update administrator profile ({{value}}). Row will be skipped','en'),(2756,2756,'You cannot update administrator profile ({{value}}). Row has been skipped','en'),(2757,2757,'The count of categories specified for a product and the count of orderBy position numbers describing the position of the product within these categories must be the same.','en'),(2758,2758,'OrderBy position number must be specified as a non-negative integer.','en'),(2759,2759,'Category name should not be empty','en'),(2760,2760,'After the problem has been fixed, try to connect again.\', {\'clear_cache\': url(\'addons_list_marketplace','en'),(2761,2761,'All items','en'),(2762,2762,'Although you can switch the store to use the secure protocol for the website pages, most Internet browsers will likely display a warning message scaring your website visitors away.','en'),(2763,2763,'Autogenerate','en'),(2764,2764,'Background export is in progress','en'),(2765,2765,'Clean URLs are disabled. More info\', {\'more_info_url\': url(\'settings\', \'','en'),(2766,2766,'Clean URLs','en'),(2767,2767,'The Clean URL entered is already in use by another page. To resolve the conflict, edit the \"clean_urls_aliases\" section in the file etc/config.php.','en'),(2768,2768,'First','en'),(2769,2769,'Last','en'),(2770,2770,' > ','en'),(2771,2771,'X-Cart','en'),(2772,2772,'','en'),(2773,2773,'Title','en'),(2774,2774,'[Edit]','en'),(2775,2775,'Parent category path','en'),(2776,2776,'Object name (category, product, etc)','en'),(2777,2777,'General options','en'),(2778,2778,'404 page','en'),(2779,2779,'Regular text for 404 page','en'),(2780,2780,'Show сustomer relations e-mails on 404 page','en'),(2781,2781,'<div><a href=\'{home}\'>Go to home page</a> | <a href=\'{contact us}\'>Contact us</a></div><div>If you continue having trouble finding what you are looking for please contact our customer service department.</div>','en'),(2782,2782,'Default site title','en'),(2783,2783,'Default site meta description','en'),(2784,2784,'Default site meta keywords','en'),(2785,2785,'Home page title and meta','en'),(2786,2786,'Page title format','en'),(2787,2787,'Show object name in page title','en'),(2788,2788,'About clean urls','en'),(2789,2789,'Page title consists of the following elements separated by the delimiter \"{{delimiter}}\"; you can change the delimiter by editing the <a href=\"{{modify_url}}\">title-delimiter</a> label','en'),(2790,2790,'Every object stores a history of up to 8 clean urls that were used for the object previously. X-Cart sets 301 redirects for these URLs automatically.','en'),(2791,2791,'Also, you can adjust your 301 redirects in the .htaccess file (See <a href=\"https://kb.x-cart.com/en/general_setup/setting_up_seo-friendly_urls.html\" target=\"blank\">Setting up seo-friendly URLs</a> for Nginx or IIS configuration), or use a special extension by 3d party module developers (<a href=\"https://market.x-cart.com/addons/redirects-by-Nova-Horizon.html\"  target=\"blank\">Redirects module</a>)','en'),(2792,2792,'Connecting to the marketplace...','en'),(2793,2793,'Do not see your payment method? Find it on our Marketplace\', {\'url\': url(\'addons_list_marketplace\', \'\', {\'tag\': \'Payment processing','en'),(2794,2794,'Enter product name or SKU','en'),(2795,2795,'Export all','en'),(2796,2796,'Export selected','en'),(2797,2797,'File was successfully uploaded','en'),(2798,2798,'Hide and make them available only via a direct link','en'),(2799,2799,'Ignore membership','en'),(2800,2800,'Import results','en'),(2801,2801,'Info','en'),(2802,2802,'Initializing...','en'),(2803,2803,'Inventory tracking is','en'),(2804,2804,'Login is locked out','en'),(2805,2805,'Manage zones','en'),(2806,2806,'Marketing','en'),(2807,2807,'Minimum value is {{value}}','en'),(2808,2808,'Modules','en'),(2809,2809,'Options','en'),(2810,2810,'Order cannot be placed because there is no shipping methods available.','en'),(2811,2811,'Order number or email','en'),(2812,2812,'Please wait','en'),(2813,2813,'Prices & Inventory','en'),(2814,2814,'Recalculate totals','en'),(2815,2815,'Recent orders only','en'),(2816,2816,'SKU length must be less than {{length}}','en'),(2817,2817,'{{field}} length must be less than {{length}}','en'),(2818,2818,'SKU or SKU1, SKU2','en'),(2819,2819,'Select language to edit','en'),(2820,2820,'Separate box','en'),(2821,2821,'Shipping method / cost','en'),(2822,2822,'Show in all the sections','en'),(2823,2823,'Show only in categories and search listings','en'),(2824,2824,'Show only in search listing','en'),(2825,2825,'Show:','en'),(2826,2826,'Soft and Hard reset links for your store','en'),(2827,2827,'Sort by:','en'),(2828,2828,'Sort settings','en'),(2829,2829,'Specify your _store information_\', {\'URL\': url(\'settings\', \'','en'),(2830,2830,'The secure protocol for your website is disabled.','en'),(2831,2831,'The secure protocol for your website is enabled.','en'),(2832,2832,'This payment method is not configured.','en'),(2833,2833,'Time left','en'),(2834,2834,'To setup Tax Rates, find and install the appropriate addons from Marketplace\', {\'url\': url(\'addons_list_marketplace\', \'\', {\'tag\': \'Taxes','en'),(2835,2835,'Transaction ID','en'),(2836,2836,'Try to change the search criteria or find the needed solution in marketplace\', {\'URL\': url(\'addons_list_marketplace\', \'\', {\'tag\': \'Payment processing','en'),(2837,2837,'Try to search worldwide or find the needed solution in marketplace\', {\'URL\': url(\'addons_list_marketplace\', \'\', {\'tag\': \'Payment processing','en'),(2838,2838,'Updating data from the marketplace...','en'),(2839,2839,'You can purchase AntiFraud Service subscription','en'),(2840,2840,'You need these links in case you want to recover your store','en'),(2841,2841,'or use the form below','en'),(2842,2842,'the same as billing','en'),(2843,2843,'Add product','en'),(2844,2844,'Are you sure you want to enable https anyway?','en'),(2845,2845,'Check for updates','en'),(2846,2846,'Install anyway','en'),(2847,2847,'Update modules','en'),(2848,2848,'The \"{{file}}\" file is not allowed and was not uploaded. Allowed extensions are: {{extensions}}','en'),(2849,2849,'Couldn\'t download the banner \"{{value}}\"','en'),(2850,2850,'Error of banner loading. Make sure the \"images\" directory has write permissions.','en'),(2851,2851,'Searching','en'),(2852,2852,'No results found.','en'),(2853,2853,'Enter a keyword to search.','en'),(2854,2854,'Loading more results','en'),(2855,2855,'Please enter 3 or more characters','en'),(2856,2856,'Item list','en'),(2857,2857,'Minor update','en'),(2858,2858,'Major upgrade','en'),(2859,2859,'Major improvements and new features','en'),(2860,2860,'Minor improvements','en'),(2861,2861,'{{count}} items selected','en'),(2862,2862,'Maximum items in box','en'),(2863,2863,'Upgrade not allowed','en'),(2864,2864,'X-Cart v5.3 requires PHP version 5.4 or better. Please update the PHP version installed on your server before you proceed.','en'),(2865,2865,'X-Cart v5.4 requires PHP version 7.2 or better. Please update the PHP version installed on your server before you proceed.','en'),(2866,2866,'X-Cart v5.4 requires MariaDB version 10.2.4 or better. Please update the MariaDB version installed on your server before you proceed.','en'),(2867,2867,'X-Cart v5.4 requires MySQL version 5.7.7 or better. Please update the MySQL version installed on your server before you proceed.','en'),(2868,2868,'Header, greeting & signature','en'),(2869,2869,'Greeting','en'),(2870,2870,'Header','en'),(2871,2871,'Signature','en'),(2872,2872,'State','en'),(2873,2873,'Scheme','en'),(2874,2874,'Body','en'),(2875,2875,'Dynamic message','en'),(2876,2876,'Customer email notification','en'),(2877,2877,'Admin email notification','en'),(2878,2878,'Customer','en'),(2879,2879,'Administrator','en'),(2880,2880,'Customer','en'),(2881,2881,'Administrator','en'),(2882,2882,'Add countries','en'),(2883,2883,'Subscribe','en'),(2884,2884,'Sign in / sign up','en'),(2885,2885,'Quick view','en'),(2886,2886,'Billing','en'),(2887,2887,'Enable this if you would like us to use your shipping address as your billing address','en'),(2888,2888,'Proceed to payment','en'),(2889,2889,'Shipping to','en'),(2890,2890,'Billing to','en'),(2891,2891,'same as shipping','en'),(2892,2892,'Choose shipping','en'),(2893,2893,'Payment','en'),(2894,2894,'There is already state with code {{code}} in {{country}}','en'),(2895,2895,'Last time re-deployed at','en'),(2896,2896,'YES','en'),(2897,2897,'NO','en'),(2898,2898,'E-mail will also be updated in all the related orders.','en'),(2899,2899,'The countries to which the selected states belong will be added to the zone automatically.','en'),(2900,2900,'Hi,<br/><br/>X-Cart Team have done their best to make your upgrade process as enjoyable as possible. If that didn’t work out well for you, please follow these quick steps to get it right:','en'),(2901,2901,'First, restore your website from the created backup - this is the fastest way to get your store back online.','en'),(2902,2902,'Second, try to disable all non-X-Cart modules by using the links below:','en'),(2903,2903,'Soft reset. Turn off all addons except those provided by X-Cart Team & Qualiteam','en'),(2904,2904,'Hard reset. Disable all addons except those provided by X-Cart Team','en'),(2905,2905,'If you still need help, please, feel free to contact X-Cart Help Desk at <a href=”mailto:helpdesk@x-cart.com”>helpdesk@x-cart.com</a>. Remember to attach the log files (from “xcart_directory/var/log”) to your email, so that their tech engineers could instantly spot the problem and help you to fix it in the most effective way possible.','en'),(2906,2906,'Performing task...','en'),(2907,2907,'This process may take a while to complete. Please do not close this page until the process is fully completed. If you have closed the page, please re-open it to complete the process as it is in progress only when the page is open.','en'),(2908,2908,'Recalculate view lists','en'),(2909,2909,'This action reloads each @ListChild annotation and updates view list records in database.','en'),(2910,2910,'Clear data and widget cache','en'),(2911,2911,'Cache clearing might be helpful if there are some widgets with outdated information. Clicking this will remove data from cache driver.','en'),(2912,2912,'Start','en'),(2913,2913,'Orders awaiting processing','en'),(2914,2914,'Awaiting processing','en'),(2915,2915,'Only orders awaiting processing','en'),(2916,2916,'On category listing','en'),(2917,2917,'On category and product details page','en'),(2918,2918,'Column \"{{value}}\" is required','en'),(2919,2919,'Wrong format of \"order number\" field','en'),(2920,2920,'Wrong format of \"anonymous\" field','en'),(2921,2921,'Wrong format of \"address same\" field','en'),(2922,2922,'Wrong format of \"subtotal\" field','en'),(2923,2923,'Wrong format of \"total\" field','en'),(2924,2924,'Wrong format of \"currency\" field','en'),(2925,2925,'Fulfilment status not found, \"New\" will be used for order','en'),(2926,2926,'Payment status not found, \"Awaiting payment\" will be used for order','en'),(2927,2927,'Order modifier \"{{value}}\" not found','en'),(2928,2928,'Wrong format of \"order modifier\" field','en'),(2929,2929,'Wrong format of \"order item\", required fields \"{{value}}\" are missing','en'),(2930,2930,'Wrong format of \"order item sku\" field','en'),(2931,2931,'Wrong format of \"order item name\" field','en'),(2932,2932,'Wrong format of \"order item price\" field','en'),(2933,2933,'Wrong format of \"order item subtotal\" field','en'),(2934,2934,'Wrong format of \"order item total\" field','en'),(2935,2935,'Wrong format of \"order item quantity\" field','en'),(2936,2936,'Order item modifier not found','en'),(2937,2937,'Wrong format of \"order item modifier\" field','en'),(2938,2938,'Wrong format of \"order transaction\", required fields \"{{value}}\" are missing','en'),(2939,2939,'Wrong format of \"order transaction method\" field','en'),(2940,2940,'Order transaction status not found','en'),(2941,2941,'Wrong format of \"order transaction value\" field','en'),(2942,2942,'Order transaction type not found','en'),(2943,2943,'Wrong format of \"order transaction id\" field','en'),(2944,2944,'Wrong format of \"order transaction currency\" field','en'),(2945,2945,'No account yet?','en'),(2946,2946,'No problem! Enter your email address','en'),(2947,2947,'Log in to your account','en'),(2948,2948,'to enjoy faster & easier checkout','en'),(2949,2949,'or proceed with','en'),(2950,2950,'You can continue as guest or <a href=\"{{URL}}\" class=\"sign-in register\">create an account</a>','en'),(2951,2951,'Apply sorting globally','en'),(2952,2952,'Integrity check','en'),(2953,2953,'Unknown core version','en'),(2954,2954,'The core may be checked only if a valid license key is present.','en'),(2955,2955,'The module may be checked only if a valid license key is present.','en'),(2956,2956,'Cannot check the files for this module','en'),(2957,2957,'Refresh integrity status','en'),(2958,2958,'Added','en'),(2959,2959,'Modified','en'),(2960,2960,'Removed','en'),(2961,2961,'Errors','en'),(2962,2962,'Integrity has not yet been checked. Initiate an integrity check by clicking the button \"Refresh integrity status\".','en'),(2963,2963,'Integrity check has been completed successfully.','en'),(2964,2964,'Integrity check has been stopped.','en'),(2965,2965,'Switch to <a href=\"javascript: void(0)\">Category tree</a>','en'),(2966,2966,'Switch to <a href=\"javascript: void(0)\">Category search</a>','en'),(2967,2967,'Parent category name','en'),(2968,2968,'All addons','en'),(2969,2969,'Disabled only','en'),(2970,2970,'Enabled only','en'),(2971,2971,'Please be warned that proper operation of the site after an upgrade is not guaranteed if you choose to upgrade only some of the components listed below. Please use the selective upgrade feature at your own risk and only if you know exactly what you are doing.','en'),(2972,2972,'Enable selected','en'),(2973,2973,'Disable selected','en'),(2974,2974,'Enable all','en'),(2975,2975,'Disable all','en'),(2976,2976,'Clone selected','en'),(2977,2977,'This field will be required if the selected country has states, and will not be required if the selected country does not have states.','en'),(2978,2978,'Will be available if core update is selected','en'),(2979,2979,'No category assigned','en'),(2980,2980,'Not assigned','en'),(2981,2981,'Developer wave','en'),(2982,2982,'Your license key is set up to get upgrades in the  {{wave_name}} wave. Therefore, upgrading may require some technical assistance on your part. If you are not prepared to deal with upgrade issues that may arise when upgrading in the developer wave, please, wait for the merchant wave. You can switch to the merchant wave <a  href=\"{{link_to_waves}}\" target=\"_blank\">on this page</a>','en'),(2983,2983,'Products in this class: {{X}}','en'),(2984,2984,'Canceling','en'),(2985,2985,'Installing native <a target=\'_blank\' href=\'http://php.net/manual/en/mbstring.installation.php\'><b>mbstring extension</b></a> is highly recommended due to the major speedup of PDF generation and general string processing.','en'),(2986,2986,'<a href=\"http://php.net/manual/en/dom.installation.php\" target=\"_blank\"><b>DOM extension</b></a> must be enabled to ensure that email notifications work correctly.','en'),(2987,2987,'<p>There are currently no orders in the store. Once your store has orders, this is where you’ll process and track them. Get accustomed with the order workflow at <a target=\'_blank\' href=\'https://kb.x-cart.com/en/orders/understanding_x-cart_order_statuses.html\'>X-Cart Knowledge Base</a>.</p>','en'),(2988,2988,'There are currently no orders in the store.','en'),(2989,2989,'<p>No payment transactions have been made yet. Once a customer will place an order, this is where you can track payment status and transaction details.</p>','en'),(2990,2990,'<p>Products catalog is empty. Start your sales by adding products using the <b>\"Add product\"</b> button or via import. Learn how to configure a product at <a target=\'_blank\' href=\'https://kb.x-cart.com/en/products/adding_products.html#adding-a-new-product\'>X-Cart Knowledge Base</a>.</p>','en'),(2991,2991,'Products catalog is empty.','en'),(2992,2992,'<p>There are no categories in the store. Group your products by adding categories using the <b>\"New category\"</b> button or via import.</p>','en'),(2993,2993,' <p>There are no memberships in the store. Memberships allow you to group your customers and give them different privileges. You can add them by clicking the <b>\"New membership\"</b> button, Learn more at <a target=\'_blank\' href=\'https://kb.x-cart.com/en/users/adding_user_membership_levels.html\'>X-Cart Knowledge Base</a>.</p>','en'),(2994,2994,'Categories processed','en'),(2995,2995,'Processing categories...','en'),(2996,2996,'Categories processed: {{X}} out of {{Y}} (errors: {{errors}}, warnings: {{warns}})','en'),(2997,2997,'Categories processed: {{X}} out of {{Y}}','en'),(2998,2998,'Categories processed: {{count}}','en'),(2999,2999,'Order {{order_number}} has been confirmed as delivered to the customer.','en'),(3000,3000,'Products with no assigned categories','en'),(3001,3001,'The selected categories have been deleted. As a result, there are products with no assigned category. You can re-arrange the location of these products by using bulk edit.','en'),(3002,3002,'Show products with no assigned category','en'),(3003,3003,'The import process has been canceled','en'),(3004,3004,'Logout this user','en'),(3005,3005,'Profile actions','en'),(3006,3006,' <p>There are no subcategories in the category.</p>','en'),(3007,3007,'The product you are trying to add to cart is unavailable.','en'),(3008,3008,'Current password','en'),(3009,3009,'<a href=\"{{url}}\">Send reset link</a>','en'),(3010,3010,'Installation script','en'),(3011,3011,'The root folder of your installed X-Cart store still contains the file install.php that is used to launch X-Cart installation. Keeping this file in the said location \'as is\' is not secure. We strongly recommend that this file should be deleted or renamed to prevent unauthorized access to the store installation tools.','en'),(3012,3012,'Config file','en'),(3013,3013,'Config file does not exist and cannot be copied from the default config file. It is required for the installation.<br /><br />Please, follow these steps: <br /><br />1. Go to directory {{configPath}}<br />2. Copy <i>{{defaultConfigFileName}}</i> to <i>{{configFileName}}</i><br />3. Set writeable permissions on <i>{{configFileName}}</i><br /><br />Then try again.','en'),(3014,3014,'Config file does not exist and cannot be copied from the default config file. It is required for the installation.<br /><br />Please, follow these steps: <br /><br />1. Go to directory {{configPath}}<br />2. Copy <i>{{defaultConfigFileName}}</i> to <i>{{configFileName}}</i><br />3. Set writeable permissions on <i>{{configFileName}}</i><br /><br />Then try again.','en'),(3015,3015,'PHP version','en'),(3016,3016,'PHP Version must be at least {{minPhpVersion}}.','en'),(3017,3017,'PHP Version must be not greater than {{maxPhpVersion}}.','en'),(3018,3018,'Unsupported PHP version detected.','en'),(3019,3019,'PHP versions <b>7.2.0+</b> are currently supported.','en'),(3020,3020,'Disabled functions','en'),(3021,3021,'The following functions are disabled:<br/>:missedFunctions<br/>These functions may be used by the software in some cases and should be enabled.','en'),(3022,3022,'Some functions, used by X-Cart, are found disabled. Make sure that these functions are not listed in \"disable_functions\" option and all php extensions required for these functions availability are enabled in the php.ini file. Please correct this and try again.','en'),(3023,3023,'Memory limit','en'),(3024,3024,'PHP memory_limit option must be at least {{memoryLimitMin}}.','en'),(3025,3025,'PHP memory_limit option must be at least {{memoryLimitMin}}.','en'),(3026,3026,'File uploads','en'),(3027,3027,'PHP file_uploads option must be set to On.','en'),(3028,3028,'The configuration of the server where X-Cart will be installed meets the Server requirements; however, some server software issues, which can impair X-Cart operation, have been identified on the server.<br /><br />For proper operation of X-Cart the value of the upload_max_filesize variable in the php.ini file should indicate the maximum file size allowed for upload.','en'),(3029,3029,'PDO extension','en'),(3030,3030,'PDO extension with MySQL support must be installed.','en'),(3031,3031,'PDO extension with enabled MySQL support is used by X-Cart for connecting to the database. Please make sure this extension is loaded in your php.ini file and try again.','en'),(3032,3032,'Check our <a href=\"https://kb.x-cart.com/en/general_setup/installation_guide.html#disabled-php-extensions\" target=\"_blank\">Knowledge Base</a> in order to find out how to solve the problem with PDO extension.','en'),(3033,3033,'Upload file size limit','en'),(3034,3034,'PHP option upload_max_filesize must contain a value. It is currently empty.','en'),(3035,3035,'For proper operation of X-Cart the value of the upload_max_filesize option in the php.ini file should indicate the maximum file size allowed for upload. Please correct this option or contact your hosting provider\'s support to have the parameter adjusted.','en'),(3036,3036,'File permissions','en'),(3037,3037,'Not enough permissions to run the process. Please make sure the following files are writable:<br /><div class=\"permissions-list\">{{pathsList}}</div>','en'),(3038,3038,'Not enough permissions to run the process. Make sure the following permissions are set (UNIX-like systems only):<br /><div class=\"permissions-list\">{{pathsList}}</div>Such permissions are required for a seamless automated installation or upgrade of X-Cart on your server. They do not take into account the specific configuration of your server or any security requirements. Once the process is completed, make sure you change the permissions to a more restrictive setting. <a target=\"_blank\" href=\"https://kb.x-cart.com/en/setting_up_x-cart_5_environment/secure_configuration.html#why-x-cart-asks-for-666777-permissions\">Read more</a>','en'),(3039,3039,'Check our <a href=\"https://kb.x-cart.com/en/general_setup/installation_guide.html#permissionchecking-failed\" target=\"_blank\">Knowledge Base</a> in order to find out how to solve the problem with incorrect permissions.','en'),(3040,3040,'MySQL version','en'),(3041,3041,'MySQL version must be at least {{minMysqlVersion}}.','en'),(3042,3042,'InnoDB engine is not supported by MySQL server. InnoDB is required for X-Cart operation.','en'),(3043,3043,'Cannot get MySQL server version ({{error}}).','en'),(3044,3044,'MySQL cache','en'),(3045,3045,'MySQL query cache is not enabled. See <a href=\"https://dev.mysql.com/doc/refman/5.7/en/query-cache-configuration.html\" target=\"_blank\">https://dev.mysql.com/doc/refman/5.7/en/query-cache-configuration.html</a> for how to enable it.','en'),(3046,3046,'GDlib extension','en'),(3047,3047,'GDlib extension v.2.0 or later is required for some modules.','en'),(3048,3048,'GDlib extension does not have the JPEG plugin.','en'),(3049,3049,'Phar extension','en'),(3050,3050,'Phar extension must be installed.','en'),(3051,3051,'Phar extension is required for installation of external X-Cart addons and upgrades from the Marketplace. Please contact your hosting provider\'s support to have this parameter adjusted.','en'),(3052,3052,'HTTPS bouncers','en'),(3053,3053,'libcurl extension is found but does not support secure protocols.','en'),(3054,3054,'libcurl extension not found.','en'),(3055,3055,'The libCURL module with HTTPS protocol support and a valid SSL certificate is required for credit cards processing via Authorize.NET, PayPal or other payment gateways and using real-time shipping calculation services (these services require your website to accept secure connections via HTTPS/SSL). Please contact your hosting provider\'s support to have these parameters adjusted.','en'),(3056,3056,'Check our <a href=\"https://kb.x-cart.com/en/general_setup/installation_guide.html#https-bouncer-is-not-installed\" target=\"_blank\">Knowledge Base</a> in order to find out how to solve the problem with libCurl library.','en'),(3057,3057,'XML extensions support','en'),(3058,3058,'XML/Expat and DOM extensions are required for some modules.','en'),(3059,3059,'Xml/EXPAT and DOMDocument extensions for PHP are required for using real-time shipping modules and payment modules. Please contact your hosting provider\'s support to have these parameters adjusted.','en'),(3060,3060,'DocBlocks support','en'),(3061,3061,'The DocBlock feature is not supported by your PHP. This feature is required for X-Cart operation.','en'),(3062,3062,'The DocBlock feature is not supported by your PHP. This feature is required for X-Cart operation. The cause of DocBlock feature being blocked may be the eAccelerator extension. Disable this extension and try again.','en'),(3063,3063,'Check our <a href=\"https://kb.x-cart.com/en/general_setup/installation_guide.html#permissionchecking-failed\" target=\"_blank\">Knowledge Base</a> in order to find out how to solve the problem with incorrect permissions.','en'),(3064,3064,'Loopback request','en'),(3065,3065,'My Addons (service.php) is not available, please <a href=\"{{url}}\">contact us</a>','en'),(3066,3066,'','en'),(3067,3067,'','en'),(3068,3068,'Category id or path is required','en'),(3069,3069,'Last element of category path should be same as name if no category id is presented','en'),(3070,3070,'Category with id \"{{value}}\" not found, new category with different id will be created','en'),(3071,3071,'CSV format tables','en'),(3072,3072,'Need to set up free shipping? <a href=\"{{url}}\" target=\"_blank\">Learn how</a>.','en'),(3073,3073,'Show states for selected countries only','en'),(3074,3074,'Profile details','en'),(3075,3075,'Attention!','en'),(3076,3076,'Ok, Got it','en'),(3077,3077,'To install modules and get X-Cart upgrades, PHP\'s <a href=\"http://php.net/manual/en/book.phar.php\" target=\"_blank\">Phar extension</a> needs to be enabled on your server. Please contact your hosting provider.','en'),(3078,3078,'Also, you can review X-Cart recommended hosting providers <a href=\"https://market.x-cart.com/experts-and-services#filter[tags]=Hosters\" target=\"_blank\">in our marketplace</a>.','en'),(3079,3079,'Your X-Cart Business trial has expired!','en'),(3080,3080,'You must register your X-Cart installation before using it for real sales. Activate your existing license key or purchase a <strong>premium license to skyrocket your business</strong>.','en'),(3081,3081,'This message can be removed only through activation of a free or premium license.','en'),(3082,3082,'Refer to <a href=\"{{licenseAgreementURL}}\" target=\"_blank\" rel=\"nofollow\">X-Cart license agreement</a> for further details.','en'),(3083,3083,'Remind me on next sign-in','en'),(3084,3084,'Purchase a premium license key','en'),(3085,3085,'I have a license key','en'),(3086,3086,'Enter your premium license key','en'),(3087,3087,'<a href=\"{{url}}\">Activate free X-Cart license & remove premium features.</a>','en'),(3088,3088,'<a href=\"{{url}}\" target=\"_blank\" rel=\"nofollow\">Contact X-Cart</a> if you have any questions.','en'),(3089,3089,'License key registration','en'),(3090,3090,'X-Cart Business trial will expire in {{count}} day','en'),(3091,3091,'X-Cart Business trial will expire in {{count}} days','en'),(3092,3092,'X-Cart Business trial will expire in {{count}} days','en'),(3093,3093,'Please register your license key now or purchase a <strong>premium license to skyrocket your business</strong>.','en'),(3094,3094,'{{count}} day left','en'),(3095,3095,'{{count}} days left','en'),(3096,3096,'{{count}} days left','en'),(3097,3097,'Trial has expired!','en'),(3098,3098,'Register license key','en'),(3099,3099,'Warning! The image cannot be resized to reduce capacity for better site performance.','en'),(3100,3100,'Previous order','en'),(3101,3101,'Next order','en'),(3102,3102,'Click to expand menu','en'),(3103,3103,'<span>Need a way to set multicurrency prices?</span> <a href=\"{{url}}\" target=\"_blank\">Install the addon</a>','en'),(3104,3104,'<span>Need a way to set up product variants?</span> <a href=\"{{url}}\" target=\"_blank\">Install the addon</a>','en'),(3105,3105,'<span>Need a way to set wholesale prices?</span> <a href=\"{{url}}\" target=\"_blank\">Install the addon</a>','en'),(3106,3106,'Image quality after resize','en'),(3107,3107,'Apply unsharp mask filter on resize','en'),(3108,3108,'Clearing this field hides the option for this product only. To remove the attribute for all the products, use the <a href=\"{{link}}\" target=\"_blank\">\"Classes & Attributes\" page</a>.','en'),(3109,3109,'Apply attribute value changes for all the products','en'),(3110,3110,'Will be added globally','en'),(3111,3111,'Will be added to the product class','en'),(3112,3112,'The name will be changed globally','en'),(3113,3113,'The totals have been recalculated. Press \"Save changes\" to adjust the order','en'),(3114,3114,'Your access to <a href=\"{{url}}\">X-Cart Business features</a> expires in {{count}} day','en'),(3115,3115,'Your access to <a href=\"{{url}}\">X-Cart Business features</a> expires in {{count}} days','en'),(3116,3116,'Your access to <a href=\"{{url}}\">X-Cart Business features</a> expires in {{count}} days','en'),(3117,3117,'Discounts','en'),(3118,3118,'Marketing','en'),(3119,3119,'My addons','en'),(3120,3120,'Custom CSS & JS','en'),(3121,3121,'System tools','en'),(3122,3122,'System logs','en'),(3123,3123,'My profile','en'),(3124,3124,'Quick menu','en'),(3125,3125,'Add sales channel','en'),(3126,3126,'Saving','en'),(3127,3127,'Users list','en'),(3128,3128,'Image resizing requires GDLib 2.0 or ImageMagick','en'),(3129,3129,'Your payment has been processed; now the addon can be installed.','en'),(3130,3130,'Your payment is being processed. The addon license key will be sent to your email address as soon as the processing has been completed. You will be able to use this key to install the addon at any time.','en'),(3131,3131,'Purchased addons','en'),(3132,3132,'My purchases','en'),(3133,3133,'new core','en'),(3134,3134,'{{count}} addon','en'),(3135,3135,'{{count}} addons','en'),(3136,3136,'{{count}} addons','en'),(3137,3137,'new core and {{count}} addon','en'),(3138,3138,'new core and {{count}} addons','en'),(3139,3139,'new core and {{count}} addons','en'),(3140,3140,'<a href=\"{{url}}\">Or add a video review powered by Shopper Approved</a>','en'),(3141,3141,'Want to customize review surveys and display video testimonials? <a href=\"{{url}}\">Try Shopper Approved and collect up to 70x more ratings and reviews</a>','en'),(3142,3142,'Consistency check','en'),(3143,3143,'Surcharges','en'),(3144,3144,'There are {{model}} without valid {{another_model}} relation','en'),(3145,3145,'There are {{model}} with missing {{another_model}}','en'),(3146,3146,'Attribute value ID {{valueId}}','en'),(3147,3147,'Attribute values (select)','en'),(3148,3148,'We couldn\'t find one correct root category','en'),(3149,3149,'We couldn\'t find one correct root category, however there are possible candidates','en'),(3150,3150,'There is one valid root category, however there are multiple root category candidates','en'),(3151,3151,'Consistency has not yet been checked. Initiate an consistency check by clicking the button \"Refresh consistency status\".','en'),(3152,3152,'Refresh consistency status','en'),(3153,3153,'There are no inconsistencies found','en'),(3154,3154,'RoundUp','en'),(3155,3155,'No roundup','en'),(3156,3156,'up to 2 decimals','en'),(3157,3157,'up to 1 decimal','en'),(3158,3158,'up to integer','en'),(3159,3159,'up to 10','en'),(3160,3160,'up to 100','en'),(3161,3161,'<span>Need a customizable contact us form with location map?</span> <a href=\"{{url}}\" target=\"_blank\">Get it now!</a>','en'),(3162,3162,'Order staff notes changed','en'),(3163,3163,'Order customer notes changed','en'),(3164,3164,'Order has been edited','en'),(3165,3165,'Let TaxJar automate your sales tax calculations, reporting, and filings in minutes.','en'),(3166,3166,'TaxJar enabled','en'),(3167,3167,'Sign up for TaxJar','en'),(3168,3168,'Install TaxJar integration','en'),(3169,3169,'TaxJar Dashboard','en'),(3170,3170,'TaxJar Category','en'),(3171,3171,'We recommend to configure the background job processing on your server to send emails asynchronously, improving the website performance. <a href=\"{{url}}\" target=\"_blank\">Learn how to do this</a>.','en'),(3172,3172,'Change payment status for selected','en'),(3173,3173,'Change fulfillment status for selected','en'),(3174,3174,'Installing addons','en'),(3175,3175,'Attention! You are creating an account with full access. If necessary, you can set a lower level of access by choosing an appropriate role. <a href=\"{{roles_link}}\" target=\"_blank\">Manage roles</a>. <a href=\"{{kb_link}}\" target=\"_blank\">Learn more</a> about permissions and roles.','en'),(3176,3176,'Contact Us page settings','en'),(3177,3177,'Date and time on the server','en'),(3178,3178,'Date and time in the store','en'),(3179,3179,'The file you are trying to upload is too large. Try using a smaller one.','en'),(3180,3180,'The file you are trying to upload is too large. Try using a smaller one.','en'),(3181,3181,'For some reason, the file upload has not been completed. Please try again or use a different file.','en'),(3182,3182,'For some reason, the file upload has not been completed. Please try again or use a different file.','en'),(3183,3183,'Server-side problem with image upload. Contact your server administrator.','en'),(3184,3184,'Server-side problem with image upload. Contact your server administrator.','en'),(3185,3185,'Server-side problem with image upload. Contact your server administrator.','en'),(3186,3186,'No file was uploaded','en'),(3187,3187,'Your PHP {{version}} is outdated','en'),(3188,3188,'Your PHP {{version}} is outdated and no longer supported (<a href=\"http://php.net/eol.php\" target=\"_blank\">http://php.net/eol.php</a>). We recommend updating PHP to the latest stable version to improve your store performance. To update your PHP version, contact your hosting provider.','en'),(3189,3189,'Failed to download image from URL. Make sure the URL is correct and the file referenced by the URL is a PNG/JPG/JPEG','en'),(3190,3190,'Transaction is in progress, please wait...','en'),(3191,3191,'to be uninstalled','en'),(3192,3192,'Review modules','en'),(3193,3193,'Logo image','en'),(3194,3194,'Manage logo dimensions','en'),(3195,3195,'E-Mail transfer settings','en'),(3196,3196,'Email from the Contact information section','en'),(3197,3197,'Sender email as identified by the server','en'),(3198,3198,'Email address specified below','en'),(3199,3199,'Specify email address','en'),(3200,3200,'Go to <a href=\'https://www.mail-tester.com/\' target=\'_blank\'>https://www.mail-tester.com/</a> and copy the email address provided on that page to clipboard. ','en'),(3201,3201,'Paste the email address you have copied into the form below (the \"To email\" field) and try sending a test email.','en'),(3202,3202,'Go back to <a href=\'https://www.mail-tester.com/\' target=\'_blank\'>https://www.mail-tester.com/</a> and press the button to check your score. Allow a few seconds for the mail tester system to check the inbox and calculate your score. The highest score would be 10/10.','en'),(3203,3203,'Share the results with your hosting provider or administrators and, if necessary, ask them to improve your score. ','en'),(3204,3204,'Learn how to test your email transfer settings with mail-tester.com.','en'),(3205,3205,'body of the test email','en'),(3206,3206,'Test your emails','en'),(3207,3207,'If a category has subcategories, the value in brackets shows the overall number of products in both that category and all its subcategories.','en'),(3208,3208,'Please select','en'),(3209,3209,'Recently installed addons','en'),(3210,3210,'Installed Addons','en'),(3211,3211,'Free & paid','en'),(3212,3212,'You don’t have any notifications right now.','en'),(3213,3213,'Status comment (reason)','en'),(3214,3214,'Import and Export','en'),(3215,3215,'Setting up tax','en'),(3216,3216,'Setting up Canadian taxes','en'),(3217,3217,'Setting up tax classes','en'),(3218,3218,'Setting up European / UK Taxes','en'),(3219,3219,'Setting up US Taxes','en'),(3220,3220,'https://kb.x-cart.com/','en'),(3221,3221,'https://kb.x-cart.com/general_setup/what_to_do_if_your_store_says_we_are_deploying_new_changes_and_you_cannot_access_it.html','en'),(3222,3222,'https://kb.x-cart.com/general_setup/moving_x-cart_to_another_location.html#transfering-database','en'),(3223,3223,'https://kb.x-cart.com/seo_and_promotion/setting_up_seo-friendly_urls.html','en'),(3224,3224,'https://kb.x-cart.com/general_setup/moving_x-cart_to_another_location.html','en'),(3225,3225,'https://kb.x-cart.com/import-export/','en'),(3226,3226,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_classes_&_attributes.html','en'),(3227,3227,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_product_attribute_values.html','en'),(3228,3228,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_categories.html','en'),(3229,3229,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_customers.html','en'),(3230,3230,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_products.html','en'),(3231,3231,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_orders.html','en'),(3232,3232,'https://kb.x-cart.com/setting_up_x-cart_5_environment/configuring_attachments_sending.html','en'),(3233,3233,'https://kb.x-cart.com/payments/paypal/setting_up_paypal_express_checkout.html','en'),(3234,3234,'https://kb.x-cart.com/payments/paypal/setting_up_paypal_payflow_link.html','en'),(3235,3235,'https://kb.x-cart.com/payments/paypal/setting_up_paypal_payments_advanced.html','en'),(3236,3236,'https://kb.x-cart.com/payments/paypal/setting_up_paypal_payments_standard.html','en'),(3237,3237,'https://kb.x-cart.com/integrating_your_store_with_other_web-sites/sell_your_products_with_buy_button.html','en'),(3238,3238,'https://kb.x-cart.com/shipping/custom_table_rates.html','en'),(3239,3239,'https://kb.x-cart.com/general_setup/inaccessible_admin_area_after_enabling_https.html','en'),(3240,3240,'https://kb.x-cart.com/users/user_roles.html','en'),(3241,3241,'https://kb.x-cart.com/shipping/free_shipping.html','en'),(3242,3242,'https://kb.x-cart.com/taxes/tax_guide.html','en'),(3243,3243,'https://kb.x-cart.com/taxes/UK_EU_taxes/','en'),(3244,3244,'https://kb.x-cart.com/taxes/us_taxes/','en'),(3245,3245,'https://kb.x-cart.com/taxes/canadian_taxes/','en'),(3246,3246,'https://kb.x-cart.com/taxes/setting_up_tax_classes.html','en'),(3247,3247,'Email from the <a href=\"{{url}}\">contact information</a> section according to the type of email message','en'),(3248,3248,'Customer email (if exists)','en'),(3249,3249,'Wonder why it may have happened? It’s likely that your customer entered a wrong card number, password or CVC, had no money on his card, closed his browser by mistake or just fleeted away.<br><br>It may be a good idea to contact him and offer your help.','en'),(3250,3250,'Transaction was failed','en'),(3251,3251,'{{ field }} year must be between 1970 and 2038','en'),(3252,3252,'If the product is not available for sale, the system will return 404 response (page not found).','en'),(3253,3253,'If the product is not available for sale, the system will return <a href=\"{{productLink}}\" target=\"_blank\">404 not found page</a> with related products list as alternatives.','en'),(3254,3254,'If the category is disabled, the system will return <a href=\"{{categoryLink}}\" target=\"_blank\">404 not found page</a> with featured products list as alternatives.','en'),(3255,3255,'{{count}} day','en'),(3256,3256,'{{count}} days','en'),(3257,3257,'Access denied','en'),(3258,3258,'Access link has been sent','en'),(3259,3259,'Add addons','en'),(3260,3260,'Add address','en'),(3261,3261,'Address masks','en'),(3262,3262,'Address type','en'),(3263,3263,'Another bulk change in progress, please try again later','en'),(3264,3264,'Apply to billing address','en'),(3265,3265,'Business premium features','en'),(3266,3266,'CVV / CVC','en'),(3267,3267,'Change template','en'),(3268,3268,'Clear cache help text','en'),(3269,3269,'Critical','en'),(3270,3270,'Data removal has been completed successfully.','en'),(3271,3271,'Data removal has been stopped.','en'),(3272,3272,'Database','en'),(3273,3273,'Date and time in the shop','en'),(3274,3274,'Developer','en'),(3275,3275,'Disable HTTPS','en'),(3276,3276,'Download','en'),(3277,3277,'Enable module','en'),(3278,3278,'Error sending link','en'),(3279,3279,'File uploading','en'),(3280,3280,'Finish','en'),(3281,3281,'Hot addons','en'),(3282,3282,'Installation requirements','en'),(3283,3283,'License warnings','en'),(3284,3284,'Module name','en'),(3285,3285,'Monday','en'),(3286,3286,'Non-critical','en'),(3287,3287,'Not available','en'),(3288,3288,'Passed','en'),(3289,3289,'Payment order status','en'),(3290,3290,'Please select the entities first','en'),(3291,3291,'Private and custom modules:','en'),(3292,3292,'Private link','en'),(3293,3293,'Proceed','en'),(3294,3294,'Public installed modules:','en'),(3295,3295,'Rebuild view lists help text','en'),(3296,3296,'Remove expired sessions','en'),(3297,3297,'Remove expired shopping carts','en'),(3298,3298,'Remove module','en'),(3299,3299,'Removing expired datacache','en'),(3300,3300,'SKU must be unique','en'),(3301,3301,'Select type','en'),(3302,3302,'Shipping method is disabled','en'),(3303,3303,'Shipping method is enabled','en'),(3304,3304,'Shipping order status','en'),(3305,3305,'Skipped','en'),(3306,3306,'Soft and hard reset links for your store','en'),(3307,3307,'Sort','en'),(3308,3308,'Store ID','en'),(3309,3309,'Sunday','en'),(3310,3310,'Test e-mail have been successfully sent','en'),(3311,3311,'The Clean URL entered has unallowed chars.','en'),(3312,3312,'This payment method is','en'),(3313,3313,'Unknown error','en'),(3314,3314,'View in my addons','en'),(3315,3315,'Dashboard','en'),(3316,3316,'Dimensions','en'),(3317,3317,'<p>Oops, no products have been added to this category yet.</p><p><a href=\"{{homePageUrl}}\">Go back to the Home page</a></p>','en'),(3318,3318,'Backordered','en'),(3319,3319,'Backordered (qty: {{qty}})','en'),(3320,3320,'This order was placed at the same time as {{orders}}; as a result, some items were out of stock at the time of order placement. <a href=\"{{kb_link}}\" target=\"_blank\">Learn more</a>','en'),(3321,3321,'Some items were out of stock at the time of order placement. <a href=\"{{kb_link}}\" target=\"_blank\">Learn more</a>','en'),(3322,3322,'Discard','en'),(3323,3323,'The Backorder status will be reset for the items. <br>The stock quantity of the backorder items will not change. Adjust it manually if necessary.','en'),(3324,3324,'Left in stock: {{quantity}}','en'),(3325,3325,'Enter alt text','en'),(3326,3326,'Select a date','en'),(3327,3327,'Start typing a category name','en'),(3328,3328,'<h6>Category is not accessible</h6><p>Your products are still accessible through the search and by direct link</p>','en'),(3329,3329,'Weak','en'),(3330,3330,'Good','en'),(3331,3331,'Strong','en'),(3332,3332,'Customer area','en'),(3333,3333,'Admin panel','en'),(3334,3334,'Default: {{code}}','en'),(3335,3335,'Original name','en'),(3336,3336,'Title for customers','en'),(3337,3337,'Description for customers','en'),(3338,3338,'Last exported','en'),(3339,3339,'Insight: Boost your sales with Google Ads addon','en'),(3340,3340,'Set up LiveChat, the fastest way to help your customers.','en'),(3341,3341,'The \"Amazon Pay\" feature is not configured and cannot be used.','en'),(3342,3342,'The \"Amazon Pay\" feature requires https to be <a href=\"{{url}}\">properly set up</a> for your store.','en'),(3343,3343,'Amazon Seller ID','en'),(3344,3344,'If you do not have seller account, you can register here:<br /><a href=\"https://payments.amazon.com/signup?LD=SPEXUSAPA_XCart_core\" target=\"_blank\">USA</a>,&nbsp;<a href=\"https://payments.amazon.co.uk/preregistration/lpa?LD=SPEXUKAPA_XCart_core\" target=\"_blank\">UK</a>,&nbsp;<a href=\"https://payments.amazon.de/preregistration/lpa?LD=SPEXDEAPA_XCart_core\" target=\"_blank\">Germany</a>','en'),(3345,3345,'Operation mode','en'),(3346,3346,'Access Key ID','en'),(3347,3347,'Secret Access Key','en'),(3348,3348,'Client ID','en'),(3349,3349,'Register your website as an application on the <a href=\"http://login.amazon.com/manageApps\" trget=\"_blank\">Login with Amazon App Console</a>. For more information, see the <a href=\"https://images-na.ssl-images-amazon.com/images/G/01/lwa/dev/docs/website-gsg._TTH_.pdf\" target=\"_blank\">Login with Amazon Getting Started Guide</a>. A client identifier (Client ID) is set when you register your website. You will need this identifier for your integration.','en'),(3350,3350,'Country of Merchant account','en'),(3351,3351,'Capture mode','en'),(3352,3352,'Type of authorization request','en'),(3353,3353,'OrderId prefix','en'),(3354,3354,'Amazon Pay','en'),(3355,3355,'Refresh','en'),(3356,3356,'Refund refresh','en'),(3357,3357,'Authorization status: {{status}}','en'),(3358,3358,'Refund status: {{status}}','en'),(3359,3359,'Payment has been captured successfully.','en'),(3360,3360,'Payment capture error: {{error}}','en'),(3361,3361,'Payment have been voided successfully.','en'),(3362,3362,'Payment void error: {{error}}','en'),(3363,3363,'Payment has been refunded successfully.','en'),(3364,3364,'Refund is in progress...','en'),(3365,3365,'Payment refund error: {{error}}','en'),(3366,3366,'Payment has been authorized successfully.','en'),(3367,3367,'Payment has been declined.','en'),(3368,3368,'Payment transaction is in progress...','en'),(3369,3369,'That payment method was not accepted for this transaction. Please choose another.','en'),(3370,3370,'Amazon has rejected the authorisation.','en'),(3371,3371,'Amazon could not process the transaction due to an internal processing error.','en'),(3372,3372,'To ensure that the status of payments in your store is updated automatically after Amazon processes the respective payment requests, you need to set up the endpoints.<br/><br/>Log in to Seller Central and select \'Integration Settings\' from the Settings drop-down box.<br/>Click Edit under the \'Instant Notifications Settings\' section and enter the Callback URL provided here into the \'Merchant URL\' field.','en'),(3373,3373,'Amazon Order Ref ID','en'),(3374,3374,'Callback URL','en'),(3375,3375,'Immediate Charge','en'),(3376,3376,'PayWithAmazon available actions','en'),(3377,3377,'Payment refresh error: {{error}}','en'),(3378,3378,'Refresh status','en'),(3379,3379,'Refund status','en'),(3380,3380,'This operation will cancel order. Payment authorization will be voided. Please confirm to proceed.','en'),(3381,3381,'This operation will capture funds from customer. Please confirm to proceed.','en'),(3382,3382,'This operation will refund funds to customer. Please confirm to proceed.','en'),(3383,3383,'Use existing Amazon account','en'),(3384,3384,'Your payment could not be processed. Please try to place the order again using another payment method.','en'),(3385,3385,'Your payment could not be processed, please follow the instructions in the payment method box.','en'),(3386,3386,'Amazon Pay was not able to process your payment.<br/> Please go to <a href=\"{{amazon_link}}\" target=\"_blank\">this page</a> and update the payment information for your order. Afterwards we will automatically request payment again from Amazon Pay and you will receive a confirmation email.','en'),(3387,3387,'Please update your payment information','en'),(3388,3388,'If AustraliaPost returns shipping methods that do not exist in the available methods list, these methods will be created in the list automatically. You can specify whether these methods should be created as enabled and available to customers right away, or should be hidden from customers until you manually enable them on <a href=\"{{URL}}\">the shipping methods list page</a>.','en'),(3389,3389,'Before you can start configuring the Australia Post module, you must receive the available options for the configuration settings from Australia Post. Please click the button below.','en'),(3390,3390,'The option values have been successfully updated.','en'),(3391,3391,'API Login ID','en'),(3392,3392,'Transaction key','en'),(3393,3393,'Signature  key','en'),(3394,3394,'<p>To obtain the transaction key from the Merchant Interface, do the following:</p><ul class=\'custom-disc\'><li>Log into the Merchant Interface</li><li>Select Settings from the Main Menu</li><li>Click on Obtain Transaction Key in the Security section</li><li>Type in the answer to the secret question configured on setup</li><li>Click Submit</li></ul>','en'),(3395,3395,'It\'s recommended to limit the length of invoice prefix to 9 characters. Larger prefixes will be cut prior to transaction initialization.','en'),(3396,3396,'Add this URL as the default Relay Response URL to the <b>Account</b> -> <b>Response/Receipt URLs</b> section in the <a href=\'https://account.authorize.net\'>Merchant Interface</a>.','en'),(3397,3397,'Relay Response URL is used to return the customer to invoice page after successful payment. Authorize.Net may issue the <b>Error 14</b> (The Referrer or Relay Response URL is invalid) in case this URL is not present in the <b>Merchant Interface</b>. <br/> Read more at the <a href=\'https://support.authorize.net/authkb/index?page=content&id=A601\' target=\'_blank\'>Authorize.Net Support Center</a>','en'),(3398,3398,'Don\'t have an account? <a href=\'{{link}}\' target=\'_blank\'>Sign Up Now</a>','en'),(3399,3399,'Required for SHA512 hash protection.','en'),(3400,3400,'Signature key','en'),(3401,3401,'Sales','en'),(3402,3402,'By Sales - 0-9','en'),(3403,3403,'By Sales - 9-0','en'),(3404,3404,'This field is required.','en'),(3405,3405,'Sorry, we can\'t verify you are not a robot','en'),(3406,3406,'The message has been sent','en'),(3407,3407,'Your Message','en'),(3408,3408,'Email Address','en'),(3409,3409,'Full Name','en'),(3410,3410,'We are always glad to help you.','en'),(3411,3411,'Send a message','en'),(3412,3412,'Our location','en'),(3413,3413,'This site is protected by reCAPTCHA and the Google <a href=\"https://policies.google.com/privacy\" target=\"_blank\">Privacy Policy</a> and <a href=\"https://policies.google.com/terms\" target=\"_blank\">Terms of Service</a> apply.','en'),(3414,3410,'Мы всегда рады вам помочь.','ru'),(3415,3411,'Отправить сообщение','ru'),(3416,3414,'Текстовое отображение адреса эл. почты','ru'),(3417,3415,'The length of the {{name}} field must be greater than {{min}}','en'),(3418,3416,'The length of the {{name}} field must be less than {{max}}','en'),(3419,3417,'Have more coupons?','en'),(3420,3418,'Applied discount coupon','en'),(3421,3419,'{{count}} coupon(s) removed','en'),(3422,3420,'{{count}} coupon(s) created','en'),(3423,3421,'The code \"{{code}}\" is already used for another coupon. Please choose a different code.','en'),(3424,3422,'Invalid coupon code, please check the spelling: \"{{code}}\"','en'),(3425,3423,'The coupon has already been used','en'),(3426,3424,'The coupon has been applied to your order','en'),(3427,3425,'Coupon discount','en'),(3428,3426,'Period start date must be earlier than period end date','en'),(3429,3427,'Period end date must be later than period start date','en'),(3430,3428,'Minimum order subtotal must be less than maximum order subtotal','en'),(3431,3429,'Maximum order subtotal must be greater than minimum order subtotal','en'),(3432,3430,'Discount must be less than 100%','en'),(3433,3431,'Coupon added','en'),(3434,3432,'Coupon updated','en'),(3435,3433,'Limit number of uses','en'),(3436,3434,'Maximum number of uses','en'),(3437,3435,'This coupon can be applied only to orders with a subtotal amount between {{min}} and {{max}}','en'),(3438,3436,'This coupon can be applied only to orders with a subtotal amount of at least {{min}}','en'),(3439,3437,'This coupon can be applied only to orders with a subtotal amount not exceeding {{max}}','en'),(3440,3438,'Date when customers can start using the coupon','en'),(3441,3439,'Date when the coupon expires','en'),(3442,3440,'Minimum order subtotal to which the coupon can be applied','en'),(3443,3441,'Maximum order subtotal to which the coupon can be applied','en'),(3444,3442,'Coupon discount can be limited to these product classes','en'),(3445,3443,'Coupon discount can be limited to customers with these membership levels','en'),(3446,3444,'This comment is visible to shop administrators only','en'),(3447,3445,'Add new coupon','en'),(3448,3446,'Enter code','en'),(3449,3447,'Coupon','en'),(3450,3448,'Redeem','en'),(3451,3449,'{{currency}} off','en'),(3452,3450,'Removed coupons','en'),(3453,3451,'Added coupons','en'),(3454,3452,'Add coupon','en'),(3455,3453,'This coupon cannot be combined with other coupons','en'),(3456,3454,'Sorry, this coupon cannot be combined with the coupon already applied. Remove the previously applied coupon and try again.','en'),(3457,3455,'Coupon cannot be combined with other coupons','en'),(3458,3456,'If you want the coupon discount to be applied only to products from specific categories, specify these categories here.','en'),(3459,3457,'Sorry, the coupon you entered is invalid. Make sure the coupon code is spelled correctly','en'),(3460,3458,'Sorry, the coupon has expired','en'),(3461,3459,'Sorry, the coupon use limit has been reached','en'),(3462,3460,'Sorry, the coupon you entered cannot be applied to the items in your cart','en'),(3463,3461,'Sorry, the coupon you entered is not valid for your membership level. Contact the administrator','en'),(3464,3462,'The maximum number of uses per user','en'),(3465,3463,'<p>There are currently no coupons. Information on the use of coupons is available <a target=\"_blank\" href=\"https://kb.x-cart.com/en/seo_and_promotion/setting_up_discount_coupons.html\">here</a>.</p>','en'),(3466,3463,'<p>В настоящее время купонов нет. Об использовании купонов можно прочесть <a target=\"_blank\" href=\"https://kb.x-cart.ru/seo_and_promotion/setting_up_discount_coupons.html\">здесь</a>.</p>','ru'),(3467,3464,'The selected date is outside the allowed date range','en'),(3468,3464,'Выбранная дата находится вне допустимого диапазона значений','ru'),(3469,3465,'Product removed','en'),(3470,3466,'Attachment removed','en'),(3471,3467,'Order has not yet been processed','en'),(3472,3468,'Expired: Downloads limit has been reached','en'),(3473,3469,'Downloads left','en'),(3474,3470,'Download TTL has expired','en'),(3475,3471,'Expires in','en'),(3476,3472,'Blocked by administrator','en'),(3477,3473,'Available for download','en'),(3478,3474,'Can be downloaded only after buying the product','en'),(3479,3475,'Global eGoods settings','en'),(3480,3476,'Download link is blocked','en'),(3481,3476,'Ссылка для скачивания заблокирована','ru'),(3482,3477,'Download links is blocked','en'),(3483,3477,'Ссылки для скачивания заблокирована','ru'),(3484,3478,'Download link has not been found','en'),(3485,3479,'Download link is not active','en'),(3486,3480,'Download link has been renewed','en'),(3487,3480,'Ссылка для скачивания обновлена','ru'),(3488,3481,'Download links has been renewed','en'),(3489,3481,'Ссылки для скачивания обновлены','ru'),(3490,3482,'less than one hour','en'),(3491,3483,'E-goods','en'),(3492,3484,'Ordered files','en'),(3493,3485,'Paid','en'),(3494,3485,'Платный','ru'),(3495,3486,'Free','en'),(3496,3486,'Бесплатный','ru'),(3497,3487,'Your payment module to accept payments for digital items. <a href=\"{{url}}\" target=\"_blank\">Get it now</a>!','en'),(3498,3487,'Продаёшь цифровые товары? Устрой тест-драйв нашему <a href=\"{{url}}\" target=\"_blank\">новому модулю</a> и начни принимать платежи прямо сейчас.','ru'),(3499,3488,'Available after purchase','en'),(3500,3488,'Доступен после покупки','ru'),(3501,3489,'Re-upload file','en'),(3502,3489,'Повторно загрузить','ru'),(3503,3490,'History of downloads','en'),(3504,3490,'История загрузок','ru'),(3505,3491,'The product\'s history of downloads is empty','en'),(3506,3491,'История загрузок для этого товара пуста','ru'),(3507,3492,'The history of downloads feature for this product is disabled. You can enable it <a href=\'{{link}}\'>here</a>','en'),(3508,3492,'Сохранение истории загрузок для данного товара отключено. Вы можете включить его <a href=\"{{link}}\">здесь</a>','ru'),(3509,3493,'File is available by public URL','en'),(3510,3493,'Файл доступен по публичной ссылке','ru'),(3511,3494,'Order fulfilment status changed from {{oldStatus}} to {{newStatus}} due to the file having been downloaded by the user.','en'),(3512,3494,'Статус доставки изменился с {{oldStatus}} на {{newStatus}} в связи с загрузкой файла пользователем','ru'),(3513,3495,'Use X-Sendfile to facilitate the download of large file attachments (100 Mb and larger) by customers:','en'),(3514,3495,'Используйте X-Sendfile для улучшения производительности при скачивании покупателями объемных прикрепляемых файлов (100 и более Мбайт):','ru'),(3515,3496,'Contact your hosting provider to make sure X-Sendfile is installed on the server.','en'),(3516,3496,'Уточните у своего хостинг провайдера, доступен ли для использования X-Sendfile.','ru'),(3517,3497,'Configure your X-Cart installation to support large file downloads.','en'),(3518,3497,'Настройте поддержку скачивания больших файлов для вашей инсталляции X-Cart.','ru'),(3519,3498,'Order #{{value}} doesn’t contain any e-goods. Choose an order that contains e-goods.','en'),(3520,3498,'С заказом {{value}} не связано никаких электронных товаров. Выберите заказ, содержащий электронные товары.','ru'),(3521,3499,'Block','en'),(3522,3500,'Ip','en'),(3523,3501,'Renew','en'),(3524,3502,'Unblock and renew','en'),(3525,3503,'Related products you may be interested in','en'),(3526,3504,'Although you may find related products below.','en'),(3527,3505,'Add featured products for the front page','en'),(3528,3506,'Featured','en'),(3529,3507,'FedEx module allows you to use online shipping rates calculation via FedEx.','en'),(3530,3508,'\"Cash on delivery\" status','en'),(3531,3509,'Note: To enable/disable the \"Cash on delivery\" payment option, you should enable/disable the payment method \"Cash on delivery (FedEx)\" on the <a href=\"{{URL}}\">Payment methods page</a>.','en'),(3532,3510,'As a FedEx user, you are entitled to receive shipping refunds usually left unclaimed with default FedEx service ($2B/year globally). <a href=\"https://71lbs.com/xcart\" target=\"_blank\">Get My FedEx Refunds</a>','en'),(3533,3507,'Модуль FedEx позволяет рассчитывать онлайн стоимость доставки через FedEx.','ru'),(3534,3508,'Состояние варианта оплаты \"Наложенный платеж\"','ru'),(3535,3509,'Важно: Чтобы включить/отключить вариант оплаты \"Наложенный платеж\", необходимо включить/отключить способ оплаты \"Наложеный платеж (FedEx)\" на <a href=\"{{URL}}\">странице Способов оплаты</a>.','ru'),(3536,3511,'The same file cannot be assigned to a product more than once','en'),(3537,3512,'The attachment has been successfully re-uploaded','en'),(3538,3513,'Failed to re-upload attachment','en'),(3539,3514,'Attachment has been deleted successfully','en'),(3540,3515,'File description','en'),(3541,3515,'Описание файла','ru'),(3542,3516,'Click to edit','en'),(3543,3516,'Нажмите для редактирования','ru'),(3544,3517,'Tweet','en'),(3545,3518,'We recommend using the Share button instead of Like.','en'),(3546,3519,'These Open Graph meta tags were generated automatically based on general product information.','en'),(3547,3520,'Pin It','en'),(3548,3521,'Pin','en'),(3549,3522,'Share','en'),(3550,3523,'Advanced statistics with','en'),(3551,3524,'Google Analytics','en'),(3552,3525,'Configure the Google Analytics module','en'),(3553,3526,'to view the advanced statistics','en'),(3554,3527,'A single domain','en'),(3555,3528,'One domain with multiple subdomains','en'),(3556,3529,'Multiple top-level domains','en'),(3557,3530,'Traditional','en'),(3558,3531,'Universal Analytics','en'),(3559,3532,'Want help with SEO? <a href=\"{{url}}\" target=\"_blank\">Ask X-Cart Guru</a>','en'),(3560,3523,'Расширенная статистика с','ru'),(3561,3524,'Google Analytics','ru'),(3562,3525,'Настроить модуль Google Analytics','ru'),(3563,3526,'для получения расширенной статистики','ru'),(3564,3527,'Одиночный домен','ru'),(3565,3528,'Один домен с несколькими поддоменами','ru'),(3566,3529,'Несколько доменов верхнего уровня','ru'),(3567,3530,'Traditional','ru'),(3568,3531,'Universal Analytics','ru'),(3569,3532,'Нужна помощь с поисковой оптимизацией? <a href=\"{{url}}\" target=\"_blank\">Спросите гуру X-Cart</a>','ru'),(3570,3533,'Quantity in stock','en'),(3571,3534,'Sold','en'),(3572,3535,'{{count}} PIN code duplicates ignored.','en'),(3573,3536,'{{count}} PIN codes created successfully.','en'),(3574,3537,'{{count}} PIN codes longer than {{max}} characters ignored.','en'),(3575,3538,'Could not assign {{count}} PIN codes to order #{{orderId}}. <a href=\"{{link}}\">Create new ones right now</a>','en'),(3576,3538,'Не удалось применить ПИН-коды в количестве {{count}} к заказу #{{orderId}}. <a href=\"{{link}}\">Создайте новые</a>','ru'),(3577,3539,'No valid code found.','en'),(3578,3540,'PIN','en'),(3579,3541,'Cannot be disabled for products with manually defined PIN codes','en'),(3580,3542,'PIN codes enabled','en'),(3581,3543,'Cannot remove a sold PIN code','en'),(3582,3544,'Sold PINs','en'),(3583,3545,'Remaining PINs','en'),(3584,3546,'Order deleted','en'),(3585,3547,'Please type in the new PIN codes one per line. PIN codes max length is 64 characters.','en'),(3586,3548,'Quantity in stock is determined by the amount of the remaining PIN codes defined on the PIN codes management page.','en'),(3587,3549,'You will be able to add pin codes after saving changes.','en'),(3588,3550,'No PIN codes found.','en'),(3589,3551,'Quantity in stock is determined by the amount of the remaining PIN codes','en'),(3590,3552,'{{count}} PIN Codes were not assigned.','en'),(3591,3553,'No pin codes have been bought yet','en'),(3592,3554,'PIN codes data has been successfully updated','en'),(3593,3555,'PIN code','en'),(3594,3556,'PIN codes','en'),(3595,3557,'Add PIN codes','en'),(3596,3558,'Inventory tracking for product {{value}} will not be imported','en'),(3597,3559,'PIN codes generation method','en'),(3598,3559,'Способ создания ПИН-кодов','ru'),(3599,3560,'Automatically','en'),(3600,3560,'Автоматически','ru'),(3601,3561,'Manually','en'),(3602,3561,'Вручную','ru'),(3603,3562,'Товар не найден','ru'),(3604,3563,'Order #{{value}} doesn’t have any pin codes associated with it. Choose an order that contains pin codes.','en'),(3605,3563,'С заказом {{value}} не связано никаких пин-кодов. Выберите заказ, содержащий пин-коды.','ru'),(3606,3564,'Add pin codes','en'),(3607,3565,'Import from CSV file','en'),(3608,3566,'Unknown error occurred','en'),(3609,3567,'The order also contains items with missing PIN codes; you will be prompted to enter the PIN codes under item names.','en'),(3610,3567,'Заказ также содержит товары с отсутствующими ПИН кодами; вам будет предоставлена возможность ввести ПИН коды под названиями соответствующих товаров.','ru'),(3611,3568,'The following PIN codes have already been sold: {{codes}}','en'),(3612,3568,'Следующие ПИН коды уже были проданы ранее: {{codes}}','ru'),(3613,3569,'PayPal ID / Email','en'),(3614,3570,'Enter the email address associated with your PayPal account.','en'),(3615,3571,'Enter a description of the purchase that will be displayed on the PayPal payment page.','en'),(3616,3572,'You can set an order id prefix that will be added to each order number in your shop to make it unique (each transaction id must be unique for a PayPal account). This option is relevant only if you share your PayPal account with other online shops','en'),(3617,3573,'Your account settings','en'),(3618,3574,'Partner name','en'),(3619,3575,'Your partner name is PayPal','en'),(3620,3576,'Merchant login','en'),(3621,3577,'This is the login name you created when you signed up for PayPal Payments Advanced / Payflow Link.','en'),(3622,3578,'PayPal recommends entering a User Login here instead of your Merchant Login. You can set up a User profile in <a href=\"https://manager.paypal.com\">PayPal Manager</a>. This will enhance security and prevent service interruption should you change your Merchant Login password.','en'),(3623,3579,'This is the password you created when you signed up for PayPal Payments Advanced or the password you created for API calls.','en'),(3624,3580,'Additional settings','en'),(3625,3581,'Auth and Capture','en'),(3626,3582,'Auth only','en'),(3627,3583,'This should be the partner name you use when logging into your PayPal Payflow account.','en'),(3628,3584,'This is the login name you created when you signed up for Payflow.','en'),(3629,3585,'This is the password you created when you signed up for PayPal Payflow or the password you created for API calls.','en'),(3630,3586,'IPN verification failed','en'),(3631,3587,'IPN HTTP error','en'),(3632,3588,'Order id prefix','en'),(3633,3589,'Email address to receive PayPal payment','en'),(3634,3590,'Start accepting Express Checkout payments immediately by simply plugging in the email address where you would like to receive payments. You can create your PayPal account later after you have received a real transaction from your customers!','en'),(3635,3591,'API credentials for payments and post-checkout operations','en'),(3636,3592,'Can be set up later','en'),(3637,3593,'Your PayPal Publisher ID is: {{publisherId}}','en'),(3638,3594,'PayPal API','en'),(3639,3595,'Payflow API','en'),(3640,3596,'API access username','en'),(3641,3597,'API access password','en'),(3642,3598,'Use PayPal authentication method','en'),(3643,3599,'API signature','en'),(3644,3600,'API certificate filename','en'),(3645,3601,'API certificate','en'),(3646,3602,'Display the \"Buy Now with PayPal\" button','en'),(3647,3603,'This setting determines whether or not the \"Buy Now with PayPal\" button should be displayed on product list pages (in list view) and product details pages.','en'),(3648,3604,'<b>PayPal Express Checkout</b> is configured to work in SandBox mode for the email <b>{{email}}</b>.<br />To use it in Live mode, click the Launch PayPal button below. You will be taken to the PayPal payment method configuration page where you will be able to specify the appropriate configuration settings.','en'),(3649,3605,'Launch PayPal','en'),(3650,3606,'PayPal Credit is','en'),(3651,3607,'I agree with PayPal terms & conditions','en'),(3652,3608,'PayPal account e-mail','en'),(3653,3609,'Banner on Home page','en'),(3654,3610,'Banner on Category pages','en'),(3655,3611,'Banner on Product details pages','en'),(3656,3612,'Banner on Cart page','en'),(3657,3613,'Show above products','en'),(3658,3614,'Show below products','en'),(3659,3615,'Near \"Add to cart\" button','en'),(3660,3616,'Near \"Checkout\" button','en'),(3661,3617,'PayPal API (Merchant API) will work for most merchants; however, some merchants may have access only to Payflow API. If you are sure you need to use Payflow API, select the respective value from this field.<br />Your choice of API solution in this field determines the type of API credentials that you will be able to enter in the fields below.','en'),(3662,3618,'Payment has been refunded successfully','en'),(3663,3619,'Payment has been voided successfully','en'),(3664,3620,'Payment has been captured successfully','en'),(3665,3621,'Your API credentials have been successfully obtained from your PayPal account and saved for use by your X-Cart store.','en'),(3666,3622,'Unfortunately, your API credentials could not be obtained from your PayPal account automatically. Please request your API credentials in your PayPal account and submit them here manually.','en'),(3667,3623,'Don\'t have an account yet?','en'),(3668,3624,'Sign Up Now','en'),(3669,3625,'Register with {{paypal}} <br /> or go to checkout as a New customer','en'),(3670,3626,'Or sign in the classic way','en'),(3671,3627,'Or register with','en'),(3672,3628,'Register with','en'),(3673,3629,'or go to checkout as a New customer','en'),(3674,3630,'Or use your social account','en'),(3675,3631,'Use existing account from','en'),(3676,3632,'PayPal','en'),(3677,3633,'Use existing PayPal account','en'),(3678,3634,'The authorized amount ({{authorized}}) differs from the current order total ({{total}}). A request to capture {{total}} will be issued on click on \"Capture\" button.','en'),(3679,3635,'Wrong token of Express Checkout. Please try again. If the problem persists, contact the administrator.','en'),(3680,3636,'PayerID value was not returned by PayPal. Please try again. If the problem persists, contact the administrator.','en'),(3681,3637,'Your address data was not received from PayPal. Please try again. If the problem persists, contact the administrator.','en'),(3682,3638,'To enable this payment method, you need Multi-vendor module installed.','en'),(3683,3639,'To enable this payment method, you need <a href=\"{{link}}\" target=\"_blank\">Multi-Vendor</a> module installed.','en'),(3684,3640,'EACHRECEIVER','en'),(3685,3641,'Obtaining your live PayPal credentials','en'),(3686,3642,'PRIMARYRECEIVER','en'),(3687,3643,'PayPal Credit','en'),(3688,3644,'Registering your application with PayPal','en'),(3689,3645,'SECONDARYONLY','en'),(3690,3646,'SENDER','en'),(3691,3647,'Additional criteria to match for PayPal account verification','en'),(3692,3648,'<div>Determines the type of criteria that should be matched for account verification (in addition to vendor PayPal account identifier).<div><ul class=\"unstyled\"><li>NAME - Default; should be good in most cases.</li><li>NONE - Is available only to certain financial institutions (Contact Paypal for approval prior to selection!)</li><li>Disable - Deactivates account verification.</li></ul>','en'),(3693,3649,'NAME','en'),(3694,3650,'NONE','en'),(3695,3651,'Disable','en'),(3696,3652,'Refund status:','en'),(3697,3653,'In progress','en'),(3698,3654,'Payment processing with PayPal Standard involves using PayPal\'s IPN service. If your merchant account is set to use <a href=\"{{link}}\" target=\"_blank\">Payment Data Transfer (PDT)</a>, be sure to disable it in your account settings and enable IPN instead.','en'),(3699,3655,'Use of the unsupported Payment Data Transfer (PDT) method has been detected','en'),(3700,3655,'Обнаружено использование неподдерживаемого метода Payment Data Transfer (PDT)','ru'),(3701,3656,'Communication problem','en'),(3702,3657,'PayPal Merchant ID','en'),(3703,3658,'Connected to PayPal; Merchant ID: {{merchantId}}','en'),(3704,3659,'Reconnect to PayPal','en'),(3705,3660,'Connect to PayPal','en'),(3706,3661,'PayPal For Marketplaces account email','en'),(3707,3662,'PayPal API Client ID','en'),(3708,3663,'PayPal API Secret','en'),(3709,3664,'PayPal Partner ID','en'),(3710,3665,'PayPal BN Code','en'),(3711,3666,'Additional PayPal Business Account','en'),(3712,3666,'Дополнительный бизнес-аккаунт PayPal','ru'),(3713,3667,'Click this to access the PayPal sign-in page and sign in using your PayPal account different from the account specified above. This account will be used to receive the shipping cost (if you are going to ship out goods on behalf of vendors), the earnings on your own products (if you are going to be one of the sellers), and the earnings on the sales of the vendors who have not set up a PayPal account of their own for some reason.','en'),(3714,3667,'Используйте для перехода на сайт PayPal и войдите на сайт, используя аккаунт PayPal, отличный от аккаунта, указанного выше. Данный аккаунт будет использоваться для получения стоимости доставки (если вы собираетесь заниматься отправкой товаров от лица продавцов), поступлений от продажи ваших собственных товаров (если вы будете выступать в качестве одного из продавцов), а также для получения средств от продажи товаров тех продавцов, которые по какой-либо причине не настроили собственный аккаунт PayPal.','ru'),(3715,3668,'Customize the PayPal button','en'),(3716,3668,'Отображение кнопки PayPal','ru'),(3717,3669,'Color','en'),(3718,3669,'Цвет','ru'),(3719,3670,'Shape','en'),(3720,3670,'Форма','ru'),(3721,3671,'Show payment card icons','en'),(3722,3671,'Значки платежных карт','ru'),(3723,3672,'Product page','en'),(3724,3672,'Страница продукта','ru'),(3725,3673,'Product list','en'),(3726,3673,'Список продуктов','ru'),(3727,3674,'Cart','en'),(3728,3674,'Корзина','ru'),(3729,3675,'Minicart','en'),(3730,3675,'Меню корзины','ru'),(3731,3676,'Checkout','en'),(3732,3676,'Оформиление заказа','ru'),(3733,3677,'Checkout (PayPal Credit)','en'),(3734,3677,'Оформиление заказа (PayPal Credit)','ru'),(3735,3678,'Add2Cart popup','en'),(3736,3678,'Всплывающее окно корзины','ru'),(3737,3679,'Payments with this payment method are not allowed because <a href=\"{{url}}\">HTTPS is not configured or there is a problem with the security certificate</a>.','en'),(3738,3680,'Webhook listener error: could not subscribe to event(s). Check the settings and make sure your site is accessible via the Web.','en'),(3739,3681,'Delayed','en'),(3740,3682,'Immediate','en'),(3741,3683,'We are experiencing a problem with the \"{{payment_method_name}}\" payment method. Please choose a different method, or contact the store administrator to resolve the problem.','en'),(3742,3684,'Funding methods (checkout page)','en'),(3743,3685,'When multiple funding sources are available to the buyer, PayPal automatically determines which additional buttons are appropriate to display. However, you can choose to opt-in or out-of displaying specific funding sources.','en'),(3744,3686,'Credit or debit card (Visa, MasterCard, American Express, Discover, and so on)','en'),(3745,3687,'ELV/SEPA','en'),(3746,3688,'Venmo','en'),(3747,3689,'Express Checkout process stopped.','en'),(3748,3690,'Fees payer','en'),(3749,3691,'PayPal Express Checkout','en'),(3750,3692,'Payment has bes refunded successfully','en'),(3751,3693,'Paypal login (email)','en'),(3752,3694,'Unable to retrieve Publisher ID for specified PayPal account. Banners are now disabled.','en'),(3753,3695,'Payment have been voided successfully','en'),(3754,3696,'Try to reconnect','en'),(3755,3697,'All newest products','en'),(3756,3698,'All upcoming products','en'),(3757,3699,'Coming soon','en'),(3758,3700,'Customers who bought this product also bought','en'),(3759,3701,'Customers who viewed this product bought','en'),(3760,3702,'Date: newest first','en'),(3761,3703,'Date: oldest first','en'),(3762,3704,'New arrivals','en'),(3763,3705,'New!','en'),(3764,3706,'Recently viewed','en'),(3765,3707,'This product will be shown in New arrivals','en'),(3766,3708,'This product will be shown in the Coming soon section','en'),(3767,3709,'Expected on','en'),(3768,3710,'Coming soon...','en'),(3769,3711,'Customers who bought this product also bought (Product Advisor module)','en'),(3770,3712,'Don\'t label','en'),(3771,3713,'In catalog only','en'),(3772,3714,'On catalog and product pages','en'),(3773,3715,'Text links','en'),(3774,3716,'Expected on <span>{{date}}</span>','en'),(3775,3715,'Текстовые ссылки','ru'),(3776,3709,'Ожидается','ru'),(3777,3716,'Ожидается <span>{{date}}</span>','ru'),(3778,3717,'MD5 hash value','en'),(3779,3718,'Use of Restriction key must be disabled in your Quantum Gateway merchant center account at all times. Please log in to your account, go to the Processing Settings section and make sure the setting \"Use restriction key\" is disabled.','en'),(3780,3719,'Include response in hash','en'),(3781,3720,'This value must be set in exactly the same way as it is set on the payment gateway end.','en'),(3782,3721,'Put up for sale','en'),(3783,3722,'Cancel sale','en'),(3784,3723,'On sale','en'),(3785,3724,'Put all for sale','en'),(3786,3725,'Cancel sale for all','en'),(3787,3724,'Выставить все на распродажу','ru'),(3788,3725,'Отменить распродажу для всех','ru'),(3789,3726,'Address for sales tax calculation','en'),(3790,3727,'Click here to specify tax rates that will apply only to shipping charges','en'),(3791,3728,'Discounted subtotal','en'),(3792,3729,'Discounted subtotal + Shipping cost','en'),(3793,3730,'General tax rates','en'),(3794,3731,'Individual settings for every rate','en'),(3795,3732,'New rate','en'),(3796,3733,'Subtotal + Shipping cost','en'),(3797,3734,'Taxable base','en'),(3798,3735,'Tax rates for shipping charges have not yet been created.','en'),(3799,3736,'Tax rates have not yet been created.','en'),(3800,3737,'Tax rates on shipping cost','en'),(3801,3738,'Use the same tax rates for all user membership levels','en'),(3802,3726,'Адрес для расчета налога с продаж','ru'),(3803,3727,'Нажмите здесь, чтобы задать ставки налогов на стоимость доставки','ru'),(3804,3728,'Сумма заказа с учетом скидки','ru'),(3805,3729,'Сумма заказа с учетом скидки + стоимость доставки','ru'),(3806,3730,'Основные ставки налогов','ru'),(3807,3731,'Индивидуальные настройки для каждой ставки налога','ru'),(3808,3732,'Новая ставка','ru'),(3809,3733,'Сумма заказа + стоимость доставки','ru'),(3810,1222,'Сумма налога успешно удалена','ru'),(3811,1223,'Сумма налога не удалена','ru'),(3812,3734,'Налогооблагаемая база','ru'),(3813,3735,'Ставки налога на стоимость доставки пока не созданы.','ru'),(3814,3736,'Ставки налога пока не созданы.','ru'),(3815,3737,'Ставки налогов на стоимость доставки','ru'),(3816,3738,'Использовать одни и те же ставки налога для всех групп покупателей','ru'),(3817,1121,'Налог с продаж','ru'),(3818,3739,'Contact us','en'),(3819,3740,'Logo','en'),(3820,3741,'Favicon','en'),(3821,3741,'Фавикон','ru'),(3822,3742,'Shipping','en'),(3823,3743,'If you want to add an external link, you should specify it with the <strong>http://</strong> prefix, e.g. <strong>http://www.example.com/</strong>.<br /><br />If you want to add a link to a page within your store (e.g. the checkout page), you can specify it as <strong>cart.php?target=checkout</strong> (relative path) or as <strong>{{URL}}cart.php?target=checkout</strong> (absolute path).<br /><br />Also the \'{home}\' shortcut value will lead to Home page','en'),(3824,3744,'Failed to update the page image','en'),(3825,3745,'Visible for','en'),(3826,3746,'The menu has been updated','en'),(3827,3747,'The menu has been added','en'),(3828,3748,'The page has been updated','en'),(3829,3749,'Any visitors','en'),(3830,3750,'Anonymous users only','en'),(3831,3751,'Logged in users only','en'),(3832,3752,'Save & Close','en'),(3833,3753,'Logo & Favicon','en'),(3834,3754,'Terms and conditions','en'),(3835,3755,'Open graph image','en'),(3836,3756,'The \"{{file}}\" file is not allowed image and was not uploaded. Allowed images are: {{extensions}}','en'),(3837,3757,'Submenu','en'),(3838,3757,'Подменю','ru'),(3839,3758,'Content page title','en'),(3840,3758,'Заголовок страницы','ru'),(3841,3759,'Leave blank to use page name as Page Title.','en'),(3842,3759,'Оставьте поле незаполненным чтобы использовать имя страницы в качестве заголовка.','ru'),(3843,3760,'The AppleIcon image could not be uploaded (Unallowed image type. Must be a .png image with the resolution of 192x192 px)','en'),(3844,3761,' <p>The store doesn\'t have any static pages yet. Static pages can be created to tell customers about your products or policies, guide them through the order process etc. Once the page is created, it will become accessible via certain URL. Start writing by clicking the <b>\"New page\"</b> button.</p>','en'),(3845,3761,' <p>Список страниц пуст. С помощью страниц вы сможете рассказать клиентам о ваших товарах и условиях заказа, предоставить им помощь и полезную информацию. Такие страницы будут доступны по определенным адресам после того, как будут опубликованы.</p>','ru'),(3846,3762,'<p>There are no menus in the store. Header and footer menus provide customers with useful navigation. They can contain any link or label, and can be nested. Generally, the primary menu is shown on the top of the page, and the footer menu is on the bottom of the page.</p>','en'),(3847,3762,'<p>Меню не заполнены. Меню - удобный инструмент навигации для ваших клиентов. Элементы меню могут содержать любой текст или ссылку, а также могут иметь подменю. Обычно, есть главное меню (оно расположено в вернхней части страницы) и нижнее меню (отображаемое в подвале страницы).</p>','ru'),(3848,3763,'Show default menu along with the custom one','en'),(3849,3764,'2Checkout.com account number','en'),(3850,3765,'Order prefix','en'),(3851,3766,'Pricing currency','en'),(3852,3767,'To set up the integration, go to the ','en'),(3853,3768,'\"Site management\"','en'),(3854,3769,' page on the 2Checkout site and make sure of the following:','en'),(3855,3770,'The \"Pricing currency\" value here in X-Cart must be exactly the same as on 2Checkout\'s Site management page.','en'),(3856,3771,'The \"Approved URL\" value on 2Checkout\'s Site management page must be set to this','en'),(3857,3772,'<strong>U.S.P.S.</strong> module allows you to use online shipping rates calculation via <a href=\"http://www.usps.com/webtools\" target=\"_blank\">USPS Web Tools Ecommerce API</a>.','en'),(3858,3773,'Note: To enable/disable the \"Cash on delivery\" payment option, you should enable/disable the payment method \"Cash on delivery (U.S.P.S.)\" on the <a href=\"{{URL}}\">Payment methods page</a>.','en'),(3859,3774,'Refresh list of available methods','en'),(3860,3775,'Wrong container type selected: {{value}}. For large package size only the following types are allowed: RECTANGULAR, NONRECTANGULAR, VARIABLE','en'),(3861,3776,'{{value}} is an invalid container type for a REGULAR package. Valid Container is: VARIABLE','en'),(3862,3777,'USPS Shipments','en'),(3863,3778,'Tracking information was updated successfully','en'),(3864,3779,'The shipment has been voided successfully','en'),(3865,3780,'The shipment has been created successfully','en'),(3866,3781,'Shipment Id','en'),(3867,3782,'Delivery cost','en'),(3868,3783,'Shipping label','en'),(3869,3784,'Parcel type','en'),(3870,3785,'Parcel weight','en'),(3871,3786,'Parcel dimensions','en'),(3872,3787,'Irregular parcel girth','en'),(3873,3788,'Special services','en'),(3874,3789,'COD value','en'),(3875,3790,'Insurance value','en'),(3876,3791,'Label format','en'),(3877,3792,'Label size','en'),(3878,3793,'Hide total carrier charge','en'),(3879,3794,'Hide the carrier shipping charge on the label','en'),(3880,3795,'Non delivery option','en'),(3881,3796,'Use this field for instructions in case the package is not delivered.','en'),(3882,3797,'Print custom message 1','en'),(3883,3798,'This is a user specified message that gets printed on the face of the label. A string of up to 50 characters can be printed on the label.','en'),(3884,3799,'Print custom message 2','en'),(3885,3800,'This is a user specified message that gets printed on the bottom of the label. A string of up to 50 characters can be printed on the label.','en'),(3886,3801,'Shipping label sender signature','en'),(3887,3802,'Adds the sender’s signature and the date on CN22 and CP72 shipping labels. Enter the signature as a string. The Sender’s signature date is automatically populated.','en'),(3888,3803,'Create shipment','en'),(3889,3804,'Please note: the USPS Web tools APIs print labels without postage.','en'),(3890,3805,'<strong>Savings</strong> - Up to 49% off retail USPS postage rates','en'),(3891,3806,'<strong>Convenience</strong> - Verify addresses and buy & print compliant USPS labels directly from the X-Cart application','en'),(3892,3807,'<strong>Easy payment options</strong> - Ship Now Pay Later with a Pitney Bowes Line of Credit or use a credit card.','en'),(3893,3808,'Get started Now! Click here to create your <a href=\"{{url}}\" class=\"external\" target=\"_blank\">PITNEY BOWES Postage Account</a>','en'),(3894,3809,'Delivery date','en'),(3895,3810,'Estimate delivery date','en'),(3896,3811,'Girth','en'),(3897,3812,'PitneyBowes','en'),(3898,3813,'Ship date','en'),(3899,3814,'Unable to get merchant info','en'),(3900,3815,'Update date','en'),(3901,3816,'Update tracking info','en'),(3902,3817,'All dimensions must be greater than 0','en'),(3903,3773,'Важно: Чтобы включить/отключить вариант оплаты \"Наложенный платеж\", необходимо включить/отключить способ оплаты \"Наложеный платеж (U.S.P.S.)\" на <a href=\"{{URL}}\">странице Способов оплаты</a>.','ru'),(3904,3774,'Обновить список доступных методов','ru'),(3905,3775,'Выбран неправильный тип контейнера: {{value}}. Для указанного размера LARGE допустимы следующие значения для типа контейнера: RECTANGULAR, NONRECTANGULAR, VARIABLE','ru'),(3906,3776,'{{value}} - неправильное значение для размера REGULAR. Допустимое значение: VARIABLE','ru'),(3907,3777,'USPS Shipments','ru'),(3908,3778,'Tracking information was updated successfully','ru'),(3909,3779,'Shipment has been voided successfully','ru'),(3910,3780,'Shipment has been created successfully','ru'),(3911,3781,'Shipment Id','ru'),(3912,2415,'Tracking number','ru'),(3913,3782,'Delivery cost','ru'),(3914,3783,'Shipping label','ru'),(3915,2069,'Shipment options','ru'),(3916,2414,'Method name','ru'),(3917,3784,'Parcel type','ru'),(3918,3785,'Parcel weight','ru'),(3919,3786,'Parcel dimensions','ru'),(3920,3787,'Irregular parcel girth','ru'),(3921,3788,'Special services','ru'),(3922,3789,'COD value','ru'),(3923,3790,'Insurance value','ru'),(3924,3791,'Label format','ru'),(3925,3792,'Label size','ru'),(3926,3793,'Hide total carrier charge','ru'),(3927,3794,'Hide the carrier shipping charge on the label','ru'),(3928,3795,'Non delivery option','ru'),(3929,3796,'Use this field for instructions in case the package is not delivered.','ru'),(3930,3797,'Print custom message 1','ru'),(3931,3798,'This is a user specified message that gets printed on the face of the label. A string of up to 50 characters can be printed on the label.','ru'),(3932,3799,'Print custom message 2','ru'),(3933,3800,'This is a user specified message that gets printed on the bottom of the label. A string of up to 50 characters can be printed on the label.','ru'),(3934,3801,'Shipping label sender signature','ru'),(3935,3802,'Adds the sender’s signature and the date on CN22 and CP72 shipping labels. Enter the signature as a string. The Sender’s signature date is automatically populated.','ru'),(3936,3803,'Create shipment','ru'),(3937,3818,'The role has been updated','en'),(3938,3819,'The role has been added','en'),(3939,3820,'(disabled)','en'),(3940,3820,'(выкл)','ru'),(3941,3821,'Get {{X}} off for order amount over {{Y}}','en'),(3942,3822,'Could not add the discount because another discount already exists for the specified subtotal range and membership level','en'),(3943,3823,'Could not update the discount because another discount already exists for the specified subtotal range and membership level','en'),(3944,3824,'Percent discount value cannot exceed 100%','en'),(3945,3825,'Too large value for absolute discount','en'),(3946,3826,'<p>No discounts have been set yet. Set up automatic discounts for your customers based on subtotal or membership level. Add the discount using <b>\"Add discount\"</b> button.</p>','en'),(3947,3826,'<p>Нет настроенных скидок. Вы можете настроить автоматическое применение оптовых скидок в зависимости от суммы заказа и группы пользователя с помощью кнопки <b>\"Создать скидку\"</b>.</p>','ru'),(3948,3827,'Site map failed to register in {{engine}}.','en'),(3949,3828,'Site map successfully registered in {{engine}}.','en'),(3950,3829,'XML sitemap URL: <a href=\"{{url}}\">{{url}}</a>','en'),(3951,3830,'Generate sitemap','en'),(3952,3831,'Generate XML Sitemap','en'),(3953,3832,'Sitemap generation...','en'),(3954,3833,'Sitemap generation has been completed successfully.','en'),(3955,3834,'Sitemap generation has been stopped.','en'),(3956,3835,'The process of sitemap generation may take a while to complete. Please do not close this page until the process is fully completed.','en'),(3957,3836,'Sitemap settings','en'),(3958,3837,'X-Cart Google Ads by Kliken','en'),(3959,3837,'X-Cart-Google-Werbung von Kliken','de'),(3960,3837,'X-Cart Google Ads por Kliken','es'),(3961,3837,'Annonces Google X-Cart par Kliken','fr'),(3962,3837,'X-Cart Google Ads door Kliken','nl'),(3963,3838,'Module Kliken\\GoogleAds was unable to access your store\'s catalog . Please make sure the correct Account Id and Application Token are saved, or contact Kliken for support.','en'),(3964,3838,'Das Modul Kliken\\GoogleAds konnte nicht auf den Katalog Ihres Shops zugreifen. Bitte stellen Sie sicher, dass die korrekte Konto-ID und der richtige Anwendungstoken gespeichert sind oder wenden Sie sich für Unterstützung an Kliken.','de'),(3965,3838,'El módulo Kliken\\GoogleAds no ha podido acceder al catálogo de su tienda. Asegúrese de que se han guardado el identificador de la cuenta y el token de aplicación correctos, o póngase en contacto con Kliken para obtener ayuda.','es'),(3966,3838,'Module Kliken\\GoogleAds n\'a pas pu accéder au catalogue de votre boutique. Veuillez vous assurer que l\'identifiant de compte et le jeton d\'application appropriés sont enregistrés, ou contactez Kliken pour obtenir de l\'aide.','fr'),(3967,3838,'Module Kliken\\GoogleAds kon geen toegang krijgen tot de catalogus van uw winkel. Zorg ervoor dat de juiste Account-ID en Applicatie-token zijn opgeslagen of neem voor ondersteuning contact op met Kliken.','nl'),(3968,3839,'Google Ads','en'),(3969,3839,'Google-Werbung','de'),(3970,3839,'Google Ads','es'),(3971,3839,'Publicités Google','fr'),(3972,3839,'Google Ads','nl'),(3973,3840,'Get your products found on Google in a few steps. Click the \"%s\" button to get started!','en'),(3974,3840,'Sorgen Sie mit wenigen Schritten dafür, dass Ihre Produkte bei Google gefunden werden. Klicken Sie den \"%s\"-Button an, um zu beginnen!','de'),(3975,3840,'Consiga que encuentren sus productos en Google en unos pocos pasos. ¡Haga clic en el botón \"%s\" para empezar!','es'),(3976,3840,'Rendez vos produits visibles sur Google en quelques étapes. Cliquez sur le bouton « %s » pour commencer !','fr'),(3977,3840,'Zorg er in een paar stappen voor dat uw producten vindbaar zijn in Google. Klik op de \"%s\"-toets om aan de slag te gaan!','nl'),(3978,3841,'Increase sales and revenue with Google Shopping Ads.','en'),(3979,3841,'Steigern Sie Ihren Umsatz und Ihre Einnahmen mit Google Shopping Anzeigen.','de'),(3980,3841,'Aumenta tus ventas e ingresos con Google Shopping Ads.','es'),(3981,3841,'Augmentez vos ventes et votre chiffre d\'affaire grâce à Google Shopping Ads.','fr'),(3982,3841,'Vergroot de verkoop en omzet met Google Shopping Ads.','nl'),(3983,3842,'Use this X-Cart and Google Ads integration to:','en'),(3984,3842,'Verwenden Sie diese X-Cart- und Google Ads-Integration und:','de'),(3985,3842,'Utiliza esta integración de X-Cart y Google para:','es'),(3986,3842,'Utilisez cette intégration de X-Cart et Google Ads pour :','fr'),(3987,3842,'Gebruik deze X-Cart- en Google Ads-integratie om:','nl'),(3988,3843,'Find more customers on Google','en'),(3989,3843,'Finden Sie mehr Kunden auf Google','de'),(3990,3843,'Encontrar más clientes en Google','es'),(3991,3843,'Trouver plus de clients sur Google','fr'),(3992,3843,'Meer klanten via Google te vinden','nl'),(3993,3844,'Automate bidding to maximize sales for your marketing budget','en'),(3994,3844,'Automatisieren Sie die Gebotsabgabe, um den Umsatz mit Ihrem Marketingbudget zu maximieren','de'),(3995,3844,'Automatizar pujas y maximizar las ventas con tu presupuesto para marketing.','es'),(3996,3844,'Automatiser les enchères afin de maximiser les ventes pour votre budget marketing','fr'),(3997,3844,'Het bieden te automatiseren om de verkoop, afgestemd op uw marketingbudget, te maximaliseren ','nl'),(3998,3845,'Keep your marketing and store in sync','en'),(3999,3845,'Stimmen Sie Ihr Marketing und Ihren Shop immer aufeinander ab','de'),(4000,3845,'Mantener tu estrategia de marketing y tu tienda sincronizadas.','es'),(4001,3845,'Synchroniser votre marketing et votre boutique','fr'),(4002,3845,'Uw marketing en winkel synchroon te houden','nl'),(4003,3846,'Create perfect shopping campaigns in minutes','en'),(4004,3846,'Erstellen Sie perfekte Shoppingkampagnen in wenigen Minuten','de'),(4005,3846,'Crear campañas de Shopping perfectas en minutos.','es'),(4006,3846,'Créer des campagnes de shopping parfaites en quelques minutes','fr'),(4007,3846,'Binnen enkele minuten perfecte winkelcampagnes op te zetten','nl'),(4008,3847,'Get Started','en'),(4009,3847,'Anfangen','de'),(4010,3847,'Empezar','es'),(4011,3847,'Commencer','fr'),(4012,3847,'Beginnen','nl'),(4013,3848,'Launch Google Shopping ads and get your products found online easily.','en'),(4014,3848,'Veröffentlichen Sie Google-Shopping-Anzeigen, damit Ihre Produkte online leicht zu finden sind.','de'),(4015,3848,'Lance los anuncios de Google Shopping Ads para conseguir que sus productos se puedan encontrar en línea fácilmente.','es'),(4016,3848,'Lancez les Campagnes Shopping Google pour qu\'on trouve facilement vos produits en ligne.','fr'),(4017,3848,'Start Google Shopping Ads en vind uw producten eenvoudig online.','nl'),(4018,3849,'Your store is connected.','en'),(4019,3849,'Ihr Shop ist verbunden.','de'),(4020,3849,'Tu tienda está conectada.','es'),(4021,3849,'Votre boutique est connectée.','fr'),(4022,3849,'Uw winkel is gekoppeld.','nl'),(4023,3850,'Your X-Cart store is connected to your Kliken account.','en'),(4024,3850,'Ihr X-Cart-Shop ist mit Ihrem Kliken-Konto verbunden.','de'),(4025,3850,'Tu tienda X-Cart está conectada a tu cuenta de Kliken.','es'),(4026,3850,'Votre boutique X-Cart est connectée à votre compte Kliken.','fr'),(4027,3850,'Uw X-Cart-winkel is gekoppeld aan uw Kliken-account.','nl'),(4028,3851,'Campaign Dashboard','en'),(4029,3851,'Kampagnen-Dashboard','de'),(4030,3851,'Panel de control de la campaña','es'),(4031,3851,'Tableau de bord des campagnes','fr'),(4032,3851,'Campagne Dashboard','nl'),(4033,3852,'Open your dashboard to review your campaign\'s performance','en'),(4034,3852,'Öffnen Sie Ihr Dashboard, um festzustellen, wie Ihre Kampagne abschneidet','de'),(4035,3852,'Abra su cuadro de mando para revisar el comportamiento de su campaña','es'),(4036,3852,'Ouvrez votre tableau de bord pour vérifier les performances de votre campagne','fr'),(4037,3852,'Open uw dashboard om de prestatie van uw actie te bekijken','nl'),(4038,3853,'Create a New Google Shopping Campaign','en'),(4039,3853,'Erstellen Sie eine neue Google-Shopping-Kampagne','de'),(4040,3853,'Cree una nueva campaña de Google Shopping','es'),(4041,3853,'Créer une nouvelle campagne Shopping Google','fr'),(4042,3853,'Creëer een nieuwe Google Shopping-actie','nl'),(4043,3854,'Build a campaign in a few minutes, and sell to customers as they search for your products on Google.','en'),(4044,3854,'Stellen Sie in Minutenschnelle eine Kampagne zusammen und verkaufen Sie an Kunden, die von Ihnen angebotene Produkte auf Google suchen.','de'),(4045,3854,'Cree una campaña en unos pocos minutos y empiece a vender a los clientes cuando busquen sus productos en Google.','es'),(4046,3854,'Élaborez une campagne en quelques minutes et vendez à des clients qui cherchent vos produits sur Google.','fr'),(4047,3854,'Maak een actie in enkele minuten en verkoop aan klanten als ze op uw producten zoeken op Google.','nl'),(4048,3855,'Manage Campaigns','en'),(4049,3855,'Kampagnen verwalten','de'),(4050,3855,'Gestionar campañas','es'),(4051,3855,'Gérer les campagnes','fr'),(4052,3855,'Campagnes Beheren','nl'),(4053,3856,'Make changes to your active campaigns, purchase one you built, or reinstate your cancelled campaigns.','en'),(4054,3856,'Bearbeiten Sie aktive, buchen Sie erstellte oder starten Sie abgebrochene Kampagnen neu.','de'),(4055,3856,'Haga cambios en sus campañas activas, compre una creada por usted o reactive las campañas canceladas.','es'),(4056,3856,'Apportez des modifications à vos campagnes actives, achetez-en une que vous allez élaborer ou relancez vos campagnes annulées.','fr'),(4057,3856,'Wijzig uw actieve acties, koop er een die u gemaakt heeft of herstel uw geannuleerde acties.','nl'),(4058,3857,'Advanced Options','en'),(4059,3857,'Erweiterte Optionen','de'),(4060,3857,'Opciones avanzadas','es'),(4061,3857,'Options avancées','fr'),(4062,3857,'Geavanceerde opties','nl'),(4063,3858,'Public key','en'),(4064,3859,'Payment processed with errors. Please, try again or ask administrator','en'),(4065,3860,'<ol>\n<li>Sign in to your <a href=\"https://account.authorize.net/\">authorize.net</a> account.</li>\n<li>Go to \"Account\"; in the \"Security Settings\" section, select \"API Credentials & Keys\" link.</li>\n<li>Copy the  API Login ID value.</li>\n<li>Go to X-Cart and paste the API Login ID value you have copied into the \"API Login ID\" field on the payment method settings page.</li>\n<li>If you haven\'t yet created a Transaction key, do so. Copy the value of your Transaction key and paste it into the \"Transaction key\" field on the payment method settings page in X-Cart.</li>\n<li>Again, go to \"Account\"; in the \"Security Settings\" section, select \"Manage Public Client Key\".</li>\n<li>If the Client key has not yet been created, choose to create a Client key. Copy the Client key value and paste it into the \"Public key\" field on the payment method settings page in X-Cart.</li>\n</ol>\n','en'),(4066,3861,'Setup instruction','en'),(4067,3862,'Sign up for Authorize.net','en'),(4068,3863,'While merchant account ID and merchant ID sound similar, they are different values with distinct purposes.<br/><br/>Your <strong>merchant ID</strong> is a unique identifier for your entire gateway account.<br/><br/>Your <strong>merchant account ID</strong> is a unique identifier for a specific merchant account. Within your Braintree gateway, you can have multiple merchant accounts to process transactions for different businesses or currencies. If you have a single merchant account, it is not necessary to specify a merchant account ID in your API requests. If you have multiple merchant accounts and choose not to specify the merchant account ID, all requests will process through your default merchant account','en'),(4069,3864,'Select <strong>Yes</strong> if you want to pass a shipping address from X-Cart checkout into the PayPal payment flow','en'),(4070,3865,'Showing results for','en'),(4071,3865,'Показаны результаты для','ru'),(4072,3866,'See details','en'),(4073,3866,'Подробнее','ru'),(4074,3867,'See more results for','en'),(4075,3867,'Показать больше результатов для','ru'),(4076,3868,'Suggestions','en'),(4077,3868,'Предложения','ru'),(4078,3869,'Products','en'),(4079,3869,'Товары','ru'),(4080,3870,'Categories','en'),(4081,3870,'Категории','ru'),(4082,3871,'Pages','en'),(4083,3871,'Страницы','ru'),(4084,3872,'Manufacturers','en'),(4085,3872,'Производители','ru'),(4086,3873,'Did you mean','en'),(4087,3873,'Возможно, вы имели в виду','ru'),(4088,3874,'Filters','en'),(4089,3874,'Фильтры','ru'),(4090,3875,'Reset all filters','en'),(4091,3875,'Сбросить все фильтры','ru'),(4092,3876,'Try clearing filters or different search terms.','en'),(4093,3876,'Попробуйте сбросить фильтры или ввести другое условие поиска.','ru'),(4094,3877,'No products matching the current filtering criteria were found. Try clearing filters.','en'),(4095,3877,'Товары, удовлетворяющие условиям фильтрации, не найдены. Попробуйте сбросить фильтры.','ru'),(4096,3878,'<i class=\"fa fa-exclamation-triangle\"></i> <a href=\"{{url}}\">CloudSearch</a> sets default sort order to relevance.','en'),(4097,3878,'<i class=\"fa fa-exclamation-triangle\"></i> Модуль <a href=\"{{url}}\">CloudSearch</a> по умолчанию сортирует товары по релевантности.','ru'),(4098,3879,'Bulk edit','en'),(4099,3880,'Click to specify','en'),(4100,3881,'Bulk edit all','en'),(4101,3882,'Inventory','en'),(4102,3883,'Price and membership','en'),(4103,3884,'Bulk edit has been processed successfully.','en'),(4104,3885,'Bulk edit processing has been interrupted.','en'),(4105,3886,'Bulk edit processing may take a while to complete. Please do not close this page until the process is fully completed. If the page has been closed, please re-open it to complete the process (The Bulk edit processing routine is executed only while the page stays open).','en'),(4106,3887,'Bulk Edit processing in progress...','en'),(4107,3888,'Replace with','en'),(4108,3889,'Back to products','en'),(4109,3890,'Bulk edit selected','en'),(4110,3891,'Product list','en'),(4111,3892,'Move to','en'),(4112,3893,'Not set','en'),(4113,3894,'Low stock warning on product page','en'),(4114,3895,'Low stock notification to admin','en'),(4115,3896,'Coming Soon','en'),(4116,3897,'This feature is not yet available. You will be redirected to the feature request page where you can vote to have this feature implemented in one of the upcoming versions.','en'),(4117,3898,'Tax Class','en'),(4118,3880,'Щелкните, чтобы указать значение','ru'),(4119,3882,'Остатки на складе','ru'),(4120,3883,'Цена и доступность для групп','ru'),(4121,1156,'Информация о доставке','ru'),(4122,3884,'Групповое редактирование завершено успешно.','ru'),(4123,3885,'Групповое редактирование было прервано.','ru'),(4124,3886,'Процесс группового редактирования может занять продолжительное время. Пожалуйста, не закрывайте эту страницу до полного завершения процесса. Если страница оказалась закрыта, откройте ее снова, чтобы завершить процесс (Процедура группового редактирования выполняется только пока страница остается открытой).','ru'),(4125,3887,'Идет групповое редактирование...','ru'),(4126,3889,'Назад к списку товаров','ru'),(4127,2861,'Выбрано {{count}} товаров','ru'),(4128,3881,'Редактировать все','ru'),(4129,3890,'Редактировать выбранные','ru'),(4130,3891,'К списку товаров','ru'),(4131,3879,'Групповое редактирование:','ru'),(4132,3892,'Переместить в','ru'),(4133,3888,'Заменить на','ru'),(4134,3893,'Не заданы','ru'),(4135,3894,'Предупреждение о низком остатке на странице товара','ru'),(4136,3895,'Уведомление администратору о низком остатке','ru'),(4137,3896,'Скоро','ru'),(4138,3897,'Данный пункт пока не доступен. Вы будете перенаправлены на страницу голосования за его реализацию в одной из ближайших версий X-Cart.','ru'),(4139,3899,'<b>Canada Post</b> module allows you to use online shipping rates calculation via <a href=\"https://www.canadapost.ca\">Canada Post</a>.','en'),(4140,3900,'Products return {{return_number}}','en'),(4141,3901,'To request a return please complete the form below','en'),(4142,3902,'Return quantity','en'),(4143,3903,'Create return','en'),(4144,3904,'Deliver to Post Office','en'),(4145,3905,'There are no post offices available','en'),(4146,3906,'Tracking pins','en'),(4147,3907,'Delivery to Post Office','en'),(4148,3908,'No events found','en'),(4149,3909,'Attached files','en'),(4150,3910,'Created on','en'),(4151,3911,'Documents','en'),(4152,3912,'Parcel options','en'),(4153,3913,'In store currency (0 - do not use coverage)','en'),(4154,3914,'Parcel','en'),(4155,3915,'Shipment info','en'),(4156,3916,'Shipment ID','en'),(4157,3917,'Shipment status','en'),(4158,3918,'Tracking pin','en'),(4159,3919,'Return tracking pin','en'),(4160,3920,'PO Number','en'),(4161,3921,'Manifests','en'),(4162,3922,'Manifest ID','en'),(4163,3923,'Parcel characteristics','en'),(4164,3924,'Total items weight','en'),(4165,3925,'warning: parcel is overweight','en'),(4166,3926,'Box maximum weight','en'),(4167,3927,'Dimensions (cm)','en'),(4168,3928,'Document','en'),(4169,3929,'Unpackaged','en'),(4170,3930,'Mailing tube','en'),(4171,3931,'Oversized','en'),(4172,3932,'On shipment','en'),(4173,3933,'On exception','en'),(4174,3934,'On delivery','en'),(4175,3935,'Test Canada Post rates calculation','en'),(4176,3936,'Please note that rates are calculated for shipping from Canadian locations only.','en'),(4177,3937,'Canada Post settings','en'),(4178,3938,'Merchant registration wizard','en'),(4179,3939,'To start the registration process for a Canada Post merchant account click on the \"Register\" button.','en'),(4180,3940,'If you want to enable merchant registration wizard once again, please click on the following link','en'),(4181,3941,'enable merchant wizard','en'),(4182,3942,'Administrator notes','en'),(4183,3943,'Not specified','en'),(4184,3944,'18 years','en'),(4185,3945,'19 years','en'),(4186,3946,'shipments are picked up by Canada Post','en'),(4187,3947,'deposit your items at a Post Office','en'),(4188,3948,'Counter - will return the regular price paid by retail consumers','en'),(4189,3949,'Commercial - will return the contracted price between Canada Post and the contract holder','en'),(4190,3950,'Card (hold) for pick up','en'),(4191,3951,'Leave at door','en'),(4192,3952,'Do not safe drop','en'),(4193,3953,'Parcel cannot be voided or transmitted - wrong quote type','en'),(4194,3954,'Parcel cannot be transmitted - wrong quote type','en'),(4195,3955,'Enter Return # or Order #','en'),(4196,3956,'Return products','en'),(4197,3957,'Void shipment','en'),(4198,3958,'Are you sure you want to void this shipment?','en'),(4199,3959,'Transmit shipment','en'),(4200,3960,'Are you sure you want to transmit this shipment?','en'),(4201,3961,'Ordered qty','en'),(4202,3962,'Return qty','en'),(4203,3963,'Total weight','en'),(4204,3964,'Move item','en'),(4205,3965,'New parcel','en'),(4206,3966,'Return #','en'),(4207,3967,'CanadaPost settings','en'),(4208,3968,'Tracking details','en'),(4209,3969,'Search for returns','en'),(4210,3970,'The parcels have been successfully updated','en'),(4211,3971,'The shipment has been created with errors','en'),(4212,3972,'The shipment cannot be created','en'),(4213,3973,'The shipment has been voided with errors','en'),(4214,3974,'The shipment cannot be voided','en'),(4215,3975,'The shipment has been transmitted with errors','en'),(4216,3976,'The shipment has been transmitted successfully','en'),(4217,3977,'The shipment cannot be transmitted','en'),(4218,3978,'Shipments','en'),(4219,3979,'Return','en'),(4220,3980,'The products return has been registered.','en'),(4221,3981,'No items have been selected for return.','en'),(4222,3982,'Directory \"{{path}}\" is not writable or cannot be created','en'),(4223,3983,'Configure manually','en'),(4224,3984,'Authentication options','en'),(4225,3985,'Common options','en'),(4226,3986,'Contact name for the manifest address','en'),(4227,3987,'Contract ID','en'),(4228,3988,'Contract shipping options','en'),(4229,3989,'Coverage','en'),(4230,3990,'Currency rate','en'),(4231,3991,'Customer number','en'),(4232,3992,'Deliver to Post Office options','en'),(4233,3993,'Developer mode','en'),(4234,3994,'Enable \"Deliver to Post Office\" feature','en'),(4235,3995,'Failure to finish registration process.','en'),(4236,3996,'Failure to get token ID.','en'),(4237,3997,'Log all communications between shopping cart and Canada Post server','en'),(4238,3998,'Maximum Post Offices that will be displayed','en'),(4239,3999,'Non-delivery instructions','en'),(4240,4000,'Package height (cm)','en'),(4241,4001,'Package length (cm)','en'),(4242,4002,'Package maximum weight (kg)','en'),(4243,4003,'Package width (cm)','en'),(4244,4004,'Proof of age','en'),(4245,4005,'Quote type','en'),(4246,4006,'Registration process has been canceled.','en'),(4247,4007,'Registration process has been completed successfully.','en'),(4248,4008,'Render detailed manifest','en'),(4249,4009,'Shipments pick up type','en'),(4250,4010,'Site number of the deposit location','en'),(4251,4011,'Way to deliver','en'),(4252,4012,'You have just added','en'),(4253,4012,'Вы добавили в корзину','ru'),(4254,4013,'Open comparison table','en'),(4255,4013,'Открыть таблицу сравнения','ru'),(4256,4014,'Please add another product to comparison','en'),(4257,4014,'Выберите еще один товар для сравнения','ru'),(4258,4015,'High - Low','en'),(4259,4015,'по убыванию','ru'),(4260,4016,'Low - High','en'),(4261,4016,'по возрастанию','ru'),(4262,4017,'A - Z','en'),(4263,4017,'А - Я','ru'),(4264,4018,'Z - A','en'),(4265,4018,'Я - А','ru'),(4266,4019,'Added to comparison table','en'),(4267,4019,'Добавлено в таблицу сравнения','ru'),(4268,4020,'','en'),(4269,4021,'Street number and street, unit number, etc','en'),(4270,4021,'Улица, номер дома, номер квартиры, и т.д.','ru'),(4271,4022,'','en'),(4272,4023,'','en'),(4273,4024,'','en'),(4274,4025,'','en'),(4275,4026,'Payment statuses','en'),(4276,4026,'Статусы оплаты','ru'),(4277,4027,'Fulfilment statuses','en'),(4278,4027,'Статусы доставки','ru'),(4279,4028,'Order statuses','en'),(4280,4028,'Статусы ордера','ru'),(4281,4029,'Add status','en'),(4282,4029,'Добавить статус','ru'),(4283,4030,'To remove this status, you need to set the status of all the orders currently in this status to a different value','en'),(4284,4030,'Чтобы удалить данный статус надо у всех ордеров с этим статусом сменить статус на другой','ru'),(4285,4031,'System status: <b>{{code}}</b>. Cannot be deleted','en'),(4286,4031,'Системный статус: <b>{{code}}</b>. Не может быть удален','ru'),(4287,4032,'Payment status not found, new status will be created','en'),(4288,4032,'Статус оплаты заказа не найден, будет создан новый статус','ru'),(4289,4033,'Fulfilment status not found, new status will be created','en'),(4290,4033,'Статус доставки заказа не найден, будет создан новый статус','ru'),(4291,4034,'Tabs','en'),(4292,4034,'Вкладки','ru'),(4293,4035,'New tab','en'),(4294,4035,'Новая вкладка','ru'),(4295,4036,'New Tab','en'),(4296,4036,'Новая вкладка','ru'),(4297,4037,'The product tab has been updated','en'),(4298,4037,'Вкладка обновлена','ru'),(4299,4038,'The product tab has been added','en'),(4300,4038,'Вкладка добавлена','ru'),(4301,4039,'Product tabs','en'),(4302,4039,'Информационные вкладки на карточке товара','ru'),(4303,4040,'Tabs imported','en'),(4304,4040,'Импорт вкладок завершен','ru'),(4305,4041,'Brief info','en'),(4306,4041,'Краткая информация','ru'),(4307,4042,'Manage global tabs','en'),(4308,4042,'Управление глобальными вкладками','ru'),(4309,4043,'Edit Globally','en'),(4310,4043,'Редактировать глобально','ru'),(4311,4044,'Global product tabs','en'),(4312,4044,'Глобальные вкладки страницы товара','ru'),(4313,4045,'Learn more','en'),(4314,4045,'Подробнее...','ru'),(4315,4046,'Apply sort and view settings for all products','en'),(4316,4046,'Применить сортировку и настройки видимости ко всем товарам','ru'),(4317,4047,'The text entered here will be displayed on the product details page on the storefront and will be followed by a \"learn more\" link pointing to the respective product tab.','en'),(4318,4047,'Данный текст будет отображаться в карточке товара на стороне витрины магазина и сопровождаться ссылкой вида \"Подробнее...\", ведущей на соответствующую вкладку страницы товара.','ru'),(4319,4048,'Global tab \"{{value}}\" not found','en'),(4320,4048,'Глобальная вкладка товара \"{{value}}\" не найдена','ru'),(4321,4049,'Field \"link\" value \"{{value}}\" is already being used for the global tab \"{{globalTab}}\"','en'),(4322,4049,'Значение поля \"link\" - \"{{value}}\" - уже используется для глобальной вкладки \"{{globalTab}}\"','ru'),(4323,4050,'Global','en'),(4324,4050,'Глобальная','ru'),(4325,4051,'Tab displaying the product\'s detailed description. Added by the X-Cart core','en'),(4326,4051,'Вкладка для отображения детального описания товара. Добавляется ядром X-Cart','ru'),(4327,4052,'Tab displaying the product\'s attributes and other details. Added by the X-Cart core','en'),(4328,4052,'Вкладка для отображения атрибутов товара и другой информации о товаре. Добавляется ядром X-Cart','ru'),(4329,4053,'Tab displaying comments about the product. Added by the addons {{modules}}','en'),(4330,4053,'Вкладка для отображения комментариев о товаре. Добавляется модулями {{modules}}','ru'),(4331,4054,'Enter file extensions separated by comma; for example, \"jpg,txt,svg\"','en'),(4332,4054,'Введите расширения файлов, разделяя запятой; например, \"jpg,txt,svg\"','ru'),(4333,4055,'Web server max upload file size limit is {{size}}','en'),(4334,4055,'Максимальный размер загружаемого файла, разрешенный Вашим веб-сервером - {{size}}','ru'),(4335,4056,'You can attach {{quantity}} more file(s)','en'),(4336,4056,'Вы можете добавить еще {{quantity}} файл(ов)','ru'),(4337,4057,'You can attach <span class=\"files-count\">{{quantity}}</span> file(s)','en'),(4338,4057,'Вы можете добавить <span class=\"files-count\">{{quantity}}</span> файл(ов)','ru'),(4339,4058,'Max allowed file size is {{size}}','en'),(4340,4058,'Максимально допустимый размер файла - {{size}}','ru'),(4341,4059,'Allowed file extensions: {{extensions}}','en'),(4342,4059,'Допустимые расширения: {{extensions}}','ru'),(4343,4060,'Attached files:','en'),(4344,4060,'Присоединенные файлы:','ru'),(4345,1344,'Загрузить файл','ru'),(4346,4061,'Delete attachment','en'),(4347,4061,'Удалить файл','ru'),(4348,4062,'Attach files','en'),(4349,4062,'Присоединить файлы','ru'),(4350,4063,'<span class=\"files-count\">{{quantity}}</span> file(s) attached','en'),(4351,4063,'<span class=\"files-count\">{{quantity}}</span> файлов загружено','ru'),(4352,4064,'Allow buyers to attach files to this product','en'),(4353,4064,'Разрешить покупателям прикреплять файлы к этому товару','ru'),(4354,4065,'The files have been attached successfully','en'),(4355,4065,'Файлы загружены','ru'),(4356,4066,'Unsupported file extension','en'),(4357,4066,'Неподдерживаемый тип файла','ru'),(4358,4067,'Cannot attach the file. The number of attached files may not exceed {{quantity}}','en'),(4359,4067,'Количество файлов не может превышать {{quantity}}','ru'),(4360,4068,'Cannot attach the file. The maximum attached file size may not exceed {{size}} MB','en'),(4361,4068,'Максимальный размер файла не должен превышать {{size}} МБ','ru'),(4362,4069,'File attachments are not allowed for this product','en'),(4363,4069,'Привязка файлов к этому товару недоступна','ru'),(4364,4070,'File uploads forbidden by web server','en'),(4365,4070,'Загрузка файлов запрещена веб-сервером','ru'),(4366,4071,'Attachment {{filename}} is deleted','en'),(4367,4071,'Присоединенный файл {{filename}} удален','ru'),(4368,4072,'Customer attachments were changed','en'),(4369,4072,'Прикрепленные покупателем файлы были изменены','ru'),(4370,4073,'File Attaching is mandatory for this product','en'),(4371,4073,'Загрузка файла необходима для добавления товара в корзину','ru'),(4372,4074,'You must attach a file to the product','en'),(4373,4074,'Вам необходимо присоединить файл для товара','ru'),(4374,4075,'You must attach a file','en'),(4375,4075,'Вам необходимо присоединить файл','ru'),(4376,4076,'Attach file','en'),(4377,4076,'Присоединить файл','ru'),(4378,4077,'Some files have not been attached','en'),(4379,4077,'Некоторые файлы не были загружены','ru'),(4380,4078,'Note: In order to setup ePDQ essential payment gateway, you have to complete these steps: <ul><li>Log in to your ePDQ backoffice</li> <li>Open the \"Configuration\" -> \"Technical information\" page -> \"Global security parameters\" tab -> \"Hashing method\" section and select SHA-512 and UTF-8 options.</li> <li>Open the \"Configuration\" -> \"Technical information\" page -> \"Data and origin verification\" tab -> \"Checks for e-Commerce\" section and in the URL field enter this URL: <em>{{URL}}</em></li> <li>Define SHA-IN pass phrase in the corresponding section and further enter it here in X-Cart in the \"SHA-IN pass phrase\" field.</li> <li>Open the \"Configuration\" -> \"Technical information\" page -> \"Transaction feedback\" tab -> \"e-Commerce\" section and enable <em>I would like to receive transaction feedback parameters on the redirection URLs</em> option.</li> <li>Scroll down to the \"All transaction submission modes\" section and define SHA-OUT pass phrase and further enter it here in X-Cart in the \"SHA-OUT pass phrase\" field.</li></ul>','en'),(4381,4079,'PSPID','en'),(4382,4080,'SHA-IN pass phrase','en'),(4383,4081,'SHA-OUT pass phrase','en'),(4384,4082,'Currency','en'),(4385,4083,'Invoice number prefix','en'),(4386,4084,'Enable logging of ePDQ transactions','en'),(4387,4085,'Response from ePDQ is not trusted (SHA checking is failed)','en'),(4388,4086,'Unexpected result was received from ePDQ (transaction status is not set)','en'),(4389,4087,'PS Store ID','en'),(4390,4088,'HPP Key','en'),(4391,4089,'To set up the integration, go to the <a href=\"https://www3.moneris.com/mpg/\" target=\"_blank\">\"Site management\"</a> page on the eSelect site and make sure of the following:','en'),(4392,4090,'The \"PS Store ID\" and \"HPP Key\" value must be exactly the same as on it.','en'),(4393,4091,'The \"Approved URL\" value must be exactly as this:','en'),(4394,4092,'URL is copied','en'),(4395,4093,'The \"Declined URL\" value must be exactly as this:','en'),(4396,4094,'Set the \"Response Method\" setting to \"Sent to your server as a POST\".','en'),(4397,4095,'Enable the \'Use \"Enhanced Cancel\"\' option.','en'),(4398,4096,'Approved URL','en'),(4399,4097,'Declined URL','en'),(4400,4098,'Facebook Ads & Instagram Ads','en'),(4401,4099,'Product feed generation has been completed successfully.','en'),(4402,4100,'Product feed generation has been stopped.','en'),(4403,4101,'Generate Product Feed','en'),(4404,4102,'Product feed','en'),(4405,4103,'Facebook Pixel ID','en'),(4406,4104,'Product Feed URL','en'),(4407,4105,'Frequency of Product Feed renewal','en'),(4408,4106,'No products have been selected for feed generation','en'),(4409,4107,'Add to product feed','en'),(4410,4108,'Remove from product feed','en'),(4411,4109,'Add to Facebook product feed','en'),(4412,4110,'Wrong \"Facebook marketing enabled\" format','en'),(4413,4111,'Use the addon Google Product Feed for advanced flexibility generating a data feed for Facebook based on the product attributes and variants from your store catalog','en'),(4414,4112,'Generate product feed','en'),(4415,4113,'Include out of stock products into feed','en'),(4416,4114,'Value for the \"Add to cart\" event is calculated as: product price multiplied by','en'),(4417,4115,'Enable Advanced Matching','en'),(4418,4116,'Specify the percentage of users who complete the transaction. To find this value, go to Activity > Funnels and create a Funnel with the events Add to Cart and Purchases. The value you require will be shown on a Grey arrow.','en'),(4419,4117,'Value for the \"ViewContent\" event on a product page is calculated as: product price multiplied by','en'),(4420,4118,'Value for the \"InitiateCheckout\" event is calculated as: cart subtotal multiplied by','en'),(4421,4119,'Specify the percentage of users who complete the transaction. To find this value, go to Activity > Funnels and create a Funnel with the events Content View and Purchases. The value you require will be shown on a Grey arrow.','en'),(4422,4120,'Specify the percentage of users who complete the transaction. To find this value, go to Activity > Funnels and create a Funnel with the events Initiated Checkout and Purchases. The value you require will be shown on a Grey arrow.','en'),(4423,4098,'Facebook Ads & Instagram Ads','ru'),(4424,4099,'Подготовка ленты товаров была успешно завершена.','ru'),(4425,4100,'Подготовка ленты товаров была остановлена.','ru'),(4426,4101,'Создать ленту товаров','ru'),(4427,4102,'Лента товаров','ru'),(4428,4103,'Идентификатор пикселя','ru'),(4429,4104,'URL Ленты товаров','ru'),(4430,4105,'Частота обновления ленты товаров','ru'),(4431,4106,'Для создания ленты товаров не выбрано ни одного товара','ru'),(4432,4107,'Включить в ленту товаров','ru'),(4433,4108,'Убрать из ленты товаров','ru'),(4434,4109,'Включить в ленту товаров Facebook','ru'),(4435,4110,'Неправильный формат значения поля \"Facebook marketing enabled\"','ru'),(4436,4111,'Используйте модуль Google Product Feed для большей гибкости при создании фида данных для Facebook на основе атрибутов и вариантов товаров в вашем каталоге','ru'),(4437,4113,'Включать в фид товары, отсутствующие на складе','ru'),(4438,4114,'Значение для события \"Добавление в козину\" рассчитывается как: цена товара, умноженная на','ru'),(4439,4115,'Включить Advanced Matching','ru'),(4440,4116,'Укажите процент пользователей, которые завершают покупку. Чтобы найти данное значение, перейдите в секцию Activity > Funnels и создайте Funnel с событиями Add to Cart и Purchases. Нужное вам значение отображается на серой стрелке.','ru'),(4441,4117,'Значение для события \"Просмотр контента\" на странице товара рассчитывается как: цена товара, умноженная на','ru'),(4442,4118,'Значение для события \"Начало оформления покупки\" рассчитывается как: стоимость товаров в корзине, умноженная на','ru'),(4443,4119,'Укажите процент пользователей, которые завершают покупку. Чтобы найти данное значение, перейдите в секцию Activity > Funnels и создайте Funnel с событиями Content View и Purchases. Нужное вам значение отображается на серой стрелке.','ru'),(4444,4120,'Укажите процент пользователей, которые завершают покупку. Чтобы найти данное значение, перейдите в секцию Activity > Funnels и создайте Funnel с событиями Initiated Checkout и Purchases. Нужное вам значение отображается на серой стрелке.','ru'),(4445,4121,'Any special needs?','en'),(4446,4121,'Укажите информацию для продавца','ru'),(4447,2892,'Выберите метод доставки','ru'),(4448,4122,'Fast Lane checkout','en'),(4449,4122,'Пошаговый','ru'),(4450,4123,'Checkout type','en'),(4451,4123,'Тип страницы оплаты','ru'),(4452,4124,'Firstname','en'),(4453,4124,'Имя','ru'),(4454,4125,'Lastname','en'),(4455,4125,'Фамилия','ru'),(4456,4126,'Return to cart','en'),(4457,4126,'Вернуться к корзине','ru'),(4458,4127,'Edit address','en'),(4459,4127,'Редактировать','ru'),(4460,4128,'Edit email','en'),(4461,4128,'Редактировать','ru'),(4462,4129,'One Page checkout','en'),(4463,4129,'Одностраничный','ru'),(4464,4130,'Order note. Any special needs?','en'),(4465,4130,'Укажите информацию для продавца','ru'),(4466,2888,'Перейти к оплате','ru'),(4467,4131,'Street address','en'),(4468,4131,'Адрес','ru'),(4469,4132,'Zipcode','en'),(4470,4132,'Индекс','ru'),(4471,4133,'Click to finish your order','en'),(4472,4133,'Нажмите для завершения заказа','ru'),(4473,4134,'Order cannot be placed because some steps are not completed','en'),(4474,4134,'Заказ не может быть завершен, пока есть незаполненные поля','ru'),(4475,4135,'Click to proceed to the next step','en'),(4476,4135,'Нажмите для перехода на следующий шаг','ru'),(4477,4136,'Check shipping info','en'),(4478,4136,'Доставка','ru'),(4479,4137,'Choose another address','en'),(4480,4137,'Выбрать другой адрес','ru'),(4481,4138,'Delivery method','en'),(4482,4138,'Способ доставки','ru'),(4483,4139,'Addresses','en'),(4484,4139,'Адреса','ru'),(4485,4140,'Your order details will be sent to your email address','en'),(4486,4140,'Детали ордера будут отправлены на данный адрес','ru'),(4487,4141,'Edit billing address','en'),(4488,4142,'Edit shipping address','en'),(4489,4143,'Next step','en'),(4490,4144,'Free','en'),(4491,4144,'БЕСПЛАТНО','ru'),(4492,4145,'Free shipping','en'),(4493,4145,'Бесплатная доставка','ru'),(4494,4146,'FREE SHIPPING','en'),(4495,4146,'БЕСПЛАТНАЯ ДОСТАВКА','ru'),(4496,4147,'Wrong shipping freight value format','en'),(4497,4147,'Неправильный формат значения поля \"freightFixedFee\"','ru'),(4498,4148,'Special shipping method. Shows during checkout only if <ul><li>all the products in the cart are marked \"Free shipping\";</li><li>there are no other shipping methods available.</li></ul><a href=\"https://kb.x-cart.com/en/shipping/free_shipping_on_orders_that_meet_certain_conditions.html\" target=\"_blank\">Learn how to set up free shipping on orders that meet certain conditions</a>','en'),(4499,4148,'Специальный способ доставки. Отображается при оформлении заказа только если <ul><li>для всех товаров в корзине включена настройка \"Бесплатная доставка\";</li><li>нет других доступных способов доставки.</li></ul><a href=\"https://kb.x-cart.ru/shipping/free_shipping_on_orders_that_meet_certain_conditions.html\" target=\"_blank\">Узнайте, как настроить бесплатную доставку для заказов, соответствующих определенным условиям</a>','ru'),(4500,4149,'Shipping freight','en'),(4501,4149,'Фиксированная стоимость доставки','ru'),(4502,4150,'This field can be used to set a fixed shipping fee for the product. Make sure the field value is a positive number (greater than zero).','en'),(4503,4150,'В данном поле можно задать фиксированную стоимость доставки для редактируемого товара. Убедитесь, что используемое значение является положительным числом (больше нуля).','ru'),(4504,4151,'Shipping freight only','en'),(4505,4151,'указанному значению фиксированной стоимости доставки','ru'),(4506,4152,'Shipping freight + regular shipping rate','en'),(4507,4152,'сумме фиксированной стоимости доставки и стоимости доставки, рассчитанной стандартным способом','ru'),(4508,4153,'Special shipping method. Shows during checkout only if <ul><li>all the products in the cart have a shipping freight value defined;</li><li>there are no other shipping methods available.</li></ul>','en'),(4509,4153,'Специальный способ доставки. Отображается при оформлении заказа только если<ul><li>для всех товаров в корзине задана фиксированная стоимость доставки;</li><li>нет других доступных способов доставки.</li></ul>','ru'),(4510,4154,'Freight','en'),(4511,4154,'Фиксированная стоимость доставки','ru'),(4512,4155,'Exclude from shipping cost calculation','en'),(4513,4155,'Исключить из расчета стоимости доставки','ru'),(4514,4156,'Wrong \"exclude from shipping cost calculation\" (freeShipping) format','en'),(4515,4156,'Неправильный формат значения поля  \"Исключить из расчета стоимости доставки\" (freeShipping)','ru'),(4516,4157,'Wrong free shipping (shipForFree) format','en'),(4517,4157,'Неправильный формат значения поля \"Бесплатная доставка\"','ru'),(4518,4158,'Important info on the Free shipping add-on update','en'),(4519,4158,'Важная информация об обновлении модуля Free shipping','ru'),(4520,4159,'Your store now provides two free shipping options for individual products:<br>- Exclude from shipping calculation;<br> - Free shipping.<br>If a product is marked \'Exclude from shipping calculation\', this product is excluded from the shipping cost calculation for the order for any available shipping methods.<br>If a product is marked \'Free shipping\', it is treated as eligible for shipping using the method \'Free shipping\'. This method becomes available at checkout if all the products in the shopping cart are either eligible for free shipping or excluded from shipping calculation.','en'),(4521,4159,'В вашем магазине сейчас доступно два варианта бесплатной доставки для отдельных товаров:<br>- Исключение из расчета стоимости доставки;<br>- Бесплатная доставка.<br>Если в свойствах какого-либо товара отмечена опция \'Исключить из расчета стоимости доставки\', данный товар исключается из расчета стоимости доставки заказа для любых доступных способов доставки.<br>Если же в свойствах товара отмечена опция \'Бесплатная доставка\', то это означает, что данный товар может быть отправлен способом доставки \'Бесплатная доставка\'. Данный способ становится доступным при оформлении заказа, если все товары в корзине являются товарами с бесплатной доставкой, либо должны быть исключены из расчета стоимости доставки в соответствии с их настройками.','ru'),(4522,4160,'Warning! Your store now supports two free shipping options for individual products:<br>- Exclude from shipping calculation;<br>- Free shipping.<br>Information on whether a product should be excluded from shipping cost calculation must be submitted via the column shipForFree.<br>Information on whether a product should be eligible for free shipping must be submitted via the column freeShipping.','en'),(4523,4160,'Предупреждение: В вашем магазине сейчас доступно два варианта бесплатной доставки для отдельных товаров:<br>- Исключение из расчета стоимости доставки;<br>- Бесплатная доставка.<br>Информация о том, должен ли товар исключаться из расчета стоимости доставки, должна передаваться в колонке shipForFree.<br>Информация о том, является ли товар товаром с бесплатной доставкой, должна передаваться в колонке freeShipping.','ru'),(4524,4161,'Content has script or style tags. Click the Code View button to edit them.','en'),(4525,4161,'В текстовом поле присутствуют тэги скриптов или стилей. Нажмите на кнопку \"Просмотр HTML-кода\", чтобы отредактировать эти тэги.','ru'),(4526,4162,'Froala Editor settings','en'),(4527,4162,'Настройки редактора Froala','ru'),(4528,4163,'My location','en'),(4529,4164,'Specify your location','en'),(4530,4165,'Save location','en'),(4531,4166,'Location was successfully set','en'),(4532,4167,'Revert to default database','en'),(4533,4168,'X-Cart uses free \"GeoLite2 Country\" database by <a href=\"https://www.maxmind.com/en/geoip2-databases?%refID=xcart\" target=\"_blank\">MaxMind</a>. You can upload the more accurate database to determine the country, subdivisions, city, and postal code. <a href=\"https://www.maxmind.com/en/geoip2-databases?%refID=xcart%\" target=\"_blank\">Learn more</a>','en'),(4534,4169,'Location is invalid','en'),(4535,4170,'Your store uses the addon Geolocation for customer location tracking. The address provided through Geolocation will overwrite the values below. If a higher level of geolocation accuracy is required, you can upload an extended database via the <a href=\'{{geoip-settings-link}}\'>Geolocation addon settings page</a> so your store can estimate a user\'s location to a country, subdivision, city, and postal code.','en'),(4536,4163,'Страна','ru'),(4537,4164,'Укажите ваш адрес','ru'),(4538,4165,'Сохранить адрес','ru'),(4539,4166,'Адрес был сохранен','ru'),(4540,4171,'Вернуться к базе данных по умолчанию','ru'),(4541,4168,'X-Cart использует бесплатную базу данных \"GeoLite2 Country\" от <a href=\"https://www.maxmind.com/en/geoip2-databases?%refID=xcart\" target=\"_blank\">MaxMind</a>. Вы можете загрузить более точную базу данных для определения страны, территориального подразделения, города и почтового кода. <a href=\"https://www.maxmind.com/en/geoip2-databases?%refID=xcart\" target=\"_blank\">Подробнее</a>','ru'),(4542,4170,'Ваш магазин использует модуль Geolocation для определения местоположения покупателя. Нижеследующие данные будут перезаписаны с использованием адреса, предоставленного модулем Geolocation. При необходимости более высокой точности определения местоположения пользователя вы можете загрузить расширенную базу данных через <a href=\'{{geoip-settings-link}}\'>страницу настроек модуля Geolocation</a> - так, чтобы ваш магазин мог осуществлять оценку местоположения пользователя до уровня страны, области, города и индекса.','ru'),(4543,4172,'Google Feed URL: <a href=\"{{url}}\">{{url}}</a>','en'),(4544,4172,'Ссылка на список товаров: <a href=\"{{url}}\">{{url}}</a>','ru'),(4545,4173,'Generate feed','en'),(4546,4173,'Создать выгрузку','ru'),(4547,4174,'Search attribute name','en'),(4548,4174,'Искать по имени атрибута','ru'),(4549,4175,'Product count','en'),(4550,4175,'Количество товаров','ru'),(4551,4176,'Attribute type','en'),(4552,4176,'Тип атрибута','ru'),(4553,4177,'Any google group','en'),(4554,4177,'Любая группа Google','ru'),(4555,4178,'Google shopping group','en'),(4556,4178,'Группа в Google','ru'),(4557,4179,'Click on the \"Generate feed\" button to get the feed link.','en'),(4558,4179,'Нажмите на кнопку «Выгрузить список товаров», чтобы получить ссылку со выгрузкой товаров.','ru'),(4559,4180,'Generate feed','en'),(4560,4180,'Выгрузить список товаров','ru'),(4561,4181,'Feed generation...','en'),(4562,4181,'Идет создание выгрузки...','ru'),(4563,4182,'Feed generation & settings','en'),(4564,4182,'Настройки выгрузки товаров','ru'),(4565,4183,'Google Shopping Group','en'),(4566,4183,'Группы Google','ru'),(4567,4184,'Assign your attributes to Google groups to import your variants.','en'),(4568,4184,'На этой странице можно сопоставить атрибуты товаров с соответствующими категориями Google для более точного определения вариантов товара.','ru'),(4569,4185,'Feed generation has been completed successfully.','en'),(4570,4185,'Создание выгрузки было успешно завершено.','ru'),(4571,4186,'Feed generation has been stopped.','en'),(4572,4186,'Создание выгрузки было остановлено.','ru'),(4573,4187,'Export duplicates as separate products','en'),(4574,4187,'Выгружать дубликаты как отдельные товары','ru'),(4575,4188,'Export only the original product','en'),(4576,4188,'Выгружать только основной товар','ru'),(4577,4189,'The process of feed generation may take a while to complete. Please do not close this page until the process is fully completed.','en'),(4578,4189,'Процесс займет некоторое время. Пожалуйста, не закрывайте эту страницу до его окончания.','ru'),(4579,4190,'Google product feed','en'),(4580,4190,'Выгрузка товаров в Google','ru'),(4581,4191,'Remove from product feed','en'),(4582,4191,'Исключить из выгрузки','ru'),(4583,4192,'Add to product feed','en'),(4584,4192,'Включить в выгрузку','ru'),(4585,4193,'Assign shopping group','en'),(4586,4193,'Назначить группу','ru'),(4587,4194,'Attribute information has been successfully updated','en'),(4588,4194,'Информация по атрибутам успешно обновлена','ru'),(4589,4195,'Generate Google Product feed','en'),(4590,4195,'Создание списка товаров для Google','ru'),(4591,4196,'Google feed','en'),(4592,4196,'Выгрузка товаров в Google','ru'),(4593,4197,'Please select the attributes first','en'),(4594,4197,'Пожалуйста выберите атрибут','ru'),(4595,4198,'Product-specific','en'),(4596,4198,'Специальный для товара','ru'),(4597,4199,'Class \"{{class}}\"','en'),(4598,4199,'Класс \"{{class}}\"','ru'),(4599,4200,'Global Plain field','en'),(4600,4200,'Глобальное строчное поле','ru'),(4601,4201,'Global Hidden field','en'),(4602,4201,'Глобальное скрытое поле','ru'),(4603,4202,'Global Textarea','en'),(4604,4202,'Глобальное многострочное поле','ru'),(4605,4203,'Global Yes/No','en'),(4606,4203,'Глобальное Да/Нет поле','ru'),(4607,4204,'Merchant ID','en'),(4608,4205,'SubID','en'),(4609,4206,'Public Certificate File','en'),(4610,4207,'Public Key','en'),(4611,4208,'Private Key','en'),(4612,4209,'Private Key Password','en'),(4613,4210,'Currency','en'),(4614,4211,'Invoice number prefix','en'),(4615,4212,'Enable logging of iDEAL transactions','en'),(4616,4213,'Something is wrong with the iDEAL payment module settings. Please try later or use a different payment option.','en'),(4617,4214,'Unexpected result was received from iDEAL (transaction status is not set)','en'),(4618,4215,'Payment return page requested without expected parameters','en'),(4619,4216,'Warning! This payment method requires OpenSSL extension. Please install and enable this extension in your PHP configuration.','en'),(4620,4217,'Warning! Please re-check public and private key values and private key password!','en'),(4621,4218,'Select issuer','en'),(4622,4219,'Unknown payment transaction','en'),(4623,4220,'The file with the certificate needs to be located in the directory {{certsDir}}','en'),(4624,4221,'Mailchimp','en'),(4625,4222,'Mailchimp Integration with E-commerce support','en'),(4626,4223,'Type: select box','en'),(4627,4224,'Type: checkbox','en'),(4628,4225,'Mailchimp is an email marketing service with powerful tools to manage your email campaigns and subscribers while gathering advanced analytics information on your campaign performance.','en'),(4629,4226,'Update Mailchimp Lists','en'),(4630,4227,'Mailchimp Lists','en'),(4631,4228,'Mailchimp \"{{list_name}}\" list segments','en'),(4632,4229,'Mailchimp segment settings','en'),(4633,4230,'Subscription','en'),(4634,4231,'Subscribe to our news list and be in touch with our latest offers.','en'),(4635,4232,'News list subscriptions','en'),(4636,4233,'Select box','en'),(4637,4234,'Filter by order frequency','en'),(4638,4235,'Orders last month','en'),(4639,4236,'Filter by order amount','en'),(4640,4237,'Total amount of orders','en'),(4641,4238,'Filter by profile membership','en'),(4642,4239,'Filter by specific products','en'),(4643,4240,'Segment condition','en'),(4644,4241,'here','en'),(4645,4242,'Static','en'),(4646,4243,'Auto-Updated','en'),(4647,4244,'No subscription','en'),(4648,4245,'Web ID','en'),(4649,4246,'List rating','en'),(4650,4247,'Members count','en'),(4651,4248,'Open rate','en'),(4652,4249,'Click rate','en'),(4653,4250,'Selected by default','en'),(4654,4251,'Allow this product to be used as a Mailchimp segment condition','en'),(4655,4252,'1 minute','en'),(4656,4253,'10 minutes','en'),(4657,4254,'15 minutes','en'),(4658,4255,'30 minutes','en'),(4659,4256,'1 hour','en'),(4660,4257,'2 hours','en'),(4661,4258,'4 hours','en'),(4662,4259,'6 hours','en'),(4663,4260,'12 hours','en'),(4664,4261,'1 day','en'),(4665,4262,'2 days','en'),(4666,4263,'5 days','en'),(4667,4264,'1 week','en'),(4668,4265,'Mailchimp lists update','en'),(4669,4266,'First name or last name are empty. Please add a new address to your address book or modify existing and fill in those fields in order to subscribe to this list.','en'),(4670,4267,'Back to segments list','en'),(4671,4268,'Subscribe by default','en'),(4672,4269,'Groups of Mailchimp news list \"{{list_name}}\"','en'),(4673,4270,'Group names of Mailchimp group \"{{group_name}}\"','en'),(4674,4271,'Sign up for news and updates from your favorite store. Be the first to know about exclusive sales, offers and deals.','en'),(4675,4272,'Sign up for {{company_name}} news, sales and deals','en'),(4676,4273,'Here you can view and manage the Mailchimp news lists and groups of the user.','en'),(4677,4274,'Groups','en'),(4678,4275,'E-Commerce features setup','en'),(4679,4276,'Upload store data to Mailchimp','en'),(4680,4277,'Upload store data to Mailchimp to promote more efficient Mailchimp Product Recommendations and Abandoned Carts. Before clicking the button, select the lists for which you want Mailchimp \"stores\" to be created. A \"store\" is a collection of products, orders, carts and customers. Mailchimp will create the \"stores\" and will connect them with the lists you have specified. Store data from X-Cart will be uploaded for these specific stores.<br><a href=\"{{url}}\" target=\"_blank\">Learn more about Mailchimp e-Commerce features</a>','en'),(4681,4278,'Whether you need to draw attention to certain products, share some big news, or tell a story, our campaign builder makes it easy to create email campaigns that best suit your message.','en'),(4682,4279,'Connect with your Mailchimp account','en'),(4683,4280,'Reset Mailchimp connection','en'),(4684,4281,'Install Mailchimp addon','en'),(4685,4282,'Enter your Mailchimp API key manually','en'),(4686,4283,'The e-Commerce Analytics feature is the core component of the integration functionality.','en'),(4687,4284,'All discount coupons','en'),(4688,4285,'Only the discount coupons that match the Mailchimp promo rules','en'),(4689,4286,'Cannot authenticate','en'),(4690,4287,'ID','en'),(4691,4288,'Mailchimp lists','en'),(4692,4289,'Mailchimp settings','en'),(4693,4290,'Manage segments','en'),(4694,4291,'No groups defined','en'),(4695,4292,'No segments','en'),(4696,4293,'Successfully authenticated','en'),(4697,4294,'Update store data','en'),(4698,4295,'Uploading data has been completed successfully.','en'),(4699,4296,'Uploading data has been stopped.','en'),(4700,4221,'Mailchimp','ru'),(4701,4222,'Интеграция сервиса Mailchimp с поддержкой Ecommerce','ru'),(4702,4223,'Тип: список','ru'),(4703,4224,'Тип: галочка','ru'),(4704,4225,'Mailchimp это маркетиногвай сервис по отправке почтовых сообщений с мощными средствами управления рассылками и подписчиками, позволяющими собирать и обрабатывать информацию эффективности маркетинговых кампаний.','ru'),(4705,4226,'Обновить список рассылок Mailchimp','ru'),(4706,4227,'Список рассылок Mailchimp','ru'),(4707,4228,'Сегменты списка рассылок \"{{list_name}}\" Mailchimp','ru'),(4708,4229,'Настройки сегмента Mailchimp','ru'),(4709,4230,'Подписка','ru'),(4710,4231,'Подпишитесь на наши новостные рассылки и будьте в курсе наших специальных предложений и акций.','ru'),(4711,4232,'Подписки на новости','ru'),(4712,4233,'Список','ru'),(4713,4234,'Фильтровать по частоте заказов','ru'),(4714,4235,'Заказов за последний месяц','ru'),(4715,4236,'Фильтровать по общей сумме заказов','ru'),(4716,4237,'Общая сумма заказов','ru'),(4717,4238,'Фильтровать по пользовательским группам','ru'),(4718,882,'Пользовательские группы','ru'),(4719,4239,'Фильтровать по определенным товарам','ru'),(4720,1054,'товары','ru'),(4721,4240,'Условия попадания подписчика в сегмент','ru'),(4722,4241,'здесь','ru'),(4723,383,'Месяц','ru'),(4724,4242,'Статический','ru'),(4725,4243,'Авто обновляемый','ru'),(4726,4244,'Без подписки','ru'),(4727,4245,'Web ID','ru'),(4728,4246,'Рейтинг рассылки','ru'),(4729,4247,'Кол-во подписчиков','ru'),(4730,4248,'Процент открытия','ru'),(4731,4249,'Процент переходов','ru'),(4732,4250,'Выбран по умолчанию','ru'),(4733,4251,'Позволяэт данному товару быть использованним как условие для сегмента Mailchimp','ru'),(4734,907,'Никогда','ru'),(4735,4252,'1 минута','ru'),(4736,4253,'10 минут','ru'),(4737,4254,'15 минут','ru'),(4738,4255,'30 минут','ru'),(4739,4256,'1 час','ru'),(4740,4257,'2 часа','ru'),(4741,4258,'4 часа','ru'),(4742,4259,'6 часов','ru'),(4743,4260,'12 часов','ru'),(4744,4261,'1 день','ru'),(4745,4262,'2 деня','ru'),(4746,4263,'5 деня','ru'),(4747,4264,'1 неделя','ru'),(4748,4265,'Обновление списков Mailchimp','ru'),(4749,4266,'Имя или фамилия пусты. Пожалуйста, добавьте новый адрес в адресную книгу или дополните существующий заполнив соответствующие поля для того, чтобы подписаться на данную рассылку.','ru'),(4750,4267,'Назад к списку сегментов','ru'),(4751,4268,'Подписка по умолчанию','ru'),(4752,4269,'Группы листа \"{{list_name}}\"','ru'),(4753,4270,'Значения группы \"{{group_name}}\"','ru'),(4754,4271,'Подпишитесь на новости и обновления любимого магазина. Узнавайте об эксклюзивных скидках, акциях и предложениях первым!','ru'),(4755,4272,'Подпишитесь на рассылку о новостях, акциях и скидках','ru'),(4756,4273,'Данная секция позволяет просматривать и управлять новостными подписками и группами пользователя (Mailchimp).','ru'),(4757,4274,'Группы','ru'),(4758,4277,'Загрузите данные магазина в Mailchimp для более эффективной работы рекомендаций товаров и поддержки оставленных корзин от Mailchimp. Перед тем как нажать на кнопку, выберите списки, для которых требуется создать \"магазины\" в Mailchimp. \"Магазин\" - это набор товаров, заказов, корзин и покупателей. Mailchimp создаст \"магазины\" и привяжет их к спискам, которые вы указали. Данные из X-Cart будут выгружаться именно в эти магазины.<br><a href=\"{{url}}\" target=\"_blank\">Подробнее об опциях e-Commerce в Mailchimp</a>','ru'),(4759,4276,'Выгрузить данные в Mailchimp','ru'),(4760,4275,'Настройка опций e-Commerce','ru'),(4761,4278,'Хотите ли вы прорекламировать какой-то товар, поделиться важными новостями или рассказать историю - наш конфигуратор рассылок поможет вам с легкостью создать новостную рассылку, наилучшим образом соответствующую посланию, которое вы пытаетесь донести.','ru'),(4762,4279,'Подключить аккаунт Mailchimp','ru'),(4763,4280,'Переподключить аккаунт Mailchimp','ru'),(4764,4281,'Установить модуль Mailchimp','ru'),(4765,4282,'Введите API ключ Mailchimp вручную','ru'),(4766,4283,'Функция e-Commerce Analytics является ключевым компонентом функциональности данной интеграции.','ru'),(4767,4284,'Все купоны','ru'),(4768,4285,'Только купоны, которые соответствуют промо-правилам Mailchimp','ru'),(4769,4297,'News messages','en'),(4770,4297,'Новости','ru'),(4771,4298,'News message','en'),(4772,4298,'Новость','ru'),(4773,4299,'New news message','en'),(4774,4299,'Добавить новость','ru'),(4775,4300,'News','en'),(4776,4300,'Новости','ru'),(4777,4301,'Top News','en'),(4778,4301,'Последние новости','ru'),(4779,4302,'All news','en'),(4780,4302,'Все новости','ru'),(4781,4303,'Previous','en'),(4782,4303,'Предыдущая новость','ru'),(4783,4304,'Next','en'),(4784,4304,'Следующая новость','ru'),(4785,4305,'The news message has been updated','en'),(4786,4305,'Новость обновлена','ru'),(4787,4306,'The news message has been added','en'),(4788,4306,'Новость добавлена','ru'),(4789,4307,'Create news message','en'),(4790,4307,'Добавление новости','ru'),(4791,4308,'News page title','en'),(4792,4308,'Заголовок страницы новости','ru'),(4793,4309,'News title','en'),(4794,4309,'Заголовок новости','ru'),(4795,4310,'Leave blank to use news title as Page Title.','en'),(4796,4310,'Оставьте поле незаполненным чтобы использовать заголовок новости в качестве заголовка страницы.','ru'),(4797,4311,'<p>There are no news messages in your store. News messages are a great way to build a community around your products and notify clients about recent updates. Start by clicking <b>\"New news message\"</b>.</p>','en'),(4798,4311,'<p>Пока нет ни одной новости. С помощью новостей можно привлекать новых клиентов и уведомлять о различных изменениях. Начните с нажатия на кнопку <b>\"Добавить новость\"</b>.</p>','ru'),(4799,4312,'To move your existing subscribers to MailChimp lists, <a href=\"{{link}}\" target=\"_blank\">export your subscribers data</a> from X-Cart and use the import feature under your MailChimp account.','en'),(4800,4312,'Для переноса существующих подписчиков в списки на стороне MailChimp, <a href=\"{{link}}\" target=\"_blank\">экспортируйте данные подписчиков</a> из X-Cart и используйте функцию импорта в вашем аккаунте MailChimp.','ru'),(4801,4313,'Connect your store to MailChimp','en'),(4802,4313,'Связать магазин с MailChimp','ru'),(4803,4314,'Sign up for {{companyName}} news','en'),(4804,4314,'Подписаться на новости {{companyName}}','ru'),(4805,4315,'Thank you for subscribing to the newsletter! We hope you enjoy shopping at {{companyName}}','en'),(4806,4315,'Спасибо за подписку на наши новости. Мы рады, что вы - наш читатель!','ru'),(4807,4316,'Subscribers','en'),(4808,4316,'Подписчики','ru'),(4809,4317,'Email or login','en'),(4810,4317,'Email или логин','ru'),(4811,4318,'Enter email address','en'),(4812,4318,'Введите email','ru'),(4813,4319,'Subscribers imported','en'),(4814,4319,'Подписчики импортированы','ru'),(4815,4320,'Subscriber with email {{email}} already subscribed','en'),(4816,4320,'Подписчик с email {{email}} уже в существует','ru'),(4817,4321,'<p>No one has subscribed on your newsletter yet.</p><p>You can manage newsletter subscribers on this page.</p>','en'),(4818,4321,'<p>Пока никто не подписался на новости вашего магазина.</p><p class=\'text-center\'>На этой странице вы сможете управлять действующими подписками на новости.</p>','ru'),(4819,4322,'You have configured Mailchimp as your primary email newsletter tool. New subscribers will be added directly to your Mailchimp lists (this X-Cart list will be skipped). You can manage your subscriber lists under your Mailchimp account','en'),(4820,4322,'Вы настроили Mailchimp для использования в качестве основного инструмента отправки рассылки в адрес ваших подписчиков. Новые подписчики будут добавляться напрямую в списки на стороне Mailchimp (минуя данный список в X-Cart). Вы можете управлять списками подписчиков через свой аккаунт Mailchimp.','ru'),(4821,4323,'Newsletters','en'),(4822,4323,'Рассылка','ru'),(4823,4324,'Can\'t subscribe you right now. Try later','en'),(4824,4325,'Product','en'),(4825,4325,'товар','ru'),(4826,32,'Предыдущий','ru'),(4827,33,'Следующий товар','ru'),(4828,4326,'Not finished order','en'),(4829,4326,'Незавершенный заказ','ru'),(4830,4327,'not finished','en'),(4831,4327,'не завершен','ru'),(4832,4328,'in case of failed or cancelled payment','en'),(4833,4328,'В случае неудачной оплаты','ru'),(4834,4329,'before payment','en'),(4835,4329,'до оплаты','ru'),(4836,4330,'Export of Not Finished orders is not supported. To export the orders which are now in this state, change their fulfillment status from Not Finished to any other.','en'),(4837,4330,'Экспорт незавершённых заказов не поддерживается. Для экспорта имеющихся заказов в данном статусе необходимо изменить их статус доставки с \'Не завершен\' на любой другой.','ru'),(4838,4331,'Not Finished orders were skipped during the export process. If you wish to export the orders which are now in this state, change their fulfillment status from Not Finished to any other.','en'),(4839,4331,'Незавершенные заказы были пропущены в процессе экспорта. Для экспорта заказов данного типа измените их статус доставки c \'Не завершен\' на любой другой.','ru'),(4840,4332,'You can find the failed order <a href=\"{{url}}\">here</a>','en'),(4841,4332,'Вы можете найти незавершенный заказ <a href=\"{{url}}\">здесь</a>','ru'),(4842,4333,'Add first product','en'),(4843,4333,'Добавьте товар','ru'),(4844,4334,'Upload company logo','en'),(4845,4334,'Загрузите логотип','ru'),(4846,4335,'Verify geo settings','en'),(4847,4335,'Проверьте геонастройки','ru'),(4848,4336,'Set up shipping methods','en'),(4849,4336,'Настройте доставку','ru'),(4850,4337,'Set up payment gateways','en'),(4851,4337,'Настройте прием платежей','ru'),(4852,4338,'Save and go to the next step','en'),(4853,4338,'Сохранить и перейти к следующему шагу','ru'),(4854,4339,'Proceed to the next step','en'),(4855,4339,'Перейти к следующему шагу','ru'),(4856,4340,'Close wizard','en'),(4857,4340,'Закрыть помощник','ru'),(4858,4341,'Skip this step','en'),(4859,4341,'Пропустить шаг','ru'),(4860,4342,'The uploaded image is too large. Please resize this image and try again.','en'),(4861,4342,'Слишком большое изображение. Пожалуйсте, уменьшите его и повторите попытку.','ru'),(4862,4343,'Your store is {{X}}% ready to accept the first order.','en'),(4863,4343,'Основные настройки магазина выполнены на {{X}}%','ru'),(4864,4344,'Let’s setup your store.','en'),(4865,4344,'Приступим к настройке магазина','ru'),(4866,4345,'Congratulations! Your store has been installed.','en'),(4867,4345,'Поздравляем! Ваш магазин установлен.','ru'),(4868,4346,'This wizard will help you to set it up step by step. Your progress will appear at the top.<br/>As soon as you hit 100%, you’re all set to accept the first order.','en'),(4869,4346,'Этот мастер настройки поможет пошагово выполнить основные настройки магазина.<br/>Пройдя его до конца, вы сможете принять свой первый заказ.','ru'),(4870,4347,'Let\'s setup your store','en'),(4871,4347,'Приступить к настройке магазина','ru'),(4872,4348,'Skip and remind me later','en'),(4873,4348,'Закрыть и напомнить позднее','ru'),(4874,4349,'Close and don’t show again','en'),(4875,4349,'Закрыть и больше не показывать','ru'),(4876,4350,'Add your first product','en'),(4877,4350,'Добавим первый товар?','ru'),(4878,4351,'Here it is, the best place to show your items to the world. Get started by adding a product name, picture and price.','en'),(4879,4351,'Укажите название товара, загрузите его изображение и задайте цену','ru'),(4880,4352,'Learn how to import products from .CSV file','en'),(4881,4352,'Как импортировать товары с помощью .CSV файла','ru'),(4882,4353,'Add other options','en'),(4883,4353,'Задать дополнительные настройки','ru'),(4884,4354,'Enter product name','en'),(4885,4354,'Введите название товара','ru'),(4886,4355,'Click here to upload product image','en'),(4887,4355,'Загрузить картинку товара','ru'),(4888,4356,'(weight, description, sale price)','en'),(4889,4356,'(вес товара, описание, цена со скидкой)','ru'),(4890,4357,'Good going! You\'ve added 1 product','en'),(4891,4357,'Прекрасно! Ваш товар добавлен.','ru'),(4892,4358,'The newly created product is already in your storefront. <a href=\'{{storefront}}\' target=\'_blank\' :href=\'productUrl\'>Have a look!</a><br>Ready to delete demo products?','en'),(4893,4358,'Посмотрите, как он будет выглядеть <a href=\'{{storefront}}\' target=\'_blank\' :href=\'productUrl\'>на витрине магазина</a><br>. А теперь давайте удалим демо-товары.','ru'),(4894,4359,'I\'ll do it later','en'),(4895,4359,'Я удалю их позднее','ru'),(4896,4360,'Delete demo products','en'),(4897,4360,'Удалить демо-товары','ru'),(4898,4361,'Ready to delete demo products?','en'),(4899,4361,'Удалим демо-товары?','ru'),(4900,4362,'Done! We\'ve just deleted all your demo products','en'),(4901,4362,'Готово! Демо-товары удалены.','ru'),(4902,4363,'Add a few <a href=\'{{more}}\' target=\'_blank\'>more products</a> to your catalog or proceed to the next step — whatever makes you happy.','en'),(4903,4363,'Теперь можно <a href=\'{{more}}\' target=\'_blank\'>добавить еще один товар</a> в каталог.  А можно перейти к следующим настройкам.','ru'),(4904,4364,'You can view the newly created product in your <a href=\'{{storefront}}\' target=\'_blank\' :href=\'productUrl\'>storefront</a> or add a few <a href=\'{{more}}\' target=\'_blank\'>more products</a> to your catalog.','en'),(4905,4364,'Посмотрите, как выглядит новый товар <a href=\'{{storefront}}\' target=\'_blank\' :href=\'productUrl\'>на витрине</a> или <a href=\'{{more}}\' target=\'_blank\'>добавьте еще один товар</a> в каталог.','ru'),(4906,4365,'Upload your company logo','en'),(4907,4365,'Давайте добавим логотип компании','ru'),(4908,4366,'Design your online store to fit your brand','en'),(4909,4366,'и тут сразу станет уютнее ;)','ru'),(4910,4367,'<p>Click here to upload your logo. Recommended 400x150px (PNG, JPG, GIF)</p><button class=\'btn regular-button\'>Choose image</button>','en'),(4911,4367,'Нажмите сюда, чтобы загрузить логотип. Предпочтительно 400x150px (PNG, JPG, GIF)</p><button class=\'btn regular-button\'>Выберите изображение</button>','ru'),(4912,4368,'Good job! You company logo is added','en'),(4913,4368,'Готово! Логотип обновлен','ru'),(4914,4369,'Here is the way it looks like on desktop & mobile devices. Do you like it?','en'),(4915,4369,'Вот как он будет выглядеть на экранах. Нравится?','ru'),(4916,4370,'Upload a new logo','en'),(4917,4370,'Загрузить другой логотип','ru'),(4918,4371,'Learn how to customize your store with Layout Editor option','en'),(4919,4371,'Как еще я могу изменить внешний вид своего магазина?','ru'),(4920,4372,'(without writing a single line of code) - 2 min','en'),(4921,4372,'(за 2 минуты, и ни одной строчки кода!)','ru'),(4922,4373,'Configure your geographic settings to connect with local customers','en'),(4923,4373,'Давайте проверим географические и локализационные настройки','ru'),(4924,4374,'We\'ve tried to guess your country, currency and weight. Verify, please.','en'),(4925,4374,'Мы попытались угадать страну, валюту и единицу измерения веса. Все верно?','ru'),(4926,4375,'Ex.','en'),(4927,4375,'Например,','ru'),(4928,4376,'More localisation settings','en'),(4929,4376,'Более детальные настройки','ru'),(4930,4377,'Set your company info','en'),(4931,4377,'Добавьте информацию о компании','ru'),(4932,4378,'We will use this info to create invoices, send emails and calculate shipping rates for your customers.','en'),(4933,4378,'Эти данные будут отображаться в email-нотификациях, печататься на счете и использоваться для расчета стоимости доставки','ru'),(4934,4379,'Geo settings & company info are all set. Congrats!','en'),(4935,4379,'Прекрасно, локализацинные настройки и данные о компании обновлены','ru'),(4936,4380,'Do you need to ship your products?','en'),(4937,4380,'Ваши товары требуют доставки?','ru'),(4938,4381,'Yes, I sell tangible goods that need to be shipped','en'),(4939,4381,'Да, я продаю физические товары','ru'),(4940,4382,'Set up shipping','en'),(4941,4382,'Настроить доставку','ru'),(4942,4383,'I sell digital goods or services and do not need to set up shipping','en'),(4943,4383,'Я продаю цифровые товары или сервисы, поэтому доставка не требуется','ru'),(4944,4384,'Mark all products as non-shippable','en'),(4945,4384,'Отключить доставку товаров','ru'),(4946,4385,'Configure shipping rates for your store','en'),(4947,4385,'Давайте настроим стоимость доставки','ru'),(4948,4386,'Besides, you can manually define your shipping rates.','en'),(4949,4386,'Также, вы можете задать стоимость доставки вручную.','ru'),(4950,2584,'Прочитайте, как это сделать','ru'),(4951,4387,'My shipping','en'),(4952,4387,'Моя доставка','ru'),(4953,4388,'Module settings','en'),(4954,4388,'Настройки модуля','ru'),(4955,4389,'Here you can choose a shipping carrier to provide your customers with real-time quotes','en'),(4956,4389,'Выберите службу доставки для онлайн расчета стоимости доставки','ru'),(4957,4390,'Advanced shipping options','en'),(4958,4390,'Расширенные настройки доставки','ru'),(4959,4391,'Create shipping rate','en'),(4960,4391,'Сохранить новый тариф','ru'),(4961,4392,'Bingo! You\'ve added {{carrier}} as a shipping carrier','en'),(4962,4392,'Готово! {{carrier}} будет использоваться в магазине для расчета стоимости доставки','ru'),(4963,4393,'You\'ve successfully set up shipping areas and rates for your store','en'),(4964,4393,'Зоны доставки и тарифы настроены','ru'),(4965,4394,'Now you can define how shipping rates should be calculated based on delivery time, weight and other parameters.','en'),(4966,4394,'Теперь вы можете настроить, как стоимость доставки будет изменяться в зависимости от времени доставки, веса и других параметров.','ru'),(4967,4395,'Advanced shipping settings','en'),(4968,4395,'Расширенные настройки стоимости доставки','ru'),(4969,4396,'Manage your payment options','en'),(4970,4396,'Настроим способы оплаты','ru'),(4971,4397,'120+ supported payment gateways, such as PayPal, Authorize.net and Sage Pay, will let you accept payments from all over the world in multiple currencies and languages, offline & online.','en'),(4972,4397,'Выберите из более чем 120 интеграций с платежными системами, включая Yandex.Кассу, Web-money и PayPal. Мы моддерживаем множество валют и языков, поэтому ваш магазин может работать для клиентов со всего мира.','ru'),(4973,4398,'Offline method','en'),(4974,4398,'Оффлайн метод','ru'),(4975,4399,'Online method','en'),(4976,4399,'Онлайн метод','ru'),(4977,4400,'Some people simply prefer to place their orders by phone — let them do that.','en'),(4978,4400,'Некоторые покупатели предпочитают оформить заказ по телефону - почему бы и нет?','ru'),(4979,4401,'Set up offline & online payments','en'),(4980,4401,'Настроить другие методы оплаты','ru'),(4981,4402,'Launch','en'),(4982,4402,'Подключить','ru'),(4983,4403,'Excellent! Now you can get paid','en'),(4984,4403,'Ура! Теперь вы можете принимать платежи','ru'),(4985,4404,'Time to check how it works for your customers. Open the <a href=\'{{url}}\' target=\'_blank\'>storefront</a> to place a test order.','en'),(4986,4404,'Пора проверить, как все работает для покупателя. Перейдите к <a href=\'{{url}}\' target=\'_blank\'>витрине</a>, чтобы оформить тестовый заказ.','ru'),(4987,4405,'Need help setting up your store?','en'),(4988,4405,'Нужна помощь с настройкой?','ru'),(4989,4406,'Contact our expert','en'),(4990,4406,'Свяжитесь с нами','ru'),(4991,4407,'X-Cart professionals will easily materialize just about any idea you’ve got.','en'),(4992,4407,'Наши профессионалы помогут претворить в жизнь любые ваши идеи, даже самые смелые.','ru'),(4993,4408,'User manuals, release notes, modules, videos and more.','en'),(4994,4408,'Руководство по эксплуатации X-Cart и модулей, обучающие видео, описания новых версий и др.','ru'),(4995,4409,'Knowledge base','en'),(4996,4409,'Инструкции пользователя','ru'),(4997,4410,'Developer docs','en'),(4998,4410,'Документация для разработчиков','ru'),(4999,4411,'See the tutorials and documentation about X-Cart store customization.','en'),(5000,4411,'Все о модификациях дизайна и функционала магазинов на X-Cart','ru'),(5001,4412,'Sales & Customer Service:','en'),(5002,4412,'Позвоните нам','ru'),(5003,4413,'International: {{phone}}','en'),(5004,4413,'Международная линия: {{phone}}','ru'),(5005,4414,'Sales & Customer Service: {{phone}}','en'),(5006,4414,'Позвоните нам: {{phone}}','ru'),(5007,4415,'Could not save logo image','en'),(5008,4416,'My Shipping','en'),(5009,4417,'Onboarding Wizard','en'),(5010,4418,'Name length must be less then {{length}}','en'),(5011,4419,'{{count}} products selected','en'),(5012,4419,'Выбрано {{count}} товар(ов)','ru'),(5013,4420,'Comparison table - {{count}} items','en'),(5014,4420,'Таблица для сравнения — {{count}} товар(ов)','ru'),(5015,4421,'Add a different product to compare','en'),(5016,4421,'Добавьте для сравнения другие товары','ru'),(5017,4422,'Clear list','en'),(5018,4422,'Очистить список','ru'),(5019,4423,'Differences only','en'),(5020,4423,'Оставить только отличия','ru'),(5021,4424,'Add to compare','en'),(5022,4424,'Сравнить','ru'),(5023,4425,'No products have been selected for comparison.','en'),(5024,4425,'Товары для сравнения не выбраны.','ru'),(5025,4426,'The product has been removed from the <a href=\"{{url}}\">comparison table</a>','en'),(5026,4426,'Товар удален из <a href=\"{{url}}\">таблицы сравнения</a>.','ru'),(5027,4427,'The product has been added to the <a href=\"{{url}}\">comparison table</a>','en'),(5028,4427,'Товар добавлен в <a href=\"{{url}}\">таблицу сравнения</a>','ru'),(5029,4428,'The comparison table has been cleared.','en'),(5030,4428,'Таблица сравнения очищена.','ru'),(5031,4429,'Shopping options','en'),(5032,4430,'Show products','en'),(5033,4431,'Reset filter','en'),(5034,4432,'No products matching your criteria found. Please try again with different parameters.','en'),(5035,4433,'Show all products in this category','en'),(5036,4434,'Price range','en'),(5037,4435,'In stock only','en'),(5038,4436,'Generate cache on the fly','en'),(5039,4437,'Remove cache when attribute, tag or product data is changed','en'),(5040,4438,'Click the button to remove the data cache used by your product filter. After removing the cache, open any category in the storefront area to have the cache generated anew.','en'),(5041,4439,'Remove product filter cache','en'),(5042,4440,'Hidden from products filter','en'),(5043,4441,'Visible in products filter','en'),(5044,4442,'Classes for product filter','en'),(5045,4443,'All classes from this category','en'),(5046,4444,'Do not show the filter','en'),(5047,4445,'Choose classes...','en'),(5048,4446,'Alphabetical','en'),(5049,4447,'Manual','en'),(5050,4448,'Wrong useClasses format. This should be \'A\', \'N\' or \'D\'','en'),(5051,4449,'Hash','en'),(5052,4450,'GET params','en'),(5053,4451,'The product filter cache has been removed successfully.','en'),(5054,4429,'Поиск','ru'),(5055,4430,'Показать','ru'),(5056,4431,'Сбросить','ru'),(5057,4432,'Нет товаров удовлетворяющих выбранным условиям.','ru'),(5058,4433,'Показать все товары в категории','ru'),(5059,4434,'Цена','ru'),(5060,4435,'Только в наличии','ru'),(5061,4436,'Генерировать кеш в процессе работы','ru'),(5062,4437,'Сбрасывать кеш при изменении данных атрибутов, тегов или товаров','ru'),(5063,4438,'Кнопка служит для удаления кеша данных, используемого фильтром товаров. После удаления кеша откройте витрину и выберите любую категорию, чтобы кеш был сгенерирован заново','ru'),(5064,4439,'Удалить кеш фильтра товаров','ru'),(5065,4440,'Скрыт из фильтра товаров','ru'),(5066,4441,'Отображается в фильтре товаров','ru'),(5067,4442,'Классы для фильтра товаров','ru'),(5068,4443,'Все классы из этой категории','ru'),(5069,4444,'Не отображать фильтр','ru'),(5070,4445,'Выбрать классы...','ru'),(5071,4446,'По алфавиту','ru'),(5072,4447,'Вручную','ru'),(5073,4448,'Неправильный формат значения useClasses. Возможные значения: \'A\', \'N\' or \'D\'','ru'),(5074,4449,'Хеш','ru'),(5075,4450,'GET параметры','ru'),(5076,4452,'Tag','en'),(5077,4453,'New tag','en'),(5078,4454,'Product tags','en'),(5079,4455,'Please select the tags first','en'),(5080,4456,'Selected tags have been deleted','en'),(5081,4457,'Categories and tags','en'),(5082,4458,'<p>Tags list is empty. Tags help your customers to find products with the specific feature. You can add tags using the <b>\"New tag\"</b> button and then assign them to the product on its edit page.</p>','en'),(5083,4459,'{{count}} tag duplicates ignored','en'),(5084,4452,'Тег','ru'),(5085,4453,'Новый тег','ru'),(5086,5,'Теги','ru'),(5087,4454,'Теги товаров','ru'),(5088,4455,'Пожалуйста, сначала выберите тег','ru'),(5089,4456,'Выбранные теги были удалены','ru'),(5090,4457,'Категории и теги','ru'),(5091,4458,'<p>Список тегов пуст. Теги помогут вашим покупателям быстрее найти нужный товар. Вы можете добавить тег с помощью кнопки <b>\"Новый тег\"</b>. После этого его можно будет назначить товару на странице редактирования товара.</p>','ru'),(5092,4459,'Неучтенные дубликаты тегов {{count}}','ru'),(5093,4460,'API key is a secret key that allows to access REST API functionality. If this key is not specified, the request will not be processed.','en'),(5094,4461,'IMPORTANT:','en'),(5095,4462,'REST API allows to get or change any information in your store (including profiles, orders, payment transactions, inner store configuration, products, categories and so on), so your API key must be as complex as possible and kept private.','en'),(5096,4463,'{{count}} stars','en'),(5097,4464,'{{count}} stars','en'),(5098,4465,'{{count}} stars','en'),(5099,4466,'{{count}} stars','en'),(5100,4467,'{{count}} star','en'),(5101,4468,'Any rating','en'),(5102,4469,'{{product}} reviews','en'),(5103,4470,'Product reviews','en'),(5104,4471,'Products reviews','en'),(5105,4472,'Add review','en'),(5106,4473,'Edit review','en'),(5107,4474,'Approve review','en'),(5108,4475,'The review has been created','en'),(5109,4476,'The review has been deleted','en'),(5110,4477,'The review has not been created since the product {{product}} has not been found','en'),(5111,4478,'The review has not been updated since the product {{product}} has not been found','en'),(5112,4479,'Reviewer','en'),(5113,4480,'Rating','en'),(5114,4481,'Reviews imported','en'),(5115,4482,'Product, SKU or customer info','en'),(5116,4483,'Approve','en'),(5117,4484,'Start typing product name or SKU','en'),(5118,4485,'Customer name','en'),(5119,4486,'Start typing customer email or name','en'),(5120,4487,'Text of review','en'),(5121,4488,'Published','en'),(5122,4489,'Please sign in to add review','en'),(5123,4490,'You have already reviewed this product','en'),(5124,4491,'Edit your review','en'),(5125,4492,'Add your own review','en'),(5126,4493,'Thank you for sharing your opinion with us!','en'),(5127,4494,'Your product rating is saved. Thank you!','en'),(5128,4495,'Your review has been updated. Thank your for sharing your opinion with us!','en'),(5129,4496,'Rating of votes','en'),(5130,4497,'Your email','en'),(5131,4498,'customers','en'),(5132,4499,'Average rating','en'),(5133,4500,'out of','en'),(5134,4501,'Based on','en'),(5135,4502,'votes','en'),(5136,4503,'Reviews','en'),(5137,4504,'Reviews: {{count}}','en'),(5138,4505,'We may use this email if we need additional information on your review. We will not use it for any kind of mailing lists or spam subscriptions','en'),(5139,4506,'How do you rate this item?','en'),(5140,4507,'Write your review','en'),(5141,4508,'Your review','en'),(5142,4509,'Back to product details','en'),(5143,4510,'Customer reviews','en'),(5144,4511,'On moderation','en'),(5145,4512,'Read all reviews for the product','en'),(5146,4513,'Rates','en'),(5147,4514,'By Rate - 0-9','en'),(5148,4515,'By Rate - 9-0','en'),(5149,4516,'Only registered customers who purchased this product can leave feedback','en'),(5150,4517,'Registered users who purchased the product','en'),(5151,4518,'Score: {{score}} (votes: {{votes}})','en'),(5152,4519,'Votes: {{votes}}','en'),(5153,4520,'No reviews.','en'),(5154,4521,'Not rated yet','en'),(5155,4522,'Be the first and leave feedback','en'),(5156,4523,'All users','en'),(5157,4524,'Registered users only','en'),(5158,4525,'Reviews and ratings','en'),(5159,4526,'Ratings only','en'),(5160,4527,'Reviews only','en'),(5161,4528,'Review','en'),(5162,4529,'Selected reviews have been deleted','en'),(5163,4530,'Please select the reviews first','en'),(5164,4531,'Selected reviews have been updated','en'),(5165,4532,'Reviews about product','en'),(5166,4533,'New product reviews','en'),(5167,4534,'Ratings and Reviews of {{product}}','en'),(5168,4535,'Rating: {{rating}} out of {{maxRating}}. Review by {{reviewerName}}: {{review}}','en'),(5169,4536,'SEO','en'),(5170,4537,'Select the review that should be included into the rich snippet shown for the page of this product when the page appears in search results by Google and other major search engines. More info: <a href=\"https://support.google.com/webmasters/answer/146750\" target=\"_blank\">https://support.google.com/webmasters/answer/146750</a>','en'),(5171,4538,'Anonymous reviewer','en'),(5172,4539,'Reject','en'),(5173,4540,'There are no comments yet. Be the first to leave a comment','en'),(5174,4541,'A new review has been submitted for the product \"{{name}}\".','en'),(5175,4542,'Go to see the review <a href=\"{{link}}\">in the Admin area</a>','en'),(5176,4543,'<p>No one has rated your products yet. Once someone reviews your product (or you add a review manually), this is the place to track, moderate and remove reviews.</p>','en'),(5177,4543,'<p>Никто пока не оценил ваши товары. Как только появятся отзывы о ваших товарах, вы сможете управлять ими на этой странице.</p>','ru'),(5178,4544,'Please review the product {{product}}','en'),(5179,4544,'Пожалуйств, оставьте отзыв на товар {{product}}','ru'),(5180,4545,'<p>Thank you for your recent purchase from {{company}} – Order #{{orderNumber}} ({{orderDate}}):</p>','en'),(5181,4545,'<p>Благодарим Вас за недавнюю покупку у {{company}} – Заказ #{{orderNumber}} ({{orderDate}}):</p>','ru'),(5182,4546,'<p>Would you be willing to rate these products and write a review? Your opinion is important us.</p><p>To write a review:</p><p>1) Click on the product name to open the Customer reviews section for the product<br />2) Click Add review<br />3) Rate the product and write your feedback.</p><p>Thank you so much for taking the time to let us know what you think. It is truly appreciated.</p>','en'),(5183,4546,'<p>Готовы ли вы оценить эти товары и написать отзыв? Ваше мнение очень важно для нас!</p><p>Чтобы написать отзыв:</p><p>1) Нажмите на название товара, чтобы открыть раздел Отзывы для этого товара<br />2) Нажмите кнопку Добавить отзыв<br />3) Оцените товар и напишите свой отзыв.</p><p>Спасибо, что нашли время сообщить нам свое мнение. Мы очень ценим это.</p>','ru'),(5184,4547,'Excellent','en'),(5185,4547,'Отлично','ru'),(5186,4548,'Good','en'),(5187,4548,'Хорошо','ru'),(5188,4549,'Average','en'),(5189,4549,'Нормально','ru'),(5190,4550,'Fair','en'),(5191,4550,'Посредственно','ru'),(5192,4551,'Poor','en'),(5193,4551,'Плохо','ru'),(5194,4552,'Text of response','en'),(5195,4552,'Ответ','ru'),(5196,4553,'Response date is in wrong format','en'),(5197,4553,'Неверный формат поля \"responseDate\"','ru'),(5198,4554,'Add response','en'),(5199,4554,'Добавить ответ','ru'),(5200,4555,'SKU or Product name','en'),(5201,4555,'Артикул или название товара','ru'),(5202,4556,'First name, Last name or E-mail','en'),(5203,4556,'Имя, фамилия или e-mail','ru'),(5204,4557,'Enter a name to be published with the review','en'),(5205,4557,'Введите имя для отображения в отзыве','ru'),(5206,4558,'Tab displaying product reviews. Added by the addon <a href=\"{{url}}\">Product Reviews</a>','en'),(5207,4558,'Вкладка для отображения отзывов о товаре. Добавляется модулем <a href=\"{{url}}\">Product Reviews</a>','ru'),(5208,4559,'No email','en'),(5209,4560,'Reviewer name','en'),(5210,4561,'Shopper approved promo','en'),(5211,4562,'Vendor name','en'),(5212,4563,'Processing mode','en'),(5213,4564,'Encryption Password','en'),(5214,4565,'Invoice number prefix','en'),(5215,4566,'Pricing currency','en'),(5216,4567,'Don\'t have an account yet? <a href=\"https://applications.sagepay.com/apply/653E8C42-AD93-4654-BB91-C645678FA97B\">Sign up</a> for SagePay now!','en'),(5217,4568,'Sage Pay is UK\'s leading independent payment service provider (PSP) and is one of the most trusted payment brands. Every year Sage Pay processes billions of pounds worth of secure payments for its 50,000+ customers and makes the process of accepting payments online, over the phone, or in person simpler, faster, safer and more profitable for businesses.<br /><br />Sage Pay is a subsidiary of FTSE 100 business management software and services company The Sage Group plc.','en'),(5218,4569,'Please enter your encryption password (This is different from your merchant password). More info on encryption passwords is available <a href=\'{{link}}\'  target=\'_blank\'>here</a>','en'),(5219,4570,'Sitemap','en'),(5220,4571,'Information','en'),(5221,4571,'Информация','ru'),(5222,4570,'Карта сайта','ru'),(5223,4572,'The \"Stripe\" feature is not configured and cannot be used.','en'),(5224,4573,'The \"Stripe\" feature requires https to be <a href=\"{{url}}\">properly set up</a> for your store.','en'),(5225,4574,'{{count}} items ({{total}})','en'),(5226,4574,'{{count}} товаров ({{total}})','ru'),(5227,4575,'CVC verification: {{state}}','en'),(5228,4575,'Проверка подлинности кредитной карты (CVC): {{state}}','ru'),(5229,4576,'Address line verification: {{state}}','en'),(5230,4576,'Проверка адреса: {{state}}','ru'),(5231,4577,'Address zipcode verification: {{state}}','en'),(5232,4577,'Проверка почтового индекса: {{state}}','ru'),(5233,4578,'Requested transaction type: {{actual}}; real transaction type: {{real}}','en'),(5234,4578,'Запрашивалася транзакция типа {{actual}}, а реально была выполнена типа {{real}}','ru'),(5235,4579,'Requested amount: {{actual}}; real amount: {{real}}','en'),(5236,4579,'Запрашивалось к оплате {{actual}}, а реально было оплачено {{real}}','ru'),(5237,4580,'Requested currency: {{actual}}; real currency: {{real}}','en'),(5238,4580,'Запрашивалось к оплате сумма в валюте {{actual}}, а реально было оплачено в валюте {{real}}','ru'),(5239,4581,'Copy \"Webhook URL\" and go to <a href=\"https://dashboard.stripe.com/account/webhooks\" target=\"_blank\">Account settings</a>','en'),(5240,4581,'Скопируйте \"Webhook URL\" и перейдите в <a href=\"https://dashboard.stripe.com/account/webhooks\" target=\"_blank\">Account settings</a>','ru'),(5241,4582,'Open the page <strong>\"Webhooks\"</strong> in the <strong>\"Developers\"</strong> section of dashboard.stripe.com: <a href=\"https://dashboard.stripe.com/account/webhooks\" target=\"_blank\">https://dashboard.stripe.com/account/webhooks</a>','en'),(5242,4582,'Откройте страницу <strong>\"Webhooks\"</strong> раздела </strong>\"Developers\"<strong> на dashboard.stripe.com: <a href=\"https://dashboard.stripe.com/account/webhooks\" target=\"_blank\">https://dashboard.stripe.com/account/webhooks</a>','ru'),(5243,4583,'In the section <strong>\"Endpoints receiving events from your account\"</strong>, click <strong>\"+ Add endpoint\"</strong>.','en'),(5244,4583,'В разделе <strong>\"Endpoints receiving events from your account\"</strong> выберите <strong>\"+ Add endpoint\"</strong>.','ru'),(5245,4584,'In the form that opens, paste the <strong>\"Webhook URL\"</strong> value into the field <strong>\"URL to be called\"</strong> and click <strong>\"Add endpoint\"</strong>.','en'),(5246,4584,'В открывшейся форме вставьте значение <strong>\"Webhook URL\"</strong> в поле <strong>\"URL to be called\"</strong> и выберите <strong>\"Add endpoint\"</strong>','ru'),(5247,4585,'More information on the setup of webhooks is available here: <a href=\"https://stripe.com/docs/webhooks#configuring-your-webhook-settings\" target=\"_blank\">https://stripe.com/docs/webhooks#configuring-your-webhook-settings</a>','en'),(5248,4585,'Больше информации по настройке вебхуков доступно здесь: <a href=\"https://stripe.com/docs/webhooks#configuring-your-webhook-settings\" target=\"_blank\">https://stripe.com/docs/webhooks#configuring-your-webhook-settings</a>','ru'),(5249,4586,'Disconnect','en'),(5250,4586,'Разъеденить','ru'),(5251,4587,'Status: <span>Connected</span> ({{mode}})','en'),(5252,4587,'Статус: <span>Соединено</span> ({{mode}})','ru'),(5253,4588,'Click \"Connect with Stripe\" to be redirected to Stripe.com','en'),(5254,4588,'Нажмите \"Connect with Stripe\" чтобы перейти на Stripe.com','ru'),(5255,4589,'<strong>Complete the form</strong> with your Company info to setup your account and start processing payments immedately.','en'),(5256,4589,'<strong>Заполняйте форму</strong>, имея на руках данные о Вашей компании. После регистрации Вы сможете сразу начать принимать платежи.','ru'),(5257,4590,'Refresh token','en'),(5258,4590,'Обновить токен','ru'),(5259,4591,'Your Stripe account is no longer accessible. Please connect with Stripe once again.','en'),(5260,4591,'Ваш Stripe аккаунт более недоступен. Пожалуста, пройдите соединение со Stripe еще раз.','ru'),(5261,4592,'Webhook URL is your store\'s URL through which Stripe informs your store about any changes in the order. For example, if you refund a payment transaction for a certain amount via Stripe backend, Stripe will send information about this refund to the store using a special request to the Webhook URL, and the store will update the order status to refunded. If Webhook URL is not specified, the store will not know that the order was updated in Stripe backend and the order status in the store will not be updated automatically.','en'),(5262,4592,'Webhook URL это URL Вашего магазина, через который Stripe оповещает магазин о изменениях в заказе. Например, если вы черезе Stripe backend сделаете refund плоатежной транзакции на некую сумму, то Stripe сообщит об этом магазину при помощи специального запроса к Webhook URL и магазин изменит состояние заказа на refunded. Иначе, если Webhook URL не указан, магазин об этом не узнает и закза не изменит свое состояние автоматически.','ru'),(5263,4092,'URL скопирован','ru'),(5264,4593,'Show \"How to use\" instruction','en'),(5265,4593,'Показать инструкцию','ru'),(5266,4594,'Hide \"How to use\" instruction','en'),(5267,4594,'Спрятать инструкцию','ru'),(5268,4595,'Don\'t have an account?','en'),(5269,4596,'Publishable key','en'),(5270,4597,'Publishable key (test mode)','en'),(5271,4598,'Secret key (test mode)','en'),(5272,4599,'Use custom css','en'),(5273,4599,'Использовать свой CSS','ru'),(5274,1347,'Использовать свой JavaScript','ru'),(5275,4600,'The database stores different version of the custom changes.','en'),(5276,4600,'В базе данных хранится другая версия пользовательского кода.','ru'),(5277,4601,'Review it.','en'),(5278,4601,'Просмотреть её.','ru'),(5279,4602,'Restore this version','en'),(5280,4602,'Восстановить эту версию','ru'),(5281,4603,'Your custom file has been saved successfully','en'),(5282,4603,'Файл успешно сохранен','ru'),(5283,4604,'Theme tweaker','en'),(5284,4604,'Theme tweaker','ru'),(5285,4605,'Pick template from page element','en'),(5286,4605,'Выбор шаблона на основе элемента страницы','ru'),(5287,4606,'Edited templates','en'),(5288,4606,'Измененные шаблоны','ru'),(5289,4607,'Webmaster mode','en'),(5290,4607,'Режим веб-мастера','ru'),(5291,4608,'Template','en'),(5292,4608,'Шаблон','ru'),(5293,4609,'Back to templates list','en'),(5294,4609,'Вернуться к списку шаблонов','ru'),(5295,4610,'Webmaster Mode allows you to change the storefront design in click-and-edit mode.<br /><br />If the design of your store\'s customer area has been messed up by a template change, try restoring the original template in the Edited Templates section. More information about design changes in X-Cart is available in <a href=\"https://devs.x-cart.com/en/design_changes/basic_guide_to_theme_creation.html\">X-Cart\'s Knowledge Base</a>.','en'),(5296,4610,'Режим веб-мастера позволяет редактировать внешний вид сайта по месту.<br /><br />Если после внесения изменений клиентская зона выглядит неправильно, попробуйте откатить изменения в секции \"Измененные шаблоны\". Больше информации об изменении дизайна сайта на X-Cart - в <a href=\"https://devs.x-cart.com/en/design_changes/basic_guide_to_theme_creation.html\">Базе знаний X-Cart</a>.','ru'),(5297,4611,'Webmaster mode is enabled','en'),(5298,4611,'Режим веб-мастера включен','ru'),(5299,4612,'Webmaster mode is disabled','en'),(5300,4612,'Режим веб-мастера отключен','ru'),(5301,4613,'The template has been updated','en'),(5302,4613,'Шаблон обновлён','ru'),(5303,4614,'The template has been added','en'),(5304,4614,'Шаблон добавлен','ru'),(5305,4615,'Enabled','en'),(5306,4615,'Вкл','ru'),(5307,4616,'Disabled','en'),(5308,4616,'Выкл','ru'),(5309,4617,'Path for use in custom CSS','en'),(5310,4617,'Путь для использования в пользовательском CSS','ru'),(5311,4618,'URL','en'),(5312,4619,'The file {{file}} does not exist or is not writable.','en'),(5313,4620,'The directory {{dir}} does not exist or is not writable.','en'),(5314,4621,'Upload image','en'),(5315,4621,'Загрузить картинку','ru'),(5316,4622,'<b>Drag & drop blocks</b> to rearrange them.','en'),(5317,4622,'Здесь можно <b>перетаскивать блоки</b>, меняя их порядок.','ru'),(5318,4623,'Click on the description to <b>edit</b>.','en'),(5319,4623,'Режим предпросмотра продукта. Здесь можно <b>редактировать описание</b> продукта.','ru'),(5320,4624,'Exit product preview','en'),(5321,4624,'Вернуться','ru'),(5322,4625,'You have unsaved changes. Are you really sure to exit the preview?','en'),(5323,4625,'У вас есть несохраненные изменения. Вы точно хотите выйти из режима предпросмотра?','ru'),(5324,4626,'<i class=\"fa fa-exclamation-triangle inline-editor-message_icon\"></i>Click on the description to <b>edit</b>. Your changes may be <span style=\"font-weight: bold; color: orange;\">incompatible</span> with TinyMCE.','en'),(5325,4626,'<i class=\"fa fa-exclamation-triangle inline-editor-message_icon\"></i>Здесь можно <b>редактировать описание</b> продукта. Изменения могут быть <span style=\"font-weight: bold; color: orange;\">несовместимы</span> с редактором TinyMCE.','ru'),(5326,4627,'Changes may be incompatible with TinyMCE. Are you sure to proceed?','en'),(5327,4627,'Изменения могут быть несовместимы с редактором TinyMCE. Вы точно хотите их сохранить?','ru'),(5328,4628,'Layout editor','en'),(5329,4628,'Режим разметки','ru'),(5330,4629,'Dynamic message editor','en'),(5331,4629,'Редактор динамического сообщения уведомления','ru'),(5332,4630,'Labels editor','en'),(5333,4630,'Редактор меток','ru'),(5334,4631,'Discard changes','en'),(5335,4631,'Отказаться','ru'),(5336,4632,'Layout editor is','en'),(5337,4632,'Режим разметки','ru'),(5338,4633,'disabled blocks','en'),(5339,4633,'блоков отключено','ru'),(5340,4634,'Some','en'),(5341,4634,'Несколько','ru'),(5342,4635,'Block is enabled','en'),(5343,4635,'Блок включен','ru'),(5344,4636,'Block is disabled','en'),(5345,4636,'Блок отключен','ru'),(5346,4637,'Exit editor','en'),(5347,4637,'Выйти','ru'),(5348,4638,'Layout editor is enabled','en'),(5349,4638,'Режим разметки включен','ru'),(5350,4639,'Layout editor is disabled','en'),(5351,4639,'Режим разметки отключен','ru'),(5352,4640,'Layout editor allows you to change the position of the blocks in drag-n-drop fashion','en'),(5353,4640,'Режим редактирования разметки позволяет менять положение и порядок блоков путем перетаскивания','ru'),(5354,4641,'There are some custom CSS styles in your store. These styles may affect the look of the installed template. <a href=\"{{url}}\">Review the custom styles</a> and disable them if necessary.','en'),(5355,4641,'Для сайта заданы пользовательские CSS стили. Эти стили могут оказывать влияние на внешний вид интерфейса покупателя. <a href=\"{{url}}\">Просмотрите пользовательские стили</a> и выключите их в случае необходимости.','ru'),(5356,4642,'There are some custom templates in your store that may contain skin dependent code. This may cause your store to crash after switching to a different skin. <a href=\"{{templates_url}}\">Review the custom templates</a> and disable them if necessary.','en'),(5357,4642,'Магазин использует модифицированные шаблоны, которые, возможно, содержат код, работа которого зависит от используемого скина. Это может привести к нарушению корректной работы магазина после переключения на другой скин. <a href=\"{{templates_url}}\">Проверьте модифицированные шаблоны</a> и отключите их в случае необходимости. ','ru'),(5358,4643,'Entity was successfully saved','en'),(5359,4644,'Error on saving image','en'),(5360,4645,'Unable to save edited content. Errors: ','en'),(5361,4646,'Unknown temporary file','en'),(5362,4647,'Show all','en'),(5363,4648,'Flexy to twig converter','en'),(5364,4648,'Flexy to twig конвертор','ru'),(5365,4649,'Flexy template','en'),(5366,4649,'Flexy-шаблон','ru'),(5367,4650,'Twig template path','en'),(5368,4650,'Путь к Twig-шаблону','ru'),(5369,4651,'Converted','en'),(5370,4651,'Сконвертирован','ru'),(5371,4652,'Search flexy templates','en'),(5372,4652,'Найти flexy-шаблоны','ru'),(5373,4653,'Convert','en'),(5374,4653,'Конвертировать','ru'),(5375,4654,'Remove flexy templates','en'),(5376,4654,'Удалить flexy-шаблоны','ru'),(5377,4655,'No flexy templates have been found.','en'),(5378,4655,'Flexy-шаблоны не найдены.','ru'),(5379,4656,'The flexy templates have been removed','en'),(5380,4656,'Flexy-шаблоны были удалены','ru'),(5381,4657,'Some flexy templates cannot be removed. Please correct the file permissions or remove the templates manually:<br />{{list}}','en'),(5382,4657,'Некоторые flexy-шаблоны не могут быть удалены. Скорректируйте права на файлы или удалите их самостоятельно:<br />{{list}}','ru'),(5383,4658,'Check directory permissions','en'),(5384,4658,'Проверьте права на директорию','ru'),(5385,4659,'This action will remove all the flexy templates. Are you sure you want to proceed?','en'),(5386,4659,'Это действие удалит все Flexy-шаблоны. Вы уверены, что хотите продолжить?','ru'),(5387,4660,'Cannot get flexy content','en'),(5388,4660,'Не удалось получить содержимое Flexy-шаблона','ru'),(5389,4661,'Flexy template conversion failure. Check for syntax errors','en'),(5390,4661,'Не удалось сконвертировать Flexy-шаблон. Проверьте его содержание на предмет синтаксических ошибок','ru'),(5391,4662,'Back to Webmaster mode','en'),(5392,4662,'Вернуться на страницу \"Режим веб-мастера\"','ru'),(5393,4663,'Converted files may not always work correctly because not all the changes can be handled automatically by conversion. Be sure to check your converted files manually to ensure that all the required changes have been implemented properly. More info about Flexy and Twig key differences is available at <a href=\"https://xcart.github.io/flexy-to-twig/\" target=\"_blank\">https://xcart.github.io/flexy-to-twig</a>','en'),(5394,4663,'Сконвертированные файлы не всегда могут работать корректно поскольку не все изменения могут быть правильно выполнены при автоматической конвертации. Проверьте ваши сконвертированные файлы вручную, чтобы убедиться, что все изменения перенесены верно. Больше информации о Flexy-to-Twig конверторе доступно здесь: <a href=\"https://xcart.github.io/flexy-to-twig/\" target=\"_blank\">https://xcart.github.io/flexy-to-twig</a>','ru'),(5395,4664,'Preview full email','en'),(5396,4664,'Предпросмотр email','ru'),(5397,4665,'No orders available. Please create at least one order.','en'),(5398,4665,'Нет ни одного заказа. Пожалуйста, создайте по крайней мере один заказ.','ru'),(5399,4666,'Back to notification settings','en'),(5400,4666,'Назад к настройкам уведомлений','ru'),(5401,4667,'Edit template based on','en'),(5402,4667,'Редактировать шаблон на основе','ru'),(5403,4668,'The test email notification has been sent to {{email}}','en'),(5404,4668,'Тестовое уведомление было послано на адрес {{email}}','ru'),(5405,4669,'Failure sending test email to {{email}}','en'),(5406,4669,'Ошибка отправки тестового уведомления на адрес {{email}}','ru'),(5407,4670,'Enter Order number','en'),(5408,4670,'Введите номер заказа','ru'),(5409,4671,'Text parts in curly braces {} are variables and filled dynamically. Do not remove them.','en'),(5410,4671,'Текст в фигурных скобках означает переменную. Не удаляйте такой текст.','ru'),(5411,4672,'<p>You haven\'t changed any templates yet. Here you can track the templates changed with Template editor and revert any changes you\'ve done. Changes to the templates can be done by opening the storefront and switching to the «Template editor» of the panel below.</p>','en'),(5412,4672,'<p>Нет отредактированных шаблонов. На данной странице вы можете узнать об отредактированных шаблонах в режиме Редактор шаблонов. Также здесь вы сможете вернуть шаблоны к первоначальному состоянию. Чтобы изменить какой-либо шаблон, перейдите в клиентскую зону и выберите «Редактор шаблонов» в панели управления сайтом внизу.</p>','ru'),(5413,4673,'Pick templates from page','en'),(5414,4673,'Выбирать шаблоны на странице','ru'),(5415,4674,'Drag-n-drop blocks','en'),(5416,4674,'Перетаскивание блоков','ru'),(5417,4675,'Highlight labels','en'),(5418,4675,'Выделение меток','ru'),(5419,4676,'Layout block','en'),(5420,4676,'Блок разметки','ru'),(5421,4677,'Description editor','en'),(5422,4677,'Контент','ru'),(5423,4678,'Proceed to the product page to edit the description','en'),(5424,4678,'Нет редактируемого контента. Данный режим работает на странице любого продукта','ru'),(5425,4679,'Open home or category page for more opportunities to adjust the website structure.','en'),(5426,4679,'На главной и странице категории есть много различных блоков разметки.','ru'),(5427,4680,'Shortcut: Ctrl+/, ⌘+/','en'),(5428,4680,'Горячая клавиша: Ctrl+/, ⌘+/','ru'),(5429,4681,'Shortcut: Ctrl+S, ⌘+S','en'),(5430,4681,'Горячая клавиша: Ctrl+S, ⌘+S','ru'),(5431,4682,'You have unsaved changes. Are you really sure to exit?','en'),(5432,4682,'Обнаружены несохраненные изменения. Вы точно хотите отказаться от них и уйти?','ru'),(5433,4683,'<a href=\"{{url}}\" target=\"_blank\">Open the storefront</a> while logged in as administrator and use the Webmaster panel <span class=\"cog-icon\">{{cog}}</span> to change the look & feel of the store.','en'),(5434,4683,'<a href=\"{{url}}\" target=\"_blank\">Откройте клиентскую часть магазина</a> из-под администраторского аккаунта и используйте Панель вебмастера <span class=\"cog-icon\">{{cog}}</span> для изменения внешнего вида магазина.','ru'),(5435,4684,'Use the Google Tag Manager addon for more flexibility when adding JS code to your web pages.','en'),(5436,4684,'Используйте модуль Google Tag Manager для получения большей гибкости при добавлении JS кода на веб-страницы.','ru'),(5437,4685,'Learn more about Google Tag Manager','en'),(5438,4685,'Узнать больше о Диспетчере тегов Google','ru'),(5439,4686,'Tag Manager Dashboard','en'),(5440,4686,'Панель управления Диспетчера тегов','ru'),(5441,4687,'Configure Tag Manager','en'),(5442,4687,'Настроить Диспетчер тегов','ru'),(5443,4688,'Install Google Tag Manager','en'),(5444,4688,'Установить Google Tag Manager','ru'),(5445,4689,'Layout was successfully reset','en'),(5446,4689,'Настройки разметки были восстановлены','ru'),(5447,4690,'Unable to reset layout','en'),(5448,4690,'Ошибка при восстановлении настроек разметки','ru'),(5449,4691,'Changes were successfully saved','en'),(5450,4691,'Изменения были успешно применены','ru'),(5451,4692,'Unable to save changes','en'),(5452,4692,'Ошибка при сохранении изменений','ru'),(5453,4693,'Customize storefront','en'),(5454,4693,'Настроить магазин','ru'),(5455,4694,'Storefront layout','en'),(5456,4694,'Тип разметки','ru'),(5457,4695,'Reset layout','en'),(5458,4695,'Сбросить изменения','ru'),(5459,4696,'Home page','en'),(5460,4696,'Главная','ru'),(5461,4697,'Other pages','en'),(5462,4697,'Прочие','ru'),(5463,3753,'Логотипы','ru'),(5464,4698,'logo','en'),(5465,4698,'логотип','ru'),(5466,4699,'favicon','en'),(5467,4699,'фавиконка','ru'),(5468,4700,'app icon','en'),(5469,4700,'закладка','ru'),(5470,4701,'Delete custom file','en'),(5471,4701,'Выключить шаблон','ru'),(5472,4702,'new template','en'),(5473,4702,'добавить шаблон','ru'),(5474,4703,'type filename and press Enter','en'),(5475,4703,'введите имя файла и нажмите Enter','ru'),(5476,4704,'weight','en'),(5477,4704,'вес','ru'),(5478,4705,'Several edited templates were selected to be restored to a default version. You can still find and enable them on the <b>Edited templates</b> page in the Admin area.','en'),(5479,4705,'Отключенные шаблоны можно включить обратно на странице <b>Отредактированные шаблоны</b> в панели администратора.','ru'),(5480,4706,'Restore the default file','en'),(5481,4706,'Вернуть стандартный шаблон','ru'),(5482,4707,'Enable','en'),(5483,4707,'Показать','ru'),(5484,4708,'Are you sure you want to reset the current layout? Custom layout settings will be lost.','en'),(5485,4708,'Вы точно хотите сбросить настройки текущего вида разметки к первоначальному варианту? Измененные настройки положения и отображения блоков будут утеряны.','ru'),(5486,4709,'<p>You can customize the look & feel of the store by configuring the layout and adding the custom CSS or HTML code.</p><p>Just click on the button below or open the storefront while logged in as administrator, and look for the panel at the bottom.</p>','en'),(5487,4709,'<p>Вы можете самостоятельно настроить вид вашего магазина и отдельных элементов, добавить CSS код и изменить код шаблонов.</p><p>Нажмите на кнопку \"Настроить магазин\" или откройте витрину в режиме администратора, чтобы активировать панель веб-мастера.</p>','ru'),(5488,4710,'Display all templates','en'),(5489,4710,'Показать все шаблоны','ru'),(5490,4711,'Скрыть конвертированные шаблоны','en'),(5491,4712,'Not enough permissions to update the template file in \"<X-Cart root>/skins/theme_tweaker\" directory.','en'),(5492,4712,'Произошла ошибка при сохранении файла. Проверьте права на запись в папку \"<X-Cart root>/skins/theme_tweaker\".','ru'),(5493,4713,'File path is too long, it should be less than 255 characters','en'),(5494,4713,'Слишком длинный путь сохраняемого файла, сократите до 255 символов.','ru'),(5495,4714,'Category description','en'),(5496,4714,'Описание категории','ru'),(5497,4715,'OK','en'),(5498,4716,'Edit notification body','en'),(5499,4716,'Редактировать тело нотификации','ru'),(5500,4717,'There is no special code for this notification.\nIf you need to use specific TWIG code put it here.\nFor the plain text, we recommend using WYSIWYG editor on the edit notification page.\n','en'),(5501,4717,'Для этой нотификации нет специального кода.\nЕсли нужно использовать специфичный TWIG-код, поместите его сюда.\nЕсли нужен только текст, рекомендуем использовать WYSIWYG редактор на странице\nредактирования нотификации.','ru'),(5502,4718,'The dynamic message is empty for this notification. If you need to use specific TWIG code, use the template tree on the left-hand side of the screen to choose the TWIG file you require. For plain text we recommend using the WYSIWYG editor on the Edit notification page.','en'),(5503,4718,'Динамическое сообщение для этого уведомления не задано. Если необходимо использовать специальный TWIG-код, используйте дерево шаблонов слева, чтобы выбрать TWIG-файл для редактирования. Если нужен только текст, рекомендуем использовать WYSIWYG редактор на странице редактирования уведомления.','ru'),(5504,4719,'Add TWIG code','en'),(5505,4719,'Добавить TWIG-код','ru'),(5506,4720,'Disable block','en'),(5507,4720,'Отключить блок','ru'),(5508,4721,'<b>UPS</b> module allows you to use online shipping rates calculation via <a href=\"http://www.ups.com\" target=\"_new\">UPS service</a>.<br/>To use UPS Rating API you need to register on <a href=\"http://www.ups.com/\" target=\"_new\">UPS.com</a> with a User ID and Password. Once you have registered you would need to obtain an Access Key from UPS.com that provides access to the Rating API. To obtain an Access Key an account number needs to be added or created in your UPS.com profile.','en'),(5509,4722,'UPS module supports \'Cash on delivery\' feature for shipments within European Union, within United States and Puerto Rico, within Canada and from Canada to the United States.<br/>To enable \'Cash on delivery\' payment option you should enable payment method \'Cash on delivery (UPS)\' at the <a href=\"{{URL}}\">Payment methods page</a>.','en'),(5510,4723,'Air service center','en'),(5511,4724,'Customer counter','en'),(5512,4725,'Daily Pickup','en'),(5513,4726,'Delivery confirmation - adult signature required','en'),(5514,4727,'Delivery confirmation - no signature','en'),(5515,4728,'Delivery confirmation - signature required','en'),(5516,4729,'Letter center','en'),(5517,4730,'No confirmation','en'),(5518,4731,'On call air','en'),(5519,4732,'One time pickup','en'),(5520,4733,'Suggested retail rates','en'),(5521,4734,'As a UPS user, you are entitled to receive shipping refunds usually left unclaimed with default UPS service ($2B/year globally). <a href=\"https://71lbs.com/xcart\" target=\"_blank\">Get My UPS Refunds</a>','en'),(5522,4735,'Update quantity','en'),(5523,4735,'Обновление количества','ru'),(5524,4736,'Products updated','en'),(5525,4736,'Обновлено товаров','ru'),(5526,4737,'The script found {{number}} problem(s) during update inventory','en'),(5527,4737,'В процессе обновления были обнаружены ошибки ({{number}})','ru'),(5528,4738,'Product with SKU \"{{value}}\" not found','en'),(5529,4738,'Товар с артикулом \"{{value}}\" не найден','ru'),(5530,4739,'Wrong product quantity value format (\"{{value}}\")','en'),(5531,4739,'Некорректный формат в поле qty (\"{{value}}\")','ru'),(5532,4740,'Products and product variants updated','en'),(5533,4740,'Обновлено товаров и вариантов товаров','ru'),(5534,4741,'Product or product variant with SKU \"{{value}}\" not found','en'),(5535,4741,'Товар или вариант товара с артикулом \"{{value}}\" не найдены','ru'),(5536,4742,'Update quantity import guide','en'),(5537,4742,'Руководство по обновлению количества','ru'),(5538,4743,'https://kb.x-cart.com/modules/update_inventory.html','en'),(5539,4743,'https://kb.x-cart.ru/modules/update_inventory.html','ru'),(5540,4744,'Related products','en'),(5541,4745,'Alternatives products you may be interested in','en'),(5542,4746,'This product is no longer available although you may find similar or newer version below.','en'),(5543,4747,'Bidirectional link','en'),(5544,4747,'Двунаправленная связь','ru'),(5545,4748,'Related products page','en'),(5546,4749,'You cannot choose this product','en'),(5547,4750,'The product SKU#{{SKU}} is already set as related for the product','en'),(5548,4751,'Add related products','en'),(5549,4752,'Related products (Related Products module)','en'),(5550,4753,'The product SKU#\"X\" is already set as Related for the product','en'),(5551,4754,'Enable bidirectional links','en'),(5552,4754,'Включить двунаправленная связь','ru'),(5553,4755,'Disable bidirectional links','en'),(5554,4755,'Отключить двунаправленная связь','ru'),(5555,4756,'Do you really want to delete all relations from this product?','en'),(5556,4756,'Вы действительно хотите удалить все связи из этого товара?','ru'),(5557,4757,'\"Bidirectional link\" means that the related product is not only linked to from the product on view, but also provides a link to that product. With the \"Bidirectional link\" option enabled, removing the link from one of the products will not remove the link in the opposite direction. To remove the relationship between the products completely, disable the \"Bidirectional link\" option first, then remove the link.','en'),(5558,4757,'\"Двунаправленная связь\" значит, что не только просматриваемый товар ссылается на связанный, но и связанный ссылается на него. При включенной настройке \"Двунаправленная связь\", удаление ссылки с одного из товаров не приведет к удалению ссылки в противоположном направлении. Для полного удаления связи между товарами, вначале отключите настройку \"Двунаправленная связь\", затем удалите ссылку на связанный товар.','ru'),(5559,4758,'Edit all','en'),(5560,4758,'Редактировать все','ru'),(5561,4759,'Make bidirectional relations','en'),(5562,4759,'Добавлять двунаправленную связь','ru'),(5563,4760,'Read','en'),(5564,4760,'Прочитано','ru'),(5565,4761,'Unread','en'),(5566,4761,'Не прочитано','ru'),(5567,4762,'Messages','en'),(5568,4762,'Сообщения','ru'),(5569,884,'Сообщение','ru'),(5570,4763,'Message not found','en'),(5571,4763,'Сообщение не найдено','ru'),(5572,2135,'Все заказы','ru'),(5573,4764,'Orders with unread messages','en'),(5574,4764,'Все заказы с непрочитанными сообщениями','ru'),(5575,4765,'Orders with any messages','en'),(5576,4765,'Все заказы с сообщениями','ru'),(5577,4766,'The field Body may not be blank','en'),(5578,4766,'Поле \'Сообщение\' не может быть пустым','ru'),(5579,4767,'Contact seller','en'),(5580,4767,'Связаться с продавцом','ru'),(5581,4768,'{{count}} unread messages','en'),(5582,4768,'{{count}} непрочитанных сообщений','ru'),(5583,4769,'Hidden messages ({{count}})','en'),(5584,4769,'Скрытые сообщения ({{count}})','ru'),(5585,4770,'Hide message history','en'),(5586,4770,'Скрыть историю общения','ru'),(5587,4771,'New message for order','en'),(5588,4771,'Новое сообщение по заказу','ru'),(5589,4772,'{{count}} new messages for order','en'),(5590,4772,'{{count}} новых сообщений  по заказу','ru'),(5591,4773,'You Have No Messages','en'),(5592,4773,'Нет сообщений','ru'),(5593,4774,'Dispute opened by {{name}}','en'),(5594,4774,'Диспут открыт {{name}}','ru'),(5595,4775,'Dispute closed by {{name}}','en'),(5596,4775,'Диспут закрыт {{name}}','ru'),(5597,4776,'Open dispute','en'),(5598,4776,'Открыть диспут','ru'),(5599,4777,'Close dispute','en'),(5600,4777,'Закрыть диспут','ru'),(5601,4778,'A dispute has been opened successfully.','en'),(5602,4778,'Диспут открыт','ru'),(5603,4779,'The dispute has been closed.','en'),(5604,4779,'Диспут закрыт','ru'),(5605,4780,'Monitoring of communication related to oder #{{order_number}} has been enabled.','en'),(5606,4780,'Подписка на получение сообщений по заказу №{{order_number}} включена','ru'),(5607,4781,'Monitoring of communication related to oder #{{order_number}} has been disabled.','en'),(5608,4781,'Подписка на получение сообщений по заказу №{{order_number}} выключена','ru'),(5609,4782,'All communication threads','en'),(5610,4782,'Все цепочки сообщений','ru'),(5611,4783,'Communication threads with unread messages','en'),(5612,4783,'Цепочки с непрочитанными сообщениями','ru'),(5613,4784,'Communication threads with open disputes','en'),(5614,4784,'Цепочки с открытыми диспутами','ru'),(5615,4785,'Dispute opened on {{date}}, by {{name}}','en'),(5616,4785,'Диспут открыт {{date}}, {{name}}','ru'),(5617,4786,'Write your message here','en'),(5618,4786,'Текст вашего сообщения','ru'),(5619,4787,'Open a dispute','en'),(5620,4787,'Открыть диспут','ru'),(5621,4788,'Dispute','en'),(5622,4788,'Диспут','ru'),(5623,4789,'Reason','en'),(5624,4789,'Причина','ru'),(5625,4790,'New messages','en'),(5626,4790,'Новые сообщения','ru'),(5627,4791,'Show vendor’s products in the order','en'),(5628,4791,'Показать товары продавца','ru'),(5629,4792,'Hide vendor’s products in the order','en'),(5630,4792,'Скрыть товары продавца','ru'),(5631,4793,'Disputes','en'),(5632,4794,'Conversation','en'),(5633,4794,'Разговор','ru'),(5634,4795,'Conversations','en'),(5635,4795,'Разговоры','ru'),(5636,4796,'Conversation: {{members}}','en'),(5637,4796,'Разговор: {{members}}','ru'),(5638,4797,'{{count}} new messages','en'),(5639,4797,'{{count}} новых сообщений','ru'),(5640,4798,'New message','en'),(5641,4798,'Новое сообщение','ru'),(5642,4799,'Mark all','en'),(5643,4799,'Пометить все','ru'),(5644,4800,'Mark selected','en'),(5645,4800,'Пометить выбранные','ru');
CREATE TABLE `xlite_payment_transactions` (
  `transaction_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  `method_id` int(11) DEFAULT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `date` int(11) NOT NULL,
  `publicTxnId` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `method_name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `method_local_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `status` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `value` decimal(14,4) NOT NULL,
  `note` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `public_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `IDX_33CBDC008D9F6D38` (`order_id`),
  KEY `IDX_33CBDC0019883967` (`method_id`),
  KEY `IDX_33CBDC0038248176` (`currency_id`),
  KEY `status` (`status`),
  KEY `o` (`order_id`,`status`),
  KEY `pm` (`method_id`,`status`),
  KEY `publicTxnId` (`publicTxnId`),
  CONSTRAINT `FK_33CBDC0019883967` FOREIGN KEY (`method_id`) REFERENCES `xlite_payment_methods` (`method_id`) ON DELETE SET NULL,
  CONSTRAINT `FK_33CBDC0038248176` FOREIGN KEY (`currency_id`) REFERENCES `xlite_currencies` (`currency_id`),
  CONSTRAINT `FK_33CBDC008D9F6D38` FOREIGN KEY (`order_id`) REFERENCES `xlite_orders` (`order_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_payment_transactions` VALUES (1,1,4,840,1394005540,'000001-KGSP','MoneyOrdering','Money Order','S',110.6500,'','sale','000001-KGSP'),(2,2,4,840,1396005895,'000002-FX7B','MoneyOrdering','Money Order','S',88.6700,'','sale','000002-FX7B'),(3,3,4,840,1407005895,'000002-FX7B','MoneyOrdering','Money Order','S',158.9400,'','sale','000002-FX7B'),(4,4,NULL,840,1452604411,'000012-AS2T','SimplifyCommerceHP','Simplify Commerce Hosted Payments','F',38.0100,'Simplify_BadRequestException: \"Request data is invalid\" (status: 400, error code: validation, reference: c5a0b8b8-92ac-4908-9506-88b843ecd399)\nField error: card.number\"Card bin Country rejected by acquirer\" (country.bin.not.accepted)','sale','demostore-000012-AS2T'),(5,4,NULL,840,1452604437,'000013-3I22','SimplifyCommerceHP','Simplify Commerce Hosted Payments','F',38.0100,'Simplify_BadRequestException: \"Request data is invalid\" (status: 400, error code: validation, reference: 195c1b1a-44c8-46d4-8e48-ee4e65f271af)\nField error: card.number\"Card has expired.\" (card.expired)','sale','demostore-000013-3I22'),(6,5,4,840,1452604702,'000005-KXAQ','MoneyOrdering','Money Order','S',352.8100,'','sale','000005-KXAQ');
CREATE TABLE `xlite_product_class_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_8471715FBF396750` FOREIGN KEY (`id`) REFERENCES `xlite_product_classes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_product_class_translations` VALUES (1,1,'Fashion','en'),(4,1,'Одежда','ru'),(5,2,'Mobile phone','en'),(6,2,'Мобильный телефон','ru'),(7,3,'Shoes','en'),(8,3,'Обувь','ru');
CREATE TABLE `xlite_tmp_vars` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_tmp_vars` VALUES (1,'cache_build_timestamp','i:1576568851;'),(2,'cloud_search_reg_scheduled','1');
CREATE TABLE `xlite_regions` (
  `code` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `country_code` char(2) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `weight` int(11) DEFAULT NULL,
  PRIMARY KEY (`code`),
  UNIQUE KEY `code` (`code`,`country_code`),
  KEY `IDX_B319C6B1F026BB7C` (`country_code`),
  KEY `name` (`name`),
  CONSTRAINT `FK_B319C6B1F026BB7C` FOREIGN KEY (`country_code`) REFERENCES `xlite_countries` (`code`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_regions` VALUES ('GB-ENG','GB','England',100),('GB-NIR','GB','Northern Ireland',400),('GB-SCT','GB','Scotland',200),('GB-WLS','GB','Wales',300);
CREATE TABLE `xlite_order_capost_parcel_shipments_manifests` (
  `manifest_id` int(11) NOT NULL,
  `shipment_id` int(11) NOT NULL,
  PRIMARY KEY (`manifest_id`,`shipment_id`),
  KEY `IDX_8D3D4D8FE697B2FB` (`manifest_id`),
  KEY `IDX_8D3D4D8F7BE036FC` (`shipment_id`),
  CONSTRAINT `FK_8D3D4D8F7BE036FC` FOREIGN KEY (`shipment_id`) REFERENCES `xlite_order_capost_parcel_shipment` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_8D3D4D8FE697B2FB` FOREIGN KEY (`manifest_id`) REFERENCES `xlite_order_capost_parcel_manifests` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_config_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(11) DEFAULT NULL,
  `option_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `option_comment` longtext COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_56A33BC3BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_config` (`config_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_config_translations` VALUES (1,1,'Use HTTPS in the Administrator Zone','','en'),(2,2,'Default customer address','','en'),(3,3,'Address line','','en'),(4,4,'Country','','en'),(5,5,'State','','en'),(6,6,'State','','en'),(7,7,'City','','en'),(8,8,'Zip/postal code','','en'),(9,9,'Address type','','en'),(10,10,'Aggregate CSS files (enable for better performance)','','en'),(11,11,'Aggregate JS files (enable for better performance)','','en'),(12,12,'Use widget cache (enable for better performance)','','en'),(13,16,'Default layout','','en'),(14,17,'Home page layout','','en'),(15,18,'CLI mode key','','en'),(16,19,'Company address','','en'),(17,20,'Contacts','','en'),(18,21,'Fax','','en'),(19,22,'Identity','','en'),(20,23,'Company name','Changing the value of this or any other fields on this page will not affect the signature in your store\'s email notifications. The signature for notifications can be edited on the <a href=\"admin.php?target=notification_common\">Header, greeting & signature</a> page.','en'),(21,24,'Company website','','en'),(22,25,'Terms and conditions relative URL','','en'),(23,26,'Customer Zone settings','','en'),(24,27,'Use HTTPS in the Customer Zone (for login, Checkout and profile pages)','','en'),(25,28,'Date format','','en'),(26,29,'First day of week','','en'),(27,30,'CSV column delimiter','','en'),(28,31,'Import/export charset','','en'),(29,32,'Export product data with','','en'),(30,35,'Payment method to be assumed in case of zero order totals','','en'),(31,36,'Maximum order quantity (per product)','','en'),(32,37,'Default payment method','','en'),(33,38,'Display check number for eCheck payment method','','en'),(34,39,'How to show out of stock products','','en'),(35,40,'Default display mode for products list','','en'),(36,42,'Street address','','en'),(37,43,'Country','','en'),(38,44,'State','','en'),(39,45,'State','','en'),(40,46,'City','','en'),(41,47,'Zip/postal code','','en'),(42,48,'Use your company address as your ship-from address','See <a href=\"admin.php?target=settings&page=Company#company-address\">company address</a>','en'),(43,49,'Street address','','en'),(44,50,'Country','','en'),(45,51,'State','','en'),(46,52,'State','','en'),(47,53,'City','','en'),(48,54,'Zip/postal code','','en'),(49,55,'Phone','','en'),(50,56,'Number of days to store the last login data','','en'),(51,57,'Maximum allowed order subtotal','','en'),(52,58,'Minimum allowed order subtotal','','en'),(53,59,'Next order #','You can change the number that will be assigned on the next order. The new order number should be greater than the current one.','en'),(54,60,'Cart TTL (days)','Specify the number of days after which a stored shopping cart should be considered old and should be removed. Leave empty if old carts should never be removed (not recommended)','en'),(55,61,'Enable internal cron service','This setting allows you to enable/disable the use of your store\'s internal cron service. This service schedules the run of certain maintenance tasks for your store - like removing customers\' expired shopping carts - at the periodicity of once per 100 user sessions.','en'),(56,62,'Sales department e-mails','The first email in this field (the one marked dark blue) will be used as the \"Reply-To:\" address for low limit warning messages.<br/><br/>All addresses in this field will be used as the \"TO:\" address for notifications about orders (creation of new orders, changes of order status, etc).','en'),(57,63,'Products per category listing page','','en'),(58,64,'Maximum products per category listing page','','en'),(59,65,'Force customer to choose product options before the product can be added to cart','','en'),(60,66,'Redirect customer to the cart page after a product is added to cart','','en'),(61,67,'Close the shop temporarily (not available in Demo store)','','en'),(62,68,'Shop currency','','en'),(63,69,'Hide trailing zeros in fractional part','','en'),(64,70,'Site administrator e-mails','The first email in this field (the one marked dark blue) will be used as the \"Reply-To:\" address for most notifications about user profiles.<br/><br/>All addresses in this field will be used as the \"TO:\" address for information on access to your store in safe mode (Hard and Soft reset links), notifications about failed administrator login attempts, low limit warnings, etc.','en'),(65,71,'Password','','en'),(66,72,'Secure connection','','en'),(67,73,'SMTP port','By default, SMTP uses TCP port 25. However, if you are going to use secure SSL/TLS encrypted SMTP, you need to specify the correct TCP port number for your system here. Typically, port number for secure SMTP is 465.','en'),(68,74,'SMTP server','','en'),(69,75,'Username','','en'),(70,76,'Year when store started its operation','','en'),(71,77,'Subcategory listings format','','en'),(72,78,'Default order to sort products within a category','','en'),(73,79,'Default order to sort products within a search result','','en'),(74,80,'HelpDesk/Support service e-mails','Addresses for messages sent by store visitors via the Contact us form.','en'),(75,81,'Time format','','en'),(76,82,'Time zone','','en'),(77,83,'Customer relations e-mails','The first email in this field (the one marked dark blue) will be used as the \"Reply-To:\" address for password reset messages.<br/><br/>All addresses in this field will be used as the \"TO:\" address for notifications about user profile related events (creation of a new user profile, deletion of a user profile, etc).','en'),(78,84,'Users per page','','en'),(79,85,'Email to use for the FROM field','Please do not confuse this with Reply-to. Reply-to addresses for your emails will be selected from the Contact information section automatically according to the type of email message.','en'),(80,87,'Use SMTP server','','en'),(81,88,'Use authentication','','en'),(82,90,'Weight symbol','','en'),(83,91,'Weight unit','','en'),(84,92,'Hide trailing zeros in fractional part','','en'),(85,93,'Weight format','','en'),(86,94,'Percent format','','en'),(87,95,'Dimensional symbol','','en'),(88,96,'Dimensional unit','','en'),(89,97,'Curl options','','en'),(90,98,'Path to Certificate Authority (CA) bundle','','en'),(91,99,'Directory holding CA certificates','','en'),(92,100,'Ask anonymous users to create an account or sign in before checkout','','en'),(93,101,'Display \"Add to cart\" buttons for products in grid view','','en'),(94,104,'General options','','en'),(95,105,'Default site title','','en'),(96,106,'Default site meta description','','en'),(97,107,'Default site meta keywords','','en'),(98,108,'Home page title and meta','','en'),(99,109,'404 page','','en'),(100,110,'Regular text for 404 page','','en'),(101,111,'Show сustomer relations e-mails on 404 page','','en'),(102,112,'Page title format','','en'),(103,113,'Company name','','en'),(104,114,'Parent category path','','en'),(105,115,'Object name (category, product, etc)','','en'),(106,116,'Show object name in page title','','en'),(107,117,'About clean urls','','en'),(108,119,'Allow customers to sign up for membership','','en'),(109,120,'Upgrade options','','en'),(110,121,'Upgrade access level','','en'),(111,122,'FROM/REPLY-TO settings','','en'),(112,122,'Настройки FROM/REPLY-TO','','ru'),(113,123,'Email to use for the REPLY-to field in customer emails','','en'),(114,124,'Email to use for the REPLY-to field in admin emails','','en'),(115,125,'SMTP','','en'),(116,126,'Enabled','','en'),(117,127,'Banner interval (in seconds)','Set to \"0\" to disable automatic rotation','en'),(118,128,'Send the PDF version of invoices in the attachments','','en'),(119,132,'Test mode','','en'),(120,133,'API key','A unique 32 character API key is used to authorise inbound requests to the APIs. To obtain an API key please visit <a href=\"http://auspost.com.au/devcentre\">http://auspost.com.au/devcentre</a> and follow the link to create your Australia Post ID. After registration has been successfully completed you will be emailed an API key.','en'),(121,134,'Package settings','','en'),(122,136,'Package box type','','en'),(123,137,'Package dimensions (mm)','','en'),(124,138,'Additional settings','','en'),(125,139,'Service option','','en'),(126,140,'Extra cover type','','en'),(127,141,'Extra cover value','The specified value (if not empty) will be used as an extra cover value. Otherwise an order total will be used.','en'),(128,142,'Currency rate','Specify rate X, where 1 AUD = X in shop currency.','en'),(129,143,'Enable new methods','When AustraliaPost return shipping methods which does not exists in the available methods list, these methods will be created in the list automatically. You can specify should these methods be created as enabled and accessible customers just after they created, or these methods must be hidden from customer until you manually validate them.','en'),(130,144,'Enable debugging','This option enables logging of all communication between the shopping cart and AustraliaPost server.','en'),(131,146,'Number of products in the bestsellers list','','en'),(132,147,'Enable form','','en'),(133,148,'E-mail address of the message recipient','If the field is blank, then administration email is used','en'),(134,149,'Show email as text','','en'),(135,150,'reCAPTCHA','','en'),(136,151,'Version','','en'),(137,152,'Site key','To use reCAPTCHA you should get Site and Secret keys from <a href=\"https://www.google.com/recaptcha/admin/create\">https://www.google.com/recaptcha/admin/create</a>','en'),(138,153,'Secret key','','en'),(139,154,'Download link TTL (days)','Set zero for unlimited access. If you are using Amazon Signed URLs, TTL is limited to 7 days.','en'),(140,154,'Время действия ссылки на скачку (в днях)','При значении 0 - неограниченный доступ. Для ссылок Amazon S3, подписанных ключом, время ограничено 7 днями.','ru'),(141,155,'Downloads limit (per 1 ordered item)','Set zero for unlimited access. If you are using Amazon Signed URLs, this settings controls the limit of link renewal, because it is impossible to control downloads on the Signed URL.','en'),(142,155,'Лимит скачек (на 1 позицию заказа)','При значении 0 - безлимитный доступ. Для ссылок Amazon S3, подписанных ключом, эта настройка контролирует количество доступов к ссылке, так как невозможно ограничить количество скачек по такой ссылке.','ru'),(143,156,'Keep a history of downloads','Amazon S3 Signed URLs are counted per link access (not download), because X-Cart can not track downloads on the Amazon S3 Storage.','en'),(144,156,'Сохранять историю загрузок','Для ссылок Amazon S3, подписанных ключом, учитывается количество доступов, а не скачек, так как X-Cart не имеет доступа к истории скачек хранилища Amazon S3.','ru'),(145,157,'Show only ESD related fulfilment statuses','With this option enabled, only 3 statuses will be available: New, Delivered and Will Not Deliver. You can rename the statuses as you require using the \"Custom Order Statuses\" module','en'),(146,157,'Отображать только статусы для цифровой дистрибуции','При включении данной настройки будет доступны только 3 статуса доставки: Новый, Доставлен и Доставка отменена. Переименовать их можно при помощи модуля Custom Order Statuses','ru'),(147,158,'Approve before providing access to download','','en'),(148,158,'Одобрение перед предоставлением доступа на скачивание','','ru'),(149,160,'Amazon Signed URLs','','en'),(150,161,'Enable usage of Presigned URLs for Amazon S3 links','Use Amazon S3 to host your digital files on Amazon and control access to your e-goods by presigned URLs. Learn more at <a href=\"https://kb.x-cart.com/en/modules/egoods/\" target=\"_blank\">E-goods module</a> article at X-Cart Knowledge Base.','en'),(151,161,'Включить ссылки, подписанные ключом, для файлов на хранилище Amazon S3','С помощью хранилища Amazon S3 можно экономить серверное дисковое пространство и контролировать доступ к скачиваемым товарам. Подробнее о конфигурации можно узнать на странице <a href=\"https://kb.x-cart.ru/modules/egoods/\" target=\"_blank\">Цифровые товары</a> в базе знаний X-Cart.','ru'),(152,162,'Amazon Access Key','','en'),(153,163,'Amazon Secret Key','','en'),(154,164,'S3 Bucket name','','en'),(155,164,'S3 Bucket','','ru'),(156,166,'Featured products look and feel','','en'),(157,167,'FedEx authentication key','','en'),(158,168,'FedEx authentication password','','en'),(159,169,'FedEx account number','','en'),(160,170,'FedEx meter number','','en'),(161,171,'Test mode','','en'),(162,172,'Enable debugging','','en'),(163,173,'Additional settings','','en'),(164,174,'Carrier type(s)','','en'),(165,175,'FedEx Express (FDXE)','','en'),(166,176,'FedEx Ground (FDXG)','','en'),(167,177,'FedEx SmartPost (FXSP)','','en'),(168,178,'Hub ID','','en'),(169,179,'Indicia','','en'),(170,180,'Rate request type','','en'),(171,181,'Packaging','','en'),(172,182,'Dropoff type','','en'),(173,183,'Ship date (days)','','en'),(174,184,'Currency code','','en'),(175,185,'Currency rate','If the currency specified above differs from the currency the store uses for payments, specify a conversion rate to convert the shipping cost returned by FedEx into your store\'s currency. If the currencies are the same, leave this set to 1.','en'),(176,186,'Package dimensions (inches)','','en'),(177,187,'Maximum package weight','','en'),(178,188,'Special services','','en'),(179,189,'Dangerous Goods/Accessibility','','en'),(180,190,'Signature option','','en'),(181,191,'Shipping refunds settings','','en'),(182,193,'Cash on delivery','','en'),(183,194,'COD type','','en'),(184,195,'Advanced options','','en'),(185,196,'Shipment is scheduled for Saturday pickup (the option will be used if ship date is Saturday)','','en'),(186,197,'Shipment from residential address','','en'),(187,198,'Send package cost to calculate insurance','','en'),(188,167,'Ключ идентификации FedEx','','ru'),(189,168,'Пароль FedEx','','ru'),(190,169,'Номер счета FedEx','','ru'),(191,170,'FedEx meter number','','ru'),(192,171,'Режим тестирования','','ru'),(193,172,'Включить отладку','','ru'),(194,173,'Дополнительные настройки','','ru'),(195,174,'Тип(ы) перевозчика(ов)','','ru'),(196,175,'FedEx Express (FDXE)','','ru'),(197,176,'FedEx Ground (FDXG)','','ru'),(198,177,'FedEx SmartPost (FXSP)','','ru'),(199,181,'Упаковка','','ru'),(200,182,'Возврат тары','','ru'),(201,183,'Дата отгрузки (дни)','','ru'),(202,184,'Код валюты','','ru'),(203,185,'Коэффициент пересчета валюты','Если валюта выше отличается от валюты, используемой для оплаты в магазине, укажите коэффициент пересчёта для перевода стоимости доставки, предоставленной FedEx, в валюту магазина. Если валюты совпадают, оставьте значение 1.','ru'),(204,186,'Размеры упаковки (в дюймах)','','ru'),(205,187,'Максимальный вес упаковки','','ru'),(206,188,'Специальные услуги','','ru'),(207,189,'Опасные Товары/Доступность','','ru'),(208,190,'Показать все сохраненные кредитные карты','','ru'),(209,193,'Оплата при получении','','ru'),(210,194,'Тип наложного платежа','','ru'),(211,195,'Расширенные опции','','ru'),(212,196,'Погрузка назначена на Субботу (эта опция используется, если день отгрузки - Суббота)','','ru'),(213,197,'Доставка с адреса расположения','','ru'),(214,198,'Рассчитывать размер страховки по стоимости посылки','','ru'),(215,199,'Facebook application settings','','en'),(216,200,'Facebook Application ID','Facebook Platform application ID that administers your site pages. You can get this ID by visiting the page at <a href=\"https://developers.facebook.com/apps/\">https://developers.facebook.com/apps/</a><br /><br />You should specify this field:<ul><li>to make your site statistics appear in the Facebook Insights dashboard</li><li>to enable a moderator interface on Facebook where comments from all product pages can be easily moderated together</li></ul>','en'),(217,201,'Facebook Application Namespace','Specify the same app namespace that you entered when configured your Facebook Platform application.','en'),(218,202,'Facebook Admins','Comma-separated list of the Facebook User IDs of page administrators. Include at least your own Facebook User ID.','en'),(219,203,'Facebook Share Button settings','','en'),(220,204,'Display the Share button on product pages','The Share button lets a customer share your product pages with friends on Facebook.','en'),(221,205,'Facebook Like Button settings','','en'),(222,206,'We recommend using the Share button instead of Like.','','en'),(223,207,'Display the Like button on product pages','The Like button lets a customer share your product pages with friends on Facebook. The button will not be displayed if Facebook application id is not set.','en'),(224,208,'Layout style','There are three options:<ul><li>\"standard\" - displays social text to the right of the button and friends\' profile photos below</li><li>\"button\" - displays the total number of likes to the right of the button</li><li>\"box\" - displays the total number of likes above the button.</li></ul>','en'),(225,209,'Show profile pictures below the Like button','Profile pictures appear in the \"standard\" layout style only.','en'),(226,210,'The verb to display in the Like button','','en'),(227,211,'The color scheme for the like button','','en'),(228,212,'Facebook comments settings','','en'),(229,213,'Display the Facebook Comments tab on product pages','To moderate comments, specify your Facebook User ID in the \"Facebook Admins\" field below.<br />To enable the moderator interface on Facebook where comments from all product pages can be easily moderated together, specify your Facebook App ID in the \"Facebook Application ID\" field below.','en'),(230,214,'Number of posts to show on the tab by default','','en'),(231,215,'The color scheme for the comments','','en'),(232,216,'Tweet button settings','','en'),(233,217,'Display the Tweet button on product pages','The Tweet button allows customers to easily share your product pages with their Twitter followers.','en'),(234,218,'Show the count box along with the Tweet button','The count box shows how many times the product page has been Tweeted.','en'),(235,219,'Account name of the user to attribute the Tweet to (optional)','Also used as username of website in Twitter Card Tags','en'),(236,220,'Account name of the user to follow after sending a Tweet (optional)','Twitter will suggest that customers follow this user once they have sent a Tweet using the Tweet button.','en'),(237,221,'Hashtag to show within the Tweet button and in the text of the tweet status (optional)','','en'),(238,222,'Pinterest button settings','','en'),(239,223,'Display the Pinterest button on product pages','','en'),(240,219,'Имя учетной записи пользователя, автора Tweet (опционально)','Также используется как твиттер сайта в Twitter Card Tags','ru'),(241,224,'Web Property ID','','en'),(242,225,'What are you tracking','','en'),(243,226,'Google Analytics code version','','en'),(244,227,'Enable eCommerce Google Analytics','','en'),(245,228,'Register purchase only on Paid status change','','en'),(246,229,'Debug mode','','en'),(247,224,'Web Property ID','','ru'),(248,225,'Что отслеживается','','ru'),(249,226,'Версия кода Google Analytics','','ru'),(250,227,'Включить eCommerce Google Analytics','','ru'),(251,228,'Регистрировать покупку только после смены статуса на \"Оплачен\"','','ru'),(252,229,'Режим отладки','','ru'),(253,230,'Show only ESD related fulfilment statuses','This option leave only 3 method: New, Delivered and Will Not Deliver. You can rename it with \"Custom Order Statuses\" module','en'),(254,230,'Отображать только статусы для цифровой дистрибуции','Данная настройка оставит только 3 статуса доставки: Новый, Доставлен и Доставка отменена. Переименовать их можно при помощи модуля Custom Order Statuses','ru'),(255,231,'Approve before providing access','','en'),(256,231,'Одобрение перед предоставлением доступа','','ru'),(257,232,'Show \"Admin welcome\" block','','en'),(258,233,'PayPal Login','<p>To enable PayPal login, you need to create a PayPal application for your website. The recommended procedure is to go to the My Apps page and create an app for testing, then to go live with this app. For detailed instructions on creating the app, see PayPal documentation at <a href=\"https://developer.paypal.com/docs/integration/admin/manage-apps/\">https://developer.paypal.com/docs/integration/admin/manage-apps/</a>. Be sure to specify your \"App return URL\" as the value of \"Redirect URL\" field below.</p><p>Once the app has been created, be sure to copy your Client Id and Client Secret from the app details and credentials and have them stored in the fields below.</p>','en'),(259,234,'Redirect URL','','en'),(260,235,'Client Id','','en'),(261,236,'Client Secret','','en'),(262,237,'Test/Live mode','','en'),(263,238,'Login scopes','','en'),(264,239,'\"New arrivals\" block settings','','en'),(265,240,'Enable \"New arrivals\" feature in catalog','','en'),(266,241,'Number of days to keep products marked as new arrivals','Specify a non-zero value; otherwise, 30 days will be used by default.','en'),(267,242,'Maximum number of products to display in complete new arrivals list','Limits the total number of products that can be displayed when user clicks the \"All new arrivals\" link in the \"New arrivals\" block. Leave 0 for no limit.','en'),(268,243,'Label new products','','en'),(269,244,'Maximum number of products to display in \"New arrivals\" block','Defines the maximum number of products that can be displayed in the \"New arrivals\" block. Specify a non-zero value; otherwise, 3 products will be displayed by default. If the specified value is less than the total amount of products on complete new arrivals list, that value will be used instead.','en'),(270,245,'Show new products only from category being viewed by customer','','en'),(271,246,'\"Coming soon\" block settings','','en'),(272,247,'Enable \"Coming soon\" feature in catalog','','en'),(273,248,'Label upcoming products','','en'),(274,249,'Show arrival date on product details pages','','en'),(275,250,'Show \"coming soon\" products only from category being viewed by customer','','en'),(276,251,'Maximum number of products to display in \"Coming soon\" block','Defines a maximum number of products that can be displayed in the \"Coming soon\" block. Specify a non-zero value; otherwise, 3 products will be displayed by default.','en'),(277,252,'\"Recently viewed\" block settings','','en'),(278,253,'Display \"Recently viewed\" block in catalog','','en'),(279,254,'Maximum number of products to display in \"Recently viewed\" block','Defines the maximum amount of products that can be displayed in the \"Recently viewed\" block. Leave 0 for no limit.','en'),(280,255,'\"Customers who bought this product also bought\" block settings','','en'),(281,256,'Display block in catalog','','en'),(282,257,'Maximum number of products to display in block','Defines the maximum number of products that can be displayed in the \"Customers who bought this product also bought\" block. Specify a non-zero value; otherwise, 3 products will be displayed by default.','en'),(283,258,'\"Customers who viewed this product bought\" block settings','','en'),(284,259,'Display block in catalog','','en'),(285,260,'Maximum number of products to display in block','Defines the maximum number of products that can be displayed in the \"Customers who viewed this product bought\" block. Specify a non-zero value; otherwise, 3 products will be displayed by default.','en'),(286,261,'Display the \"Products on sale\" block in the storefront','','en'),(287,262,'Display only the products on sale which are in the category being viewed (or its subcategories)','','en'),(288,263,'The maximum number of products to be displayed in the \"Products on sale\" block','The maximum number of products to be displayed in the \"Products on sale\" block. Set zero to display all products in the block. Drupal block settings can override this option (when the DrupalConnector module is enabled).','en'),(289,264,'Use the same tax rates for all user membership levels','','en'),(290,265,'Address for sales tax calculation','','en'),(291,266,'Taxable base','','en'),(292,267,'Company logo','','en'),(293,268,'Favicon','For the icon to be displayed properly in all web browsers, we recommend using the icon size of 32x32 px','en'),(294,269,'Apple icon','Image must be a .png file with the resolution of 192x192px','en'),(295,270,'Frequency of content renewal for Static page','','en'),(296,271,'Priority for Static page','The value should range from 0 to 1.','en'),(297,272,'Show the default menu along with the custom one','','en'),(298,273,'Data provider','','en'),(299,274,'PitneyBowes merchant emailId','','en'),(300,275,'PitneyBowes merchant shipperId','','en'),(301,276,'User ID','','en'),(302,277,'U.S.P.S. API server URL','Enter the URL provided to you by U.S.P.S. in the notification about your successful registration for the U. S. Postal Service\'s Web Tools Application Program Interfaces. For example: <ul><li>http://stg-production.shippingapis.com/ShippingApi.dll</li><li>http://production.shippingapis.com/ShippingAPI.dll</li></ul>','en'),(303,278,'Additional settings','','en'),(304,279,'Common options','','en'),(305,280,'Package dimensions (inches)','If dimensions are not provided, Web Tools will assume package is regular in size and all dimensions are less than or equal to 12 inches.','en'),(306,281,'Girth','If Girth is provided with a non-zero value, the package will be considered \"NONRECTANGULAR\"','en'),(307,282,'Maximum package weight','','en'),(308,283,'Machinable','','en'),(309,284,'Currency conversion rate','Specify rate X, where 1 USD = X in shop currency.<br/>The shipping cost is always returned in US Dollars. So if the store uses a different currency for payments, you need to specify a conversion rate to convert the shipping cost returned by the shipping service into your store\'s currency. If the same currency is used, leave this set to 1.','en'),(310,285,'Domestic U.S.P.S.','','en'),(311,286,'Container','','en'),(312,287,'First-Class mail type','','en'),(313,288,'Pricing type to be used','','en'),(314,289,'Parcel type','','en'),(315,290,'Request rates for','','en'),(316,291,'International U.S.P.S.','','en'),(317,292,'Mail type','','en'),(318,293,'Get commercial base postage','','en'),(319,294,'Global Express Guarantee (GXG)','','en'),(320,295,'GXG destination is a post office box','','en'),(321,296,'GXG package contains a gift','','en'),(322,297,'Parcel type','','en'),(323,298,'Cash on delivery','','en'),(324,299,'Use a fixed amount Collect on Delivery fee','If you are planning to allow your customers to use the COD payment method for orders shipped with USPS shipping methods, you can make the calculation of shipping costs faster by setting a fixed extra fee for using the COD payment method.<br /><br />If a fixed amount COD fee is not set on the store\'s end, it will be calculated on the USPS end, and to get information about the COD fee amount the store will need to send several requests to the USPS API (one for each USPS service type), which may take up to 14 seconds. When using a fixed amount COD fee, the store will only send a single request to the USPS API, which will take under one second.<br /><br />Using a <b>fixed amount COD fee</b> allows the store to calculate the shipping cost much faster and is the <b>recommended option</b>.','en'),(325,300,'Fixed COD price','If you have selected to use a fixed COD fee, specify the fee amount here. The COD fee will be used for all shipping methods returned by the USPS server.<br /><br />You can find the current price for the USPS Collect on Delivery (COD) extra service on this page: <a href=\"https://www.usps.com/business/add-extra-services.htm\" target=\"_blank\">https://www.usps.com/business/add-extra-services.htm</a>','en'),(326,301,'Additional options','','en'),(327,302,'Log all communication between shopping cart and USPS server','','en'),(328,303,'Sandbox mode','','en'),(329,304,'Auto enable new USPS shipping methods','','en'),(330,273,'Data provider','','ru'),(331,274,'PitneyBowes merchant emailId','','ru'),(332,275,'PitneyBowes merchant shipperId','','ru'),(333,276,'Идентификатор пользователя','','ru'),(334,277,'Веб-адрес API сервера U.S.P.S.','Введите веб-адрес, указанный в уведомлении от U.S.P.S. об успешной регистрации в U. S. Postal Service Web Tools Application Program Interfaces. Например: <ul><li>http://testing.shippingapis.com/ShippingAPITest.dll</li><li>http://production.shippingapis.com/ShippingAPI.dll</li></ul>','ru'),(335,278,'Дополнительные настройки','','ru'),(336,279,'Общие настройки','','ru'),(337,280,'Размеры упаковки (в дюймах)','If dimensions are not provided, Web Tools will assume package is regular in size and all dimensions are less than or equal to 12 inches.','ru'),(338,281,'Периметр (дюймы)','Для больших размеров и непрямоугольного и неизменяемого контейнера.','ru'),(339,282,'Максимальный вес упаковки','','ru'),(340,284,'Коэффициент пересчета валюты','Укажите ставку X, где 1 USD = X в валюте магазина.<br/>Стоимость доставки всегда определяется в американских доллрах. Если в магазине используется другая валюта, необходимо указать коэффициент пересчёта стоимости доставки, полученной от службы доставки, в валюту магазина. Если валюта совпадает, оставить коэффициент равным 1.','ru'),(341,285,'Локальный U.S.P.S.','','ru'),(342,286,'Тара','','ru'),(343,287,'Тип почтового отправления для сервиса First-Class','','ru'),(344,283,'Машинная обработка','','ru'),(345,288,'Используемый тип цены (розничная, коммерческая и т.п.)','','ru'),(346,289,'Тип почтового отправления','','ru'),(347,291,'Международная служба U.S.P.S.','','ru'),(348,292,'Тип почтового отправления','','ru'),(349,293,'Воспользоваться услугой Commercial Base','','ru'),(350,294,'Служба доставки Global Express Guarantee (GXG)','','ru'),(351,295,'Пункт назначения GXG - абонентский ящик','','ru'),(352,296,'В посылке GXG есть подарок','','ru'),(353,297,'Тип почтового отправления','','ru'),(354,298,'Оплата при получении','','ru'),(355,299,'Использовать фиксированную сумму наценки на доставку наложенным платежом','Если вы планируете предоставлять покупателям возможность оплаты заказа при получении при доставке методами USPS, вы можете ускорить расчет стоимости доставки заказа, установив фиксированную наценку за использование данного метода оплаты. В случае, когда размер наценки не задан жестко на стороне магазина, расчет наценки будет осуществляться на стороне USPS, и для получения информации о размере наценки магазин должен будет отправить несколько запросов к USPS API (по одному для каждого типа сервисов USPS), что в общей сложности может занять до 20 сек. При использовании фиксированной наценки магазин будет делать всего один запрос к USPS API, на который ему потребуется менее одной секунды. Использование фиксированной наценки значительно ускоряет расчет стоимости доставки методами USPS и является рекомендуемой опцией.','ru'),(356,300,'Fixed COD price','Если вы выбрали использование фиксированной наценки на COD, укажите здесь ее значение. Это значение будет использовано для всех методов доставки USPS. Вы можете найти актуальное значение наценки за использование услуги Collect on delivery на этой странице: <a href=\"https://www.usps.com/business/add-extra-services.htm\" target=\"_blank\">https://www.usps.com/business/add-extra-services.htm</a>','ru'),(357,301,'Дополнительные опции','','ru'),(358,302,'Записать всю коммуникацию магазина с сервером USPS','','ru'),(359,303,'Sandbox mode','','ru'),(360,304,'Добавлять новые методы USPS включенными','','ru'),(361,305,'Frequency of content renewal for Welcome page','','en'),(362,306,'Frequency of content renewal for Category page','','en'),(363,307,'Frequency of content renewal for Product page','','en'),(364,308,'Priority for Welcome page','The value should range from 0 to 1.','en'),(365,309,'Priority for Category page','The value should range from 0 to 1.','en'),(366,310,'Priority for Product page','The value should range from 0 to 1.','en'),(367,311,'Account Id','','en'),(368,311,'Analyse-Account-ID','','de'),(369,311,'ID de la cuenta','','es'),(370,311,'Identifiant du compte','','fr'),(371,311,'Account ID','','nl'),(372,312,'Application Token','','en'),(373,312,'Anwendungstoken','','de'),(374,312,'Identificador de la aplicación','','es'),(375,312,'Jeton d\'application','','fr'),(376,312,'Applicatietoken','','nl'),(377,313,'Google Verification Token','','en'),(378,313,'Google-Verifizierungstoken','','de'),(379,313,'Identificador de verificación de Google','','es'),(380,313,'Jeton de vérification de Google','','fr'),(381,313,'Google verificatietoken','','nl'),(382,317,'Enable CloudFilters','','en'),(383,317,'Включить CloudFilters','','ru'),(384,318,'Enable products search in X-Cart Admin using CloudSearch','','en'),(385,318,'Включить поиск продуктов в админке X-Cart используя CloudSearch','','ru'),(386,320,'Show number of products in category','Select to show the number of products in a category next to the category\'s name','en'),(387,321,'Wrap long category names','Enable word wrapping for long category names','en'),(388,322,'Show category triangles','Select to display a tiny triangle next the names of categories that include subcategories. Categories that do not contain subcategories will not be furnished with a triangle. Having this option activated would help your store visitors to navigate through your category tree better','en'),(389,325,'User','','en'),(390,326,'Password','','en'),(391,327,'Developer mode','','en'),(392,328,'Log all communications between shopping cart and CanadaPost server','','en'),(393,329,'Additional settings','','en'),(394,330,'Quote type','','en'),(395,331,'Customer number','','en'),(396,332,'Currency rate','(specify rate X, where 1 CAD = X in shop currency)','en'),(397,333,'Contract shipping options','','en'),(398,334,'Contract ID','','en'),(399,335,'Shipments pick up type','','en'),(400,336,'Site number of the deposit location','Look up the site number using <a href=\"https://www.canadapost.ca/cpotools/apps/fdl/business/findDepositLocation?execution=e1s1\">Find a Deposit Location</a>','en'),(401,337,'Render detailed manifest','','en'),(402,338,'Contact name for the manifest address','','en'),(403,339,'Deliver to Post Office options','','en'),(404,340,'Enable \"Deliver to Post Office\" feature','','en'),(405,341,'Maximum Post Offices that will be displayed','','en'),(406,342,'Parcel characteristics','','en'),(407,343,'Package length (cm)','Longest dimension. (3.1 digits e.g. 999.9 pattern)','en'),(408,344,'Package width (cm)','Second longest dimension. (3.1 digits e.g. 999.9 pattern)','en'),(409,345,'Package height (cm)','Shortest dimension. (3.1 digits e.g. 999.9 pattern)','en'),(410,346,'Package maximum weight (kg)','This value will be used to separate ordered products into several packages by weight','en'),(411,347,'Document','Indicates whether the shipment is a document or not.','en'),(412,348,'Unpackaged','Indicates whether a shipment is unpackaged or not. For example, auto tires may be an example of an unpackaged shipment.','en'),(413,349,'Mailing tube','Indicates whether a shipment is contained in a mailing tube. (e.g. a poster tube)','en'),(414,350,'Oversized','Indicates whether the parcel is oversized or not.','en'),(415,351,'Parcel options','','en'),(416,352,'Way to deliver','','en'),(417,353,'Signature','','en'),(418,354,'Proof of age','','en'),(419,355,'Coverage','In percent of the order subtotal (0 - do not use coverage)','en'),(420,356,'Non-delivery instructions','','en'),(421,357,'Write key','','en'),(422,358,'User Id','','en'),(423,359,'Additional config loaded','','en'),(424,360,'Max number of files that can be attached','','en'),(425,360,'Максимальное количество файлов, которые можно присоединить','','ru'),(426,361,'Allowed file extensions','','en'),(427,361,'Допустимые расширения','','ru'),(428,362,'Max file size (MB). Set to \"0\" (zero) for unlimited','','en'),(429,362,'Максимальный размер файла (МБ). Используйте \"0\" (ноль) при отсутствии ограничений размера','','ru'),(430,370,'Checkout type','','en'),(431,371,'Shipping cost for products with a defined shipping freight value should be calculated as','','en'),(432,371,'Стоимость доставки для товаров с заданным значением поля \"Фиксированная стоимость доставки\" должна быть равна','','ru'),(433,372,'Use custom colors','','en'),(434,372,'Использовать пользовательские цвета','','ru'),(435,373,'Custom colors','','en'),(436,373,'Пользовательские цвета','','ru'),(437,374,'Use Froala as a text editor for e-mail notifications','','en'),(438,374,'Использовать Froala для редактирования текста e-mail уведомлений','','ru'),(439,375,'Default geolocation provider','','en'),(440,375,'Приоритетный источник данных о местоположении','','ru'),(441,376,'Display location select widget','','en'),(442,376,'Отображать виджет смены местоположения','','ru'),(443,377,'Upload extended database','You can upload an extended .mmdb database to get user location by IP more accurately','en'),(444,377,'Загрузить расширенную базу данных','Вы можете загрузить расширенную базу данных в формате .mmdb для более точного определения местоположения','ru'),(445,378,'Database file in use','','en'),(446,378,'Текущая база данных','','ru'),(447,379,'Frequency of Product Feed renewal','You should configure X-Cart to run <a href=\"https://kb.x-cart.com/general_setup/configuring_your_server_to_run_scheduled_x-cart_tasks.html\" target=\"_blank\">scheduled cron tasks</a> to enable periodic feed updates.','en'),(448,379,'Частота обновления выгрузки товаров','Чтобы автоматизировать обновление списка товаров, необходимо настроить <a href=\"https://kb.x-cart.ru/general_setup/configuring_your_server_to_run_scheduled_x-cart_tasks.html\" target=\"_blank\">выполнение запланированных задач</a> на сервере.','ru'),(449,380,'In case of duplicate product variants','The variants with duplicate attributes will get a title with a suffix, containing the attribute option values as string. Google will do it\'s best to handle such products properly.','en'),(450,380,'При наличии дублирующихся вариантов товара','Вариантам с дублирующимися атрибутами будет присвоен суффикс в наименовании, содержащий прочие значения атрибутов в строковом виде. При загрузке списка товаров Google попытается определить связь вариантов через наименование.','ru'),(451,381,'Mailchimp settings','','en'),(452,382,'Mailchimp API key','','en'),(453,383,'Enable E-commerce analytics','','en'),(454,384,'Enable Abandoned Carts','','en'),(455,385,'Default list for automatic campaigns','','en'),(456,386,'Enable single opt-in for customers','When this option is enabled customers are not prompted to confirm the subscription by email (contrary to double opt-in). Abusing this option might get your account banned by Mailchimp.','en'),(457,387,'Subscription select element type','This option controls the way your customers select a subscription. Select box allows subscription to only one mail list while check box allows subscription to multiple lists. For Checkout page always stays checkbox.','en'),(458,388,'Update Mailchimp lists every','Select the time interval for the periodical list updates.','en'),(459,389,'Type of discount coupons that should be uploaded to Mailchimp','The Mailchimp promo rules are:<br> - Code<br> - Discount amount<br> - Active from<br> - Active till <br>Discount coupons configured using any rules outside this rule set will be treated as not matching the Mailchimp rules.','en'),(460,389,'Тип купонов на скидку, который следует загружать в Mailchimp','Промо-правила Mailchimp: <br> - Код<br> - Сумма скидки<br> - Активен с<br> - Активен по <br>Купоны, настроенные с использованием каких-либо правил сверх этого набора, будут считаться не соответствующим промо-правилам Mailchimp.','ru'),(461,390,'Site connection code','The connection code will appear here automatically once you upload store data to MailChimp. Alternatively, you can connect MailChimp subscription popup via Custom Website integration code. Add your site to the MailChimp account and paste here the connection code.','en'),(462,390,'Код подключения сайта','Код появится автоматически после загрузки данных магазина в MailChimp. Также вы можете самостоятельно присоединить магазин, скопировав код подключения в это поле.','ru'),(463,381,'Настройки Mailchimp','','ru'),(464,382,'API ключ Mailchimp','','ru'),(465,383,'Включить аналитику Ecommerce','','ru'),(466,384,'Включить Abandoned Carts','','ru'),(467,385,'Список рассылок для автоматических кампаний','','ru'),(468,386,'Включить режим подписки \"single opt-in\"','Когда этоа опция включена клиенты не будут получать запрос на подтверждение подписки (в отличие от метода \"double opt-in\"). Злоупотребление данной опцией может привести к блокировке вашей учетной записи Mailchimp!','ru'),(469,387,'Тип элемента выбора подписки','Эта опция управляет тем, как ваши клиенты выбирают подписку на рассылку. Список позволяет подписаться только на одну рассылку из списка за раз, когда как галочка позволяет подписаться на несколько рассылок сразу. Для страницы оплаты всегда остаётся галочка.','ru'),(470,388,'Обновлять список рассылок Mailchimp каждые','Выберите временной интервал для обновления информации о списках рассылок.','ru'),(471,391,'Number of news messages in the Top news list','','en'),(472,391,'Количество новостей в списке Последних новостей','','ru'),(473,392,'News messages per page','','en'),(474,392,'Количество новостей на странице','','ru'),(475,393,'Frequency of content renewal for News Message page','','en'),(476,394,'Priority for News Message page','The value should range from 0 to 1.','en'),(477,395,'Not finished order will be created','','en'),(478,395,'Создавать незавершенный заказ','','ru'),(479,396,'Clear cart if administrator changes order','','en'),(480,396,'Очищать корзину при изменении заказа администратором','','ru'),(481,397,'Limit lifetime of not finished order','','en'),(482,397,'Ограничить срок действия незавершенного заказа','','ru'),(483,398,'Time to use the order for future attempts (days)','0 means that every failed attempt will be recorded as individual not finished order and its data will not be used in the next attempts.','en'),(484,398,'Срок действия незавершенного заказа (в днях)','Если задать срок равным 0 (нулю), то каждая неудачная попытка оплаты будет создавать отдельный незавершенный заказ, и данные этого заказа не будут внесены в будущие попытки.','ru'),(485,400,'Enable \"In stock only\" filter','','en'),(486,401,'Enable \"Price range\" filter','','en'),(487,402,'Enable \"Attributes\" filter','','en'),(488,403,'Show only available attributes and tags for products in category','If the setting is disabled, the filter shows all the attribute values and tags used in your store. If the setting is enabled, X-Cart generates a data cache that is used to display in the filter only the attribute values and tags that are actually used for the products in the category being viewed. Please be aware that the availability of the products for specific user membership levels is not taken into account during cache generation.','en'),(489,404,'Cache reset mode','Cache is first generated when a category page is opened. When attribute, tag or product data is changed, the generated cache is removed. It is then generated again when any category is opened.','en'),(490,405,'Sort order for class attributes','This setting affects only the attributes themselves, not their values. The values are sorted alphabetically.','en'),(491,406,'Generate the URL query string for filter with','This setting defines how the URL query string should be assembled when selecting the parameters that will be used to filter products.','en'),(492,400,'Включить фильтр \"Только товары в наличии\"','','ru'),(493,401,'Включить фильтр \"Цена\"','','ru'),(494,402,'Включить фильтр \"Атрибуты\"','','ru'),(495,403,'Отображать только атрибуты и теги, реально используемые для товаров в категории','Если данная настройка выключена, в фильтре показываются все значения атрибутов и все теги, используемые в магазине. Если настройка включена, X-Cart генерирует кеш данных, позволяющий отображать в фильтре только те значения атрибутов и теги, которые реально используются для товаров в просматриваемой категории. Обратите внимание, что доступность товаров для отдельных групп пользователей при генерации кеша не учитывается.','ru'),(496,404,'Режим обновления кэша','Кеш впервые генерируется при открытии страницы категории. При внесении изменений в данные атрибутов, тегов или товаров, кеш сбрасывается. Затем он генерируется заново, когда происходит открытие любой категории.','ru'),(497,405,'Порядок сортировки классовых атрибутов','Эта настройка влияет только на сами атрибуты, а не их значения. Значения сортируются в алфавитном порядке.','ru'),(498,406,'Строить строку запроса в URL для фильтра используя','Данная настройка позволяет выбрать, каким образом должен собираться URL страницы при наборе параметров, по которым будет осуществляться фильтрация товаров.','ru'),(499,407,'Show tags list in the sidebar','','en'),(500,408,'Enable \"Tags\" filter','','en'),(501,407,'Показывать список тегов в боковой колонке','','ru'),(502,408,'Включить фильтр \"Теги\"','','ru'),(503,409,'API key (read/write)','','en'),(504,410,'API key (only read)','','en'),(505,411,'Who can leave feedback','','en'),(506,412,'Admin moderates all reviews before showing them to customers','','en'),(507,413,'The quantity of reviews for tabs product reviews','','en'),(508,414,'Request customers to review the purchased products after successful orders','A successful order means an order that has been paid for and delivered.','en'),(509,414,'Отправлять покупателям приглашение оставить отзыв о купленных товарах после успешного заказа','Успешным заказом считается заказ, оплаченный и доставленный покупателю.','ru'),(510,415,'How many days later to send a review request','','en'),(511,415,'Через сколько дней отправлять приглашение оставить отзыв','','ru'),(512,416,'Use custom css','','en'),(513,417,'Use custom javascript','','en'),(514,418,'User ID','','en'),(515,419,'Password','','en'),(516,420,'Access key','','en'),(517,421,'UPS Account number','A shipper\'s UPS account number is required when requesting to receive the negotiated rates.','en'),(518,422,'Test mode','','en'),(519,423,'Additional settings','','en'),(520,424,'Package settings','','en'),(521,425,'Package box type','','en'),(522,426,'Package dimensions','','en'),(523,427,'Maximum package weight','','en'),(524,428,'Service options','','en'),(525,429,'Pickup type','','en'),(526,430,'Saturday pickup','','en'),(527,431,'Additional handling','','en'),(528,432,'Saturday delivery','','en'),(529,433,'Use negotiated rates','','en'),(530,434,'Delivery confirmation','','en'),(531,435,'Add insured value','','en'),(532,436,'Insured value','','en'),(533,437,'Shipping refunds settings','','en'),(534,439,'Cash on delivery','','en'),(535,440,'Currency conversion options','','en'),(536,441,'Shipping cost currency','','en'),(537,442,'Currency rate','If the UPS returns rates in currency which is differ from the currency the store uses for payments you need to specify the conversion rate to convert the shipping cost returned by UPS into the necessary currency. Otherwise leave 1.','en'),(538,443,'Additional options','','en'),(539,444,'Enable debugging','This option enables logging of all communication between shopping cart and UPS server.','en'),(540,445,'Allow direct communication between vendor and buyer in the \"Warehouse\" multivendor mode','','en'),(541,445,'Разрешить обмен сообщениями между продавцом и покупателем в режиме \"Общий склад\"','','ru');
CREATE TABLE `xlite_upselling_products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned DEFAULT NULL,
  `parent_product_id` int(10) unsigned DEFAULT NULL,
  `orderBy` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_1DF3D3E14584665A` (`product_id`),
  KEY `parent_product_index` (`parent_product_id`),
  CONSTRAINT `FK_1DF3D3E12C7E20A` FOREIGN KEY (`parent_product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_1DF3D3E14584665A` FOREIGN KEY (`product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_upselling_products` VALUES (1,12,16,0),(2,16,12,0),(3,13,16,0),(4,16,13,0),(5,14,16,0),(6,16,14,0),(7,17,16,0),(8,16,17,0),(9,13,12,0),(10,12,13,0),(11,14,12,0),(12,12,14,0),(13,17,12,0),(14,12,17,0),(15,14,13,0),(16,13,14,0),(17,17,13,0),(18,13,17,0),(19,14,17,0),(20,17,14,0),(27,28,41,0),(29,30,41,0),(31,39,41,0),(33,40,37,0),(35,40,41,0),(37,28,37,0),(39,30,37,0),(41,39,37,0),(43,28,42,0),(45,30,42,0),(47,39,42,0),(49,40,42,0),(50,43,25,0),(51,42,25,0),(52,50,25,0),(53,46,25,0),(54,49,25,0);
CREATE TABLE `xlite_form_ids` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` int(11) DEFAULT NULL,
  `form_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `date` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fs` (`form_id`,`session_id`),
  KEY `session_id` (`session_id`),
  CONSTRAINT `FK_AD266A12613FECDF` FOREIGN KEY (`session_id`) REFERENCES `xlite_sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_category_images` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned DEFAULT NULL,
  `alt` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `width` int(11) NOT NULL,
  `height` int(11) NOT NULL,
  `hash` char(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `needProcess` tinyint(1) NOT NULL,
  `path` varchar(512) COLLATE utf8_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_3EDA5C4B12469DE2` (`category_id`),
  CONSTRAINT `FK_3EDA5C4B12469DE2` FOREIGN KEY (`category_id`) REFERENCES `xlite_categories` (`category_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_category_images` VALUES (1,2,'',732,880,NULL,1,'clo_7_1.jpg','','image/jpeg','r',111237,1559324094),(2,3,'',732,880,NULL,1,'clo_5.jpg','','image/jpeg','r',199790,1559317753),(3,4,'',732,880,NULL,1,'shoes_6_2.jpg','','image/jpeg','r',80257,1559317794),(4,5,'',732,880,NULL,1,'bag_1.jpg','','image/jpeg','r',154680,1559320882),(5,6,'',732,880,NULL,1,'beauty_1.jpg','','image/jpeg','r',46495,1559892754),(6,7,'',732,880,NULL,1,'beauty_2.jpg','','image/jpeg','r',102218,1559894538),(7,8,'',732,880,NULL,1,'food_11.jpg','','image/jpeg','r',84336,1559898037),(8,9,'',732,880,NULL,1,'elec_2.jpg','','image/jpeg','r',132698,1559820383),(9,10,'',732,880,NULL,1,'elec_5.jpg','','image/jpeg','r',51859,1559822955),(10,11,'',732,880,NULL,1,'elec_4.jpg','','image/jpeg','r',125842,1559821038),(11,12,'',732,880,NULL,1,'elec_14.jpg','','image/jpeg','r',16200,1559828507);
CREATE TABLE `xlite_tasks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `triggerTime` int(11) NOT NULL,
  `data` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_tasks` VALUES (1,'XLite\\Core\\Task\\EventListener',0,'a:0:{}'),(2,'XLite\\Core\\Task\\OrdersGarbageCleaner',0,'a:0:{}'),(3,'XLite\\Core\\Task\\JobQueueCronRunner',0,'a:0:{}'),(4,'XLite\\Core\\Task\\SessionsGarbageCleaner',0,'a:0:{}'),(5,'XLite\\Core\\Task\\DataCacheGarbageCleaner',0,'a:0:{}'),(6,'XLite\\Module\\CDev\\XMLSitemap\\Core\\Task\\GenerateSitemap',0,'a:0:{}'),(7,'XLite\\Module\\XC\\FacebookMarketing\\Core\\Task\\GenerateProductFeed',0,'a:0:{}'),(8,'XLite\\Module\\XC\\GoogleFeed\\Core\\Task\\FeedUpdater',0,'a:0:{}'),(9,'XLite\\Module\\XC\\MailChimp\\Core\\Task\\UpdateLists',0,'a:0:{}'),(10,'XLite\\Module\\XC\\Reviews\\Core\\Task\\SendReviewKeys',0,'a:0:{}');
CREATE TABLE `xlite_data_sources` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_featured_products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `orderBy` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pair` (`category_id`,`product_id`),
  KEY `IDX_CE976A6E4584665A` (`product_id`),
  KEY `IDX_CE976A6E12469DE2` (`category_id`),
  CONSTRAINT `FK_CE976A6E12469DE2` FOREIGN KEY (`category_id`) REFERENCES `xlite_categories` (`category_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_CE976A6E4584665A` FOREIGN KEY (`product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_featured_products` VALUES (1,14,1,10),(2,29,1,20),(3,42,1,30),(4,31,1,40),(5,35,1,50),(6,25,1,60),(7,21,1,70),(8,2,1,80);
CREATE TABLE `xlite_attribute_values_text_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `value` longtext COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_753A596BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_attribute_values_text` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_attribute_options` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_id` int(10) unsigned DEFAULT NULL,
  `addToNew` tinyint(1) NOT NULL,
  `position` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_2E486F4AB6E62EFA` (`attribute_id`),
  CONSTRAINT `FK_2E486F4AB6E62EFA` FOREIGN KEY (`attribute_id`) REFERENCES `xlite_attributes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_attribute_options` VALUES (1,1,1,0),(2,1,1,0),(3,1,1,0),(4,1,1,0),(5,1,1,0),(8,1,1,0),(109,50,0,0),(110,50,0,0),(111,50,0,0),(112,50,0,0),(113,50,0,0),(114,50,0,0),(115,50,0,0),(116,50,0,0),(165,71,1,0),(166,71,1,0),(167,71,0,0),(168,73,0,0),(169,73,0,0),(170,73,0,0),(171,72,0,0),(173,75,0,0),(181,83,0,0),(183,85,0,0),(186,71,0,0),(187,72,0,0),(188,73,0,0),(189,73,0,0),(196,83,0,0),(200,72,0,0),(205,73,0,0),(207,74,0,0),(209,76,0,0),(210,77,0,0),(211,78,0,0),(212,79,0,0),(213,80,0,0),(214,81,0,0),(215,82,0,0),(217,84,0,0),(218,1,0,0),(219,1,0,0),(227,94,1,0),(228,94,1,0),(229,94,1,0),(230,94,1,0),(231,95,0,0),(232,95,0,0),(233,95,0,0),(234,96,0,0),(235,96,0,0),(236,96,0,0),(237,96,0,0),(238,96,0,0),(245,98,0,0),(246,98,0,0),(247,98,0,0),(248,98,0,0),(249,71,0,0),(250,72,0,0),(251,75,0,0),(252,76,0,0),(253,77,0,0),(254,85,0,0),(255,72,0,0),(256,99,0,0),(257,99,0,0),(258,99,0,0),(259,99,0,0),(260,99,0,0),(261,99,0,0);
CREATE TABLE `xlite_order_history_events` (
  `event_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  `author_id` int(11) DEFAULT NULL,
  `date` int(11) NOT NULL,
  `code` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(1024) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  `comment` longtext COLLATE utf8_unicode_ci NOT NULL,
  `authorName` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `authorIp` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`event_id`),
  KEY `IDX_57EBBA5F8D9F6D38` (`order_id`),
  KEY `IDX_57EBBA5FF675F31B` (`author_id`),
  CONSTRAINT `FK_57EBBA5F8D9F6D38` FOREIGN KEY (`order_id`) REFERENCES `xlite_orders` (`order_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_57EBBA5FF675F31B` FOREIGN KEY (`author_id`) REFERENCES `xlite_profiles` (`profile_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_order_history_events` VALUES (1,1,1,1394005540,'PLACE ORDER','Order placed','N;','',NULL,''),(2,1,1,1394005540,'TRANSACTION','Payment transaction [method: Phone Ordering, type: sale, amount: 18.49, status: Pending]','N;','',NULL,''),(3,1,1,1394005540,'EMAIL ADMIN SENT','Email sent to the admin','a:1:{s:7:\"orderId\";i:1;}','Order is initially created',NULL,''),(4,2,1,1396005895,'PLACE ORDER','Order placed','N;','',NULL,''),(5,2,1,1396005895,'TRANSACTION','Payment transaction [method: Phone Ordering, type: sale, amount: 88.67, status: Pending]','N;','',NULL,''),(6,2,1,1396005895,'EMAIL ADMIN SENT','Email sent to the admin','a:1:{s:7:\"orderId\";i:2;}','Order is initially created',NULL,''),(7,3,1,1407005895,'PLACE ORDER','Order placed','N;','',NULL,''),(8,3,1,1407005895,'TRANSACTION','Payment transaction [method: Phone Ordering, type: sale, amount: 158.94, status: Pending]','N;','',NULL,''),(9,3,1,1407005895,'EMAIL ADMIN SENT','Email sent to the admin','a:1:{s:7:\"orderId\";i:3;}','Order is initially created',NULL,''),(10,4,1,1452604435,'PLACE ORDER','Order placed','a:1:{s:7:\"orderId\";i:4;}','',NULL,''),(11,4,1,1452604436,'TRANSACTION','Back end payment transaction [method: Simplify Commerce Hosted Payments, type: sale, amount: 38.01, status: Failed] [initial request]','N;','',NULL,''),(12,4,1,1452604436,'TRANSACTION','Payment transaction [method: Simplify Commerce Hosted Payments, type: sale, amount: 38.01, status: Failed]','N;','',NULL,''),(13,4,1,1452604437,'CHANGE PAYMENT STATUS ORDER','Order payment status changed from {{oldStatus}} to {{newStatus}}','a:3:{s:7:\"orderId\";i:4;s:9:\"newStatus\";s:8:\"Declined\";s:9:\"oldStatus\";s:16:\"Awaiting payment\";}','',NULL,''),(14,4,1,1452604501,'CHANGE PAYMENT STATUS ORDER','Order payment status changed from {{oldStatus}} to {{newStatus}}','a:3:{s:7:\"orderId\";i:4;s:9:\"newStatus\";s:16:\"Awaiting payment\";s:9:\"oldStatus\";s:8:\"Declined\";}','',NULL,''),(15,4,1,1452604502,'TRANSACTION','Back end payment transaction [method: Simplify Commerce Hosted Payments, type: sale, amount: 38.01, status: Failed] [initial request]','N;','',NULL,''),(16,4,1,1452604502,'TRANSACTION','Payment transaction [method: Simplify Commerce Hosted Payments, type: sale, amount: 38.01, status: Failed]','N;','',NULL,''),(17,4,1,1452604502,'CHANGE PAYMENT STATUS ORDER','Order payment status changed from {{oldStatus}} to {{newStatus}}','a:3:{s:7:\"orderId\";i:4;s:9:\"newStatus\";s:8:\"Declined\";s:9:\"oldStatus\";s:16:\"Awaiting payment\";}','',NULL,''),(18,5,1,1452604702,'PLACE ORDER','Order placed','N;','',NULL,''),(19,5,1,1452604702,'TRANSACTION','Payment transaction [method: Money Ordering, type: sale, amount: 352.81, status: Pending]','N;','',NULL,''),(20,5,1,1452604702,'EMAIL ADMIN SENT','Email sent to the admin','a:1:{s:7:\"orderId\";i:5;}','Order is initially created',NULL,'');
CREATE TABLE `xlite_profile_addresses` (
  `address_id` int(11) NOT NULL AUTO_INCREMENT,
  `profile_id` int(11) DEFAULT NULL,
  `state_id` int(11) DEFAULT NULL,
  `country_code` char(2) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_billing` tinyint(1) NOT NULL,
  `is_shipping` tinyint(1) NOT NULL,
  `isWork` tinyint(1) NOT NULL,
  `address_type` char(1) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`address_id`),
  KEY `IDX_A6B45064CCFA12B8` (`profile_id`),
  KEY `IDX_A6B450645D83CC1` (`state_id`),
  KEY `IDX_A6B45064F026BB7C` (`country_code`),
  KEY `is_billing` (`is_billing`),
  KEY `is_shipping` (`is_shipping`),
  CONSTRAINT `FK_A6B450645D83CC1` FOREIGN KEY (`state_id`) REFERENCES `xlite_states` (`state_id`) ON DELETE SET NULL,
  CONSTRAINT `FK_A6B45064CCFA12B8` FOREIGN KEY (`profile_id`) REFERENCES `xlite_profiles` (`profile_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_A6B45064F026BB7C` FOREIGN KEY (`country_code`) REFERENCES `xlite_countries` (`code`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_profile_addresses` VALUES (1,1,595,'US',1,1,0,'R'),(2,2,595,'US',1,1,0,'R'),(3,3,595,'US',1,1,0,'R'),(4,4,595,'US',1,1,0,'R'),(5,5,595,'US',1,1,0,'R'),(6,6,595,'US',1,1,0,'R');
CREATE TABLE `xlite_order_history_event_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_id` int(11) DEFAULT NULL,
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_BAE0BB2471F7E88B` (`event_id`),
  KEY `en` (`event_id`,`name`),
  CONSTRAINT `FK_BAE0BB2471F7E88B` FOREIGN KEY (`event_id`) REFERENCES `xlite_order_history_events` (`event_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_memberships` (
  `membership_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `position` int(11) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  PRIMARY KEY (`membership_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_memberships` VALUES (1,10,1);
CREATE TABLE `xlite_role_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `IDX_27007A52BF396750` (`id`),
  CONSTRAINT `FK_27007A52BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_role_translations` VALUES (1,1,'Administrator','en'),(2,1,'Administrator','ru'),(3,2,'Coupons management','en'),(4,2,'Управление купонами','ru'),(5,3,'Content management','en'),(6,3,'Управлением контентом','ru'),(7,4,'Volume discounts management','en'),(8,4,'Управление скидками','ru');
CREATE TABLE `xlite_product_attachments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned DEFAULT NULL,
  `private` tinyint(1) NOT NULL,
  `orderby` int(11) NOT NULL,
  `access` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_A8FB24FA4584665A` (`product_id`),
  KEY `o` (`orderby`),
  CONSTRAINT `FK_A8FB24FA4584665A` FOREIGN KEY (`product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_global_product_tab_provider` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tab_id` int(10) unsigned DEFAULT NULL,
  `code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_5120A7CB8D0C9323` (`tab_id`),
  CONSTRAINT `FK_5120A7CB8D0C9323` FOREIGN KEY (`tab_id`) REFERENCES `xlite_global_product_tabs` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_global_product_tab_provider` VALUES (1,1,'Core'),(2,2,'Core'),(3,3,'CDev-GoSocial'),(4,4,'XC-Reviews'),(5,5,'Core'),(6,6,'Core'),(7,7,'Core');
CREATE TABLE `xlite_access_control_entities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type_id` int(10) unsigned DEFAULT NULL,
  `cell_id` int(10) unsigned DEFAULT NULL,
  `uid` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_A98BAB59C54C8C93` (`type_id`),
  KEY `IDX_A98BAB59CB39D93A` (`cell_id`),
  CONSTRAINT `FK_A98BAB59C54C8C93` FOREIGN KEY (`type_id`) REFERENCES `xlite_access_control_entity_types` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_A98BAB59CB39D93A` FOREIGN KEY (`cell_id`) REFERENCES `xlite_access_control_cells` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_order_capost_parcel_shipment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shipmentId` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `shipmentStatus` varchar(14) COLLATE utf8_unicode_ci DEFAULT NULL,
  `trackingPin` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `returnTrackingPin` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `poNumber` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `parcelId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_7954C1A5A9ACC87` (`parcelId`),
  CONSTRAINT `FK_7954C1A5A9ACC87` FOREIGN KEY (`parcelId`) REFERENCES `xlite_order_capost_parcels` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_order_capost_parcel_shipment_tracking_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `trackingId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_F6B816A26F76B6A7` (`trackingId`),
  CONSTRAINT `FK_F6B816A26F76B6A7` FOREIGN KEY (`trackingId`) REFERENCES `xlite_order_capost_parcel_shipment_tracking` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_customer_attachments_storage` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `item_id` int(11) DEFAULT NULL,
  `path` varchar(512) COLLATE utf8_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_ACB714E4126F525E` (`item_id`),
  CONSTRAINT `FK_ACB714E4126F525E` FOREIGN KEY (`item_id`) REFERENCES `xlite_order_items` (`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_iframe_contents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `method` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `data` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_import_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` int(11) NOT NULL,
  `type` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(32) COLLATE utf8_unicode_ci NOT NULL,
  `arguments` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  `file` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `row` int(10) unsigned NOT NULL,
  `processor` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_attribute_values_select` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_option_id` int(10) unsigned DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  `attribute_id` int(10) unsigned DEFAULT NULL,
  `position` int(11) NOT NULL,
  `priceModifier` decimal(14,4) NOT NULL,
  `priceModifierType` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `weightModifier` decimal(14,4) NOT NULL,
  `weightModifierType` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `defaultValue` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`),
  KEY `attribute_id` (`attribute_id`),
  KEY `attribute_option_id` (`attribute_option_id`),
  CONSTRAINT `FK_65258CAB1AE56DE9` FOREIGN KEY (`attribute_option_id`) REFERENCES `xlite_attribute_options` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_65258CAB4584665A` FOREIGN KEY (`product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_65258CABB6E62EFA` FOREIGN KEY (`attribute_id`) REFERENCES `xlite_attributes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_attribute_values_select` VALUES (462,227,2,94,0,0.0000,'p',0.0000,'p',0),(463,228,2,94,0,0.0000,'p',0.0000,'p',0),(464,229,2,94,0,0.0000,'p',0.0000,'p',0),(465,230,2,94,0,0.0000,'p',0.0000,'p',0),(466,228,4,94,0,0.0000,'a',0.0000,'a',0),(467,229,4,94,0,0.0000,'a',0.0000,'a',0),(468,230,4,94,0,0.0000,'a',0.0000,'a',0),(470,231,31,95,10,0.0000,'a',0.0000,'a',0),(471,232,31,95,20,20.0000,'a',0.0000,'a',0),(472,233,31,95,30,5.0000,'p',0.0000,'a',0),(473,234,16,96,10,0.0000,'a',0.0000,'a',0),(474,235,16,96,20,0.0000,'a',0.0000,'a',0),(475,236,16,96,30,0.0000,'a',0.0000,'a',0),(476,237,16,96,40,0.0000,'a',0.0000,'a',0),(477,238,16,96,50,0.0000,'a',0.0000,'a',0),(484,116,14,50,10,0.0000,'a',0.0000,'a',0),(485,1,14,1,0,0.0000,'p',0.0000,'p',0),(486,2,14,1,0,0.0000,'p',0.0000,'p',0),(487,3,14,1,0,0.0000,'p',0.0000,'p',0),(488,4,14,1,0,0.0000,'p',0.0000,'p',0),(489,5,14,1,0,0.0000,'p',0.0000,'p',0),(490,8,14,1,0,0.0000,'p',0.0000,'p',0),(491,2,17,1,0,0.0000,'a',0.0000,'a',0),(493,3,17,1,0,0.0000,'a',0.0000,'a',0),(494,4,17,1,0,0.0000,'a',0.0000,'a',0),(495,5,17,1,0,0.0000,'a',0.0000,'a',0),(496,8,17,1,0,0.0000,'a',0.0000,'a',0),(497,109,17,50,10,0.0000,'a',0.0000,'a',0),(502,166,29,71,0,0.0000,'a',0.0000,'a',0),(504,167,29,71,10,100.0000,'a',0.0000,'a',0),(505,249,29,71,20,200.0000,'a',0.0000,'a',0),(506,250,29,72,10,0.0000,'a',0.0000,'a',0),(507,189,29,73,10,0.0000,'a',0.0000,'a',0),(509,251,29,75,10,0.0000,'a',0.0000,'a',0),(510,252,29,76,10,0.0000,'a',0.0000,'a',0),(511,253,29,77,10,0.0000,'a',0.0000,'a',0),(513,181,29,83,10,0.0000,'a',0.0000,'a',0),(515,254,29,85,10,0.0000,'a',0.0000,'a',0),(516,166,28,71,0,0.0000,'a',0.0000,'a',0),(517,249,28,71,0,0.0000,'a',0.0000,'a',0),(518,255,28,72,10,0.0000,'a',0.0000,'a',0),(519,168,28,73,10,0.0000,'a',0.0000,'a',0),(520,170,28,73,20,0.0000,'a',0.0000,'a',0),(521,169,28,73,30,0.0000,'a',0.0000,'a',0),(523,173,28,75,10,0.0000,'a',0.0000,'a',0),(527,181,28,83,10,0.0000,'a',0.0000,'a',0),(529,254,28,85,10,0.0000,'a',0.0000,'a',0),(530,111,15,50,10,0.0000,'a',0.0000,'a',0),(531,256,15,99,10,0.0000,'a',0.0000,'a',0),(532,257,15,99,20,0.0000,'a',0.0000,'a',0),(533,258,15,99,30,0.0000,'a',0.0000,'a',0),(534,259,15,99,40,0.0000,'a',0.0000,'a',0),(535,260,15,99,50,0.0000,'a',0.0000,'a',0),(536,261,15,99,60,0.0000,'a',0.0000,'a',0);
CREATE TABLE `xlite_order_details` (
  `detail_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `value` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`detail_id`),
  KEY `IDX_C25F888B8D9F6D38` (`order_id`),
  KEY `oname` (`order_id`,`name`),
  CONSTRAINT `FK_C25F888B8D9F6D38` FOREIGN KEY (`order_id`) REFERENCES `xlite_orders` (`order_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_vendor_convo_message_reads` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `message_id` int(10) unsigned DEFAULT NULL,
  `profile_id` int(11) DEFAULT NULL,
  `date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`message_id`,`profile_id`),
  KEY `IDX_25816BBA537A1329` (`message_id`),
  KEY `IDX_25816BBACCFA12B8` (`profile_id`),
  CONSTRAINT `FK_25816BBA537A1329` FOREIGN KEY (`message_id`) REFERENCES `xlite_vendor_convo_messages` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_25816BBACCFA12B8` FOREIGN KEY (`profile_id`) REFERENCES `xlite_profiles` (`profile_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_access_control_zones` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cell_id` int(10) unsigned DEFAULT NULL,
  `type_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cz` (`cell_id`,`type_id`),
  KEY `IDX_19AE0547CB39D93A` (`cell_id`),
  KEY `IDX_19AE0547C54C8C93` (`type_id`),
  CONSTRAINT `FK_19AE0547C54C8C93` FOREIGN KEY (`type_id`) REFERENCES `xlite_access_control_zone_types` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_19AE0547CB39D93A` FOREIGN KEY (`cell_id`) REFERENCES `xlite_access_control_cells` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_sales_tax_rates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tax_id` int(10) unsigned DEFAULT NULL,
  `zone_id` int(11) DEFAULT NULL,
  `tax_class_id` int(10) unsigned DEFAULT NULL,
  `membership_id` int(10) unsigned DEFAULT NULL,
  `value` decimal(14,4) NOT NULL,
  `type` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `position` int(11) NOT NULL,
  `noTaxClass` tinyint(1) NOT NULL,
  `taxableBase` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_1ACD2E0EB2A824D8` (`tax_id`),
  KEY `IDX_1ACD2E0E9F2C3FAB` (`zone_id`),
  KEY `IDX_1ACD2E0EA94AAAE` (`tax_class_id`),
  KEY `IDX_1ACD2E0E1FB354CD` (`membership_id`),
  CONSTRAINT `FK_1ACD2E0E1FB354CD` FOREIGN KEY (`membership_id`) REFERENCES `xlite_memberships` (`membership_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_1ACD2E0E9F2C3FAB` FOREIGN KEY (`zone_id`) REFERENCES `xlite_zones` (`zone_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_1ACD2E0EA94AAAE` FOREIGN KEY (`tax_class_id`) REFERENCES `xlite_tax_classes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_1ACD2E0EB2A824D8` FOREIGN KEY (`tax_id`) REFERENCES `xlite_sales_taxes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_payment_transaction_data` (
  `data_id` int(11) NOT NULL AUTO_INCREMENT,
  `transaction_id` int(11) DEFAULT NULL,
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `access_level` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`data_id`),
  KEY `IDX_BA8F92A12FC0CB0F` (`transaction_id`),
  KEY `tn` (`transaction_id`,`name`),
  CONSTRAINT `FK_BA8F92A12FC0CB0F` FOREIGN KEY (`transaction_id`) REFERENCES `xlite_payment_transactions` (`transaction_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_payment_transaction_data` VALUES (1,4,'test_mode','Test mode','A','1'),(2,4,'error_field_name_card.number','Error: field name','A','card.number'),(3,4,'error_field_code_card.number','Error: field code','A','country.bin.not.accepted'),(4,4,'error_field_message_card.number','Error: field message','A','Card bin Country rejected by acquirer'),(5,4,'cart_items','Cart items','A','a:1:{i:0;a:5:{s:4:\"name\";s:27:\"Caged Cutout Sandals in Gold\";s:3:\"sku\";s:6:\"10000000083\";s:5:\"price\";d:34.990000000000002;s:6:\"amount\";i:1;s:5:\"attrs\";a:0:{}}}'),(6,5,'test_mode','Test mode','A','1'),(7,5,'error_field_name_card.number','Error: field name','A','card.number'),(8,5,'error_field_code_card.number','Error: field code','A','card.expired'),(9,5,'error_field_message_card.number','Error: field message','A','Card has expired.'),(10,5,'cart_items','Cart items','A','a:1:{i:0;a:5:{s:4:\"name\";s:27:\"Caged Cutout Sandals in Gold\";s:3:\"sku\";s:6:\"10000000083\";s:5:\"price\";d:34.990000000000002;s:6:\"amount\";i:1;s:5:\"attrs\";a:0:{}}}');
CREATE TABLE `xlite_order_capost_parcel_shipment_links` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rel` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `href` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `idx` int(11) DEFAULT NULL,
  `mediaType` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `shipmentId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_EB25DE223C5EEBE2` (`shipmentId`),
  CONSTRAINT `FK_EB25DE223C5EEBE2` FOREIGN KEY (`shipmentId`) REFERENCES `xlite_order_capost_parcel_shipment` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_products` (
  `product_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_class_id` int(10) unsigned DEFAULT NULL,
  `tax_class_id` int(10) unsigned DEFAULT NULL,
  `useCustomOG` tinyint(1) NOT NULL,
  `marketPrice` decimal(14,4) NOT NULL,
  `pinCodesEnabled` tinyint(1) NOT NULL,
  `autoPinCodes` tinyint(1) NOT NULL,
  `participateSale` tinyint(1) NOT NULL,
  `discountType` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `salePriceValue` decimal(14,4) NOT NULL,
  `csLastUpdate` int(11) NOT NULL,
  `xcPendingBulkEdit` tinyint(1) NOT NULL,
  `isCustomerAttachmentsAvailable` tinyint(1) NOT NULL,
  `isCustomerAttachmentsRequired` tinyint(1) NOT NULL,
  `facebookMarketingEnabled` tinyint(1) NOT NULL DEFAULT '1',
  `freeShip` tinyint(1) NOT NULL,
  `shipForFree` tinyint(1) NOT NULL,
  `freightFixedFee` decimal(14,4) NOT NULL,
  `googleFeedEnabled` tinyint(1) NOT NULL DEFAULT '1',
  `useAsSegmentCondition` tinyint(1) NOT NULL,
  `demo` tinyint(1) NOT NULL,
  `price` decimal(14,4) NOT NULL COMMENT '(DC2Type:money)',
  `sku` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL,
  `weight` decimal(14,4) NOT NULL,
  `useSeparateBox` tinyint(1) NOT NULL,
  `boxWidth` decimal(14,4) NOT NULL,
  `boxLength` decimal(14,4) NOT NULL,
  `boxHeight` decimal(14,4) NOT NULL,
  `itemsPerBox` int(11) NOT NULL,
  `free_shipping` tinyint(1) NOT NULL,
  `taxable` tinyint(1) NOT NULL,
  `arrivalDate` int(11) NOT NULL,
  `date` int(11) NOT NULL,
  `updateDate` int(10) unsigned NOT NULL,
  `needProcess` tinyint(1) NOT NULL,
  `inventoryEnabled` tinyint(1) NOT NULL,
  `amount` int(10) unsigned NOT NULL,
  `lowLimitEnabledCustomer` tinyint(1) NOT NULL,
  `lowLimitEnabled` tinyint(1) NOT NULL,
  `lowLimitAmount` int(10) unsigned NOT NULL,
  `attrSepTab` tinyint(1) NOT NULL,
  `metaDescType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `sales` int(10) unsigned NOT NULL,
  `xcPendingExport` tinyint(1) NOT NULL,
  `entityVersion` char(36) COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`product_id`),
  KEY `IDX_2B79045921B06187` (`product_class_id`),
  KEY `IDX_2B790459A94AAAE` (`tax_class_id`),
  KEY `sku` (`sku`),
  KEY `price` (`price`),
  KEY `weight` (`weight`),
  KEY `free_shipping` (`free_shipping`),
  KEY `customerArea` (`enabled`,`arrivalDate`),
  KEY `csLastUpdate` (`csLastUpdate`),
  CONSTRAINT `FK_2B79045921B06187` FOREIGN KEY (`product_class_id`) REFERENCES `xlite_product_classes` (`id`) ON DELETE SET NULL,
  CONSTRAINT `FK_2B790459A94AAAE` FOREIGN KEY (`tax_class_id`) REFERENCES `xlite_tax_classes` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_products` VALUES (1,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,19.9900,'10000000065',1,0.7000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568813,1576568817,0,1,1000,1,1,10,1,'A',0,0,'59262f3a-5888-4cd8-b566-d4e95a81fb2a'),(2,3,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,49.9900,'10000000068',1,3.0000,0,0.0000,0.0000,0.0000,1,0,1,1575704821,1576568813,1576568817,0,1,7,1,1,10,1,'A',0,0,'5fe3d55a-c6d7-4493-a6ac-0854a8ff641d'),(3,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,19.9900,'10000000069',1,2.6000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568813,1576568819,0,1,1000,1,1,10,1,'A',2,0,'19c5b007-2e80-4d3e-939d-b1bab31de0d3'),(4,3,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,24.9900,'10000000070',1,1.3000,0,0.0000,0.0000,0.0000,1,0,1,1579160821,1576568813,1576568817,0,1,75,1,1,10,1,'A',0,0,'78455e96-4fa5-4d88-ab73-225609af2506'),(5,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,19.9900,'10000000074',1,1.8000,0,0.0000,0.0000,0.0000,1,0,1,1575704821,1576568813,1576568817,0,1,6,1,1,10,1,'A',0,0,'e70f387b-e8b3-410d-9825-f25b5669b6e7'),(6,NULL,NULL,0,0.0000,0,0,1,'sale_price',47.9900,0,0,0,0,1,0,0,0.0000,1,0,1,79.9900,'10000000076',1,2.9000,0,0.0000,0.0000,0.0000,1,0,1,1579160821,1576568813,1576568819,0,1,1000,1,1,10,1,'A',0,0,'908d1bc3-5130-4736-a46f-ae045c9db3d1'),(7,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,29.9900,'10000000079',1,0.6000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568813,1576568817,0,1,100,1,1,10,1,'A',0,0,'da6673f7-fbdf-41a0-a281-376326033d08'),(8,NULL,NULL,0,0.0000,0,0,1,'sale_price',14.9900,0,0,0,0,1,0,0,0.0000,1,0,1,19.9900,'10000000081',1,1.8000,0,0.0000,0.0000,0.0000,1,0,1,1579160821,1576568813,1576568819,0,1,146,1,1,10,1,'A',3,0,'9be3b558-387a-4b5c-bbf1-493195311eeb'),(9,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,19.9900,'10000000082',1,2.8000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568814,1576568817,0,1,218,1,1,10,1,'A',0,0,'3e05ea32-2114-4f24-b74e-d4485c2d5adc'),(10,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,34.9900,'10000000083',1,1.1000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568814,1576568817,0,1,0,1,1,10,1,'A',0,0,'ac66e6c1-7144-41f3-b5a4-8f2dcefc818f'),(11,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,14.9900,'10000000084',1,0.9000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568814,1576568817,0,1,200,1,1,10,1,'A',0,0,'35c4f309-151e-4dcb-8628-6f61825d0b87'),(12,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,9.9900,'10000000085',1,2.9000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568814,1576568819,0,1,1000,1,1,10,1,'A',6,0,'09efc6e5-c379-4015-970c-d2d39f5f90e0'),(13,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,39.9900,'10000000086',1,2.8000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568814,1576568817,0,1,6,1,1,10,1,'A',0,0,'738e97ac-eb64-42a1-858b-ccd2f33a7a93'),(14,1,NULL,0,0.0000,0,0,1,'sale_percent',15.0000,0,0,0,0,1,0,0,0.0000,1,0,1,29.9900,'10000000087',1,0.7000,0,0.0000,0.0000,0.0000,1,0,1,1575704821,1576568814,1576568819,0,1,22,1,1,10,1,'A',12,0,'b908777e-2bb1-4cd3-8329-b20baf5be3ca'),(15,NULL,NULL,0,0.0000,0,0,1,'sale_percent',25.0000,0,0,0,0,1,0,0,0.0000,1,0,1,19.9900,'10000000088',1,1.8000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568814,1576568819,0,1,300,1,1,10,1,'A',0,0,'84503add-5b06-4561-b272-068dad7c2575'),(16,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,99.0000,'10000000089',1,1.0000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568814,1576568819,0,1,999,1,1,10,1,'A',1,0,'b4cf8d6c-7d07-49ca-af89-34e88613937a'),(17,1,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,49.9900,'10000000091',1,2.1000,0,0.0000,0.0000,0.0000,1,0,1,1579160821,1576568814,1576568817,0,1,1000,1,1,10,1,'A',0,0,'759ca179-8a70-4e81-aba1-7c2eb9555cd3'),(18,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,19.9900,'10000000093',1,0.5000,0,0.0000,0.0000,0.0000,1,0,1,1579160821,1576568814,1576568817,0,1,1000,1,1,10,1,'A',0,0,'044a7a92-bc96-4ddd-b91b-46ddeaeceb33'),(19,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,9.9900,'10000000094',1,3.0000,0,0.0000,0.0000,0.0000,1,0,1,1575704821,1576568814,1576568817,0,1,12,1,1,10,1,'A',0,0,'38c44c48-1aa9-4e2b-80d6-0d43ee1bda0d'),(20,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,9.9900,'10000000095',1,1.1000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568814,1576568817,0,1,1000,1,1,10,1,'A',0,0,'1164cfbc-c1c5-4eea-a87d-f068f1f8f84a'),(21,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,29.9900,'10000000096',1,2.8000,0,0.0000,0.0000,0.0000,1,0,1,1579160821,1576568814,1576568817,0,1,200,1,1,10,1,'A',0,0,'dcca5661-57d7-471e-b761-d84e007f9bc7'),(22,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,19.9900,'10000000097',1,1.6000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568814,1576568817,0,1,1000,1,1,10,1,'A',0,0,'2760cfa1-cf74-4a51-868a-7a50b1fffc52'),(23,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,29.9900,'10000000098',1,1.0000,0,0.0000,0.0000,0.0000,1,0,1,1579160821,1576568814,1576568817,0,1,1000,1,1,10,1,'A',0,0,'dfbfceef-8b26-4380-bbc2-f27b668c7ad3'),(24,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,14.9900,'10000000099',1,2.3000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568814,1576568817,0,1,1000,1,1,10,1,'A',0,0,'69d613e7-2ff1-42df-a0ef-ee880c0602d5'),(25,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,19.9900,'10000000100',1,1.3000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568814,1576568817,0,1,4,1,1,10,1,'A',0,0,'00e36c7f-fb15-4dd6-9938-2b2eca8f28a8'),(26,NULL,NULL,0,0.0000,0,0,1,'sale_price',6.4900,0,0,0,0,1,0,0,0.0000,1,0,1,12.9900,'10000000101',1,1.3000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568814,1576568819,0,1,20,1,1,10,1,'A',7,0,'65913e5b-baad-4615-9b68-362f2343a7a0'),(27,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,69.9900,'10000000102',1,1.4000,0,0.0000,0.0000,0.0000,1,0,1,1575704821,1576568814,1576568817,0,1,10,1,1,10,1,'A',0,0,'a1dde0a2-dd1c-44cb-a789-a6bc59d38ac9'),(28,2,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,850.0000,'10000000103',1,2.5000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568814,1576568817,0,1,50,1,1,10,1,'A',0,0,'a8a85871-c1a7-419c-a0c4-d2159b8a9f66'),(29,2,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,650.0000,'10000000104',1,1.0000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568814,1576568818,0,1,1000,1,1,10,1,'A',0,0,'62df508d-4cb2-44de-aca1-1a4aa47bbc61'),(30,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,399.0000,'10000000105',1,1.1000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568814,1576568818,0,1,999,1,1,10,1,'A',0,0,'02e7dd6c-ec6d-4eb0-9ede-1b712fd9debb'),(31,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,299.0000,'10000000106',1,1.3000,0,0.0000,0.0000,0.0000,1,0,1,1575704821,1576568814,1576568818,0,1,1000,1,1,10,1,'A',0,0,'b6d28a89-2ea0-441e-b0d6-67b530d3ea95'),(32,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,79.9900,'10000000107',1,1.2000,0,0.0000,0.0000,0.0000,1,0,1,1575704821,1576568814,1576568818,0,1,10,1,1,10,1,'A',0,0,'cfe3b217-fce5-4d3a-a9ec-bf808baa8702'),(33,NULL,NULL,0,0.0000,0,0,1,'sale_price',19.9900,0,0,0,0,1,0,0,0.0000,1,0,1,49.9900,'10000000109',1,2.2000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568814,1576568819,0,1,999,1,1,10,1,'A',0,0,'32cee6c5-ed1f-4d7d-a887-d469ad312892'),(34,NULL,NULL,0,0.0000,0,0,1,'sale_price',44.9900,0,0,0,0,1,0,0,0.0000,1,0,1,59.9900,'10000000110',1,2.7000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568814,1576568819,0,1,1000,1,1,10,1,'A',0,0,'0292df19-c069-4c2d-ab27-2689d583fbea'),(35,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,299.9900,'10000000111',1,1.7000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568814,1576568818,0,1,999,1,1,10,1,'A',0,0,'fab66767-698f-40b3-95ae-98c849b14621'),(36,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,11.9900,'10000000112',1,2.0000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568814,1576568818,0,1,999,1,1,10,1,'A',0,0,'2e5a3dfa-afc6-4959-a31b-b1b7810c1da3'),(37,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,139.9900,'10000000113',1,1.7000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568814,1576568818,0,1,1000,1,1,10,1,'A',0,0,'11724d52-c161-415f-abdc-f409c7d24ee1'),(38,NULL,NULL,0,0.0000,0,0,1,'sale_price',39.9900,0,0,0,0,1,0,0,0.0000,1,0,1,49.9900,'10000000114',1,1.6000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568814,1576568819,0,1,10,1,1,10,1,'A',0,0,'d2af66c9-72eb-4e45-bb1b-38bad087e6de'),(39,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,34.9900,'10000000115',1,1.0000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568814,1576568818,0,1,1000,1,1,10,1,'A',0,0,'5c610ac4-eb9f-4d8e-beac-eb1ffb53eafa'),(40,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,817.5900,'10000000116',1,1.8000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568815,1576568818,0,1,6,1,1,10,1,'A',0,0,'83534f48-8bd7-4c5d-8f1b-e664efc77970'),(41,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,199.9900,'10000000117',1,2.1000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568815,1576568818,0,1,1000,1,1,10,1,'A',0,0,'5c4677e9-3d74-4095-8100-905aacd463fc'),(42,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,19.9900,'10000000118',1,2.6000,0,0.0000,0.0000,0.0000,1,0,1,1575704821,1576568815,1576568819,0,1,1000,1,1,10,1,'A',1,0,'76f8b21f-55c9-4533-82db-1431d3a1f354'),(43,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,12.0000,'10000000119',1,1.7000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568815,1576568818,0,1,1000,1,1,10,1,'A',0,0,'73e3f72a-bed3-4b1a-b18e-e02cd2f35c67'),(44,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,28.0000,'10000000122',1,1.4000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568815,1576568818,0,1,1000,1,1,10,1,'A',0,0,'3453a840-4664-4163-9d09-4a24ca0fa842'),(45,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,83.0000,'10000000123',1,1.8000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568815,1576568818,0,1,1000,1,1,10,1,'A',0,0,'44a7d079-b409-40f4-8f9a-dea0f55324eb'),(46,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,25.0000,'10000000124',1,1.3000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568815,1576568818,0,1,1000,1,1,10,1,'A',0,0,'0a53044a-104e-4af5-b656-5542d981e47c'),(47,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,17.0000,'10000000125',1,1.8000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568815,1576568818,0,1,1000,1,1,10,1,'A',0,0,'6faee690-ff23-4acb-a09e-a44863dc4d83'),(48,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,21.0000,'10000000126',1,2.8000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568815,1576568818,0,1,1000,1,1,10,1,'A',0,0,'d3024e08-72b2-4306-879c-eb36f963ab68'),(49,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,16.0000,'10000000127',1,1.4000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568815,1576568818,0,1,12,1,1,10,1,'A',0,0,'bb879350-b015-4393-8aea-39cef25a17e0'),(50,NULL,NULL,0,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,1,22.0000,'10000000128',1,1.7000,0,0.0000,0.0000,0.0000,1,0,1,1563608821,1576568815,1576568818,0,1,23,1,1,10,1,'A',0,0,'ed971183-e89c-493d-939f-4b027c7734bf');
CREATE TABLE `xlite_mailchimp_segment_subscriptions` (
  `segment_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `profile_id` int(11) NOT NULL,
  PRIMARY KEY (`segment_id`,`profile_id`),
  KEY `IDX_CE45B298DB296AAD` (`segment_id`),
  KEY `IDX_CE45B298CCFA12B8` (`profile_id`),
  CONSTRAINT `FK_CE45B298CCFA12B8` FOREIGN KEY (`profile_id`) REFERENCES `xlite_profiles` (`profile_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_CE45B298DB296AAD` FOREIGN KEY (`segment_id`) REFERENCES `xlite_mailchimp_list_segments` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_attribute_values_text` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned DEFAULT NULL,
  `attribute_id` int(10) unsigned DEFAULT NULL,
  `editable` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`),
  KEY `attribute_id` (`attribute_id`),
  CONSTRAINT `FK_560D03DA4584665A` FOREIGN KEY (`product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_560D03DAB6E62EFA` FOREIGN KEY (`attribute_id`) REFERENCES `xlite_attributes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_shipping_method_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `deliveryTime` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `IDX_674AA5A0BF396750` (`id`),
  CONSTRAINT `FK_674AA5A0BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_shipping_methods` (`method_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_shipping_method_translations` VALUES (1,1,'Australia Post','','en'),(2,2,'FedEx','','en'),(3,3,'FedEx Europe First International Priority','','en'),(4,4,'FedEx 1Day<sup>&reg;</sup> Freight','','en'),(5,5,'FedEx 2Day<sup>&reg;</sup>','','en'),(6,6,'FedEx 2Day AM<sup>&reg;</sup>','','en'),(7,7,'FedEx 2Day<sup>&reg;</sup> Freight','','en'),(8,8,'FedEx 3Day<sup>&reg;</sup> Freight','','en'),(9,9,'FedEx Express Saver<sup>&reg;</sup>','','en'),(10,10,'FedEx First Freight<sup>&reg;</sup>','','en'),(11,11,'FedEx Ground<sup>&reg;</sup>','','en'),(12,12,'FedEx First Overnight<sup>&reg;</sup>','','en'),(13,13,'FedEx Home Delivery<sup>&reg;</sup>','','en'),(14,14,'FedEx International Distribution<sup>&reg;</sup> Freight','','en'),(15,15,'FedEx International Economy<sup>&reg;</sup>','','en'),(16,16,'FedEx International Economy Distribution<sup>&reg;</sup>','','en'),(17,17,'FedEx International Economy<sup>&reg;</sup> Freight','','en'),(18,18,'FedEx International First<sup>&reg;</sup>','','en'),(19,19,'FedEx International Priority<sup>&reg;</sup>','','en'),(20,20,'FedEx International Priority<sup>&reg;</sup> Distribution','','en'),(21,21,'FedEx International Priority Freight<sup>&reg;</sup>','','en'),(22,22,'FedEx Priority Overnight<sup>&reg;</sup>','','en'),(23,23,'FedEx SmartPost<sup>&reg;</sup>/FedEx SmartPost<sup>&reg;</sup> International','','en'),(24,24,'FedEx Standard Overnight<sup>&reg;</sup>','','en'),(25,25,'U.S.P.S','','en'),(26,26,'U.S.P.S. First Class Mail','','en'),(27,27,'U.S.P.S. Priority Mail','','en'),(28,28,'U.S.P.S. Priority Mail Express','','en'),(29,29,'U.S.P.S. Standard Post','','en'),(30,30,'U.S.P.S. Parcel Select','','en'),(31,31,'U.S.P.S. Media Mail','','en'),(32,32,'U.S.P.S. Library Mail','','en'),(33,33,'U.S.P.S. First Class International','','en'),(34,34,'U.S.P.S. First Class Package International Service','','en'),(35,35,'U.S.P.S. Priority Mail Express International','','en'),(36,36,'U.S.P.S. Priority Mail International','','en'),(37,37,'Canada Post','','en'),(38,38,'Regular Parcel','','en'),(39,39,'Expedited Parcel','','en'),(40,40,'Xpresspost','','en'),(41,41,'Xpresspost Certified','','en'),(42,42,'Priority','','en'),(43,43,'Library Books','','en'),(44,44,'Expedited Parcel USA','','en'),(45,45,'Priority Worldwide Envelope USA','','en'),(46,46,'Priority Worldwide pak USA','','en'),(47,47,'Priority Worldwide Parcel USA','','en'),(48,48,'Small Packet USA Air','','en'),(49,49,'Tracked Packet – USA','','en'),(50,50,'Tracked Packet – USA (LVM)','','en'),(51,51,'Xpresspost USA','','en'),(52,52,'Xpresspost International','','en'),(53,53,'International Parcel Air','','en'),(54,54,'International Parcel Surface','','en'),(55,55,'Priority Worldwide Envelope International','','en'),(56,56,'Priority Worldwide pak International','','en'),(57,57,'Priority Worldwide parcel International','','en'),(58,58,'Small Packet International Air','','en'),(59,59,'Small Packet International Surface','','en'),(60,60,'Tracked Packet – International','','en'),(61,61,'UPS','','en'),(62,62,'UPS Next Day Air&reg;','','en'),(63,63,'UPS 2nd Day Air&reg;','','en'),(64,64,'UPS Ground','','en'),(65,65,'UPS Worldwide Express','','en'),(66,66,'UPS Worldwide Expedited','','en'),(67,67,'UPS Standard','','en'),(68,68,'UPS 3 Day Select&reg;','','en'),(69,69,'UPS Next Day Air Saver&reg;','','en'),(70,70,'UPS Next Day Air&reg; Early A.M.','','en'),(71,71,'UPS Worldwide Express Plus','','en'),(72,72,'UPS 2nd Day Air A.M.&reg;','','en'),(73,73,'UPS Saver','','en'),(74,74,'UPS Today StandardSM','','en'),(75,75,'UPS Today Dedicated CourrierSM','','en'),(76,76,'UPS Today Intercity','','en'),(77,77,'UPS Today Express','','en'),(78,78,'UPS Today Express Saver','','en'),(79,79,'UPS WorldWide Express Freight','','en'),(80,80,'UPS Express','','en'),(81,81,'UPS Express Plus','','en'),(82,82,'UPS ExpeditedSM','','en'),(83,83,'UPS Worldwide ExpeditedSM','','en'),(84,84,'UPS Worldwide ExpressSM','','en'),(85,85,'UPS SaverSM','','en'),(86,86,'UPS Express Early A.M. SM','','en'),(87,87,'UPS Next Day Air&reg; Early A.M. SM','','en'),(88,88,'UPS Worldwide Express PlusSM','','en'),(89,89,'Courier','2 - 4 days','en'),(90,89,'Доставка курьером','2 - 4 дня','ru'),(91,90,'Local shipping','up to one week','en'),(92,90,'Местная доставка','до одной недели','ru'),(93,91,'One day shipping','1 day','en'),(94,91,'Экспресс доставка','1 день','ru'),(95,92,'Local pickup','','en'),(96,92,'Самовывоз','','ru'),(97,93,'Free shipping on orders over $50','','en'),(98,93,'Бесплатная доставка при заказе от $50','','ru'),(99,94,'Free shipping','5 - 7 days','en'),(100,94,'Бесплатная доставка','5 - 7 дней','ru'),(101,95,'Fixed rate shipping','5 - 7 days','en'),(102,95,'Фиксированная стоимость доставки','5 - 7 дней','ru');
CREATE TABLE `xlite_capost_return_links` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rel` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `href` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `idx` int(11) DEFAULT NULL,
  `mediaType` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `returnId` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_33BC6A621B43D59E` (`returnId`),
  CONSTRAINT `FK_33BC6A621B43D59E` FOREIGN KEY (`returnId`) REFERENCES `xlite_capost_returns` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_profiles` (
  `profile_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  `membership_id` int(10) unsigned DEFAULT NULL,
  `pending_membership_id` int(10) unsigned DEFAULT NULL,
  `socialLoginProvider` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `socialLoginId` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `gaClientId` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `braintree_customer_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `saveCardBoxChecked` tinyint(1) NOT NULL,
  `conciergeUserId` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `xpaymentsCustomerId` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `login` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `password` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `password_hint` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `password_hint_answer` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `passwordResetKey` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `passwordResetKeyDate` int(11) NOT NULL,
  `access_level` int(11) NOT NULL,
  `cms_profile_id` int(11) NOT NULL,
  `cms_name` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `added` int(11) NOT NULL,
  `first_login` int(11) NOT NULL,
  `last_login` int(11) NOT NULL,
  `status` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `statusComment` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `referer` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `language` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `last_shipping_id` int(11) DEFAULT NULL,
  `last_payment_id` int(11) DEFAULT NULL,
  `anonymous` tinyint(1) NOT NULL,
  `forceChangePassword` tinyint(1) NOT NULL,
  `dateOfLoginAttempt` int(10) unsigned NOT NULL,
  `countOfLoginAttempts` int(11) NOT NULL,
  `searchFakeField` longtext COLLATE utf8_unicode_ci,
  `xcPendingExport` tinyint(1) NOT NULL,
  `lastCheckoutEmail` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`profile_id`),
  UNIQUE KEY `UNIQ_13F3DB338D9F6D38` (`order_id`),
  KEY `IDX_13F3DB331FB354CD` (`membership_id`),
  KEY `IDX_13F3DB33CD228392` (`pending_membership_id`),
  KEY `cms_profile` (`cms_name`,`cms_profile_id`),
  KEY `login` (`login`),
  KEY `order_id` (`order_id`),
  KEY `password` (`password`),
  KEY `access_level` (`access_level`),
  KEY `first_login` (`first_login`),
  KEY `last_login` (`last_login`),
  KEY `status` (`status`),
  CONSTRAINT `FK_13F3DB331FB354CD` FOREIGN KEY (`membership_id`) REFERENCES `xlite_memberships` (`membership_id`) ON DELETE SET NULL,
  CONSTRAINT `FK_13F3DB338D9F6D38` FOREIGN KEY (`order_id`) REFERENCES `xlite_orders` (`order_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_13F3DB33CD228392` FOREIGN KEY (`pending_membership_id`) REFERENCES `xlite_memberships` (`membership_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_profiles` VALUES (1,NULL,NULL,NULL,NULL,NULL,'','',0,NULL,'','bit-bucket@example.com','084e0343a0486ff05530df6c705c8bb4','','','',0,0,0,'',1576568818,0,0,'E','','','en',NULL,NULL,1,0,0,0,'Guest Guest Guest;bit-bucket@example.com',0,''),(2,1,NULL,NULL,NULL,NULL,'','',0,NULL,'','bit-bucket@example.com','084e0343a0486ff05530df6c705c8bb4','','','',0,0,0,'',1576568818,0,0,'E','','','en',NULL,NULL,1,0,0,0,'Guest Guest Guest;bit-bucket@example.com',0,''),(3,2,NULL,NULL,NULL,NULL,'','',0,NULL,'','bit-bucket@example.com','084e0343a0486ff05530df6c705c8bb4','','','',0,0,0,'',1576568818,0,0,'E','','','en',NULL,NULL,1,0,0,0,'Guest Guest Guest;bit-bucket@example.com',0,''),(4,3,NULL,NULL,NULL,NULL,'','',0,NULL,'','bit-bucket@example.com','084e0343a0486ff05530df6c705c8bb4','','','',0,0,0,'',1576568818,0,0,'E','','','en',NULL,NULL,1,0,0,0,'Guest Guest Guest;bit-bucket@example.com',0,''),(5,4,NULL,NULL,NULL,NULL,'','',0,NULL,'','bit-bucket@example.com','084e0343a0486ff05530df6c705c8bb4','','','',0,0,0,'',1576568819,0,0,'E','','','en',NULL,NULL,1,0,0,0,'Guest Guest Guest;bit-bucket@example.com',0,''),(6,5,NULL,NULL,NULL,NULL,'','',0,NULL,'','bit-bucket@example.com','084e0343a0486ff05530df6c705c8bb4','','','',0,0,0,'',1576568819,0,0,'E','','','en',NULL,NULL,1,0,0,0,'Guest Guest Guest;bit-bucket@example.com',0,'');
CREATE TABLE `xlite_mailchimp_list_group` (
  `id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `list_id` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `title` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_2F783133DAE168B` (`list_id`),
  CONSTRAINT `FK_2F783133DAE168B` FOREIGN KEY (`list_id`) REFERENCES `xlite_mailchimp_lists` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_sessions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sid` char(32) COLLATE utf8_unicode_ci NOT NULL,
  `expiry` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sid` (`sid`),
  KEY `expiry` (`expiry`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_overridden_view_lists` (
  `listHash` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `listData` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`listHash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_segment_products` (
  `segment_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`segment_id`,`product_id`),
  KEY `IDX_768E358DDB296AAD` (`segment_id`),
  KEY `IDX_768E358D4584665A` (`product_id`),
  CONSTRAINT `FK_768E358D4584665A` FOREIGN KEY (`product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_768E358DDB296AAD` FOREIGN KEY (`segment_id`) REFERENCES `xlite_mailchimp_list_segments` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_attribute_values_hidden` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_option_id` int(10) unsigned DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  `attribute_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`),
  KEY `attribute_id` (`attribute_id`),
  KEY `attribute_option_id` (`attribute_option_id`),
  CONSTRAINT `FK_A68A8FD61AE56DE9` FOREIGN KEY (`attribute_option_id`) REFERENCES `xlite_attribute_options` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_A68A8FD64584665A` FOREIGN KEY (`product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_A68A8FD6B6E62EFA` FOREIGN KEY (`attribute_id`) REFERENCES `xlite_attributes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_payment_methods` (
  `method_id` int(11) NOT NULL AUTO_INCREMENT,
  `service_name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `class` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `moduleName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `orderby` int(11) NOT NULL,
  `adminOrderby` int(11) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `added` tinyint(1) NOT NULL,
  `type` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `fromMarketplace` tinyint(1) NOT NULL,
  `iconURL` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `countries` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:array)',
  `exCountries` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:array)',
  PRIMARY KEY (`method_id`),
  KEY `orderby` (`orderby`),
  KEY `class` (`class`,`enabled`),
  KEY `enabled` (`enabled`),
  KEY `serviceName` (`service_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_payment_methods` VALUES (1,'PurchaseOrder','Model\\Payment\\Processor\\PurchaseOrder','',20,0,0,1,'O',0,NULL,'N;','N;'),(2,'PhoneOrdering','Model\\Payment\\Processor\\PhoneOrdering','',30,0,1,1,'O',0,NULL,'N;','N;'),(3,'FaxOrdering','Model\\Payment\\Processor\\Offline','',40,0,1,1,'O',0,NULL,'N;','N;'),(4,'MoneyOrdering','Model\\Payment\\Processor\\Offline','',50,0,1,1,'O',0,NULL,'N;','N;'),(5,'Echeck','Model\\Payment\\Processor\\Check','',60,0,0,1,'O',0,NULL,'N;','N;'),(6,'COD','Model\\Payment\\Processor\\Offline','',70,0,1,1,'O',0,NULL,'N;','N;'),(7,'PayWithAmazon','Module\\Amazon\\PayWithAmazon\\Model\\Payment\\Processor\\PayWithAmazon','Amazon_PayWithAmazon',-101600,-101600,0,0,'C',0,NULL,'a:4:{i:0;s:2:\"US\";i:1;s:2:\"GB\";i:2;s:2:\"DE\";i:3;s:2:\"JP\";}','N;'),(8,'AuthorizeNet SIM','Module\\CDev\\AuthorizeNet\\Model\\Payment\\Processor\\AuthorizeNetSIM','CDev_AuthorizeNet',-101000,0,0,0,'C',0,NULL,'a:36:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"AU\";i:3;s:2:\"GB\";i:4;s:2:\"AD\";i:5;s:2:\"AT\";i:6;s:2:\"BE\";i:7;s:2:\"BG\";i:8;s:2:\"CY\";i:9;s:2:\"CZ\";i:10;s:2:\"DK\";i:11;s:2:\"FI\";i:12;s:2:\"FR\";i:13;s:2:\"DE\";i:14;s:2:\"GI\";i:15;s:2:\"GR\";i:16;s:2:\"HU\";i:17;s:2:\"IE\";i:18;s:2:\"IT\";i:19;s:2:\"LI\";i:20;s:2:\"LU\";i:21;s:2:\"MT\";i:22;s:2:\"MC\";i:23;s:2:\"NL\";i:24;s:2:\"NO\";i:25;s:2:\"PL\";i:26;s:2:\"PT\";i:27;s:2:\"RO\";i:28;s:2:\"SE\";i:29;s:2:\"SI\";i:30;s:2:\"SK\";i:31;s:2:\"SM\";i:32;s:2:\"CH\";i:33;s:2:\"ES\";i:34;s:2:\"VA\";i:35;s:2:\"TR\";}','N;'),(9,'COD_FEDEX','Module\\CDev\\FedEx\\Model\\Payment\\Processor\\COD','CDev_FedEx',0,0,0,1,'O',0,NULL,'a:2:{i:0;s:2:\"CA\";i:1;s:2:\"US\";}','N;'),(10,'PayflowLink','Module\\CDev\\Paypal\\Model\\Payment\\Processor\\PayflowLink','CDev_Paypal',-10600,0,0,0,'C',0,NULL,'a:4:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"AU\";i:3;s:2:\"NZ\";}','N;'),(11,'PayflowTransparentRedirect','Module\\CDev\\Paypal\\Model\\Payment\\Processor\\PayflowTransparentRedirect','CDev_Paypal',-10650,0,0,0,'C',0,NULL,'a:4:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"AU\";i:3;s:2:\"NZ\";}','N;'),(12,'PaypalAdvanced','Module\\CDev\\Paypal\\Model\\Payment\\Processor\\PaypalAdvanced','CDev_Paypal',-10700,0,0,0,'C',0,NULL,'a:2:{i:0;s:2:\"US\";i:1;s:2:\"CA\";}','N;'),(13,'PaypalWPS','Module\\CDev\\Paypal\\Model\\Payment\\Processor\\PaypalWPS','CDev_Paypal',-10800,0,0,0,'A',0,NULL,'a:202:{i:0;s:2:\"DZ\";i:1;s:2:\"AO\";i:2;s:2:\"BJ\";i:3;s:2:\"BW\";i:4;s:2:\"BF\";i:5;s:2:\"BI\";i:6;s:2:\"CM\";i:7;s:2:\"CV\";i:8;s:2:\"TD\";i:9;s:2:\"KM\";i:10;s:2:\"CI\";i:11;s:2:\"CD\";i:12;s:2:\"DJ\";i:13;s:2:\"EG\";i:14;s:2:\"ER\";i:15;s:2:\"ET\";i:16;s:2:\"GA\";i:17;s:2:\"GM\";i:18;s:2:\"GN\";i:19;s:2:\"GW\";i:20;s:2:\"KE\";i:21;s:2:\"LS\";i:22;s:2:\"MG\";i:23;s:2:\"MW\";i:24;s:2:\"ML\";i:25;s:2:\"MR\";i:26;s:2:\"MU\";i:27;s:2:\"YT\";i:28;s:2:\"MA\";i:29;s:2:\"MZ\";i:30;s:2:\"NA\";i:31;s:2:\"NE\";i:32;s:2:\"NG\";i:33;s:2:\"CG\";i:34;s:2:\"RE\";i:35;s:2:\"RW\";i:36;s:2:\"SH\";i:37;s:2:\"ST\";i:38;s:2:\"SN\";i:39;s:2:\"SC\";i:40;s:2:\"SL\";i:41;s:2:\"SO\";i:42;s:2:\"ZA\";i:43;s:2:\"SZ\";i:44;s:2:\"TZ\";i:45;s:2:\"TG\";i:46;s:2:\"TN\";i:47;s:2:\"UG\";i:48;s:2:\"ZM\";i:49;s:2:\"ZW\";i:50;s:2:\"AI\";i:51;s:2:\"AG\";i:52;s:2:\"AR\";i:53;s:2:\"AW\";i:54;s:2:\"BS\";i:55;s:2:\"BB\";i:56;s:2:\"BZ\";i:57;s:2:\"BM\";i:58;s:2:\"BO\";i:59;s:2:\"BR\";i:60;s:2:\"VG\";i:61;s:2:\"CA\";i:62;s:2:\"KY\";i:63;s:2:\"CL\";i:64;s:2:\"CO\";i:65;s:2:\"CR\";i:66;s:2:\"DM\";i:67;s:2:\"DO\";i:68;s:2:\"EC\";i:69;s:2:\"SV\";i:70;s:2:\"FK\";i:71;s:2:\"GF\";i:72;s:2:\"GL\";i:73;s:2:\"GD\";i:74;s:2:\"GP\";i:75;s:2:\"GT\";i:76;s:2:\"GY\";i:77;s:2:\"HN\";i:78;s:2:\"JM\";i:79;s:2:\"MQ\";i:80;s:2:\"MX\";i:81;s:2:\"MS\";i:82;s:2:\"NA\";i:83;s:2:\"NI\";i:84;s:2:\"PA\";i:85;s:2:\"PY\";i:86;s:2:\"PE\";i:87;s:2:\"KN\";i:88;s:2:\"LC\";i:89;s:2:\"PM\";i:90;s:2:\"VC\";i:91;s:2:\"SR\";i:92;s:2:\"TT\";i:93;s:2:\"TC\";i:94;s:2:\"US\";i:95;s:2:\"UY\";i:96;s:2:\"VE\";i:97;s:2:\"AM\";i:98;s:2:\"AU\";i:99;s:2:\"BH\";i:100;s:2:\"BT\";i:101;s:2:\"BN\";i:102;s:2:\"KH\";i:103;s:2:\"CN\";i:104;s:2:\"CK\";i:105;s:2:\"FJ\";i:106;s:2:\"PF\";i:107;s:2:\"HK\";i:108;s:2:\"IN\";i:109;s:2:\"ID\";i:110;s:2:\"IL\";i:111;s:2:\"JP\";i:112;s:2:\"JO\";i:113;s:2:\"KZ\";i:114;s:2:\"KI\";i:115;s:2:\"KW\";i:116;s:2:\"KG\";i:117;s:2:\"LA\";i:118;s:2:\"MY\";i:119;s:2:\"MV\";i:120;s:2:\"MH\";i:121;s:2:\"FM\";i:122;s:2:\"MN\";i:123;s:2:\"NR\";i:124;s:2:\"NP\";i:125;s:2:\"NC\";i:126;s:2:\"NZ\";i:127;s:2:\"NU\";i:128;s:2:\"NF\";i:129;s:2:\"OM\";i:130;s:2:\"PW\";i:131;s:2:\"PG\";i:132;s:2:\"PH\";i:133;s:2:\"PN\";i:134;s:2:\"QA\";i:135;s:2:\"WS\";i:136;s:2:\"SA\";i:137;s:2:\"SG\";i:138;s:2:\"SB\";i:139;s:2:\"KR\";i:140;s:2:\"LK\";i:141;s:2:\"TW\";i:142;s:2:\"TJ\";i:143;s:2:\"TH\";i:144;s:2:\"TO\";i:145;s:2:\"TM\";i:146;s:2:\"TV\";i:147;s:2:\"AE\";i:148;s:2:\"VU\";i:149;s:2:\"VN\";i:150;s:2:\"WF\";i:151;s:2:\"YE\";i:152;s:2:\"AL\";i:153;s:2:\"AD\";i:154;s:2:\"AT\";i:155;s:2:\"AZ\";i:156;s:2:\"BY\";i:157;s:2:\"BE\";i:158;s:2:\"BA\";i:159;s:2:\"BG\";i:160;s:2:\"HR\";i:161;s:2:\"CY\";i:162;s:2:\"CZ\";i:163;s:2:\"DK\";i:164;s:2:\"EE\";i:165;s:2:\"FO\";i:166;s:2:\"FI\";i:167;s:2:\"FR\";i:168;s:2:\"GE\";i:169;s:2:\"DE\";i:170;s:2:\"GI\";i:171;s:2:\"GR\";i:172;s:2:\"HU\";i:173;s:2:\"IS\";i:174;s:2:\"IE\";i:175;s:2:\"IT\";i:176;s:2:\"LV\";i:177;s:2:\"LI\";i:178;s:2:\"LT\";i:179;s:2:\"LU\";i:180;s:2:\"MK\";i:181;s:2:\"MT\";i:182;s:2:\"MD\";i:183;s:2:\"MC\";i:184;s:2:\"ME\";i:185;s:2:\"NL\";i:186;s:2:\"NO\";i:187;s:2:\"PL\";i:188;s:2:\"PT\";i:189;s:2:\"RO\";i:190;s:2:\"RU\";i:191;s:2:\"SM\";i:192;s:2:\"RS\";i:193;s:2:\"SK\";i:194;s:2:\"SI\";i:195;s:2:\"ES\";i:196;s:2:\"SJ\";i:197;s:2:\"SE\";i:198;s:2:\"CH\";i:199;s:2:\"UA\";i:200;s:2:\"GB\";i:201;s:2:\"VA\";}','N;'),(14,'ExpressCheckout','Module\\CDev\\Paypal\\Model\\Payment\\Processor\\ExpressCheckout','CDev_Paypal',-102000,0,0,1,'C',0,NULL,'a:23:{i:0;s:2:\"US\";i:1;s:2:\"MX\";i:2;s:2:\"BE\";i:3;s:2:\"DK\";i:4;s:2:\"FR\";i:5;s:2:\"DE\";i:6;s:2:\"IE\";i:7;s:2:\"IT\";i:8;s:2:\"LU\";i:9;s:2:\"NL\";i:10;s:2:\"NO\";i:11;s:2:\"PL\";i:12;s:2:\"RU\";i:13;s:2:\"ES\";i:14;s:2:\"NZ\";i:15;s:2:\"SE\";i:16;s:2:\"GB\";i:17;s:2:\"AU\";i:18;s:2:\"CN\";i:19;s:2:\"IL\";i:20;s:2:\"SG\";i:21;s:2:\"BR\";i:22;s:2:\"JP\";}','N;'),(15,'PaypalCredit','Module\\CDev\\Paypal\\Model\\Payment\\Processor\\PaypalCredit','CDev_Paypal',-11000,0,0,1,'C',0,NULL,'a:2:{i:0;s:2:\"US\";i:1;s:2:\"CA\";}','N;'),(16,'PaypalAdaptive','Module\\CDev\\Paypal\\Model\\Payment\\Processor\\PaypalAdaptive','CDev_Paypal',-11100,0,0,0,'C',0,NULL,'N;','N;'),(17,'PaypalForMarketplaces','Module\\CDev\\Paypal\\Model\\Payment\\Processor\\PaypalForMarketplaces','CDev_Paypal',-11100,0,0,0,'C',0,NULL,'a:27:{i:0;s:2:\"AT\";i:1;s:2:\"AU\";i:2;s:2:\"BE\";i:3;s:2:\"CA\";i:4;s:2:\"CH\";i:5;s:2:\"CZ\";i:6;s:2:\"DE\";i:7;s:2:\"DK\";i:8;s:2:\"ES\";i:9;s:2:\"FI\";i:10;s:2:\"FR\";i:11;s:2:\"GB\";i:12;s:2:\"GB\";i:13;s:2:\"GR\";i:14;s:2:\"HU\";i:15;s:2:\"IE\";i:16;s:2:\"IL\";i:17;s:2:\"IN\";i:18;s:2:\"IT\";i:19;s:2:\"NL\";i:20;s:2:\"NO\";i:21;s:2:\"PL\";i:22;s:2:\"PT\";i:23;s:2:\"RU\";i:24;s:2:\"SE\";i:25;s:2:\"SK\";i:26;s:2:\"US\";}','N;'),(18,'QuantumGateway','Module\\CDev\\Quantum\\Model\\Payment\\Processor\\Quantum','CDev_Quantum',-10000,0,0,0,'C',0,NULL,'a:1:{i:0;s:2:\"US\";}','N;'),(19,'2Checkout.com','Module\\CDev\\TwoCheckout\\Model\\Payment\\Processor\\TwoCheckout','CDev_TwoCheckout',-10500,0,0,0,'C',0,NULL,'a:239:{i:0;s:2:\"AI\";i:1;s:2:\"AW\";i:2;s:2:\"BB\";i:3;s:2:\"BZ\";i:4;s:2:\"BM\";i:5;s:2:\"BQ\";i:6;s:2:\"CA\";i:7;s:2:\"KY\";i:8;s:2:\"CR\";i:9;s:2:\"CW\";i:10;s:2:\"DM\";i:11;s:2:\"DO\";i:12;s:2:\"SV\";i:13;s:2:\"GD\";i:14;s:2:\"GT\";i:15;s:2:\"HT\";i:16;s:2:\"HN\";i:17;s:2:\"MQ\";i:18;s:2:\"MX\";i:19;s:2:\"MS\";i:20;s:2:\"PA\";i:21;s:2:\"KN\";i:22;s:2:\"LC\";i:23;s:2:\"PM\";i:24;s:2:\"VC\";i:25;s:2:\"TC\";i:26;s:2:\"US\";i:27;s:2:\"VG\";i:28;s:2:\"VI\";i:29;s:2:\"AS\";i:30;s:2:\"AG\";i:31;s:2:\"BS\";i:32;s:2:\"GP\";i:33;s:2:\"JM\";i:34;s:2:\"NI\";i:35;s:2:\"PR\";i:36;s:2:\"TT\";i:37;s:2:\"UM\";i:38;s:2:\"AX\";i:39;s:2:\"AL\";i:40;s:2:\"AD\";i:41;s:2:\"AM\";i:42;s:2:\"AT\";i:43;s:2:\"AZ\";i:44;s:2:\"BY\";i:45;s:2:\"BE\";i:46;s:2:\"BA\";i:47;s:2:\"BV\";i:48;s:2:\"BG\";i:49;s:2:\"HR\";i:50;s:2:\"CZ\";i:51;s:2:\"DK\";i:52;s:2:\"EE\";i:53;s:2:\"FI\";i:54;s:2:\"FR\";i:55;s:2:\"TF\";i:56;s:2:\"DE\";i:57;s:2:\"GI\";i:58;s:2:\"GR\";i:59;s:2:\"GG\";i:60;s:2:\"HU\";i:61;s:2:\"IS\";i:62;s:2:\"IE\";i:63;s:2:\"IM\";i:64;s:2:\"IT\";i:65;s:2:\"JE\";i:66;s:2:\"LV\";i:67;s:2:\"LI\";i:68;s:2:\"LT\";i:69;s:2:\"LU\";i:70;s:2:\"MK\";i:71;s:2:\"MT\";i:72;s:2:\"MD\";i:73;s:2:\"MC\";i:74;s:2:\"ME\";i:75;s:2:\"NL\";i:76;s:2:\"NO\";i:77;s:2:\"PL\";i:78;s:2:\"PT\";i:79;s:2:\"RO\";i:80;s:2:\"RU\";i:81;s:2:\"SM\";i:82;s:2:\"RS\";i:83;s:2:\"SK\";i:84;s:2:\"SI\";i:85;s:2:\"ES\";i:86;s:2:\"SJ\";i:87;s:2:\"SE\";i:88;s:2:\"CH\";i:89;s:2:\"UA\";i:90;s:2:\"GB\";i:91;s:2:\"VA\";i:92;s:2:\"FO\";i:93;s:2:\"GF\";i:94;s:2:\"GE\";i:95;s:2:\"GL\";i:96;s:2:\"KZ\";i:97;s:2:\"MF\";i:98;s:2:\"TR\";i:99;s:2:\"AU\";i:100;s:2:\"BD\";i:101;s:2:\"BT\";i:102;s:2:\"IO\";i:103;s:2:\"CN\";i:104;s:2:\"CX\";i:105;s:2:\"CC\";i:106;s:2:\"CK\";i:107;s:2:\"PF\";i:108;s:2:\"GU\";i:109;s:2:\"HM\";i:110;s:2:\"HK\";i:111;s:2:\"IN\";i:112;s:2:\"ID\";i:113;s:2:\"JP\";i:114;s:2:\"KI\";i:115;s:2:\"KR\";i:116;s:2:\"LA\";i:117;s:2:\"MO\";i:118;s:2:\"MY\";i:119;s:2:\"MH\";i:120;s:2:\"FM\";i:121;s:2:\"MN\";i:122;s:2:\"NR\";i:123;s:2:\"NP\";i:124;s:2:\"NZ\";i:125;s:2:\"NU\";i:126;s:2:\"NF\";i:127;s:2:\"PK\";i:128;s:2:\"PW\";i:129;s:2:\"PG\";i:130;s:2:\"PH\";i:131;s:2:\"PN\";i:132;s:2:\"WS\";i:133;s:2:\"SG\";i:134;s:2:\"SB\";i:135;s:2:\"LK\";i:136;s:2:\"TW\";i:137;s:2:\"TH\";i:138;s:2:\"TK\";i:139;s:2:\"TO\";i:140;s:2:\"TV\";i:141;s:2:\"VN\";i:142;s:2:\"WF\";i:143;s:2:\"BN\";i:144;s:2:\"KH\";i:145;s:2:\"FJ\";i:146;s:2:\"MV\";i:147;s:2:\"NC\";i:148;s:2:\"MP\";i:149;s:2:\"TL\";i:150;s:2:\"VU\";i:151;s:2:\"AO\";i:152;s:2:\"BH\";i:153;s:2:\"BF\";i:154;s:2:\"BI\";i:155;s:2:\"CV\";i:156;s:2:\"CF\";i:157;s:2:\"TD\";i:158;s:2:\"KM\";i:159;s:2:\"CG\";i:160;s:2:\"CD\";i:161;s:2:\"CY\";i:162;s:2:\"DJ\";i:163;s:2:\"EG\";i:164;s:2:\"GQ\";i:165;s:2:\"ER\";i:166;s:2:\"ET\";i:167;s:2:\"GM\";i:168;s:2:\"IL\";i:169;s:2:\"JO\";i:170;s:2:\"KE\";i:171;s:2:\"XK\";i:172;s:2:\"KW\";i:173;s:2:\"KG\";i:174;s:2:\"LB\";i:175;s:2:\"LS\";i:176;s:2:\"LR\";i:177;s:2:\"MG\";i:178;s:2:\"MW\";i:179;s:2:\"MR\";i:180;s:2:\"MU\";i:181;s:2:\"YT\";i:182;s:2:\"MA\";i:183;s:2:\"NE\";i:184;s:2:\"NG\";i:185;s:2:\"OM\";i:186;s:2:\"PS\";i:187;s:2:\"ST\";i:188;s:2:\"SA\";i:189;s:2:\"SL\";i:190;s:2:\"SO\";i:191;s:2:\"GS\";i:192;s:2:\"ZA\";i:193;s:2:\"TG\";i:194;s:2:\"AE\";i:195;s:2:\"UZ\";i:196;s:2:\"EH\";i:197;s:2:\"ZM\";i:198;s:2:\"ZW\";i:199;s:2:\"AF\";i:200;s:2:\"DZ\";i:201;s:2:\"BJ\";i:202;s:2:\"BW\";i:203;s:2:\"CM\";i:204;s:2:\"GA\";i:205;s:2:\"GH\";i:206;s:2:\"GN\";i:207;s:2:\"GW\";i:208;s:2:\"ML\";i:209;s:2:\"MZ\";i:210;s:2:\"NA\";i:211;s:2:\"QA\";i:212;s:2:\"RE\";i:213;s:2:\"RW\";i:214;s:2:\"SN\";i:215;s:2:\"SC\";i:216;s:2:\"SZ\";i:217;s:2:\"TJ\";i:218;s:2:\"TZ\";i:219;s:2:\"TN\";i:220;s:2:\"TM\";i:221;s:2:\"UG\";i:222;s:2:\"YE\";i:223;s:2:\"XA\";i:224;s:2:\"AR\";i:225;s:2:\"BR\";i:226;s:2:\"CL\";i:227;s:2:\"CO\";i:228;s:2:\"EC\";i:229;s:2:\"FK\";i:230;s:2:\"GY\";i:231;s:2:\"PY\";i:232;s:2:\"PE\";i:233;s:2:\"SH\";i:234;s:2:\"SR\";i:235;s:2:\"UY\";i:236;s:2:\"BO\";i:237;s:2:\"VE\";i:238;s:2:\"SX\";}','N;'),(20,'COD_USPS','Module\\CDev\\USPS\\Model\\Payment\\Processor\\COD','CDev_USPS',0,0,0,1,'O',0,NULL,'a:1:{i:0;s:2:\"US\";}','N;'),(21,'AuthorizenetAcceptjs','Module\\QSL\\AuthorizenetAcceptjs\\Model\\Payment\\Processor\\AuthorizenetAcceptjs','QSL_AuthorizenetAcceptjs',-101800,-101800,0,1,'C',0,NULL,'a:1:{i:0;s:2:\"US\";}','N;'),(22,'PayPal powered by Braintree','Module\\QSL\\BraintreeVZ\\Model\\Payment\\Processor\\BraintreeVZ','QSL_BraintreeVZ',-101950,-101950,0,0,'A',0,NULL,'a:5:{i:0;s:2:\"US\";i:1;s:2:\"UK\";i:2;s:2:\"FR\";i:3;s:2:\"IT\";i:4;s:2:\"ES\";}','N;'),(23,'ePDQ e-Commerce','Module\\XC\\EPDQ\\Model\\Payment\\Processor\\EPDQ','XC_EPDQ',-10200,0,0,0,'C',0,NULL,'a:1:{i:0;s:2:\"GB\";}','N;'),(24,'Moneris (eSELECTplus- Hosted Pay Page)','Module\\XC\\ESelectHPP\\Model\\Payment\\Processor\\ESelectHPP','XC_ESelectHPP',0,0,0,0,'C',0,NULL,'a:1:{i:0;s:2:\"CA\";}','N;'),(25,'iDEAL Professional','Module\\XC\\IdealPayments\\Model\\Payment\\Processor\\IdealProfessional','XC_IdealPayments',-10100,0,0,0,'C',0,NULL,'a:9:{i:0;s:2:\"NL\";i:1;s:2:\"DE\";i:2;s:2:\"GB\";i:3;s:2:\"FR\";i:4;s:2:\"BE\";i:5;s:2:\"MT\";i:6;s:2:\"BG\";i:7;s:2:\"LU\";i:8;s:2:\"SE\";}','N;'),(26,'SagePay form protocol','Module\\XC\\SagePay\\Model\\Payment\\Processor\\SagePayForm','XC_SagePay',-101500,0,0,0,'C',0,NULL,'a:2:{i:0;s:2:\"GB\";i:1;s:2:\"IE\";}','N;'),(27,'Stripe','Module\\XC\\Stripe\\Model\\Payment\\Stripe','XC_Stripe',-10300,0,0,0,'C',0,NULL,'a:32:{i:0;s:2:\"AT\";i:1;s:2:\"AU\";i:2;s:2:\"BE\";i:3;s:2:\"BR\";i:4;s:2:\"CA\";i:5;s:2:\"CH\";i:6;s:2:\"DE\";i:7;s:2:\"DK\";i:8;s:2:\"EE\";i:9;s:2:\"ES\";i:10;s:2:\"FI\";i:11;s:2:\"FR\";i:12;s:2:\"GB\";i:13;s:2:\"GR\";i:14;s:2:\"HK\";i:15;s:2:\"IE\";i:16;s:2:\"IN\";i:17;s:2:\"IT\";i:18;s:2:\"JP\";i:19;s:2:\"LT\";i:20;s:2:\"LU\";i:21;s:2:\"LV\";i:22;s:2:\"MX\";i:23;s:2:\"MY\";i:24;s:2:\"NL\";i:25;s:2:\"NO\";i:26;s:2:\"NZ\";i:27;s:2:\"PL\";i:28;s:2:\"PT\";i:29;s:2:\"SE\";i:30;s:2:\"SG\";i:31;s:2:\"US\";}','N;'),(28,'COD_UPS','Module\\XC\\UPS\\Model\\Payment\\Processor\\COD','XC_UPS',0,0,0,1,'O',0,NULL,'a:2:{i:0;s:2:\"US\";i:1;s:2:\"PR\";}','N;'),(29,'XPaymentsCloud','Module\\XPay\\XPaymentsCloud\\Model\\Payment\\Processor\\XPaymentsCloud','XPay_XPaymentsCloud',0,0,0,1,'C',0,NULL,'N;','N;');
CREATE TABLE `xlite_access_control_entity_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_access_control_entity_types` VALUES (1,'\\XLite\\Model\\Order');
CREATE TABLE `xlite_images_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `model` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `moduleName` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `width` int(11) NOT NULL,
  `height` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code_model_module` (`code`,`model`,`moduleName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_images_settings` VALUES (1,'Default','XLite\\Model\\Image\\Product\\Image','standard',300,300),(2,'LGThumbnailList','XLite\\Model\\Image\\Product\\Image','standard',160,160),(3,'LGThumbnailGrid','XLite\\Model\\Image\\Product\\Image','standard',160,160),(4,'Default','XLite\\Model\\Image\\Category\\Image','standard',160,160),(5,'Default','XLite\\Model\\Image\\Common\\Logo','standard',180,66),(6,'Default','XLite\\Model\\Image\\Category\\Image','XC-CrispWhiteSkin',100,120),(7,'LGThumbnailGrid','XLite\\Model\\Image\\Product\\Image','XC-CrispWhiteSkin',262,280),(8,'LGThumbnailList','XLite\\Model\\Image\\Product\\Image','XC-CrispWhiteSkin',262,280),(9,'Default','XLite\\Model\\Image\\Product\\Image','XC-CrispWhiteSkin',366,440),(10,'Default','XLite\\Model\\Image\\Common\\Logo','XC-CrispWhiteSkin',221,40);
CREATE TABLE `xlite_attribute_group_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_8C43909EBF396750` FOREIGN KEY (`id`) REFERENCES `xlite_attribute_groups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_attribute_group_translations` VALUES (1,1,'Display','en'),(2,2,'Cellular and Wireless','en'),(3,3,'Power and Battery','en'),(4,1,'Дисплей','ru'),(5,2,'Сотовая и беспроводняа связь','ru'),(6,3,'Батарея','ru');
CREATE TABLE `xlite_tax_classes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `position` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_payment_method_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8_unicode_ci NOT NULL,
  `adminDescription` longtext COLLATE utf8_unicode_ci NOT NULL,
  `altAdminDescription` longtext COLLATE utf8_unicode_ci NOT NULL,
  `instruction` longtext COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_9FBF065BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_payment_methods` (`method_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_payment_method_translations` VALUES (1,1,'Purchase Order','','','','','','en'),(2,1,'Заказ-наряд','','Оформить заказ на поставку товара','','','','ru'),(3,2,'Phone Ordering','','Phone: (555) 555-5555','','','','en'),(4,2,'Заказ по телефону','','Тел. (555) 555-5555','','','','ru'),(5,3,'Fax Ordering','','Fax: (555) 555-5555','','','','en'),(6,3,'Заказ по факсу','','','','','','ru'),(7,4,'Money Order','','US Banks Only','','','','en'),(8,4,'Денежный перевод','','Оплата через отделение банка','','','','ru'),(9,5,'Check','','Check payment','','','','en'),(10,5,'Чек','','Оплата банковским чеком','','','','ru'),(11,6,'COD','','Cash On Delivery','','','','en'),(12,6,'Наложенный платеж','','Оплата товара при получении','','','','ru'),(13,7,'Amazon Pay','','','','','','en'),(14,8,'Authorize.Net SIM','','','','','','en'),(15,9,'Cash on Delivery (FedEx)','','','','','','en'),(16,10,'PayPal Payflow Link','Credit/Debit card or PayPal','','','Accept Visa, MasterCard®, American Express, Discover and PayPal payments on your site by connecting a PayPal-hosted checkout page with your own internet merchant account. Customize the page to look like the rest of your site and make sure customer transactions are secure.','','en'),(17,11,'PayPal Partner Hosted with PCI Compliance','Credit/Debit card','','','PCI compliant payments on your site with Visa, MasterCard, American Express and Discover - without PayPal-hosted pages. Maintain full control over your customers\' checkout experience by providing a credit card form that will post your customers\' payment details from your site\'s native checkout page directly to the Gateway server.','','en'),(18,12,'PayPal Payments Advanced','Credit/Debit card or PayPal','','','Accept Visa, MasterCard®, American Express, Discover and PayPal payments securely. With this all-in-one option, customers stay on your site for the entire checkout process. It simplifies PCI compliance and opens the door to more than 100 million active PayPal customers. Requires credit approval (2-3 business days).','','en'),(19,13,'PayPal Payments Standard','PayPal','','','Add a PayPal payment button to your site to accept Visa, MasterCard®, American Express, Discover and PayPal payments securely. When your customers check out, they are redirected to PayPal to pay, then return to your site after they are finished.','','en'),(20,14,'PayPal Express Checkout','PayPal','','','Create a seamless checkout experience and increase your conversion rate by opening the door to over 100 million active PayPal customers who look for and use this fast, easy, and secure way to pay.','','en'),(21,15,'PayPal Credit','PayPal Credit','','','','','en'),(22,16,'PayPal Adaptive payments (legacy)','PayPal','','','This method provides automatic transfer of payments to vendor users (the type of users enabled by the Multi-vendor module). The method may not be activated unless the module <a href=\'admin.php?target=addons_list_marketplace&moduleName=XC\\MultiVendor\' target=\'_blank\'>Multi-vendor</a> is installed and enabled. To use this method, store administrator is required to have an Application ID for PayPal Adaptive Payments API.','','en'),(23,17,'PayPal for Marketplaces (beta)','PayPal','','','PayPal for Marketplaces is a comprehensive payments solution for marketplaces, crowdfunding platforms, and other environments where people buy and sell goods and services or raise money. The solution is ideal if you run a multi-party commerce platform and want a flexible, end-to-end solution for processing payments.','','en'),(24,17,'PayPal for Marketplaces (beta)','PayPal','','','PayPal for Marketplaces - это комплексное решение по приёму платежей для торговых площадок, платформ для сбора средств под проект (\"краудфандинг\") и других сфер, где осуществляется продажа и покупка товаров и услуг, либо сбор средств. Данное решение идеально подойдет для платформ, осуществляющих коммерческую деятельность от лица нескольких участников, и представляет собой комплексное и гибкое решение для обработки платежей на всех этапах этой деятельности.','','ru'),(25,18,'QuantumGateway','','','','','','en'),(26,19,'2Checkout.com','','','','','','en'),(27,20,'Cash on Delivery (USPS)','','','','','','en'),(28,21,'Authorize.Net Accept.js','','','','','','en'),(29,22,'PayPal powered by Braintree','','','Supported countries: US, UK, France, Italy & Spain.','','','en'),(30,23,'Barclaycard ePDQ e-Commerce','','','','','','en'),(31,24,'Moneris (eSELECTplus- Hosted Pay Page)','','','','','','en'),(32,25,'iDEAL Professional (Rabobank)','','','','','','en'),(33,26,'Sage Pay form protocol','','','','','','en'),(34,27,'Stripe','','','','','','en'),(35,28,'Cash on Delivery (UPS)','','','','','','en'),(36,29,'X-Payments Cloud','Credit or Debit card by X-Payments','','','','','en');
CREATE TABLE `xlite_membership_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_571DB741BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_memberships` (`membership_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_membership_translations` VALUES (1,1,'Wholesaler','en'),(2,1,'Оптовый покупатель','ru');
CREATE TABLE `xlite_order_items` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `object_id` int(10) unsigned DEFAULT NULL,
  `order_id` int(11) DEFAULT NULL,
  `categoryAdded` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `xpaymentsEmulated` tinyint(1) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `sku` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `price` decimal(14,4) NOT NULL COMMENT '(DC2Type:money)',
  `itemNetPrice` decimal(14,4) NOT NULL,
  `discountedSubtotal` decimal(14,4) NOT NULL,
  `amount` int(11) NOT NULL,
  `backorderedAmount` int(11) NOT NULL,
  `total` decimal(14,4) NOT NULL,
  `subtotal` decimal(14,4) NOT NULL,
  `object_type` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `IDX_4693C0A18D9F6D38` (`order_id`),
  KEY `ooo` (`order_id`,`object_type`,`object_id`),
  KEY `object_id` (`object_id`),
  KEY `price` (`price`),
  KEY `amount` (`amount`),
  CONSTRAINT `FK_4693C0A1232D562B` FOREIGN KEY (`object_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE SET NULL,
  CONSTRAINT `FK_4693C0A18D9F6D38` FOREIGN KEY (`order_id`) REFERENCES `xlite_orders` (`order_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_order_items` VALUES (1,42,1,'',0,'Perfect Snacks','10000000118',19.9900,19.9900,16.9900,1,0,19.9900,19.9900,'product'),(2,3,2,'',0,'Beige Sneakers','10000000069',19.9900,19.9900,39.9800,2,0,39.9800,39.9800,'product'),(3,8,2,'',0,'Pink Sneakers with White Soles','10000000081',19.9900,14.9900,44.9700,3,0,44.9700,44.9700,'product'),(4,12,3,'',0,'Waist Tie Dress in Blue and White Stripe','10000000085',9.9900,9.9900,59.9400,6,0,59.9400,59.9400,'product'),(5,16,3,'',0,'Sleeved Mini Dress in Color Block','10000000089',99.0000,99.0000,99.9900,1,0,99.0000,99.0000,'product'),(6,10,4,'',0,'Caged Cutout Sandals in Gold','10000000083',34.9900,34.9900,34.9900,1,0,34.9900,34.9900,'product'),(7,14,5,'',0,'Multicolored Dress with Balloon Sleeves [Options & Attributes]','10000000087',29.9900,25.4900,305.8800,12,0,305.8800,305.8800,'product'),(8,26,5,'',0,'Festival Braslet Pack in Gold Tone','10000000101',12.9900,6.4900,45.4300,7,0,45.4300,45.4300,'product');
CREATE TABLE `xlite_logo_images` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `width` int(11) NOT NULL,
  `height` int(11) NOT NULL,
  `hash` char(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `needProcess` tinyint(1) NOT NULL,
  `path` varchar(512) COLLATE utf8_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_product_attachment_history_points` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attachment_id` int(10) unsigned DEFAULT NULL,
  `order_id` int(11) DEFAULT NULL,
  `profile_id` int(11) DEFAULT NULL,
  `login` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ip` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `date` int(10) unsigned NOT NULL,
  `path` longtext COLLATE utf8_unicode_ci NOT NULL,
  `additionalDetails` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_8F48E3E88D9F6D38` (`order_id`),
  KEY `IDX_8F48E3E8CCFA12B8` (`profile_id`),
  KEY `attachment` (`attachment_id`),
  CONSTRAINT `FK_8F48E3E8464E68B` FOREIGN KEY (`attachment_id`) REFERENCES `xlite_product_attachments` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_8F48E3E88D9F6D38` FOREIGN KEY (`order_id`) REFERENCES `xlite_orders` (`order_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_8F48E3E8CCFA12B8` FOREIGN KEY (`profile_id`) REFERENCES `xlite_profiles` (`profile_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_news` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `enabled` tinyint(1) NOT NULL,
  `date` int(11) NOT NULL,
  `metaDescType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `enabled` (`enabled`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_language_labels` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`label_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_language_labels` VALUES (3769,' page and make sure that:'),(3508,'\"Cash on delivery\" status'),(3768,'\"Site management\"'),(2062,'\"X product\" options'),(1174,'\"{{number}}\" tracking number is added'),(1175,'\"{{number}}\" tracking number is removed'),(1838,'\"{{product}} product\" attributes'),(2012,'# selected'),(1,'%'),(2084,'\'RESULT\' argument not found'),(2079,'\'status\' request argument can not found'),(3820,'(disabled role)'),(4356,'(like categories, weight, description, color)'),(2077,'(optional)'),(4372,'(without writing a single line of code) - 2 min'),(426,'+12130000000'),(4020,'+15550000000'),(1782,'- OR -'),(231,'-- No categories --'),(1923,'-- empty --'),(2609,'...Downloading {{entry}}...{{status}}'),(2607,'...Hooks {{hooksCount}}'),(2606,'...Hooks {{hooksCount}}, Items {{itemsCount}}...'),(2605,'...Invoke {{type}} hook for {{entry}}...'),(2608,'...Unpacking {{entry}}...{{status}}'),(4261,'1 day'),(4256,'1 hour'),(4252,'1 minute'),(4264,'1 week'),(4253,'10 minutes'),(422,'1000 Example street'),(4021,'1000 Main Street'),(4260,'12 hours'),(4397,'120+ supported payment gateways, such as PayPal, Authorize.net and etc.'),(379,'14days'),(4254,'15 minutes'),(3944,'18 years'),(3945,'19 years'),(4262,'2 days'),(4257,'2 hours'),(3764,'2Checkout.com account number'),(4255,'30 minutes'),(380,'30days'),(4258,'4 hours'),(2778,'404 page'),(4263,'5 days'),(4259,'6 hours'),(378,'7days'),(425,'90001'),(2610,'<span>X</span> items'),(4017,'A - Z'),(1473,'A DB error occurred while uninstalling the module X'),(4778,'A dispute has been opened successfully'),(2234,'A new category will be created'),(430,'A new customer? Enter your e-mail'),(2231,'A new membership will be created'),(2232,'A new product class will be created'),(2230,'A new product will be created'),(4541,'A new review has been submitted for the product \"{{name}}\".'),(2233,'A new tax class will be created'),(3527,'A single domain'),(431,'ABA routing number'),(3391,'API Login ID'),(3597,'API access password'),(3596,'API access username'),(3601,'API certificate'),(3600,'API certificate filename'),(3591,'API credentials for payments and post-checkout operations'),(4460,'API key is a secret key that allows to access REST API functionality. If this key is not specified in a request will not be executed.'),(3599,'API signature'),(367,'APRIL'),(371,'AUGUST'),(2479,'About X remaining'),(2788,'About clean urls'),(432,'Absolute'),(433,'Accept'),(2733,'Accept[TT]'),(434,'Accepted orders'),(3346,'Access Key ID'),(3257,'Access denied'),(436,'Access denied!'),(437,'Access information'),(438,'Access is locked out'),(439,'Access level'),(2754,'Access level cannot be changed (from {{prevValue}} to {{value}}) for existing profile ({{login}})'),(3258,'Access link has been successfully sent'),(440,'Account'),(441,'Account details'),(240,'Account settings'),(442,'Account status'),(443,'Account summary'),(2615,'Accounting'),(2393,'Action'),(1469,'Action X::Y, M'),(19,'Activate'),(17,'Activate existing key'),(16,'Activate free license'),(3087,'Activate free license & remove premium features.'),(23,'Activate free license description'),(1662,'Activate key'),(444,'Activate license key'),(2513,'Activate purchased skin'),(2287,'Activate your X-Cart'),(2285,'Activate your X-Cart installation'),(2286,'Activate your X-Cart installation first'),(10,'Activate your license key'),(445,'Activate your paid module license'),(446,'Active'),(447,'Active from'),(448,'Active till'),(449,'Add'),(3557,'Add PIN codes'),(450,'Add Product'),(4719,'Add TWIG code'),(4363,'Add a few [more products] to your catalog or proceed to the next step - whatever makes you happy.'),(3259,'Add addons'),(3260,'Add address'),(451,'Add alternative payment method'),(1908,'Add attribute'),(2704,'Add banner'),(452,'Add category'),(453,'Add child'),(2700,'Add comment here'),(2882,'Add countries'),(3452,'Add coupon'),(454,'Add discount'),(455,'Add featured products'),(2067,'Add featured products for \"X\"'),(3505,'Add featured products for the front page'),(456,'Add file'),(4333,'Add first product'),(457,'Add image'),(123,'Add language'),(458,'Add markup'),(459,'Add new'),(460,'Add new address'),(461,'Add new country'),(3445,'Add new coupon'),(462,'Add new exception'),(122,'Add new label'),(126,'Add new language'),(463,'Add new membership level'),(464,'Add new option'),(465,'Add new option group'),(466,'Add new state'),(467,'Add offline payment method'),(4353,'Add other options'),(4421,'Add other products to compare'),(468,'Add payment method'),(3564,'Add pin codes'),(2843,'Add product'),(1967,'Add products'),(1642,'Add rates'),(4751,'Add related products'),(4554,'Add response'),(4472,'Add review'),(3125,'Add sales channel'),(469,'Add shipping method'),(1647,'Add state'),(1646,'Add states'),(4029,'Add status'),(470,'Add subcategory'),(2400,'Add to bag'),(29,'Add to cart'),(4424,'Add to compare'),(4192,'Add to google product feed'),(1177,'Add tracking number'),(471,'Add user'),(472,'Add your _products_'),(4492,'Add your own review'),(473,'Add zone'),(2419,'Add-on does not exist.'),(474,'Add-ons'),(475,'Add/update options'),(476,'Added'),(3451,'Added coupons'),(2958,'Added files'),(2198,'Added items'),(478,'Added to cart'),(4019,'Added to comparison table'),(3666,'Additional PayPal Business Account'),(3647,'Additional criteria to match for PayPal account verification'),(3580,'Additional settings'),(894,'Addons Marketplace'),(479,'Address'),(480,'Address book'),(481,'Address details'),(482,'Address field'),(483,'Address fields'),(3726,'Address for sales tax calculation'),(1841,'Address has been deleted'),(1836,'Address is not selected'),(4576,'Address line verification: X'),(3261,'Address masks'),(1837,'Address not found'),(484,'Address pattern'),(3262,'Address type'),(1835,'Address type has wrong value'),(4577,'Address zipcode verification: X'),(2569,'Address zone'),(4139,'Addresses'),(1773,'Addresses list is empty'),(3802,'Adds the sender’s signature and the date on CN22 and CP72 shipping labels. Enter the signature as a string. The Sender’s signature date is automatically populated.'),(485,'Admin'),(1317,'Admin has requested a change of password for your account. Please change the password before you proceed.'),(3333,'Admin panel'),(486,'Administration Zone'),(487,'Administrator'),(1527,'Administrator Zone'),(2434,'Administrator account cannot be deleted via customer interface.'),(2329,'Administrator header'),(3942,'Administrator notes'),(2330,'Administrator signature'),(2333,'Administrator subject'),(2334,'Administrator text'),(3857,'Advanced Options'),(2411,'Advanced Order Management'),(4390,'Advanced shipping options'),(4395,'Advanced shipping settings'),(3523,'Advanced statistics with'),(2076,'After activation Skrill will give you access to a new section in your Skrill account called \"Merchant tools\". Please choose a secret word (do not use your password for this) and enter it into the merchant tools section and below.'),(1293,'After clicking this button, your hard/soft reset links will be regenerated. You need it in case old links were compromised.'),(1414,'After the problem has been fixed, try to connect again.'),(2760,'After the problem has been fixed, try to connect again.\', {\'clear_cache\': url(\'addons_list_marketplace'),(1499,'After the upgrade is completed please check your website. If you find that the site is inoperative, please try to do the following'),(1827,'Aggregation cache has been cleaned'),(4723,'Air service center'),(228,'All'),(662,'All Addresses (default zone)'),(345,'All Order Statuses'),(395,'All User Types'),(488,'All add-ons'),(2968,'All addons'),(2154,'All attributes'),(4443,'All classes from this category'),(4782,'All communication threads'),(1849,'All countries'),(489,'All customers'),(3817,'All dimensions must be greater than 0'),(2761,'All items'),(2195,'All items cannot be removed from the order.'),(2131,'All levels'),(393,'All membership levels'),(490,'All memberships'),(3697,'All newest products'),(4302,'All news'),(2135,'All orders'),(2120,'All payment statuses'),(2684,'All payment transaction statuses'),(492,'All products on sale'),(1772,'All rights reserved.'),(493,'All shipping methods'),(2121,'All shipping statuses'),(494,'All shipping zones'),(748,'All states'),(2403,'All statuses'),(491,'All the necessary adaptation will be done by the developer.'),(495,'All the products are in sufficient quantities'),(496,'All time'),(3698,'All upcoming products'),(2410,'All user types'),(4523,'All users'),(1778,'All words'),(4064,'Allow buyers to attach files to this product'),(4251,'Allow this product to be used as a MailChimp segment condition'),(4059,'Allowed file extensions: X'),(4446,'Alphabetical'),(499,'Alphabetically'),(1678,'Already added'),(1717,'Already exists'),(500,'Already have an account?'),(2676,'Also the system has detected problems with the following modules'),(2791,'Also, to manage your redirects you can define 301 redirects in .htaccess file.'),(3078,'Also, you can review X-Cart recommended hosting providers'),(90,'Alt'),(501,'Alternative payment methods'),(502,'Alternative text'),(276,'Alternatively, upload file sqldump.sql.php to the var/backup/ sub-directory click on the \"Restore from server\" button'),(4745,'Alternatives products you may be interested in'),(2762,'Although you can switch the store to use the secure protocol for the website pages, most Internet browsers will likely display a warning message scaring your website visitors away.'),(3504,'Although you may find related products below.'),(2634,'Amazon'),(3373,'Amazon Order Ref ID'),(3386,'Amazon Pay was not able to process your payment.'),(3343,'Amazon Seller ID'),(3372,'Amazon callback URL help'),(3371,'Amazon could not process the transaction due to an internal processing error.'),(3370,'Amazon has rejected the authorisation.'),(3355,'AmazonRefresh'),(3356,'AmazonRefundRefresh'),(503,'Amount'),(504,'Amount: high to low'),(505,'Amount: low to high'),(1860,'An attempt to update settings of unknown payment method'),(2356,'An error occurred while sending the request'),(2472,'An error occurred, please try again. If the problem persists, contact the administrator.'),(2473,'An error occurred, please try again. If the problem persists, contact the administrator. (txnNote)'),(1732,'An upgrade is a dangerous process that may result in a crashed website.'),(506,'An upgrade is a dangerous process that may result in a crashed website. It is strongly recommended to create a full back up of your shop (the code and the database) and download it to a local computer before proceeding to the next step.'),(1932,'Anonymous'),(2132,'Anonymous (access level)'),(200,'Anonymous Customer'),(201,'Anonymous Customer, _Registered User with the same email_'),(2022,'Anonymous Customers'),(4538,'Anonymous reviewer'),(3750,'Anonymous users only'),(3263,'Another bulk change in progress, please try again later'),(507,'Another state'),(111,'Any availability status'),(400,'Any category'),(114,'Any class'),(4177,'Any google group'),(508,'Any membership level'),(509,'Any product class'),(2550,'Any profile'),(4468,'Any rating'),(4121,'Any special needs?'),(401,'Any status'),(2178,'Any stock status'),(3749,'Any visitors'),(1779,'Any word'),(510,'Any zone'),(4022,'Anyland'),(4023,'Anytown'),(2627,'App type'),(511,'Appearance'),(3418,'Applied discount coupon'),(3109,'Apply attribute value changes for all the products'),(512,'Apply destination'),(513,'Apply price'),(4046,'Apply sort and view settings for all products'),(2951,'Apply sorting globally'),(3264,'Apply to billing address'),(3107,'Apply unsharp mask filter on resize'),(1751,'Apply value changes globally'),(1750,'Apply value changes locally'),(4483,'Approve'),(4474,'Approve review'),(4096,'Approved URL'),(514,'Are you sure you want to continue?'),(519,'Are you sure you want to delete the selected payment method?'),(515,'Are you sure you want to delete the selected user?'),(2651,'Are you sure you want to delete this filter?'),(1675,'Are you sure you want to delete this profile?'),(516,'Are you sure you want to disable this add-on?'),(2844,'Are you sure you want to enable https anyway?'),(517,'Are you sure you want to enable this add-on?'),(4708,'Are you sure you want to reset current layout? Custom layout settings will be lost.'),(3960,'Are you sure you want to transmit this shipment?'),(2398,'Are you sure you want to uninstall selected add-ons?'),(518,'Are you sure you want to uninstall this add-on?'),(3958,'Are you sure you want to void this shipment?'),(520,'Are you sure you wish to delete the selected zones?'),(521,'Are you sure?'),(522,'Arrival date'),(3510,'As a FedEx user, you are entitled to receive shipping refunds usually left unclaimed with default FedEx service ($2B/year globally)'),(4734,'As a UPS user, you are entitled to receive shipping refunds usually left unclaimed with default UPS service ($2B/year globally)'),(524,'Ask.com'),(2454,'Assign entered Clean URL to this page anyway'),(4193,'Assign shopping group'),(4184,'Assign your attributes to Google groups to import your variants.'),(525,'Assigned classes'),(523,'Asynchronous'),(4076,'Attach file'),(4062,'Attach files'),(3909,'Attached files'),(4060,'Attached files:'),(4071,'Attachment X is deleted'),(3514,'Attachment has been deleted successfully'),(526,'Attachment is not deleted'),(3466,'Attachment removed'),(527,'Attachments'),(528,'Attachments have been updated successfully'),(3075,'Attention!'),(3175,'Attention! You are creating an account with full access. Roles warning'),(1572,'Attribute'),(6,'Attribute data will be lost. warning text'),(1570,'Attribute group'),(1571,'Attribute groups'),(4194,'Attribute information has been successfully updated'),(1567,'Attribute name'),(1562,'Attribute option'),(4176,'Attribute type'),(3146,'Attribute value ID'),(1568,'Attribute values'),(3147,'Attribute values (select)'),(117,'Attributes'),(751,'Attributes block'),(315,'Attributes for X product class'),(1839,'Attributes have been successfully changed'),(1889,'Attributes have been updated successfully'),(1904,'Attributes imported'),(529,'Australia Post settings'),(2101,'Auth'),(3581,'Auth and Capture'),(3582,'Auth only'),(530,'Authentication'),(531,'Authentication code'),(3984,'Authentication options'),(532,'Author'),(2056,'Authorization and Capture'),(2057,'Authorization only'),(3357,'Authorization status: {{status}}'),(533,'Authorization then capture'),(3860,'AuthorizeNet accept.js instruction text'),(2721,'Authorize[TT]'),(347,'Authorized'),(1828,'Authorized amount'),(534,'Auto'),(4243,'Auto-Updated'),(2763,'Autogenerate'),(1676,'Autogenerate Clean URL'),(2074,'Autogenerated'),(2643,'Automate Shipping Refunds'),(3844,'Automate bidding to maximize sales for your marketing budget'),(2620,'Automate shipping'),(2622,'Automate your shipping process with the services of our partners: print shipping labels, grab shipping orders info from eBay, ETSY, Amazon and other marketplaces; integrate with several shipping carriers in one spot and more.'),(3560,'Automatically'),(535,'Availability'),(3488,'Available after purchase'),(3473,'Available for download'),(536,'Available for sale'),(2546,'Avalara provides our mutual customers with everything you need to calculate, file and remit sales tax for your business effortlessly by providing an integrated, end-to-end solution for every step of the tax compliance process.'),(2548,'Avalara.60 Day Free Trial'),(4499,'Average rating'),(2914,'Awaiting processing'),(537,'B'),(244,'BEGIN - END of TOTAL'),(1816,'Back'),(1783,'Back to Login form'),(2681,'Back to Trial mode'),(4662,'Back to Webmaster mode'),(750,'Back to Zones list'),(538,'Back to file select'),(539,'Back to layout settings'),(540,'Back to methods'),(1784,'Back to modules'),(4666,'Back to notification settings'),(2337,'Back to notifications list'),(541,'Back to order list'),(4509,'Back to product details'),(3889,'Back to products'),(4267,'Back to segments list'),(2597,'Back to shipping methods'),(4609,'Back to templates list'),(302,'Backend payment transaction X issued'),(2764,'Background export is in progress'),(3318,'Backordered'),(3319,'Backordered (qty: {{qty}})'),(542,'Backup'),(543,'Backup database'),(2034,'Backup your store with Backup Master'),(544,'Bank Account Number'),(905,'Bank name'),(3612,'Banner on Cart page'),(3610,'Banner on Category pages'),(3609,'Banner on Home page'),(3611,'Banner on Product details pages'),(2703,'Banner rotation'),(4501,'Based on'),(4522,'Be the first and leave a feedback.'),(1605,'Before editing attributes specific for the chosen type you should save the changes'),(2539,'Before enabling HTTPS protocol read this article:'),(2283,'Before installing a paid addon for this installation, you need to activate your X-Cart license.'),(3389,'Before you can start configure Australia Post module you should update available options from Australia Post. Please click button below.'),(545,'Benchmark completed in '),(546,'Benchmark result under 3000ms is considered good'),(547,'Bestsellers'),(2660,'Bill to'),(2886,'Billing'),(548,'Billing address'),(2087,'Billing address is not defined'),(549,'Billing address is not defined yet'),(1819,'Billing address is the same as Shipping'),(2890,'Billing to'),(550,'Bing'),(4392,'Bingo! You\'ve added carrier as a shipping carrier'),(3499,'Block'),(4636,'Block is disabled'),(4635,'Block is enabled'),(2065,'Blocked'),(3472,'Blocked by administrator'),(2874,'Body'),(3926,'Box maximum weight'),(551,'Brief description'),(552,'Brief descrption'),(4041,'Brief info'),(4047,'Brief info help'),(553,'Browse server'),(3854,'Build a campaign in a few minutes, and sell to customers as they search for your products on Google.'),(3887,'Bulk Edit processing in progress...'),(3879,'Bulk edit'),(3881,'Bulk edit all'),(3884,'Bulk edit has been processed successfully.'),(3885,'Bulk edit processing has been interrupted.'),(3886,'Bulk edit processing may take a while to complete. Please do not close this page until the process is fully completed.'),(3890,'Bulk edit selected'),(3265,'Business premium features'),(2208,'Buy'),(2488,'Buy Business Edition'),(554,'Buy more'),(2443,'Buy prolongation'),(1608,'Buyers can select an option'),(1793,'C.O.D. fee included'),(555,'CLOSE'),(2002,'CM'),(3789,'COD value'),(556,'CSS & JavaScript'),(2388,'CSV delimiter'),(2161,'CSV file has the wrong filename format.'),(3071,'CSV format tables'),(1982,'CSV or ZIP files, total max size: {{size}}'),(4575,'CVC verification: X'),(3266,'CVV / CVC'),(1804,'CVV2'),(2474,'Cache management'),(557,'Cache rebuild is already started, please wait'),(2477,'Calculate quick data'),(2478,'Calculate quick data help text'),(558,'Calculate rates'),(2480,'Calculating quick data...'),(424,'California'),(1806,'Call us: '),(3374,'Callback URL'),(3851,'Campaign Dashboard'),(3474,'Can be downloaded only after buying the product'),(2555,'Can be provided only for offline shipping methods.'),(2557,'Can be provided only for online shipping methods.'),(3592,'Can be set up later'),(3541,'Can not be disabled for products with manually defined PIN codes'),(559,'Can\'t be disabled. The module is required by:'),(560,'Can\'t connect to the Addons Marketplace server'),(2029,'Can\'t connect to the marketplace server'),(4324,'Can\'t subscribe you right now. Try later'),(3899,'Canada Post module allows to use online shipping rates calculation via Canada Post'),(3937,'Canada Post settings'),(3967,'CanadaPost settings'),(138,'Cancel'),(3722,'Cancel sale'),(3725,'Cancel sale for all'),(349,'Canceled'),(2691,'Canceled[S]'),(2984,'Canceling'),(4068,'Cannot attach the file. The maximum attached file size may not exceed X MB'),(4067,'Cannot attach the file. The number of attached files may not exceed X'),(4286,'Cannot authenticate'),(1895,'Cannot autogenerate clean URL for the product name \"{{name}}\". Please specify it manually.'),(2956,'Cannot check the files for this module'),(2192,'Cannot create temporary order for modification'),(2342,'Cannot gather modules from the marketplace. Please try later.'),(4660,'Cannot get flexy content'),(3543,'Cannot remove a sold PIN code'),(281,'Cannot set X permissions for subdirectories:'),(2102,'Capture'),(3351,'Capture mode'),(2725,'Capture multiple[TT]'),(2724,'Capture partially[TT]'),(561,'Capture status'),(2723,'Capture[TT]'),(1829,'Captured amount'),(3950,'Card (hold) for pick up'),(2297,'Card number'),(2294,'Card type'),(1799,'Cardholder name'),(1168,'Carrier'),(2594,'Carrier service'),(2595,'Carrier service name'),(2593,'Carrier services'),(2559,'Carrier-calculated rates'),(1814,'Cart'),(562,'Cart & checkout'),(2175,'Cart contains products with wrong quantity'),(2174,'Cart contains products with wrong quantity. Please correct this to proceed'),(210,'Cart is empty'),(2070,'Cash on delivery'),(563,'Catalog'),(564,'Categories'),(4457,'Categories and tags'),(1905,'Categories imported'),(2994,'Categories processed'),(2997,'Categories processed: X out of Y'),(2996,'Categories processed: X out of Y with errors'),(2998,'Categories processed: {{count}}'),(565,'Category'),(4714,'Category description'),(80,'Category icon'),(3068,'Category id or path is required'),(566,'Category info'),(3328,'Category is not accessible'),(567,'Category name'),(568,'Category name contains invalid symbols'),(2759,'Category name should not be empty'),(569,'Category page title'),(570,'Category path contains invalid symbols'),(3070,'Category with id X not found, new category will be created'),(571,'Change'),(572,'Change address'),(1805,'Change attributes'),(3173,'Change fulfillment status for selected'),(573,'Change method'),(574,'Change options'),(1416,'Change password'),(575,'Change payment info'),(3172,'Change payment status for selected'),(577,'Change shipping'),(576,'Change shipping info'),(3267,'Change template'),(2196,'Changed items'),(2197,'Changed options'),(4627,'Changes may be incompatible with TinyMCE. Are you sure to proceed?'),(1748,'Changes of attributes globally'),(1749,'Changes of attributes locally'),(4691,'Changes were successfully saved'),(2210,'Character set'),(1730,'Check again'),(578,'Check all'),(4658,'Check directory permissions'),(2529,'Check for available free disk space has failed'),(2845,'Check for updates'),(579,'Check number'),(4136,'Check shipping info'),(3204,'Check the article how to check your emails'),(3206,'Check your email deliverability'),(580,'Checking'),(581,'Checking integrity, please wait...'),(214,'Checkout'),(4123,'Checkout type'),(582,'Choose'),(583,'Choose _payment methods_'),(2515,'Choose a new template'),(4137,'Choose another address'),(2296,'Choose card type'),(4445,'Choose classes...'),(584,'Choose file'),(585,'Choose from a variety of bundled payment solutions to accept credit cards and other methods of payment on your website'),(586,'Choose method'),(2892,'Choose shipping'),(587,'Choose shipping method'),(1786,'Choose the product options first'),(2487,'Choose the right plan'),(4164,'Choose your location'),(1621,'Choosing \"URLs\" will link the exported data to your public files (product and category images, downloadable files shown on product pages, and so on) through direct URLs'),(2295,'Chose credit card type'),(588,'City'),(1428,'City masks'),(4199,'Class X'),(2155,'Classes & Attributes'),(1856,'Classes & attributes'),(4442,'Classes for product filter'),(589,'Clean URL'),(2766,'Clean URLs'),(643,'Clean URLs are disabled'),(641,'Clean URLs are disabled. More info'),(2765,'Clean URLs are disabled. More info\', {\'more_info_url\': url(\'settings\', \''),(642,'Clean URLs are enabled'),(645,'Clean URLs functionality may not be enabled. More info'),(595,'Clean aggregation cache'),(50,'Clean aggregation cache help text'),(596,'Clean widgets cache'),(51,'Clean widgets cache help text'),(597,'CleanURL'),(594,'Clean_urls_error_message'),(1523,'Cleanup'),(1520,'Cleanup queries'),(2910,'Clear all caches'),(2911,'Clear all caches text'),(1790,'Clear all fields'),(598,'Clear bag'),(3268,'Clear cache help text'),(34,'Clear cart'),(4422,'Clear list'),(109,'Clear search'),(4588,'Click Connect with Stripe to be redirected to Stripe.com'),(599,'Click here to access/add subcategories'),(3727,'Click here to specify tax rates that will apply only to shipping charges'),(4355,'Click here to upload product image'),(4367,'Click here to upload your logo. Recommended 400x150px (PNG, JPG or SVG)'),(600,'Click here to view states of country'),(1596,'Click if you do not want to add this value to new products or class’s assigns automatically'),(1597,'Click if you want to add this value to new products or class’s assigns automatically'),(4249,'Click rate'),(2209,'Click the link to increase product amount'),(3667,'Click this to access the PayPal sign-in page and sign in using your PayPal account different from the account specified above.'),(1641,'Click to add rates'),(1645,'Click to add states'),(1709,'Click to close'),(3516,'Click to edit'),(1648,'Click to edit all this label translations'),(1640,'Click to edit rates'),(1644,'Click to edit states'),(3102,'Click to expand menu'),(4133,'Click to finish your order'),(1708,'Click to open'),(4135,'Click to proceed to the next step'),(3326,'Click to select the date'),(3880,'Click to specify'),(601,'Click to unblock'),(179,'Clicking the Place order button you accept: Terms and Conditions'),(3348,'Client ID'),(1554,'Clone'),(2976,'Clone selected'),(1553,'Clone this product'),(118,'Cloned products'),(356,'Close'),(4777,'Close dispute'),(602,'Close storefront'),(4340,'Close wizard'),(1940,'Closed'),(2628,'Cloud Service'),(2629,'Cloud Zoom'),(2630,'Cloud Zoom mode'),(2631,'Cloud Zoom mode Inside'),(2632,'Cloud Zoom mode Outside'),(3878,'CloudSearch sets default sort order to relevance'),(603,'Code'),(3669,'Color'),(2918,'Column X is required'),(3699,'Coming soon'),(2384,'Coming soon (title)'),(3710,'Coming soon...'),(1701,'Comma'),(604,'Comment'),(605,'Comments'),(1998,'Commercial'),(3949,'Commercial - will return the contracted price between Canada Post and the contract holder'),(3985,'Common options'),(1184,'Common tax settings'),(2124,'Communication log'),(3656,'Communication problem'),(4784,'Communication threads with open disputes'),(4783,'Communication threads with unread messages'),(1926,'Compact view'),(606,'Company'),(607,'Company name'),(2086,'Compare'),(1807,'Compare products'),(1529,'Compare your result with other servers'),(4420,'Comparison table - X items'),(1720,'Complete'),(1820,'Complete billing address'),(608,'Completed'),(609,'Component'),(3012,'Config file'),(610,'Configuration'),(1636,'Configure'),(4687,'Configure Tag Manager'),(611,'Configure _shipping methods_'),(3983,'Configure manually'),(3525,'Configure the Google Analytics module'),(3497,'Configure your X-Cart installation to support large file downloads.'),(4373,'Configure your geographic settings to connect with local customers'),(612,'Configure your store'),(135,'Confirm deletion'),(613,'Confirm password'),(2494,'Confirmation'),(1718,'Confirmation does not match'),(157,'Congratulations! Your order has been placed successfully'),(3660,'Connect to PayPal'),(4279,'Connect with your MailChimp account'),(4313,'Connect your store to MailChimp'),(3658,'Connected to PayPal; Merchant ID: {{merchantId}}'),(2792,'Connecting to the marketplace...'),(3142,'Consistency check'),(3151,'Consistency has not yet been checked. Initiate an consistency check by clicking the button \"Refresh consistency status\".'),(3176,'Contact Us page settings'),(3986,'Contact name for the manifest address'),(4406,'Contact our expert'),(4767,'Contact seller'),(3739,'Contact us'),(3088,'Contact us if you have any questions.'),(9,'Contact us trial notice'),(3496,'Contact your hosting provider to make sure X-Sendfile is installed on the server.'),(614,'Contacts'),(615,'Content'),(4161,'Content has script tags (Froala)'),(2324,'Content of this notification based on the body.twig template'),(3758,'Content page title'),(616,'Continue'),(1821,'Continue as guest'),(35,'Continue shopping'),(48,'Continue...'),(3987,'Contract ID'),(3988,'Contract shipping options'),(3806,'Convenience - Verify addresses and buy & print compliant USPS labels directly from the X-Cart application'),(4794,'Conversation'),(4796,'Conversation: X'),(4795,'Conversations'),(2708,'Convert failed transactions into real orders'),(4653,'Convert templates'),(91,'Copy'),(4581,'Copy Webhook URL and go to Account settings'),(617,'Copy file to local server'),(92,'Copy to clipboard'),(89,'Copy to file system'),(1688,'Core version'),(618,'Core version: '),(3822,'Could not add the discount because another discount already exists for the specified subtotal range and membership level'),(3538,'Could not assign X PIN codes to order #Y.'),(2469,'Could not assign upgrade access level to your license keys'),(4415,'Could not save logo image'),(3823,'Could not update the discount because another discount already exists for the specified subtotal range and membership level'),(2849,'Couldn\'t download the banner {{value}} from URL'),(2710,'Couldn\'t download the image {{value}} from URL'),(2041,'Couldn\'t move X images. See log for details.'),(2040,'Couldn\'t move image X'),(1518,'Count'),(3948,'Counter - will return the regular price paid by retail consumers'),(619,'Countries'),(2305,'Countries information has been successfully updated'),(620,'Countries, states and zones'),(621,'Country'),(622,'Country is not selected'),(3350,'Country of Merchant account'),(3447,'Coupon'),(3455,'Coupon cannot be combined with other coupons'),(623,'Coupon code'),(3425,'Coupon discount'),(3443,'Coupon discount can be limited to customers with these membership levels'),(3442,'Coupon discount can be limited to these product classes'),(624,'Coupons'),(3989,'Coverage'),(625,'Create'),(627,'Create SQL file'),(3853,'Create a New Google Shopping Campaign'),(628,'Create a backup'),(629,'Create account'),(630,'Create an account for later use'),(631,'Create category'),(2427,'Create label'),(632,'Create new account'),(1979,'Create new items and update existing items'),(4307,'Create news message'),(3846,'Create perfect shopping campaigns in minutes'),(626,'Create profile'),(3903,'Create return'),(3803,'Create shipment'),(4391,'Create shipping rate'),(1303,'Create zone'),(633,'Created'),(3910,'Created on'),(1800,'Credit card number'),(2304,'Credit card security code (if present)'),(3686,'Credit or debit card (Visa, MasterCard, American Express, Discover, and so on)'),(3269,'Critical'),(1977,'Critical error'),(1502,'Critical errors have been detected in the files you are trying to import. Check the manual to correct the errors and try again.'),(1696,'Curl options'),(1695,'Curl version'),(634,'Currency'),(3990,'Currency rate'),(3008,'Current password'),(2191,'Current price for the selected configuration and quantity: X'),(2508,'Current template'),(2075,'Custom'),(636,'Custom CSS'),(3120,'Custom CSS & JS'),(78,'Custom HTML title'),(637,'Custom JavaScript'),(635,'Custom addons'),(1987,'Custom attributes'),(638,'Custom images'),(1912,'Custom offline shipping'),(2560,'Custom table rates'),(639,'Custom translation'),(199,'Customer'),(2130,'Customer access level'),(3332,'Customer area'),(4724,'Customer counter'),(3248,'Customer email (if exist)'),(2327,'Customer header'),(2193,'Customer information'),(4485,'Customer name'),(198,'Customer note'),(3991,'Customer number'),(4510,'Customer reviews'),(2328,'Customer signature'),(2331,'Customer subject'),(2332,'Customer text'),(640,'Customer zip/postal code'),(1531,'Customer zone is closed for maintenance.'),(4072,'Customer`s attachments were changed'),(1901,'Customers'),(1902,'Customers imported'),(3700,'Customers who bought this product also bought'),(3701,'Customers who viewed this product bought'),(4693,'Customize storefront'),(3668,'Customize the PayPal button'),(4371,'Customize your store with Layout Editor option'),(375,'DECEMBER'),(2635,'DHL'),(2003,'DM'),(4725,'Daily Pickup'),(3315,'Dashboard'),(1503,'Data has not been found'),(647,'Data have been deleted successfully'),(648,'Data have been saved successfully'),(3270,'Data removal has been completed successfully.'),(3271,'Data removal has been stopped.'),(3272,'Database'),(649,'Database backup created successfully'),(1877,'Database restored successfully!'),(650,'Date'),(3273,'Date and time in the shop'),(3178,'Date and time in the store'),(3177,'Date and time on the server'),(1789,'Date range'),(387,'Date range should less than %d days'),(386,'Date range should longer than %d days'),(3438,'Date when customers can start using the coupon'),(3439,'Date when the coupon expires'),(3702,'Date: newest first'),(3703,'Date: oldest first'),(651,'Day'),(355,'Days'),(652,'Dear'),(294,'Dear X'),(653,'Dear customer'),(654,'Decline'),(2734,'Decline[TT]'),(655,'Declined'),(4097,'Declined URL'),(656,'Default'),(1607,'Default attribute value'),(657,'Default customer address'),(1910,'Default for admins'),(658,'Default for customer zone and can not disabled or deleted'),(659,'Default for customer zone and cannot be disabled or deleted'),(1909,'Default for customers'),(2685,'Default image settings'),(660,'Default images settings'),(1564,'Default option'),(2783,'Default site meta description'),(2784,'Default site meta keywords'),(2782,'Default site title'),(115,'Default tax class'),(1606,'Default value'),(413,'Default zone tooltip text'),(1083,'Default-sort-option'),(3334,'Default: {{code}}'),(663,'Define classes'),(3681,'Delayed'),(137,'Delete'),(4360,'Delete Demo products'),(146,'Delete Language'),(664,'Delete SQL file'),(2433,'Delete account'),(665,'Delete all'),(1604,'Delete all files'),(4061,'Delete attachment'),(4701,'Delete custom file'),(2650,'Delete filter option'),(47,'Delete item'),(666,'Delete profile'),(667,'Delete selected'),(668,'Delete selected profile'),(1506,'Delete temporary files after the import is completed'),(669,'Delete the image'),(670,'Delete this address?'),(3904,'Deliver to Post Office'),(3992,'Deliver to Post Office options'),(38,'Delivery'),(4726,'Delivery confirmation - adult signature required'),(4727,'Delivery confirmation - no signature'),(4728,'Delivery confirmation - signature required'),(3782,'Delivery cost'),(3809,'Delivery date'),(4138,'Delivery method'),(671,'Delivery methods'),(2552,'Delivery time'),(3907,'Delivery to Post Office'),(258,'Depending on the size of your data file, importing may take some time.'),(2105,'Deploy'),(30,'Description'),(3337,'Description for customers'),(4366,'Design your online store to fit your brand'),(2049,'Destination address'),(672,'Destination zone'),(673,'Details'),(3274,'Developer'),(4410,'Developer docs'),(3993,'Developer mode'),(2981,'Developer wave'),(2374,'Developers docs'),(4423,'Differences only'),(3316,'Dimensions'),(3927,'Dimensions (cm)'),(674,'Directories and files permissions'),(336,'Directory X does not have permissions to write. Please set necessary permissions to directory X.'),(3982,'Directory X is not writable'),(1907,'Directory does not have permissions to write'),(1700,'Directory is empty'),(142,'Disable'),(3275,'Disable HTTPS'),(2975,'Disable all'),(675,'Disable all modules in the system'),(4720,'Disable block'),(4108,'Disable facebook product feed'),(4755,'Disable mutual links'),(2973,'Disable selected'),(676,'Disable suspicious modules'),(677,'Disabled'),(3020,'Disabled functions'),(1599,'Disabled in catalog'),(145,'Disabled language can not be set as default for customer zone'),(1894,'Disabled language cannot be default.'),(678,'Disabled language cannot be set as default for customer zone'),(2113,'Disabled modules hooks message body'),(2112,'Disabled modules hooks message head'),(2969,'Disabled only'),(772,'Disables all addons (core reset)'),(771,'Disables all addons except ones that are provided by X-Cart Team & Qualiteam (soft reset)'),(770,'Disables all addons except ones that are provided by X-Cart Team (hard reset)'),(1188,'Disables all modules except ones that were downloaded from marketplace (soft reset)'),(3322,'Discard'),(4631,'Discard changes'),(4586,'Disconnect'),(679,'Discount'),(680,'Discount amount'),(681,'Discount type'),(3728,'Discounted subtotal'),(3729,'Discounted subtotal + Shipping cost'),(2571,'Discounted subtotal range'),(3117,'Discounts'),(682,'Display \'inc/ex VAT\' labels next to prices'),(4710,'Display all templates'),(1186,'Display common settings'),(3602,'Display the \"Buy Now with PayPal\" button'),(683,'Display type'),(1918,'Displays the number of labels translated to the language'),(4788,'Dispute'),(4775,'Dispute closed by X'),(4785,'Dispute is open X by Y'),(4774,'Dispute opened by X'),(4793,'Disputes'),(684,'Do not close this page!'),(1737,'Do not replace selected files and ignore their newer versions'),(3952,'Do not safe drop'),(2138,'Do not see your payment method? Find it on our Marketplace'),(2793,'Do not see your payment method? Find it on our Marketplace\', {\'url\': url(\'addons_list_marketplace\', \'\', {\'tag\': \'Payment processing'),(2177,'Do not select anything if you want to make the product visible to all customers.'),(685,'Do not show at startup anymore'),(4444,'Do not show the filter'),(1505,'Do not verify images to increase speed of the process'),(4380,'Do you need to ship your products?'),(2612,'Do you really want to close storefront?'),(4756,'Do you really want to delete all relations from this product?'),(686,'Do you really want to delete selected items?'),(3060,'DocBlocks support'),(3928,'Document'),(3911,'Documents'),(2669,'Does not match license type (requires {{list}} edition)'),(3623,'Don\'t have account yet?'),(4567,'Don\'t have account yet? Sign up for SagePay now!'),(4595,'Don\'t have an account?'),(3712,'Don\'t label'),(4362,'Done! We ve just deleted all your demo products'),(687,'Dont have account yet?'),(3398,'Dont have an account? Sign Up Now'),(2033,'Don’t forget to create a backup!'),(2205,'Don’t notify customer'),(1710,'Double quote'),(3276,'Download'),(1983,'Download CSV files'),(688,'Download SQL file'),(1622,'Download all files'),(2719,'Download error file'),(3478,'Download link did not found'),(3476,'Download link is blocked'),(3479,'Download link is not active'),(3480,'Download link is renew'),(3477,'Download links is blocked'),(3481,'Download links is renew'),(689,'Downloaded components'),(690,'Downloading updates'),(691,'Downloading updates, please wait...'),(3469,'Downloads left'),(692,'Drag and drop me to the bag'),(4674,'Drag-n-drop blocks'),(1504,'Drop existing items before import'),(693,'Drop items here to shop'),(694,'Drupal frontend'),(314,'Duplicated clean URL: X'),(4049,'Duplicated link'),(263,'During the import was recorded X errors. You can get them by downloading the log files.'),(2875,'Dynamic message'),(4629,'Dynamic message editor'),(4275,'E-Commerce features setup'),(1808,'E-Mail'),(3589,'E-Mail address to receive PayPal payment'),(3483,'E-goods'),(695,'E-mail'),(696,'E-mail is not defined yet'),(2898,'E-mail will also be updated in all the related orders.'),(3640,'EACHRECEIVER'),(3687,'ELV/SEPA'),(2636,'ETSY'),(3807,'Easy payment options - Ship Now Pay Later with a Pitney Bowes Line of Credit or use a credit card.'),(1643,'Edit'),(4043,'Edit Globally'),(4127,'Edit address'),(4758,'Edit all'),(1679,'Edit attribute'),(1595,'Edit attribute values'),(1537,'Edit attributes'),(4141,'Edit billing address'),(697,'Edit charges for:'),(2511,'Edit custom options'),(4128,'Edit email'),(147,'Edit label'),(148,'Edit labels'),(403,'Edit labels (X)'),(4716,'Edit notification body'),(699,'Edit page'),(698,'Edit payment method data'),(1638,'Edit product'),(700,'Edit profile'),(419,'Edit rates (X)'),(4473,'Edit review'),(4142,'Edit shipping address'),(408,'Edit states (X)'),(341,'Edit subcategories (X)'),(4667,'Edit template based on'),(4491,'Edit your review'),(4606,'Edited templates'),(304,'Editing attribute groups on this page won\'t affect other product classes which use these groups'),(3486,'Egoods free'),(3485,'Egoods paid'),(701,'Email'),(702,'Email &amp; password'),(3408,'Email Address'),(217,'Email address'),(2024,'Email again'),(703,'Email body'),(3247,'Email from the contact information section according to the type of email message'),(2322,'Email notifications'),(4317,'Email or login'),(704,'Email settings'),(3195,'Email transfer settings'),(2030,'Empty \"class\" parameter is passed to the {{method}}'),(143,'Enable'),(3994,'Enable \"Deliver to Post Office\" feature'),(4115,'Enable Advanced Matching'),(705,'Enable HTTPS'),(2974,'Enable all'),(590,'Enable clean URL'),(644,'Enable clean URLs'),(4107,'Enable facebook product feed'),(4707,'Enable hidden block'),(3277,'Enable module'),(4754,'Enable mutual links'),(2972,'Enable selected'),(4095,'Enable the Use Enhanced Cancel option.'),(2452,'Enable the option \"Assign entered Clean URL to this page anyway\" to dissociate the entered Clean URL from the page it is currently used for and assign it to the page of the object being edited.'),(2887,'Enable this if you would like us to use your shipping address as your billing address'),(706,'Enabled'),(2325,'Enabled for administrator'),(2326,'Enabled for customer'),(1598,'Enabled in catalog'),(2970,'Enabled only'),(4670,'Enter Order number'),(3955,'Enter Return # or Order #'),(711,'Enter X more characters to start search'),(182,'Enter a correct email'),(2451,'Enter a different Clean URL value for this page'),(2853,'Enter a keyword to search.'),(4557,'Enter a name to be published with the review'),(187,'Enter a negative number'),(184,'Enter a number'),(186,'Enter a positive number'),(3325,'Enter alt text'),(183,'Enter an integer'),(3446,'Enter code'),(707,'Enter coupon code'),(346,'Enter date range'),(3571,'Enter description of the purchase that will be displayed on PayPal payment page.'),(4318,'Enter email address'),(4054,'Enter file extensions separated by comma; for example, \"jpg,txt,svg\"'),(2649,'Enter filter name'),(392,'Enter keyword'),(708,'Enter keywords'),(709,'Enter license key'),(1960,'Enter pattern here'),(4354,'Enter product name'),(2794,'Enter product name or SKU'),(1963,'Enter search pattern'),(710,'Enter shipping address'),(3570,'Enter the email address associated with your PayPal account.'),(1792,'Enter the shipping address to see delivery methods available to you'),(4282,'Enter your MailChimp API key manually'),(1822,'Enter your e-mail'),(18,'Enter your license key here'),(3086,'Enter your premium license key'),(4643,'Entity was successfully saved'),(712,'Environment'),(713,'Environment info'),(714,'Error'),(591,'Error code explanation:'),(2850,'Error of banner loading. Make sure the \"images\" directory has write permissions.'),(2254,'Error of image loading. Make sure the \"images\" directory has write permissions.'),(2711,'Error of image verification ({{value}}). Make sure you have specified the correct image file or URL.'),(1873,'Error of uploading file.'),(4644,'Error on saving image'),(3278,'Error sending link'),(2717,'Errors'),(2961,'Errors files'),(3810,'Estimate delivery date'),(715,'Estimate shipping cost'),(716,'Estimate your server performance'),(717,'Estimated for'),(24,'Evaluation notice'),(2790,'Every object stores history with 8 clean urls which were previously used for this object.'),(718,'Everything you need'),(4375,'Ex.'),(1777,'Exact phrase'),(719,'Example'),(423,'Example city'),(720,'Examples'),(4403,'Excellent! Now you can get paid'),(721,'Exception'),(4155,'Exclude from shipping cost calculation'),(2549,'Existing Avalara Customer?'),(1794,'Existing Customer?'),(4637,'Exit editor'),(4624,'Exit product preview'),(2442,'Exp. date'),(722,'Expand the functionality of your store by installing and using add-on modules'),(1927,'Expanded view'),(3709,'Expected on'),(3716,'Expected on X'),(1802,'Expiration date'),(350,'Expired'),(3470,'Expired by TTL'),(3468,'Expired by limit'),(3471,'Expires in'),(723,'Export'),(2795,'Export all'),(1630,'Export cannot be started because it is disabled or there is another running export process'),(1624,'Export completed'),(4187,'Export duplicates as separate products'),(1628,'Export failed'),(1631,'Export in CSV'),(1629,'Export not started'),(4330,'Export of Not Finished orders is not supported. To export the orders which are now in this state, change their fulfillment status from Not Finished to any other.'),(4188,'Export only the original product'),(2616,'Export orders'),(2152,'Export product data with'),(724,'Export products'),(1618,'Export public files as'),(2796,'Export selected'),(1617,'Export settings'),(1623,'Exported files'),(335,'Exported in X'),(1625,'Exporting data...'),(3689,'Express Checkout process stopped.'),(725,'Extensions'),(365,'FEBRUARY'),(361,'FR'),(4144,'FREE'),(4146,'FREE SHIPPING'),(2517,'FREE quote'),(2625,'FREE trial'),(726,'Facebook'),(4098,'Facebook Ads & Instagram Ads'),(4103,'Facebook Pixel Id'),(4109,'Facebook product feed enabled'),(727,'Failed'),(728,'Failed to add detailed image'),(729,'Failed to add the attachment'),(730,'Failed to add the attachment. The file download is forbidden'),(2256,'Failed to load the banner {{value}} because it does not exist'),(2255,'Failed to load the file {{value}} because it does not exist'),(3513,'Failed to re-upload attachment'),(1885,'Failed to update category image'),(3744,'Failed to update page image'),(1906,'Failed write to file'),(337,'Failed write to file X. There may not be enough disc-space. Please check if there is enough disc-space.'),(731,'Failed/Declined'),(2690,'Failed[S]'),(1731,'Failure'),(1798,'Failure reason:'),(4669,'Failure sending test email to X'),(4661,'Failure to convert flexy-template. Check for syntax errors'),(3995,'Failure to finish registration process.'),(3996,'Failure to get token ID.'),(1583,'Failure: File has the wrong format.'),(4122,'Fast Lane checkout'),(3741,'Favicon'),(1665,'Fax'),(3506,'Featured'),(732,'Featured products'),(2637,'FedEx'),(3507,'FedEx module allows to use online shipping rates calculation via FedEx.'),(4182,'Feed generation & settings'),(4185,'Feed generation has been completed successfully.'),(4186,'Feed generation has been stopped.'),(4181,'Feed generation...'),(3690,'Fees payer'),(733,'Field is required!'),(4073,'File Attaching is mandatory for this product'),(4069,'File attachments are not allowed for this product'),(2740,'File can not be uploaded'),(3515,'File description'),(3493,'File is available by public URL'),(2425,'File is not an image'),(2426,'File is not uploaded'),(4713,'File name is too long, it should be less than 255 characters'),(1865,'File not found'),(3036,'File permissions'),(283,'File size exceeds the maximum size'),(734,'File title'),(3279,'File uploading'),(3179,'File uploading error 1'),(3180,'File uploading error 2'),(3181,'File uploading error 3'),(3182,'File uploading error 4'),(3183,'File uploading error 6'),(3184,'File uploading error 7'),(3185,'File uploading error 8'),(3026,'File uploads'),(4070,'File uploads forbidden by web server'),(2797,'File was successfully uploaded'),(4220,'File with certificate should be located in the directory {{certsDir}}'),(2603,'Files cannot be updated'),(4589,'Fill out the form with your Company info to setup your account and start processing payments immedately'),(4236,'Filter by order amount'),(4234,'Filter by order frequency'),(4238,'Filter by profile membership'),(4239,'Filter by specific products'),(2653,'Filter has been removed'),(2652,'Filter has been successfully saved'),(2486,'Filter transactions by status'),(3874,'Filters'),(1961,'Find countries'),(2139,'Find in Marketplace'),(1277,'Find language in marketplace'),(3843,'Find more customers on Google'),(1962,'Find states'),(2484,'Find transactions by ID'),(735,'Find us on'),(736,'Find us on Facebook'),(3280,'Finish'),(2545,'Finished operating as user'),(737,'First name'),(4266,'First name or last name are empty. Please add a new address to your address book or modify existing and fill in those fields in order to subscribe to this list.'),(4556,'First name, Last name or E-mail'),(2901,'First, restore your website from the created backup - this is the fastest way to get your store back online.'),(4124,'Firstname'),(738,'Flat markup'),(2589,'Flat shipping charge per item ordered.'),(2591,'Flat shipping charge per weight unit ordered (for example, per pound or per kilogram - depending on the weight units used by your store).'),(2588,'Flat shipping charge. This value will be added to the shipping rate regardless of the weight, price and number of items ordered.'),(4656,'Flexy templates have been removed'),(4648,'Flexy to twig converter'),(4649,'Flexy-template'),(4663,'Flexy-to-twig converter warning'),(739,'Footer menu'),(2027,'For any emergency you can use the hard, soft and restore-state links'),(1686,'For details refer to'),(7,'For details refer to X-Cart license'),(740,'For the period'),(2109,'Force customer to choose product options before the product can be added to cart'),(1775,'Forgot password'),(741,'Forgot password?'),(1535,'Forgot your password?'),(742,'Format'),(2303,'Four-digit number on the front side of your card'),(43,'Free'),(3211,'Free & paid'),(743,'Free add-ons'),(2169,'Free license is activated successfully'),(4145,'Free shipping'),(4148,'Free shipping tooltip text'),(4160,'Free shipping update import text'),(4159,'Free shipping update text'),(4154,'Freight'),(4105,'Frequency of Product Feed renewal'),(4162,'Froala Editor settings'),(744,'From'),(86,'From computer'),(752,'From email'),(1825,'Front page'),(2773,'Front page title'),(3409,'Full Name'),(753,'Full description'),(754,'Full name'),(3684,'Funding methods (checkout page)'),(2016,'G'),(3046,'GDlib extension'),(755,'General'),(756,'General Settings'),(757,'General info'),(2777,'General options'),(758,'General settings'),(3730,'General tax rates'),(4180,'Generate Google Feed'),(4195,'Generate Google Product feed'),(4101,'Generate Product Feed'),(3831,'Generate XML-Sitemap'),(4436,'Generate cache on the fly'),(4173,'Generate feed'),(4112,'Generate product feed'),(2368,'Generate resized images'),(2369,'Generate resized images help text'),(3830,'Generate sitemap'),(4379,'Geo settings & company info are all set. Congrats!'),(4168,'Geolocation header promo'),(1590,'Get CSV'),(3847,'Get Started'),(3821,'Get X off for order amount over Y'),(2739,'Get a more customizeable PDF invoice solution for your store'),(2736,'Get a more powerful banner system for your store'),(2732,'Get information[TT]'),(4450,'Get params'),(2561,'Get shipping rates from major shipping carrier companies.'),(3808,'Get started Now! Click here to create your PITNEY BOWES Postage Account'),(3840,'Get your products found on Google in a few steps. Click the \"%s\" button to get started!'),(3811,'Girth'),(759,'Give buyers a way to pay by adding an alternative payment method.'),(760,'Give buyers another way to pay by adding an alternative payment method'),(1882,'Global'),(2153,'Global & Classes attributes'),(4201,'Global Hidden field'),(4200,'Global Plain field'),(4202,'Global Textarea'),(4203,'Global Yes/No'),(1881,'Global attributes'),(3475,'Global eGood settings'),(4044,'Global product tabs'),(4050,'Global tab label'),(4048,'Global tab not found'),(4404,'Go on, make your first sale.'),(761,'Go to Marketplace'),(762,'Go to checkout'),(26,'Go to checkout as a New customer'),(4013,'Go to comparison table'),(4678,'Go to different page to edit the content'),(1264,'Go to home page'),(4542,'Go to see the review [in the Admin area]'),(4368,'Good job! You company logo is added'),(3330,'Good password'),(3839,'Google Ads'),(3524,'Google Analytics'),(4172,'Google Feed URL: X'),(4179,'Google Feed has not been generated yet'),(4183,'Google Shopping Group'),(4196,'Google feed'),(4190,'Google product feed'),(4178,'Google shopping group'),(41,'Grand total'),(2869,'Greeting'),(172,'Greetings, X'),(763,'Grid'),(764,'Group options'),(2269,'Group {{value}} does not exists and will be created'),(4274,'Groups'),(4088,'HPP Key'),(766,'HTML title (\'title\' tag)'),(3052,'HTTPS bouncers'),(767,'HTTPS check'),(1897,'HTTPS option has been disabled'),(1896,'HTTPS option has been successfully enabled'),(768,'HTTPS settings'),(2556,'Handling fee'),(1762,'Hard reset (disables all modules and runs application)'),(2904,'Hard reset. Disable all addons except those provided by X-Cart Team'),(4449,'Hash'),(2458,'Hash file for installed entry \"{{entry}}\" doesn\'t exist or is not readable'),(773,'Have a discount coupon?'),(3417,'Have more coupons?'),(2623,'Haven\'t found what you\'re looking for? View more shipping modules'),(2870,'Header'),(2868,'Header, greeting & signature'),(2053,'Height'),(774,'Height (px)'),(227,'Hello, user'),(103,'Help'),(775,'Help zone'),(776,'Here are shown only the methods enabled on the configuration page'),(765,'Here is a new link for access to your information: X'),(4369,'Here is the way it looks like on desktop & mobile devices. Do you like it?'),(777,'Here you can define how your payment methods will look in customer area'),(1540,'Here you can define how your payment methods will look in customer area.'),(4386,'Here you can manually define your shipping rates and etc.'),(2583,'Here you can provide general information about the shipping method and configure a table defining how shipping rates for this method should be calculated.'),(4273,'Here you can view and manage the MailChimp news lists and groups of the user.'),(4769,'Hidden X messages'),(1921,'Hidden attributes'),(1922,'Hidden field'),(4440,'Hidden from products filter'),(778,'Hide'),(4594,'Hide \"How to use\" instruction'),(2716,'Hide all warnings/errors'),(2798,'Hide and make them available only via a direct link'),(1185,'Hide common settings'),(4711,'Hide converted templates'),(4770,'Hide message history'),(3794,'Hide the carrier shipping charge on the label'),(3793,'Hide total carrier charge'),(779,'Hide trailing zeros in fractional part'),(4792,'Hide vendor’s products in the order'),(4015,'High - Low'),(4675,'Highlight labels'),(780,'History'),(3490,'History of downloads'),(781,'Home'),(4696,'Home page'),(2785,'Home page title and meta'),(3281,'Hot addons'),(2527,'How do I move X-Cart?'),(4506,'How do you rate this item?'),(782,'How to'),(783,'How to back up your store database'),(2584,'How to define shipping rates'),(784,'How to define shipping zones'),(3072,'How to set up free shipping help'),(2455,'Human readable and SEO friendly web address for the page.'),(178,'I accept Terms and Conditions'),(785,'I agree that these addons may require an adaptation.'),(3607,'I agree with PayPal terms & conditions'),(2292,'I confirm that I have created backups of my store\'s files and database before upgrading the store'),(3085,'I have a license key'),(4383,'I sell digital goods or services and do not need to set up shipping'),(2114,'I understand that the following disabled modules will be removed.'),(4359,'I\'ll do it later'),(4287,'ID'),(4461,'IMPORTANT:'),(2004,'IN'),(3587,'IPN HTTP error'),(3586,'IPN verification failed'),(786,'Icons'),(787,'Identity'),(3207,'If a category has subcategories, the value in brackets shows the overall number of products in both that category and all its subcategories.'),(3254,'If the category is disabled, the system will return 404.'),(3252,'If the product is not available for sale, the system will return 404 response.'),(3253,'If the product is not available for sale, the system will return 404.'),(788,'If there are some critical errors occurred you can do the following'),(789,'If you choose the second option, you can download the file from the server later on and delete it from the server by clicking on the \'Delete SQL file\' button.'),(1548,'If you choose to create SQL file, you will be able to download the file from the server later and after that delete it from the server by clicking on the \"Delete SQL file\" button.'),(1263,'If you continue having trouble finding what you are looking for please contact our customer service department.'),(790,'If you do not have an account, you can easily'),(3344,'If you do not have seller account, you can register here: USA UK Germany'),(791,'If you don\'t have a moneybookers account yet, please sign up for a free moneybookers account at: http://www.skrill.com'),(792,'If you have a license key for a commercial module, you can enter it here to register the purchase of the appropriate module.'),(793,'If you have a plugin in the .tar format, you can install it by uploading it here'),(1561,'If you have multiple products sharing the same set of attributes, it makes sence to make them to be of the same product type and create the attributes on the product type level.'),(2514,'If you purchased a template but do not see it here, activate the license key that was provided to you.'),(2905,'If you still need help, please, feel free to contact X-Cart Help Desk at helpdesk@x-cart.com.'),(292,'If you store product images in the database, they are included in the SQL dump file'),(3456,'If you want the coupon discount to be applied only to products from specific categories, specify these categories here.'),(3940,'If you want to enable merchant registration wizard once again, please click on the following link'),(1546,'If you want to upload the backup of another X-Cart installation, ensure that you have completed the steps described here'),(2032,'If your store is crashed after upgrade, you can recover it'),(2799,'Ignore membership'),(794,'Image'),(190,'Image X'),(795,'Image border will not be displayed in customer\'s frontend'),(796,'Image has been identified as a duplicate and has not been imported'),(3106,'Image quality after resize'),(2146,'Image resized: X out of Y'),(2150,'Image resized: X out of Y with errors'),(3128,'Image resizing requires libraries'),(116,'Images'),(2366,'Images resized'),(2382,'Images resized: {{count}}'),(3682,'Immediate'),(3375,'Immediate Charge'),(797,'Import'),(798,'Import / Export'),(3214,'Import and Export'),(1515,'Import by CSV'),(3565,'Import from CSV file'),(799,'Import from file'),(2151,'Import has been cancelled.'),(2429,'Import language'),(1964,'Import language from CSV file'),(259,'Import mechanism does not know the field of X and it can not be imported'),(1978,'Import mode'),(1981,'Import mode comment'),(2800,'Import results'),(1507,'Import settings'),(800,'Import/Export'),(2390,'Import/Export guide'),(801,'Important'),(4158,'Important info on the Free shipping addon update'),(2360,'Imported'),(2361,'Importing data...'),(256,'Importing will overwrite the existing product information. This operation cannot be undone.'),(2282,'In advanced mode you can choose specific modules for upgrade.'),(3713,'In catalog only'),(802,'In category'),(1541,'In order to accept credit cards payments you should install the necessary payment module from our Marketplace.'),(2686,'In progress[S]'),(803,'In stock'),(4435,'In stock only'),(3913,'In store currency (0 - do not use coverage)'),(4584,'In the form that opens, paste the \"Webhook URL\" value into the field \"URL to be called\" and click \"Add endpoint\".'),(4583,'In the section \"Endpoints receiving events from your account\", click \"+ Add endpoint\".'),(2457,'In this section you can review the recent payment transactions that have taken place at your store'),(804,'Inactive'),(2668,'Inactive license key ({{key}})'),(805,'Incl. X'),(4113,'Include out of stock products into feed'),(3719,'Include response in hash'),(249,'Including X'),(1576,'Including subcategories'),(1719,'Incomplete'),(806,'Incompleted'),(2748,'Incorrect amount'),(280,'Incorrect owner of X directory'),(282,'Incorrect owner of X file'),(2493,'Incorrect password. Please try again.'),(2747,'Incorrect permissions'),(3841,'Increase sales and revenue with Google Shopping Ads.'),(3731,'Individual settings for every rate'),(2801,'Info'),(4571,'Information'),(2687,'Initialized[S]'),(2802,'Initializing...'),(4677,'Inline editor'),(4626,'Inline editor is unavailable due to TinyMCE'),(807,'InnoDB engine support enabled'),(2125,'Input data'),(3339,'Insight: Boost your sales with Google Ads addon'),(808,'Install'),(4688,'Install Google Tag Manager'),(4281,'Install Mailchimp addon'),(3168,'Install TaxJar integration'),(809,'Install add-on'),(1966,'Install addons'),(2846,'Install anyway'),(810,'Install updates'),(2431,'Installation date'),(811,'Installation directory'),(3282,'Installation requirements'),(3010,'Installation script'),(2534,'Installation warnings'),(812,'Installed'),(3210,'Installed Addons'),(813,'Installed Modules'),(814,'Installed modules'),(1656,'Installed version'),(3174,'Installing addons'),(815,'Installing updates, please wait...'),(3790,'Insurance value'),(2621,'Integration with'),(2952,'Integrity check'),(2963,'Integrity check has been completed successfully.'),(2964,'Integrity check has been stopped.'),(2962,'Integrity has not yet been checked. Initiate an integrity check by clicking the button \"Refresh integrity status\".'),(592,'Internal server error'),(4413,'International: phone'),(816,'Invalid login or password'),(817,'Invalid login or password. You can use forgot password form to create a new password.'),(3882,'Inventory'),(1898,'Inventory has been successfully updated'),(818,'Inventory status'),(819,'Inventory tracking'),(3558,'Inventory tracking for product X will not be imported'),(820,'Inventory tracking for this product is'),(2803,'Inventory tracking is'),(2176,'Inventory tracking options'),(821,'Invoice'),(1834,'Invoice #{{orderId}}, {{time}}'),(206,'Invoice X'),(2058,'Invoice number prefix'),(3500,'Ip'),(3787,'Irregular parcel girth'),(1803,'Issue no'),(822,'It is impossible to delete or create user accounts because your store currently works as an integration with Drupal and shares users with Drupal. Deleting/creating user accounts is possible via Drupal administrator interface.'),(823,'It is impossible to edit some user profile fields because your store currently works as an integration with Drupal and shares users with Drupal. Modifying these fields is possible via Drupal administrator interface.'),(1495,'It\'s impossible to detect valid SSL certificate availability on your server because curl extension is not installed.'),(3395,'It\'s recommended to limit the length of invoice prefix to 9 characters'),(1928,'Item'),(824,'Item description'),(825,'Item has been deleted from cart'),(1844,'Item has not been deleted from cart'),(2856,'Item list'),(826,'Item name'),(2225,'Item not found ({{keys}})'),(212,'Items'),(160,'Items in your cart: X'),(827,'Items per page'),(2573,'Items range'),(364,'JANUARY'),(370,'JULY'),(369,'JUNE'),(4024,'Joe'),(828,'Join forces with your bank'),(477,'Joined'),(2946,'Just enter email address'),(829,'K'),(2015,'KG'),(3845,'Keep your marketing and store in sync'),(1470,'Key is validated, but the module X was not found'),(104,'Knowledge Base'),(4409,'Knowledge base'),(2013,'LB'),(1919,'Label'),(3791,'Label format'),(133,'Label name'),(3792,'Label size'),(1911,'Labels'),(4630,'Labels editor'),(830,'Language'),(831,'Language labels'),(140,'Language name in X'),(98,'Language options'),(1579,'Language:'),(102,'Languages'),(1743,'Last 24 hours'),(1744,'Last 7 days'),(162,'Last added items'),(3069,'Last element of category path should be same as name'),(3338,'Last exported'),(832,'Last logged in'),(833,'Last login'),(1745,'Last month'),(834,'Last name'),(2302,'Last three numbers on the back side of your card'),(2895,'Last time re-deployed at'),(2461,'Last week'),(2463,'Last year'),(4125,'Lastname'),(4402,'Launch (Paypal Onboarding)'),(3848,'Launch Google Shopping ads and get your products found online easily.'),(3605,'Launch PayPal'),(2213,'Layout'),(4676,'Layout block'),(4628,'Layout editor'),(4640,'Layout editor allows you to change the position of the blocks in drag-n-drop fashion'),(4632,'Layout editor is'),(4639,'Layout editor is disabled'),(4638,'Layout editor is enabled'),(2518,'Layout has been changed. Review the updated storefront.'),(2510,'Layout type'),(4689,'Layout was successfully reset'),(2311,'Learn More'),(4685,'Learn more about Google Tag Manager'),(82,'Learn more about the top banner and how it shows in the page layout'),(2312,'Learn more.'),(3951,'Leave at door'),(2507,'Leave blank to use category name as Page Title.'),(4310,'Leave blank to use news title as Page Title.'),(3759,'Leave blank to use page name as Page Title.'),(2495,'Leave blank to use product name as Page Title.'),(3324,'Left in stock: {{quantity}}'),(2051,'Length'),(1565,'Length x Width x Height'),(1780,'Less search options'),(3165,'Let TaxJar automate your sales tax calculations, reporting, and filings in minutes.'),(4729,'Letter center'),(4344,'Let’s setup your store'),(8,'License activation is not available'),(1476,'License is not received'),(2441,'License key'),(2437,'License key has been successfully verified and activated for \"{{name}}\" module by \"{{author}}\" author.'),(835,'License key has been successfully verified for \"{{name}}\" module by \"{{author}}\" author'),(2671,'License key is missing'),(3089,'License key registration'),(2667,'License warning'),(3283,'License warnings'),(2430,'License: trial version'),(836,'Lifetime'),(3433,'Limit number of uses'),(837,'Limit the number of uses'),(2143,'Lines checked: X out of Y'),(2144,'Lines imported: X out of Y'),(2148,'Lines imported: X out of Y with errors'),(2147,'Lines verified: X out of Y with errors'),(838,'Link'),(839,'List'),(840,'List of states'),(4246,'List rating'),(1993,'Live'),(2082,'Live mode'),(2854,'Loading more results...'),(1876,'Loading the database from file .'),(841,'Loading...'),(842,'Localization'),(4169,'Location is invalid'),(4166,'Location was successfully set'),(2090,'Locked'),(3997,'Log all communications between shopping cart and Canada Post server'),(2421,'Log files not found'),(843,'Log in'),(2738,'Log in as this admin'),(239,'Log off'),(844,'Log out'),(845,'Logged as'),(3751,'Logged in users only'),(238,'Logged in!'),(846,'Login'),(1795,'Login Here'),(2424,'Login dates'),(847,'Login here'),(848,'Login history'),(2804,'Login is locked out'),(2947,'Login to your account'),(1931,'Login/E-mail'),(3740,'Logo'),(3753,'Logo & Favicon'),(3004,'Logout this user'),(849,'Look & Feel'),(3064,'Loopback request'),(1690,'Loopback test'),(4016,'Low - High'),(319,'Low inventory products'),(850,'Low limit notification for this product is'),(851,'Low limit quantity'),(852,'Low stock'),(2462,'Low stock info'),(3895,'Low stock notification to admin'),(3894,'Low stock warning on product page'),(853,'M'),(366,'MARCH'),(3651,'MATCH_CRITERIA_DISABLED'),(3648,'MATCH_CRITERIA_HELP'),(3649,'MATCH_CRITERIA_NAME'),(3650,'MATCH_CRITERIA_NONE'),(368,'MAY'),(3717,'MD5 hash value'),(2001,'MM'),(357,'MO'),(2298,'MONTH'),(4221,'MailChimp'),(4222,'MailChimp Integration with E-commerce support'),(4227,'MailChimp Lists'),(4225,'MailChimp is an email marketing service with powerful tools to manage your email campaigns and subscribers while gathering advanced analytics information on your campaign performance.'),(4270,'MailChimp list group names'),(4269,'MailChimp list groups'),(4228,'MailChimp list segments'),(4288,'MailChimp lists'),(4265,'MailChimp lists update'),(4229,'MailChimp segment settings'),(4289,'MailChimp settings'),(3930,'Mailing tube'),(121,'Main categories'),(854,'Maintenance'),(855,'Maintenance and operation'),(2859,'Major improvements and new features'),(2858,'Major upgrade'),(2503,'Make a discount available to all customers or only to specific membership levels;'),(856,'Make back-up of your store database'),(3856,'Make changes to your active campaigns, purchase one you built, or reinstate your cancelled campaigns.'),(4759,'Make mutual relations'),(3189,'Make sure the URL is correct and the file referenced by the URL is a PNG/JPG/JPEG'),(1874,'Making backup of the current database state ... '),(3855,'Manage Campaigns'),(864,'Manage admins'),(1871,'Manage attribute groups'),(857,'Manage catalog'),(858,'Manage categories'),(342,'Manage category (X)'),(859,'Manage customer and administrator accounts'),(4042,'Manage global tabs'),(1681,'Manage groups'),(860,'Manage layout'),(3194,'Manage logo dimensions'),(861,'Manage orders'),(862,'Manage orders placed at your store'),(1560,'Manage product classes'),(4290,'Manage segments'),(863,'Manage users'),(4396,'Manage your payment options'),(865,'Manage your product inventory'),(2805,'Manage zones'),(866,'Mandatory fields are marked with an asterisk'),(3922,'Manifest ID'),(3921,'Manifests'),(4447,'Manual'),(3561,'Manually'),(867,'Manually defined shipping methods'),(4799,'Mark all'),(4800,'Mark selected'),(868,'Mark, the search engines you want to inform of the structure of your site using the site map'),(869,'Market price'),(2806,'Marketing'),(870,'Marketplace'),(871,'Marketplace [check_addon_key]: the \"{{url}}\" URL requested'),(872,'Marketplace [check_for_updates]: the \"{{url}}\" URL requested'),(873,'Marketplace [check_for_updates]: valid response received'),(874,'Marketplace [get_hosting_score]: response has an invalid format'),(875,'Marketplace [get_hosting_score]: the \"{{url}}\" URL requested'),(2288,'Marketplace-Vendor'),(876,'Markup per item'),(877,'Markup per weight unit'),(1776,'Max'),(4058,'Max allowed file size is X'),(3998,'Maximum Post Offices that will be displayed'),(2862,'Maximum items in box'),(1566,'Maximum number of items per box'),(3434,'Maximum number of uses'),(3429,'Maximum order subtotal must be greater than minimum order subtotal'),(3441,'Maximum order subtotal the coupon can be applied to'),(277,'Maximum size of the file to upload is N'),(1872,'Measuring productivity in manual mode failed.'),(4247,'Members count'),(878,'Membership'),(879,'Membership access'),(880,'Membership levels'),(881,'Membership name'),(882,'Memberships'),(3023,'Memory limit'),(2088,'Menu'),(3743,'Menu links help text'),(883,'Menus'),(3576,'Merchant login'),(3938,'Merchant registration wizard'),(205,'Merge with Registered'),(884,'Message'),(3406,'Message has been sent'),(4763,'Message not found'),(4762,'Messages'),(84,'Meta desc'),(885,'Meta description'),(886,'Meta keywords'),(83,'Meta tags'),(2414,'Method name'),(887,'Methods'),(3428,'Minimum order subtotal must be less than maximum order subtotal'),(3440,'Minimum order subtotal the coupon can be applied to'),(2807,'Minimum value is X'),(2860,'Minor improvements'),(2857,'Minor update'),(2959,'Modified files'),(1563,'Modifiers'),(888,'Modify'),(889,'Modify \"{{name}}\" option group'),(890,'Modify category'),(891,'Modify option groups exceptions'),(892,'Modify root category (the front shop page)'),(3838,'Module Kliken\\GoogleAds was unable to access your store\'s catalog . Please make sure the correct Account Id and Application Token are saved, or contact Kliken for support.'),(2389,'Module Marketplace. Terms of use'),(129,'Module available editions 3'),(130,'Module available editions 4'),(893,'Module has been successfully installed'),(3284,'Module name'),(1867,'Module packing is available in the DEVELOPER mode only. Check etc/config.php file'),(2399,'Module page'),(4388,'Module settings (shipping_rates)'),(1490,'Module with ID X is not found'),(1661,'Module\'s page'),(2808,'Modules'),(1481,'Modules have been successfully installed'),(1899,'Modules license agreements'),(3285,'Monday'),(4781,'Monitoring of communication related to oder #X has been disabled'),(4780,'Monitoring of communication related to oder #X has been enabled'),(383,'Month'),(1815,'More'),(1968,'More actions for selected'),(895,'More add-ons'),(2611,'More attributes'),(896,'More details'),(2039,'More info is available in X-Cart\'s Knowledge Base article \'What to do if you cannot access your store...\''),(593,'More information about clean urls in X-Cart is available in '),(646,'More information on Clean URL problems on your system'),(4585,'More information on the setup of webhooks is available here: https://stripe.com/docs/webhooks#configuring-your-webhook-settings'),(4376,'More localisation settings'),(1781,'More search options'),(2645,'More shipping solutions'),(897,'Most Popular'),(898,'Most Rated'),(899,'Move'),(3964,'Move item'),(3892,'Move to'),(2009,'Mr.'),(2011,'Mrs.'),(2010,'Ms.'),(3529,'Multiple top-level domains'),(4747,'Mutual link'),(4757,'Mutual link head help'),(4416,'My Shipping'),(900,'My account'),(3119,'My addons'),(4163,'My location'),(3123,'My profile'),(3132,'My purchases'),(4387,'My shipping'),(3044,'MySQL cache'),(901,'MySQL server'),(3040,'MySQL version'),(125,'N it.'),(96,'N items found'),(124,'N items total'),(374,'NOVEMBER'),(902,'Name'),(1916,'Name asc'),(1917,'Name desc'),(4418,'Name length must be less then {{length}}'),(906,'Name of account holder'),(903,'Name of address field'),(904,'Name of purchaser'),(1559,'Name, e.g. Apparel'),(1034,'Name-sort-option'),(2344,'Names, descriptions & sorting'),(141,'Native language name'),(3615,'Near \"Add to cart\" button'),(3616,'Near \"Checkout\" button'),(3161,'Need a customizable contact us form with location map? [Get it now!]'),(20,'Need a license key?'),(3103,'Need a way to set multicurrency prices? [Install the addon]'),(3104,'Need a way to set up product variants? [Install the addon]'),(3105,'Need a way to set wholesale prices? [Install the addon]'),(2516,'Need custom design? We can modify this template or create a completely unique design for you'),(4405,'Need help setting up your store?'),(1683,'Need license key?'),(1542,'Need more payment methods?'),(907,'Never'),(1614,'New Export'),(4036,'New Tab'),(2401,'New access codes were generated.'),(909,'New access key will also be sent to the Site administrator\'s email address'),(908,'New access link'),(2380,'New account'),(1534,'New address'),(910,'New address field'),(3704,'New arrivals'),(1680,'New attribute'),(2259,'New attribute group will be created'),(119,'New category'),(2699,'New customer note'),(911,'New discount coupon'),(1613,'New group'),(912,'New image'),(1501,'New import'),(913,'New item'),(110,'New membership'),(4798,'New message'),(4771,'New message for order'),(4790,'New messages'),(2117,'New module version available for core versions X'),(2465,'New modules'),(4299,'New news message'),(914,'New page'),(3965,'New parcel'),(915,'New product class'),(916,'New product has been added successfully'),(4533,'New product reviews'),(917,'New rate'),(918,'New role'),(1760,'New safe mode access key has been generated'),(3732,'New sale tax rate'),(2190,'New staff note'),(4035,'New tab'),(4453,'New tag'),(1302,'New tax class'),(2547,'New to Avalara?'),(25,'New to our store?'),(1741,'New user registered'),(1612,'New value'),(168,'New zone has been created successfully'),(3705,'New!'),(919,'Newest'),(920,'Newest first'),(4300,'News'),(4232,'News list subscriptions'),(4298,'News message'),(4297,'News messages'),(4308,'News page title'),(4309,'News title'),(4323,'Newsletters'),(921,'Next'),(4304,'Next news'),(3101,'Next order'),(922,'Next page'),(33,'Next product'),(4143,'Next step'),(77,'Next wizard'),(923,'No'),(1409,'No Curl extension for PHP error'),(1410,'No OpenSSL extension for PHP error'),(3550,'No PIN codes found.'),(1408,'No Phar extension for PHP error'),(2945,'No account yet?'),(2619,'No accounting system has been selected yet. Choose your accounting system below and configure it.'),(1574,'No attributes'),(1682,'No attributes are defined for the product class yet.'),(1575,'No attributes assigned'),(2979,'No category assigned'),(1857,'No category defined'),(2166,'No class'),(4730,'No confirmation'),(924,'No countries found'),(1999,'No delimiter'),(4559,'No email'),(3908,'No events found'),(925,'No featured products defined for this category'),(3186,'No file was uploaded'),(4655,'No flexy-templates found.'),(1573,'No group'),(4291,'No groups defined'),(926,'No image'),(927,'No images uploaded'),(2405,'No items found'),(928,'No items found.'),(3981,'No items have been selected for return.'),(394,'No membership'),(929,'No merchant account required'),(498,'No merchant account required. Simple onboarding for you and easy checkout for your customers.'),(2406,'No model selected'),(1652,'No modules found'),(97,'No modules found for search_string'),(930,'No order have been placed yet'),(326,'No order on last day'),(329,'No order on last lifetime'),(328,'No order on last month'),(327,'No order on last week'),(330,'No orders'),(4665,'No orders available. Please create at least one order.'),(931,'No orders have been placed yet'),(101,'No other languages defined'),(1847,'No payment method selected'),(1848,'No payment methods found based on the selected criteria'),(932,'No payment modules installed'),(3553,'No pin codes are bought yet'),(1609,'No pre-defined value'),(1558,'No product class assigned'),(1654,'No products found'),(4425,'No products have been selected for comparison.'),(3877,'No products matching the current filtering criteria were found. Try clearing filters.'),(4432,'No products matching your criteria found. Please try again with different parameters.'),(933,'No products sold yet'),(1655,'No profiles found'),(2343,'No promotion modules installed'),(2528,'No region'),(2852,'No results found.'),(4520,'No reviews.'),(3155,'No roundup'),(4292,'No segments'),(934,'No states found'),(4244,'No subscription'),(1536,'No such user'),(935,'No tax rate defined'),(1172,'No tracking numbers are defined'),(1653,'No users found'),(3539,'No valid code found.'),(3795,'Non delivery option'),(936,'Non-administrator'),(3286,'Non-critical'),(3999,'Non-delivery instructions'),(229,'None'),(4331,'Not Finished orders were skipped during the export process. If you wish to export the orders which are now in this state, change their fulfillment status from Not Finished to any other.'),(2980,'Not assigned'),(3287,'Not available'),(1692,'Not detected'),(2028,'Not enough disk space. Required: {{req}} (+{{reserve}} reserve). Available: {{avail}}'),(4712,'Not enough permissions to update the template file'),(937,'Not finished'),(4326,'Not finished order'),(938,'Not numeric'),(4521,'Not rated yet'),(2617,'Not seeing your accounting software here? Let us know'),(1591,'Not selected'),(3893,'Not set'),(3943,'Not specified'),(939,'Note'),(2050,'Note: a new window will be opened'),(940,'Notes'),(2336,'Notification'),(2872,'Notification state'),(2713,'Notify administrator if the stock quantity of this product goes below a certain limit'),(941,'Notify administrator inactivity help'),(1727,'Now disabled'),(4394,'Now you can define how shipping rates should be calculated based on  delivery time, weight and other parameters.'),(1581,'Number of ignored rows:'),(373,'OCTOBER'),(4715,'OK'),(1672,'OR'),(2014,'OZ'),(2776,'Object name (category, product, etc)'),(2768,'Object name order first'),(2769,'Object name order last'),(3641,'Obtaining your live PayPal credentials'),(942,'Off'),(943,'Official website'),(4398,'Offline method'),(944,'Offline methods'),(3076,'Ok, Got it'),(2698,'Old customer note'),(945,'Old price'),(2189,'Old staff note'),(946,'On'),(947,'On all catalog pages'),(4731,'On call air'),(3714,'On catalog and product pages'),(2917,'On category and product details page'),(2916,'On category listing'),(3934,'On delivery'),(3933,'On exception'),(4511,'On moderation'),(948,'On product details only'),(3723,'On sale'),(3932,'On shipment'),(4417,'Onboarding Wizard'),(1292,'Once links are regenerated, they will be sent to store administrator email.'),(4129,'One Page checkout'),(2217,'One column'),(3528,'One domain with multiple subdomains'),(4732,'One time pickup'),(949,'Online catalog structure setup'),(4399,'Online method'),(435,'Online methods'),(2136,'Online orders'),(2714,'Only X left in stock'),(4516,'Only customers who purchased this product can leave feedback on this product'),(113,'Only disabled'),(112,'Only enabled'),(1866,'Only enabled modules can be packed'),(2915,'Only orders awaiting processing'),(950,'Only small letter, digits and undescore sign are allowed'),(3317,'Oops, no products have been added to this category yet.'),(1938,'Open'),(951,'Open Graph meta tags'),(4787,'Open a dispute'),(4776,'Open dispute'),(3755,'Open graph image'),(952,'Open graph tags'),(4679,'Open home or category pages for more opportunities to adjust the website structure'),(4248,'Open rate'),(953,'Open storefront'),(4582,'Open the page \"Webhooks\" in the \"Developers\" section of dashboard.stripe.com: https://dashboard.stripe.com/account/webhooks'),(4683,'Open the storefront while logged in as administrator to change the look & feel of the store.'),(3852,'Open your dashboard to review your campaign\'s performance'),(2541,'Operate as user'),(954,'Operating system'),(3345,'Operation mode'),(955,'Option group'),(3390,'Option values has been successfully updated.'),(2809,'Options'),(956,'Options have been successfully changed'),(2395,'Options:'),(3140,'Or add a video review powered by ShopperApproved'),(3627,'Or register with'),(3626,'Or sign in the classic way'),(3630,'Or use your social account'),(957,'Order'),(958,'Order #'),(265,'Order #X, Y'),(1959,'Order #{{id}}'),(1969,'Order #{{id}} details'),(3498,'Order #{{value}} doesn\'t contain any e-goods'),(3563,'Order #{{value}} doesn\'t have any associated pin codes'),(959,'Order ID'),(2662,'Order QTY'),(960,'Order Total'),(299,'Order Total X'),(266,'Order X'),(2999,'Order X has been confirmed as delivered to the customer'),(1516,'Order by'),(1823,'Order can not be placed because not all required fields are completed. Please check the form and try again.'),(4134,'Order cannot be placed because some steps are not completed'),(2810,'Order cannot be placed because there is no shipping methods available.'),(2206,'Order changes cannot be saved due to negative total value'),(3163,'Order customer notes changed'),(2659,'Order date'),(961,'Order date from'),(962,'Order date through'),(3546,'Order deleted'),(963,'Order details'),(2432,'Order failed'),(3494,'Order fulfilment status changed from {{oldStatus}} to {{newStatus}} by file download'),(3164,'Order has been edited'),(1925,'Order history'),(964,'Order id'),(3588,'Order id prefix'),(3467,'Order is not processed'),(317,'Order is placed'),(2200,'Order item attributes are out-of-date and cannot be edited'),(2936,'Order item modifier not found'),(965,'Order items'),(2927,'Order modifier not found'),(1846,'Order not found'),(966,'Order note'),(4130,'Order note. Any special needs?'),(1788,'Order number'),(2811,'Order number or email'),(967,'Order page'),(1774,'Order payment'),(2122,'Order payment status changed from {{oldStatus}} to {{newStatus}}'),(3765,'Order prefix'),(968,'Order review'),(2123,'Order shipping status changed from {{oldStatus}} to {{newStatus}}'),(3162,'Order staff notes changed'),(969,'Order statistics'),(970,'Order status'),(2107,'Order status changed from {{oldStatus}} to {{newStatus}}'),(4028,'Order statuses'),(1169,'Order tracking information'),(2940,'Order transaction status not found'),(2942,'Order transaction type not found'),(2201,'Order will be delivered to the billing address.'),(2758,'OrderBy position number must be specified as a non-negative integer.'),(344,'OrderID or email, ID1-ID2 for range'),(3353,'OrderId prefix'),(3484,'Ordered files'),(3961,'Ordered qty'),(971,'Orders'),(2913,'Orders awaiting processing'),(972,'Orders count'),(2665,'Orders has been deleted successfully'),(4030,'Orders have this status tooltip'),(4235,'Orders last month'),(2383,'Orders list'),(973,'Orders placed'),(4765,'Orders with any messages'),(4764,'Orders with unread messages'),(2642,'Origin address'),(3335,'Original name'),(226,'Other'),(163,'Other items'),(4697,'Other pages'),(108,'Our Blog'),(3412,'Our location'),(1813,'Out of Stock'),(974,'Out of stock'),(3931,'Oversized'),(3029,'PDO extension'),(1694,'PHP \'gd\' extension is not installed.'),(3015,'PHP version'),(3540,'PIN'),(3555,'PIN code'),(3556,'PIN codes'),(3554,'PIN codes data have been successfully updated'),(3542,'PIN codes enabled'),(3559,'PIN codes generation method'),(3920,'PO Number'),(1067,'PO number'),(2137,'POS orders'),(3642,'PRIMARYRECEIVER'),(4087,'PS Store ID'),(975,'Pack it'),(1667,'Package'),(2073,'Package dimensions (inches)'),(4000,'Package height (cm)'),(4001,'Package length (cm)'),(4002,'Package maximum weight (kg)'),(2068,'Package properties'),(2045,'Package subtotal'),(2046,'Package subtotal (X)'),(2043,'Package weight'),(2044,'Package weight (X)'),(4003,'Package width (cm)'),(2072,'Packaging'),(2658,'Packing date'),(2656,'Packing slip'),(976,'Page'),(977,'Page URL'),(978,'Page name'),(979,'Page not found'),(2786,'Page title format'),(980,'Pages'),(981,'Paid'),(3914,'Parcel'),(3923,'Parcel characteristics'),(3786,'Parcel dimensions'),(3954,'Parcel is cannot be transmitted - wrong quote type'),(3953,'Parcel is cannot be voided or transmitted - wrong quote type'),(3912,'Parcel options'),(3784,'Parcel type'),(3785,'Parcel weight'),(3970,'Parcels have been successfully updated'),(982,'Parent category'),(2967,'Parent category name'),(2775,'Parent category path'),(353,'Partially refunded'),(3574,'Partner name'),(3288,'Passed'),(218,'Password'),(983,'Password and its confirmation do not match'),(377,'Past'),(4617,'Path for using in custom CSS'),(984,'Pattern search'),(3354,'Pay with Amazon'),(3632,'PayPal'),(3594,'PayPal API'),(3617,'PayPal API (Merchant API) will work for most merchants; however, some merchants may have access only to Payflow API.'),(3662,'PayPal API Client ID'),(3663,'PayPal API Secret'),(3665,'PayPal BN Code'),(3643,'PayPal Credit'),(3606,'PayPal Credit is'),(3691,'PayPal Express Checkout'),(3661,'PayPal For Marketplaces account email'),(3569,'PayPal ID / Email'),(3657,'PayPal Merchant ID'),(3664,'PayPal Partner ID'),(3608,'PayPal account email'),(497,'PayPal all-in-one solutions'),(3578,'PayPal recommends entering a User Login here instead of your Merchant Login'),(3376,'PayWithAmazon available actions'),(3636,'PayerID value was not returned by PayPal. Please try again. If the problem persists, contact the administrator.'),(3595,'Payflow API'),(2893,'Payment'),(3360,'Payment capture error: {{error}}'),(991,'Payment data ({{method}})'),(985,'Payment gateways'),(3366,'Payment has been authorized successfully.'),(3620,'Payment has been captured successfully'),(3359,'Payment has been captured successfully.'),(3367,'Payment has been declined.'),(3618,'Payment has been refunded successfully'),(3363,'Payment has been refunded successfully.'),(3619,'Payment has been voided successfully'),(3692,'Payment has bes refunded successfully'),(3695,'Payment have been voided successfully'),(3361,'Payment have been voided successfully.'),(986,'Payment info'),(987,'Payment instructions'),(2386,'Payment is not required'),(988,'Payment method'),(990,'Payment method data'),(2532,'Payment method has been added'),(1870,'Payment method has been added successfully'),(311,'Payment method has been disabled successfully'),(310,'Payment method has been enabled successfully'),(312,'Payment method has been removed successfully'),(313,'Payment method has not been configured properly'),(2346,'Payment method is disabled'),(2345,'Payment method is enabled'),(2422,'Payment method settings'),(2533,'Payment method was not added'),(989,'Payment methods'),(3289,'Payment order status'),(3859,'Payment processed with errors. Please, try again or ask administrator'),(3377,'Payment refresh error: {{error}}'),(3365,'Payment refund error: {{error}}'),(4215,'Payment return page requested without expected parameters'),(992,'Payment settings'),(2118,'Payment status'),(2926,'Payment status not found, \"Awaiting payment\" will be used for order'),(4032,'Payment status not found, new status will be created'),(4026,'Payment statuses'),(993,'Payment transaction ID'),(301,'Payment transaction X issued'),(3368,'Payment transaction is in progress...'),(994,'Payment transactions'),(3362,'Payment void error: {{error}}'),(300,'Payment was not finished'),(995,'Payments'),(3679,'Payments with this payment method are not allowed because HTTPS is not configured'),(3634,'Paypal capture warning message'),(3693,'Paypal login (email)'),(996,'Pending'),(233,'Pending membership'),(997,'Pending memberships'),(2689,'Pending[S]'),(998,'Per item markup'),(999,'Per weight unit markup'),(1000,'Percent'),(3824,'Percent discount value cannot exceed 100%'),(1001,'Percent markup'),(1002,'Percent off'),(1003,'Perform order search'),(1004,'Performance'),(2906,'Performing task...'),(3427,'Period end date must be later than period start date'),(3426,'Period start date must be sooner than period end date'),(1005,'Permissions'),(1006,'Permissions checking failed'),(1007,'Personal info'),(1318,'Personal info: The new password must not coincide with the current password for your account.'),(3049,'Phar extension'),(1008,'Phone'),(1009,'Pick address from address book'),(4605,'Pick template from page element'),(4673,'Pick templates from page'),(3521,'Pin'),(3520,'Pin It'),(3812,'PitneyBowes'),(1010,'Place order'),(180,'Place order X'),(2184,'Placed by NAME'),(2183,'Placed by _NAME_'),(1671,'Placed on'),(2182,'Placed on DATE'),(297,'Placed on X by Y'),(298,'Placed on X by Y link'),(1920,'Plain field'),(1650,'Please'),(1011,'Please accept the Terms and Conditions to continue'),(4014,'Please add another product to comparison'),(2971,'Please be warned that proper operation of the site after an upgrade is not guaranteed if you choose to upgrade only some of the components listed below.'),(1012,'Please choose the appropriate action'),(1582,'Please confirm if you want proceed with the import otherwise cancel the operation.'),(1284,'Please contact the module developers to make sure that these modules are compatible with the upcoming upgrade'),(2126,'Please create a new password'),(1013,'Please enable JavaScript in your web browser.'),(2855,'Please enter 3 or more characters'),(3405,'Please enter the correct captcha'),(1715,'Please enter the correct file location or set correct file permissions.'),(4569,'Please enter your encryption password (This is different from your merchant password). More info on encryption passwords is available <here>'),(1014,'Please identify yourself'),(1526,'Please make sure that \"min weight\", \"min total\", \"min items\", \"shipping zone\", \"shipping method\" fields do not overlap with other shipping rates.'),(1588,'Please make sure your file format is as described.'),(3936,'Please note that rates are calculated for shipping from Canadian locations only.'),(1015,'Please note that some of these modules are definitely incompatible with the upcoming upgrade and will be disabled in order to prevent the system crash'),(2379,'Please note that the following modules will also be enabled'),(3804,'Please note: the USPS Web tools APIs print labels without postage.'),(3093,'Please register your license key now or purchase a premium license to skyrocket your business.'),(2440,'Please renew your access to upgrades to get new superior features from the latest releases.'),(4544,'Please review purchased product {{product}}'),(4546,'Please review purchased products'),(1016,'Please run the benchmark test in order to estimate your server performance'),(1017,'Please save the soft reset and hard reset links so that you can use them later in case the website crash happens'),(3208,'Please select'),(391,'Please select a date range'),(390,'Please select a date range between %d and %d days'),(389,'Please select a date range less than %d days'),(388,'Please select a date range longer than %d days'),(1018,'Please select one'),(396,'Please select one ...'),(397,'Please select option'),(1840,'Please select other attribute'),(4197,'Please select the attributes first'),(2306,'Please select the countries first'),(3290,'Please select the entities first'),(2664,'Please select the orders first'),(1826,'Please select the products first'),(4530,'Please select the reviews first'),(2173,'Please select the states first'),(4455,'Please select the tags first'),(4489,'Please sign in to add review'),(149,'Please specify a pattern to find the required labels'),(1472,'Please specify non-empty key'),(128,'Please specify text labels for each language'),(3387,'Please update your payment information'),(2812,'Please wait'),(224,'Please, clarify your search request or search in Marketplace'),(1406,'Please, contact administrator'),(1722,'Please, enter a valid IP address'),(1721,'Please, enter a valid e-mail address'),(1705,'Please, enter unique membership name'),(1632,'Please, make sure that the following modules are installed and enabled:'),(3547,'Please, type in the new PIN codes one per line.'),(1660,'Popularity'),(1019,'Pos'),(1020,'Pos.'),(1021,'Pos.:'),(1022,'Position'),(2162,'Possible import file names are:'),(2164,'Possible reasons of data not found in import file'),(2048,'Postal Code'),(2054,'Postal/ZIP Code'),(1025,'Pre upgrade disabled modules hooks message body'),(1028,'Pre upgrade disabled modules hooks message footer'),(1024,'Pre upgrade disabled modules hooks message head'),(2602,'Pre-upgrade hooks cannot be run'),(1027,'Pre-upgrade off'),(1026,'Pre-upgrade on'),(1023,'Prefix'),(2165,'Premium license modules warning'),(1029,'Prev'),(4664,'Preview full email'),(1555,'Preview product page'),(381,'Previous'),(4303,'Previous news'),(3100,'Previous order'),(1030,'Previous page'),(32,'Previous product'),(222,'Price'),(3883,'Price and membership'),(1914,'Price asc'),(1915,'Price desc'),(1031,'Price modifier'),(4434,'Price range'),(1033,'Price-sort-option'),(1032,'Price: Not a numeric'),(2813,'Prices & Inventory'),(3766,'Pricing currency'),(1035,'Primary menu'),(1994,'Print'),(2624,'Print Shipping labels'),(3797,'Print custom message 1'),(3799,'Print custom message 2'),(1036,'Print invoice'),(2657,'Print packing slip'),(1995,'Print selected'),(2111,'Priority'),(2063,'Private'),(3291,'Private and custom modules:'),(3292,'Private link'),(3293,'Proceed'),(1510,'Proceed import'),(2888,'Proceed to payment'),(181,'Proceed to payment X'),(4339,'Proceed to the next step'),(1037,'Processed'),(1038,'Processed/Completed'),(2995,'Processing categories...'),(2365,'Processing products...'),(4325,'Product'),(4104,'Product Feed URL'),(1768,'Product ID'),(1039,'Product Name'),(1040,'Product SKU'),(1041,'Product Title'),(1042,'Product added to bag'),(2156,'Product attributes values'),(2160,'Product attributes values (Hidden field) has been imported'),(2158,'Product attributes values (Plain text) has been imported'),(2159,'Product attributes values (Textarea) has been imported'),(2157,'Product attributes values (Yes/No) has been imported'),(2404,'Product attributes values has been imported'),(1043,'Product class'),(1890,'Product class have been updated successfully'),(1891,'Product class name is empty'),(2268,'Product class {{value}} does not exists and will be created'),(1044,'Product classes'),(4175,'Product count'),(4102,'Product feed'),(4099,'Product feed generation has been completed successfully'),(4100,'Product feed generation has been stopped'),(1045,'Product has been added to cart'),(1843,'Product has not been added to cart'),(1046,'Product images'),(1047,'Product info'),(1048,'Product info has been updated successfully'),(1049,'Product is out of stock'),(3891,'Product list'),(223,'Product name'),(3562,'Product not found'),(1050,'Product on sale'),(1051,'Product options'),(4741,'Product or product variant with SKU \"{{value}}\" not found'),(1052,'Product page title'),(1053,'Product prices are defined including this tax calculated for'),(3465,'Product removed'),(4470,'Product reviews'),(4039,'Product tabs'),(4454,'Product tags'),(2262,'Product with SKU \"{{value}}\" does not exists'),(4738,'Product with SKU \"{{value}}\" not found'),(2187,'Product with selected properties cannot be purchased'),(4482,'Product, SKU or customer info'),(1892,'Product-Specific'),(1893,'Product-Specific attributes'),(4198,'Product-specific'),(2261,'ProductSKU is empty'),(1054,'Products'),(4740,'Products and product variants updated'),(1519,'Products found'),(1903,'Products imported'),(1055,'Products in bag'),(2983,'Products in this class: {{X}}'),(2428,'Products information has been successfully deleted'),(1056,'Products information has been successfully updated'),(2364,'Products processed'),(2145,'Products processed: X out of Y'),(2149,'Products processed: X out of Y with errors'),(2381,'Products processed: {{count}}'),(3900,'Products return X'),(4471,'Products reviews'),(2706,'Products search'),(4736,'Products updated'),(1057,'Products with low inventory'),(3000,'Products with no assigned categories'),(1058,'Profile'),(3005,'Profile actions'),(3074,'Profile details'),(1059,'Profile has been created successfully'),(1060,'Profile has been deleted successfully'),(1956,'Profile has been modified successfully'),(1061,'Profile has been updated successfully'),(2129,'Profile is not defined'),(2407,'Profile is not selected'),(1062,'Profile settings'),(1063,'Promotions'),(4004,'Proof of age'),(1064,'Properties'),(4025,'Public'),(2412,'Public ID'),(2413,'Public id'),(3294,'Public installed modules:'),(3858,'Public key'),(4596,'Publishable key'),(4597,'Publishable key (test mode)'),(4488,'Published'),(1065,'Purchase'),(1066,'Purchase SSL certificate'),(3084,'Purchase a premium license key'),(2081,'Purchase description'),(2666,'Purchase license'),(15,'Purchase premium license'),(1658,'Purchased'),(3131,'Purchased addons'),(3724,'Put all for sale'),(3721,'Put up for sale'),(1068,'Put up selected for sale'),(1069,'Qty'),(1070,'Qty.'),(208,'Quantity'),(3533,'Quantity in stock'),(3551,'Quantity in stock is determined by the amount of the remaining PIN codes'),(3548,'Quantity in stock is determined by the amount of the remaining PIN codes.'),(1071,'Quantity: high to low'),(1072,'Quantity: low to high'),(384,'Quarter'),(1517,'Query'),(1073,'Queued'),(1074,'Quick and easy setup'),(3124,'Quick menu'),(2885,'Quick view'),(2542,'Quit'),(4005,'Quote type'),(4462,'REST API allows to get or change any information in your store (including profiles, orders, payment transactions, inner store configuration, products, categories and so on), so your API key must be as complex as possible and kept private.'),(2396,'RSS feed'),(1075,'Rate'),(4514,'Rate asc'),(4515,'Rate desc'),(4513,'Rate sort'),(1076,'Rates'),(1077,'Rates / Conditions'),(4480,'Rating'),(4496,'Rating of votes'),(4534,'Ratings and Reviews of X'),(4526,'Ratings only'),(1078,'Raw online rate (on-line rate)'),(1079,'Re-build cache'),(2682,'Re-check'),(2475,'Re-deploy the store'),(2476,'Re-deploy the store help text'),(1080,'Re-generate access key'),(1569,'Re-generate links'),(1081,'Re-order'),(3489,'Re-upload file'),(2445,'Re-validate license keys'),(4760,'Read'),(4512,'Read all reviews about the product'),(4361,'Ready to delete demo products?'),(4789,'Reason'),(3295,'Rebuild view lists help text'),(2908,'Recalculate ViewLists'),(2909,'Recalculate ViewLists text'),(2203,'Recalculate this value automatically'),(2814,'Recalculate totals'),(2815,'Recent orders only'),(3209,'Recently installed addons'),(2423,'Recently installed modules'),(3706,'Recently viewed'),(4545,'Recently, you have made a purchase from our company:'),(1913,'Recommended'),(3659,'Reconnect to PayPal'),(4280,'Reconnect with your MailChimp account'),(219,'Recover password'),(3448,'Redeem'),(1082,'Redirect customers to HTTPS'),(3082,'Refer to X-Cart license agreement for further details.'),(1084,'Referer'),(3152,'Refresh consistency status'),(2957,'Refresh integrity status'),(3774,'Refresh list of available methods'),(3378,'Refresh status'),(4590,'Refresh token'),(2104,'Refund'),(3364,'Refund is in progress...'),(2731,'Refund multiple[TT]'),(2730,'Refund partially[TT]'),(351,'Refund requested'),(3379,'Refund status'),(3652,'Refund status:'),(3358,'Refund status: {{status}}'),(2729,'Refund[TT]'),(352,'Refunded'),(1830,'Refunded amount'),(2626,'Refunds'),(1085,'Register'),(3098,'Register license key'),(1754,'Register user'),(3628,'Register with'),(3625,'Register with PayPal or go to checkout as a New customer'),(3349,'Register your website as an application on the Login with Amazon App Console.'),(1086,'Registered'),(2133,'Registered (access level)'),(202,'Registered Customer'),(203,'Registered Customer, _Anonymous Customer with the same email_'),(2021,'Registered Customers'),(4524,'Registered users only'),(4517,'Registered users who purchased product'),(3644,'Registering your application with PayPal'),(4006,'Registration process has been canceled.'),(4007,'Registration process has been completed successfully.'),(2779,'Regular text for 404 page'),(4539,'Reject'),(4744,'Related products'),(4748,'Related products page'),(3503,'Related products you may be interested in'),(3396,'Relay Response URL note'),(3545,'Remaining PINs'),(3083,'Remind me on next sign-in'),(22,'Removal of this message is allowed only through activation of a free or premium license.'),(1087,'Remove'),(4437,'Remove cache when attribute, tag or product data is changed'),(2207,'Remove data'),(3296,'Remove expired sessions'),(3297,'Remove expired shopping carts'),(4654,'Remove flexy-templates'),(4191,'Remove from google product feed'),(3298,'Remove module'),(4439,'Remove product filter cache'),(4438,'Remove product filter cache tooltip'),(2679,'Remove unlicensed modules'),(3450,'Removed coupons'),(2960,'Removed files'),(2199,'Removed items'),(3299,'Removing expired datacache'),(1603,'Removing this attribute will affect all the products. Leave this blank to hide this option for the product.'),(1687,'Removing this message without buying a Full license is prohibited and will result in legal proceedings.'),(1187,'Rename label'),(4008,'Render detailed manifest'),(3501,'Renew'),(2444,'Renew your access to new features'),(1735,'Replace all modified files with the unmodified newer versions'),(3888,'Replace with'),(105,'Report a bug'),(2354,'Request for upgrade'),(2078,'Request type must be POST'),(4579,'Requested amount: X; real amount: Y'),(4580,'Requested currency: X; real currency: Y'),(4578,'Requested transaction type: X; real transaction type: Y'),(1965,'Requested zone does not exists'),(1415,'Require to change password on next log in'),(1088,'Required'),(1706,'Required field'),(261,'Required field X is not defined or empty'),(3399,'Required for SHA512 hash protection.'),(1089,'Required php extensions is not loaded: X'),(2977,'Required state_id checkbox help text'),(1090,'Requires registered merchant account'),(2707,'Requires shipping'),(2670,'Requires {{list}} edition'),(1091,'Rerun benchmark'),(1092,'Resend secret link to renew the access'),(3875,'Reset all filters'),(4431,'Reset filter'),(4695,'Reset layout'),(1997,'Residential'),(2367,'Resizing images...'),(2453,'Resolve the conflict'),(4553,'Response date is in wrong format'),(4085,'Response from ePDQ is not trusted (SHA checking is failed)'),(1093,'Response from marketplace is not received'),(1094,'Response from marketplace: '),(1471,'Response from marketplace: X'),(1095,'Restore'),(1096,'Restore database'),(1097,'Restore from server'),(1098,'Restore last backup'),(1099,'Restore links'),(4602,'Restore this version'),(769,'Restores to current state of active addons (use in case of emergency)'),(1879,'Restoring database from the backup .'),(2450,'Result'),(1723,'Result pages'),(3979,'Return'),(3966,'Return #'),(3956,'Return products'),(3962,'Return qty'),(3902,'Return quantity'),(1100,'Return to Drupal'),(1880,'Return to admin interface'),(4126,'Return to cart'),(4171,'Return to default database'),(3919,'Return tracking pin'),(1511,'Reupload files'),(1101,'Revenue'),(4706,'Revert to default'),(4167,'Revert to default database'),(4528,'Review'),(2705,'Review & Submit order'),(4475,'Review has been created'),(4476,'Review has been deleted'),(4477,'Review has not been created since product is not found'),(4478,'Review has not been updated since product is not found'),(4601,'Review it.'),(3192,'Review modules'),(1102,'Review statistics on various aspects of your store\'s operation'),(4479,'Reviewer'),(4560,'Reviewer name'),(4503,'Reviews'),(4532,'Reviews about product'),(4525,'Reviews and ratings'),(4469,'Reviews for product'),(4481,'Reviews imported'),(4527,'Reviews only'),(4504,'Reviews: X'),(1103,'Role'),(1104,'Roles'),(2753,'Roles cannot be changed for your profile via import'),(1105,'Root Level'),(1106,'Root access'),(1673,'Root categories'),(1107,'Root category'),(2141,'Root category listings format'),(230,'Root level'),(3154,'RoundUp'),(1975,'Row {{number}}'),(1976,'Row(s) {{numbers}}'),(1108,'Run Benchmark again'),(1109,'Run benchmark'),(362,'SA'),(3645,'SECONDARYONLY'),(3646,'SENDER'),(4536,'SEO'),(1144,'SEO settings'),(372,'SEPTEMBER'),(2592,'SHIPPING = flat + ITEMS*per_item + SUBTOTAL*(% of subtotal)/100 + WEIGHT*per_weight;'),(31,'SKU'),(2408,'SKU is not selected'),(2816,'SKU length must be less then {{length}}'),(3300,'SKU must be unique'),(4555,'SKU or Product name'),(2818,'SKU or SKU1, SKU2'),(1110,'SKU: a-z'),(1111,'SKU: z-a'),(1112,'SMTP server'),(1864,'SQL file was deleted successfully'),(1411,'SSL Error'),(1113,'STORE SETUP'),(363,'SU'),(1114,'SYSTEM SETTINGS'),(1115,'Safe mode'),(1116,'Safe mode access key'),(1858,'Safe mode access key has been re-generated'),(2025,'Safe mode links were emailed'),(4564,'Sage Pay password'),(4566,'Sage Pay pricing currency'),(4563,'Sage Pay processing mode'),(4562,'Sage Pay vendor name'),(4565,'Sage pay invoice number prefix'),(4568,'SagePay Form admin description'),(1117,'Sale'),(1118,'Sale price'),(2459,'Sale statistics'),(1119,'Sale statistics from the opening of the store'),(2722,'Sale[TT]'),(1120,'Sales'),(4412,'Sales & Customer Service:'),(4414,'Sales & Customer Service: [phone]'),(3402,'Sales asc'),(2696,'Sales calculation'),(3118,'Sales channels'),(3403,'Sales desc'),(3401,'Sales sort'),(1121,'Sales tax'),(1509,'Samples of the file structures'),(127,'Save'),(3752,'Save & Close'),(4338,'Save and go to the next step'),(1122,'Save as new'),(1123,'Save changes'),(2648,'Save filter'),(4165,'Save location'),(2204,'Save the existing value without re-calculating'),(1124,'Save zone details'),(3126,'Saving'),(1125,'Savings'),(3805,'Savings - Up to 49% off retail USPS postage rates'),(2873,'Scheme'),(4518,'Score: X. Votes: Y'),(76,'Search'),(4174,'Search attribute name'),(4652,'Search flexy-templates'),(1126,'Search for modules'),(1127,'Search for orders'),(3969,'Search for returns'),(2485,'Search for transactions by date'),(1128,'Search for users'),(1129,'Search for users that are'),(402,'Search in'),(1130,'Search in subcategories'),(2140,'Search items...(customer header search form)'),(398,'Search keywords'),(399,'Search payment method'),(1131,'Search product'),(1132,'Search profiles'),(1133,'Search result'),(1134,'Search results'),(2134,'Search total'),(2851,'Searching...'),(2902,'Second, try to disable all non-X-Cart modules by using the links below:'),(3347,'Secret Access Key'),(2106,'Secret key'),(4598,'Secret key (test mode)'),(2091,'Secret word'),(215,'Secure Checkout'),(1135,'Secure connection cannot be established.'),(2293,'Secure credit card payment'),(1136,'Security'),(2301,'Security code'),(2464,'Security issue'),(1137,'Security settings'),(161,'See all items in the cart'),(1818,'See comparison chart'),(2167,'See log file for details'),(4411,'See the tutorials and documentation about X-Cart store customization.'),(4240,'Segment condition'),(291,'Select a country or a state from a list, specify the zone'),(1739,'Select all'),(4233,'Select box'),(1138,'Select country'),(93,'Select file'),(4218,'Select issuer'),(100,'Select language'),(2819,'Select language to edit'),(225,'Select one'),(1139,'Select options'),(1855,'Select products from the list'),(1140,'Select status'),(4537,'Select the review that should be included into the rich snippet shown for the page of this product when the page appears in search results by Google and other major search engines'),(3301,'Select type'),(4250,'Selected by default'),(747,'Selected countries'),(746,'Selected countries:'),(4529,'Selected reviews have been deleted'),(4531,'Selected reviews have been updated'),(749,'Selected states'),(4456,'Selected tags have been deleted'),(354,'Selected:'),(1702,'Semicolon'),(1141,'Send'),(3411,'Send a message'),(3009,'Send reset link'),(1142,'Send test email'),(1143,'Send to {{email}}'),(1171,'Send tracking info'),(2820,'Separate box'),(1145,'Service name'),(1146,'Service name of address field'),(1147,'Set'),(2504,'Set a single discount or add multiple volume discounts.'),(2502,'Set absolute or %-based discount rates;'),(4385,'Set flat shipping rates for your store'),(4094,'Set the Response Method setting to Sent to your server as a POST.'),(1148,'Set the sale price'),(144,'Set this language as default for customer zone'),(3340,'Set up LiveChat, the fastest way to help your customers.'),(4401,'Set up offline & online payments'),(4337,'Set up payment gateways'),(4382,'Set up shipping'),(4336,'Set up shipping methods'),(4377,'Set your company info'),(3216,'Setting up Canadian taxes'),(3218,'Setting up European / UK Taxes'),(3219,'Setting up US Taxes'),(3215,'Setting up tax'),(3217,'Setting up tax classes'),(1149,'Settings'),(1150,'Setup _address zones_ and _taxes_'),(3861,'Setup instruction'),(2185,'Setup store price: X'),(3670,'Shape'),(3522,'Share'),(2663,'Ship QTY'),(3813,'Ship date'),(1551,'Ship in a separate box'),(2661,'Ship to'),(3916,'Shipment ID'),(3781,'Shipment Id'),(3972,'Shipment cannot be created'),(3977,'Shipment cannot be transmitted'),(3974,'Shipment cannot be voided'),(3780,'Shipment has been created successfully'),(3971,'Shipment has been created with errors'),(3975,'Shipment has been tranmitted with errors'),(3976,'Shipment has been transmitted successfully'),(3779,'Shipment has been voided successfully'),(3973,'Shipment has been voided with errors'),(3915,'Shipment info'),(2069,'Shipment options'),(3917,'Shipment status'),(3978,'Shipments'),(4009,'Shipments pick up type'),(348,'Shipped'),(3742,'Shipping'),(1151,'Shipping & Taxes'),(1304,'Shipping / Payment info'),(1152,'Shipping address'),(1833,'Shipping address is invalid'),(1153,'Shipping address is not completly defined yet'),(1154,'Shipping address is not defined'),(1155,'Shipping address is not defined yet'),(2590,'Shipping charge based on a percentage of the order subtotal.'),(1533,'Shipping charges'),(42,'Shipping cost'),(4149,'Shipping freight'),(4152,'Shipping freight + regular shipping rate'),(4151,'Shipping freight only'),(4153,'Shipping freight tooltip text'),(1666,'Shipping has been calculated based on the following split of the products into packages:'),(1156,'Shipping info'),(3783,'Shipping label'),(3801,'Shipping label sender signature'),(1157,'Shipping markup has been created successfully'),(1158,'Shipping markups have been updated'),(1159,'Shipping method'),(2821,'Shipping method / cost'),(1160,'Shipping method has been added'),(3302,'Shipping method is disabled'),(3303,'Shipping method is enabled'),(2551,'Shipping method is not configured.'),(2562,'Shipping method name'),(1161,'Shipping methods'),(1162,'Shipping methods are not available'),(165,'Shipping methods have been updated'),(3304,'Shipping order status'),(1525,'Shipping rate cannot be added'),(1524,'Shipping rate has been added successfully'),(1163,'Shipping rates'),(2586,'Shipping rates are calculated by the following formula:'),(1164,'Shipping settings'),(2644,'Shipping solutions'),(2119,'Shipping status'),(2925,'Shipping status not found, \"New\" will be used for order'),(4033,'Shipping status not found, new status will be created'),(4027,'Shipping statuses'),(2889,'Shipping to'),(1165,'Shipping zones'),(4561,'Shopper approved promo'),(1179,'Shopping bag'),(4429,'Shopping options'),(376,'Shortcuts'),(2023,'Show'),(4593,'Show \"How to use\" instruction'),(79,'Show Category title'),(3613,'Show above products'),(4647,'Show all'),(95,'Show all labels'),(4433,'Show all products in this category'),(2715,'Show all warnings/errors'),(3614,'Show below products'),(3763,'Show default menu along with the custom one'),(3414,'Show email as text'),(197,'Show filter options'),(2822,'Show in all the sections'),(2712,'Show low stock warning on product page'),(2787,'Show object name in page title'),(2823,'Show only in categories and search listings'),(2824,'Show only in search listing'),(3671,'Show payment card icons'),(4430,'Show products'),(3002,'Show products with no assigned category'),(1180,'Show social buttons'),(3073,'Show states for selected countries only'),(4791,'Show vendor’s products in the order'),(2780,'Show сustomer relations e-mails on 404 page'),(2825,'Show:'),(2313,'Sign Up'),(3624,'Sign Up Now'),(1181,'Sign in'),(2884,'Sign in / sign up'),(1182,'Sign out'),(4272,'Sign up for <Company name> news, sales and deals'),(3862,'Sign up for Authorize.net'),(3167,'Sign up for TaxJar'),(4271,'Sign up for news and updates from your favorite store. Be the first to know about exclusive sales, offers and deals.'),(4314,'Sign up for {{companyName}} news'),(2871,'Signature'),(3393,'Signature  key'),(3400,'Signature key'),(14,'Simplify tax compilance process and reduce the sales tax audit risk with AvaTax Sales Tax Automation'),(1711,'Single quote'),(3827,'Site map has not been registred in X'),(3828,'Site map successfully registred on X'),(4010,'Site number of the deposit location'),(4570,'Sitemap'),(3833,'Sitemap generation has been completed successfully.'),(3834,'Sitemap generation has been stopped.'),(3832,'Sitemap generation...'),(3836,'Sitemap settings'),(1183,'Size'),(4384,'Skip Shipping Step'),(4341,'Skip this step'),(3305,'Skipped'),(2826,'Soft and Hard reset links for your store'),(3306,'Soft and hard reset links for your store'),(1763,'Soft reset (disables all modules except ones that were downloaded from marketplace)'),(2903,'Soft reset. Turn off all addons except those provided by X-Cart Team & Qualiteam'),(3534,'Sold'),(3544,'Sold PINs'),(4634,'Some'),(4705,'Some edited templates were selected to be disabled. You can enable them on the Edited templates page in the Admin area.'),(1733,'Some files are modified'),(4077,'Some files haven`t been attached'),(4657,'Some flexy-templates cannot be removed. Please correct file permissions or remove them manually'),(3321,'Some items were out of stock at the time of order placement.'),(2439,'Some of these updates are not available for you at the moment.'),(4400,'Some people simply prefer to place their orders by phone — let them do that.'),(264,'Some products could have been imported incorrectly'),(4213,'Something wrong in the iDEAL payment module settings. Please try later or use other payment option.'),(3458,'Sorry, the coupon has expired'),(3459,'Sorry, the coupon use limit has been reached'),(3460,'Sorry, the coupon you entered cannot be applied to the items in your cart'),(3457,'Sorry, the coupon you entered is invalid. Make sure the coupon code is spelled correctly'),(3461,'Sorry, the coupon you entered is not valid for your membership level. Contact the administrator'),(1262,'Sorry, this category is no longer available.'),(3454,'Sorry, this coupon cannot be combined with the coupon already applied. Revome the previously applied coupon and try again.'),(1260,'Sorry, this page is no longer available.'),(1261,'Sorry, this product is no longer available.'),(2655,'Sorry, your order cannot be placed as there are no shipping methods available.'),(1796,'Sorry, your order payment is canceled.'),(1797,'Sorry, your order payment is failed.'),(3307,'Sort'),(232,'Sort by'),(2827,'Sort by:'),(2828,'Sort settings'),(2047,'Source address'),(2000,'Space'),(3788,'Special services'),(428,'Specification'),(3199,'Specify email address'),(4116,'Specify the percentage of users who complete the transaction (Add to cart)'),(4120,'Specify the percentage of users who complete the transaction (Initiate checkout)'),(4119,'Specify the percentage of users who complete the transaction (View content)'),(1189,'Specify your _store information_'),(2829,'Specify your _store information_\', {\'URL\': url(\'settings\', \''),(1190,'Speed up your store'),(2202,'Staff note'),(2638,'Stamps.com'),(2509,'Standard'),(2912,'Start'),(1616,'Start Export'),(1500,'Start Import'),(3590,'Start accepting Express Checkout payments immediately by simply plugging in the email address where you would like to receive payments.'),(1801,'Start date'),(1191,'Start selling!'),(3327,'Start typing a category name'),(4486,'Start typing customer email or name'),(4484,'Start typing product name or SKU'),(1192,'State'),(1488,'State cannot be created with unknown country code X'),(1193,'States'),(1194,'States have been deleted successfully'),(1195,'States have been updated successfully'),(2172,'States information has been successfully deleted'),(4242,'Static'),(1196,'Statistics'),(1197,'Status'),(3213,'Status comment (reason)'),(2409,'Status is not defined'),(4587,'Status: Connected'),(333,'Steps to complete your store for real sales'),(1930,'Stock'),(3308,'Store ID'),(1198,'Store Maintenance'),(1199,'Store currency'),(1200,'Store info'),(1201,'Store is closed'),(1202,'Store is open'),(1746,'Store lifetime'),(1203,'Store setup'),(1204,'Storefront'),(1937,'Storefront is closed'),(1939,'Storefront is open'),(4694,'Storefront layout'),(4131,'Street address'),(3331,'Strong password'),(120,'Subcat'),(1205,'Subcategories'),(343,'Subcategories for'),(1206,'Subject'),(3757,'Submenu'),(36,'Submit'),(2883,'Subscribe'),(4268,'Subscribe by default'),(4231,'Subscribe to our news list and be in touch with our latest offers.'),(4320,'Subscriber with email {{email}} already subscribed'),(4316,'Subscribers'),(4319,'Subscribers imported'),(4230,'Subscription'),(1207,'Substring'),(44,'Subtotal'),(3733,'Subtotal + Shipping cost'),(2570,'Subtotal range'),(1208,'Subtotal range (begin)'),(1209,'Subtotal range (end)'),(1664,'Success'),(2688,'Success[S]'),(4293,'Successfully authenticated'),(1210,'Successfully imported X new products'),(1211,'Successfully imported X new products and upgraded Y old products'),(1212,'Successfully upgraded Y old products'),(1213,'Suffix'),(4733,'Suggested retail rates'),(3309,'Sunday'),(1498,'Support'),(3143,'Surcharges'),(2966,'Switch to Category search'),(2965,'Switch to Category tree'),(2897,'Switcher NO'),(2896,'Switcher YES'),(1214,'Synchronous'),(3122,'System logs'),(1215,'System settings'),(4031,'System status tooltip'),(3121,'System tools'),(1850,'System will download and install this module from marketplace. Continue?'),(360,'TH'),(358,'TU'),(1703,'Tab'),(4053,'Tab displaying comments about the product. Added by the addons VK/GoSocial/Disqus'),(4558,'Tab displaying product reviews. Added by the addon Product Reviews'),(4052,'Tab displaying the product\'s attributes and other details. Added by the X-Cart core'),(4051,'Tab displaying the product\'s detailed description. Added by the X-Cart core'),(1216,'Table'),(2563,'Table based on'),(4034,'Tabs'),(4040,'Tabs imported'),(4452,'Tag'),(4686,'Tag Manager Dashboard'),(5,'Tags'),(2227,'Tags are not allowed in the column \"{{column}}\" and will be stripped'),(45,'Tax'),(3898,'Tax Class'),(1556,'Tax class'),(1887,'Tax classes'),(1217,'Tax disabled'),(1218,'Tax enabled'),(1219,'Tax has been disabled successfully'),(1220,'Tax has been enabled successfully'),(1222,'Tax rate has been deleted successfully'),(1223,'Tax rate has not been deleted successfully'),(3735,'Tax rates for shipping charges have not yet been created.'),(1221,'Tax rates have been updated successfully'),(3736,'Tax rates have not yet been created.'),(3737,'Tax rates on shipping cost'),(1224,'Tax title'),(3170,'TaxJar Category'),(3169,'TaxJar Dashboard'),(3166,'TaxJar enabled'),(3734,'Taxable base'),(1225,'Taxes'),(1226,'Teaser'),(4608,'Template'),(4651,'Template is converted'),(3754,'Terms and conditions'),(1486,'Terms and conditions text'),(1996,'Test'),(3935,'Test Canada Post rates calculation'),(3310,'Test e-mail have been successfully sent'),(1227,'Test email configuration'),(1755,'Test email notification'),(1756,'Test email notification:'),(2071,'Test mode'),(2180,'Test mode: Live'),(2179,'Test mode: Test'),(2596,'Test rates'),(1228,'Test shipping rates'),(2080,'Test/Live mode'),(2735,'Test[TT]'),(1229,'Tester'),(1230,'Text'),(65,'Text labels have been deleted'),(61,'Text labels have been updated successfully'),(66,'Text labels have not been deleted: no text labels have been found or specified'),(63,'Text labels have not been updated successfully: the default application language has been set as the translation language'),(64,'Text labels have not been updated successfully: the translation language has not been found'),(62,'Text labels have not been updated successfully: the translation language has not been specified'),(3715,'Text links'),(4552,'Text of response'),(4487,'Text of review'),(1924,'Textarea'),(243,'Thank you for registering a customer account, your profile has been created successfully'),(4315,'Thank you for subscribing to the newsletter! We hope you enjoy shopping at {{companyName}}'),(194,'Thank you for using company services'),(1231,'Thank you for your order'),(295,'Thank you for your order FOOTER'),(4493,'Thank your for sharing your opinion with us!'),(3369,'That payment method was not accepted for this transaction. Please choose another.'),(3771,'The \"Approved URL\" value must be exact as this'),(3341,'The \"Pay With Amazon\" feature is not configured and cannot be used.'),(3342,'The \"Pay with Amazon\" feature requires https to be properly set up for your store.'),(3770,'The \"Pricing currency\" value must be exactly the same as on it.'),(4572,'The \"Stripe\" feature is not configured and cannot be used.'),(4573,'The \"Stripe\" feature requires https to be properly set up for your store.'),(2848,'The \"{{file}}\" file is not allowed and was not uploaded. Allowed extensions are: {{extensions}}'),(3756,'The \"{{file}}\" file is not allowed image and was not uploaded. Allowed images are: {{extensions}}'),(1824,'The \"{{file}}\" file was not uploaded'),(1862,'The \"{{file}}\" is not CSV or archive'),(2224,'The \"{{value}}\" category does not exist'),(2258,'The \"{{value}}\" group is not created'),(2222,'The \"{{value}}\" image does not exist'),(2219,'The \"{{value}}\" membership does not exist'),(2220,'The \"{{value}}\" product class does not exist'),(2221,'The \"{{value}}\" tax class does not exist'),(3760,'The AppleIcon image could not be uploaded (Unallowed image type. Must be a .png image with the resolution of 192x192 px)'),(4091,'The Approved URL value must be exact as this:'),(3323,'The Backorder status will be reset for the items. The stock quantity of the backorder items will not change. Adjust it manually if necessary.'),(3311,'The Clean URL entered has unallowed chars.'),(2448,'The Clean URL entered is a redirect to object.'),(2767,'The Clean URL entered is already in use by target alias.'),(2447,'The Clean URL entered is already in use.'),(4093,'The Declined URL value must be exact as this:'),(2110,'The English language cannot be removed as it is primary language for all texts.'),(1246,'The HTTPS protocol is enabled for your website'),(1232,'The SSL certificate installed for your custom website domain is not valid.'),(1233,'The SSL certificate installed on your server is not valid. Although you can switch the store to use the secure protocol for the website pages, most Internet browsers will likely display a warning message scaring your website visitors away.'),(4090,'The Store ID and HPP Key value must be exactly the same as on it.'),(267,'The X field is empty'),(1234,'The X language has been added and enabled successfully'),(54,'The X language has been added successfully'),(56,'The X language has been deleted successfully'),(59,'The X language has been disabled successfully'),(60,'The X language has been enabled successfully'),(154,'The X module has been installed incorrectly. Please see the logs for more information'),(152,'The X module has been installed successfully'),(153,'The X module has been installed with errors: the DB has not been modified correctly'),(155,'The X module has been installed, but the module has a wrong module control class'),(1948,'The address field has been added'),(1947,'The address field has been updated'),(1235,'The attachment has been added successfully'),(3512,'The attachment has been successfully re-upload'),(1942,'The attribute group has been added'),(1941,'The attribute group has been updated'),(1950,'The attribute has been added'),(1949,'The attribute has been updated'),(1944,'The attribute option has been added'),(1943,'The attribute option has been updated'),(193,'The benchmark evaluates server environment'),(2186,'The button is inactive either because no changes have been detected on the current page or because the order totals need to be recalculated before the order can be updated.'),(2694,'The calculation completed'),(2693,'The calculation failed'),(2482,'The calculation of quick data has been completed successfully.'),(2483,'The calculation of quick data has been stopped.'),(1946,'The category has been added'),(1945,'The category has been updated'),(1236,'The changes will be applied to all selected products'),(2449,'The clean URL will be generated automatically.'),(2416,'The common notification fields has been updated'),(4428,'The comparison table has been cleared.'),(195,'The confirmation URL link was mailed to email'),(2127,'The confirmation URL link will be emailed to you shortly'),(2954,'The core may be checked only if a valid license key is present.'),(2757,'The count of categories specified for a product and the count of orderBy position numbers describing the position of the product within these categories must be the same.'),(1868,'The countries list for zone is empty. Please specify it.'),(2899,'The countries to which the selected states belong will be added to the zone automatically.'),(3431,'The coupon has been added'),(3424,'The coupon has been applied to your order'),(3432,'The coupon has been updated'),(1878,'The database has not been restored because of the errors'),(4600,'The database stores different version of the custom changes.'),(58,'The default interface language cannot be disabled'),(1237,'The detailed image has been added successfully'),(1238,'The detailed image has been deleted'),(1888,'The detailed image has not been deleted'),(1239,'The detailed images have been updated successfully'),(1550,'The directory \'var/backup/\' does not exist or is not writable.'),(4620,'The directory {{dir}} does not exist or is not writable.'),(3430,'The discount should be less than 100%'),(4779,'The dispute has been closed'),(2654,'The download should start automatically. Click the link if does not start.'),(4718,'The dynamic message is empty for this notification.'),(73,'The edited language has not been found'),(196,'The email with your account information was mailed to email'),(1240,'The exceptions have been updated successfully'),(1764,'The export is complete.'),(4766,'The field Body may not be blank'),(2614,'The file extension is forbidden'),(2746,'The file extension is forbidden ({{file}}'),(284,'The file was not loaded because of a failure on the server'),(1886,'The file was not loaded because of a failure on the server.'),(4619,'The file {{file}} does not exist or is not writable.'),(4065,'The files have been attached successfully'),(3568,'The following PIN codes have already been sold: {{codes}}'),(1242,'The following add-on(s) must be disabled'),(1241,'The following add-on(s) must be enabled'),(1243,'The following categories were selected to be removed'),(1244,'The following dependent add-ons will be disabled  automatically'),(1492,'The following expected input data have wrong format or empty: X'),(1615,'The following files are too large to be included in the archive'),(2349,'The following modules currently do not have a version compatible with the X-Cart version to which you are upgrading'),(131,'The following modules will be disabled'),(2378,'The following selected modules cannot be disabled due to architecture limitations'),(2375,'The following selected modules cannot be disabled or uninstalled as they have dependent modules'),(2376,'The following selected modules cannot be enabled as they depend on disabled modules which cannot be enabled'),(1854,'The form could not be identified as a form generated by X-Cart'),(1955,'The front page has been updated'),(2370,'The generation of resized images has been completed successfully.'),(2371,'The generation of resized images has been stopped.'),(3492,'The history of downloads feature for this product is disabled. You can enable it here'),(1245,'The image has been updated'),(2372,'The image resizing process may take a while to complete. Please do not close this page until the process is fully completed.'),(1247,'The import is in progress'),(3003,'The import process has been canceled'),(1248,'The importing starts immediately upon selecting the data file. No additional confirmation prompts will appear.'),(2438,'The key does not allow getting new features and upgrades.'),(1584,'The language CSV file should be a text file which contains 3 columns per row (columns are separated by comma:'),(74,'The language data has been saved'),(57,'The language has not been found'),(1578,'The language labels have been successfully imported:'),(53,'The language you want to add has already been added'),(52,'The language you want to add has not been found'),(55,'The language you want to delete has not been found'),(1249,'The language you want to delete is the default application language and cannot be deleted'),(1250,'The language you want to delete is the default interface language and cannot be deleted'),(3415,'The length of X field must be greater than Y'),(3416,'The length of X field must be less than Y'),(2229,'The length of value for the column \"{{column}}\" exceeds length of field and will be cut'),(49,'The link was copied to your clipboard'),(75,'The maximum file size that can be uploaded: X'),(1251,'The maximum number of uses'),(3462,'The maximum number of uses per user'),(1704,'The membership name cannot contain such symbols as \\, \' and \". Also, it cannot exceed 32 characters.'),(3747,'The menu has been added'),(3746,'The menu has been updated'),(1831,'The method is not configured and cannot be used'),(1474,'The module X has been uninstalled successfully'),(1252,'The module has been partially uninstalled'),(151,'The module has been uninstalled successfully'),(1729,'The module is incompatible with the new core version going to be installed'),(1253,'The module is not released for your X-Cart version'),(2955,'The module may be checked only if a valid license key is present.'),(2377,'The module may not be disabled due to the limitations of the module architecture.'),(150,'The module to uninstall has not been found'),(2116,'The module version is incompatible with your core version and cannot be enabled. Minimum core version required for this module is X.'),(2115,'The module version is incompatible with your core version and cannot be installed. Minimum core version required for this module is X.'),(156,'The modules have been updated'),(2248,'The name is empty'),(3112,'The name will be changed globally'),(4358,'The newly created product is already in your [storefront]. Have a look! Ready to delete demo products?'),(4306,'The news message has been added'),(4305,'The news message has been updated'),(2417,'The notification has been updated'),(2226,'The number of values in the row does not match the number of column headers for this CSV file'),(1832,'The only remaining active administrator profile cannot be deleted.'),(3567,'The order also contains items with missing PIN codes; you will be prompted to enter the PIN codes under item names.'),(1934,'The order subtotal exceeds the maximum allowed value ({{max_order_amount}})'),(1984,'The order subtotal exceeds the maximum allowed value ({{max_order_amount}}), please remove some items from the cart.'),(1935,'The order subtotal less than the minimum allowed value ({{min_order_amount}})'),(1985,'The order subtotal less than the minimum allowed value ({{min_order_amount}}), please add some items to the cart.'),(1254,'The page has been added'),(3748,'The page has been updated'),(1752,'The password is the one you specified during checkout.'),(1753,'The password is the one you specified.'),(338,'The process of export is complete. You can follow this_link to check the results and download the files containing data.'),(1627,'The process of export may take much time. Please do not close this page until the export is complete'),(1626,'The process of export may take much time. You may close the page, the operation will be in progress as background. If the operation takes long enough, we will send you a notification when it is complete.'),(4189,'The process of feed generation may take a while to complete. Please do not close this page until the process is fully completed.'),(1513,'The process of import may take much time. Please do not close this page until the import is complete'),(1512,'The process of import may take much time. You may close the page, the operation will be in progress as background. If the operation takes long enough, we will send you a notification when it is complete.'),(2481,'The process of quick data calculation may take a while to complete. Please do not close this page until the process is fully completed.'),(2695,'The process of sales calculation may take a while to complete. Please do not close this page until the process is fully completed.'),(3835,'The process of sitemap generation may take a while to complete. Please do not close this page until the process is fully completed.'),(4753,'The product SKU#\"X\" is already set as Related for the product'),(2066,'The product SKU#\"X\" is already set as featured for the category'),(4750,'The product SKU#\"X\" is already set as related for the product'),(1952,'The product class has been added'),(1951,'The product class has been updated'),(4451,'The product filter cache has been removed successfully.'),(2613,'The product for which you attempted to upload an attachment has not been found'),(2418,'The product has been added'),(4427,'The product has been added to the comparison table'),(4426,'The product has been removed from comparison table'),(2168,'The product has been updated'),(1255,'The product option group has been added successfully'),(1256,'The product option group has been updated successfully'),(1257,'The product option groups have been updated successfully'),(1258,'The product option groups have not been successfully updated'),(1954,'The product selection has been added'),(1953,'The product selection has been updated'),(4038,'The product tab has been added'),(4037,'The product tab has been updated'),(2218,'The product with \"{{value}}\" SKU does not exist'),(3007,'The product you are trying to add to cart is unavailable'),(3491,'The product\'s history of downloads is empty'),(3980,'The products return has been registered.'),(1485,'The profile has been registered. The password has been sent to the user\'s email address'),(1484,'The profiles have been merged'),(1577,'The provided file contains the following language labels:'),(1259,'The requested page could not be found.'),(1265,'The restoration procedure is irreversible and erases all data tables from your store database. It is highly recommended that you back your present database data up before restoring one of the previous states from a back-up.'),(3819,'The role has been added'),(3818,'The role has been updated'),(1266,'The same as shipping'),(3511,'The same file can not be assigned to one product'),(1974,'The script found {{number}} errors during import'),(4737,'The script found {{number}} errors during update inventory'),(1973,'The script found {{number}} errors during verification'),(2830,'The secure protocol for your website is disabled.'),(2831,'The secure protocol for your website is enabled.'),(2526,'The secure protocol is enabled for your website. But X-Cart hasn\'t found the valid SSL certificate on your server.'),(3001,'The selected categories have been deleted. There are products with no assigned category.'),(3464,'The selected date is outside the allowed date range'),(1853,'The selected payment method is obsolete or invalid. Select another payment method'),(1267,'The selected shipping markups have been deleted successfully'),(164,'The selected shipping method has been deleted successfully'),(166,'The selected zones have been deleted successfully'),(2181,'The service name X is reserved and cannot be used for an address field.'),(1861,'The settings of payment method successfully updated'),(2188,'The specified amount of product exceeds maximum amount of product in stock'),(1268,'The state has been added successfully'),(260,'The string is different from that of the title number of columns - X instead of Y'),(2392,'The system detects that some updates are available for enabled modules. It is strongly recommended to have all enabled modules updated to latest version for better compatibility before the install new ones from Marketplace.'),(2505,'The system has been restored to the selected snapshot of X'),(2672,'The system has detected one or more problems with some of the modules at your store:'),(1734,'The system has detected that some custom modifications were made by editing core and module files, not by writing new modules. In order to proceed with the upgrade you should decide what to do with the modifications'),(2680,'The system has detected that the license key that was activated for your store is invalid.'),(2506,'The system has failed to restore because there was no snapshot of X'),(1958,'The tax class has been added'),(1957,'The tax class has been updated'),(4614,'The template has been added'),(4613,'The template has been updated'),(4668,'The test email notification has been sent to X'),(71,'The text label has been added successfully'),(67,'The text label has been deleted'),(72,'The text label has been modified successfully'),(69,'The text label has not been added, because its name has not been specified'),(1269,'The text label has not been added, because its translation to the default application language has not been specified'),(1270,'The text label has not been added, because its translation to the default interface language has not been specified'),(70,'The text label has not been added, because such a text label already exists'),(68,'The text label has not been deleted: it has been either not found or not specified'),(1271,'The text label has not been modified, because its translation to the default application language has not been specified'),(1272,'The text label has not been modified, because its translation to the default interface language has not been specified'),(3113,'The totals have been recalculated. Press \"Save changes\" to adjust the order'),(1273,'The upgrade is completed. Please, do not close this page until you check your web site and check that everything works properly'),(4342,'The uploaded image is too large.'),(204,'The user will be registered; a password will be sent to the user via email'),(2228,'The value in the column \"{{column}}\" will be adjusted according to HTML specification to prevent potential XSS attack'),(2720,'The value must be greater than the current maximum order number in the order list'),(1707,'The value must be in range'),(270,'The value of the X field has an incorrect format'),(268,'The value of the X field must be greater than Y'),(269,'The value of the X field must be less than Y'),(271,'The value of the X field should not be longer than Y'),(1530,'The values are average'),(4604,'Theme tweaker'),(3145,'There are %model% with missing %another_model%'),(3144,'There are %model% without valid %another_model% relation'),(2470,'There are no activated license keys'),(1274,'There are no categories'),(4540,'There are no comments yet. Be the first to leave a comment'),(1557,'There are no images loaded for this product'),(3153,'There are no inconsistencies found'),(1489,'There are no labels translated to X'),(1275,'There are no markups selected'),(2749,'There are no permissions to import user access level'),(2751,'There are no permissions to import user roles'),(1276,'There are no rates available for specified source/destination and/or package measurements/weight.'),(1791,'There are no shipping methods available'),(1639,'There are no shipping methods defined for this carrier'),(4641,'There are some custom CSS styles in your store. These styles may affect the look of the installed template. Review the custom styles and disable them if necessary.'),(4642,'There are some custom templates in your store that may contain skin dependent code.'),(2524,'There are unsaved changes on the page. If you choose to continue, these changes will be lost. Do you want to proceed?'),(1167,'There is a maximum purchase limit of MaxQuantity'),(1166,'There is a minimum purchase limit of MinQuantity'),(176,'There is already an account with your email address. You can sign in or continue as guest'),(2894,'There is already state with code {{code}} in {{country}}'),(4106,'There is no products for facebook product feed generation'),(4717,'There is no special code for this notification'),(3422,'There is no such a coupon, please check the spelling: X'),(1278,'There is no user with specified email address'),(3150,'There is one valid root category, however there are multiple root category candidates'),(1279,'There were no orders placed'),(407,'There\'s no payment method available'),(3905,'There\'s no post offices available'),(3519,'These Open Graph meta tags were generated automatically based on general product information.'),(1990,'These attributes can be applied to all the products in the store.'),(1988,'These attributes can be applied to the \"{{name}}\" product class.'),(1989,'These attributes can only be applied to this particular product.'),(1280,'These components require your attention'),(1281,'These components will be updated'),(1282,'These instructions will appear below the order invoice on the page which customers see after they confirm their order.'),(1283,'These links were already provided to you after this store was installed and will be emailed to you again after you start the upgrade process'),(2026,'These links were already provided to you after this store was installed and will be emailed to you again after you start the upgrade process.'),(2789,'These options separated by X, you can change it by modify X label'),(4659,'This action will remove all flexy-templates. Are you sure to proceed?'),(1809,'This address was used as a'),(1285,'This address was used as a billing address during the recent purchase'),(1286,'This address was used as a shipping address during the recent purchase'),(3444,'This comment will be visible to shop administrators only'),(1287,'This component is automatically calculated by shipping add-on module and cannot be edited'),(2323,'This content shows via %dynamic_message% variable. Do not use this variable to put content (if it exists) below the main message'),(3453,'This coupon cannot be combined with other coupons'),(1288,'This e-mail address is already in use by another user.'),(1289,'This email address is used for an existing account. Enter another email address or sign in'),(2456,'This feature is available only for paid (non-free) X-Cart license plans'),(3897,'This feature is not yet available. You will be redirected to the feature request page where you can vote to have this feature implemented in one of the upcoming versions.'),(4150,'This field can be used to set a fixed shipping fee for the product. Make sure the field value is a positive number (greater than zero).'),(188,'This field is required'),(3404,'This field is required.'),(1290,'This is a default zone which covers all addresses. It\'s impossible to edit this zone\'s countries, states etc'),(221,'This is a demo store with powerful X-Cart engine inside'),(3800,'This is a user specified message that gets printed on the bottom of the label. A string of up to 50 characters can be printed on the label.'),(3798,'This is a user specified message that gets printed on the face of the label. A string of up to 50 characters can be printed on the label.'),(3577,'This is the login name you created when signing up for PayPal Payments Advanced.'),(3584,'This is the login name you created when signing up for Payflow.'),(3585,'This is the password you created when signing up for PayPal Payflow or the password you created for API calls.'),(3579,'This is the password you created when signing up for PayPal Payments Advanced or the password you created for API calls.'),(404,'This language is added by module and cannot be removed.'),(3081,'This message can be removed only through activation of a free or premium license.'),(1634,'This method does not support the current store currency and is not available for customers'),(2697,'This method is displayed because you are logged in as admin and operating as another user'),(1635,'This method is in test mode'),(318,'This module is available for X-Cart hosted stores only.'),(2042,'This module uses PHP\'s cURL functions which are disabled on your web server'),(1291,'This month'),(1787,'This operation is irreversible. Are you sure you want to proceed?'),(3380,'This operation will cancel order. Payment authorization will be voided. Please confirm to proceed.'),(3381,'This operation will capture funds from customer. Please confirm to proceed.'),(3382,'This operation will refund funds to customer. Please confirm to proceed.'),(3320,'This order was placed at the same time as {{orders}}; as a result, some items were out of stock at the time of order placement.'),(2335,'This page allows you to adjust the types of email notifications your store sends to users'),(1532,'This page allows you to configure Shipping methods, zones and charges.'),(1539,'This page allows you to edit global attributes, which are available for all products in your store, and attributes specific for classes of your products.'),(2496,'This page is intended for the creation and management of discount coupons.'),(2501,'This page is intended for the management of volume discounts based on the order subtotal.'),(1637,'This payment method cannot be enabled until you configure it'),(3312,'This payment method is'),(2307,'This payment method is Active.'),(2308,'This payment method is Inactive.'),(2832,'This payment method is not configured.'),(2907,'This process may take much time. Please do not close this page until the task is complete'),(169,'This product has been added to your bag'),(4746,'This product is no longer available although you may find similar or newer version below.'),(39,'This product is out of stock or it has been disabled for sale'),(3708,'This product will be shown in coming soon section'),(3707,'This product will be shown in new arrivals'),(1297,'This quarter'),(1294,'This section displays order placement statistics'),(1528,'This section displays order processing statistics'),(3603,'This setting determines whether or not the \"Buy Now with PayPal\" button should be displayed on product list pages (in list view) and product details pages.'),(2598,'This shipping method is'),(2599,'This shipping method is not configured.'),(3583,'This should be the same partner name that is used when logging into your PayPal Payflow account.'),(1295,'This site requires JavaScript to function properly.'),(2491,'This tool allows you to get rid of any content that might have been created in your store for testing purposes and which you no longer need.'),(177,'This user name is used for an existing account. Enter another user name or sign in'),(3720,'This value must be set in exactly the same way as it is set on the payment gateway end.'),(1611,'This value will be added to new products or class assigns automatically'),(1296,'This week'),(339,'This will increase the shipping cost by XX'),(1298,'This year'),(2216,'Three columns'),(1299,'Through'),(1300,'Thumbnail'),(2833,'Time left'),(1412,'Timeout error'),(2321,'Tip from X-Cart'),(1301,'Title'),(3336,'Title for customers'),(11,'To activate your X-Cart license, enter your secret key into the field below and click Activate.'),(12,'To activate your X-Cart or commercial module license, enter your license key into the field below and click Activate.'),(272,'To boost your sales try to use Discounts coupons, Sale, Product Advisor, Volume discounts addons. Also you may be interested in all Marketing extensions from our Marketplace'),(1759,'To change the password, log into your company account and use the \'Modify profile\' link'),(1592,'To change the roles of your profile, contact the store administrator'),(1305,'To contact us please fill the form below'),(1404,'To continue, please, sign in'),(1306,'To email'),(332,'To enable secure protocol for your website pages you need a valid SSL certificate purchased for the website domain and installed on your server.'),(3639,'To enable this payment method, you need <Multi-vendor> module installed.'),(3638,'To enable this payment method, you need Multi-vendor module installed.'),(274,'To fix this problem, do the following: 3 points'),(257,'To get the format of the import data you can export your products to a file'),(1538,'To have attributes specific for product classes, define product classes first.'),(331,'To make the online store use the secure protocol you need an SSL certificate purchased for the website domain and installed on your server.'),(2519,'To make your changes visible in the customer area, cache rebuild is required. It will take several seconds. You don’t need to close the storefront, the operation is executed in the background.'),(4312,'To move your existing subscribers to MailChimp lists, <export your subscribers data> from X-Cart and use the import feature under your MailChimp account.'),(1307,'To place the order please accept Terms and Conditions'),(1308,'To place the order please complete the previous steps first'),(1309,'To recover your password, please type in the valid e-mail address you use as a login'),(3901,'To request a return please fill the form below'),(3171,'To send email asynchronously and improve website performance we recommend to set up queues in on your server. [Learn how to do it].'),(3767,'To set up the integration you should follow '),(4089,'To set up the integration, go to the _Site management_'),(13,'To setup Tax Rates, find and install the appropriate addons from Marketplace'),(2834,'To setup Tax Rates, find and install the appropriate addons from Marketplace\', {\'url\': url(\'addons_list_marketplace\', \'\', {\'tag\': \'Taxes'),(3939,'To start registration process for Canada Post merchant account click on the \"Register\" button.'),(3436,'To use the coupon, your order subtotal must be at least X'),(3435,'To use the coupon, your order subtotal must be between X and Y'),(3437,'To use the coupon, your order subtotal must not exceed Y'),(1310,'Today'),(3825,'Too large value for absolute discount'),(2683,'Tools'),(4301,'Top News'),(191,'Top X products'),(81,'Top banner'),(1311,'Top sellers'),(1312,'Top selling products'),(209,'Total'),(4237,'Total amount of orders'),(3924,'Total items weight'),(3963,'Total weight'),(1765,'Totals'),(1170,'Track package'),(3968,'Tracking details'),(1178,'Tracking information has been sent'),(3778,'Tracking information was updated successfully'),(2415,'Tracking number'),(1176,'Tracking number is changed from \"{{old_number}}\" to \"{{new_number}}\"'),(1173,'Tracking numbers'),(3918,'Tracking pin'),(3906,'Tracking pins'),(3530,'Traditional'),(2420,'Transaction'),(2835,'Transaction ID'),(2085,'Transaction amount mismatch'),(3190,'Transaction is in progress'),(3392,'Transaction key'),(2055,'Transaction type'),(3250,'Transaction was failed'),(2646,'Transactions details'),(1313,'Translation driver'),(106,'Translations'),(3959,'Transmit shipment'),(3097,'Trial has expired!'),(303,'Trial period X days'),(1992,'Trial period expires today'),(1991,'Trial period is expired'),(3876,'Try clearing filters or different search terms.'),(1785,'Try search-as-you-type feature...'),(1851,'Try to change the search criteria or find the needed solution in marketplace'),(2836,'Try to change the search criteria or find the needed solution in marketplace\', {\'URL\': url(\'addons_list_marketplace\', \'\', {\'tag\': \'Payment processing'),(3696,'Try to reconnect'),(1852,'Try to search worldwide or find the needed solution in marketplace'),(2837,'Try to search worldwide or find the needed solution in marketplace\', {\'URL\': url(\'addons_list_marketplace\', \'\', {\'tag\': \'Payment processing'),(1452,'Try to unpack them manually'),(273,'Trying to access the shop at X'),(2604,'Trying to run pre-upgrade hooks while not all archives were unpacked'),(3517,'Tweet'),(4650,'Twig-template path'),(1314,'Twitter'),(2215,'Two columns with left sidebar'),(2214,'Two columns with right sidebar'),(1315,'Type'),(1316,'Type of Account'),(3352,'Type of authorization request'),(4224,'Type: checkbox'),(4223,'Type: select box'),(3772,'U.S.P.S. module allows you to use online shipping rates calculation via USPS Web Tools Ecommerce API.'),(2639,'UPS'),(4721,'UPS module allows to use online shipping rates calculation via UPS service.'),(4618,'URL'),(4092,'URL is copied'),(1619,'URLs'),(2640,'USPS'),(3777,'USPS Shipments'),(1863,'Unable to delete file'),(1475,'Unable to delete module X files: some dirs have no writable permissions: Y'),(2743,'Unable to download the contents of {{url}}'),(2745,'Unable to get at the contents of {{url}}'),(3814,'Unable to get merchant info'),(278,'Unable to install module X because some modules, which it depends on, have not been installed or activated yet'),(4690,'Unable to reset layout'),(3694,'Unable to retrieve Publisher ID for specified PayPal account. Banners are now disabled.'),(4692,'Unable to save changes'),(4645,'Unable to save edited content. Errors: '),(2742,'Unable to write data to file {{file}}'),(2678,'Unallowed modules will be disabled automatically on the next visit any page in the administrator interface.'),(2064,'Unavailable'),(3502,'Unblock and renew'),(1319,'Uncheck all'),(94,'Undelete'),(1320,'Understanding Online Payments'),(1321,'Unexpected error: version value is not passed'),(4086,'Unexpected result was received from ePDQ (transaction status is not set)'),(4214,'Unexpected result was received from iDEAL (transaction status is not set)'),(1403,'Unfortunately, you don\'t have permissions to access this page.'),(3622,'Unfortunately, your API credentials could not be obtained from your PayPal account automatically.'),(1322,'Uninstall'),(1323,'Units & Formats'),(1324,'Units of measurement'),(3531,'Universal Analytics'),(1325,'Unknown'),(2953,'Unknown core version'),(3313,'Unknown error'),(3566,'Unknown error occurred'),(1493,'Unknown language: X'),(4219,'Unknown payment transaction'),(2170,'Unknown payment. If you see this message after returning from the payment page, please contact the store administrator for information about the status of your payment.'),(4646,'Unknown temporary file'),(2089,'Unlimited'),(3929,'Unpackaged'),(1326,'Unpacking archives, please wait...'),(4761,'Unread'),(1740,'Unselect all'),(1327,'Unset'),(4066,'Unsupported file extension'),(40,'Update'),(4226,'Update MailChimp Lists'),(3815,'Update date'),(1328,'Update exceptions'),(1980,'Update existing items, but skip new items'),(1329,'Update module'),(2847,'Update modules'),(1330,'Update product'),(1331,'Update profile'),(4735,'Update quantity'),(4742,'Update quantity import guide'),(4294,'Update store data'),(3816,'Update tracking info'),(1332,'Updated components'),(1333,'Updates are available'),(1334,'Updates for the X-Cart core and/or installed modules are available'),(1335,'Updates for your version ({{version}})'),(2838,'Updating data from the marketplace...'),(1336,'Upgrade'),(2471,'Upgrade access level cannot be changed for default free license'),(2467,'Upgrade access level has been successfully assigned to your license keys'),(2468,'Upgrade access level tooltip message'),(1337,'Upgrade available'),(1338,'Upgrade core'),(1726,'Upgrade for X-Cart core is available'),(1339,'Upgrade module'),(2863,'Upgrade not allowed'),(2348,'Upgrade note'),(3077,'Upgrade phar warning'),(1340,'Upgrade to version {{version}}'),(1341,'Upload'),(4370,'Upload a new logo'),(1342,'Upload add-on'),(1343,'Upload and restore'),(4334,'Upload company logo'),(1344,'Upload file'),(3033,'Upload file size limit'),(1508,'Upload files'),(1543,'Upload from server'),(1544,'Upload from your computer'),(4621,'Upload image'),(4276,'Upload store data to MailChimp'),(88,'Upload via URL'),(4365,'Upload your company logo'),(4295,'Uploading data has been completed successfully.'),(4296,'Uploading data has been stopped.'),(3598,'Use PayPal authentication method'),(3495,'Use X-Sendfile to facilitate the download of large file attachments (100 Mb and larger) by customers:'),(1345,'Use a merchant account from your financial institution or choose a bundled payment solution to accept credit cards and other methods of payment on your website.'),(1346,'Use a merchant account from your financial institution to accept online payments'),(4599,'Use custom css'),(1347,'Use custom js'),(1349,'Use default logo'),(1351,'Use dynamic image help'),(1350,'Use dynamic image resizing'),(3383,'Use existing Amazon account'),(3633,'Use existing PayPal account'),(3631,'Use existing account from'),(1348,'Use lazy loading'),(3718,'Use of Restriction key must be disabled in your Quantum Gateway merchant center account at all times.'),(3655,'Use of the unsupported Payment Data Transfer (PDT) method has been detected'),(2037,'Use our new nifty module to automatically backup your store and be able to restore it if anything crops up.'),(4684,'Use the Google Tag Manager addon for more flexibility when adding JS code to your web pages.'),(4111,'Use the addon Google Product Feed for advanced flexibility generating a data feed for Facebook based on the product attributes and variants from your store catalog'),(1352,'Use the category name'),(1761,'Use the following key to access safe mode'),(2284,'Use the form below to provide your license information.'),(1353,'Use the navigation bar above this dialog to navigate through the catalog categories'),(3738,'Use the same tax rates for all user membership levels'),(3842,'Use this X-Cart and Google Ads integration to:'),(3796,'Use this field for instructions in case the package is not delivered.'),(1354,'Use this section to back the database of your online store up. Please note that the database backup procedure can take up to several minutes.'),(1547,'Use this section to back up the database of your online store. Please note that the database backup procedure can take up to several minutes.'),(1355,'Use this section to define shipping zones.'),(1356,'Use this section to define your store\'s shipping methods.'),(1357,'Use this section to manage the list of existing countries. This list is used in the shipping settings and calculations, and in the registration form at the Customer Front-end.'),(1358,'Use this section to manage the lists of counties, provinces, regions and states of different countries. The lists are used in shipping settings and calculations, and in the registration form at the Customer Front-end.'),(1359,'Use this section to restore the database of your online store. Please note that the database restoration procedure can take up to several minutes'),(1360,'Use this section to review the list of existing membership levels and add new ones'),(2083,'User'),(241,'User X is logged in'),(1724,'User activity'),(1767,'User filled in Contact Us form'),(4408,'User manuals, release notes, modules, videos and more.'),(1361,'User membership'),(1362,'User type'),(1363,'Username or e-mail'),(1364,'Users'),(3127,'Users list'),(1365,'Uses count'),(1366,'Uses left'),(2675,'Using the modules with this type of license violation is illegal'),(2299,'VALID THRU'),(1367,'VAT'),(1368,'Validate key'),(1369,'Value'),(4114,'Value for the \"Add to cart\" event is calculated as'),(4118,'Value for the \"InitiateCheckout\" event is calculated as'),(4117,'Value for the \"ViewContent\" event on a product page is calculated as'),(2373,'Variables for this notification'),(2223,'Variant attribute \"{{column}}\" cannot be empty'),(3688,'Venmo'),(1514,'Verification results'),(2362,'Verified'),(4335,'Verify geo settings'),(2363,'Verifying data before importing...'),(1370,'Version'),(1371,'Version change'),(87,'Via URL'),(1936,'View all addons'),(1747,'View all low inventory products'),(1372,'View all open orders'),(2142,'View all ordered items'),(216,'View cart'),(85,'View image'),(1659,'View in list'),(3314,'View in my addons'),(1373,'View logs'),(2466,'View more addons in Marketplace'),(2702,'View order history'),(1374,'View profile'),(2385,'View storefront'),(1375,'View system logs'),(1376,'View update log'),(3745,'Visible for'),(4441,'Visible in products filter'),(1377,'Visit module details page'),(1378,'Visit storefront'),(2512,'Visit the template store'),(2103,'Void'),(2728,'Void multiple[TT]'),(2727,'Void partially[TT]'),(3957,'Void shipment'),(2692,'Void[S]'),(2726,'Void[TT]'),(1379,'Volume discounts'),(4519,'Votes: X'),(1674,'WARNING! There are no more available administrators\' profiles. You will not be able to manage your store after you delete this profile.'),(359,'WE'),(3532,'Want help with SEO? Ask X-Cart Guru'),(2618,'Want to change or add another accounting system? Choose the accounting system you require below and configure it.'),(3141,'Want to customize review surveys and display video testimonials? Try Shopper Approved and collect up to 70x more ratings and reviews'),(1380,'Warning'),(1693,'Warning!'),(1713,'Warning! CSV file was not specified.'),(1691,'Warning! InnoDB engine is not supported. It is required for software operation'),(1649,'Warning! Installing this module will overwrite all language labels translated to the appropriate language.'),(4217,'Warning! Please re-check public and private key values!'),(1716,'Warning! The file you have specified in the \'File (CSV) for upload\' field has not been uploaded to the server.'),(1714,'Warning! The file you have specified in the \'File (CSV) local\' field does not exist or cannot be read.'),(3099,'Warning! The image cannot be resized to reduce capacity for better site performance.'),(2492,'Warning! The selected types of content data will be deleted permanently.'),(1381,'Warning! There is not enough product items in stock to process the order'),(4216,'Warning! This payment method requires OpenSSL extension. Please install and enable this extension in your PHP configuration.'),(1545,'Warning: The restoration procedure is irreversible and erases all the data tables from the store database. It is highly recommended that you back up your current database before restoring one of the previous states from a back-up.'),(1382,'Warning: this operation can not be reverted!'),(2718,'Warnings'),(308,'Watch this short video and learn the basics of how online payment processing works'),(1383,'Watch video'),(4011,'Way to deliver'),(1491,'We are already aware of this problem and working on it. If you would like to get in touch, feel free to contact us via our Help center at _URL_'),(3410,'We are always glad to help you.'),(2036,'We are doing our best to make your upgrade process not only easy to do, but safe.'),(3683,'We are experiencing a problem with the \"PayPal For Marketplaces\" payment method.'),(3148,'We couldn\'t find one correct root category'),(3149,'We couldn\'t find one correct root category, however there are possible candidates'),(1497,'We have found a valid SSL certificate installed on the server. Now you can switch the store to use the secure protocol for the store back-end and checkout, sign-in and profile pages.'),(3518,'We recommend to use share button instead of like'),(4505,'We use this email in case we need additional information on your review. We do not use it for any kind of mailing lists or spam subscriptions'),(2038,'We will email you with emergency links to disable custom modules and stay only with original add-ons.'),(4378,'We will use this info to create invoices, send emails and calculate shipping rates for your customers.'),(4374,'We\'ve tried to guess your country, currency and weight. Verify, please.'),(3329,'Weak password'),(4245,'Web ID'),(1384,'Web server'),(4055,'Web server max upload file size limit is X'),(4592,'Webhook URL is your store\'s URL through which Stripe informs your store about any changes in the order'),(3680,'Webhook listener error: could not subscribe to event(s).'),(4610,'Webmaster Mode allows you to change the storefront design in click-and-edit mode'),(4607,'Webmaster mode'),(4612,'Webmaster mode is disabled'),(4611,'Webmaster mode is enabled'),(1742,'Website'),(382,'Week'),(27,'Weight'),(28,'Weight X'),(1385,'Weight modifier'),(2572,'Weight range'),(1594,'Welcome'),(207,'Welcome to X-Cart'),(1386,'What is benchmark?'),(1600,'What to export'),(2558,'What type of shipping rates would you like to use?'),(305,'What\'s new'),(3388,'When AustraliaPost returns shipping methods which does not exists in the available methods list, these methods will be created in the list automatically'),(3685,'When multiple funding sources are available to the buyer, PayPal automatically determines which additional buttons are appropriate to display. However, you can choose to opt-in or out-of displaying specific funding sources.'),(1387,'When the export is completed, you will be prompted to download the product data file'),(1610,'Whether customers should be able to select an option they require when ordering the product, or the information is provided purely as part of product specification'),(1883,'Widgets cache has been cleaned'),(1884,'Widgets cache has not been cleaned completely'),(2052,'Width'),(1388,'Width (px)'),(3110,'Will be added globally'),(3111,'Will be added to the product class'),(2978,'Will be available if core update is selected'),(2397,'Will be deleted:'),(1728,'Will be installed'),(2394,'Will be updated if core update is selected'),(2633,'Win app'),(3249,'Wonder why it may have happened? It’s likely that your customer entered a wrong card number, password or CVC'),(4786,'Write your message'),(4507,'Write your review'),(2265,'Wrong \"default\" format ({{value}}). Value should be one of \"Yes\" or \"No\"'),(4110,'Wrong \"facebook marketing enabled\" format'),(2264,'Wrong \"owner\" format ({{value}}). Value should be one of \"Yes\" or \"No\"'),(2266,'Wrong \"priceModifier\" format ({{value}}). Correct examples: +1, +1%, -1, -1%'),(2263,'Wrong \"type\" value ({{value}}). This should be \"C\", \"S\", \"H\" or \"T\"'),(2267,'Wrong \"weightModifier\" format ({{value}}). Correct examples: +1, +1%, -1, -1%'),(2750,'Wrong access level format'),(2272,'Wrong added format'),(2921,'Wrong address same format'),(2920,'Wrong anonymous format'),(2241,'Wrong arrival date format'),(2279,'Wrong billing address format'),(2251,'Wrong box height format'),(2250,'Wrong box length format'),(2249,'Wrong box width format'),(3775,'Wrong container type selected: {{value}}. For large package size only the following types are allowed: RECTANGULAR, NONRECTANGULAR, VARIABLE'),(2280,'Wrong country code format'),(2924,'Wrong currency format'),(2242,'Wrong date format'),(2236,'Wrong enabled format'),(4156,'Wrong exclude from shipping cost format'),(2273,'Wrong first login date format'),(2253,'Wrong format of Clean URL value (allowed alpha-numeric, \"_\" and \"-\" chars)'),(2446,'Wrong format: Field contains unallowed characters'),(4157,'Wrong free shipping format'),(4147,'Wrong freight fixed fee format'),(2244,'Wrong inventory tracking format'),(2937,'Wrong item order modifier format'),(2252,'Wrong items per box format'),(2277,'Wrong language format'),(2274,'Wrong last login date format'),(2271,'Wrong login format'),(2247,'Wrong low limit level format'),(2246,'Wrong low stock notification format'),(2237,'Wrong meta desc type format'),(1389,'Wrong method_id specifed'),(2929,'Wrong order item format'),(2931,'Wrong order item name format'),(2932,'Wrong order item price format'),(2935,'Wrong order item quantity format'),(2930,'Wrong order item sku format'),(2933,'Wrong order item subtotal format'),(2934,'Wrong order item total format'),(2928,'Wrong order modifier format'),(2919,'Wrong order number format'),(2944,'Wrong order transaction currency format'),(2938,'Wrong order transaction format'),(2943,'Wrong order transaction id format'),(2939,'Wrong order transaction method format'),(2941,'Wrong order transaction value format'),(2257,'Wrong position format'),(2235,'Wrong price format'),(4739,'Wrong product quantity value format (\"{{value}}\")'),(2276,'Wrong referer format'),(2752,'Wrong role format'),(2239,'Wrong shippable format'),(2278,'Wrong shipping address format'),(2270,'Wrong show title format'),(2281,'Wrong state id format'),(2275,'Wrong status format'),(2245,'Wrong stock level format'),(2922,'Wrong subtotal format'),(3635,'Wrong token of Express Checkout. Please try again. If the problem persists, contact the administrator.'),(2923,'Wrong total format'),(2260,'Wrong type format'),(2243,'Wrong update date format'),(2240,'Wrong use separate box format'),(4448,'Wrong useClasses format'),(1390,'Wrong value is specified for arrival date field. The field was not updated.'),(2238,'Wrong weight format'),(248,'X GB'),(139,'X Language (Code: Y)'),(247,'X MB'),(3552,'X PIN Codes were not assigned.'),(3535,'X PIN code duplicates ignored.'),(3536,'X PIN codes created successfully.'),(3537,'X PIN codes longer than Y characters ignored.'),(3134,'X addon'),(1487,'X addon(s) selected'),(3135,'X addons'),(3136,'X addons (5)'),(316,'X attributes in group'),(245,'X bytes'),(3421,'X code is already used for other coupon, please specify a different code'),(3420,'X coupon(s) has been created'),(3419,'X coupon(s) has been removed'),(3094,'X day left'),(252,'X days'),(3095,'X days left'),(3096,'X days left (5)'),(290,'X entities has been created'),(289,'X entities has been removed'),(2171,'X expired shopping cart(s) have been successfully removed'),(189,'X field is required'),(1482,'X file type'),(4063,'X file(s) attached'),(253,'X hours'),(262,'X image unable to load'),(211,'X item'),(285,'X item available'),(158,'X item in bag'),(173,'X items'),(4574,'X items ($)'),(286,'X items available'),(159,'X items in bag'),(2861,'X items selected'),(246,'X kB'),(99,'X labels'),(406,'X language labels have been removed'),(405,'X languages have been removed'),(309,'X methods available'),(254,'X minutes'),(192,'X module settings'),(2350,'X module will be disabled'),(2352,'X module will be upgraded'),(2490,'X modules selected'),(2351,'X modules will be disabled'),(2353,'X modules will be upgraded'),(251,'X months'),(4772,'X new message for order'),(4797,'X new messages'),(3449,'X off'),(236,'X order'),(237,'X orders'),(320,'X orders on last day'),(322,'X orders on last month'),(321,'X orders on last week'),(288,'X product(s) has been created'),(287,'X product(s) has been removed'),(340,'X products'),(242,'X products found'),(4419,'X products selected'),(234,'X results found'),(323,'X revenue on last day'),(325,'X revenue on last month'),(324,'X revenue on last week'),(255,'X seconds'),(417,'X shipping methods have been created'),(418,'X shipping methods have been removed'),(4467,'X star_1'),(4466,'X stars_2'),(4465,'X stars_3'),(4464,'X stars_4'),(4463,'X stars_5'),(409,'X states have been removed'),(410,'X states have been successfully created'),(4768,'X unread messages'),(250,'X years'),(411,'X zones have been removed'),(412,'X zones have been successfully created'),(4343,'X% Wizard completion'),(334,'X, including images and file attachments'),(1391,'X-Cart'),(3090,'X-Cart Business trial will expire in X day'),(3091,'X-Cart Business trial will expire in X days'),(3092,'X-Cart Business trial will expire in X days (5)'),(3837,'X-Cart Google Ads by Kliken'),(107,'X-Cart News'),(2900,'X-Cart Team have done their best to make your upgrade process as enjoyable as possible.'),(2538,'X-Cart could not find a valid SSL certificate on your server X.'),(2537,'X-Cart could not find a valid SSL certificate on your server.'),(2536,'X-Cart could not find a valid SSL certificate on your server. Although you can switch the store to use the secure protocol for the website pages, most Internet browsers will likely display a warning message scaring your website visitors away.'),(2163,'X-Cart could not find data in your file.'),(2525,'X-Cart found some issues with installed SSL certificate'),(2435,'X-Cart license key has been successfully verified'),(2436,'X-Cart license key has been successfully verified and activated. But this key has expired and do not allow upgrade store.'),(1392,'X-Cart online store builder'),(4407,'X-Cart professionals will easily materialize just about any idea you’ve got.'),(1393,'X-Cart shopping cart software'),(2864,'X-Cart v5.3 requires PHP version 5.4 or better. Please update the PHP version installed on your server before you proceed.'),(2866,'X-Cart v5.4 requires MariaDB version 10.2.4 or better. Please update the MariaDB version installed on your server before you proceed.'),(2867,'X-Cart v5.4 requires MySQL version 5.7.7 or better. Please update the MySQL version installed on your server before you proceed.'),(2865,'X-Cart v5.4 requires PHP version 7.2 or better. Please update the PHP version installed on your server before you proceed.'),(3057,'XML extensions support'),(1394,'XML parser'),(1395,'XML sitemap'),(3829,'XML sitemap URL: X'),(2300,'YEAR'),(1396,'Yahoo!'),(1397,'Yandex'),(385,'Year'),(2108,'Year when store started its operation'),(1398,'Yes'),(1399,'Yes, I agree with License agreement'),(2391,'Yes, I agree with License agreements'),(2035,'Yes, I have made the full backup of my store files and database'),(4381,'Yes, I sell tangible goods that needed to be shipped'),(1929,'Yes/No'),(2460,'Yesterday'),(4773,'You Have No Messages'),(136,'You are going to delete the X language'),(2544,'You are logged in as: user'),(1400,'You are not allowed to access this resource!'),(4622,'You are now in layout editing mode'),(4623,'You are now in preview mode'),(2540,'You are operating as:'),(2543,'You are operating as: user'),(1770,'You are sure to clear your cart?'),(2677,'You can also contact our CR department for help with this issue'),(4057,'You can attach X file(s)'),(4056,'You can attach X more file(s)'),(1685,'You can build your web-site during FREE evaluation, but you cannot use this installation for real sales without buying a license.'),(2212,'You can change the CSV delimiter for all subsequent imports and exports using this link'),(2211,'You can change the charset for all subsequent imports and exports using this link'),(293,'You can choose if to download your database data'),(2950,'You can continue as guest or create an account'),(4709,'You can customize the look & feel of the store by configuring the layout and adding the custom CSS or HTML code.'),(3572,'You can define an order id prefix, which would precede each order number in your shop, to make it unique'),(2587,'You can define the following values:'),(4332,'You can find the failed order here'),(2647,'You can find the failed transaction here'),(2535,'You can get more information using this service: '),(132,'You can install these updates after purchasing and activating your X-Cart license key'),(1758,'You can now use the following credentials to access your account'),(2839,'You can purchase AntiFraud Service subscription'),(2585,'You can set up different shipping rates depending on the weight, price or quantity of items in the order.'),(275,'You can upload the database data directly from your local computer'),(4364,'You can view the newly created product in your [storefront] or add a few [more products] to your catalog.'),(4749,'You cannot choose this product'),(1549,'You cannot save database data to a file on the web server (\'var/backup/sqldump.sql.php\').'),(2756,'You cannot update administrator profile ({{value}}). Row is skipped'),(2755,'You cannot update administrator profile ({{value}}). Row will be skipped'),(3212,'You don’t have any notifications right now.'),(4357,'You have added 1 product'),(4490,'You have already reviewed this product'),(3423,'You have already used the coupon'),(1845,'You have an unpaid order #{{ORDER}}'),(4322,'You have configured MailChimp as your primary email newsletter tool. New subscribers will be added directly to your MailChimp lists (this X-Cart list will be skipped). You can manage your subscriber lists under your MailChimp account'),(1633,'You have no payment methods enabled in your shop'),(1407,'You have selected to delete your profile. Please, confirm you want to proceed'),(1593,'You have the following roles:'),(4075,'You have to attach file'),(4074,'You have to attach file to product'),(4625,'You have unsaved changes. Are you really sure to exit the preview?'),(4682,'You have unsaved changes. Are you really sure to exit?'),(4012,'You just added'),(3080,'You must register your X-Cart installation before using it for real sales. Activate your existing license key or purchase a premium license to skyrocket your business.'),(21,'You must register your installation before you can use it for real sales'),(2031,'You need hard and soft reset links in case some 3rd party module crashes your web-store'),(2840,'You need these links in case you want to recover your store'),(2531,'You should check available free disk space yourself before continuing installation'),(2530,'You should check available free disk space yourself before continuing upgrade'),(2347,'You should confirm that you have created backup before upgrading the store.'),(1842,'You tried to buy more items of \"{{product}}\" product {{description}} than are in stock. We have {{amount}} item(s) only. Please adjust the product quantity.'),(3549,'You will be able to add pin codes after saving changes.'),(1552,'You will be able to provide additional product info (images, attributes, etc.) after you submit this form.'),(4393,'You\'ve successfully set up shipping areas and rates for your store'),(2128,'Your \"Password reset key\" has expired. Please enter the email address associated with your user account to get a new \"Password reset key\".'),(3621,'Your API credentials have been successfully obtained from your PayPal account and saved for use by your X-Cart store.'),(1817,'Your Account'),(3407,'Your Message'),(3187,'Your PHP version is outdated'),(3188,'Your PHP version is outdated and no longer supported'),(3593,'Your PayPal Publisher ID is X'),(4591,'Your Stripe account is no longer accessible. Please connect with Stripe once again.'),(3079,'Your X-Cart Business trial has expired!'),(1684,'Your X-Cart installation is licensed for evaluation purposes only.'),(3850,'Your X-Cart store is connected to your Kliken account.'),(1401,'Your access link has been expired'),(3114,'Your access to X-Cart Business features expires in X day'),(3115,'Your access to X-Cart Business features expires in X days'),(3116,'Your access to X-Cart Business features expires in X days (5)'),(306,'Your account email is X'),(1417,'Your account information will be e-mailed to you shortly'),(1418,'Your account information will be e-mailed to you shortly.'),(307,'Your account password is X'),(3573,'Your account settings'),(3637,'Your address data was not received from PayPal. Please try again. If the problem persists, contact the administrator.'),(220,'Your cart'),(1402,'Your custom addons were prepared for certain core version'),(4603,'Your custom file is successfully saved'),(1419,'Your e-mail'),(4497,'Your email'),(420,'Your first name'),(421,'Your last name'),(1420,'Your name'),(1757,'Your new password'),(1970,'Your order details will be sent to your e-mail address'),(4140,'Your order details will be sent to your email address'),(3575,'Your partner name is PayPal'),(3385,'Your payment could not be processed, please follow the instructions in the payment method box.'),(3384,'Your payment could not be processed. Please try to place the order again using another payment method.'),(3129,'Your payment has been processed; now the addon can be installed.'),(3130,'Your payment is being processed. The addon license key will be sent to your email address as soon as the processing has been completed. You will be able to use this key to install the addon at any time. '),(3487,'Your payment module to accept payments for digital items. [Get it now]!'),(4494,'Your product rating is saved. Thank you!'),(1421,'Your products will be exported as a CSV file.'),(1766,'Your profile modified'),(2355,'Your request has been sent successfully'),(4508,'Your review'),(4495,'Your review has been updated. Thank your for sharing your opinion with us!'),(170,'Your shopping bag - X item'),(171,'Your shopping bag - X items'),(1422,'Your shopping bag is empty'),(1423,'Your state'),(1424,'Your store'),(1496,'Your store is configured to use the secure protocol for the store back-end and checkout, sign-in and profile pages.'),(3849,'Your store is connected.'),(1425,'Your store is currently unable to calculate taxes'),(4170,'Your store uses the addon Geolocation'),(2359,'Your version (X) can be upgraded to'),(4018,'Z - A'),(185,'Zero cannot be used'),(1426,'Zip code'),(1427,'Zip/postal code masks'),(4132,'Zipcode'),(1429,'Zone'),(416,'Zone address masks help'),(415,'Zone city masks help'),(167,'Zone details have been updated successfully'),(1430,'Zone name'),(1483,'Zone not found (X)'),(414,'Zone zipcode masks help'),(1431,'Zones'),(2387,'Zoom image'),(3653,'[BT] In progress'),(2774,'[Edit]'),(3251,'[field] year must be between 1970 and 2038'),(4277,'_MailChimp ecommerce info text_'),(174,'_X_ item'),(175,'_X_ items'),(3654,'__pdt-paypal-warning__'),(2059,'a side box'),(3711,'a2cp-source-code-PAB'),(4752,'a2cp-source-code-REL'),(1812,'address during the recent purchase'),(2095,'always'),(1432,'and'),(4700,'app icon uploader'),(1771,'attributes'),(3108,'attributes_popover_text'),(3394,'authorize_key_help'),(1810,'billing'),(3205,'body of the test email'),(3863,'braintree_merchant_account_id_help'),(3864,'braintree_paypal_shipping_override_help'),(1433,'by'),(4328,'by payment callback (Failed + Cancel)'),(4329,'by pressing Place order button'),(1413,'cURL error'),(1697,'cannot create directory'),(279,'cannot set X permissions'),(2341,'checkbox.firstlast.off'),(2340,'checkbox.firstlast.on'),(2339,'checkbox.onoff.off'),(2338,'checkbox.onoff.on'),(2006,'cm'),(3013,'config_file.error_message_1'),(3014,'config_file.label_message'),(3870,'cs_categories'),(3873,'cs_did_you_mean'),(3872,'cs_manufacturers'),(3871,'cs_pages'),(3869,'cs_products'),(3866,'cs_see_details'),(3867,'cs_see_more_results_for'),(3865,'cs_showing_results_for'),(3868,'cs_suggestions'),(4498,'customers'),(2097,'daily'),(1589,'default'),(2781,'default-404-text'),(661,'default-meta-description'),(2772,'default-meta-keywords'),(2771,'default-site-title'),(1494,'deleted'),(2553,'deliveryTime.help'),(3947,'deposit your items at a Post Office'),(1434,'details'),(1669,'dimensions'),(1435,'disabled'),(4633,'disabled blocks'),(2007,'dm'),(3061,'doc_blocks_support.error_message_1'),(3062,'doc_blocks_support.error_message_2'),(3063,'doc_blocks_support.label_message'),(2986,'dom.extension.alert'),(1875,'done'),(1436,'downloads'),(4283,'e-Commerce Analytics disable warning'),(2641,'eBay'),(4082,'ePDQ Currency'),(4084,'ePDQ Enable logging of ePDQ transactions'),(4083,'ePDQ Invoice number prefix'),(4079,'ePDQ PSPID'),(4080,'ePDQ SHA-IN pass phrase'),(4081,'ePDQ SHA-OUT pass phrase'),(4078,'ePDQ settings note'),(2093,'each'),(1601,'editable'),(3196,'email from Contact information section'),(427,'email@example.com'),(2318,'emailNotificationAdminGreeting'),(2317,'emailNotificationAdminHeader'),(2319,'emailNotificationAdminSignature'),(2315,'emailNotificationCustomerGreeting'),(2314,'emailNotificationCustomerHeader'),(2316,'emailNotificationCustomerSignature'),(2320,'emailNotificationTipGoogleADS'),(1712,'empty'),(3941,'enable merchant wizard'),(1437,'enabled'),(2061,'expired'),(4699,'favicon uploader'),(3509,'fedex.CODStatusOptionComment'),(1699,'file does not exist'),(3037,'file_permissions.error_message_1'),(3038,'file_permissions.error_message_2'),(3039,'file_permissions.kb_message'),(2574,'flat rate'),(745,'from'),(1438,'from URL'),(1439,'from local computer'),(1440,'from local server'),(2020,'g'),(1441,'hard reset'),(4241,'here'),(2358,'hide list'),(2096,'hourly'),(3220,'https://kb.x-cart.com/'),(3239,'https://kb.x-cart.com/general_setup/inaccessible_admin_area_after_enabling_https.html'),(3224,'https://kb.x-cart.com/general_setup/moving_x-cart_to_another_location.html'),(3222,'https://kb.x-cart.com/general_setup/moving_x-cart_to_another_location.html#transfering-database'),(3221,'https://kb.x-cart.com/general_setup/what_to_do_if_your_store_says_we_are_deploying_new_changes_and_you_cannot_access_it.html'),(3225,'https://kb.x-cart.com/import-export/'),(3228,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_categories.html'),(3226,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_classes_&_attributes.html'),(3229,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_customers.html'),(3231,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_orders.html'),(3227,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_product_attribute_values.html'),(3230,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_products.html'),(3237,'https://kb.x-cart.com/integrating_your_store_with_other_web-sites/sell_your_products_with_buy_button.html'),(4743,'https://kb.x-cart.com/modules/update_inventory.html'),(3233,'https://kb.x-cart.com/payments/paypal/setting_up_paypal_express_checkout.html'),(3234,'https://kb.x-cart.com/payments/paypal/setting_up_paypal_payflow_link.html'),(3235,'https://kb.x-cart.com/payments/paypal/setting_up_paypal_payments_advanced.html'),(3236,'https://kb.x-cart.com/payments/paypal/setting_up_paypal_payments_standard.html'),(3223,'https://kb.x-cart.com/seo_and_promotion/setting_up_seo-friendly_urls.html'),(3232,'https://kb.x-cart.com/setting_up_x-cart_5_environment/configuring_attachments_sending.html'),(3238,'https://kb.x-cart.com/shipping/custom_table_rates.html'),(3241,'https://kb.x-cart.com/shipping/free_shipping.html'),(3243,'https://kb.x-cart.com/taxes/UK_EU_taxes/'),(3245,'https://kb.x-cart.com/taxes/canadian_taxes/'),(3246,'https://kb.x-cart.com/taxes/setting_up_tax_classes.html'),(3242,'https://kb.x-cart.com/taxes/tax_guide.html'),(3244,'https://kb.x-cart.com/taxes/us_taxes/'),(3240,'https://kb.x-cart.com/users/user_roles.html'),(3053,'https_bouncer.error_message_1'),(3054,'https_bouncer.error_message_2'),(3056,'https_bouncer.kb_message'),(3055,'https_bouncer.label_message'),(4210,'iDEAL Currency'),(4212,'iDEAL Enable logging of iDEAL transactions'),(4211,'iDEAL Invoice number prefix'),(4204,'iDEAL Merchant ID'),(4208,'iDEAL Private Key'),(4209,'iDEAL Private Key Password'),(4206,'iDEAL Public Certificate File'),(4207,'iDEAL Public Key'),(4205,'iDEAL SubID'),(1663,'if you have any questions'),(3193,'imgsize-XLite\\Model\\Image\\Common\\Logo-Default'),(2523,'imgsize-category-Default'),(2520,'imgsize-product-Default'),(2521,'imgsize-product-LGThumbnailGrid'),(2522,'imgsize-product-LGThumbnailList'),(1442,'in description'),(1443,'in title'),(2673,'inactive license key(s);'),(2008,'inches'),(3011,'install_script.error_message_1'),(2674,'installed module(s) not allowed by the type of X-Cart license activated at your store.'),(1477,'invalid module ID passed: X'),(1444,'is available'),(1670,'item(s)'),(1769,'item(s) in stock'),(213,'items'),(1445,'items available'),(2992,'itemslist.admin.category.blank'),(3463,'itemslist.admin.coupon.blank'),(2993,'itemslist.admin.membership.blank'),(3762,'itemslist.admin.menu.blank'),(4311,'itemslist.admin.news_message.blank'),(2988,'itemslist.admin.order.blank'),(2987,'itemslist.admin.order.search.blank'),(3761,'itemslist.admin.page.blank'),(2991,'itemslist.admin.product.blank'),(2990,'itemslist.admin.product.search.blank'),(4543,'itemslist.admin.review.blank'),(3006,'itemslist.admin.subcategory.blank'),(4321,'itemslist.admin.subscribers.blank'),(4458,'itemslist.admin.tag.blank'),(4672,'itemslist.admin.template.blank'),(2989,'itemslist.admin.transaction.blank'),(3826,'itemslist.admin.volume_discounts.blank'),(2019,'kg'),(1586,'label name,'),(1587,'label translation.'),(3896,'label.coming_soon'),(1580,'labels count:'),(1585,'language code,'),(2017,'lbs'),(4045,'learn more'),(1446,'less'),(3482,'less one hour'),(1620,'local files'),(4698,'logo uploader'),(3065,'loopback_request.error_message_1'),(3067,'loopback_request.kb_message'),(3066,'loopback_request.label_message'),(3200,'mail tester line 1'),(3201,'mail tester line 2'),(3202,'mail tester line 3'),(3203,'mail tester line 4'),(4278,'mailchimp_settings_promo_text'),(2985,'mbstring.extension.alert'),(2005,'mm'),(1479,'module version X is not equal to the core one (Y)'),(4,'module-sort-Alphabetically'),(2,'module-sort-Most popular'),(3,'module-sort-Newest'),(1447,'modules'),(2099,'monthly'),(2701,'more'),(1448,'ms'),(1602,'multi value'),(3045,'mysql_cache.error_message_1'),(3041,'mysql_version.error_message_1'),(3042,'mysql_version.error_message_2'),(3043,'mysql_version.error_message_3'),(46,'n/a'),(2737,'na_admin'),(2709,'na_customer'),(1449,'never'),(3133,'new core'),(3137,'new core and X addon'),(3138,'new core and X addons'),(3139,'new core and X addons (5)'),(4702,'new template'),(2194,'no comments'),(1450,'none'),(1451,'not all archives were unpacked'),(429,'not all upgrade packs were downloaded'),(1453,'not available for sale'),(4327,'not finished'),(1454,'not installed'),(1455,'not ready to download packs. Please, try again'),(2881,'notification.column.administrator'),(2880,'notification.column.customer'),(2877,'notification.section.administrator'),(2876,'notification.section.customer'),(2879,'notification.tab.administrator'),(2878,'notification.tab.customer'),(1725,'now disabled'),(1456,'of'),(4350,'onboarding.add_product.heading'),(4352,'onboarding.add_product.import'),(4351,'onboarding.add_product.text'),(4349,'onboarding.intro.disable_button'),(4345,'onboarding.intro.heading'),(4348,'onboarding.intro.later_button'),(4347,'onboarding.intro.next_button'),(4346,'onboarding.intro.text'),(1457,'options'),(1458,'or'),(4389,'or choose a shipping carrier to provide your customers with real-time quotes'),(3629,'or go to checkout as a New customer'),(2949,'or proceed with'),(2841,'or use the form below'),(4500,'out of'),(1657,'outdated'),(2018,'oz'),(2309,'paymentStatus.Active'),(2310,'paymentStatus.Inactive'),(3604,'paypal_welcome_text'),(2575,'per item'),(235,'per page'),(2576,'per weight unit'),(296,'percent X off'),(3021,'php_disabled_functions.error_message_1'),(3022,'php_disabled_functions.label_message'),(3027,'php_file_uploads.error_message_1'),(3028,'php_file_uploads.label_message'),(3047,'php_gdlib.error_message_1'),(3048,'php_gdlib.error_message_2'),(3024,'php_memory_limit.error_message_1'),(3025,'php_memory_limit.label_message'),(3030,'php_pdo_mysql.error_message_1'),(3032,'php_pdo_mysql.kb_message'),(3031,'php_pdo_mysql.label_message'),(3050,'php_phar.error_message_1'),(3051,'php_phar.label_message'),(3034,'php_upload_max_file_size.error_message_1'),(3035,'php_upload_max_file_size.label_message'),(3016,'php_version.error_message_1'),(3017,'php_version.error_message_2'),(3018,'php_version.error_message_3'),(3019,'php_version.label_message'),(1405,'please sign in'),(3678,'pp-button-location:Add2Cart popup'),(3674,'pp-button-location:Cart'),(3676,'pp-button-location:Checkout'),(3677,'pp-button-location:Checkout (credit)'),(3675,'pp-button-location:Minicart'),(3673,'pp-button-location:Product list'),(3672,'pp-button-location:Product page'),(2289,'price-All'),(2291,'price-Free'),(2290,'price-Paid'),(1677,'products'),(1459,'proxy'),(3413,'recaptcha_terms_of_service'),(3397,'relay_response_help'),(1933,'requested for'),(1522,'requested once or twice'),(1521,'requested only once'),(134,'required'),(4535,'reviewMetaDescription'),(1460,'sale'),(2891,'same as shipping'),(2094,'save'),(4284,'send all discount coupons'),(4285,'send only discount coupons with matched rules'),(3197,'sender identified by server'),(3946,'shipments are picked up by Canada Post'),(1811,'shipping'),(2580,'shippingFormula.DiscountedSubtotal'),(2582,'shippingFormula.Free'),(2578,'shippingFormula.Items'),(2577,'shippingFormula.Shipping'),(2579,'shippingFormula.Subtotal'),(2581,'shippingFormula.Weight'),(2600,'shippingStatus.Active'),(2601,'shippingStatus.Inactive'),(2568,'shippingTableType.All'),(2565,'shippingTableType.DiscountedSubtotal'),(2567,'shippingTableType.Items'),(2564,'shippingTableType.Subtotal'),(2566,'shippingTableType.Weight'),(1461,'should be performed manually'),(2402,'show list'),(1462,'soft reset'),(3198,'specific email address (set up below)'),(4547,'star_tooltip_1'),(4548,'star_tooltip_2'),(4549,'star_tooltip_3'),(4550,'star_tooltip_4'),(4551,'star_tooltip_5'),(1698,'subdirectories problems'),(37,'submit_restore_pass'),(2554,'tableType.help'),(4704,'template weight'),(2499,'the categories and product classes to which the coupon may be applied;'),(1736,'the custom modifications will be lost'),(2497,'the dates the coupon should be valid for;'),(2060,'the main column'),(2498,'the order subtotal range for which the coupon can be used;'),(2842,'the same as billing'),(4681,'themetweaker.shortcut.save'),(4680,'themetweaker.shortcut.switcher'),(2770,'title-delimiter'),(3191,'to be uninstalled'),(2948,'to enjoy checkout'),(3526,'to view the advanced statistics'),(1463,'trying to install a non-marketplace module: X'),(1464,'trying to unpack non-downloaded archives'),(4703,'type filename and press Enter'),(1478,'unable to add module entry to the installation list: X'),(1465,'unable to install: not all archives were unpacked. Please, try again'),(1466,'unable to test files: not all archives were unpacked'),(1480,'unable to upload module'),(2489,'unavailable'),(2092,'units'),(1467,'unknown'),(1869,'unknown error'),(3157,'up to 1 decimal'),(3159,'up to 10'),(3160,'up to 100'),(3156,'up to 2 decimals'),(3158,'up to integer'),(1651,'upgrade core'),(2982,'upgrade_warning_text'),(4722,'ups.CODStatusOptionComment'),(3773,'usps.CODStatusOptionComment'),(1689,'verified version'),(2357,'view list'),(4502,'votes'),(3925,'warning: parcel is overweight'),(4616,'webmasterMode.Disabled'),(4615,'webmasterMode.Enabled'),(2098,'weekly'),(1668,'weight'),(2500,'whether the coupon may be used by everyone or only by users with specific memberships.'),(4671,'xlite-translation-popover.help'),(3058,'xml_support.error_message_1'),(3059,'xml_support.label_message'),(2100,'yearly'),(1468,'you save'),(1738,'your web site may crash'),(4459,'{{count}} Tag duplicates ignored'),(1971,'{{count}} created'),(3255,'{{count}} day'),(3256,'{{count}} days'),(1972,'{{count}} updated'),(2817,'{{field}} length must be less then {{length}}'),(2744,'{{file}} does not exist on the filesystem'),(2741,'{{file}} file could not be copied to a new location {{newPath}}'),(1900,'{{module}} license agreement'),(1986,'{{name}} attributes'),(1859,'{{paymentMethod}} settings'),(3776,'{{value}} is an invalid container type for a REGULAR package. Valid Container is: VARIABLE');
CREATE TABLE `xlite_address_field` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `serviceName` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `viewGetterName` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `schemaClass` varchar(256) COLLATE utf8_unicode_ci NOT NULL,
  `additional` tinyint(1) NOT NULL,
  `required` tinyint(1) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `position` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_2A531832912ABBB5` (`serviceName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_address_field` VALUES (1,'title','','\\XLite\\View\\FormField\\Select\\Title',0,0,0,0),(2,'firstname','','\\XLite\\View\\FormField\\Input\\Text',0,1,1,0),(3,'lastname','','\\XLite\\View\\FormField\\Input\\Text',0,1,1,0),(4,'street','','\\XLite\\View\\FormField\\Input\\Text',0,1,1,0),(5,'city','','\\XLite\\View\\FormField\\Input\\Text',0,1,1,0),(6,'country_code','country_name','\\XLite\\View\\FormField\\Select\\Country',0,1,1,0),(7,'state_id','state_name','\\XLite\\View\\FormField\\Select\\State',0,1,1,0),(8,'custom_state','state_name','\\XLite\\View\\FormField\\Input\\Text',0,0,1,0),(9,'zipcode','','\\XLite\\View\\FormField\\Input\\Text',0,1,1,0),(10,'phone','','\\XLite\\View\\FormField\\Input\\Text',0,0,1,0),(11,'type','type_name','\\XLite\\View\\FormField\\Select\\AddressType',0,0,0,0);
CREATE TABLE `xlite_capost_return_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `amount` int(10) unsigned NOT NULL,
  `returnId` int(10) unsigned DEFAULT NULL,
  `orderItemId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_32022371B43D59E` (`returnId`),
  KEY `IDX_3202237BBF22A26` (`orderItemId`),
  CONSTRAINT `FK_32022371B43D59E` FOREIGN KEY (`returnId`) REFERENCES `xlite_capost_returns` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_3202237BBF22A26` FOREIGN KEY (`orderItemId`) REFERENCES `xlite_order_items` (`item_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_order_modifiers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `class` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `weight` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_order_modifiers` VALUES (1,'XLite\\Logic\\Order\\Modifier\\Shipping',100),(2,'XLite\\Module\\CDev\\Coupons\\Logic\\Order\\Modifier\\Discount',50),(3,'XLite\\Module\\CDev\\SalesTax\\Logic\\Order\\Modifier\\Tax',1100),(4,'XLite\\Module\\CDev\\VolumeDiscounts\\Logic\\Order\\Modifier\\Discount',50);
CREATE TABLE `xlite_order_capost_parcel_shipment_link_storage` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(512) COLLATE utf8_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  `linkId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_82EA5F8AAEC98E42` (`linkId`),
  CONSTRAINT `FK_82EA5F8AAEC98E42` FOREIGN KEY (`linkId`) REFERENCES `xlite_order_capost_parcel_shipment_links` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_job_states` (
  `id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `progress` int(11) NOT NULL,
  `startedAt` decimal(10,0) NOT NULL,
  `cancelled` tinyint(1) NOT NULL,
  `finished` tinyint(1) NOT NULL,
  `data` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_product_images` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned DEFAULT NULL,
  `orderby` int(11) NOT NULL,
  `alt` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `width` int(11) NOT NULL,
  `height` int(11) NOT NULL,
  `hash` char(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `needProcess` tinyint(1) NOT NULL,
  `path` varchar(512) COLLATE utf8_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_142C546A4584665A` (`product_id`),
  CONSTRAINT `FK_142C546A4584665A` FOREIGN KEY (`product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_product_images` VALUES (1,1,10,'',366,440,'4d895c21093a256f83ba47d639f0a5a2',1,'shoes_2.jpg','shoes_2.jpg','image/jpeg','r',57153,1576568857),(2,1,11,'',366,440,'326589e7ccf2d6bd5e171b4519a70a0f',1,'shoes_3.jpg','shoes_3.jpg','image/jpeg','r',49327,1576568857),(3,2,10,'',732,880,'72bedcc06b23823acb74845d09cfa054',1,'shoes_6_2.jpg','shoes_6_2.jpg','image/jpeg','r',80257,1576568857),(4,3,10,'',732,880,'d3c0481c7cc90a31f25b0bc1e37c902c',1,'shoes_7.jpg','shoes_7.jpg','image/jpeg','r',94954,1576568857),(5,4,10,'',732,880,'ca24ff395d951c053a817d479ed6db19',1,'shoes_8.jpg','shoes_8.jpg','image/jpeg','r',133449,1576568857),(6,5,10,'',732,880,'b156f93a5c923dc2e6bfda4306ee3782',1,'shoes_12.jpg','shoes_12.jpg','image/jpeg','r',106340,1576568857),(7,6,10,'',732,880,'59a81275c25138dc8f99afb30b5267e6',1,'shoes_1_1.jpg','shoes_1_1.jpg','image/jpeg','r',143611,1576568857),(8,6,11,'',366,440,'4d895c21093a256f83ba47d639f0a5a2',1,'shoes_2.jpg','shoes_2.jpg','image/jpeg','r',57153,1576568857),(9,6,12,'',366,440,'326589e7ccf2d6bd5e171b4519a70a0f',1,'shoes_3.jpg','shoes_3.jpg','image/jpeg','r',49327,1576568857),(10,7,10,'',732,880,'38da3aca8e486b7b1c35e91c733f8769',1,'clo_1.jpg','clo_1.jpg','image/jpeg','r',186966,1576568857),(11,8,10,'',732,880,'0277483e750a1c9afee7623ee3a92048',1,'shoes_16.jpg','shoes_16.jpg','image/jpeg','r',120497,1576568857),(12,9,10,'',732,880,'20264ed03a148092c598631ccbf5f36b',1,'shoes_17.jpg','shoes_17.jpg','image/jpeg','r',38909,1576568857),(13,10,10,'',732,880,'e36e1056b21d7c2057955dced353fdab',1,'shoes_10.jpg','shoes_10.jpg','image/jpeg','r',107727,1576568857),(14,11,10,'',732,880,'f6fe575d12d0702df99847a0c543323e',1,'shoes_18.jpg','shoes_18.jpg','image/jpeg','r',43838,1576568857),(15,12,10,'',732,880,'e781eaa9cb63cd714d1b11a7c6f21dd1',1,'clo_3.jpg','clo_3.jpg','image/jpeg','r',152629,1576568857),(16,13,10,'',732,880,'8af87c8410d6e9230d4df827c1a94361',1,'clo_4.jpg','clo_4.jpg','image/jpeg','r',190460,1576568857),(17,14,10,'',732,880,'56758e6725d61df67360ea76c79353e7',1,'clo_5.jpg','clo_5.jpg','image/jpeg','r',199790,1576568857),(18,15,10,'',732,880,'6e877e727bfa8406d825067c1ba1d8b4',1,'clo_6.jpg','clo_6.jpg','image/jpeg','r',155982,1576568857),(19,16,10,'',732,880,'0914437938e71b4d51e361a96d0a1d9f',1,'clo_7_1.jpg','clo_7_1.jpg','image/jpeg','r',111237,1576568857),(20,17,10,'',732,880,'4f463863a815b0afe56a06e22b112350',1,'clo_9.jpg','clo_9.jpg','image/jpeg','r',99905,1576568857),(21,17,11,'',732,880,'4ca25adb0ee0186f670d3bf2c9d6356d',1,'clo_10.jpg','clo_10.jpg','image/jpeg','r',76717,1576568857),(22,18,10,'',732,880,'8c7f212feb7187705f405034a3181f68',1,'clo_12.jpg','clo_12.jpg','image/jpeg','r',195566,1576568857),(23,19,10,'',732,880,'f5e52b087200218a567351585759fa9b',1,'clo_13.jpg','clo_13.jpg','image/jpeg','r',89063,1576568857),(24,20,10,'',732,880,'c96c1e673b54122d8502bf1e26216cf2',1,'clo_14.jpg','clo_14.jpg','image/jpeg','r',159307,1576568857),(25,21,10,'',732,880,'3dd31e4e2a731d50bace9356b552f456',1,'bag_1.jpg','bag_1.jpg','image/jpeg','r',154680,1576568857),(26,22,10,'',732,880,'e66ac046657b4e79839254bcc5abbcde',1,'bag_2.jpg','bag_2.jpg','image/jpeg','r',83551,1576568857),(27,23,10,'',732,880,'61a67ab6c7917d24bafd3a73429e34ee',1,'bag_3.jpg','bag_3.jpg','image/jpeg','r',51531,1576568857),(28,24,10,'',732,880,'8b9e13f61b5e97631c1466cddadbebad',1,'bag_4.jpg','bag_4.jpg','image/jpeg','r',72468,1576568857),(29,25,10,'',732,880,'d3c7fe9a8bf498a2600021755e97d44a',1,'bag_5.jpg','bag_5.jpg','image/jpeg','r',75707,1576568857),(30,26,10,'',732,880,'6d9a5450e06a8bc447b8e9589344e792',1,'bag_6.jpg','bag_6.jpg','image/jpeg','r',89008,1576568857),(31,27,10,'',732,880,'1c2a542342240c15ae76a8038f768800',1,'elec_1.jpg','elec_1.jpg','image/jpeg','r',71237,1576568857),(32,28,10,'',732,880,'627da7514ffc664b11b5a4db98125a32',1,'elec_2.jpg','elec_2.jpg','image/jpeg','r',132698,1576568857),(33,29,10,'',732,880,'d6e5e893843013fd41c45a251508c854',1,'elec_4.jpg','elec_4.jpg','image/jpeg','r',125842,1576568857),(34,30,10,'',732,880,'73bac33aaec377dea6b017731c89eb3a',1,'elec_5.jpg','elec_5.jpg','image/jpeg','r',51859,1576568857),(35,31,10,'',732,880,'ded7443afb41dfb3202adc60df70a27c',1,'elec_6.jpg','elec_6.jpg','image/jpeg','r',50433,1576568857),(36,31,11,'',732,880,'6dd2314204135954d106838005c1acfc',1,'elec_8.jpg','elec_8.jpg','image/jpeg','r',111724,1576568857),(37,31,12,'',732,880,'9a917d178eb36bab0383b32645dc1a93',1,'elec_7.jpg','elec_7.jpg','image/jpeg','r',123416,1576568857),(38,31,13,'',732,880,'b23620947e364f001cc7bdf107b85b70',1,'elec_9.jpg','elec_9.jpg','image/jpeg','r',97905,1576568857),(39,32,10,'',732,880,'183494a6df7857e32cdfa138802333dc',1,'elec_10.jpg','elec_10.jpg','image/jpeg','r',55079,1576568857),(40,33,10,'',732,880,'1b422844889512483104ced4a4f0feac',1,'elec_12.jpg','elec_12.jpg','image/jpeg','r',105637,1576568857),(41,34,10,'',732,880,'becdbe97f13c89a6ea3e56adfe9f76f2',1,'elec_13.jpg','elec_13.jpg','image/jpeg','r',37404,1576568857),(42,35,10,'',732,880,'9c616e7c60724a9baab787633994fdcf',1,'elec_14.jpg','elec_14.jpg','image/jpeg','r',16200,1576568857),(43,36,10,'',732,880,'d4dbdee04da48c75c6e49baf76c195b5',1,'beauty_1.jpg','beauty_1.jpg','image/jpeg','r',46495,1576568857),(44,37,10,'',732,880,'fdc89da643f75c705a7221bd7ccf7e6a',1,'beauty_2.jpg','beauty_2.jpg','image/jpeg','r',102218,1576568857),(45,38,10,'',732,880,'9f948e63cba77a773abda02604bf12fc',1,'beauty_3.jpg','beauty_3.jpg','image/jpeg','r',74344,1576568857),(46,39,10,'',732,880,'157c4dc34f176835a72dd7ce2dfdb4c3',1,'beauty_4.jpg','beauty_4.jpg','image/jpeg','r',88194,1576568857),(47,40,10,'',732,880,'6fa1870d58aedfb8872a227d2beb3938',1,'beauty_5.jpg','beauty_5.jpg','image/jpeg','r',50207,1576568857),(48,40,11,'',732,880,'dec5086f7dbabcca3fe8dad7f40716fe',1,'beauty_6.jpg','beauty_6.jpg','image/jpeg','r',137610,1576568857),(49,41,10,'',732,880,'a950f0aee59a617bacad71d97bce43ab',1,'beauty_7.jpg','beauty_7.jpg','image/jpeg','r',94563,1576568857),(50,42,10,'',732,880,'50cb16268b9f45112b94fa701baf7aa6',1,'food_1.jpg','food_1.jpg','image/jpeg','r',167086,1576568857),(51,42,11,'',732,880,'fe3140eb8c5a5ac165ef812f7d775129',1,'food_2.jpg','food_2.jpg','image/jpeg','r',97721,1576568857),(52,43,10,'',732,880,'cfb4d7e98c6aeaff1f69ad3b586818e9',1,'food_15.jpg','food_15.jpg','image/jpeg','r',214478,1576568857),(53,43,11,'',732,880,'02889061c0e860a824b49772dd8327d2',1,'food_3.jpg','food_3.jpg','image/jpeg','r',112526,1576568857),(54,43,12,'',732,880,'f5624e665e8880236a3a5dc1c1c47610',1,'food_4.jpg','food_4.jpg','image/jpeg','r',135694,1576568857),(55,44,10,'',732,880,'8e4a6f3a8911853df2b32713feecb3a2',1,'food_9.jpg','food_9.jpg','image/jpeg','r',190550,1576568857),(56,44,11,'',732,880,'1435ac61b22520636cdb6fdb57a86f2a',1,'food_10_2.jpg','food_10_2.jpg','image/jpeg','r',60111,1576568857),(57,45,10,'',732,880,'bb58add0a6b52cf55ec1783057c8d67f',1,'food_11.jpg','food_11.jpg','image/jpeg','r',84336,1576568857),(58,45,11,'',732,880,'7419ee1425b0bf9ec37a83a394e81303',1,'food_12.jpg','food_12.jpg','image/jpeg','r',115617,1576568857),(59,45,12,'',732,880,'fe5990dc0bc71d58463a47604652944e',1,'food_13.jpg','food_13.jpg','image/jpeg','r',108802,1576568857),(60,46,10,'',732,880,'7a1cab839e0c15f55e7f3a5c0efdfa07',1,'food_14.jpg','food_14.jpg','image/jpeg','r',68878,1576568857),(61,47,10,'',732,880,'ac00bb8c6862b364f5a335e2c5e507ba',1,'food_16.jpg','food_16.jpg','image/jpeg','r',75917,1576568857),(62,47,11,'',732,880,'183de1c5cb688c5da87d72254168b83e',1,'food_19.jpg','food_19.jpg','image/jpeg','r',130386,1576568857),(63,47,12,'',732,880,'484b22d3bd13dbaada735179f3a8377c',1,'food_18.jpg','food_18.jpg','image/jpeg','r',132056,1576568857),(64,47,13,'',732,880,'f19e410ce8777f26da2eac0fa11d8566',1,'food_17.jpg','food_17.jpg','image/jpeg','r',123735,1576568857),(65,48,10,'',732,880,'2ba16018666cbf828a1e01f5cd99271d',1,'food_21.jpg','food_21.jpg','image/jpeg','r',96778,1576568857),(66,48,11,'',732,880,'176afdc335b384f452bddab05a557c2a',1,'food_20.jpg','food_20.jpg','image/jpeg','r',118898,1576568857),(67,49,10,'',732,880,'2e7fa17bbe4583c202bec4fc27f98679',1,'food_22.jpg','food_22.jpg','image/jpeg','r',157267,1576568857),(68,50,10,'',732,880,'f63830487ca574357705e2430a915793',1,'food_24.jpg','food_24.jpg','image/jpeg','r',114214,1576568857),(69,50,11,'',732,880,'a7216535c69bcbb7e74c4db86c1d1cc7',1,'food_23.jpg','food_23.jpg','image/jpeg','r',123810,1576568857),(70,50,12,'',732,880,'7c91b0e5665402bcb013e86b0d83e3bd',1,'food_25.jpg','food_25.jpg','image/jpeg','r',84710,1576568857);
CREATE TABLE `xlite_sales_taxes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `enabled` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_profile_roles` (
  `role_id` int(10) unsigned NOT NULL,
  `profile_id` int(11) NOT NULL,
  PRIMARY KEY (`role_id`,`profile_id`),
  KEY `IDX_7E99B5FD60322AC` (`role_id`),
  KEY `IDX_7E99B5FCCFA12B8` (`profile_id`),
  CONSTRAINT `FK_7E99B5FCCFA12B8` FOREIGN KEY (`profile_id`) REFERENCES `xlite_profiles` (`profile_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_7E99B5FD60322AC` FOREIGN KEY (`role_id`) REFERENCES `xlite_roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_order_shipping_status_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `customerName` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_53DEE45BBF396750` FOREIGN KEY (`id`) REFERENCES `xlite_order_shipping_statuses` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_order_shipping_status_translations` VALUES (1,1,'New','New','en'),(2,2,'Processing','Processing','en'),(3,3,'Shipped','Shipped','en'),(4,4,'Delivered','Delivered','en'),(5,5,'Will Not Deliver','Will Not Deliver','en'),(6,6,'Returned','Returned','en'),(7,7,'Waiting for approve','Waiting for approve','en'),(8,8,'New/Backorder','New','en'),(9,9,'Not Finished','Not finished','en'),(10,9,'Не завершен','Не завершен','ru');
CREATE TABLE `xlite_category_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `ogMeta` longtext COLLATE utf8_unicode_ci,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8_unicode_ci NOT NULL,
  `metaTags` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `metaDesc` longtext COLLATE utf8_unicode_ci NOT NULL,
  `metaTitle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_9ED79EA5BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_categories` (`category_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_category_translations` VALUES (1,1,'','Catalog','<h1>Welcome to X-Cart Demo Store!</h1><p>It illustrates operation and features of X-Cart - all-in-one eCommerce solution for swift and easy launch of a professional online store. Orders placed here cannot be fulfilled as all the sample products listed in this store are for demonstration and testing purposes only.</p>','','','','en'),(2,2,'','Fashion','','','','','en'),(3,3,'','Clothing','','','','','en'),(4,4,'','Shoes','','','','','en'),(5,5,'','Accessories','','','','','en'),(6,6,'','Beauty & Health','','','','','en'),(7,7,'','Cosmetics','','','','','en'),(8,8,'','Healthy Food & Snacks','','','','','en'),(9,9,'','Electronics','','','','','en'),(10,10,'','Smart watches','','','','','en'),(11,11,'','Mobile phones','','','','','en'),(12,12,'','Other','','','','','en');
CREATE TABLE `xlite_order_tracking_number` (
  `tracking_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  `value` longtext COLLATE utf8_unicode_ci NOT NULL,
  `creationDate` int(11) NOT NULL,
  PRIMARY KEY (`tracking_id`),
  KEY `IDX_77A238F48D9F6D38` (`order_id`),
  CONSTRAINT `FK_77A238F48D9F6D38` FOREIGN KEY (`order_id`) REFERENCES `xlite_orders` (`order_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `position` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_zone_elements` (
  `element_id` int(11) NOT NULL AUTO_INCREMENT,
  `zone_id` int(11) DEFAULT NULL,
  `element_value` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `element_type` char(1) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`element_id`),
  KEY `IDX_2AF5A18A9F2C3FAB` (`zone_id`),
  KEY `type_value` (`element_type`,`element_value`),
  KEY `id_type` (`zone_id`,`element_type`),
  CONSTRAINT `FK_2AF5A18A9F2C3FAB` FOREIGN KEY (`zone_id`) REFERENCES `xlite_zones` (`zone_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_zone_elements` VALUES (1,2,'US','C'),(2,2,'VI','C'),(3,2,'UM','C'),(4,3,'US','C'),(5,3,'VI','C'),(6,3,'UM','C'),(7,3,'CA','C'),(8,3,'US_NY','S'),(9,3,'US_ME','S'),(10,3,'US_VT','S'),(11,3,'US_NH','S'),(12,3,'US_MI','S'),(13,3,'US_MN','S'),(14,3,'US_WI','S'),(15,4,'AT','C'),(16,4,'BE','C'),(17,4,'BG','C'),(18,4,'HR','C'),(19,4,'CY','C'),(20,4,'CZ','C'),(21,4,'DK','C'),(22,4,'EE','C'),(23,4,'FL','C'),(24,4,'FR','C'),(25,4,'DE','C'),(26,4,'GR','C'),(27,4,'HU','C'),(28,4,'IE','C'),(29,4,'IT','C'),(30,4,'LV','C'),(31,4,'LT','C'),(32,4,'LU','C'),(33,4,'MT','C'),(34,4,'NL','C'),(35,4,'PL','C'),(36,4,'PT','C'),(37,4,'RO','C'),(38,4,'SK','C'),(39,4,'SI','C'),(40,4,'ES','C'),(41,4,'SE','C'),(42,4,'GB','C');
CREATE TABLE `xlite_category_membership_links` (
  `category_id` int(10) unsigned NOT NULL,
  `membership_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`category_id`,`membership_id`),
  KEY `IDX_A0AA75DD12469DE2` (`category_id`),
  KEY `IDX_A0AA75DD1FB354CD` (`membership_id`),
  CONSTRAINT `FK_A0AA75DD12469DE2` FOREIGN KEY (`category_id`) REFERENCES `xlite_categories` (`category_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_A0AA75DD1FB354CD` FOREIGN KEY (`membership_id`) REFERENCES `xlite_memberships` (`membership_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_order_capost_parcel_manifest_links` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rel` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `href` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `idx` int(11) DEFAULT NULL,
  `mediaType` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `manifestId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_7FE471EA99AD4367` (`manifestId`),
  CONSTRAINT `FK_7FE471EA99AD4367` FOREIGN KEY (`manifestId`) REFERENCES `xlite_order_capost_parcel_manifests` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_order_backorder_competitors` (
  `id` int(11) NOT NULL,
  `competitor_id` int(11) NOT NULL,
  PRIMARY KEY (`id`,`competitor_id`),
  KEY `IDX_C73B739BBF396750` (`id`),
  KEY `IDX_C73B739B78A5D405` (`competitor_id`),
  CONSTRAINT `FK_C73B739B78A5D405` FOREIGN KEY (`competitor_id`) REFERENCES `xlite_orders` (`order_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_C73B739BBF396750` FOREIGN KEY (`id`) REFERENCES `xlite_orders` (`order_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_attribute_values_checkbox` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned DEFAULT NULL,
  `attribute_id` int(10) unsigned DEFAULT NULL,
  `value` tinyint(1) NOT NULL,
  `priceModifier` decimal(14,4) NOT NULL,
  `priceModifierType` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `weightModifier` decimal(14,4) NOT NULL,
  `weightModifierType` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `defaultValue` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`),
  KEY `attribute_id` (`attribute_id`),
  KEY `value` (`value`),
  CONSTRAINT `FK_3CA3503B4584665A` FOREIGN KEY (`product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_3CA3503BB6E62EFA` FOREIGN KEY (`attribute_id`) REFERENCES `xlite_attributes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_attribute_values_checkbox` VALUES (21,29,86,1,0.0000,'p',0.0000,'p',0),(22,28,86,1,0.0000,'p',0.0000,'p',0);
CREATE TABLE `xlite_product_classes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `position` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_product_classes` VALUES (1,0),(2,0),(3,0);
CREATE TABLE `xlite_xpayments_fraud_check_data` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(11) DEFAULT NULL,
  `code` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `service` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `module` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `result` int(11) NOT NULL,
  `status` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `score` int(11) NOT NULL,
  `message` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `serviceTransactionId` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `url` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `errors` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `warnings` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `rules` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `data` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_BC7EC2A42FC0CB0F` (`transaction_id`),
  CONSTRAINT `FK_BC7EC2A42FC0CB0F` FOREIGN KEY (`transaction_id`) REFERENCES `xlite_payment_transactions` (`transaction_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_categories` (
  `category_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned DEFAULT NULL,
  `ogMeta` longtext COLLATE utf8_unicode_ci,
  `useCustomOG` tinyint(1) NOT NULL,
  `csLastUpdate` int(11) NOT NULL,
  `demo` tinyint(1) NOT NULL,
  `useClasses` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `lpos` int(11) NOT NULL,
  `rpos` int(11) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `show_title` tinyint(1) NOT NULL,
  `depth` int(11) NOT NULL,
  `pos` int(11) NOT NULL,
  `root_category_look` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `metaDescType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `xcPendingExport` tinyint(1) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `IDX_9D0DF19B727ACA70` (`parent_id`),
  KEY `lpos` (`lpos`),
  KEY `rpos` (`rpos`),
  KEY `enabled` (`enabled`),
  KEY `csLastUpdate` (`csLastUpdate`),
  CONSTRAINT `FK_9D0DF19B727ACA70` FOREIGN KEY (`parent_id`) REFERENCES `xlite_categories` (`category_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_categories` VALUES (1,NULL,'',0,0,0,'A',1,24,1,0,-1,0,'icons','A',0),(2,1,'',0,0,1,'A',2,9,1,1,0,10,NULL,'A',0),(3,2,'',0,0,1,'A',3,4,1,1,1,10,NULL,'A',0),(4,2,'',0,0,1,'A',5,6,1,1,1,20,NULL,'A',0),(5,2,'',0,0,1,'A',7,8,1,1,1,30,NULL,'A',0),(6,1,'',0,0,1,'A',10,15,1,1,0,20,NULL,'A',0),(7,6,'',0,0,1,'A',11,12,1,1,1,10,NULL,'A',0),(8,6,'',0,0,1,'A',13,14,1,1,1,10,NULL,'A',0),(9,1,'',0,0,1,'A',16,23,1,1,0,30,NULL,'A',0),(10,9,'',0,0,1,'A',17,18,1,1,1,10,NULL,'A',0),(11,9,'',0,0,1,'A',19,20,1,1,1,20,NULL,'A',0),(12,9,'',0,0,1,'A',21,22,1,1,1,30,NULL,'A',0);
CREATE TABLE `xlite_mailchimp_store` (
  `id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `list_id` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `main` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_95CF70793DAE168B` (`list_id`),
  CONSTRAINT `FK_95CF70793DAE168B` FOREIGN KEY (`list_id`) REFERENCES `xlite_mailchimp_lists` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_attribute_properties` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned DEFAULT NULL,
  `attribute_id` int(10) unsigned DEFAULT NULL,
  `position` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_3C3647F44584665A` (`product_id`),
  KEY `IDX_3C3647F4B6E62EFA` (`attribute_id`),
  CONSTRAINT `FK_3C3647F44584665A` FOREIGN KEY (`product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_3C3647F4B6E62EFA` FOREIGN KEY (`attribute_id`) REFERENCES `xlite_attributes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_menu_quick_flags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_id` int(10) unsigned DEFAULT NULL,
  `submenus_count_all` int(11) NOT NULL,
  `submenus_count_enabled` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_B0327DB0CCD7E912` (`menu_id`),
  CONSTRAINT `FK_B0327DB0CCD7E912` FOREIGN KEY (`menu_id`) REFERENCES `xlite_menus` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_menu_quick_flags` VALUES (1,3,2,2),(3,1,0,0),(4,2,11,11),(5,4,0,0),(6,5,0,0),(8,6,0,0),(9,7,0,0),(10,8,0,0),(11,9,3,2),(12,10,0,0),(13,11,0,0),(14,12,0,0),(15,14,3,3),(16,13,0,0),(17,15,0,0),(18,16,0,0),(19,17,0,0),(20,18,3,3),(21,19,0,0),(22,20,0,0),(23,21,0,0),(24,22,2,2),(25,23,0,0),(26,24,0,0),(27,25,3,3),(28,26,0,0),(29,27,0,0),(30,28,0,0);
CREATE TABLE `xlite_config` (
  `config_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `category` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `orderby` int(11) NOT NULL,
  `value` longtext COLLATE utf8_unicode_ci NOT NULL,
  `widgetParameters` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:array)',
  PRIMARY KEY (`config_id`),
  UNIQUE KEY `nc` (`name`,`category`),
  KEY `orderby` (`orderby`),
  KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_config` VALUES (1,'admin_security','Security','checkbox',1000,'N','N;'),(2,'anonymous','Shipping','separator',3000,'','N;'),(3,'anonymous_address','Shipping','text',4000,'','N;'),(4,'anonymous_country','Shipping','country',5000,'US','N;'),(5,'anonymous_state','Shipping','state',6000,'562','a:1:{s:9:\"selectOne\";b:1;}'),(6,'anonymous_custom_state','Shipping','text',7000,'','N;'),(7,'anonymous_city','Shipping','text',8000,'Los Angeles','N;'),(8,'anonymous_zipcode','Shipping','text',9000,'90001','N;'),(9,'anonymous_address_type','Shipping','\\XLite\\View\\FormField\\Select\\AddressType',10000,'R','N;'),(10,'aggregate_css','Performance','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',2000,'Y','N;'),(11,'aggregate_js','Performance','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',3000,'Y','N;'),(12,'use_view_cache','Performance','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',4000,'Y','N;'),(13,'use_dynamic_image_resizing','Performance','hidden',5000,'','N;'),(14,'use_lazy_load','Performance','hidden',5200,'','N;'),(15,'unsharp_mask_filter_on_resize','Performance','hidden',5100,'','N;'),(16,'layout_type','Layout','XLite\\View\\FormField\\Select\\LayoutType',1000,'left','N;'),(17,'layout_type_home','Layout','XLite\\View\\FormField\\Select\\LayoutType',1010,'one','N;'),(18,'cli_key','Security','',11000,'','N;'),(19,'company_address','Company','separator',38500,'','N;'),(20,'company_contacts','Company','separator',45500,'','N;'),(21,'company_fax','Company','XLite\\View\\FormField\\Input\\Text\\Phone',42000,'','N;'),(22,'company_identity','Company','separator',35000,'','N;'),(23,'company_name','Company','text',36000,'*Your company name*','N;'),(24,'company_website','Company','text',37000,'','N;'),(25,'terms_url','General','text',38000,'terms-and-conditions','N;'),(26,'customer_presentation','General','separator',20000,'','N;'),(27,'customer_security','Security','checkbox',100,'N','N;'),(28,'date_format','Units','XLite\\View\\FormField\\Select\\DateFormat',66000,'%b %e, %Y','N;'),(29,'week_start','Units','XLite\\View\\FormField\\Select\\DayOfWeek',67000,'sun','N;'),(30,'csv_delim','Units','XLite\\View\\FormField\\Select\\CSVDelimiter',70000,',','N;'),(31,'export_import_charset','Units','XLite\\View\\FormField\\Select\\IconvCharset',72500,'UTF-8','N;'),(32,'export_product_attrs','Units','XLite\\View\\FormField\\Select\\ExportAttrs',75000,'global','N;'),(33,'default_language','General','',33000,'en','N;'),(34,'default_admin_language','General','',33500,'en','N;'),(35,'default_offline_payment','Payments','text',0,'','N;'),(36,'default_purchase_limit','General','XLite\\View\\FormField\\Input\\Text\\Integer',29300,'9999','a:1:{s:3:\"min\";i:1;}'),(37,'default_select_payment','Payments','text',0,'','N;'),(38,'display_check_number','General','checkbox',21500,'Y','N;'),(39,'show_out_of_stock_products','General','XLite\\View\\FormField\\Select\\ShowOutOfStockProducts',20000,'directLink','N;'),(40,'default_prod_display_mode','General','XLite\\View\\FormField\\Select\\DefaultDisplayModeForProductsList',25000,'grid','N;'),(41,'license','License','text',0,'','N;'),(42,'location_address','Company','text',39000,'*Your company address*','N;'),(43,'location_country','Company','country',40000,'US','a:2:{s:9:\"selectOne\";b:0;s:3:\"all\";b:1;}'),(44,'location_state','Company','state',41000,'591','N;'),(45,'location_custom_state','Company','text',41500,'','N;'),(46,'location_city','Company','text',42000,'New York','N;'),(47,'location_zipcode','Company','text',43000,'10001','N;'),(48,'origin_use_company','Company','checkbox',38000,'1','N;'),(49,'origin_address','Company','text',39000,'','N;'),(50,'origin_country','Company','country',40000,'US','a:2:{s:9:\"selectOne\";b:0;s:3:\"all\";b:1;}'),(51,'origin_state','Company','state',41000,'','N;'),(52,'origin_custom_state','Company','text',41500,'','N;'),(53,'origin_city','Company','text',42000,'','N;'),(54,'origin_zipcode','Company','text',43000,'','N;'),(55,'company_phone','Company','text',44000,'(555) 555-5555','N;'),(56,'login_lifetime','General','XLite\\View\\FormField\\Input\\Text\\Integer',45000,'3','a:1:{s:3:\"min\";i:1;}'),(57,'maximal_order_amount','General','XLite\\View\\FormField\\Input\\Text\\FloatInput',29000,'99999','a:1:{s:3:\"min\";i:1;}'),(58,'minimal_order_amount','General','XLite\\View\\FormField\\Input\\Text\\FloatInput',28000,'0','a:1:{s:3:\"min\";i:0;}'),(59,'order_number_counter','General','XLite\\View\\FormField\\Input\\Text\\Integer',39000,'6','N;'),(60,'cart_ttl','General','XLite\\View\\FormField\\Input\\Text\\Integer',39500,'7','N;'),(61,'internal_cron_enabled','General','checkbox',39800,'Y','N;'),(62,'orders_department','Company','XLite\\View\\FormField\\Select\\MultipleEmails',48000,'a:1:{i:0;s:17:\"admin@example.com\";}','N;'),(63,'products_per_page','General','XLite\\View\\FormField\\Input\\Text\\Integer',25000,'12','a:1:{s:3:\"min\";i:1;}'),(64,'products_per_page_max','General','XLite\\View\\FormField\\Input\\Text\\Integer',25000,'100','a:1:{s:3:\"min\";i:1;}'),(65,'force_choose_product_options','General','XLite\\View\\FormField\\Select\\ForceProductOptions',29900,'','N;'),(66,'redirect_to_cart','General','checkbox',30000,'N','N;'),(67,'shop_closed','Internal','checkbox',11000,'N','N;'),(68,'shop_currency','General','',60500,'840','N;'),(69,'trailing_zeroes','General','',60500,'0','N;'),(70,'site_administrator','Company','XLite\\View\\FormField\\Select\\MultipleEmails',46000,'a:1:{i:0;s:17:\"admin@example.com\";}','N;'),(71,'smtp_password','Email','XLite\\View\\FormField\\Input\\PasswordWithValue',16000,'','N;'),(72,'smtp_security','Email','XLite\\View\\FormField\\Select\\SMTPSecurity',17000,'no','N;'),(73,'smtp_server_port','Email','XLite\\View\\FormField\\Input\\Text\\Integer',13000,'25','a:2:{s:3:\"min\";i:0;s:3:\"max\";i:65535;}'),(74,'smtp_server_url','Email','text',12000,'','N;'),(75,'smtp_username','Email','text',15000,'','N;'),(76,'start_year','Company','XLite\\View\\FormField\\Input\\Text\\PastYear',38000,'2016','N;'),(77,'subcategories_look','General','XLite\\View\\FormField\\Select\\SubcategoriesLook',22000,'icons','N;'),(78,'default_products_sort_order','General','XLite\\View\\FormField\\Select\\DefaultProductSortOrder',22500,'default','N;'),(79,'default_search_sort_order','General','XLite\\View\\FormField\\Select\\DefaultProductSortOrder',22501,'default','N;'),(80,'support_department','Company','XLite\\View\\FormField\\Select\\MultipleEmails',49000,'a:1:{i:0;s:17:\"admin@example.com\";}','N;'),(81,'time_format','Units','XLite\\View\\FormField\\Select\\TimeFormat',67000,'%H:%M','N;'),(82,'time_zone','Units','XLite\\View\\FormField\\Select\\TimeZone',68000,'','N;'),(83,'users_department','Company','XLite\\View\\FormField\\Select\\MultipleEmails',47000,'a:1:{i:0;s:17:\"admin@example.com\";}','N;'),(84,'users_per_page','General','XLite\\View\\FormField\\Input\\Text\\Integer',42000,'30','a:1:{s:3:\"min\";i:1;}'),(85,'mail_from_type','Email','XLite\\View\\FormField\\Select\\EmailFrom',10500,'contact','N;'),(86,'mail_from_manual','Email','\\XLite\\View\\FormField\\Input\\Text\\EmailFromManual',10600,'','a:1:{s:8:\"required\";b:1;}'),(87,'use_smtp','Email','\\XLite\\View\\FormField\\Input\\Checkbox\\UseSmtp',11000,'','N;'),(88,'use_smtp_auth','Email','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',14000,'','N;'),(89,'version','Version','',0,'5.4.0.8','N;'),(90,'weight_symbol','Units','text',62000,'lbs','N;'),(91,'weight_unit','Units','XLite\\View\\FormField\\Select\\WeightUnit',61000,'lbs','N;'),(92,'weight_trailing_zeroes','Units','checkbox',62100,'Y','N;'),(93,'weight_format','Units','XLite\\View\\FormField\\Select\\FloatFormat',62200,'|.','N;'),(94,'percent_format','Units','XLite\\View\\FormField\\Select\\PercentFormat',62300,'%s%%','N;'),(95,'dim_symbol','Units','text',62500,'in','N;'),(96,'dim_unit','Units','XLite\\View\\FormField\\Select\\DimUnit',62300,'in','N;'),(97,'curl_sep','Environment','separator',10000,'','N;'),(98,'curl_cainfo','Environment','text',11000,'','N;'),(99,'curl_capath','Environment','text',12000,'','N;'),(100,'force_login_before_checkout','General','checkbox',30500,'Y','N;'),(101,'enable_add2cart_button_grid','General','checkbox',30100,'Y','N;'),(102,'requires_shipping_default','General','',0,'1','N;'),(103,'clean_url_flag','CleanURL','XLite\\View\\FormField\\Input\\Checkbox\\CleanUrl',1000,'0','N;'),(104,'general_options','CleanURL','separator',10000,'','N;'),(105,'default_site_title','CleanURL','XLite\\View\\FormField\\Label\\TranslationLabel',11000,'default-site-title','N;'),(106,'default_site_meta_description','CleanURL','XLite\\View\\FormField\\Label\\TranslationLabel',12000,'default-meta-description','N;'),(107,'default_site_meta_keywords','CleanURL','XLite\\View\\FormField\\Label\\TranslationLabel',13000,'default-meta-keywords','N;'),(108,'home_page_title_and_meta','CleanURL','XLite\\View\\FormField\\CleanUrls\\FrontPage',14000,'','N;'),(109,'page_404','CleanURL','XLite\\View\\FormField\\CleanUrls\\Page404',14500,'','N;'),(110,'regular_text_404','CleanURL','XLite\\View\\FormField\\Label\\TranslationLabelWithHtmlCode',14501,'default-404-text','N;'),(111,'show_email_404','CleanURL','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',14502,'1','N;'),(112,'page_title_format','CleanURL','XLite\\View\\FormField\\CleanUrls\\PageTitleFormat',15000,'','N;'),(113,'company_name','CleanURL','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',15100,'1','N;'),(114,'parent_category_path','CleanURL','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',15200,'1','N;'),(115,'object_name','CleanURL','XLite\\View\\FormField\\Input\\Checkbox\\OnOffReadOnly',15300,'1','N;'),(116,'object_name_in_page_title_order','CleanURL','XLite\\View\\FormField\\Input\\Checkbox\\FirstLast',16000,'0','N;'),(117,'clean_urls_about','CleanURL','separator',20000,'','N;'),(118,'about_widget','CleanURL','XLite\\View\\FormField\\CleanUrls\\AboutCleanUrls',21000,'','N;'),(119,'allow_membership_request','General','checkbox',39900,'N','N;'),(120,'upgrade_wave_sep','Environment','separator',20000,'','N;'),(121,'upgrade_wave','Environment','XLite\\View\\FormField\\Select\\UpgradeWave',21000,'','N;'),(122,'fields_settings_section','Email','separator',1000,'','N;'),(123,'reply_to_customer','Email','\\XLite\\View\\FormField\\Label\\ReplyToCustomer',10700,'','N;'),(124,'reply_to_admin','Email','\\XLite\\View\\FormField\\Label\\ReplyToAdmin',10800,'','N;'),(125,'smtp_section','Email','\\XLite\\View\\FormField\\Separator\\Regular',10950,'','N;'),(126,'enabled','BannerRotation','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',10000,'1','N;'),(127,'interval','BannerRotation','XLite\\View\\FormField\\Input\\Text\\FloatInput',30000,'5','N;'),(128,'attach_pdf_invoices','NotificationAttachments','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',10000,'0','N;'),(129,'contact_us_comment','Company','XLite\\View\\FormField\\ContactUsComment',49500,'','N;'),(130,'deliverability_check','Company','XLite\\View\\FormField\\DeliverabilityCheck',49400,'','N;'),(131,'livechat_ad','Company','XLite\\View\\FormField\\LiveChatAd',49300,'','N;'),(132,'test_mode','CDev\\AustraliaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',10,'1','N;'),(133,'api_key','CDev\\AustraliaPost','XLite\\View\\FormField\\Input\\Text',20,'','N;'),(134,'packageSettingsSeparator','CDev\\AustraliaPost','separator',100,'','N;'),(135,'package_type','CDev\\AustraliaPost','',0,'Parcel','N;'),(136,'package_box_type','CDev\\AustraliaPost','XLite\\Module\\CDev\\AustraliaPost\\View\\FormField\\PackageBoxType',110,'AUS_PARCEL_TYPE_BOXED_OTH','N;'),(137,'dimensions','CDev\\AustraliaPost','serialized',120,'a:3:{i:0;i:10;i:1;i:10;i:2;i:10;}','N;'),(138,'additionalSettingsSeparator','CDev\\AustraliaPost','separator',200,'','N;'),(139,'service_option','CDev\\AustraliaPost','XLite\\Module\\CDev\\AustraliaPost\\View\\FormField\\ServiceOption',210,'AUS_SERVICE_OPTION_STANDARD','N;'),(140,'extra_cover','CDev\\AustraliaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',220,'','N;'),(141,'extra_cover_value','CDev\\AustraliaPost','XLite\\View\\FormField\\Input\\Text\\Price',230,'0','N;'),(142,'currency_rate','CDev\\AustraliaPost','XLite\\View\\FormField\\Input\\Text\\FloatInput',240,'1','N;'),(143,'enable_new_methods','CDev\\AustraliaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',250,'1','N;'),(144,'debug_enabled','CDev\\AustraliaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',260,'1','N;'),(145,'max_weight','CDev\\AustraliaPost','',0,'20','N;'),(146,'number_of_bestsellers','CDev\\Bestsellers','XLite\\View\\FormField\\Input\\Text\\Integer',115,'4','a:1:{s:3:\"min\";i:1;}'),(147,'enable_form','CDev\\ContactUs','XLite\\View\\FormField\\Input\\Checkbox\\YesNo',100,'1','N;'),(148,'email','CDev\\ContactUs','XLite\\View\\FormField\\Input\\Text\\Email',200,'','N;'),(149,'showEmail','CDev\\ContactUs','XLite\\View\\FormField\\Input\\Checkbox\\YesNo',300,'1','N;'),(150,'contact_us_sep_1','CDev\\ContactUs','separator',1000,'','N;'),(151,'recaptcha_version','CDev\\ContactUs','\\XLite\\Module\\CDev\\ContactUs\\View\\FormField\\VersionSwitch',1050,'2','N;'),(152,'recaptcha_public_key','CDev\\ContactUs','text',1100,'','N;'),(153,'recaptcha_private_key','CDev\\ContactUs','text',1200,'','N;'),(154,'ttl','CDev\\Egoods','XLite\\View\\FormField\\Input\\Text\\Integer',100,'3','a:1:{s:3:\"min\";i:0;}'),(155,'attempts_limit','CDev\\Egoods','XLite\\View\\FormField\\Input\\Text\\Integer',200,'3','a:1:{s:3:\"min\";i:0;}'),(156,'enable_history','CDev\\Egoods','XLite\\View\\FormField\\Input\\Checkbox\\YesNo',300,'1','N;'),(157,'esd_fullfilment','CDev\\Egoods','XLite\\View\\FormField\\Input\\Checkbox\\YesNo',400,'','N;'),(158,'approve_before_download','CDev\\Egoods','XLite\\View\\FormField\\Input\\Checkbox\\YesNo',500,'','N;'),(159,'sendfile_info','CDev\\Egoods','XLite\\Module\\CDev\\Egoods\\View\\FormField\\Label\\Sendfile',600,'','N;'),(160,'amazon_separator','CDev\\Egoods','separator',1000,'0','N;'),(161,'enable_signed_urls','CDev\\Egoods','XLite\\View\\FormField\\Input\\Checkbox\\YesNo',1100,'0','N;'),(162,'amazon_access','CDev\\Egoods','XLite\\View\\FormField\\Input\\Text',1200,'','N;'),(163,'amazon_secret','CDev\\Egoods','XLite\\View\\FormField\\Input\\Text',1300,'','N;'),(164,'bucket','CDev\\Egoods','XLite\\View\\FormField\\Input\\Text',1400,'','N;'),(165,'bucket_region','CDev\\Egoods','hidden',1500,'','N;'),(166,'featured_products_look','CDev\\FeaturedProducts','XLite\\Module\\CDev\\FeaturedProducts\\View\\FormField\\FeaturedProductsLook',10,'grid','N;'),(167,'key','CDev\\FedEx','XLite\\View\\FormField\\Input\\Text',10,'','N;'),(168,'password','CDev\\FedEx','XLite\\View\\FormField\\Input\\PasswordWithValue',20,'','N;'),(169,'account_number','CDev\\FedEx','XLite\\View\\FormField\\Input\\Text',30,'','N;'),(170,'meter_number','CDev\\FedEx','XLite\\View\\FormField\\Input\\Text',40,'','N;'),(171,'test_mode','CDev\\FedEx','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',50,'','N;'),(172,'debug_enabled','CDev\\FedEx','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',60,'','N;'),(173,'additionalSettingsSeparator','CDev\\FedEx','separator',100,'','N;'),(174,'carrierTypesSeparator','CDev\\FedEx','separator',200,'','N;'),(175,'fdxe','CDev\\FedEx','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',210,'','N;'),(176,'fdxg','CDev\\FedEx','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',220,'','N;'),(177,'fxsp','CDev\\FedEx','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',230,'','N;'),(178,'fxsp_hub_id','CDev\\FedEx','XLite\\Module\\CDev\\FedEx\\View\\FormField\\Select\\HubId',235,'','N;'),(179,'fxsp_indicia','CDev\\FedEx','XLite\\Module\\CDev\\FedEx\\View\\FormField\\Select\\Indicia',240,'','N;'),(180,'rate_request_type','CDev\\FedEx','XLite\\Module\\CDev\\FedEx\\View\\FormField\\Select\\RateRequestType',300,'NONE','N;'),(181,'packaging','CDev\\FedEx','XLite\\Module\\CDev\\FedEx\\View\\FormField\\Select\\Packaging',310,'','N;'),(182,'dropoff_type','CDev\\FedEx','XLite\\Module\\CDev\\FedEx\\View\\FormField\\Select\\DropOffType',320,'','N;'),(183,'ship_date','CDev\\FedEx','XLite\\Module\\CDev\\FedEx\\View\\FormField\\Select\\ShipDate',330,'0','N;'),(184,'currency_code','CDev\\FedEx','XLite\\Module\\CDev\\FedEx\\View\\FormField\\Select\\CurrencyCode',340,'0','N;'),(185,'currency_rate','CDev\\FedEx','XLite\\View\\FormField\\Input\\Text\\FloatInput',350,'1','N;'),(186,'dimensions','CDev\\FedEx','serialized',360,'a:3:{i:0;i:10;i:1;i:10;i:2;i:10;}','N;'),(187,'max_weight','CDev\\FedEx','XLite\\View\\FormField\\Input\\Text\\FloatInput',370,'70','N;'),(188,'specialServicesSeparator','CDev\\FedEx','separator',400,'','N;'),(189,'dg_accessibility','CDev\\FedEx','XLite\\Module\\CDev\\FedEx\\View\\FormField\\Select\\DangerousGoodsAccessibility',410,'','N;'),(190,'signature','CDev\\FedEx','XLite\\Module\\CDev\\FedEx\\View\\FormField\\Select\\Signature',420,'','N;'),(191,'shippingRefundsSeparator','CDev\\FedEx','separator',450,'','N;'),(192,'lbs71Info','CDev\\FedEx','XLite\\View\\FormField\\Label',460,'As a FedEx user, you are entitled to receive shipping refunds usually left unclaimed with default FedEx service ($2B/year globally)','a:1:{s:9:\"fieldOnly\";b:1;}'),(193,'cacheOnDeliverySeparator','CDev\\FedEx','separator',500,'','N;'),(194,'cod_type','CDev\\FedEx','XLite\\Module\\CDev\\FedEx\\View\\FormField\\Select\\CODType',510,'ANY','N;'),(195,'advancedOptionsSeparator','CDev\\FedEx','separator',600,'','N;'),(196,'opt_saturday_pickup','CDev\\FedEx','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',610,'','N;'),(197,'opt_residential_delivery','CDev\\FedEx','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',620,'','N;'),(198,'send_insured_value','CDev\\FedEx','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',630,'1','N;'),(199,'gosocial_sep_1','CDev\\GoSocial','separator',5000,'','N;'),(200,'fb_app_id','CDev\\GoSocial','text',5100,'','N;'),(201,'fb_app_namespace','CDev\\GoSocial','text',5200,'','N;'),(202,'fb_admins','CDev\\GoSocial','text',5300,'','N;'),(203,'gosocial_sep_6','CDev\\GoSocial','separator',1000,'','N;'),(204,'fb_share_use','CDev\\GoSocial','checkbox',1050,'1','N;'),(205,'gosocial_sep_2','CDev\\GoSocial','separator',1300,'','N;'),(206,'like_settings_warning','CDev\\GoSocial','XLite\\Module\\CDev\\GoSocial\\View\\FormField\\Label\\LikeSettingsWarning',1325,'1','N;'),(207,'fb_like_use','CDev\\GoSocial','checkbox',1350,'','N;'),(208,'fb_like_layout','CDev\\GoSocial','XLite\\Module\\CDev\\GoSocial\\View\\FormField\\Select\\FBLayoutStyle',1400,'button_count','N;'),(209,'fb_like_show_faces','CDev\\GoSocial','checkbox',1420,'1','N;'),(210,'fb_like_verb','CDev\\GoSocial','XLite\\Module\\CDev\\GoSocial\\View\\FormField\\Select\\FBVerbDisplay',1440,'like','N;'),(211,'fb_like_colorscheme','CDev\\GoSocial','XLite\\Module\\CDev\\GoSocial\\View\\FormField\\Select\\FBLikeColorScheme',1460,'light','N;'),(212,'gosocial_sep_21','CDev\\GoSocial','separator',1500,'','N;'),(213,'fb_comments_use','CDev\\GoSocial','checkbox',1600,'1','N;'),(214,'fb_comments_num_posts','CDev\\GoSocial','XLite\\View\\FormField\\Input\\Text\\Integer',1700,'8','a:1:{s:3:\"min\";i:1;}'),(215,'fb_comments_colorscheme','CDev\\GoSocial','XLite\\Module\\CDev\\GoSocial\\View\\FormField\\Select\\FBCommentsColorScheme',1750,'light','N;'),(216,'gosocial_sep_3','CDev\\GoSocial','separator',2000,'','N;'),(217,'tweet_use','CDev\\GoSocial','checkbox',2050,'1','N;'),(218,'tweet_show_count','CDev\\GoSocial','checkbox',2100,'1','N;'),(219,'tweet_via','CDev\\GoSocial','text',2200,'','N;'),(220,'tweet_recommend','CDev\\GoSocial','text',2300,'','N;'),(221,'tweet_hashtag','CDev\\GoSocial','text',2300,'','N;'),(222,'gosocial_sep_5','CDev\\GoSocial','separator',4000,'','N;'),(223,'pinterest_use','CDev\\GoSocial','checkbox',4050,'1','N;'),(224,'ga_account','CDev\\GoogleAnalytics','text',100,'','N;'),(225,'ga_tracking_type','CDev\\GoogleAnalytics','XLite\\Module\\CDev\\GoogleAnalytics\\View\\FormField\\Select\\TrackingType',200,'1','N;'),(226,'ga_code_version','CDev\\GoogleAnalytics','XLite\\Module\\CDev\\GoogleAnalytics\\View\\FormField\\Select\\CodeVersion',300,'U','N;'),(227,'ecommerce_enabled','CDev\\GoogleAnalytics','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',400,'1','N;'),(228,'purchase_only_on_paid','CDev\\GoogleAnalytics','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',450,'1','N;'),(229,'debug_mode','CDev\\GoogleAnalytics','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',500,'','N;'),(230,'esd_fullfilment','CDev\\PINCodes','XLite\\View\\FormField\\Input\\Checkbox\\YesNo',400,'','N;'),(231,'approve_before_download','CDev\\PINCodes','XLite\\View\\FormField\\Input\\Checkbox\\YesNo',500,'','N;'),(232,'show_admin_welcome','CDev\\Paypal','checkbox',100,'N','N;'),(233,'paypalLoginOptions','CDev\\Paypal','\\XLite\\Module\\CDev\\Paypal\\View\\FormField\\Instructions',200,'','N;'),(234,'loginRedirectURLProtocol','CDev\\Paypal','XLite\\Module\\CDev\\Paypal\\View\\FormField\\Select\\Protocol',300,'http','N;'),(235,'loginClientId','CDev\\Paypal','text',400,'','N;'),(236,'loginClientSecret','CDev\\Paypal','text',500,'','N;'),(237,'loginMode','CDev\\Paypal','XLite\\View\\FormField\\Select\\TestLiveMode',600,'test','N;'),(238,'loginScopes','CDev\\Paypal','XLite\\Module\\CDev\\Paypal\\View\\FormField\\Select\\Scopes',700,'a:6:{i:0;s:6:\"openid\";i:1;s:5:\"email\";i:2;s:7:\"profile\";i:3;s:7:\"address\";i:4;s:5:\"phone\";i:5;s:47:\"https://uri.paypal.com/services/expresscheckout\";}','N;'),(239,'sep_product_advisor_na','CDev\\ProductAdvisor','separator',10,'','N;'),(240,'na_enabled','CDev\\ProductAdvisor','checkbox',20,'Y','N;'),(241,'na_max_days','CDev\\ProductAdvisor','XLite\\View\\FormField\\Input\\Text\\Integer',30,'30','a:1:{s:3:\"min\";i:0;}'),(242,'na_max_count_in_full_list','CDev\\ProductAdvisor','XLite\\View\\FormField\\Input\\Text\\Integer',40,'72','a:1:{s:3:\"min\";i:0;}'),(243,'na_mark_with_label','CDev\\ProductAdvisor','XLite\\Module\\CDev\\ProductAdvisor\\View\\FormField\\Select\\MarkProducts',50,'C','N;'),(244,'na_max_count_in_block','CDev\\ProductAdvisor','XLite\\View\\FormField\\Input\\Text\\Integer',80,'4','a:1:{s:3:\"min\";i:0;}'),(245,'na_from_current_category','CDev\\ProductAdvisor','checkbox',90,'N','N;'),(246,'sep_product_advisor_cs','CDev\\ProductAdvisor','separator',1000,'','N;'),(247,'cs_enabled','CDev\\ProductAdvisor','checkbox',1010,'Y','N;'),(248,'cs_mark_with_label','CDev\\ProductAdvisor','XLite\\Module\\CDev\\ProductAdvisor\\View\\FormField\\Select\\MarkProducts',1020,'C','N;'),(249,'cs_display_date','CDev\\ProductAdvisor','checkbox',1030,'Y','N;'),(250,'cs_from_current_category','CDev\\ProductAdvisor','checkbox',1050,'N','N;'),(251,'cs_max_count_in_block','CDev\\ProductAdvisor','XLite\\View\\FormField\\Input\\Text\\Integer',1080,'4','a:1:{s:3:\"min\";i:0;}'),(252,'sep_product_advisor_rv','CDev\\ProductAdvisor','separator',2000,'','N;'),(253,'rv_enabled','CDev\\ProductAdvisor','checkbox',2010,'Y','N;'),(254,'rv_max_count_in_block','CDev\\ProductAdvisor','XLite\\View\\FormField\\Input\\Text\\Integer',2020,'10','a:1:{s:3:\"min\";i:0;}'),(255,'sep_product_advisor_cbb','CDev\\ProductAdvisor','separator',3000,'','N;'),(256,'cbb_enabled','CDev\\ProductAdvisor','checkbox',3010,'Y','N;'),(257,'cbb_max_count_in_block','CDev\\ProductAdvisor','XLite\\View\\FormField\\Input\\Text\\Integer',3020,'5','a:1:{s:3:\"min\";i:0;}'),(258,'sep_product_advisor_cvb','CDev\\ProductAdvisor','separator',4000,'','N;'),(259,'cvb_enabled','CDev\\ProductAdvisor','checkbox',4010,'Y','N;'),(260,'cvb_max_count_in_block','CDev\\ProductAdvisor','XLite\\View\\FormField\\Input\\Text\\Integer',4020,'5','a:1:{s:3:\"min\";i:0;}'),(261,'sale_enabled','CDev\\Sale','checkbox',20,'Y','N;'),(262,'sale_in_current_category','CDev\\Sale','checkbox',30,'Y','N;'),(263,'sale_max_count_in_block','CDev\\Sale','text',80,'4','N;'),(264,'ignore_memberships','CDev\\SalesTax','checkbox',150,'Y','N;'),(265,'addressType','CDev\\SalesTax','\\XLite\\Module\\CDev\\SalesTax\\View\\FormField\\AddressType',160,'billing','N;'),(266,'taxableBase','CDev\\SalesTax','\\XLite\\Module\\CDev\\SalesTax\\View\\FormField\\TaxableBase',170,'DST+SH','N;'),(267,'logo','CDev\\SimpleCMS','XLite\\Module\\CDev\\SimpleCMS\\View\\FormField\\Input\\Logo',100,'','N;'),(268,'favicon','CDev\\SimpleCMS','XLite\\Module\\CDev\\SimpleCMS\\View\\FormField\\Input\\Favicon',200,'','N;'),(269,'appleIcon','CDev\\SimpleCMS','XLite\\Module\\CDev\\SimpleCMS\\View\\FormField\\Input\\AppleIcon',250,'','N;'),(270,'page_changefreq','CDev\\XMLSitemap','XLite\\Module\\CDev\\SimpleCMS\\View\\FormField\\Select\\ChangeFrequency',400,'daily','N;'),(271,'page_priority','CDev\\XMLSitemap','XLite\\View\\FormField\\Input\\Text\\FloatInput',800,'0.5','a:3:{s:3:\"min\";i:0;s:3:\"max\";i:1;s:1:\"e\";i:1;}'),(272,'show_default_menu','CDev\\SimpleCMS','checkbox',300,'Y','N;'),(273,'dataProvider','CDev\\USPS','XLite\\Module\\CDev\\USPS\\View\\FormField\\Select\\DataProvider',2,'pitneyBowes','N;'),(274,'pbEmailId','CDev\\USPS','XLite\\View\\FormField\\Input\\Text',10,'','N;'),(275,'pbShipperId','CDev\\USPS','',10,'','N;'),(276,'userid','CDev\\USPS','XLite\\View\\FormField\\Input\\Text',10,'','N;'),(277,'server_url','CDev\\USPS','XLite\\View\\FormField\\Input\\Text\\URL',20,'http://stg-production.shippingapis.com/ShippingApi.dll','N;'),(278,'additionalSettingsSeparator','CDev\\USPS','separator',100,'','N;'),(279,'commonOptionsSeparator','CDev\\USPS','separator',200,'','N;'),(280,'dimensions','CDev\\USPS','serialized',210,'a:3:{i:0;i:10;i:1;i:7;i:2;i:9;}','N;'),(281,'girth','CDev\\USPS','XLite\\View\\FormField\\Input\\Text\\FloatInput',220,'0','N;'),(282,'max_weight','CDev\\USPS','XLite\\View\\FormField\\Input\\Text\\FloatInput',230,'70','N;'),(283,'machinable','CDev\\USPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',235,'1','N;'),(284,'currency_rate','CDev\\USPS','XLite\\View\\FormField\\Input\\Text\\FloatInput',240,'1','N;'),(285,'domesticUSPSSeparator','CDev\\USPS','separator',300,'','N;'),(286,'container','CDev\\USPS','XLite\\Module\\CDev\\USPS\\View\\FormField\\Select\\Container',310,'VARIABLE','N;'),(287,'first_class_mail_type','CDev\\USPS','XLite\\Module\\CDev\\USPS\\View\\FormField\\Select\\FirstClassMailType',330,'PARCEL','N;'),(288,'use_rate_type','CDev\\USPS','XLite\\Module\\CDev\\USPS\\View\\FormField\\Select\\UseRateType',350,'Rate','N;'),(289,'pb_domestic_parcel_type','CDev\\USPS','XLite\\Module\\CDev\\USPS\\View\\FormField\\Select\\PBDomesticParcelType',360,'PKG','N;'),(290,'domestic_all_services_type','CDev\\USPS','XLite\\Module\\CDev\\USPS\\View\\FormField\\Select\\AllServicesType',370,'online','N;'),(291,'internationalUSPSSeparator','CDev\\USPS','separator',400,'','N;'),(292,'mail_type','CDev\\USPS','XLite\\Module\\CDev\\USPS\\View\\FormField\\Select\\MailType',410,'Package','N;'),(293,'commercial','CDev\\USPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',430,'','N;'),(294,'gxg','CDev\\USPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',440,'','N;'),(295,'gxg_pobox','CDev\\USPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',450,'','N;'),(296,'gxg_gift','CDev\\USPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',460,'','N;'),(297,'pb_international_parcel_type','CDev\\USPS','XLite\\Module\\CDev\\USPS\\View\\FormField\\Select\\PBInternationalParcelType',470,'PKG','N;'),(298,'cacheOnDeliverySeparator','CDev\\USPS','separator',500,'','N;'),(299,'use_cod_price','CDev\\USPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',510,'1','N;'),(300,'cod_price','CDev\\USPS','XLite\\View\\FormField\\Input\\Text\\Price',520,'6.95','N;'),(301,'additionalOptionsSeparator','CDev\\USPS','separator',600,'','N;'),(302,'debug_enabled','CDev\\USPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',610,'','N;'),(303,'pbSandbox','CDev\\USPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',605,'','N;'),(304,'autoenable_new_methods','CDev\\USPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',620,'1','N;'),(305,'welcome_changefreq','CDev\\XMLSitemap','XLite\\Module\\CDev\\XMLSitemap\\View\\FormField\\Select\\ChangeFrequency',100,'daily','N;'),(306,'category_changefreq','CDev\\XMLSitemap','XLite\\Module\\CDev\\XMLSitemap\\View\\FormField\\Select\\ChangeFrequency',200,'daily','N;'),(307,'product_changefreq','CDev\\XMLSitemap','XLite\\Module\\CDev\\XMLSitemap\\View\\FormField\\Select\\ChangeFrequency',300,'daily','N;'),(308,'welcome_priority','CDev\\XMLSitemap','XLite\\View\\FormField\\Input\\Text\\FloatInput',500,'0.5','a:3:{s:3:\"min\";i:0;s:3:\"max\";i:1;s:1:\"e\";i:1;}'),(309,'category_priority','CDev\\XMLSitemap','XLite\\View\\FormField\\Input\\Text\\FloatInput',600,'0.5','a:3:{s:3:\"min\";i:0;s:3:\"max\";i:1;s:1:\"e\";i:1;}'),(310,'product_priority','CDev\\XMLSitemap','XLite\\View\\FormField\\Input\\Text\\FloatInput',700,'0.5','a:3:{s:3:\"min\";i:0;s:3:\"max\";i:1;s:1:\"e\";i:1;}'),(311,'account_id','Kliken\\GoogleAds','XLite\\View\\FormField\\Input\\Text\\Integer',100,'','N;'),(312,'app_token','Kliken\\GoogleAds','text',200,'','N;'),(313,'google_verification_token','Kliken\\GoogleAds','text',300,'','N;'),(314,'api_key','QSL\\CloudSearch','hidden',0,'','N;'),(315,'secret_key','QSL\\CloudSearch','hidden',0,'','N;'),(316,'dashboard','QSL\\CloudSearch','\\XLite\\Module\\QSL\\CloudSearch\\View\\FormField\\Dashboard',0,'','N;'),(317,'isCloudFiltersEnabled','QSL\\CloudSearch','hidden',20,'','N;'),(318,'isAdminSearchEnabled','QSL\\CloudSearch','hidden',30,'','N;'),(319,'planFeatures','QSL\\CloudSearch','hidden',0,'','N;'),(320,'fcm_show_product_num','QSL\\FlyoutCategoriesMenu','checkbox',10,'N','N;'),(321,'fcm_word_wrap','QSL\\FlyoutCategoriesMenu','checkbox',20,'Y','N;'),(322,'fcm_show_triangle','QSL\\FlyoutCategoriesMenu','checkbox',30,'Y','N;'),(323,'wizard_enabled','XC\\CanadaPost','',0,'1','N;'),(324,'wizard_hash','XC\\CanadaPost','',0,'','N;'),(325,'user','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Text',10,'','N;'),(326,'password','XC\\CanadaPost','XLite\\View\\FormField\\Input\\PasswordWithValue',20,'','N;'),(327,'developer_mode','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',30,'','N;'),(328,'debug_enabled','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',40,'','N;'),(329,'additionalSettingsSeparator','XC\\CanadaPost','separator',100,'','N;'),(330,'quote_type','XC\\CanadaPost','XLite\\Module\\XC\\CanadaPost\\View\\FormField\\Select\\QuoteType',110,'C','N;'),(331,'customer_number','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Text',120,'','N;'),(332,'currency_rate','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Text\\FloatInput',130,'1','N;'),(333,'contractShippingSeparator','XC\\CanadaPost','separator',200,'','N;'),(334,'contract_id','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Text',210,'','N;'),(335,'pick_up_type','XC\\CanadaPost','XLite\\Module\\XC\\CanadaPost\\View\\FormField\\Select\\PickUpType',220,'','N;'),(336,'deposit_site_num','XC\\CanadaPost','XLite\\Module\\XC\\CanadaPost\\View\\FormField\\Input\\Text\\DepositSiteNum',230,'','N;'),(337,'detailed_manifests','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',240,'1','N;'),(338,'manifest_name','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Text',250,'','N;'),(339,'deliverToPostOfficeSeparator','XC\\CanadaPost','separator',300,'','N;'),(340,'deliver_to_po_enabled','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',310,'','N;'),(341,'max_post_offices','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Text\\Integer',320,'5','N;'),(342,'parcelCharacteristicsSeparator','XC\\CanadaPost','separator',400,'','N;'),(343,'length','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Text\\FloatInput',410,'10','N;'),(344,'width','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Text\\FloatInput',420,'9','N;'),(345,'height','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Text\\FloatInput',430,'7','N;'),(346,'max_weight','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Text\\FloatInput',440,'30','N;'),(347,'document','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',450,'','N;'),(348,'unpackaged','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',460,'','N;'),(349,'mailing_tube','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',470,'','N;'),(350,'oversized','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',480,'','N;'),(351,'parcelSeparator','XC\\CanadaPost','separator',500,'','N;'),(352,'way_to_deliver','XC\\CanadaPost','XLite\\Module\\XC\\CanadaPost\\View\\FormField\\Select\\DeliveryWayType',510,'','N;'),(353,'signature','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',520,'','N;'),(354,'age_proof','XC\\CanadaPost','XLite\\Module\\XC\\CanadaPost\\View\\FormField\\Select\\AgeProofType',530,'','N;'),(355,'coverage','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Text\\FloatInput',540,'0','N;'),(356,'non_delivery','XC\\CanadaPost','XLite\\Module\\XC\\CanadaPost\\View\\FormField\\Select\\NonDeliveryType',550,'','N;'),(357,'write_key','XC\\Concierge','hidden',100,'','N;'),(358,'user_id','XC\\Concierge','hidden',300,'','N;'),(359,'additional_config_loaded','XC\\Concierge','hidden',400,'','N;'),(360,'quantity','XC\\CustomerAttachments','\\XLite\\View\\FormField\\Input\\Text\\Integer',0,'10','a:1:{s:3:\"min\";i:0;}'),(361,'extensions','XC\\CustomerAttachments','text',0,'','a:1:{s:7:\"comment\";s:68:\"Enter file extensions separated by comma; for example, \"jpg,txt,svg\"\";}'),(362,'file_size','XC\\CustomerAttachments','\\XLite\\Module\\XC\\CustomerAttachments\\View\\FormField\\Input\\Text\\FileSizeInteger',0,'0','a:1:{s:3:\"min\";i:0;}'),(363,'pixel_id','XC\\FacebookMarketing','hidden',0,'','N;'),(364,'include_out_of_stock','XC\\FacebookMarketing','hidden',0,'Y','N;'),(365,'renewal_frequency','XC\\FacebookMarketing','hidden',0,'86400','N;'),(366,'add_to_cart_value','XC\\FacebookMarketing','hidden',0,'30','N;'),(367,'view_content_value','XC\\FacebookMarketing','hidden',0,'10','N;'),(368,'init_checkout_value','XC\\FacebookMarketing','hidden',0,'40','N;'),(369,'advanced_matching','XC\\FacebookMarketing','hidden',0,'1','N;'),(370,'checkout_type','General','XLite\\Module\\XC\\FastLaneCheckout\\View\\FormField\\Select\\CheckoutType',200,'fast-lane','N;'),(371,'freight_shipping_calc_mode','XC\\FreeShipping','XLite\\Module\\XC\\FreeShipping\\View\\FormField\\FreightMode',10,'F','N;'),(372,'use_custom_colors','XC\\FroalaEditor','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',10,'','N;'),(373,'custom_colors','XC\\FroalaEditor','XLite\\Module\\XC\\FroalaEditor\\View\\FormField\\ColorPalettePicker',20,'','N;'),(374,'use_as_email_editor','XC\\FroalaEditor','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',30,'1','N;'),(375,'default_provider','XC\\Geolocation','XLite\\Module\\XC\\Geolocation\\View\\FormField\\Select\\DefaultProvider',10,'0','N;'),(376,'display_location_popup','XC\\Geolocation','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',20,'1','N;'),(377,'extended_database','XC\\Geolocation','XLite\\View\\FormField\\FileUploader\\ChunkUpload',30,'','a:2:{s:13:\"successAction\";s:11:\"geolocation\";s:10:\"extensions\";s:5:\".mmdb\";}'),(378,'current_database','XC\\Geolocation','XLite\\Module\\XC\\Geolocation\\View\\FormField\\Label\\CurrentDatabase',40,'','N;'),(379,'renewal_frequency','XC\\GoogleFeed','XLite\\Module\\XC\\GoogleFeed\\View\\FormField\\Select\\RenewalFrequency',0,'86400','N;'),(380,'duplicate_policy','XC\\GoogleFeed','XLite\\Module\\XC\\GoogleFeed\\View\\FormField\\Select\\DuplicatePolicy',0,'export_as_separate','N;'),(381,'mailChimpSeparator','XC\\MailChimp','separator',100,'','N;'),(382,'mailChimpAPIKey','XC\\MailChimp','text',200,'','N;'),(383,'analytics360enabled','XC\\MailChimp','\\XLite\\View\\FormField\\Input\\Checkbox\\OnOff',300,'1','N;'),(384,'abandonedCartEnabled','XC\\MailChimp','\\XLite\\View\\FormField\\Input\\Checkbox\\OnOff',350,'','N;'),(385,'defaultAutomationListId','XC\\MailChimp','\\XLite\\Module\\XC\\MailChimp\\View\\FormField\\Select\\Lists',375,'','N;'),(386,'doubleOptinDisabled','XC\\MailChimp','\\XLite\\View\\FormField\\Input\\Checkbox\\OnOff',400,'','N;'),(387,'subscriptionElementType','XC\\MailChimp','XLite\\Module\\XC\\MailChimp\\View\\FormField\\Select\\ElementType',500,'checkbox','N;'),(388,'updateInterval','XC\\MailChimp','XLite\\Module\\XC\\MailChimp\\View\\FormField\\Select\\UpdateInterval',600,'never','N;'),(389,'send_coupons','XC\\MailChimp','XLite\\Module\\XC\\MailChimp\\View\\FormField\\Select\\SendCoupons',700,'all','N;'),(390,'mcjs','XC\\MailChimp','textarea',800,'','N;'),(391,'top_news_length','XC\\News','XLite\\View\\FormField\\Input\\Text\\Integer',100,'5','a:1:{s:3:\"min\";i:1;}'),(392,'items_per_page','XC\\News','XLite\\View\\FormField\\Input\\Text\\Integer',200,'50','a:1:{s:3:\"min\";i:1;}'),(393,'news_changefreq','CDev\\XMLSitemap','XLite\\Module\\CDev\\XMLSitemap\\View\\FormField\\Select\\ChangeFrequency',400,'daily','N;'),(394,'news_priority','CDev\\XMLSitemap','XLite\\View\\FormField\\Input\\Text\\FloatInput',800,'0.5','a:3:{s:3:\"min\";i:0;s:3:\"max\";i:1;s:1:\"e\";i:1;}'),(395,'create_nfo_mode','XC\\NotFinishedOrders','XLite\\Module\\XC\\NotFinishedOrders\\View\\FormField\\Select\\CreateNFOMode',5,'onFailure','N;'),(396,'clear_cart_on_order_change','XC\\NotFinishedOrders','XLite\\View\\FormField\\Select\\YesNo',10,'Y','N;'),(397,'limit_nf_order_ttl','XC\\NotFinishedOrders','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',20,'1','N;'),(398,'nf_order_ttl','XC\\NotFinishedOrders','XLite\\View\\FormField\\Input\\Text\\Integer',30,'30','N;'),(399,'wizard_state','XC\\Onboarding','hidden',0,'visible','N;'),(400,'enable_in_stock_only_filter','XC\\ProductFilter','checkbox',100,'1','N;'),(401,'enable_price_range_filter','XC\\ProductFilter','checkbox',200,'1','N;'),(402,'enable_attributes_filter','XC\\ProductFilter','checkbox',300,'1','N;'),(403,'attributes_filter_by_category','XC\\ProductFilter','checkbox',400,'1','N;'),(404,'attributes_filter_cache_mode','XC\\ProductFilter','XLite\\Module\\XC\\ProductFilter\\View\\FormField\\Select\\CacheResetMode',500,'1','N;'),(405,'attributes_sorting_type','XC\\ProductFilter','XLite\\Module\\XC\\ProductFilter\\View\\FormField\\Select\\AttributesSortingType',600,'A','N;'),(406,'url_part_type','XC\\ProductFilter','XLite\\Module\\XC\\ProductFilter\\View\\FormField\\Select\\UrlPartType',700,'G','N;'),(407,'show_tags_sidebar','XC\\ProductTags','checkbox',100,'','N;'),(408,'enable_tags_filter','XC\\ProductFilter','checkbox',350,'1','N;'),(409,'key','XC\\RESTAPI','text',100,'umOLKV3igGnlckUpGHX7J7jQFnOJzkZP','N;'),(410,'key_read','XC\\RESTAPI','text',200,'RtSNHLKG5I0ed6nlyX8kmgqS6lMeAjJd','N;'),(411,'whoCanLeaveFeedback','XC\\Reviews','\\XLite\\Module\\XC\\Reviews\\View\\FormField\\Select\\WhoCanLeaveFeedback',10,'R','N;'),(412,'disablePendingReviews','XC\\Reviews','checkbox',20,'1','N;'),(413,'reviewsCountPerTab','XC\\Reviews','\\XLite\\View\\FormField\\Input\\Text\\Integer',30,'5','a:1:{s:3:\"min\";i:1;}'),(414,'enableCustomersFollowup','XC\\Reviews','\\XLite\\View\\FormField\\Input\\Checkbox\\OnOff',50,'','N;'),(415,'followupTimeout','XC\\Reviews','\\XLite\\View\\FormField\\Input\\Text\\Integer',60,'15','a:1:{s:3:\"min\";i:0;}'),(416,'use_custom_css','XC\\ThemeTweaker','checkbox',10,'','N;'),(417,'use_custom_js','XC\\ThemeTweaker','checkbox',20,'','N;'),(418,'userID','XC\\UPS','XLite\\View\\FormField\\Input\\Text',10,'','N;'),(419,'password','XC\\UPS','XLite\\View\\FormField\\Input\\PasswordWithValue',20,'','N;'),(420,'accessKey','XC\\UPS','XLite\\View\\FormField\\Input\\Text',30,'','N;'),(421,'shipper_number','XC\\UPS','XLite\\View\\FormField\\Input\\Text',40,'','N;'),(422,'test_mode','XC\\UPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',50,'1','N;'),(423,'additionalSettingsSeparator','XC\\UPS','separator',100,'','N;'),(424,'packageSettingsSeparator','XC\\UPS','separator',200,'','N;'),(425,'packaging_type','XC\\UPS','XLite\\Module\\XC\\UPS\\View\\FormField\\Select\\PackagingType',210,'00','N;'),(426,'dimensions','XC\\UPS','serialized',220,'a:3:{i:0;i:10;i:1;i:10;i:2;i:10;}','N;'),(427,'max_weight','XC\\UPS','XLite\\View\\FormField\\Input\\Text\\FloatInput',230,'150','N;'),(428,'serviceOptionsSeparator','XC\\UPS','separator',300,'','N;'),(429,'pickup_type','XC\\UPS','XLite\\Module\\XC\\UPS\\View\\FormField\\Select\\PickupType',310,'01','N;'),(430,'saturday_pickup','XC\\UPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',320,'','N;'),(431,'additional_handling','XC\\UPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',330,'','N;'),(432,'saturday_delivery','XC\\UPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',340,'','N;'),(433,'negotiated_rates','XC\\UPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',350,'','N;'),(434,'delivery_conf','XC\\UPS','XLite\\Module\\XC\\UPS\\View\\FormField\\Select\\DeliveryConfirmation',360,'0','N;'),(435,'extra_cover','XC\\UPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',370,'','N;'),(436,'extra_cover_value','XC\\UPS','XLite\\View\\FormField\\Input\\Text\\Price',380,'0','N;'),(437,'shippingRefundsSeparator','XC\\UPS','separator',390,'','N;'),(438,'lbs71Info','XC\\UPS','XLite\\View\\FormField\\Label',395,'As a UPS user, you are entitled to receive shipping refunds usually left unclaimed with default UPS service ($2B/year globally)','a:1:{s:9:\"fieldOnly\";b:1;}'),(439,'cacheOnDeliverySeparator','XC\\UPS','separator',400,'','N;'),(440,'currencyConversionSeparator','XC\\UPS','separator',500,'','N;'),(441,'currency_code','XC\\UPS','XLite\\View\\FormField\\Input\\Text',510,'','N;'),(442,'currency_rate','XC\\UPS','XLite\\View\\FormField\\Input\\Text\\FloatInput',520,'1','N;'),(443,'additionalOptionsSeparator','XC\\UPS','separator',600,'','N;'),(444,'debug_enabled','XC\\UPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',610,'1','N;'),(445,'allow_vendor_communication','XC\\VendorMessages','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',200,'0','N;'),(446,'time_zone','General','',0,'Europe/Moscow','N;');
CREATE TABLE `xlite_currency_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_E560C647BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_currencies` (`currency_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_currency_translations` VALUES (1,784,'UAE Dirham','en'),(2,971,'Afghani','en'),(3,8,'Lek','en'),(4,51,'Armenian Dram','en'),(5,532,'Netherlands Antillian Guilder','en'),(6,973,'Kwanza','en'),(7,32,'Argentine Peso','en'),(8,36,'Australian Dollar','en'),(9,533,'Aruban Guilder','en'),(10,944,'Azerbaijanian Manat','en'),(11,977,'Convertible Marks','en'),(12,52,'Barbados Dollar','en'),(13,50,'Bangladesh Taka','en'),(14,975,'Bulgarian Lev','en'),(15,48,'Bahraini dinar','en'),(16,108,'Burundi Franc','en'),(17,60,'Bermudian Dollar','en'),(18,96,'Brunei Dollar','en'),(19,68,'Boliviano','en'),(20,986,'Brazilian Real','en'),(21,44,'Bahamian dollar','en'),(22,64,'Ngultrum','en'),(23,72,'Botswana Pula','en'),(24,974,'Belarussian Rouble','en'),(25,84,'Belize Dollar','en'),(26,124,'Canadian Dollar','en'),(27,976,'Franc Congolais','en'),(28,756,'Swiss Franc','en'),(29,152,'Chilean Peso','en'),(30,156,'Chinese Renminbi Yuan','en'),(31,170,'Colombian Peso','en'),(32,188,'Cost Rican Colon','en'),(33,192,'Cuban Peso','en'),(34,132,'Cape Verde Escudo','en'),(35,203,'Czech Koruna','en'),(36,262,'Djibouti Franc','en'),(37,208,'Danish Krone','en'),(38,214,'Dominican Peso','en'),(39,12,'Algerian Dinar','en'),(40,818,'Egyptian Pound','en'),(41,232,'Nakfa','en'),(42,230,'Ethiopian Birr','en'),(43,978,'Euro','en'),(44,242,'Fiji Dollar','en'),(45,238,'Falkland Islands Pound','en'),(46,826,'Pound Sterling','en'),(47,981,'Lari','en'),(48,936,'Ghana Cedi','en'),(49,292,'Gilbraltar Pound','en'),(50,270,'Dalasi','en'),(51,324,'Guinea Franc','en'),(52,320,'Quetzal','en'),(53,328,'Guyana Dollar','en'),(54,344,'Hong Kong Dollar','en'),(55,340,'Lempira','en'),(56,191,'Croatian Kuna','en'),(57,332,'Gourde','en'),(58,348,'Hungary Forint','en'),(59,360,'Indonesian Rupiah','en'),(60,376,'New Israeli Sheqel','en'),(61,356,'Indian Rupee','en'),(62,368,'Iraqi Dinar','en'),(63,364,'Iranian Rial','en'),(64,352,'Iceland Krona','en'),(65,388,'Jamaican Dollar','en'),(66,400,'Jordanian Dinar','en'),(67,392,'Japanese Yen','en'),(68,404,'Kenyan Shilling','en'),(69,417,'Son','en'),(70,116,'Cambodian riel','en'),(71,174,'Comoro Franc','en'),(72,408,'North Korean Won','en'),(73,410,'South Korean Won','en'),(74,414,'Kuwaiti Dinar','en'),(75,136,'Cayman Islands Dollar','en'),(76,398,'Tenge','en'),(77,418,'Kip','en'),(78,422,'Lebanese Pound','en'),(79,144,'Sri Lanka Rupee','en'),(80,430,'Liberian Dollar','en'),(81,426,'Loti','en'),(82,440,'Lithuanian Litus','en'),(83,428,'Latvian Lats','en'),(84,434,'Libyan Dinar','en'),(85,504,'Moroccan Dirham','en'),(86,498,'Moldovan Leu','en'),(87,969,'Malagasy Ariary','en'),(88,807,'Denar','en'),(89,104,'Kyat','en'),(90,496,'Tugrik','en'),(91,446,'Pataca','en'),(92,478,'Ouguiya','en'),(93,480,'Mauritius Rupee','en'),(94,462,'Rufiyaa','en'),(95,454,'Malawian kwacha','en'),(96,484,'Mexican Peso','en'),(97,458,'Ringgit Malaysia','en'),(98,943,'Mozambique Metical','en'),(99,516,'Namibia Dollar','en'),(100,566,'Naira','en'),(101,558,'Cordoba Oro','en'),(102,578,'Norwegian Krone','en'),(103,524,'Nepalese Rupee','en'),(104,554,'New Zealand Dollar','en'),(105,512,'Rial Omani','en'),(106,590,'Balboa','en'),(107,604,'Nuevo Sol','en'),(108,598,'Kina','en'),(109,608,'Philippine Peso','en'),(110,586,'Pakistan Rupee','en'),(111,985,'Polish Zloty','en'),(112,600,'Guarani','en'),(113,634,'Qatari Rial','en'),(114,946,'Romanian Leu','en'),(115,941,'Serbian Dinar','en'),(116,643,'Russian Ruble','en'),(117,646,'Rwanda Franc','en'),(118,682,'Saudi Riyal','en'),(119,90,'Solomon Islands Dollar','en'),(120,690,'Seychelles Rupee','en'),(121,938,'Sudanese Pound','en'),(122,752,'Swedish Krona','en'),(123,702,'Singapore Dollar','en'),(124,654,'Saint Helena Pound','en'),(125,694,'Leone','en'),(126,706,'Somali Shilling','en'),(127,968,'Surinam Dollar','en'),(128,728,'South Sudanese Pound','en'),(129,678,'Dobra','en'),(130,222,'El Salvador Colon','en'),(131,760,'Syrian Pound','en'),(132,748,'Lilangeni','en'),(133,764,'Thailand Baht','en'),(134,972,'Somoni','en'),(135,934,'Turkmenistan New Manat','en'),(136,788,'Tunisian Dinar','en'),(137,776,'Pa\'anga','en'),(138,949,'Turkish Lira','en'),(139,780,'Trinidad and Tobago Dollar','en'),(140,901,'New Taiwan Dollar','en'),(141,834,'Tanzanian Shilling','en'),(142,980,'Hryvnia','en'),(143,800,'Uganda Shilling','en'),(144,840,'US Dollar','en'),(145,858,'Peso Uruguayo','en'),(146,860,'Uzbekistan som','en'),(147,937,'Bolivar Fuerte','en'),(148,704,'Vietnamese Dong','en'),(149,548,'Vatu','en'),(150,882,'Tala','en'),(151,950,'CFA Franc BEAC','en'),(152,951,'East Caribbean Dollar','en'),(153,952,'CFA Franc BCEAO','en'),(154,953,'CFP Franc','en'),(155,886,'Yemeni Rial','en'),(156,710,'South Africa Rand','en'),(157,894,'Zambian kwacha','en'),(158,932,'Zimbabwe Dollar','en');
CREATE TABLE `xlite_zones` (
  `zone_id` int(11) NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL,
  PRIMARY KEY (`zone_id`),
  KEY `zone_name` (`zone_name`),
  KEY `zone_default` (`is_default`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_zones` VALUES (1,'All Addresses (default zone)',1),(2,'United States',0),(3,'North of United States & Canada',0),(4,'Europe',0);
CREATE TABLE `xlite_order_status_properties` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `payment_status_id` int(10) unsigned DEFAULT NULL,
  `shipping_status_id` int(10) unsigned DEFAULT NULL,
  `incStock` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payment_status` (`payment_status_id`),
  KEY `shipping_status` (`shipping_status_id`),
  CONSTRAINT `FK_A5E047EE28DE2F95` FOREIGN KEY (`payment_status_id`) REFERENCES `xlite_order_payment_statuses` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_A5E047EE2D02518A` FOREIGN KEY (`shipping_status_id`) REFERENCES `xlite_order_shipping_statuses` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_order_status_properties` VALUES (1,2,1,0),(2,2,2,0),(3,2,3,0),(4,2,4,0),(5,2,5,0),(6,2,6,0),(7,2,7,0),(8,2,8,0),(9,3,1,0),(10,3,2,0),(11,3,3,0),(12,3,4,0),(13,3,5,0),(14,3,6,0),(15,3,7,0),(16,3,8,0),(17,4,1,0),(18,4,2,0),(19,4,3,0),(20,4,4,0),(21,4,5,0),(22,4,6,0),(23,4,7,0),(24,4,8,0),(25,5,1,1),(26,5,2,1),(27,5,3,1),(28,5,4,1),(29,5,5,1),(30,5,6,1),(31,5,7,1),(32,5,8,1),(33,6,1,1),(34,6,2,1),(35,6,3,1),(36,6,4,1),(37,6,5,1),(38,6,6,1),(39,6,7,1),(40,6,8,1),(41,1,1,0),(42,1,2,0),(43,1,3,0),(44,1,4,0),(45,1,5,0),(46,1,6,0),(47,1,7,0),(48,1,8,0),(49,7,1,1),(50,7,2,1),(51,7,3,0),(52,7,4,0),(53,7,5,1),(54,7,6,1),(55,7,7,1),(56,7,8,1),(57,2,9,1),(58,3,9,1),(59,4,9,1),(60,5,9,1),(61,6,9,1),(62,1,9,1),(63,7,9,1);
CREATE TABLE `xlite_capost_return_link_storage` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(512) COLLATE utf8_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  `linkId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_784CAF87AEC98E42` (`linkId`),
  CONSTRAINT `FK_784CAF87AEC98E42` FOREIGN KEY (`linkId`) REFERENCES `xlite_capost_return_links` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_banner_rotation_slide` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `enabled` tinyint(1) NOT NULL,
  `link` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `position` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_banner_rotation_slide` VALUES (1,0,'cart.php?target=category&category_id=6',50),(2,1,'cart.php?target=category&category_id=8',30),(3,1,'cart.php?target=category&category_id=9',40),(4,1,'cart.php?target=category&category_id=2',20);
CREATE TABLE `xlite_order_payment_statuses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` char(4) COLLATE utf8_unicode_ci DEFAULT NULL,
  `position` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_A2C34C8E77153098` (`code`),
  KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_order_payment_statuses` VALUES (1,'Q',10),(2,'A',20),(3,'PP',30),(4,'P',40),(5,'D',50),(6,'C',60),(7,'R',70);
CREATE TABLE `xlite_order_item_attribute_values` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `item_id` int(11) DEFAULT NULL,
  `attribute_value_checkbox_id` int(10) unsigned DEFAULT NULL,
  `attribute_value_select_id` int(10) unsigned DEFAULT NULL,
  `attribute_value_text_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `value` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `attributeId` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_46E30CEA126F525E` (`item_id`),
  KEY `IDX_46E30CEA571B5A02` (`attribute_value_checkbox_id`),
  KEY `IDX_46E30CEAA16D6CC9` (`attribute_value_select_id`),
  KEY `IDX_46E30CEA27A31B4D` (`attribute_value_text_id`),
  CONSTRAINT `FK_46E30CEA126F525E` FOREIGN KEY (`item_id`) REFERENCES `xlite_order_items` (`item_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_46E30CEA27A31B4D` FOREIGN KEY (`attribute_value_text_id`) REFERENCES `xlite_attribute_values_text` (`id`) ON DELETE SET NULL,
  CONSTRAINT `FK_46E30CEA571B5A02` FOREIGN KEY (`attribute_value_checkbox_id`) REFERENCES `xlite_attribute_values_checkbox` (`id`) ON DELETE SET NULL,
  CONSTRAINT `FK_46E30CEAA16D6CC9` FOREIGN KEY (`attribute_value_select_id`) REFERENCES `xlite_attribute_values_select` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_search_filter_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `IDX_5D64D191BF396750` (`id`),
  KEY `name` (`name`),
  CONSTRAINT `FK_5D64D191BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_search_filters` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_search_filter_translations` VALUES (1,1,'Unpaid','en'),(2,1,'Не оплаченные','ru'),(3,2,'Paid but not shipped','en'),(4,2,'Оплаченные, но не отправленные','ru'),(5,3,'Not finished','en'),(6,3,'Незавершенные','ru');
CREATE TABLE `xlite_countries` (
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `id` int(11) NOT NULL,
  `code3` char(3) COLLATE utf8_unicode_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `IDX_C4F7794938248176` (`currency_id`),
  KEY `enabled` (`enabled`),
  CONSTRAINT `FK_C4F7794938248176` FOREIGN KEY (`currency_id`) REFERENCES `xlite_currencies` (`currency_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_countries` VALUES ('AD',978,20,'AND',1),('AE',784,784,'ARE',1),('AF',971,4,'AFG',1),('AG',951,28,'ATG',1),('AI',951,660,'AIA',1),('AL',8,8,'ALB',1),('AM',51,51,'ARM',1),('AO',973,24,'AGO',1),('AQ',NULL,10,'ATA',1),('AR',32,32,'ARG',1),('AS',840,16,'ASM',1),('AT',978,40,'AUT',1),('AU',36,36,'AUS',1),('AW',533,533,'ABW',1),('AX',978,248,'ALA',1),('AZ',944,31,'AZE',1),('BA',977,70,'BIH',1),('BB',52,52,'BRB',1),('BD',50,50,'BGD',1),('BE',978,56,'BEL',1),('BF',952,854,'BFA',1),('BG',975,100,'BGR',1),('BH',48,48,'BHR',1),('BI',108,108,'BDI',1),('BJ',952,204,'BEN',1),('BL',978,652,'BLM',1),('BM',60,60,'BMU',1),('BN',96,96,'BRN',1),('BO',68,68,'BOL',1),('BQ',840,535,'BES',1),('BR',986,76,'BRA',1),('BS',44,44,'BHS',1),('BT',356,64,'BTN',1),('BV',578,74,'BVT',1),('BW',72,72,'BWA',1),('BY',974,112,'BLR',1),('BZ',84,84,'BLZ',1),('CA',124,124,'CAN',1),('CC',36,166,'CCK',1),('CD',976,180,'COD',1),('CF',950,140,'CAF',1),('CG',950,178,'COG',1),('CH',756,756,'CHE',1),('CI',950,384,'CIV',1),('CK',554,184,'COK',1),('CL',152,152,'CHL',1),('CM',950,120,'CMR',1),('CN',156,156,'CHN',1),('CO',170,170,'COL',1),('CR',188,188,'CRI',1),('CU',192,192,'CUB',1),('CV',132,132,'CPV',1),('CW',532,531,'CUW',1),('CX',36,162,'CXR',1),('CY',978,196,'CYP',1),('CZ',203,203,'CZE',1),('DE',978,276,'DEU',1),('DJ',262,262,'DJI',1),('DK',208,208,'DNK',1),('DM',951,212,'DMA',1),('DO',214,214,'DOM',1),('DZ',12,12,'DZA',1),('EC',840,218,'ECU',1),('EE',978,233,'EST',1),('EG',818,818,'EGY',1),('EH',504,732,'ESH',1),('ER',232,232,'ERI',1),('ES',978,724,'ESP',1),('ET',230,231,'ETH',1),('FI',978,246,'FIN',1),('FJ',242,242,'FJI',1),('FK',238,238,'FLK',1),('FM',840,583,'FSM',1),('FO',208,234,'FRO',1),('FR',978,250,'FRA',1),('GA',950,266,'GAB',1),('GB',826,826,'GBR',1),('GD',951,308,'GRD',1),('GE',981,268,'GEO',1),('GF',978,254,'GUF',1),('GG',826,831,'GGY',1),('GH',936,288,'GHA',1),('GI',292,292,'GIB',1),('GL',208,304,'GRL',1),('GM',270,270,'GMB',1),('GN',324,324,'GIN',1),('GP',978,312,'GLP',1),('GQ',950,226,'GNQ',1),('GR',978,300,'GRC',1),('GS',826,239,'SGS',1),('GT',320,320,'GTM',1),('GU',840,316,'GUM',1),('GW',952,624,'GNB',1),('GY',328,328,'GUY',1),('HK',344,344,'HKG',1),('HM',36,334,'HMD',1),('HN',340,340,'HND',1),('HR',191,191,'HRV',1),('HT',332,332,'HTI',1),('HU',348,348,'HUN',1),('ID',360,360,'IDN',1),('IE',978,372,'IRL',1),('IL',376,376,'ISR',1),('IM',826,833,'IMN',1),('IN',356,356,'IND',1),('IO',840,86,'IOT',1),('IQ',368,368,'IRQ',1),('IR',364,364,'IRN',1),('IS',352,352,'ISL',1),('IT',978,380,'ITA',1),('JE',826,832,'JEY',1),('JM',388,388,'JAM',1),('JO',400,400,'JOR',1),('JP',392,392,'JPN',1),('KE',404,404,'KEN',1),('KG',417,417,'KGZ',1),('KH',116,116,'KHM',1),('KI',36,296,'KIR',1),('KM',174,174,'COM',1),('KN',951,659,'KNA',1),('KP',408,408,'PRK',1),('KR',410,410,'KOR',1),('KW',414,414,'KWT',1),('KY',136,136,'CYM',1),('KZ',398,398,'KAZ',1),('LA',418,418,'LAO',1),('LB',422,422,'LBN',1),('LC',951,662,'LCA',1),('LI',756,438,'LIE',1),('LK',144,144,'LKA',1),('LR',430,430,'LBR',1),('LS',426,426,'LSO',1),('LT',440,440,'LTU',1),('LU',978,442,'LUX',1),('LV',428,428,'LVA',1),('LY',434,434,'LBY',1),('MA',504,504,'MAR',1),('MC',978,492,'MCO',1),('MD',498,498,'MDA',1),('ME',978,499,'MNE',1),('MF',978,663,'MAF',1),('MG',969,450,'MDG',1),('MH',840,584,'MHL',1),('MK',807,807,'MKD',1),('ML',952,466,'MLI',1),('MM',64,104,'MMR',1),('MN',496,496,'MNG',1),('MO',446,446,'MAC',1),('MP',840,580,'MNP',1),('MQ',978,474,'MTQ',1),('MR',478,478,'MRT',1),('MS',951,500,'MSR',1),('MT',978,470,'MLT',1),('MU',480,480,'MUS',1),('MV',462,462,'MDV',1),('MW',454,454,'MWI',1),('MX',484,484,'MEX',1),('MY',458,458,'MYS',1),('MZ',943,508,'MOZ',1),('NA',516,516,'NAM',1),('NC',953,540,'NCL',1),('NE',952,562,'NER',1),('NF',36,574,'NFK',1),('NG',566,566,'NGA',1),('NI',558,558,'NIC',1),('NL',978,528,'NLD',1),('NO',578,578,'NOR',1),('NP',524,524,'NPL',1),('NR',36,520,'NRU',1),('NU',554,570,'NIU',1),('NZ',554,554,'NZL',1),('OM',512,512,'OMN',1),('PA',590,591,'PAN',1),('PE',604,604,'PER',1),('PF',953,258,'PYF',1),('PG',598,598,'PNG',1),('PH',608,608,'PHL',1),('PK',586,586,'PAK',1),('PL',985,616,'POL',1),('PM',978,666,'SPM',1),('PN',554,612,'PCN',1),('PR',840,630,'PRI',1),('PS',400,275,'PSE',1),('PT',978,620,'PRT',1),('PW',840,585,'PLW',1),('PY',600,600,'PRY',1),('QA',634,634,'QAT',1),('RE',978,638,'REU',1),('RO',946,642,'ROU',1),('RS',941,688,'SRB',1),('RU',643,643,'RUS',1),('RW',646,646,'RWA',1),('SA',682,682,'SAU',1),('SB',90,90,'SLB',1),('SC',690,690,'SYC',1),('SD',938,729,'SDN',1),('SE',752,752,'SWE',1),('SG',702,702,'SGP',1),('SH',654,654,'SHN',1),('SI',978,705,'SVN',1),('SJ',978,744,'SJM',1),('SK',978,703,'SVK',1),('SL',694,694,'SLE',1),('SM',978,674,'SMR',1),('SN',952,686,'SEN',1),('SO',706,706,'SOM',1),('SR',968,740,'SUR',1),('SS',728,728,'SSD',1),('ST',678,678,'STP',1),('SV',222,222,'SLV',1),('SX',532,534,'SXM',1),('SY',760,760,'SYR',1),('SZ',748,748,'SWZ',1),('TC',840,796,'TCA',1),('TD',950,148,'TCD',1),('TF',978,260,'ATF',1),('TG',952,768,'TGO',1),('TH',764,764,'THA',1),('TJ',972,762,'TJK',1),('TK',554,772,'TKL',1),('TL',840,626,'TLS',1),('TM',934,795,'TKM',1),('TN',788,788,'TUN',1),('TO',776,776,'TON',1),('TR',949,792,'TUR',1),('TT',780,780,'TTO',1),('TV',36,798,'TUV',1),('TW',901,158,'TWN',1),('TZ',834,834,'TZA',1),('UA',980,804,'UKR',1),('UG',800,800,'UGA',1),('UM',840,581,'UMI',1),('US',840,840,'USA',1),('UY',858,858,'URY',1),('UZ',860,860,'UZB',1),('VA',978,336,'VAT',1),('VC',951,670,'VCT',1),('VE',937,862,'VEN',1),('VG',840,92,'VGB',1),('VI',840,850,'VIR',1),('VN',704,704,'VNM',1),('VU',548,548,'VUT',1),('WF',953,876,'WLF',1),('WS',882,882,'WSM',1),('YE',886,887,'YEM',1),('YT',978,175,'MYT',1),('ZA',710,710,'ZAF',1),('ZM',894,894,'ZMB',1),('ZW',932,716,'ZWE',1);
CREATE TABLE `xlite_orders` (
  `order_id` int(11) NOT NULL AUTO_INCREMENT,
  `not_finished_order_id` int(11) DEFAULT NULL,
  `profile_id` int(11) DEFAULT NULL,
  `orig_profile_id` int(11) DEFAULT NULL,
  `payment_status_id` int(10) unsigned DEFAULT NULL,
  `shipping_status_id` int(10) unsigned DEFAULT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `mailchimpStoreId` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `demo` tinyint(1) NOT NULL,
  `xpaymentsFraudStatus` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `xpaymentsFraudType` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `xpaymentsFraudCheckTransactionId` int(11) NOT NULL,
  `shipping_id` int(11) NOT NULL,
  `shipping_method_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment_method_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tracking` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `date` int(11) NOT NULL,
  `lastRenewDate` int(11) NOT NULL,
  `notes` longtext COLLATE utf8_unicode_ci NOT NULL,
  `adminNotes` longtext COLLATE utf8_unicode_ci NOT NULL,
  `orderNumber` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `recent` tinyint(1) NOT NULL,
  `xcPendingExport` tinyint(1) NOT NULL,
  `total` decimal(14,4) NOT NULL,
  `subtotal` decimal(14,4) NOT NULL,
  `is_order` int(11) NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `IDX_9A9BE335791AE370` (`not_finished_order_id`),
  KEY `IDX_9A9BE335CCFA12B8` (`profile_id`),
  KEY `IDX_9A9BE335DBFEF46C` (`orig_profile_id`),
  KEY `IDX_9A9BE33538248176` (`currency_id`),
  KEY `date` (`date`),
  KEY `total` (`total`),
  KEY `subtotal` (`subtotal`),
  KEY `tracking` (`tracking`),
  KEY `payment_status` (`payment_status_id`),
  KEY `shipping_status` (`shipping_status_id`),
  KEY `shipping_id` (`shipping_id`),
  KEY `lastRenewDate` (`lastRenewDate`),
  KEY `orderNumber` (`orderNumber`),
  KEY `is_order` (`is_order`),
  KEY `xcPendingExport` (`xcPendingExport`),
  CONSTRAINT `FK_9A9BE33528DE2F95` FOREIGN KEY (`payment_status_id`) REFERENCES `xlite_order_payment_statuses` (`id`) ON DELETE SET NULL,
  CONSTRAINT `FK_9A9BE3352D02518A` FOREIGN KEY (`shipping_status_id`) REFERENCES `xlite_order_shipping_statuses` (`id`) ON DELETE SET NULL,
  CONSTRAINT `FK_9A9BE33538248176` FOREIGN KEY (`currency_id`) REFERENCES `xlite_currencies` (`currency_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_9A9BE335791AE370` FOREIGN KEY (`not_finished_order_id`) REFERENCES `xlite_orders` (`order_id`) ON DELETE SET NULL,
  CONSTRAINT `FK_9A9BE335CCFA12B8` FOREIGN KEY (`profile_id`) REFERENCES `xlite_profiles` (`profile_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_9A9BE335DBFEF46C` FOREIGN KEY (`orig_profile_id`) REFERENCES `xlite_profiles` (`profile_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_orders` VALUES (1,NULL,2,1,4,4,840,'',1,'','',0,89,'Courier','','',1394005540,1576568818,'','','1',0,0,18.4900,19.9900,1),(2,NULL,3,1,4,4,840,'',1,'','',0,89,'Courier','','',1396005895,1576568818,'','','2',1,0,88.6700,84.9500,1),(3,NULL,4,1,4,4,840,'',1,'','',0,89,'Courier','','',1407005895,1576568818,'','','3',1,0,158.9400,158.9400,1),(4,NULL,5,1,5,5,840,'',1,'','',0,89,'Courier','Simplify Commerce Hosted Payments','',1452604403,1576568819,'','','4',1,0,38.0100,34.9900,1),(5,NULL,6,1,4,4,840,'',1,'','',0,89,'Courier','','',1452604702,1576568819,'','','5',0,0,352.8100,351.3100,1);
CREATE TABLE `xlite_mailchimp_subscriptions` (
  `list_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `profile_id` int(11) NOT NULL,
  PRIMARY KEY (`list_id`,`profile_id`),
  KEY `IDX_CF18140A3DAE168B` (`list_id`),
  KEY `IDX_CF18140ACCFA12B8` (`profile_id`),
  CONSTRAINT `FK_CF18140A3DAE168B` FOREIGN KEY (`list_id`) REFERENCES `xlite_mailchimp_lists` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_CF18140ACCFA12B8` FOREIGN KEY (`profile_id`) REFERENCES `xlite_profiles` (`profile_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_attributes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_class_id` int(10) unsigned DEFAULT NULL,
  `attribute_group_id` int(10) unsigned DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  `googleShoppingGroup` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `position` int(11) NOT NULL,
  `decimals` int(11) NOT NULL,
  `type` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `addToNew` char(1) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_9665298321B06187` (`product_class_id`),
  KEY `IDX_9665298362D643B7` (`attribute_group_id`),
  KEY `IDX_966529834584665A` (`product_id`),
  CONSTRAINT `FK_9665298321B06187` FOREIGN KEY (`product_class_id`) REFERENCES `xlite_product_classes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_966529834584665A` FOREIGN KEY (`product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_9665298362D643B7` FOREIGN KEY (`attribute_group_id`) REFERENCES `xlite_attribute_groups` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_attributes` VALUES (1,1,NULL,NULL,NULL,1,0,0,'S',''),(50,NULL,NULL,NULL,NULL,1,0,0,'S',''),(71,2,NULL,NULL,NULL,1,0,0,'S',''),(72,2,NULL,NULL,NULL,1,0,0,'S',''),(73,2,NULL,NULL,NULL,1,0,0,'S',''),(74,2,NULL,NULL,NULL,0,0,0,'S',''),(75,2,1,NULL,NULL,1,0,0,'S',''),(76,2,1,NULL,NULL,1,0,0,'S',''),(77,2,1,NULL,NULL,1,0,0,'S',''),(78,2,3,NULL,NULL,0,0,0,'S',''),(79,2,3,NULL,NULL,0,0,0,'S',''),(80,2,3,NULL,NULL,0,0,0,'S',''),(81,2,3,NULL,NULL,0,0,0,'S',''),(82,2,3,NULL,NULL,0,0,0,'S',''),(83,2,2,NULL,NULL,1,0,0,'S',''),(84,2,2,NULL,NULL,1,0,0,'S',''),(85,2,2,NULL,NULL,0,0,0,'S',''),(86,2,2,NULL,NULL,1,0,0,'C',''),(94,3,NULL,NULL,NULL,1,0,0,'S',''),(95,NULL,NULL,31,NULL,1,0,0,'S',''),(96,NULL,NULL,16,NULL,1,0,0,'S',''),(99,NULL,NULL,15,NULL,1,0,0,'S','');
CREATE TABLE `xlite_custom_global_tabs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `global_tab_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_5C09BCAD629D8673` (`global_tab_id`),
  CONSTRAINT `FK_5C09BCAD629D8673` FOREIGN KEY (`global_tab_id`) REFERENCES `xlite_global_product_tabs` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_custom_global_tabs` VALUES (1,5),(2,6),(3,7);
CREATE TABLE `xlite_segment_membership` (
  `segment_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `membership_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`segment_id`,`membership_id`),
  KEY `IDX_958B38A0DB296AAD` (`segment_id`),
  KEY `IDX_958B38A01FB354CD` (`membership_id`),
  CONSTRAINT `FK_958B38A01FB354CD` FOREIGN KEY (`membership_id`) REFERENCES `xlite_memberships` (`membership_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_958B38A0DB296AAD` FOREIGN KEY (`segment_id`) REFERENCES `xlite_mailchimp_list_segments` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_address_field_value` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `address_field_id` int(11) DEFAULT NULL,
  `address_id` int(11) DEFAULT NULL,
  `value` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_620FAD37BAB8F931` (`address_field_id`),
  KEY `IDX_620FAD37F5B7AF75` (`address_id`),
  CONSTRAINT `FK_620FAD37BAB8F931` FOREIGN KEY (`address_field_id`) REFERENCES `xlite_address_field` (`id`) ON DELETE SET NULL,
  CONSTRAINT `FK_620FAD37F5B7AF75` FOREIGN KEY (`address_id`) REFERENCES `xlite_profile_addresses` (`address_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_address_field_value` VALUES (1,1,1,'Mr.'),(2,7,1,'595'),(3,8,1,'Oklahoma'),(4,6,1,'US'),(5,2,1,'Guest'),(6,3,1,'Guest'),(7,10,1,'0123456789'),(8,4,1,'51 apt, 87 street'),(9,5,1,'Edmond'),(10,7,1,'595'),(11,6,1,'US'),(12,9,1,'73003'),(13,1,2,'Mr.'),(14,7,2,'595'),(15,8,2,'Oklahoma'),(16,6,2,'US'),(17,2,2,'Guest'),(18,3,2,'Guest'),(19,10,2,'0123456789'),(20,4,2,'51 apt, 87 street'),(21,5,2,'Edmond'),(22,7,2,'595'),(23,6,2,'US'),(24,9,2,'73003'),(25,1,3,'Mr.'),(26,7,3,'595'),(27,8,3,'Oklahoma'),(28,6,3,'US'),(29,2,3,'Guest'),(30,3,3,'Guest'),(31,10,3,'0123456789'),(32,4,3,'51 apt, 87 street'),(33,5,3,'Edmond'),(34,7,3,'595'),(35,6,3,'US'),(36,9,3,'73003'),(37,1,4,'Mr.'),(38,7,4,'595'),(39,8,4,'Oklahoma'),(40,6,4,'US'),(41,2,4,'Guest'),(42,3,4,'Guest'),(43,10,4,'0123456789'),(44,4,4,'51 apt, 87 street'),(45,5,4,'Edmond'),(46,7,4,'595'),(47,6,4,'US'),(48,9,4,'73003'),(49,1,5,'Mr.'),(50,7,5,'595'),(51,8,5,'Oklahoma'),(52,6,5,'US'),(53,2,5,'Guest'),(54,3,5,'Guest'),(55,10,5,'0123456789'),(56,4,5,'51 apt, 87 street'),(57,5,5,'Edmond'),(58,7,5,'595'),(59,6,5,'US'),(60,9,5,'73003'),(61,1,6,'Mr.'),(62,7,6,'595'),(63,8,6,'Oklahoma'),(64,6,6,'US'),(65,2,6,'Guest'),(66,3,6,'Guest'),(67,10,6,'0123456789'),(68,4,6,'51 apt, 87 street'),(69,5,6,'Edmond'),(70,7,6,'595'),(71,6,6,'US'),(72,9,6,'73003');
CREATE TABLE `xlite_address_field_translation` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `IDX_430F4FF2BF396750` (`id`),
  CONSTRAINT `FK_430F4FF2BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_address_field` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_address_field_translation` VALUES (1,1,'Title','en'),(2,2,'First name','en'),(3,3,'Last name','en'),(4,4,'Address','en'),(5,5,'City','en'),(6,6,'Country','en'),(7,7,'State','en'),(8,8,'State','en'),(9,9,'Zip code','en'),(10,10,'Phone','en'),(11,11,'Address type','en');
CREATE TABLE `xlite_order_coupons` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  `coupon_id` int(10) unsigned DEFAULT NULL,
  `code` char(16) COLLATE utf8_unicode_ci NOT NULL,
  `value` decimal(14,4) NOT NULL,
  `type` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_451D92198D9F6D38` (`order_id`),
  KEY `IDX_451D921966C5951B` (`coupon_id`),
  CONSTRAINT `FK_451D921966C5951B` FOREIGN KEY (`coupon_id`) REFERENCES `xlite_coupons` (`id`) ON DELETE SET NULL,
  CONSTRAINT `FK_451D92198D9F6D38` FOREIGN KEY (`order_id`) REFERENCES `xlite_orders` (`order_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_attribute_values_select_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_CDF9A7AFBF396750` FOREIGN KEY (`id`) REFERENCES `xlite_attribute_values_select` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_category_banners` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned DEFAULT NULL,
  `alt` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `width` int(11) NOT NULL,
  `height` int(11) NOT NULL,
  `hash` char(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `needProcess` tinyint(1) NOT NULL,
  `path` varchar(512) COLLATE utf8_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_69B8F0D412469DE2` (`category_id`),
  CONSTRAINT `FK_69B8F0D412469DE2` FOREIGN KEY (`category_id`) REFERENCES `xlite_categories` (`category_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_category_banners` VALUES (1,2,'',2996,520,NULL,1,'fashion_6.jpeg','','image/jpeg','r',331715,1560863809),(2,6,'',2996,520,NULL,1,'beauty_banner5.jpg','','image/jpeg','r',340745,1559911154),(3,9,'',2996,520,NULL,1,'9_electronic.jpeg','','image/jpeg','r',334750,1560943954);
CREATE TABLE `xlite_session_cells` (
  `cell_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`cell_id`),
  UNIQUE KEY `iname` (`id`,`name`),
  KEY `id` (`id`),
  CONSTRAINT `FK_C8BF5944BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
COMMIT;