/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Clean URL
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

jQuery().ready(
  function() {
    var showResult = function (url) {
      var result = jQuery('.clean-url-result');
      var template = result.data('url-template');
      var savedValue = preprocessValue(result.data('saved-value'));

      if (url === savedValue) {
        jQuery('.saved-url', result).show();
        jQuery('.url', result).hide();
      } else {
        jQuery('.saved-url', result).hide();
        jQuery('.url', result).show().html(template.replace('#PLACEHOLDER#', '<span class="editable">' + url + '</span>'));
      }
    };

    var toggleAutogenerate = function () {
      jQuery('#autogenerateFlag').prop('checked', '' === jQuery('#cleanurl').val());
    };

    var toggleInputField = function () {
      jQuery('#cleanurl').prop('disabled', jQuery('#autogenerateFlag').is(':checked'));
    };

    var toggleResultMessage = function () {
      var checked = jQuery('#autogenerateFlag').is(':checked');

      jQuery('.clean-url-result').toggle(!checked);
      jQuery('.clean-url-result-autogenerated').toggle(checked);
    };

    var preprocessValue = function(url) {
      return removeExtension(url);
    };

    var removeExtension = function (url) {
      var extension = jQuery('#cleanurl + .input-group-addon').data('extension');

      return String(url).replace(new RegExp('\.' + extension + '$'), '');
    };

    var input = jQuery('#cleanurl');

    input.keyup(
      function () {
        showResult(preprocessValue(jQuery(this).val()));
        toggleAutogenerate();
      }
    );

    jQuery('#autogenerateFlag').change(
      function () {
        toggleInputField();
        toggleResultMessage();
      }
    );

    input.val(preprocessValue(input.val()));

    input.blur(function(event){
        input.val(preprocessValue(input.val()));
      })
      .keydown(function(event){
        if (event.which === 13) {
          input.val(preprocessValue(input.val()));
        };
      });

    toggleAutogenerate();
    toggleInputField();
    toggleResultMessage();

    showResult(preprocessValue(input.val()));

    jQuery('.additional-option .force.mark').removeClass('mark');
  }
);
