<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\Module\XC\ThemeTweaker\View\LayoutSettings;

/**
 * Layout settings
 */
 class Settings extends \XLite\View\LayoutSettings\SettingsAbstract implements \XLite\Base\IDecorator
{
    /**
     * Get a list of CSS files required to display the widget properly
     *
     * @return array
     */
    public function getCSSFiles()
    {
        $list = parent::getCSSFiles();
        $list[] = 'modules/XC/ThemeTweaker/layout_settings/style.less';

        return $list;
    }

    /**
     * Get a list of JS files required to display the widget properly
     *
     * @return array
     */
    public function getJSFiles()
    {
        $list = parent::getJSFiles();
        $list[] = 'modules/XC/ThemeTweaker/theme_tweaker_templates/controller.js';
        $list[] = 'modules/XC/ThemeTweaker/layout_settings/layout_mode_btn_controller.js';
        $list[] = 'modules/XC/ThemeTweaker/layout_settings/labels_editor_btn_controller.js';

        return $list;
    }
}
